<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO 
    -- Retorna as senhas de carta frete de um usurio de liberao
    -- ANDERSON 23/06/2010 - CRIADO
    --->		
    <cffunction name="get_alcada_liberacao_senha" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicial" required="no" default="">
        <cfargument name="data_termino" required="no" default="">
        <cfargument name="senha_liberacao" required="no" default="">
        <cfargument name="lancto_id" required="no" default="">
        <cfargument name="num_formulario" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.senha_id
                 , t.usuario_liberacao
                 , t.senha_liberacao
                 , t.quantidade_tentativas
                 , t.quantidade_gerada
                 , t.usuario_utilizacao
                 , to_char(t.data_utilizacao, 'dd/mm/yyyy hh24:mi:ss') as data_utilizacao
                 , t.lancto_id
                 , t.num_formulario
                 , t.usuario_cancelamento
                 , to_char(t.data_cancelamento, 'dd/mm/yyyy hh24:mi:ss') as data_cancelamento
                 , t.user_insert
                 , to_char(t.date_insert, 'dd/mm/yyyy hh24:mi:ss') as date_insert
                 , case
                      when t.status = 1 then 'Utilizada'
                      when t.status = 2 then 'Em aberto'
                      else 'Cancelada'
                   end as status
				<cfif Len(Trim(arguments.data_inicial)) and Len(Trim(arguments.data_termino))>
                 , case
                      when t.date_insert between to_date('#arguments.data_inicial#', 'dd/mm/yyyy') and to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss') then '000'
                      else 'F00'
                   end as cor_fonte
                <cfelse>
                 , '000' as cor_fonte
                </cfif>
              from (
                    select als.senha_id
                         , als.usuario_liberacao
                         , als.senha_liberacao
                         , als.quantidade_tentativas
                         , als.quantidade_gerada
                         , als.usuario_utilizacao
                         , als.data_utilizacao
                         , als.lancto_id
                         , ct.num_formulario
                         , als.usuario_cancelamento
                         , als.data_cancelamento
                         , als.user_insert
                         , als.date_insert
                         , case
                              when als.data_utilizacao is not null then 1
                              when als.data_cancelamento is not null then 3
                              else 2
                           end as status
                      from oper.v$alcada_liberacao_senha als
                      left join oper.v$contrato_transp ct
                            on ct.lancto_id = als.lancto_id
                     where als.usuario_liberacao = user
					<cfif Len(Trim(arguments.data_inicial)) and Len(Trim(arguments.data_termino))>
                       and (als.date_insert between to_date('#arguments.data_inicial#', 'dd/mm/yyyy') and to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss') or (als.data_utilizacao is null and als.data_cancelamento is null))
                    </cfif>
                    <cfif Len(Trim(arguments.senha_liberacao))>
                       and als.senha_liberacao = '#arguments.senha_liberacao#'
                    </cfif>
                    <cfif Len(Trim(arguments.lancto_id))>
                       and als.lancto_id = #arguments.lancto_id#
                    </cfif>
                    <cfif Len(Trim(arguments.num_formulario))>
                       and ct.num_formulario = #arguments.num_formulario#
                    </cfif>
                    <cfif not Len(Trim(arguments.data_inicial)) and not Len(Trim(arguments.data_termino)) and not Len(Trim(arguments.senha_liberacao)) and not Len(Trim(arguments.lancto_id)) and not Len(Trim(arguments.num_formulario))>
                       and als.data_utilizacao is null
                       and als.data_cancelamento is null
                    </cfif>
                   ) t
             order by t.status, t.data_utilizacao desc, t.data_cancelamento desc, t.date_insert, t.senha_liberacao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
</cfcomponent>