<!-- KM&M Componentes -->
<cfcomponent displayname="Consultas da área de mensagens do Totem" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPÓSITO 
	-- Busca mensagem do totem
	-- NOTAS EXPLICATIVAS
	-- ERIC 29/12/2010
	--->
	<cffunction name="get_mensagem" displayname="Busca mensagem do totem" access="remote" returntype="query" output="true">
		<cfargument name="totem_mensagem_id" required="no" default="">
        <cfargument name="assunto" 			 required="no" default="">
        <cfargument name="data_envio_inicio" required="no" default="">
        <cfargument name="data_envio_fim" 	 required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select tm.totem_mensagem_id
                 , tm.mensagem_grupo_id
                 , tm.grupo_id
                 , (select vgs.descricao
                      from oper.v$veiculo_grupo_setup vgs
                     where vgs.grupo_id = tm.grupo_id
                   ) as grupo
                 , tm.cod_registro
                 , (select kss.pkg_pessoa.fnc_get_cliente(mrh.cod_pessoa)
                      from oper.v$motorista_reg_historico mrh
                     where mrh.cod_registro = tm.cod_registro
                   ) as motorista
                 , tm.assunto
                 , tm.mensagem
                 , to_char(tm.primeira_leitura, 'dd/mm/yyyy HH24:mi:ss') as primeira_leitura
                 , to_char(tm.ultima_leitura, 'dd/mm/yyyy HH24:mi:ss') as ultima_leitura
                 , tm.quantidade_leitura
                 , to_char(tm.cancelada, 'dd/mm/yyyy HH24:mi:ss') as cancelada
                 , nvl((select u.nome
                          from kss.kss_usuarios u
                         where u.usuario = tm.user_insert), tm.user_insert
                   ) as remetente
                 , case
                      when tm.mensagem_grupo_id is null then
                         decode(tm.cancelada, null, 1, 0)
                      else
                         (select sign(count(1))
                            from oper.v$totem_mensagem tm2
                           where tm2.quantidade_leitura = 0
                             and tm2.cancelada is null
                             and tm2.mensagem_grupo_id = tm.mensagem_grupo_id)
                   end as pode_cancelar
                 , tm.user_insert
                 , to_char(tm.date_insert, 'dd/mm/yyyy HH24:mi:ss') as date_insert
                 , tm.user_update
                 , to_char( tm.date_update, 'dd/mm/yyyy HH24:mi:ss') as date_update
                 , tm.site
              from oper.v$totem_mensagem tm
     		 where 1=1
			<cfif len(trim(arguments.totem_mensagem_id))>
				and tm.totem_mensagem_id = #arguments.totem_mensagem_id#
			</cfif>
            <cfif len(trim(arguments.assunto))>
				and upper(tm.assunto) like upper('%#arguments.assunto#%')
			</cfif>
            <cfif len(trim(arguments.data_envio_inicio))>
				and tm.date_insert >= '#arguments.data_envio_inicio#'
			</cfif>
            <cfif len(trim(arguments.data_envio_fim))>
				and trunc(tm.date_insert) <= '#arguments.data_envio_fim#'
			</cfif>
			order by tm.date_insert desc
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
	<!--- 
	-- PROPÓSITO 
	-- Busca grupos de veículos ativos
	-- ERIC 29/12/2010
	--->
	<cffunction name="get_grupo_veiculo" displayname="Busca grupos de veículos ativos" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select vgs.grupo_id
                 , vgs.descricao
              from oper.v$veiculo_grupo_setup vgs
             where vgs.situacao_id = 1
             order by vgs.descricao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
	<!--- 
	-- PROPÓSITO 
	-- Busca motorista
	-- ERIC 29/12/2010
	--->
	<cffunction name="get_motorista" displayname="Busca motorista" access="remote" returntype="query" output="true">
    	<cfargument name="cod_registro" required="no" default="">
        <cfargument name="cnpj_cpf" 	required="no" default="">
        <cfargument name="cliente" 		required="no" default="">        
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select mrh.cod_pessoa
                 , mrh.cod_registro
                 , p.cnpj_cpf
                 , p.identificador
                 , p.cliente
              from oper.v$motorista_reg_historico mrh
             inner join kss.v$pessoa p
                     on p.cod_pessoa = mrh.cod_pessoa
             where mrh.data_fim is null
			<cfif len(trim(arguments.cod_registro))>
				and mrh.cod_registro = '#arguments.cod_registro#'
			</cfif>
            <cfif len(trim(arguments.cnpj_cpf))>
				and p.cnpj_cpf like '#arguments.cnpj_cpf#%'
			</cfif> 
            <cfif len(trim(arguments.cliente))>
				and upper(p.cliente) like upper('#arguments.cliente#%')
			</cfif>          
             order by p.cliente
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>     
</cfcomponent>