<cfcomponent extends="_transportes.funcoes.cfc_init">
<!--- 
	-- PROPSITO 
	-- Busca ocorrncias de sinistro
	-- 
	-- WAGNERLV 24/12/2007
	--->
	<cffunction name="get_ocorrencia_sinistro" returntype="query" access="remote">
		<cfargument name="NUM_SINISTRO" required="no" default="" >
        <cfargument name="NUM_PROCESSO" required="no" default="" >
        <cfargument name="CNPJCPF" required="no" default="" >
        <cfargument name="PERIODO_I" required="no" default="" >
        <cfargument name="PERIODO_F" required="no" default="" >
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        
select t.sinistro_id,
       t.num_processo,
       t.data_hora ,
       un.cod_unidade_negocio,
       un.unidade_negocio,
   t.cod_modalidade,
       (select x.sigla from oper.v$seg_modalidade x where x.modalidade_id = t.cod_modalidade) as modalidade,
       t.evento_id,
       e.descricao as evento,
       t.arquivamento_id,
       a.descricao as arquivamento,
       decode(t.houve_vitima,1,'Sim','No') as houve_vitima,
       decode(t.houve_vazamento,1,'Sim','No') as houve_vazamento,
       decode(t.houve_impacto_amb,1,'Sim','No') as houve_impacto_amb,
       t.num_romaneio,
       mo.municipio as municipio_origem,
       mo.uf_id as uf_origem,
       md.municipio as municipio_destino,
       md.uf_id as uf_destino,
       ml.municipio as municipio_local,
       ml.uf_id as uf_local,
       t.descricao_local,
       t.num_natureza,
       n.descricao as natureza,
       t.valor_carga,
       t.informante,
       pc.identificador as cnpj_cpf_cliente,
       pc.razao_social as razao_social_cliente,
       pcc.identificador as cnpj_cpf_corretora,
       pcc.razao_social as razao_social_corretora,
       ps.identificador as cnpj_cpf_seguradora,
       ps.razao_social as razao_social_seguradora,
       pm.identificador as cnpj_cpf_motorista,
       pm.razao_social as razao_social_motorista,
       t.num_liberacao_motorista,
       t.modalidade_motorista,
       t.valor_avaria,
       t.valor_franquia,
       t.valor_custo_atendimento,
       t.valor_prejuizo,
       t.ind_data_recebimento,
       t.ind_data_pagamento,
       t.ind_data_previsao,
       t.ind_valor_recebimento,
       t.ind_valor_pagamento,
       decode(t.terc_tipo,1,'Terceiro',2,'Passageiro','') as terc_tipo,
       t.terc_nome,
       t.terc_identificacao,
       t.terc_orgao_emissor,
       t.terc_logradouro,
       t.terc_bairro,
       t.terc_cidade,
       t.terc_cep,
       t.terc_telefone,
       t.terc_ramal,
       t.terc_veiculo,
       t.terc_placa,
       t.terc_uf,
       t.terc_cor,
       decode(t.terc_possui_seguro,1,'Sim','No') as terc_possui_seguro,
       t.terc_seguro,
       t.terc_observacao,
       case t.situacao
          when 0 then 'Em Aberto'
          when 1 then 'Encerrado'
          when 2 then 'Pendente de Avaliao'
          when 3 then 'Pendente de Terceiros'
       end as situacao,
       t.user_insert, t.date_insert, t.user_update, t.date_update
  from oper.v$seg_sinistro t
 inner join kss.v$unidade_negocio un
         on un.cod_pessoa = t.cod_pessoa_filial
 inner join oper.v$seg_sinistro_evento e
         on t.evento_id = e.evento_id
  left join oper.v$seg_sinistro_arq_processo a
         on a.arquivamento_id = t.arquivamento_id
  left join cep.municipio mo
         on mo.municipio_id = t.municipio_id_origem
  left join cep.municipio md
         on md.municipio_id = t.municipio_id_destino
  left join cep.municipio ml
         on ml.municipio_id = t.municipio_id_local
  left join oper.v$natureza n
         on n.num_natureza = t.num_natureza
 inner join kss.v$pessoa pc
         on pc.cod_pessoa = t.cod_pessoa_cliente
 inner join kss.v$pessoa pcc
         on pcc.cod_pessoa = t.cod_pessoa_corretora
 inner join kss.v$pessoa ps
         on ps.cod_pessoa = t.cod_pessoa_seguradora
 inner join kss.v$pessoa pm
         on pm.cod_pessoa = t.cod_pessoa_motorista         
 where 	
 1=1
 <cfif len(trim(arguments.NUM_PROCESSO)) >
  and (t.num_processo = '#arguments.NUM_PROCESSO#')
 </cfif>
 <cfif len(trim(arguments.NUM_SINISTRO)) >
  and (t.sinistro_id = '#arguments.NUM_SINISTRO#')
 </cfif>
 order by t.sinistro_id
        </cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca arquivos relacionados ao sinistro
	-- 
	-- WAGNERLV 24/12/2007
	--->
    <cffunction name="get_arquivos_sinistro" returntype="query" access="remote">
		<cfargument name="num_sinistro" required="yes" default="" >
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                
        select sinistro_id,
               arquivo_id,
               nome_arquivo,
               descricao,
               arquivo,
               user_insert,
               date_insert,
               user_update,
               date_update
        from oper.v$seg_sinistro_arquivo 
        where sinistro_id = #arguments.num_sinistro# 
               
          </cfquery>
		<cfreturn qr_result>
	</cffunction>
    
     <!--- 
	-- PROPSITO 
	-- Busca arquivo relacionado ao sinistro
	-- 
	-- WAGNERLV 24/12/2007
	--->
    <cffunction name="get_arquivo_sinistro" returntype="query" access="remote">
		<cfargument name="ARQUIVO_ID" required="yes" default="" >
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">       
        select nome_arquivo,
               arquivo
               from oper.v$seg_sinistro_arquivo 
        where arquivo_id = #arguments.ARQUIVO_ID#                
          </cfquery>
		<cfreturn qr_result>
	</cffunction>
     <!--- 
	-- PROPSITO 
	-- Busca arquivo relacionado ao sinistro
	-- 
	-- KATHLYNTS 24/12/2007
	--->
    <cffunction name="get_historico_sinistro" returntype="query" access="remote">
		<cfargument name="num_processo" required="yes" default="" >
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">       
   select 
       historico_id,
       historico,
       date_update,
       user_update,
       date_insert,
       user_insert       
  from oper.v$seg_sinistro_hist
 where historico_id = historico_id
   and sinistro_id in( select sinistro_id
          from  oper.v$seg_sinistro
         where oper.v$seg_sinistro_hist.sinistro_id = oper.v$seg_sinistro.sinistro_id
              and oper.v$seg_sinistro.num_processo = '#arguments.num_processo#')
       </cfquery>
		<cfreturn qr_result>
</cffunction>
         <!--- 
	-- PROPSITO 
	-- Busca arquivo relacionado ao sinistro
	-- 
	-- KATHLYNTS 24/12/2007
	--->
    <cffunction name="get_veiculo" returntype="query" access="remote">
		<cfargument name="num_processo" required="yes" default="" >
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">       
  	select placa, modalidade
  from oper.v$seg_sinistro_veiculo
 where sinistro_id in
       (select sinistro_id
          from oper.v$seg_sinistro
         where oper.v$seg_sinistro_veiculo.sinistro_id =
               oper.v$seg_sinistro.sinistro_id
           and oper.v$seg_sinistro.num_processo = '#arguments.num_processo#')
       </cfquery>
		<cfreturn qr_result>
	</cffunction>
    
       
</cfcomponent>