<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!---
    -- PROPSITO
    -- Retorna Tipos de Treinamento
    -- LEOPOLDOS 08/06/2010 - CRIADO
    --->
    <cffunction name="get_treinamento_tipo" access="remote" returntype="query" output="true">
    	<cfargument name="DESCRICAO" required="no" default="">
    	<cfargument name="CARGA_HORARIA" required="no" default="">
    	<cfargument name="PERIODICIDADE" required="no" default="">
		<cfargument name="TREINAMENTO_TIPO_ID" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select tt.treinamento_tipo_id
                 , tt.descricao
                 , case
                      when length(tt.carga_horaria) >= 2 then to_char(tt.carga_horaria)
                      else lpad(tt.carga_horaria, 2, 0)
                   end || ':' || lpad(nvl(tt.carga_horaria_minutos,00), 2, 0)|| ':00'  as carga_horaria_extenso
                 , case
                      when length(tt.carga_horaria) >= 2 then to_char(tt.carga_horaria)
                      else lpad(tt.carga_horaria, 2, 0)
                   end || ':' || lpad(nvl(tt.carga_horaria_minutos,00), 2, 0)  as carga_horaria_resum
                 , tt.treinamento_obrigatorio
                 , decode(tt.situacao, '1','Ativo','0','Inativo') as situacao_texto
                 , tt.situacao
                 , tt.carga_horaria
                 , tt.carga_horaria_minutos
                 , tt.periodicidade
                 , tt.pauta
                 , tt.user_insert
                 , tt.date_insert
                 , tt.user_update
                 , tt.date_update
              from oper.v$mot_treinamento_tipo tt
             where 1=1
	        <cfif Len(Trim(arguments.DESCRICAO))>
               and tt.descricao like  '%#arguments.DESCRICAO#%'
            </cfif>
            <cfif Len(Trim(arguments.CARGA_HORARIA))>
               and tt.carga_horaria =  #arguments.CARGA_HORARIA#
            </cfif>
			<cfif Len(Trim(arguments.PERIODICIDADE))>
               and tt.periodicidade = #arguments.PERIODICIDADE#
            </cfif>
			<cfif Len(Trim(arguments.TREINAMENTO_TIPO_ID))>
               and tt.treinamento_tipo_id = #arguments.TREINAMENTO_TIPO_ID#
            </cfif>
             order by tt.descricao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

	<!---
    -- PROPSITO
    -- Retorna Instrutores
    -- LEOPOLDOS 08/06/2010 - CRIADO
    --->
    <cffunction name="get_instrutor" access="remote" returntype="query" output="true">
	    <cfargument name="cod_pessoa_instrutor" required="no" default="">
        <cfargument name="nome" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select mti.cod_pessoa_instrutor
                 , p.cnpj_cpf as cpf_instrutor
                 , p.cliente as nome
                 , p.identificador
				 , mti.cargo
				 , mti.registro
              from oper.v$mot_treinamento_instrutor mti
             inner join kss.v$pessoa p
                on p.cod_pessoa = mti.cod_pessoa_instrutor
             where 1 = 1
			<cfif Len(Trim(arguments.cod_pessoa_instrutor))>
               and mti.cod_pessoa_instrutor = #arguments.cod_pessoa_instrutor#
			</cfif>
            <cfif Len(Trim(arguments.nome))>
               and upper(p.cliente) like upper('#arguments.nome#%')
			</cfif>
             order by p.cliente
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Retorna Instrutores
    -- VICTOR 12/06/2015 - CRIADO
    --->
    <cffunction name="get_pauta" access="remote" returntype="query" output="true">
	    <cfargument name="treinamento_tipo_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.pauta
  		      from oper.v$mot_treinamento_tipo t
             where 1 = 1
			<cfif Len(Trim(arguments.treinamento_tipo_id))>
               and t.treinamento_tipo_id = #arguments.treinamento_tipo_id#
			</cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>


    <!---
    -- PROPSITO
    -- Retorna Instrutores para determinado treinamento
    -- LEOPOLDOS 09/06/2010 - CRIADO
    --->
    <cffunction name="get_instrutor_treinamento" access="remote" returntype="query" output="true">
    	<cfargument name="TREINAMENTO_TIPO_ID" required="no" default="">
    	<cfargument name="COD_PESSOA_INSTRUTOR" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select  i.cod_pessoa_instrutor
                 , i.treinamento_tipo_id
                 , (select mtt.descricao
                      from oper.v$mot_treinamento_tipo mtt
                     where mtt.treinamento_tipo_id = i.treinamento_tipo_id) as treinamento
                 , (select mtt.carga_horaria
                      from oper.v$mot_treinamento_tipo mtt
                     where mtt.treinamento_tipo_id = i.treinamento_tipo_id) as carga_horaria
                 , (select p.razao_social
                      from kss.v$pessoa p
                     where p.cod_pessoa = i.cod_pessoa_instrutor ) as nome
            from oper.v$mot_treinamento_instr_tipo  i
            where 1=1
            <cfif Len(Trim(arguments.TREINAMENTO_TIPO_ID))>
              and i.treinamento_tipo_id = #arguments.TREINAMENTO_TIPO_ID#
            </cfif>
            <cfif Len(Trim(arguments.COD_PESSOA_INSTRUTOR))>
              and i.cod_pessoa_instrutor = #arguments.COD_PESSOA_INSTRUTOR#
            </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    <!---
    -- PROPSITO
    -- Retorna Treinamentos
    -- LEOPOLDOS 09/06/2010 - CRIADO
    --->
    <cffunction name="get_treinamentos" access="remote" returntype="query" output="true">
    	<cfargument name="TREINAMENTO_TIPO_ID" required="no" default="">
        <cfargument name="TREINAMENTO_ID" required="no" default="">
    	<cfargument name="COD_PESSOA_INSTRUTOR" required="no" default="">
    	<cfargument name="DATA_INICIO" required="no" default="">
    	<cfargument name="DATA_TERMINO" required="no" default="">
        <cfargument name="COD_PESSOA_PARTICIPANTE" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select t.treinamento_id
                 , t.treinamento_tipo_id
                 , (select tit.descricao
                      from oper.v$mot_treinamento_tipo tit
                     where tit.treinamento_tipo_id = t.treinamento_tipo_id) as treinamento
                 , (select nvl(tit.carga_horaria,0)
                      from oper.v$mot_treinamento_tipo tit
                     where tit.treinamento_tipo_id = t.treinamento_tipo_id) as carga_horaria
                 ,  manutencao.to_tempo_execucao(numtodsinterval(t.data_termino -
                                                    t.data_inicio,
                                                    'day'),
                                    2) .retorno as tempo_treinamento
				 , t.cod_pessoa_instrutor
				 , t.cod_pessoa_instrutor_2
				 , t.cod_pessoa_resp_tecnico
                 , (select pi.razao_social
                      from kss.v$pessoa pi
                     where pi.cod_pessoa = t.cod_pessoa_instrutor) as instrutor
				 , (select pi.razao_social
                      from kss.v$pessoa pi
                     where pi.cod_pessoa = t.cod_pessoa_instrutor_2) as instrutor_2
				 , (select pi.razao_social
                      from kss.v$pessoa pi
                     where pi.cod_pessoa = t.cod_pessoa_resp_tecnico) as resp_tecnico
                 , t.item_norma
				 , t.local
                 , to_char(t.data_inicio, 'dd/mm/yyyy hh24:mi') as data_inicio
                 , to_char(t.data_termino, 'dd/mm/yyyy hh24:mi') as data_termino
                 , t.observacao
                 , t.cod_unidade_negocio
                 , un.unidade_negocio
                 , t.cod_departamento
                 , dep.descricao as departamento
                 , t.cod_setor
                 , s.descricao as setor
                 , t.cod_centro_custo
                 , cc.centro_custo
                 , replace(t.pauta, chr(13) || chr(10), '<br />') as pauta
				 , t.carga_horaria as carga_horaria_treinamento
              from oper.v$mot_treinamento t
             inner join kss.v$unidade_negocio un
                on un.cod_unidade_negocio = t.cod_unidade_negocio
             inner join kss.v$departamento dep
                on dep.cod_departamento = t.cod_departamento
             inner join kss.v$setor s
                on s.cod_setor = t.cod_setor
             inner join kss.v$centro_custo cc
                on cc.cod_centro_custo = t.cod_centro_custo
             where 1=1
			<cfif Len(Trim(arguments.TREINAMENTO_TIPO_ID))>
               and t.treinamento_tipo_id = #arguments.TREINAMENTO_TIPO_ID#
            </cfif>
            <cfif Len(Trim(arguments.TREINAMENTO_ID))>
               and t.treinamento_id = #arguments.TREINAMENTO_ID#
            </cfif>
			<cfif Len(Trim(arguments.COD_PESSOA_INSTRUTOR))>
               and t.cod_pessoa_instrutor = #arguments.COD_PESSOA_INSTRUTOR#
            </cfif>
            <cfif Len(Trim(arguments.COD_PESSOA_PARTICIPANTE))>
               and exists(select 1
                            from oper.v$mot_trein_participante mtp
                           where mtp.cod_pessoa = #arguments.COD_PESSOA_PARTICIPANTE#
                             and mtp.treinamento_id = t.treinamento_id)
            </cfif>
			<cfif Len(Trim(arguments.DATA_INICIO))>
               and trunc(t.data_inicio) >= '#arguments.DATA_INICIO#'
            </cfif>
			<cfif Len(Trim(arguments.DATA_TERMINO))>
               and trunc(t.data_termino) <= '#arguments.DATA_TERMINO#'
            </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    <!---
    -- PROPSITO
    -- Retorna Lista de Treinamento
    -- LEOPOLDOS 09/06/2010 - CRIADO
    --->
    <cffunction name="get_lista_treinamento" access="remote" returntype="query" output="true">
    	<cfargument name="COD_PESSOA_PARTICIPANTE" required="no" default="">
    	<cfargument name="CPF_PARTICIPANTE" required="no" default="">
    	<cfargument name="COD_PESSOA_INSTRUTOR" required="no" default="">
    	<cfargument name="DATA_INICIO_1" required="no" default="">
    	<cfargument name="DATA_INICIO_2" required="no" default="">
    	<cfargument name="DATA_TERMINO_1" required="no" default="">
    	<cfargument name="DATA_TERMINO_2" required="no" default="">
    	<cfargument name="LOCAL" required="no" default="">
    	<cfargument name="COD_TIPO_TREINAMENTO" required="no" default="">

        <cfargument name="COD_UNIDADE_NEGOCIO" required="no" default="">
        <cfargument name="COD_DEPARTAMENTO" required="no" default="">
        <cfargument name="COD_SETOR" required="no" default="">
        <cfargument name="COD_CENTRO_CUSTO" required="no" default="">
    	<cfargument name="TREINAMENTO_ID" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
               select mt.treinamento_id as cod_treinamento
               				 , mtp.mot_trein_participante_id
                             , mtp.cod_pessoa as cod_participante
                             , pf.identificador as cpf_participante
                             , pf.razao_social as participante
                             , p.identificador as cnpj_cpf_instrutor
                             , mt.cod_pessoa_instrutor as cod_instrutor
							 , mt.carga_horaria as tempo_treinamento
                             , p.razao_social as instrutor
                             , mt.treinamento_tipo_id as cod_tipo_treinamento
                             , mtt.descricao as treinamento
                             , to_char(mt.data_inicio, 'dd/mm/yyyy hh24:mi') as data_inicio
                             , to_char(mt.data_termino, 'dd/mm/yyyy hh24:mi') as data_termino
                             , case
                                  when length(mtt.carga_horaria) >= 2 then to_char(mtt.carga_horaria)
                                  else lpad(mtt.carga_horaria, 2, 0)
                               end || ':' || lpad(nvl(mtt.carga_horaria_minutos,00), 2, 0)|| ':00'  as carga_horaria_extenso
                             , case
                                  when length(mtt.carga_horaria) >= 2 then to_char(mtt.carga_horaria)
                                  else lpad(mtt.carga_horaria, 2, 0)
				                   end || ':' || lpad(nvl(mtt.carga_horaria_minutos,00), 2, 0)  as carga_horaria_resum
                             , mtt.carga_horaria
                             , to_char(mt.data_termino + mtt.periodicidade, 'dd/mm/yyyy') as data_validade
                             , mt.observacao
                             , mt.pauta
                             , mt.local
                             , (select distinct d.cod_funcionario
                                  from oper.v$funcionario_dados d
                                 where d.cod_pessoa = pf.cod_pessoa
                               ) as matricula
                             , mt.avaliacao
                             , (case tpa.avaliacao_participante
                                   when 1 then 'Eficaz'
                                   when 0 then 'Ineficaz'
                                   else 'Nao Avaliado'
                                 END
                                ) as avaliacao_participante_desc
                             , tpa.avaliacao_participante
                             , tpa.motivo_ineficacia
                             , tpa.plano_acao
                             , tpa.resultado_obtido
                             , (case
                                 when sysdate >= mt.data_termino + 90 and mt.avaliacao is null then
                                  1
                                 else
                                  0
                               end) as vencido
                              , (case
                                 when sysdate >= mt.data_termino + 60 and mt.avaliacao is null then
                                  1
                                 else
                                  0
                               end) as alerta_vencimento
                             , un.unidade_negocio
                             , dep.descricao as departamento
                             , s.descricao as setor
                             , cc.centro_custo
                          from oper.v$mot_treinamento mt
                         inner join oper.v$mot_treinamento_tipo mtt
                            on mtt.treinamento_tipo_id = mt.treinamento_tipo_id
                         inner join kss.v$pessoa p
                            on p.cod_pessoa = mt.cod_pessoa_instrutor
                          left join oper.v$mot_trein_participante mtp
                            on mtp.treinamento_id = mt.treinamento_id
                          left join oper.v$mot_trein_part_avaliacao tpa
                            on mtp.mot_trein_participante_id = tpa.mot_trein_participante_id
                          left join kss.v$pessoa pf
                            on pf.cod_pessoa = mtp.cod_pessoa
                         inner join kss.v$unidade_negocio un
                            on un.cod_unidade_negocio = mt.cod_unidade_negocio
                         inner join kss.v$departamento dep
                            on dep.cod_departamento = mt.cod_departamento
                         inner join kss.v$setor s
                            on s.cod_setor = mt.cod_setor
                         inner join kss.v$centro_custo cc
                            on cc.cod_centro_custo = mt.cod_centro_custo
             where 1=1
             <cfif Len(Trim(arguments.COD_PESSOA_PARTICIPANTE))>
               and mtp.cod_pessoa = #arguments.COD_PESSOA_PARTICIPANTE#
             </cfif>
             <cfif Len(Trim(arguments.LOCAL))>
               and upper(mt.local) like upper('%#arguments.LOCAL#%')
             </cfif>
             <cfif Len(Trim(arguments.COD_TIPO_TREINAMENTO))>
               and  mt.treinamento_tipo_id = #arguments.COD_TIPO_TREINAMENTO#
             </cfif>
             <cfif Len(Trim(arguments.TREINAMENTO_ID))>
               and  mt.treinamento_id = #arguments.TREINAMENTO_ID#
             </cfif>
             <cfif Len(Trim(arguments.COD_PESSOA_INSTRUTOR))>
               and  mt.cod_pessoa_instrutor = #arguments.COD_PESSOA_INSTRUTOR#
             </cfif>
             <cfif Len(Trim(arguments.CPF_PARTICIPANTE))>
               and  pf.cnpj_cpf = '#arguments.CPF_PARTICIPANTE#'
             </cfif>

             <cfif Len(Trim(arguments.DATA_INICIO_1))>
               and trunc(mt.data_inicio) >= to_date('#arguments.DATA_INICIO_1#')
             </cfif>
             <cfif Len(Trim(arguments.DATA_INICIO_2))>
   			   and trunc(mt.data_inicio) <= to_date('#arguments.DATA_INICIO_2#')
             </cfif>

             <cfif Len(Trim(arguments.DATA_TERMINO_1))>
               and trunc(mt.data_termino) >= to_date('#arguments.DATA_TERMINO_1#')
             </cfif>
             <cfif Len(Trim(arguments.DATA_TERMINO_2))>
               and trunc(mt.data_termino) <= to_date('#arguments.DATA_TERMINO_2#')
             </cfif>

             <cfif Len(Trim(arguments.COD_UNIDADE_NEGOCIO))>
               and  mt.cod_unidade_negocio = #arguments.COD_UNIDADE_NEGOCIO#
             </cfif>
             <cfif Len(Trim(arguments.COD_DEPARTAMENTO))>
               and  mt.cod_departamento = #arguments.COD_DEPARTAMENTO#
             </cfif>
             <cfif Len(Trim(arguments.COD_SETOR))>
               and  mt.cod_setor = #arguments.COD_SETOR#
             </cfif>
             <cfif Len(Trim(arguments.COD_CENTRO_CUSTO))>
               and  mt.cod_centro_custo = #arguments.COD_CENTRO_CUSTO#
             </cfif>
             order by mt.treinamento_id,  pf.razao_social
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    <!---
    -- PROPSITO
    -- Retorna Treinamentos em determinado dia ou de determinado tipo
    -- LEOPOLDOS 99/99/2010 - CRIADO
    --->
    <cffunction name="get_lista_treinamentos_registro" access="remote" returntype="query" output="true">
    	<cfargument name="TREINAMENTO_TIPO_ID" required="yes">
    	<cfargument name="DATA" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.treinamento_tipo_id
            	 , t.treinamento_id
                 , tt.descricao as treinamento
                 , kss.pkg_pessoa.fnc_get_cliente(t.cod_pessoa_instrutor) as instrutor
                 , to_char(t.data_inicio, 'dd/mm/yyyy') as data_inicio
                 , to_char(t.data_termino, 'dd/mm/yyyy') as data_termino
              from oper.v$mot_treinamento t
             inner join oper.v$mot_treinamento_tipo tt
                on t.treinamento_tipo_id = tt.treinamento_tipo_id
             where 1=1
             <cfif Len(Trim(arguments.TREINAMENTO_TIPO_ID))>
               and t.treinamento_tipo_id = #arguments.TREINAMENTO_TIPO_ID#
             </cfif>
             <cfif Len(Trim(arguments.DATA))>
               and trunc(t.data_inicio)  <= to_date('#arguments.DATA#', 'dd/mm/yyyy')
               and trunc(t.data_termino) >= to_date('#arguments.DATA#', 'dd/mm/yyyy')
             </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    <!---
    -- PROPSITO
    -- Retorna Treinamento
    -- LEOPOLDOS 09/06/2010 - CRIADO
    --->
    <cffunction name="get_treinamento_registro" access="remote" returntype="query" output="true">
    	<cfargument name="TREINAMENTO_TIPO_ID" required="no" default="">
    	<cfargument name="DATA_INICIO" required="no" default="">
    	<cfargument name="DATA_TERMINO" required="no" default="">
        <cfargument name="TREINAMENTO_ID" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select m.treinamento_id
            	 , m.treinamento_tipo_id
                 , kss.pkg_pessoa.fnc_get_cliente(m.cod_pessoa_instrutor) as instrutor
                 , to_char(m.data_inicio, 'dd/mm/yyyy') as data_inicio
                 , to_char(m.data_termino, 'dd/mm/yyyy') as data_termino
                 , t.descricao as treinamento
                 , t.carga_horaria
                 , manutencao.to_tempo_execucao(numtodsinterval(m.data_termino - m.data_inicio,'day'),2).retorno as tempo_treinamento
                 , t.periodicidade
                 , kss.pkg_pessoa.fnc_get_cliente(mp.cod_pessoa) as participante
                 , kss.pkg_pessoa.fnc_get_identificador(mp.cod_pessoa) as participante_cpf
                 , m.cod_unidade_negocio
                 , m.cod_departamento
                 , m.cod_setor
                 , m.cod_centro_custo
                 , rownum as numero
              from oper.v$mot_treinamento m
             inner join oper.v$mot_treinamento_tipo t
                on t.treinamento_tipo_id = m.treinamento_tipo_id
             inner join oper.v$mot_trein_participante mp
             	on mp.treinamento_id = m.treinamento_id
             where 1 = 1
             <cfif Len(Trim(arguments.TREINAMENTO_ID))>
               and m.treinamento_id = #arguments.TREINAMENTO_ID#
             </cfif>
             <cfif Len(Trim(arguments.TREINAMENTO_TIPO_ID))>
               and m.treinamento_tipo_id = #arguments.TREINAMENTO_TIPO_ID#
             </cfif>
             <cfif Len(Trim(arguments.DATA_INICIO))>
               and m.data_inicio = to_date('#arguments.DATA_INICIO#', 'dd/mm/yyyy')
             </cfif>
             <cfif Len(Trim(arguments.DATA_TERMINO))>
               and m.data_termino = to_date('#arguments.DATA_TERMINO#', 'dd/mm/yyyy')
             </cfif>
             order by numero, participante
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Retorna os Participantes de um Treinamento
    -- LEOPOLDOS 09/06/2010 - CRIADO
    --->
    <cffunction name="get_treinamento_participantes" access="remote" returntype="query" output="true">
    	<cfargument name="TREINAMENTO_ID" required="yes">
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select mtp.mot_trein_participante_id
                 , mtp.treinamento_id
                 , mtp.cod_pessoa
                 , kss.pkg_pessoa.fnc_get_cliente(mtp.cod_pessoa) as nome_participante
                 , kss.pkg_pessoa.fnc_get_identificador(mtp.cod_pessoa, 0) as cpf_participante
              from oper.v$mot_trein_participante mtp
             where mtp.treinamento_id = #arguments.TREINAMENTO_ID#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Retorna os Participantes de um Treinamento
    -- JAQUELINEF 18/12/2012 - CRIADO
    --->
    <cffunction name="get_participantes" access="remote" returntype="query" output="true">
    	<cfargument name="CPF" required="no" default="">
    	<cfargument name="NOME" required="no" default="">
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct mtp.cod_pessoa
                 , kss.pkg_pessoa.fnc_get_cliente(mtp.cod_pessoa) as nome_participante
                 , kss.pkg_pessoa.fnc_get_identificador(mtp.cod_pessoa, 0) as cpf_participante
                 , kss.pkg_string.fnc_formata_cnpj_cpf(kss.pkg_pessoa.fnc_get_identificador(mtp.cod_pessoa, 0)) as cpf_participante_f
              from oper.v$mot_trein_participante mtp
             where 1=1
             <cfif Len(Trim(arguments.CPF))>
               and kss.pkg_pessoa.fnc_get_identificador(mtp.cod_pessoa, 0) = #arguments.CPF#
             </cfif>
             <cfif Len(Trim(arguments.NOME))>
               and upper(kss.pkg_pessoa.fnc_get_cliente(mtp.cod_pessoa)) like upper(#arguments.NOME#)
             </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!--- 
    -- PROPSITO 
    -- Retorna Avaliao do Participante no Treinamento
    -- MARIALICE 04/10/2017 - CRIADO
    --->		
    <cffunction name="get_avaliacao_participante" access="remote" returntype="query" output="true">
    	<cfargument name="MOT_TREIN_PARTICIPANTE_ID" required="no" default="">            
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select t.mot_trein_part_avaliacao_id,
					   t.avaliacao_participante,
					   t.motivo_ineficacia,
					   t.plano_acao,
					   t.resultado_obtido,
					   t.mot_trein_participante_id
				  from oper.v$mot_trein_part_avaliacao t
             where 1=1
             <cfif Len(Trim(arguments.MOT_TREIN_PARTICIPANTE_ID))>
               and t.mot_trein_participante_id = #arguments.MOT_TREIN_PARTICIPANTE_ID#
             </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <cffunction name="get_filial" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select un.cod_unidade_negocio
                 , un.unidade_negocio nome
              from kss.v$unidade_negocio un
             where 1 = 1
             order by un.unidade_negocio
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <cffunction name="get_departamento" access="remote" returntype="query" output="true">
	    <cfargument name="cod_unidade_negocio" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select distinct o.cod_departamento
                 , d.descricao
              from kss.v$organograma o
             inner join kss.v$departamento d
                on o.cod_departamento = d.cod_departamento
             where 1=1
             <cfif Len(Trim(arguments.cod_unidade_negocio))>
               and o.cod_unidade_negocio = #arguments.cod_unidade_negocio#
             <cfelse>
               and 1=0
             </cfif>
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <cffunction name="get_setores" access="remote" returntype="query" output="true">
    	<cfargument name="cod_unidade_negocio" required="no" default="">
        <cfargument name="cod_departamento" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select distinct o.cod_setor
                 , s.descricao
              from kss.v$organograma o
             inner join kss.v$setor s
                on o.cod_setor = s.cod_setor
             where 1=1
			<cfif Len(Trim(arguments.cod_unidade_negocio))>
               and o.cod_unidade_negocio = #arguments.cod_unidade_negocio#
            <cfelse>
               and 1=0
            </cfif>
            <cfif Len(Trim(arguments.cod_departamento))>
               and o.cod_departamento = #arguments.cod_departamento#
            <cfelse>
               and 1=0
            </cfif>
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <cffunction name="get_centro_custo" access="remote" returntype="query" output="true">
    	<cfargument name="cod_unidade_negocio" required="no" default="">
        <cfargument name="cod_departamento" required="no" default="">
        <cfargument name="cod_setor" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select distinct o.cod_centro_custo
                 , c.centro_custo
              from kss.v$organograma o
             inner join kss.v$centro_custo c
                on o.cod_centro_custo = c.cod_centro_custo
             where 1=1
			<cfif Len(Trim(arguments.cod_unidade_negocio))>
               and o.cod_unidade_negocio = #arguments.cod_unidade_negocio#
            <cfelse>
               and 1=0
            </cfif>
            <cfif Len(Trim(arguments.cod_departamento))>
               and o.cod_departamento = #arguments.cod_departamento#
            <cfelse>
               and 1=0
            </cfif>
            <cfif Len(Trim(arguments.cod_setor))>
               and o.cod_setor = #arguments.cod_setor#
            <cfelse>
               and 1=0
            </cfif>
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
</cfcomponent>
