<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- Retorna recibos de holerites
	-- NOTAS EXPLICATIVAS
	-- 13/01/2009 - GUTO - criado
	--->	
	<cffunction name="get_holerite_controle" displayname="Retorna recibos de holerites" output="true" returntype="query" access="public">
		<cfargument name="mes_inicio" required="no" default="" />
		<cfargument name="ano_inicio" required="no" default="" />
		<cfargument name="mes_fim" required="no" default="" />
		<cfargument name="ano_fim" required="no" default="" />
		<cfargument name="cod_funcionario" required="no" default="" />
		<cfargument name="cod_pessoa_funcionario" required="no" default="" />        
		<cfargument name="situacao_id" required="no" default="" />
        <cfargument name="cod_recibo_tipo" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select hc.controle_id,
                   hc.cod_funcionario,
                   f.nome_funcionario,
                   to_char(hc.mes, '00') as mes,
                   hc.ano,
                   to_char(hc.emitido, 'dd/mm/yyyy') as emitido,
                   to_char(hc.arquivado, 'dd/mm/yyyy') as arquivado,
                   to_char(hc.cancelado, 'dd/mm/yyyy') as cancelado,
                   hc.cod_filial_emissao,
                   hc.usuario_emissao,
                   hc.usuario_arquivamento,
                   hc.usuario_cancelamento,
                   p.cliente as filial_emissao,
                   hc.cod_recibo_tipo,
                   rt.descricao as recibo_tipo
              from rh.v$rh_holerite_controle hc
             inner join rh.rh_funcionario f
                     on f.cod_funcionario = hc.cod_funcionario
             inner join rh.rh_recibo_tipo rt
                     on rt.cod_recibo_tipo = hc.cod_recibo_tipo
              left join kss.v$pessoa p
                     on p.cod_pessoa = hc.cod_filial_emissao
             where 1 = 1
			 <cfif Len(Trim(arguments.mes_inicio))>
               and hc.mes >= #arguments.mes_inicio#
             </cfif>
			 <cfif Len(Trim(arguments.ano_inicio))>
               and hc.ano >= #arguments.ano_inicio#
             </cfif>
			 <cfif Len(Trim(arguments.mes_fim))>
               and hc.mes <= #arguments.mes_fim#
             </cfif>
			 <cfif Len(Trim(arguments.ano_fim))>
               and hc.ano <= #arguments.ano_fim#
             </cfif>
			 <cfif Len(Trim(arguments.cod_pessoa_funcionario))>
               and (hc.cod_funcionario = oper.pkg_global.fnc_get_cod_funcionario(#arguments.cod_pessoa_funcionario#)
                   or oper.pkg_global.fnc_get_cod_funcionario(#arguments.cod_pessoa_funcionario#) = -1)
             </cfif>
			 <cfif Len(Trim(arguments.ano_fim))>
               and hc.ano <= #arguments.ano_fim#
             </cfif>
			 <cfif Len(Trim(arguments.cod_funcionario))>
               and hc.cod_funcionario = #arguments.cod_funcionario#
             </cfif>             
			 <cfif Len(Trim(arguments.situacao_id))>
                <cfswitch expression="#arguments.situacao_id#">
					<cfcase value="1">
                        and hc.emitido is null
                        and hc.arquivado is null
                        and hc.cancelado is null
                    </cfcase>
					<cfcase value="2">
                     	and hc.emitido is not null
                    	and hc.arquivado is null
                     	and hc.cancelado is null
                    </cfcase>
					<cfcase value="3">
                     	and hc.emitido is not null
                     	and hc.arquivado is not null
                     	and hc.cancelado is null
                    </cfcase>
					<cfcase value="4">
                     	and hc.cancelado is not null
                    </cfcase>
					<cfcase value="5">
                     	and hc.cancelado is null
                    </cfcase>
                    <cfcase value="6">
                     	and hc.cancelado is null
                     	and hc.arquivado is null
                    </cfcase>
                </cfswitch>
             </cfif>
             <cfif Len(Trim(arguments.cod_recibo_tipo))>
               and hc.cod_recibo_tipo = #arguments.cod_recibo_tipo#
             </cfif>
			 order by f.nome_funcionario, to_date('01/' || hc.mes || '/' || hc.ano,'dd/mm/yyyy')
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna os tipos de holerites
	-- NOTAS EXPLICATIVAS
	-- 04/08/2009 - Rafael - criado
	--->	
	<cffunction name="get_recibo_tipo" displayname="Retorna os tipos de holerites" output="true" returntype="query" access="public">
		<cfargument name="cod_recibo_tipo" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cod_recibo_tipo
                  ,descricao
              from rh.rh_recibo_tipo
             where 1 = 1
			 <cfif Len(Trim(arguments.cod_recibo_tipo))>
               and cod_recibo_tipo in(#arguments.cod_recibo_tipo#) 
             </cfif>			 
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna os eventos
	-- NOTAS EXPLICATIVAS
	-- 02/03/2010 - Rafael - criado
	--->	
	<cffunction name="get_evento" displayname="Retorna os tipos de holerites" output="true" returntype="query" access="remote">
		<cfargument name="cod_evento" required="no" default="" />
        <cfargument name="descricao" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select re.cod_evento
                 , re.descricao
              from rh.rh_evento re
             where 1 = 1
			 <cfif Len(Trim(arguments.cod_evento))>
               and re.cod_evento = #arguments.cod_evento# 
             </cfif>
             <cfif Len(Trim(arguments.descricao))>
               and upper(kss.pkg_string.fnc_string_clean(re.descricao)) like upper(kss.pkg_string.fnc_string_clean('%#arguments.descricao#%'))
             </cfif>
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
</cfcomponent>
