<cfcomponent displayname="Componentes de consulta para os Indicadores da Qualidade" extends="_transportes.funcoes.cfc_init">
		
	<!--- 
	-- PROPSITO
	-- Retorna um indicador com os Tipos de Treinamento e o n de ocorrencias
	-- NOTAS EXPLICATIVAS
	-- Rafael - 17/12/2012 Criado
	--->	
	<cffunction name="get_treinamentos_tipo" displayname="Retorna um indicador com os Tipos de Treinamento e o n de ocorrencias" access="remote" returntype="query" output="true">
	   <cfargument name="data_inicio" required="no" default="">
       <cfargument name="data_termino" required="no" default="">
	   <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select descricao as descricao
                 , quantidade
                 , replace(to_char(round(quantidade/sum(quantidade) over()*100,2)),'.',',')||'%' as porcentagem
              from (
                     select mtt.descricao
                          , count(distinct mt.treinamento_id) as quantidade
                       from oper.v$mot_treinamento mt
                      inner join oper.v$mot_treinamento_tipo mtt
                         on mtt.treinamento_tipo_id = mt.treinamento_tipo_id
      	             	 where mt.data_inicio >= '#arguments.data_inicio#'
                           and mt.data_termino <= '#arguments.data_termino#'                  
                       group by mtt.descricao
                     )
            order by quantidade desc
	   </cfquery>
	   <cfreturn qr_result>	   
	</cffunction>	

    <!---
    -- PROPSITO
	-- Retorna um indicador com os Tipos de Treinamento e Carga Horria
    -- MARIALICE 12/12/2017 - CRIADO
    --->
    <cffunction name="get_treinamentos_carga" access="remote" returntype="query" output="true">
		<cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_termino" required="no" default="">
	    <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">		
			select treinamento_tipo_id,
				   descricao,
				   sum(minutos) as carga_horaria,
				   trunc(sum(minutos)/60) || ':' || mod(sum(minutos),60) as carga_horaria_extenso,
				   trunc(sum(minutos)/60) as hora,
				   mod(sum(minutos),60) as minuto
			  from (select mt.treinamento_tipo_id,
						   mtt.descricao,
						   (to_char(to_date(mt.carga_horaria, 'hh24:mi'), 'hh24') * 60) +
						   to_char(to_date(mt.carga_horaria, 'hh24:mi'), 'mi') as minutos
					  from oper.v$mot_treinamento mt
					 inner join oper.v$mot_treinamento_tipo mtt
						on mtt.treinamento_tipo_id = mt.treinamento_tipo_id
					 where mt.data_inicio >= '#arguments.data_inicio#'
					   and mt.data_termino <= '#arguments.data_termino#'   
					 group by mt.treinamento_tipo_id, mtt.descricao, mt.carga_horaria)
			 group by descricao, treinamento_tipo_id
			 order by sum(minutos) desc		
        </cfquery>
        <cfreturn qr_result>
    </cffunction>	

    <!---
    -- PROPSITO
	-- Retorna um indicador com os Tipos de Treinamento e Carga Horria
    -- MARIALICE 12/12/2017 - CRIADO
    --->
    <cffunction name="get_total_carga" access="remote" returntype="query" output="true">
		<cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_termino" required="no" default="">
	    <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">		
			select sum(minutos) as carga_horaria,
				   trunc(sum(minutos)/60) || ':' || mod(sum(minutos),60) as carga_horaria_extenso,
				   trunc(sum(minutos)/60) as hora,
				   mod(sum(minutos),60) as minuto
			  from (select mt.treinamento_tipo_id,
						   mtt.descricao,
						   (to_char(to_date(mt.carga_horaria, 'hh24:mi'), 'hh24') * 60) +
						   to_char(to_date(mt.carga_horaria, 'hh24:mi'), 'mi') as minutos
					  from oper.v$mot_treinamento mt
					 inner join oper.v$mot_treinamento_tipo mtt
						on mtt.treinamento_tipo_id = mt.treinamento_tipo_id
					 where mt.data_inicio >= '#arguments.data_inicio#'
					   and mt.data_termino <= '#arguments.data_termino#'   
					 group by mt.treinamento_tipo_id, mtt.descricao, mt.carga_horaria)
			 order by sum(minutos) desc		
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna um indicador com os Instrutores dos Treinamentos e o n de ocorrencias
	-- NOTAS EXPLICATIVAS
	-- Rafael - 18/12/2012 Criado
	--->	
	<cffunction name="get_treinamentos_instrutor" displayname="Retorna um indicador com os Instrutores dos Treinamentos e o n de ocorrencias" access="remote" returntype="query" output="true">
	   <cfargument name="data_inicio" required="no" default="">
       <cfargument name="data_termino" required="no" default="">
	   <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select instrutor as descricao
                 , decode(instr(instrutor,' '),0,instrutor,(substr(instrutor,0,instr(instrutor,' ')+1)||'.')) as descricao_abrv
                 , quantidade
                 , replace(to_char(round(quantidade/sum(quantidade) over()*100,2)),'.',',')||'%' as porcentagem
              from (
                     select ltrim(kss.pkg_pessoa.fnc_get_cliente(mti.cod_pessoa_instrutor)) as instrutor
                          , count(distinct mt.treinamento_id) as quantidade
                      from oper.v$mot_treinamento mt
                     inner join oper.v$mot_treinamento_instrutor mti
                        on mti.cod_pessoa_instrutor = mt.cod_pessoa_instrutor
      	             	 where mt.data_inicio >= '#arguments.data_inicio#'
      		               and mt.data_termino <= '#arguments.data_termino#'                  
                       group by mti.cod_pessoa_instrutor
                     )
            order by descricao
	   </cfquery>
	   <cfreturn qr_result>	   
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna um indicador com os Participantes dos Treinamentos e o n de ocorrencias
	-- NOTAS EXPLICATIVAS
	-- Rafael - 18/12/2012 Criado
	--->	
	<cffunction name="get_treinamentos_participante" displayname="Retorna um indicador com os Participantes dos Treinamentos e o n de ocorrencias" access="remote" returntype="query" output="true">
	   <cfargument name="data_inicio" required="no" default="">
       <cfargument name="data_termino" required="no" default="">
	   <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select participante as descricao
                 , decode(instr(participante,' '),0,participante,(substr(participante,0,instr(participante,' ')+1)||'.')) as descricao_abrv
                 , quantidade
                 , replace(to_char(round(quantidade/sum(quantidade) over()*100,2)),'.',',')||'%' as porcentagem
              from (
                     select ltrim(kss.pkg_pessoa.fnc_get_cliente(mtp.cod_pessoa)) as participante
                          , count(distinct mt.treinamento_id) as quantidade
                      from oper.v$mot_treinamento mt
                     inner join oper.v$mot_trein_participante mtp
                        on mtp.treinamento_id = mt.treinamento_id
      	             	 where mt.data_inicio >= '#arguments.data_inicio#'
      		               and mt.data_termino <= '#arguments.data_termino#'                  
                       group by mtp.cod_pessoa
                     )
            order by descricao
	   </cfquery>
	   <cfreturn qr_result>	   
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna um indicador com os Produtos dos Fornecedores e o n de ocorrencias
	-- NOTAS EXPLICATIVAS
	-- Rafael - 18/12/2012 Criado
	--->	
	<cffunction name="get_fornecedor_produto" displayname="Retorna um indicador com os Produtos dos Fornecedores e o n de ocorrencias" access="remote" returntype="query" output="true">
	   <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select descricao as descricao
                 , substr(descricao,0,10) as descricao_abrv 
                 , quantidade
                 , replace(to_char(round(quantidade/sum(quantidade) over()*100,2)),'.',',')||'%' as porcentagem
              from (
                     select p.descricao
                          , count(distinct fp.fornecedor_id) as quantidade
                       from qualidade.v$fornecedor_produto fp
                      inner join oper.v$produto p
                         on p.produto_id = fp.produto_id                    
                       group by p.descricao
                     )
            order by descricao
	   </cfquery>
	   <cfreturn qr_result>	   
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna um indicador com as Classificaes dos Fornecedores e o n de ocorrencias
	-- NOTAS EXPLICATIVAS
	-- Rafael - 18/12/2012 Criado
	--->	
	<cffunction name="get_fornecedor_classificacao" displayname="Retorna um indicador com as Classificaes dos Fornecedores e o n de ocorrencias" access="remote" returntype="query" output="true">
	   <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select distinct classificacao as descricao
                 , classificacao_abrv as descricao_abrv 
                 , quantidade
                 , replace(to_char(round(quantidade/sum(quantidade) over()*100,2)),'.',',')||'%' as porcentagem
                 , total_pontos
              from (
                      select  classificacao 
                            , classificacao_abrv 
                            , count(distinct fornecedor_id) as quantidade  
                            , total_pontos 
                       from(
                             select cg.rv_meaning as classificacao
                                  , nvl(substr(cg.rv_meaning,0,instr(cg.rv_meaning,' ')-1),cg.rv_meaning) as classificacao_abrv                     
                                  , fornecedor_id
                                  , rv_low_value+1 as total_pontos
                               from kss.cg_ref_codes cg
                               left join 
                                 (( select av.fornecedor_id
                                          , (select rv_meaning 
                                               from kss.cg_ref_codes  cg
                                              where cg.owner = 'QUALIDADE' 
                                                and cg.rv_domain = 'FORNECEDOR.CLASSIFICACAO'
                                                and (((total_pontos*100/total_pontos_requisitos) > cg.rv_low_value 
                                                and (total_pontos*100/total_pontos_requisitos) <= cg.rv_high_value) or ((total_pontos*100/total_pontos_requisitos) = 0 and cg.rv_low_value = 0))
                                            ) as classificacao   
                                          , av.data_avaliacao                  
                                       from( select f.fornecedor_id
                                                  , (select sum(fr.pontos) 
                                                       from qualidade.v$fornecedor_avaliacao_req fr 
                                                      where fr.avaliacao_id = f.avaliacao_id
                                                    ) as total_pontos
                                                  , (select sum(1) *  max( (select max(to_number(cg.rv_low_value))
                                                                              from kss.cg_ref_codes cg
                                                                             where cg.owner = 'QUALIDADE' 
                                                                               and cg.rv_domain = 'FORNECEDOR.AVALIACAO' 
                                                                            )                                                                            
                                                                          ) as pontos
                                                       from qualidade.v$fornecedor f2
                                                      inner join qualidade.v$ramo_atividade_requisito rar
                                                         on rar.ramo_atividade_id = f2.ramo_atividade_id
                                                     where f2.fornecedor_id = f.fornecedor_id
                                                    )as total_pontos_requisitos       
                                                  , max(f.data_avaliacao) over(partition by f.fornecedor_id) as data_ultima_avaliacao
                                                  , f.data_avaliacao
                                               from qualidade.v$fornecedor_avaliacao f
                                           ) av        
                                      where data_ultima_avaliacao = data_avaliacao
                                     )      
                                 ) on classificacao=rv_meaning
                              where cg.owner = 'QUALIDADE' 
                                and cg.rv_domain = 'FORNECEDOR.CLASSIFICACAO'
                          union
                             select 'NO AVALIADO' as classificao
                                  , 'NO AVALIADO' as classificacao_abrv
                                  , fornecedor_id
                                  , 0 as total_pontos
                               from qualidade.v$fornecedor f
                              where not exists (
                                                 select 1 
                                                   from qualidade.v$fornecedor_avaliacao fa 
                                                  where fa.fornecedor_id=f.fornecedor_id
                                               )
                            
                       ) 
                       group by classificacao, classificacao_abrv, total_pontos
                     )
            order by total_pontos desc 
	   </cfquery>
	   <cfreturn qr_result>	   
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna um indicador com os requisitos das Avaliaes dos Fornecedores e o n de ocorrencias
	-- NOTAS EXPLICATIVAS
	-- Rafael - 18/12/2012 Criado
	--->	
	<cffunction name="get_fornecedor_requisitos" displayname="Retorna um indicador com os requisitos das Avaliaes dos Fornecedores e o n de ocorrencias" access="remote" returntype="query" output="true">
	   <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select descricao as descricao
                 , quantidade
                 , replace(to_char(round(quantidade/sum(quantidade) over()*100,2)),'.',',')||'%' as porcentagem
              from (
                     select ra.descricao
                          , count(distinct fr.fornecedor_id) as quantidade
                       from qualidade.v$fornecedor_requisito fr
                      inner join qualidade.v$requisito_avaliacao ra
                         on fr.requisito_id = ra.requisito_id                      
                       group by ra.descricao
                     )
            order by descricao
	   </cfquery>
	   <cfreturn qr_result>	   
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna um indicador com os tipos de documentos e nmero de documentos cadastrados no periodo
	-- JAQUELIENF - 19/12/2012 Criado
	--->	
	<cffunction name="get_tipo_documento" displayname="Retorna um indicador com os tipos de documentos e nmero de documentos cadastrados no periodo" access="remote" returntype="query" output="true">
	   <cfargument name="data_inicio" required="no" default="">
       <cfargument name="data_termino" required="no" default="">    
	   <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select descricao as descricao
                 , quantidade
                 , replace(to_char(round(quantidade/sum(quantidade) over()*100,2)),'.',',')||'%' as porcentagem
              from (
                     select td.descricao
                          , count(distinct d.documento_id) as quantidade
                       from qualidade.v$documento d  
                      inner join qualidade.v$tipo_documento td
                         on td.tipo_documento_id = d.tipo_documento_id                       
                      where d.date_insert >= '#arguments.data_inicio#'
                        and d.date_insert <= '#arguments.data_termino#'   
                       group by td.descricao
                     )
            order by descricao 
	   </cfquery>
	   <cfreturn qr_result>	   
	</cffunction>    
    
    <!--- 
	-- PROPSITO
	-- Retorna um indicador com o nmero de verses por documento cadastrado no perodo
	-- JAQUELIENF - 19/12/2012 Criado
	--->	
	<cffunction name="get_versoes_documento" displayname="Retorna um indicador com o nmero de verses por documento cadastrado no perodo" access="remote" returntype="query" output="true">
	   <cfargument name="data_inicio" required="no" default="">
       <cfargument name="data_termino" required="no" default="">    
	   <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
             select titulo as descricao
                 , quantidade
                 , replace(to_char(round(quantidade/sum(quantidade) over()*100,2)),'.',',')||'%' as porcentagem
              from (
                     select d.titulo
                          , count(distinct dv.versao_id) as quantidade
                       from qualidade.v$documento_versao dv
                      inner join qualidade.v$documento d  
                         on d.documento_id = dv.documento_id
                      where d.date_insert >= '#arguments.data_inicio#'
                        and d.date_insert <= '#arguments.data_termino#'   
                       group by d.titulo
                     )
            order by descricao          
	   </cfquery>
	   <cfreturn qr_result>	   
	</cffunction>    
    
    <!--- 
	-- PROPSITO
	-- Retorna um indicador com o nmero documentos cadastrados no perodo por desenvolvedor
	-- JAQUELIENF - 19/12/2012 Criado
	--->	
	<cffunction name="get_desenvolvedor_documento" displayname="Retorna um indicador com o nmero documentos cadastrados no perodo por desenvolvedor" access="remote" returntype="query" output="true">
	   <cfargument name="data_inicio" required="no" default="">
       <cfargument name="data_termino" required="no" default="">    
	   <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select desenvolvedor as descricao
                 , decode(instr(desenvolvedor,' '),0,desenvolvedor,(substr(desenvolvedor,0,instr(desenvolvedor,' ')+1)||'.')) as descricao_abrv            
                 , quantidade
                 , replace(to_char(round(quantidade/sum(quantidade) over()*100,2)),'.',',')||'%' as porcentagem
              from (
                     select ltrim(kss.pkg_pessoa.fnc_get_cliente(d.cod_responsavel)) as desenvolvedor
                          , count(distinct d.documento_id) as quantidade
                       from qualidade.v$documento d  
                      where d.date_insert >= '#arguments.data_inicio#'
                        and d.date_insert <= '#arguments.data_termino#'   
                       group by d.cod_responsavel
                     )
            order by descricao
	   </cfquery>
	   <cfreturn qr_result>	   
	</cffunction>  
    
    <!--- 
	-- PROPSITO
	-- Retorna um indicador com o nmero documentos cadastrados no perodo por situao
	-- JAQUELIENF - 19/12/2012 Criado
	--->	
	<cffunction name="get_situacao_documento" displayname="Retorna um indicador com o nmero documentos cadastrados no perodo por situao" access="remote" returntype="query" output="true">
	   <cfargument name="data_inicio" required="no" default="">
       <cfargument name="data_termino" required="no" default="">    
	   <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select descricao
                 , decode(instr(descricao,' '),0,descricao,(substr(descricao,0,instr(descricao,' ')))) as descricao_abrv              
                 , quantidade
                 , replace(to_char(round(quantidade/sum(quantidade) over()*100,2)),'.',',')||'%' as porcentagem
              from (
                       select cg.rv_meaning as descricao
                            , count(distinct dv.documento_id) as quantidade
                          from kss.cg_ref_codes cg
                         inner join qualidade.v$documento_versao dv
                            on dv.situacao_id = cg.rv_low_value
                         inner join qualidade.v$documento d
                           on d.documento_id = dv.documento_id
                           and d.date_insert >= '#arguments.data_inicio#'
                           and d.date_insert <= '#arguments.data_termino#'               
                         where cg.rv_domain = 'DOCUMENTO.SITUACAO'
                           and cg.owner = 'QUALIDADE'
                          group by cg.rv_meaning   
                     )
            order by descricao
	   </cfquery>
	   <cfreturn qr_result>	   
	</cffunction>  
    
    <!--- 
	-- PROPSITO
	-- Retorna um indicador com o nmero registros identificados no perodo por responsvel
	-- JAQUELIENF - 19/12/2012 Criado
	--->	
	<cffunction name="get_responsaveis_registro" displayname="Retorna um indicador com o nmero registros identificados no perodo por responsvel" access="remote" returntype="query" output="true">
	   <cfargument name="data_inicio" required="no" default="">
       <cfargument name="data_termino" required="no" default="">    
	   <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select responsavel as descricao
                 , decode(instr(responsavel,' '),0,responsavel,(substr(responsavel,0,instr(responsavel,' ')+1)||'.')) as descricao_abrv            
                 , quantidade
                 , replace(to_char(round(quantidade/sum(quantidade) over()*100,2)),'.',',')||'%' as porcentagem
              from (
                     select ltrim(kss.pkg_pessoa.fnc_get_cliente(r.cod_responsavel)) as responsavel
                          , count(distinct r.registro_id) as quantidade
                       from qualidade.v$registro r  
                      where r.data_identificacao >= '#arguments.data_inicio#'
                        and r.data_identificacao <= '#arguments.data_termino#'   
                       group by r.cod_responsavel
                     )
            order by descricao
	   </cfquery>
	   <cfreturn qr_result>	   
	</cffunction> 
    
    <!--- 
	-- PROPSITO
	-- Retorna um indicador com o nmero registros identificados no perodo por identificador
	-- JAQUELIENF - 19/12/2012 Criado
	--->	
	<cffunction name="get_identificadores_registro" displayname="Retorna um indicador com o nmero registros identificados no perodo por identificador" access="remote" returntype="query" output="true">
	   <cfargument name="data_inicio" required="no" default="">
       <cfargument name="data_termino" required="no" default="">    
	   <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select identificador as descricao
                 , decode(instr(identificador,' '),0,identificador,(substr(identificador,0,instr(identificador,' ')+1)||'.')) as descricao_abrv            
                 , quantidade
                 , replace(to_char(round(quantidade/sum(quantidade) over()*100,2)),'.',',')||'%' as porcentagem
              from (
                     select ltrim(kss.pkg_pessoa.fnc_get_cliente(r.cod_identificacao)) as identificador
                          , count(distinct r.registro_id) as quantidade
                       from qualidade.v$registro r  
                      where r.data_identificacao >= '#arguments.data_inicio#'
                        and r.data_identificacao <= '#arguments.data_termino#'   
                       group by r.cod_identificacao
                     )
            order by descricao
	   </cfquery>
	   <cfreturn qr_result>	   
	</cffunction>                      
        
    <!--- 
	-- PROPSITO
	-- Retorna um indicador com o nmero registros identificados no perodo por rea
	-- RAFAEL - 19/12/2012 Criado
	--->	
	<cffunction name="get_area_registro" displayname="Retorna um indicador com o nmero registros identificados no perodo por rea" access="remote" returntype="query" output="true">
	   <cfargument name="data_inicio" required="no" default="">
       <cfargument name="data_termino" required="no" default="">    
	   <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select area as descricao
                 , quantidade
                 , replace(to_char(round(quantidade/sum(quantidade) over()*100,2)),'.',',')||'%' as porcentagem
              from (
                     select nvl(cg.rv_meaning,'No Definido') as area
                          , count(distinct r.registro_id) as quantidade
                       from qualidade.v$registro r  
                       left join qualidade.v$cg_ref_codes cg
                         on cg.rv_domain = 'REGISTRO.AREA'
                        and cg.rv_low_value = r.area_id
                      where r.data_identificacao >= '#arguments.data_inicio#'
                        and r.data_identificacao <= '#arguments.data_termino#'   
                       group by cg.rv_meaning
                     )
            order by descricao
	   </cfquery>
	   <cfreturn qr_result>	   
	</cffunction>   

    <!--- 
	-- PROPSITO
	-- Retorna um indicador com o nmero registros identificados no perodo por prioridade
	-- RAFAEL - 19/12/2012 Criado
	--->	
	<cffunction name="get_prioridade_registro" displayname="Retorna um indicador com o nmero registros identificados no perodo por prioridade" access="remote" returntype="query" output="true">
	   <cfargument name="data_inicio" required="no" default="">
       <cfargument name="data_termino" required="no" default="">    
	   <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select prioridade as descricao
                 , quantidade
                 , replace(to_char(round(quantidade/sum(quantidade) over()*100,2)),'.',',')||'%' as porcentagem
              from (
                     select cg.rv_meaning as prioridade
                          , count(distinct r.registro_id) as quantidade
                       from qualidade.v$registro r  
                       left join qualidade.v$cg_ref_codes cg
                         on cg.rv_domain = 'REGISTRO.PRIORIDADE'
                        and cg.rv_low_value = r.prioridade
                      where r.data_identificacao >= '#arguments.data_inicio#'
                        and r.data_identificacao <= '#arguments.data_termino#'   
                       group by cg.rv_meaning
                     )
            order by descricao
	   </cfquery>
	   <cfreturn qr_result>	   
	</cffunction>   

    <!--- 
	-- PROPSITO
	-- Retorna um indicador com o nmero registros identificados no perodo por classificacao
	-- RAFAEL - 19/12/2012 Criado
	--->	
	<cffunction name="get_classificacao_registro" displayname="Retorna um indicador com o nmero registros identificados no perodo por classificacao" access="remote" returntype="query" output="true">
	   <cfargument name="data_inicio" required="no" default="">
       <cfargument name="data_termino" required="no" default="">    
	   <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select classificacao as descricao
                 , quantidade
                 , replace(to_char(round(quantidade/sum(quantidade) over()*100,2)),'.',',')||'%' as porcentagem
              from (
                     select nvl(cg.rv_meaning, 'No Classificado') as classificacao
                          , count(distinct r.registro_id) as quantidade
                       from qualidade.v$registro r
                      left join qualidade.v$cg_ref_codes cg
                        on cg.rv_low_value = r.classificacao_id
                       and cg.rv_domain = 'REGISTRO.CLASSIFICACAO_ID'
                      where r.data_identificacao >= '#arguments.data_inicio#'
                        and r.data_identificacao <= '#arguments.data_termino#'   
                       group by cg.rv_meaning
                     )
            order by descricao
	   </cfquery>
	   <cfreturn qr_result>	   
	</cffunction>   

    <!--- 
	-- PROPSITO
	-- Retorna um indicador com o nmero registros identificados no perodo por tipo
	-- RAFAEL - 19/12/2012 Criado
	--->	
	<cffunction name="get_tipo_registro" displayname="Retorna um indicador com o nmero registros identificados no perodo por tipo" access="remote" returntype="query" output="true">
	   <cfargument name="data_inicio" required="no" default="">
       <cfargument name="data_termino" required="no" default="">    
	   <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select tipo as descricao
                 , quantidade
                 , replace(to_char(round(quantidade/sum(quantidade) over()*100,2)),'.',',')||'%' as porcentagem
              from (
                     select tr.descricao as tipo
                          , count(distinct r.registro_id) as quantidade
                       from qualidade.v$registro r  
                      inner join qualidade.v$tipo_registro tr
                         on tr.tipo_registro_id = r.tipo_registro_id
                      where r.data_identificacao >= '#arguments.data_inicio#'
                        and r.data_identificacao <= '#arguments.data_termino#' 
                       group by tr.descricao
                     )
            order by descricao
	   </cfquery>
	   <cfreturn qr_result>	   
	</cffunction>  
    
    <!--- 
	-- PROPSITO
	-- Retorna um indicador com o nmero registros identificados no perodo por organograma
	-- JAQUELINEF -20/12/2012 Criado
	--->	
	<cffunction name="get_organograma_registro" displayname="Retorna um indicador com o nmero registros identificados no perodo por organograma" access="remote" returntype="query" output="true">
	   <cfargument name="data_inicio" required="no" default="">
       <cfargument name="data_termino" required="no" default="">   
	   <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select organograma as descricao
                 , cod_organograma as descricao_abrv
                 , quantidade
     			 , replace(to_char(round(quantidade/sum(quantidade) over()*100,2)),'.',',')||'%' as porcentagem
              from (
          select p.cliente||' / '||d.descricao||' / '||s.descricao||' / '||cc.centro_custo as organograma
                           , o.cod_organograma
                           , count(distinct r.registro_id) as quantidade
                        from qualidade.v$registro r
                       inner join kss.v$organograma o
                          on o.cod_organograma = r.cod_organograma
                       inner join kss.v$pessoa p
                          on o.cod_pessoa = p.cod_pessoa
                       inner join kss.v$departamento d
                          on o.cod_departamento = d.cod_departamento 
                       inner join kss.v$setor s
                          on s.cod_setor = o.cod_setor    
                       inner join kss.v$centro_custo cc
                          on o.cod_centro_custo = cc.cod_centro_custo    
                         where r.data_identificacao >= '#arguments.data_inicio#'
                           and r.data_identificacao <= '#arguments.data_termino#'               
                        group by o.cod_organograma,  p.cliente, d.descricao, s.descricao, cc.centro_custo
                      ) 
             order by organograma
	   </cfquery>
	   <cfreturn qr_result>	   
	</cffunction>    
                         
 <!--- 
    -- PROPSITO 
    -- Retorna ...
    -- ANDERSON 99/99/2010 - CRIADO
    --->		
    <cffunction name="get_produtos_perigosos" access="remote" returntype="query" output="true">
    	<cfargument name="mes_inicial" required="yes" />
        <cfargument name="ano_inicial" required="yes" />
        <cfargument name="mes_final" required="yes" />
        <cfargument name="ano_final" required="yes" />
        <cfargument name="cod_pessoa_filial" required="yes" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.produtos_quimicos
            	 , t.classificacao
                 , nvl(sum(t.quantidade), 0) as quantidade
                 , (select un.unidade
                      from fiscal.v$unidade_medida un
                     where un.cod_unidade = t.cod_unidade
                   ) as unidade
                 , nvl(sum(t.km_percorrido), 0) as km_percorrido
                 , '' as ocorrencia
                 , '' as observacoes
                 , to_char(to_date('#arguments.mes_inicial#/#arguments.ano_inicial#', 'mm/yyyy'), 'Month/yyyy') as periodo_inicial
                 , to_char(last_day(to_date('#arguments.mes_final#/#arguments.ano_final#', 'mm/yyyy')), 'Month/yyyy') as periodo_final
              from (
                    select n.descricao as produtos_quimicos
               			 , gn.descricao_resumida as classificacao	
                         , nvl(sum(cnf.peso), 0) as quantidade
                         , cnf.cod_unidade
                         , c.km_rota as km_percorrido
                      from fiscal.v$conhecimento c
                     inner join fiscal.v$conhecimento_nota_fiscal cnf
                             on cnf.conhecimento_id = c.conhecimento_id
                     inner join oper.v$natureza n
                             on n.num_natureza = cnf.num_natureza
                     inner join oper.v$grupo_natureza gn 
                     		 on gn.grupo_natureza_id = n.grupo_natureza_id        
                     where c.cancelado is null
                       and trunc(c.data_emissao) between to_date('#arguments.mes_inicial#/#arguments.ano_inicial#', 'mm/yyyy') and last_day(to_date('#arguments.mes_final#/#arguments.ano_final#', 'mm/yyyy'))
                       and c.cod_pessoa_filial = #arguments.cod_pessoa_filial#
                     group by n.descricao
                            , cnf.cod_unidade
                            , c.km_rota
                            , gn.descricao_resumida
                     
                     union all
                    
                    select n.descricao as produtos_quimicos
               			 , gn.descricao_resumida as classificacao
                         , nvl(sum(ci.peso_bruto), 0) as quantidade
                         , ci.unidade_id as cod_unidade
                         , (select max(r.distancia_padrao) keep(dense_rank first order by r.origem_cod_pessoa nulls last, r.destino_cod_pessoa nulls last)
                              from fiscal.v$intc_conhecimento c2
                             inner join cep.municipio mo
                                     on mo.municipio_id = c2.resp_municipio_id
                             inner join cep.municipio md
                                     on md.municipio_id = c2.entrega_municipio_id
                             inner join oper.v$rota r
                                     on r.referencia_origem_id = mo.referencia_id
                                    and r.referencia_destino_id = md.referencia_id
                                    and (r.origem_cod_pessoa = c2.cod_remetente or r.origem_cod_pessoa is null)
                                    and (r.destino_cod_pessoa = c2.cod_destinatario or r.destino_cod_pessoa is null)
                             where c2.conhecimento_id = c.conhecimento_id
                           ) as km_percorrido
                      from fiscal.v$intc_conhecimento c
                     inner join fiscal.v$intc_conhecimento_item ci
                             on ci.conhecimento_id = c.conhecimento_id
                     inner join oper.v$natureza n
                             on n.num_natureza = ci.produto_id
                     inner join oper.v$grupo_natureza gn 
                     		 on gn.grupo_natureza_id = n.grupo_natureza_id   
                     where c.cancelado = 0
                       and trunc(c.emissao_data) between to_date('#arguments.mes_inicial#/#arguments.ano_inicial#', 'mm/yyyy') and last_day(to_date('#arguments.mes_final#/#arguments.ano_final#', 'mm/yyyy'))
                       and c.cod_pessoa_filial = #arguments.cod_pessoa_filial#
                     group by n.descricao
                            , ci.unidade_id
                            , c.conhecimento_id
                            , gn.descricao_resumida
                   ) t
             group by t.produtos_quimicos
             		, t.classificacao
                    , t.cod_unidade
        </cfquery>
        <cfreturn qr_result>
    </cffunction>   
                         
</cfcomponent>
