<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO 
    -- Retorna os tipos de registro
    -- FABIOG 22/03/2011 - CRIADO
    --->		
    <cffunction name="get_tipo_registro" access="remote" returntype="query" output="true">
    	<cfargument name="tipo_registro_id" required="no" default="">
        <cfargument name="registro_descricao_id" required="no" default="">
        <cfargument name="descricao" required="no" default="">        
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select tr.tipo_registro_id
                 , tr.descricao
              from qualidade.v$tipo_registro tr
             where 1 = 1
			<cfif Len(Trim(arguments.tipo_registro_id))>
               and tr.tipo_registro_id in (#arguments.tipo_registro_id#)
            </cfif>
            <cfif Len(Trim(arguments.registro_descricao_id))>
               and tr.tipo_registro_id in (#arguments.registro_descricao_id#)
            </cfif>
            <cfif Len(Trim(arguments.descricao))>
               and upper(tr.descricao) like upper('%#arguments.descricao#%')
            </cfif>            
             order by tr.tipo_registro_id
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as situaes
    -- ANDERSON 30/03/2011 - CRIADO
    --->		
    <cffunction name="get_registro_situacao" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select s.situacao_id
            	 , s.descricao
                 , s.ordem
              from qualidade.v$registro_situacao s
             order by s.ordem
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
	
	<!--- 
    -- PROPSITO 
    -- Retorna as atividades
    -- FABIOG 22/03/2011 - CRIADO
    --->		
    <cffunction name="get_atividade" access="remote" returntype="query" output="true">
    	<cfargument name="descricao" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select a.atividade_id
            	 , a.descricao
              from qualidade.v$atividade a
             where 1 = 1
			<cfif Len(Trim(arguments.descricao))>
               and upper(a.descricao) like upper('#arguments.descricao#%')
			</cfif>
             order by a.descricao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
   <!--- 
    -- PROPSITO 
    -- Retorna as descries de registro
    -- FABIOG 22/03/2011 - CRIADO
    --->		
    <cffunction name="get_registro_descricao" access="remote" returntype="query" output="true">
    	<cfargument name="registro_descricao_id" required="no" default="">
        <cfargument name="titulo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select rd.registro_descricao_id
                 , rd.titulo
                 , rd.descricao
              from qualidade.v$registro_descricao rd
             where 1 = 1
            <cfif Len(Trim(arguments.registro_descricao_id))>
               and rd.registro_descricao_id = #arguments.registro_descricao_id#
            </cfif>
            <cfif Len(Trim(arguments.titulo))>
               and upper(rd.titulo) like upper('#arguments.titulo#%')
		    </cfif>
             order by rd.titulo
        </cfquery>
        <cfreturn qr_result>
    </cffunction> 
    
    
    <!--- 
    -- PROPSITO 
    -- Retorna os registros
    -- ANDERSON 29/03/2010 - CRIADO
    --->		
    <cffunction name="get_registro" access="remote" returntype="query" output="true">
    	<cfargument name="registro_id" required="no" default="">
        <cfargument name="tipo_registro_id" required="no" default="">
        <cfargument name="prioridade" required="no" default="">
        <cfargument name="situacao_id" required="no" default="">
        <cfargument name="cod_responsavel" required="no" default="">
        <cfargument name="data_inicial" required="no" default="">
        <cfargument name="data_final" required="no" default="">
        <cfargument name="visualizar_atraso" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.registro_id
                 , r.tipo_registro_id
                 , (select tr.descricao
                      from qualidade.v$tipo_registro tr
                     where tr.tipo_registro_id = r.tipo_registro_id
                   ) as tipo_registro
                 , r.registro_id_gerador
                 , (select r2.descricao
                      from qualidade.v$registro r2
                     where r2.registro_id = r.registro_id_gerador
                   ) as registro_gerador_descricao
                 , r.classificacao_id
                 , (select cg.rv_abbreviation
                      from qualidade.v$cg_ref_codes cg
                     where cg.rv_domain = 'REGISTRO.CLASSIFICACAO_ID'
                       and cg.rv_low_value = r.classificacao_id
                   ) as classificacao
                 , r.area_id
                 , (select a.descricao
                      from qualidade.v$area a
                     where a.area_id = r.area_id
                   ) as area
                 , r.prioridade
                 , (select cg.rv_abbreviation
                      from qualidade.v$cg_ref_codes cg
                     where cg.rv_domain = 'REGISTRO.PRIORIDADE'
                       and cg.rv_low_value = r.prioridade
                   ) as prioridade_desc
                 , r.situacao_id
                 , (select rs.descricao
                      from qualidade.v$registro_situacao rs
                     where rs.situacao_id = r.situacao_id 
                   ) as situacao
                 , r.confirmado
                 , decode(r.confirmado, 1, 'Sim', 'No') as confirmado_desc
                 , r.cod_cliente
                 , (select p.cnpj_cpf
                      from kss.v$pessoa p
                     where p.cod_pessoa = r.cod_cliente
                   ) as cliente_cnpj_cpf
                 , (select p.razao_social
                      from kss.v$pessoa p
                     where p.cod_pessoa = r.cod_cliente
                   ) as cliente
                 , r.cod_organograma
                 , o.cod_pessoa as cod_pessoa_filial
                 , (select un.unidade_negocio
                      from kss.v$unidade_negocio un
                     where un.cod_pessoa = o.cod_pessoa
                   ) as unidade_negocio
                 , o.cod_departamento
                 , (select d.descricao
                      from kss.v$departamento d
                     where d.cod_departamento = o.cod_departamento
                   ) as departamento
                 , o.cod_setor
                 , (select s.descricao
                      from kss.v$setor s
                     where s.cod_setor = o.cod_setor
                   ) as setor
                 , o.cod_centro_custo
                 , (select cc.centro_custo
                      from kss.v$centro_custo cc
                     where cc.cod_centro_custo = o.cod_centro_custo
                   ) as centro_custo
                 , r.cod_identificacao
                 , r.cod_responsavel 
                 , (select p.cnpj_cpf
                      from kss.v$pessoa p
                     where p.cod_pessoa = r.cod_identificacao
                   ) as cod_funcionario_identificacao
                 , (select p.cliente
                      from kss.v$pessoa p
                     where p.cod_pessoa = r.cod_identificacao
                   ) as nome_funcionario_identificacao      
                 , (select p.cnpj_cpf
                      from kss.v$pessoa p
                     where p.cod_pessoa = r.cod_responsavel
                   ) as cod_funcionario_responsavel
                 , (select p.cliente
                      from kss.v$pessoa p
                     where p.cod_pessoa = r.cod_responsavel
                   ) as nome_funcionario_responsavel    
                 , r.atividade_id
                 , (select a.descricao
                      from qualidade.v$atividade a
                     where a.atividade_id = r.atividade_id
                   ) as atividade
                 , to_char(r.data_identificacao, 'dd/mm/yyyy') as data_identificacao
                 , to_char(r.data_previsao, 'dd/mm/yyyy') as data_previsao
                 , to_char(r.data_conclusao, 'dd/mm/yyyy') as data_conclusao
                 , r.descricao
                 , rd.registro_descricao_id as descricao_id
                 , rd.registro_descricao_id
                 , rd.titulo as descricao_titulo                
                 , rd.descricao as registro_descricao                 
                 , r.possiveis_causas
                 , r.solucao_aplicavel
                 , r.reclamacao
                 , case
                      when r.data_conclusao is null and trunc(r.data_previsao) <= trunc(sysdate) - 1 then 1
                      else 0
                   end as aviso
                 , case
                      when r.data_conclusao is null and trunc(r.data_previsao) - kss.pkg_global.fnc_parametro_num(11, 'OPERACIONAL', 41, 7) <= trunc(sysdate) then 1
                      else 0
                   end as lembrete
                 , r.eficaz
                 , r.avaliacao
                 , r.usuario_avaliacao
                 , to_char(r.data_avaliacao, 'dd/mm/yyyy hh24:mi:ss') as data_avaliacao
                 , case
                      when r.situacao_id = 3 and r.data_avaliacao is null then 1
                      else 0
                   end as avaliacao_ok
                 , r.user_insert
                 , to_char(r.date_insert, 'dd/mm/yyyy hh24:mi:ss') as date_insert
                 , r.user_update
                 , to_char(r.date_update, 'dd/mm/yyyy hh24:mi:ss') as date_update
                 , decode(r.situacao_id, 4, 'Sim', 'No') as status_cancelado
                 , r.motivo_cancelamento
                 , r.ip
                 /* Dados da tarefa */
                  ,(select p.cnpj_cpf||' - '||p.cliente
                      from kss.v$pessoa p
                     where p.cod_pessoa = t.cod_responsavel) as nome_responsavel_tarefa
                   , t.cod_responsavel as cod_responsavel_tarefa  
                   ,(select rs.descricao
                      from qualidade.v$registro_situacao rs
                     where rs.situacao_id = t.situacao_id) as situacao_tarefa
                   , t.tarefa_id
                   , to_char(t.data_abertura,'dd/mm/yyyy')  as data_abertura_tarefa
                   , to_char(t.data_previsao ,'dd/mm/yyyy')  as data_previsao_tarefa 
                   , to_char(t.data_conclusao ,'dd/mm/yyyy')  as data_conclusao_tarefa 
                   , t.descricao as descricao_tarefa
                   , t.acao_tomada as acao_tarefa
                   , t.brainstorm as brainstorm_tarefa
                   , t.participantes as participantes_tarefa
                   , t.possivel_causa_grupo  as possivel_causa_grupo_tarefa
                   , t.causa_grupo  as causa_grupo_tarefa
                   , t.solucao_imediata as solucao_imediata_tarefa
                   , t.solucao_contencao as solucao_contencao_tarefa
                   , case
                        when t.data_conclusao is null and trunc(t.data_previsao) <= trunc(sysdate) - 1 then 1
                        else 0
                     end as aviso_tarefa
                   , case
                        when t.data_conclusao is null and trunc(t.data_previsao) - kss.pkg_global.fnc_parametro_num(11, 'OPERACIONAL', 41, 7) <= trunc(sysdate) then 1
                        else 0
                   end as lembrete_tarefa                  
              from qualidade.v$registro r
             left join kss.v$organograma o
                     on o.cod_organograma = r.cod_organograma
			 left join qualidade.v$tarefa t
			   on t.registro_id = r.registro_id                     
             left join qualidade.v$registro_descricao rd
                     on rd.registro_descricao_id = r.descricao_id        
             where 1 = 1
			<cfif Len(Trim(arguments.registro_id))>
               and r.registro_id = #arguments.registro_id#
            </cfif>
            <cfif Len(Trim(arguments.tipo_registro_id))>
               and r.tipo_registro_id in (#arguments.tipo_registro_id#)
            </cfif>
            <cfif Len(Trim(arguments.prioridade))>
               and r.prioridade = #arguments.prioridade#
            </cfif>
            <cfif Len(Trim(arguments.situacao_id))>
               and r.situacao_id in (#arguments.situacao_id#)
            </cfif>
            <cfif Len(Trim(arguments.cod_responsavel))>
               and (r.cod_responsavel = #arguments.cod_responsavel# or t.cod_responsavel = #arguments.cod_responsavel#)
            </cfif>
            <cfif Len(Trim(arguments.data_inicial)) and Len(Trim(arguments.data_final))>
               and r.data_identificacao between to_date('#arguments.data_inicial#', 'dd/mm/yyyy') and to_date('#arguments.data_final# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
            <cfelseif Len(Trim(arguments.data_inicial))>
               and r.data_identificacao >= to_date('#arguments.data_inicial#', 'dd/mm/yyyy')
            <cfelseif Len(Trim(arguments.data_final))>
               and r.data_identificacao <= to_date('#arguments.data_final# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
            </cfif>
            <cfif Len(Trim(arguments.visualizar_atraso)) and arguments.visualizar_atraso eq 1>
                and (
                	(t.data_conclusao is null and trunc(t.data_previsao) <= trunc(sysdate) - 1) or
                    (r.data_conclusao is null and trunc(r.data_previsao) <= trunc(sysdate) - 1))
                and (r.situacao_id in (1, 2) or t.situacao_id in (1, 2))               
             </cfif>
             order by r.situacao_id, r.data_identificacao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as tarefas
    -- FABIOG 28/03/2011 - CRIADO
    --->		
    <cffunction name="get_tarefa" access="remote" returntype="query" output="true">
        <cfargument name="tarefa_id" required="no" default="">
        <cfargument name="registro_id" required="yes" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.tarefa_id
                 , t.registro_id
                 , t.situacao_id
                 , (select rs.descricao
                      from qualidade.v$registro_situacao rs
                     where rs.situacao_id = t.situacao_id 
                   ) as situacao
                 , t.cod_responsavel  
                 , (select p.cnpj_cpf 
                      from kss.v$pessoa p
                     where p.cod_pessoa = t.cod_responsavel
                   ) as cod_funcionario_responsavel                    
                 , (select p.cliente
                          from kss.v$pessoa p
                         where p.cod_pessoa = t.cod_responsavel
                       ) as nome_funcionario_responsavel
                 , to_char(t.data_abertura, 'dd/mm/yyyy') as data_abertura
                 , to_char(t.data_previsao, 'dd/mm/yyyy') as data_previsao
                 , to_char(t.data_conclusao, 'dd/mm/yyyy')as data_conclusao
                 , t.descricao
                 , t.acao_tomada
                 , case
                      when t.data_conclusao is null and trunc(t.data_previsao) <= trunc(sysdate) - 1 then 1
                      else 0
                   end as aviso
                 , case
                      when t.data_conclusao is null and trunc(t.data_previsao) - kss.pkg_global.fnc_parametro_num(11, 'OPERACIONAL', 41, 1) <= trunc(sysdate) then 1
                      else 0
                   end as lembrete
              from qualidade.v$tarefa t
             where 1 = 1
            <cfif Len(Trim(arguments.tarefa_id))>
               and t.tarefa_id = #arguments.tarefa_id#
		    </cfif>
            <cfif Len(Trim(arguments.registro_id))>
               and t.registro_id = #arguments.registro_id#
		    </cfif>
             order by t.situacao_id, t.data_abertura
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    
        <!--- 
    -- PROPSITO 
    -- Retorna as tarefas
    -- FABIOG 28/03/2011 - CRIADO
    --->		
    <cffunction name="get_sacp" access="remote" returntype="query" output="true">
        <cfargument name="tarefa_id" required="no" default="">
        <cfargument name="registro_id" required="yes" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.tarefa_id
                 , t.registro_id
                 , t.situacao_id
                 , (select rs.descricao
                      from qualidade.v$registro_situacao rs
                     where rs.situacao_id = t.situacao_id 
                   ) as situacao
                 , t.cod_responsavel
                 , (select p.cnpj_cpf   
                      from kss.v$pessoa p
                     where p.cod_pessoa = t.cod_responsavel
                   ) as cod_funcionario_responsavel
                 , (select p.cliente
                      from kss.v$pessoa p
                     where p.cod_pessoa = t.cod_responsavel
                   ) as nome_funcionario_responsavel 
                 , to_char(t.data_abertura, 'dd/mm/yyyy') as data_abertura
                 , to_char(t.data_previsao, 'dd/mm/yyyy') as data_previsao
                 , to_char(t.data_conclusao, 'dd/mm/yyyy')as data_conclusao
                 , t.descricao
                 , t.acao_tomada
                 , t.brainstorm
                 , t.participantes
                 , t.possivel_causa_grupo
                 , t.causa_grupo
                 , t.solucao_imediata
                 , t.solucao_contencao
                 , case
                      when t.data_conclusao is null and trunc(t.data_previsao) <= trunc(sysdate) - 1 then 1
                      else 0
                   end as aviso
                 , case
                      when t.data_conclusao is null and trunc(t.data_previsao) - kss.pkg_global.fnc_parametro_num(11, 'OPERACIONAL', 41, 1) <= trunc(sysdate) then 1
                      else 0
                   end as lembrete
              from qualidade.v$tarefa t
             where 1 = 1
            <cfif Len(Trim(arguments.tarefa_id))>
               and t.tarefa_id = #arguments.tarefa_id#
		    </cfif>
            <cfif Len(Trim(arguments.registro_id))>
               and t.registro_id = #arguments.registro_id#
		    </cfif>
             order by t.situacao_id, t.data_abertura
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as configiraes de registros automticos
    -- FABIOG 16/05/2011 - CRIADO
    --->		
    <cffunction name="get_config_registro_automatico" access="remote" returntype="query" output="true">
		<cfargument name="registro_config_id" required="no" default="">
        <cfargument name="tipo_id" required="no" default="">
        <cfargument name="data_inicial" required="no" default="">
        <cfargument name="data_final" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select rc.registro_config_id
                 , rc.tipo_id
                 , (select cg.rv_abbreviation
                      from qualidade.v$cg_ref_codes cg
                     where cg.rv_domain = 'REGISTRO_CONFIG.TIPO_ID'
                       and cg.rv_low_value = rc.tipo_id
                   ) as tipo_desc
                 , rc.classificacao_id
                 , (select cg.rv_abbreviation
                      from qualidade.v$cg_ref_codes cg
                     where cg.rv_domain = 'REGISTRO.CLASSIFICACAO_ID'
                       and cg.rv_low_value = rc.classificacao_id
                   ) as classificacao
                 , rc.prioridade
                 , (select cg.rv_abbreviation
                      from qualidade.v$cg_ref_codes cg
                     where cg.rv_domain = 'REGISTRO.PRIORIDADE'
                       and cg.rv_low_value = rc.prioridade
                   ) as prioridade_desc
                 , rc.cod_organograma
                 , o.cod_pessoa as cod_pessoa_filial
                 , o.cod_departamento
                 , o.cod_setor
                 , o.cod_centro_custo
                 , rc.cod_identificacao
                 , rc.cod_responsavel
                 , (select p.cod_pessoa
                      from kss.v$pessoa p
                     where p.cod_pessoa = rc.cod_identificacao
                   ) as cod_funcionario_identificacao
                 , (select p.cliente
                      from kss.v$pessoa p
                     where p.cod_pessoa = rc.cod_identificacao
                   ) as nome_funcionario_identificacao      
                 , (select p.cod_pessoa
                      from kss.v$pessoa p
                     where p.cod_pessoa = rc.cod_responsavel
                   ) as cod_funcionario_responsavel
                 , (select p.cliente
                      from kss.v$pessoa p
                     where p.cod_pessoa = rc.cod_responsavel
                   ) as nome_funcionario_responsavel
                 , rc.atividade_id
                 , (select a.descricao
                      from qualidade.v$atividade a
                     where a.atividade_id = rc.atividade_id
                   ) as atividade_desc
                 , rc.descricao
                 , rc.possiveis_causas
                 , rc.solucao_aplicavel
                 , to_char(rc.data_inicio, 'dd/mm/yyyy hh24:mi') as data_inicio
                 , to_char(rc.data_termino, 'dd/mm/yyyy hh24:mi') as data_termino
              from qualidade.v$registro_config rc 
             inner join kss.v$organograma o
                     on o.cod_organograma = rc.cod_organograma
             where 1 = 1
             <cfif Len(Trim(arguments.registro_config_id))>
               and rc.registro_config_id = #arguments.registro_config_id#
		    </cfif>
             <cfif Len(Trim(arguments.tipo_id))>
               and rc.tipo_id = #arguments.tipo_id#
		    </cfif>
            
            <cfif Len(Trim(arguments.data_inicial)) and Len(Trim(arguments.data_final))>
               and rc.data_inicio between to_date('#arguments.data_inicial#', 'dd/mm/yyyy') and to_date('#arguments.data_final# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
            <cfelseif Len(Trim(arguments.data_inicial))>
               and rc.data_inicio >= to_date('#arguments.data_inicial#', 'dd/mm/yyyy')
            <cfelseif Len(Trim(arguments.data_final))>
               and rc.data_inicio <= to_date('#arguments.data_final# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
            </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Verificar se o usurio tem pendncias no mdulo de qualidade
    -- FABIOG 17/05/2011 - CRIADO
    --->		
    <cffunction name="verifica_usuario" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select count(distinct r.registro_id) as qtde_pendencias
              from qualidade.v$registro r
              left join qualidade.v$tarefa t on r.registro_id = t.registro_id
             where ((t.data_conclusao is null and
                   trunc(t.data_previsao) <= trunc(sysdate) - 1 and
                   t.cod_responsavel =
                   (select u.cod_pessoa from kss.v$usuarios u where u.usuario = user))
                or (r.data_conclusao is null and
                   trunc(r.data_previsao) <= trunc(sysdate) - 1 and
                   r.cod_responsavel =
                   (select u.cod_pessoa from kss.v$usuarios u where u.usuario = user)))
               and (r.situacao_id in (1, 2) or t.situacao_id in (1, 2))
           </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as impresses do registro
    -- MARIA 01/06/2011 - CRIADO
    --->		
    <cffunction name="get_registro_impressao" access="remote" returntype="query" output="true">
    	<cfargument name="impressao_id" required="no" default="">
        <cfargument name="registro_id" required="no" default="">
        <cfargument name="localizacao_impressao_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select i.impressao_id
                 , i.registro_id
                 , i.localizacao_impressao_id
                 , to_char(i.data_impressao,'dd/mm/yyyy') as data_impressao                 
                 , i.user_insert
                 , l.descricao as localizacao
              from qualidade.v$impressao i
              inner join qualidade.v$registro r
              		on r.registro_id = i.registro_id
              inner join qualidade.v$localizacao_impressao l
              		on l.localizacao_impressao_id = i.localizacao_impressao_id     
             where 1 = 1
			<cfif Len(Trim(arguments.impressao_id))>
               and i.impressao_id in (#arguments.impressao_id#)
            </cfif>
			<cfif Len(Trim(arguments.registro_id))>
               and i.registro_id in (#arguments.registro_id#)
            </cfif>
            <cfif Len(Trim(arguments.localizacao_impressao_id))>
               and i.localizacao_impressao_id in (#arguments.localizacao_impressao_id#)
            </cfif>
             order by i.impressao_id
        </cfquery>
        <cfreturn qr_result>
    </cffunction>       

    <!--- 
    -- PROPSITO 
    -- Retorna as areas
    -- MARIA 26/03/2013 - CRIADO
    --->		
    <cffunction name="get_area" access="remote" returntype="query" output="true">
    	<cfargument name="area_id" required="no" default="">
        <cfargument name="descricao" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">        
            select a.area_id
                 , a.descricao
				 , a.email
              from qualidade.v$area a    
             where 1 = 1
			<cfif Len(Trim(arguments.area_id))>
               and a.area_id in (#arguments.area_id#)
            </cfif>
			<cfif Len(Trim(arguments.descricao))>
               and upper(a.descricao) like upper('%#arguments.descricao#%')
            </cfif>           
             order by a.descricao 
        </cfquery>
        <cfreturn qr_result>
    </cffunction> 
        
	<!--- 
    -- PROPSITO 
    -- Retorna as anexos do registro
    -- MARIA 14/06/2013 - CRIADO
    --->		
    <cffunction name="get_registro_anexo" access="remote" returntype="query" output="true">
    	<cfargument name="registro_anexo_id" required="no" default="">
        <cfargument name="registro_id" required="no" default="">
        <cfargument name="anexo_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.registro_anexo_id
                 , r.registro_id
                 , r.anexo_id
                 , r.ordem
                 , r.user_insert
                 , r.user_update
                 , to_char(r.date_insert,'dd/mm/yyyy')  as date_insert
                 , to_char(r.date_update,'dd/mm/yyyy')  as date_update
                 , a.titulo	as anexo_titulo			 
				 , a.url as anexo_url
              from qualidade.v$registro_anexo r                        
             inner join qualidade.v$anexo a
             	on a.anexo_id = r.anexo_id
             where 1=1  
			<cfif Len(Trim(arguments.registro_anexo_id))>
               and r.documento_anexo_id in (#arguments.registro_anexo_id#)
            </cfif>
			<cfif Len(Trim(arguments.registro_id))>
               and r.registro_id in (#arguments.registro_id#)
            </cfif>
			<cfif Len(Trim(arguments.anexo_id))>
               and r.anexo_id in (#arguments.anexo_id#)
            </cfif>
            order by r.ordem
        </cfquery>
        <cfreturn qr_result>
    </cffunction> 
    
</cfcomponent>