<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!---
    -- PROPSITO 
    -- Retorna os tipos de documentos
    -- MARIA 31/05/2011 - CRIADOget_tipo_documento_ext
    --->		
    <cffunction name="get_tipo_documento" access="remote" returntype="query" output="true">
    	<cfargument name="tipo_documento_id" required="no" default="">
        <cfargument name="codigo" required="no" default="">
        <cfargument name="descricao" required="no" default="">
        <cfargument name="cod_descricao" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select td.tipo_documento_id
                 , td.descricao
                 , td.codigo
                 , td.cabecalho_id
                 , c.titulo as doccabecalho
                 , td.rodape_id
                 , r.titulo as docrodape
              from qualidade.v$tipo_documento td
              left join qualidade.v$cabecalho c on td.cabecalho_id = c.cabecalho_id
              left join qualidade.v$rodape r on td.rodape_id = r.rodape_id
             where 1 = 1
			<cfif Len(Trim(arguments.tipo_documento_id))>
               and td.tipo_documento_id in (#arguments.tipo_documento_id#)
            </cfif>
            <cfif Len(Trim(arguments.codigo))>
               and upper(td.codigo) like upper('%#arguments.codigo#%')
            </cfif>
            <cfif Len(Trim(arguments.descricao))>
               and upper(td.descricao) like upper('%#arguments.descricao#%')
            </cfif>
			<cfif Len(Trim(arguments.cod_descricao))>
               and upper(td.descricao) like upper('%#arguments.cod_descricao#%' )
               or upper(td.codigo) like upper('%#arguments.cod_descricao#%')
            </cfif>
             order by td.tipo_documento_id
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
	<!--- 
    -- PROPSITO 
    -- Retorna as localizaes de impresso
    -- MARIA 01/06/2011 - CRIADO
    --->		
    <cffunction name="get_localizacao_impressao" access="remote" returntype="query" output="true">
    	<cfargument name="localizacao_impressao_id" required="no" default="">
        <cfargument name="descricao" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select li.localizacao_impressao_id
                 , li.descricao
              from qualidade.v$localizacao_impressao li
             where 1 = 1
			<cfif Len(Trim(arguments.localizacao_impressao_id))>
               and li.localizacao_impressao_id in (#arguments.localizacao_impressao_id#)
            </cfif>
            <cfif Len(Trim(arguments.descricao))>
               and upper(li.descricao) like upper('%#arguments.descricao#%')
            </cfif>
             order by li.localizacao_impressao_id
        </cfquery>
        <cfreturn qr_result>
    </cffunction>    
    
	<!--- 
    -- PROPSITO 
    -- Retorna os documentos
    -- MARIA 01/06/2011 - CRIADO
	--->	    
    <cffunction name="get_documento" access="remote" returntype="query" output="true">
    	<cfargument name="documento_id" required="no" default="">
        <cfargument name="situacao_id" required="no" default="">
        <cfargument name="status_id" required="no" default="">
        <cfargument name="versao_id" required="no" default="">
        <cfargument name="tipo_documento_id" required="no" default="">
        <cfargument name="cod_responsavel" required="no" default="">
        <cfargument name="data_inicial" required="no" default="">
        <cfargument name="data_final" required="no" default="">
        <cfargument name="palavra_chave" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select dd.documento_id
                 , dd.versao_id_atual
                 , dd.tipo_documento_id
                 , dd.codigo
                 , dd.titulo
                 , dd.palavra_chave
                 , dd.cod_responsavel
                 , dd.cod_organograma
                 , dd.recuperacao
                 , dd.descarte_apos_retencao
                 , dd.protecao
                 , dd.tempo_retencao
                 , dd.descarte_apos_retencao
                 , dd.protecao
                 , dd.armazenamento
                 , o.cod_pessoa as cod_pessoa_filial
                 , (select un.unidade_negocio
                      from kss.v$unidade_negocio un
                     where un.cod_pessoa = o.cod_pessoa
                   ) as unidade_negocio
                 , o.cod_departamento
                 , (select d.descricao
                      from kss.v$departamento d
                     where d.cod_departamento = o.cod_departamento
                   ) as departamento
                 , o.cod_setor
                 , (select s.descricao
                      from kss.v$setor s
                     where s.cod_setor = o.cod_setor
                   ) as setor
                 , o.cod_centro_custo
                 , (select cc.centro_custo
                      from kss.v$centro_custo cc
                     where cc.cod_centro_custo = o.cod_centro_custo
                   ) as centro_custo
                 , dd.user_insert
                 , dd.status_id    
                 , decode(dd.status_id,1,'Ativo','Inativo') as status             
                 , to_char(dd.date_insert,'dd/mm/yyyy')  as date_insert
                 , dd.user_update
                 , to_char(dd.date_update,'dd/mm/yyyy')  as date_update                
                 , dv.versao_id
                 , dv.num_versao
                 , dv.situacao_id
                 , dv.conteudo
                 , dv.observacao
                 , dv.date_insert as data_versao  
                 , dv.cod_responsavel as cod_responsavel_versao
                 , dv.cod_responsavel_aprovacao
                 , dv.cod_responsavel_validacao
                 , td.descricao as tipo_documento
                 , td.codigo
                 , (select cg.rv_abbreviation
                      from qualidade.v$cg_ref_codes cg
                     where cg.rv_domain = 'DOCUMENTO.SITUACAO'
                       and cg.rv_low_value = dv.situacao_id
                   ) as situacao                   
                 , (select p.cnpj_cpf
                      from kss.v$pessoa p
                     where p.cod_pessoa = dv.cod_responsavel
                   ) as cod_funcionario_responsavel
                 , (select p.cliente
                      from kss.v$pessoa p
                     where p.cod_pessoa = dv.cod_responsavel
                   ) as nome_funcionario_responsavel
                 , c.cabecalho_id
                 , cv.conteudo as conteudo_cabecalho  
                 , r.rodape_id
                 , rv.conteudo as conteudo_rodape
                 , dd.documento_formato
                 , (select cg.rv_abbreviation
                      from kss.cg_ref_codes cg
                     where TO_CHAR(cg.rv_low_value) = TO_CHAR(dd.documento_formato)
                       and cg.rv_domain ='DOCUMENTO.FORMATO'
                       and cg.owner = 'QUALIDADE' 
                    )   as doc_formato_desc
                 , (select cg.rv_abbreviation
                      from kss.cg_ref_codes cg
                     where TO_CHAR(cg.rv_low_value) = TO_CHAR(dd.protecao)
                       and cg.rv_domain ='DOCUMENTO.PROTECAO'
                       and cg.owner = 'QUALIDADE' 
                    )   as doc_protecao_desc 
                 , (select cg.rv_abbreviation
                      from kss.cg_ref_codes cg
                     where TO_CHAR(cg.rv_low_value) = TO_CHAR(dd.descarte_apos_retencao)
                       and cg.rv_domain ='DOCUMENTO.DESCARTE'
                       and cg.owner = 'QUALIDADE' 
                    )   as doc_descarte_desc
                 , (select cg.rv_abbreviation
                      from kss.cg_ref_codes cg
                     where TO_CHAR(cg.rv_low_value) = TO_CHAR(dd.recuperacao)
                       and cg.rv_domain ='DOCUMENTO.RECUPERACAO'
                       and cg.owner = 'QUALIDADE' 
                    )   as doc_recuperacao_desc
                 , (select cg.rv_abbreviation
                      from kss.cg_ref_codes cg
                     where TO_CHAR(cg.rv_low_value) = TO_CHAR(dd.tempo_retencao)
                       and cg.rv_domain ='DOCUMENTO.TEMPO_RETENCAO'
                       and cg.owner = 'QUALIDADE' 
                    )   as doc_tempo_retencao_desc
                 , (select kss.fnc_concat_all(kss.to_concat_expr(ar.descricao, ', ')) 
                      from qualidade.v$aplicabilidade ap
                     inner join qualidade.v$area ar
                        on ar.area_id = ap.area_id
                     where ap.documento_id =dd.documento_id 
                      ) as aplicabilidade_desc
                 , a.descricao as armazenamento_desc
                 , lpad((select max(dv1.num_versao)
                      from qualidade.v$documento_versao dv1
                     where dv1.documento_id = dd.documento_id), 2, 0) as versao_atual
                 , (select kss.fnc_concat_all(kss.to_concat_expr(a1.area_id, ','))
                      from qualidade.v$aplicabilidade a1 
                     where a1.documento_id = dd.documento_id) as lista_aplicabilidade
                  , dd.armazenamento   
              from qualidade.v$documento dd 
             inner join qualidade.v$documento_versao dv
                on dv.versao_id = dd.versao_id_atual
             left join qualidade.v$area a
                on a.area_id = dd.armazenamento
             inner join qualidade.v$tipo_documento td
                on td.tipo_documento_id = dd.tipo_documento_id  
              left join kss.v$organograma o
                on o.cod_organograma = dd.cod_organograma
              left join qualidade.v$cabecalho c
                on c.cabecalho_id = td.cabecalho_id
              left join qualidade.v$cabecalho_versao cv
                on cv.cabecalho_versao_id = c.versao_id_atual
              left join qualidade.v$rodape r
                on r.rodape_id = td.rodape_id
              left join qualidade.v$rodape_versao rv
                on rv.rodape_versao_id = r.versao_id_atual
             where 1=1
			<cfif Len(Trim(arguments.documento_id))>
               and dd.documento_id in (#arguments.documento_id#)
            </cfif>
            <cfif Len(Trim(arguments.tipo_documento_id))>
               and dd.tipo_documento_id in (#arguments.tipo_documento_id#)
            </cfif>
            <cfif Len(Trim(arguments.versao_id))>
               and dv.versao_id in (#arguments.versao_id#)
            </cfif>
	       <cfif Len(Trim(arguments.situacao_id))>
               and dv.situacao_id in (#arguments.situacao_id#)
            </cfif>            
			<cfif Len(Trim(arguments.status_id))>
               and dd.status_id = #arguments.status_id#
            </cfif>
            <cfif Len(Trim(arguments.cod_responsavel))>
               and dd.cod_responsavel = #arguments.cod_responsavel#
            </cfif>            
            <cfif Len(Trim(arguments.data_inicial)) and Len(Trim(arguments.data_final))>
               and dd.date_insert between to_date('#arguments.data_inicial#', 'dd/mm/yyyy') and to_date('#arguments.data_final# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')            
			<cfelseif Len(Trim(arguments.data_inicial))>
               and dd.date_insert >= to_date('#arguments.data_inicial#', 'dd/mm/yyyy')
            <cfelseif Len(Trim(arguments.data_final))>
               and dd.date_insert <= to_date('#arguments.data_final# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
            </cfif>
            <cfif Len(Trim(arguments.palavra_chave))>
               and dd.palavra_chave like '%#LCase(arguments.palavra_chave)#%'
            </cfif>
             order by dd.documento_id, date_insert desc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os documentos para mostrar na lista mestre
    -- VCTOR 25/06/2015 - CRIADO
	--->	    
    <cffunction name="get_documento_lista_mestre" access="remote" returntype="query" output="true">
    	<cfargument name="documento_id" required="no" default="">
        <cfargument name="situacao_id" required="no" default="">
        <cfargument name="status_id" required="no" default="">
        <cfargument name="versao_id" required="no" default="">
        <cfargument name="tipo_documento_id" required="no" default="">
        <cfargument name="cod_responsavel" required="no" default="">
        <cfargument name="data_inicial" required="no" default="">
        <cfargument name="data_final" required="no" default="">
        <cfargument name="palavra_chave" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select dd.documento_id
                 , dd.versao_id_atual
                 , dd.tipo_documento_id
                 , dd.codigo
                 , dd.titulo
                 , dd.palavra_chave
                 , dd.cod_responsavel
                 , dd.cod_organograma
                 , dd.recuperacao
                 , dd.descarte_apos_retencao
                 , dd.protecao
                 , dd.tempo_retencao
                 , dd.descarte_apos_retencao
                 , dd.protecao
                 , dd.armazenamento
                 , o.cod_pessoa as cod_pessoa_filial
                 , (select un.unidade_negocio
                      from kss.v$unidade_negocio un
                     where un.cod_pessoa = o.cod_pessoa
                   ) as unidade_negocio
                 , o.cod_departamento
                 , (select d.descricao
                      from kss.v$departamento d
                     where d.cod_departamento = o.cod_departamento
                   ) as departamento
                 , o.cod_setor
                 , (select s.descricao
                      from kss.v$setor s
                     where s.cod_setor = o.cod_setor
                   ) as setor
                 , o.cod_centro_custo
                 , (select cc.centro_custo
                      from kss.v$centro_custo cc
                     where cc.cod_centro_custo = o.cod_centro_custo
                   ) as centro_custo
                 , dd.user_insert
                 , dd.status_id    
                 , decode(dd.status_id,1,'Ativo','Inativo') as status             
                 , to_char(dd.date_insert,'dd/mm/yyyy')  as date_insert
                 , dd.user_update
                 , to_char(dd.date_update,'dd/mm/yyyy')  as date_update                
                 , dv.versao_id
                 , dv.num_versao
                 , dv.situacao_id
                 , dv.conteudo
                 , dv.observacao
                 , dv.date_insert as data_versao  
                 , dv.cod_responsavel as cod_responsavel_versao
                 , dv.cod_responsavel_aprovacao
                 , dv.cod_responsavel_validacao
                 , td.descricao as tipo_documento
                 , td.codigo
                 , (select cg.rv_abbreviation
                      from qualidade.v$cg_ref_codes cg
                     where cg.rv_domain = 'DOCUMENTO.SITUACAO'
                       and cg.rv_low_value = dv.situacao_id
                   ) as situacao                   
                 , (select p.cnpj_cpf
                      from kss.v$pessoa p
                     where p.cod_pessoa = dv.cod_responsavel
                   ) as cod_funcionario_responsavel
                 , (select p.cliente
                      from kss.v$pessoa p
                     where p.cod_pessoa = dv.cod_responsavel
                   ) as nome_funcionario_responsavel
                 , c.cabecalho_id
                 , cv.conteudo as conteudo_cabecalho  
                 , r.rodape_id
                 , rv.conteudo as conteudo_rodape
                 , dd.documento_formato
                 , (select cg.rv_abbreviation
                      from kss.cg_ref_codes cg
                     where TO_CHAR(cg.rv_low_value) = TO_CHAR(dd.documento_formato)
                       and cg.rv_domain ='DOCUMENTO.FORMATO'
                       and cg.owner = 'QUALIDADE' 
                    )   as doc_formato_desc
                 , (select cg.rv_abbreviation
                      from kss.cg_ref_codes cg
                     where TO_CHAR(cg.rv_low_value) = TO_CHAR(dd.protecao)
                       and cg.rv_domain ='DOCUMENTO.PROTECAO'
                       and cg.owner = 'QUALIDADE' 
                    )   as doc_protecao_desc 
                 , (select cg.rv_abbreviation
                      from kss.cg_ref_codes cg
                     where TO_CHAR(cg.rv_low_value) = TO_CHAR(dd.descarte_apos_retencao)
                       and cg.rv_domain ='DOCUMENTO.DESCARTE'
                       and cg.owner = 'QUALIDADE' 
                    )   as doc_descarte_desc
                 , (select cg.rv_abbreviation
                      from kss.cg_ref_codes cg
                     where TO_CHAR(cg.rv_low_value) = TO_CHAR(dd.recuperacao)
                       and cg.rv_domain ='DOCUMENTO.RECUPERACAO'
                       and cg.owner = 'QUALIDADE' 
                    )   as doc_recuperacao_desc
                 , (select cg.rv_abbreviation
                      from kss.cg_ref_codes cg
                     where TO_CHAR(cg.rv_low_value) = TO_CHAR(dd.tempo_retencao)
                       and cg.rv_domain ='DOCUMENTO.TEMPO_RETENCAO'
                       and cg.owner = 'QUALIDADE' 
                    )   as doc_tempo_retencao_desc
                 , (select kss.fnc_concat_all(kss.to_concat_expr(ar.descricao, ', ')) 
                      from qualidade.v$aplicabilidade ap
                     inner join qualidade.v$area ar
                        on ar.area_id = ap.area_id
                     where ap.documento_id =dd.documento_id 
                      ) as aplicabilidade_desc
                 , a.descricao as armazenamento_desc
                 , lpad((select max(dv1.num_versao)
                      from qualidade.v$documento_versao dv1
                     where dv1.documento_id = dd.documento_id), 2, 0) as versao_atual
                 , (select kss.fnc_concat_all(kss.to_concat_expr(a1.area_id, ','))
                      from qualidade.v$aplicabilidade a1 
                     where a1.documento_id = dd.documento_id) as lista_aplicabilidade
                  , dd.armazenamento   
              from qualidade.v$documento dd 
             inner join qualidade.v$documento_versao dv
                on dv.versao_id = dd.versao_id_atual
             left join qualidade.v$area a
                on a.area_id = dd.armazenamento
             inner join qualidade.v$tipo_documento td
                on td.tipo_documento_id = dd.tipo_documento_id  
              left join kss.v$organograma o
                on o.cod_organograma = dd.cod_organograma
              left join qualidade.v$cabecalho c
                on c.cabecalho_id = td.cabecalho_id
              left join qualidade.v$cabecalho_versao cv
                on cv.cabecalho_versao_id = c.versao_id_atual
              left join qualidade.v$rodape r
                on r.rodape_id = td.rodape_id
              left join qualidade.v$rodape_versao rv
                on rv.rodape_versao_id = r.versao_id_atual
             where 1=1
			<cfif Len(Trim(arguments.documento_id))>
               and dd.documento_id in (#arguments.documento_id#)
            </cfif>
            <cfif Len(Trim(arguments.tipo_documento_id))>
               and dd.tipo_documento_id in (#arguments.tipo_documento_id#)
            </cfif>
            <cfif Len(Trim(arguments.versao_id))>
               and dv.versao_id in (#arguments.versao_id#)
            </cfif>
	       <cfif Len(Trim(arguments.situacao_id))>
               and dv.situacao_id in (#arguments.situacao_id#)
            </cfif>            
            <cfif Len(Trim(arguments.cod_responsavel))>
               and dd.cod_responsavel = #arguments.cod_responsavel#
            </cfif>            
            <cfif Len(Trim(arguments.data_inicial)) and Len(Trim(arguments.data_final))>
               and dd.date_insert between to_date('#arguments.data_inicial#', 'dd/mm/yyyy') and to_date('#arguments.data_final# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')            
			<cfelseif Len(Trim(arguments.data_inicial))>
               and dd.date_insert >= to_date('#arguments.data_inicial#', 'dd/mm/yyyy')
            <cfelseif Len(Trim(arguments.data_final))>
               and dd.date_insert <= to_date('#arguments.data_final# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
            </cfif>
            <cfif Len(Trim(arguments.palavra_chave))>
               and dd.palavra_chave like '%#LCase(arguments.palavra_chave)#%'
            </cfif>
              and dd.status_id = 1
             order by dd.documento_id, date_insert desc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    
	<!--- 
    -- PROPSITO 
    -- Retorna as verses do documento
    -- MARIA 01/06/2011 - CRIADO
    --->		
    <cffunction name="get_documento_versao" access="remote" returntype="query" output="true">
    	<cfargument name="versao_id" required="no" default="">
        <cfargument name="documento_id" required="no" default="">
        <cfargument name="num_versao" required="no" default="">
        <cfargument name="situacao_id" required="no" default="">
        <cfargument name="conteudo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select d.documento_id,
                       d.versao_id_atual,
                       d.tipo_documento_id,
                       d.codigo,
                       d.titulo,
                       d.palavra_chave,
                       d.cod_responsavel,
                       d.cod_organograma,
                       d.recuperacao,
                       d.descarte_apos_retencao,
                       d.protecao,
                       d.tempo_retencao,
                       d.descarte_apos_retencao,
                       d.protecao,
                       d.armazenamento,
                       o.cod_pessoa as cod_pessoa_filial,
                       (select un.unidade_negocio
                          from kss.v$unidade_negocio un
                         where un.cod_pessoa = o.cod_pessoa) as unidade_negocio,
                       o.cod_departamento,
                       (select d.descricao
                          from kss.v$departamento d
                         where d.cod_departamento = o.cod_departamento) as departamento,
                       o.cod_setor,
                       (select s.descricao
                          from kss.v$setor s
                         where s.cod_setor = o.cod_setor) as setor,
                       o.cod_centro_custo,
                       (select cc.centro_custo
                          from kss.v$centro_custo cc
                         where cc.cod_centro_custo = o.cod_centro_custo) as centro_custo,
                       d.user_insert,
                       d.status_id,
                       decode(d.status_id, 1, 'Ativo', 'Inativo') as status,
                       to_char(d.date_insert, 'dd/mm/yyyy') as date_insert,
                       d.user_update,
                       to_char(d.date_update, 'dd/mm/yyyy') as date_update,
                       dv.versao_id,
                       dv.num_versao,
                       dv.situacao_id,
                       dv.conteudo,
                       dv.observacao,
                       dv.date_insert as data_versao,
                       dv.cod_responsavel as cod_responsavel_versao,
                       dv.cod_responsavel_aprovacao,
                       dv.cod_responsavel_validacao,
                       td.descricao as tipo_documento,
                       td.codigo,
                       (select cg.rv_abbreviation
                          from qualidade.v$cg_ref_codes cg
                         where cg.rv_domain = 'DOCUMENTO.SITUACAO'
                           and cg.rv_low_value = dv.situacao_id) as situacao,
                       (select p.cnpj_cpf
                          from kss.v$pessoa p
                         where p.cod_pessoa = dv.cod_responsavel) as cod_funcionario_responsavel,
                       (select p.cliente
                          from kss.v$pessoa p
                         where p.cod_pessoa = dv.cod_responsavel) as nome_funcionario_responsavel,
                       c.cabecalho_id,
                       cv.conteudo as conteudo_cabecalho,
                       r.rodape_id,
                       rv.conteudo as conteudo_rodape,
                       d.documento_formato,
                       (select cg.rv_abbreviation
                          from kss.cg_ref_codes cg
                         where TO_CHAR(cg.rv_low_value) = TO_CHAR(d.documento_formato)
                           and cg.rv_domain = 'DOCUMENTO.FORMATO'
                           and cg.owner = 'QUALIDADE') as doc_formato_desc,
                       (select cg.rv_abbreviation
                          from kss.cg_ref_codes cg
                         where TO_CHAR(cg.rv_low_value) = TO_CHAR(d.protecao)
                           and cg.rv_domain = 'DOCUMENTO.PROTECAO'
                           and cg.owner = 'QUALIDADE') as doc_protecao_desc,
                       (select cg.rv_abbreviation
                          from kss.cg_ref_codes cg
                         where TO_CHAR(cg.rv_low_value) = TO_CHAR(d.descarte_apos_retencao)
                           and cg.rv_domain = 'DOCUMENTO.DESCARTE'
                           and cg.owner = 'QUALIDADE') as doc_descarte_desc,
                       (select cg.rv_abbreviation
                          from kss.cg_ref_codes cg
                         where TO_CHAR(cg.rv_low_value) = TO_CHAR(d.recuperacao)
                           and cg.rv_domain = 'DOCUMENTO.RECUPERACAO'
                           and cg.owner = 'QUALIDADE') as doc_recuperacao_desc,
                       (select cg.rv_abbreviation
                          from kss.cg_ref_codes cg
                         where TO_CHAR(cg.rv_low_value) = TO_CHAR(d.tempo_retencao)
                           and cg.rv_domain = 'DOCUMENTO.TEMPO_RETENCAO'
                           and cg.owner = 'QUALIDADE') as doc_tempo_retencao_desc,
                       (select kss.fnc_concat_all(kss.to_concat_expr(ar.descricao, ', '))
                          from qualidade.v$aplicabilidade ap
                         inner join qualidade.v$area ar on ar.area_id = ap.area_id
                         where ap.documento_id = d.documento_id) as aplicabilidade_desc,
                       a.descricao as armazenamento_desc,
                       lpad((select max(dv1.num_versao)
                              from qualidade.v$documento_versao dv1
                             where dv1.documento_id = d.documento_id),
                            2,
                            0) as versao_atual,
                       (select kss.fnc_concat_all(kss.to_concat_expr(a1.area_id, ','))
                          from qualidade.v$aplicabilidade a1
                         where a1.documento_id = d.documento_id) as lista_aplicabilidade,
                       (select to_char(min(dva.data_aprovacao), 'dd/mm/yyyy hh24:mi:ss') 
          				  from qualidade.v$documento_versao_auditoria dva
         				 where dva.versao_id = d.versao_id_atual) as data_aprovacao,
                       (select to_char(max(dva.data_reprovacao), 'dd/mm/yyyy hh24:mi:ss') 
          				  from qualidade.v$documento_versao_auditoria dva
         				 where dva.versao_id = dv.versao_id) as data_reprovacao,
                        (select to_char(dv.date_insert,'dd/mm/yyyy')
          				   from dual
         				  where dv.situacao_id = 4) as data_validacao       
                  from qualidade.v$documento_versao dv
                 inner join qualidade.v$documento d on d.documento_id = dv.documento_id
                 inner join qualidade.v$tipo_documento td on td.tipo_documento_id =
                                                             d.tipo_documento_id
                  
                
                  left join qualidade.v$area a on a.area_id = d.armazenamento
                 inner join qualidade.v$tipo_documento td on td.tipo_documento_id =
                                                             d.tipo_documento_id
                  left join kss.v$organograma o on o.cod_organograma = d.cod_organograma
                  left join qualidade.v$cabecalho c on c.cabecalho_id = td.cabecalho_id
                  left join qualidade.v$cabecalho_versao cv on cv.cabecalho_versao_id =
                                                               c.versao_id_atual
                  left join qualidade.v$rodape r on r.rodape_id = td.rodape_id
                  left join qualidade.v$rodape_versao rv on rv.rodape_versao_id =
                                                            r.versao_id_atual
                 where 1 = 1
			<cfif Len(Trim(arguments.versao_id))>
               and dv.versao_id in (#arguments.versao_id#)
            </cfif>
			<cfif Len(Trim(arguments.documento_id))>
               and dv.documento_id in (#arguments.documento_id#)
            </cfif>
			<cfif Len(Trim(arguments.num_versao))>
               and dv.num_versao in (#arguments.num_versao#)
            </cfif>
			<cfif Len(Trim(arguments.situacao_id))>
               and dv.situacao_id in (#arguments.situacao_id#)
            </cfif>
            <cfif Len(Trim(arguments.conteudo))>
               and dv.conteudo like '%#arguments.conteudo#%'
            </cfif>
             order by dv.versao_id
        </cfquery>
        <cfreturn qr_result>
    </cffunction> 
    
        
	<!--- 
    -- PROPSITO 
    -- Retorna as anexos do documento
    -- MARIA 01/06/2011 - CRIADO
    --->		
    <cffunction name="get_documento_anexo" access="remote" returntype="query" output="true">
    	<cfargument name="documento_anexo_id" required="no" default="">
        <cfargument name="versao_id" required="no" default="">
        <cfargument name="anexo_id" required="no" default="">
        <cfargument name="documento_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select da.documento_anexo_id
                 , da.versao_id
                 , da.anexo_id
                 , da.ordem
                 , da.user_insert
                 , da.user_update
                 , to_char(da.date_insert,'dd/mm/yyyy')  as date_insert
                 , to_char(da.date_update,'dd/mm/yyyy')  as date_update
                 , a.titulo	as anexo_titulo			 
				 , a.url as anexo_url
              from qualidade.v$documento_anexo da           
             inner join qualidade.v$documento_versao dv
             	on dv.versao_id = da.versao_id
             inner join qualidade.v$anexo a
             	on a.anexo_id = da.anexo_id
             where 1=1  
			<cfif Len(Trim(arguments.documento_anexo_id))>
               and da.documento_anexo_id in (#arguments.documento_anexo_id#)
            </cfif>
			<cfif Len(Trim(arguments.versao_id))>
               and da.versao_id in (#arguments.versao_id#)
            </cfif>
			<cfif Len(Trim(arguments.anexo_id))>
               and da.anexo_id in (#arguments.anexo_id#)
            </cfif>
			<cfif Len(Trim(arguments.documento_id))>
               and dv.documento_id in (#arguments.documento_id#)
            </cfif>
            order by da.ordem
        </cfquery>
        <cfreturn qr_result>
    </cffunction> 
    
	<!--- 
	-- PROPSITO 
	-- Busca os anexos
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="get_anexo" access="remote" returntype="query" output="true">
		<cfargument name="anexo_id" required="no" default="">
		<cfargument name="todos" required="no" default="0">
		<cfargument name="titulo" required="no" default="">
		<cfargument name="com_grupo" required="no" default="1">
         <cfset var raiz = this.get_anexo_grupo_raiz() />      
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select 
				<cfif arguments.com_grupo eq 1>
					distinct replace(replace(sys_connect_by_path(ag.descricao,'-/-'),'-/-','/')||'/','/Raiz/','/') as path,
				   upper(a.titulo) as titulo_upper,
				</cfif>
			       a.titulo,
				   a.anexo_id,
				   ag.descricao as grupo,
				   a.url,
				   a.permite_excluir,
				   a.user_insert,
				   a.grupo_id
			  from qualidade.v$anexo_grupo ag 
 			  left join qualidade.v$anexo a
					 on ag.grupo_id = a.grupo_id
			 where 1 = 1
			   and a.anexo_id is not null
			 <cfif arguments.todos eq 0>
			   and (a.permite_excluir = 1 or a.user_insert = user)
			 </cfif>
			 <cfif len(trim(arguments.titulo))>
			   and upper(a.titulo) like upper('%#arguments.titulo#%')
			 </cfif>
			 <cfif len(trim(arguments.anexo_id))>
			   and a.anexo_id = #arguments.anexo_id#
			 </cfif>
			<cfif arguments.com_grupo eq 1>
			 start with ag.grupo_id = #raiz.grupo_id#
			connect by prior ag.grupo_id = ag.grupo_pai_id
			 order siblings by upper(a.titulo)
 			</cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca os grupos de anexos
	-- CRISTOFER  11/05/2006
	--->		
	<cffunction name="get_anexo_grupo" access="remote" returntype="query" output="true">	   
        <cfset var raiz = this.get_anexo_grupo_raiz() />           
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select grupo_id,
				   grupo_pai_id,
				   nvl(grupo_pai_id,#raiz.grupo_id#) as grupo_pai_id_nvl,
				   descricao,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from qualidade.v$anexo_grupo	
			 where 1=1
			   and grupo_id <> #raiz.grupo_id#
		     start with grupo_pai_id = #raiz.grupo_id#
		   connect by prior grupo_id = grupo_pai_id
		     order siblings by descricao		 
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
    
    
    <!--- 
	-- PROPSITO 
	-- Busca os grupos de anexos raiz
	-- CRISTOFER  11/05/2006
	--->		
	<cffunction name="get_anexo_grupo_raiz" access="remote" returntype="query" output="true">	             
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select a.grupo_id
            	  ,a.descricao
              from qualidade.v$anexo_grupo a
             where a.grupo_pai_id is null			   
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	      
 	
    <!--- 
	-- PROPSITO
	-- Seleciona os emails d
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 20/07/2005 - criado
	--->
	<cffunction name="get_email" access="remote" returntype="query" output="false">	  
			<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">                
                <cfif session.site neq "bbm/" and session.site neq "rodomar/">
                    select pe.email_id,
                           pe.email_proprietario,
                           pe.email_obs,
                           em.email_completo as email_end,
                           pe.email_padrao,
                           f.cod_funcionario,
                           f.nome_funcionario,
                           f.cpf_funcionario,
                           f.cod_cargo,
                           oper.pkg_global.fnc_get_cod_pessoa_func(f.cod_funcionario) as cod_pessoa
                      from kss.v$pessoa_email pe
                     inner join kss.v$email em 
                        on em.email_id = pe.email_id
                     <cfif isdefined("session.site") and session.site eq "delpozo/">   
                         inner join rh.v$rh_funcionario f 
                            on f.cod_funcionario = pe.cod_pessoa
                     <cfelse>
                         inner join oper.v$rh_funcionario f 
                            on f.cod_pessoa = pe.cod_pessoa
                     </cfif>       
                 where 1 = 1
				 order by f.nome_funcionario
                 <cfelse>
                      select distinct pe.email_id,
                             pe.email_proprietario,
                             em.email_completo as email_end
                      from kss.v$pessoa_email pe
                     inner join kss.v$email em 
                        on em.email_id = pe.email_id
                     inner join kss.v$pessoa p 
                           on p.cod_pessoa = pe.cod_pessoa  
                     where 1 = 1
                     order by pe.email_proprietario
                 </cfif>
			</cfquery>  
		<cfreturn qr_result />
	</cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as verses_auditoria do documento
    -- MARIA 01/06/2011 - CRIADO
    --->		
    <cffunction name="get_documento_versao_auditoria" access="remote" returntype="query" output="true">
    	<cfargument name="versao_id" required="no" default="">
        <cfargument name="documento_id" required="no" default="">
        <cfargument name="num_versao" required="no" default="">
        <cfargument name="situacao_id" required="no" default="">
        <cfargument name="conteudo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
              select dva.auditoria_id
                   , dva.versao_id
                   , (select kss.pkg_pessoa.fnc_get_cliente(dv.cod_responsavel_validacao)
                        from dual
                       where dv.situacao_id = 4) as avaliado_por
                   , (select to_char(dv.date_insert,'dd/mm/yyyy')
                        from dual
                       where dv.situacao_id = 4) as avaliado_em
                   , dva.usuario_aprovacao
                   , (select ku.nome
                        from kss.v$kss_usuarios ku
                       where ku.usuario = dva.usuario_aprovacao) as nome_usuario_aprovacao
                   , to_char(dva.data_aprovacao,'dd/mm/yyyy') as data_aprovacao
                   , dva.usuario_reprovacao
                   , (select ku.nome
                        from kss.v$kss_usuarios ku
                       where ku.usuario = dva.usuario_reprovacao) as nome_usuario_reprovacao
                   , to_char(dva.data_reprovacao, 'dd/mm/yyyy') as data_reprovacao
                   , dva.motivo_reprovacao
                   , dva.user_insert
                   , to_char(dva.date_insert,'dd/mm/yyyy')  as date_insert
                   , dva.user_update
                   , to_char(dva.date_update,'dd/mm/yyyy')  as date_update
                   , dv.versao_id
                   , dv.num_versao
                   , dv.situacao_id
                   , dv.conteudo
                   , dv.observacao
                   , to_char(dv.date_update,'dd/mm/yyyy')  as data_versao
                   , d.documento_id
                   , d.tipo_documento_id
                   , d.versao_id_atual
                   , d.codigo
                   , d.titulo
                   , nvl2(dva.usuario_aprovacao, 'Aprovado','Reprovado') as situacao
              from qualidade.v$documento_versao_auditoria dva
             inner join qualidade.v$documento_versao dv on
             	 dv.versao_id = dva.versao_id
             inner join qualidade.v$documento d on
             	 d.documento_id = dv.documento_id
             left join kss.v$kss_usuarios ku on
             	ku.usuario = dva.usuario_aprovacao
             where 1 = 1
			<cfif Len(Trim(arguments.versao_id))>
               and dva.versao_id in (#arguments.versao_id#)
            </cfif>		
			<cfif Len(Trim(arguments.documento_id))>
               and d.documento_id in (#arguments.documento_id#)
            </cfif>		
            <cfif Len(Trim(arguments.documento_id))>
               and dva.usuario_aprovacao is not null
            </cfif>	
             order by dva.date_insert
        </cfquery>
        <cfreturn qr_result>
    </cffunction> 			
	
    <!--- 
    -- PROPSITO 
    -- Retorna as impresses do documento
    -- MARIA 01/06/2011 - CRIADO
    --->		
    <cffunction name="get_documento_impressao" access="remote" returntype="query" output="true">
    	<cfargument name="impressao_id" required="no" default="">
        <cfargument name="documento_id" required="no" default="">
        <cfargument name="localizacao_impressao_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select i.impressao_id
                 , i.documento_id
                 , i.localizacao_impressao_id
                 , to_char(i.data_impressao,'dd/mm/yyyy') as data_impressao                 
                 , i.user_insert
                 , l.descricao as localizacao
              from qualidade.v$impressao i
              inner join qualidade.v$documento d
              		on d.documento_id = i.documento_id
              inner join qualidade.v$localizacao_impressao l
              		on l.localizacao_impressao_id = i.localizacao_impressao_id     
             where 1 = 1
			<cfif Len(Trim(arguments.impressao_id))>
               and i.impressao_id in (#arguments.impressao_id#)
            </cfif>
			<cfif Len(Trim(arguments.documento_id))>
               and i.documento_id in (#arguments.documento_id#)
            </cfif>
            <cfif Len(Trim(arguments.localizacao_impressao_id))>
               and i.localizacao_impressao_id in (#arguments.localizacao_impressao_id#)
            </cfif>
             order by i.impressao_id
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna ...
    -- ANDERSON 99/99/2010 - CRIADO
    --->		
    <cffunction name="get_produtos_perigosos" access="remote" returntype="query" output="true">
    	<cfargument name="mes_inicial" required="yes" />
        <cfargument name="ano_inicial" required="yes" />
        <cfargument name="mes_final" required="yes" />
        <cfargument name="ano_final" required="yes" />
        <cfargument name="cod_pessoa_filial" required="yes" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.classificacao
                 , nvl(sum(t.quantidade), 0) as quantidade
                 , (select un.unidade
                      from kss.v$unidade_medida un
                     where un.cod_unidade = t.cod_unidade
                   ) as unidade
                 , nvl(sum(t.km_percorrido), 0) as km_percorrido
                 , '' as ocorrencia
                 , '' as observacoes
                 , to_char(to_date('#arguments.mes_inicial#/#arguments.ano_inicial#', 'mm/yyyy'), 'Month/yyyy') as periodo_inicial
                 , to_char(last_day(to_date('#arguments.mes_final#/#arguments.ano_final#', 'mm/yyyy')), 'Month/yyyy') as periodo_final
              from (
                    select n.descricao as classificacao
                         , nvl(sum(cnf.peso), 0) as quantidade
                         , cnf.cod_unidade
                         , c.km_rota as km_percorrido
                      from fiscal.v$conhecimento c
                     inner join fiscal.v$conhecimento_nota_fiscal cnf
                             on cnf.conhecimento_id = c.conhecimento_id
                     inner join oper.v$natureza n
                             on n.num_natureza = cnf.num_natureza
                     where c.situacao_id = 0
                       and trunc(c.data_emissao) between to_date('#arguments.mes_inicial#/#arguments.ano_inicial#', 'mm/yyyy') and last_day(to_date('#arguments.mes_final#/#arguments.ano_final#', 'mm/yyyy'))
                       and c.cod_pessoa_filial = #arguments.cod_pessoa_filial#
                     group by n.descricao
                            , cnf.cod_unidade
                            , c.km_rota
                     
                     union all
                    
                    select n.descricao as classificacao
                         , nvl(sum(ci.peso_bruto), 0) as quantidade
                         , ci.unidade_id as cod_unidade
                         , (select max(r.distancia_padrao) keep(dense_rank first order by r.origem_cod_pessoa nulls last, r.destino_cod_pessoa nulls last)
                              from fiscal.v$intc_conhecimento c2
                             inner join cep.municipio mo
                                     on mo.municipio_id = c2.resp_municipio_id
                             inner join cep.municipio md
                                     on md.municipio_id = c2.entrega_municipio_id
                             inner join oper.v$rota r
                                     on r.referencia_origem_id = mo.referencia_id
                                    and r.referencia_destino_id = md.referencia_id
                                    and (r.origem_cod_pessoa = c2.cod_remetente or r.origem_cod_pessoa is null)
                                    and (r.destino_cod_pessoa = c2.cod_destinatario or r.destino_cod_pessoa is null)
                             where c2.conhecimento_id = c.conhecimento_id
                           ) as km_percorrido
                      from fiscal.v$intc_conhecimento c
                     inner join fiscal.v$intc_conhecimento_item ci
                             on ci.conhecimento_id = c.conhecimento_id
                     inner join oper.v$natureza n
                             on n.num_natureza = ci.produto_id
                     where c.cancelado = 0
                       and trunc(c.emissao_data) between to_date('#arguments.mes_inicial#/#arguments.ano_inicial#', 'mm/yyyy') and last_day(to_date('#arguments.mes_final#/#arguments.ano_final#', 'mm/yyyy'))
                       and c.cod_pessoa_filial = #arguments.cod_pessoa_filial#
                     group by n.descricao
                            , ci.unidade_id
                            , c.conhecimento_id
                   ) t
             group by t.classificacao
                    , t.cod_unidade
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
	<!--- 
    -- PROPSITO 
    -- Retorna os cabealhos
    -- JAQUELINE 22/08/2012 - CRIADO
    --->		
    <cffunction name="get_cabecalho" access="remote" returntype="query" output="true">
    	<cfargument name="titulo" required="no" default="">
        <cfargument name="cabecalho_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select c.cabecalho_id
                 , c.versao_id_atual
                 , c.titulo
                 , c.user_insert                 
                 , to_char(c.date_insert,'dd/mm/yyyy')  as date_insert
                 , c.user_update
                 , to_char(c.date_update,'dd/mm/yyyy')  as date_update                
                 , cv.cabecalho_versao_id
                 , cv.num_versao
                 , cv.conteudo
                 , cv.date_insert as data_versao
               from qualidade.v$cabecalho c
              inner join qualidade.v$cabecalho_versao cv
              	on cv.cabecalho_versao_id = c.versao_id_atual     
             where 1 = 1
			<cfif Len(Trim(arguments.cabecalho_id))>
               and c.cabecalho_id in (#arguments.cabecalho_id#)
            </cfif>
            <cfif Len(Trim(arguments.titulo))>
               and upper(c.titulo) like upper('%#arguments.titulo#%')
            </cfif>
             order by c.cabecalho_id, cv.num_versao desc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

<!--- 
    -- PROPSITO 
    -- Retorna as verses do cabealho
    -- JAQUELINE 22/08/2012 - CRIADO
    --->		
    <cffunction name="get_cabecalho_versao" access="remote" returntype="query" output="true">
    	<cfargument name="versao_id" required="no" default="">
        <cfargument name="cabecalho_id" required="no" default="">
        <cfargument name="num_versao" required="no" default="">
        <cfargument name="conteudo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cv.cabecalho_versao_id
                 , cv.cabecalho_id
                 , cv.num_versao
                 , cv.conteudo
                 , cv.user_insert
                 , to_char(cv.date_insert,'dd/mm/yyyy')  as date_insert
                 , cv.user_update
                 , to_char(cv.date_update,'dd/mm/yyyy')  as date_update
                 , c.versao_id_atual
                 , c.titulo
              from qualidade.v$cabecalho_versao cv
              inner join qualidade.v$cabecalho c
              	on c.cabecalho_id = cv.cabecalho_id
             where 1 = 1
			<cfif Len(Trim(arguments.cabecalho_versao_id))>
               and cv.cabecalho_versao_id in (#arguments.cabecalho_versao_id#)
            </cfif>
			<cfif Len(Trim(arguments.cabecalho_id))>
               and cv.cabecalho_id in (#arguments.cabecalho_id#)
            </cfif>
			<cfif Len(Trim(arguments.num_versao))>
               and cv.num_versao in (#arguments.num_versao#)
            </cfif>
            <cfif Len(Trim(arguments.conteudo))>
               and cv.conteudo like '%#arguments.conteudo#%'
            </cfif>
             order by cv.cabecalho_versao_id
        </cfquery>
        <cfreturn qr_result>
    </cffunction> 

	<!--- 
    -- PROPSITO 
    -- Retorna os rodaps
    -- JAQUELINE 23/08/2012 - CRIADO
    --->		
    <cffunction name="get_rodape" access="remote" returntype="query" output="true">
    	<cfargument name="titulo" required="no" default="">
        <cfargument name="rodape_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.rodape_id
                 , r.versao_id_atual
                 , r.titulo
                 , r.user_insert                 
                 , to_char(r.date_insert,'dd/mm/yyyy')  as date_insert
                 , r.user_update
                 , to_char(r.date_update,'dd/mm/yyyy')  as date_update                
                 , rv.rodape_versao_id
                 , rv.num_versao
                 , rv.conteudo
                 , rv.date_insert as data_versao
               from qualidade.v$rodape r
              inner join qualidade.v$rodape_versao rv
              	on rv.rodape_versao_id = r.versao_id_atual     
             where 1 = 1
			<cfif Len(Trim(arguments.rodape_id))>
               and r.rodape_id in (#arguments.rodape_id#)
            </cfif>
            <cfif Len(Trim(arguments.titulo))>
               and upper(r.titulo) like upper('%#arguments.titulo#%')
            </cfif>
             order by r.rodape_id, date_insert desc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

<!--- 
    -- PROPSITO 
    -- Retorna as verses do rodap
    -- JAQUELINE 23/08/2012 - CRIADO
    --->		
    <cffunction name="get_rodape_versao" access="remote" returntype="query" output="true">
    	<cfargument name="versao_id" required="no" default="">
        <cfargument name="rodape_id" required="no" default="">
        <cfargument name="num_versao" required="no" default="">
        <cfargument name="conteudo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select rv.rodape_versao_id
                 , rv.rodape_id
                 , rv.num_versao
                 , rv.conteudo
                 , rv.user_insert
                 , to_char(rv.date_insert,'dd/mm/yyyy')  as date_insert
                 , rv.user_update
                 , to_char(rv.date_update,'dd/mm/yyyy')  as date_update
                 , r.versao_id_atual
                 , r.titulo
              from qualidade.v$rodape_versao rv
              inner join qualidade.v$rodape r
              	on r.rodape_id = rv.rodape_id
             where 1 = 1
			<cfif Len(Trim(arguments.rodape_versao_id))>
               and rv.rodape_versao_id in (#arguments.rodape_versao_id#)
            </cfif>
			<cfif Len(Trim(arguments.rodape_id))>
               and rv.rodape_id in (#arguments.rodape_id#)
            </cfif>
			<cfif Len(Trim(arguments.num_versao))>
               and rv.num_versao in (#arguments.num_versao#)
            </cfif>
            <cfif Len(Trim(arguments.conteudo))>
               and rv.conteudo like '%#arguments.conteudo#%'
            </cfif>
             order by rv.rodape_versao_id
        </cfquery>
        <cfreturn qr_result>
    </cffunction> 
    
    <!--- 
    -- PROPSITO 
    -- Verificar se o usurio tem pendncias de reviso de documentos no mdulo de qualidade
    -- JAQUELINEF 04/12/2012 - CRIADO
    --->		
    <cffunction name="verifica_usuario_pendencias" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select count(1) as qtde_pendencias
              from qualidade.v$documento_versao dv
			 where dv.situacao_id = 2
			   and (dv.cod_responsavel_aprovacao = #session.cod_pessoa_usuario# 
                or dv.cod_responsavel_validacao = #session.cod_pessoa_usuario#)
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
	<!--- 
        -- PROPSITO 
        -- Busca Visualizaes dos documentos
        -- JAQUELINE 05/12/2012 - CRIADO
        --->		
    <cffunction name="get_visualizacao_documento" access="remote" returntype="query" output="true">
    	<cfargument name="versao_id" required="no" default="">
        <cfargument name="usuario" required="no" default="">
        <cfargument name="data_inicial" required="no" default="">
        <cfargument name="data_final" required="no" default="">
        <cfargument name="tipo_id" required="no" default="">
        <cfargument name="documento_id" required="no" default="">        
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select usuario
                 , d.codigo
                 , d.documento_id
                 , dv.num_versao
                 , d.titulo
                 , to_char(vd.data_visualizacao, 'dd/mm/yyyy') as data_visualizacao
                 , (d.codigo||d.documento_id||'/'||dv.num_versao) as cod_doc
              from qualidade.v$visualizacao_documento vd
        inner join qualidade.v$documento_versao dv
                on dv.versao_id = vd.versao_documento_id
        inner join qualidade.v$documento d
                on d.documento_id = dv.documento_id
             where 1=1
			<cfif Len(Trim(arguments.versao_id))>             
               and vd.versao_documento_id = #arguments.versao_id#
            </cfif>
            <cfif Len(Trim(arguments.usuario))>               
               and upper(vd.usuario) like upper('#arguments.usuario#')
            </cfif>
            <cfif Len(Trim(arguments.tipo_id))>               
               and d.tipo_documento_id = #arguments.tipo_id#
            </cfif>
            <cfif Len(Trim(arguments.documento_id))>               
               and d.documento_id = #arguments.documento_id#
            </cfif>
            <cfif Len(Trim(arguments.data_inicial))>               
               and vd.data_visualizacao >= to_date('#arguments.data_inicial#', 'dd/mm/yyyy')
            </cfif>
            <cfif Len(Trim(arguments.data_final))>               
               and vd.data_visualizacao <= to_date('#arguments.data_final#', 'dd/mm/yyyy hh24:mi:ss')
            </cfif>               
            order by vd.data_visualizacao desc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>     

	<!--- 
        -- PROPSITO 
        -- Busca responsveis por aprovao de documentos
        -- JAQUELINE 05/12/2012 - CRIADO
        --->		
    <cffunction name="get_responsavel_aprovacao" access="remote" returntype="query" output="true">
    	<cfargument name="responsavel_aprovacao_id" required="no" default="">
        <cfargument name="usuario" required="yes" default="">
        <cfargument name="email" required="no" default=""> 
        <cfargument name="cod_pessoa" required="no" default="">    
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ra.usuario
                 , ra.email
                 , ra.responsavel_aprovacao_id
                 , u.cod_pessoa
                 , u.nome
              from qualidade.v$responsavel_aprovacao ra  
		inner join kss.v$usuarios u          
                on u.usuario = ra.usuario              
             where 1=1
			<cfif Len(Trim(arguments.responsavel_aprovacao_id))>             
               and ra.responsavel_aprovacao_id = #arguments.responsavel_aprovacao_id#
            </cfif>
            <cfif Len(Trim(arguments.usuario))>               
               and upper(u.usuario) like upper('#arguments.usuario#')
            </cfif>
            <cfif Len(Trim(arguments.email))>               
               and ra.email = #arguments.email#
            </cfif>   
            <cfif Len(Trim(arguments.cod_pessoa))>               
               and u.cod_pessoa = #arguments.cod_pessoa#
            </cfif>                         
            order by ra.usuario
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <cffunction name="get_tipo_documento_ext" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
           select cg.rv_low_value as valor 
                , cg.rv_abbreviation as DOC_TIPO
             from kss.cg_ref_codes cg
            where cg.owner = 'QUALIDADE'
              and cg.rv_domain = 'DOCUMENTO.FORMATO'
        </cfquery>
        <cfreturn qr_result>
    </cffunction>   
  
   <cffunction name="get_documento_protecao" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
           select cg.rv_low_value as valor
                , cg.rv_abbreviation as protecao 
             from kss.cg_ref_codes cg
            where cg.owner = 'QUALIDADE'
              and cg.rv_domain = 'DOCUMENTO.PROTECAO'
             order by cg.rv_abbreviation
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
     <cffunction name="get_documento_descarte" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cg.rv_low_value as valor
      			 , cg.rv_abbreviation as descarte 
		      from kss.cg_ref_codes cg
			 where cg.owner = 'QUALIDADE'
			   and cg.rv_domain = 'DOCUMENTO.DESCARTE'
			 order by cg.rv_abbreviation
        </cfquery>
        <cfreturn qr_result>
    </cffunction>  
    
     <cffunction name="get_documento_tempo_retencao" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
             select cg.rv_low_value as valor
      			  , cg.rv_abbreviation as tempo_retencao 
               from kss.cg_ref_codes cg
              where cg.owner = 'QUALIDADE'
                and cg.rv_domain = 'DOCUMENTO.TEMPO_RETENCAO'
              order by cg.rv_low_value
        </cfquery>
        <cfreturn qr_result>
    </cffunction> 
  
    <cffunction name="get_documento_recuperacao" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cg.rv_low_value as valor
                 , cg.rv_abbreviation as recuperacao 
              from kss.cg_ref_codes cg
             where cg.owner = 'QUALIDADE'
               and cg.rv_domain = 'DOCUMENTO.RECUPERACAO'
             order by cg.rv_low_value
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <cffunction name="get_aplicabilidade" access="remote" returntype="query" output="true">
        <cfargument name="documento_id" required="no" default="">
           <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
           select ar.email
                , ar.descricao
                , a.aplicabilidade_id
                , a.documento_id
                , a.area_id
             from qualidade.v$aplicabilidade a
            inner join qualidade.v$area ar
               on ar.area_id = a.area_id
            where 1=1
		<cfif Len(Trim(arguments.documento_id))>             
           and a.documento_id = #arguments.documento_id#
        </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Busca os dados da empresa
    -- Lukas Jacomin 17/10/2014 - CRIADO
    --->		
    <cffunction name="get_empresa" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">        
            select e.razao_social
                 , e.razao_social_resumida
                 , e.nome_fantasia
                 , e.cod_pessoa
                 , e.inscricao_estadual
                 , e.inscricao_municipal
                 , coalesce((select l1.logotipo from qualidade.documento_logotipo l1), e.logotipo) as logotipo
              from kss.v$empresa e
             inner join kss.v$pessoa p
                on p.cod_pessoa = e.cod_pessoa
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os dados da empresa
    -- Lukas Jacomin 21/10/2014 - CRIADO
    --->		
    <cffunction name="get_info_lista_mestre" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">        
            select (select cg.rv_low_value
                      from kss.cg_ref_codes cg
                     where upper(cg.owner) = 'QUALIDADE'
                       and upper(cg.rv_domain) = 'DOCUMENTO.CODIGO_LISTA_MESTRE'
                       and upper(cg.rv_meaning) = upper('D.QUA.01-04')) as codigo
              from dual
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

 
</cfcomponent>