<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO 
    -- Retorna os requisitos de avaliao de fornecedor
    -- JAQUELINEF 10/12/2012 - CRIADO
    --->		
    <cffunction name="get_requisitos" access="remote" returntype="query" output="true">
    	<cfargument name="requisito_id" required="no" default="">
        <cfargument name="descricao" required="no" default="">       
        <cfargument name="fornecedor_id" required="no" default="">      
        <cfargument name="ramo_atividade_id" required="no" default="">      
        <cfargument name="status" required="no" default="">                
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select distinct raf.requisito_id
                 , raf.descricao
                 , raf.status
              from qualidade.v$requisito_avaliacao raf
         left join qualidade.v$fornecedor_requisito fr
                on fr.requisito_id = raf.requisito_id
             where 1 = 1
			<cfif Len(Trim(arguments.requisito_id))>
               and raf.requisito_id in (#arguments.requisito_id#)
            </cfif>
			<cfif Len(Trim(arguments.fornecedor_id))>
               and fr.fornecedor_id in (#arguments.fornecedor_id#)
            </cfif>            
            <cfif Len(Trim(arguments.descricao))>
               and upper(raf.descricao) like upper('%#arguments.descricao#%')
            </cfif> 
			<cfif Len(Trim(arguments.status))>
               and raf.status = #arguments.status#
            </cfif>         
             order by raf.descricao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
	<!--- 
    -- PROPSITO 
    -- Retorna os requisitos do ramo de atividade
    -- MARIALICE 22/09/204
    --->		
    <cffunction name="get_requisitos_area" access="remote" returntype="query" output="true">
    	<cfargument name="requisito_id" required="no" default="">
        <cfargument name="descricao" required="no" default="">       
        <cfargument name="ramo_atividade_id" required="no" default="">      
        <cfargument name="status" required="no" default="">                
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
             select raf.requisito_id
                  , raf.descricao
                  , raf.status
                  , r.ramo_atividade_id
                  , r.ramo_atividade_requisito_id
              from qualidade.v$requisito_avaliacao raf
             inner join qualidade.v$ramo_atividade_requisito r on r.requisito_id =
                                                                  raf.requisito_id
             where 1 = 1
			<cfif Len(Trim(arguments.requisito_id))>
               and raf.requisito_id in (#arguments.requisito_id#)
            </cfif>
			<cfif Len(Trim(arguments.ramo_atividade_id))>
               and r.ramo_atividade_id in (#arguments.ramo_atividade_id#)
            </cfif>            
            <cfif Len(Trim(arguments.descricao))>
               and upper(raf.descricao) like upper('%#arguments.descricao#%')
            </cfif> 
			<cfif Len(Trim(arguments.status))>
               and raf.status = #arguments.status#
            </cfif>         
             order by raf.descricao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
	<!--- 
    -- PROPSITO 
    -- Retorna os fornecedores
    -- JAQUELINEF 10/12/2012 - CRIADO
    --->		
    <cffunction name="get_fornecedores" access="remote" returntype="query" output="true">
    	<cfargument name="fornecedor_id" required="no" default="">
        <cfargument name="nome" required="no" default=""> 
        <cfargument name="razao" required="no" default=""> 
        <cfargument name="contato" required="no" default="">                   
        <cfargument name="cnpj" required="no" default="">                
        <cfargument name="cnpjl" required="no" default="">                

        <cfargument name="status_id" required="no" default="">               
        <cfargument name="qualificado" required="no" default="">             
        <cfargument name="ramo_atividade_id" required="no" default="">                    
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select f.fornecedor_id   
                 , f.razao_social    
                 , f.nome_fantasia   
                 , f.cnpj            
                 , f.endereco   
                 , f.residuos       
                 , f.produtos    
                 , f.contato
                 , f.setor
                 , f.centro_custo
                 , f.cod_pessoa_filial
                 , f.status_id  
                 , f.qualificado
                 , f.ramo_atividade_id
                 , f.cod_pessoa
                 , kss.pkg_string.fnc_formata_cnpj_cpf(f.cnpj) as cnpj_f
                 , p.cod_pessoa
                 , p.cliente as filial
              from qualidade.v$fornecedor f
             inner join kss.v$pessoa p on p.cod_pessoa = f.cod_pessoa_filial
                        <cfif Len(Trim(arguments.fornecedor_id))>
               and f.fornecedor_id in (#arguments.fornecedor_id#)
            </cfif>
			<cfif Len(Trim(arguments.cnpj))>
               and f.cnpj = '#arguments.cnpj#'
            </cfif>            
            <cfif Len(Trim(arguments.nome))>
               and upper(f.nome_fantasia) like upper('%#arguments.nome#%')
            </cfif> 
            <cfif Len(Trim(arguments.razao))>
               and upper(f.razao_social) like upper('%#arguments.razao#%')
            </cfif>   
            <cfif Len(Trim(arguments.contato))>
               and upper(f.contato) like upper('%#arguments.contato#%')
            </cfif>                        
            <cfif Len(Trim(arguments.cnpjl))>
               and f.cnpj like '%#arguments.cnpjl#%'
            </cfif>                         
            <cfif Len(Trim(arguments.status_id))>
               and f.status_id = #arguments.status_id#
            </cfif>                         
            <cfif Len(Trim(arguments.qualificado))>
               and f.qualificado = #arguments.qualificado#
            </cfif>                          
            <cfif Len(Trim(arguments.ramo_atividade_id))>
               and f.ramo_atividade_id in (#arguments.ramo_atividade_id#)
            </cfif>                         
             order by f.nome_fantasia
        </cfquery>
        <cfreturn qr_result>
    </cffunction>   
    
	<!--- 
    -- PROPSITO 
    -- Retorna os produtos
    -- JAQUELINEF 11/12/2012 - CRIADO
    --->		
    <cffunction name="get_produtos" access="remote" returntype="query" output="true">
    	<cfargument name="produto_id" required="no" default="">
        <cfargument name="produto" required="no" default="">      
    	<cfargument name="fornecedor_id" required="no" default="">  
        <cfargument name="vinculados" required="no" default="">           
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select p.produto_id
                 , p.descricao as produto
              from oper.v$produto p
			<cfif Len(Trim(arguments.vinculados))>
         inner join qualidade.v$fornecedor_produto fp
           <cfelse> 
         left join qualidade.v$fornecedor_produto fp
           </cfif> 
                on fp.produto_id = p.produto_id
             where 1 = 1
			<cfif Len(Trim(arguments.produto_id))>
               and p.produto_id in (#arguments.produto_id#)
            </cfif>
			<cfif Len(Trim(arguments.fornecedor_id))>
               and fp.fornecedor_id in (#arguments.fornecedor_id#)
            </cfif>             
            <cfif Len(Trim(arguments.produto))>
               and upper(p.descricao) like upper('%#arguments.produto#%')
            </cfif>            
             order by p.produto_id
        </cfquery>
        <cfreturn qr_result>
    </cffunction>       
    
	<!--- 
    -- PROPSITO 
    -- Retorna os documentos dos fornecedores
    -- JAQUELINEF 11/12/2012 - CRIADO
    --->		
    <cffunction name="get_documentos" access="remote" returntype="query" output="true"> 
    	<cfargument name="fornecedor_id" required="no" default="">          
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select d.nome
                 , to_char(d.vencimento,'dd/mm/yyyy') as vencimento
                 , d.documento_id
                 , d.doc_anexo_id      
                 , a.titulo   as anexo_titulo
                 , a.url      as anexo_url
              from qualidade.v$fornecedor_documento d
              left join qualidade.v$anexo a
                on a.anexo_id = d.doc_anexo_id
             where 1 = 1
			<cfif Len(Trim(arguments.fornecedor_id))>
               and d.fornecedor_id in (#arguments.fornecedor_id#)
            </cfif>                        
             order by d.nome
        </cfquery>
        <cfreturn qr_result>
    </cffunction>  
    
	<!--- 
    -- PROPSITO 
    -- Retorna as avaliaes
    -- JAQUELINEF 12/12/2012 - CRIADO
    --->		
    <cffunction name="get_avaliacoes" access="remote" returntype="query" output="true"> 
    	<cfargument name="fornecedor_id" required="no" default="">
    	<cfargument name="cod_pessoa_filial" required="no" default="">       
    	<cfargument name="classif" required="no" default="">
    	<cfargument name="data_i" required="no" default="">                                
    	<cfargument name="data_f" required="no" default="">       
    	<cfargument name="vencido" required="no" default="">       
    	<cfargument name="qualificado" required="no" default="">     
    	<cfargument name="ramo_atividade_id" required="no" default=""> 
    	<cfargument name="setor" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select avaliacao_id,
                   observacao,
                   nome,
                   status,
                   vencido,
                   vencido_ano,
                   data_ultima_avaliacao,
                   total_pontos,
                   to_char(data_avaliacao, 'dd/mm/yyyy') as data_avaliacao,
                   total_pontos_porc,
                   classificacao,
                   classif,
                   fornecedor_id,
                   razao_social,
                   nome_fantasia,
                   cnpj,
                   cnpj_f,
                   contato,
                   endereco,
                   residuos,
                   produtos,
                   cod_pessoa_filial,
                  (select rv_meaning
	                 from kss.cg_ref_codes
                    where rv_domain = 'FORNECEDOR.SETOR'
	                  and owner = 'QUALIDADE' and rv_low_value = setor) as setor,
                   centro_custo,
                   status_id,
                   qualificado,
                   ramo_atividade_id,
                   cod_pessoa,
                   filial,
                   n_avaliacao
              from (select avaliados.avaliacao_id,
                           avaliados.observacao,
                           avaliados.nome,
                           (case
                             when avaliados.data_vencimento < sysdate or
                                  avaliados.data_vencimento is null then
                              'Pendente'
                             else
                              'Avaliado'
                           end) as status,
                           (case
                             when avaliados.data_vencimento < sysdate or
                                  avaliados.data_vencimento is null then
                              1
                             else
                              0
                           end) as vencido,
                           (case
                             when avaliados.data_vencimento_ano < sysdate or
                                  avaliados.data_vencimento_ano is null then
                              1
                             else
                              0
                           end) as vencido_ano,
                           nvl(to_char(avaliados.data_ultima_avaliacao, 'dd/mm/yyyy'),
                               'NO AVALIADO') as data_ultima_avaliacao,
                           nvl(avaliados.total_pontos, 0) as total_pontos,
                           avaliados.data_avaliacao,
                           avaliados.n_avaliacao,
                           nvl(avaliados.total_pontos_porc, 0) as total_pontos_porc,
                           nvl((select rv_meaning
                                 from kss.cg_ref_codes cg
                                where cg.owner = 'QUALIDADE'
                                  and cg.rv_domain = 'FORNECEDOR.CLASSIFICACAO'
                                  and ((avaliados.total_pontos_porc >= cg.rv_low_value and
                                      avaliados.total_pontos_porc <= cg.rv_high_value) or
                                      (avaliados.total_pontos_porc = 0 and
                                      cg.rv_low_value = 0))),
                               'No Avaliado') as classificacao,
                           (select rv_abbreviation
                              from kss.cg_ref_codes cg
                             where cg.owner = 'QUALIDADE'
                               and cg.rv_domain = 'FORNECEDOR.CLASSIFICACAO'
                               and ((avaliados.total_pontos_porc >= cg.rv_low_value and
                                   avaliados.total_pontos_porc <= cg.rv_high_value) or
                                   (avaliados.total_pontos_porc = 0 and
                                   cg.rv_low_value = 0))) as classif,
                           f_dados.fornecedor_id,
                           f_dados.razao_social,
                           f_dados.nome_fantasia,
                           f_dados.cnpj,
                           kss.pkg_string.fnc_formata_cnpj_cpf(f_dados.cnpj) as cnpj_f,
                           f_dados.contato,
                           f_dados.endereco,
                           f_dados.residuos,
                           f_dados.produtos,
                           f_dados.cod_pessoa_filial,
                           f_dados.setor,
                           f_dados.centro_custo,
                           f_dados.status_id,
                           f_dados.qualificado,
                           f_dados.ramo_atividade_id,
                           f_dados.cod_pessoa,
                           p.cliente as filial
                      from qualidade.v$fornecedor f_dados
                      left join (select av.avaliacao_id,
                                       av.fornecedor_id,
                                       av.observacao,
                                       av.avaliador,
                                       av.email_gerado,
                                       av.data_avaliacao,
                                       av.total_pontos,
                                       av.n_avaliacao,
                                       av.data_vencimento,
                                       av.data_vencimento_ano,
                                       av.data_ultima_avaliacao,
                                       av.nome,
                                       (total_pontos * 100 / total_pontos_requisitos) as total_pontos_porc
                                  from (select f.avaliacao_id,
            
                                               f.fornecedor_id,
                                               f.observacao,
                                               f.avaliador,
                                               f.email_gerado,
                                               f.data_avaliacao,
                                               f.data_vencimento,
                                               f.data_vencimento_ano,
                                               ku.nome,
                                               (select sum(fr.pontos)
                                                  from qualidade.v$fornecedor_avaliacao_req fr
                                                 where fr.avaliacao_id = f.avaliacao_id) as total_pontos,                                               
                                               (select count(fr.requisito_id) * 10
                                                   from qualidade.v$fornecedor_avaliacao_req fr
                                                  where fr.avaliacao_id = f.avaliacao_id) as total_pontos_requisitos,
                                               count(f.avaliacao_id) over(partition by f.fornecedor_id) as n_avaliacao,
                                               max(f.data_avaliacao) over(partition by f.fornecedor_id) as data_ultima_avaliacao
                                          from qualidade.v$fornecedor_avaliacao f
                                         inner join kss.v$usuarios ku on f.avaliador =
                                                                         ku.usuario) av
                                 where data_ultima_avaliacao = data_avaliacao) avaliados on f_dados.fornecedor_id =
                                                                                            avaliados.fornecedor_id
                    
                     inner join kss.v$pessoa p on p.cod_pessoa =
                                                  f_dados.cod_pessoa_filial)
             where 1=1  
               and status_id = 1  
			<cfif Len(Trim(arguments.fornecedor_id))>
               and fornecedor_id = #arguments.fornecedor_id#
            </cfif> 
			<cfif Len(Trim(arguments.cod_pessoa_filial))>
               and cod_pessoa_filial = #arguments.cod_pessoa_filial#
            </cfif>     
			<cfif Len(Trim(arguments.classif))>
               and classif = '#arguments.classif#'
            </cfif> 
			<cfif Len(Trim(arguments.data_i))>
               and data_avaliacao >= '#arguments.data_i#'
            </cfif>                                    
   			<cfif Len(Trim(arguments.data_f))>
               and data_avaliacao <= '#arguments.data_f#'
            </cfif> 
   			<cfif Len(Trim(arguments.vencido))>
               and vencido = #arguments.vencido#
            </cfif>  
   			<cfif Len(Trim(arguments.setor))>
               and setor = #arguments.setor#
            </cfif>             
   			<cfif Len(Trim(arguments.qualificado))>
               and qualificado = #arguments.qualificado#
            </cfif>        
   			<cfif Len(Trim(arguments.ramo_atividade_id))>
               and ramo_atividade_id = #arguments.ramo_atividade_id#
            </cfif> 
            order by total_pontos desc, cnpj
        </cfquery>
        <cfreturn qr_result>
    </cffunction>           
    
	<!--- 
    -- PROPSITO 
    -- Retorna as avaliaes de um fornecedor
    -- JAQUELINEF 14/12/2012 - CRIADO
    --->		
    <cffunction name="get_avaliacoes_fornecedor" access="remote" returntype="query" output="true"> 
    	<cfargument name="fornecedor_id" required="no" default="">                                              
    	<cfargument name="avaliacao_id" required="no" default="">        
    	<cfargument name="status_id" required="no" default="">                                                      
    	<cfargument name="qualificado" required="no" default="">                                                        
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
           select avaliados.avaliacao_id
                , avaliados.observacao
                , avaliados.nome
                , nvl(avaliados.total_pontos,0) as total_pontos
                , to_char(avaliados.data_avaliacao,'dd/mm/yyyy') as data_avaliacao
                , row_number() over( order by avaliados.avaliacao_id ) as n_avaliacao   
                , nvl((select rv_meaning 
                     from kss.cg_ref_codes  cg
                    where cg.owner = 'QUALIDADE' 
                      and cg.rv_domain = 'FORNECEDOR.CLASSIFICACAO'
                      and ((avaliados.total_pontos_porc >= cg.rv_low_value 
                      and avaliados.total_pontos_porc <= cg.rv_high_value) or (avaliados.total_pontos_porc = 0 and cg.rv_low_value = 0))
                   ), 'No Avaliado') as classificacao                          
                , f_dados.fornecedor_id
                , f_dados.razao_social
                , f_dados.nome_fantasia
                , f_dados.cnpj
                , kss.pkg_string.fnc_formata_cnpj_cpf(f_dados.cnpj) as cnpj_f
                , f_dados.contato
                , f_dados.endereco
                , f_dados.residuos
                , f_dados.produtos
                , f_dados.cod_pessoa_filial 
                , f_dados.setor 
                , f_dados.centro_custo
                , f_dados.status_id                               
                , f_dados.qualificado   
                , f_dados.cod_pessoa                               
             from ( select av.avaliacao_id
                              , av.fornecedor_id
                              , av.observacao
                              , av.avaliador 
                              , av.email_gerado
                              , av.data_avaliacao
                              , av.total_pontos
                              , av.n_avaliacao
                              , av.data_vencimento
                              , av.data_ultima_avaliacao   
                              , av.nome
                              ,(total_pontos*100/total_pontos_requisitos) as total_pontos_porc   
                          from(
                               select f.avaliacao_id
                                    , f.fornecedor_id
                                    , f.observacao
                                    , f.avaliador
                                    , f.email_gerado
                                    , f.data_avaliacao
                                    , f.data_vencimento  
                                    , ku.nome
                                    , (select sum(fr.pontos) 
                                         from qualidade.v$fornecedor_avaliacao_req fr 
                                        where fr.avaliacao_id = f.avaliacao_id
                                      ) as total_pontos
                                   , (select count(fr.requisito_id) * 10
                                       from qualidade.v$fornecedor_avaliacao_req fr
                                      where fr.avaliacao_id = f.avaliacao_id) as total_pontos_requisitos    
                                    , count(f.avaliacao_id) over (order by f.avaliacao_id,f.fornecedor_id) as n_avaliacao     
                                    , max(f.data_avaliacao) over(partition by f.fornecedor_id) as data_ultima_avaliacao
                                from qualidade.v$fornecedor_avaliacao f
                               inner join kss.v$usuarios ku
                                  on f.avaliador = ku.usuario
                              ) av        
                    ) avaliados
             inner join qualidade.v$fornecedor f_dados     
                on f_dados.fornecedor_id = avaliados.fornecedor_id                              
             where 1=1    
			<cfif Len(Trim(arguments.fornecedor_id))>
               and f_dados.fornecedor_id = #arguments.fornecedor_id#
            </cfif>  
			<cfif Len(Trim(arguments.avaliacao_id))>
               and avaliados.avaliacao_id = #arguments.avaliacao_id#
            </cfif>    
			<cfif Len(Trim(arguments.status_id))>
               and f_dados.status_id = #arguments.status_id#
            </cfif>             
			<cfif Len(Trim(arguments.qualificado))>
               and f_dados.qualificado = #arguments.qualificado#
            </cfif>                
             order by avaliados.avaliacao_id desc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>  
                 
	<!--- 
    -- PROPSITO 
    -- Retorna os requisitos de avaliao de fornecedor
    -- JAQUELINEF 10/12/2012 - CRIADO
    --->		
    <cffunction name="get_requisitos_avaliacao" access="remote" returntype="query" output="true">
    	<cfargument name="requisito_id" required="no" default="">
        <cfargument name="descricao" required="no" default="">       
        <cfargument name="avaliacao_id" required="no" default="">                
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select fr.requisito_id
                 , fr.descricao
                 , raf.pontos
              from qualidade.v$fornecedor_avaliacao_req raf
             inner join qualidade.v$requisito_avaliacao fr
                on fr.requisito_id = raf.requisito_id
             where 1 = 1
			<cfif Len(Trim(arguments.requisito_id))>
               and raf.requisito_id in (#arguments.requisito_id#)
            </cfif>
			<cfif Len(Trim(arguments.avaliacao_id))>
               and raf.avaliacao_id in (#arguments.avaliacao_id#)
            </cfif>            
            <cfif Len(Trim(arguments.descricao))>
               and upper(raf.descricao) like upper('%#arguments.descricao#%')
            </cfif>            
             order by fr.descricao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
	<!--- 
    -- PROPSITO 
    -- Retorna os emails do fornecedor
    -- MARIALICE 09/01/2013 - CRIADO
    --->		
    <cffunction name="get_fornecedor_emails" access="remote" returntype="query" output="true">
    	<cfargument name="fornecedor_id" required="no" default="">
        <cfargument name="email_id" required="no" default="">       
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select fe.email_id
                 , fe.fornecedor_id
                 , fe.proprietario
                 , fe.email_endereco
              from qualidade.v$fornecedor_email fe            
             where 1 = 1
			<cfif Len(Trim(arguments.fornecedor_id))>
               and fe.fornecedor_id in (#arguments.fornecedor_id#)
            </cfif>
			<cfif Len(Trim(arguments.email_id))>
               and fe.email_id in (#arguments.email_id#)
            </cfif> 
             order by fe.proprietario
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
	<!--- 
    -- PROPSITO 
    -- Retorna os ramos de atividades
    -- MARIALICE 22/09/2014 - CRIADO
    --->		
    <cffunction name="get_ramo_atividade" access="remote" returntype="query" output="true">
    	<cfargument name="ramo_atividade_id" required="no" default="">
    	<cfargument name="descricao" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.ramo_atividade_id
                 , r.descricao
              from qualidade.v$fornecedor_ramo_atividade r            
             where 1 = 1
			<cfif Len(Trim(arguments.ramo_atividade_id))>
               and r.ramo_atividade_id in (#arguments.ramo_atividade_id#)
            </cfif>
			<cfif Len(Trim(arguments.descricao))>
               and upper(r.descricao) like upper('%#arguments.descricao#%')
            </cfif>
             order by r.descricao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
	<!--- 
	-- PROPSITO 
	-- Busca parametro por identificador
    -- MARIALICE 22/09/2014 - CRIADO
	--->		
	<cffunction name="get_parametro_id" access="remote" returntype="string" output="true">
    	<cfargument name="identificador" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select kss.pkg_parametro.fnc_valor_numerico('#arguments.identificador#') valor from dual
		</cfquery>
		<cfreturn qr_result.valor>		
	</cffunction>
    
	<!--- 
	-- PROPSITO 
	-- Busca cg_ref_codes
    -- MARIALICE 22/09/2014 - CRIADO
	--->		
	<cffunction name="get_cg_ref_codes" access="remote" returntype="query" output="true">
    	<cfargument name="owner" required="yes">
    	<cfargument name="rv_domain" required="yes">
    	<cfargument name="rv_low_value" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cg.rv_domain, 
                   cg.rv_low_value, 
                   cg.rv_high_value, 
                   cg.rv_abbreviation, 
                   cg.rv_meaning,
                   cg.owner
              from kss.cg_ref_codes cg
             where 1=1
               and cg.owner = '#arguments.owner#'
               and cg.rv_domain = '#arguments.rv_domain#'
             <cfif len(trim(arguments.rv_low_value))>
               and cg.rv_low_value in (#arguments.rv_low_value#)
             </cfif>
             <cfif len(trim(arguments.order))>
               order by #arguments.order#
             <cfelse>  
             	order by cg.rv_low_value
             </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
            
</cfcomponent>