<cfcomponent extends="_transportes.funcoes.cfc_init">  
      <!--- 
    -- PROPSITO
    -- Busca dados da solicitao de pernoite 
    -- LEANDROR 23/07/2010 - criado
    --->	
    <cffunction name="get_solicitacao_pernoite" displayname="" output="true" returntype="query" access="remote">
    	<cfargument name="num_romaneio" required="no" default="">
        <cfargument name="nome_motorista" required="no" default="">
        <cfargument name="cod_veiculo" required="no" default="">
        <cfargument name="hora_solicitada_inicio" required="no" default="">
        <cfargument name="hora_solicitada_termino" required="no" default="">
        <cfargument name="solicitacao_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select x.solicitacao_id
            	 , x.motorista
                 , x.num_romaneio
                 , x.origem_destino
                 , x.placa_veiculo
                 , x.cod_veiculo
                 , x.veiculo_id
                 , x.cpf_motorista
                 , x.motorista
                 , x.cod_motorista
                 , x.motivo_solicitacao
                 , x.cod_solicitante
                 , x.cpf_solicitante
                 , x.solicitante
   			     , to_char(x.hora_solicitada_inicio, 'dd/mm/yyyy hh24:mi:ss') as hora_solicitada_inicio
   			     , to_char(x.hora_solicitada_termino, 'dd/mm/yyyy hh24:mi:ss') as hora_solicitada_termino
                 , x.status_atual
                 , x.data_autorizacao
                 , x.setor_autorizador
                 , x.autorizado                  
                 , to_char(x.date_insert, 'dd/mm/yyyy hh24:mi:ss') as data_solicitacao                 
             from
                 (
                  select s.solicitacao_id
   			     	   , s.hora_solicitada_inicio
                       , s.hora_solicitada_termino
                       , s.num_romaneio
                       , (select cep.fnc_municipio_uf(r.org_municipio_id) || ' - ' || cep.fnc_municipio_uf(r.dest_municipio_id)
                            from oper.v$romaneio r
                           where r.num_romaneio = s.num_romaneio) as origem_destino
                       ,  s.cod_solicitante
                       ,  (select p.cnpj_cpf
                     	     from kss.v$pessoa p
                            where p.cod_pessoa = s.cod_solicitante) as cpf_solicitante
                       ,  (select p.razao_social
                     	     from kss.v$pessoa p
                            where p.cod_pessoa = s.cod_solicitante) as solicitante
                       , s.motivo_solicitacao
                       , s.veiculo_id
                       , (select v.cod_veiculo
                            from oper.v$veiculo v
                           where v.veiculo_id = s.veiculo_id) as cod_veiculo
                       , (select v.placa
                            from oper.v$veiculo v
                           where v.veiculo_id = s.veiculo_id) as placa_veiculo                           
                       , s.cod_motorista
                       , (select p.cliente
                            from kss.v$pessoa p
                           where p.cod_pessoa = s.cod_motorista) as motorista
                       , (select p.cnpj_cpf
                            from kss.v$pessoa p
                           where p.cod_pessoa = s.cod_motorista) as cpf_motorista
  					   , case
                            when ap.setor_autorizador = 1 and ap.autorizado = 1 then 'Autorizado pelo CCO em ' || to_char(ap.data_autorizacao, 'dd/mm/yyyy') || ' s ' || to_char(ap.data_autorizacao, 'hh24:mi:ss')
                            when ap.setor_autorizador = 1 and ap.autorizado = 0 then 'Reprovado pelo CCO em '  || to_char(ap.data_autorizacao, 'dd/mm/yyyy')  || ' s ' || to_char(ap.data_autorizacao, 'hh24:mi:ss')
                            when ap.setor_autorizador = 2 and ap.autorizado = 1 then 'Autorizado pelo CGR em ' || to_char(ap.data_autorizacao, 'dd/mm/yyyy') || ' s ' || to_char(ap.data_autorizacao, 'hh24:mi:ss')
                            when ap.setor_autorizador = 2 and ap.autorizado = 0 then 'Reprovado pelo CGR em '  || to_char(ap.data_autorizacao, 'dd/mm/yyyy')  || ' s ' || to_char(ap.data_autorizacao, 'hh24:mi:ss')
                            else 'Pendente de Aprovao'
                            end status_atual
                       , ap.data_autorizacao
                       , ap.setor_autorizador
                       , ap.autorizado                                                                      
                       , s.date_insert
                    from logistica.v$solicitacao_pernoite s                                                
                    left join logistica.v$autorizacao_pernoite ap
                          on ap.solicitacao_id = s.solicitacao_id
                    ) x            
                   where 1 = 1                   
                     and nvl(x.data_autorizacao,sysdate) = (select nvl(max(data_autorizacao),sysdate)
                                                              from logistica.v$autorizacao_pernoite app
                                                             where app.solicitacao_id = x.solicitacao_id)
                  
             <cfif len(trim(arguments.num_romaneio))>
	               and x.num_romaneio = #arguments.num_romaneio#
             </cfif>
             <cfif len(trim(arguments.hora_solicitada_inicio))>
	               and x.hora_solicitada_inicio >= '#arguments.hora_solicitada_inicio#'
             </cfif>
             <cfif len(trim(arguments.hora_solicitada_termino))>
	               and x.hora_solicitada_termino <= '#arguments.hora_solicitada_termino#'
             </cfif>
             <cfif len(trim(arguments.nome_motorista))>
	               and upper(x.motorista) like upper('#arguments.nome_motorista#%')
             </cfif>
             <cfif len(trim(arguments.cod_veiculo))>
	               and upper(x.cod_veiculo) like upper('#arguments.cod_veiculo#')
             </cfif>
             <cfif len(trim(arguments.solicitacao_id))>
	               and x.solicitacao_id = #arguments.solicitacao_id#
             </cfif>
             order by x.hora_solicitada_inicio, x.num_romaneio
        </cfquery>
        <cfreturn qr_result>
    </cffunction>  
</cfcomponent>    