<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO 
    -- Retorna os Dados dos Veiculos
    -- RAFAEL 23/06/2010 - CRIADO
    --->		
    <cffunction name="get_veiculos" access="remote" returntype="query" output="true">
        <cfargument name="idmensageminicial" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select vmm.veiculo_motorista_monit_id
                 , vmm.veiculo_monitoramento_id
                 , vmm.veiculo_id
                 , vmm.placa
                 , vmm.nome_motorista
                 , vmm.cpf
                 , vmm.celular
              from integracao.v$veiculo_motorista_monit vmm
             where 1 = 1             
			<cfif Len(Trim(arguments.idmensageminicial))>
               and vmm.veiculo_motorista_monit_id > #arguments.idmensageminicial#
            </cfif>              
            order by vmm.veiculo_motorista_monit_id
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os Dados dos Veiculos
    -- RAFAEL 23/06/2010 - CRIADO
    --->		
    <cffunction name="get_mensagens" access="remote" returntype="query" output="true">
        <cfargument name="idmensageminicial" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select vpm.veiculo_posicao_monit_id
                 , vpm.veiculo_id
                 , to_char(vpm.data_posicao,'yyyy-mm-dd')||'T'||to_char(vpm.data_posicao,'hh24:mi:ss')||dbtimezone as data_posicao
                 , vpm.latitude
                 , vpm.longitude
                 , vpm.estado
                 , kss.pkg_string.fnc_string_clean(vpm.cidade) as cidade
                 , kss.pkg_string.fnc_string_clean(vpm.logradouro) as logradouro
                 , vpm.codigo_macro
                 , kss.pkg_string.fnc_string_clean(vpm.macro) as macro
              from integracao.v$veiculo_posicao_monit vpm
             where 1 = 1
			<cfif Len(Trim(arguments.idmensageminicial))>
               and vpm.veiculo_posicao_monit_id > #arguments.idmensageminicial#
            </cfif>              
            order by vpm.veiculo_posicao_monit_id
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
</cfcomponent>