<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO 
	-- Busca resumo por grupo de controle
	-- GUTO  11/07/2012
	--->		
	<cffunction name="get_resumo_grupo" access="remote" returntype="query" output="true">
    	<cfargument name="cod_grupo" required="no" default="">
    	<cfargument name="GRUPO_CLIENTE" required="no" default="">
    	<cfargument name="TODOS" required="no" default="">
    	<cfargument name="FILTRO" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select b.situacao, count(*) as ativos
              from (with engatados as (select case 
                                               when a.classe_id = 10 and a.tempo_parado > gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_FRONTEIRA') * 60 * 60 then 'fronteira_parado'
                                               when a.classe_id = 10 and a.tempo_parado < gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_FRONTEIRA') * 60 * 60 then 'fronteira'
                                               when a.status in ('Vazio','Destinado') and a.tempo_parado > gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_VAZIO_DESTINADO') * 60 * 60 then 'vazio_destinado_parado'
                                               when a.status in ('Vazio','Destinado') and a.tempo_parado < gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_VAZIO_DESTINADO') * 60 * 60 then 'vazio_destinado'
                                               when a.status in ('Destinado') and a.tempo_parado > gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_VAZIO_DESTINADO') * 60 * 60 then 'destinado_parado'
                                               when a.status in ('Destinado') and a.tempo_parado < gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_VAZIO_DESTINADO') * 60 * 60 then 'destinado'
                                               when a.status in ('Viagem') and a.tempo_parado > gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_VIAGEM') * 60 * 60 then 'transito_parado'
                                               when a.status in ('Viagem') and a.tempo_parado < gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_VIAGEM') * 60 * 60 then 'transito'
                                               when a.status in ('Carga') and a.tempo_parado > gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_CARGA') * 60 * 60 then 'carga_parado'
                                               when a.status in ('Carga') and a.tempo_parado < gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_CARGA') * 60 * 60 then 'carga_parado'
                                               when a.status in ('Descarga') and a.tempo_parado > gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_DESCARGA') * 60 * 60 then 'descarga_parado'
                                               when a.status in ('Descarga') and a.tempo_parado < gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_DESCARGA') * 60 * 60 then 'descarga_parado'
                                               when a.status in ('Descarga Parcial') and a.tempo_parado > gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_DESCARGA') * 60 * 60 then 'descarga_parado'
                                               when a.status in ('Descarga Parcial') and a.tempo_parado < gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_DESCARGA') * 60 * 60 then 'descarga_parado'
                                               when a.placa_referencia is null then 'Cavalo Desengatado'
                                             else 'nao_definido' end tipo
                                            ,case
                                              when a.uf_origem = 'EX' and a.uf_destino <> 'EX' then 'Importao'
                                              when a.uf_origem <> 'EX' and a.uf_destino = 'EX' then 'Exportao'
                                              when a.uf_origem = 'EX' and a.uf_destino = 'EX' then 'Internacional'
                                             else 'Nacional' end as categoria
                                            ,a.pais   
                                            ,a.placa_tracao
                                            ,a.placa_reboque
                                            ,a.placa_controle
                                            ,a.placa_referencia
                                            ,a.classe_id
                                            ,a.referencia
                                            ,case
                                               when not exists (select 1 
                                                                  from oper.v$evento_operacao eo
                                                                 inner join oper.v$romaneio_evento re
                                                                         on re.controle_evo_id = eo.controle_evo_id
                                                                        and eo.num_evento = 25
                                                                where re.num_romaneio = a.num_romaneio)
                                                and a.classe_id = 10 then 'Fronteira'
                                              else a.status end status
                                            ,a.tempo
                                            ,a.distancia
                                            ,a.rank_frota_id
                                            ,a.latitude
                                            ,a.longitude
                                            ,a.ctrl_tempo
                                            ,a.distancia_destino
                                            ,a.tempo_evento
                                            ,a.destino
                                            ,a.cliente
                                            ,a.num_romaneio
                                            ,decode(a.uf_origem,'EX','importacao','exportacao') as direcao_frete
                                            ,case 
                                               when a.classe_id = 10 and a.tempo_parado > gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_FRONTEIRA') * 60 * 60 then 0
                                               when a.classe_id = 10 and a.tempo_parado < gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_FRONTEIRA') * 60 * 60 then 1
                                               when a.status in ('Viagem','Vazio','Destinado') and a.tempo_parado > gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_VAZIO_DESTINADO') * 60 * 60 then 0
                                               when a.status in ('Viagem','Vazio','Destinado') and a.tempo_parado < gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_VAZIO_DESTINADO') * 60 * 60 then 1
                                               when a.status in ('Viagem') and a.tempo_parado > gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_VIAGEM') * 60 * 60 then 0
                                               when a.status in ('Viagem') and a.tempo_parado < gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_VIAGEM') * 60 * 60 then 1
                                               when a.status in ('Carga','Descarga','Descarga Parcial') and a.tempo_parado > gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_CARGA_DESCARGA') * 60 * 60 then 0
                                               when a.status in ('Carga','Descarga','Descarga Parcial') and a.tempo_parado < gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_CARGA_DESCARGA') * 60 * 60 then 1
                                         else -1 end status_tempo               
                                        from (select oper.pkg_veiculo.fnc_get_cod_veiculo(rf.placa_controle) as placa_tracao
                                                    ,oper.pkg_veiculo.fnc_get_cod_veiculo(rf.placa_referencia) as placa_reboque
                                                    ,rf.placa_controle
                                                    ,rf.placa_referencia
                                                    ,rf.num_romaneio
                                                    ,r.referencia
                                                    ,r.referencia || '-' || mr.uf_id as referencia_completa
                                                    ,rc.classe_id
                                                    ,rc.classe as classe_referencia
                                                    ,mr.uf_id as uf_referencia
                                                    ,pa.descricao as pais
                                                    ,rf.latitude
                                                    ,rf.longitude
                                                    ,rf.distancia
                                                    ,rf.cliente
                                                    ,rf.carregamento as origem
                                                    ,(select nvl(evs.descricao_resumida,'Vazio')
                                                        from oper.v$evento_operacao evo
                                                       inner join oper.v$evento_operacao_setup evs
                                                               on evs.num_evento = evo.num_evento
                                                       where evo.controle_evo_id = rf.roo_evo_id) as status
                                                    ,case
                                                         when rf.engatada = 0 and rf.placa_referencia is not null then
                                                            oper.pkg_global.fnc_tempo_formatado((sysdate - rf.rhv_data_termino)*86400)
                                                         when (vrh.num_rastreador is null or vrh.situacao = 0) and (evo.num_evento =any(2,4)) then
                                                            oper.pkg_global.fnc_tempo_formatado((sysdate - evo.data)*86400)
                                                         when (vrh.num_rastreador is not null and vrh.situacao = 1) then
                                                            oper.pkg_global.fnc_tempo_formatado(((sysdate - rf.data_ultima_posicao) *86400) + rf.dia*86400 + rf.hora*3600 + rf.minuto*60)
                                                         else ' 00 : 00 ' end tempo
                                                    ,case
                                                         when rf.engatada = 0 and rf.placa_referencia is not null then
                                                            trunc((sysdate - rf.rhv_data_termino)*86400)
                                                         when (vrh.num_rastreador is null or vrh.situacao = 0) and (evo.num_evento =any(2,4)) then
                                                            trunc((sysdate - evo.data)*86400)
                                                         when vrh.num_rastreador is not null and vrh.situacao = 1 then
                                                            ((sysdate - rf.data_ultima_posicao) *86400) + (rf.dia*86400 + rf.hora*3600 + rf.minuto*60)
                                                         else 0 end tempo_parado
                                                    ,rf.rank_frota_id
                                                    ,nvl(case
                                                           when evo.num_evento = 5 then -- VAZIO: Data do Trmino da Viagem - Data Atual
                                                              trunc(rf.data_termino, 'mi') - trunc(sysdate, 'mi')
                                                           when evo.num_evento = 100 then -- DESTINADO: Previso de chegada - Data Atual
                                                              trunc(rf.data_previsao_vazio, 'mi') - trunc(sysdate, 'mi')
                                                           when evo.num_evento = 2 then -- CARGA: Data de incio de carga - Data Atual
                                                              trunc(rf.data_inicio_carga, 'mi') - trunc(sysdate, 'mi')
                                                           when evo.num_evento in (3, 8) then -- VIAGEM: Previso de Chegada - Data Atual
                                                              trunc(rf.data_previsao_carregado, 'mi') - trunc(sysdate, 'mi')
                                                           when evo.num_evento = 4 then -- DESCARGA: Data de incio descarga - Data Atual
                                                              trunc(rf.data_inicio_descarga, 'mi') - trunc(sysdate, 'mi')
                                                           else 0
                                                        end, 0) * 24 * 60  ctrl_tempo -- converte em minutos
                                                    ,rf.distancia_destino
                                                    ,decode(evo.data, null, null, oper.pkg_global.fnc_tempo_formatado((sysdate - decode(evo.num_evento, 100, rf.data_destinado, evo.data))*86400)) tempo_evento
                                                    ,rf.destino
                                                    ,(select max(m.uf_id) keep (dense_rank first order by sc.data_carregamento_inicio)
                                                        from oper.v$romaneio_item ri
                                                       inner join logistica.v$viagem_carga vc
                                                               on vc.viagem_carga_id = ri.viagem_carga_id
                                                       inner join logistica.v$solicitacao_carga sc
                                                               on sc.solicitacao_carga_id = vc.solicitacao_carga_id
                                                       inner join cep.municipio m 
                                                               on m.municipio_id = sc.origem_municipio_id
                                                       where ri.num_romaneio = rf.num_romaneio
                                                    )  as uf_origem
                                                    ,(select max(m.uf_id) keep (dense_rank last order by sc.data_carregamento_inicio)
                                                        from oper.v$romaneio_item ri
                                                       inner join logistica.v$viagem_carga vc
                                                               on vc.viagem_carga_id = ri.viagem_carga_id
                                                       inner join logistica.v$solicitacao_carga sc
                                                               on sc.solicitacao_carga_id = vc.solicitacao_carga_id
                                                       inner join cep.municipio m 
                                                               on m.municipio_id = sc.destino_municipio_id
                                                       where ri.num_romaneio = rf.num_romaneio
                                                    )  as uf_destino                        
                                                from oper.v$rank_frota rf
                                                left join oper.v$referencia r
                                                        on r.referencia_id = rf.referencia_id
                                                left join oper.v$referencia_classe rc
                                                       on rc.classe_id = r.classe_id
                                                left join cep.municipio mr
                                                        on mr.municipio_id = r.municipio_id
                                                left join cep.pais pa
                                                        on mr.pais_id = pa.pais_id
                                                left join oper.v$veiculo_grupo vg
                                                        on vg.placa = rf.placa_referencia
                                                       and sysdate between vg.data_inicio and nvl(vg.data_termino,sysdate)
                                                left join integracao.v$rastreador_historico vrh
                                                       on vrh.placa = rf.placa_controle
                                                      and vrh.data_final is null 
                                                left join oper.v$evento_operacao evo
                                                         on evo.controle_evo_id = rf.roo_evo_id
                                               where 1=1
												<cfif Len(Trim(arguments.COD_GRUPO))>
                                                and vg.cod_grupo in (select vg.cod_grupo
                                                                       from oper.v$veiculo_grupo_setup vg
                                                                      start with vg.cod_grupo in (#ListQualify(arguments.COD_GRUPO,"'",',')#)
                                                                     connect by prior vg.cod_grupo = vg.cod_grupo_pai) 
                                                </cfif>
                                                <cfif Len(Trim(arguments.GRUPO_CLIENTE))>
                                                  and rf.num_romaneio in (select ri.num_romaneio
                                                                            from oper.v$grupo_logistico_acesso gla
                                                                           inner join oper.v$romaneio_item ri
                                                                                   on ri.cod_remetente = gla.cod_pessoa_carga
                                                                                  and ri.cod_destinatario = nvl(gla.cod_pessoa_descarga,ri.cod_destinatario))
                                                </cfif>
                                                and (rf.engatada = 1 or (rf.engatada = 0 and rf.placa_referencia is null))
                                                ) a)
                    select case
                           when e.status in ('Carga') then nvl(e.pais,'Brasil') || ' - ' || 'Carga'
                           when e.status in ('Descarga') then nvl(e.pais,'Brasil') || ' - ' || 'Descarga'
                           when e.status in ('Descarga Parcial') then nvl(e.pais,'Brasil') || ' - ' || 'Descarga'
                           when e.status in ('Vazio') then nvl(e.pais,'Brasil') || ' - ' || 'Vazio'
                           when e.status in ('Destinado') then nvl(e.pais,'Brasil') || ' - ' || 'Destinado'
                           when e.status in ('Fronteira') then e.categoria  || ' - ' || 'Fronteira'
                           when e.status in ('Viagem') then e.categoria  || ' - ' || 'Trnsito'
                           when e.placa_referencia is null then 'Cavalo Desengatado'
                         else 'No Classificado' end situacao,
                         e.num_romaneio,
                         e.tipo, e.categoria, e.pais, e.placa_tracao, e.placa_reboque, e.placa_controle, e.placa_referencia, 
                         e.classe_id, e.referencia, e.status, e.tempo, e.distancia, e.rank_frota_id, e.latitude, e.longitude, 
                         e.ctrl_tempo, e.distancia_destino, e.tempo_evento, e.destino, e.cliente, e.direcao_frete, e.status_tempo
                      from engatados e
                      where 1=1
					  <cfif Len(Trim(arguments.FILTRO))>
                        and (e.placa_tracao = upper('#arguments.FILTRO#') or
                             e.placa_reboque = upper('#arguments.FILTRO#') or
                             e.placa_controle = replace(upper('#arguments.FILTRO#'),'-','') or
                             e.placa_referencia = replace(upper('#arguments.FILTRO#'),'-','') or
                             (select kss.fnc_concat_all(distinct kss.to_concat_expr(c.num_conhecimento,'/')) as conhecimento
                                from fiscal.v$conhecimento c
                                where c.num_romaneio = e.num_romaneio) like '%#arguments.FILTRO#%' or
                             (select kss.fnc_concat_all(distinct kss.to_concat_expr(nf.ordem_compra_cliente,'/')) as pedido
                                from fiscal.v$conhecimento c
                                inner join fiscal.v$conhecimento_nota_fiscal nf
                                        on nf.conhecimento_id = c.conhecimento_id
                                where c.num_romaneio = e.num_romaneio
                                  and nf.ordem_compra_cliente is not null) like '%#arguments.FILTRO#%' or
                             (select kss.fnc_concat_all(distinct kss.to_concat_expr(nf.numero,'/')) as numero
                                from fiscal.v$conhecimento c
                                inner join fiscal.v$conhecimento_nota_fiscal nf
                                        on nf.conhecimento_id = c.conhecimento_id
                                where c.num_romaneio = e.num_romaneio
                                  and nf.ordem_compra_cliente is not null) like '%#arguments.FILTRO#%' or
                             to_char(e.num_romaneio) = '#arguments.FILTRO#'
                             )
                      </cfif>
                      <cfif Len(Trim(arguments.GRUPO_CLIENTE)) and not Len(Trim(arguments.TODOS))>
                        and e.status in ('Carga','Descarga','Fronteira','Viagem')
                      </cfif>
                    order by situacao, e.cliente) b
                  group by b.situacao           
                  order by b.situacao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca detalhamento por grupo de controle
	-- GUTO  11/07/2012
	--->		
	<cffunction name="get_detalhamento_grupo" access="remote" returntype="query" output="true">
    	<cfargument name="cod_grupo" required="no" default="">
    	<cfargument name="GRUPO_CLIENTE" required="no" default="">
    	<cfargument name="TODOS" required="no" default="">
    	<cfargument name="FILTRO" required="no" default="">
    	<cfargument name="ORIGEM" required="no" default="Solicitao">        
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                with engatados as (select case 
                                           when a.classe_id = 10 and a.tempo_parado > gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_FRONTEIRA') * 60 * 60 then 'fronteira_parado'
                                           when a.classe_id = 10 and a.tempo_parado < gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_FRONTEIRA') * 60 * 60 then 'fronteira'
                                           when a.status in ('Vazio') and a.tempo_parado > gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_VAZIO_DESTINADO') * 60 * 60 then 'vazio_parado'
                                           when a.status in ('Vazio') and a.tempo_parado < gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_VAZIO_DESTINADO') * 60 * 60 then 'vazio'
                                           when a.status in ('Destinado') and a.tempo_parado > gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_VAZIO_DESTINADO') * 60 * 60 then 'destinado_parado'
                                           when a.status in ('Destinado') and a.tempo_parado < gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_VAZIO_DESTINADO') * 60 * 60 then 'destinado'
                                           when a.status in ('Viagem') and a.tempo_parado > gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_VIAGEM') * 60 * 60 then 'transito_parado'
                                           when a.status in ('Viagem') and a.tempo_parado < gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_VIAGEM') * 60 * 60 then 'transito'
                                           when a.status in ('Carga') and a.tempo_parado > gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_CARGA') * 60 * 60 then 'carga_parado'
                                           when a.status in ('Carga') and a.tempo_parado < gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_CARGA') * 60 * 60 then 'carga_parado'
                                           when a.status in ('Descarga') and a.tempo_parado > gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_DESCARGA') * 60 * 60 then 'descarga_parado'
                                           when a.status in ('Descarga') and a.tempo_parado < gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_DESCARGA') * 60 * 60 then 'descarga_parado'
                                           when a.status in ('Descarga Parcial') and a.tempo_parado > gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_DESCARGA') * 60 * 60 then 'descarga_parado'
                                           when a.status in ('Descarga Parcial') and a.tempo_parado < gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_DESCARGA') * 60 * 60 then 'descarga_parado'
                                           when a.placa_referencia is null then 'Cavalo Desengatado'
                                         else 'nao_definido' end tipo
                                        ,case
                                          when a.uf_origem = 'EX' and a.uf_destino <> 'EX' then 'Importao'
                                          when a.uf_origem <> 'EX' and a.uf_destino = 'EX' then 'Exportao'
                                          when a.uf_origem = 'EX' and a.uf_destino = 'EX' then 'Internacional'
                                         else 'Nacional' end as categoria
                                        ,a.pais   
                                        ,a.placa_tracao
                                        ,a.placa_reboque
                                        ,a.placa_controle
                                        ,a.placa_referencia
                                        ,(select vc.placa_2
                                            from oper.v$veiculo_composicao vc
                                           where vc.placa_1 = a.placa_referencia
                                             and vc.data_hora_desengate is null) as carreta_2
                                        ,a.classe_id
                                        ,a.referencia
                                        ,(select count(*)
                                            from oper.v$evento_operacao eo
                                           inner join oper.v$romaneio_evento re
                                                   on re.controle_evo_id = eo.controle_evo_id
                                                  and eo.num_evento = 24
                                           where re.num_romaneio = a.num_romaneio) as possui_fronteira
                                        ,case
                                               when not exists (select 1 
                                                                  from oper.v$evento_operacao eo
                                                                 inner join oper.v$romaneio_evento re
                                                                         on re.controle_evo_id = eo.controle_evo_id
                                                                        and eo.num_evento = 25
                                                                where re.num_romaneio = a.num_romaneio)
                                                and a.classe_id = 10 then 'Fronteira'
                                              else a.status end status
                                        ,a.tempo
                                        ,a.distancia
                                        ,a.rank_frota_id
                                        ,a.nome_motorista
                                        ,a.latitude
                                        ,a.longitude
                                        ,a.ctrl_tempo
                                        ,a.data_inicio
                                        ,a.distancia_destino
                                        ,a.tempo_evento
                                        ,a.origem
                                        ,a.carregamento
                                        ,a.destino
                                        ,a.cliente
                                        ,a.cod_grupo
                                        ,decode(a.uf_origem,'EX','importacao','exportacao') as direcao_frete
                                        ,case 
                                           when a.classe_id = 10 and a.tempo_parado > gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_FRONTEIRA') * 60 * 60 then 0
                                           when a.classe_id = 10 and a.tempo_parado < gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_FRONTEIRA') * 60 * 60 then 1
                                           when a.status in ('Viagem','Vazio','Destinado') and a.tempo_parado > gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_VAZIO_DESTINADO') * 60 * 60 then 0
                                           when a.status in ('Viagem','Vazio','Destinado') and a.tempo_parado < gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_VAZIO_DESTINADO') * 60 * 60 then 1
                                           when a.status in ('Viagem') and a.tempo_parado > gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_VIAGEM') * 60 * 60 then 0
                                           when a.status in ('Viagem') and a.tempo_parado < gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_VIAGEM') * 60 * 60 then 1
                                           when a.status in ('Carga','Descarga','Descarga Parcial') and a.tempo_parado > gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_CARGA_DESCARGA') * 60 * 60 then 0
                                           when a.status in ('Carga','Descarga','Descarga Parcial') and a.tempo_parado < gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_CARGA_DESCARGA') * 60 * 60 then 1
                                         else -1 end status_tempo,
                                         lat_origem, lat_destino, num_romaneio, tt_nac, tt_int                                         
                                    from (select oper.pkg_veiculo.fnc_get_cod_veiculo(rf.placa_controle) as placa_tracao
                                                ,oper.pkg_veiculo.fnc_get_cod_veiculo(rf.placa_referencia) as placa_reboque
                                                ,rf.placa_controle
                                                ,rf.placa_referencia
                                                ,r.referencia
                                                ,r.referencia || '-' || mr.uf_id as referencia_completa
                                                ,rc.classe_id
                                                ,rc.classe as classe_referencia
                                                ,mr.uf_id as uf_referencia
                                                ,pa.descricao as pais
                                                ,rf.latitude
                                                ,rf.longitude
                                                ,nvl(vg.cod_grupo,vgc.cod_grupo) as cod_grupo
                                                ,(select p.razao_social
                                                   from kss.v$pessoa p
                                                  where p.cod_pessoa = rf.cod_pessoa) as nome_motorista
                                                ,rf.distancia
                                                ,rf.cliente
                                                ,rf.carregamento as origem
                                                ,(select nvl(evs.descricao_resumida,'Vazio')
                                                    from oper.v$evento_operacao evo
                                                   inner join oper.v$evento_operacao_setup evs
                                                           on evs.num_evento = evo.num_evento
                                                   where evo.controle_evo_id = rf.roo_evo_id) as status
                                                ,case
                                                     when rf.engatada = 0 and rf.placa_referencia is not null then
                                                        oper.pkg_global.fnc_tempo_formatado((sysdate - rf.rhv_data_termino)*86400)
                                                     when (vrh.num_rastreador is null or vrh.situacao = 0) and (evo.num_evento =any(2,4)) then
                                                        oper.pkg_global.fnc_tempo_formatado((sysdate - evo.data)*86400)
                                                     when (vrh.num_rastreador is not null and vrh.situacao = 1) then
                                                        oper.pkg_global.fnc_tempo_formatado(((sysdate - rf.data_ultima_posicao) *86400) + rf.dia*86400 + rf.hora*3600 + rf.minuto*60)
                                                     else ' 00 : 00 ' end tempo
                                                ,case
                                                     when rf.engatada = 0 and rf.placa_referencia is not null then
                                                        trunc((sysdate - rf.rhv_data_termino)*86400)
                                                     when (vrh.num_rastreador is null or vrh.situacao = 0) and (evo.num_evento =any(2,4)) then
                                                        trunc((sysdate - evo.data)*86400)
                                                     when vrh.num_rastreador is not null and vrh.situacao = 1 then
                                                        ((sysdate - rf.data_ultima_posicao) *86400) + (rf.dia*86400 + rf.hora*3600 + rf.minuto*60)
                                                     else 0 end tempo_parado
                                                ,rf.rank_frota_id
                                                ,nvl(case
                                                       when evo.num_evento = 5 then -- VAZIO: Data do Trmino da Viagem - Data Atual
                                                          trunc(rf.data_termino, 'mi') - trunc(sysdate, 'mi')
                                                       when evo.num_evento = 100 then -- DESTINADO: Previso de chegada - Data Atual
                                                          trunc(rf.data_previsao_vazio, 'mi') - trunc(sysdate, 'mi')
                                                       when evo.num_evento = 2 then -- CARGA: Data de incio de carga - Data Atual
                                                          trunc(rf.data_inicio_carga, 'mi') - trunc(sysdate, 'mi')
                                                       when evo.num_evento in (3, 8) then -- VIAGEM: Previso de Chegada - Data Atual
                                                          trunc(rf.data_previsao_carregado, 'mi') - trunc(sysdate, 'mi')
                                                       when evo.num_evento = 4 then -- DESCARGA: Data de incio descarga - Data Atual
                                                          trunc(rf.data_inicio_descarga, 'mi') - trunc(sysdate, 'mi')
                                                       else 0
                                                    end, 0) * 24 * 60  ctrl_tempo -- converte em minutos
                                                ,rf.distancia_destino
                                                ,decode(evo.data, null, null, oper.pkg_global.fnc_tempo_formatado((sysdate - decode(evo.num_evento, 100, rf.data_destinado, evo.data))*86400)) tempo_evento
                                                ,rf.destino
                                                ,(select max(m.uf_id) keep (dense_rank first order by sc.data_carregamento_inicio)
                                                    from oper.v$romaneio_item ri
                                                   inner join logistica.v$viagem_carga vc
                                                           on vc.viagem_carga_id = ri.viagem_carga_id
                                                   inner join logistica.v$solicitacao_carga sc
                                                           on sc.solicitacao_carga_id = vc.solicitacao_carga_id
                                                   inner join cep.municipio m 
                                                           on m.municipio_id = sc.origem_municipio_id
                                                   where ri.num_romaneio = rf.num_romaneio
                                                )  as uf_origem
                                                ,(select max(m.uf_id) keep (dense_rank last order by sc.data_carregamento_inicio)
                                                    from oper.v$romaneio_item ri
                                                   inner join logistica.v$viagem_carga vc
                                                           on vc.viagem_carga_id = ri.viagem_carga_id
                                                   inner join logistica.v$solicitacao_carga sc
                                                           on sc.solicitacao_carga_id = vc.solicitacao_carga_id
                                                   inner join cep.municipio m 
                                                           on m.municipio_id = sc.destino_municipio_id
                                                   where ri.num_romaneio = rf.num_romaneio
                                                )  as uf_destino                        
                                                ,(select max(cep.pkg_coord_geografica.fnc_graus2decimais(m.latitude)) keep (dense_rank last order by sc.data_carregamento_inicio)
                                                    from oper.v$romaneio_item ri
                                                   inner join logistica.v$viagem_carga vc
                                                           on vc.viagem_carga_id = ri.viagem_carga_id
                                                   inner join logistica.v$solicitacao_carga sc
                                                           on sc.solicitacao_carga_id = vc.solicitacao_carga_id
                                                   inner join cep.municipio m 
                                                           on m.municipio_id = sc.origem_municipio_id
                                                   where ri.num_romaneio = rf.num_romaneio
                                                )  as lat_origem
                                                ,(select max(cep.pkg_coord_geografica.fnc_graus2decimais(m.latitude)) keep (dense_rank last order by sc.data_carregamento_inicio)
                                                    from oper.v$romaneio_item ri
                                                   inner join logistica.v$viagem_carga vc
                                                           on vc.viagem_carga_id = ri.viagem_carga_id
                                                   inner join logistica.v$solicitacao_carga sc
                                                           on sc.solicitacao_carga_id = vc.solicitacao_carga_id
                                                   inner join cep.municipio m 
                                                           on m.municipio_id = sc.destino_municipio_id
                                                   where ri.num_romaneio = rf.num_romaneio
                                                )  as lat_destino      
                                                , rf.num_romaneio
                                                , oper.pkg_transit_time.fnc_romaneio_transit_time(rf.num_romaneio,rf.placa_controle,0) as tt_nac
                                                , oper.pkg_transit_time.fnc_romaneio_transit_time(rf.num_romaneio,rf.placa_controle,1) as tt_int
                                                , (select to_char(max(eo.data),'dd/mm hh24:mi')
                                                     from oper.v$evento_operacao eo
                                                    inner join oper.v$romaneio_evento re
                                                            on eo.controle_evo_id  = re.controle_evo_id 
                                                    where eo.num_evento = 3
                                                      and re.num_romaneio = rf.num_romaneio) as data_inicio 
                                                ,roo.carregamento                                               
                                            from oper.v$rank_frota rf
                                            left join oper.v$referencia r
                                                    on r.referencia_id = rf.referencia_id
                                            left join oper.v$referencia_classe rc
                                                   on rc.classe_id = r.classe_id
                                            left join cep.municipio mr
                                                    on mr.municipio_id = r.municipio_id
                                            left join cep.pais pa
                                                    on mr.pais_id = pa.pais_id
                                            left join oper.v$veiculo_grupo vg
                                                    on vg.placa = rf.placa_referencia
                                                   and sysdate between vg.data_inicio and nvl(vg.data_termino,sysdate)
                                            left join oper.v$veiculo_grupo vgc
                                                    on vgc.placa = rf.placa_controle
                                                   and sysdate between vgc.data_inicio and nvl(vgc.data_termino,sysdate)
                                            left join integracao.v$rastreador_historico vrh
                                                   on vrh.placa = rf.placa_controle
                                                  and vrh.data_final is null
                                            left join oper.v$evento_operacao evo
                                                     on evo.controle_evo_id = rf.roo_evo_id
                                            left join oper.v$romaneio roo
                                                   on roo.num_romaneio = rf.num_romaneio
                                          where 1=1
                                            <cfif Len(Trim(arguments.COD_GRUPO))>
                                            and nvl(vg.cod_grupo,vgc.cod_grupo) in (select vgs.cod_grupo
                                                                                      from oper.v$veiculo_grupo_setup vgs
                                                                                     start with vgs.cod_grupo in (#ListQualify(arguments.COD_GRUPO,"'",',')#)
                                                                                    connect by prior vgs.cod_grupo = vgs.cod_grupo_pai) 
                                            </cfif>
                                            <cfif Len(Trim(arguments.GRUPO_CLIENTE))>
                                              and rf.num_romaneio in (select ri.num_romaneio
                                                                        from oper.v$grupo_logistico_acesso gla
                                                                       inner join oper.v$romaneio_item ri
                                                                               on ri.cod_remetente = gla.cod_pessoa_carga
                                                                               and ri.cod_destinatario = nvl(gla.cod_pessoa_descarga,ri.cod_destinatario) )                                            
                                            </cfif>
                                            and (rf.engatada = 1 or (rf.engatada = 0 and rf.placa_referencia is null))
                                            ) a)
                select case
                          when e.status in ('Carga') then
                           nvl(e.pais, 'Brasil') || ' - ' || 'Carga'
                          when e.status in ('Descarga') then
                           nvl(e.pais, 'Brasil') || ' - ' || 'Descarga'
                          when e.status in ('Descarga Parcial') then
                           nvl(e.pais, 'Brasil') || ' - ' || 'Descarga'
                          when e.status in ('Vazio') then
                           nvl(e.pais, 'Brasil') || ' - ' || 'Vazio'
                          when e.status in ('Destinado') then
                           nvl(e.pais, 'Brasil') || ' - ' || 'Destinado'
                          when e.status in ('Fronteira') then
                           e.categoria || ' - ' || 'Fronteira'
                          when e.status in ('Viagem') and e.categoria = 'Nacional' and
                               e.lat_destino < e.lat_origem then
                           'Rumo Sul'
                          when e.status in ('Viagem') and e.categoria = 'Nacional' and
                               e.lat_destino > e.lat_origem then
                           'Rumo Norte'
                          when e.status in ('Viagem') then
                           e.categoria || ' - ' || 'Trnsito'
                          when e.placa_referencia is null then
                           'Cavalo Desengatado'
                          else
                           'No Classificado'
                       end situacao,
                       case
                          when e.status in ('Carga') then
                           6
                          when e.status in ('Descarga') then
                           5
                          when e.status in ('Descarga Parcial') then
                           5
                          when e.status in ('Vazio') then
                           3
                          when e.status in ('Destinado') then
                           4
                          when e.status in ('Fronteira') then
                           2
                          when e.status in ('Viagem') then
                           1
                          when e.placa_referencia is null then
                           10
                          else
                           -1
                       end ordem_situacao,
                       e.nome_motorista,       
                       e.tt_nac.trajeto_concluido as nac_trajeto_concluido,       
                       e.tt_nac.km_trajeto as nac_km_trajeto,
                       case
                          when (100 * ((e.tt_nac.km_trajeto - e.tt_nac.distancia_destino) /
                               nullif(e.tt_nac.km_trajeto, 0))) >= 96 then
                           96
                          else
                           (100 * ((e.tt_nac.km_trajeto - e.tt_nac.distancia_destino) /
                           nullif(e.tt_nac.km_trajeto, 0)))
                       end nac_percentual_executado,
                       e.tt_nac.referencia_destino as nac_referencia_destino,
                       e.tt_nac.distancia_destino as nac_distancia_destino,
                       e.tt_nac.trajeto as nac_trajeto,
                       nvl(to_char(e.tt_nac.data_lib_fronteira, 'dd/mm hh24:mi'),
                           to_char(e.tt_int.data_lib_fronteira, 'dd/mm hh24:mi')) as data_lib_fronteira,
                       nvl(to_char(e.tt_nac.data_chegada_fronteira, 'dd/mm hh24:mi'),
                           to_char(e.tt_int.data_chegada_fronteira, 'dd/mm hh24:mi')) as data_chegada_fronteira,
                       nvl(e.tt_nac.obs_fronteira, e.tt_int.obs_fronteira) as obs_fronteira,
                       nvl(e.tt_nac.tempo_fronteira, e.tt_int.tempo_fronteira) as tempo_fronteira,
                       case
                          when e.tt_nac.trajeto_concluido = 0 then
                           to_char(oper.pkg_tempo_viagem_ctrl.fnc_previsao_chegada(1,
                                                                                   sysdate,
                                                                                   numtodsinterval(e.tt_nac.distancia_destino / 55,
                                                                                                   'hour')),
                                   'dd/mm hh24:mi')
                          else
                           null
                       end nac_previsao_chegada,
                       e.tt_int.trajeto_concluido as int_trajeto_concluido,       
                       e.tt_int.km_trajeto as int_km_trajeto,
                       case
                          when (100 * ((e.tt_int.km_trajeto - e.tt_int.distancia_destino) /
                               e.tt_int.km_trajeto)) >= 96 then
                           96
                          else
                           100 * ((e.tt_int.km_trajeto - e.tt_int.distancia_destino) /
                           e.tt_int.km_trajeto)
                       end int_percentual_executado,       
                       e.tt_int.referencia_destino as int_referencia_destino,
                       e.tt_int.distancia_destino as int_distancia_destino,
                       e.tt_int.trajeto as int_trajeto,
                       case
                          when e.tt_int.trajeto_concluido = 0 then
                           to_char(oper.pkg_tempo_viagem_ctrl.fnc_previsao_chegada(1,
                                                                                   sysdate,
                                                                                   numtodsinterval(e.tt_int.distancia_destino / 55,
                                                                                                   'hour')),
                                   'dd/mm hh24:mi')
                          else
                           null
                       end int_previsao_chegada,       
                       e.num_romaneio,
                       e.tipo,
                       e.categoria,
                       e.pais,
                       e.placa_tracao,
                       e.placa_reboque,
                       e.placa_controle,
                       e.placa_referencia,
                       e.carreta_2,
                       e.cod_grupo,
                       e.classe_id,
                       e.referencia,
                       e.status,
                       e.tempo,
                       e.distancia,
                       e.rank_frota_id,
                       e.latitude,
                       e.longitude,
                       e.ctrl_tempo,
                       e.distancia_destino,
                       e.tempo_evento,
                       e.data_inicio,
                       e.origem,
                       e.destino,
                       e.cliente,
                       e.status_tempo,
                       case
                          when e.categoria = 'Nacional' and e.lat_destino < e.lat_origem then
                           'exportacao'
                          when e.categoria = 'Nacional' and e.lat_destino > e.lat_origem then
                           'importacao'
                          else
                           e.direcao_frete
                       end direcao_frete,
                       case
                          when e.categoria = 'Nacional' and e.lat_destino < e.lat_origem then
                           'Rumo Sul'
                          when e.categoria = 'Nacional' and e.lat_destino > e.lat_origem then
                           'Rumo Norte'
                       end rumo,
                       case
                          when e.tt_nac.trajeto_concluido = 0 then
                           e.tt_nac.referencia_destino
                          else
                           e.tt_int.referencia_destino
                       end destino_ordem,
                       e.possui_fronteira,
                       (select kss.fnc_concat_all(distinct
                                                  kss.to_concat_expr(c.num_conhecimento, '/')) as conhecimento
                          from fiscal.v$conhecimento c
                         where c.num_romaneio = e.num_romaneio) as conhecimento,
                       (select kss.fnc_concat_all(distinct kss.to_concat_expr(nf.ordem_compra_cliente,
                                                                     '/')) as pedido
                          from fiscal.v$conhecimento c
                         inner join fiscal.v$conhecimento_nota_fiscal nf
                            on nf.conhecimento_id = c.conhecimento_id
                         where c.num_romaneio = e.num_romaneio
                           and nf.ordem_compra_cliente is not null) as ordem_compra_cliente,
                       (select kss.fnc_concat_all(distinct
                                                  kss.to_concat_expr(nf.numero, '/')) as numero
                          from fiscal.v$conhecimento c
                         inner join fiscal.v$conhecimento_nota_fiscal nf
                            on nf.conhecimento_id = c.conhecimento_id
                         where c.num_romaneio = e.num_romaneio
                           and nf.ordem_compra_cliente is not null) as numero_nf_cliente,
                       e.carregamento,
                       e.tt_nac.tt_programado_rota as nac_tt_programado_rota,
                       e.tt_int.tt_programado_rota as int_tt_programado_rota,                       
                       <cfif arguments.ORIGEM eq 'Rota'>
                           e.tt_nac.no_prazo_rota as nac_no_prazo,
                           e.tt_nac.data_tt_programado_rota as nac_data_tt_programado,
                           e.tt_nac.tt_programado_rota as nac_tt_programado,
                           e.tt_nac.data_tt_executado_rota as nac_data_tt_executado,
                           e.tt_nac.tt_executado_solic as nac_tt_executado,
                           e.tt_nac.tt_executado_horas_solic as nac_tt_executado_horas,
                           e.tt_nac.tt_programado_horas_rota as nac_tt_programado_horas,
                           case
                              when e.tt_nac.trajeto_concluido = 1 then
                               4 /*CONCLUIDO*/
                              when e.tt_nac.trajeto_concluido = 0 and
                                   e.tt_nac.data_tt_programado_rota < sysdate then
                               2 /*ATRASADO*/
                              when e.tt_nac.trajeto_concluido = 0 and
                                   oper.pkg_tempo_viagem_ctrl.fnc_previsao_chegada(1,
                                                                                   sysdate,
                                                                                   numtodsinterval(e.tt_nac.distancia_destino / 55,
                                                                                                   'hour')) >
                                   e.tt_nac.data_tt_programado_rota then
                               3 /*POSSIBILIDADE DE ATRASO*/
                              else
                               1 /* NO PRAZO */
                           end nac_tt_status_atual,
                           e.tt_int.no_prazo_rota as int_no_prazo,
                           e.tt_int.data_tt_programado_rota as int_data_tt_programado,
                           e.tt_int.tt_programado_rota as int_tt_programado,
                           e.tt_int.data_tt_executado_rota as int_data_tt_executado,
                           e.tt_int.tt_executado_solic as int_tt_executado,
                           e.tt_int.tt_executado_horas_solic as int_tt_executado_horas,
                           e.tt_int.tt_programado_horas_rota as int_tt_programado_horas,
                           case
                              when e.tt_int.trajeto_concluido = 1 then
                               4 /*CONCLUIDO*/
                              when e.tt_int.trajeto_concluido = 0 and
                                   e.tt_int.data_tt_programado_rota < sysdate then
                               2 /*ATRASADO*/
                              when e.tt_int.trajeto_concluido = 0 and
                                   oper.pkg_tempo_viagem_ctrl.fnc_previsao_chegada(1,
                                                                                   sysdate,
                                                                                   numtodsinterval(e.tt_int.distancia_destino / 55,
                                                                                                   'hour')) >
                                   e.tt_int.data_tt_programado_rota then
                               3 /*POSSIBILIDADE DE ATRASO*/
                              else
                               1 /* NO PRAZO */
                           end int_tt_status_atual                       
                       <cfelse>
                       e.tt_nac.no_prazo_solic as nac_no_prazo,
                       e.tt_nac.data_tt_programado_solic as nac_data_tt_programado,
                       e.tt_nac.tt_programado_solic as nac_tt_programado,
                       e.tt_nac.data_tt_executado_solic as nac_data_tt_executado,
                       e.tt_nac.tt_executado_solic as nac_tt_executado,
                       e.tt_nac.tt_executado_horas_solic as nac_tt_executado_horas,
                       e.tt_nac.tt_programado_horas_solic as nac_tt_programado_horas,
                       case
                          when e.tt_nac.trajeto_concluido = 1 then
                           4 /*CONCLUIDO*/
                          when e.tt_nac.trajeto_concluido = 0 and
                               e.tt_nac.data_tt_programado_solic < sysdate then
                           2 /*ATRASADO*/
                          when e.tt_nac.trajeto_concluido = 0 and
                               oper.pkg_tempo_viagem_ctrl.fnc_previsao_chegada(1,
                                                                               sysdate,
                                                                               numtodsinterval(e.tt_nac.distancia_destino / 55,
                                                                                               'hour')) >
                               e.tt_nac.data_tt_programado_solic then
                           3 /*POSSIBILIDADE DE ATRASO*/
                          else
                           1 /* NO PRAZO */
                       end nac_tt_status_atual,
                       e.tt_int.no_prazo_solic as int_no_prazo,
                       e.tt_int.data_tt_programado_solic as int_data_tt_programado,
                       e.tt_int.tt_programado_solic as int_tt_programado,
                       e.tt_int.data_tt_executado_solic as int_data_tt_executado,
                       e.tt_int.tt_executado_solic as int_tt_executado,
                       e.tt_int.tt_executado_horas_solic as int_tt_executado_horas,
                       e.tt_int.tt_programado_horas_solic as int_tt_programado_horas,
                       case
                          when e.tt_int.trajeto_concluido = 1 then
                           4 /*CONCLUIDO*/
                          when e.tt_int.trajeto_concluido = 0 and
                               e.tt_int.data_tt_programado_solic < sysdate then
                           2 /*ATRASADO*/
                          when e.tt_int.trajeto_concluido = 0 and
                               oper.pkg_tempo_viagem_ctrl.fnc_previsao_chegada(1,
                                                                               sysdate,
                                                                               numtodsinterval(e.tt_int.distancia_destino / 55,
                                                                                               'hour')) >
                               e.tt_int.data_tt_programado_solic then
                           3 /*POSSIBILIDADE DE ATRASO*/
                          else
                           1 /* NO PRAZO */
                       end int_tt_status_atual 
                       </cfif>
                  from engatados e
				  where 1=1
				  <cfif Len(Trim(arguments.FILTRO))>
                    and (e.placa_tracao = upper('#arguments.FILTRO#') or
                         e.placa_reboque = upper('#arguments.FILTRO#') or
                         e.placa_controle = replace(upper('#arguments.FILTRO#'),'-','') or
                         e.placa_referencia = replace(upper('#arguments.FILTRO#'),'-','') or
                         (select kss.fnc_concat_all(distinct kss.to_concat_expr(c.num_conhecimento,'/')) as conhecimento
                            from fiscal.v$conhecimento c
                            where c.num_romaneio = e.num_romaneio) like '%#arguments.FILTRO#%' or
                         (select kss.fnc_concat_all(distinct kss.to_concat_expr(nf.ordem_compra_cliente,'/')) as pedido
                            from fiscal.v$conhecimento c
                            inner join fiscal.v$conhecimento_nota_fiscal nf
                                    on nf.conhecimento_id = c.conhecimento_id
                            where c.num_romaneio = e.num_romaneio
                              and nf.ordem_compra_cliente is not null) like '%#arguments.FILTRO#%' or
                         (select kss.fnc_concat_all(distinct kss.to_concat_expr(nf.numero,'/')) as numero
                            from fiscal.v$conhecimento c
                            inner join fiscal.v$conhecimento_nota_fiscal nf
                                    on nf.conhecimento_id = c.conhecimento_id
                            where c.num_romaneio = e.num_romaneio
                              and nf.ordem_compra_cliente is not null) like '%#arguments.FILTRO#%' or
                         to_char(e.num_romaneio) = '#arguments.FILTRO#'
                         )
                  </cfif>
				  <cfif Len(Trim(arguments.GRUPO_CLIENTE)) and not Len(Trim(arguments.TODOS))>
                    and e.status in ('Carga','Descarga','Fronteira','Viagem')
                  </cfif>
                order by ordem_situacao, situacao
                       , case 
                           when e.tt_nac.trajeto_concluido = 0 then e.tt_nac.referencia_destino
                           else e.tt_int.referencia_destino end 
                       , case 
                           when e.tt_nac.trajeto_concluido = 0 then oper.pkg_tempo_viagem_ctrl.fnc_previsao_chegada(1,sysdate,numtodsinterval(e.tt_nac.distancia_destino/55,'hour'))
                           when e.tt_int.trajeto_concluido = 0 then oper.pkg_tempo_viagem_ctrl.fnc_previsao_chegada(1,sysdate,numtodsinterval(e.tt_int.distancia_destino/55,'hour'))
                         else null end 
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>    

	<!--- 
    -- PROPSITO
    -- Busca parametros do painel
    -- 17/07/2012 - criado
    --->	
    <cffunction name="get_parametros_painel" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="rank_frota_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_ATUALIZACAO') as tempo_atualizacao
                  ,gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_FRONTEIRA') as tempo_fronteira
                   ,kss.to_tempo(gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_FRONTEIRA')*60,4).retorno as tempo_fronteira_formatado
                  ,gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_CARGA') as tempo_carga
                   ,kss.to_tempo(gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_CARGA')*60,4).retorno as tempo_carga_formatado
                  ,gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_DESCARGA') as tempo_descarga
                   ,kss.to_tempo(gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_DESCARGA')*60,4).retorno as tempo_descarga_formatado
                  ,gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_VAZIO_DESTINADO') as tempo_vazio_destinado
                   ,kss.to_tempo(gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_VAZIO_DESTINADO')*60,4).retorno as tempo_vazio_dest_formatado
                  ,gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_VIAGEM') as tempo_viagem
                   ,kss.to_tempo(gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_VIAGEM')*60,4).retorno as tempo_viagem_formatado
              from dual
        </cfquery>
        <cfreturn qr_result>
    </cffunction>    
    
	<!--- 
    -- PROPSITO
    -- Busca a posio geografica dos veiculos
    -- 13/12/2008 - criado
    --->	
    <cffunction name="get_posicao_veiculo_mapa" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="rank_frota_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select rank_frota_id,
            	   placa_controle as placa,
            	   oper.pkg_veiculo.fnc_get_cod_veiculo(placa_controle) as frota_controle,
            	   placa_referencia as placa_referencia,
            	   oper.pkg_veiculo.fnc_get_cod_veiculo(placa_referencia) as frota_referencia,
            	   landmark, 
                   latitude, 
                   longitude 
              from oper.v$rank_frota 
             where rank_frota_id in (#ListQualify(arguments.rank_frota_id,"'",',')#)
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
	<!--- 
    -- PROPSITO
    -- Busca grupos de controle
    -- 13/12/2008 - criado
    --->	
    <cffunction name="get_grupos" displayname="" output="true" returntype="query" access="public">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
              select substr(replace(sys_connect_by_path(vg.descricao, '->'),'->',' - '),4) as grupo_completo,
                     vg.cod_grupo, vg.descricao , vg.cod_grupo_pai,
                     (select count(*) 
                        from oper.v$veiculo_grupo veg
                       where veg.cod_grupo = vg.cod_grupo
                         and veg.data_termino is null) as veiculos
                from oper.v$veiculo_grupo_setup vg
               where vg.situacao_id = 1
               start with vg.cod_grupo_pai is null
               connect by prior vg.cod_grupo = vg.cod_grupo_pai
               order siblings by vg.cod_grupo_pai, vg.cod_grupo
           </cfquery>
        <cfreturn qr_result>
    </cffunction>        

	<!--- 
    -- PROPSITO
    -- Busca grupos de controle limitados pelo cliente que acessa
    -- 20/03/2015 - criado
    --->	
    <cffunction name="get_grupos_cliente" displayname="" output="true" returntype="query" access="public">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
              select substr(replace(sys_connect_by_path(vg.descricao, '->'),'->',' - '),4) as grupo_completo,
                     vg.cod_grupo, vg.descricao , vg.cod_grupo_pai,
                     (select count(*) 
                        from oper.v$veiculo_grupo veg
                       where veg.cod_grupo = vg.cod_grupo
                         and veg.data_termino is null) as veiculos
                from oper.v$veiculo_grupo_setup vg
               inner join oper.v$veiculo_grupo_setup_usuario us
                  on us.cod_grupo = vg.cod_grupo
                 and us.usuario = user
               where vg.situacao_id = 1
               start with vg.cod_grupo_pai is null
               connect by prior vg.cod_grupo = vg.cod_grupo_pai
               order siblings by vg.cod_grupo_pai, vg.cod_grupo
           </cfquery>
        <cfreturn qr_result>
    </cffunction> 

	<!--- 
    -- PROPSITO
    -- Busca carretas desengatadas
    --->	
    <cffunction name="get_detalhamento_carretas" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="cod_grupo" required="no" default="">
    	<cfargument name="FILTRO" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select rf.placa_referencia, oper.pkg_veiculo.fnc_get_cod_veiculo(rf.placa_referencia) as cod_veiculo,
                   count(rf.placa_referencia) over(partition by nvl(vg.cod_grupo,'GERAL') order by nvl(vg.cod_grupo,'GERAL')) as qtde_grupo,
                   count(rf.placa_referencia) over(partition by rf.filial_mais_proxima order by rf.filial_mais_proxima) as qtde_filial,
                   eo.local as referencia, 
                   case 
                      when (select count(*)
                              from oper.v$rank_frota rf2
                              inner join oper.v$referencia re2
                              on re2.referencia_id = rf2.referencia_id
                              where re2.latitude = eo.latitude) > 1 then eo.latitude + (dbms_random.value(0,1)/1000)
                   else eo.latitude end latitude, 
                   eo.longitude, 
                   to_char(rf.data_hora_desengate,'dd/mm/yyyy hh24:mi') as data_hora_desengate , 
                   kss.to_tempo((sysdate-rf.data_hora_desengate)*1440,1).retorno as tempo_parado,
                   rf.filial_mais_proxima, nvl((select sum(c.total_conhecimento - c.valor_icms)
                                             from fiscal.v$conhecimento c
                                            where c.data_emissao >= trunc(sysdate,'month')
                                              and c.conhecimento_tipo_id <> 6
                                              and c.cancelado is null
                                              and c.placa = rf.placa_referencia),0) as faturamento,  
                   rf.uf_atual, nvl(evs.descricao_resumida, 'Vazio') status, nvl(vg.cod_grupo,'GERAL') as cod_grupo,
                   va.descricao as agrupamento, vtc.descricao as classificacao, vma.marca, vm.modelo
              from oper.v$rank_frota rf
             inner join oper.v$veiculo v
                     on v.placa = rf.placa_referencia
             inner join oper.v$veiculo_hist_situacao_atual vhsa
                     on vhsa.placa = v.placa
                    and vhsa.situacao_id <> 0
             inner join oper.v$veiculo_modelo vm 
                     on vm.modelo_id = v.modelo_id
             inner join oper.v$veiculo_marca vma
                     on vma.marca_id = v.marca_id
             inner join oper.v$veiculo_tipo_carroceria vtc
                     on vtc.tipo_carroceria_id = v.tipo_carroceria_id
             inner join oper.v$veiculo_agrupamento va
                     on va.agrupamento_id = vtc.agrupamento_id
             inner join oper.v$veiculo_modalidade_atual vmo
                     on vmo.placa = v.placa
                    and vmo.modalidade <> 'TERCEIRO'
             left join oper.v$evento_operacao eo 
                     on eo.controle_evo_id = rf.evo_id_desengate
              left join oper.v$veiculo_grupo vg
                     on vg.placa = v.placa
                    and sysdate between vg.data_inicio and nvl(vg.data_termino,sysdate)
              left join oper.v$evento_operacao evo
                     on evo.controle_evo_id = rf.roo_evo_id
              left join oper.v$evento_operacao_setup evs
                     on evs.num_evento = evo.num_evento
             where rf.placa_referencia is not null
               and rf.engatada = 0 
			  <cfif Len(Trim(arguments.FILTRO))>
                and (rf.placa_reboque = upper('#arguments.FILTRO#') or
                     rf.placa_referencia = replace(upper('#arguments.FILTRO#'),'-','') or
                     to_char(rf.num_romaneio) = '#arguments.FILTRO#'
                     )
              </cfif>
               <cfif Len(Trim(arguments.cod_grupo)) >
                    and vg.cod_grupo in (select vg2.cod_grupo
                                           from oper.v$veiculo_grupo_setup vg2
                                          start with vg2.cod_grupo in (#ListQualify(arguments.COD_GRUPO,"'",',')#)
                                         connect by prior vg2.cod_grupo = vg2.cod_grupo_pai) 
               </cfif>
               order by vg.cod_grupo, rf.filial_mais_proxima, (sysdate-rf.data_hora_desengate)*1440 desc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>        

	<!--- 
    -- PROPSITO
    -- Busca faturamento das carretas
    --->	
    <cffunction name="get_faturamento_carretas" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="cod_grupo" required="no" default="">
    	<cfargument name="data_inicio" required="no" default="">
    	<cfargument name="data_fim" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select vg.placa, v.cod_veiculo, vg.cod_grupo, 
                   vtc.descricao as tipo_carroceria,
                   nvl(sum(c.total_conhecimento - c.valor_icms - c.valor_icms_substit),0) as valor_faturamento
              from oper.v$veiculo_grupo vg
             inner join oper.v$veiculo v
                     on vg.placa = v.placa
             inner join oper.v$veiculo_tipo_carroceria vtc
                     on vtc.tipo_carroceria_id = v.tipo_carroceria_id
             inner join oper.v$veiculo_agrupamento va
                     on va.agrupamento_id = vtc.agrupamento_id
                    and va.tracao = 0
             left join fiscal.v$conhecimento c
                     on vg.placa = c.placa
                    and c.data_emissao between vg.data_inicio and nvl(vg.data_termino,c.data_emissao)
                    and c.cancelado is null
                    and c.conhecimento_tipo_id <> 6                     
				   <cfif Len(Trim(arguments.data_inicio)) >
                     and trunc(c.data_emissao) >= '#arguments.data_inicio#'
                   </cfif>
                   <cfif Len(Trim(arguments.data_fim)) >
                     and trunc(c.data_emissao) <= '#arguments.data_fim#'
                   </cfif>
             where vg.data_termino is null
               <cfif Len(Trim(arguments.cod_grupo)) >
                    and vg.cod_grupo in (select vg.cod_grupo
                                           from oper.v$veiculo_grupo_setup vg
                                          start with vg.cod_grupo in (#ListQualify(arguments.COD_GRUPO,"'",',')#)
                                         connect by prior vg.cod_grupo = vg.cod_grupo_pai) 
               </cfif>
            group by vg.placa, vg.cod_grupo, v.cod_veiculo, vtc.descricao
            order by vg.cod_grupo, v.cod_veiculo, vtc.descricao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>            

	<!--- 
    -- PROPSITO
    -- Calcula paradas
    -- GUTO
    --->
    <cffunction name='processa_tempo_veiculo' displayname='Exclui as solicitaes de pernoite' access='remote' returntype='Struct' output='true'>
        <cfargument name='COD_GRUPO' required='yes'>
        <cfargument name='DATA_INICIO' required='yes'>
        <cfargument name='DATA_TERMINO' required='yes'>
        <cfargument name='PERNOITE' required='no' default='0'>
        <cftry>
            <cfstoredproc procedure='oper.pkg_veiculo.prc_veiculo_pernoite' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='cf_sql_varchar' dbvarname='P_COD_GRUPO'  value='#arguments.COD_GRUPO#'>
                <cfprocparam type='IN' cfsqltype='cf_sql_varchar' dbvarname='P_DATA_INICIO'  value='#arguments.DATA_INICIO#'>
                <cfprocparam type='IN' cfsqltype='cf_sql_varchar' dbvarname='P_DATA_TERMINO'  value='#arguments.DATA_TERMINO#'>
                <cfprocparam type='IN' cfsqltype='cf_sql_varchar' dbvarname='P_PERNOITE'  value='#arguments.PERNOITE#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = ''>
        <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
        </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Busca faturamento das carretas
    --->	
    <cffunction name="get_grupo_pernoite" displayname="" output="true" returntype="query" access="public">
        <cfargument name='COD_GRUPO'        required='yes'>
        <cfargument name='DATA_INICIO'      required='yes'>
        <cfargument name='DATA_TERMINO'     required='yes'>
        <cfargument name='TEMPO_PERNOITE'   required='yes'>
        <cfargument name='FILTRO_PERNOITE'  required='yes'>
        <cfargument name='SOMENTE_ENGATADO' required='yes'>
        <cfargument name='CONTINUO'         required='yes'>
        
        <cftransaction>            
            <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select distinct a.placa as placa_cavalo
                     , a.modalidade
                     , oper.pkg_veiculo.fnc_get_cod_veiculo(a.placa) as cod_veiculo
                     , vc.placa_2 as placa_carreta
                     , nvl(a.num_romaneio, oper.pkg_romaneio.fnc_romaneio_placa_controle(a.placa,sysdate)) as romaneio
                     , nvl(kss.pkg_pessoa.fnc_get_cliente(vm.cod_pessoa), 'Sem motorista') as motorista
                     , (select s.cod_grupo || ' - ' || s.descricao
                          from oper.v$veiculo_grupo_setup s
                         where s.grupo_id = a.grupo_id) as cod_grupo
                     , kss.to_tempo(a.tempo_parado*60,1).retorno as tempo_parado
                     , case 
                          when a.referencia_id is null or a.modalidade = 'TERCEIRO' then 'No Rastreado'
                          when a.tempo_parado > (case 
                                                    when #arguments.FILTRO_PERNOITE# = 1 then (case 
                                                                                                  when a.modalidade = 'FROTA' then nvl(op.tempo_pernoite_frota, #arguments.TEMPO_PERNOITE#)
                                                                                                  else nvl(op.tempo_pernoite_agregado, #arguments.TEMPO_PERNOITE#)
                                                                                               end)
                                                    else #arguments.TEMPO_PERNOITE#
                                                 end) then 'Executado'
                       else 'No Executado' end status_pernoite
                     , nvl(r.referencia,'No Rastreado') as local
                     , case 
                          when #arguments.FILTRO_PERNOITE# = 1 then
                             op.tempo_pernoite_frota
                          else
                             #arguments.TEMPO_PERNOITE#
                       end as tempo_pernoite_frota
                     , case 
                          when #arguments.FILTRO_PERNOITE# = 1 then
                             op.tempo_pernoite_agregado
                          else
                             #arguments.TEMPO_PERNOITE#
                       end as tempo_pernoite_agregado
                  from table(oper.pkg_veiculo.fnc_veiculo_pernoite_grupo(p_data_inicial     => '#arguments.DATA_INICIO#'
                                                                        ,p_data_final       => '#arguments.DATA_TERMINO#'
                                                                        ,p_cod_grupo        => '#arguments.COD_GRUPO#'
                                                                        ,p_somente_engatado => '#arguments.SOMENTE_ENGATADO#'
                                                                        ,p_motivo			=> 'PARADO'
                                                                        ,p_continuo		    => '#arguments.CONTINUO#')) a
                  left join logistica.v$operacao op
                    on op.operacao_id = a.operacao_id
                  left join oper.v$veiculo_motorista vm
                    on vm.placa = a.placa
                   and '#arguments.DATA_INICIO#' between vm.data_inicio and nvl(vm.data_fim,'#arguments.DATA_INICIO#')
                  left join oper.v$referencia r
                    on r.referencia_id = a.referencia_id
                  left join oper.v$veiculo_composicao vc
                    on a.placa = vc.placa_1
                   and '#arguments.DATA_INICIO#' between vc.data_hora_engate and nvl(vc.data_hora_desengate,'#arguments.DATA_INICIO#')
                 order by cod_grupo
             </cfquery>
        </cftransaction>

        <cfreturn qr_result>
    </cffunction>  
    
	<!--- 
    -- PROPSITO
    -- Busca painel logistico
    --->	
    <cffunction name="get_painel_logistico_total" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="cod_grupo" required="no" default="">
    	<cfargument name="data_inicio" required="no" default="">
    	<cfargument name="data_fim" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select (select count(placa)
                      from (                                                                                                              
                             select v.placa, vma.modalidade, vs.situacao_id
                               from oper.v$veiculo v                                                                                      
                              inner join oper.v$veiculo_hist_situacao_atual vs                                                            
                                      on vs.placa = v.placa                                                                               
                              inner join oper.v$veiculo_proprietario_atual vp                                                        
                                      on vp.placa = v.placa                            
                               inner join kss.v$unidade_negocio un             
                                       on un.cod_pessoa = vp.cod_pessoa        
                               inner join oper.v$veiculo_modalidade_atual vma
                                       on vma.placa = v.placa
                               inner join oper.v$veiculo_tipo_carroceria vtc
                                       on vtc.tipo_carroceria_id = v.tipo_carroceria_id
                               inner join oper.v$veiculo_agrupamento va
                                       on va.agrupamento_id = vtc.agrupamento_id
                                      and va.controla = 1
                                where vtc.tipo_carroceria_id not in (23,220,222,189,51,140,30,148,204,50,49,48,202,200,224,174,197)
                     ) 
                      where modalidade = 'FROTA'
                        and situacao_id = 1
                   ) total_ativos
                   ,(select count(distinct ct.placa_tracao) as ativos_engatados
                       from oper.v$rank_frota ct
                      where (ct.modalidade_controle in ('FROTA','AGREGADO') or ct.modalidade_referencia in ('FROTA','AGREGADO'))
                        and ct.engatada = 1
                        and nvl(ct.cod_grupo,'SEMGRUPO') not in ('WHITE','WMTRIUNFO','WMARAUCARI','CARRO LEVE')
                        and nvl(ct.cod_grupo_cavalo,'SEMGRUPO') not in ('WHITE','WMTRIUNFO','WMARAUCARI','CARRO LEVE')
                        and upper(ct.operacao) <> 'VIAGEM TERCEIRO'
                        ) as ativos_engatados
                   ,(select count(distinct ct.placa_tracao) as ativos_engatados
                       from oper.v$rank_frota ct
                      where (ct.modalidade_controle in ('FROTA','AGREGADO') or ct.modalidade_referencia in ('FROTA','AGREGADO'))
                        and ct.engatada = 1
                        and upper(ct.operacao) = 'VIAGEM TERCEIRO'
                        and nvl(ct.cod_grupo,'SEMGRUPO') not in ('WHITE','WMTRIUNFO','WMARAUCARI','CARRO LEVE')
                        and nvl(ct.cod_grupo_cavalo,'SEMGRUPO') not in ('WHITE','WMTRIUNFO','WMARAUCARI','CARRO LEVE')
                        ) as viagens_terceiro                        
                   ,(select count(distinct ct.placa_tracao) as cv_desengatados
                       from oper.v$controle_trafego ct
                      where ct.modalidade_controle in ('FROTA')
                        and ct.engatada = 0
                        and ct.controle_situacao_id = 1
                        and (ct.maxdatahora =(select distinct max(ct2.maxdatahora) keep (dense_rank last order by ct2.maxdatahora)
                                over (partition by ct2.placa_tracao)
                           from oper.v$controle_trafego ct2
                          where ct.placa_tracao = ct2.placa_tracao) or ct.maxdatahora is null)
                        and nvl(ct.cod_grupo,'SEMGRUPO') not in ('WHITE','WMTRIUNFO','WMARAUCARI','WMJOINVILL','WMTLAGOAS', 'CARRO LEVE' )
                        and nvl(ct.cod_grupo_cavalo,'SEMGRUPO') not in ('WHITE','WMTRIUNFO','WMARAUCARI','WMJOINVILL','WMTLAGOAS', 'CARRO LEVE')) as cv_desengatados
                   ,(select count(distinct ct.placa_reboque) as sr_desengatados
                       from oper.v$rank_frota ct
                      inner join oper.v$veiculo_hist_situacao_atual vsa
                         on vsa.placa = ct.placa_referencia
                      where ct.modalidade_referencia in ('FROTA')
                        and ct.engatada = 0
                        and ct.referencia_situacao_id = 1
                        and nvl(ct.cod_grupo,'SEMGRUPO') not in ('WHITE','WMTRIUNFO','WMARAUCARI','WMJOINVILL','WMTLAGOAS','CARRO LEVE')
                        and nvl(ct.cod_grupo_cavalo,'SEMGRUPO') not in ('WHITE','WMTRIUNFO','WMARAUCARI','WMJOINVILL','WMTLAGOAS','CARRO LEVE')
                        and upper(ct.operacao) <> 'VIAGEM TERCEIRO'
                        and vsa.situacao_id = 1
                        ) as sr_desengatados
                   ,(select count(distinct placa_tracao)
                      from (select case 
                            when r.classe_id = 10 then 'Fronteira'
                            else ct.status end status,
                           ct.placa_tracao,
                           case
                             when r.classe_id = 10 and ct.segundos <= gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_FRONTEIRA') * 3600 then 0
                             when ct.status in ('Vazio','Destinado') and ct.segundos <= gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_VAZIO_DESTINADO') * 3600 then 0
                             when ct.status in ('Viagem') and ct.segundos <= gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_VIAGEM') * 3600 then 0
                             when ct.status in ('Carga') and ct.segundos <= gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_CARGA') * 3600 then 0
                             when ct.status in ('Descarga') and ct.segundos <= gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_DESCARGA') * 3600 then 0
                           else 1 end status_alerta
                      from oper.v$controle_trafego ct
                      left join oper.v$referencia r
                             on r.referencia_id = ct.referencia_id
                      where ct.modalidade_controle in ('FROTA','AGREGADO')
                        and ct.engatada = 1
                        and upper(ct.operacao) <> 'VIAGEM TERCEIRO'
                        and nvl(ct.cod_grupo,'SEMGRUPO') not in ('WHITE','WMTRIUNFO','WMARAUCARI','CARRO LEVE')
                        and nvl(ct.cod_grupo_cavalo,'SEMGRUPO') not in ('WHITE','WMTRIUNFO','WMARAUCARI', 'CARRO LEVE'))
                    where status_alerta = 1) as veiculos_alerta
              from dual
        </cfquery>
        <cfreturn qr_result>
    </cffunction>           

	<!--- 
    -- PROPSITO
    -- Busca painel logistico
    --->	
    <cffunction name="get_painel_logistico" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="cod_grupo" required="no" default="">
    	<cfargument name="data_inicio" required="no" default="">
    	<cfargument name="data_fim" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
  select status,   
                   status_alerta,   
                   to_char(count(distinct placa_tracao),'900') as veiculos
              from (select case 
                            when r.classe_id = 10 then 'Fronteira'
                              when ct.status in ('Vazio') 
                                and ((select o.dedicado
                                     from logistica.v$operacao o 
                                    where o.operacao_id = 
                                          (select max(i.OPERACAO_ID)
                                             from oper.v$romaneio_item i
                                            where i.num_romaneio = ct.num_romaneio)) = 1) then 'Viagem'
                            else ct.status end status,
                           ct.placa_tracao,
                           ct.num_romaneio,
                           case
                             when r.classe_id = 10 and ct.segundos <= gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_FRONTEIRA') * 3600 then 0
                             when ct.status in ('Vazio') and ct.segundos <= gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_VAZIO_DESTINADO') * 3600 
                               then 0
                              when ct.status in ('Vazio') and ct.segundos > gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_VAZIO_DESTINADO') * 3600 
                               then 1
                             when ct.status in ('Destinado') and ct.segundos <= gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_VAZIO_DESTINADO') * 3600 then 0
                             when ct.status in ('Viagem') and ct.segundos <= gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_VIAGEM') * 3600 then 0
                             when ct.status in ('Carga') and ct.segundos <= gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_CARGA') * 3600 then 0
                             when ct.status in ('Descarga') and ct.segundos <= gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_DESCARGA') * 3600 then 0
                             when ct.status not in ('Vazio') then 1 end status_alerta
                      from oper.v$controle_trafego ct
                      left join oper.v$referencia r
                             on r.referencia_id = ct.referencia_id
                      where ct.modalidade_controle in ('FROTA','AGREGADO')
                        and ct.engatada = 1
                        and upper(ct.operacao) <> 'VIAGEM TERCEIRO'
                        and nvl(ct.cod_grupo,'SEMGRUPO') not in ('WHITE','WMTRIUNFO','WMARAUCARI','CARRO LEVE')
                        and nvl(ct.cod_grupo_cavalo,'SEMGRUPO') not in ('WHITE','WMTRIUNFO','WMARAUCARI', 'CARRO LEVE'))
                  where status_alerta is not null
                group by status, status_alerta
        </cfquery>
        <cfreturn qr_result>
    </cffunction> 
</cfcomponent>