<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO 
    -- Retorna as gerenciadoras
    -- ANDERSON 21/12/2009 - CRIADO
    --->		
    <cffunction name="get_gerenciadora" access="remote" returntype="query" output="true">
    	<cfargument name="interna" required="no" default="">
        <cfargument name="web_service" required="no" default="">
        <cfargument name="padrao" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select g.gerenciadora_id
                 , g.descricao
                 , g.cod_pessoa
                 , p.cnpj_cpf
                 , p.razao_social
                 , p.cliente as gerenciadora
                 , g.url_acesso
                 , g.interna
                 , g.web_service
              from logistica.v$gerenciadora g
             inner join kss.v$pessoa p
                     on p.cod_pessoa = g.cod_pessoa
			 where 1 = 1
			<cfif Len(Trim(arguments.interna))>
               and g.interna = #arguments.interna#
            </cfif>
            <cfif Len(Trim(arguments.web_service))>
               and g.web_service = #arguments.web_service#
            </cfif>
            <cfif Len(Trim(arguments.padrao))>
               and g.padrao = #arguments.padrao#
            </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as liberaes de gerenciadoras
    -- ANDERSON 21/12/2009 - CRIADO
    --->		
    <cffunction name="get_gerenciadora_liberacao" access="remote" returntype="query" output="true">
    	<cfargument name="liberacao_id" required="no" default="">
        <cfargument name="gerenciadora_id" required="no" default="">
        <cfargument name="cod_liberacao" required="no" default="">
        <cfargument name="cod_motorista" required="no" default="">
        <cfargument name="veiculo_id" required="no" default="">
        <cfargument name="cod_proprietario" required="no" default="">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_termino" required="no" default="">
        <cfargument name="motorista" required="no" default="">
        <cfargument name="veiculo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select gl.liberacao_id
                 , gl.gerenciadora_id
                 , (select p.razao_social
                      from logistica.v$gerenciadora g
                     inner join kss.v$pessoa p
                             on p.cod_pessoa = g.cod_pessoa
                     where g.gerenciadora_id = gl.gerenciadora_id) as gerenciadora_razao_social
                 , to_char(gl.data_liberacao, 'dd/mm/yyyy hh24:mi:ss') as data_liberacao
                 , gl.cod_liberacao
                 , gl.usuario_liberacao
                 , gl.tipo_id
                 , gl.tipo_liberacao_id
                 , gl.situacao_id
                 , kss.fnc_ref_code('LOGISTICA', 'GERENCIADORA_LIBERACAO.SITUACAO_ID', gl.situacao_id) as situacao
                 , to_char(gl.data_inicio, 'dd/mm/yyyy') as data_inicio
                 , to_char(gl.data_termino, 'dd/mm/yyyy') as data_termino
                 , gl.nro_viagens
                 , gl.viagens_liberadas
                 , gl.veiculo_id
                 , oper.pkg_veiculo.fnc_cod_veiculo(gl.veiculo_id) as cod_veiculo
                 , oper.pkg_veiculo.fnc_placa(gl.veiculo_id) as placa
                 , gl.cod_motorista
                 , (select p.cnpj_cpf
                      from kss.v$pessoa p
                     where p.cod_pessoa = gl.cod_motorista) as cnpj_cpf_motorista
                 , (select p.cliente
                      from kss.v$pessoa p
                     where p.cod_pessoa = gl.cod_motorista) as motorista
                 , gl.motivo
                 , to_char(gl.cancelado, 'dd/mm/yyyy hh24:mi:ss') as cancelado
                 , gl.usuario_cancelamento
                 , gl.motivo_cancelamento
                 , gl.consulta
              from logistica.v$gerenciadora_liberacao gl
             where 1 = 1
			<cfif Len(Trim(arguments.liberacao_id))>
               and gl.liberacao_id = #arguments.liberacao_id#
            </cfif>
            <cfif Len(Trim(arguments.gerenciadora_id))>
               and gl.gerenciadora_id = #arguments.gerenciadora_id#
            </cfif>
            <cfif Len(Trim(arguments.cod_liberacao))>
               and upper(gl.cod_liberacao) like upper('#arguments.cod_liberacao#%')
            </cfif>
            <cfif Len(Trim(arguments.cod_motorista))>
               and gl.cod_motorista = #arguments.cod_motorista#
            </cfif>
            <cfif Len(Trim(arguments.veiculo_id))>
               and gl.veiculo_id = #arguments.veiculo_id#
            </cfif>
            <cfif Len(Trim(arguments.cod_proprietario))>
               and (select vp.cod_pessoa
                      from oper.v$veiculo_proprietario vp
                     where vp.placa = oper.pkg_veiculo.fnc_placa(gl.veiculo_id)
                       and gl.data_liberacao between vp.data_inicio and nvl(vp.data_fim, gl.data_liberacao)
                       and rownum = 1) = #arguments.cod_proprietario#
            </cfif>
            <cfif Len(Trim(arguments.data_inicio))>
               and gl.data_liberacao >= to_date('#arguments.data_inicio#', 'dd/mm/yyyy')
            </cfif>
            <cfif Len(Trim(arguments.data_termino))>
               and gl.data_liberacao <= to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
            </cfif>
            <cfif Len(Trim(arguments.motorista))>
               and gl.cod_motorista is not null
            </cfif>
            <cfif Len(Trim(arguments.veiculo))>
               and gl.veiculo_id is not null
            </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as ocorrncias de uma liberao de gerenciadora
    -- ANDERSON 26/12/2009 - CRIADO
    --->		
    <cffunction name="get_gerenciadora_liberacao_ocor" access="remote" returntype="query" output="true">
        <cfargument name="liberacao_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select o.usuario
                 , to_char(o.data, 'dd/mm/yyyy hh24:mi:ss') as data
                 , o.comentario
              from logistica.v$gerenciadora_liberacao_ocor glo
             inner join logistica.v$ocorrencia o
                     on o.ocorrencia_id = glo.ocorrencia_id
             where glo.liberacao_id = #arguments.liberacao_id#
             order by o.data
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as liberaes de um Motorista
    -- RAFAEL 22/03/2010 - CRIADO
    --->		
    <cffunction name="get_liberacao_motorista" access="remote" returntype="query" output="true">
    	<cfargument name="gerenciadora_id" required="no" default="">
        <cfargument name="data_viagem" required="yes">
        <cfargument name="operacao_id" required="no" default="">
        <cfargument name="cod_motorista" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.sinal,
                   t.liberacao_id,
                   to_char(t.data, 'dd/mm/yyyy') as data,
                   t.cpf as cnpj_cpf_motorista,
                   t.nome as motorista,
                   t.gerenciadora as gerenciadora_razao_social,
                   t.observacao,
                   to_char(t.vencimento, 'dd/mm/yyyy') as vencimento,
                   t.enviar_consulta
              from table(logistica.pkg_risco.fnc_liberacao_risco_mot_cons(p_cod_motorista => '#arguments.cod_motorista#',
                                                                          p_operacao_id => '#arguments.operacao_id#',
                                                                          p_gerenciadora_id =>  '#arguments.gerenciadora_id#',
                                                                          p_data => '#arguments.data_viagem#')) t            
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as liberaes de um Veculo
    -- RAFAEL 22/03/2010 - CRIADO
    --->		
    <cffunction name="get_liberacao_veiculo" access="remote" returntype="query" output="true">
    	<cfargument name="gerenciadora_id" required="no" default="">
        <cfargument name="data_viagem" required="no" default="">
        <cfargument name="operacao_id" required="no" default="">
        <cfargument name="veiculo_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.sinal as situacao_id,
                   t.liberacao_id,
                   to_char(t.data, 'dd/mm/yyyy') as data,
                   t.placa,
                   t.frota,
                   t.gerenciadora as gerenciadora_razao_social,
                   t.observacao,
                   to_char(t.vencimento, 'dd/mm/yyyy') as vencimento,
                   t.enviar_consulta
              from table(logistica.pkg_risco.fnc_liberacao_risco_veic_cons(p_veiculo_id => '#arguments.veiculo_id#',
                                                                           p_operacao_id => '#arguments.operacao_id#',
                                                                           p_gerenciadora_id =>  '#arguments.gerenciadora_id#',
                                                                           p_data => '#arguments.data_viagem#')) t
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna a situao de um motorista junto a gerenciadora de risco
    -- ANDERSON 23/03/2010 - CRIADO
    --->		
    <cffunction name="get_liberacao_risco_motorista" access="remote" returntype="query" output="true">
    	<cfargument name="cod_motorista" required="yes">
        <cfargument name="operacao_id" required="no" default="null">
        <cfargument name="gerenciadora_id" required="no" default="null">
        <cfargument name="data" required="no" default="sysdate">
        <cfscript>
			if(not Len(Trim(arguments.operacao_id))) {
				arguments.operacao_id = 'null';
			}
			if(not Len(Trim(arguments.gerenciadora_id))) {
				arguments.gerenciadora_id = 'null';
			}
			if(not Len(Trim(arguments.data))) {
				arguments.data = 'sysdate';
			}
		</cfscript>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select gl.situacao_id
              from logistica.v$gerenciadora_liberacao gl
             where gl.liberacao_id = logistica.pkg_risco.fnc_liberacao_risco_motorista(#arguments.cod_motorista#, #arguments.operacao_id#, #arguments.gerenciadora_id#, <cfif arguments.data eq 'sysdate'>#arguments.data#<cfelse>to_date('#arguments.data#', 'dd/mm/yyyy hh24:mi:ss')</cfif>)
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna a situao de um veculo junto a gerenciadora de risco
    -- ANDERSON 23/03/2010 - CRIADO
    --->		
    <cffunction name="get_liberacao_risco_veiculo" access="remote" returntype="query" output="true">
    	<cfargument name="cod_veiculo" required="yes">
        <cfargument name="operacao_id" required="no" default="null">
        <cfargument name="gerenciadora_id" required="no" default="null">
        <cfargument name="data" required="no" default="sysdate">
        <cfscript>
			if(not Len(Trim(arguments.operacao_id))) {
				arguments.operacao_id = 'null';
			}
			if(not Len(Trim(arguments.gerenciadora_id))) {
				arguments.gerenciadora_id = 'null';
			}
			if(not Len(Trim(arguments.data))) {
				arguments.data = 'sysdate';
			}
		</cfscript>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select gl.situacao_id
              from logistica.v$gerenciadora_liberacao gl
             where gl.liberacao_id = logistica.pkg_risco.fnc_liberacao_risco_veiculo(oper.pkg_veiculo.fnc_veiculo_id(#arguments.veiculo_id#, 'C'), #arguments.operacao_id#, #arguments.gerenciadora_id#, <cfif arguments.data eq 'sysdate'>#arguments.data#<cfelse>to_date('#arguments.data#', 'dd/mm/yyyy hh24:mi:ss')</cfif>)
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
</cfcomponent>