<cfcomponent extends="_transportes.funcoes.cfc_init">

   <!--- 
    -- PROPÓSITO 
    -- Busca estimativa de faturamento
    -- NOTAS EXPLICATIVAS
    -- LEANDROR 15/04/2010
    --->		
    <cffunction name="get_faturamento_estimativa" access="remote" returntype="query" output="true">
        <cfargument name="cod_centro_custo" required="no" default="">   
        <cfargument name="data_ontem" required="no" default="">                                 
        <cfargument name="data_estimativa" required="no" default="">                         
        <cfargument name="data_estimativa_inicio" required="no" default="">
        <cfargument name="data_estimativa_fim" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select fe.estimativa_id
            	 , fe.cod_centro_custo
                 , (select cc.centro_custo
                 	  from kss.v$centro_custo cc
                     where cc.cod_centro_custo = fe.cod_centro_custo) as centro_custo
                 , to_char(fe.data_estimativa, 'dd/mm/yyyy') as data_estimativa
                 , fe.valor_estimado
              from fiscal.v$faturamento_estimativa fe
             where 1 = 1
              <cfif Len(Trim(arguments.cod_centro_custo))>
                and fe.cod_centro_custo = #arguments.cod_centro_custo#
             </cfif>
   			 <cfif Len(Trim(arguments.data_ontem))>
                and fe.data_estimativa >= to_date('#arguments.data_ontem#', 'dd/mm/yyyy')
             </cfif>
			 <cfif Len(Trim(arguments.data_estimativa))>
                and fe.data_estimativa = to_date('#arguments.data_estimativa#', 'dd/mm/yyyy')
             </cfif>             
			 <cfif Len(Trim(arguments.data_estimativa_inicio))>
                and fe.data_estimativa >= to_date('#arguments.data_estimativa_inicio#', 'dd/mm/yyyy')
             </cfif>
              <cfif Len(Trim(arguments.data_estimativa_fim))>
                and fe.data_estimativa <= to_date('#arguments.data_estimativa_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
             </cfif>
             order by centro_custo, fe.data_estimativa
        </cfquery>
        <cfreturn qr_result>		
	</cffunction>  	
    
   <!--- 
    -- PROPÓSITO 
    -- Busca indicador centro custo
    -- NOTAS EXPLICATIVAS
    -- GUTO 15/04/2010
    --->		
    <cffunction name="get_faturamento_indicador" access="remote" returntype="query" output="true">
        <cfargument name="cod_centro_custo" required="no" default="">   
        <cfargument name="data" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.meta_id
                 , t.cod_centro_custo
                 , kss.pkg_organograma.fnc_centro_custo(o.cod_centro_custo) as centro_custo
                 , o.cod_unidade_negocio
                 , kss.pkg_organograma.fnc_unidade_negocio(o.cod_pessoa) as unidade_negocio
                 , to_char(t.data,'dd/mm/yyyy') as data
                 , t.valor_meta
                 , nvl(t.valor_estimado,0) as valor_estimado
                 , nvl(round(t.valor_estimado / t.valor_meta * 100,2),0) as perc_estimado
                 , t.valor_solicit_executadas
                 , round(t.valor_solicit_executadas / t.valor_meta * 100,2) as perc_solicit_executadas
                 , t.valor_realizado
                 , round(t.valor_realizado / t.valor_meta * 100,2) as perc_realizado
                 , t.valor_custo_cf
                 , t.valor_receita_cf
                 , t.valor_custo_cf_avulsa as valor_custo_cf_avulsa
                 , t.count_cf_avulsa as count_cf_avulsa
                 , case
                      when t.valor_receita_cf > 0 then
                         round(t.valor_custo_cf / t.valor_receita_cf * 100, 1)
                      else
                         0
                   end as perc_carta_frete
              from fiscal.v$faturamento_painel t
             inner join kss.v$organograma o
                on o.cod_centro_custo = t.cod_centro_custo
             where t.valor_meta is not null
               and t.data = '#arguments.DATA#'
               <cfif Len(Trim(arguments.COD_CENTRO_CUSTO))>
               and t.cod_centro_custo = #arguments.COD_CENTRO_CUSTO#
               </cfif>
             order by t.data, t.valor_estimado desc nulls last, t.valor_meta desc
         </cfquery>
        <cfreturn qr_result>		
	</cffunction>    

   <!--- 
    -- PROPÓSITO 
    -- Busca indicador centro custo
    -- NOTAS EXPLICATIVAS
    -- GUTO 15/04/2010
    --->		
    <cffunction name="get_faturamento_indicador_empresa" access="remote" returntype="query" output="true">
        <cfargument name="data" required="no" default="">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_termino" required="no" default="">
        <cfargument name="acumulado" required="no" default="0">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select sum(t.valor_meta) as valor_meta
            	 <cfif arguments.ACUMULADO eq 0>
                   , to_char(t.data,'dd/mm/yyyy') as data
                 </cfif>
                 , sum(nvl(t.valor_estimado,0)) as valor_estimado
                 , nvl(round(sum(t.valor_estimado) / sum(t.valor_meta) * 100,2),0) as perc_estimado
                 , sum(t.valor_solicit_executadas) as valor_solicit_executadas
                 , round(sum(t.valor_solicit_executadas) / sum(t.valor_meta) * 100,2) as perc_solicit_executadas
                 , sum(t.valor_realizado) as valor_realizado
                 , round(sum(t.valor_realizado) / sum(t.valor_meta) * 100,2) as perc_realizado
                 , sum(t.valor_custo_cf) as valor_custo_cf
                 , sum(t.valor_receita_cf) as valor_receita_cf
                 , sum(t.valor_custo_cf_avulsa) as valor_custo_cf_avulsa
                 , sum(t.count_cf_avulsa) as count_cf_avulsa
                 , case
                      when sum(t.valor_receita_cf) > 0 then
                         round(sum(t.valor_custo_cf) / sum(t.valor_receita_cf) * 100, 1)
                      else
                         0
                   end as perc_carta_frete
         	     <cfif arguments.ACUMULADO eq 1>
                     ,max((select sum(fm.valor)
                         from fiscal.v$faturamento_meta fm
                        where fm.data > '#arguments.DATA_TERMINO#'
                          and fm.data <= last_day('#arguments.DATA_TERMINO#'))) as valor_meta_restante
                     ,max((select sum(fm.valor)
                             from fiscal.v$faturamento_meta fm
                            where trunc(fm.data,'month') = trunc(to_date('#arguments.DATA_TERMINO#','dd/mm/yyyy'),'month'))) as valor_meta_total
                 </cfif>
              from fiscal.v$faturamento_painel t
             inner join kss.v$centro_custo o
                on o.cod_centro_custo = t.cod_centro_custo
             where t.valor_meta is not null
              <cfif Len(Trim(arguments.DATA))>
               and t.data = '#arguments.DATA#'
              </cfif>
              <cfif Len(Trim(arguments.DATA_INICIO))>
               and t.data >= '#arguments.DATA_INICIO#'
              </cfif>
              <cfif Len(Trim(arguments.DATA_TERMINO))>
               and t.data <= '#arguments.DATA_TERMINO#'
              </cfif>
         	  <cfif arguments.ACUMULADO eq 0>
                group by to_char(t.data,'dd/mm/yyyy')
              </cfif>
              order by data
         </cfquery>
        <cfreturn qr_result>		
	</cffunction>    

  <!--- 
    -- PROPÓSITO 
    -- Busca indicador centro custo
    -- NOTAS EXPLICATIVAS
    -- GUTO 15/04/2010
    --->		
    <cffunction name="get_faturamento_indicador_centro_custo" access="remote" returntype="query" output="true">
        <cfargument name="data" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_termino" required="no" default="">
        <cfargument name="acumulado" required="no" default="0">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select sum(t.valor_meta) as valor_meta
                 , cc.centro_custo, cc.cod_centro_custo
            	 <cfif arguments.ACUMULADO eq 0>
                 , to_char(t.data,'dd/mm/yyyy') as data
                 </cfif>
                 , sum(nvl(t.valor_estimado,0)) as valor_estimado
                 , nvl(round(sum(t.valor_estimado) / sum(t.valor_meta) * 100,2),0) as perc_estimado
                 , sum(t.valor_solicit_executadas) as valor_solicit_executadas
                 , round(sum(t.valor_solicit_executadas) / sum(t.valor_meta) * 100,2) as perc_solicit_executadas
                 , sum(t.valor_realizado) as valor_realizado
                 , round(sum(t.valor_realizado) / sum(t.valor_meta) * 100,2) as perc_realizado
                 , sum(t.valor_custo_cf) as valor_custo_cf
                 , sum(t.valor_receita_cf) as valor_receita_cf
                 , case
                      when sum(t.valor_receita_cf) > 0 then
                         round((sum(t.valor_custo_cf) / sum(t.valor_receita_cf)) * 100, 1)
                      else
                         0
                   end as perc_carta_frete                 
              from fiscal.v$faturamento_painel t
             inner join kss.v$centro_custo o
                on o.cod_centro_custo = t.cod_centro_custo
             inner join kss.v$centro_custo cc
                     on cc.cod_centro_custo = o.cod_centro_custo
             where t.valor_meta is not null
               <cfif Len(Trim(arguments.COD_CENTRO_CUSTO))>
               and t.cod_centro_custo = #arguments.COD_CENTRO_CUSTO#
               </cfif>
              <cfif Len(Trim(arguments.DATA))>
               and t.data = '#arguments.DATA#'
              </cfif>
              <cfif Len(Trim(arguments.DATA_INICIO))>
               and t.data >= '#arguments.DATA_INICIO#'
              </cfif>
              <cfif Len(Trim(arguments.DATA_TERMINO))>
               and t.data <= '#arguments.DATA_TERMINO#'
              </cfif>
              group by <cfif arguments.ACUMULADO eq 0>to_char(t.data,'dd/mm/yyyy'), </cfif>cc.centro_custo, cc.cod_centro_custo
              order by <cfif arguments.ACUMULADO eq 0>data<cfelse>valor_estimado</cfif>
         </cfquery>
        <cfreturn qr_result>		
	</cffunction>      

    <!--- 
    -- PROPÓSITO 
    -- Retorna um período para plotar o gráfico 
    -- GUTO 15/06/2010 - CRIADO
    --->		
    <cffunction name="get_periodo" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="yes">
        <cfargument name="data_termino" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select to_char(t.data, 'dd/mm/yyyy') as data
                 , extract(day from (t.data)) as dia
              from (
                    select to_date('#arguments.data_inicio#', 'dd/mm/yyyy') + level - 1 as data
                      from dual
                   connect by level <= to_date('#arguments.data_termino#', 'dd/mm/yyyy') - to_date('#arguments.data_inicio#', 'dd/mm/yyyy') + 1
                   ) t
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
     <!--- 
    -- PROPÓSITO 
    -- Retorna os centros de custo para a ALL
    -- FABIOG 14/07/2011 - CRIADO
    --->		
    <cffunction name="get_centro_custos" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select cc.cod_centro_custo
                 , cc.centro_custo
              from kss.v$centro_custo cc
             where cc.cod_centro_custo >= 8000
        </cfquery>
        <cfreturn qr_result>
    </cffunction>    
    

   <!--- 
    -- PROPÓSITO 
    -- Busca estimativa de faturamento gerencial
    -- MARIA 25/10/2011
    --->		
    <cffunction name="get_faturamento_estimativa_gerencial" access="remote" returntype="query" output="true">
        <cfargument name="cod_centro_custo" required="no" default="">   
        <cfargument name="data_ontem" required="no" default="">                                 
        <cfargument name="data_estimativa" required="no" default="">                         
        <cfargument name="data_estimativa_inicio" required="no" default="">
        <cfargument name="data_estimativa_fim" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select fe.estimativa_id
            	 , fe.organizacional_id_gerencial as cod_centro_custo
                 , kss.pkg_organizacional.fnc_descricao_completa(fe.cod_centro_custo) as centro_custo
                 , to_char(fe.data_estimativa, 'dd/mm/yyyy') as data_estimativa
                 , fe.valor_estimado
              from fiscal.v$fat_estimativa_gerencial fe
             where 1 = 1
              <cfif Len(Trim(arguments.cod_centro_custo))>
                and fe.organizacional_id_gerencial = #arguments.cod_centro_custo#
             </cfif>
   			 <cfif Len(Trim(arguments.data_ontem))>
                and fe.data_estimativa >= to_date('#arguments.data_ontem#', 'dd/mm/yyyy')
             </cfif>
			 <cfif Len(Trim(arguments.data_estimativa))>
                and fe.data_estimativa = to_date('#arguments.data_estimativa#', 'dd/mm/yyyy')
             </cfif>             
			 <cfif Len(Trim(arguments.data_estimativa_inicio))>
                and fe.data_estimativa >= to_date('#arguments.data_estimativa_inicio#', 'dd/mm/yyyy')
             </cfif>
              <cfif Len(Trim(arguments.data_estimativa_fim))>
                and fe.data_estimativa <= to_date('#arguments.data_estimativa_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
             </cfif>
             order by organizacional_id_gerencial, fe.data_estimativa
        </cfquery>
        <cfreturn qr_result>		
	</cffunction>  	
    
   <!--- 
    -- PROPÓSITO 
    -- Busca indicador centro custo gerencial
    -- MARIA 25/10/2011
    --->		
    <cffunction name="get_faturamento_indicador_gerencial" access="remote" returntype="query" output="true">
        <cfargument name="cod_centro_custo" required="no" default="">   
        <cfargument name="data" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.meta_id
                 , t.organizacional_id_gerencial as cod_centro_custo
                 , kss.pkg_organizacional.fnc_descricao_completa(o.organizacional_id) as centro_custo_completo
                 , o.cod_organizacional ||'  ' || o.descricao as centro_custo
                 , to_char(t.data,'dd/mm/yyyy') as data
                 , t.valor_meta
                 , nvl(t.valor_estimado,0) as valor_estimado
                 , nvl(round(t.valor_estimado / t.valor_meta * 100,2),0) as perc_estimado
                 , t.valor_solicit_executadas
                 , round(t.valor_solicit_executadas / t.valor_meta * 100,2) as perc_solicit_executadas
                 , t.valor_realizado
                 , round(t.valor_realizado / t.valor_meta * 100,2) as perc_realizado
                 , t.valor_custo_cf
                 , t.valor_receita_cf
                 , t.valor_custo_cf_avulsa as valor_custo_cf_avulsa
                 , t.count_cf_avulsa as count_cf_avulsa
                 , case
                      when t.valor_receita_cf > 0 then
                         round(t.valor_custo_cf / t.valor_receita_cf * 100, 1)
                      else
                         0
                   end as perc_carta_frete
              from fiscal.v$faturamento_painel_gerencial t
             inner join kss.v$organizacional o
                on o.organizacional_id = t.organizacional_id_gerencial
             where t.valor_meta is not null
               and t.data = '#arguments.DATA#'
               <cfif Len(Trim(arguments.COD_CENTRO_CUSTO))>
               and t.organizacional_id_gerencial = #arguments.COD_CENTRO_CUSTO#
               </cfif>
             order by t.data, t.valor_estimado desc nulls last, t.valor_meta desc
         </cfquery>
        <cfreturn qr_result>		
	</cffunction>    

   <!--- 
    -- PROPÓSITO 
    -- Busca indicador centro custo gerencial
    -- MARIA 25/10/2011
    --->		
    <cffunction name="get_faturamento_indicador_empresa_gerencial" access="remote" returntype="query" output="true">
        <cfargument name="data" required="no" default="">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_termino" required="no" default="">
        <cfargument name="acumulado" required="no" default="0">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select sum(t.valor_meta) as valor_meta
            	 <cfif arguments.ACUMULADO eq 0>
                   , to_char(t.data,'dd/mm/yyyy') as data
                 </cfif>
                 , sum(nvl(t.valor_estimado,0)) as valor_estimado
                 , nvl(round(sum(t.valor_estimado) / sum(t.valor_meta) * 100,2),0) as perc_estimado
                 , sum(t.valor_solicit_executadas) as valor_solicit_executadas
                 , round(sum(t.valor_solicit_executadas) / sum(t.valor_meta) * 100,2) as perc_solicit_executadas
                 , sum(t.valor_realizado) as valor_realizado
                 , round(sum(t.valor_realizado) / sum(t.valor_meta) * 100,2) as perc_realizado
                 , sum(t.valor_custo_cf) as valor_custo_cf
                 , sum(t.valor_receita_cf) as valor_receita_cf
                 , sum(t.valor_custo_cf_avulsa) as valor_custo_cf_avulsa
                 , sum(t.count_cf_avulsa) as count_cf_avulsa
                 , case
                      when sum(t.valor_receita_cf) > 0 then
                         round(sum(t.valor_custo_cf) / sum(t.valor_receita_cf) * 100, 1)
                      else
                         0
                   end as perc_carta_frete
         	     <cfif arguments.ACUMULADO eq 1>
                     ,max((select sum(fm.valor)
                         from fiscal.v$faturamento_meta_gerencial fm
                        where fm.data > '#arguments.DATA_TERMINO#'
                          and fm.data <= last_day('#arguments.DATA_TERMINO#'))) as valor_meta_restante
                     ,max((select sum(fm.valor)
                             from fiscal.v$faturamento_meta_gerencial fm
                            where trunc(fm.data,'month') = trunc(to_date('#arguments.DATA_TERMINO#','dd/mm/yyyy'),'month'))) as valor_meta_total
                 </cfif>
              from fiscal.v$faturamento_painel_gerencial t
             inner join kss.v$organizacional o
                on o.organizacional_id = t.organizacional_id_gerencial   
             where t.valor_meta is not null
              <cfif Len(Trim(arguments.DATA))>
               and t.data = '#arguments.DATA#'
              </cfif>
              <cfif Len(Trim(arguments.DATA_INICIO))>
               and t.data >= '#arguments.DATA_INICIO#'
              </cfif>
              <cfif Len(Trim(arguments.DATA_TERMINO))>
               and t.data <= '#arguments.DATA_TERMINO#'
              </cfif>
         	  <cfif arguments.ACUMULADO eq 0>
                group by to_char(t.data,'dd/mm/yyyy')
              </cfif>
              order by data
         </cfquery>
        <cfreturn qr_result>		
	</cffunction>    

  <!--- 
    -- PROPÓSITO 
    -- Busca indicador centro custo gerencial
    -- MARIA 25/10/2011
    --->		
    <cffunction name="get_faturamento_indicador_centro_custo_gerencial" access="remote" returntype="query" output="true">
        <cfargument name="data" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_termino" required="no" default="">
        <cfargument name="acumulado" required="no" default="0">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select sum(t.valor_meta) as valor_meta
                 , kss.pkg_organizacional.fnc_descricao_completa(cc.organizacional_id) as centro_custo
                 , cc.organizacional_id as cod_centro_custo
            	 <cfif arguments.ACUMULADO eq 0>
                 , to_char(t.data,'dd/mm/yyyy') as data
                 </cfif>
                 , sum(nvl(t.valor_estimado,0)) as valor_estimado
                 , nvl(round(sum(t.valor_estimado) / sum(t.valor_meta) * 100,2),0) as perc_estimado
                 , sum(t.valor_solicit_executadas) as valor_solicit_executadas
                 , round(sum(t.valor_solicit_executadas) / sum(t.valor_meta) * 100,2) as perc_solicit_executadas
                 , sum(t.valor_realizado) as valor_realizado
                 , round(sum(t.valor_realizado) / sum(t.valor_meta) * 100,2) as perc_realizado
                 , sum(t.valor_custo_cf) as valor_custo_cf
                 , sum(t.valor_receita_cf) as valor_receita_cf
                 , case
                      when sum(t.valor_receita_cf) > 0 then
                         round((sum(t.valor_custo_cf) / sum(t.valor_receita_cf)) * 100, 1)
                      else
                         0
                   end as perc_carta_frete                 
              from fiscal.v$faturamento_painel_gerencial t
             inner join kss.v$organizacional cc
                on cc.organizacional_id = t.organizacional_id_gerencial 
             where t.valor_meta is not null
               <cfif Len(Trim(arguments.COD_CENTRO_CUSTO))>
               and t.cod_centro_custo = #arguments.COD_CENTRO_CUSTO#
               </cfif>
              <cfif Len(Trim(arguments.DATA))>
               and t.data = '#arguments.DATA#'
              </cfif>
              <cfif Len(Trim(arguments.DATA_INICIO))>
               and t.data >= '#arguments.DATA_INICIO#'
              </cfif>
              <cfif Len(Trim(arguments.DATA_TERMINO))>
               and t.data <= '#arguments.DATA_TERMINO#'
              </cfif>
              group by <cfif arguments.ACUMULADO eq 0>to_char(t.data,'dd/mm/yyyy'), </cfif>kss.pkg_organizacional.fnc_descricao_completa(cc.organizacional_id), cc.organizacional_id
              order by <cfif arguments.ACUMULADO eq 0>data<cfelse>valor_estimado</cfif>
         </cfquery>
        <cfreturn qr_result>		
	</cffunction>    
    
    
</cfcomponent>