<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO 
    -- Retorna os rastreadores
    -- ANDERSON 03/03/2011 - CRIADO
    --->		
    <cffunction name="get_rastreador" access="remote" returntype="query" output="true">
    	<cfargument name="num_rastreador" required="no" default="">
        <cfargument name="cod_conta" required="no" default="">
        <cfargument name="cnpj_proprietario" required="no" default="">
        <cfargument name="proprietario" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.rastreador_id
                 , r.num_rastreador
                 , rc.cod_conta
                 , p.identificador as cnpj_proprietario
                 , p.razao_social as proprietario
                 , (select cg.rv_abbreviation
                      from integracao.cg_ref_codes cg
                     where cg.rv_domain = 'RASTREADOR.STATUS_ID'
                       and cg.rv_low_value = r.status_id
                   ) as situacao
              from integracao.v$rastreador r
             inner join integracao.v$rastreador_conta rc
                     on rc.conta_id = r.conta_id
             inner join kss.v$pessoa p
                     on p.cod_pessoa = rc.cod_proprietario
             where 1 = 1
			<cfif Len(Trim(arguments.num_rastreador))>
               and r.num_rastreador = '#arguments.num_rastreador#'
			</cfif>
            <cfif Len(Trim(arguments.cod_conta))>
               and rc.cod_conta like '#arguments.cod_conta#%'
			</cfif>
            <cfif Len(Trim(arguments.cnpj_proprietario))>
               and p.cnpj_cpf like '#arguments.cnpj_proprietario#%' 
            </cfif>
            <cfif Len(Trim(arguments.proprietario))>
               and upper(p.razao_social) like upper('#arguments.proprietario#%')
            </cfif>
             order by r.num_rastreador
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os tipos de macros
    -- ANDERSON 03/03/2011 - CRIADO
    --->		
    <cffunction name="get_macro_tipo" access="remote" returntype="query" output="true">
    	<cfargument name="parametro" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cg.rv_low_value as tipo_id
                 , cg.rv_abbreviation as descricao
              from integracao.cg_ref_codes cg
             where cg.rv_domain = 'MACRO.TIPO_ID'
             order by cg.rv_low_value
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as macros
    -- ANDERSON 03/03/2011 - CRIADO
    --->		
    <cffunction name="get_macro" access="remote" returntype="query" output="true">
    	<cfargument name="macro_id" required="no" default="">
    	<cfargument name="num_macro" required="no" default="">
        <cfargument name="descricao" required="no" default="">
        <cfargument name="modelo" required="no" default="">
        <cfargument name="tipo_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select m.macro_id
                 , m.num_macro
                 , m.versao
                 , m.descricao
                 , rm.descricao as modelo
                 , (select cg.rv_abbreviation
                      from integracao.cg_ref_codes cg
                     where cg.rv_low_value = m.situacao_id
                       and cg.rv_domain = 'MACRO.SITUACAO_ID'
                   ) as situacao
                 , (select cg.rv_abbreviation
                      from integracao.cg_ref_codes cg
                     where cg.rv_low_value = m.tipo_id
                       and cg.rv_domain = 'MACRO.TIPO_ID'
                   ) as tipo
                 , rc.cod_conta
              from integracao.v$macro m
             inner join integracao.v$rastreador_modelo rm
                     on rm.modelo_id = m.modelo_id
              left join integracao.v$rastreador_conta rc
                     on rc.conta_id = m.conta_id
             where 1 = 1
			<cfif Len(Trim(arguments.macro_id))>
               and m.macro_id = #arguments.macro_id#
			</cfif>
            <cfif Len(Trim(arguments.num_macro))>
               and m.num_macro = #arguments.num_macro#
			</cfif>
            <cfif Len(Trim(arguments.descricao))>
               and upper(m.descricao) like upper('#arguments.descricao#%')
			</cfif>
            <cfif Len(Trim(arguments.modelo))>
               and upper(rm.descricao) like upper('#arguments.modelo#%')
			</cfif>
            <cfif Len(Trim(arguments.tipo_id))>
               and m.tipo_id = #arguments.tipo_id#
			</cfif>
             order by m.num_macro
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os modelos de rastreadores
    -- ANDERSON 03/03/2011 - CRIADO
    --->		
    <cffunction name="get_rastreador_modelo" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select rm.modelo_id
                 , rm.descricao
              from integracao.v$rastreador_modelo rm
             order by rm.descricao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as contas de rastreadores
    -- ANDERSON 03/03/2011 - CRIADO
    --->		
    <cffunction name="get_rastreador_conta" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select rc.conta_id
                 , rc.descricao
                 , rc.modelo_id
             from integracao.v$rastreador_conta rc
            where rc.ativa = 1
            order by rc.descricao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as situaes das mensagens
    -- ANDERSON 29/07/2010 - CRIADO
    --->
    <cffunction name="get_mensagem_situacao" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ms.situacao_id
                 , ms.descricao
              from integracao.v$mensagem_situacao ms
             order by ms.descricao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os tipos das mensagens
    -- ANDERSON 29/07/2010 - CRIADO
    --->
    <cffunction name="get_mensagem_tipo" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select mt.tipo_id
                 , mt.descricao
              from integracao.v$mensagem_tipo mt
             order by mt.tipo_id
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as mensagens para o Controle de Mensagens
    -- ANDERSON 29/07/2010 - CRIADO
    --->
    <cffunction name="get_controle_mensagens" access="remote" returntype="query" output="true">
    	<cfargument name="mensagem_id" required="no" default="">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_termino" required="no" default="">
        <cfargument name="placa" required="no" default="">
        <cfargument name="situacao_id" required="no" default="">
        <cfargument name="tipo_id" required="no" default="">
        
        <cfif Len(Trim(arguments.placa))>
        	<cfquery name="qr_veiculo_id" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select v.veiculo_id
                  from integracao.v$veiculo v
                 where v.cod_veiculo = '#arguments.placa#'
			</cfquery>
        </cfif>
        
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" maxrows="500">
            select m.mensagem_id
                 , m.num_mensagem
                 , m.lida
                 , decode(m.lida, 1, 'Lida', 'No Lida') as lida_descricao
                 , m.cod_frota
                 , m.cod_veiculo
                 , m.num_rastreador
                 , m.tipo
                 , m.macro
                 , to_char(m.data_envio, 'dd/mm/yyyy hh24:mi:ss') as data_envio
                 , to_char(m.data_integracao, 'dd/mm/yyyy hh24:mi:ss') as data_integracao
                 , to_char(m.data_recebimento, 'dd/mm/yyyy hh24:mi:ss') as data_recebimento
                 , m.erro
                 , m.situacao_id
                 , m.situacao
                 , em.controle_evo_id
                 , (select sit.rv_abbreviation
                      from integracao.cg_ref_codes sit
                     where sit.rv_domain = 'MENSAGEM.SITUACAO_INTEGRACAO_ID'
                       and sit.rv_low_value = em.situacao_integracao_id
                   ) as situacao_evento
                 , m.landmark
                 , (select max(mrh.cod_registro)
                      from oper.v$veiculo_motorista vm
                     inner join oper.v$motorista_reg_historico mrh
                             on mrh.cod_pessoa = vm.cod_pessoa
                            and nvl(vm.data_fim, sysdate) between mrh.data_inicio and nvl(mrh.data_fim, sysdate)
                     where vm.placa = m.cod_veiculo
                       and nvl(m.data_envio, m.data_recebimento) between vm.data_inicio and nvl(vm.data_fim, nvl(m.data_envio, m.data_recebimento))
                   ) as cod_registro_motorista
                 , (select min(pf.cliente)
                      from oper.v$veiculo_motorista vm
                     inner join kss.v$pessoa pf
                             on pf.cod_pessoa = vm.cod_pessoa
                     where vm.placa = m.cod_veiculo
                       and nvl(m.data_envio, m.data_recebimento) between vm.data_inicio and nvl(vm.data_fim, nvl(m.data_envio, m.data_recebimento))
                   ) as nome_motorista
                 , m.descricao_conta
                 , m.cod_conta
                 , m.user_update
                 , to_char(m.date_update, 'dd/mm/yyyy hh24:mi:ss') as date_update
              from integracao.v$controle_mensagens m
              left join integracao.v$evento_mensagem em
                     on em.mensagem_id = m.mensagem_id                           
             where 1 = 1
            <cfif Len(Trim(arguments.mensagem_id))>
               and m.mensagem_id = #arguments.mensagem_id#
            </cfif>
			<cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_termino))>
               and nvl(m.data_envio, m.data_recebimento) between to_date('#arguments.data_inicio#:00', 'dd/mm/yyyy hh24:mi:ss') and to_date('#arguments.data_termino#:59', 'dd/mm/yyyy hh24:mi:ss')
            </cfif>
            <cfif Len(Trim(arguments.situacao_id))>
               and m.situacao_id in (#arguments.situacao_id#)
            </cfif>
            <cfif Len(Trim(arguments.tipo_id))>
               and m.tipo_id in (#arguments.tipo_id#)
            </cfif>
            <cfif IsDefined("qr_veiculo_id") and qr_veiculo_id.RecordCount>
               and m.veiculo_id in (#ValueList(qr_veiculo_id.VEICULO_ID, ',')#)
            </cfif>
             order by nvl(m.data_envio, m.data_recebimento) desc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna o contedo traduzido de uma mensagem
    -- ANDERSON 29/07/2010 - CRIADO
    --->		
    <cffunction name="get_conteudo_traduzido" access="remote" returntype="query" output="true">
    	<cfargument name="mensagem_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select '/' || sys_connect_by_path(a.node_name, '/') || '/text()' as xpath
                 , a.node_id
                 , a.node_parent
                 , a.node_name
                 , (select a.node_name ||
                           case
                              when max(m.descricao) is not null then ' (' || max(m.descricao) || ')'
                              else ''
                           end
                      from integracao.v$macro_parametro m
                     inner join integracao.v$mensagem ms
                             on ms.macro_id = m.macro_id
                            and ms.mensagem_id = #arguments.mensagem_id#
                     where 'CAMPO' || m.ordem = a.node_name
                   ) as node_descricao
                 , a.node_value
                 , level
                 , (select count(*)
                      from table(integracao.fnc_get_xml_tree((select (xmltype.createxml(m.conteudo_traduzido)).getStringVal()
                                                                from integracao.v$mensagem m
                                                               where m.mensagem_id = #arguments.mensagem_id#
                                                             )
                                                            )) t
                     where t.node_parent = a.node_id
                   ) as possui_filhos
              from table(integracao.fnc_get_xml_tree((select (xmltype.createxml(m.conteudo_traduzido)).getStringVal()
                                                        from integracao.v$mensagem m
                                                       where m.mensagem_id = #arguments.mensagem_id#
                                                     )
                                                    )) a,
                   dual j
             start with a.node_parent = -1
           connect by prior a.node_id = a.node_parent
             order siblings by a.node_id
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna a visualizao de uma mensagem
    -- ANDERSON 29/07/2010 - CRIADO
    --->
    <cffunction name="get_visualizacao_mensagem" access="remote" returntype="query" output="true">
    	<cfargument name="mensagem_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select m.conteudo_visor
              from integracao.v$mensagem m
             where m.mensagem_id = #arguments.mensagem_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna o contedo original de uma mensagem
    -- ANDERSON 29/07/2010 - CRIADO
    --->		
    <cffunction name="get_conteudo_original" access="remote" returntype="query" output="true">
    	<cfargument name="mensagem_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select '/' || sys_connect_by_path(t.node_name, '/') || '/text()' as xpath
                 , t.node_id
                 , t.node_parent
                 , t.node_name
                 , t.node_value
                 , level
              from table(integracao.fnc_get_xml_tree((select (xmltype.createxml(m.conteudo_original)).getStringVal()
                                                        from integracao.v$mensagem m
                                                       where m.mensagem_id = #arguments.mensagem_id#
                                                     )
                                                    )) t
             start with t.node_parent = -1
           connect by prior t.node_id = t.node_parent
             order siblings by t.node_id
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna se o usurio possui acesso para editar os dados das mensagens
    -- ANDERSON 29/07/2010 - CRIADO
    --->		
    <cffunction name="get_permite_edicao_dados_mensagem" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select decode(trim(t.permite), '', 1, kss.pkg_string.fnc_verifica_lista(user, upper(t.permite))) as permite
              from (
                    select kss.pkg_global.fnc_parametro_str(11, 'OPERACIONAL', 17, 328) as permite
                      from dual 
                   ) t
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
</cfcomponent>