<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO 
	-- Busca status para os tickets
	-- GUTO 16/01/2010 - CRIADO
	--->  		
	<cffunction name="get_ticket_status" access="remote" returntype="query" output="true">
		<cfargument name="status_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select status_id, descricao_suporte, cor_suporte, descricao_producao, 
                   cor_producao, descricao_cliente, cor_cliente, tempo_alerta
              from kmm.v$ticket_status 
             where 1=1
		 	<cfif len(trim(arguments.status_id))>
               and status_id = #arguments.status_id#
			</cfif>
  		</cfquery>
		<cfreturn qr_result>		
	</cffunction>    

	<!--- 
	-- PROPSITO 
	-- Busca prioridade para os tickets
	-- GUTO 16/01/2010 - CRIADO
	--->  		
	<cffunction name="get_ticket_prioridade" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select tp.prioridade_id, tp.descricao
              from kmm.v$ticket_prioridade tp    
              order by tp.prioridade_id
  		</cfquery>
		<cfreturn qr_result>		
	</cffunction>   
    
	<!--- 
	-- PROPSITO 
	-- Busca tickets
	-- GUTO 16/01/2010 - CRIADO
	--->  		
	<cffunction name="get_ticket" access="remote" returntype="query" output="true">
        <cfargument name="num_ticket" required="no" default=""/>
        <cfargument name="cliente_id" required="no" default=""/>
        <cfargument name="status_id" required="no" default=""/>
        <cfargument name="responsabilidade" required="no" default=""/>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.num_ticket, t.titulo, t.cliente_id, t.solicitante_id,
                   t.prioridade_id, t.status_id, t.modulo_id, to_char(t.data_abertura,'dd/mm/yyyy') as data_abertura,
                   c.nome as cliente, m.nome as modulo, r.nome_completo as solicitante, tp.descricao as prioridade,
                   t.texto
              from kmm.v$ticket t
             inner join kmm.v$cliente c
                     on c.cliente_id = t.cliente_id
             inner join kmm.v$modulo m
                     on m.modulo_id = t.modulo_id
             inner join kmm.v$recurso r
                     on r.recurso_id = t.solicitante_id 
             inner join kmm.v$ticket_status ts
		             on ts.status_id = t.status_id
             inner join kmm.v$ticket_prioridade tp
                     on tp.prioridade_id = t.prioridade_id                     
             where 1=1
             <cfif Len(Trim(arguments.num_ticket))>
                and t.num_ticket = #arguments.num_ticket#
             </cfif> 
             <cfif Len(Trim(arguments.cliente_id))>
                and t.cliente_id = #arguments.cliente_id#
             </cfif> 
             <cfif Len(Trim(arguments.status_id))>
                and t.status_id = #arguments.status_id#
             </cfif> 
             <cfif Len(Trim(arguments.responsabilidade))>
                and ts.responsabilidade = #arguments.responsabilidade#
             </cfif> 
            order by t.cliente_id, t.data_abertura             
  		</cfquery>
		<cfreturn qr_result>		
	</cffunction>         
</cfcomponent>