<cfcomponent extends="_transportes.funcoes.cfc_init">

	<!--- 
	-- PROPSITO 
	-- Busca os containers para o repositorio com os ambientes
	-- CRISTOFER  27/08/2009
	--->		
	<cffunction name="get_container_repositorio_ambiente" access="remote" returntype="query" output="true">
    	<cfargument name="repositorio_id" required="no" default="">
    	<cfargument name="recurso_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select c.container_id, 
                   c.servidor_id, 
                   c.cod_container, 
                   c.nome, 
                   r.cod_repositorio,
                   r.nome as nome_repositorio,
                   to_char(a.data,'dd/mm/yyyy hh24:mi:ss') as data_origem,
                   to_char(a.data_criacao,'dd/mm/yyyy hh24:mi:ss') as data_criacao,
                   a.usuario_criacao,
                   a.ambiente_id,
                   c.descricao, 
                   c.tipo_id, 
                   c.situacao_id, 
                   (select count(*)
                      from infraestrutura.v$ambiente_recurso ar
                     where ar.ambiente_id = a.ambiente_id
                       and ar.data_liberacao is null) as reservas,
                   (select min(ar.restricao_id)
                      from infraestrutura.v$ambiente_recurso ar
                     where ar.ambiente_id = a.ambiente_id
                       and ar.recurso_id = '#arguments.recurso_id#'
                       and ar.data_liberacao is null) as restricao_id,
                   (select count(*)
                      from infraestrutura.v$container_atividade ca
                     where ca.container_id = c.container_id
                       and ca.situacao_id in (1,2)) atividades_pendentes,
                   (select count(*)
                      from infraestrutura.v$container_atividade ca
                     where ca.container_id = c.container_id
                       and ca.situacao_id in (4)) atividades_erro,
                   to_char(c.date_insert,'dd/mm/yyyy hh24:mi:ss') as date_insert, 
                   c.user_insert, 
                   to_char(c.date_update,'dd/mm/yyyy hh24:mi:ss') as date_update, 
                   c.user_update, 
                   c.site
              from infraestrutura.v$container c
             inner join infraestrutura.v$container_repositorio cr
                     on cr.container_id = c.container_id
             inner join infraestrutura.v$repositorio r
                     on r.repositorio_id = cr.repositorio_id
              left join infraestrutura.v$ambiente a
                     on cr.container_id = a.container_id
                    and cr.repositorio_id = cr.repositorio_id
                    and a.ativo = 1
             where 1=1
             <cfif len(trim(arguments.repositorio_id))>
               and cr.repositorio_id = #arguments.repositorio_id#
             </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
	<!--- 
	-- PROPSITO 
	-- Busca os repositorios
	-- CRISTOFER  27/08/2009
	--->		
	<cffunction name="get_repositorio" access="remote" returntype="query" output="true">
    	<cfargument name="repositorio_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.repositorio_id, 
                   r.cod_repositorio, 
                   r.nome, 
                   r.descricao, 
                   r.limite_servidor, 
                   r.producao, 
                   r.atualizavel, 
                   r.data_atualizacao, 
                   r.tipo_id, 
                   r.date_insert, 
                   r.user_insert, 
                   r.date_update, 
                   r.user_update, 
                   r.site
              from infraestrutura.v$repositorio r
             where 1=1
             <cfif len(trim(arguments.repositorio_id))>
               and r.repositorio_id = #arguments.repositorio_id#
             </cfif>
             order by r.nome
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>         	    

	<!--- 
	-- PROPSITO 
	-- Busca os ambientes
	-- CRISTOFER  27/08/2009
	--->		
	<cffunction name="get_ambiente" access="remote" returntype="query" output="true">
    	<cfargument name="container_id" required="no" default="">
    	<cfargument name="repositorio_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ambiente_id, 
                   repositorio_id, 
                   container_id, 
                   to_char(data,'dd/mm/yyyy hh24:mi:ss') as data, 
                   ativo, 
                   to_char(data_inativacao,'dd/mm/yyyy hh24:mi:ss') as data_inativacao, 
                   usuario_inativacao, 
                   to_char(data_criacao,'dd/mm/yyyy hh24:mi:ss') as data_criacao, 
                   usuario_criacao, 
                   to_char(data_exclusao,'dd/mm/yyyy hh24:mi:ss') as data_exclusao, 
                   usuario_exclusao, 
                   to_char(date_insert,'dd/mm/yyyy hh24:mi:ss') as date_insert, 
                   user_insert, 
                   to_char(date_update,'dd/mm/yyyy hh24:mi:ss') as date_update, 
                   user_update, 
                   site
              from infraestrutura.v$ambiente a
             where 1=1
             <cfif len(trim(arguments.container_id))>
               and a.container_id = #arguments.container_id#
             </cfif>
             <cfif len(trim(arguments.repositorio_id))>
               and a.repositorio_id = #arguments.repositorio_id#
             </cfif>
             order by a.data_criacao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>         	    

	<!--- 
	-- PROPSITO 
	-- Busca as atividades para o ambiente
	-- CRISTOFER  28/08/2009
	--->		
	<cffunction name="get_container_atividade" access="remote" returntype="query" output="true">
    	<cfargument name="container_id" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select atividade_id,
                   container_id,
                   descricao,
                   execute_immediate,
                   usuario,
                   to_char(data,'dd/mm/yyyy hh24:mi:ss') as data,
                   situacao_id,
                   (select c.rv_abbreviation
                      from infraestrutura.cg_ref_codes c
                     where c.rv_domain = 'CONTAINER_ATIVIDADE.SITUACAO_ID'
                       and c.rv_low_value = ca.situacao_id) situacao,
                   to_char(data_inicio,'dd/mm/yyyy hh24:mi:ss') as data_inicio,
                   to_char(data_termino,'dd/mm/yyyy hh24:mi:ss') as data_termino,
                   erro,
                   to_char(date_insert,'dd/mm/yyyy hh24:mi:ss') as date_insert,
                   user_insert,
                   to_char(date_update,'dd/mm/yyyy hh24:mi:ss') as date_update,
                   user_update,
                   site
              from infraestrutura.v$container_atividade ca
             where 1=1
             <cfif len(trim(arguments.container_id))>
               and ca.container_id = 1
             </cfif>
             <cfif len(trim(arguments.situacao_id))>
               and ca.situacao_id in (#arguments.situacao_id#)
             </cfif>
             order by ca.atividade_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>  
	<!--- 
	-- PROPSITO 
	-- Busca os recursos que reservaram um ambiente
	-- CRISTOFER  09/09/2009
	--->		
	<cffunction name="get_ambiente_recurso" access="remote" returntype="query" output="true">
    	<cfargument name="ambiente_id" required="no" default="">
        <cfargument name="ativo" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ar.restricao_id, 
                   ar.ambiente_id, 
                   ar.recurso_id, 
                   r.nome,
                   r.nome_completo,
                   to_char(ar.data_insercao,'dd/mm/yyyy hh24:mi:ss') as data_insercao, 
                   to_char(ar.data_liberacao,'dd/mm/yyyy hh24:mi:ss') as data_liberacao, 
                   ar.date_insert, 
                   ar.user_insert, 
                   ar.date_update, 
                   ar.user_update, 
                   ar.site 
              from infraestrutura.v$ambiente_recurso ar
             inner join kmm.v$recurso r
                     on r.recurso_id = ar.recurso_id    
             where 1=1
             <cfif arguments.ativo eq 1>
               and ar.data_liberacao is null
             </cfif>
             <cfif len(trim(arguments.ambiente_id))>
               and ar.ambiente_id = #arguments.ambiente_id#
             </cfif>
             order by r.nome_completo
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>         	    
    
    <!--- 
	-- PROPSITO 
	-- Busca os dados da CG_REF_CODES
	-- CRISTOFER  16/04/2009
	--->		
	<cffunction name="get_cg_ref_codes" access="remote" returntype="query" output="true">
    	<cfargument name="rv_domain" required="yes">
    	<cfargument name="rv_low_value" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select rv_domain, 
                   rv_low_value, 
                   rv_high_value, 
                   rv_abbreviation, 
                   rv_meaning
              from infraestrutura.cg_ref_codes
             where 1=1
               and rv_domain = '#arguments.rv_domain#'
             <cfif len(trim(arguments.rv_low_value))>
               and rv_low_value in (#arguments.rv_low_value#)
             </cfif>
             order by rv_low_value
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>         	           	    

</cfcomponent>