<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO 
	-- Busca projetos em execuo
	-- GUTO 05/08/2009 - CRIADO
	--->  		
	<cffunction name="get_cliente_projetos" access="remote" returntype="query" output="true">
		<cfargument name="cliente_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select p.projeto_id, p.codigo as codigo_projeto, p.titulo as titulo_projeto
              from kmm.v$projeto p
	         where nvl(p.data_fechamento,sysdate-1) > sysdate
		 	<cfif len(trim(arguments.cliente_id))>
               and p.cliente_id = #arguments.cliente_id#
			</cfif>
            order by p.projeto_id 
  		</cfquery>
		<cfreturn qr_result>		
	</cffunction>    

	<!--- 
	-- PROPSITO 
	-- Busca projetos, sds, tarefas
	-- GUTO 05/08/2009 - CRIADO
	--->  		
	<cffunction name="get_projetos_tarefas" access="remote" returntype="query" output="true">
		<cfargument name="cliente_id" required="no" default="">
		<cfargument name="status_id_sd" required="no" default="">
		<cfargument name="sd_id" required="no" default="">
		<cfargument name="tipo_id" required="no" default="">
		<cfargument name="data" required="no" default="">
		<cfargument name="mes_entrega" required="no" default="">
		<cfargument name="ano_entrega" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select p.codigo || '-' || p.titulo as projeto
            	   ,sd.codigo || '-' || sd.titulo as sd_nome
                   ,cgs.descricao as status_sd, sd.status_id as sd_status_id ,t.tarefa_id, nvl(t.titulo,'No possui tarefas cadastradas') as titulo_tarefa
            	   ,cg.descricao as tipo_tarefa
                   ,nvl(cgt.descricao,'Aberto') as status_tarefa, nvl(t.status,12) as tarefa_status_id
                   ,to_char(nvl(t.finalizada_em,t.entregar_em),'dd/mm/yyyy') as entregar_em
                   ,to_char(t.entregar_em,'mm/yyyy') as mes_ano
                   ,kss.to_tempo(t.tempo_estimado,3).retorno as tempo_estimado
                   ,kss.to_tempo(kss.sum_dsinterval(t.tempo_estimado) over(partition by sd.sd_id order by sd.sd_id),3).retorno as total_sd
                   ,kss.to_tempo(kss.sum_dsinterval(t.tempo_estimado) over(),3).retorno as total
				   ,(select to_char(max(sdd.data_disponibilizacao),'mm/yyyy')
                      from kmm.v$sd_detalhamento sdd
                     where sdd.sd_id = sd.sd_id) as mes_disponibilizacao
              from kmm.v$projeto p
             inner join kmm.v$sd sd
                     on p.projeto_id = sd.projeto_id
             inner join kmm.v$cg_ref_codes cgs
                     on cgs.id = sd.status_id
                    and cgs.dominio = 'SD STATUS' 
             left join kmm.v$tarefa t
                     on t.sd_id = sd.sd_id
             left join kmm.v$cg_ref_codes cg
                     on cg.id = t.tipo_id
                    and cg.dominio = 'TIPO TAREFA' 
             left join kmm.v$cg_ref_codes cgt
                     on cgt.id = t.status
                    and cgt.dominio = 'STATUS TAREFA'
			 where 1=1
               and t.status not in (5,8)
			<cfif len(trim(arguments.sd_id))>
               and sd.sd_id = #arguments.sd_id#
			</cfif>
			<cfif len(trim(arguments.tipo_id))>
               and sd.tipo_id = #arguments.tipo_id#
			</cfif>
			<cfif len(trim(arguments.data))>
               and trunc(nvl(t.finalizada_em,t.entregar_em)) = '#arguments.data#'
			</cfif>
			<cfif len(trim(arguments.cliente_id))>
               and p.cliente_id = #arguments.cliente_id#
			</cfif>
			<cfif len(trim(arguments.status_id_sd))>
               and sd.status_id in (#arguments.status_id_sd#)
			</cfif>           
			<cfif len(trim(arguments.mes_entrega))>
               and  (select max(sdd.data_disponibilizacao)
                      from kmm.v$sd_detalhamento sdd
                     where sdd.sd_id = sd.sd_id) between to_date('01/#arguments.mes_entrega#/#arguments.ano_entrega#','dd/mm/yyyy') and last_day(to_date('01/#arguments.mes_entrega#/#arguments.ano_entrega#','dd/mm/yyyy'))
			</cfif>           
            order by p.projeto_id, sd.sd_id, t.entregar_em
  		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca sds que possuem tarefas para entregar em uma determinada data.
	-- GUTO 05/08/2009 - CRIADO
	--->  		
	<cffunction name="get_sd_entrega_data" access="remote" returntype="query" output="true">
		<cfargument name="cliente_id" required="no" default="">
		<cfargument name="projeto_id" required="no" default="">
		<cfargument name="data" required="no" default="">
		<cfargument name="mes" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select distinct sd.sd_id, sd.codigo as codigo_sd, 
                   sd.titulo as titulo_sd, 
                   cgs.descricao as status_sd, sd.status_id
              from kmm.v$tarefa t
             inner join kmm.v$cg_ref_codes cg
                     on cg.id = t.tipo_id
                    and cg.dominio = 'TIPO TAREFA' 
             inner join kmm.v$cg_ref_codes cgt
                     on cgt.id = t.status
                    and cgt.dominio = 'STATUS TAREFA'
             inner join kmm.v$sd_tarefa st
                     on st.tarefa_id = t.tarefa_id
             inner join kmm.v$sd sd
                     on sd.sd_id = st.sd_id
             inner join kmm.v$cg_ref_codes cgs
                     on cgs.id = sd.status_id
                    and cgs.dominio = 'SD STATUS' 
             inner join kmm.v$projeto p
                     on p.projeto_id = sd.projeto_id
			 where t.status <> 8
			<cfif len(trim(arguments.cliente_id))>
               and p.cliente_id = #arguments.cliente_id#
			</cfif>
			<cfif len(trim(arguments.projeto_id))>
               and p.projeto_id = #arguments.projeto_id#
			</cfif>
			<cfif len(trim(arguments.data)) and not Len(Trim(arguments.mes))>
               and trunc(nvl(t.finalizada_em,t.entregar_em)) = '#arguments.data#'
			</cfif>            
			<cfif len(trim(arguments.mes))>
               and nvl(t.finalizada_em,t.entregar_em) between trunc(to_date('#arguments.data#','dd/mm/yyyy'),'MONTH') and last_day(to_date('#arguments.data#','dd/mm/yyyy'))+1
			</cfif>            
            order by sd.codigo
  		</cfquery>
		<cfreturn qr_result>		
	</cffunction>    

</cfcomponent>