<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO 
    -- Retorna datas de um intervalo
    -- GUTO 01/07/2010 - CRIADO
    --->		
    <cffunction name="get_intervalo_datas" access="remote" returntype="query" output="true">
        <cfargument name="DATA_INICIAL" required="no" default=""/>
        <cfargument name="DATA_FINAL" required="no" default=""/>
        <cfargument name="DIA" required="no" default="1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31"/>
        <cfargument name="MES" required="no" default="1,2,3,4,5,6,7,8,9,10,11,12"/>
        <cfif not Len(Trim(arguments.MES))>
           <cfset arguments.MES = "1,2,3,4,5,6,7,8,9,10,11,12"/>
        </cfif>
                
        <cfif not Len(Trim(arguments.DATA_INICIAL))>
		   <cfset arguments.DATA_INICIAL = ArrayMin(ListToArray(arguments.DIA)) & '/' & ArrayMax(ListToArray(arguments.MES)) & '/2010'>
           <cfif DaysInMonth(CreateDate(2010,ArrayMax(ListToArray(arguments.MES)),1)) gt ArrayMax(ListToArray(arguments.DIA))>
		       <cfset arguments.DATA_FINAL =  ArrayMax(ListToArray(arguments.DIA)) & '/' & ArrayMax(ListToArray(arguments.MES)) & '/2010'>
           <cfelse>
		       <cfset arguments.DATA_FINAL =  DaysInMonth(CreateDate(2010,ArrayMax(ListToArray(arguments.MES)),1)) & '/' & ArrayMax(ListToArray(arguments.MES)) & '/2010'>
           </cfif>
  		   <cfif not Len(Trim(arguments.DIA))>
				<cfset arguments.DATA_INICIAL = '01' & '/' & ArrayMax(ListToArray(arguments.MES)) & '/2010'>
                <cfset arguments.DATA_FINAL = DaysInMonth(CreateDate(2010,ArrayMax(ListToArray(arguments.MES)),1)) & '/' & ArrayMax(ListToArray(arguments.MES)) & '/2010'>
           </cfif>
		</cfif>
        
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select * 
  			  from (select to_char(trunc(to_date('#arguments.DATA_FINAL#','dd/mm/yyyy'))-(level-1),'yyyymmdd') as cod_data,
                   to_char(trunc(to_date('#arguments.DATA_FINAL#','dd/mm/yyyy'))-(level-1),'dd') as dia,
                   to_char(trunc(to_date('#arguments.DATA_FINAL#','dd/mm/yyyy'))-(level-1),'mm') as mes,
                   to_char(trunc(to_date('#arguments.DATA_FINAL#','dd/mm/yyyy'))-(level-1),'yyyy') as ano,
                   to_char(trunc(to_date('#arguments.DATA_FINAL#','dd/mm/yyyy'))-(level-1),'dd/mm/yyyy') as data,
                   to_char(trunc(to_date('#arguments.DATA_FINAL#','dd/mm/yyyy'))-(level-1),'dd/mon') as data_formatada
              from dual
            connect by level <= to_date('#arguments.DATA_FINAL#','dd/mm/yyyy')-(to_date('#arguments.DATA_INICIAL#','dd/mm/yyyy')-1)
            order by cod_data)
            where 1=1
		   <cfif Len(Trim(arguments.DIA))>
                and dia in (#arguments.DIA#)
           </cfif>
           <cfif Len(Trim(arguments.MES))>
                and mes in (#arguments.MES#) 
           </cfif>   
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

	<!--- 
    -- PROPSITO 
    -- Retorna centro custo
    -- GUTO 01/07/2010 - CRIADO
    --->		
    <cffunction name="get_centro_custo" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cc.cod_centro_custo, cc.centro_custo, cc.ativo
              from kss.v$centro_custo cc
              where cc.ativo = 1
            order by cc.centro_custo
        </cfquery>
        <cfreturn qr_result>
    </cffunction>    

	<!--- 
    -- PROPSITO 
    -- Retorna conta
    -- GUTO 01/07/2010 - CRIADO
    --->		
    <cffunction name="get_plano_contas" access="remote" returntype="query" output="true">
        <cfargument name="CONTA_ID" required="no" default=""/>
        <cfargument name="PERMITE_MANUAL" required="no" default=""/>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select substr(replace(sys_connect_by_path(replace(pl.nome,' ','@@'), ' '),'@@',' '),2) as conta,
                   pl.formula,
                   pl.conta_id,
                   pl.conta_id_pai,
                   pl.nome,
                   pl.permite_manual,
                   pl.debito_credito,
                   connect_by_isleaf as folha,
                   level as nivel
              from gerencial.v$plano_contas pl
             where pl.ativo = 1
             <cfif Len(Trim(arguments.PERMITE_MANUAL))>
               and pl.permite_manual = #arguments.PERMITE_MANUAL#
             </cfif>
             start with pl.conta_id_pai is null
            connect by prior pl.conta_id = pl.conta_id_pai
            order siblings by pl.ordem
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

	<!--- 
    -- PROPSITO 
    -- Retorna acumulado mes
    -- GUTO 01/07/2010 - CRIADO
    --->		
    <cffunction name="get_datas_acumulado" access="remote" returntype="query" output="true">
        <cfargument name="DIA" required="no" default="1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31"/>
        <cfargument name="MES" required="no" default="1,2,3,4,5,6,7,8,9,10,11,12"/>
        <cfargument name="ORDEM" required="no" default="1"/>
        <cfif not Len(Trim(arguments.MES))>
           <cfset arguments.MES = "1,2,3,4,5,6,7,8,9,10,11,12"/>
        </cfif>

	    <cfset arguments.DATA_INICIAL = ArrayMin(ListToArray(arguments.DIA)) & '/' & ArrayMin(ListToArray(arguments.MES)) & '/2010'>
	    <cfif DaysInMonth(CreateDate(2010,ArrayMax(ListToArray(arguments.MES)),1)) gt ArrayMax(ListToArray(arguments.DIA))>
           <cfset arguments.DATA_FINAL =  ArrayMax(ListToArray(arguments.DIA)) & '/' & ArrayMax(ListToArray(arguments.MES)) & '/2010'>
        <cfelse>
           <cfset arguments.DATA_FINAL =  DaysInMonth(CreateDate(2010,ArrayMax(ListToArray(arguments.MES)),1)) & '/' & ArrayMax(ListToArray(arguments.MES)) & '/2010'>
        </cfif>
        <cfif not Len(Trim(arguments.DIA))>
             <cfset arguments.DATA_INICIAL = '01' & '/' & ArrayMin(ListToArray(arguments.MES)) & '/2010'>
             <cfset arguments.DATA_FINAL = DaysInMonth(CreateDate(2010,ArrayMax(ListToArray(arguments.MES)),1)) & '/' & ArrayMax(ListToArray(arguments.MES)) & '/2010'>
        </cfif>
        
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select 'AC'||min(cod_data)  as cod_data,
                   mes_ano,
                   data_formatada,
                   min(data) as data_inicio,
                   max(data) as data_fim
              from (select * 
                      from (select to_char(trunc(to_date('#arguments.DATA_FINAL#','dd/mm/yyyy'))-(level-1),'yyyymmdd') as cod_data,
                           to_char(trunc(to_date('#arguments.DATA_FINAL#','dd/mm/yyyy'))-(level-1),'dd') as dia,
                           to_char(trunc(to_date('#arguments.DATA_FINAL#','dd/mm/yyyy'))-(level-1),'mm') as mes,
                           to_char(trunc(to_date('#arguments.DATA_FINAL#','dd/mm/yyyy'))-(level-1),'yyyy') as ano,
                           to_char(trunc(to_date('#arguments.DATA_FINAL#','dd/mm/yyyy'))-(level-1),'mmyyyy') as mes_ano,
                           to_char(trunc(to_date('#arguments.DATA_FINAL#','dd/mm/yyyy'))-(level-1),'dd/mm/yyyy') as data,
                           to_char(trunc(to_date('#arguments.DATA_FINAL#','dd/mm/yyyy'))-(level-1),'mon/yyyy') as data_formatada
                      from dual
                    connect by level <= to_date('#arguments.DATA_FINAL#','dd/mm/yyyy')-(to_date('#arguments.DATA_INICIAL#','dd/mm/yyyy')-1)
                    order by cod_data)
                    where 1=1
                   <cfif Len(Trim(arguments.DIA))>
                        and dia in (#arguments.DIA#)
                   </cfif>
                   <cfif Len(Trim(arguments.MES))>
                        and mes in (#arguments.MES#) 
                   </cfif>  
                   )
            group by mes_ano,data_formatada
            order by cod_data <cfif arguments.ordem eq 1>desc</cfif>     
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
        	
	<!--- 
    -- PROPSITO 
    -- Retorna contas
    -- GUTO 01/07/2010 - CRIADO
    --->		
    <cffunction name="get_plano_contas_resultado" access="remote" returntype="query" output="true">
        <cfargument name="DATA_INICIAL" required="no" default=""/>
        <cfargument name="DATA_FINAL" required="no" default=""/>
        <cfargument name="DIA" required="no" default=""/>
        <cfargument name="MES" required="no" default=""/>
        <cfargument name="COD_CENTRO_CUSTO" required="no" default="null"/>
        <cfargument name="CONTA_ID_PAI" required="no" default=""/>
        
        <cfif not Len(Trim(arguments.DATA_INICIAL))>
		   <cfset arguments.DATA_INICIAL = ArrayMin(ListToArray(arguments.DIA)) & '/' & ArrayMax(ListToArray(arguments.MES)) & '/2010'>
 		   <cfif DaysInMonth(CreateDate(2010,ArrayMax(ListToArray(arguments.MES)),1)) gt ArrayMax(ListToArray(arguments.DIA))>
               <cfset arguments.DATA_FINAL =  ArrayMax(ListToArray(arguments.DIA)) & '/' & ArrayMax(ListToArray(arguments.MES)) & '/2010'>
           <cfelse>
               <cfset arguments.DATA_FINAL =  DaysInMonth(CreateDate(2010,ArrayMax(ListToArray(arguments.MES)),1)) & '/' & ArrayMax(ListToArray(arguments.MES)) & '/2010'>
           </cfif>
  		   <cfif not Len(Trim(arguments.DIA))>
				<cfset arguments.DATA_INICIAL = '01' & '/' & ArrayMax(ListToArray(arguments.MES)) & '/2010'>
                <cfset arguments.DATA_FINAL = DaysInMonth(CreateDate(2010,ArrayMax(ListToArray(arguments.MES)),1)) & '/' & ArrayMax(ListToArray(arguments.MES)) & '/2010'>
           </cfif>
		</cfif>        

        <cfif not Len(Trim(arguments.COD_CENTRO_CUSTO))>
           <cfset arguments.COD_CENTRO_CUSTO = 'null'>
        </cfif>
        
        <cfscript>
		   if (Len(Trim(arguments.DIA))) {
			   qrDatas = this.get_intervalo_datas(argumentCollection = arguments);
		   }
		   qrDatasAcumulados = this.get_datas_acumulado(argumentCollection = arguments);
		</cfscript>
        
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select substr(replace(sys_connect_by_path(replace(pl.nome,' ','@@'), ' '),'@@',' '),2) as conta,
                   <cfif IsDefined("qrDatas")>
                      #qrDatas.COD_DATA# as cod_data,
                   </cfif>
                   #arguments.COD_CENTRO_CUSTO# as cod_centro_custo,
                   level as nivel,
                   <cfif Len(Trim(arguments.DIA))>
                       <cfloop query="qrDatas">
                           nvl(decode(pl.debito_credito,0,-1,1) * gerencial.pkg_formula.fnc_obtem_valor(pl.conta_id,'[CONTA_ID]:'||pl.conta_id||',[DATA_INICIO]:#qrDatas.DATA#,[DATA_FIM]:#qrDatas.DATA#,[COD_CENTRO_CUSTO]:#arguments.cod_centro_custo#'),0) as valor_#qrDatas.COD_DATA#,
                       </cfloop>
                   </cfif>

                   <cfloop query="qrDatasAcumulados">
	                   nvl(decode(pl.debito_credito,0,-1,1) * gerencial.pkg_formula.fnc_obtem_valor(pl.conta_id,'[CONTA_ID]:'||pl.conta_id||',[DATA_INICIO]:#qrDatasAcumulados.DATA_INICIO#,[DATA_FIM]:#qrDatasAcumulados.DATA_FIM#,[COD_CENTRO_CUSTO]:#arguments.cod_centro_custo#'),0) as valor_acumulado_#qrDatasAcumulados.COD_DATA#,
                   </cfloop>

                   '#arguments.DATA_INICIAL#' as data_inicio,
                   '#arguments.DATA_FINAL#' as data_fim,
                   pl.nome,
                   pl.conta_id, 
                   pl.formula, 
                   pl.permite_manual,
                   pl.debito_credito,
                   connect_by_isleaf as folha
              from gerencial.v$plano_contas pl
             where 1=1
             and pl.ativo = 1
             start with pl.conta_id_pai is null
            connect by prior pl.conta_id = pl.conta_id_pai
            order siblings by pl.ordem  
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

	<!--- 
    -- PROPSITO 
    -- Retorna rateio por fornecedor
    -- GUTO 01/07/2010 - CRIADO
    --->		
    <cffunction name="get_fornecedor_rateio_notas" access="remote" returntype="query" output="true">
        <cfargument name="DATA_INICIO" required="yes"/>
        <cfargument name="DATA_FIM" required="yes"/>
        <cfargument name="COD_CENTRO_CUSTO" required="no" default=""/>
        <cfargument name="PLANO_CONTA_ID" required="no" default=""/>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cod_pessoa,
                   fornecedor as fornecedor, 
                   sum(valor_rateio_proporcional) as valor
              from (
            select t.pedido_id,
                   t.solicitacao_id,
                   s.titulo,
                   s.data_emissao as data_solicitacao,
                   t.cod_pessoa,
                   t.fornecedor,
                   t.nome_fantasia,
                   t.data_emissao_nf,
                   t.data_entrada_nf,
                   t.valor,
                   t.valor_nf,
                   t.num_nota_id, 
                   sum(t.valor_nf) over(partition by t.num_nota_id) as valor_total_nota, 
                   <cfif Len(Trim(arguments.COD_CENTRO_CUSTO))>
                      gerencial.pkg_resultado_filial.fnc_valor_rateio_nota_cc(t.num_nota_id,#arguments.COD_CENTRO_CUSTO#) * (t.valor_nf/sum(t.valor_nf) over(partition by t.num_nota_id)) as valor_rateio_proporcional
                   <cfelse>
                      gerencial.pkg_resultado_filial.fnc_valor_rateio_nota_conta(t.num_nota_id,#arguments.PLANO_CONTA_ID#) * (t.valor_nf/sum(t.valor_nf) over(partition by t.num_nota_id)) as valor_rateio_proporcional
                   </cfif>
              from compras.v$solicitacao_fornecedor t
              inner join compras.v$solicitacao s
                      on s.solicitacao_id = t.solicitacao_id
              inner join compras.v$area a
                      on a.area_id = s.area_id
            <cfif Len(Trim(arguments.PLANO_CONTA_ID))>  
              inner join table(gerencial.pkg_plano_contas.fnc_conta_sucessores(#arguments.PLANO_CONTA_ID#)) pl
                      on pl.conta_id = a.plano_conta_id
            </cfif>
            where t.data_entrada_nf between '#arguments.DATA_INICIO#' and to_date('#arguments.DATA_FIM# 23:59:59','dd/mm/yyyy hh24:mi:ss')
            <cfif Len(Trim(arguments.COD_CENTRO_CUSTO))>
            and t.num_nota_id in (select nt.num_nota_id
                                    from fiscal.v$nf_terceiro nt
                                   inner join fiscal.v$nf_terceiro_rateio ntr
                                           on ntr.num_nota_id = nt.num_nota_id
                                  where nt.data_entrada between '#arguments.DATA_INICIO#' and to_date('#arguments.DATA_FIM# 23:59:59','dd/mm/yyyy hh24:mi:ss')
                                    and exists (select 0
                                                  from kss.v$organizacional o
                                                 inner join gerencial.v$ccusto_organizacional cco
                                                         on cco.cod_centro_custo = #arguments.COD_CENTRO_CUSTO#
                                                        and cco.organizacional_id = o.organizacional_id
                                                 where o.organizacional_id = ntr.organizacional_id_gerencial))
	         </cfif>                                                 
              )
            group by cod_pessoa, fornecedor
            order by valor desc 
        </cfquery>
        <cfreturn qr_result>
    </cffunction>    

	<!--- 
    -- PROPSITO 
    -- Retorna rateio por fornecedor
    -- GUTO 01/07/2010 - CRIADO
    --->		
    <cffunction name="get_rateio_fornecedor_detalhe" access="remote" returntype="query" output="true">
        <cfargument name="DATA_INICIO" required="yes"/>
        <cfargument name="DATA_FIM" required="yes"/>
        <cfargument name="COD_CENTRO_CUSTO" required="no" default=""/>
        <cfargument name="PLANO_CONTA_ID" required="no" default=""/>
        <cfargument name="COD_PESSOA" required="no" default=""/>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.pedido_id,
                   t.solicitacao_id,
                   s.num_controle as num_solicitacao,
                   s.titulo as titulo_solicitacao,
                   a.descricao as area,
                   (select e.cod_equipamento
                      from almoxarifado.v$equipamento e
                     where e.equipamento_id = s.equipamento_id) as cod_equipamento, 
                   (select pr.cliente
                      from kss.v$pessoa pr
                     where s.COD_PESSOA_EMISSAO = pr.cod_pessoa) as responsavel,                     
                   compras.pkg_compras.fnc_get_usuario_ocorrencia(s.solicitacao_id, kss.pkg_global.fnc_parametro_num(11,'OPERACIONAL',33,419)) as usuario_aprovacao,
                   to_char(s.data_emissao,'dd/mm/yyyy') as data_solicitacao,
                   t.cod_pessoa,
                   t.fornecedor,
                   t.nome_fantasia,
                   to_char(t.data_emissao_nf,'dd/mm/yyyy') as data_emissao_nf,
                   to_char(t.data_entrada_nf,'dd/mm/yyyy') as data_entrada_nf,
                   t.valor,
                   t.valor_nf,
                   t.num_nota_id, 
                   nf.num_nota_fiscal,
                   sum(t.valor_nf) over(partition by t.num_nota_id) as valor_total_nota, 
                   <cfif Len(Trim(arguments.COD_CENTRO_CUSTO))>
                      gerencial.pkg_resultado_filial.fnc_valor_rateio_nota_cc(t.num_nota_id,#arguments.COD_CENTRO_CUSTO#) * (t.valor_nf/sum(t.valor_nf) over(partition by t.num_nota_id)) as valor_rateio_proporcional
                   <cfelse>
                      gerencial.pkg_resultado_filial.fnc_valor_rateio_nota_conta(t.num_nota_id,#arguments.PLANO_CONTA_ID#) * (t.valor_nf/sum(t.valor_nf) over(partition by t.num_nota_id)) as valor_rateio_proporcional
                   </cfif>
              from compras.v$solicitacao_fornecedor t
              inner join compras.v$solicitacao s
                      on s.solicitacao_id = t.solicitacao_id
              inner join compras.v$area a
                      on a.area_id = s.area_id
			<cfif Len(Trim(arguments.PLANO_CONTA_ID))>  
              inner join table(gerencial.pkg_plano_contas.fnc_conta_sucessores(#arguments.PLANO_CONTA_ID#)) pl
                      on pl.conta_id = a.plano_conta_id
            </cfif>                      
              left join fiscal.v$nf_terceiro nf
                     on nf.num_nota_id = t.num_nota_id  
            where t.data_entrada_nf between '#arguments.DATA_INICIO#' and to_date('#arguments.DATA_FIM# 23:59:59','dd/mm/yyyy hh24:mi:ss')
              and t.cod_pessoa = #arguments.COD_PESSOA#
            <cfif Len(Trim(arguments.COD_CENTRO_CUSTO))>
            and t.num_nota_id in (select nt.num_nota_id
                                    from fiscal.v$nf_terceiro nt
                                   inner join fiscal.v$nf_terceiro_rateio ntr
                                           on ntr.num_nota_id = nt.num_nota_id
                                  where nt.data_entrada between '#arguments.DATA_INICIO#' and to_date('#arguments.DATA_FIM# 23:59:59','dd/mm/yyyy hh24:mi:ss')
                                    and exists (select 0
                                                  from kss.v$organizacional o
                                                 inner join gerencial.v$ccusto_organizacional cco
                                                         on cco.cod_centro_custo = #arguments.COD_CENTRO_CUSTO#
                                                        and cco.organizacional_id = o.organizacional_id
                                                 where o.organizacional_id = ntr.organizacional_id_gerencial))
	         </cfif>
             order by num_solicitacao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>        
    
	<!--- 
    -- PROPSITO 
    -- Retorna datas de um intervalo
    -- GUTO 01/07/2010 - CRIADO
    --->		
    <cffunction name="get_lancamento_manual_conta" access="remote" returntype="query" output="true">
        <cfargument name="DATA_INICIO" required="no" default=""/>
        <cfargument name="DATA_FIM" required="no" default=""/>
        <cfargument name="PLANO_CONTA_ID" required="no" default=""/>
        <cfargument name="COD_CENTRO_CUSTO" required="no" default=""/>
        <cfargument name="LANCAMENTO_ID" required="no" default=""/>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select pcl.lancamento_id, 
            	   pcl.conta_id,
                   pcl.cod_centro_custo,
                   cc.centro_custo,
                   gerencial.pkg_plano_contas.fnc_nome_conta_completo(pcl.conta_id) as conta,
                   to_char(pcl.data,'dd/mm/yyyy') as data,
                   pcl.user_insert,
                   to_char(pcl.date_insert,'dd/mm/yyyy') as date_insert,
                   pcl.complemento,                    
                   pcl.valor
              from gerencial.v$plano_contas_lancamento pcl
              inner join kss.v$centro_custo cc
                      on cc.cod_centro_custo = pcl.cod_centro_custo
              where pcl.data_cancelamento is null
              <cfif Len(Trim(arguments.DATA_INICIO))>
                and pcl.data >= '#arguments.DATA_INICIO#'
              </cfif>
              <cfif Len(Trim(arguments.DATA_FIM))>
                and pcl.data <= '#arguments.DATA_FIM#'
              </cfif>
              <cfif Len(Trim(arguments.PLANO_CONTA_ID))>
                and pcl.CONTA_ID in (#arguments.PLANO_CONTA_ID#)
              </cfif>
              <cfif Len(Trim(arguments.COD_CENTRO_CUSTO))>
                and pcl.cod_centro_custo in (#arguments.COD_CENTRO_CUSTO#)
              </cfif>
              <cfif Len(Trim(arguments.LANCAMENTO_ID))>
                and pcl.lancamento_id in (#arguments.LANCAMENTO_ID#)
              </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

<!--- 
    -- PROPSITO 
    -- Retorna matriz com as datas e os centros de custo
    -- GUTO 01/07/2010 - CRIADO
    --->		
    <cffunction name="get_lancamento_manual_datas" access="remote" returntype="query" output="true">
        <cfargument name="DATA_INICIO" required="no" default=""/>
        <cfargument name="DATA_FIM" required="no" default=""/>
        <cfargument name="PLANO_CONTA_ID" required="no" default=""/>
        <cfargument name="COD_CENTRO_CUSTO" required="no" default=""/>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
          select dt.data, 
                 dt.cod_data,
                 dt.data_formatada,
                 cc.cod_centro_custo,
                 cc.centro_custo,
                 pcl.lancamento_id, 
                 pcl.valor
            from (select to_char(trunc(to_date('#arguments.DATA_FINAL#','dd/mm/yyyy'))-(level-1),'yyyymmdd') as cod_data,
                         to_char(trunc(to_date('#arguments.DATA_FINAL#','dd/mm/yyyy'))-(level-1),'dd/mm/yyyy') as data,
                         to_char(trunc(to_date('#arguments.DATA_FINAL#','dd/mm/yyyy'))-(level-1),'dd/mon') as data_formatada
                    from dual
                  connect by level <= to_date('#arguments.DATA_FINAL#','dd/mm/yyyy')-(to_date('#arguments.DATA_INICIAL#','dd/mm/yyyy')-1)
                  order by cod_data) dt
            natural join kss.v$centro_custo cc
            left join gerencial.v$plano_contas_lancamento pcl
                    on pcl.cod_centro_custo = cc.cod_centro_custo
                   and pcl.data = dt.data 
                   and pcl.data_cancelamento is null
                   and pcl.conta_id = #arguments.PLANO_CONTA_ID#
            where cc.ativo = 1  
            order by cc.cod_centro_custo, dt.data
        </cfquery>
        <cfreturn qr_result>
    </cffunction>    

<!--- 
    -- PROPSITO 
    -- Retorna matriz com as datas e os centros de custo
    -- GUTO 01/07/2010 - CRIADO
    --->		
    <cffunction name="get_faturamento_custo" access="remote" returntype="query" output="true">
        <cfargument name="DATA_INICIAL" required="no" default=""/>
        <cfargument name="DATA_FINAL" required="no" default=""/>
        <cfargument name="DIA" required="no" default="1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31"/>
        <cfargument name="MES" required="no" default="1,2,3,4,5,6,7,8,9,10,11,12"/>
        <cfif not Len(Trim(arguments.MES))>
           <cfset arguments.MES = "1,2,3,4,5,6,7,8,9,10,11,12"/>
        </cfif>
        
        <cfif not Len(Trim(arguments.DATA_INICIAL))>
		   <cfset arguments.DATA_INICIAL = ArrayMin(ListToArray(arguments.DIA)) & '/' & ArrayMax(ListToArray(arguments.MES)) & '/2010'>
		   <cfset arguments.DATA_FINAL = ArrayMax(ListToArray(arguments.DIA)) & '/' & ArrayMax(ListToArray(arguments.MES)) & '/2010'>
  		   <cfif not Len(Trim(arguments.DIA))>
				<cfset arguments.DATA_INICIAL = '01' & '/' & ArrayMax(ListToArray(arguments.MES)) & '/2010'>
                <cfset arguments.DATA_FINAL = DaysInMonth(CreateDate(2010,ArrayMax(ListToArray(arguments.MES)),1)) & '/' & ArrayMax(ListToArray(arguments.MES)) & '/2010'>
           </cfif>
		</cfif>

        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select gerencial.pkg_formula.fnc_obtem_valor(1,'[CONTA_ID]:1,[DATA_INICIO]:#arguments.DATA_INICIAL#,[DATA_FIM]:#arguments.DATA_FINAL#,[COD_CENTRO_CUSTO]:null') as valor_realizado,
                   gerencial.pkg_formula.fnc_obtem_valor(2,'[CONTA_ID]:2,[DATA_INICIO]:#arguments.DATA_INICIAL#,[DATA_FIM]:#arguments.DATA_FINAL#,[COD_CENTRO_CUSTO]:null') as valor_custo,
                   (select sum(fm.valor_meta) 
                      from fiscal.v$faturamento_painel fm
                     where fm.data between '#arguments.DATA_INICIAL#' and '#arguments.DATA_FINAL#') as valor_meta,
                   '#arguments.DATA_FIM#' as data
              from dual     
        </cfquery>
        <cfreturn qr_result>
    </cffunction>    

</cfcomponent>