<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO 
    -- Retorna os nmeros de tempo parado
    -- ANDERSON 01/06/2010 - CRIADO
    --->		
    <cffunction name="get_tempo_parado" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="no" default="01/#LSDateFormat(Now(),'mm/yyyy')#">
    	<cfargument name="data_termino" required="no" default="#LSDateFormat(Now())#">
        <cfif not Len(Trim(arguments.data_inicio))>
        	<cfset arguments.data_inicio = "01/#LSDateFormat(Now(),'mm/yyyy')#">
        </cfif>
        <cfif not Len(Trim(arguments.data_termino))>
        	<cfset arguments.data_termino = #LSDateFormat(Now())#>
        </cfif>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_MANUT_TEMPO_PARADO_INICIO') * horas_por_equipamento as inicio 
                 , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_MANUT_TEMPO_PARADO_FIM') * horas_por_equipamento as fim
                 , round(nvl(sum(t.tempo_parado), 0), 2) as tempo_parado
              from (
                    select os.ordem_servico_id, gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_DISPONIBILIDADE_EQUIPAMENTO'), gerencial.to_data_mes(to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')).dia_mes_atual * gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_DISPONIBILIDADE_EQUIPAMENTO') as horas_por_equipamento,
                         case 
                          when os.data_abertura < trunc(to_date('#arguments.data_inicio#', 'dd/mm/yyyy'),'month') then (nvl(os.data_fechamento, to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')) - trunc(to_date('#arguments.data_inicio#', 'dd/mm/yyyy'),'month'))*gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_DISPONIBILIDADE_EQUIPAMENTO')
                         else (nvl(os.data_fechamento, to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')) - os.data_abertura)*gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_DISPONIBILIDADE_EQUIPAMENTO') end tempo_parado
                      from manutencao.v$ordem_servico os
                     where nvl(os.data_fechamento, to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')) between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                   ) t 
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os nmeros de tempo de espera
    -- ANDERSON 01/06/2010 - CRIADO
    --->		
    <cffunction name="get_tempo_espera" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="no" default="01/#LSDateFormat(Now(),'mm/yyyy')#">
    	<cfargument name="data_termino" required="no" default="#LSDateFormat(Now())#">
        <cfif not Len(Trim(arguments.data_inicio))>
        	<cfset arguments.data_inicio = "01/#LSDateFormat(Now(),'mm/yyyy')#">
        </cfif>
        <cfif not Len(Trim(arguments.data_termino))>
        	<cfset arguments.data_termino = #LSDateFormat(Now())#>
        </cfif>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_MANUT_TEMPO_ESPERA_INICIO') as inicio
                 , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_MANUT_TEMPO_ESPERA_FIM') as fim
                 , round(nvl(sum(t.tempo_espera), 0), 2) as tempo_espera
              from (
                    select (nvl(os.data_atendimento, sysdate) - os.data_abertura) * 24 as tempo_espera
                      from manutencao.v$ordem_servico os
                     where nvl(os.data_fechamento, to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')) between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                   ) t
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os nmeros de tempo de impedimento
    -- ANDERSON 01/06/2010 - CRIADO
    --->		
    <cffunction name="get_tempo_impedimento" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="no" default="01/#LSDateFormat(Now(),'mm/yyyy')#">
    	<cfargument name="data_termino" required="no" default="#LSDateFormat(Now())#">
        <cfif not Len(Trim(arguments.data_inicio))>
        	<cfset arguments.data_inicio = "01/#LSDateFormat(Now(),'mm/yyyy')#">
        </cfif>
        <cfif not Len(Trim(arguments.data_termino))>
        	<cfset arguments.data_termino = #LSDateFormat(Now())#>
        </cfif>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_MANUT_TEMPO_IMPEDIMENTO_INICIO') as inicio
                 , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_MANUT_TEMPO_IMPEDIMENTO_FIM') as fim
                 , round(nvl(sum(ti.tempo_impedimento), 0), 2) as tempo_impedimento
              from gerencial.v$tempo_impedimento ti
             where ti.data_abertura between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os nmeros de disponibilidade
    -- ANDERSON 01/06/2010 - CRIADO
    --->		
    <cffunction name="get_disponibilidade" access="remote" returntype="query" output="true">
    	<cfargument name="classificacao" required="yes">
    	<cfargument name="data_inicio" required="no" default="#LSDateFormat(Now())#">
    	<cfargument name="data_termino" required="no" default="#LSDateFormat(Now())#">
        <cfif not Len(Trim(arguments.data_inicio))>
        	<cfset arguments.data_inicio = #LSDateFormat(Now())#>
        </cfif>
        <cfif not Len(Trim(arguments.data_termino))>
        	<cfset arguments.data_termino = #LSDateFormat(Now())#>
        </cfif>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
             select gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_MANUT_DISPONIB_#arguments.classificacao#_AMARELO') as faixa_amarela
                             , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_MANUT_DISPONIB_#arguments.classificacao#_VERDE') as faixa_verde
                             , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_MANUT_DISPONIB_#arguments.classificacao#_META') as meta
                             , x.tempo_parado
                             , x.horas_disponiveis
                             , x.tempo_parado_total
                             , x.horas_disponiveis_total
                             , round((1-(x.tempo_parado / x.horas_disponiveis))*100, 2) as perc_disponivel
                             , round((1-(x.tempo_parado_total / x.horas_disponiveis_total))*100, 2) as perc_disponivel_total
                          from (
                                select t.horas_disponiveis
                                     , t.horas_disponiveis * (trunc(t.data_termino) - trunc(t.data_inicio,'month') + 1) as horas_disponiveis_total
                                     , (select sum(case 
                                               when os.data_abertura < t.data_inicio then (nvl(os.data_fechamento, t.data_termino) - t.data_inicio)*gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_DISPONIBILIDADE_EQUIPAMENTO')
                                               else (nvl(os.data_fechamento, t.data_termino) - os.data_abertura)*gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_DISPONIBILIDADE_EQUIPAMENTO') end) as tempo_parado
                                              from manutencao.v$ordem_servico os
                                              inner join almoxarifado.v$equipamento e
                                                      on e.equipamento_id = os.equipamento_id
                                             where nvl(os.data_fechamento, t.data_termino) between t.data_inicio and t.data_termino
                                             <cfif arguments.classificacao neq 'TOTAL' >
                                               and oper.pkg_veiculo.fnc_veiculo_tracao(e.placa) = <cfif arguments.classificacao eq 'CAVALO'>1<cfelseif arguments.classificacao eq 'CARRETA'>0</cfif>
                                             </cfif>
                                       ) as tempo_parado
                                     , (select sum(case 
                                               when os.data_abertura < trunc(t.data_inicio,'month') then (nvl(os.data_fechamento, t.data_termino) - trunc(t.data_inicio,'month'))*gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_DISPONIBILIDADE_EQUIPAMENTO')
                                               else (nvl(os.data_fechamento, t.data_termino) - os.data_abertura)*gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_DISPONIBILIDADE_EQUIPAMENTO') end) as  tempo_parado
                                              from manutencao.v$ordem_servico os
                                              inner join almoxarifado.v$equipamento e
                                                      on e.equipamento_id = os.equipamento_id
                                             where nvl(os.data_fechamento, t.data_termino) between trunc(t.data_inicio,'month') and t.data_termino
                                             <cfif arguments.classificacao neq 'TOTAL'>
                                               and oper.pkg_veiculo.fnc_veiculo_tracao(e.placa) = <cfif arguments.classificacao eq 'CAVALO'>1<cfelseif arguments.classificacao eq 'CARRETA'>0</cfif>
                                             </cfif>
                                       ) as tempo_parado_total
                                  from (
                                         select gerencial.pkg_rentabilidade.fnc_qtde_veiculos_ativos(d.data_inicio,d.data_termino,'FROTA',<cfif arguments.classificacao eq 'CAVALO'>1<cfelseif arguments.classificacao eq 'CARRETA'>0<cfelse>-1</cfif>) * gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_CCO_HORAS_TRABALHADAS') as horas_disponiveis
                                             , d.data_inicio
                                             , data_termino
                                          from (select to_date('#arguments.data_inicio#', 'dd/mm/yyyy') as data_inicio
                                                          , to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss') as data_termino
                                                       from dual
                                                    ) d              
                                       ) t
                               ) x
                               

        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os nmeros de orado x realizado
    -- ANDERSON 01/06/2010 - CRIADO
    --->		
    <cffunction name="get_orcado_realizado" access="remote" returntype="query" output="true">
     	<cfargument name="data_inicio" required="no" default="01/#LSDateFormat(Now(),'mm/yyyy')#">
    	<cfargument name="data_termino" required="no" default="#LSDateFormat(Now())#">
        <cfif not Len(Trim(arguments.data_inicio))>
        	<cfset arguments.data_inicio = "01/#LSDateFormat(Now(),'mm/yyyy')#">
        </cfif>
        <cfif not Len(Trim(arguments.data_termino))>
        	<cfset arguments.data_termino = #LSDateFormat(Now())#>
        </cfif>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_MANUT_ORCADO_REALIZADO_VERDE') as faixa_verde,
                   gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_MANUT_ORCADO_REALIZADO_AMARELO') as faixa_amarela,
                   gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_MANUT_ORCADO_REALIZADO_VERMELHO') as faixa_vermelha,
                   gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_MANUT_ORCADO_REALIZADO_META') as meta,
                   round(t.valor_realizado / ((t.valor_orcado/qtde_dias_mes_atual)*dia_mes_atual) * 100, 2) as percentual
              from (select (select nvl(sum(ao.valor), 1)
                               from compras.v$area_orcamento ao
                              where ao.mes = extract(month from(d.data_termino))
                                and ao.ano = extract(year from(d.data_termino))) as valor_orcado,
                   (select nvl(sum(fc.valor), 0)
                      from gerencial.mv$faturamento_compras fc
                     where fc.data_emissao between d.data_inicio and d.data_termino                       
                       and fc.tipo = 1) as valor_realizado,
                   d.dt.qtde_dias_mes_atual as qtde_dias_mes_atual,
                   d.dt.dia_mes_atual as dia_mes_atual
             from (
                   select to_date('#arguments.data_inicio#', 'dd/mm/yyyy') as data_inicio
                        , to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss') as data_termino
                        , gerencial.to_data_mes(to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')) as dt
                     from dual
                  ) d
          ) t
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os nmeros de MTR (Tempo mdio parado)
    -- ANDERSON 01/06/2010 - CRIADO
    --->		
    <cffunction name="get_mtr" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="no" default="01/#LSDateFormat(Now(),'mm/yyyy')#">
    	<cfargument name="data_termino" required="no" default="#LSDateFormat(Now())#">
        <cfif not Len(Trim(arguments.data_inicio))>
        	<cfset arguments.data_inicio = "01/#LSDateFormat(Now(),'mm/yyyy')#">
        </cfif>
        <cfif not Len(Trim(arguments.data_termino))>
        	<cfset arguments.data_termino = #LSDateFormat(Now())#>
        </cfif>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_MANUT_MTR_INICIO') as inicio
                 , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_MANUT_MTR_FIM') as fim
                 , round(nvl(avg(t.tempo_parado), 0), 2) as tempo_medio_parado
              from (
                    select (nvl(os.data_fechamento, sysdate) - os.data_abertura) * 24 as tempo_parado
                      from manutencao.v$ordem_servico os
                      inner join manutencao.v$tipo_ordem_servico tos
                       on tos.tipo_ordem_servico_id = os.tipo_ordem_servico_id
                     where nvl(os.data_fechamento, sysdate) between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                       and tos.corretiva = 1
                   ) t 
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os nmeros de KMED (Mdia de KM rodado entre as OS)
    -- ANDERSON 01/06/2010 - CRIADO
    --->
    <cffunction name="get_kmed" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="no" default="01/#LSDateFormat(Now(),'mm/yyyy')#">
    	<cfargument name="data_termino" required="no" default="#LSDateFormat(Now())#">
        <cfif not Len(Trim(arguments.data_inicio))>
        	<cfset arguments.data_inicio = "01/#LSDateFormat(Now(),'mm/yyyy')#">
        </cfif>
        <cfif not Len(Trim(arguments.data_termino))>
        	<cfset arguments.data_termino = #LSDateFormat(Now())#>
        </cfif>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_MANUT_KMED_INICIO') as inicio
                 , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_MANUT_KMED_FIM') as fim
                 , round(nvl(avg(t.media_km_rodado), 0)) as media_km_rodado
              from (
                    select v.placa
                         , manutencao.pkg_ordem_servico.fnc_media_km_rodado_entre_os(v.placa, data_inicio, d.data_termino) as media_km_rodado
                      from oper.v$veiculo v
                     inner join almoxarifado.v$equipamento e
                             on e.placa = v.placa
                     cross join (select to_date('#arguments.data_inicio#', 'dd/mm/yyyy') as data_inicio
                                      , to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss') as data_termino
                                   from dual
                                ) d
                     where exists (select 1
                                     from oper.v$veiculo_hist_situacao vhs
                                    where vhs.placa = v.placa
                                      and vhs.data = (select max(vhs2.data)
                                                        from oper.v$veiculo_hist_situacao vhs2
                                                       where vhs2.placa = vhs.placa
                                                         and vhs2.data <= d.data_inicio
                                                     )
                                      and vhs.situacao_id = 1
                                  )
                       and exists (select 1
                                     from oper.v$veiculo_modalidade vm
                                    where vm.placa = v.placa
                                      and vm.data = (select max(vm2.data)
                                                       from oper.v$veiculo_modalidade vm2
                                                      where vm2.placa = vm.placa
                                                        and vm2.data <= d.data_inicio
                                                    )
                                      and vm.modalidade = 'FROTA'
                                  )
                   ) t
             where t.media_km_rodado > 0
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna um perodo para plotar o grfico das ordens de servio em aberto
    -- ANDERSON 01/06/2010 - CRIADO
    --->		
    <cffunction name="get_maior_data_ordens_servico" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_termino" required="no" default="">
    	<cfargument name="cod_grupo" required="no" default=""/>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select to_char(max(t.data_previsao), 'dd/mm/yyyy') as data_previsao,
            	   to_char(trunc(min(t.data_previsao),'month'), 'dd/mm/yyyy') as data_inicio	
              from (
                    select (select nvl(min(opl.data_previsao), sysdate)
                              from manutencao.v$os_previsao_liberacao opl
                             where opl.ordem_servico_id = os.ordem_servico_id
                           ) as data_previsao
                      from manutencao.v$ordem_servico os
                     where 1=1
                       <cfif Len(Trim(arguments.DATA_INICIO))>
	                       and os.data_abertura >= to_date('#arguments.data_inicio#', 'dd/mm/yyyy') 
                       </cfif>
                       <cfif Len(Trim(arguments.DATA_TERMINO))>
	                       and os.data_abertura <= to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                       </cfif>
                       <cfif Len(Trim(arguments.COD_GRUPO))>
                           and exists (select 1
                                         from almoxarifado.v$equipamento e
                                        inner join oper.v$veiculo_grupo vg
                                                on vg.placa = e.placa
                                               and sysdate between vg.data_inicio and nvl(vg.data_termino,sysdate) 
                                        where e.equipamento_id = os.equipamento_id
                                          and vg.cod_grupo in (#ListQualify(arguments.COD_GRUPO,"'")#))
                       </cfif>
                       and os.data_fechamento is null
                   ) t                   
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os meses para plotar o grfico das ordens de servio em aberto
    -- ANDERSON 01/06/2010 - CRIADO
    --->		
    <cffunction name="get_meses_ordens_servico" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="yes">
        <cfargument name="data_termino" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select to_char(min(t.data), 'dd/mm/yyyy') as data_inicio
                 , to_char(max(t.data), 'dd/mm/yyyy') as data_termino
                 , to_char(min(t.data), 'Month') as mes
              from (
                    select to_date('#arguments.data_inicio#', 'dd/mm/yyyy') + level - 1 as data
                      from dual
                   connect by level <= to_date('#arguments.data_termino#', 'dd/mm/yyyy') - to_date('#arguments.data_inicio#', 'dd/mm/yyyy') + 1
                   ) t
              group by extract(month from t.data)
              order by data_inicio 
        </cfquery>
        <cfreturn qr_result>
    </cffunction> 
    <!--- 
    -- PROPSITO 
    -- Retorna um perodo para plotar o grfico das ordens de servio em aberto
    -- ANDERSON 01/06/2010 - CRIADO
    --->		
    <cffunction name="get_periodo_ordens_servico" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="yes">
        <cfargument name="data_termino" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select to_char(t.data, 'dd/mm/yyyy') as data
                 , extract(day from (t.data)) as dia
              from (
                    select to_date('#arguments.data_inicio#', 'dd/mm/yyyy') + level - 1 as data
                      from dual
                   connect by level <= to_date('#arguments.data_termino#', 'dd/mm/yyyy') - to_date('#arguments.data_inicio#', 'dd/mm/yyyy') + 1
                   ) t
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os nmeros das ordens de servio em aberto
    -- ANDERSON 01/06/2010 - CRIADO
    --->
    <cffunction name="get_ordens_servico" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="no" default="">
    	<cfargument name="data_termino" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select x.cod_veiculo
                 , to_char(x.data_abertura, 'dd/mm/yyyy hh24:mi:ss') as data_abertura
                 , case 
                    when x.ultima_data_previsao < sysdate then to_char(sysdate, 'dd/mm/yyyy hh24:mi:ss')
                   else to_char(x.ultima_data_previsao, 'dd/mm/yyyy hh24:mi:ss') end data_previsao
                 , to_char(sysdate, 'dd/mm/yyyy hh24:mi:ss') as data_atual
                 , to_char(x.data_previsao, 'dd/mm/yyyy hh24:mi:ss') as primeira_previsao
                 , x.oficina
                 , x.tipo
                 , case
                      when x.percentual > 100 then 100
                      else x.percentual
                   end as percentual
              from (
            select t.cod_veiculo
                 , t.data_abertura
                 , t.data_previsao
                 , t.ultima_data_previsao
                 , t.oficina
                 , t.tipo
                 , round((nvl(t.data_previsao, sysdate) - t.data_abertura) / (sysdate - t.data_abertura) * 100, 2) as percentual
              from (
                    select oper.pkg_veiculo.fnc_get_cod_veiculo(e.placa) as cod_veiculo
                         , os.data_abertura
                         , (select min(opl.data_previsao)
                              from manutencao.v$os_previsao_liberacao opl
                             where opl.ordem_servico_id = os.ordem_servico_id
                           ) as data_previsao
                         , (select max(opl.data_previsao)
                              from manutencao.v$os_previsao_liberacao opl
                             where opl.ordem_servico_id = os.ordem_servico_id
                           ) as ultima_data_previsao
                         , p.cliente as oficina
                         , ot.descricao as tipo
                      from manutencao.v$ordem_servico os
                     inner join manutencao.v$tipo_ordem_servico ot
                             on ot.TIPO_ORDEM_SERVICO_ID = os.TIPO_ORDEM_SERVICO_ID 
                     inner join kss.v$pessoa p 
                              on p.cod_pessoa = os.cod_pessoa_oficina
                     inner join almoxarifado.v$equipamento e
                             on e.equipamento_id = os.equipamento_id
                     where os.data_fechamento is null
                       <cfif Len(Trim(arguments.COD_GRUPO))>
                           and exists (select 1
                                         from almoxarifado.v$equipamento e
                                        inner join oper.v$veiculo_grupo vg
                                                on vg.placa = e.placa
                                               and sysdate between vg.data_inicio and nvl(vg.data_termino,sysdate) 
                                        where e.equipamento_id = os.equipamento_id
                                          and vg.cod_grupo in (#ListQualify(arguments.COD_GRUPO,"'")#))
                       </cfif>                       
                   ) t
                   ) x
                   order by x.data_abertura
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os nmeros de veculos em manuteno
    -- ANDERSON 01/06/2010 - CRIADO
    --->		
    <cffunction name="get_veiculos_em_manutencao" access="remote" returntype="query" output="true">
    	<cfargument name="classificacao" required="no" default=""/>
    	<cfargument name="cod_grupo" required="no" default=""/>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_MANUT_EM_MANUTENCAO_VERDE') as faixa_verde
                 , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_MANUT_EM_MANUTENCAO_AMARELO') as faixa_amarela
                 , count(*) as qtde_veiculos
                 , count(case
                            when d.em_manutencao = 1 then 1
                            else null
                         end
                        ) as qtde_em_manutencao
              from gerencial.v$disponibilidade d
              where 1=1
                and empresa = 1
              <cfif Len(Trim(arguments.CLASSIFICACAO))>
                and d.classificacao = '#arguments.CLASSIFICACAO#'
              </cfif>
              <cfif Len(Trim(arguments.COD_GRUPO))>
                and d.cod_grupo in (#ListQualify(arguments.COD_GRUPO,"'")#)
              </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os nmeros de tipos de ordem de servio
    -- ANDERSON 01/06/2010 - CRIADO
    --->		
    <cffunction name="get_tipos_ordem_servico" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="no" default="01/#LSDateFormat(Now(),'mm/yyyy')#">
    	<cfargument name="data_termino" required="no" default="#LSDateFormat(Now())#">
    	<cfargument name="cod_grupo" required="no" default=""/>
        <cfif not Len(Trim(arguments.data_inicio))>
        	<cfset arguments.data_inicio = "01/#LSDateFormat(Now(),'mm/yyyy')#">
        </cfif>
        <cfif not Len(Trim(arguments.data_termino))>
        	<cfset arguments.data_termino = #LSDateFormat(Now())#>
        </cfif>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select (select tos.descricao
                      from manutencao.v$tipo_ordem_servico tos
                     where tos.tipo_ordem_servico_id = os.tipo_ordem_servico_id
                   ) as tipo_ordem_servico
                 , count(*) as qtde_tipo
              from manutencao.v$ordem_servico os
             where os.data_abertura between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
		   <cfif Len(Trim(arguments.COD_GRUPO))>
               and exists (select 1
                             from almoxarifado.v$equipamento e
                            inner join oper.v$veiculo_grupo vg
                                    on vg.placa = e.placa
                                   and sysdate between vg.data_inicio and nvl(vg.data_termino,sysdate) 
                            where e.equipamento_id = os.equipamento_id
                              and vg.cod_grupo in (#ListQualify(arguments.COD_GRUPO,"'")#))
           </cfif>                       
             group by os.tipo_ordem_servico_id
             order by qtde_tipo desc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os nmeros de custo por rea
    -- ANDERSON 01/06/2010 - CRIADO
    --->
    <cffunction name="get_orcado_realizado_pedidos" access="remote" returntype="query" output="true">
    	<cfargument name="data_termino" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select to_char(data,'dd') as dia,
                   data, 
                   sum(valor_orcado) as valor_orcado, 
                   sum(valor_nf_acumulado) as valor_nf_acumulado, 
                   sum(valor_pedido) as valor_pedido_executado
              from (select dt.data,
                           round(sum((select nvl(sum(ao.valor), 0) / extract(day from (last_day(dt.data)))
                            from compras.v$area_orcamento ao
                           where ao.mes = extract(month from (dt.data))
                             and ao.ano = extract(year from (dt.data))
                           )) over(order by dt.data rows unbounded preceding), 2) as valor_orcado
                         , round(sum(x.valor) over(order by dt.data rows unbounded preceding), 2) as valor_nf_acumulado
                         , 0 as valor_pedido
                    from (select data_termino - level+1 as data
                            from (select trunc(last_day(to_date('#arguments.data_termino#', 'dd/mm/yyyy'))) as data_termino
                                    from dual
                                 ) d
                         connect by level <= extract(day from (d.data_termino))
                         ) dt
                    left join (select sf.data_entrada_nf,  
                                 sum(sf.valor_nf) as valor     
                            from compras.v$solicitacao_fornecedor sf
                            inner join compras.v$area a
                                    on a.area_id = sf.area_id
                            where sf.data_entrada_nf between trunc(to_date('#arguments.data_termino#', 'dd/mm/yyyy'),'month') and last_day(to_date('#arguments.data_termino#', 'dd/mm/yyyy'))
                             and a.cod_conta in ('MANUTENCAO','PNEU')
                          group by sf.data_entrada_nf 
                          order by data_entrada_nf) x
                    on dt.data = x.data_entrada_nf
                  union all
                  select dt.data
                         , 0 as valor_orcado
                         , 0 as valor_pedido
                         , round(sum(x.valor) over(order by dt.data rows unbounded preceding), 2) as valor_pedido_executado              
                    from (select data_termino - level+1 as data
                            from (select trunc(last_day(to_date('#arguments.data_termino#', 'dd/mm/yyyy'))) as data_termino
                                    from dual
                                 ) d
                         connect by level <= extract(day from (d.data_termino))
                         ) dt
                    left join           
                         (select sf.data_vencimento_pedido as data,  
                                 sum(sf.valor) as valor     
                            from compras.v$solicitacao_fornecedor sf
                            inner join compras.v$area a
                                    on a.area_id = sf.area_id
                            where sf.data_vencimento_pedido between trunc(to_date('#arguments.data_termino#', 'dd/mm/yyyy'),'month') and last_day(to_date('#arguments.data_termino#', 'dd/mm/yyyy'))
                             and a.cod_conta in ('MANUTENCAO','PNEU')
                             and sf.num_nota_id is null
                          group by sf.data_vencimento_pedido 
                          order by data_vencimento_pedido) x
                    on dt.data = x.data
            )
            group by data
            order by data 
	    </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!--- 
    -- PROPSITO 
    -- Retorna os saldos superior e anterior ao mes de consulta
    -- ANDERSON 01/06/2010 - CRIADO
    --->
    <cffunction name="get_orcado_realizado_pedidos_saldos" access="remote" returntype="query" output="true">
    	<cfargument name="data_termino" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select sum(valor_anterior) as saldo_anterior,
                   sum(valor_superior) as saldo_superior
              from (select sum(sf.valor) as valor_anterior, 0 as valor_superior
                      from compras.v$solicitacao_fornecedor sf
                      inner join compras.v$area a
                              on a.area_id = sf.area_id
                     where sf.data_vencimento_pedido < trunc(to_date('#arguments.data_termino#', 'dd/mm/yyyy'),'month')
                       and a.cod_conta in ('MANUTENCAO','PNEU')
                       and sf.num_nota_id is null
                    union all
                    select 0, sum(sf.valor) as valor     
                      from compras.v$solicitacao_fornecedor sf
                      inner join compras.v$area a
                              on a.area_id = sf.area_id
                     where sf.data_vencimento_pedido >= last_day(to_date('#arguments.data_termino#', 'dd/mm/yyyy'))
                       and a.cod_conta in ('MANUTENCAO','PNEU')
                       and sf.num_nota_id is null)
	    </cfquery>
        <cfreturn qr_result>
    </cffunction>    
    
    <!--- 
    -- PROPSITO 
    -- Retorna os nmeros de custo por rea
    -- ANDERSON 01/06/2010 - CRIADO
    --->
    <cffunction name="get_orcado_realizado_acumulado" access="remote" returntype="query" output="true">
    	<cfargument name="data_termino" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select x.data
                 , extract(day from (x.data)) as dia
                 , round(x.valor_orcado, 2) as valor_orcado
                 , round(sum(x.valor_orcado) over(order by x.data rows unbounded preceding), 2) as valor_orcado_acum

                 , round(x.valor_realizado_emissao, 2) as valor_realizado_emissao
                 , round(sum(x.valor_realizado_emissao) over(order by x.data rows unbounded preceding), 2) as valor_realizado_emissao_acum

                 , round(x.valor_realizado_entrada, 2) as valor_realizado_entrada
                 , round(sum(x.valor_realizado_entrada) over(order by x.data rows unbounded preceding), 2) as valor_realizado_entrada_acum

                 , round(x.valor_aprovado, 2) as valor_aprovado
                 , round(sum(x.valor_aprovado) over(order by x.data rows unbounded preceding), 2) as valor_aprovado_acum

                 , round(x.valor_aprovado_total, 2) as valor_aprovado_total
                 , round(sum(x.valor_aprovado_total) over(order by x.data rows unbounded preceding), 2) as valor_aprovado_total_acum
              from (
                    select t.data
                         , (select nvl(sum(ao.valor), 0) / extract(day from (last_day(t.data)))
                              from compras.v$area_orcamento ao
                             where ao.mes = extract(month from (t.data))
                               and ao.ano = extract(year from (t.data))
                           ) as valor_orcado
                         , (select nvl(sum(fc.valor), 0)
                              from gerencial.mv$faturamento_compras fc
                             where fc.data_emissao = t.data
                               and fc.tipo = 1
                           ) as valor_realizado_emissao
                         , (select nvl(sum(fc.valor), 0)
                              from gerencial.mv$faturamento_compras fc
                             where fc.data_entrada = t.data
                               and fc.tipo = 1
                           ) as valor_realizado_entrada
                         , (select nvl(sum(fc.valor), 0)
                              from gerencial.mv$faturamento_compras fc
                             where fc.data_entrada = t.data
                               and fc.tipo = 2
                           ) as valor_aprovado
                         , (select nvl(sum(fc.valor), 0)
                              from gerencial.mv$faturamento_compras fc
                             where fc.data_emissao = t.data
                               and fc.tipo = 3
                           ) as valor_aprovado_total
                      from (
                            select to_date(level || '/' || extract(month from (d.data_termino)) || '/' || extract(year from (d.data_termino)), 'dd/mm/yyyy') as data
                              from (select to_date('#arguments.data_termino#', 'dd/mm/yyyy') as data_termino
                                      from dual
                                   ) d
                           connect by level <= extract(day from (d.data_termino))
                           ) t
                   ) x        
	    </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os nmeros de custo por rea
    -- ANDERSON 01/06/2010 - CRIADO
    --->		
    <cffunction name="get_custo_por_area" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="yes">
        <cfargument name="data_termino" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select (select a.descricao
                      from compras.v$area a
                     where a.area_id = t.area_id
                   ) as area
                 , round(sum(t.valor), 2) as valor
              from (
                    select (select s.area_id
                              from compras.v$solicitacao s
                             where s.solicitacao_id = fc.solicitacao_id
                           ) as area_id
                         , fc.valor
                      from gerencial.mv$faturamento_compras fc
                     where fc.tipo in (1,2)
                       and fc.data_emissao between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                   ) t
             group by t.area_id
             order by valor desc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os nmeros de faturamento x custo
    -- ANDERSON 01/06/2010 - CRIADO
    --->
    <cffunction name="get_faturamento_compras" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="yes">
        <cfargument name="data_termino" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_MANUT_FAT_CUSTO_VERDE') as faixa_verde
                 , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_MANUT_FAT_CUSTO_AMARELO') as faixa_amarela
                 , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_MANUT_FAT_CUSTO_META') as meta
                 , round(t.valor_compras / t.valor_faturamento * 100, 2) as percentual
              from (
                    select (select nvl(sum(f.valor_faturamento), 0)
                              from gerencial.v$faturamento f
                             where f.data_emissao between d.data_inicio and d.data_termino
                           ) as valor_faturamento
                         , (select nvl(sum(fc.valor), 0)
                              from gerencial.mv$faturamento_compras fc
                             where fc.data_emissao between d.data_inicio and d.data_termino
                               and fc.tipo in (1,2)
                           ) as valor_compras
                      from (
                            select to_date('#arguments.data_inicio#', 'dd/mm/yyyy') as data_inicio
                                 , to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss') as data_termino
                              from dual
                           ) d
                   ) t
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os nmeros de custo de compras por KM rodado
    -- ANDERSON 01/06/2010 - CRIADO
    --->		
    <cffunction name="get_custo_compras_km_rodado" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="no" default="01/#LSDateFormat(Now(),'mm/yyyy')#">
    	<cfargument name="data_termino" required="no" default="#LSDateFormat(Now())#">
        <cfif not Len(Trim(arguments.data_inicio))>
        	<cfset arguments.data_inicio = "01/#LSDateFormat(Now(),'mm/yyyy')#">
        </cfif>
        <cfif not Len(Trim(arguments.data_termino))>
        	<cfset arguments.data_termino = #LSDateFormat(Now())#>
        </cfif>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_MANUT_CUSTO_COMPRAS_KM_VERDE') as faixa_verde
                 , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_MANUT_CUSTO_COMPRAS_KM_AMARELO') as faixa_amarela
                 , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_MANUT_CUSTO_COMPRAS_KM_VERMELHO') as faixa_vermelha
                 , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_MANUT_CUSTO_COMPRAS_KM_META') as meta
                 , round(a.valor_compras / a.km_rodado, 2) as custo_compras_km_rodado
             from (
                   select (select nvl(sum(fc.valor), 0)
                             from gerencial.mv$faturamento_compras fc
                            where fc.data_emissao between x.data_inicio and x.data_termino
                              and fc.tipo in (1,2)
                          ) as valor_compras
                        , x.km_rodado
                     from (
                           select sum(t.km_rodado) as km_rodado
                                , t.data_inicio
                                , t.data_termino
                             from (
                                   select gerencial.pkg_rentabilidade.fnc_km_rodado(v.placa, d.data_inicio, d.data_termino) as km_rodado
                                        , d.data_inicio
                                        , d.data_termino
                                     from oper.v$veiculo v
                                    inner join oper.v$veiculo_frota_geral vfg
                                            on vfg.placa = v.placa
                                    inner join oper.v$veiculo_tipo_carroceria vtc
                                            on vtc.tipo_carroceria_id = v.tipo_carroceria_id                    
                                    inner join oper.v$veiculo_agrupamento va
                                            on va.agrupamento_id = vtc.agrupamento_id
                                    cross join (select to_date('#arguments.data_inicio#', 'dd/mm/yyyy') as data_inicio
                                                     , to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss') as data_termino
                                                  from dual
                                               ) d
                                    where va.controla = 1
                                      and va.tracao = 1
                                      and exists (select 1
                                                    from oper.v$veiculo_hist_situacao vhs
                                                   where vhs.placa = v.placa
                                                     and vhs.data = (select max(vhs2.data)
                                                                       from oper.v$veiculo_hist_situacao vhs2
                                                                      where vhs2.placa = vhs.placa
                                                                        and vhs2.data <= d.data_inicio
                                                                    )
                                                     and vhs.situacao_id = 1
                                                 )
                                      and exists (select 1
                                                    from oper.v$veiculo_modalidade vm
                                                   where vm.placa = v.placa
                                                     and vm.data = (select max(vm2.data)
                                                                      from oper.v$veiculo_modalidade vm2
                                                                     where vm2.placa = vm.placa
                                                                       and vm2.data <= d.data_inicio
                                                                   )
                                                     and vm.modalidade = 'FROTA'
                                                 )
                                  ) t
                          ) x
                  ) a
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os 10 frotas com os maiores custos
    -- ANDERSON 01/06/2010 - CRIADO
    --->
    <cffunction name="get_frotas_maiores_custos" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="yes">
        <cfargument name="data_termino" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select rownum as rank
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(t.placa) as cod_veiculo
                 , t.placa
                 , (select vg.cod_grupo
                      from oper.v$veiculo_grupo vg
                     where vg.placa = t.placa
                       and sysdate between vg.data_inicio and nvl(vg.data_termino, sysdate)
                   ) as cod_grupo
                 , round(t.valor, 2) as valor
              from (
                    select fc.placa
                         , sum(fc.valor) as valor
                      from gerencial.mv$faturamento_compras fc
                     where fc.data_emissao between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                       and fc.tipo in (1,2)
                       and fc.placa is not null
                     group by fc.placa
                     order by valor desc
                   ) t
             where rownum <= 10
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os nmeros de faturamento x abastecimento
    -- ANDERSON 01/06/2010 - CRIADO
    --->		
    <cffunction name="get_faturamento_abastecimento" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="yes">
        <cfargument name="data_termino" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_MANUT_FAT_ABASTECIMENTO_VERDE') as faixa_verde
                 , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_MANUT_FAT_ABASTECIMENTO_AMARELO') as faixa_amarela
                 , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_MANUT_FAT_ABASTECIMENTO_META') as meta
                 , round(t.valor_abastecimento / t.valor_faturamento * 100, 2) as percentual
              from (
                    select (select nvl(sum(f.valor_faturamento), 0)
                              from gerencial.v$faturamento f
                             where f.data_emissao between d.data_inicio and d.data_termino
                               and f.empresa = 1
                           ) as valor_faturamento
                         , (select nvl(sum(fa.valor_total), 0)
                              from gerencial.v$faturamento_abastecimento fa
                             where fa.data_hora between d.data_inicio and d.data_termino
                           ) + compras.pkg_compras.fnc_solicitacao_valor_area(5, d.data_inicio, d.data_termino) as valor_abastecimento
                      from (
                            select to_date('#arguments.data_inicio#', 'dd/mm/yyyy') as data_inicio
                                 , to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss') as data_termino
                              from dual
                           ) d
                   ) t
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os nmeros de mdia KM/Litro
    -- ANDERSON 01/06/2010 - CRIADO
    --->		
    <cffunction name="get_media_km_litro" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="yes">
        <cfargument name="data_termino" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_MANUT_MEDIA_KM_LITRO_INICIO') as inicio
                 , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_MANUT_MEDIA_KM_LITRO_FIM') as fim
                 , round(sum(cc.km_rodado)/sum(cc.quantidade), 2) as media_km_litro
              from gerencial.v$consumo_combustivel cc
             cross join (select to_date('#arguments.data_inicio#', 'dd/mm/yyyy') as data_inicio
                              , to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss') as data_termino
                           from dual
                        ) d
             where cc.data_hora between d.data_inicio and d.data_termino
               and exists (select 1
                             from oper.v$veiculo_hist_situacao vhs
                            where vhs.placa = cc.placa
                              and vhs.data = (select max(vhs2.data)
                                                from oper.v$veiculo_hist_situacao vhs2
                                               where vhs2.placa = vhs.placa
                                                 and vhs2.data <= d.data_inicio
                                             )
                              and vhs.situacao_id = 1
                          )
               and exists (select 1
                             from oper.v$veiculo_modalidade vm
                            where vm.placa = cc.placa
                              and vm.data = (select max(vm2.data)
                                               from oper.v$veiculo_modalidade vm2
                                              where vm2.placa = vm.placa
                                                and vm2.data <= d.data_inicio
                                            )
                              and vm.modalidade = 'FROTA'
                          )
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os nmeros de estoque de combustvel
    -- ANDERSON 01/06/2010 - CRIADO
    --->		
    <cffunction name="get_estoque_combustivel" access="remote" returntype="query" output="true">
    	<cfargument name="data_termino" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select x.cod_centro_custo
                 , x.centro_custo
                 , x.capacidade_maxima
                 , x.saldo
                 , case
                      when x.saldo <= x.estoque_minimo then 'FF0000'
                      else 'F6BD0F'
                   end as cor
              from (
                    select t.cod_centro_custo
                         , t.centro_custo
                         , t.capacidade_maxima
                         , t.estoque_minimo
                         , case
                              when t.saldo > t.capacidade_maxima then t.capacidade_maxima
                              else t.saldo
                           end as saldo
                      from (
                            select e.cod_centro_custo
                                 , cc.centro_custo
                                 , e.capacidade_maxima
                                 , e.estoque_minimo
                                 , oper.pkg_almoxarifado.fnc_calcula_saldo_estoque(e.estoque_id, to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')) as saldo
                              from oper.v$estoque e
                             inner join kss.v$centro_custo cc
                                     on cc.cod_centro_custo = e.cod_centro_custo
                           ) t
                   ) x
             order by x.centro_custo
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os 10 frotas e os 10 motoristas com as piores mdias KM/Litro
    -- ANDERSON 01/06/2010 - CRIADO
    --->		
    <cffunction name="get_piores_media_km_litro" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="yes">
        <cfargument name="data_termino" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select a.rank as rank_veiculo
                 , a.cod_veiculo
                 , a.placa
                 , (select vg.cod_grupo
                      from oper.v$veiculo_grupo vg
                     where vg.placa = a.placa
                       and sysdate between vg.data_inicio and nvl(vg.data_termino, sysdate)
                   ) as cod_grupo_veiculo
                 , a.media_km_litro as media_km_litro_veiculo
                 , b.rank as rank_motorista
                 , b.cod_funcionario
                 , b.motorista
                 , (select vg.cod_grupo
                      from oper.v$veiculo_grupo vg
                     where vg.placa = b.placa_motorista
                       and sysdate between vg.data_inicio and nvl(vg.data_termino, sysdate)
                   ) as cod_grupo_motorista
                 , b.media_km_litro as media_km_litro_motorista
              from (
                    select rownum as rank
                         , oper.pkg_veiculo.fnc_get_cod_veiculo(t.placa) as cod_veiculo
                         , t.placa
                         , t.media_km_litro
                      from (
                            select cc.placa
                                 , round(sum(cc.km_rodado) / sum(cc.quantidade_anterior), 2) as media_km_litro
                              from gerencial.v$consumo_combustivel cc
                             cross join (select to_date('#arguments.data_inicio#', 'dd/mm/yyyy') as data_inicio
                                              , to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss') as data_termino
                                           from dual
                                        ) d
                             where cc.data_hora between d.data_inicio and d.data_termino
                               and exists (select 1
                                             from oper.v$veiculo_hist_situacao vhs
                                            where vhs.placa = cc.placa
                                              and vhs.data = (select max(vhs2.data)
                                                                from oper.v$veiculo_hist_situacao vhs2
                                                               where vhs2.placa = vhs.placa
                                                                 and vhs2.data <= d.data_inicio
                                                             )
                                              and vhs.situacao_id = 1
                                          )
                               and exists (select 1
                                             from oper.v$veiculo_modalidade vm
                                            where vm.placa = cc.placa
                                              and vm.data = (select max(vm2.data)
                                                               from oper.v$veiculo_modalidade vm2
                                                              where vm2.placa = vm.placa
                                                                and vm2.data <= d.data_inicio
                                                            )
                                              and vm.modalidade = 'FROTA'
                                          )
                             group by cc.placa
                             order by media_km_litro
                           ) t
                     where rownum <= 10
                   ) a
             inner join
                   (
                    select rownum as rank
                         , (select vmot.placa
                              from oper.v$veiculo_motorista vmot
                             where vmot.cod_pessoa = t.cod_pessoa_motorista
                               and sysdate between vmot.data_inicio and nvl(vmot.data_fim, sysdate)
                           ) as placa_motorista
                         , oper.pkg_global.fnc_get_cod_funcionario(t.cod_pessoa_motorista) as cod_funcionario
                         , kss.pkg_pessoa.fnc_get_cliente(t.cod_pessoa_motorista) as motorista
                         , t.media_km_litro
                      from (
                            select cc.cod_pessoa_motorista
                                 , round(sum(cc.km_rodado) / sum(cc.quantidade_anterior), 2) as media_km_litro
                              from gerencial.v$consumo_combustivel cc
                             cross join (select to_date('#arguments.data_inicio#', 'dd/mm/yyyy') as data_inicio
                                              , to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss') as data_termino
                                           from dual
                                        ) d
                             where cc.data_hora between d.data_inicio and d.data_termino
                               and exists (select 1
                                             from oper.v$veiculo_hist_situacao vhs
                                            where vhs.placa = cc.placa
                                              and vhs.data = (select max(vhs2.data)
                                                                from oper.v$veiculo_hist_situacao vhs2
                                                               where vhs2.placa = vhs.placa
                                                                 and vhs2.data <= d.data_inicio
                                                             )
                                              and vhs.situacao_id = 1
                                          )
                               and exists (select 1
                                             from oper.v$veiculo_modalidade vm
                                            where vm.placa = cc.placa
                                              and vm.data = (select max(vm2.data)
                                                               from oper.v$veiculo_modalidade vm2
                                                              where vm2.placa = vm.placa
                                                                and vm2.data <= d.data_inicio
                                                            )
                                              and vm.modalidade = 'FROTA'
                                          )
                             group by cc.cod_pessoa_motorista
                             order by media_km_litro
                           ) t
                     where rownum <= 10
                   ) b
                     on b.rank = a.rank
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os nmeros de faturamento x pneus
    -- ANDERSON 01/06/2010 - CRIADO
    --->		
    <cffunction name="get_faturamento_pneus" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="yes">
        <cfargument name="data_termino" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_MANUT_FAT_PNEUS_VERDE') as faixa_verde
                 , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_MANUT_FAT_PNEUS_AMARELO') as faixa_amarela
                 , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_MANUT_FAT_PNEUS_META') as meta
                 , round(t.valor_pneus / t.valor_faturamento * 100, 2) as percentual
              from (
                    select (select nvl(sum(f.valor_faturamento), 0)
                              from gerencial.v$faturamento f
                             where f.data_emissao between d.data_inicio and d.data_termino) as valor_faturamento
                         , (
                            compras.pkg_compras.fnc_solicitacao_valor_area(6, d.data_inicio, d.data_termino) +
                            (select nvl(sum(fp.valor), 0)
                             from gerencial.v$faturamento_pneu fp
                            where fp.data_emissao between d.data_inicio and d.data_termino)
                           ) as valor_pneus
                      from (
                            select to_date('#arguments.data_inicio#', 'dd/mm/yyyy') as data_inicio
                                 , to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss') as data_termino
                              from dual
                           ) d
                   ) t
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os nmeros de custo de pneus por KM rodado
    -- ANDERSON 01/06/2010 - CRIADO
    --->		
    <cffunction name="get_custo_pneus_km_rodado" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="yes">
        <cfargument name="data_termino" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_MANUT_CUSTO_PNEUS_KM_VERDE') as faixa_verde
                 , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_MANUT_CUSTO_PNEUS_KM_AMARELO') as faixa_amarela
                 , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_MANUT_CUSTO_PNEUS_KM_VERMELHO') as faixa_vermelha
                 , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_MANUT_CUSTO_PNEUS_KM_META') as meta
                 , round((a.valor_aquisicao_pneus + a.valor_pneus) / a.km_rodado, 2) as custo_pneus_km_rodado
             from (
                   select compras.pkg_compras.fnc_solicitacao_valor_area(6, x.data_inicio, x.data_termino) as valor_aquisicao_pneus
                        , (select nvl(sum(fp.valor), 0)
                             from gerencial.v$faturamento_pneu fp
                            where fp.data_emissao between x.data_inicio and x.data_termino
                          ) as valor_pneus
                        , x.km_rodado
                     from (
                           select sum(t.km_rodado) as km_rodado
                                , t.data_inicio
                                , t.data_termino
                             from (
                                   select gerencial.pkg_rentabilidade.fnc_km_rodado(v.placa, d.data_inicio, d.data_termino) as km_rodado
                                        , d.data_inicio
                                        , d.data_termino
                                     from oper.v$veiculo v
                                    inner join oper.v$veiculo_frota_geral vfg
                                            on vfg.placa = v.placa
                                    inner join oper.v$veiculo_tipo_carroceria vtc
                                            on vtc.tipo_carroceria_id = v.tipo_carroceria_id                    
                                    inner join oper.v$veiculo_agrupamento va
                                            on va.agrupamento_id = vtc.agrupamento_id
                                    cross join (select to_date('#arguments.data_inicio#', 'dd/mm/yyyy') as data_inicio
                                                     , to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss') as data_termino
                                                  from dual
                                               ) d
                                    where va.controla = 1
                                      and va.tracao = 1
                                      and exists (select 1
                                                    from oper.v$veiculo_hist_situacao vhs
                                                   where vhs.placa = v.placa
                                                     and vhs.data = (select max(vhs2.data)
                                                                       from oper.v$veiculo_hist_situacao vhs2
                                                                      where vhs2.placa = vhs.placa
                                                                        and vhs2.data <= d.data_inicio
                                                                    )
                                                     and vhs.situacao_id = 1
                                                 )
                                      and exists (select 1
                                                    from oper.v$veiculo_modalidade vm
                                                   where vm.placa = v.placa
                                                     and vm.data = (select max(vm2.data)
                                                                      from oper.v$veiculo_modalidade vm2
                                                                     where vm2.placa = vm.placa
                                                                       and vm2.data <= d.data_inicio
                                                                   )
                                                     and vm.modalidade = 'FROTA'
                                                 )
                                  ) t
                          ) x
                  ) a
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os nmeros de estoque de pneus
    -- ANDERSON 01/06/2010 - CRIADO
    --->		
    <cffunction name="get_estoque_pneus" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="yes">
        <cfargument name="data_termino" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select pl.cod_centro_custo
                 , (select cc.centro_custo
                      from kss.v$centro_custo cc
                     where cc.cod_centro_custo = pl.cod_centro_custo
                   ) as centro_custo
                 , (count(distinct pl.pneu_id) +
                    (select count(distinct pl2.pneu_id)
                       from oper.v$pneu_localizacao pl2
                      inner join oper.v$pneu p2
                              on p2.pneu_id = pl2.pneu_id
                      where pl2.data_entrada between d.data_inicio and d.data_termino
                        and pl2.cod_centro_custo = pl.cod_centro_custo
                        and p2.situacao_id <> 12
                        and p2.adquirido_novo = 1
                    )
                   ) as qtde_estoque
                 , (select count(distinct pl2.pneu_id)
                      from oper.v$pneu_localizacao pl2
                     inner join oper.v$pneu p2
                             on p2.pneu_id = pl2.pneu_id
                     where pl2.data_saida between d.data_inicio and d.data_termino
                       and pl2.cod_centro_custo = pl.cod_centro_custo
                       and p2.situacao_id <> 12
                       and p2.adquirido_novo = 1
                   ) as qtde_usados
              from oper.v$pneu_localizacao pl
             inner join oper.v$pneu p
                     on p.pneu_id = pl.pneu_id
             cross join (select to_date('#arguments.data_inicio#', 'dd/mm/yyyy') as data_inicio
                              , to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss') as data_termino
                           from dual
                        ) d
             where d.data_inicio between pl.data_entrada and nvl(pl.data_saida, d.data_termino)
               and p.situacao_id <> 12
               and p.adquirido_novo = 1
             group by pl.cod_centro_custo
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!--- 
    -- PROPSITO 
    -- Retorna pendencias em aberto
    -- GUTO 01/06/2010 - CRIADO
    --->		
    <cffunction name="get_pendencias" access="remote" returntype="query" output="true">
        <cfargument name="classificacao" required="no" default=""/>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select mp.tipo, mp.nivel_importancia, count(*) as total
             from gerencial.v$manutencao_pendencias mp
            where mp.atendida = 0
              <cfif Len(Trim(arguments.CLASSIFICACAO))>
                and mp.classificacao = '#arguments.CLASSIFICACAO#'
              </cfif>
            group by mp.tipo, mp.nivel_importancia 
            order by mp.nivel_importancia desc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>    
</cfcomponent>