<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO 
    -- Retorna os grupos de veculo ativos
    -- ANDERSON 21/09/2010 - CRIADO
    --->		
    <cffunction name="get_grupos_veiculos" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select sys_connect_by_path(vgs.cod_grupo, '->') as path
                 , vgs.cod_grupo_pai
                 , vgs.cod_grupo
                 , vgs.descricao
                 , level
                 , level - 1 as nivel
              from oper.v$veiculo_grupo_setup vgs
             where vgs.situacao_id = 1
             start with vgs.cod_grupo_pai is null
            connect by prior vgs.cod_grupo = vgs.cod_grupo_pai
             order siblings by vgs.cod_grupo
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
	
	<!--- 
    -- PROPSITO 
    -- Retorna os nmeros de disponibilidade
    -- ANDERSON 16/05/2010 - CRIADO
    --->		
    <cffunction name="get_disponibilidade" access="remote" returntype="query" output="true">
    	<cfargument name="cod_cliente" required="no" default="">
        <cfargument name="cod_grupo" required="no" default="">
    	<cfargument name="cod_centro_custo" required="no" default="">
        <cfargument name="not_cod_centro_custo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.cod_centro_custo
                 , (select cc.centro_custo
                      from kss.v$centro_custo cc
                     where cc.cod_centro_custo = t.cod_centro_custo) as filial
                 , t.qtde_cavalo
                 , t.qtde_carreta
              from (
                   select d.cod_centro_custo
                        , count(case
                                   when d.classificacao = 'CAVALO' then 1
                                   else null
                                end
                               ) as qtde_cavalo
                        , count(case
                                   when d.classificacao = 'CARRETA' then 1
                                   else null
                                end
                               ) as qtde_carreta
                     from gerencial.mv$disponibilidade d
                    where d.cod_centro_custo is not null
					<cfif Len(Trim(arguments.cod_cliente))>
                      and d.cod_cliente = #arguments.cod_cliente#
                    </cfif>
                    <cfif Len(Trim(arguments.cod_grupo))>
                      and d.cod_grupo in (#ListQualify(arguments.cod_grupo,"'")#)
                    </cfif>
                    <cfif Len(Trim(arguments.cod_centro_custo))>
                      and d.cod_centro_custo = #arguments.cod_centro_custo#
                    </cfif>
                    <cfif Len(Trim(arguments.not_cod_centro_custo))>
                      and d.cod_centro_custo <> #arguments.not_cod_centro_custo#
                    </cfif>
                    group by d.cod_centro_custo
                   ) t
             order by filial 
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

	<!--- 
    -- PROPSITO 
    -- Retorna os nmeros de disponibilidade
    -- ANDERSON 16/05/2010 - CRIADO
    --->		
    <cffunction name="get_disponibilidade_detalhado" access="remote" returntype="query" output="true">
    	<cfargument name="cod_cliente" required="no" default="">
        <cfargument name="cod_grupo" required="no" default="">
    	<cfargument name="cod_centro_custo" required="no" default="">
        <cfargument name="not_cod_centro_custo" required="no" default="">
        <cfargument name="classificacao" required="no" default="">        
        <cfargument name="EM_TRANSITO_CARREGADO" required="no" default="">
        <cfargument name="EM_TRANSITO_VAZIO" required="no" default="">
        <cfargument name="MANUTENCAO" required="no" default="">
        <cfargument name="CARGA" required="no" default="">
        <cfargument name="DESCARGA" required="no" default="">
        <cfargument name="FRONTEIRA" required="no" default="">
        <cfargument name="VAZIO" required="no" default="">
        <cfargument name="SEM_STATUS" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
             select d.placa, oper.pkg_veiculo.fnc_get_cod_veiculo(d.placa) as frota, d.classificacao, d.cod_grupo
              from gerencial.mv$disponibilidade d
             where 1=1
            <cfif Len(Trim(arguments.cod_cliente))>
              and d.cod_cliente = #arguments.cod_cliente#
            </cfif>
            <cfif Len(Trim(arguments.cod_grupo))>
              and d.cod_grupo in (#ListQualify(arguments.cod_grupo,"'")#)
            </cfif>
            <cfif Len(Trim(arguments.cod_centro_custo))>
              and d.cod_centro_custo = #arguments.cod_centro_custo#
            </cfif>
            <cfif Len(Trim(arguments.not_cod_centro_custo))>
              and d.cod_centro_custo <> #arguments.not_cod_centro_custo#
              and d.cod_centro_custo is not null
            </cfif>
            <cfif Len(Trim(arguments.classificacao))>
              and d.classificacao = '#arguments.classificacao#'
            </cfif>
            <cfif Len(Trim(arguments.MANUTENCAO))>
              and d.em_manutencao = #arguments.MANUTENCAO#
              and d.cod_centro_custo is null
            </cfif>
            <cfif Len(Trim(arguments.CARGA))>
              and d.em_carga = #arguments.CARGA#
              and d.cod_centro_custo is null
            </cfif>
            <cfif Len(Trim(arguments.EM_TRANSITO_CARREGADO))>
              and d.EM_TRANSITO_CARREGADO = #arguments.EM_TRANSITO_CARREGADO#
              and d.cod_centro_custo is null
            </cfif>            
            <cfif Len(Trim(arguments.EM_TRANSITO_VAZIO))>
              and d.EM_TRANSITO_VAZIO = #arguments.EM_TRANSITO_VAZIO#
              and d.cod_centro_custo is null
            </cfif>            
            <cfif Len(Trim(arguments.DESCARGA))>
              and d.em_descarga = #arguments.DESCARGA#
              and d.cod_pessoa_filial is null
            </cfif>
            <cfif Len(Trim(arguments.FRONTEIRA))>
              and d.na_fronteira = #arguments.FRONTEIRA#
              and d.cod_centro_custo is null
            </cfif>
            <cfif Len(Trim(arguments.VAZIO))>
              and d.em_manutencao = 0
              and d.em_carga = 0
              and d.EM_TRANSITO_CARREGADO = 0
              and d.EM_TRANSITO_VAZIO = 0
              and d.na_fronteira = 0
              and d.em_descarga = 0
              and d.vazio = #arguments.VAZIO#
              and d.cod_pessoa_filial is null
            </cfif>
            <cfif Len(Trim(arguments.SEM_STATUS))>
              and d.vazio = 0
              and d.em_manutencao = 0
              and d.em_carga = 0
              and d.EM_TRANSITO_CARREGADO = 0
              and d.EM_TRANSITO_VAZIO = 0
              and d.na_fronteira = 0
              and d.em_descarga = 0
            </cfif> 
        </cfquery>
        <cfreturn qr_result>
    </cffunction>    
    
    <!--- 
    -- PROPSITO 
    -- Retorna os nmeros restantes de disponibilidade
    -- ANDERSON 22/05/2010 - CRIADO
    --->		
    <cffunction name="get_disponibilidade_restante" access="remote" returntype="query" output="true">
    	<cfargument name="cod_cliente" required="no" default="">
        <cfargument name="cod_grupo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select count(*) as qtde_veiculos
                 , t.faixa
              from (
                    select case
                              when d.em_manutencao = 1 then 'em_manutencao'
                              when d.em_carga = 1 then 'em_carga'
                              when d.em_descarga = 1 then 'em_descarga'
                              when d.na_fronteira = 1 then 'na_fronteira'
                              when d.em_transito_carregado= 1 then 'em_transito_carregado'
                              when d.em_transito_vazio = 1 then 'em_transito_vazio'
                              when d.vazio = 1 then 'vazio'
                              else 'sem_status'
                           end as faixa
                      from gerencial.mv$disponibilidade d
                     where d.cod_pessoa_filial is null
					<cfif Len(Trim(arguments.cod_cliente))>
                       and d.cod_cliente = #arguments.cod_cliente#
                    </cfif>
                    <cfif Len(Trim(arguments.cod_grupo))>
                       and d.cod_grupo in (#ListQualify(arguments.cod_grupo,"'")#)
                    </cfif>
                   ) t
             group by t.faixa
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os nmeros de produtividade de carga
    -- ANDERSON 18/05/2010 - CRIADO
    --->		
    <cffunction name="get_produtividade_carga" access="remote" returntype="query" output="true">
    	<cfargument name="cod_grupo" required="no" default="">
    	<cfargument name="data_inicial" required="no" default="">
    	<cfargument name="data_final" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select pc.faixa
                 , count(*) as qtde_viagens
              from gerencial.mv$produtividade_carga pc
              inner join oper.v$romaneio r
                      on r.num_romaneio = pc.num_romaneio
             where 1 = 1
			<cfif not Len(Trim(arguments.data_final))>
               and r.situacao_viagem_id = 3
            </cfif>
			<cfif Len(Trim(arguments.cod_grupo))>
			   and pc.cod_grupo_controle in (#ListQualify(arguments.cod_grupo,"'")#)
			</cfif>
			<cfif Len(Trim(arguments.data_inicial))>
			   and pc.data_inicio_carga >= '#arguments.data_inicial#'
			</cfif>
			<cfif Len(Trim(arguments.data_final))>
			   and pc.data_inicio_carga <= '#arguments.data_final# 23:59:59'
			</cfif>
             group by pc.faixa  
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os nmeros de produtividade de descarga
    -- ANDERSON 18/05/2010 - CRIADO
    --->		
    <cffunction name="get_produtividade_descarga" access="remote" returntype="query" output="true">
    	<cfargument name="cod_grupo" required="no" default="">
    	<cfargument name="data_inicial" required="no" default="">
    	<cfargument name="data_final" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select pd.faixa
                 , count(*) as qtde_viagens
              from gerencial.mv$produtividade_descarga pd
              inner join oper.v$romaneio r
                      on r.num_romaneio = pd.num_romaneio
             where 1 = 1
			<cfif not Len(Trim(arguments.data_final))>
               and r.situacao_viagem_id = 5
            </cfif>
			<cfif Len(Trim(arguments.cod_grupo))>
			   and pd.cod_grupo_controle in (#ListQualify(arguments.cod_grupo,"'")#)
			</cfif>
			<cfif Len(Trim(arguments.data_inicial))>
			   and pd.data_inicio_descarga >= '#arguments.data_inicial#'
			</cfif>
			<cfif Len(Trim(arguments.data_final))>
			   and pd.data_inicio_descarga <= '#arguments.data_final# 23:59:59'
			</cfif>            
             group by pd.faixa
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os nmeros de produtividade de fronteira
    -- ANDERSON 19/05/2010 - CRIADO
    --->		
    <cffunction name="get_produtividade_fronteira" access="remote" returntype="query" output="true">
    	<cfargument name="cod_grupo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select pf.faixa
                 , count(*) as qtde_viagens
              from gerencial.v$produtividade_fronteira pf
             where 1 = 1
			<cfif Len(Trim(arguments.cod_grupo))>
			   and pf.cod_grupo_controle in (#ListQualify(arguments.cod_grupo,"'")#)
			</cfif>
             group by pf.faixa
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os nmeros de atraso
    -- ANDERSON 19/05/2010 - CRIADO
    --->		
    <cffunction name="get_atraso" access="remote" returntype="query" output="true">
    	<cfargument name="modalidade" required="no" default="">
        <cfargument name="cod_grupo" required="no" default="">
    	<cfargument name="data_inicial" required="no" default="">
    	<cfargument name="data_final" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select a.faixa
                 , count(*) as qtde_viagens
              from gerencial.mv$atraso a
             where 1 = 1
			<cfif not Len(Trim(arguments.data_final))>
               and a.situacao_id = 0
               and a.situacao_viagem_id in (4, 5, 6)
            </cfif>
			<cfif Len(Trim(arguments.modalidade))>
               and a.modalidade in (#PreserveSingleQuotes(arguments.modalidade)#)
            </cfif>
            <cfif Len(Trim(arguments.cod_grupo))>
			   and a.cod_grupo_controle in (#ListQualify(arguments.cod_grupo,"'")#)
			</cfif>
			<cfif Len(Trim(arguments.data_inicial))>
			   and a.data_inicio >= '#arguments.data_inicial#'
			</cfif>
			<cfif Len(Trim(arguments.data_final))>
			   and a.data_inicio <= '#arguments.data_final# 23:59:59'
			</cfif>            
             group by a.faixa 
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os romaneios de uma faixa de um grfico
    -- ANDERSON 19/05/2010 - CRIADO
    --->		
    <cffunction name="get_romaneio" access="remote" returntype="query" output="true">
    	<cfargument name="grafico" required="yes">
        <cfargument name="faixa" required="yes">
        <cfargument name="cod_grupo" required="no" default="">
    	<cfargument name="data_inicial" required="no" default="">
    	<cfargument name="data_final" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.placa_controle
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(r.placa_controle) as cod_veiculo_controle
                 , r.placa_referencia
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(r.placa_referencia) as cod_veiculo_referencia
				<cfif arguments.grafico eq 1>
                 , kss.to_tempo(t.intervalo_carga_hrs * 60, 3).retorno as tempo
                 , t.intervalo_carga_hrs * 60 as tempo_min
				<cfelseif arguments.grafico eq 2>
                 , kss.to_tempo(t.intervalo_descarga_hrs * 60, 3).retorno as tempo
                 , t.intervalo_descarga_hrs * 60 as tempo_min
                <cfelseif arguments.grafico eq 3>
                 , kss.to_tempo((t.tempo_parado + sysdate - sysdate) * 60, 3).retorno as tempo
                 , (t.tempo_parado + sysdate - sysdate) * 60 as tempo_min
                <cfelseif arguments.grafico eq 4 or arguments.grafico eq 5 or arguments.grafico eq 6>
                 , kss.to_tempo((sysdate - r.data_inicio) * 1440, 3).retorno as tempo
                 , (sysdate - r.data_inicio) * 1440 as tempo_min
                </cfif>
                 , r.num_romaneio
                 , nvl2(r.destino, r.carregamento || ' / ' || r.destino, r.carregamento) as rota
                 , (select kss.fnc_concat_all(distinct kss.to_concat_expr(o.descricao, ' / '))
                      from logistica.v$viagem v
                     inner join logistica.v$viagem_carga vc
                             on vc.viagem_id = v.viagem_id
                     inner join logistica.v$solicitacao_carga sc
                             on sc.solicitacao_carga_id = vc.solicitacao_carga_id
                     inner join logistica.v$operacao o
                             on o.operacao_id = sc.operacao_id
                     where v.num_romaneio = r.num_romaneio
                   ) as operacao
                 , r.cliente
                 , (select kss.pkg_pessoa.fnc_get_cliente(rhv.cod_pessoa)
                      from oper.v$romaneio_hist_veiculo rhv
                     where rhv.num_romaneio = r.num_romaneio
                       and r.data_inicio between rhv.data_inicio and nvl(rhv.data_termino, r.data_inicio)
                   ) as motorista
                 , (select vg.cod_grupo
                      from oper.v$veiculo_grupo vg
                     where vg.placa = r.placa_controle
                       and sysdate between vg.data_inicio and nvl(vg.data_termino, sysdate)) as cod_grupo
              from oper.v$romaneio r
			<cfif arguments.grafico eq 1>
             inner join gerencial.mv$produtividade_carga t
              		 on t.num_romaneio = r.num_romaneio
					<cfif Len(Trim(arguments.data_inicial))>
                       and r.data_inicio_carga >= '#arguments.data_inicial#'
                    <cfelse>
                       and r.situacao_viagem_id = 3
                    </cfif>
                    <cfif Len(Trim(arguments.data_final))>
                       and r.data_inicio_carga <= '#arguments.data_final# 23:59:59'
                    </cfif>            
           	<cfelseif arguments.grafico eq 2>
             inner join gerencial.mv$produtividade_descarga t
             		 on t.num_romaneio = r.num_romaneio
					<cfif Len(Trim(arguments.data_inicial))>
                       and r.data_inicio_descarga >= '#arguments.data_inicial#'
                    <cfelse>
                       and r.situacao_viagem_id = 5
                    </cfif>
                    <cfif Len(Trim(arguments.data_final))>
                       and r.data_inicio_descarga <= '#arguments.data_final# 23:59:59'
                    </cfif>            
            <cfelseif arguments.grafico eq 3>
             inner join gerencial.v$produtividade_fronteira t
             		 on t.num_romaneio = r.num_romaneio
            <cfelseif arguments.grafico eq 4 or arguments.grafico eq 5 or arguments.grafico eq 6>
             inner join gerencial.mv$atraso t
             		 on t.num_romaneio = r.num_romaneio
					<cfif not Len(Trim(arguments.data_inicial))>
                     and t.situacao_id = 0
                     and t.situacao_viagem_id in (4,5,6)
                    </cfif>
					<cfif Len(Trim(arguments.data_inicial))>
                       and r.data_inicio >= '#arguments.data_inicial#'
                    </cfif>
                    <cfif Len(Trim(arguments.data_final))>
                       and r.data_inicio <= '#arguments.data_final# 23:59:59'
                    </cfif>            
            </cfif>
			 where upper(t.faixa) = upper('#arguments.faixa#')
            <cfif arguments.grafico eq 4>
               and t.modalidade = 'FROTA'
            <cfelseif arguments.grafico eq 5>
               and t.modalidade = 'AGREGADO'
            <cfelseif arguments.grafico eq 6>
               and t.modalidade in ('FROTA', 'AGREGADO')
            </cfif>
            <cfif Len(Trim(arguments.cod_grupo))>
			   and t.cod_grupo_controle in (#ListQualify(arguments.cod_grupo,"'")#)
			</cfif> 
            order by tempo_min 
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os nmeros de KM rodado x capacidade
    -- ANDERSON 22/05/2010 - CRIADO
    --->		
    <cffunction name="get_km_rodado_capacidade" access="remote" returntype="query" output="true">
    	<cfargument name="cod_grupo" required="no" default="">
    	<cfargument name="data_inicial" required="no" default="01/#LSDateFormat(Now(),'mm/yyyy')#">
    	<cfargument name="data_final" required="no" default="#LSDateFormat(Now())#">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_CCO_KM_RODADO_CAPACIDADE_AMARELO') as faixa_amarela
                 , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_CCO_KM_RODADO_CAPACIDADE_VERDE') as faixa_verde
                 , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_CCO_KM_RODADO_CAPACIDADE_META') as meta
                 , round(sum(krc.km_rodado) / sum(krc.km_capacidade) * 100, 2) as percentual
              from gerencial.v$km_rodado_capacidade krc
             where 1=1
			  <cfif Len(Trim(arguments.COD_GRUPO))>
                 and krc.cod_grupo in (#ListQualify(arguments.COD_GRUPO,"'")#)
              </cfif>
              <cfif Len(Trim(arguments.DATA_INICIAL))>
				and to_date('01/'||krc.mes_ano,'dd/mm/yyyy') >= to_date('#arguments.DATA_INICIAL#')    
              </cfif>
              <cfif Len(Trim(arguments.DATA_FINAL))>
                and to_date('01/'||krc.mes_ano,'dd/mm/yyyy') <= to_date('#arguments.DATA_FINAL#')              
              </cfif>
         </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os nmeros de KM rodado x capacidade (DETALHADO)
    -- GUTO 22/05/2010 - CRIADO
    --->		
    <cffunction name="get_km_rodado_detalhado" access="remote" returntype="query" output="true">
    	<cfargument name="cod_grupo" required="no" default="">
    	<cfargument name="data_inicial" required="no" default="01/#LSDateFormat(Now(),'mm/yyyy')#">
    	<cfargument name="data_final" required="no" default="#LSDateFormat(Now())#">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select placa, oper.pkg_veiculo.fnc_get_cod_veiculo(placa) as cod_veiculo,
                   cod_grupo, sum(km_capacidade) as capacidade, sum(km_rodado) as km_rodado,
			       to_char(krc.data_inicial,'dd/mm/yyyy') as data_inicial, to_char(krc.data_final,'dd/mm/yyyy') as data_final,
                   round((sum(km_rodado)/sum(km_capacidade))*100,1) as percentual
              from gerencial.v$km_rodado_capacidade krc
             where 1=1
			  <cfif Len(Trim(arguments.COD_GRUPO))>
                 and krc.cod_grupo in (#ListQualify(arguments.COD_GRUPO,"'")#)
              </cfif>
              <cfif Len(Trim(arguments.DATA_INICIAL))>
				and to_date('01/'||krc.mes_ano,'dd/mm/yyyy') >= to_date('#arguments.DATA_INICIAL#')    
              </cfif>
              <cfif Len(Trim(arguments.DATA_FINAL))>
                and to_date('01/'||krc.mes_ano,'dd/mm/yyyy') <= to_date('#arguments.DATA_FINAL#')              
              </cfif>
            group by placa, cod_grupo, to_char(krc.data_inicial,'dd/mm/yyyy'), to_char(krc.data_final,'dd/mm/yyyy') 
            order by placa, data_inicial, data_final
         </cfquery>
        <cfreturn qr_result>
    </cffunction>    
    
    <!--- 
    -- PROPSITO 
    -- Retorna os nmeros de Ton. transportada x capacidade
    -- ANDERSON 22/05/2010 - CRIADO
    --->		
    <cffunction name="get_ton_transportada_capacidade" access="remote" returntype="query" output="true">
    	<cfargument name="cod_grupo" required="no" default="">
    	<cfargument name="data_inicial" required="no" default="01/#LSDateFormat(Now(),'mm/yyyy')#">
    	<cfargument name="data_final" required="no" default="#LSDateFormat(Now())#">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_CCO_TON_TRANSPORTADA_CAPACIDADE_AMARELO') as faixa_amarela
                 , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_CCO_TON_TRANSPORTADA_CAPACIDADE_VERDE') as faixa_verde
                 , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_CCO_TON_TRANSPORTADA_CAPACIDADE_META') as meta
                 , round(sum(ttc.peso_total) / sum(ttc.capacidade) * 100, 2) as percentual
              from gerencial.mv$capacidade_transportada ttc
             where 1=1
		  <cfif Len(Trim(arguments.COD_GRUPO))>
             and ttc.cod_grupo in (#ListQualify(arguments.COD_GRUPO,"'")#)
          </cfif>
		  <cfif Len(Trim(arguments.DATA_INICIAL))>
             and ttc.data_inicio >= '#arguments.DATA_INICIAL#' 
          </cfif>
		  <cfif Len(Trim(arguments.DATA_FINAL))>
             and ttc.data_inicio <= to_date('#arguments.DATA_FINAL# 23:59:59')
          </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os nmeros de Ton. transportada x capacidade (DETALHADO)
    -- GUTO 22/05/2010 - CRIADO
    --->		
    <cffunction name="get_ton_transportada_capacidade_detalhado" access="remote" returntype="query" output="true">
    	<cfargument name="cod_grupo" required="no" default="">
    	<cfargument name="data_inicial" required="no" default="01/#LSDateFormat(Now(),'mm/yyyy')#">
    	<cfargument name="data_final" required="no" default="#LSDateFormat(Now())#">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select oper.pkg_veiculo.fnc_get_cod_veiculo(placa_controle) as frota, cod_grupo,
            	   count(distinct num_romaneio)	as num_viagens,
                   round(sum(capacidade)/1000) as capacidade_carga, round(sum(peso_total)/1000) as peso_transportado,
                   round((sum(peso_total)/decode(sum(capacidade),0,1,sum(capacidade)))*100,1) as percentual
              from gerencial.mv$capacidade_transportada ttc
             where 1=1
		  <cfif Len(Trim(arguments.COD_GRUPO))>
             and ttc.cod_grupo in (#ListQualify(arguments.COD_GRUPO,"'")#)
          </cfif>
		  <cfif Len(Trim(arguments.DATA_INICIAL))>
             and ttc.data_inicio >= '#arguments.DATA_INICIAL#' 
          </cfif>
		  <cfif Len(Trim(arguments.DATA_FINAL))>
             and ttc.data_inicio <= to_date('#arguments.DATA_FINAL# 23:59:59')
          </cfif>
             group by cod_grupo, oper.pkg_veiculo.fnc_get_cod_veiculo(placa_controle)
            order by frota, cod_grupo
        </cfquery>
        <cfreturn qr_result>
    </cffunction>    
    
    <!--- 
    -- PROPSITO 
    -- Retorna os nmeros de faturamento x custo
    -- ANDERSON 22/05/2010 - CRIADO
    --->		
    <cffunction name="get_faturamento_custo" access="remote" returntype="query" output="true">
    	<cfargument name="cod_grupo" required="no" default="">
    	<cfargument name="data_inicial" required="no" default="#LSDateFormat(Now())#">
    	<cfargument name="data_final" required="no" default="#LSDateFormat(Now())#">
        <cfif not Len(Trim(arguments.data_inicial))>
        	<cfset arguments.data_inicial = #LSDateFormat(Now())#>
        </cfif>
        <cfif not Len(Trim(arguments.data_final))>
        	<cfset arguments.data_final = #LSDateFormat(Now())#>
        </cfif>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_CCO_FATURAMENTO_CUSTO_AMARELO') as faixa_amarela
                 , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_CCO_FATURAMENTO_CUSTO_VERDE') as faixa_verde
                 , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_CCO_FATURAMENTO_CUSTO_META') as meta
                 , round(t.custo_total/t.valor_faturamento * 100, 2) as percentual
              from (
                    select sum(fc.valor_faturamento) as valor_faturamento
                         , (sum(fc.custo_carta_frete) + sum(fc.custo_pedagio) + sum(fc.custo_manutencao) + sum(fc.custo_manutencao_km*fc.km_rodado) + sum(fc.custo_manutencao_carreta) + sum(fc.custo_abastecimento) +
                            sum(fc.custo_rastreador) + sum(fc.custo_gerenciamento) + sum(fc.custo_pneu) + sum(fc.custo_pneu_km*fc.km_rodado) + sum(fc.custo_depreciacao) + sum(fc.custo_motorista)
                           ) as custo_total
                      from (select cod_veiculo
                         , placa_tracao
                         , valor_faturamento
                         , cod_grupo
                         , custo_pedagio
                         , custo_abastecimento
                         , custo_carta_frete
                         , km_rodado
                         , custo_manutencao
                         , custo_manutencao_carreta
                         , custo_rastreador
                         , custo_gerenciamento 
                         , custo_depreciacao
                         , custo_motorista
                         , custo_manutencao_km 
                         , custo_pneu_km 
                         , custo_pneu                         
                      from (select a.cod_veiculo
                                 , a.placa_tracao
                                 , a.cod_grupo_atual as cod_grupo
                                 , round(a.valor_faturamento,2) as valor_faturamento
                                 , a.pedagio as custo_pedagio
                                 , nvl((select sum(fa.valor_total)
                                          from gerencial.v$faturamento_abastecimento fa
                                         where fa.placa = a.placa_tracao
                                           and fa.data_hora between a.to_data.data_inicial_mes_atual and sysdate),0) as custo_abastecimento
                                 , nvl((select sum(cf.valor_frete_liquido)
                                          from gerencial.mv$faturamento_carta_frete cf
                                         where cf.placa_controle = a.placa_tracao
                                           and cf.data_emissao between a.to_data.data_inicial_mes_atual and to_date('#arguments.data_final# 23:59:59')),0) as custo_carta_frete
                                     ,nvl((select max(vk.km) keep (dense_rank last order by vk.data_hora)
                                         from oper.v$veiculo_km vk
                                        where vk.placa = a.placa_tracao
                                          and vk.data_hora <= a.to_data.data_final_mes_atual
                                      ) -
                                      (select max(vk.km) keep (dense_rank last order by vk.data_hora)
                                         from oper.v$veiculo_km vk
                                        where vk.placa = a.placa_tracao
                                          and vk.data_hora <= a.to_data.data_inicial_mes_atual
                                      ),0) as km_rodado
                                 , nvl((select sum(fm.valor)
                                          from gerencial.mv$faturamento_manutencao fm
                                         where fm.placa = a.placa_tracao
                                           and fm.data_entrada between a.to_data.data_inicial_mes_atual and to_date('#arguments.data_final# 23:59:59')),0) as custo_manutencao
                                 , round(nvl((select sum(fmc.valor)
                                                from gerencial.v$faturamento_manut_carreta fmc
                                               where fmc.placa_tracao = a.placa_tracao
                                                 and fmc.data between a.to_data.data_inicial_mes_atual and to_date('#arguments.data_final# 23:59:59')),0),2) as custo_manutencao_carreta
                                 , nvl((to_number(gerencial.pkg_gerencial.fnc_valor_numerico('CUSTOS_VEIC_RASTREADOR', a.to_data.data_inicial_mes_anterior))/a.to_data.qtde_dias_mes_atual)*a.to_data.dia_mes_atual, 0) as custo_rastreador
                                 , nvl((to_number(gerencial.pkg_gerencial.fnc_valor_numerico('CUSTOS_VEIC_GERENCIADORA', a.to_data.data_inicial_mes_anterior))/a.to_data.qtde_dias_mes_atual)*a.to_data.dia_mes_atual, 0) as custo_gerenciamento
                                 , nvl((to_number(oper.pkg_frota_dml.fnc_veiculo_get_atributo(a.placa_tracao, 'DEPRECIACAO'))/a.to_data.qtde_dias_mes_atual)*a.to_data.dia_mes_atual, 0) as custo_depreciacao
                                 , case
                                     when a.empresa = 1 then (gerencial.pkg_gerencial.fnc_custo_motorista(a.valor_faturamento)/a.to_data.qtde_dias_mes_atual)*a.to_data.dia_mes_atual
                                   else 0 end custo_motorista
                                 , nvl(gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_CCO_RENTABILIDADE_CUSTO_MANUTENCAO', a.to_data.data_inicial_mes_anterior), 0) as custo_manutencao_km
                                 , nvl(gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_CCO_RENTABILIDADE_CUSTO_PNEU', a.to_data.data_inicial_mes_anterior), 0) as custo_pneu_km
                                 , round(nvl((select sum(fp.custo)
                                                from gerencial.v$faturamento_pneus_novos fp
                                               where fp.placa = a.placa_tracao
                                                 and fp.data_montagem between a.to_data.data_inicial_mes_atual and to_date('#arguments.data_final# 23:59:59')),0),2)
                                 + round(nvl((select sum(fc.valor)
                                                from gerencial.v$faturamento_pneu_carreta fc
                                               where fc.placa_tracao = a.placa_tracao
                                                 and fc.data between a.to_data.data_inicial_mes_atual and to_date('#arguments.data_final# 23:59:59')),0),2) as custo_pneu
                              from (
                            select v.cod_veiculo, f.placa_tracao, vfg.empresa , f.cod_grupo_atual
                                  ,sum(f.valor_faturamento) as valor_faturamento 
                                  ,sum(f.pedagio) as pedagio
                                  ,gerencial.to_data_mes(to_date('#arguments.data_final# 23:59:59')) as to_data
                              from gerencial.v$faturamento f
                              inner join oper.v$veiculo_frota_geral vfg
                                      on vfg.placa = f.placa_tracao
                              inner join oper.v$veiculo v
                                      on v.placa = f.placa_tracao
                              where f.data_emissao between trunc(to_date('#arguments.data_inicial# 00:00:00'),'month') and to_date('#arguments.data_final# 23:59:59')
                              group by v.cod_veiculo, f.placa_tracao, vfg.empresa, f.cod_grupo_atual ) a) x ) fc
                     where 1 = 1
                      <cfif Len(Trim(arguments.COD_GRUPO))>
                         and fc.cod_grupo in (#ListQualify(arguments.COD_GRUPO,"'")#)
                      </cfif>
                   ) t 
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os nmeros detalhados de faturamento x custo
    -- ANDERSON 22/05/2010 - CRIADO
    --->		
    <cffunction name="get_faturamento_custo_detalhado" access="remote" returntype="query" output="true">
    	<cfargument name="cod_grupo" required="no" default="">
    	<cfargument name="data_inicial" required="no" default="#LSDateFormat(Now())#">
    	<cfargument name="data_final" required="no" default="#LSDateFormat(Now())#">
        <cfif not Len(Trim(arguments.data_inicial))>
        	<cfset arguments.data_inicial = #LSDateFormat(Now())#>
        </cfif>
        <cfif not Len(Trim(arguments.data_final))>
        	<cfset arguments.data_final = #LSDateFormat(Now())#>
        </cfif>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cod_veiculo
                 , placa_tracao
                 , valor_faturamento
                 , cod_grupo
                 , custo_pedagio
                 , custo_abastecimento
                 , custo_carta_frete
                 , km_rodado
                 , custo_manutencao
                 , custo_manutencao_carreta
                 , custo_rastreador
                 , custo_gerenciamento as custo_gerenciadora
                 , custo_depreciacao
                 , custo_motorista
                 , custo_manutencao_km * km_rodado as custo_manutencao_geral
                 , custo_pneu_km * km_rodado as custo_pneu_geral
                 , custo_pneu
                 , round(((fc.valor_faturamento -
                    (fc.custo_carta_frete + fc.custo_pedagio + fc.custo_manutencao + fc.custo_manutencao_carreta 
                    + fc.custo_abastecimento + fc.custo_rastreador + fc.custo_gerenciamento + fc.custo_pneu + (fc.custo_pneu_km*fc.km_rodado) + fc.custo_motorista + (fc.custo_manutencao_km*fc.km_rodado) 
                    )
                   ) / valor_faturamento)*100,2) as ebit
                 , round(((fc.valor_faturamento -
                    (fc.custo_carta_frete + fc.custo_pedagio + fc.custo_manutencao + fc.custo_manutencao_carreta 
                    + fc.custo_abastecimento + fc.custo_rastreador + fc.custo_gerenciamento + fc.custo_pneu + (fc.custo_pneu_km*fc.km_rodado) + fc.custo_motorista + (fc.custo_manutencao_km*fc.km_rodado) + custo_depreciacao
                    )
                   ) / valor_faturamento)*100,2) as ebitda
                 , (fc.valor_faturamento -
                    (fc.custo_carta_frete + fc.custo_pedagio + fc.custo_manutencao + fc.custo_manutencao_carreta 
                    + fc.custo_abastecimento + fc.custo_rastreador + fc.custo_gerenciamento + fc.custo_pneu + (fc.custo_pneu_km*fc.km_rodado) + fc.custo_motorista + (fc.custo_manutencao_km*fc.km_rodado) + custo_depreciacao
                    )
                   ) as resultado
              from (select a.cod_veiculo
                         , a.placa_tracao
                         , a.cod_grupo_atual as cod_grupo
                         , round(a.valor_faturamento,2) as valor_faturamento
                         , a.pedagio as custo_pedagio
                         , nvl((select sum(fa.valor_total)
                                  from gerencial.v$faturamento_abastecimento fa
                                 where fa.placa = a.placa_tracao
                                   and fa.data_hora between a.to_data.data_inicial_mes_atual and sysdate),0) as custo_abastecimento
                         , nvl((select sum(cf.valor_frete_liquido)
                                  from gerencial.mv$faturamento_carta_frete cf
                                 where cf.placa_controle = a.placa_tracao
                                   and cf.data_emissao between a.to_data.data_inicial_mes_atual and to_date('#arguments.data_final# 23:59:59')),0) as custo_carta_frete
                             ,nvl((select max(vk.km) keep (dense_rank last order by vk.data_hora)
                                 from oper.v$veiculo_km vk
                                where vk.placa = a.placa_tracao
                                  and vk.data_hora <= a.to_data.data_final_mes_atual
                              ) -
                              (select max(vk.km) keep (dense_rank last order by vk.data_hora)
                                 from oper.v$veiculo_km vk
                                where vk.placa = a.placa_tracao
                                  and vk.data_hora <= a.to_data.data_inicial_mes_atual
                              ),0) as km_rodado
                         , nvl((select sum(fm.valor)
                                  from gerencial.mv$faturamento_manutencao fm
                                 where fm.placa = a.placa_tracao
                                   and fm.data_entrada between a.to_data.data_inicial_mes_atual and to_date('#arguments.data_final# 23:59:59')),0) as custo_manutencao
                         , round(nvl((select sum(fmc.valor)
                                        from gerencial.v$faturamento_manut_carreta fmc
                                       where fmc.placa_tracao = a.placa_tracao
                                         and fmc.data between a.to_data.data_inicial_mes_atual and to_date('#arguments.data_final# 23:59:59')),0),2) as custo_manutencao_carreta
                         , nvl((to_number(gerencial.pkg_gerencial.fnc_valor_numerico('CUSTOS_VEIC_RASTREADOR', a.to_data.data_inicial_mes_anterior))/a.to_data.qtde_dias_mes_atual)*a.to_data.dia_mes_atual, 0) as custo_rastreador
                         , nvl((to_number(gerencial.pkg_gerencial.fnc_valor_numerico('CUSTOS_VEIC_GERENCIADORA', a.to_data.data_inicial_mes_anterior))/a.to_data.qtde_dias_mes_atual)*a.to_data.dia_mes_atual, 0) as custo_gerenciamento
                         , nvl((to_number(oper.pkg_frota_dml.fnc_veiculo_get_atributo(a.placa_tracao, 'DEPRECIACAO'))/a.to_data.qtde_dias_mes_atual)*a.to_data.dia_mes_atual, 0) as custo_depreciacao
                         , case
                             when a.empresa = 1 then (gerencial.pkg_gerencial.fnc_custo_motorista(a.valor_faturamento)/a.to_data.qtde_dias_mes_atual)*a.to_data.dia_mes_atual
                           else 0 end custo_motorista
                         , nvl(gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_CCO_RENTABILIDADE_CUSTO_MANUTENCAO', a.to_data.data_inicial_mes_anterior), 0) as custo_manutencao_km
                         , nvl(gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_CCO_RENTABILIDADE_CUSTO_PNEU', a.to_data.data_inicial_mes_anterior), 0) as custo_pneu_km
                         , round(nvl((select sum(fp.custo)
                                        from gerencial.v$faturamento_pneus_novos fp
                                       where fp.placa = a.placa_tracao
                                         and fp.data_montagem between a.to_data.data_inicial_mes_atual and to_date('#arguments.data_final# 23:59:59')),0),2)
                         + round(nvl((select sum(fc.valor)
                                        from gerencial.v$faturamento_pneu_carreta fc
                                       where fc.placa_tracao = a.placa_tracao
                                         and fc.data between a.to_data.data_inicial_mes_atual and to_date('#arguments.data_final# 23:59:59')),0),2) as custo_pneu
                      from (
                    select v.cod_veiculo, f.placa_tracao, vfg.empresa , f.cod_grupo_atual
                          ,sum(f.valor_faturamento) as valor_faturamento 
                          ,sum(f.pedagio) as pedagio
                          ,gerencial.to_data_mes(to_date('#arguments.data_final# 23:59:59')) as to_data
                      from gerencial.v$faturamento f
                      inner join oper.v$veiculo_frota_geral vfg
                              on vfg.placa = f.placa_tracao
                      inner join oper.v$veiculo v
                              on v.placa = f.placa_tracao
                      where f.data_emissao between trunc(to_date('#arguments.data_inicial# 00:00:00'),'month') and to_date('#arguments.data_final# 23:59:59')
                      group by v.cod_veiculo, f.placa_tracao, vfg.empresa, f.cod_grupo_atual ) a) fc
                      where 1=1
                      <cfif Len(Trim(arguments.COD_GRUPO))>
                         and fc.cod_grupo in (#ListQualify(arguments.COD_GRUPO,"'")#)
                      </cfif>
                      order by ebit                       
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os nmeros de pontualidade
    -- ANDERSON 22/05/2010 - CRIADO
    --->		
    <cffunction name="get_pontualidade" access="remote" returntype="query" output="true">
    	<cfargument name="COD_GRUPO" required="no" default="">
    	<cfargument name="data_inicial" required="no" default="#LSDateFormat(Now())#">
    	<cfargument name="data_final" required="no" default="#LSDateFormat(Now())#">
        <cfif not Len(Trim(arguments.data_inicial))>
        	<cfset arguments.data_inicial = #LSDateFormat(Now())#>
        </cfif>
        <cfif not Len(Trim(arguments.data_final))>
        	<cfset arguments.data_final = #LSDateFormat(Now())#>
        </cfif>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_CCO_PONTUALIDADE_AMARELO') as faixa_amarela
                 , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_CCO_PONTUALIDADE_VERDE') as faixa_verde
                 , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_CCO_PONTUALIDADE_META') as meta
                 , t.qtde_dentro_prazo
                 , t.qtde_total
                 , case
                      when t.qtde_total > 0 then
                         round((t.qtde_dentro_prazo / t.qtde_total) * 100, 2)
                      else 0
                   end as perc_dentro_prazo
              from (
                    select count(case
                                    when p.faixa = 'dentro_prazo' then 1
                                    else null
                                 end
                                ) as qtde_dentro_prazo
                         , count(*) as qtde_total
                      from gerencial.mv$pontualidade p
                     where p.modalidade in ('FROTA', 'AGREGADO')
                       and p.data_termino between to_date('#arguments.data_inicial#', 'dd/mm/yyyy') and to_date('#arguments.data_final# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                       and p.situacao_viagem_id in (4,5,6)
                       <cfif Len(Trim(arguments.COD_GRUPO))>
                          and p.cod_grupo in (#ListQualify(arguments.COD_GRUPO,"'")#)
                       </cfif>
                   ) t 
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os nmeros de regularidade
    -- ANDERSON 22/05/2010 - CRIADO
    --->		
    <cffunction name="get_regularidade" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicial" required="no" default="#LSDateFormat(Now())#">
    	<cfargument name="data_final" required="no" default="#LSDateFormat(Now())#">
        <cfif not Len(Trim(arguments.data_inicial))>
        	<cfset arguments.data_inicial = #LSDateFormat(Now())#>
        </cfif>
        <cfif not Len(Trim(arguments.data_final))>
        	<cfset arguments.data_final = #LSDateFormat(Now())#>
        </cfif>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_CCO_REGULARIDADE_AMARELO') as faixa_amarela
                 , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_CCO_REGULARIDADE_VERDE') as faixa_verde
                 , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_CCO_REGULARIDADE_META') as meta
                 , x.qtde_agendada
                 , x.qtde_total
                 , case
                      when x.qtde_total > 0 then
                         round((x.qtde_agendada / x.qtde_total) * 100, 2)
                      else 0
                   end as perc_agendada
                 , case
                      when x.qtde_total > 0 then
                         round((x.qtde_cancelada / x.qtde_total) * 100, 2)
                      else 0
                   end as perc_cancelada
              from (
                    select sum(t.possui_agendamento) as qtde_agendada
                         , sum(t.cancelada) as qtde_cancelada
                         , count(*) as qtde_total
                      from (
                            select (select sign(count(*))
                                      from logistica.v$viagem_carga vc
                                     where vc.solicitacao_carga_id = sc.solicitacao_carga_id
                                   ) as possui_agendamento
                                 , case
                                      when sc.situacao_id = 5 then 1
                                      else 0
                                   end as cancelada
                              from logistica.v$solicitacao_carga sc
                             where sc.data_carregamento_inicio between to_date('#arguments.data_inicial#', 'dd/mm/yyyy') and to_date('#arguments.data_final# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')                               
                           ) t
                   ) x
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os nmeros de eficcia da frota
    -- ANDERSON 22/05/2010 - CRIADO
    --->		
    <cffunction name="get_eficacia_frota" access="remote" returntype="query" output="true">
    	<cfargument name="COD_GRUPO" required="no" default="">
    	<cfargument name="data_inicial" required="no" default="#LSDateFormat(Now())#">
    	<cfargument name="data_final" required="no" default="#LSDateFormat(Now())#">
        <cfif not Len(Trim(arguments.data_inicial))>
        	<cfset arguments.data_inicial = #LSDateFormat(Now())#>
        </cfif>
        <cfif not Len(Trim(arguments.data_final))>
        	<cfset arguments.data_final = #LSDateFormat(Now())#>
        </cfif>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.qtde_viagens
                 , t.valor_total
                 , t.qtde_viagens_com_retorno
                 , t.valor_com_retorno
                 , t.qtde_viagens_sem_retorno
                 , t.valor_sem_retorno
			     <cfif Len(Trim(arguments.COD_GRUPO))>
                 , gerencial.pkg_rentabilidade.fnc_qtde_veiculos_vazios(to_date('#arguments.data_final# 23:59:59', 'dd/mm/yyyy hh24:mi:ss'),'#arguments.COD_GRUPO#') as qtde_veiculos_vazios
                 <cfelse>
                 , oper.pkg_veiculo.fnc_qtde_veiculos_vazios(to_date('#arguments.data_final# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')) as qtde_veiculos_vazios
                 </cfif>
              from (
                    select count(*) as qtde_viagens
                         , round(nvl(sum(ef.valor_receita), 0), 2) as valor_total
                         , sum(ef.viagem_com_retorno) as qtde_viagens_com_retorno
                         , round(nvl(sum(ef.valor_receita * ef.viagem_com_retorno), 0), 2) as valor_com_retorno
                         , sum(abs(ef.viagem_com_retorno - 1)) as qtde_viagens_sem_retorno
                         , round(nvl(sum(ef.valor_receita * ef.perc_retorno * abs(ef.viagem_com_retorno - 1)), 0), 2) as valor_sem_retorno
                      from gerencial.mv$eficacia_frota ef
                     where ef.data_inicio between to_date('#arguments.data_inicial#', 'dd/mm/yyyy') and to_date('#arguments.data_final# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
				   <cfif Len(Trim(arguments.COD_GRUPO))>
                      and ef.cod_grupo in (#ListQualify(arguments.COD_GRUPO,"'")#)
                   </cfif>
                   ) t 
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os nmeros de tempo mdio entre a solicitao e o agendamento
    -- ANDERSON 22/05/2010 - CRIADO
    --->		
    <cffunction name="get_tempo_solicitacao_agendamento" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicial" required="no" default="#LSDateFormat(Now())#">
    	<cfargument name="data_final" required="no" default="#LSDateFormat(Now())#">
    	<cfargument name="COD_GRUPO" required="no" default="">
        <cfif not Len(Trim(arguments.data_inicial))>
        	<cfset arguments.data_inicial = #LSDateFormat(Now())#>
        </cfif>
        <cfif not Len(Trim(arguments.data_final))>
        	<cfset arguments.data_final = #LSDateFormat(Now())#>
        </cfif>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_CCO_TEMPO_CARGA_AGENDAMENTO_INICIO') as inicio
                 , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_CCO_TEMPO_CARGA_AGENDAMENTO_FIM') as fim
                 , round(nvl(avg(x.tempo_carga_viagem), 0), 2) as tempo_medio_carga_viagem
              from (
                     select (t.date_insert_viagem - t.date_insert_carga) * 24 as tempo_carga_viagem
                       from (
                              select sc.date_insert as date_insert_carga
                                   , (select v.date_insert
                                        from logistica.v$viagem v
                                       where v.viagem_id = vc.viagem_id
                                     ) as date_insert_viagem
                                from logistica.v$solicitacao_carga sc
                               inner join logistica.v$viagem_carga vc
                                       on vc.solicitacao_carga_id = sc.solicitacao_carga_id
                               where sc.situacao_id <> 5 -- Cancelada
                                 and sc.data_carregamento_inicio between to_date('#arguments.data_inicial#', 'dd/mm/yyyy') and to_date('#arguments.data_final# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                            ) t
                   ) x
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os nmeros de tempo mdio entre o agendamento e o destinar
    -- ANDERSON 22/05/2010 - CRIADO
    --->		
    <cffunction name="get_tempo_agendamento_destinar" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicial" required="no" default="#LSDateFormat(Now())#">
    	<cfargument name="data_final" required="no" default="#LSDateFormat(Now())#">
    	<cfargument name="COD_GRUPO" required="no" default="">
        <cfif not Len(Trim(arguments.data_inicial))>
        	<cfset arguments.data_inicial = #LSDateFormat(Now())#>
        </cfif>
        <cfif not Len(Trim(arguments.data_final))>
        	<cfset arguments.data_final = #LSDateFormat(Now())#>
        </cfif>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_CCO_TEMPO_AGENDAMENTO_DESTINAR_INICIO') as inicio
                 , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_CCO_TEMPO_AGENDAMENTO_DESTINAR_FIM') as fim
                 , round(nvl(avg(x.tempo_viagem_destinar), 0), 2) as tempo_medio_viagem_destinar
              from (
                     select (t.date_insert_romaneio - t.date_insert_viagem) * 24 as tempo_viagem_destinar
                       from (
                              select (select min(sc.data_carregamento_inicio)
                                        from logistica.v$viagem_carga vc 
                                        inner join logistica.v$solicitacao_carga sc
                                                on sc.solicitacao_carga_id = vc.solicitacao_carga_id
                                       where vc.viagem_id = v.viagem_id  
                                     ) as date_insert_viagem
                                   , v.data_vinculo_romaneio as date_insert_romaneio
                                from logistica.v$viagem v
                               where v.data_vinculo_romaneio between to_date('#arguments.data_inicial#', 'dd/mm/yyyy') and to_date('#arguments.data_final# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                                 and v.situacao_id not in (0,6) -- Cancelado
                                 and v.modalidade <> 'TERCEIRO'
                            ) t
                   ) x
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os nmeros de veculos com problemas de macro
    -- ANDERSON 22/05/2010 - CRIADO
    --->
    <cffunction name="get_veiculos_problema_macro" access="remote" returntype="query" output="true">
    	<cfargument name="parametro" required="no" default="">
    	<cfargument name="COD_GRUPO" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_CCO_VEICULOS_PROBLEMA_MACRO_INICIO') as inicio
                 , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_CCO_VEICULOS_PROBLEMA_MACRO_FIM') as fim
                 , count(distinct evm.placa) as qtde_veiculos
              from integracao.v$controle_mensagens em
            inner join integracao.v$evento_mensagem evm
                    on evm.MENSAGEM_ID = em.MENSAGEM_ID
            inner join oper.v$veiculo vd
                    on vd.placa = evm.placa
            inner join oper.v$veiculo_modalidade_atual vma
                    on vma.placa = vd.placa
            inner join oper.v$veiculo_grupo vg
                    on vg.placa = vd.placa
                   and sysdate between vg.data_inicio and nvl(vg.data_termino, sysdate)
             where em.situacao_id in (1, 2, 3, 4, 5, 6)
               and em.tipo_id = 2
               and evm.critica = 1
               and vma.modalidade in ('FROTA', 'AGREGADO')
			   <cfif Len(Trim(arguments.COD_GRUPO))>
                  and vg.cod_grupo in (#ListQualify(arguments.COD_GRUPO,"'")#)
               </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!--- 
    -- PROPSITO 
    -- Retorna os nmeros de veculos com problemas de macro (DETALHADO)
    -- ANDERSON 22/05/2010 - CRIADO
    --->
    <cffunction name="get_veiculos_problema_macro_detalhado" access="remote" returntype="query" output="true">
    	<cfargument name="COD_GRUPO" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select /*+ use_hash(em evm) */ vd.cod_veiculo, evm.placa, vg.cod_grupo,
            	   to_char(min(evm.data_envio),'dd/mm/yyyy hh24:mi') as data,
                   kss.to_tempo((sysdate - min(evm.data_envio))*1440,3).retorno as tempo_problema,
                   (sysdate - min(evm.data_envio))*1440 as tempo_min
              from integracao.v$controle_mensagens em
            inner join integracao.v$evento_mensagem evm
                    on evm.MENSAGEM_ID = em.MENSAGEM_ID
            inner join oper.v$veiculo vd
                    on vd.placa = evm.placa
            inner join oper.v$veiculo_modalidade_atual vma
                    on vma.placa = vd.placa
            inner join oper.v$veiculo_grupo vg
                    on vg.placa = vd.placa
                   and sysdate between vg.data_inicio and nvl(vg.data_termino, sysdate)
             where em.situacao_id in (1, 2, 3, 4, 5, 6)
               and em.tipo_id = 2
               and evm.critica = 1
               and vma.modalidade in ('FROTA', 'AGREGADO')
			   <cfif Len(Trim(arguments.COD_GRUPO))>
                  and vg.cod_grupo in (#ListQualify(arguments.COD_GRUPO,"'")#)
               </cfif>
               group by vd.cod_veiculo, evm.placa, vg.cod_grupo
               order by vg.cod_grupo, tempo_min desc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os projetos
    -- ANDERSON 21/09/2010 - CRIADO
    --->		
    <cffunction name="get_projeto" access="remote" returntype="query" output="true">
    	<cfargument name="ano" required="yes">
    	<cfargument name="cod_grupo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select p.projeto_id
                 , p.nome
                 , p.descricao
              from gerencial.v$projeto p
             where exists (select 1
                             from gerencial.v$projeto_valor pv
                            where pv.projeto_id = p.projeto_id
                              and pv.ano = #arguments.ano#
							<cfif Len(Trim(arguments.cod_grupo))>
                              and pv.cod_grupo in (#ListQualify(arguments.cod_grupo, "'")#)
							</cfif>
                          )
             order by p.nome
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os grupos de um projeto
    -- ANDERSON 21/09/2010 - CRIADO
    --->		
    <cffunction name="get_projeto_grupos" access="remote" returntype="query" output="true">
    	<cfargument name="projeto_id" required="yes">
        <cfargument name="ano" required="yes">
    	<cfargument name="cod_grupo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select vgs.cod_grupo
                 , vgs.descricao
              from oper.v$veiculo_grupo_setup vgs
             where exists (select 1
                             from gerencial.v$projeto_valor pv
                            where pv.cod_grupo = vgs.cod_grupo
                              and pv.projeto_id = #arguments.projeto_id#
                              and pv.ano = #arguments.ano#
                          )
			<cfif Len(Trim(arguments.cod_grupo))>
               and vgs.cod_grupo in (#ListQualify(arguments.cod_grupo, "'")#)
			</cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os nmeros de faturamento dos projetos (Acumulado)
    -- ANDERSON 22/05/2010 - CRIADO
    --->		
    <cffunction name="get_faturamento_projetos_acumulado" access="remote" returntype="query" output="true">
        <cfargument name="ano" required="yes">
        <cfargument name="cod_grupo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select d.ano
                 , d.mes
                 , round(nvl(sum(pv.valor_previsao), 0), 2) as valor_previsao
                 , round(nvl(sum(pv.valor_realizado), 0), 2) as valor_realizado
              from (
                    select extract(month from (add_months(trunc(to_date('#arguments.ano#', 'yyyy'), 'year'), (level - 1)))) as mes
                         , extract(year from (add_months(trunc(to_date('#arguments.ano#', 'yyyy'), 'year'), (level - 1)))) as ano
                      from dual
                   connect by level <= 12
                   ) d
              left join gerencial.v$projeto_valor pv
                     on pv.ano = d.ano
                    and pv.mes = d.mes
				<cfif Len(Trim(arguments.cod_grupo))>
                    and pv.cod_grupo in (#ListQualify(arguments.cod_grupo, "'")#)
                </cfif>
             group by d.ano, d.mes
             order by d.ano, d.mes
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!--- 
    -- PROPSITO 
    -- Retorna os nmeros de faturamento de um projeto
    -- ANDERSON 22/05/2010 - CRIADO
    --->		
    <cffunction name="get_faturamento_projetos" access="remote" returntype="query" output="true">
        <cfargument name="ano" required="yes">
        <cfargument name="projeto_id" required="yes">
        <cfargument name="cod_grupo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select p.nome
                 , d.ano
                 , d.mes
                 , round(nvl(sum(pv.valor_previsao), 0), 2) as valor_previsao
                 , round(nvl(sum(pv.valor_realizado), 0), 2) as valor_realizado
              from (
                    select extract(month from (add_months(trunc(to_date('#arguments.ano#', 'yyyy'), 'year'), (level - 1)))) as mes
                         , extract(year from (add_months(trunc(to_date('#arguments.ano#', 'yyyy'), 'year'), (level - 1)))) as ano
                      from dual
                   connect by level <= 12
                   ) d
             cross join gerencial.v$projeto p
              left join gerencial.v$projeto_valor pv
                     on pv.projeto_id = p.projeto_id
                    and pv.ano = d.ano
                    and pv.mes = d.mes
				<cfif Len(Trim(arguments.cod_grupo))>
                    and pv.cod_grupo in (#ListQualify(arguments.cod_grupo, "'")#)
                </cfif>
             where p.projeto_id = #arguments.projeto_id#
             group by p.nome, d.ano, d.mes
             order by d.ano, d.mes
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!--- 
    -- PROPSITO 
    -- Retorna KMs 
    -- ANDERSON 22/05/2010 - CRIADO
    --->		
    <cffunction name="get_km_rodado_30dias" access="remote" returntype="query" output="true">
        <cfargument name="COD_GRUPO" required="no" default=""/>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cod_veiculo, placa, cod_grupo, ultima_data, modalidade, km30dias, rownum as linha,
            	   gerencial.pkg_gerencial.fnc_valor_numerico('KM_MAX_RODADO_30_DIAS') as valor_max,	
            	   gerencial.pkg_gerencial.fnc_valor_numerico('KM_MIN_RODADO_30_DIAS') as valor_min	
              from (
            select cod_veiculo, placa, cod_grupo, ultima_data, modalidade,
                   (select nvl((max(km) -min(km)), 0)
                        from oper.v$veiculo_km
                       where data_hora >= sysdate - 30
                         and placa = a.placa) as km30dias
              from (
            select v.cod_veiculo, v.placa, vg.cod_grupo, va.modalidade,
                   max(vk.km) keep (dense_rank last order by vk.data_hora) as ultimo_km,
                   max(vk.data_hora) keep (dense_rank last order by vk.data_hora) as ultima_data
              from oper.v$veiculo_dados v
              inner join oper.v$veiculo_modalidade_atual va
               on va.placa = v.placa
              inner join oper.v$veiculo_hist_situacao_atual vs
                      on vs.placa = v.placa
              inner join oper.v$veiculo_km vk
                      on vk.placa = v.placa
              inner join oper.v$veiculo_grupo vg
                      on vg.placa = v.placa 
                     and sysdate between vg.data_inicio and nvl(vg.data_termino,sysdate)          
              where va.modalidade in ('FROTA','AGREGADO')
              and vs.situacao_id = 1
              and vk.data_hora between trunc(sysdate,'month') and sysdate
              group by v.cod_veiculo, v.placa, vg.cod_grupo,va.modalidade) a) b
              where 1=1
              <cfif Len(Trim(arguments.COD_GRUPO))>
                  and b.cod_grupo in (#ListQualify(arguments.COD_GRUPO,"'")#)
              </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
</cfcomponent>
