<cfcomponent extends="_transportes.funcoes.cfc_init">
        <!---
    -- PROPSITO
    -- Retorna periodo
    -- GUTO 01/07/2010 - CRIADO
    --->
    <cffunction name="get_custo_solicitacao_periodo" access="remote" returntype="query" output="true">
        <cfargument name="cod_conta" required="no" default="">
        <cfargument name="area_id" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.ano_mes_aprovacao as ano_mes_solicitacao,
                   t.mes_ano_aprovacao as mes_ano_solicitacao
              from gerencial.v$solicitacao_compra t
              where t.ano_mes_aprovacao is not null
                and to_date(t.ano_mes_aprovacao,'yyyymm') > sysdate-(12*30)
              <cfif Len(Trim(arguments.COD_CENTRO_CUSTO))>
                and t.cod_centro_custo in (#arguments.COD_CENTRO_CUSTO#)
              </cfif>
              <cfif Len(Trim(arguments.AREA_ID))>
                and t.area_id in (#arguments.AREA_ID#)
              </cfif>
              <cfif Len(Trim(arguments.COD_CONTA))>
                and t.cod_conta in (#ListQualify(arguments.COD_CONTA,"'")#)
              </cfif>
            group by t.ano_mes_aprovacao, t.mes_ano_aprovacao
            order by ano_mes_solicitacao desc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

        <!---
    -- PROPSITO
    -- Retorna valores das solicitaes
    -- GUTO 01/07/2010 - CRIADO
    --->
    <cffunction name="get_custo_solicitacao" access="remote" returntype="query" output="true">
        <cfargument name="cod_conta" required="no" default=""/>
        <cfargument name="area_id" required="no" default=""/>
        <cfargument name="cod_centro_custo" required="no" default=""/>
        <cfargument name="tipo" required="no" default="1"/>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select
                   <cfswitch expression="#arguments.tipo#">
                      <cfcase value="1">
                           t.ano_mes_aprovacao as ano_mes,
                           t.mes_ano_aprovacao as mes_ano,
                      </cfcase>
                                          <cfcase value="2">
                           to_char(t.data_pedido,'yyyymm') as ano_mes,
                           t.mes_ano_pedido as mes_ano,
                      </cfcase>
                                          <cfcase value="3">
                           to_char(t.data_nota_entrada,'yyyymm') as ano_mes,
                           t.mes_nota_entrada as mes_ano,
                      </cfcase>
                   </cfswitch>
                   sum(t.valor_finalizado) as valor_nota,
                   sum(t.valor_executado) as valor_executado,
                   sum(t.valor_total_solicitacao) as valor_solicitado
              from gerencial.v$solicitacao_compra t
              where t.ano_mes_aprovacao is not null
                and to_date(t.ano_mes_aprovacao,'yyyymm') > sysdate-(12*30)
              <cfif Len(Trim(arguments.COD_CENTRO_CUSTO))>
                and t.cod_centro_custo in (#arguments.COD_CENTRO_CUSTO#)
              </cfif>
              <cfif Len(Trim(arguments.AREA_ID))>
                and t.area_id in (#arguments.AREA_ID#)
              </cfif>
              <cfif Len(Trim(arguments.COD_CONTA))>
                and t.cod_conta in (#ListQualify(arguments.COD_CONTA,"'")#)
              </cfif>
              <cfswitch expression="#arguments.tipo#">
                  <cfcase value="1">
                    group by t.ano_mes_aprovacao, t.mes_ano_aprovacao
                  </cfcase>
                  <cfcase value="2">
                    and t.mes_ano_pedido is not null
                            group by to_char(t.data_pedido,'yyyymm'), t.mes_ano_pedido
                  </cfcase>
                  <cfcase value="3">
                    and t.mes_nota_entrada is not null
                            group by to_char(t.data_nota_entrada,'yyyymm'), t.mes_nota_entrada
                  </cfcase>
              </cfswitch>
            order by ano_mes desc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

<!---
    -- PROPSITO
    -- Retorna resumo de valor por rea
    -- GUTO 19/03/2010 - CRIADO
    --->
    <cffunction name="get_detalhamento" access="remote" returntype="query" output="true">
        <cfargument name="mes_ano" required="no" default="">
        <cfargument name="area_id" required="no" default="">
        <cfargument name="cod_conta" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfargument name="situacao_id" required="no" default="">
        <cfargument name="tipo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select num_controle, titulo,
                   filial,
                   cod_centro_custo,
                   to_char(data_solicitacao,'dd/mm/yyyy') as data_emissao,
                   cod_equipamento, placa, responsavel,
                   nota_fiscal,
                   ano_mes_solicitacao,
                   mes_ano_solicitacao,
                   to_char(data_nota_emissao,'dd/mm/yyyy') as data_nota_emissao,
                   mes_nota_emissao,
                   to_char(data_nota_entrada,'dd/mm/yyyy') as data_nota_entrada,
                   mes_nota_entrada,
                   area,
                   area_id,
                   cod_conta,
                   fornecedor_ped,
                   fornecedor_solicitacao,
                   valor_executado,
                   valor_finalizado,
                   valor_total_solicitacao,
                   valor_solicitado
              from gerencial.v$solicitacao_compra t
              where 1=1
<!---              <cfswitch expression="#arguments.tipo#">
                <cfcase value="1">
                        and valor_finalizado > 0
                </cfcase>
                <cfcase value="2">
                        and valor_executado > 0
                </cfcase>
                <cfcase value="3">
                        and valor_solicitado > 0
                </cfcase>
              </cfswitch>--->
              <cfif Len(Trim(arguments.MES_ANO))>
                and t.mes_ano_aprovacao = '#arguments.MES_ANO#'
              </cfif>

              <cfif Len(Trim(arguments.COD_CENTRO_CUSTO))>
                and t.cod_centro_custo in (#arguments.COD_CENTRO_CUSTO#)
              </cfif>
              <cfif Len(Trim(arguments.AREA_ID))>
                and t.area_id in (#arguments.AREA_ID#)
              </cfif>
              <cfif Len(Trim(arguments.COD_CONTA))>
                and t.cod_conta in (#ListQualify(arguments.COD_CONTA,"'")#)
              </cfif>
          order by fornecedor_ped, data_solicitacao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

        <!---
    -- PROPSITO
    -- Retorna detalhamento mes
    -- GUTO 01/07/2010 - CRIADO
    --->
    <cffunction name="get_custo_solicitacao_mes" access="remote" returntype="query" output="true">
        <cfargument name="cod_conta" required="no" default="">
        <cfargument name="area_id" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfargument name="ano_mes" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select to_char(data_aprovacao,'dd/mm/yyyy') as data_aprovacao, valor_total_solicitacao,
            	   sum(valor_total_solicitacao) over(order by trunc(data_aprovacao) rows unbounded preceding) as acumulado
              from (select trunc(t.data_aprovacao) as data_aprovacao, sum(t.valor_total_solicitacao) as valor_total_solicitacao
                      from gerencial.v$solicitacao_compra t
                      where t.ano_mes_aprovacao is not null
                      <cfif Len(Trim(arguments.COD_CENTRO_CUSTO))>
                        and t.cod_centro_custo in (#arguments.COD_CENTRO_CUSTO#)
                      </cfif>
                      <cfif Len(Trim(arguments.AREA_ID))>
                        and t.area_id in (#arguments.AREA_ID#)
                      </cfif>
                      <cfif Len(Trim(arguments.COD_CONTA))>
                        and t.cod_conta in (#ListQualify(arguments.COD_CONTA,"'")#)
                      </cfif>
                      <cfif Len(Trim(arguments.ANO_MES))>
                        and t.ano_mes_aprovacao = #arguments.ANO_MES#
                      </cfif>
                    group by trunc(t.data_aprovacao)
                       order by data_aprovacao)
        </cfquery>
        <cfreturn qr_result>
    </cffunction>    

        <!---
    -- PROPSITO
    -- Retorna detalhamento mes
    -- GUTO 01/07/2010 - CRIADO
    --->
    <cffunction name="get_custo_solicitacao_data" access="remote" returntype="query" output="true">
        <cfargument name="cod_conta" required="no" default="">
        <cfargument name="area_id" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfargument name="data" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select area, valor_total_solicitacao,
                   sum(valor_total_solicitacao) over(order by valor_total_solicitacao rows unbounded preceding) as acumulado
              from (select t.area, sum(t.valor_total_solicitacao) as valor_total_solicitacao
                      from gerencial.v$solicitacao_compra t
                          where t.ano_mes_aprovacao is not null
                          <cfif Len(Trim(arguments.COD_CENTRO_CUSTO))>
                            and t.cod_centro_custo in (#arguments.COD_CENTRO_CUSTO#)
                          </cfif>
                          <cfif Len(Trim(arguments.AREA_ID))>
                            and t.area_id in (#arguments.AREA_ID#)
                          </cfif>
                          <cfif Len(Trim(arguments.COD_CONTA))>
                            and t.cod_conta in (#ListQualify(arguments.COD_CONTA,"'")#)
                          </cfif>
                          <cfif Len(Trim(arguments.DATA))>
                            and trunc(t.data_aprovacao) = '#arguments.DATA#'
                          </cfif>
                        group by t.area, trunc(t.data_aprovacao)
                        order by valor_total_solicitacao)
        </cfquery>
        <cfreturn qr_result>
    </cffunction>  
    
<!---
    -- PROPSITO
    -- Retorna resumo de valor por rea
    -- GUTO 19/03/2010 - CRIADO
    --->
    <cffunction name="get_detalhamento_placas" access="remote" returntype="query" output="true">
        <cfargument name="notas" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select distinct compras.pkg_compras.fnc_get_pedido_placa(nt.pedido_id) as placa
              from table(kss.pkg_string.fnc_split('#arguments.notas#',',')) a
              inner join fiscal.v$nf_terceiro_pedido_item nt
              on nt.num_nota_id = to_number(a.column_value)
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

        <!---
    -- PROPSITO
    -- Retorna Custo Filial
    -- GUTO 01/07/2010 - CRIADO
    --->
    <cffunction name="get_painel_custo_filial_fornecedor" access="remote" returntype="query" output="true">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfargument name="mes" required="no" default="">
        <cfargument name="ano" required="no" default="">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_fim" required="no" default="">
        <cfargument name="atual" required="no" default="1">
        <cfif arguments.atual eq 1>
                <cfset arguments.mes = Month(Now())>
                <cfset arguments.ano = Year(Now())>
        </cfif>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select p.cliente as fornecedor_ped
                  ,f.cod_pessoa_fornecedor
                  ,nvl(valor_finalizado,0) as valor_finalizado
                  ,nvl(valor_executado,0) as valor_executado
                  ,nvl((select sum(compras.pkg_compras.fnc_solicitacao_valor_total(s.solicitacao_id)) as valor_solicitado
                      from compras.v$solicitacao s
                      inner join kss.v$organograma o
                              on o.cod_organograma = s.cod_organograma
                     where 1=1
                       <cfif Len(Trim(arguments.mes))>
                               and to_char(s.data_emissao,'mm/yyyy') = '#NumberFormat(arguments.mes,'00')#/#arguments.ano#'
                       </cfif>
                       <cfif Len(Trim(arguments.data_inicio))>
                          and s.data_emissao between '#arguments.data_inicio#' and to_date('#arguments.data_fim# 23:59:59')
                       </cfif>
                       <cfif Len(Trim(arguments.cod_centro_custo))>
                         and o.cod_centro_custo = #arguments.cod_centro_custo#
                       </cfif>
                       and s.cod_pessoa_fornecedor = a.cod_pessoa_fornecedor
                       and s.situacao_id not in (6,9,10,11)),0) as valor_solicitado
                  ,nvl(cco.valor,0) as orcamento
                  ,nvl((cco.valor/gerencial.to_data_mes(sysdate).qtde_dias_mes_atual)*gerencial.to_data_mes(sysdate).dia_mes_atual,0) as ritmo_mes
                  ,case
                    when f.tipo_cobranca = 3 then (cco.valor/gerencial.to_data_mes(sysdate).qtde_dias_mes_atual)*gerencial.to_data_mes(sysdate).dia_mes_atual
                    when f.tipo_cobranca = 2 then 0/*km_rodado*/ * f.custo_por_km
                   else -1 end total_custo
              from gerencial.v$centro_custo_fornecedor f
              inner join kss.v$pessoa p
                      on p.cod_pessoa = f.cod_pessoa_fornecedor
              <cfif Len(Trim(arguments.cod_centro_custo))>inner<cfelse>left</cfif> join (select sc.fornecedor_ped, sc.fornecedor_ped_pessoa as cod_pessoa_fornecedor, sum(sc.valor_finalizado) as valor_finalizado,
                           sum(sc.valor_executado) as valor_executado
                      from gerencial.v$solicitacao_compra sc
                      inner join gerencial.v$centro_custo_fornecedor ccf
                              on ccf.cod_centro_custo = sc.cod_centro_custo
                             and ccf.cod_pessoa_fornecedor = sc.fornecedor_ped_pessoa
                     where 1=1
                       <cfif Len(Trim(arguments.mes))>
                          and sc.mes_ano_base = '#NumberFormat(arguments.mes,'00')#/#arguments.ano#'
                       </cfif>
                       <cfif Len(Trim(arguments.data_inicio))>
                          and sc.data_nota_entrada between '#arguments.data_inicio#' and to_date('#arguments.data_fim# 23:59:59')
                       </cfif>
                       <cfif Len(Trim(arguments.cod_centro_custo))>
                         and sc.cod_centro_custo = #arguments.cod_centro_custo#
                       </cfif>
                    group by sc.fornecedor_ped_pessoa, sc.fornecedor_ped) a
                on f.cod_pessoa_fornecedor = a.cod_pessoa_fornecedor
              left join gerencial.v$ccusto_fornecedor_orcamento cco
                     on cco.controle_id_fornecedor = f.controle_id
                    <cfif Len(Trim(arguments.mes))>
                            and cco.mes = #NumberFormat(arguments.mes,'00')#
                    </cfif>
                    <cfif Len(Trim(arguments.ano))>
                            and cco.ano = #arguments.ano#
                    </cfif>
                    <cfif Len(Trim(arguments.data_inicio))>
                            and cco.mes = to_char(to_date('#arguments.data_inicio#','dd/mm/yyyy'),'mm')
                            and cco.ano = to_char(to_date('#arguments.data_inicio#','dd/mm/yyyy'),'yyyy')
                    </cfif>
            where 1=1
                           <cfif Len(Trim(arguments.cod_centro_custo))>
                 and f.cod_centro_custo = #arguments.cod_centro_custo#
               </cfif>
              and f.data_fim is null
             order by valor_finalizado desc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

        <!---
    -- PROPSITO
    -- Retorna Custo Filial
    -- GUTO 01/07/2010 - CRIADO
    --->
    <cffunction name="get_painel_custo_filial_organizacional" access="remote" returntype="query" output="true">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_fim" required="no" default="">
        <cfargument name="mes" required="no" default="">
        <cfargument name="PLANO_CONTA_ID" required="no" default="">
        <cfargument name="ano" required="no" default="">
        <cfargument name="atual" required="no" default="1">
        <cfif arguments.atual eq 1>
                <cfset arguments.mes = Month(Now())>
                <cfset arguments.ano = Year(Now())>
        </cfif>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select o.organizacional_id, kss.pkg_organizacional.fnc_descricao_completa(o.organizacional_id) as centro_custo, o.cod_organizacional,
                   a.perc_rateio, a.valor_rateio as total_custo, nvl(ccorg.valor,0) as orcamento
                   <cfif Len(Trim(arguments.mes))>
                  ,nvl((ccorg.valor/gerencial.to_data_mes(to_date('01/#arguments.mes#/#arguments.ano#','dd/mm/yyyy')).qtde_dias_mes_atual)*gerencial.to_data_mes(to_date('01/#arguments.mes#/#arguments.ano#','dd/mm/yyyy')).dia_mes_atual,0) as ritmo_mes
                  </cfif>
                  <cfif Len(Trim(arguments.data_inicio))>
                  ,nvl((ccorg.valor/gerencial.to_data_mes(to_date('#arguments.data_inicio#','dd/mm/yyyy')).qtde_dias_mes_atual)*gerencial.to_data_mes(to_date('#arguments.data_inicio#','dd/mm/yyyy')).dia_mes_atual,0) as ritmo_mes
                  </cfif>
              from (select nr.organizacional_id_gerencial,
                           avg(nr.perc_rateio) as perc_rateio, sum(nr.valor_rateio) as valor_rateio
                      from fiscal.v$nf_terceiro nt
                     inner join fiscal.v$nf_terceiro_rateio ntr
                             on ntr.num_nota_id = nt.num_nota_id
                     inner join fiscal.v$nf_rateio nr
                             on nr.nf_rateio_id = ntr.nf_rateio_id
                     where 1=1
                       <cfif Len(Trim(arguments.PLANO_CONTA_ID))>
                                                        and exists (select 0
                                         from gerencial.mv$solicitacao_fornecedor t
                                       inner join compras.v$solicitacao s
                                              on s.solicitacao_id = t.solicitacao_id
                                       inner join compras.v$area a
                                              on a.area_id = s.area_id
                                       where nt.num_nota_id = t.num_nota_id
                                         and a.plano_conta_id = #arguments.PLANO_CONTA_ID#)
                       </cfif>
                       <cfif Len(Trim(arguments.mes))>
                               and trunc(nt.data_entrada,'month') = to_char('01/#arguments.mes#/#arguments.ano#')
                       </cfif>
                       <cfif Len(Trim(arguments.data_inicio))>
                          and trunc(nt.data_entrada) between '#arguments.data_inicio#' and to_date('#arguments.data_fim# 23:59:59')
                       </cfif>
                     group by nr.organizacional_id_gerencial) a
             inner join kss.v$organizacional o
                     on o.organizacional_id = a.organizacional_id_gerencial
             <cfif Len(Trim(arguments.cod_centro_custo))>inner<cfelse>left</cfif> join gerencial.v$ccusto_organizacional cco
                      on cco.organizacional_id = o.organizacional_id
                    <cfif Len(Trim(arguments.cod_centro_custo))>
                     and cco.cod_centro_custo = #arguments.cod_centro_custo#
                    </cfif>
             left join gerencial.v$ccusto_org_orcamento ccorg
                    on ccorg.controle_id_cc_organizacional = cco.controle_id
                        <cfif Len(Trim(arguments.mes))>
               and ccorg.mes = #NumberFormat(arguments.mes,'00')#
            </cfif>
            <cfif Len(Trim(arguments.ano))>
               and ccorg.ano = #arguments.ano#
            </cfif>
            <cfif Len(Trim(arguments.data_inicio))>
                and ccorg.mes = to_char(to_date('#arguments.data_inicio#','dd/mm/yyyy'),'mm')
                and ccorg.ano = to_char(to_date('#arguments.data_inicio#','dd/mm/yyyy'),'yyyy')
            </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

        <!---
    -- PROPSITO
    -- Retorna Detalhamento do centro de custo gerencial
    -- GUTO 01/07/2010 - CRIADO
    --->
    <cffunction name="get_painel_custo_filial_detalhe_fornecedor" access="remote" returntype="query" output="true">
        <cfargument name="cod_centro_custo" required="no" default="null">
        <cfargument name="organizacional_id" required="no" default="">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_fim" required="no" default="">
        <cfargument name="mes" required="no" default="">
        <cfargument name="ano" required="no" default="">
        <cfargument name="atual" required="no" default="1">
        <cfif arguments.atual eq 1>
                <cfset arguments.mes = Month(Now())>
                <cfset arguments.ano = Year(Now())>
        </cfif>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select a.emit_razao_social, a.cod_emitente, a.emitente, sum(a.valor_rateio) as valor,
                   kss.fnc_concat_all(kss.to_concat_expr(a.num_nota_id,',')) as notas
              from (
            select nr.organizacional_id_gerencial,
                   nr.perc_rateio, nr.valor_rateio,
                   nt.emit_razao_social, nt.cod_emitente, pe.cliente as emitente,
                   nt.data_emissao, nt.data_entrada, nt.num_nota_id
              from fiscal.v$nf_terceiro nt
             inner join fiscal.v$nf_terceiro_rateio ntr
                     on ntr.num_nota_id = nt.num_nota_id
             inner join fiscal.v$nf_rateio nr
                     on nr.nf_rateio_id = ntr.nf_rateio_id
             inner join kss.v$pessoa pe
                     on pe.cod_pessoa = nt.cod_emitente
             where 1=1
                           <cfif Len(Trim(arguments.mes))>
                   and trunc(nt.data_entrada,'month') = to_char('01/#arguments.mes#/#arguments.ano#')
               </cfif>
               <cfif Len(Trim(arguments.data_inicio))>
                  and trunc(nt.data_entrada) between '#arguments.data_inicio#' and to_date('#arguments.data_fim# 23:59:59')
               </cfif>
               and ntr.organizacional_id_gerencial = #arguments.organizacional_id#
             ) a
             inner join kss.v$organizacional o
             <cfif Len(Trim(arguments.cod_centro_custo))>inner<cfelse>left</cfif> join gerencial.v$ccusto_organizacional cco
                      on cco.organizacional_id = o.organizacional_id
                    <cfif Len(Trim(arguments.cod_centro_custo))>
                      and cco.cod_centro_custo = #arguments.cod_centro_custo#
                    </cfif>
                on o.organizacional_id = a.organizacional_id_gerencial
            group by a.emit_razao_social, a.cod_emitente, a.emitente
            order by valor
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    <!---
    -- PROPSITO
    -- Retorna Custo de carta-frete por gestor
    -- LEOPOLDOS 06/09/2010 - CRIADO
    --->
    <cffunction name="get_painel_custo_carta_frete_gestor" access="remote" returntype="query" output="true">
                <cfargument name="data_inicio" required="no" default="01/#LSDateFormat(Now(),'mm/yyyy')#">
        <cfargument name="data_termino" required="no" default="#LSDateFormat(Now())#">
        <cfif not Len(Trim(arguments.data_inicio))>
                <cfset arguments.data_inicio = "01/#LSDateFormat(Now(),'mm/yyyy')#">
        </cfif>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select b.usuario_liberacao
                 , b.gestor
                 , b.meta
                 , sum(frete_bruto+pedagio+valor_icms_ctrc+recuperacao_icms+recuperacao_pis_cofins) as valor_receita
                 , decode(sum(frete_bruto),0,100,100-round(100*(sum(frete_bruto+pedagio+valor_icms_ctrc+total_pis_cofins+valor_icms_pago+recuperacao_icms+pedagio_cf+seguro+carta_frete+recuperacao_pis_cofins+valor_sest_senat_inss)/sum(frete_bruto+pedagio+valor_icms_ctrc+recuperacao_icms+recuperacao_pis_cofins)),2)) as percentual_medio
                 , -1*sum(total_pis_cofins+valor_icms_pago+pedagio_cf+seguro+carta_frete+valor_sest_senat_inss) as total_cf
              from (
            select usuario_liberacao,
                   gestor
                   ,meta
                   ,total_receita_sem_pedagio - (a.total_receita_bruta - a.total_receita_liquida) as frete_bruto
                   ,a.total_receita_bruta - a.total_receita_sem_pedagio as pedagio
                   ,(a.total_receita_bruta - a.total_receita_liquida) as valor_icms_ctrc
                   ,-1*(a.total_receita_sem_pedagio * (9.25/100)) as total_pis_cofins
                   ,-1*((a.total_receita_bruta - a.total_receita_liquida)) as valor_icms_pago
                   ,(a.total_receita_bruta - a.total_receita_liquida)*0.2 as recuperacao_icms
                   ,-1*valor_pedagio_cf as pedagio_cf
                   ,-1*((a.total_receita_liquida - (a.total_receita_bruta - a.total_receita_sem_pedagio))*0.003) as seguro
                   ,-1*valor_frete_bruto as carta_frete
                   ,((valor_frete_bruto-valor_pedagio_cf)*0.75)*(9.25/100) as recuperacao_pis_cofins
                   ,-1*a.valor_sest_senat_inss as valor_sest_senat_inss
              from (
                select ct.usuario_liberacao
                                          , (select upper(u.nome)
                                               from kss.v$usuarios u
                                              where u.usuario = ct.usuario_liberacao ) as gestor
                                          , nvl((case
                                                     when exists (select 1
                                                             from fiscal.v$intc_crt_embarque_divisao ice
                                                            where ice.lancto_id = ct.lancto_id) then
                                                      (select oper.pkg_contrato_transp.fnc_valor_receita_bruta(p_num_romaneio=>null,p_divisao_id => ice.divisao_id)
                                                         from fiscal.v$intc_crt_embarque_divisao ice
                                                        where ice.lancto_id = ct.lancto_id
                                                        and rownum = 1)
                                                     when ct.num_romaneio is not null then
                                                      oper.pkg_contrato_transp.fnc_valor_receita_bruta(ct.num_romaneio)
                                                     when ct.conhecimento_id is not null then
                                                      oper.pkg_contrato_transp.fnc_valor_receita_bruta(p_num_romaneio=>null,p_conhecimento_id => ct.conhecimento_id_diaria)
                                                     when ct.crt_id_diaria is not null then
                                                      oper.pkg_contrato_transp.fnc_valor_receita_bruta(p_num_romaneio=>null,p_crt_id_diaria => ct.crt_id_diaria)
                                                   end),
                                                   0) as total_receita_bruta
                                          , nvl((case
                                                     when exists (select 1
                                                             from fiscal.v$intc_crt_embarque_divisao ice
                                                            where ice.lancto_id = ct.lancto_id) then
                                                      (select oper.pkg_contrato_transp.fnc_valor_receita_sem_pedagio(p_num_romaneio=>null,p_divisao_id => ice.divisao_id)
                                                         from fiscal.v$intc_crt_embarque_divisao ice
                                                        where ice.lancto_id = ct.lancto_id
                                                        and rownum = 1)
                                                     when ct.num_romaneio is not null then
                                                      oper.pkg_contrato_transp.fnc_valor_receita_sem_pedagio(ct.num_romaneio)
                                                     when ct.conhecimento_id is not null then
                                                      oper.pkg_contrato_transp.fnc_valor_receita_sem_pedagio(p_num_romaneio=>null,p_conhecimento_id => ct.conhecimento_id_diaria)
                                                     when ct.crt_id_diaria is not null then
                                                      oper.pkg_contrato_transp.fnc_valor_receita_sem_pedagio(p_num_romaneio=>null,p_crt_id_diaria => ct.crt_id_diaria)
                                                   end),
                                                   0) as total_receita_sem_pedagio
                                          , nvl((case
                                                     when exists (select 1
                                                             from fiscal.v$intc_crt_embarque_divisao ice
                                                            where ice.lancto_id = ct.lancto_id) then
                                                      (select oper.pkg_contrato_transp.fnc_valor_contrato_receita(p_num_romaneio=>null,p_divisao_id => ice.divisao_id)
                                                         from fiscal.v$intc_crt_embarque_divisao ice
                                                        where ice.lancto_id = ct.lancto_id
                                                        and rownum = 1)
                                                     when ct.num_romaneio is not null then
                                                      oper.pkg_contrato_transp.fnc_valor_contrato_receita(ct.num_romaneio)
                                                     when ct.conhecimento_id is not null then
                                                      oper.pkg_contrato_transp.fnc_valor_contrato_receita(p_num_romaneio=>null,p_conhecimento_id => ct.conhecimento_id_diaria)
                                                     when ct.crt_id_diaria is not null then
                                                      oper.pkg_contrato_transp.fnc_valor_contrato_receita(p_num_romaneio=>null,p_crt_id_diaria => ct.crt_id_diaria)
                                                   end),
                                                   0) as total_receita_liquida
                                          , (select max(m.percentual_carta_frete) keep(dense_rank last order by data_vigencia)
                                               from gerencial.v$gestor_meta_inadimplencia m
                                              where m.data_vigencia <= '#arguments.data_termino# 23:59:59'
                                                and m.gestor_id = (select g.gestor_id
                                                                     from gerencial.v$gestor g
                                                                    where g.usuario = ct.usuario_liberacao)
                                            ) as meta
                                          , ct.valor_frete_bruto
                                          , p.tipo_pessoa
                                          , (select nvl(sum(cti.valor),0)
                                               from oper.v$contrato_transp_item cti
                                              where cti.lancto_id = ct.lancto_id
                                                and cti.item_id in (23,24,21)) as valor_sest_senat_inss
                                          , (select nvl(sum(cti.valor),0)
                                               from oper.v$contrato_transp_item cti
                                              where cti.lancto_id = ct.lancto_id
                                                and cti.item_id in (1,4)) as valor_pedagio_cf
                                          ,ct.num_rpa
                                       from oper.v$contrato_transp ct
                                      inner join kss.v$pessoa p
                                              on p.cod_pessoa = ct.proprietario_cod_pessoa
                                      where ct.data_cancelamento is null
                                        and ct.senha_liberacao is not null
                                        and ct.percentual_receita is not null
                                        and ct.usuario_liberacao is not null
                                        and ct.data_emissao > '#arguments.data_inicio# 00:00:00'
                                                                                <cfif Len(Trim(arguments.data_termino))>
                                        and ct.data_emissao <= '#arguments.data_termino# 23:59:59'
                                        </cfif>
                                    ) a
            ) b
            group by b.usuario_liberacao, b.gestor, b.meta
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    <!---
    -- PROPSITO
    -- Retorna carta-frete por gestor/perodo
    -- LEOPOLDOS 06/09/2010 - CRIADO
    --->
    <cffunction name="get_carta_frete" access="remote" returntype="query" output="true">
        <cfargument name="usuario_gestor" required="yes">
                <cfargument name="data_inicio" required="no" default="01/#LSDateFormat(Now(),'mm/yyyy')#">
        <cfargument name="data_termino" required="no" default="#LSDateFormat(Now())#">
        <cfif not Len(Trim(arguments.data_inicio))>
                <cfset arguments.data_inicio = "01/#LSDateFormat(Now(),'mm/yyyy')#">
        </cfif>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select b.*
                  ,frete_bruto+pedagio+valor_icms_ctrc+recuperacao_icms+recuperacao_pis_cofins as total_receita
                  ,-1*(total_pis_cofins+valor_icms_pago+pedagio_cf+seguro+carta_frete) as valor_frete_bruto
                  ,(frete_bruto+pedagio+valor_icms_ctrc+total_pis_cofins+valor_icms_pago+recuperacao_icms+pedagio_cf+seguro+carta_frete+recuperacao_pis_cofins+valor_sest_senat_inss) as margem_bruta
                  ,round(100*((frete_bruto+pedagio+valor_icms_ctrc+total_pis_cofins+valor_icms_pago+recuperacao_icms+pedagio_cf+seguro+carta_frete+recuperacao_pis_cofins+valor_sest_senat_inss)/decode((frete_bruto),0,(frete_bruto+pedagio+valor_icms_ctrc+total_pis_cofins+valor_icms_pago+recuperacao_icms+pedagio_cf+seguro+carta_frete+recuperacao_pis_cofins),(frete_bruto))),2) as perc_margem_bruta
              from (
            select num_formulario,
                   lancto_id,
                   data_emissao,
                   num_romaneio,
                   num_conhecimento,
                   operacao,
                   usuario_liberacao,
                   gestor,
                   filial,
                   cavalo,
                   carreta,
                   remetente,
                   destinatario
                   ,total_receita_sem_pedagio - (a.total_receita_bruta - a.total_receita_liquida) as frete_bruto
                   ,a.total_receita_bruta - a.total_receita_sem_pedagio as pedagio
                   ,(a.total_receita_bruta - a.total_receita_liquida) as valor_icms_ctrc
                   ,-1*(a.total_receita_sem_pedagio * (9.25/100)) as total_pis_cofins
                   ,-1*((a.total_receita_bruta - a.total_receita_liquida)) as valor_icms_pago
                   ,(a.total_receita_bruta - a.total_receita_liquida)*0.2 as recuperacao_icms
                   ,-1*valor_pedagio_cf as pedagio_cf
                   ,-1*((a.total_receita_liquida - (a.total_receita_bruta - a.total_receita_sem_pedagio))*0.003) as seguro
                   ,-1*valor_frete_bruto as carta_frete
                   ,((valor_frete_bruto-valor_pedagio_cf)*0.75)*(9.25/100) as recuperacao_pis_cofins
                   ,-1*a.valor_sest_senat_inss as valor_sest_senat_inss
              from (
                select ct.num_formulario
                             , ct.lancto_id
                             , to_char(ct.data_emissao, 'dd/MM/yyyy')  as data_emissao
                             , ct.num_romaneio
                             , (select co.num_conhecimento
                                  from fiscal.v$conhecimento co
                                 where co.conhecimento_id = ct.conhecimento_id) as num_conhecimento
                             , (select op.descricao
                                  from oper.v$romaneio_item r
                                 inner join logistica.v$operacao op
                                         on op.operacao_id = r.operacao_id
                                 where rownum = 1
                                   and r.num_romaneio = ct.num_romaneio) as operacao
                             , (select ctf.cf_remetente
                                  from oper.v$contrato_transp_form ctf
                                 where ctf.documento_id = ct.lancto_id) as remetente
                             , (select ctf.cf_destinatario
                                  from oper.v$contrato_transp_form ctf
                                 where ctf.documento_id = ct.lancto_id) as destinatario
                             , nvl2(ct.placa_controle, oper.pkg_veiculo.fnc_get_cod_veiculo(ct.placa_controle), ct.placa_controle) as cavalo
                             , nvl2(ct.placa_referencia, oper.pkg_veiculo.fnc_get_cod_veiculo(ct.placa_referencia), ct.placa_referencia) as carreta
                             , kss.pkg_pessoa.fnc_get_cliente(ct.cod_pessoa_filial) as filial
                             , ct.usuario_liberacao
                                          , (select upper(u.nome)
                                               from kss.v$usuarios u
                                              where u.usuario = ct.usuario_liberacao ) as gestor
                                          , nvl((case
                                                     when exists (select 1
                                                             from fiscal.v$intc_crt_embarque_divisao ice
                                                            where ice.lancto_id = ct.lancto_id) then
                                                      (select oper.pkg_contrato_transp.fnc_valor_receita_bruta(p_num_romaneio=>null,p_divisao_id => ice.divisao_id)
                                                         from fiscal.v$intc_crt_embarque_divisao ice
                                                        where ice.lancto_id = ct.lancto_id
                                                        and rownum = 1)
                                                     when ct.num_romaneio is not null then
                                                      oper.pkg_contrato_transp.fnc_valor_receita_bruta(ct.num_romaneio)
                                                     when ct.conhecimento_id is not null then
                                                      oper.pkg_contrato_transp.fnc_valor_receita_bruta(p_num_romaneio=>null,p_conhecimento_id => ct.conhecimento_id_diaria)
                                                     when ct.crt_id_diaria is not null then
                                                      oper.pkg_contrato_transp.fnc_valor_receita_bruta(p_num_romaneio=>null,p_crt_id_diaria => ct.crt_id_diaria)
                                                   end),
                                                   0) as total_receita_bruta
                                          , nvl((case
                                                     when exists (select 1
                                                             from fiscal.v$intc_crt_embarque_divisao ice
                                                            where ice.lancto_id = ct.lancto_id) then
                                                      (select oper.pkg_contrato_transp.fnc_valor_receita_sem_pedagio(p_num_romaneio=>null,p_divisao_id => ice.divisao_id)
                                                         from fiscal.v$intc_crt_embarque_divisao ice
                                                        where ice.lancto_id = ct.lancto_id
                                                        and rownum = 1)
                                                     when ct.num_romaneio is not null then
                                                      oper.pkg_contrato_transp.fnc_valor_receita_sem_pedagio(ct.num_romaneio)
                                                     when ct.conhecimento_id is not null then
                                                      oper.pkg_contrato_transp.fnc_valor_receita_sem_pedagio(p_num_romaneio=>null,p_conhecimento_id => ct.conhecimento_id_diaria)
                                                     when ct.crt_id_diaria is not null then
                                                      oper.pkg_contrato_transp.fnc_valor_receita_sem_pedagio(p_num_romaneio=>null,p_crt_id_diaria => ct.crt_id_diaria)
                                                   end),
                                                   0) as total_receita_sem_pedagio
                                          , nvl((case
                                                     when exists (select 1
                                                             from fiscal.v$intc_crt_embarque_divisao ice
                                                            where ice.lancto_id = ct.lancto_id) then
                                                      (select oper.pkg_contrato_transp.fnc_valor_contrato_receita(p_num_romaneio=>null,p_divisao_id => ice.divisao_id)
                                                         from fiscal.v$intc_crt_embarque_divisao ice
                                                        where ice.lancto_id = ct.lancto_id
                                                        and rownum = 1)
                                                     when ct.num_romaneio is not null then
                                                      oper.pkg_contrato_transp.fnc_valor_contrato_receita(ct.num_romaneio)
                                                     when ct.conhecimento_id is not null then
                                                      oper.pkg_contrato_transp.fnc_valor_contrato_receita(p_num_romaneio=>null,p_conhecimento_id => ct.conhecimento_id_diaria)
                                                     when ct.crt_id_diaria is not null then
                                                      oper.pkg_contrato_transp.fnc_valor_contrato_receita(p_num_romaneio=>null,p_crt_id_diaria => ct.crt_id_diaria)
                                                   end),
                                                   0) as total_receita_liquida
                                          , ct.valor_frete_bruto
                                          , p.tipo_pessoa
                                          , (select nvl(sum(cti.valor),0)
                                               from oper.v$contrato_transp_item cti
                                              where cti.lancto_id = ct.lancto_id
                                                and cti.item_id in (23,24,21)) as valor_sest_senat_inss
                                           , (select nvl(sum(cti.valor),0)
                                               from oper.v$contrato_transp_item cti
                                              where cti.lancto_id = ct.lancto_id
                                                and cti.item_id in (1,4)) as valor_pedagio_cf
                                          ,ct.num_rpa
                                       from oper.v$contrato_transp ct
                                      inner join kss.v$pessoa p
                                              on p.cod_pessoa = ct.proprietario_cod_pessoa
                                      where ct.data_cancelamento is null
                                            and upper(ct.usuario_liberacao) = upper('#arguments.usuario_gestor#')
                                        and ct.senha_liberacao is not null
                                        and ct.percentual_receita is not null
                                        and ct.usuario_liberacao is not null
                                        and ct.data_emissao >= '#arguments.data_inicio# 00:00:00'
                                        <cfif Len(Trim(arguments.data_termino))>
                                        and ct.data_emissao <= '#arguments.data_termino# 23:59:59'
                                        </cfif>
                                    ) a
            ) b
                        order by b.data_emissao desc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    <!---
    -- PROPSITO
    -- Retorna Custo de solicitao de compra por mes
    -- LEOPOLDOS 08/09/2010 - CRIADO
    --->
    <cffunction name="get_painel_custo_solicitacao_compra_mes" access="remote" returntype="query" output="true">
                <cfargument name="data_inicio" required="no" default="01/#LSDateFormat(DateAdd('m', -12, Now()),'mm/yyyy')#">
        <cfargument name="data_termino" required="no" default="#LSDateFormat(Now())#">
                <cfargument name="area_id" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        select a.mes
             , a.ano
             , round(sum(a.valor_negociado), 2) as valor
          from ( select p.pedido_id
                      , s.solicitacao_id
                      , c.valor_negociado
                      , extract(month from (s.data_aprovacao)) as mes
                      , extract(year from (s.data_aprovacao)) as ano
                      , s.area_id
                      , (select o.cod_centro_custo
                           from kss.v$organograma o
                          where o.cod_organograma = s.cod_organograma ) as cod_centro_custo
                   from compras.v$pedido p
                  inner join compras.v$pedido_item pi
                          on pi.pedido_id = p.pedido_id
                  inner join compras.v$cotacao c
                          on c.cotacao_id = pi.cotacao_id
                  inner join compras.v$orcamento_atividade oa
                          on oa.orcamento_atividade_id = c.orcamento_atividade_id
                  inner join compras.v$orcamento_atividade_solic oas
                          on oas.orcamento_atividade_id = oa.orcamento_atividade_id
                  inner join compras.v$solicitacao_atividade sa
                          on sa.controle_id = oas.solicitacao_atividade_id
                  inner join compras.v$solicitacao s
                          on s.solicitacao_id = sa.solicitacao_id
                  where 1=1
                    and c.aprovada = 1
                    and p.situacao_id = 1
                    and s.situacao_id = 6
                    <cfif Len(Trim(arguments.area_id))>
                    and s.area_id = #arguments.area_id#
                    </cfif>
                    and s.data_aprovacao >= '#arguments.data_inicio# 00:00:00'
                    <cfif Len(Trim(arguments.data_termino))>
                    and s.data_aprovacao <= '#arguments.data_termino# 23:59:59'
                    </cfif>
                 union
                 select p.pedido_id
                      , s.solicitacao_id
                      , c.valor_negociado
                      , extract(month from (s.data_aprovacao)) as mes
                          , extract(year from (s.data_aprovacao)) as ano
                      , s.area_id
                      , (select o.cod_centro_custo
                           from kss.v$organograma o
                          where o.cod_organograma = s.cod_organograma ) as cod_centro_custo
                   from compras.v$pedido p
                  inner join compras.v$pedido_item pi
                          on pi.pedido_id = p.pedido_id
                  inner join compras.v$cotacao c
                          on c.cotacao_id = pi.cotacao_id
                  inner join compras.v$orcamento_material om
                          on om.orcamento_material_id = c.orcamento_material_id
                  inner join compras.v$orcamento_material_solic oms
                          on oms.orcamento_material_id = om.orcamento_material_id
                  inner join compras.v$solicitacao_material sm
                          on sm.controle_id = oms.solicitacao_material_id
                  inner join compras.v$solicitacao s
                          on s.solicitacao_id = sm.solicitacao_id
                  where 1=1
                    and c.aprovada = 1
                    and p.situacao_id = 1
                    and s.situacao_id = 6
                    <cfif Len(Trim(arguments.area_id))>
                    and s.area_id = #arguments.area_id#
                    </cfif>
                    and s.data_aprovacao >= '#arguments.data_inicio# 00:00:00'
                    <cfif Len(Trim(arguments.data_termino))>
                    and s.data_aprovacao <= '#arguments.data_termino# 23:59:59'
                    </cfif>) a
          <cfif Len(Trim(arguments.cod_centro_custo))>
          where a.cod_centro_custo in (#arguments.cod_centro_custo#)
          </cfif>
          group by a.ano, a.mes
          order by a.ano, a.mes
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    <!---
    -- PROPSITO
    -- Retorna Custo de solicitao de compra por rea
    -- LEOPOLDOS 08/09/2010 - CRIADO
    --->
    <cffunction name="get_painel_custo_solicitacao_compra_area" access="remote" returntype="query" output="true">
                <cfargument name="data_inicio" required="no" default="01/#LSDateFormat(DateAdd('m', -12, Now()),'mm/yyyy')#">
        <cfargument name="data_termino" required="no" default="#LSDateFormat(Now())#">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        select (select ar.descricao
                  from compras.v$area ar
                 where ar.area_id = a.area_id ) as area
             , round(sum(a.valor_negociado), 2) as valor
             , a.area_id
          from ( select p.pedido_id
                      , s.solicitacao_id
                      , c.valor_negociado
                      , extract(month from (s.data_emissao)) as mes
                      , extract(year from (s.data_emissao)) as ano
                      , s.area_id
                      , (select o.cod_centro_custo
                           from kss.v$organograma o
                          where o.cod_organograma = s.cod_organograma ) as cod_centro_custo
                   from compras.v$pedido p
                  inner join compras.v$pedido_item pi
                          on pi.pedido_id = p.pedido_id
                  inner join compras.v$cotacao c
                          on c.cotacao_id = pi.cotacao_id
                  inner join compras.v$orcamento_atividade oa
                          on oa.orcamento_atividade_id = c.orcamento_atividade_id
                  inner join compras.v$orcamento_atividade_solic oas
                          on oas.orcamento_atividade_id = oa.orcamento_atividade_id
                  inner join compras.v$solicitacao_atividade sa
                          on sa.controle_id = oas.solicitacao_atividade_id
                  inner join compras.v$solicitacao s
                          on s.solicitacao_id = sa.solicitacao_id
                  where 1=1
                    and c.aprovada = 1
                    and p.situacao_id = 1
                    and s.situacao_id = 6
                    and s.data_emissao >= '#arguments.data_inicio# 00:00:00'
                    <cfif Len(Trim(arguments.data_termino))>
                    and s.data_emissao <= '#arguments.data_termino# 23:59:59'
                    </cfif>
                 union
                 select p.pedido_id
                      , s.solicitacao_id
                      , c.valor_negociado
                      , extract(month from (s.data_emissao)) as mes
                      , extract(year from (s.data_emissao)) as ano
                      , s.area_id
                      , (select o.cod_centro_custo
                           from kss.v$organograma o
                          where o.cod_organograma = s.cod_organograma ) as cod_centro_custo
                   from compras.v$pedido p
                  inner join compras.v$pedido_item pi
                          on pi.pedido_id = p.pedido_id
                  inner join compras.v$cotacao c
                          on c.cotacao_id = pi.cotacao_id
                  inner join compras.v$orcamento_material om
                          on om.orcamento_material_id = c.orcamento_material_id
                  inner join compras.v$orcamento_material_solic oms
                          on oms.orcamento_material_id = om.orcamento_material_id
                  inner join compras.v$solicitacao_material sm
                          on sm.controle_id = oms.solicitacao_material_id
                  inner join compras.v$solicitacao s
                          on s.solicitacao_id = sm.solicitacao_id
                  where 1=1
                    and c.aprovada = 1
                    and p.situacao_id = 1
                    and s.situacao_id = 6
                                        and s.data_emissao >= '#arguments.data_inicio# 00:00:00'
                    <cfif Len(Trim(arguments.data_termino))>
                    and s.data_emissao <= '#arguments.data_termino# 23:59:59'
                    </cfif>
                    ) a
          <cfif Len(Trim(arguments.cod_centro_custo))>
          where a.cod_centro_custo in (#arguments.cod_centro_custo#)
          </cfif>
          group by a.area_id
          order by a.area_id
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    <!---
    -- PROPSITO
    -- Retorna totais do painel de custo de carta frete
    -- LEOPOLDOS 08/09/2010 - CRIADO
    --->
    <cffunction name="get_totais_custo_carta_frete" access="remote" returntype="query" output="true">
                <cfargument name="data_inicio" required="no" default="01/#LSDateFormat(Now(),'mm/yyyy')#">
        <cfargument name="data_termino" required="no" default="#LSDateFormat(Now())#">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select sum(valor_receita) as valor_frete
                   ,sum(total_cf) as valor_cf
                   ,sum(quantidade) as quantidade
                   ,round((sum(total_cf)/sum(valor_receita))*100,2) as percentual_medio
              from (select b.usuario_liberacao
                 , b.gestor
                 , b.meta
                 , count(*) as quantidade
                 , sum(frete_bruto+pedagio+valor_icms_ctrc+recuperacao_icms+recuperacao_pis_cofins) as valor_receita
                 , decode(sum(frete_bruto),0,100,100-round(100*(sum(frete_bruto+pedagio+valor_icms_ctrc+total_pis_cofins+valor_icms_pago+recuperacao_icms+pedagio_cf+seguro+carta_frete+recuperacao_pis_cofins+valor_sest_senat_inss)/sum(frete_bruto+pedagio+valor_icms_ctrc+recuperacao_icms+recuperacao_pis_cofins)),2)) as percentual_medio
                 , -1*sum(total_pis_cofins+valor_icms_pago+pedagio_cf+seguro+carta_frete+valor_sest_senat_inss) as total_cf
              from (
            select usuario_liberacao,
                   gestor
                   ,meta
                   ,total_receita_sem_pedagio - (a.total_receita_bruta - a.total_receita_liquida) as frete_bruto
                   ,a.total_receita_bruta - a.total_receita_sem_pedagio as pedagio
                   ,(a.total_receita_bruta - a.total_receita_liquida) as valor_icms_ctrc
                   ,-1*(a.total_receita_sem_pedagio * (9.25/100)) as total_pis_cofins
                   ,-1*((a.total_receita_bruta - a.total_receita_liquida)) as valor_icms_pago
                   ,(a.total_receita_bruta - a.total_receita_liquida)*0.2 as recuperacao_icms
                   ,-1*valor_pedagio_cf as pedagio_cf
                   ,-1*((a.total_receita_liquida - (a.total_receita_bruta - a.total_receita_sem_pedagio))*0.003) as seguro
                   ,-1*valor_frete_bruto as carta_frete
                   ,((valor_frete_bruto-valor_pedagio_cf)*0.75)*(9.25/100) as recuperacao_pis_cofins
                   ,-1*a.valor_sest_senat_inss as valor_sest_senat_inss
              from (
                select ct.usuario_liberacao
                                          , (select upper(u.nome)
                                               from kss.v$usuarios u
                                              where u.usuario = ct.usuario_liberacao ) as gestor
                                          , nvl((case
                                                     when exists (select 1
                                                             from fiscal.v$intc_crt_embarque_divisao ice
                                                            where ice.lancto_id = ct.lancto_id) then
                                                      (select oper.pkg_contrato_transp.fnc_valor_receita_bruta(p_num_romaneio=>null,p_divisao_id => ice.divisao_id)
                                                         from fiscal.v$intc_crt_embarque_divisao ice
                                                        where ice.lancto_id = ct.lancto_id
                                                        and rownum = 1)
                                                     when ct.num_romaneio is not null then
                                                      oper.pkg_contrato_transp.fnc_valor_receita_bruta(ct.num_romaneio)
                                                     when ct.conhecimento_id is not null then
                                                      oper.pkg_contrato_transp.fnc_valor_receita_bruta(p_num_romaneio=>null,p_conhecimento_id => ct.conhecimento_id_diaria)
                                                     when ct.crt_id_diaria is not null then
                                                      oper.pkg_contrato_transp.fnc_valor_receita_bruta(p_num_romaneio=>null,p_crt_id_diaria => ct.crt_id_diaria)
                                                   end),
                                                   0) as total_receita_bruta
                                          , nvl((case
                                                     when exists (select 1
                                                             from fiscal.v$intc_crt_embarque_divisao ice
                                                            where ice.lancto_id = ct.lancto_id) then
                                                      (select oper.pkg_contrato_transp.fnc_valor_receita_sem_pedagio(p_num_romaneio=>null,p_divisao_id => ice.divisao_id)
                                                         from fiscal.v$intc_crt_embarque_divisao ice
                                                        where ice.lancto_id = ct.lancto_id
                                                        and rownum = 1)
                                                     when ct.num_romaneio is not null then
                                                      oper.pkg_contrato_transp.fnc_valor_receita_sem_pedagio(ct.num_romaneio)
                                                     when ct.conhecimento_id is not null then
                                                      oper.pkg_contrato_transp.fnc_valor_receita_sem_pedagio(p_num_romaneio=>null,p_conhecimento_id => ct.conhecimento_id_diaria)
                                                     when ct.crt_id_diaria is not null then
                                                      oper.pkg_contrato_transp.fnc_valor_receita_sem_pedagio(p_num_romaneio=>null,p_crt_id_diaria => ct.crt_id_diaria)
                                                   end),
                                                   0) as total_receita_sem_pedagio
                                          , nvl((case
                                                     when exists (select 1
                                                             from fiscal.v$intc_crt_embarque_divisao ice
                                                            where ice.lancto_id = ct.lancto_id) then
                                                      (select oper.pkg_contrato_transp.fnc_valor_contrato_receita(p_num_romaneio=>null,p_divisao_id => ice.divisao_id)
                                                         from fiscal.v$intc_crt_embarque_divisao ice
                                                        where ice.lancto_id = ct.lancto_id
                                                        and rownum = 1)
                                                     when ct.num_romaneio is not null then
                                                      oper.pkg_contrato_transp.fnc_valor_contrato_receita(ct.num_romaneio)
                                                     when ct.conhecimento_id is not null then
                                                      oper.pkg_contrato_transp.fnc_valor_contrato_receita(p_num_romaneio=>null,p_conhecimento_id => ct.conhecimento_id_diaria)
                                                     when ct.crt_id_diaria is not null then
                                                      oper.pkg_contrato_transp.fnc_valor_contrato_receita(p_num_romaneio=>null,p_crt_id_diaria => ct.crt_id_diaria)
                                                   end),
                                                   0) as total_receita_liquida
                                          , (select max(m.percentual_carta_frete) keep(dense_rank last order by data_vigencia)
                                               from gerencial.v$gestor_meta_inadimplencia m
                                              where m.data_vigencia <= '#arguments.data_termino# 23:59:59'
                                                and m.gestor_id = (select g.gestor_id
                                                                     from gerencial.v$gestor g
                                                                    where g.usuario = ct.usuario_liberacao)
                                            ) as meta
                                          , ct.valor_frete_bruto
                                          , p.tipo_pessoa
                                          , (select nvl(sum(cti.valor),0)
                                               from oper.v$contrato_transp_item cti
                                              where cti.lancto_id = ct.lancto_id
                                                and cti.item_id in (23,24,21)) as valor_sest_senat_inss
                                          , (select nvl(sum(cti.valor),0)
                                               from oper.v$contrato_transp_item cti
                                              where cti.lancto_id = ct.lancto_id
                                                and cti.item_id in (1,4)) as valor_pedagio_cf
                                          ,ct.num_rpa
                                       from oper.v$contrato_transp ct
                                      inner join kss.v$pessoa p
                                              on p.cod_pessoa = ct.proprietario_cod_pessoa
                                      where ct.data_cancelamento is null
                                        and ct.senha_liberacao is not null
                                        and ct.percentual_receita is not null
                                        and ct.usuario_liberacao is not null
                                        and ct.data_emissao > '#arguments.data_inicio# 00:00:00'
                                                                                <cfif Len(Trim(arguments.data_termino))>
                                        and ct.data_emissao <= '#arguments.data_termino# 23:59:59'
                                        </cfif>
                                    ) a
            ) b
            group by b.usuario_liberacao, b.gestor, b.meta) c
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Retorna os gestores
    -- ANDERSON 13/09/2010 - CRIADO
    --->
    <cffunction name="get_gestor" access="remote" returntype="query" output="true">
        <cfargument name="gestor_id" required="no" default="">
        <cfargument name="usuario" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select g.gestor_id
                 , g.usuario
                 , (select upper(u.nome)
                      from kss.v$kss_usuarios u
                     where u.usuario = g.usuario
                   ) as nome
              from gerencial.v$gestor g
             where 1 = 1
                        <cfif Len(Trim(arguments.gestor_id))>
               and g.gestor_id = #arguments.gestor_id#
            </cfif>
            <cfif Len(Trim(arguments.usuario))>
               and upper(g.usuario) = upper('#arguments.usuario#')
            </cfif>
             order by nome
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Retorna os valores de inadimplncia dos gestores
    -- ANDERSON 13/09/2010 - CRIADO
    --->
    <cffunction name="get_inadimplencia_faturamento" access="remote" returntype="query" output="true">
        <cfargument name="data_inicio" required="yes">
        <cfargument name="data_termino" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select x.gestor_id
                 , (select upper(u.nome)
                      from gerencial.v$gestor g
                     inner join kss.v$kss_usuarios u
                             on u.usuario = g.usuario
                     where g.gestor_id = x.gestor_id
                   ) as gestor
                 , x.valor_inadimplencia
                 , (select gmi.valor_inadimplencia
                      from gerencial.v$gestor_meta_inadimplencia gmi
                     where gmi.gestor_id = x.gestor_id
                       and gmi.gestor_meta_id = (select max(gmi2.gestor_meta_id) keep(dense_rank last order by gmi2.data_vigencia)
                                                   from gerencial.v$gestor_meta_inadimplencia gmi2
                                                  where gmi2.gestor_id = gmi.gestor_id
                                                    and gmi2.data_vigencia <= to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                                                )
                   ) as meta
              from (
                    select t.gestor_id
                         , nvl(sum(t.valor_faturamento), 0) as valor_inadimplencia
                      from (
                            select logistica.pkg_operacao.fnc_retorna_gestor(c.operacao_id) as gestor_id
                                 , finan.pkg_faturamento.fnc_data_vencimento(c.cod_cliente_cobranca, c.data_emissao) as data_vencimento
                                 ,     (select max(fcr.data_emissao)
                                          from fiscal.v$conhecimento_receber cr
                                         inner join finan.v$finan_contas_receber fcr
                                                 on fcr.contas_receber_id = cr.contas_receber_id
                                         where cr.conhecimento_id = c.conhecimento_id
                                       ) as data_faturamento
                                 , c.valor_faturamento
                              from fiscal.v$conhecimento c
                             where c.cancelado is null
                               and c.faturado is null

                             union all

                            select logistica.pkg_operacao.fnc_retorna_gestor(nff.operacao_id) as gestor_id
                                 , finan.pkg_faturamento.fnc_data_vencimento(nff.cod_cliente_cobranca, nf.data_emissao) as data_vencimento
                                 ,
                                       (select max(fcr.data_emissao)
                                          from fiscal.v$nf_es_receber nfr
                                         inner join finan.v$finan_contas_receber fcr
                                                 on fcr.contas_receber_id = nfr.contas_receber_id
                                         where nfr.num_nota_id = nf.num_nota_id
                                       ) as data_faturamento
                                 , nf.calc_valor_total_nota as valor_faturamento
                              from fiscal.v$nf_es nf
                             inner join fiscal.v$nf_es_frete nff
                                     on nff.nf_es_id = nf.num_nota_id
                             where nf.cancelada = 0

                             union all

                            select logistica.pkg_operacao.fnc_retorna_gestor(c.operacao_id) as gestor_id
                                 , finan.pkg_faturamento.fnc_data_vencimento(c.cod_consignatario, iced.data_divisao) as data_vencimento
                                 ,     (select max(fcr.data_emissao)
                                          from fiscal.v$intc_conhecimento_receber cr
                                         inner join finan.v$finan_contas_receber fcr
                                                 on fcr.contas_receber_id = cr.contas_receber_id
                                         where cr.conhecimento_id = c.conhecimento_id
                                       ) as data_faturamento
                                 , iced.valor * c.cotacao as valor_faturamento
                              from fiscal.v$intc_conhecimento c
                             inner join fiscal.v$intc_crt_embarque ice
                                     on ice.conhecimento_id = c.conhecimento_id
                                    and ice.data_cancelamento is null
                             inner join fiscal.v$intc_crt_embarque_divisao iced
                                     on iced.embarque_id = ice.embarque_id
                                    and iced.data_cancelamento is null
                              where c.cancelado = 0
                           ) t
                     where t.data_faturamento is null
                       and t.data_vencimento <= to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                       and t.gestor_id is not null
                     group by t.gestor_id
                   ) x
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Retorna os valores de inadimplncia de um gestor agrupados por cliente
    -- ANDERSON 13/09/2010 - CRIADO
    --->
    <cffunction name="get_gestor_inadimplencia_faturamento" access="remote" returntype="query" output="true">
        <cfargument name="gestor_id" required="yes">
        <cfargument name="data_inicio" required="yes">
        <cfargument name="data_termino" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select grupo_id, cliente_cobranca, sum(valor_inadimplencia)  as VALOR_INADIMPLENCIA
              from (
            select nvl((select gn.descricao
                      from oper.v$grupo_negociador gn
                      inner join oper.v$grupo_negociador_pessoa gnp
                              on gn.grupo_id = gnp.grupo_id
                      where gnp.cod_pessoa = x.cod_cliente_cobranca),'No possui grupo negociador') as cliente_cobranca,
                   (select gn.grupo_id
                      from oper.v$grupo_negociador gn
                      inner join oper.v$grupo_negociador_pessoa gnp
                              on gn.grupo_id = gnp.grupo_id
                      where gnp.cod_pessoa = x.cod_cliente_cobranca) as grupo_id
                   , x.valor_inadimplencia
                  from (
                    select t.cod_cliente_cobranca
                         , nvl(sum(t.valor_faturamento), 0) as valor_inadimplencia
                      from (
                            select logistica.pkg_operacao.fnc_retorna_gestor(c.operacao_id) as gestor_id
                                 , c.cod_cliente_cobranca
                                 , finan.pkg_faturamento.fnc_data_vencimento(c.cod_cliente_cobranca, c.data_emissao) as data_vencimento
                                 ,     (select max(fcr.data_emissao)
                                          from fiscal.v$conhecimento_receber cr
                                         inner join finan.v$finan_contas_receber fcr
                                                 on fcr.contas_receber_id = cr.contas_receber_id
                                         where cr.conhecimento_id = c.conhecimento_id
                                       )as data_faturamento
                                 , c.valor_faturamento
                              from fiscal.v$conhecimento c
                              where c.cancelado is null
                                and c.faturado is null

                             union all

                            select logistica.pkg_operacao.fnc_retorna_gestor(nff.operacao_id) as gestor_id
                                 , nff.cod_cliente_cobranca
                                 , finan.pkg_faturamento.fnc_data_vencimento(nff.cod_cliente_cobranca, nf.data_emissao) as data_vencimento
                                 ,     (select max(fcr.data_emissao)
                                          from fiscal.v$nf_es_receber nfr
                                         inner join finan.v$finan_contas_receber fcr
                                                 on fcr.contas_receber_id = nfr.contas_receber_id
                                         where nfr.num_nota_id = nf.num_nota_id
                                       ) as data_faturamento
                                 , nf.calc_valor_total_nota as valor_faturamento
                              from fiscal.v$nf_es nf
                             inner join fiscal.v$nf_es_frete nff
                                     on nff.nf_es_id = nf.num_nota_id
                             where nf.cancelada = 0

                             union all

                            select logistica.pkg_operacao.fnc_retorna_gestor(c.operacao_id) as gestor_id
                                 , c.COD_CONSIGNATARIO as cod_cliente_cobranca
                                 , finan.pkg_faturamento.fnc_data_vencimento(c.cod_consignatario, iced.data_divisao) as data_vencimento
                                 ,     (select max(fcr.data_emissao)
                                          from fiscal.v$intc_conhecimento_receber cr
                                         inner join finan.v$finan_contas_receber fcr
                                                 on fcr.contas_receber_id = cr.contas_receber_id
                                         where cr.conhecimento_id = c.conhecimento_id
                                       ) as data_faturamento
                                 , iced.valor * c.cotacao as valor_faturamento
                              from fiscal.v$intc_conhecimento c
                             inner join fiscal.v$intc_crt_embarque ice
                                     on ice.conhecimento_id = c.conhecimento_id
                                    and ice.data_cancelamento is null
                             inner join fiscal.v$intc_crt_embarque_divisao iced
                                     on iced.embarque_id = ice.embarque_id
                                    and iced.data_cancelamento is null
                             where c.cancelado = 0
                           ) t
                     where t.data_faturamento is null
                       and t.data_vencimento < to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                       and t.gestor_id = #arguments.gestor_id#
                     group by t.cod_cliente_cobranca
                   ) x)
                    group by grupo_id, cliente_cobranca
                    order by valor_inadimplencia desc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Retorna os documentos considerados inadimplentes de faturamento de um gestor e de um cliente cobrana
    -- ANDERSON 13/09/2010 - CRIADO
    --->
    <cffunction name="get_documentos_inadimplencia" access="remote" returntype="query" output="true">
        <cfargument name="gestor_id" required="yes">
        <cfargument name="grupo_id" required="yes">
        <cfargument name="data_inicio" required="yes">
        <cfargument name="data_termino" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select kss.pkg_pessoa.fnc_get_cliente(t.cod_cliente_cobranca) as cliente_cobranca
                 , kss.pkg_pessoa.fnc_get_identificador(t.cod_cliente_cobranca) as cob_cnpj_cpf
                 , t.tipo_documento
                 , t.num_documento
                 , to_char(t.data_emissao, 'dd/mm/yyyy') as data_emissao
                 , t.origem_municipio
                 , t.origem_uf
                 , t.destino_municipio
                 , t.destino_uf
                 , t.placa_tracao
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(t.placa_tracao) as cod_veiculo_tracao
                 , t.placa_carreta
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(t.placa_carreta) as cod_veiculo_carreta
                 , (select mrh.cod_registro
                      from oper.v$motorista_reg_historico mrh
                     where mrh.cod_pessoa = t.cod_pessoa_motorista
                       and t.data_emissao between mrh.data_inicio and nvl(mrh.data_fim, sysdate)
                   ) as cod_motorista
                 , kss.pkg_pessoa.fnc_get_cliente(t.cod_pessoa_motorista) as motorista
                 , t.valor_faturamento
              from (
                    select 'CTRC' as tipo_documento
                         , logistica.pkg_operacao.fnc_retorna_gestor(c.operacao_id) as gestor_id
                         , c.cod_cliente_cobranca
                         , finan.pkg_faturamento.fnc_data_vencimento(c.cod_cliente_cobranca, c.data_emissao) as data_vencimento
                         ,     (select max(fcr.data_emissao)
                                  from fiscal.v$conhecimento_receber cr
                                 inner join finan.v$finan_contas_receber fcr
                                         on fcr.contas_receber_id = cr.contas_receber_id
                                 where cr.conhecimento_id = c.conhecimento_id
                               ) as data_faturamento
                         , to_char(c.num_conhecimento) as num_documento
                         , c.data_emissao
                         , (select m.municipio
                              from cep.municipio m
                             where m.municipio_id = c.coleta_municipio_id
                           ) as origem_municipio
                         , (select m.uf_id
                              from cep.municipio m
                             where m.municipio_id = c.coleta_municipio_id
                           ) as origem_uf
                         , (select m.municipio
                              from cep.municipio m
                             where m.municipio_id = c.entrega_municipio_id
                           ) as destino_municipio
                         , (select m.uf_id
                              from cep.municipio m
                             where m.municipio_id = c.entrega_municipio_id
                           ) as destino_uf
                         , c.placa_tracao
                         , c.placa as placa_carreta
                         , c.cod_motorista as cod_pessoa_motorista
                         , c.valor_faturamento
                      from fiscal.v$conhecimento c
                     where c.cancelado is null
                       and c.faturado is null

                     union all

                    select 'NFES' as tipo_documento
                         , logistica.pkg_operacao.fnc_retorna_gestor(nff.operacao_id) as gestor_id
                         , nff.cod_cliente_cobranca
                         , finan.pkg_faturamento.fnc_data_vencimento(nff.cod_cliente_cobranca, nf.data_emissao) as data_vencimento
                         , (select max(fcr.data_emissao)
                                  from fiscal.v$nf_es_receber nfr
                                 inner join finan.v$finan_contas_receber fcr
                                         on fcr.contas_receber_id = nfr.contas_receber_id
                                 where nfr.num_nota_id = nf.num_nota_id
                               ) as data_faturamento
                         , to_char(nf.num_nota_fiscal) as num_documento
                         , nf.data_emissao
                         , nvl(nff.coleta_municipio,
                               (select m.municipio
                                  from cep.municipio m
                                 where m.municipio_id = nff.coleta_municipio_id
                               )
                              ) as origem_municipio
                         , nvl(nff.coleta_sigla_uf,
                               (select m.uf_id
                                  from cep.municipio m
                                 where m.municipio_id = nff.coleta_municipio_id
                               )
                              ) as origem_uf
                         , nvl(nff.entrega_municipio,
                               (select m.municipio
                                  from cep.municipio m
                                 where m.municipio_id = nff.entrega_municipio_id
                               )
                              ) as destino_municipio
                         , nvl(nff.entrega_sigla_uf,
                               (select m.uf_id
                                  from cep.municipio m
                                 where m.municipio_id = nff.entrega_municipio_id
                               )
                              ) as destino_uf
                         , nff.placa_tracao
                         , nff.placa as placa_carreta
                         , nff.cod_motorista as cod_pessoa_motorista
                         , nf.calc_valor_total_nota as valor_faturamento
                      from fiscal.v$nf_es nf
                     inner join fiscal.v$nf_es_frete nff
                             on nff.nf_es_id = nf.num_nota_id
                     where nf.cancelada = 0

                     union all

                    select 'CRT' as tipo_documento
                         , logistica.pkg_operacao.fnc_retorna_gestor(c.operacao_id) as gestor_id
                         , c.cod_consignatario as cod_cliente_cobranca
                         , finan.pkg_faturamento.fnc_data_vencimento(c.cod_consignatario, iced.data_divisao) as data_vencimento
                         ,     (select max(fcr.data_emissao)
                                  from fiscal.v$intc_conhecimento_receber cr
                                 inner join finan.v$finan_contas_receber fcr
                                         on fcr.contas_receber_id = cr.contas_receber_id
                                 where cr.conhecimento_id = c.conhecimento_id
                               ) as data_faturamento
                         , c.num_crt_completo as num_documento
                         , iced.data_divisao as data_emissao
                         , (select m.municipio
                              from cep.municipio m
                             where m.municipio_id = c.resp_municipio_id
                           ) as origem_municipio
                         , (select m.uf_id
                              from cep.municipio m
                             where m.municipio_id = c.resp_municipio_id
                           ) as origem_uf
                         , (select m.municipio
                              from cep.municipio m
                             where m.municipio_id = c.entrega_municipio_id
                           ) as destino_municipio
                         , (select m.uf_id
                              from cep.municipio m
                             where m.municipio_id = c.entrega_municipio_id
                           ) as destino_uf
                         , (select v.placa
                              from fiscal.v$intc_crt_embarque_div_comp icedc
                              left join oper.v$veiculo v
                                     on v.veiculo_id = icedc.veiculo_id
                             where icedc.divisao_id = iced.divisao_id
                               and icedc.ordem = 0
                           ) as placa_tracao
                         , (select v.placa
                              from fiscal.v$intc_crt_embarque_div_comp icedc
                              left join oper.v$veiculo v
                                     on v.veiculo_id = icedc.veiculo_id
                             where icedc.divisao_id = iced.divisao_id
                               and icedc.ordem = 1
                           ) as placa_carreta
                         , iced.cod_pessoa_motorista
                         , iced.valor * c.cotacao as valor_faturamento
                      from fiscal.v$intc_conhecimento c
                     inner join fiscal.v$intc_crt_embarque ice
                             on ice.conhecimento_id = c.conhecimento_id
                            and ice.data_cancelamento is null
                     inner join fiscal.v$intc_crt_embarque_divisao iced
                             on iced.embarque_id = ice.embarque_id
                            and iced.data_cancelamento is null
                     where c.cancelado = 0
                   ) t
             where t.data_faturamento is null
               and t.data_vencimento < to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
               and t.gestor_id = #arguments.gestor_id#
               and t.cod_cliente_cobranca in (select gnp.cod_pessoa
                                               from oper.v$grupo_negociador gn
                                              inner join oper.v$grupo_negociador_pessoa gnp
                                                      on gn.grupo_id = gnp.grupo_id
                                              where gn.grupo_id = #arguments.grupo_id#)
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Retorna os vnculos entre centros de custo
    -- ANDERSON 19/09/2010 - CRIADO
    --->
    <cffunction name="get_ccusto_organizacional" access="remote" returntype="query" output="true">
        <cfargument name="controle_id" required="no" default="">
        <cfargument name="organizacional_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select co.controle_id
                 , co.cod_centro_custo
                 , (select cc.centro_custo
                      from kss.v$centro_custo cc
                     where cc.cod_centro_custo = co.cod_centro_custo
                   ) as centro_custo
                 , co.organizacional_id
                 , to_char(co.data_inicio, 'dd/mm/yyyy') as data_inicio
                 , to_char(co.data_fim, 'dd/mm/yyyy') as data_fim
              from gerencial.v$ccusto_organizacional co
             where 1 = 1
                        <cfif Len(Trim(arguments.controle_id))>
               and co.controle_id = #arguments.controle_id#
                        </cfif>
            <cfif Len(Trim(arguments.organizacional_id))>
               and co.organizacional_id = #arguments.organizacional_id#
                        </cfif>
             order by co.data_inicio
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Retorna os oramentos de um vnculo entre centros de custo
    -- ANDERSON 19/09/2010 - CRIADO
    --->
    <cffunction name="get_ccusto_org_orcamento" access="remote" returntype="query" output="true">
        <cfargument name="controle_id_cc_organizacional" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select coo.controle_id
                 , coo.controle_id_cc_organizacional
                 , coo.mes
                 , coo.ano
                 , coo.valor
              from gerencial.v$ccusto_org_orcamento coo
             where coo.controle_id_cc_organizacional = #arguments.controle_id_cc_organizacional#
             order by coo.ano, coo.mes
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Retorna os vnculos entre fornecedores e centros de custo
    -- ANDERSON 19/09/2010 - CRIADO
    --->
    <cffunction name="get_centro_custo_fornecedor" access="remote" returntype="query" output="true">
        <cfargument name="controle_id" required="no" default="">
        <cfargument name="cod_pessoa_fornecedor" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ccf.controle_id
                 , ccf.cod_centro_custo
                 , (select cc.centro_custo
                      from kss.v$centro_custo cc
                     where cc.cod_centro_custo = ccf.cod_centro_custo
                   ) as centro_custo
                 , ccf.cod_pessoa_fornecedor
                 , (select p.cnpj_cpf
                      from kss.v$pessoa p
                     where p.cod_pessoa = ccf.cod_pessoa_fornecedor
                   ) as cnpj_fornecedor
                 , (select p.razao_social
                      from kss.v$pessoa p
                     where p.cod_pessoa = ccf.cod_pessoa_fornecedor
                   ) as fornecedor
                 , ccf.tipo_cobranca
                 , kss.fnc_ref_code('GERENCIAL', 'TIPO.COBRANCA.FORNECEDOR', ccf.tipo_cobranca, 0) as tipo_cobranca_desc
                 , ccf.custo_por_km
                 , to_char(ccf.data_inicio, 'dd/mm/yyyy') as data_inicio
                 , to_char(ccf.data_fim, 'dd/mm/yyyy') as data_fim
              from gerencial.v$centro_custo_fornecedor ccf
             where 1 = 1
                        <cfif Len(Trim(arguments.controle_id))>
               and ccf.controle_id = #arguments.controle_id#
                        </cfif>
            <cfif Len(Trim(arguments.cod_pessoa_fornecedor))>
               and ccf.cod_pessoa_fornecedor = #arguments.cod_pessoa_fornecedor#
                        </cfif>
             order by ccf.data_inicio
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Retorna os oramentos de um vnculo entre fornecedor e centro de custo
    -- ANDERSON 19/09/2010 - CRIADO
    --->
    <cffunction name="get_ccusto_fornecedor_orcamento" access="remote" returntype="query" output="true">
        <cfargument name="controle_id_fornecedor" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cfo.controle_id
                 , cfo.controle_id_fornecedor
                 , cfo.mes
                 , cfo.ano
                 , cfo.valor
              from gerencial.v$ccusto_fornecedor_orcamento cfo
             where cfo.controle_id_fornecedor = #arguments.controle_id_fornecedor#
             order by cfo.ano, cfo.mes
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
</cfcomponent>