<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO 
    -- Retorna os nmeros de solicitaes por status
    -- GUTO 01/07/2010 - CRIADO
    --->		
    <cffunction name="get_solicitacoes_status" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_termino" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select (select cg.rv_meaning
                      from compras.v$cg_ref_codes cg
                     where cg.rv_domain = 'SOLICITACAO SITUACAO'
                       and cg.rv_low_value = s.situacao_id) as situacao,
                   count(*) as qtde_solicitacoes 
              from compras.v$solicitacao s
              inner join kss.v$organograma o
                       on o.cod_organograma = s.cod_organograma
             where 1=1
			<cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_termino))>
               and s.data_emissao <= to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
               and s.data_emissao >= to_date('#arguments.data_inicio#', 'dd/mm/yyyy') 
            <cfelse>
			   and s.situacao_id not in (10,11,12,6,9)   	
            </cfif>
            <cfif Len(Trim(arguments.cod_centro_custo))>
               and o.cod_centro_custo in (#arguments.cod_centro_custo#)
            </cfif>
            group by s.situacao_id
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
	<!--- 
    -- PROPSITO 
    -- Retorna os nmeros de tempo de aprovao das solicitaes
    -- LEANDRO 01/07/2010 - CRIADO
    --->		
    <cffunction name="get_tempo_aprovacao_solicitacoes" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_termino" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_COMPRAS_TEMP_APROV_SOLC_VERDE') as faixa_verde
                 , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_COMPRAS_TEMP_APROV_SOLC_AMARELO') as faixa_amarela
                 , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_COMPRAS_TEMP_APROV_SOLC_META') as meta                 
                 , x.qtde_dentro_prazo
                 , x.qtde_total  
                 , case 
          			   when x.qtde_total > 0 then round(x.qtde_dentro_prazo / x.qtde_total * 100, 2) 
                       else 0
                   end percentual                                
              from (
                    select count(*) as qtde_total
                         , count(case
                                    when t.tempo_para_liberacao <= 719 then 1
                                    else null
                                 end
                                ) as qtde_dentro_prazo
                      from (
                            select round((sd.data_liberacao_compra-sd.data_emissao)*1440) as tempo_para_liberacao
                              from gerencial.mv$solicitacao_datas sd
                             inner join compras.v$solicitacao s
                                     on s.solicitacao_id = sd.solicitacao_id
                             inner join kss.v$organograma o
                                     on o.cod_organograma = s.cod_organograma
                             where sd.data_liberacao_compra is not null
							<cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_termino))>
                               and sd.data_emissao <= to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                               and sd.data_emissao >= to_date('#arguments.data_inicio#', 'dd/mm/yyyy') 
                            <cfelse>
                               and s.situacao_id in (0,1)  
                            </cfif>
           					<cfif Len(Trim(arguments.cod_centro_custo))>
                                  and o.cod_centro_custo in (#arguments.cod_centro_custo#)
                            </cfif>
                           ) t
                   ) x 
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    	<!--- 
    -- PROPSITO 
    -- Retorna os nmeros de tempo de solicitao em oramento
    -- LEANDRO 01/07/2010 - CRIADO
    --->		
    <cffunction name="get_tempo_solicitacao_orcamento" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_termino" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_COMPRAS_TEMP_SOLIC_ORC_VERDE') as faixa_verde
                 , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_COMPRAS_TEMP_SOLIC_ORC_AMARELO') as faixa_amarela
                 , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_COMPRAS_TEMP_SOLIC_ORC_META') as meta                 
                 , x.qtde_dentro_prazo
                 , x.qtde_total                   
                 , case 
                      when x.qtde_total > 0 then round(x.qtde_dentro_prazo / x.qtde_total * 100, 2)
                       else 0
                   end percentual                                  
              from (
                    select count(*) as qtde_total
                         , count(case
                                    when t.tempo_para_liberada_aprovacao <= 719 then 1
                                    else null
                                 end
                                ) as qtde_dentro_prazo
                      from (
                            select round((sd.data_orcamento-sd.data_liberacao_compra)*1440) as tempo_para_liberada_aprovacao
                              from gerencial.mv$solicitacao_datas sd
                             inner join compras.v$solicitacao s
                                     on s.solicitacao_id = sd.solicitacao_id
                             inner join kss.v$organograma o
                                     on o.cod_organograma = s.cod_organograma
                             where sd.data_orcamento is not null
                               and sd.data_liberacao_compra is not null
							<cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_termino))>
                               and sd.data_emissao <= to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                               and sd.data_emissao >= to_date('#arguments.data_inicio#', 'dd/mm/yyyy') 
                            <cfelse>
                               and s.situacao_id in (2)  
                            </cfif>
           					<cfif Len(Trim(arguments.cod_centro_custo))>
                                  and o.cod_centro_custo in (#arguments.cod_centro_custo#)
                            </cfif>
                           ) t
                   ) x
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
        	<!--- 
    -- PROPSITO 
    -- Retorna os nmeros de tempo de finalizar o pedido
    -- LEANDRO 05/07/2010 - CRIADO
    --->		
    <cffunction name="get_tempo_finalizar_pedido" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_termino" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
         select gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_COMPRAS_TEMP_FINAL_PED_VERDE') as faixa_verde
             , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_COMPRAS_TEMP_FINAL_PED_AMARELO') as faixa_amarela
             , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_COMPRAS_TEMP_FINAL_PED_META') as meta                 
             , x.qtde_dentro_prazo
             , x.qtde_total               
             , case 
                  when x.qtde_total > 0 then round(x.qtde_dentro_prazo / x.qtde_total * 100, 2)
                   else 0
               end percentual                                  
          from (
                select count(*) as qtde_total
                     , count(case
                                when t.tempo_para_pedido <= 719 then 1
                                else null
                             end
                            ) as qtde_dentro_prazo
                  from (
                        select round((sd.data_pedido-sd.data_aprovacao)*1440) as tempo_para_pedido
                          from gerencial.mv$solicitacao_datas sd
                         inner join compras.v$solicitacao s
                                 on s.solicitacao_id = sd.solicitacao_id
                         inner join kss.v$organograma o
                                 on o.cod_organograma = s.cod_organograma
                         where sd.data_pedido is not null
                           and sd.data_aprovacao is not null
						<cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_termino))>
                           and sd.data_emissao <= to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                           and sd.data_emissao >= to_date('#arguments.data_inicio#', 'dd/mm/yyyy') 
                        <cfelse>
                           and s.situacao_id in (5)  
                        </cfif>
                        <cfif Len(Trim(arguments.cod_centro_custo))>
                              and o.cod_centro_custo in (#arguments.cod_centro_custo#)
                        </cfif>
                       ) t
               ) x
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os nmeros de tempo para liberar aprovao de oramento
    -- LEANDRO 05/07/2010 - CRIADO
    --->		
    <cffunction name="get_tempo_liberar_aprov_orcamento" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_termino" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
         select gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_COMPRAS_TEMP_LIB_APR_ORC_VERDE') as faixa_verde
             , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_COMPRAS_TEMP_LIB_APR_ORC_AMARELO') as faixa_amarela
             , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_COMPRAS_TEMP_LIB_APR_ORC_META') as meta                 
             , x.qtde_dentro_prazo
             , x.qtde_total               
             , case 
                  when x.qtde_total > 0 then round(x.qtde_dentro_prazo / x.qtde_total * 100, 2)
                   else 0
               end percentual                                  
          from (
                select count(*) as qtde_total
                     , count(case
                                when t.tempo_para_orcamento <= 719 then 1
                                else null
                             end
                            ) as qtde_dentro_prazo
                  from (
                        select round((sd.data_liberado_aprovacao-sd.data_orcamento)*1440) as tempo_para_orcamento
                          from gerencial.mv$solicitacao_datas sd
                         inner join compras.v$solicitacao s
                                 on s.solicitacao_id = sd.solicitacao_id
                         inner join kss.v$organograma o
                                 on o.cod_organograma = s.cod_organograma
                         where sd.data_liberado_aprovacao is not null
                           and sd.data_orcamento is not null
						<cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_termino))>
                           and sd.data_emissao <= to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                           and sd.data_emissao >= to_date('#arguments.data_inicio#', 'dd/mm/yyyy') 
                        <cfelse>
                           and s.situacao_id in (3,7,8)  
                        </cfif>
                        <cfif Len(Trim(arguments.cod_centro_custo))>
                              and o.cod_centro_custo in (#arguments.cod_centro_custo#)
                        </cfif>
                       ) t
               ) x
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
        <!--- 
    -- PROPSITO 
    -- Retorna os nmeros de tempo para aprovar oramento
    -- LEANDRO 05/07/2010 - CRIADO
    --->		
    <cffunction name="get_tempo_aprov_orcamento" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_termino" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
         select gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_COMPRAS_TEMP_APR_ORC_VERDE') as faixa_verde
             , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_COMPRAS_TEMP_APR_ORC_AMARELO') as faixa_amarela
             , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_COMPRAS_TEMP_APR_ORC_META') as meta                 
             , x.qtde_dentro_prazo
             , x.qtde_total               
             , case 
                  when x.qtde_total > 0 then round(x.qtde_dentro_prazo / x.qtde_total * 100, 2)
                   else 0
               end percentual                                  
          from (
                select count(*) as qtde_total
                     , count(case
                                when t.tempo_para_aprovar <= 719 then 1
                                else null
                             end
                            ) as qtde_dentro_prazo
                  from (
                        select round((sd.data_aprovacao-sd.data_liberado_aprovacao)*1440) as tempo_para_aprovar
                          from gerencial.mv$solicitacao_datas sd
                         inner join compras.v$solicitacao s
                                 on s.solicitacao_id = sd.solicitacao_id
                         inner join kss.v$organograma o
                                 on o.cod_organograma = s.cod_organograma
                         where sd.data_aprovacao is not null
                           and sd.data_liberado_aprovacao is not null
						<cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_termino))>
                           and sd.data_emissao <= to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                           and sd.data_emissao >= to_date('#arguments.data_inicio#', 'dd/mm/yyyy') 
                        <cfelse>
                           and s.situacao_id in (4)  
                        </cfif>
                        <cfif Len(Trim(arguments.cod_centro_custo))>
                              and o.cod_centro_custo in (#arguments.cod_centro_custo#)
                        </cfif>
                       ) t
               ) x
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
            <!--- 
    -- PROPSITO 
    -- Retorna as porcentagem dos tempos de aprovao das solicitaes
    -- LEANDRO 06/07/2010 - CRIADO
    --->		
    <cffunction name="get_perc_aprov_solicitacoes" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_termino" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select fx2.faixa, descricao, nvl(ajustada,0) as ajustada, nvl(quantidade,0) as qtde_solicitacoes
                  from (select cg.rv_abbreviation as faixa, cg.rv_high_value as descricao
                          from compras.v$cg_ref_codes cg
                         where cg.rv_domain = 'FAIXA GRAFICO COMPRAS'
                         order by to_number(cg.rv_low_value)) fx2
                  left join (select faixa, ajustada, count(*) as quantidade
                               from (select case 
                                           when tempo_para_liberacao between fx.fx_atual and fx.fx_proxima then fx.rv_abbreviation
                                           else ''
                                            end faixa,
                                           ajustada 
                                      from (select cg.rv_abbreviation, cg.rv_low_value as fx_atual, nvl(lead(cg.rv_low_value) over(order by to_number(cg.rv_low_value)),9999999999999999) as fx_proxima
                                              from compras.v$cg_ref_codes cg
                                             where cg.rv_domain = 'FAIXA GRAFICO COMPRAS') fx
                                      natural join (select round((sd.data_liberacao_compra-sd.data_emissao)*1440) as tempo_para_liberacao,
                                                           s.ajustada
                                                    from gerencial.mv$solicitacao_datas sd
                                                   inner join compras.v$solicitacao s
                                                           on s.solicitacao_id = sd.solicitacao_id
                                                   inner join kss.v$organograma o
                                                           on o.cod_organograma = s.cod_organograma
                                                  where sd.data_liberacao_compra is not null
                                                    <cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_termino))>
                                                       and sd.data_emissao <= to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                                                       and sd.data_emissao >= to_date('#arguments.data_inicio#', 'dd/mm/yyyy') 
                                                    <cfelse>
                                                       and s.situacao_id in (0,1) 
                                                    </cfif>
                                                    <cfif Len(Trim(arguments.cod_centro_custo))>
                                                       and o.cod_centro_custo in (#arguments.cod_centro_custo#)
                                                    </cfif>                      
                                                  ) t
                                ) 
                                where faixa is not null  
                                group by faixa, ajustada) sl
                 on sl.faixa = fx2.faixa
               </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as porcentagem dos tempos das solicitaes em oramento
    -- LEANDRO 06/07/2010 - CRIADO
    --->		
    <cffunction name="get_perc_solic_orcamento" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_termino" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select fx2.faixa, descricao, nvl(ajustada,0) as ajustada, nvl(quantidade,0) as qtde_solicitacoes
                  from (select cg.rv_abbreviation as faixa, cg.rv_high_value as descricao
                          from compras.v$cg_ref_codes cg
                         where cg.rv_domain = 'FAIXA GRAFICO COMPRAS'
                         order by to_number(cg.rv_low_value)) fx2
                  left join (select faixa, ajustada, count(*) as quantidade
                               from (select case 
                                           when tempo_para_liberacao between fx.fx_atual and fx.fx_proxima then fx.rv_abbreviation
                                           else ''
                                            end faixa,
                                           ajustada 
                                      from (select cg.rv_abbreviation, cg.rv_low_value as fx_atual, nvl(lead(cg.rv_low_value) over(order by to_number(cg.rv_low_value)),9999999999999999) as fx_proxima
                                              from compras.v$cg_ref_codes cg
                                             where cg.rv_domain = 'FAIXA GRAFICO COMPRAS') fx
                                      natural join (select round((sd.data_orcamento-sd.data_liberacao_compra)*1440) as tempo_para_liberacao,
                                                           s.ajustada
                                                    from gerencial.mv$solicitacao_datas sd
                                                   inner join compras.v$solicitacao s
                                                           on s.solicitacao_id = sd.solicitacao_id
                                                   inner join kss.v$organograma o
                                                           on o.cod_organograma = s.cod_organograma
                                      where sd.data_orcamento is not null
                                        and sd.data_liberacao_compra is not null
                                        <cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_termino))>
                                           and sd.data_emissao <= to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                                           and sd.data_emissao >= to_date('#arguments.data_inicio#', 'dd/mm/yyyy') 
                                        <cfelse>
                                           and s.situacao_id in (2)  
                                        </cfif>
                                        <cfif Len(Trim(arguments.cod_centro_custo))>
                                            and o.cod_centro_custo in (#arguments.cod_centro_custo#)
                                        </cfif>                      
                                                  ) t
                                ) 
                                where faixa is not null  
                                group by faixa, ajustada) sl
                 on sl.faixa = fx2.faixa            
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
        <!--- 
    -- PROPSITO 
    -- Retorna as porcentagem dos tempos para finalizar pedido
    -- LEANDRO 06/07/2010 - CRIADO
    --->		
    <cffunction name="get_perc_finalizar_pedido" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="no" default="01/#LSDateFormat(Now(),'mm/yyyy')#">
    	<cfargument name="data_termino" required="no" default="#LSDateFormat(Now())#">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
              select fx2.faixa, descricao, nvl(ajustada,0) as ajustada, nvl(quantidade,0) as qtde_solicitacoes
                              from (select cg.rv_abbreviation as faixa, cg.rv_high_value as descricao
                                      from compras.v$cg_ref_codes cg
                                     where cg.rv_domain = 'FAIXA GRAFICO COMPRAS'
                                     order by to_number(cg.rv_low_value)) fx2
                              left join (select faixa, ajustada, count(*) as quantidade
                                           from (select case 
                                                       when tempo_para_liberacao between fx.fx_atual and fx.fx_proxima then fx.rv_abbreviation
                                                       else ''
                                                        end faixa,
                                                       ajustada 
                                                  from (select cg.rv_abbreviation, cg.rv_low_value as fx_atual, nvl(lead(cg.rv_low_value) over(order by to_number(cg.rv_low_value)),9999999999999999) as fx_proxima
                                                          from compras.v$cg_ref_codes cg
                                                         where cg.rv_domain = 'FAIXA GRAFICO COMPRAS') fx
                                                  natural join (select round((sd.data_pedido-sd.data_aprovacao)*1440) as tempo_para_liberacao,
                                                                       s.ajustada
                                                                from gerencial.mv$solicitacao_datas sd
                                                               inner join compras.v$solicitacao s
                                                                       on s.solicitacao_id = sd.solicitacao_id
                                                               inner join kss.v$organograma o
                                                                       on o.cod_organograma = s.cod_organograma
                                              where sd.data_pedido is not null 
                                                and sd.data_aprovacao is not null
                                                <cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_termino))>
                                                   and sd.data_emissao <= to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                                                   and sd.data_emissao >= to_date('#arguments.data_inicio#', 'dd/mm/yyyy') 
                                                <cfelse>
                                                   and s.situacao_id in (5)  
                                                </cfif>
                                                <cfif Len(Trim(arguments.cod_centro_custo))>
                                                    and o.cod_centro_custo in (#arguments.cod_centro_custo#)
                                                </cfif>                      
                                                              ) t
                                            ) 
                                            where faixa is not null  
                                            group by faixa, ajustada) sl
                             on sl.faixa = fx2.faixa  
               </cfquery>
        <cfreturn qr_result>
    </cffunction> 
    
            <!--- 
    -- PROPSITO 
    -- Retorna as porcentagem dos tempos para liberar aprovao de oramento
    -- LEANDRO 06/07/2010 - CRIADO
    --->		
    <cffunction name="get_perc_lib_aprov_orcamento" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_termino" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select fx2.faixa, descricao, nvl(ajustada,0) as ajustada, nvl(quantidade,0) as qtde_solicitacoes
              from (select cg.rv_abbreviation as faixa, cg.rv_high_value as descricao
                      from compras.v$cg_ref_codes cg
                     where cg.rv_domain = 'FAIXA GRAFICO COMPRAS'
                     order by to_number(cg.rv_low_value)) fx2
              left join (select faixa, ajustada, count(*) as quantidade
                           from (select case 
                                       when tempo_para_liberacao between fx.fx_atual and fx.fx_proxima then fx.rv_abbreviation
                                       else ''
                                        end faixa,
                                       ajustada 
                                  from (select cg.rv_abbreviation, cg.rv_low_value as fx_atual, nvl(lead(cg.rv_low_value) over(order by to_number(cg.rv_low_value)),9999999999999999) as fx_proxima
                                          from compras.v$cg_ref_codes cg
                                         where cg.rv_domain = 'FAIXA GRAFICO COMPRAS') fx
                                  natural join (select round((sd.data_liberado_aprovacao-sd.data_orcamento)*1440) as tempo_para_liberacao,
                                                       s.ajustada
                                                from gerencial.mv$solicitacao_datas sd
                                               inner join compras.v$solicitacao s
                                                       on s.solicitacao_id = sd.solicitacao_id
                                               inner join kss.v$organograma o
                                                       on o.cod_organograma = s.cod_organograma
                                              where sd.data_liberado_aprovacao is not null
                                                and sd.data_orcamento is not null
                                                <cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_termino))>
                                                   and s.data_emissao >= to_date('#arguments.data_inicio#', 'dd/mm/yyyy') 
                                                   and s.data_emissao <= to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                                                <cfelse>
                                                   and s.situacao_id in (3,7,8)  
                                                </cfif>
                                                <cfif Len(Trim(arguments.cod_centro_custo))>
                                                    and o.cod_centro_custo in (#arguments.cod_centro_custo#)
                                                </cfif>                      
                                              ) t
                            ) 
                            where faixa is not null  
                            group by faixa, ajustada) sl
             on sl.faixa = fx2.faixa 
               </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as porcentagem dos tempos para aprovar oramento
    -- LEANDRO 06/07/2010 - CRIADO
    --->		
    <cffunction name="get_perc_aprovar_orcamento" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_termino" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select fx2.faixa, descricao, nvl(ajustada,0) as ajustada, nvl(quantidade,0) as qtde_solicitacoes
              from (select cg.rv_abbreviation as faixa, cg.rv_high_value as descricao
                      from compras.v$cg_ref_codes cg
                     where cg.rv_domain = 'FAIXA GRAFICO COMPRAS'
                     order by to_number(cg.rv_low_value)) fx2
              left join (select faixa, ajustada, count(*) as quantidade
                           from (select case 
                                       when tempo_para_liberacao between fx.fx_atual and fx.fx_proxima then fx.rv_abbreviation
                                       else ''
                                        end faixa,
                                       ajustada 
                                  from (select cg.rv_abbreviation, cg.rv_low_value as fx_atual, nvl(lead(cg.rv_low_value) over(order by to_number(cg.rv_low_value)),9999999999999999) as fx_proxima
                                          from compras.v$cg_ref_codes cg
                                         where cg.rv_domain = 'FAIXA GRAFICO COMPRAS') fx
                                  natural join (select round((sd.data_aprovacao-sd.data_liberado_aprovacao)*1440) as tempo_para_liberacao,
                                                       s.ajustada
                                                from gerencial.mv$solicitacao_datas sd
                                               inner join compras.v$solicitacao s
                                                       on s.solicitacao_id = sd.solicitacao_id
                                               inner join kss.v$organograma o
                                                       on o.cod_organograma = s.cod_organograma
                                              where sd.data_aprovacao is not null
                                                and sd.data_liberado_aprovacao is not null
                                                <cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_termino))>
                                                   and sd.data_emissao <= to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                                                   and sd.data_emissao >= to_date('#arguments.data_inicio#', 'dd/mm/yyyy') 
                                                <cfelse>
                                                   and s.situacao_id in (4)   
                                                </cfif>
                                                <cfif Len(Trim(arguments.cod_centro_custo))>
                                                    and o.cod_centro_custo in (#arguments.cod_centro_custo#)
                                                </cfif>                      
                                              ) t
                            ) 
                            where faixa is not null  
                            group by faixa, ajustada) sl
             on sl.faixa = fx2.faixa
               </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
        <!--- 
    -- PROPSITO 
    -- Retorna as porcentagem das solicitaes de regularizao por centro de custo
    -- LEANDRO 07/07/2010 - CRIADO
    --->		
    <cffunction name="get_perc_solic_reg_centro_custo" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_termino" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select cc.centro_custo, cc.cod_centro_custo, y.tipo_cotacao_id
                     , nvl((select tc.descricao
                          from compras.v$orcamento_tipo_cotacao tc
                         where tc.tipo_cotacao_id = y.tipo_cotacao_id),'Regularizao') as tipo
                     , round((y.qtde_solicitacoes / sum(y.qtde_solicitacoes) over() * 100),2) as perc_solicitacoes                
                     , y.qtde_solicitacoes
                  from (                                        
                         select case 
                                  when t.tipo_cotacao_id = 1 and possui_fornecedor = 1 then 0
                                  when t.tipo_cotacao_id = 1 and possui_fornecedor = 0 then 1 
                                else t.tipo_cotacao_id end tipo_cotacao_id, possui_fornecedor,
                                count(*) as qtde_solicitacoes,
                                t.cod_organograma
                           from (
                                select (select a.tipo_cotacao_id
                                          from (select s.num_controle, o.tipo_cotacao_id
                                                  from compras.v$orcamento o
                                                 inner join compras.v$orcamento_atividade oa
                                                         on o.orcamento_id = oa.orcamento_id
                                                 inner join compras.v$orcamento_atividade_solic oas
                                                         on oas.orcamento_atividade_id = oa.orcamento_atividade_id
                                                 inner join compras.v$solicitacao_atividade sa
                                                         on sa.controle_id = oas.solicitacao_atividade_id
                                                 inner join compras.v$solicitacao s
                                                         on s.solicitacao_id = sa.solicitacao_id
                                                 union
                                                select s.num_controle, o.tipo_cotacao_id
                                                  from compras.v$orcamento o
                                                 inner join compras.v$orcamento_material om
                                                         on o.orcamento_id = om.orcamento_id
                                                 inner join compras.v$orcamento_material_solic oms
                                                         on oms.orcamento_material_id = om.orcamento_material_id
                                                 inner join compras.v$solicitacao_material sm
                                                         on sm.controle_id = oms.solicitacao_material_id
                                                 inner join compras.v$solicitacao s
                                                         on s.solicitacao_id = sm.solicitacao_id
                                               ) a
                                               where a.num_controle = sd.num_controle) as tipo_cotacao_id, 
                                               case 
                                                 when s.cod_pessoa_fornecedor is null then 0 else 1 end possui_fornecedor,
                                               s.cod_organograma
                                  from gerencial.mv$solicitacao_datas sd
                                 inner join compras.v$solicitacao s
                                         on s.solicitacao_id = sd.solicitacao_id
                                 inner join kss.v$organograma o
                                         on o.cod_organograma = s.cod_organograma
                                 where 1=1
                                   <cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_termino))>
                                       and sd.data_emissao <= to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                                       and sd.data_emissao >= to_date('#arguments.data_inicio#', 'dd/mm/yyyy') 
                                   <cfelse>
                                       and s.situacao_id not in (10,11,12,6,9) 
                                   </cfif>
                              ) t
                              group by t.cod_organograma, t.tipo_cotacao_id, t.possui_fornecedor                                              
                       ) y   
                  inner join kss.v$organograma o
                          on y.cod_organograma = o.cod_organograma
                  inner join kss.v$centro_custo cc
                          on cc.cod_centro_custo = o.cod_centro_custo
                where y.tipo_cotacao_id = 0
               <cfif Len(Trim(arguments.cod_centro_custo))>
                    and o.cod_centro_custo in (#arguments.cod_centro_custo#)
               </cfif>                      
               </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
            <!--- 
    -- PROPSITO 
    -- Retorna as porcentagem das solicitaes por tipo de validao
    -- LEANDRO 07/07/2010 - CRIADO
    --->		
    <cffunction name="get_perc_solic_tipo_validacao" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_termino" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		    select y.tipo_cotacao_id
                 , nvl((select tc.descricao
                      from compras.v$orcamento_tipo_cotacao tc
                     where tc.tipo_cotacao_id = y.tipo_cotacao_id),'Regularizao') as tipo
                 , round((y.qtde_solicitacoes / sum(y.qtde_solicitacoes) over() * 100),2) as perc_solicitacoes                
                 , y.qtde_solicitacoes
              from (                                        
                     select case 
                              when t.tipo_cotacao_id = 1 and possui_fornecedor = 1 then 0
                              when t.tipo_cotacao_id = 1 and possui_fornecedor = 0 then 1 
                            else t.tipo_cotacao_id end tipo_cotacao_id, possui_fornecedor,
                            count(*) as qtde_solicitacoes    
                       from (
                            select (select a.tipo_cotacao_id
                                      from (select s.num_controle, o.tipo_cotacao_id
                                              from compras.v$orcamento o
                                             inner join compras.v$orcamento_atividade oa
                                                     on o.orcamento_id = oa.orcamento_id
                                             inner join compras.v$orcamento_atividade_solic oas
                                                     on oas.orcamento_atividade_id = oa.orcamento_atividade_id
                                             inner join compras.v$solicitacao_atividade sa
                                                     on sa.controle_id = oas.solicitacao_atividade_id
                                             inner join compras.v$solicitacao s
                                                     on s.solicitacao_id = sa.solicitacao_id
                                             union
                                            select s.num_controle, o.tipo_cotacao_id
                                              from compras.v$orcamento o
                                             inner join compras.v$orcamento_material om
                                                     on o.orcamento_id = om.orcamento_id
                                             inner join compras.v$orcamento_material_solic oms
                                                     on oms.orcamento_material_id = om.orcamento_material_id
                                             inner join compras.v$solicitacao_material sm
                                                     on sm.controle_id = oms.solicitacao_material_id
                                             inner join compras.v$solicitacao s
                                                     on s.solicitacao_id = sm.solicitacao_id
                                           ) a
                                           where a.num_controle = sd.num_controle) as tipo_cotacao_id, 
                                           case 
                                             when s.cod_pessoa_fornecedor is null then 0 else 1 end possui_fornecedor
                              from gerencial.mv$solicitacao_datas sd
                             inner join compras.v$solicitacao s
                                     on s.solicitacao_id = sd.solicitacao_id
                             inner join kss.v$organograma o
                                     on o.cod_organograma = s.cod_organograma
                             where 1=1
							   <cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_termino))>
                                   and sd.data_emissao <= to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                                   and sd.data_emissao >= to_date('#arguments.data_inicio#', 'dd/mm/yyyy') 
                               <cfelse>
                                   and s.situacao_id not in (10,11,12,6,9) 
                               </cfif>
                               <cfif Len(Trim(arguments.cod_centro_custo))>
                          			and o.cod_centro_custo in (#arguments.cod_centro_custo#)
							   </cfif>           
                          ) t
                          where t.tipo_cotacao_id is not null
                          group by t.tipo_cotacao_id, t.possui_fornecedor                                              
                   ) y                    
               </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as solicitaes de compras de forma detalhada de um grfico e de uma faixa
    -- LEANDRO 07/07/2010 - CRIADO
    --->		
    <cffunction name="get_solicitacoes_tempos" access="remote" returntype="query" output="true">
    	<cfargument name="grafico" required="yes">
        <cfargument name="faixa" required="yes">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_termino" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.num_controle
                 , t.unidade_negocio
                 , t.centro_custo
                 , to_char(t.data_emissao, 'dd/mm/yyyy hh24:mi:ss') as data_emissao
                 , to_char(t.data_liberacao_compra, 'dd/mm/yyyy hh24:mi:ss') as data_liberacao_compra
                 , to_char(t.data_orcamento, 'dd/mm/yyyy hh24:mi:ss') as data_orcamento
                 , to_char(t.data_liberado_aprovacao, 'dd/mm/yyyy hh24:mi:ss') as data_liberacao_aprovacao
                 , to_char(t.data_aprovacao, 'dd/mm/yyyy hh24:mi:ss') as data_aprovacao
                 , to_char(t.data_pedido, 'dd/mm/yyyy hh24:mi:ss') as data_pedido
                 , t.status
                 , t.num_reinicios
                 , t.area
                 , t.responsavel
                 , t.valor_materiais
                 , t.valor_atividades
                 , t.valor_materiais + t.valor_atividades as valor_total
                 , t.fornecedor
              from (
                    select sd.num_controle
                    	 , (select cg.rv_high_value
                              from compras.v$cg_ref_codes cg
                             where cg.rv_domain = 'SOLICITACAO SITUACAO'
                               and cg.rv_low_value = s.situacao_id) as status
                         , (select un.unidade_negocio
                              from kss.v$unidade_negocio un
                             where un.cod_unidade_negocio = o.cod_unidade_negocio) as unidade_negocio
                         , (select cc.centro_custo
                              from kss.v$centro_custo cc
                             where cc.cod_centro_custo = o.cod_centro_custo) as centro_custo                 
                         , sd.data_emissao
                         , sd.data_liberacao_compra
                         , sd.data_orcamento
                         , sd.data_liberado_aprovacao
                         , sd.data_pedido
                         , sd.data_aprovacao
                         , sd.num_reinicios
                         , (select a.descricao
                              from compras.v$area a
                             where a.area_id = s.area_id) as area
                         , kss.pkg_pessoa.fnc_get_cliente(s.cod_pessoa_emissao) as responsavel
                         , (select nvl(sum(sm.quantidade * sm.valor_sugerido), 0)
                              from compras.v$solicitacao_material sm
                             where sm.solicitacao_id = sd.solicitacao_id) as valor_materiais
                         , (select nvl(sum(sa.quantidade * sa.valor_sugerido), 0)
                              from compras.v$solicitacao_atividade sa
                             where sa.solicitacao_id = sd.solicitacao_id) as valor_atividades
                         , (select spf.fornecedor
                              from compras.v$solic_pedido_fornecedor spf
                             where spf.solicitacao_id = sd.solicitacao_id) as fornecedor
						<cfif arguments.grafico eq 1>
                         , round((sd.data_liberacao_compra-sd.data_emissao)*1440) as tempo
                        <cfelseif arguments.grafico eq 2>
                         , round((sd.data_orcamento-sd.data_liberacao_compra)*1440) as tempo
                        <cfelseif arguments.grafico eq 3>
                         , round((sd.data_liberado_aprovacao-sd.data_orcamento)*1440) as tempo
                        <cfelseif arguments.grafico eq 4>
                         , round((sd.data_aprovacao-sd.data_liberado_aprovacao)*1440) as tempo                         
                        <cfelseif arguments.grafico eq 5>
                         , round((sd.data_pedido-sd.data_aprovacao)*1440) as tempo
                        </cfif>
                      from gerencial.mv$solicitacao_datas sd
                     inner join compras.v$solicitacao s
                             on s.solicitacao_id = sd.solicitacao_id
                     inner join kss.v$organograma o
                             on o.cod_organograma = s.cod_organograma
                     where 1=1
                       <cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_termino))>  
                          and s.data_emissao between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
					   <cfelseif arguments.grafico eq 1>
                          and s.situacao_id in (0,1)
                       <cfelseif arguments.grafico eq 2>
                          and s.situacao_id in (2)
                       <cfelseif arguments.grafico eq 3>
                          and s.situacao_id in (3,7,8)
                       <cfelseif arguments.grafico eq 4>
                          and s.situacao_id in (4)
                       <cfelseif arguments.grafico eq 5>
                          and s.situacao_id in (5)
                       </cfif>
                       <cfif Len(Trim(arguments.cod_centro_custo))>
                   			and o.cod_centro_custo in (#arguments.cod_centro_custo#)
					   </cfif>
                   ) t
			<cfif arguments.faixa eq 'dentro_prazo'>
             where t.tempo <= 719
            <cfelseif arguments.faixa eq 'fora_prazo1'>
             where t.tempo > 719 and t.tempo <= 1439
            <cfelseif arguments.faixa eq 'fora_prazo2'>
             where t.tempo > 1439 and t.tempo <= 2879       
            <cfelseif arguments.faixa eq 'fora_prazo3'>
             where t.tempo > 2879 and t.tempo <= 4319       
            <cfelse>
             where t.tempo > 4319
            </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
     <cffunction name="get_solicitacoes_centro_custo" access="remote" returntype="query" output="true">      
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_termino" required="no" default="">
        <cfargument name="cod_centro_custo" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.num_controle
                 , t.unidade_negocio
                 , t.centro_custo
                 , to_char(t.data_emissao, 'dd/mm/yyyy hh24:mi:ss') as data_emissao
                 , to_char(t.data_liberacao_compra, 'dd/mm/yyyy hh24:mi:ss') as data_liberacao_compra
                 , t.area
                 , t.responsavel
                 , t.valor_materiais
                 , t.valor_atividades
                 , t.valor_materiais + t.valor_atividades as valor_total
                 , t.fornecedor
              from (
                    select sd.num_controle
                         , (select un.unidade_negocio
                              from kss.v$unidade_negocio un
                             where un.cod_unidade_negocio = o.cod_unidade_negocio) as unidade_negocio
                         , (select cc.centro_custo
                              from kss.v$centro_custo cc
                             where cc.cod_centro_custo = o.cod_centro_custo) as centro_custo                 
                         , sd.data_emissao
                         , sd.data_liberacao_compra
                         , (select a.descricao
                              from compras.v$area a
                             where a.area_id = s.area_id) as area
                         , kss.pkg_pessoa.fnc_get_cliente(s.cod_pessoa_emissao) as responsavel
                         , (select nvl(sum(sm.quantidade * sm.valor_sugerido), 0)
                              from compras.v$solicitacao_material sm
                             where sm.solicitacao_id = sd.solicitacao_id) as valor_materiais
                         , (select nvl(sum(sa.quantidade * sa.valor_sugerido), 0)
                              from compras.v$solicitacao_atividade sa
                             where sa.solicitacao_id = sd.solicitacao_id) as valor_atividades
                         , (select spf.fornecedor
                              from compras.v$solic_pedido_fornecedor spf
                             where spf.solicitacao_id = sd.solicitacao_id) as fornecedor
                     from gerencial.mv$solicitacao_datas sd
                    inner join compras.v$solicitacao s
                            on s.solicitacao_id = sd.solicitacao_id
                    inner join kss.v$organograma o
                            on o.cod_organograma = s.cod_organograma
                    inner join kss.v$centro_custo cc
                            on cc.cod_centro_custo = o.cod_centro_custo
                    where s.situacao_id not in (11,12)
					   <cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_termino))>
                           and sd.data_emissao <= to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                           and sd.data_emissao >= to_date('#arguments.data_inicio#', 'dd/mm/yyyy') 
                       <cfelse>
                           and s.situacao_id not in (6,9,10,11,12)  
                       </cfif>
                      and o.cod_centro_custo = #arguments.cod_centro_custo#
                   ) t            
               </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <cffunction name="get_solicitacoes_tipo_cotacao" access="remote" returntype="query" output="true">      
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_termino" required="no" default="">
        <cfargument name="tipo_cotacao_id" required="yes">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select t.num_controle
                 , t.unidade_negocio
                 , t.centro_custo
                 , to_char(t.data_emissao, 'dd/mm/yyyy hh24:mi:ss') as data_emissao
                 , to_char(t.data_liberacao_compra, 'dd/mm/yyyy hh24:mi:ss') as data_liberacao_compra
                 , t.area
                 , t.responsavel
                 , t.valor_materiais
                 , t.valor_atividades
                 , t.valor_materiais + t.valor_atividades as valor_total
                 , t.fornecedor
                 , (select tc.descricao
                      from compras.v$orcamento_tipo_cotacao tc
                     where tc.tipo_cotacao_id = t.tipo_cotacao_id) as tipo
              from (
                    select sd.num_controle, s.cod_pessoa_fornecedor
                         , (select un.unidade_negocio
                              from kss.v$unidade_negocio un
                             where un.cod_unidade_negocio = o.cod_unidade_negocio) as unidade_negocio
                         , (select cc.centro_custo
                              from kss.v$centro_custo cc
                             where cc.cod_centro_custo = o.cod_centro_custo) as centro_custo                 
                         , sd.data_emissao
                         , sd.data_liberacao_compra
                         , (select a.descricao
                              from compras.v$area a
                             where a.area_id = s.area_id) as area
                         , kss.pkg_pessoa.fnc_get_cliente(s.cod_pessoa_emissao) as responsavel
                         , (select nvl(sum(sm.quantidade * sm.valor_sugerido), 0)
                              from compras.v$solicitacao_material sm
                             where sm.solicitacao_id = sd.solicitacao_id) as valor_materiais
                         , (select nvl(sum(sa.quantidade * sa.valor_sugerido), 0)
                              from compras.v$solicitacao_atividade sa
                             where sa.solicitacao_id = sd.solicitacao_id) as valor_atividades
                         , (select spf.fornecedor
                              from compras.v$solic_pedido_fornecedor spf
                             where spf.solicitacao_id = sd.solicitacao_id) as fornecedor
                         , (select distinct a.tipo_cotacao_id
                              from (select s.num_controle, o.tipo_cotacao_id
                                      from compras.v$orcamento o
                                     inner join compras.v$orcamento_atividade oa
                                             on o.orcamento_id = oa.orcamento_id
                                     inner join compras.v$orcamento_atividade_solic oas
                                             on oas.orcamento_atividade_id = oa.orcamento_atividade_id
                                     inner join compras.v$solicitacao_atividade sa
                                             on sa.controle_id = oas.solicitacao_atividade_id
                                     inner join compras.v$solicitacao s
                                             on s.solicitacao_id = sa.solicitacao_id
                                     union all
                                    select s.num_controle, o.tipo_cotacao_id
                                      from compras.v$orcamento o
                                     inner join compras.v$orcamento_material om
                                             on o.orcamento_id = om.orcamento_id
                                     inner join compras.v$orcamento_material_solic oms
                                             on oms.orcamento_material_id = om.orcamento_material_id
                                     inner join compras.v$solicitacao_material sm
                                             on sm.controle_id = oms.solicitacao_material_id
                                     inner join compras.v$solicitacao s
                                             on s.solicitacao_id = sm.solicitacao_id
                                   ) a
                                   where a.num_controle = sd.num_controle) as tipo_cotacao_id
                     from gerencial.mv$solicitacao_datas sd
                    inner join compras.v$solicitacao s
                            on s.solicitacao_id = sd.solicitacao_id
                    inner join kss.v$organograma o
                            on o.cod_organograma = s.cod_organograma
                    inner join kss.v$centro_custo cc
                            on cc.cod_centro_custo = o.cod_centro_custo
                    where sd.data_pedido is not null
					   <cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_termino))>
                           and sd.data_emissao <= to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                           and sd.data_emissao >= to_date('#arguments.data_inicio#', 'dd/mm/yyyy') 
                       <cfelse>
                           and s.situacao_id not in (11,12)  
                       </cfif>
                       <cfif Len(Trim(arguments.cod_centro_custo))>
                   			and o.cod_centro_custo in (#arguments.cod_centro_custo#)
					   </cfif>
               ) t
           where 1=1
             <cfif arguments.tipo_cotacao_id eq 0>
                 and t.tipo_cotacao_id = 1 and t.cod_pessoa_fornecedor is not null
             <cfelseif arguments.tipo_cotacao_id eq 1>
                 and t.tipo_cotacao_id = 1 and t.cod_pessoa_fornecedor is null
             <cfelse>
                 and t.tipo_cotacao_id = #arguments.tipo_cotacao_id#
             </cfif>
         </cfquery>
        <cfreturn qr_result>
    </cffunction>         
    
</cfcomponent>