<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO
    -- Busca formas de faturamento
    -- 26/05/2009
    --->	
    <cffunction name="get_faturamento_forma" displayname="" output="true" returntype="query" access="public">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select f.forma_id, f.forma_descricao, f.observacao
              from kss.v$faturamento_forma f    
        </cfquery>
        <cfreturn qr_result>
    </cffunction>        
    
	<!--- 
    -- PROPSITO
    -- Busca faturamento periodo
    -- 26/05/2009
    --->	
    <cffunction name="get_faturamento_periodo" displayname="" output="true" returntype="query" access="public">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select p.agrupamento_id, p.agrupamento, p.num_dia
              from kss.v$faturamento_periodo p    
        </cfquery>
        <cfreturn qr_result>
    </cffunction>        

	<!--- 
    -- PROPSITO
    -- Busca faturamento periodo
    -- 26/05/2009
    --->	
    <cffunction name="get_faturamento_condicao" displayname="" output="true" returntype="query" access="public">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
             select c.condicao_id, c.condicao, c.num_dias_vencto, c.dias_uteis
               from kss.v$faturamento_condicao c    
        </cfquery>
        <cfreturn qr_result>
    </cffunction>        

	<!--- 
    -- PROPSITO
    -- Busca faturamento mes vencimento
    -- 26/05/2009
    --->	
    <cffunction name="get_faturamento_mes_vencimento" displayname="" output="true" returntype="query" access="public">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select to_number(rv_low_value) as id, rv_abbreviation as descricao
              from kss.cg_ref_codes
             where rv_domain = 'PESSOA_FATURAMENTO_REGRA.MES_VENCIMENTO' 
             order by to_number(rv_low_value)
        </cfquery>
        <cfreturn qr_result>
    </cffunction>        

	<!--- 
    -- PROPSITO
    -- Busca faturamento codigo_protesto
    -- 26/05/2009
    --->	
    <cffunction name="get_faturamento_protesto" displayname="" output="true" returntype="query" access="public">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select f.c026_id, f.descricao
              from finan.v$febraban_c026 f
              where f.c026_id <> 9
          </cfquery>
        <cfreturn qr_result>
    </cffunction>     

	<!--- 
    -- PROPSITO
    -- Busca conta corrente bancaria
    -- 26/05/2009
    --->	
    <cffunction name="get_faturamento_ccorrente" displayname="" output="true" returntype="query" access="public">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select /*+ ordered first_rows */ to_number(c.cod_conta) codigo, c.descricao_conta descricao, 
                   c.conta_corrente conta, p.cliente pessoa, p.identificador cnpj,
                   b.banco_descricao banco, b.banco_id id
              from finan.v$ccorrente_banco c
              inner join kss.v$pessoa p
                      on p.cod_pessoa = c.cod_pessoa
              inner join kss.banco b
                      on b.banco_id = c.banco_id
             order by lower(p.cliente) 
        </cfquery>
        <cfreturn qr_result>
    </cffunction>        
    
	<!--- 
    -- PROPSITO
    -- Busca pagadores NACIONAL
    -- 26/05/2009
    --->	
    <cffunction name="get_pagadores" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="COD_PESSOA_FILIAL" required="no" default=""/>
    	<cfargument name="FATURA_CONFERIDO" required="yes"/>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select distinct 
                   c.cod_cliente_cobranca as codigo
                 , kss.pkg_pessoa.fnc_get_identificador(c.cod_cliente_cobranca) as cnpj_cpf
                 , kss.pkg_pessoa.fnc_get_cliente(c.cod_cliente_cobranca) as razao_social
                 , decode(pf.fat_forma_id,2,1,0) as fatura_com_bloqueto
              from fiscal.v$conhecimento c
              left join kss.v$pessoa_faturamento pf 
                      on pf.cod_pessoa = c.cod_cliente_cobranca
             where 1=1
               <cfif Len(Trim(arguments.COD_PESSOA_FILIAL))>
	               and c.cod_pessoa_filial in (#arguments.COD_PESSOA_FILIAL#)
               </cfif>
               and c.cancelado is null -- no cancelado
               and c.impresso is not null -- no impresso
               and c.num_conhecimento > 0
               and c.total_conhecimento > 0
               and c.cod_cliente_cobranca is not null
               and ((#arguments.FATURA_CONFERIDO# = 1 and c.conferido is not null) or (#arguments.FATURA_CONFERIDO# = 0))
               and not exists (select 'x'
                                 from fiscal.v$conhecimento_receber cr
                                where c.conhecimento_id = cr.conhecimento_id
                                  and rownum = 1)
             order by razao_social, cnpj_cpf
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Busca pagadores CRT
    -- 26/05/2009
    --->	
    <cffunction name="get_pagadores_crt" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="COD_PESSOA_FILIAL" required="no" default=""/>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select /*+ PUSH_SUBQ */
            distinct p.cnpj_cpf ,
                     p.razao_social || '(' || p.cnpj_cpf || ')' as razao_social,
                     p.cod_pessoa as codigo, decode(pf.fat_forma_id,2,1,0) as fatura_com_bloqueto
              from fiscal.v$intc_doctos_fatura t
             inner join kss.v$pessoa p 
                     on p.cod_pessoa = t.cod_pessoa_pagador
             inner join fiscal.v$intc_conhecimento c 
                     on t.conhecimento_id = c.conhecimento_id
              left join kss.v$pessoa_faturamento pf 
                      on pf.cod_pessoa = t.cod_pessoa_pagador
             where 1=1
               <cfif Len(Trim(arguments.COD_PESSOA_FILIAL))>
	               and c.cod_pessoa_filial in (#arguments.COD_PESSOA_FILIAL#)
               </cfif>
               and not exists (select 'x'
                                 from fiscal.v$intc_conhecimento_receber cr
                                inner join fiscal.v$intc_conhecimento c2 
                                        on c2.conhecimento_id = cr.conhecimento_id
                                inner join finan.v$finan_contas_receber fcr on fcr.contas_receber_id = cr.contas_receber_id
                                where cr.conhecimento_id = c.conhecimento_id
                                  and fcr.COD_PESSOA = t.cod_pessoa_pagador)
               and c.quitado = 0
               and c.pre_conhecimento = 0
             order by razao_social
        </cfquery>
        <cfreturn qr_result>
    </cffunction>    

<!--- 
    -- PROPSITO
    -- Busca pagadores NACIONAL NFES
    -- 26/05/2009
    --->	
    <cffunction name="get_pagadores_nf_es" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="COD_PESSOA_FILIAL" required="no" default=""/>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select /*+ push_subq */
                   distinct 
                     nvl(nef.cob_cnpj_cpf, n.dest_cnpj_cpf) as cnpj_cpf ,
                     nvl(nef.cob_razao_social, n.dest_razao_social) as razao_social,
                     nvl(nef.cod_cliente_cobranca, n.cod_destinatario) as codigo, 
                     decode(pf.fat_forma_id,2,1,0) as fatura_com_bloqueto
              from fiscal.v$nf_es_faturamento n
              left join fiscal.v$nf_es_frete nef
                     on nef.nf_es_id = n.num_nota_id
              left join kss.v$pessoa_faturamento pf 
                      on pf.cod_pessoa = nvl(nef.cod_cliente_cobranca, n.cod_destinatario)
             where cancelada = 0
               <cfif Len(Trim(arguments.COD_PESSOA_FILIAL))>
	               and n.cod_pessoa_filial = #arguments.COD_PESSOA_FILIAL#
               </cfif>             
               and not exists (
                                 select /*+ push_subq */ 'x'
                                   from fiscal.v$nf_es_receber tp
                                  where tp.num_nota_id = n.num_nota_id
                              )
             order by razao_social
        </cfquery>
        <cfreturn qr_result>
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Busca CTRC para faturar
    -- 26/05/2009
    --->	
    <cffunction name="get_ctrc_faturamento" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="COD_PESSOA_FILIAL" required="no" default=""/>
    	<cfargument name="FATURA_CONFERIDO" required="no" default=""/>
    	<cfargument name="COD_PESSOA_PAGADOR" required="no" default=""/>
    	<cfargument name="NUM_CONHECIMENTO" required="no" default=""/>
    	<cfargument name="NUM_DOCTO" required="no" default=""/> 
    	<cfargument name="FATURADOS" required="no" default="0"/>
    	<cfargument name="DATA_INICIO" required="no" default=""/>
    	<cfargument name="DATA_FIM" required="no" default=""/>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select distinct /*+LEADING(C) INDEX(RI PKC_RIT)*/
                  c.conhecimento_id
                 , c.num_conhecimento, c.cob_razao_social as pagador , c.serie
                 , to_char(c.data_emissao,'dd/mm/yyyy') as data_emissao
                 , c.valor_icms
                 , c.total_conhecimento
                 , case
                      when c.num_romaneio is null then 1
                      when to_number(kss.pkg_global.fnc_obtem_parametro_str(25, 'FISCAL.EXE', 8, 2)) = 0 then 1
                      --else oper.pkg_fluxo_docto.fnc_verifica_doctos_fatura_2(c.num_romaneio, c.item_id, null)
                   end situacao_fluxo,
                   c.pedagio, c.rowid,
                   0 as selecionado
                 , c.valor_faturamento
                 , c.cod_organograma_gerencial, (select o.cod_unidade_negocio||' - '||o.cod_centro_custo
                                                   from kss.v$organograma o
                                                  where o.cod_organograma = c.cod_organograma_gerencial) as centro_custo_gerencial
                 , c.valor_icms_substit,
                     fcr.num_docto, to_char(fcr.data_vencto,'dd/mm/yyyy') as data_vencto
              from fiscal.v$conhecimento c
             <cfif Len(Trim(arguments.NUM_DOCTO))>
             	inner join fiscal.v$conhecimento_receber cr
                        on cr.conhecimento_id = c.conhecimento_id
                inner join finan.v$finan_contas_receber fcr
                       on fcr.contas_receber_id = cr.contas_receber_id
                      and fcr.num_docto = '#arguments.NUM_DOCTO#'
             <cfelse>
             	left join fiscal.v$conhecimento_receber cr
                        on cr.conhecimento_id = c.conhecimento_id
                left join finan.v$finan_contas_receber fcr
                       on fcr.contas_receber_id = cr.contas_receber_id
             </cfif>
             left join finan.v$faturamento_excecao_cliente fec
                            on fec.cod_pessoa = c.cod_cliente_cobranca
             where 1=1
               <cfif Len(Trim(arguments.COD_PESSOA_FILIAL))>
	               and ( c.cod_pessoa_filial in (#arguments.COD_PESSOA_FILIAL#) or fec.cod_pessoa_filial in (#arguments.COD_PESSOA_FILIAL#) )
               </cfif>
               <cfif Len(Trim(arguments.COD_PESSOA_PAGADOR))>
	               and c.cod_cliente_cobranca = #arguments.COD_PESSOA_PAGADOR#
               </cfif>
               and c.cancelado is null
               and c.num_conhecimento > 0
               and c.valor_faturamento > 0
               <cfif Len(Trim(arguments.FATURA_CONFERIDO))>
                 and ((#arguments.FATURA_CONFERIDO# = 1 and c.conferido is not null)
                  or (#arguments.FATURA_CONFERIDO# = 0))
               </cfif>
               <cfif Len(Trim(arguments.NUM_CONHECIMENTO))>
			     and c.num_conhecimento = #arguments.NUM_CONHECIMENTO#
               </cfif>
               <cfif arguments.FATURADOS eq 0>
                   and not exists (select /*+INDEX(CR PKC_CNCR) */ 'x'
                                     from fiscal.v$conhecimento_receber cr
                                    where c.conhecimento_id = cr.conhecimento_id)
               <cfelse>
                   and exists (select /*+INDEX(CR PKC_CNCR) */ 'x'
                                     from fiscal.v$conhecimento_receber cr
                                    where c.conhecimento_id = cr.conhecimento_id)
               </cfif>
               <cfif Len(Trim(arguments.DATA_INICIO))>
                 and trunc(fcr.data_emissao) >= '#arguments.DATA_INICIO#'
               </cfif>
               
               <cfif Len(Trim(arguments.DATA_FIM))>
                 and trunc(fcr.data_emissao) <= '#arguments.DATA_FIM#'
               </cfif>
            order by num_conhecimento    
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Busca CRT para faturar
    -- 26/05/2009
    --->	
    <cffunction name="get_crt_faturamento" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="COD_PESSOA_FILIAL" required="no" default=""/>
    	<cfargument name="NUM_CONHECIMENTO" required="no" default=""/>
    	<cfargument name="COD_PESSOA_PAGADOR" required="no" default=""/>
    	<cfargument name="NUM_DOCTO" required="no" default=""/>
    	<cfargument name="FATURADOS" required="no" default="0"/>
    	<cfargument name="DATA_INICIO" required="no" default=""/>
    	<cfargument name="DATA_FIM" required="no" default=""/>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select /*+ PUSH_SUBQ */
            distinct p.cnpj_cpf,
                     p.razao_social || '(' || p.cnpj_cpf || ')' as razao_social,
                     p.cod_pessoa,
                     c.numero_cod_pais || '.' || c.numero_certificado || '.' || replace(replace(to_char(c.numero_sequencial, '000,000'), ',', '.'),' ','') as num_crt,
                     (select mb.descricao_moeda
                        from finan.v$moeda_bacen mb
                       where mb.cod_moeda = t.cod_moeda) moeda,
                     c.cotacao,
                     t.cod_moeda,
                     t.valor_total,
                     round(t.valor_total * c.cotacao, 2) valor_total_convertido,
                     t.origem,
                     t.destino,
                     to_char(t.emissao_data,'dd/mm/yyyy') as emissao_data,
                     c.conhecimento_id,
                     c.pago_por,
                     c.numero_cod_pais,
                     c.cod_pessoa_filial,
                     fcr.num_docto, to_char(fcr.data_vencto,'dd/mm/yyyy') as data_vencto
              from fiscal.v$intc_doctos_fatura t
             inner join kss.v$pessoa p 
                     on p.cod_pessoa = t.cod_pessoa_pagador
             inner join fiscal.v$intc_conhecimento c 
                     on t.conhecimento_id = c.conhecimento_id
             <cfif Len(Trim(arguments.NUM_DOCTO))>
             	inner join fiscal.v$intc_conhecimento_receber cr
                        on cr.conhecimento_id = c.conhecimento_id
                inner join finan.v$finan_contas_receber fcr
                       on fcr.contas_receber_id = cr.contas_receber_id
                      and fcr.num_docto = #arguments.NUM_DOCTO#
			 <cfelse>
             	left join fiscal.v$intc_conhecimento_receber cr
                        on cr.conhecimento_id = c.conhecimento_id
                left join finan.v$finan_contas_receber fcr
                       on fcr.contas_receber_id = cr.contas_receber_id
             </cfif>
             where 1=1
               <cfif Len(Trim(arguments.COD_PESSOA_FILIAL))>
	               and c.cod_pessoa_filial = #arguments.COD_PESSOA_FILIAL#
               </cfif>
               <cfif Len(Trim(arguments.NUM_CONHECIMENTO))>
                  and c.numero_cod_pais || '.' || c.numero_certificado || '.' || replace(replace(to_char(c.numero_sequencial, '000000'), ',', '.'),' ','')  = '#arguments.NUM_CONHECIMENTO#'
               </cfif>
               <cfif Len(Trim(arguments.COD_PESSOA_PAGADOR))>
                  and p.cod_pessoa = #arguments.COD_PESSOA_PAGADOR#
               </cfif>
               <cfif arguments.FATURADOS eq 0>
                   and not exists (select 'x'
                                     from fiscal.v$intc_conhecimento_receber cr
                                    inner join fiscal.v$intc_conhecimento c2 
                                            on c2.conhecimento_id = cr.conhecimento_id
                                    inner join finan.v$finan_contas_receber fcr on fcr.contas_receber_id = cr.contas_receber_id
                                    where cr.conhecimento_id = c.conhecimento_id
                                      and fcr.COD_PESSOA = t.cod_pessoa_pagador)
                   and c.quitado = 0
               <cfelse>
                   and exists (select 'x'
                                     from fiscal.v$intc_conhecimento_receber cr
                                    inner join fiscal.v$intc_conhecimento c2 
                                            on c2.conhecimento_id = cr.conhecimento_id
                                    inner join finan.v$finan_contas_receber fcr on fcr.contas_receber_id = cr.contas_receber_id
                                    where cr.conhecimento_id = c.conhecimento_id
                                      and fcr.COD_PESSOA = t.cod_pessoa_pagador)
               </cfif>
               <cfif Len(Trim(arguments.DATA_INICIO))>
                 and trunc(fcr.data_emissao) >= '#arguments.DATA_INICIO#'
               </cfif>
               <cfif Len(Trim(arguments.DATA_FIM))>
                 and trunc(fcr.data_emissao) <= '#arguments.DATA_FIM#'
               </cfif>
               and c.pre_conhecimento = 0
             order by razao_social 
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Busca CRT para faturar
    -- 26/05/2009
    --->	
    <cffunction name="get_nfes_faturamento" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="COD_PESSOA_FILIAL" required="no" default=""/>
    	<cfargument name="COD_PESSOA_PAGADOR" required="no" default=""/>
    	<cfargument name="NUM_NOTA_ID" required="no" default=""/>
    	<cfargument name="NUM_NOTA_FISCAL" required="no" default=""/>
    	<cfargument name="SEM_FATURA" required="no" default="1"/>
    	<cfargument name="NUM_DOCTO" required="no" default=""/>
    	<cfargument name="DATA_INICIO" required="no" default=""/>
    	<cfargument name="DATA_FIM" required="no" default=""/>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			 select /*+ push_subq */
                   n.num_nota_id, n.num_nota_fiscal, n.serie, n.e_s,
                   n.cod_pessoa_filial, n.cod_departamento,
                   n.cod_setor, n.cod_centro_custo,
                   (
                      select cod_unidade_negocio
                        from kss.v$unidade_negocio
                       where cod_pessoa = cod_pessoa_filial
                   ) as cod_unidade_negocio,
                   to_char(n.data_emissao,'dd/mm/yyyy') as data_emissao, n.data_es, n.natureza_descricao, 
                   n.calc_valor_total_nota as calc_valor_bruto,
                   fiscal.pkg_nf_es.fnc_valor_retencao_impostos(n.num_nota_id) as serv_iss_valor,
                   n.calc_valor_total_nota - fiscal.pkg_nf_es.fnc_valor_retencao_impostos(n.num_nota_id) as calc_valor_total_nota,
                   n.trp_peso_liquido,
                   nvl(nef.cob_razao_social,n.dest_razao_social) as pagador,
                     fcr.num_docto, to_char(fcr.data_vencto,'dd/mm/yyyy') as data_vencto
              from fiscal.v$nf_es_faturamento n
             <cfif Len(Trim(arguments.NUM_DOCTO))>
             	inner join fiscal.v$nf_es_receber cr
                        on cr.num_nota_id = n.num_nota_id
                inner join finan.v$finan_contas_receber fcr
                       on fcr.contas_receber_id = cr.contas_receber_id
                      and fcr.num_docto = '#arguments.NUM_DOCTO#'
             <cfelse>
             	left join fiscal.v$nf_es_receber cr
                        on cr.num_nota_id = n.num_nota_id
                left join finan.v$finan_contas_receber fcr
                       on fcr.contas_receber_id = cr.contas_receber_id
             </cfif>
              left join fiscal.v$nf_es_frete nef
                     on nef.nf_es_id = n.num_nota_id
             where cancelada = 0
               <cfif Len(Trim(arguments.COD_PESSOA_FILIAL))>
	               and n.cod_pessoa_filial = #arguments.COD_PESSOA_FILIAL#
               </cfif>
               <cfif Len(Trim(arguments.COD_PESSOA_PAGADOR))>
	               and (nvl(nef.cod_cliente_cobranca, n.cod_destinatario) = #arguments.COD_PESSOA_PAGADOR#)
               </cfif>	
               <cfif Len(Trim(arguments.NUM_NOTA_ID))>
	               and n.num_nota_id = #arguments.NUM_NOTA_ID#
               </cfif>
               <cfif Len(Trim(arguments.NUM_NOTA_FISCAL))>
               	  and n.num_nota_fiscal = #arguments.NUM_NOTA_FISCAL#
               </cfif>
               <cfif arguments.SEM_FATURA eq 1>
                   and not exists (
                                     select /*+ push_subq */ 'x'
                                       from fiscal.v$nf_es_receber tp
                                      where tp.num_nota_id = n.num_nota_id
                                  )
               <cfelse>
                   and exists (
                                     select /*+ push_subq */ 'x'
                                       from fiscal.v$nf_es_receber tp
                                      where tp.num_nota_id = n.num_nota_id
                                  )
               </cfif>
               <cfif Len(Trim(arguments.DATA_INICIO))>
                 and trunc(fcr.data_emissao) >= '#arguments.DATA_INICIO#'
               </cfif>
               <cfif Len(Trim(arguments.DATA_FIM))>
                 and trunc(fcr.data_emissao) <= '#arguments.DATA_FIM#'
               </cfif>
               
             order by n.num_nota_fiscal, n.serie 
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    

	<!--- 
    -- PROPSITO
    -- Busca contas receber do conhecimento
    -- 26/05/2009
    --->	
    <cffunction name="get_contas_receber" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="conhecimento_id" required="yes"/>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select distinct cr.contas_receber_id 
              from fiscal.v$conhecimento_receber cr
            where 1=1
		  <cfif Len(Trim(arguments.conhecimento_id))>
            and conhecimento_id in (#arguments.conhecimento_id#)
          </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>    
    
	<!--- 
    -- PROPSITO
    -- Busca contas receber do conhecimento
    -- 26/05/2009
    --->	
    <cffunction name="get_contas_receber_crt" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="conhecimento_id" required="yes"/>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select distinct cr.contas_receber_id 
              from fiscal.v$intc_conhecimento_receber cr
            where 1=1
		  <cfif Len(Trim(arguments.conhecimento_id))>
            and conhecimento_id in (#arguments.conhecimento_id#)
          </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>     

	<!--- 
    -- PROPSITO
    -- Busca contas receber da nota
    -- 26/05/2009
    --->	
    <cffunction name="get_contas_receber_nfes" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="num_nota_id" required="yes"/>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select distinct cr.contas_receber_id 
              from fiscal.v$nf_es_receber cr
            where 1=1
		  <cfif Len(Trim(arguments.num_nota_id))>
            and num_nota_id in (#arguments.num_nota_id#)
          </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>        

	<!--- 
    -- PROPSITO
    -- Busca dados da duplicata
    -- 26/05/2009
    --->	
    <cffunction name="get_duplicata" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="contas_receber_id" required="yes"/>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
             select contas_receber_id, num_docto, dup_ordem, parc_docto, 
                    to_char(data_emissao,'dd/mm/yyyy') as data_emissao, 
                    to_char(data_vencto,'dd/mm/yyyy') as data_vencto, valor_docto, cod_moeda, 
                    linha_1, linha_2, cnpj_filial, razao_social, 
                    inscricao_estadual, cep_filial, municipio, uf, 
                    linha_2_filial, linha_3_filial, linha_4_filial, linha_5_filial, 
                    linha_6_filial, cliente, municipio_cliente, 
                    uf_cliente, cep_cliente, ie_cliente, cnpjcpf_cliente, 
                    end_cliente, cliente_mun_cep_uf, bairro_cliente, praca_pagto, 
                    cod_pessoa, cnpj_cpf_filial, filial, emitente_filial, 
                    emitente_centro_custo, cod_pessoa_filial, comentario, 
                    bloqueto_id, agencia_logradouro, agencia_codigo_cedente 
               from finan.v$duplicata  
              where 1=1
              <cfif Len(Trim(arguments.contas_receber_id))>
              	and contas_receber_id = #arguments.contas_receber_id#
              </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Busca itens da duplita
    -- 26/05/2009
    --->	
    <cffunction name="get_duplicata_item" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="contas_receber_id" required="yes"/>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
              select contas_receber_id, num_docto, to_char(data_emissao,'dd/mm/yyyy') as data_emissao, nf_carga, 
                     peso, base_icms, impostos, val_icms, val_icms_presumido, total, 
                     cod_moeda, regra_fiscal_id, frete_valor, 
                     natureza_carga, tipo, 
                     adiantamento, percurso
                from finan.v$itens_duplicata  
              where 1=1
              <cfif Len(Trim(arguments.contas_receber_id))>
              	and contas_receber_id = #arguments.contas_receber_id#
              </cfif>
              order by num_docto
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Busca dados bloqueto
    -- 26/05/2009
    --->	
    <cffunction name="get_bloqueto" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="bloqueto_id" required="no" default=""/>
    	<cfargument name="contas_receber_id" required="no" default=""/>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select contas_receber_id, bloqueto_id, banco_id, cod_conta, febraban_layout_arquivo, cod_convenio, 
                   g065_id, cod_pessoa_sacado, it05_numero, banco, banco_abrev, agencia_logradouro, 
                   codigo_barras_convertido, local_pagamento, data_vencimento, c009_id, cedente, 
                   agencia_codigo_cedente, data_documento, num_documento, especie_documento, aceite, 
                   data_processamento, nosso_numero, uso_banco, carteira, especie, quantidade, valor, 
                   valor_documento, mensagem_1, mensagem_2, mensagem_3, mensagem_4, mensagem_5, 
                   desconto_padrao, desconto_abatimento, outras_deducoes, mora_multa, outros_acrescimos, 
                   sacado_nome, sacado_cnpj, sacado_endereco, sacado_cep_mun_uf, codigo_barras
              from (select d.contas_receber_id, b.bloqueto_id, b.banco_id, b.cod_conta, b.febraban_layout_arquivo, b.cod_convenio, b.g065_id, 
                           b.cod_pessoa_sacado, b.it05_numero, b.banco, b.banco_abrev, b.agencia_logradouro, 
                           b.codigo_barras_convertido, b.local_pagamento, 
                           to_char(b.data_vencimento,'dd/mm/yyyy') as data_vencimento, b.c009_id, 
                           b.cedente, b.agencia_codigo_cedente, to_char(b.data_documento,'dd/mm/yyyy') as data_documento, b.num_documento, b.especie_documento, 
                           b.aceite, to_char(b.data_processamento,'dd/mm/yyyy') as data_processamento, nvl(b.nosso_numero,'&nbsp;') as nosso_numero, b.uso_banco, b.carteira, 
                           b.especie, b.quantidade, b.valor, b.valor_documento, b.mensagem_1, b.mensagem_2, 
                           b.mensagem_3, b.mensagem_4, b.mensagem_5, b.desconto_padrao, b.desconto_abatimento, 
                           b.outras_deducoes, b.mora_multa, b.outros_acrescimos, b.sacado_nome, 
                           b.sacado_cnpj, b.sacado_endereco, b.sacado_cep_mun_uf, 
                           b.codigo_barras 
                      from finan.v$bloqueto_impresso b
                     inner join finan.v$duplicata d
                             on d.bloqueto_id = b.bloqueto_id
                    union all
                    select d.contas_receber_id, null bloqueto_id, null banco_id, null cod_conta, null febraban_layout_arquivo, null cod_convenio, null g065_id, 
                           null cod_pessoa_sacado, null it05_numero, d.razao_social banco, null banco_abrev, null agencia_logradouro, 
                           null codigo_barras_convertido, null local_pagamento, to_char(d.data_vencto,'dd/mm/yyyy') as data_vencimento,null c009_id, 
                           d.razao_social cedente, '' agencia_codigo_cedente, to_char(d.data_emissao,'dd/mm/yyyy') as data_documento, d.num_docto as num_documento, null especie_documento, 
                           null aceite, to_char(d.data_emissao,'dd/mm/yyyy') data_processamento, null nosso_numero, null uso_banco, null carteira, 
                           nvl((select m.moeda
                                  from kss.v$pessoa_faturamento t 
                                 inner join finan.v$moeda_bacen m
                                         on t.cod_moeda = m.cod_moeda
                                 where t.cod_pessoa = d.cod_pessoa),decode(p.tipo_pessoa,2,'US$','R$')) as especie, null quantidade, '' valor, case nvl((select t.cod_moeda
                                                                                                                                                           from kss.v$pessoa_faturamento t
                                                                                                                                                          where t.cod_pessoa = d.cod_pessoa),decode(p.tipo_pessoa,2,220,790))
                                                                                                                                                        when 220 then d.valor_docto
                                                                                                                                                        else d.valor_docto_convertido
                                                                                                                                               end valor_documento, null mensagem_1, null mensagem_2, 
                                                                                                                                                                   null mensagem_3, null mensagem_4, null mensagem_5, null desconto_padrao, null desconto_abatimento, 
                           null outras_deducoes, null mora_multa, null outros_acrescimos, d.cliente sacado_nome, 
                           d.cnpjcpf_cliente sacado_cnpj, d.end_cliente sacado_endereco, d.cep_cliente || '-' || d.municipio_cliente || '-' || d.uf_cliente sacado_cep_mun_uf, null codigo_barras
                      from finan.v$duplicata d
                     inner join kss.v$pessoa p 
                             on p.cod_pessoa = d.cod_pessoa
                     where d.bloqueto_id is null
                    )
            where 1=1
              <cfif Len(Trim(arguments.contas_receber_id))>
              	and contas_receber_id = #arguments.contas_receber_id#
              </cfif>
              <cfif Len(Trim(arguments.bloqueto_id))>
              	and bloqueto_id = #arguments.bloqueto_id#
              </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Busca faturas
    -- 26/05/2009
    --->	
    <cffunction name="get_logo_banco" displayname="" output="true" returntype="binary" access="public">
    	<cfargument name="bloqueto_id" required="no" default=""/>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
              select banco_logo
                from finan.v$bloqueto_impresso b
              where 1=1
              <cfif Len(Trim(arguments.bloqueto_id))>
                and b.bloqueto_id = #arguments.bloqueto_id#
              </cfif>
        </cfquery>
        <cfreturn qr_result.banco_logo>
    </cffunction>        

	<!--- 
    -- PROPSITO
    -- Busca faturas
    -- 26/05/2009
    --->	
    <cffunction name="get_fatura_ctrc" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="conhecimento_id" required="no" default=""/>
    	<cfargument name="contas_receber_id" required="no" default=""/>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
              select fcr.contas_receber_id, fcr.num_docto,
                     to_char(fcr.data_emissao,'dd/mm/yyyy') as data_emissao, 
                     to_char(fcr.data_vencto, 'dd/mm/yyyy') as data_vencto, 
                     fcr.valor_docto,
                     c.cob_razao_social,c.conhecimento_id, c.num_conhecimento, c.serie, c.num_romaneio, c.data_emissao,
			         c.rem_razao_social, c.valor_icms, c.total_conhecimento, 
                     case 
                       when sysdate-fcr.data_emissao < 1 then 1
                     else 0 end permite_cancelar, 
                     (select kss.fnc_concat_all(kss.to_concat_expr(c2.conhecimento_id,','))
                        from fiscal.v$conhecimento_receber c2
                       where c2.contas_receber_id = cr.contas_receber_id) as lista_conhecimento
                from fiscal.v$conhecimento c
                inner join fiscal.v$conhecimento_receber cr
                        on c.conhecimento_id = cr.conhecimento_id
                inner join finan.v$finan_contas_receber fcr
                        on fcr.contas_receber_id = cr.contas_receber_id
              where 1=1
              <cfif Len(Trim(arguments.conhecimento_id))>
                and c.conhecimento_id in (#arguments.conhecimento_id#)
              </cfif>
              <cfif Len(Trim(arguments.contas_receber_id))>
                and fcr.contas_receber_id = #arguments.contas_receber_id#
              </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Busca faturas
    -- 26/05/2009
    --->	
    <cffunction name="get_fatura_crt" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="conhecimento_id" required="no" default=""/>
    	<cfargument name="contas_receber_id" required="no" default=""/>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
              select fcr.contas_receber_id, fcr.num_docto,
                     to_char(fcr.data_emissao,'dd/mm/yyyy') as data_emissao, 
                     to_char(fcr.data_vencto, 'dd/mm/yyyy') as data_vencto, 
                     fcr.valor_docto,
                     c.pag_origem_nome as cob_razao_social, c.conhecimento_id, 
                     replace(c.numero_cod_pais || '.' || c.numero_certificado || '.' || replace(to_char(c.numero_sequencial, '000,000'),',','.'), ' ', '') as numero, 
                     to_char(c.emissao_data,'dd/mm/yyyy') as emissao_data,
			         c.pag_origem_nome, 
                     case 
                       when sysdate-fcr.data_emissao < 1 then 1
                     else 0 end permite_cancelar, 
                     (select kss.fnc_concat_all(kss.to_concat_expr(c2.conhecimento_id,','))
                        from fiscal.v$intc_conhecimento_receber c2
                       where c2.contas_receber_id = cr.contas_receber_id) as lista_conhecimento
                from fiscal.v$intc_conhecimento c
                inner join fiscal.v$intc_conhecimento_receber cr
                        on c.conhecimento_id = cr.conhecimento_id
                inner join finan.v$finan_contas_receber fcr
                        on fcr.contas_receber_id = cr.contas_receber_id
              where 1=1
              <cfif Len(Trim(arguments.conhecimento_id))>
                and c.conhecimento_id in (#arguments.conhecimento_id#)
              </cfif>
              <cfif Len(Trim(arguments.contas_receber_id))>
                and fcr.contas_receber_id = #arguments.contas_receber_id#
              </cfif> 
        </cfquery>
        <cfreturn qr_result>
    </cffunction>        


	<!--- 
    -- PROPSITO
    -- Busca faturas
    -- 26/05/2009
    --->	
    <cffunction name="get_fatura_nfes" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="num_nota_id" required="no" default=""/>
    	<cfargument name="contas_receber_id" required="no" default=""/>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
              select fcr.contas_receber_id, fcr.num_docto,
                     to_char(fcr.data_emissao,'dd/mm/yyyy') as data_emissao, 
                     to_char(fcr.data_vencto, 'dd/mm/yyyy') as data_vencto, 
                     fcr.valor_docto,
                     nvl(nfe.cob_razao_social,nf.dest_razao_social) as cliente,
                     nf.num_nota_id, 
                     nf.num_nota_fiscal, 
                     nf.serie, 
                     nfe.num_romaneio, 
                     nf.data_emissao,
                     nf.calc_valor_total_nota as calc_valor_bruto,
                     fiscal.pkg_nf_es.fnc_valor_retencao_impostos(nf.num_nota_id) as serv_iss_valor,
                     nf.calc_valor_total_nota - fiscal.pkg_nf_es.fnc_valor_retencao_impostos(nf.num_nota_id) as total,
                     case 
                       when sysdate-fcr.data_emissao < 1 then 1
                     else 0 end permite_cancelar, 
                     (select kss.fnc_concat_all(kss.to_concat_expr(c2.num_nota_id,','))
                        from fiscal.v$nf_es_receber c2
                       where c2.contas_receber_id = cr.contas_receber_id) as lista_notas
                from fiscal.v$nf_es nf
                inner join fiscal.v$nf_es_receber cr
                        on nf.num_nota_id = cr.num_nota_id
                inner join finan.v$finan_contas_receber fcr
                        on fcr.contas_receber_id = cr.contas_receber_id
                left join fiscal.v$nf_es_frete nfe
                       on nfe.nf_es_id = nf.num_nota_id
              where 1=1
              <cfif Len(Trim(arguments.num_nota_id))>
                and nf.num_nota_id in (#arguments.num_nota_id#)
              </cfif>
              <cfif Len(Trim(arguments.contas_receber_id))>
                and fcr.contas_receber_id = #arguments.contas_receber_id#
              </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca vencimento para o faturamento de CTRC
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 08/01/2010
	--->		
	<cffunction name="get_vencimento_faturamento_ctrc" access="remote" returntype="query" output="true">
		<cfargument name="conhecimento_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select to_char(finan.pkg_faturamento_ctrc.fnc_data_base_fatura('#arguments.conhecimento_id#'), 'dd/mm/yyyy') as data_base
              from dual
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca vencimento para o faturamento de NFES
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 08/01/2010
	--->		
	<cffunction name="get_vencimento_faturamento_nfes" access="remote" returntype="query" output="true">
		<cfargument name="num_nota_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select to_char(finan.pkg_faturamento_nf_es.fnc_data_base_fatura('#arguments.num_nota_id#'), 'dd/mm/yyyy') as data_base
              from dual
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca vencimento para o faturamento de CRT
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 08/01/2010
	--->		
	<cffunction name="get_vencimento_faturamento_crt" access="remote" returntype="query" output="true">
		<cfargument name="conhecimento_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select to_char(finan.pkg_faturamento_crt.fnc_data_base_fatura('#arguments.conhecimento_id#'), 'dd/mm/yyyy') as data_base
              from dual
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca vencimento para o faturamento
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 11/01/2010
	--->		
	<cffunction name="get_vencimento_faturamento" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="yes">
        <cfargument name="data_base" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select to_char(finan.pkg_faturamento.fnc_data_vencimento(#arguments.cod_pessoa# , '#arguments.data_base#'), 'dd/mm/yyyy') as data_vencimento
              from dual
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>
</cfcomponent>