<cfcomponent extends="_transportes.funcoes.cfc_init">

	<!--- 
    -- PROPSITO
    -- Busca as contas a pagar
    -- 23/12/2008 - criado
    --->	
    <cffunction name="get_contas_pagar_pagamento" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="cc_favorecido" required="no" default="">
        <cfargument name="data_inicial" required="no" default="">
        <cfargument name="data_final" required="no" default="">
        <cfargument name="num_documento" required="no" default="">
        <cfargument name="cod_pessoa_favorecido" required="no" default="">
        <cfargument name="docto_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select /*+ ordered use_hash(cp cf) use_hash(cp cs) */ 
                   cp.contas_pagar_id, cp.num_docto, cp.parc_docto, 
                   cp.tipo_pagto_id, cp.cod_historico, cp.docto_id, 
                   to_char(cp.data_emissao,'dd/mm/yyyy hh24:mi:ss') as data_emissao, 
                   to_char(cp.data_vencto,'dd/mm/yyyy hh24:mi:ss') as data_vencto, trunc(cp.data_previsao) as data_previsao, 
            
                   cp.cod_pessoa_empresa, cp.cod_pessoa, 
                   cp.cod_departamento, cp.cod_setor, cp.cod_centro_custo, 
                   cp.valor_docto, cp.cod_moeda, cp.valor_docto_moeda, cp.variacao_cambial, 
                   cp.cc_sacado, cp.cc_favorecido, cp.banco_id, cp.agencia_id, cp.conta, 
                   cp.codigo_barras, 
                   decode(cp.codigo_barras,null,null,finan.pkg_bloqueto.fnc_cod_barras_2_rep_numerica(cp.codigo_barras)) as repres_numerica,
            
                   cp.comentario, cp.integrado, cp.exige_liberacao_pagamento, 
                   cp.conferido_financeiro, cp.conferido_contabilidade, cp.situacao, cp.lancamento_previsao, 
                   -- Campos relacionados 
                   un.cod_unidade_negocio, un.unidade_negocio, 
                   depto.descricao departamento, st.descricao setor, cc.centro_custo, 
                   td.descricao as docto_descricao, tp.tipo_pagto_descricao, 
                   (select ch.historico from finan.v$finan_caixa_historico ch where ch.cod_historico = cp.cod_historico) as historico,
            		
                   kss.pkg_pessoa.fnc_get_identificador(p_cod_pessoa => cp.cod_pessoa_empresa) as cnpj_cpf_favorecido,
                   cf.descricao_conta as conta_favorecido, 
                   cf.cod_pessoa as cod_pessoa_favorecido, 
                   cs.descricao_conta as conta_sacado, 
                   a.agencia_id_dv 
                 , (select pc.conta_dv 
                      from kss.v$pessoa_conta_bancaria pc 
                     where pc.cod_pessoa = cp.cod_pessoa 
                       and pc.banco_id = cp.banco_id 
                       and pc.agencia_id = cp.agencia_id 
                       and pc.conta = lpad(cp.conta,12,'0')) as conta_dv 
                 , b.banco_abrev||' - Ag. '||a.agencia_id||' - ' ||a.municipio||' - '||a.uf||' - C/C: '||ltrim(cp.conta,'0') as cc_bancaria_favorecido,
            
                   nvl(decode(cp.situacao,0,'Em aberto','Quitado'),'') as situacao_flag, 
                   -- valores do lanamento 
                   finan.pkg_contas_pagar.FNC_PAGAR_TOTAL_AMORT(cp.contas_pagar_id,sysdate,1)        as total_amortizado, 
                   finan.pkg_contas_pagar.FNC_PAGAR_TOTAL_JURO(cp.contas_pagar_id,sysdate,1)         as total_juro, 
                   finan.pkg_contas_pagar.FNC_PAGAR_TOTAL_DESC(cp.contas_pagar_id,sysdate,0,1)       as total_desconto, 
                   finan.pkg_contas_pagar.FNC_PAGAR_TOTAL_DESC(cp.contas_pagar_id,sysdate,1,1)       as total_devolvido, 
                   finan.pkg_contas_pagar.FNC_PAGAR_TOTAL_AMORT_MOEDA(cp.contas_pagar_id,sysdate,1)  as total_amortizado_moeda, 
                   finan.pkg_contas_pagar.FNC_PAGAR_TOTAL_DESC_MOEDA(cp.contas_pagar_id,sysdate,0,1) as total_desconto_moeda, 
                   finan.pkg_contas_pagar.FNC_PAGAR_TOTAL_DESC_MOEDA(cp.contas_pagar_id,sysdate,1,1) as total_devolvido_moeda, 
                   finan.pkg_contas_pagar.FNC_PAGAR_TOTAL_ABERTO(cp.contas_pagar_id,1)               as valor_aberto 
                 , (select agrupamento_id from finan.v$contabilizacao_cpagar ccp where ccp.contas_pagar_id = cp.contas_pagar_id) as agrupamento_id
            
                 , cp.cod_pessoa_pagamento, kss.pkg_pessoa.fnc_get_cliente(cp.cod_pessoa_pagamento) as pessoa_pagamento 
                 , (select p.cnpj_cpf from kss.v$pessoa p where p.cod_pessoa = cp.cod_pessoa_pagamento) as cnpj_cpf_pessoa_pagto 
                 , case 
                      when finan.pkg_contas_pagar.fnc_pagar_total_amort(cp.contas_pagar_id,'01/01/2100',0) = 0 then 
                         finan.pkg_contas_pagar.fnc_pagar_total_aberto(cp.contas_pagar_id,1) 
                      else finan.pkg_contas_pagar.fnc_pagar_total_amort(cp.contas_pagar_id,'01/01/2100',0) 
                   end as valor_parcial 
                 , (select t.contas_pagar_lote_id 
                      from finan.v$finan_contas_pagar_lote_it t 
                     inner join finan.v$finan_contas_pagar_lote l 
                             on l.contas_pagar_lote_id = t.contas_pagar_lote_id 
                     where t.contas_pagar_id = cp.contas_pagar_id 
                       and l.status = 0) as num_lote 
              from 
                   finan.v$finan_contas_pagar cp 
                   inner join kss.v$unidade_negocio un 
                      on un.cod_pessoa = cp.cod_pessoa_empresa 
                   inner join kss.v$departamento depto 
                      on depto.cod_departamento = cp.cod_departamento 
                   inner join kss.v$setor st 
                      on st.cod_setor = cp.cod_setor 
                   inner join kss.v$centro_custo cc 
                      on cc.cod_centro_custo = cp.cod_centro_custo 
                   inner join finan.v$finan_tipo_pagto tp 
                      on tp.tipo_pagto_id = cp.tipo_pagto_id 
                   inner join finan.v$finan_documento td 
                      on td.docto_id = cp.docto_id 
                   inner join finan.v$ccorrente cf 
                      on cf.cod_conta = cp.cc_favorecido 
                   inner join finan.v$ccorrente_banco cs 
                      on cs.cod_conta = cp.cc_sacado 
                    left join kss.banco b 
                      on b.banco_id = cp.banco_id 
                    left join kss.banco_agencia a 
                      on a.banco_id = cp.banco_id and 
                         a.agencia_id = cp.agencia_id 
               where 1=1
                 and cp.situacao = 0
               <cfif isDefined("arguments.num_documento") and   len(trim(arguments.num_documento))>
               	<cfif listlen(arguments.num_documento,',') gt 1>
                   and upper(cp.num_docto) in (#ListQualify(arguments.num_documento,"'",',')#)
                <cfelse>
                 and upper(cp.num_docto) like nvl(upper('#arguments.num_documento#'),'%')
                </cfif>
               </cfif>
               <cfif isDefined("arguments.cc_favorecido") and   len(trim(arguments.cc_favorecido))>
                 and cp.cc_favorecido = #arguments.cc_favorecido#
               </cfif>
               <cfif isDefined("arguments.data_inicial") and   len(trim(arguments.data_inicial))>
                 and cp.data_vencto >= '#arguments.data_inicial# 00:00:00'
               </cfif>
               <cfif isDefined("arguments.data_final") and   len(trim(arguments.data_final))>
                 and cp.data_vencto <= '#arguments.data_final# 23:59:59'
               </cfif>
               <cfif isDefined("arguments.cod_pessoa_favorecido") and   len(trim(arguments.cod_pessoa_favorecido))>
                 and cf.cod_pessoa in (#arguments.cod_pessoa_favorecido#)
               </cfif>
               <cfif isDefined("arguments.docto_id") and   len(trim(arguments.docto_id))>
                 and cp.docto_id in (#ListQualify(arguments.docto_id,"'",',')#)
               </cfif>
               <cfif isDefined("arguments.not_docto_id") and len(trim(arguments.not_docto_id))>
               	 and cp.docto_id not in (#ListQualify(arguments.not_docto_id,"'",',')#)
               </cfif>
               <cfif isDefined("arguments.favorecido") and  len(trim(arguments.favorecido))>
                 and upper(cf.descricao_conta) like upper('%#arguments.favorecido#%')
               </cfif>
               <cfif isDefined("arguments.data_emissao") and  len(trim(arguments.data_emissao))>
                  and trunc(cp.data_emissao) = '#arguments.data_emissao#'
               </cfif>
               <cfif isDefined("arguments.data_vencimento") and  len(trim(arguments.data_vencimento))>
                  and trunc(cp.data_vencto) = '#arguments.data_vencimento#'
               </cfif>
               <cfif isDefined("arguments.valor") and  len(trim(arguments.valor))>
                  and trunc(cp.valor_docto) = '#arguments.valor#'
               </cfif>
               <cfif isDefined("arguments.contas_pagar_id") and  len(trim(arguments.contas_pagar_id))>
                  and trunc(cp.contas_pagar_id) = '#arguments.contas_pagar_id#'
               </cfif>
               <cfif isDefined("arguments.cod_pessoa") and len(trim(arguments.cod_pessoa))>
               	  and cp.cod_pessoa_empresa = #arguments.cod_pessoa#
               </cfif>
             order by cf.descricao_conta, cp.num_docto
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Busca os tipos de pagamento
    -- 26/12/2009 - criado
    --->	
    <cffunction name="get_tipo_pagto" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="tipo_pagto_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select p.tipo_pagto_id,
            	   p.tipo_pagto_descricao
			  from finan.v$finan_tipo_pagto p

             where 1=1
             <cfif isDefined("arguments.tipo_pagto_id") and len(trim(arguments.tipo_pagto_id))>
               and p.tipo_pagto_id in (#arguments.tipo_pagto_id#)
             </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Busca os cheques emitidos
    -- 27/12/2009 - criado
    --->	
    <cffunction name="get_cheques_emitidos" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="data_inicial" required="no" default="">
    	<cfargument name="data_final" required="no" default="">
    	<cfargument name="cc_sacado" required="no" default="">
    	<cfargument name="estorno" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ch.serie_cheque
            	 , ch.num_cheque
                 , lpad(ch.cc_sacado,6,'0')||'_'||lpad(ch.serie_cheque,6,'0')||'_'||lpad(ch.num_cheque,6,'0') as documento_id
                 , ch.impresso
                 , ch.a_ordem, ch.valor
                 , to_char(cc.data_vencto,'dd/mm/yyyy hh24:mi:ss') as data_compensacao
                 , to_char(ch.data_emissao,'dd/mm/yyyy hh24:mi:ss') as data_emissao
                 , to_char(ch.data_previsao,'dd/mm/yyyy hh24:mi:ss') as data_previsao
                 , chcc.num_lancto_ccorrente
                 , ccd.descricao_documento||nvl2(cc.historico,' - '||cc.historico,'') as historico
                 , cc.cod_conta
              from finan.v$cheque_ccorrente chcc
             inner join finan.v$cheque ch
                     on chcc.cc_sacado = ch.cc_sacado
                    and chcc.num_cheque = ch.num_cheque
                    and chcc.serie_cheque = ch.serie_cheque
             inner join finan.v$ccorrente_lancamento cc
                     on cc.num_lancamento = chcc.num_lancto_ccorrente
             inner join finan.v$ccorrente_documento ccd
                     on ccd.cod_documento = cc.cod_documento
             where 1=1
             <cfif len(trim(arguments.cc_sacado))>
               and ch.cc_sacado = #arguments.cc_sacado#
             </cfif>
             <cfif len(trim(arguments.data_inicial))>
               and ch.data_emissao >= '#arguments.data_inicial# 00:00:00'
             </cfif>
             <cfif len(trim(arguments.data_final))>
               and ch.data_emissao <= '#arguments.data_final# 23:59:59'
             </cfif>
             <cfif len(trim(arguments.estorno))>
             	<cfif arguments.estorno eq 1>
	               and cc.data_vencto is not null
                <cfelse>
	               and cc.data_vencto is null
                </cfif>
             </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
	<!--- 
	-- PROPSITO 
	-- Busca o tipos de documento
	-- NOTAS EXPLICATIVAS
	-- GUTO 22/10/2008
	--->
	<cffunction name="get_tipo_documento" returntype="query" access="remote">
		<cfargument name="contas_pagar" required="no" default="">
		<cfargument name="contas_receber" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select fd.docto_id, fd.descricao
              from finan.v$finan_documento fd
            where 1=1            
            <cfif Len(Trim(arguments.contas_pagar))>
              and fd.contas_pagar = 1
            </cfif>
            <cfif Len(Trim(arguments.contas_receber))>
              and fd.contas_receber = 1
            </cfif>
   		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
    
    
    <!--- 
	-- PROPSITO 
	-- Busca o tipos de documento
	-- NOTAS EXPLICATIVAS
	-- GUTO 22/10/2008
	--->
	<cffunction name="get_historico" returntype="query" access="remote">
		<cfargument name="contas_pagar" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select f.cod_historico,
                   f.historico,
                   f.historico_contabil,
                   f.ativo,
                   f.cod_contabil,
                   f.cod_centro_custo,
                   f.hist_cpagar,
                   f.hist_cpagar_juro,
                   f.hist_cpagar_desc,
                   f.hist_creceber,
                   f.hist_creceber_juro,
                   f.hist_creceber_desc,
                   f.hist_caixa
              from finan.v$finan_caixa_historico f
            where 1=1
            <cfif Len(Trim(arguments.contas_pagar))>
              and f.hist_cpagar = 1
            </cfif>
   		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
    
    
	<!--- 
    -- PROPSITO
    -- Busca os historicos de caixa
    -- 09/02/2009 - criado
    --->	
    <cffunction name="get_finan_caixa_historico" displayname="" output="true" returntype="query" access="remote">
    	<cfargument name="hist_cpagar_desc" required="no" default="">
    	<cfargument name="hist_cpagar_juro" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cod_historico,
                   historico       
              from finan.v$finan_caixa_historico
             where ativo = 1
             <cfif len(trim(arguments.hist_cpagar_desc))>
               and hist_cpagar_desc = #arguments.hist_cpagar_desc#
             </cfif>
             <cfif len(trim(arguments.hist_cpagar_juro))>
               and hist_cpagar_juro = #arguments.hist_cpagar_juro#
             </cfif>
             order by historico
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
       
</cfcomponent>