<!-- KM&M Componentes -->
<cfcomponent displayname="Consultas da rea de caixas" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO 
	-- Busca os parametros de gestao do controle de vales
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  27/02/2006
	--->
	<cffunction name="get_gestao" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qrGestao" username="#session.usuario#" password="#session.senha#">
			select oper.pkg_global.fnc_get_parametro(1,'VALE') as limite_vales_motorista, 
				   oper.pkg_global.fnc_get_parametro(2,'VALE') as valor_vales_eixo, 
				   oper.pkg_global.fnc_get_parametro(3,'VALE') as vale_pessoal, 
				   oper.pkg_global.fnc_get_parametro(4,'VALE') as limite_vale_pessoal_mes, 
				   oper.pkg_global.fnc_get_parametro(5,'VALE') as limite_primeiro_vale, 
				   oper.pkg_global.fnc_get_parametro(6,'VALE') as num_vales_bloco,
				   oper.pkg_global.fnc_get_parametro(43,'VALE') as dias_relacao_pedagio
			  from dual
  		</cfquery>
	<cfreturn qrGestao>
	</cffunction>
    
	<!--- 
	-- PROPSITO 
	-- Busca o nmero do proximo vale a ser trocado
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  16/01/2006
	--->
	<cffunction name="get_proximo_vale" access="remote" returntype="numeric" output="true">
		<cfargument name="num_vale" displayname="Nmero do vale" type="numeric" required="true">
		<cfquery datasource="#session.dsn#" name="qrProximo_vale" username="#session.usuario#" password="#session.senha#">
			select nvl(min(num_vale),0) as proximo_vale
			  from oper.v$vale v
			 where v.num_vale < #Arguments.num_vale#
			   and v.situacao_id = 2
			   and v.cod_pessoa_funcionario = (select cod_pessoa_funcionario 
												 from oper.v$vale 
												where num_vale = #Arguments.num_vale#)
			   and v.num_bloco = (select v2.num_bloco
									from oper.v$vale v2
								   where v2.num_vale = #Arguments.num_vale#)
		</cfquery>
		<cfreturn qrProximo_vale.proximo_vale>
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- 
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  16/01/2006
	--->
	<cffunction name="get_saldos" access="remote" returntype="query" output="true">
		<cfargument name="num_vale"	required="yes">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select v.num_vale
                 , v.cod_centro_custo
                 , v.valor
                 , v.situacao_id
                 , v.tipo_id
                 , v.num_bloco
                 , v.cod_pessoa_troca
                 , (select pt.cnpj_cpf
                      from kss.v$pessoa pt
                     where pt.cod_pessoa = v.cod_pessoa_troca) cnpj_local
                 , v.data_entrega
                 , v.data_troca
                 , v.contas_pagar_id
                 , v.num_recibo
                 , v.cod_pessoa_funcionario
                 , (select mrh.cod_registro 
                      from oper.v$motorista_reg_historico mrh
                     where mrh.cod_pessoa = v.cod_pessoa_funcionario
                       and mrh.data_fim is null) cod_funcionario
                 , v.comentario
                 , v.obs_troca
                 , v.user_libera_troca
                 , v.cx_lancamento_id
                 , v.agrupamento_id
                 , (select p.razao_social
                      from kss.v$pessoa p
                     where p.cod_pessoa = v.cod_pessoa_funcionario) nome_funcionario
                ,round((nvl((select sum(mp.base_calculo)
                        from oper.v$mapa_producao mp
                       where mp.cod_pessoa_motorista = v.cod_pessoa_funcionario
                         and mp.data_emissao between to_date(kss.pkg_global.fnc_parametro_str(11, 'OPERACIONAL', 17, 451), 'dd/mm/yyyy') and sysdate                                              
                         and not exists(select '*'
                                          from oper.v$comissao_documento cd
                                         where cd.conhecimento_id = mp.conhecimento_id
                                            or cd.nf_es_id = mp.nf_es_id
                                            or cd.cf_lancto_id = mp.cf_lancto_id)
                     ),0) * (select pc.valor/100
                               from kss.v$parametro_conteudo pc
                              where pc.cod_projeto = 11
                                and pc.parametro_grupo_id = 13
                                and pc.parametro_id = 500)/1000),2) as saldo_comissao
                 , finan.pkg_ccorrente.fnc_saldo_ccorrente_atual((select cc.cod_conta
                                                                    from finan.v$ccorrente cc
                                                                   where cc.ativo = 1
                                                                     and cc.modalidade_id = 9
                                                                     and cc.cod_pessoa = v.cod_pessoa_funcionario),to_date(sysdate)) as saldo_cc
                 , (select vm.placa
                      from oper.v$veiculo_motorista vm
                     where vm.cod_pessoa = v.cod_pessoa_funcionario
                       and vm.data_fim is null ) as placa
                 , (select count(1)
                      from kss.v$pessoa_modalidade pm
                     where pm.cod_pessoa = v.cod_pessoa_funcionario
                       and pm.num_modalidade in (2,6)
                       and pm.situacao = 1) as motorista
                 , v.rowid
              from oper.v$vale v
             where v.num_vale = #arguments.num_vale#
		</cfquery>
		<cfreturn qr_result>
	</cffunction>		
	
	<!--- 
	-- PROPSITO 
	-- Busca as situaes de vales
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  01/03/2006
	--->
	<cffunction name="get_situacao" access="remote" returntype="query" output="true">
		<cfargument name="cancelado" required="false">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select situacao_id, descricao, comentario
			  from oper.v$vale_situacao
			<cfif isDefined("Arguments.cancelado")>
				 where cancelamento = 1
			 </cfif>
			 order by situacao_id
  		</cfquery>
	<cfreturn qr_result>
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Verifica o abastecimento
	-- NOTAS EXPLICATIVAS
	-- GUTO 29/04/2006
	--->
	<cffunction name="get_situacao_consumo_diesel" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_motorista" required="yes" />
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select oper.pkg_abastecimento.fnc_verifica_consumo_combust(#arguments.cod_pessoa_motorista#) as resultado     
			  from dual
  		</cfquery>
	<cfreturn qr_result>
	</cffunction>		

	<!--- 
	-- PROPSITO 
	-- Verifica se a troca  em uma filial, se for o veculo deve fazer um abastecimento antes de trocar o vale
	-- NOTAS EXPLICATIVAS
	-- GUTO 29/04/2006
	--->
	<cffunction name="get_verifica_abastecimento_filial" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_troca" required="yes" />
		<cfargument name="cod_setor" required="yes" />
		<cfargument name="placa" required="yes" />
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select oper.pkg_controla_vale.fnc_verifica_troca_filial(#arguments.cod_pessoa_troca#, #arguments.COD_SETOR#, '#arguments.placa#') as resultado
			  from dual
   		</cfquery>
	<cfreturn qr_result>
	</cffunction>		
	
	<!--- 
	-- PROPSITO 
	-- Busca o ultimo bloco do motorista
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  01/03/2006
	--->		
	<cffunction name="get_ultimo_bloco" access="remote" returntype="query" output="true">
		<cfargument name="COD_FUNCIONARIO" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct num_bloco 
			from oper.v$vale
			 where cod_pessoa_funcionario = #arguments.COD_FUNCIONARIO#
			   and situacao_id = 2
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>		

	<!--- 
	-- PROPSITO 
	-- Busca o ultimo vale alocado no sistema
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  01/03/2006
	--->
	<cffunction name="get_ultimo_vale" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select max(num_vale) as num_vale
			  from oper.v$vale
  		</cfquery>
	<cfreturn qr_result>
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Retorna log de alterao do vale
	-- NOTAS EXPLICATIVAS
	-- GUTO 02/05/2006
	--->
	<cffunction name="get_vale_log" access="remote" returntype="query" output="true">
		<cfargument name="num_vale" required="yes" />
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select vl.usuario, vl.data, vl.num_vale, vl.situacao_id, vs.DESCRICAO as situacao
			  from oper.v$vale_log vl
			 inner join oper.v$vale_situacao vs
					 on vs.situacao_id = vl.situacao_id
		     where vl.num_vale = #arguments.NUM_VALE#
			 order by vl.data
   		</cfquery>
	<cfreturn qr_result>
	</cffunction>		
		
	<!--- 
	-- PROPSITO 
	-- Busca os dados do vale
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  16/01/2006
	--->
	<cffunction name="get_vale" access="remote" returntype="query" output="true">
		<cfargument name="num_vale" 		required="no" default="">
		<cfargument name="num_bloco" 		required="no" default="">
		<cfargument name="cod_funcionario" 	required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select v.num_vale, 
				   v.valor, 
				   vs.descricao as situacao, 
				   vt.descricao as tipo,
				   decode(v.cod_pessoa_troca,null,'',kss.pessoa_pkg.getcliente(v.cod_pessoa_troca,1)) as local_troca, 
				   v.data_entrega,
				   v.data_troca, 
				   v.placa, 
				   decode(v.cod_pessoa_funcionario,null,'',kss.pessoa_pkg.getcliente(v.cod_pessoa_funcionario,1)) as nome_motorista,
				   v.cod_pessoa_funcionario, 
				   v.comentario, 
				   v.situacao_id, 
				   v.user_update as usuario, 
				   vs.cancelamento, 
				   v.date_update as ultima_alteracao
			  from oper.v$vale v
			 inner join oper.v$vale_situacao vs 
					 on v.situacao_id = vs.situacao_id
               left join oper.v$vale_tipo vt
					 on v.tipo_id = vt.tipo_id
			 where 1=1
			<cfif Len(Trim(arguments.num_vale))>
			   and num_vale = #arguments.num_vale#
			<cfelseif Len(trim(arguments.num_bloco)) and Len(trim(arguments.cod_funcionario))>
			   and v.num_bloco in (#arguments.num_bloco#)
			   and v.cod_pessoa_funcionario = oper.pkg_global.fnc_get_cod_pessoa_func(#arguments.cod_funcionario#)
			 order by v.num_vale
			</cfif>
		</cfquery>		
	<cfreturn qr_result>
	</cffunction>
	
	
	<!--- 
	-- PROPSITO 
	-- Busca a listagem de vales
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  01/03/2006
	--->
	<cffunction name="get_vale_listagem" access="remote" returntype="query" output="true">
		<cfargument name="data_inicial" 	required="no" default="">
		<cfargument name="data_final" 		required="no" default="">
		<cfargument name="cod_funcionario" 	required="no" default="">
		<cfargument name="situacao" 		required="no" default="">
		<cfargument name="cod_local_troca" 	required="no" default="">
		<cfargument name="num_inicial" 		required="no" default="">
		<cfargument name="num_final" 		required="no" default="">
		<cfargument name="num_vale" 		required="no" default="">
		<cfargument name="obs_troca" 		required="no" default="">
        <cfargument name="tipo_vale" 		required="no" default="">
        <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select v.cod_pessoa_funcionario
                 , v.num_vale
                 , ps.razao_social as funcionario
                 , v.placa
                 , v.valor
                 , pss.cnpj_cpf as cnpj_local_troca
                 , pss.razao_social as local_troca
                 , pss.cliente as local_troca_fantasia
                 , v.tipo_id
                 , vt.descricao as tipo
                 , vs.situacao_id
                 , vs.descricao as situacao
                 , to_char(v.date_insert,'dd/mm/yyyy hh24:mi:ss') as data_insercao
                 , v.user_insert as responsavel
                 , trunc(v.data_troca) data_troca
                 , trunc(v.data_entrega) data_entrega
                 , ps.cnpj_cpf as id_funcionario
                 , v.comentario
                 
                 
              from oper.v$vale v
             inner join oper.v$vale_situacao vs
                     on vs.situacao_id = v.situacao_id
              left join oper.v$vale_tipo vt
                     on vt.tipo_id = v.tipo_id
              left join kss.v$pessoa ps
                     on ps.cod_pessoa = v.cod_pessoa_funcionario
              left join kss.v$pessoa pss
                     on pss.cod_pessoa = v.cod_pessoa_troca
              
             where 1=1
			<cfif len(trim(arguments.COD_FUNCIONARIO))>
            	 and (select to_number(cod_registro) from oper.v$motorista_reg_historico t
                         where cod_pessoa = v.cod_pessoa_funcionario
                           and t.COD_REGISTRO = #arguments.cod_funcionario#
                           and v.data_entrega between data_inicio and nvl(data_fim, v.data_entrega)) = #arguments.cod_funcionario#
			</cfif>
			<cfif Len(Trim(arguments.situacao))>
			     and v.situacao_id in (#arguments.situacao#)
			</cfif>
			<cfif len(trim(arguments.cod_local_troca))>
			   and v.cod_pessoa_troca = #arguments.cod_local_troca#
			</cfif>
			<cfif len(trim(arguments.DATA_INICIAL))>
			   and trunc(v.data_troca) >= '#arguments.data_inicial#'
			</cfif>
			<cfif len(trim(arguments.DATA_FINAL))>
			   and (trunc(v.data_troca) <= '#arguments.data_final#' or v.data_troca is null)
			</cfif>
			<cfif len(trim(arguments.num_inicial))>
			   and v.num_vale >= #arguments.num_inicial#
			</cfif>
			<cfif len(trim(arguments.num_final))>
			   and v.num_vale <= #arguments.num_final#
			</cfif>
			<cfif len(trim(arguments.num_vale))>
			   and v.num_vale = #arguments.num_vale#
			</cfif>
			<cfif len(trim(arguments.obs_troca))>
			   and v.obs_troca like '%#arguments.obs_troca#%'
			</cfif>
            <cfif tipo_vale neq 0 and len(trim(arguments.tipo_vale)) >
			   and v.tipo_id = #arguments.tipo_vale#
			</cfif>
			 order by v.num_vale
		</cfquery>
	<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Verifica se a empresa contra vale, ou seja, se deve fazer todas as verificaes
	-- NOTAS EXPLICATIVAS
	-- GUTO 02/05/2006
	--->
	<cffunction name="get_empresa_controla_vale" access="remote" returntype="query" output="true">
		<cfargument name="placa_controle" required="yes" />
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			 select cod_pessoa 
			  from oper.v$veiculo_ctrl_vale
			 where placa = '#arguments.placa_controle#'
			   and rownum = 1
			   and sysdate between data_inicio and nvl(data_fim,sysdate+1/1440)
   		</cfquery>
	<cfreturn qr_result>
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Verifica se o motorista possui documentos urgentes
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  16/01/2006
	--->
	<cffunction name="verifica_doctos_urgentes_motorista" displayname="Verifica se o motorista possui documentos urgentes" access="remote" returntype="struct" output="true">
		<cfargument name="cod_pessoa_motorista" required="true">
		<cftry>
			<cfset retorno = structNew()>
			<cfquery datasource="#session.dsn#" name="qrDoctos" username="#session.usuario#" password="#session.senha#">
				select oper.pkg_fluxo_docto.fnc_verifica_entrega_doctos(#arguments.cod_pessoa_motorista#)
				  from dual
			</cfquery>
			<cfset retorno.mensagem = 'Troca de vale permitida.'>		
			<cfset retorno.erro = false>						
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Retorna 1 se o motorista possui a relao de pedgio fechada no perodo permitido no parmetro
	-- NOTAS EXPLICATIVAS
	-- GUTO 11/03/2009
	--->
	<cffunction name="get_relacao_pedagio_ok" access="remote" returntype="numeric" output="true">
    	<cfargument name="cod_pessoa" required="yes"/>
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select min(relacao_pedagio_ok) as relacao_pedagio_ok
            from (
                  select case 
                           when (sysdate - max(pl.data))- oper.pkg_global.fnc_get_parametro(43,'VALE') > 0 then 0
                           else 1 end relacao_pedagio_ok
                    from oper.v$pedagio_lancto pl
                   where pl.cod_pessoa = #arguments.COD_PESSOA#
                     and pl.relacao_id is null /*
                  union
                    select case 
                           when (sysdate - max(vr.data))- oper.pkg_global.fnc_get_parametro(43,'VALE') > 0 then 0
                           else 1 end relacao_pedagio_ok
                    from oper.v$viagem_recibo vr
                   where vr.cod_pessoa = #arguments.COD_PESSOA#
                     and vr.relacao_id is null */)
  		</cfquery> 
	<cfreturn qr_result.relacao_pedagio_ok>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Verifica se para a placa deve ser verificada a data de fechamento do pedgio
	-- NOTAS EXPLICATIVAS
	-- GUTO 16/03/2009
	--->
	<cffunction name="get_empresa_controla_vale_relacao" access="remote" returntype="query" output="true">
		<cfargument name="placa_controle" required="yes" />
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select vp.placa
              from oper.v$veiculo_proprietario_atual vp
              inner join oper.v$vale_controle_rel_pedagio vr
                      on vr.cod_pessoa = vp.cod_pessoa
              where vp.placa = '#arguments.placa_controle#'
   		</cfquery>
	<cfreturn qr_result>
	</cffunction>	    
    
    <!--- 
    -- PROPSITO 
    -- Retorna um local de troca de vales
    -- ANDERSON 09/02/2010 - CRIADO
    --->		
    <cffunction name="get_local_troca_vales" access="remote" returntype="query" output="true">
        <cfargument name="cnpj" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select p.cod_pessoa
                 , p.cnpj_cpf
                 , p.razao_social
                 , p.cliente
              from kss.v$pessoa p
             inner join kss.v$pessoa_modalidade pm
                     on pm.cod_pessoa = p.cod_pessoa
                    and pm.num_modalidade = 12
                    and pm.situacao = 1
             inner join oper.v$posto_produto_autorizado ppa
                     on ppa.cod_pessoa = p.cod_pessoa
                    and ppa.produto_id = 7
                    and ppa.liberado = 1
             where p.cnpj_cpf = #arguments.cnpj#
             union
            select p.cod_pessoa
                 , p.cnpj_cpf
                 , p.razao_social
                 , p.cliente
              from kss.v$pessoa p
             inner join kss.v$pessoa_modalidade pm
                     on pm.cod_pessoa =p.cod_pessoa
                    and pm.num_modalidade = 9
                    and pm.situacao = 1
             where p.cnpj_cpf = #arguments.cnpj#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna o nmero do prximo do vale
    -- GUSTAVOC 06/05/2010 - CRIADO
    --->		
    <cffunction name="get_proximo_num_vale" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select nvl(max(num_vale), 0) + 1 as num_vale
              from oper.v$vale
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!--- 
    -- PROPSITO 
    -- identificar se este romaneio j possui vale emitido
    -- GUSTAVOC 06/05/2010 - CRIADO
    --->		
    <cffunction name="get_vale_romaneio" access="remote" returntype="query" output="true">
    	<cfargument name="num_romaneio" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select num_vale
              from oper.v$vale_romaneio
             where num_romaneio = #arguments.num_romaneio#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
</cfcomponent>