<cfcomponent displayname="Componentes de consulta para controle de trfego" extends="_transportes.funcoes.cfc_init">
<!--- 
-- PROPSITO
-- Busca niveis acesos
-- NOTAS EXPLICATIVAS
--  
-- GUTO 28/12/2005 - criado
--->	
<cffunction name="get_niveis_acesso" displayname="Consulta todas as aplicaes" access="remote" returntype="query" output="true">
	<cfquery datasource="#session.dsn#" name="qr_aplicacoes" username="#session.usuario#" password="#session.senha#">
        select n.cod_nivel_acesso, n.nome_nivel_acesso
          from kss.kss_nivel_acesso n
         order by n.cod_nivel_acesso
	</cfquery>	
	<cfreturn qr_aplicacoes>
</cffunction>	

<!--- 
-- PROPSITO
-- Busca as aplicaes cadastradas
-- NOTAS EXPLICATIVAS
--  
-- GUTO 28/12/2005 - criado
--->	
<cffunction name="get_aplicacoes" displayname="Consulta todas as aplicaes" access="remote" returntype="query" output="true">
	<cfquery datasource="#session.dsn#" name="qr_aplicacoes" username="#session.usuario#" password="#session.senha#">
		select a.cod_projeto, 
			   a.cod_aplicacao, 
			   a.nome_aplicacao
		  from kss.kss_aplicacao a 
		 where a.tipo_aplicacao_id = 1 
	</cfquery>	
	<cfreturn qr_aplicacoes>
</cffunction>	
<!--- 
-- PROPSITO
-- Busca todos os usurios
-- NOTAS EXPLICATIVAS
-- CRISTOFER 03/01/2006
--->
<cffunction name="get_usuarios" displayname="Busca todos os usurios" access="remote" returntype="query" output="false">
	<cfargument name="ordem" 		required="no" default="nome">
	<cfargument name="aplicacao" 	required="no" default="">
	<cfargument name="ativo"		required="no" default="">
	<cfargument name="USUARIO"		required="no" default="">
	<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
		select *
		 from (SELECT distinct u.nome || ' - ' || u.usuario as nome, 
		              u.usuario, 
                      u.nome as nome_usuario,
					  u.ativo, 
					  u.cod_pessoa 
		         FROM kss.kss_usuarios u
		<cfif Len(trim(arguments.aplicacao))>
				inner join kss.pessoa_usuario_aplicacao ua
					    on ua.usuario = u.usuario
				       and ua.cod_aplicacao = '#arguments.aplicacao#'
		</cfif>) 
		where 1=1
		<cfif len(trim(arguments.ativo))>
		  and ativo = #arguments.ativo#
		</cfif>
		<cfif len(trim(arguments.usuario))>
		  and upper(usuario) = upper('#arguments.usuario#')
		</cfif>
		ORDER BY #Arguments.ordem#
	</cfquery>
	<cfreturn qr_result>
</cffunction>
<!--- 
-- PROPSITO
-- Busca todos os usurios
-- NOTAS EXPLICATIVAS
-- CRISTOFER 03/01/2006
--->
<cffunction name="get_usuarios_modulo" displayname="Busca todos os usurios" access="remote" returntype="query" output="false">
	<cfargument name="ordem" 		required="no" default="nome">
	<cfargument name="modulo_id" 	required="no" default="">
	<cfargument name="ativo"		required="no" default="">
	<cfargument name="USUARIO"		required="no" default="">
	<cfargument name="num_modalidade"	required="no" default="">    
	<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
		select *
		 from (SELECT distinct u.nome || ' - ' || u.usuario as nome, 
		              u.usuario, 
					  u.ativo, 
					  u.cod_pessoa 
		         FROM kss.kss_usuarios u
		<cfif Len(trim(arguments.MODULO_ID))>
                inner join acesso.v$modulo_usuario ua
					    on ua.usuario = u.usuario
				       and ua.modulo_id = #arguments.MODULO_ID#
			<cfif Len(trim(arguments.num_modalidade))>	
                inner join kss.pessoa_modalidade pm on pm.cod_pessoa = u.cod_pessoa
	            inner join kss.modalidade m on m.num_modalidade = pm.num_modalidade
                where m.num_modalidade in (#arguments.num_modalidade#)
            </cfif>
		</cfif>) 
		where 1=1
		<cfif len(trim(arguments.ativo))>
		  and ativo = #arguments.ativo#
		</cfif>
		<cfif len(trim(arguments.usuario))>
		  and usuario = '#arguments.usuario#'
		</cfif>
		ORDER BY #Arguments.ordem# 
	</cfquery>
	<cfreturn qr_result>
</cffunction>
<!--- 
-- PROPSITO
-- Busca todas as lotaes possveis e a atual do usurio
-- NOTAS EXPLICATIVAS
-- CRISTOFER 03/01/2006
--->
<cffunction name="get_lotacoes" displayname="Busca todas as lotaes possveis e a atual do usurio" access="remote" returntype="query" output="true">
	<cfargument name="usuario" required="yes">
	<cfargument name="atual" required="no" default="0">
	<cfquery name="qr_lotacoes" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		select distinct u.usuario, 
        	   u.nome,
			   u.cod_pessoa as cod_pessoa_lotacao, 
			   p.cod_pessoa,
			   p.cliente as nome_fantasia, 
			   d.cod_departamento, 
			   d.descricao as departamento, 
			   s.cod_setor, 
			   s.descricao as setor, 
			   c.cod_centro_custo, 
			   c.centro_custo, 
			   ul.cod_lotacao
		  from kss.lotacao l
		 inner join kss.kss_usuarios u
		   		 on l.cod_pessoa_lotacao = u.cod_pessoa
		 inner join kss.v$pessoa p
		   		 on l.cod_pessoa = p.cod_pessoa
		 inner join kss.v$departamento d
		   		 on l.cod_departamento = d.cod_departamento
		 inner join kss.v$setor s
				 on l.cod_setor = s.cod_setor
		 inner join kss.v$centro_custo c 
		   		 on l.cod_centro_custo = c.cod_centro_custo 
		 <cfif arguments.atual eq 0>
	     left join kss.usuario_lotacao ul
				 on l.cod_lotacao = ul.cod_lotacao
					and upper(ul.usuario) = upper('#Arguments.usuario#')
		 <cfelse>
	     inner join kss.usuario_lotacao ul
				    on l.cod_lotacao = ul.cod_lotacao
					and upper(ul.usuario) = upper('#Arguments.usuario#')
		 </cfif>
		 where upper(u.usuario) = upper('#Arguments.usuario#')
		 order by nome_fantasia, 
		 		  departamento, 
				  setor 
		</cfquery>
<cfreturn qr_lotacoes>
</cffunction>	
<!--- 
-- PROPSITO
-- Busca o organograma do usuario
-- NOTAS EXPLICATIVAS
-- WAGNER 30/09/2010
--->
<cffunction name="get_usuario_organograma" displayname="Busca todas as lotaes possveis e a atual do usurio" access="remote" returntype="query" output="true">
	<cfargument name="usuario" required="yes">
	<cfquery name="qr_organograma" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		select o.cod_organograma,
               o.cod_pessoa,
               o.cod_unidade_negocio,
               o.cod_departamento,
               o.cod_setor,
               o.cod_centro_custo
          from kss.v$organograma o
         where o.cod_organograma = kss.pkg_organograma.fnc_organograma_usuario('#arguments.usuario#')
		</cfquery>
<cfreturn qr_organograma>




</cffunction>	
</cfcomponent>