<cfcomponent displayname="Componentes de consulta para controle de trfego" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- Retorna todos os pases cadastrados
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 01/12/2005 - criado
	--->	
	<cffunction name="get_pais" displayname="Retorna todos os pases cadastrados" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select pais_id, initcap(descricao) as descricao, id_2, id_3, id_iso, verifica_documentos , 
				   user_insert, date_insert, user_update, date_update 
			  from cep.pais
			order by descricao  
  		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Retorna todos os cod_pais cadastrados em MICs
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 10/02/2006
	--->	
	<cffunction name="get_cod_pais_mic" displayname="Retorna todos os pases cadastrados" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select distinct numero_cod_pais from fiscal.v$intc_manifesto
 		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Retorna todos os cod_pais cadastrados em CRTs
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 10/02/2006
	--->	
	<cffunction name="get_cod_pais_crt" displayname="Retorna todos os pases cadastrados" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select distinct numero_cod_pais from fiscal.v$intc_conhecimento
 		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Retorna todos os estados do territrio nacional e EX para os pases estrangeiros
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 01/12/2005 - criado
	--->	
	<cffunction name="get_uf" displayname="Retorna todos os estados do territrio nacional e EX para os pases estrangeiros" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select sigla_uf, initcap(nome_uf) as nome_uf, cod_uf 
			  from cep.cep_ufs
  			 order by nome_uf
  		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Retorna todos os registro da tabela de seguro
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 01/12/2005 - criado
	--->
	<cffunction name="get_tabela_seguro" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select distinct uf_origem, origem, uf_destino, destino,  taxa
		      from (select org.sigla_uf as uf_origem, initCap(org.nome_uf) as origem, dest.sigla_uf as uf_destino, initCap(dest.nome_uf) as destino,  taxa
					 from oper.v$seguro_uf_taxa uf
					inner join cep.cep_ufs org 
					   on uf.COD_UF_1 = org.cod_uf
					inner join cep.cep_ufs dest 
					   on uf.COD_UF_2 = dest.cod_uf
					union 
					select dest.sigla_uf as uf_origem, initCap(dest.nome_uf) as origem, org.sigla_uf as uf_destino, initCap(org.nome_uf) as destino, taxa
					 from oper.v$seguro_uf_taxa uf
					inner join cep.cep_ufs org 
					   on uf.COD_UF_1 = org.cod_uf
					inner join cep.cep_ufs dest 
					   on uf.COD_UF_2 = dest.cod_uf)
	      order by uf_origem
		</cfquery>
	<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Retorna todos os bancos internacionais cadastrados
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 01/12/2005 - criado
	--->	
	<cffunction name="get_intc_bancos" displayname="Retorna todos os bancos internacionais cadastrados" access="remote" returntype="query" output="true">
		<cfargument name="ITEM_ID" required="no" default="" />
		<cfargument name="NOME" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select atributo_id, item_id, nome 
			  from finan.v$intc_bancos
			 where 1=1
			 <cfif Len(Trim(arguments.ITEM_ID))>
			   and item_id = #arguments.ITEM_ID#
			 </cfif>
			 <cfif Len(Trim(arguments.NOME))>
			   and nome like '%#arguments.NOME#%'
			 </cfif>
			 order by nome 
		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Retorna as cidades cadastradas no sistema
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 01/12/2005 - criado
	--->	

	<cffunction name="get_cidade" displayname="Retorna as cidades cadastradas no sistema" access="remote" returntype="query" output="true">
		<cfargument name="municipio_id" required="no" />
		<cfargument name="municipio" required="no" />
		<cfargument name="pais_id" required="no" />
		<cfargument name="uf_id" required="no" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select distinct municipio_id, 
            	   municipio, 
                   latitude, 
                   longitude, 
                   cep.pkg_coord_geografica.fnc_graus2decimais(latitude) as latitude_dec, 
                   cep.pkg_coord_geografica.fnc_graus2decimais(longitude) as longitude_dec, 
                   p.pais_id, 
                   uf_id,
				   altitude, 
                   cep, 
                   cod_inpe, 
                   intc_cod_municipio, 
                   p.descricao as pais, 
                   cep.pkg_municipio.fnc_cidade_completa(municipio_id) as descricao
			  from cep.municipio m 		
			 inner join cep.pais p
			         on p.pais_id = m.pais_id
			 where 1=1
		    <cfif IsDefined("arguments.municipio") and Len(Trim(arguments.municipio))>
			   and upper(municipio) like upper('%#arguments.municipio#%')
			</cfif>
		    <cfif IsDefined("arguments.pais_id") and Len(Trim(arguments.pais_id))>
			   and p.pais_id = #arguments.pais_id#
			</cfif>
		    <cfif IsDefined("arguments.uf_id") and Len(Trim(arguments.uf_id))>
			   and uf_id = '#arguments.uf_id#'
			</cfif>
		    <cfif IsDefined("arguments.municipio_id") and Len(Trim(arguments.municipio_id))>
			   and municipio_id = #arguments.municipio_id#
			</cfif>			
			order by municipio
		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Retorna todas as fronteiras cadastradas
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 24/01/2006 - criado
	--->	
	<cffunction name="get_fronteira" displayname="Retorna todos as fronteiras cadastradas" access="remote" returntype="query" output="true">
		<cfargument name="fronteira_id" required="no" />
		<cfargument name="descricao" required="no" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select f.fronteira_id, f.descricao, 
				     cep.fnc_cidade_completa(f.municipio_id_1, '-') as cidade_01, f.municipio_id_1, 
				     cep.fnc_cidade_completa(f.municipio_id_2, '-') as cidade_02, f.municipio_id_2,
				     p1.id_2 as pais_01, p2.id_2 as pais_02,
				     m1.municipio || ' - ' || m1.uf_id as municipio_1,
				     m2.municipio || decode(m2.uf_id,'EX','',' - ' || m2.uf_id) as municipio_2
  		      from fiscal.v$fronteira f
			 inner join cep.municipio m1
			         on m1.municipio_id = f.municipio_id_1
       		 inner join cep.pais p1
			  	     on m1.pais_id = p1.pais_id        
			 inner join cep.municipio m2
					 on m2.municipio_id = f.municipio_id_2
  		     inner join cep.pais p2
                     on m2.pais_id = p2.pais_id        
			 where 1=1
			 <cfif IsDefined("arguments.fronteira_id") and Len(Trim(arguments.fronteira_id)) >
			   and fronteira_id = #arguments.fronteira_id#
			 </cfif>
			 <cfif IsDefined("arguments.descricao") and Len(Trim(arguments.descricao)) >
			   and upper(f.descricao) like upper('%#arguments.descricao#%')
			 </cfif>
  		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Retorna alfndegas cadastradas
	-- NOTAS EXPLICATIVAS
	--  

	-- GUTO 03/12/2005 - criado
	--->	
	<cffunction name="get_alfandega" displayname="Retorna alfndegas cadastradas" access="remote" returntype="query" output="true">
		<cfargument name="alfandega_id" required="no" />
		<cfargument name="municipio_id" required="no" />
		<cfargument name="municipio" required="no" />
		<cfargument name="pais_id" required="no" />
		<cfargument name="uf_id" required="no" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select a.alfandega_id, a.codigo, a.nome, a.municipio_id,
				   m.pais_id, m.uf_id, m.municipio, p.descricao as pais,
				   m.municipio||decode(m.uf_id, null, '', 'EX', '', ' - '||m.uf_id)||' - '||p.descricao as descricao
			  from fiscal.v$alfandega a
			 inner join cep.municipio m
					 on a.municipio_id = m.municipio_id
			 inner join cep.pais p
					 on p.pais_id = m.pais_id        
			 where 1=1
		    <cfif IsDefined("arguments.municipio") and Len(Trim(arguments.municipio))>
			   and upper(m.municipio) like upper('%#arguments.municipio#%')
			</cfif>
		    <cfif IsDefined("arguments.alfandega_id") and Len(Trim(arguments.alfandega_id))>
			   and a.alfandega_id = #arguments.alfandega_id#
			</cfif>
		    <cfif IsDefined("arguments.pais_id") and Len(Trim(arguments.pais_id))>
			   and m.pais_id = #arguments.pais_id#
			</cfif>
		    <cfif IsDefined("arguments.uf_id") and Len(Trim(arguments.uf_id))>
			   and m.uf_id = '#arguments.uf_id#'
			</cfif>
		    <cfif IsDefined("arguments.municipio_id") and Len(Trim(arguments.municipio_id))>
			   and a.municipio_id = #arguments.municipio_id#
			</cfif>		
			order by a.nome	
		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Retorna as embalagens(volumes) cadastrados
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 01/12/2005 - criado
	--->	
	<cffunction name="get_embalagens" displayname="Retorna as embalagens(volumes) cadastrados" access="remote" returntype="query" output="true">
		<cfargument name="num_especie" required="no" />
		<cfargument name="descricao" required="no" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select num_especie, descricao, abreviatura, peso, codigo_intc
			  from oper.v$especie
			 where 1=1
		    <cfif IsDefined("arguments.descricao") and Len(Trim(arguments.descricao))>
			   and upper(descricao) like upper('%#arguments.descricao#%')
			</cfif>
		    <cfif IsDefined("arguments.num_especie") and Len(Trim(arguments.num_especie))>
			   and num_especie = #arguments.num_especie#
			</cfif>
			order by descricao
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>
			
	<!--- 
	-- PROPSITO
	-- Retorna todos os INCOTERMs cadastrados
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 01/12/2005 - criado
	--->	
	<cffunction name="get_incoterm" displayname="Retorna todos os INCOTERMs cadastrados" access="remote" returntype="query" output="true">
		<cfargument name="incoterm_id" required="no" />
		<cfargument name="codigo" required="no" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select incoterm_id, codigo, significado
			  from fiscal.v$incoterm
			 where 1=1
			 <cfif IsDefined("arguments.incoterm_id") and Len(Trim(arguments.incoterm_id))>
			   and incoterm_id = #arguments.incoterm_id#
			 </cfif>
			 <cfif IsDefined("arguments.codigo") and Len(Trim(arguments.codigo))>
			   and codigo = upper('#arguments.codigo#')
			 </cfif>
  			 order by codigo
  		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>	
	<!--- 
	-- PROPSITO
	-- Lista de Moedas cadastradas
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 02/12/2005 - criado
	--->	
	<cffunction name="get_moeda" displayname="Retorna as cidades cadastradas no sistema" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select cod_moeda,
				   moeda,
				   descricao_moeda,
				   pais,
				   tipo
			  from finan.v$moeda_bacen		
			 order by cod_moeda 
		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>
	<!--- 
	-- PROPSITO
	-- Lista de Moedas cadastradas com a cotao do BACEN
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 09/06/2006 - criado
	--->	
	<cffunction name="get_moeda_cotacao" displayname="Retorna as cidades cadastradas no sistema" access="remote" returntype="query" output="true">
		<cfargument name="cod_moeda"   required="no" default="220" />
		<cfargument name="cod_moeda_conversao"   required="no" default="220" />
		<cfargument name="data_inicio" required="no" default="#DateFormat(DateAdd('d',-120,Now()),'dd/mm/yyyy')#" />
		<cfargument name="data_fim"    required="no" default="#DateFormat(Now(),'dd/mm/yyyy')#" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select t.cod_moeda, t.moeda, 
				   to_char(t.data_cotacao,'dd/mm') as data_cotacao, t.taxa_compra, t.taxa_venda
			  from finan.v$moeda_bacen_cotacao t
			 where cod_moeda = #arguments.COD_MOEDA#
               and cod_moeda_conversao = #arguments.cod_moeda_conversao#
			   and t.data_cotacao between '#arguments.DATA_INICIO#' and '#arguments.DATA_FIM#'
			order by to_char(t.data_cotacao,'yyyymmdd')
		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>				

	<!--- 
	-- PROPSITO
	-- Lista de CRTs vinculados ao contas a receber
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 04/01/2007 - criado
	--->	
	<cffunction name="get_intc_conhecimento_cr" displayname="Lista de CRTs vinculados ao contas a receber" access="remote" returntype="query" output="true">
		<cfargument name="data_inicial" required="no" default="" />
		<cfargument name="data_final" required="no" default="" />
		<cfargument name="data_inicial_fatura" required="no" default="" />
		<cfargument name="data_final_fatura" required="no" default="" />
		<cfargument name="faturado" required="no" default="" />
		<cfargument name="cod_pais" required="no" default="" />
		<cfargument name="num_crt" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select a.*, 
			       nvl(sum(valor_docto) over(),0) as total_receber,
			       nvl(sum(valor_docto + juros_correcoes) over(partition by a.num_docto order by a.num_docto),0) as total_receber_total,
			       nvl(sum(total_crt_rs) over(),0) as total_crt,
			       nvl(sum(total_crt_uss) over(),0) as total_uss,
			       nvl(count(*) over(),0) as numero_total_crts
			  from (
						select fcr.num_docto, fcr.data_emissao, 
								 fcr.data_vencto, 
								 nvl(fcr.valor_docto,0) as valor_docto, 
								 fcr.cod_moeda,
								 mbf.moeda,
								 nvl(fcr.valor_docto_moeda,0) as valor_docto_moeda, 
								 nvl((select sum(fccrj.valor_juro)
										  from finan.v$finan_contas_receber_juro fccrj
										 where fccrj.contas_receber_id = fcr.CONTAS_RECEBER_ID),0) as juros_correcoes,
								 round(fcr.variacao_cambial,3) as variacao_cambial, 
								 fcr.cc_favorecido, 
								 nvl(pf.razao_social,'-- NO FATURADO --') as cliente,
								 fcr.situacao,c.numero_cod_pais,
								 c.numero_cod_pais || '.' || c.numero_certificado || '.' || replace(replace(to_char(c.numero_sequencial, '000,000'), ',', '.'), ' ', '') as numero_crt,
								 c.emissao_data, c.cotacao,
									case 
									  when c.pago_por = 1 then 'CRT de amostra'
									  when c.pago_por = 2 then c.rem_nome
									  when c.pago_por = 3 then c.dest_nome
									  when c.pago_por = 4 then c.rem_nome || '/' || c.dest_nome
									end pagador,	                                                     
								 total_custo_origem,
								 (select moeda from oper.v$moeda_bacen where cod_moeda = total_custo_origem_cod_moeda) as total_custo_origem_cod_moeda,
								 total_custo_destino,
								 (select moeda from oper.v$moeda_bacen where cod_moeda = total_custo_destino_cod_moeda) as total_custo_destino_cod_moeda,
								 nvl(
								 case 
								  when c.pago_por = 1 then total_custo_origem + total_custo_destino
								  when c.pago_por = 2 then total_custo_origem + total_custo_destino
								  when c.pago_por = 3 then total_custo_origem + total_custo_destino
								  when c.pago_por = 4 and fcr.cod_pessoa = c.cod_remetente then c.total_custo_origem 
								  when c.pago_por = 4 and fcr.cod_pessoa = c.cod_destinatario then c.total_custo_destino 
								 end,0) total_crt_uss,
								 nvl(

								 case 
								  when c.pago_por = 1 then round((total_custo_origem + total_custo_destino) * c.cotacao,3)
								  when c.pago_por = 2 then round((total_custo_origem + total_custo_destino) * c.cotacao,3)
								  when c.pago_por = 3 then round((total_custo_origem + total_custo_destino) * c.cotacao,3)
								  when c.pago_por = 4 and fcr.cod_pessoa = c.cod_remetente then round(total_custo_origem * c.cotacao,3)
								  when c.pago_por = 4 and fcr.cod_pessoa = c.cod_destinatario then round(total_custo_destino * c.cotacao,3)
								 end,0) total_crt_rs,
								  (select kss.fnc_concat_all(kss.to_concat_expr(f.num_fatura, '/'))
										 from fiscal.v$intc_fatura f
									inner join fiscal.v$intc_fatura_item ifa
												 on ifa.fatura_id = f.fatura_id
									  where ifa.conhecimento_id = c.conhecimento_id) as num_factura,					
									(select max(f.data_emissao)
										from fiscal.v$intc_fatura f
									  inner join fiscal.v$intc_fatura_item ifa
												 on ifa.fatura_id = f.fatura_id
											 where ifa.conhecimento_id = c.conhecimento_id) as data_factura           
						  from fiscal.v$intc_conhecimento c
						 left join fiscal.v$intc_conhecimento_receber icr
									on c.conhecimento_id = icr.conhecimento_id
						 left join finan.v$finan_contas_receber fcr
									on fcr.contas_receber_id = icr.contas_receber_id
						 left join kss.v$pessoa pf
									on pf.cod_pessoa = fcr.cod_pessoa         
						 left join finan.v$moeda_bacen mbf
									on mbf.cod_moeda = fcr.cod_moeda
						where 1=1
						) a         
				   where 1=1
					<cfif Len(Trim(arguments.NUM_CRT))>
						and a.numero_crt = '#arguments.NUM_CRT#'
					</cfif>
					<cfif Len(Trim(arguments.COD_PAIS))>
						and a.numero_cod_pais = '#arguments.COD_PAIS#'
					</cfif>
					<cfif Len(Trim(arguments.COD_PAIS))>
						and a.numero_cod_pais = '#arguments.COD_PAIS#'
					</cfif>
					<cfif Len(Trim(arguments.DATA_INICIAL))>
						and a.emissao_data between '#arguments.DATA_INICIAL#' and '#arguments.DATA_FINAL#'
					</cfif>
					<cfif Len(Trim(arguments.DATA_INICIAL_FATURA))>
						and a.data_emissao between '#arguments.DATA_INICIAL_FATURA#' and '#arguments.DATA_FINAL_FATURA#'
					</cfif>
					<cfif Len(Trim(arguments.FATURADO)) and arguments.FATURADO eq 0>
						and a.num_docto is null
					<cfelseif Len(Trim(arguments.FATURADO)) and arguments.FATURADO eq 1>
						and a.num_docto is not null
					</cfif>
				  order by a.numero_crt, a.emissao_data 
		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>				

	<!--- 
	-- PROPSITO
	-- Lista os conhecimentos internacionais
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 02/12/2005 - criado
	--->	
	<cffunction name="get_intc_conhecimento" displayname="Lista os conhecimentos internacionais" access="remote" returntype="query" output="true">
		<cfargument name="conhecimento_id" required="no" default="">
		<cfargument name="cod_pessoa_filial" required="no" default="">
		<cfargument name="cod_centro_custo" required="no" default="">
		<cfargument name="data_inicio" required="no" default="">
		<cfargument name="data_fim" required="no" default="">
		<cfargument name="data_inicio_primeiro_embarque" required="no" default="">
		<cfargument name="data_fim_primeiro_embarque" required="no" default="">
		<cfargument name="faturar" required="no" default="">
		<cfargument name="cancelado" required="no" default="">
		<cfargument name="lib_fatura" required="no" default="">
		<cfargument name="nao_embarcado" required="no" default="">
		<cfargument name="quitado" required="no" default="">
		<cfargument name="pre_conhecimento" required="no" default="">
		<cfargument name="cod_pessoa_pagador" required="no" default="">
		<cfargument name="numero" required="no" default="">
		<cfargument name="conferido" required="no" default="">
		<cfargument name="data_inicio_lib_fatura" required="no" default="">
		<cfargument name="data_fim_lib_fatura" required="no" default="">
        <cfargument name="cod_organizacional" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
            select c.conhecimento_id,
                   versao,
                   numero_cod_pais,
                   numero_certificado,
                   numero_sequencial,
                   upper(numero_cod_pais || '.' || numero_certificado || '.' ||
                         replace(to_char(numero_sequencial, '000000'), ' ', '')) as numero,
                   cod_pessoa_filial,
                   emissao_local,
                   emissao_municipio_id,
                   emissao_data,
                   case
                     when pago_por = 1 then
                      'CRT de amostra'
                     when pago_por = 2 then
                      rem_nome
                     when pago_por = 3 then
                      dest_nome
                     when pago_por = 4 then
                      rem_nome || '/' || dest_nome
                   end pagador,
                   resp_local,
                   resp_municipio_id,
                   resp_data,
                   entrega_local,
                   entrega_municipio_id,
                   entrega_data,
                   transp_sucessivos,
                   cod_remetente,
                   rem_nome,
                   rem_endereco,
                   rem_cidade,
                   rem_uf,
                   rem_pais,
                   rem_cnpj_cpf,
                   cod_destinatario,
                   dest_nome,
                   dest_endereco,
                   dest_cidade,
                   dest_uf,
                   dest_pais,
                   dest_cnpj_cpf,
                   cod_consignatario,
                   cons_nome,
                   cons_endereco,
                   cons_cidade,
                   cons_uf,
                   cons_pais,
                   cons_cnpj_cpf,
                   cod_notificar,
                   not_endereco,
                   not_cidade,
                   not_uf,
                   not_pais,
                   not_cnpj_cpf,
                   mercadorias,
                   num_especie,
                   quantidade_total,
                   peso_bruto,
                   peso_liquido,
                   unidade_id,
                   m3,
                   valor_total,
                   (select moeda
                      from finan.v$moeda_bacen
                     where cod_moeda = valor_total_cod_moeda) as valor_total_cod_moeda,
                   valor_total_incoterm_id,
                   total_custo_origem,
                   (select moeda
                      from finan.v$moeda_bacen
                     where cod_moeda = total_custo_origem_cod_moeda) as total_custo_origem_cod_moeda,
                   total_custo_destino,
                   (select moeda
                      from finan.v$moeda_bacen
                     where cod_moeda = total_custo_destino_cod_moeda) as total_custo_destino_cod_moeda,
                   valor_frt_externo,
                   valor_frt_externo_cod_moeda,
                   valor_reembolso,
                   valor_reembolso_cod_moeda,
                   valor_mercadorias,
                   valor_mercadorias_cod_moeda,
                   alfandega_origem_id,
                   alfandega_destino_id,
                   pago_por,
                   declaracao_observacao,
                   impresso,
                   cancelado,
                   liberado_fatura,
                   case
                      when exists (select 1
                                     from fiscal.v$intc_conhecimento_receber cr
                                    where cr.conhecimento_id = c.conhecimento_id) then 1
                      else 0
                   end as faturado,
                   quitado,
                   (select fcr.num_docto
                      from fiscal.v$intc_conhecimento_receber cr
                     inner join finan.v$finan_contas_receber fcr
                             on fcr.contas_receber_id = cr.contas_receber_id
                     where cr.conhecimento_id = c.conhecimento_id) as num_fatura,
                   qtde_veiculos,
                   c.obs_pago_por,
                   seguro_pago_empresa,
                   nvl(c.cotacao, 0) as cotacao,
                   c.cod_organograma,
                   o.cod_centro_custo,
                   cce.centro_custo,
                   c.conferido as conferido,
                   (select min(im.data_emissao)
                      from fiscal.v$intc_manifesto im
                     inner join fiscal.v$intc_manifesto_crt imc on imc.manifesto_id =
                                                                   im.manifesto_id
                     where imc.conhecimento_id = c.conhecimento_id) as primeiro_embarque,
                   c.data_lib_fatura,
                   c.data_entrega,
                   (select max(r.descricao_rota) keep(dense_rank first order by r.origem_cod_pessoa nulls last, r.destino_cod_pessoa nulls last)
                      from fiscal.v$intc_conhecimento c2
                     inner join cep.municipio mo
                             on mo.municipio_id = c2.resp_municipio_id
                     inner join cep.municipio md
                             on md.municipio_id = c2.entrega_municipio_id
                     inner join oper.v$rota r
                             on r.referencia_origem_id = mo.referencia_id
                            and r.referencia_destino_id = md.referencia_id
                            and (r.origem_cod_pessoa = c2.cod_remetente or r.origem_cod_pessoa is null)
                            and (r.destino_cod_pessoa = c2.cod_destinatario or r.destino_cod_pessoa is null)
                     where c2.conhecimento_id = c.conhecimento_id
                   ) as descricao_rota,
                   (select max(r.abreviatura) keep(dense_rank first order by r.origem_cod_pessoa nulls last, r.destino_cod_pessoa nulls last)
                      from fiscal.v$intc_conhecimento c2
                     inner join cep.municipio mo
                             on mo.municipio_id = c2.resp_municipio_id
                     inner join cep.municipio md
                             on md.municipio_id = c2.entrega_municipio_id
                     inner join oper.v$rota r
                             on r.referencia_origem_id = mo.referencia_id
                            and r.referencia_destino_id = md.referencia_id
                            and (r.origem_cod_pessoa = c2.cod_remetente or r.origem_cod_pessoa is null)
                            and (r.destino_cod_pessoa = c2.cod_destinatario or r.destino_cod_pessoa is null)
                     where c2.conhecimento_id = c.conhecimento_id
                   ) as abreviatura_rota,
                   (select max(r.distancia_padrao) keep(dense_rank first order by r.origem_cod_pessoa nulls last, r.destino_cod_pessoa nulls last)
                      from fiscal.v$intc_conhecimento c2
                     inner join cep.municipio mo
                             on mo.municipio_id = c2.resp_municipio_id
                     inner join cep.municipio md
                             on md.municipio_id = c2.entrega_municipio_id
                     inner join oper.v$rota r
                             on r.referencia_origem_id = mo.referencia_id
                            and r.referencia_destino_id = md.referencia_id
                            and (r.origem_cod_pessoa = c2.cod_remetente or r.origem_cod_pessoa is null)
                            and (r.destino_cod_pessoa = c2.cod_destinatario or r.destino_cod_pessoa is null)
                     where c2.conhecimento_id = c.conhecimento_id
                   ) as distancia_padrao,
                   c.cod_pagador_origem,
                   c.pag_origem_nome,
                   c.pag_origem_endereco,
                   c.pag_origem_cidade,
                   c.pag_origem_uf,
                   c.pag_origem_pais,
                   c.pag_origem_cnpj_cpf,
                   c.cod_pagador_destino,
                   c.pag_destino_nome,
                   c.pag_destino_endereco,
                   c.pag_destino_cidade,
                   c.pag_destino_uf,
                   c.pag_destino_pais,
                   c.pag_destino_cnpj_cpf,
                   c.embarcado,
                   decode(c.embarcado,
                          0,
                          null,
                          to_char(c.data_ult_embarque, 'dd/mm/yyyy')) as data_embarque,
                   c.pre_conhecimento,
                   (select sign(count(1))
                      from fiscal.v$intc_crt_comercial_versao ccv
                     where ccv.conhecimento_id = c.conhecimento_id) as possui_tabela_frete,
                   (select descricao
                      from kss.v$organizacional o
                     where o.organizacional_id = c.organizacional_id) as centro_custo_gerencial
              from fiscal.v$intc_conhecimento c
              left join kss.v$organograma o
              		 on o.cod_organograma = c.cod_organograma
              left join kss.v$centro_custo cce
              		 on cce.cod_centro_custo = o.cod_centro_custo
			 <cfif Len(Trim(arguments.cod_pessoa_pagador))>
			 inner join fiscal.v$intc_conhecimento_custo cc
					 on cc.conhecimento_id = c.conhecimento_id 
			 </cfif>			 
			 where 1=1
             <cfif Len(Trim(arguments.cod_organizacional))>
			   and c.cod_organizacional = '#arguments.cod_organizacional#'
			 </cfif>
			 <cfif Len(Trim(arguments.DATA_INICIO_PRIMEIRO_EMBARQUE)) and Len(Trim(arguments.DATA_FIM_PRIMEIRO_EMBARQUE))>
				and c.data_ult_embarque between '#arguments.DATA_INICIO_PRIMEIRO_EMBARQUE#' and '#arguments.DATA_FIM_PRIMEIRO_EMBARQUE#'
			 </cfif>
			 <cfif Len(Trim(arguments.NAO_EMBARCADO))>
				and (c.embarcado = 0 or c.data_ult_embarque > to_date('#arguments.data_fim#','dd/mm/yyyy'))
			 </cfif>
			 <cfif Len(Trim(arguments.cod_centro_custo))>
			   and kss.to_organograma(c.cod_organograma).cod_centro_custo = #arguments.cod_centro_custo#
			 </cfif>
			 <cfif Len(Trim(arguments.cod_pessoa_pagador))>
			   and case
					 when pago_por = 2 then cod_remetente
					 when pago_por = 3 then cod_destinatario
					 when pago_por = 4 and nvl(cc.valor_origem,0) > 0 then c.cod_remetente
					 when pago_por = 4 and nvl(cc.valor_destino,0) > 0 then c.cod_destinatario
				   end = #arguments.cod_pessoa_pagador#
			 </cfif>
			 <cfif Len(Trim(arguments.numero))>
			   and upper(numero_cod_pais||'.'||numero_certificado||'.'||replace(to_char(numero_sequencial, '000000'), ' ', '')) = upper('#arguments.numero#')
			 </cfif>
			 <cfif Len(Trim(arguments.conhecimento_id))>
			   and c.conhecimento_id in (#arguments.conhecimento_id#)
			 </cfif>
			 <cfif Len(Trim(arguments.cod_pessoa_filial))>
			   and c.cod_pessoa_filial = #arguments.cod_pessoa_filial#
			 </cfif>
			 <cfif Len(Trim(arguments.faturar))>
			   and c.faturado = 0
			   and c.cancelado = 0
			 </cfif>
			 <cfif Len(Trim(arguments.cancelado))>
			   and c.cancelado = #arguments.cancelado#
    		 <cfelse>
			   and c.cancelado = 0
			 </cfif>
			 <cfif Len(Trim(arguments.lib_fatura))>
			   and c.liberado_fatura in (#arguments.lib_fatura#)
			 </cfif>
			 <cfif Len(Trim(arguments.quitado))>
			   and c.quitado = #arguments.quitado#
			 </cfif>
			 <cfif Len(Trim(arguments.conferido))>
			   and c.conferido = #arguments.conferido#
			 </cfif>
			 <cfif Len(Trim(arguments.pre_conhecimento))>
			   and c.pre_conhecimento = #arguments.pre_conhecimento#
    		 <cfelse>
			   and c.pre_conhecimento = 0
			 </cfif>
    
			 <cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_fim))>
			   and to_date(to_char(c.emissao_data,'dd/mm/yyyy'),'dd/mm/yyyy') between to_date('#arguments.data_inicio#','dd/mm/yyyy') and to_date('#arguments.data_fim#','dd/mm/yyyy')
			 </cfif>
			 <cfif Len(Trim(arguments.data_inicio_lib_fatura)) and Len(Trim(arguments.data_fim_lib_fatura))>
			   and to_date(to_char(c.data_lib_fatura,'dd/mm/yyyy'),'dd/mm/yyyy') between to_date('#arguments.data_inicio_lib_fatura#','dd/mm/yyyy') and to_date('#arguments.data_fim_lib_fatura#','dd/mm/yyyy')
			 </cfif>
			 order by c.numero_cod_pais, c.numero_certificado, c.numero_sequencial  
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>		
	
	<!--- 
	-- PROPSITO
	-- Lista os conhecimentos internacionais
	-- NOTAS EXPLICATIVAS
	--  
	-- LOUIS 27/03/2007 - criado
	--->	
	<cffunction name="get_intc_fretes" displayname="Relatrios de fretes internacionais" access="remote" returntype="query" output="true">
		<cfargument name="data_inicio" required="no" default="">
		<cfargument name="data_fim" required="no" default="">
		<cfargument name="data_inicio_embarque" required="no" default="">
		<cfargument name="data_fim_embaque" required="no" default="">
		<cfargument name="VALOR_KM_FROTA" required="no" default="">
		<cfargument name="VALOR_DIARIA_FROTA" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
             select conhecimento_id, numero, manifesto_id, numero_mic, emissao_data, resp_data, data_entrega, emissao_local
             	    ,peso_bruto/num_mics as peso_bruto
                    ,valor_total_cod_moeda
                    ,round(valor_total/num_mics,2) as valor_total
                    ,total_custo_origem_cod_moeda
                    ,total_custo_destino_cod_moeda
                    ,total_custo_origem/num_mics as total_custo_origem
                    ,total_custo_destino/num_mics as total_custo_destino
                    ,nvl(cotacao,0) as cotacao, rem_nome, dest_nome, pagador, km, frota, modalidade, embarcado,
                    (sum((total_custo_origem+total_custo_destino)*nvl(cotacao,0)) over())/num_mics as total_receita_reais,
                    ((total_custo_origem+total_custo_destino)*nvl(cotacao,0))/num_mics total_receita,
                    diarias, 
                    case 
                      when num_mics = 1 and num_crts > 1 then nvl(round(nvl(custo,0)/num_crts,2),0)
                      when num_mics > 1 and num_crts = 1 then nvl(round(nvl(custo,0)/num_mics,2),0)
                      when num_mics > 1 and num_crts > 1 then nvl(round(nvl(custo,0)/num_crts,2),0)
                      when num_mics = 1 and num_crts = 1 then nvl(round(custo,2),0)
                    end custo,
                    num_romaneio, descricao_rota, abreviatura_rota, distancia_padrao, resp_local, entrega_local, num_mics
              from (
                    select c.conhecimento_id, upper(c.numero_cod_pais || '.' || c.numero_certificado || '.' || replace(to_char(c.numero_sequencial, '000000'), ' ', '')) as numero,
                           im.manifesto_id, upper(im.numero_cod_pais || '.' || im.numero_certificado || '.' || replace(to_char(im.numero_sequencial, '000000'), ' ', '')) as numero_mic,
                           c.emissao_data,
                           c.emissao_local,
                           c.peso_bruto, c.data_entrega, c.resp_data,
                           c.valor_total,
                           (select moeda
                              from oper.v$moeda_bacen
                             where cod_moeda = valor_total_cod_moeda) as valor_total_cod_moeda,
                           (select moeda
                              from oper.v$moeda_bacen
                             where cod_moeda = total_custo_origem_cod_moeda) as total_custo_origem_cod_moeda,
                           (select moeda
                              from oper.v$moeda_bacen
                             where cod_moeda = total_custo_destino_cod_moeda) as total_custo_destino_cod_moeda,
                           c.total_custo_origem,
                           c.total_custo_destino,
                           c.cotacao,
                           c.rem_nome,
                           c.dest_nome,
                           c.embarcado,
                           case
                             when c.pago_por = 1 then
                              'CRT de amostra'
                             when c.pago_por = 2 then
                              c.rem_nome
                             when c.pago_por = 3 then
                              c.dest_nome
                             when c.pago_por = 4 then
                              c.rem_nome || '/' || c.dest_nome
                           end pagador,
                           decode(nvl(t.km_carregado, 0) + nvl(t.km_vazio, 0),0,r.distancia_padrao,nvl(t.km_carregado, 0) + nvl(t.km_vazio, 0)) as km,
                           nvl(oper.fnc_get_cod_veiculo(t.placa_controle),im.veic_orig_placa_controle) as frota,
                           oper.pkg_veiculo_dml.fnc_veiculo_get_atributo(im.veic_orig_placa_controle,'MODALIDADE') as modalidade,
                           nvl(round(nvl(t.data_termino, sysdate) - t.data_inicio),0) as diarias,
                           /*case
                             when oper.pkg_veiculo_dml.fnc_veiculo_get_atributo(im.veic_orig_placa_controle,'MODALIDADE') = 'AGREGADO' then
                                  nvl((select sum(ar.valor_frete_bruto)
                                     from oper.v$cfa ar
                                    where ar.num_romaneio = t.num_romaneio),0)
                           when oper.pkg_veiculo_dml.fnc_veiculo_get_atributo(im.veic_orig_placa_controle,'MODALIDADE') = 'TERCEIRO' then
                              (select sum(itd.valor_servico)
                               from fiscal.v$intc_despacho itd
                              inner join fiscal.v$intc_despacho_item idi
                                  on idi.despacho_id = itd.despacho_id
                                   and itd.cancelado = 0
                              where idi.conhecimento_id = c.conhecimento_id)
                           when oper.pkg_veiculo_dml.fnc_veiculo_get_atributo(im.veic_orig_placa_controle,'MODALIDADE') = 'FROTA' then
                              (#arguments.VALOR_KM_FROTA# * decode(nvl(t.km_carregado, 0) + nvl(t.km_vazio, 0),0,r.distancia_padrao,nvl(t.km_carregado, 0) + nvl(t.km_vazio, 0))) + (#arguments.VALOR_DIARIA_FROTA# *nvl(round(nvl(t.data_termino, sysdate) - t.data_inicio),0))
                           end custo*/
                           fiscal.pkg_transp_internacional.fnc_custo_crt(c.conhecimento_id) as custo
                           , t.num_romaneio,
                           r.descricao_rota, r.abreviatura as abreviatura_rota, r.distancia_padrao,
                           c.resp_local, c.entrega_local,
                           count(*) over(partition by ic.conhecimento_id order by ic.conhecimento_id) as num_mics,
                           (select count(*) 
                              from fiscal.v$intc_manifesto_crt_item t
                            where t.manifesto_id = im.manifesto_id) as num_crts
                    from fiscal.v$intc_manifesto im 
                   inner join fiscal.v$intc_manifesto_crt ic 
                       on ic.manifesto_id = im.manifesto_id
                   inner join fiscal.v$intc_conhecimento c 
                       on c.conhecimento_id = ic.conhecimento_id
                   left join oper.v$romaneio_item it 
                       on it.num_romaneio = im.num_romaneio
                      and it.item_id = im.item_id
                   left join oper.v$romaneio t
                       on it.num_romaneio = t.num_romaneio
                   left join kss.v$pessoa p 
                       on p.cod_pessoa = t.cod_pessoa_filial
                   left join oper.v$lote l  
                       on l.num_lote = it.num_lote
                      and l.internacional = 1
                   left join oper.v$rota r
                      on r.origem_municipio_id = c.resp_municipio_id
                       and r.destino_municipio_id = c.entrega_municipio_id			           
                   where 1 = 1 
                   <cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_fim))>
                       and c.emissao_data between '#arguments.data_inicio#' and '#arguments.data_fim#'
                   </cfif>
                   <cfif Len(Trim(arguments.data_inicio_embarque)) and Len(Trim(arguments.data_fim_embarque))>
                       and c.data_ult_embarque between '#arguments.data_inicio_embarque#' and '#arguments.data_fim_embarque#'
                   </cfif>
                   order by c.emissao_data)
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna o detalhamento de um custo de um frete
    -- ANDERSON 23/02/2010 - CRIADO
    --->		
    <cffunction name="get_detalhamento_custo_frete" access="remote" returntype="query" output="true">
        <cfargument name="conhecimento_id" required="yes">
        <cfargument name="manifesto_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.placa_controle
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(t.placa_controle) as cod_veiculo_controle
                 , t.placa_referencia
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(t.placa_referencia) as cod_veiculo_referencia
                 , t.documento
                 , t.num_documento
                 , case
                      when t.num_mics = 1 and t.num_crts > 1 then
                         nvl(round(nvl(t.valor_custo_crt, 0) / t.num_crts, 2), 0)
                      when t.num_mics > 1 and t.num_crts = 1 then
                         nvl(round(nvl(t.valor_custo_crt, 0) / t.num_mics, 2), 0)
                      when t.num_mics > 1 and t.num_crts > 1 then
                         nvl(round(nvl(t.valor_custo_crt, 0) / t.num_crts, 2), 0)
                      when t.num_mics = 1 and t.num_crts = 1 then
                         nvl(round(t.valor_custo_crt, 2), 0)
                   end as valor
                 , t.rota
                 , t.carregamento
                 , t.destino
              from (
                    select rhv.placa_controle
                         , rhv.placa_referencia
                         , null as documento
                         , null as num_documento
                         , (nvl(r.km_vazio, 0) + nvl(r.km_carregado, 0)) *
                           nvl((select min(cp.custo_km) keep(dense_rank last order by cp.data_inicio)
                                  from oper.v$custo_padrao cp
                                 where cp.centro_custo = cc.cod_centro_custo
                                   and cp.data_inicio <= trunc(c.data_ult_embarque)), 0) as valor_custo_crt
                         , (select rt.abreviatura
                              from oper.v$rota rt
                             where rt.origem_municipio_id = r.org_municipio_id
                               and rt.destino_municipio_id = r.dest_municipio_id) as rota
                         , r.carregamento
                         , r.destino
                         , (select count(*)
                              from fiscal.v$intc_manifesto_crt mc
                             where mc.conhecimento_id = c.conhecimento_id) as num_mics
                         , (select count(*)
                              from fiscal.v$intc_manifesto_crt_item mci
                             where mci.manifesto_id = #arguments.manifesto_id#) as num_crts
                      from fiscal.v$intc_conhecimento c
                     inner join oper.v$romaneio_intc_conhecimento rc
                             on rc.conhecimento_id = c.conhecimento_id 
                     inner join oper.v$romaneio r
                             on r.num_romaneio = rc.num_romaneio
                     inner join oper.v$romaneio_hist_veiculo rhv
                             on rhv.num_romaneio = rc.num_romaneio
                            and rhv.data_inicio = (select min(rhv2.data_inicio)
                                                     from oper.v$romaneio_hist_veiculo rhv2
                                                    where rhv2.num_romaneio = rhv.num_romaneio)
                     inner join oper.v$veiculo_ccusto_atual cc
                             on cc.placa = rhv.placa_referencia
                     where c.pre_conhecimento = 0
                       and c.cancelado = 0
                       and oper.pkg_veiculo.fnc_veiculo_proprietario(rhv.placa_controle) = 1
                       and c.conhecimento_id = #arguments.conhecimento_id#
                    
                    union all
                    
                    select rhv.placa_controle
                         , rhv.placa_referencia
                         , 'PS' as documento
                         , ar.ps_id as num_documento
                         , nvl(ar.valor_servico, 0) as valor_custo_crt
                         , (select rt.abreviatura
                              from oper.v$rota rt
                             where rt.origem_municipio_id = r.org_municipio_id
                               and rt.destino_municipio_id = r.dest_municipio_id) as rota
                         , r.carregamento
                         , r.destino
                         , (select count(*)
                              from fiscal.v$intc_manifesto_crt mc
                             where mc.conhecimento_id = c.conhecimento_id) as num_mics
                         , (select count(*)
                              from fiscal.v$intc_manifesto_crt_item mci
                             where mci.manifesto_id = #arguments.manifesto_id#) as num_crts
                      from fiscal.v$intc_conhecimento c
                     inner join oper.v$romaneio_intc_conhecimento rc
                             on rc.conhecimento_id = c.conhecimento_id
                     inner join oper.v$romaneio r
                             on r.num_romaneio = rc.num_romaneio
                     inner join oper.v$romaneio_hist_veiculo rhv
                             on rhv.num_romaneio = rc.num_romaneio
                            and rhv.data_inicio = (select min(rhv2.data_inicio)
                                                     from oper.v$romaneio_hist_veiculo rhv2
                                                    where rhv2.num_romaneio = rhv.num_romaneio)  
                     inner join oper.v$agregado_romaneio ar
                             on ar.num_romaneio = rc.num_romaneio
                     inner join oper.v$agregado_fechamento af
                             on af.fechamento_id = ar.fechamento_id
                     where c.pre_conhecimento = 0
                       and ar.data_cancelamento is null
                       and c.conhecimento_id = #arguments.conhecimento_id#
                    
                    union all
                    
                    select rhv.placa_controle
                         , rhv.placa_referencia
                         , 'CFA' as documento
                         , v.lancto_id as num_documento
                         , nvl(v.valor_servico + v.tx_inss_empresa_valor, 0) as valor_custo_crt
                         , (select rt.abreviatura
                              from oper.v$rota rt
                             where rt.origem_municipio_id = v.municipio_id_origem
                               and rt.destino_municipio_id = v.municipio_id_destino) as rota
                         , (select m.municipio || '/' || m.uf_id
                              from cep.municipio m
                             where m.municipio_id = v.municipio_id_origem) as carregamento
                         , (select m.municipio || '/' || m.uf_id
                              from cep.municipio m
                             where m.municipio_id = v.municipio_id_destino) as destino
                         , (select count(*)
                              from fiscal.v$intc_manifesto_crt mc
                             where mc.conhecimento_id = c.conhecimento_id) as num_mics
                         , (select count(*)
                              from fiscal.v$intc_manifesto_crt_item mci
                             where mci.manifesto_id = #arguments.manifesto_id#) as num_crts
                      from fiscal.v$intc_conhecimento c
                     inner join oper.v$romaneio_intc_conhecimento rc
                             on rc.conhecimento_id = c.conhecimento_id
                     inner join oper.v$romaneio r
                             on r.num_romaneio = rc.num_romaneio
                     inner join oper.v$romaneio_hist_veiculo rhv
                             on rhv.num_romaneio = rc.num_romaneio
                            and rhv.data_inicio = (select min(rhv2.data_inicio)
                                                     from oper.v$romaneio_hist_veiculo rhv2
                                                    where rhv2.num_romaneio = rhv.num_romaneio)
                     inner join oper.v$agreg_viagem v
                             on v.num_romaneio = rc.num_romaneio
                     where c.pre_conhecimento = 0
                       and v.data_cancelamento is null
                       and c.conhecimento_id = #arguments.conhecimento_id#
                    
                    union all
                    
                    select d.placa_tracao as placa_controle
                         , d.placa_reboque as placa_referencia
                         , 'DTI' as documento
                         , d.num_despacho as num_documento
                         , nvl(nvl(d.valor_servico, 0) +
                               case
                                  when nvl((select p.tipo_pessoa
                                              from kss.v$pessoa p
                                             where p.cod_pessoa = d.cod_proprietario), 0) = 1 then
                                     nvl(((nvl(d.valor_servico, 0) *
                                           (select min(ie.aliquota)
                                              from rh.v$rh_inss_empregador ie
                                             where ie.limite >= nvl(d.valor_servico, 0)
                                               and ie.data_vigencia <= trunc(c.data_ult_embarque)) / 100
                                          ) * 20 / 100
                                         ), 0)
                                  else 0
                               end, 0) as valor_custo_crt
                         , (select rt.abreviatura
                              from oper.v$rota rt
                             where rt.origem_municipio_id = d.origem_municipio_id
                               and rt.destino_municipio_id = d.destino_municipio_id) as rota
                         , (select m.municipio || '/' || m.uf_id
                              from cep.municipio m
                             where m.municipio_id = d.origem_municipio_id) as carregamento
                         , (select m.municipio || '/' || m.uf_id
                              from cep.municipio m
                             where m.municipio_id = d.destino_municipio_id) as destino
                         , (select count(*)
                              from fiscal.v$intc_manifesto_crt mc
                             where mc.conhecimento_id = c.conhecimento_id) as num_mics
                         , (select count(*)
                              from fiscal.v$intc_manifesto_crt_item mci
                             where mci.manifesto_id = #arguments.manifesto_id#) as num_crts
                      from fiscal.v$intc_conhecimento c
                     inner join fiscal.v$intc_despacho_item di
                             on di.conhecimento_id = c.conhecimento_id
                     inner join fiscal.v$intc_despacho d
                             on d.despacho_id = di.despacho_id
                     where d.cancelado = 0
                       and c.conhecimento_id = #arguments.conhecimento_id#
                   ) t
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
	
	<!--- 
	-- PROPSITO
	-- Lista os clientes com CRTs a pagar
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 02/12/2005 - criado
	--->	
	<cffunction name="get_intc_conhecimento_pagador" displayname="Lista os conhecimentos internacionais" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" required="no" default="">
		<cfargument name="data_inicio" required="no" default="">
		<cfargument name="data_fim" required="no" default="">
		<cfargument name="quitado" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select distinct c.cod_pessoa_filial,
				  case
					 when c.pago_por = 2 then c.rem_nome || '(' || oper.pkg_global.fnc_mascara_cnpj_cpf(c.cod_remetente) || ')'
					 when c.pago_por = 3 then c.dest_nome || '(' || oper.pkg_global.fnc_mascara_cnpj_cpf(c.cod_destinatario) || ')'
					 when c.pago_por = 4 and nvl(cc.valor_origem,0) > 0 then c.rem_nome || '(' || oper.pkg_global.fnc_mascara_cnpj_cpf(c.cod_remetente) || ')'
					 when c.pago_por = 4 and nvl(cc.valor_destino,0) > 0 then c.dest_nome || '(' || oper.pkg_global.fnc_mascara_cnpj_cpf(c.cod_destinatario) || ')'
				   end pagador,
				  case
					 when c.pago_por = 2 then c.cod_remetente
					 when c.pago_por = 3 then c.cod_destinatario
					 when c.pago_por = 4 and nvl(cc.valor_origem,0) > 0 then c.cod_remetente
					 when c.pago_por = 4 and nvl(cc.valor_destino,0) > 0 then c.cod_destinatario
				   end cod_pessoa_pagador
			  from fiscal.v$intc_conhecimento c
			 inner join fiscal.v$intc_conhecimento_custo cc
					 on cc.conhecimento_id = c.conhecimento_id 
			 where c.pago_por <> 1
 			 <cfif Len(Trim(arguments.cod_pessoa_filial))>
			   and c.cod_pessoa_filial = #arguments.cod_pessoa_filial#
			 </cfif>
			 <cfif len(trim(arguments.quitado))>
			 	and c.quitado = #arguments.quitado#
			 </cfif>
			 <cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_fim))>
			   and c.emissao_data between '#arguments.data_inicio#' and '#arguments.data_fim#'
			 </cfif>
			 order by pagador
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Lista os CRTs para faturamento de um cliente
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 02/12/2005 - criado
	--->	
	<cffunction name="get_intc_conhecimento_liberar_fatura" displayname="Lista os CRTs para faturamento de um cliente" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_cliente" required="no" default="">
		<cfargument name="lista_crt" required="no" default="">
		<cfargument name="fatura_id" required="no" default="">
		<cfargument name="numero_cod_pais" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select conhecimento_id, numero, emissao_data, origem, destino, pagador,
				   cod_pessoa_pagador, valor_total, cod_moeda, pago_por, fatura_emitida, fatura_id,
				   data_embarque
			  from fiscal.v$intc_conhecimento_lib_fatura
			 where 1=1
			 <cfif Len(Trim(arguments.cod_pessoa_cliente))>
			   and cod_pessoa_pagador = #arguments.cod_pessoa_cliente#
			 </cfif>
			 <cfif Len(Trim(arguments.lista_crt))>
			   and conhecimento_id in (#arguments.lista_crt#)
			 </cfif>
			 <cfif Len(Trim(arguments.numero_cod_pais))>
			   and numero_cod_pais = '#arguments.numero_cod_pais#'
			 </cfif>
			 <cfif Len(Trim(arguments.fatura_id))>
			   and fatura_id = #arguments.fatura_id#
			 </cfif>
			 order by pagador, numero 
   		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Lista os CRTs para faturamento de um cliente
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 16/07/2009 - ALTERADO
	--->	
	<cffunction name="get_intc_conhecimento_faturar" displayname="Lista os CRTs para faturamento de um cliente" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_cliente" required="no" default="">
		<cfargument name="lista_crt" required="no" default="">
		<cfargument name="fatura_id" required="no" default="">
		<cfargument name="internacional" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
            select icf.conhecimento_id
                 , icf.numero
                 , icf.emissao_data
                 , icf.origem
                 , icf.destino
                 , icf.pagador
                 , icf.cod_pessoa_pagador
                 , icf.valor_total
                 , icf.cod_moeda
                 , icf.pago_por
                 , icf.fatura_emitida
                 , icf.fatura_id
                 , icf.data_embarque
                 , icf.numero_cod_pais
                 , icr.icr.contas_receber_id
              from fiscal.v$intc_conhecimento_faturar icf
              left join fiscal.v$intc_conhecimento_receber icr
                     on icr.conhecimento_id = icf.conhecimento_id
              left join finan.v$finan_contas_receber fcr
                     on fcr.contas_receber_id = icr.contas_receber_id
                    and fcr.cod_pessoa = icf.cod_pessoa_pagador
             where 1 = 1
			<cfif Len(Trim(arguments.cod_pessoa_cliente))>
			   and icf.cod_pessoa_pagador = #arguments.cod_pessoa_cliente#
			</cfif>
			<cfif Len(Trim(arguments.lista_crt))>
			   and icf.conhecimento_id in (#arguments.lista_crt#)
			</cfif>
			<cfif Len(Trim(arguments.internacional))>
			   and (icf.numero_cod_pais = 'AR' or lower(icf.pag_pais) = 'argentina')
			</cfif>
			<cfif Len(Trim(arguments.fatura_id))>
			   and icf.fatura_id = #arguments.fatura_id#
			</cfif>
			 order by icf.pagador, icf.numero 
   		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>	
		
	<!--- 
	-- PROPSITO
	-- Lista os conhecimentos internacionais
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 02/12/2005 - criado
	--->	
	<cffunction name="get_cliente_filial" displayname="Lista os conhecimentos internacionais" access="remote" returntype="query" output="true">
		<cfargument name="nome" required="no" default="">
        <cfargument name="cnpj_cpf" required="no" default="">
		<cfargument name="filial" required="no" default="">
        <cfargument name="cod_pessoa" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select cod_pessoa,
				   razao_social,
				   identificador,
				   cnpj_cpf,
				   inscricao_estadual,
				   nome,
				   endereco,
				   bairro,
				   cep,
				   municipio,
				   uf,
				   municipio_id,
				   telefone,
				   municipio_uf,
				   pais_id,
				   pais,
				   filial
			  from (
                      select /*+ FIRST_ROWS */ p.cod_pessoa, p.tipo_pessoa, p.razao_social, p.cliente as nome, p.identificador,
                             decode(p.tipo_pessoa,2/*Estrangeira*/, pes.cod_cadastro_contribuinte, p.cnpj_cpf) as cnpj_cpf,
                             p.inscricao_estadual,
                             decode(p.tipo_pessoa,2/*Estrangeira*/, pes.endereco, pe.logradouro || decode(pe.numero, '', '', ', ') || pe.numero || decode(pe.complemento, '', '', ' - ') || pe.complemento) as endereco,
                             pe.bairro,
                             decode(p.tipo_pessoa,2/*Estrangeira*/, pes.codigo_postal, to_char(pe.cep)) as cep,
                             decode(p.tipo_pessoa,2/*Estrangeira*/, pes.municipio, pe.municipio) as municipio,
                             decode(p.tipo_pessoa,2/*Estrangeira*/, 'EX', pe.uf) as uf,
                             decode(p.tipo_pessoa,2/*Estrangeira*/, pes.municipio, pe.municipio) || decode(nvl(pe.uf,'EX'), 'EX', (select decode(pe.estado_provincia,null,'',' - ' || to_char(pe.estado_provincia)) from kss.v$pessoa_estrangeira pe where pe.cod_pessoa = p.cod_pessoa), ' - ' || pe.uf) municipio_uf,
                             decode(p.tipo_pessoa,2/*Estrangeira*/, pes.municipio_id, pe.municipio_id) as municipio_id,
                             decode(t.telefone_id, null, '', '(' || t.fone_ddd || ')' || t.fone_prefixo || '-' || t.fone_numero) telefone,
                             m.pais_id,
                             decode(p.tipo_pessoa,2/*Estrangeira*/, pes.pais,ps.descricao) as pais, 
                             0 as filial
                        from kss.v$pessoa p
                       inner join kss.v$pessoa_modalidade pm
                               on p.cod_pessoa = pm.cod_pessoa
                              and num_modalidade in (5, 13, 15)
                              and pm.situacao = 1
                        left join kss.v$pessoa_endereco pe
                               on pe.cod_pessoa = p.cod_pessoa
                              and pe.endereco_padrao = 1
                        left join kss.v$pessoa_estrangeira pes
                               on pes.cod_pessoa = p.cod_pessoa
                        left join kss.v$pessoa_telefone pt
                               on pt.cod_pessoa = p.cod_pessoa
                              and pt.telefone_padrao = 1
                        left join kss.v$telefone t
                               on t.telefone_id = pt.telefone_id
                        left join cep.municipio m
                               on m.municipio_id = pe.municipio_id
                        left join cep.pais ps
                               on ps.pais_id = m.pais_id
                      union all
                      select /*+ FIRST_ROWS */ p.cod_pessoa, p.tipo_pessoa, p.razao_social, p.cliente as nome, p.identificador,
                             p.cnpj_cpf,
                             p.inscricao_estadual,
                             pe.logradouro || decode(pe.numero, '', '', ', ')  || pe.numero || decode(pe.complemento, '', '', ' - ') || pe.complemento as endereco,
                             pe.bairro,
                             to_char(pe.cep) as cep,
                             pe.municipio, pe.uf,
                             pe.municipio || decode(pe.uf, 'EX', (select decode(pe.estado_provincia,null,'',' - ' || to_char(pe.estado_provincia)) from kss.v$pessoa_estrangeira pe where pe.cod_pessoa = p.cod_pessoa), ' - ' || pe.uf) municipio_uf,
                              pe.municipio_id,
                             decode(t.telefone_id, null, '', '(' || t.fone_ddd || ')' || t.fone_prefixo || '-' || t.fone_numero) telefone,
                             m.pais_id, ps.descricao as pais, 1 as filial
                        from kss.v$pessoa p
                       inner join kss.v$unidade_negocio un
                               on p.cod_pessoa = un.cod_pessoa
                        left join kss.v$pessoa_endereco pe
                               on pe.cod_pessoa = p.cod_pessoa
                              and pe.endereco_padrao = 1
                        left join kss.v$pessoa_telefone pt
                               on pt.cod_pessoa = p.cod_pessoa
                              and pt.telefone_padrao = 1
                        left join kss.v$telefone t
                               on t.telefone_id = pt.telefone_id
                        left join cep.municipio m
                               on m.municipio_id = pe.municipio_id
                        left join cep.pais ps
                               on ps.pais_id = m.pais_id
                      
              )	
			 where 1=1
			 <cfif len(trim(arguments.nome))>
			   and upper(razao_social) like upper('%#arguments.nome#%')
			 </cfif>
			 <cfif len(trim(arguments.cnpj_cpf))>
			   and cnpj_cpf = '#arguments.cnpj_cpf#'
			 </cfif>
  		      order by razao_social, municipio_uf			 
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>		


	<!--- 
	-- PROPSITO
	-- Lista os conhecimentos internacionais
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 02/12/2005 - criado
	--->	
	<cffunction name="get_filial" displayname="Lista os conhecimentos internacionais" access="remote" returntype="query" output="true">
		<cfargument name="nome" required="no" default="">
		<cfargument name="cod_empresa" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
        select t.cod_pessoa,
               t.razao_social,
               t.cliente as nome,
               t.identificador,
               t.cnpj_cpf,
               t.inscricao_estadual,
               t.endereco,
               t.bairro,
               t.cep,
               t.municipio,
               t.uf,
               t.municipio_uf,
               t.municipio_id,
               t.telefone,
               ps.pais_id,
               ps.descricao as pais
          from (select p.cod_pessoa,
                       p.razao_social,
                       p.cliente,
                       p.identificador,
                       p.cnpj_cpf,
                       p.inscricao_estadual,
                       decode(p.tipo_pessoa, 2 /*Estrangeira*/, pes.endereco, pe.logradouro || ', ' || pe.numero || ' - ' || pe.complemento) as endereco,
                       pe.bairro,
                       decode(p.tipo_pessoa, 2 /*Estrangeira*/, pes.codigo_postal, to_char(pe.cep)) as cep,
                       decode(p.tipo_pessoa, 2 /*Estrangeira*/, pes.municipio, pe.municipio) as municipio,
                       decode(p.tipo_pessoa, 2 /*Estrangeira*/, 'EX', pe.uf) as uf,
                       decode(p.tipo_pessoa, 2 /*Estrangeira*/, pes.municipio, pe.municipio) || decode(nvl(pe.uf, 'EX'), 'EX', '', ' - ' || pe.uf) as municipio_uf,
                       decode(p.tipo_pessoa, 2 /*Estrangeira*/, pes.municipio_id, pe.municipio_id) as municipio_id,
                       decode(t.telefone_id, null, '', '(' || t.fone_ddd || ')' || t.fone_prefixo || '-' || t.fone_numero) as telefone,
                       p.tipo_pessoa
                  from kss.v$pessoa p
                 inner join kss.v$unidade_negocio un
                         on p.cod_pessoa = un.cod_pessoa
                  left join kss.v$pessoa_endereco pe
                         on pe.cod_pessoa = p.cod_pessoa
                        and pe.endereco_padrao = 1
                  left join kss.v$pessoa_estrangeira pes
                         on pes.cod_pessoa = p.cod_pessoa
                  left join kss.v$pessoa_telefone pt
                         on pt.cod_pessoa = p.cod_pessoa
                        and pt.telefone_padrao = 1
                  left join kss.v$telefone t
                         on t.telefone_id = pt.telefone_id) t
                 left join cep.municipio m
                        on m.municipio_id = t.municipio_id
                 left join cep.pais ps
                        on ps.pais_id = m.pais_id
                    where 1 = 1
                    <cfif len(trim(arguments.nome))>
                       and upper(t.razao_social) like upper('%#arguments.nome#%')
                     </cfif>
         order by t.cliente, t.razao_social, t.municipio_uf
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>		

	<!--- 
	-- PROPSITO
	-- Lista as especies de mercadorias
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 05/12/2005 - criado
	--->	
	<cffunction name="get_especies" displayname="Lista as especies de mercadorias" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select num_especie, 
				   descricao, 
				   abreviatura, 
				   peso, 
				   codigo_intc
			  from oper.v$especie
			 order by num_especie
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>		

	<!--- 
	-- PROPSITO
	-- Lista as unidades de medida
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 05/12/2005 - criado
	--->	
	<cffunction name="get_unidades" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select cod_unidade,
				   unidade
			  from fiscal.v$unidade_medida	
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>		
	
	<!--- 
	-- PROPSITO
	-- Lista os categorias de produto
	-- NOTAS EXPLICATIVAS
	--  
	-- 15/12/2005 - criado
	--->	
	<cffunction name="get_categorias_produto" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select gn.grupo_natureza_id as categoria_id,
                   gn.descricao,
                   gn.descricao_resumida
              from oper.v$grupo_natureza gn
             order by gn.descricao_resumida
                    , gn.descricao
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Lista NCM de produto
	-- NOTAS EXPLICATIVAS
	--  
	-- 15/12/2005 - criado
	--->	
	<cffunction name="get_produto_ncm" access="remote" returntype="query" output="true">
		<cfargument name="cod_ncm" required="yes" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select cod_ncm, descricao_ncm 
			  from fiscal.v$produto_ncm
		    where cod_ncm = '#arguments.cod_ncm#'
			  and rownum = 1
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>		

	<!--- 
	-- PROPSITO
	-- Busca taxa de seguro
	-- NOTAS EXPLICATIVAS
	--  
	-- 15/12/2005 - criado
	--->	
	<cffunction name="get_sobretaxa_seguro" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select kss.pkg_global.fnc_obtem_parametro_num(25,'FISCAL.EXE',34) as taxa_padrao
			  from dual
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>	    

	<!--- 
	-- PROPSITO
	-- Lista os produtos
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 05/12/2005 - criado
	--->	
	<cffunction name="get_produtos" access="remote" returntype="query" output="true">
		<cfargument name="produto_id" required="no" />
		<cfargument name="descricao" required="no" />		
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select n.num_natureza produto_id
                 , n.descricao
                 , n.cod_ncm
                 , n.grupo_natureza_id as categoria_id
                 , 'Kg' as cod_unidade
              from oper.v$natureza n
             where 1 = 1
			 <cfif IsDefined("arguments.produto_id") and Len(Trim(arguments.produto_id))>
				 and n.num_natureza = #arguments.produto_id#
			 </cfif>
			 <cfif IsDefined("arguments.descricao") and Len(Trim(arguments.descricao))>
				 and upper(n.descricao) like upper('%#arguments.descricao#%')
			 </cfif>
			 order by n.descricao
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>		
	
	<!--- 
	-- PROPSITO
	-- Lista os RESP. PELA DESCARGA	
	-- NOTAS EXPLICATIVAS
	--  
	-- 16/12/2005 - criado
	--->	
	<cffunction name="get_despacho_descarga" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select descarga_por_conta_id, descricao, ativo
			  from fiscal.v$intc_despacho_descarga
			 order by descarga_por_conta_id
 		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>		

	<!--- 
	-- PROPSITO
	-- Lista os tipos de produto
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 05/12/2005 - criado
	--->	
	<cffunction name="get_crt" access="remote" returntype="query" output="true">
		<cfargument name="conhecimento_id" required="no" default="">
		<cfargument name="numero" required="no" default="">
		<cfargument name="cod_pessoa_filial" required="no" default="">
		<cfargument name="cod_remetente" required="no" default="">
		<cfargument name="cod_destinatario" required="no" default="">
      <cfargument name="num_crt_completo" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select c.conhecimento_id, c.versao, 
				   c.numero_cod_pais,
				   c.numero_certificado,
				   c.numero_sequencial,
				   upper(c.numero_cod_pais||'.'||c.numero_certificado||'.'||replace(to_char(c.numero_sequencial, '000000'), ' ', '')) as numero,
				   upper(c.numero_cod_pais||'.'||c.numero_certificado||'.'||replace(replace(to_char(c.numero_sequencial, '000,000'), ',','.'), ' ', '')) as numero_form,
				   c.cod_pessoa_filial,
				   c.emissao_local,
				   c.emissao_municipio_id,
				   c.emissao_data,
				   to_char(c.emissao_data,'dd/mm/yyyy') emissao_data_char,
				   c.resp_local,
				   c.resp_municipio_id,				   
				   cep.fnc_cidade_completa(c.resp_municipio_id) as resp_cidade, 
				   c.resp_data,
				   c.entrega_local,
				   c.entrega_municipio_id,
				   cep.fnc_cidade_completa(c.entrega_municipio_id) as entrega_cidade, 
				   c.entrega_data,
				   c.transp_sucessivos,
				   c.cod_remetente,
				   c.rem_nome,
				   c.rem_endereco,
				   c.rem_cidade,
				   c.rem_municipio_id,
				   c.pais_id_origem,
				   c.rem_uf,
				   c.rem_pais,
				   decode(c.rem_uf,'EX',(select pe.cod_cadastro_contribuinte from kss.v$pessoa_estrangeira pe where pe.cod_pessoa = c.cod_remetente),c.rem_cnpj_cpf) as rem_cnpj_cpf,
				   rem.inscricao_estadual as rem_inscricao_estadual, 
				   c.rem_cidade|| decode(nvl(c.rem_uf, 'EX'),'EX',(select decode(pe.estado_provincia,null,'',' - ' || to_char(pe.estado_provincia)) from kss.v$pessoa_estrangeira pe where pe.cod_pessoa = c.cod_remetente),' - ' || c.rem_uf) ||' - '||c.rem_pais as rem_municipio_uf_pais,
				   c.cod_destinatario,
				   c.dest_nome,
				   c.dest_endereco,
				   c.dest_cidade,
				   c.dest_municipio_id,

				   c.dest_uf,
				   c.dest_pais,
				   decode(c.dest_uf,'EX',(select pe.cod_cadastro_contribuinte from kss.v$pessoa_estrangeira pe where pe.cod_pessoa = c.cod_destinatario),c.dest_cnpj_cpf) as dest_cnpj_cpf,
				   dest.inscricao_estadual as dest_inscricao_estadual, 
				   c.dest_cidade|| decode(nvl(c.dest_uf, 'EX'),'EX',(select decode(pe.estado_provincia,null,'',' - ' || to_char(pe.estado_provincia)) from kss.v$pessoa_estrangeira pe where pe.cod_pessoa = c.cod_destinatario),' - ' || c.dest_uf) || ' - '||c.dest_pais as dest_municipio_uf_pais,				   
				   c.cod_consignatario,
				   c.cons_nome,
				   c.cons_endereco,
				   c.cons_cidade,
				   c.cons_municipio_id,

				   c.cons_uf,
				   c.cons_pais,
				   c.cons_cnpj_cpf,
				   c.cons_cidade|| decode(nvl(c.cons_uf, 'EX'),'EX',(select decode(pe.estado_provincia,null,'',' - ' || to_char(pe.estado_provincia)) from kss.v$pessoa_estrangeira pe where pe.cod_pessoa = c.cod_consignatario),' - ' || c.cons_uf)||' - '||c.cons_pais as cons_municipio_uf_pais,				   
				   c.cod_notificar,
				   c.not_nome,
				   c.not_endereco,
				   c.not_cidade,
				   c.not_municipio_id,

				   c.not_uf,
				   c.not_pais,
				   c.not_cnpj_cpf,
				   c.not_cidade||decode(nvl(c.not_uf, 'EX'),'EX',(select decode(pe.estado_provincia,null,'',' - ' || to_char(pe.estado_provincia)) from kss.v$pessoa_estrangeira pe where pe.cod_pessoa = c.cod_notificar),' - ' || c.not_uf)||' - '||c.not_pais as not_municipio_uf_pais,				   
				   c.mercadorias,
				   c.num_especie,
   				   to_char(c.quantidade_total,'999999') as quantidade_total,
				   c.peso_bruto,
				   c.peso_liquido,
				   c.unidade_id,
				   to_char(c.m3,'999999D999') as m3,
				   c.valor_total,
				   c.valor_total_cod_moeda,
				   c.valor_total_incoterm_id,
				   c.total_custo_origem,
				   c.total_custo_origem_cod_moeda,
				   c.total_custo_destino,
				   c.total_custo_destino_cod_moeda,
				   c.valor_frt_externo,
				   c.valor_frt_externo_cod_moeda,
				   c.valor_reembolso,
				   c.valor_reembolso_cod_moeda,
				   c.valor_mercadorias,
				   c.valor_mercadorias_cod_moeda,
				   c.valor_mercadorias_incoterm_id as valor_mercadorias_incoterm,
				   c.alfandega_origem_id,
				   c.alfandega_destino_id,
				   c.pago_por,
				   c.declaracao_observacao,
				   c.user_insert,
				   c.date_insert,
				   c.user_update,
				   c.date_update,
				   c.site,
				   f.cliente as filial,
				   c.cancelado,
				   c.liberado_fatura, c.obs_pago_por, 
				   c.seguro_pago_empresa,
				   c.qtde_veiculos, c.cod_organograma,
                   c.taxa_mercadoria_seguro,
                   (select cod_centro_custo
                      from kss.v$organograma o
                     where o.cod_organograma = c.cod_organograma) as cod_centro_custo,
					c.emissao_data_impressao,
       c.cod_pagador_origem, c.pag_origem_nome, c.pag_origem_endereco, c.pag_origem_cidade, 
	 		   c.pag_origem_uf, c.pag_origem_pais, c.pag_origem_cnpj_cpf, 
				   c.pag_origem_cidade||decode(nvl(c.pag_origem_uf, 'EX'),'EX',(select decode(pe.estado_provincia,null,'',' - ' || to_char(pe.estado_provincia)) from kss.v$pessoa_estrangeira pe where pe.cod_pessoa = c.cod_pagador_origem),' - ' || c.pag_origem_uf)||' - '||c.pag_origem_pais as pag_origem_cidade_uf_pais,     
       c.cod_pagador_destino, 
       c.pag_destino_nome, c.pag_destino_endereco, c.pag_destino_cidade, c.pag_destino_uf, 
							c.pag_destino_pais, c.pag_destino_cnpj_cpf,
				   c.pag_destino_cidade||decode(nvl(c.pag_destino_uf, 'EX'),'EX',(select decode(pe.estado_provincia,null,'',' - ' || to_char(pe.estado_provincia)) from kss.v$pessoa_estrangeira pe where pe.cod_pessoa = c.cod_pagador_destino),' - ' || c.pag_destino_uf)||' - '||c.pag_destino_pais as pag_destino_cidade_uf_pais,
       c.pre_conhecimento,
                   c.cotacao
			  from fiscal.v$intc_conhecimento c
			 left join kss.v$pessoa f
			         on f.cod_pessoa = c.cod_pessoa_filial
			 left join kss.v$pessoa rem
			         on rem.cod_pessoa = c.cod_remetente
			 left join kss.v$pessoa dest
			         on dest.cod_pessoa = c.cod_destinatario
			 where 1=1
			 <cfif len(trim(arguments.conhecimento_id))>
			   and c.conhecimento_id = #arguments.conhecimento_id#
			 </cfif>
          <cfif len(trim(arguments.num_crt_completo))>
			   and c.num_crt_completo = '#arguments.num_crt_completo#'
			 </cfif>
			 <cfif len(trim(arguments.cod_remetente))>
			   and c.cod_remetente = #arguments.cod_remetente#
			 </cfif>
			 <cfif len(trim(arguments.cod_destinatario))>
			   and c.cod_destinatario = #arguments.cod_destinatario#
			 </cfif>
			 <cfif len(trim(arguments.numero))>
			   and upper(c.numero_cod_pais||'.'||c.numero_certificado||'.'||replace(to_char(c.numero_sequencial, '000000'), ' ', '')) like upper('%#arguments.numero#%')
			 </cfif>
			 <cfif len(trim(arguments.cod_pessoa_filial))>
			   and c.cod_pessoa_filial = #arguments.cod_pessoa_filial#
			 </cfif>
			 order by c.numero_cod_pais desc, c.numero_certificado desc, c.numero_sequencial desc 
            
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>	  	
	
	<!--- 
	-- PROPSITO
	-- Lista os itens do crt
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 05/12/2005 - criado
	--->	
	<cffunction name="get_item_crt" access="remote" returntype="query" output="true">
		<cfargument name="conhecimento_id" required="yes">
		<cfargument name="item_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
		select i.conhecimento_id, i.item_id, i.produto_id, i.quantidade, i.quantidade - nvl((select sum(quantidade) 
                                                                                       from fiscal.v$intc_manifesto_crt_item mit 
                                                                                      where mit.conhecimento_id = i.conhecimento_id 
                                                                                        and mit.item_id = i.item_id),0) as quantidade_disponivel, 
			   i.unidade_id, i.descricao, i.user_insert, i.date_insert, i.user_update, i.date_update, i.site, 
			   i.num_especie, nvl(i.peso_bruto, 0) as peso_bruto, nvl(i.peso_liquido, 0) as peso_liquido, 
			   nvl(i.peso_bruto, 0) - nvl((select sum(peso_bruto) 
									 from fiscal.v$intc_manifesto_crt_item mit 
									where mit.conhecimento_id = i.conhecimento_id 
									  and mit.item_id = i.item_id),0) as peso_bruto_disponivel, 
			   nvl(i.peso_liquido,0) - nvl((select sum(peso_liquido) 
									   from fiscal.v$intc_manifesto_crt_item mit 
									  where mit.conhecimento_id = i.conhecimento_id 
										and mit.item_id = i.item_id),0) as peso_liquido_disponivel, 
			   nvl(i.m3, 0) as m3, c.alfandega_destino_id, c.VALOR_TOTAL_COD_MOEDA, c.EMISSAO_LOCAL, c.EMISSAO_MUNICIPIO_ID, i.PRODUTO_ID, 
			   i.UNIDADE_ID, c.COD_REMETENTE, c.rem_nome, 
			   c.cod_destinatario, c.dest_nome, 
			   c.cod_consignatario, c.cons_nome 
			   from fiscal.v$intc_conhecimento_item i 
			   inner join fiscal.v$intc_conhecimento c 
			   		   on c.conhecimento_id = i.conhecimento_id 
			 where i.conhecimento_id = #arguments.conhecimento_id#
			 <cfif len(trim(arguments.item_id))>
			 	and i.item_id = #arguments.item_id#
			 </cfif>
			 
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>	 
	
	
	
	<!--- 
	-- PROPSITO
	-- Lista os itens do crt
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 05/12/2005 - criado
	--->	
	<cffunction name="get_custo_crt" access="remote" returntype="query" output="true">
		<cfargument name="conhecimento_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select conhecimento_id,
				   item_id,
				   descricao,
				   valor_origem,
				   valor_origem_cod_moeda,
				   valor_destino,
				   valor_destino_cod_moeda,
				   user_insert,
				   date_insert,
				   user_update,
				   date_update,
				   site
			  from fiscal.v$intc_conhecimento_custo	 	
			 where conhecimento_id = #arguments.conhecimento_id#
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>	 
	
	
	
	<!--- 
	-- PROPSITO
	-- Lista os itens do crt
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 05/12/2005 - criado
	--->	
	<cffunction name="get_anexo_crt" access="remote" returntype="query" output="true">
		<cfargument name="conhecimento_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select conhecimento_id,
				   anexo_id,
				   descricao,
				   user_insert,
				   date_insert,
				   user_update,
				   date_update,
				   site
			  from fiscal.v$intc_conhecimento_anexo	
			 where conhecimento_id = #arguments.conhecimento_id#
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>	 

	<!--- 
	-- PROPSITO
	-- Lista froteiras
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 04/07/2007 - criado
	--->	
	<cffunction name="get_fronteira_crt" access="remote" returntype="query" output="true">
		<cfargument name="conhecimento_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select cf.controle_id,
            	   cf.conhecimento_id,
				   f.fronteira_id,
				   f.descricao
			  from fiscal.v$intc_conhecimento_fronteira cf
              inner join fiscal.v$fronteira f
                      on f.fronteira_id = cf.fronteira_id
			 where conhecimento_id = #arguments.conhecimento_id#
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>		
	
	<!--- 
	-- PROPSITO
	-- Lista os itens do CRT a serem impressos
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 05/12/2005 - criado
	--->	
	<cffunction name="get_crt_form" access="remote" returntype="query" output="true">
		<cfargument name="conhecimento_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select conhecimento_id, 
                   numero_cod_pais, 
                   versao, 
                   campo01, 
                   campo02, 
                   '' as campo03,
                   campo04, 
                   campo05, 
                   campo06, 
                   campo07, 
                   campo08, 
                   campo09, 
                   campo10, 
                   campo11, 
                   campo12, 
                   campo13, 
                   campo14_1, 
                   campo14_2, 
                   campo15_1, 
                   campo15_2, 
                   campo15_3, 
                   campo15_4, 
                   campo16_1, 
                   campo16_2, 
                   campo17, 
                   campo18, 
                   campo19_0, 
                   campo19_1, 
                   campo19_2, 
                   campo20_1, 
                   campo20_2, 
                   campo21_1, 
                   campo21_2, 
                   campo22, 
                   campo23, 
                   campo23_1
              from fiscal.v$intc_conhecimento_form
 			 where conhecimento_id = #arguments.conhecimento_id#
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Lista os itens do CRT originais
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 16/06/2009
	--->	
	<cffunction name="get_crt_print" access="remote" returntype="query" output="true">
		<cfargument name="conhecimento_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select conhecimento_id, 
                   numero_cod_pais, 
                   versao, 
                   campo01, 
                   campo02, 
                   '' as campo03,
                   campo04, 
                   campo05, 
                   campo06, 
                   campo07, 
                   campo08, 
                   campo09, 
                   campo10, 
                   campo11, 
                   campo12, 
                   campo13, 
                   campo14_1, 
                   campo14_2, 
                   campo15_1, 
                   campo15_2, 
                   campo15_3, 
                   campo15_4, 
                   campo16_1, 
                   campo16_2, 
                   campo17, 
                   campo18, 
                   campo19_0, 
                   campo19_1, 
                   campo19_2, 
                   campo20_1, 
                   campo20_2, 
                   campo21_1, 
                   campo21_2, 
                   campo22, 
                   campo23, 
                   campo23_1
              from fiscal.v$intc_conhecimento_print
 			 where conhecimento_id = #arguments.conhecimento_id#
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Lista os itens do crt
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 05/12/2005 - criado
	--->	
	<cffunction name="get_intc_manifesto" access="remote" returntype="query" output="true">
		<cfargument name="numero" required="no" default="">
		<cfargument name="numero_cod_pais" required="no" default="">
		<cfargument name="manifesto_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select m.manifesto_id,
				   m.numero_cod_pais,
				   m.numero_certificado,
				   m.numero_sequencial,
				   upper(m.numero_cod_pais)||'.'||m.numero_certificado||'.'||replace(replace(to_char(m.numero_sequencial, '000000'),' ', ''), ',', '.') as numero,
				   m.data_emissao,
				   m.transito_aduaneiro,
				   m.cod_transportador,
				   m.transp_nome,
				   m.transp_endereco,
				   m.transp_municipio_id,
				   cep.fnc_cidade_completa(m.transp_municipio_id) as transp_mun_uf_pais,
				   m.transp_dados_adicionais,
				   m.transp_cnpj_cpf,
				   m.alfandega_origem_id,
				   a.nome as alfandega,
				   m.pais_id_origem,
				   m.destino_local,
				   m.destino_municipio_id,
				   m.veic_orig_prop_cod_pessoa,
				   m.veic_orig_prop_nome,
				   m.veic_orig_prop_endereco,
				   m.veic_orig_prop_municipio_id,
				   cep.fnc_cidade_completa(m.veic_orig_prop_municipio_id) as veic_orig_prop_mun_uf_pais,
				   m.veic_orig_prop_cnpj_cpf,                   
                   m.veic_orig_prop_dados_adic,
				   m.veic_orig_placa_controle,
				   oper.pkg_veiculo.fnc_get_cod_veiculo(m.veic_orig_placa_controle) veic_orig_frota_controle,
				   m.veic_orig_marca,
				   m.veic_orig_chassis,
				   m.veic_orig_capacidade,
				   oper.pkg_frota_dml.fnc_veiculo_get_atributo(m.veic_orig_placa_controle, 'TARA') as veic_orig_tara,
				   m.veic_orig_ano,
				   m.veic_orig_tipo,
				   m.veic_orig_placa_referencia,
				   oper.pkg_veiculo.fnc_get_cod_veiculo(m.veic_orig_placa_referencia) veic_orig_frota_referencia,
				   m.veic_orig_mot_cod_pessoa,
				   oper.pkg_global.fnc_mascara_cnpj_cpf(m.veic_orig_mot_cod_pessoa) as veic_orig_mot_cnpj_cpf,
				   oper.pkg_global.fnc_busca_nome_pessoa(m.veic_orig_mot_cod_pessoa) as veic_orig_mot_nome,
				   m.veic_subst_prop_cod_pessoa,
				   m.veic_subst_prop_nome,
				   m.veic_subst_prop_endereco,
				   m.veic_subst_prop_municipio_id,
				   cep.fnc_cidade_completa(m.veic_subst_prop_municipio_id) as veic_subst_prop_mun_uf_pais,
				   m.veic_subst_prop_cnpj_cpf,
				   m.veic_subst_placa_controle,
				   m.veic_subst_marca,
				   m.veic_subst_chassis,
				   m.veic_subst_capacidade,
				   m.veic_subst_mot_cod_pessoa,
				   oper.pkg_global.fnc_mascara_cnpj_cpf(m.veic_subst_mot_cod_pessoa) as veic_subst_mot_cnpj_cpf,
				   oper.pkg_global.fnc_busca_nome_pessoa(m.veic_subst_mot_cod_pessoa) as veic_subst_mot_nome,
				   oper.pkg_frota_dml.fnc_veiculo_get_atributo(m.veic_subst_placa_controle, 'TARA') as veic_subst_tara,
				   m.veic_subst_ano,
				   m.veic_subst_tipo,
				   m.veic_subst_placa_referencia,
				   m.num_dta_rota,
				   m.rota_id,
				   m.complemento,
				   m.cancelado, m.embarcado, m.num_romaneio, m.item_id as romaneio_item_id,
				   (select kss.fnc_concat_all(kss.to_concat_expr(c.NUMERO_COD_PAIS||'.'||lpad(c.NUMERO_CERTIFICADO,3,'0')||'.'||trim(replace(to_char(c.numero_sequencial,'000G000'),',','.')),' <br>')) 
					  from fiscal.v$intc_manifesto_crt mc
					 inner join fiscal.v$intc_conhecimento c
							 on c.conhecimento_id = mc.conhecimento_id
					 where mc.MANIFESTO_ID = m.manifesto_id) crts,
				   (select count(*) from fiscal.v$intc_manifesto_crt mc where mc.MANIFESTO_ID = m.MANIFESTO_ID) as num_crts
			  from fiscal.v$intc_manifesto m
			 inner join fiscal.v$alfandega a
			         on a.alfandega_id = m.alfandega_origem_id
		     where 1=1
			 <cfif len(trim(arguments.numero))>
			 	and upper(m.numero_cod_pais)||'.'||m.numero_certificado||'.'||replace(replace(to_char(m.numero_sequencial, '000,000'),' ', ''), ',', '.') like upper('%#arguments.numero#%')
			 </cfif>
			 <cfif len(trim(arguments.numero_cod_pais))>
			 	and upper(m.numero_cod_pais) = upper('#arguments.numero_cod_pais#')
			 </cfif>
			 <cfif len(trim(arguments.manifesto_id))>
			 	and manifesto_id in (#arguments.manifesto_id#)
			 </cfif>
			 order by m.numero_cod_pais desc, m.numero_certificado desc, m.numero_sequencial desc
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>  

	<!--- 
	-- PROPSITO
	-- Lista os totais de cada pagina do MIC
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 31/01/2006 - criado
	--->	
	<cffunction name="get_intc_manifesto_pagina" access="remote" returntype="query" output="true">
		<cfargument name="manifesto_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select manifesto_id, pagina, campo42, campo43, campo44, campo45,
				   campo46, campo47
			  from fiscal.v$intc_manifesto_pagina
  		     where 1=1
			 <cfif len(trim(arguments.manifesto_id))>
			   and manifesto_id = '#arguments.manifesto_id#'
			 </cfif>
			 order by manifesto_id, pagina
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>  	
	
	<!--- 
	-- PROPSITO
	-- Lista os itens do crt
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 05/12/2005 - criado
	--->	
	<cffunction name="get_intc_manifesto_item" access="remote" returntype="query" output="true">
		<cfargument name="manifesto_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct i.manifesto_id,
                   c.numero_sequencial,
                   i.conhecimento_id,
                   ci.item_id as conhecimento_item_id,
                   upper(c.numero_cod_pais||'.'||c.numero_certificado||'.'||replace(to_char(c.numero_sequencial, '000000'), ' ' , '')) as numero_crt,
                   i.alfandega_destino_id,
                   i.cod_moeda,
                   i.origem_local,
                   i.origem_municipio_id,
                   i.valor_fot,
                   i.valor_total,
                   i.valor_seguro,
                   ci.produto_id,
                   i.num_especie,
                   i.quantidade,
                   i.peso_bruto,
                   i.peso_liquido,
                   i.unidade_id,
                   i.cod_remetente,
                   i.rem_nome,
                   i.rem_local,
                   rem.cnpj_cpf as rem_cnpj_cpf,
                   rem.inscricao_estadual as rem_inscr_estadual,
                   decode(rem.tipo_pessoa,2/*Estrangeira*/, rpes.endereco, rpe.logradouro || decode(rpe.numero, '', '', ', ') || rpe.numero || decode(rpe.complemento, '', '', ' - ') || rpe.complemento) as rem_endereco,
                   rmun.municipio as rem_municipio, 
                   rmun.uf_id as rem_uf,
                   rps.descricao as rem_pais,
                   cep.fnc_cidade_completa(i.rem_municipio_id) as rem_local,
                   i.rem_municipio_id,
                   i.cod_destinatario,
                   i.dest_nome,
                   i.dest_local,
                   dest.cnpj_cpf as dest_cnpj_cpf,
                   dest.inscricao_estadual as dest_inscr_estadual,
                   decode(dest.tipo_pessoa,2/*Estrangeira*/, dpes.endereco, dpe.logradouro || decode(dpe.numero, '', '', ', ') || dpe.numero || decode(dpe.complemento, '', '', ' - ') || dpe.complemento) as dest_endereco,
                   dmun.municipio as dest_municipio, 
                   dmun.uf_id as dest_uf,
                   dps.descricao as dest_pais,
                   cep.fnc_cidade_completa(i.dest_municipio_id) as dest_local,
                   i.dest_municipio_id,
                   i.cod_consignatario,
                   i.cons_nome,
                   i.cons_local,
                   i.cons_municipio_id,
                   i.numero_lacres,
                   i.mercadorias,
                   '' as ncm,
                   i.user_insert,
                   i.date_insert,
                   i.user_update,
                   i.date_update,
                   i.site,
                   i.anexo,
                   ic.item_id,
                   i.pais_id_origem
                from fiscal.v$intc_manifesto_crt  i
               inner join fiscal.v$intc_manifesto_crt_item ic
                       on i.MANIFESTO_ID = ic.MANIFESTO_ID
                  and i.conhecimento_id = ic.conhecimento_id
               inner join fiscal.v$intc_conhecimento_item ci
                       on ic.conhecimento_id = i.conhecimento_id
                      and ci.item_id = ic.item_id
               inner join fiscal.v$intc_conhecimento c
                       on c.conhecimento_id = i.conhecimento_id
                     inner join kss.v$pessoa rem 
                             on rem.cod_pessoa = i.cod_remetente
                     left join kss.v$pessoa_estrangeira rpes
                             on rpes.cod_pessoa = i.cod_remetente
               left join kss.v$pessoa_endereco rpe
                      on rpe.cod_pessoa = rem.cod_pessoa
                     and rpe.endereco_padrao = 1
               left join cep.municipio rmun
                      on rmun.municipio_Id = rpe.municipio_id
               left join cep.pais rps
                      on rps.pais_id = rmun.pais_id
                     left join kss.v$pessoa dest
                             on dest.cod_pessoa = i.cod_destinatario
                     left join kss.v$pessoa_estrangeira dpes
                             on dpes.cod_pessoa = i.cod_destinatario
               left join kss.v$pessoa_endereco dpe
                      on dpe.cod_pessoa = dest.cod_pessoa
                     and dpe.endereco_padrao = 1
               left join cep.municipio dmun
                      on dmun.municipio_Id = dpe.municipio_id
               left join cep.pais dps
                      on dps.pais_id = dmun.pais_id
			 where i.manifesto_id = #arguments.manifesto_id#
			 order by c.numero_sequencial
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>  			  
	
	<!--- 
	-- PROPSITO
	-- Retorna dados do CRT para ser vinculado ao MIC
	-- NOTAS EXPLICATIVAS
	--  
	--->	
	<cffunction name="get_intc_conhecimento_item_mic" access="remote" returntype="query" output="true">
		<cfargument name="conhecimento_id" required="yes">
		<cfargument name="item_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select im.conhecimento_id,
				   im.item_id,
				   im.produto_id,
				   im.quantidade,
				   im.quantidade_disponivel,
				   im.unidade_id,
				   im.descricao,
				   im.user_insert,
				   im.date_insert,
				   im.user_update,
				   im.date_update,
				   im.site,
				   im.num_especie,
				   im.peso_bruto,
				   im.peso_liquido,
				   im.peso_bruto_disponivel,
				   im.peso_liquido_disponivel,
				   im.m3,
				   im.alfandega_destino_id,
				   im.valor_total_cod_moeda,
				   im.emissao_local,
				   im.emissao_municipio_id,
				   im.emissao_local as origem_local,
				   im.emissao_municipio_id as origem_municipio_id,
				   im.cod_remetente,
				   decode(p.tipo_pessoa,2, nvl(pe.cod_cadastro_contribuinte,pe.cod_pessoa),p.identificador) as rem_identificador,
				   decode(p.tipo_pessoa,2, nvl(pe.cod_cadastro_contribuinte,pe.cod_pessoa),p.cnpj_cpf) as rem_cnpj_cpf,
				   im.rem_nome,
				   im.rem_local,
				   im.rem_local as rem_endereco,
				   im.rem_municipio_id,
				   cep.fnc_cidade_completa(im.rem_municipio_id) as rem_municipio_uf_pais,
				   im.cod_destinatario,
				   im.dest_nome,
				   im.dest_local,
				   im.dest_municipio_id,
				   im.cod_consignatario,
				   im.cons_nome,
				   im.cons_local,
				   im.cons_municipio_id,
				   im.anexos,
				   im.pais_id_origem,
				   im.valor_total_cod_moeda as cod_moeda
			  from fiscal.v$intc_conhecimento_item_mic	im
			 inner join kss.v$pessoa p
             		 on im.cod_remetente = p.cod_pessoa
			  left join kss.v$pessoa_estrangeira pe
					 on pe.cod_pessoa = p.cod_pessoa
			 where 1=1 
			 <cfif len(trim(arguments.conhecimento_id))>
			    and im.conhecimento_id = #arguments.conhecimento_id#
			 </cfif>
			 <cfif len(trim(arguments.item_id))>
			 	and im.item_id = #arguments.item_id#
			 </cfif>
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>  			  

	<!--- 
	-- PROPSITO
	-- Retorna dados do MIC para a impresso
	-- NOTAS EXPLICATIVAS
	--  
	--->	
	<cffunction name="get_intc_manifesto_form" access="remote" returntype="query" output="true">
		<cfargument name="manifesto_id" required="yes">
		<cfargument name="vias" required="no" default="1">
		<cfargument name="paginas" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">	
			select manifesto_id, numero_cod_pais,
				   conhecimento_id,
				   pagina,
				   total_paginas,
				   campo01,
				   campo02,
				   campo03_1,
				   campo03_2,
				   campo04,
				   campo05,
				   campo06,
				   campo07,
				   campo07_cod1,
				   campo07_cod2,
				   campo07_cod3,
				   campo07_cod4,
				   campo07_cod5,
				   campo07_cod6,
				   campo07_cod7,
				   campo07_cod8,
				   campo08,
				   campo09,
				   campo10,
				   campo11,
				   campo12,
				   campo13,
				   campo14,
				   campo15_1,
				   campo15_2,
				   campo15_3,
       			   '' as campo16,
				   campo17,
				   campo18,
				   campo19,
				   campo20,
				   campo21,
				   campo22_1,
				   campo22_2,
				   campo22_3,
				   campo23,
				   campo24,
				   campo24_cod1,
				   campo24_cod2,
				   campo24_cod3,
				   campo24_cod4,
				   campo24_cod5,
				   campo24_cod6,
				   campo24_cod7,
				   campo24_cod8,
				   campo25,
				   campo26,
				   campo27,
				   campo28,
				   campo29,
				   campo30,
				   campo31,
				   campo32,
				   campo33,
				   campo34,
				   campo35,
				   campo36,
				   campo37,
				   campo38,
				   campo38_1,
				   campo38_cod1,
				   campo38_cod2,
				   campo38_cod3,
				   campo38_cod4,
				   campo38_cod5,
				   campo38_cod6,
				   campo38_cod7,
				   campo38_cod8,
				   campo38_cod9,
				   campo38_cod10,
				   campo40,
				   campo42,
				   campo43,
				   campo44,
				   campo45,
				   campo46,
				   campo47
			  from fiscal.v$intc_manifesto_form
			 where manifesto_id  = #arguments.manifesto_id#
			 <cfif arguments.paginas eq 0>
			 and pagina = 1
			 <cfelseif arguments.paginas eq 1>
			 and pagina <> 1
			 </cfif>
			 order by pagina
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>  	  
	
	<!--- 
	-- PROPSITO
	-- Retorna dados das vias para o MIC
	-- NOTAS EXPLICATIVAS
	--  
	--->	
	<cffunction name="get_intc_manifesto_vias" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select num_via,
					   descricao,
					   user_insert,
					   date_insert,
					   user_update,
					   date_update,
					   site
				  from fiscal.v$intc_manifesto_vias	
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>  

	<!--- 
	-- PROPSITO
	-- Retorna vias do CRT
	-- NOTAS EXPLICATIVAS
	--  
	--->	
	<cffunction name="get_intc_conhecimento_vias" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select num_via,
					   descricao,
					   user_insert,
					   date_insert,
					   user_update,
					   date_update,
					   site
				  from fiscal.v$intc_conhecimento_vias
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>  	

	<!--- 
	-- PROPSITO
	-- Retorna rota para ser vinculada ao MIC
	-- NOTAS EXPLICATIVAS
	--  
	--->	
	<cffunction name="get_intc_manifesto_rota" access="remote" returntype="query" output="true">
		<cfargument name="rota_id" required="no" />
		<cfargument name="nome_rota" required="no" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select rota_id, nome_rota, rota, prazo,
				   rota || chr(10) || 'Prazo: ' || nvl(to_char(prazo),'....') || ' dias' as rota_prazo
			  from fiscal.v$intc_manifesto_rota
			 where 1=1
		    <cfif IsDefined("arguments.rota_id") and Len(Trim(arguments.rota_id))>
			   and rota_id = #arguments.rota_id#
			</cfif>
		    <cfif IsDefined("arguments.nome_rota") and Len(Trim(arguments.nome_rota))>
			   and nome_rota like '%#arguments.nome_rota#%'
			</cfif>
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>  	

	<!--- 
	-- PROPSITO
	-- Retorna dados do DTI
	-- NOTAS EXPLICATIVAS
	--  
	--->	
	<cffunction name="get_intc_despacho" access="remote" returntype="query" output="true">
		<cfargument name="despacho_id" required="no">
		<cfargument name="num_despacho" required="no">
		<cfargument name="cod_pessoa_filial" required="no">		
		<cfargument name="cod_pessoa_emissao" required="no">
       	<cfargument name="serie" required="no">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select d.despacho_id, d.num_despacho, d.serie, d.cod_pessoa_filial, d.cod_pessoa_emissao, f.cliente as filial,
				   d.local_emissao,
				   d.municipio_id, to_char(d.data_emissao,'dd/mm/yyyy') as data_emissao, d.origem_local, d.origem_municipio_id,
				   d.destino_local, d.destino_municipio_id, d.cod_remetente, d.rem_nome,
				   d.rem_cnpj, d.rem_inscricao_estadual, d.rem_endereco,
				   cep.fnc_cidade_completa(d.rem_municipio_id) as rem_local,
				   d.rem_municipio_id, d.cod_destinatario, d.dest_nome, d.dest_cnpj,
				   d.dest_inscricao_estadual, d.dest_endereco, d.dest_municipio_id,
				   cep.fnc_cidade_completa(d.dest_municipio_id) as dest_local,				   
				   d.notas_fiscais, d.valor_mercadoria, d.valor_mercadoria_cod_moeda,
				   d.produto_id, d.num_especie, d.quantidade, d.peso_bruto,
				   d.cod_proprietario, d.prop_nome, d.prop_endereco, d.prop_cnpj_cpf,
				   d.prop_municipio_id, 
				   cep.fnc_cidade_completa(d.prop_municipio_id) as prop_local,
				   d.prop_cert_propriedade, d.prop_rtb,
				   d.cod_motorista, d.mot_nome, d.mot_cpf, d.mot_endereco,
				   d.mot_municipio_id, 
				   cep.fnc_cidade_completa(d.mot_municipio_id) as mot_local,
				   d.mot_cnh, d.mot_cnh_validade, d.placa_tracao,
				   d.placa_reboque, 
				   d.peso_a_pagar, 
				   d.valor_por_kg, 
				   round(d.valor_servico,2) as valor_servico,
				   round(d.valor_carga_descarga,2) as valor_carga_descarga, 
				   round(d.valor_fronteira,2) as valor_fronteira, 
				   round(d.valor_irrf,2) as valor_irrf,
				   round(d.valor_adiantamento,2) as valor_adiantamento, 
				   round(d.valor_icms_retido,2) as valor_icms_retido, 
				   round(d.valor_liquido,2) as valor_icms_retido,
				   round(d.valor_falta_avarias,2) as valor_falta_avarias, 
				   round(d.valor_adicional,2) as valor_adicional, 
				   d.descricao_valor_adicional,
				   round(d.liquido_a_pagar,2) as liquido_a_pagar, 
				   d.cotacao_dolar, d.num_dependentes,
				   d.base_calc_irrf, d.outras_deducoes, d.descarga_por_conta_id, des.descricao as descarga_por_conta,
				   d.observacoes, d.autorizar_pagto_por, d.autorizar_pagto_data,
				   d.autorizar_adto_por, d.autorizar_adto_data,
				   d.cancelado, d.tipo, d.date_update, d.user_update,
				   d.operador_valor_adicional operacao_valor_adicional
			  from fiscal.v$intc_despacho d
			 left join fiscal.v$intc_despacho_descarga des
					 on d.descarga_por_conta_id = des.descarga_por_conta_id
			 left join kss.v$pessoa f
			         on f.cod_pessoa = d.cod_pessoa_filial
             where 1=1
			 <cfif IsDefined("arguments.despacho_id") and Len(Trim(arguments.despacho_id))>
			   and d.despacho_id = #arguments.despacho_id#
			 </cfif>
			 <cfif IsDefined("arguments.num_despacho") and Len(Trim(arguments.num_despacho))>
			   and d.num_despacho = #arguments.num_despacho#
			 </cfif>
			 <cfif IsDefined("arguments.cod_pessoa_filial") and Len(Trim(arguments.cod_pessoa_filial))>
			   and d.cod_pessoa_filial = #arguments.cod_pessoa_filial#
			 </cfif>
			 <cfif IsDefined("arguments.cod_pessoa_emissao") and Len(Trim(arguments.cod_pessoa_emissao))>
			   and d.cod_pessoa_emissao = #arguments.cod_pessoa_emissao#
			 </cfif>
             <cfif IsDefined("arguments.serie") and Len(Trim(arguments.serie))>
			   and d.serie = #arguments.serie#
			 </cfif>
			 order by f.cliente, d.num_despacho
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>  	

	<!--- 
	-- PROPSITO
	-- Retorna dados resumidos do DTI
	-- NOTAS EXPLICATIVAS
	--  
	--->	
	<cffunction name="get_intc_despacho_localizar" access="remote" returntype="query" output="true">
		<cfargument name="despacho_id" required="no">
		<cfargument name="num_despacho" required="no">
		<cfargument name="placa" required="no" default="">
		<cfargument name="cod_pessoa_filial" required="no">		
		<cfargument name="cod_pessoa_fl" required="no">		
		<cfargument name="data_emissao" required="no">		
		<cfargument name="data_inicio" required="no" default="">		
		<cfargument name="data_fim" required="no" default="">		
		<cfargument name="cancelado" required="no" default="">		
		<cfargument name="num_crt" required="no" default="">
        <cfargument name="serie" required="no">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select d.despacho_id, to_char(d.num_despacho,'000000') as num_despacho, d.serie,
				   p.cliente filial_formulario, to_char(d.data_emissao,'dd/mm/yyyy') as data_emissao,
					to_char(d.num_despacho) || to_char(d.cod_pessoa_filial) || d.serie as identificador,
				   p2.cliente filial_emissao,       
				   p3.cliente motorista,       
				   c.numero_cod_pais || '.' || c.numero_certificado || '.' || replace(replace(to_char(c.numero_sequencial, '000,000'), ',', '.'), ' ', '') as num_crt,
				   d.placa_tracao,
          		  (select b.moeda from finan.v$moeda_bacen b where b.cod_moeda = d.valor_mercadoria_cod_moeda) as valor_mercadoria_cod_moeda,
           		   d.valor_mercadoria, d.liquido_a_pagar, d.VALOR_SERVICO, d.VALOR_ADIANTAMENTO,
				   c.cancelado,
				   d.rem_nome as remetente,
				   d.dest_nome as destinatario,
				   d.liquido_a_pagar,
				   d.valor_adiantamento
			  from fiscal.v$intc_despacho d
			 left join fiscal.v$intc_despacho_item di
					 on di.despacho_id = d.despacho_id
			 left join fiscal.v$intc_conhecimento c
					 on c.conhecimento_id = di.conhecimento_id
			 left join kss.v$pessoa p
					 on d.cod_pessoa_filial = p.cod_pessoa
			 left join kss.v$pessoa p2
					 on d.cod_pessoa_emissao = p2.cod_pessoa
			 left join kss.v$pessoa p3
					 on d.cod_motorista = p3.cod_pessoa
			  where 1=1
			 <cfif IsDefined("arguments.despacho_id") and Len(Trim(arguments.despacho_id))>
			   and d.despacho_id = #arguments.despacho_id#
			 </cfif>
			 <cfif len(trim(arguments.placa))>
			   and d.placa_tracao like '#arguments.placa#%'
			 </cfif>
			 <cfif IsDefined("arguments.data_emissao") and Len(Trim(arguments.data_emissao))>
			   and trunc(d.data_emissao) = '#arguments.data_emissao#'
			 </cfif>
			 <cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_fim))>
			   and d.data_emissao between to_date('#arguments.data_inicio# 00:00','dd/mm/yyyy hh24:mi') and to_date('#arguments.data_fim# 23:59','dd/mm/yyyy hh24:mi')
			 </cfif>
			 <cfif IsDefined("arguments.num_despacho") and Len(Trim(arguments.num_despacho))>
			   and d.num_despacho = #arguments.num_despacho#
			 </cfif>
			 <cfif IsDefined("arguments.cod_pessoa_filial") and Len(Trim(arguments.cod_pessoa_filial))>
			   and d.cod_pessoa_emissao = #arguments.cod_pessoa_filial#
			 </cfif>
			 <cfif IsDefined("arguments.cod_pessoa_fl") and Len(Trim(arguments.cod_pessoa_fl))>
			   and d.cod_pessoa_filial = #arguments.cod_pessoa_fl#
			 </cfif>
             <cfif IsDefined("arguments.serie") and Len(Trim(arguments.serie))>
			   and d.serie = #arguments.serie#
			 </cfif>
			 <cfif Len(Trim(arguments.cancelado))>
			   and d.cancelado = #arguments.cancelado#
			 </cfif>
			 <cfif len(trim(arguments.num_crt))>
			   and c.numero_cod_pais like '%#Left(UCase(arguments.num_crt),2)#%'
               and c.numero_certificado like '%#ListGetAt(UCase(arguments.num_crt),2,'.')#%'
               and replace(replace(to_char(c.numero_sequencial, '000,000'), ',', '.'), ' ', '') like '%#Right(UCase(arguments.num_crt),6)#%'
			 </cfif>
             order by d.num_despacho 
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>  		
	
	<!--- 
	-- PROPSITO
	-- Retorna dados do DTI para serem usados na impresso
	-- NOTAS EXPLICATIVAS
	--  
	--->	
	<cffunction name="get_intc_despacho_form" access="remote" returntype="query" output="true">
		<cfargument name="despacho_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select despacho_id, num_despacho, serie, cod_pessoa_filial, filial, filial_emissao,
				   local_emissao, municipio_id, data_emissao, origem_local,
				   origem_municipio_id, destino_local, destino_municipio_id,
				   cod_remetente, rem_nome, rem_cnpj, rem_inscricao_estadual,
				   rem_endereco, rem_municipio, rem_uf, rem_municipio_id,
				   cod_destinatario, dest_nome, dest_cnpj, dest_inscricao_estadual,
				   dest_endereco, dest_municipio_id, dest_municipio, dest_uf,
				   notas_fiscais, valor_mercadoria, valor_mercadoria_cod_moeda,
				   produto_id, num_especie, quantidade, peso_bruto, cod_proprietario,
				   prop_nome, prop_endereco, prop_cnpj_cpf, prop_municipio_id,
				   prop_municipio, prop_uf, prop_cert_propriedade, prop_rtb,
				   cod_motorista, mot_nome, mot_cpf, mot_endereco, mot_municipio_id,
				   mot_cnh, mot_cnh_validade, mot_primeira_cnh, mot_municipio, mot_uf,
				   placa_tracao, placa_reboque, peso_a_pagar, valor_por_kg,
				   valor_servico, valor_carga_descarga, valor_fronteira, valor_irrf,
				   valor_adiantamento, valor_icms_retido, valor_liquido,
				   valor_falta_avarias, valor_adicional, descricao_valor_adicional,
				   liquido_a_pagar, cotacao_dolar, num_dependentes, base_calc_irrf,
				   outras_deducoes, descarga_por_conta_id, descarga_por_conta,
				   autorizar_pagto_por, autorizar_pagto_data, autorizar_adto_por,
				   autorizar_adto_data, especie, produto, veic_uf, marca,
				   cor_predominante, documentos, crt_vinculados, mic_vinculados, observacoes, cancelado,
				   valor_inss, descricao_inss,
                   (select upper(kss.pkg_pessoa.fnc_get_cliente(i.cod_pessoa_filial))
                      from dual) as razao_social,
                   (select kss.pkg_pessoa.fnc_get_endereco(i.cod_pessoa_filial) || ' - ' ||
                           kss.pkg_pessoa.fnc_get_desc_municipio(kss.pkg_pessoa.fnc_get_municipio_endereco(i.cod_pessoa_filial)) || chr(13) || chr(10) ||
                           (select ' CNPJ: ' || p.identificador || ' INSC ESTAD.: ' || p.inscricao_estadual
                              from kss.v$pessoa p
                             where p.cod_pessoa = i.cod_pessoa_filial ) || chr(13) || chr(10) ||
                            (select ' TEL.: (' || t.fone_ddd || ') ' || t.fone_prefixo || ' ' || t.fone_numero 
                               from kss.v$pessoa_telefone_padrao t
                              where t.cod_pessoa = i.cod_pessoa_filial
                                and t.telefone_tipo_id = 2
                                and rownum = 1)  || 
                            (select ' FAX.: (' || t.fone_ddd || ') ' || t.fone_prefixo || ' ' || t.fone_numero 
                               from kss.v$pessoa_telefone_padrao t
                              where t.cod_pessoa = i.cod_pessoa_filial
                                and t.telefone_tipo_id = 4
                                and rownum = 1) || chr(13) || chr(10) ||
                            (select ' E-mail: ' || (select em.email_completo
                                                      from kss.v$email em
                                                     where e.email_id = em.email_id) 
                               from kss.v$pessoa_email e
                              where e.cod_pessoa = i.cod_pessoa_filial
                                and e.email_padrao = 1
                                and rownum = 1) 
                      from dual) as endereco_email
			  from fiscal.v$intc_despacho_form i
             where despacho_id = #arguments.despacho_id#
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>  	

	<!--- 
	-- PROPSITO
	-- Retorna dados dos documentos que pode ser vinculados ao DTI
	-- NOTAS EXPLICATIVAS
	--  
	--->	
	<cffunction name="get_intc_despacho_documentos" access="remote" returntype="query" output="true">
		<cfargument name="despacho_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select despacho_id, documento_id
			  from fiscal.v$intc_despacho_documentos
             where despacho_id = #arguments.despacho_id#
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>  		

	<!--- 
	-- PROPSITO
	-- Retorna dados dos itens do DTI
	-- NOTAS EXPLICATIVAS
	--  
	--->	
	<cffunction name="get_intc_despacho_itens" access="remote" returntype="query" output="true">
		<cfargument name="despacho_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select di.item_id, di.despacho_id, di.manifesto_id, di.conhecimento_id,
				   c.rem_nome, c.dest_nome,
				   nvl(c.numero_cod_pais || '.' || c.numero_certificado || '.' || c.numero_sequencial,'Nulo') as num_crt,
				   replace(upper(man.numero_cod_pais)||'.'||to_char(man.numero_certificado, '000')||'.'||replace(to_char(man.numero_sequencial, '000,000'), ',', '.'), ' ', '') as num_mic
			  from fiscal.v$intc_despacho_item di
			 left join fiscal.v$intc_conhecimento c
					 on c.conhecimento_id = di.conhecimento_id
			  left join fiscal.v$intc_manifesto man
					 on man.manifesto_id = di.manifesto_id
			 where despacho_id = #arguments.despacho_id#
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>  		

	<!--- 
	-- PROPSITO
	-- Retorna condies de venda para a fatura argentina
	-- NOTAS EXPLICATIVAS
	--  
	--->	
	<cffunction name="get_intc_condicao_venda" access="remote" returntype="query" output="true">
	    <cfargument name="condicao_venda_id" required="no" default="" />
	    <cfargument name="descricao" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select condicao_venda_id, descricao 
			  from fiscal.v$intc_condicao_venda
			 where 1=1
			<cfif Len(Trim(arguments.condicao_venda_id))>
			 and condicao_venda_id = #arguments.condicao_venda_id#
			</cfif>
			<cfif Len(Trim(arguments.descricao))>
			 and descricao like '%#arguments.descricao#%'
			</cfif>
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction> 

	<!--- 
	-- PROPSITO
	-- Retorna dados da fatura
	-- NOTAS EXPLICATIVAS
	--  
	--->	
	<cffunction name="get_intc_fatura" access="remote" returntype="query" output="true">
		<cfargument name="fatura_id" required="no" default="" />
		<cfargument name="num_fatura" required="no" default="" />
		<cfargument name="data_emissao" required="no" default="" />
		<cfargument name="data_inicial" required="no" default="" />
		<cfargument name="data_final" required="no" default="" />
		<cfargument name="tipo_fatura" required="no" default="" />
		<cfargument name="emitida" required="no" default="" />
		<cfargument name="quitada" required="no" default="" />
		<cfargument name="cod_pessoa_cliente" required="no" default="" />
		<cfargument name="cod_pais" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select data_emissao, num_fatura, num_duplicata, fatura_id, cod_pessoa_cliente, cliente, endereco, municipio_uf,
				   pais, iva, cuit, condicao_venda, historico, valor_total, cod_tipo, nvl(valor_iva, 0) as valor_iva, aliquota_iva,
				   valor_total_fatura, valor_extenso, observacao, tipo_fatura, numero_crt, numero_crt_resumido,data_vencimento,
				   to_char(data_vencimento,'dd/mm/yyyy') as data_vencimento_char,
				   substr(observacao,instr(observacao,'Monto a abonar en pesos'), instr(observacao,'. El')-instr(observacao,'Monto a abonar en pesos')) as obs,
				   quitada, cnpj_cpf, emissao_data, pais_crt, condicao_venda, condicao_venda_id, conhecimento_id,
				   valor_pago, valor_total_fatura_2, cotacao_moeda2, '' as bairro
			  from fiscal.v$intc_fatura_dados
  			 where 1=1
			 <cfif Len(Trim(arguments.fatura_id))>
			   and fatura_id = #arguments.fatura_id#
			 </cfif> 
			 <cfif Len(Trim(arguments.num_fatura))>
			   and num_fatura = #arguments.num_fatura#
			 </cfif> 
			 <cfif Len(Trim(arguments.data_emissao))>
			   and data_emissao = '#arguments.data_emissao#'
			 </cfif> 
			 <cfif Len(Trim(arguments.quitada))>
			   and quitada = #arguments.quitada#
			 </cfif> 
			 <cfif Len(Trim(arguments.cod_pessoa_cliente))>
			   and cod_pessoa_cliente = #arguments.cod_pessoa_cliente#
			 </cfif> 
			 <cfif Len(Trim(arguments.tipo_fatura))>
			   and tipo_fatura_id = #arguments.tipo_fatura#
			 </cfif> 
			 <cfif Len(Trim(arguments.emitida))>
			   and emitida = #arguments.emitida#
			 </cfif> 
			 <cfif Len(Trim(arguments.cod_pais))>
			   and pais_crt = '#arguments.cod_pais#'
			 </cfif> 
			 <cfif Len(Trim(arguments.data_inicial)) and Len(Trim(arguments.data_final))>
			   and data_emissao between '#arguments.data_inicial#' and '#arguments.data_final#'
			 </cfif> 
			 order by num_fatura 			 
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction> 	 	
	
	<!--- 
	-- PROPSITO
	-- Retorna dados da fatura que ser utilizado no recibo
	-- ANDERSON 19/03/2010 - ALTERADO
	--->	
	<cffunction name="get_intc_fatura_recibo" access="remote" returntype="query" output="true">
		<cfargument name="fatura_id" required="no" default="" />
		<cfargument name="num_fatura" required="no" default="" />
		<cfargument name="data_recibo" required="no" default="" />
		<cfargument name="quitada" required="no" default="" />
		<cfargument name="cod_pessoa_cliente" required="no" default="" />
		<cfargument name="cod_pais" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select fd.data_emissao
                 , fd.num_fatura
                 , fd.fatura_id
                 , fd.cod_pessoa_cliente
                 , fd.cliente
                 , fd.endereco
                 , fd.municipio_uf
                 , fd.pais
                 , fd.iva
                 , fd.cuit
                 , fd.condicao_venda
                 , fd.historico
                 , fd.valor_total
                 , fd.cod_tipo
                 , fd.valor_iva
                 , fd.aliquota_iva
                 , fd.valor_total_fatura
                 , fd.tipo_fatura_id
                 , nvl(fd.tipo_fatura, 'Factura ' || fd.cod_tipo) as tipo_fatura
                 , fd.numero_crt
                 , fd.data_vencimento
                 , to_char(fd.data_vencimento, 'dd/mm/yyyy') as data_vencimento_char
                 , fd.quitada
                 , fd.cnpj_cpf
                 , fd.emissao_data
                 , fd.pais_crt
                 , fd.condicao_venda
                 , fd.condicao_venda_id
                 , fd.conhecimento_id
                 , fd.valor_pago
                 , (fd.valor_total_fatura - fd.valor_pago) as valor_restante
                 , (fd.valor_total_fatura - fd.valor_pago) * fd.cotacao_moeda2 as valor_restante_2
                 , fd.valor_total_fatura_2
                 , fd.cotacao_moeda2
                 , fd.cod_moeda
                 , fd.cod_moeda2
              from fiscal.v$intc_fatura_dados fd
             where 1 = 1
			 <cfif Len(Trim(arguments.fatura_id))>
			   and fd.fatura_id = #arguments.fatura_id#
			 </cfif> 
			 <cfif Len(Trim(arguments.num_fatura))>
			   and fd.num_fatura = #arguments.num_fatura#
			 </cfif> 
			 <cfif Len(Trim(arguments.data_recibo))>
			   and trunc(fd.data_emissao) <= '#arguments.data_recibo#'
			 </cfif> 
			 <cfif Len(Trim(arguments.quitada))>
			   and fd.quitada = #arguments.quitada#
			 </cfif> 
			 <cfif Len(Trim(arguments.cod_pessoa_cliente))>
			   and fd.cod_pessoa_cliente = #arguments.cod_pessoa_cliente#
			 </cfif> 
			 order by fd.num_fatura 			 
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction> 	

	<!--- 
	-- PROPSITO 
	-- 
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  13/03/2006
	--->		
	<cffunction name="get_fatura" access="remote" returntype="query" output="true">
 		<cfargument name="fatura_id" required="no" default="">
        <cfargument name="tipo_fatura" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select fatura_id,
				   to_char(num_fatura)as num_fatura,
				   num_duplicata, 
				   cod_pessoa_filial,
				   cod_pessoa_cliente,
				   data_emissao,
				   data_vencimento,
				   condicao_venda_id,
				   observacao,
				   cod_moeda,
				   valor_total,
				   cod_moeda2,
				   cotacao_moeda2,
				   valor_moeda2,
				   tipo_fatura,
				   situacao,
				   emitida,
				   quitada,
				   cancelada,
				   num_lancto_ccorrente,
				   fatura_id_pai,
               aliquota_iva,
               valor_iva,
				   oper.pkg_global.fnc_busca_nome_pessoa(cod_pessoa_cliente) as cliente,
                   cod_tipo
			  from fiscal.v$intc_fatura f
			 where 1=1
             <cfif Len(Trim(arguments.fatura_id))>
			   and fatura_id = #arguments.fatura_id#
             </cfif>
             <cfif Len(Trim(arguments.tipo_fatura))>
			   and tipo_fatura = #arguments.tipo_fatura#
               order by f.num_fatura
             </cfif>
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os tipos de dado
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  21/02/2006
	--->		
	<cffunction name="get_tipo_dado" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cod_tipo_dado, descricao from oper.v$tipo_dado
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>	  	
	
	<!--- 
	-- PROPSITO 
	-- Busca as formas de Pagamento das faturar internacionais
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  08/03/2006
	--->		
	<cffunction name="get_intc_forma_pagto" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select forma_pagto_id,
				   descricao,
				   user_insert,
				   date_insert,
				   user_update,
				   date_update,
				   site
			  from fiscal.v$intc_forma_pagto	
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca as faturar com conhecimentos faturados e no quitados
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 22/07/2009 - ALTERADO
	--->		
	<cffunction name="get_intc_conhecimento_pagar" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select fd.fatura_id,
                   fd.cod_pessoa_cliente,
                   fd.num_fatura,
                   fd.tipo_fatura_id as tipo_fatura,
                   fd.cliente,
                   fd.data_emissao,
                   fd.data_vencimento,
                   nvl(fd.valor_total_fatura, 0) as valor_total_fatura,
                   fd.numero_crt,
                   nvl(fd.valor_total, 0) as valor_total,
                   fd.emissao_data,
                   fd.conhecimento_id,
                   (select c.resp_local
                      from fiscal.v$intc_conhecimento c
                     where c.conhecimento_id = fd.conhecimento_id) as origem,
                   (select c.entrega_local
                      from fiscal.v$intc_conhecimento c
                     where c.conhecimento_id = fd.conhecimento_id) as destino,
                   fd.quitada,
                   nvl(fd.valor_total_fatura_2, 0) as valor_total_fatura_2,
                   nvl(fd.valor_pago, 0) as valor_pago,
                   rf.recibo_id,
                   (select count(fa.ocorrencia_id)
                      from fiscal.v$intc_fatura_ocorrencia fa
                     where fa.fatura_id = f.fatura_id) as total_ocorrencias
              from fiscal.v$intc_fatura_dados fd
             inner join fiscal.v$intc_fatura f
                     on f.fatura_id = fd.fatura_id
              left join fiscal.v$intc_recibo_fatura rf
                     on rf.fatura_id = fd.fatura_id
             where fd.valor_pago < fd.valor_total_fatura
               and lower(fd.pais) = 'argentina'
               and fd.quitada = 0
               and fd.data_vencimento is not null
             order by fd.cliente, fd.data_vencimento, fd.num_fatura
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
	<!--- 
	-- PROPSITO 
	-- Busca os atributos das formas de pagamento(cheque)
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  08/03/2006
	--->		
	<cffunction name="get_atributos_forma_pagto" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select a.forma_id, 
				   a.atributo_id, 
				   a.cod_atributo, 
				   a.descricao_resumida, 
				   a.descricao,
				   a.tipo_dado,
				   i.item_id,
				   i.VALOR
			  from fiscal.v$intc_forma_pagto_atributo a
			  left join kss.v$atributo_item i
					 on i.ATRIBUTO_ID = a.atributo_id
			 order by atributo_id, item_id	
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
	<!--- 
	-- PROPSITO 
	-- Busca os pagamentos efetuados com cheque
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  09/03/2006
	--->		
	<cffunction name="get_intc_pagto_cheque" access="remote" returntype="query" output="true">
		<cfargument name="num_cheque" required="no" default="">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfargument name="em_aberto" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select pagto_id,
				   num_recibo,
				   cod_pessoa_cliente,
				   cliente,
				   num_cheque,
				   banco,
				   valor,
				   data_predatado,
				   data_deposito,
				   num_controle_deposito,
				   observacoes,
				   acreditado,
				   sum(valor) over(partition by num_cheque,banco order by num_cheque,banco) as valor_total
			  from fiscal.v$intc_recibo_pagto_cheque 
			 where 1=1
			<cfif len(trim(arguments.data_inicial)) and not len(Trim(arguments.num_cheque))>
			   and to_date(data_predatado, 'dd/mm/yyyy') >= '#arguments.data_inicial#'
			</cfif>
			<cfif len(trim(arguments.data_final)) and not len(Trim(arguments.num_cheque))>
			   and to_date(data_predatado, 'dd/mm/yyyy') <= '#arguments.data_final#'
			</cfif>
			<cfif arguments.em_aberto eq 1 and not len(Trim(arguments.num_cheque))>
			   and (data_deposito is null or num_controle_deposito is null)
			</cfif>
			<cfif Len(Trim(arguments.num_cheque))>
			   and num_cheque = '#arguments.num_cheque#'
			</cfif>
			order by banco, num_cheque 
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca os atributos do pagamento
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  09/03/2006
	--->		
	<cffunction name="get_atributos_pagto" access="remote" returntype="query" output="true">
		<cfargument name="pagto_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select fa.forma_id,
				   fa.atributo_id,
				   fa.cod_atributo,
				   fa.descricao_resumida,
				   fa.descricao,
				   fa.tipo_dado,
				   pa.valor,
				   pa.pagto_id,
		           nvl(sum(decode(cod_atributo, 'VALOR_CHEQUE', to_number(valor), 0)) over (order by forma_id),0) as valor_cheque
			  from fiscal.v$intc_forma_pagto_atributo fa
			 inner join fiscal.v$intc_pagto_atributo pa
					 on pa.atributo_id = fa.atributo_id	
			 where 1=1
			   and pa.pagto_id in (#arguments.pagto_id#)
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	
	<!--- 
	-- PROPSITO 
	-- Busca as faturas
	-- NOTAS EXPLICATIVAS
	-- LEANDRO 19/03/2010 - ALTERADO
	--->		
	<cffunction name="get_intc_fatura_editar" access="remote" returntype="query" output="true">
		<cfargument name="tipo_fatura" required="no" default="">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfargument name="num_fatura" required="no" default="">
        <cfargument name="cod_pessoa_cliente" required="no" default="">
        <cfargument name="num_crt" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select level as nivel,
				   f.fatura_id,
				   f.num_fatura,
                   f.cod_tipo,
				   f.cod_pessoa_filial,
				   f.cod_pessoa_cliente,
				   f.data_emissao,
				   f.condicao_venda_id,
				   f.cod_moeda,
				   f.valor_total,
				   f.observacao,
				   f.cod_moeda2,
				   f.cotacao_moeda2,
				   f.valor_moeda2,
				   f.tipo_fatura,
				   f.fatura_id_pai,
				   f.data_vencimento,
				   f.situacao,
				   f.quitada,
				   f.cancelada,
				   f.num_lancto_ccorrente,
                   c.num_crt_completo,
				   case f.tipo_fatura
				     when 1 then 'Fatura'
					 when 2 then 'Nota de Dbito'
					 when 3 then 'Nota de Crdito'
				   end tipo,
				   oper.pkg_global.fnc_busca_nome_pessoa(f.cod_pessoa_cliente) as cliente,
                   (select count(fa.ocorrencia_id)
                      from fiscal.v$intc_fatura_ocorrencia fa
                     where fa.fatura_id = f.fatura_id) as total_ocorrencias
			  from fiscal.v$intc_fatura f
			 inner join kss.v$pessoa p
		 			 on p.cod_pessoa = f.cod_pessoa_cliente			  
			  left join fiscal.v$intc_fatura_notas fn
					 on fn.fatura_id = f.fatura_id
              left join fiscal.v$intc_conhecimento_faturar cf 
           			 on cf.fatura_id = f.fatura_id
        	  left join fiscal.v$intc_conhecimento c
           			 on c.conhecimento_id = cf.conhecimento_id
		     where 1=1
			   and level in (1,2)
			 start with fatura_nota_id is null
			<cfif len(trim(arguments.num_fatura))>
			   and f.num_fatura = #arguments.num_fatura#
			</cfif>
			<cfif len(trim(arguments.tipo_fatura))>
			   and f.tipo_fatura = #arguments.tipo_fatura#
			</cfif>
			<cfif len(trim(arguments.data_inicial))>
			   and trunc(f.data_emissao) >= '#arguments.data_inicial#'
			</cfif>
			<cfif len(trim(arguments.data_final))>
			   and trunc(f.data_emissao) <= '#arguments.data_final#'
            </cfif>
			<cfif Len(Trim(arguments.cod_pessoa_cliente))>
               and f.cod_pessoa_cliente = #arguments.cod_pessoa_cliente#
            </cfif>
   			<cfif Len(Trim(arguments.num_crt))>
			   and c.num_crt_completo = '#arguments.num_crt#'   
			</cfif>
			connect by prior f.fatura_id = fn.fatura_nota_id			
			order siblings by f.tipo_fatura
    	</cfquery>
		<cfreturn qr_result>
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca os items da fatura
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  13/03/2006
	--->		
	<cffunction name="get_fatura_item" access="remote" returntype="query" output="true">
		<cfargument name="fatura_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select fatura_id,
				   item_id,
				   conhecimento_id,
				   historico,
				   cod_moeda,
				   valor_total
			  from fiscal.v$intc_fatura_item
			 where 1=1
			   and fatura_id = #arguments.fatura_id#
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>			
	
	<!--- 
	-- PROPSITO 
	-- Busca os locais de transbordo cadastrados
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  20/03/2006
	--->		
	<cffunction name="get_intc_local_transbordo" access="remote" returntype="query" output="true">
		<cfargument name="local_id" required="no" default="">
		<cfargument name="municipio_id" required="no" default="">
		<cfargument name="descricao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select local_id,
				   descricao,
				   municipio_id,
				   cep.fnc_cidade_completa(municipio_id) municipio
			  from oper.v$intc_local_transbordo	
			 where 1=1 
			 <cfif len(trim(arguments.local_id))>
			   and local_id = #arguments.local_id#
			 </cfif>
			 <cfif len(trim(arguments.municipio_id))>
			   and municipio_id = #arguments.municipio_id#
			 </cfif>
			 <cfif len(trim(arguments.descricao))>
			   and upper(descricao) like upper('%#arguments.descricao#%')
			 </cfif>
			 order by descricao
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os pagamentos da fatura
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  28/03/2006
	--->		
	<cffunction name="get_intc_fatura_pagto" access="remote" returntype="query" output="true">
		<cfargument name="fatura_id" required="yes">
		<cfargument name="pagto_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select p.pagto_id,
				   p.fatura_id,
				   p.forma_pagto_id,
				   fp.descricao as forma_pagto,
				   p.data_lancamento,
				   p.cod_moeda,
				   p.valor,
				   p.cod_moeda2,
				   p.cotacao_moeda2,
				   p.valor_moeda2,
				   p.num_recibo

				   from fiscal.v$intc_fatura_pagto p
			 inner join fiscal.v$intc_forma_pagto fp
					 on fp.forma_pagto_id = p.forma_pagto_id
			 where 1=1
			   and p.fatura_id = #arguments.fatura_id#
			 <cfif len(trim(arguments.pagto_id))>
			   and p.pagto_id = #arguments.pagto_id#
			 </cfif>
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Relao de CRTs para Importacao
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  03/04/2006
	--->		
	<cffunction name="get_crts_importacao" access="remote" returntype="query" output="true">
		<cfargument name="data_inicial" required="yes">
		<cfargument name="data_final" required="yes">
		<cfargument name="cod_pais" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select replace(c.numero_cod_pais || '.' || c.numero_certificado || '.' || replace(to_char(c.numero_sequencial,'000,000'), ',','.'),' ','') as numero_crt, 
			       c.emissao_data,
				   replace(m.numero_cod_pais || '.' || m.numero_certificado || '.' || replace(to_char(m.numero_sequencial,'000,000'), ',','.'),' ','') as numero_mic,
				   '' as data_embarque,
				   m.veic_orig_placa_controle || ' / ' || m.veic_orig_placa_referencia as placas,
					decode(oper.pkg_veiculo.fnc_veiculo_proprietario(m.veic_orig_placa_controle),1,'Frota',2,'Agregado','Terceiro') as proprietario,
				   (select sum(mci.peso_bruto)
					  from fiscal.v$intc_manifesto_crt_item mci
					 where mci.manifesto_id = mc.manifesto_id
					   and mci.conhecimento_id = mc.conhecimento_id) as peso_bruto,
				   (select sum(mci.valor_fot)
					  from fiscal.v$intc_manifesto_crt_item mci
					 where mci.manifesto_id = mc.manifesto_id
					   and mci.conhecimento_id = mc.conhecimento_id) as valor_mercadoria,
				   (select sum(mci.valor_total)
					  from fiscal.v$intc_manifesto_crt_item mci
					 where mci.manifesto_id = mc.manifesto_id
					   and mci.conhecimento_id = mc.conhecimento_id) as valor_frete,
					mc.rem_nome, mc.dest_nome, c.resp_local as origem_local, m.destino_local,
					decode(c.PAGO_POR,1,c.REM_NOME, c.DEST_NOME) as pagador,
					cep.fnc_cidade_completa(f.municipio_id_1) as fronteira,
					f.descricao as filial, c.cotacao,
					(select sum(ind.valor_servico)/count(*)
					   from fiscal.v$intc_despacho ind
					  inner join fiscal.v$intc_despacho_item idi
					   		  on ind.despacho_id = idi.despacho_id
				      where idi.conhecimento_id = c.conhecimento_id
                        and ind.cancelado = 0
                and ind.cod_motorista = m.veic_orig_mot_cod_pessoa) as total_dti
			  from fiscal.v$intc_manifesto m
			 inner join fiscal.v$intc_manifesto_crt mc
					 on mc.manifesto_id = m.manifesto_id
			 inner join fiscal.v$intc_conhecimento c
					 on c.conhecimento_id = mc.conhecimento_id
			 /* left join oper.v$filial f
			         on f.cod_pessoa = c.cod_pessoa_filial */
			 inner join fiscal.v$intc_conhecimento_fronteira cf
                     on cf.conhecimento_id = c.conhecimento_id
             inner join fiscal.v$fronteira f
					 on f.fronteira_id = cf.FRONTEIRA_ID
			where 1=1
			  <cfif Len(Trim(arguments.cod_pais))>
				  and c.numero_cod_pais = '#arguments.cod_pais#'
			  </cfif>
			  and trunc(c.emissao_data) between '#arguments.data_inicial#' and '#arguments.data_final#'
			order by numero_crt, numero_mic
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
  	
	<!--- 
	-- PROPSITO 
	-- Busca os pagamentos do periodo
	-- NOTAS EXPLICATIVAS
	-- GUTO 28/03/2006
	--->		
	<cffunction name="get_intc_pagtos_geral" access="remote" returntype="query" output="true">
        <cfargument name="data_inicial" required="yes"/>
		<cfargument name="data_final" required="yes"/> 
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select c.EMISSAO_LOCAL,
				   f.data_lancamento, f.NUM_RECIBO,
				   oper.pkg_global.FNC_BUSCA_NOME_PESSOA(fa.COD_PESSOA_CLIENTE) as cliente,
				   c.numero_cod_pais || '.' || c.numero_sequencial as crt,
				   case         
					 when f.forma_pagto_id = 1 then 'Efetivo'
					 when f.forma_pagto_id = 2 then fiscal.pkg_transp_internacional.fnc_get_pagto_atributo(f.pagto_id,100)
					 when f.forma_pagto_id = 3 then 'Depsito' 
					 when f.forma_pagto_id = 4 then 'Retencin'
					 when f.forma_pagto_id = 9 then 'Percepcin de SUSS'                     
					 when f.forma_pagto_id = 8 then 'Percepcin de IVA'
					 else 'Ajuste' end num_cheque,
				   f.VALOR, f.VALOR_MOEDA2
			  from fiscal.v$intc_fatura fa
			 inner join fiscal.v$intc_fatura_pagto f
					 on f.fatura_id = fa.fatura_id
			 inner join fiscal.v$intc_fatura_item fi
					 on fi.fatura_id = f.fatura_id
			 inner join fiscal.v$intc_conhecimento c
					 on c.conhecimento_id = fi.conhecimento_id
			  where 1=1
			 <cfif len(trim(arguments.data_inicial))>
			   and f.data_lancamento >= '#arguments.data_inicial#'
			 </cfif>
			 <cfif len(trim(arguments.data_final))>
			   and f.data_lancamento <= '#arguments.data_final#'
			 </cfif>
			 order by f.num_recibo			 
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca de CRTs por Romaneio, CRT e MIC
	-- NOTAS EXPLICATIVAS
	-- WAGNER  02/02/2007
	--->		
	<cffunction name="get_crts_por_romaneio" access="remote" returntype="query" output="true">
		<cfargument name="numero_crt" required="no" default="">
		<cfargument name="numero_mic" required="no" default="">
		<cfargument name="num_romaneio" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select replace(c.numero_cod_pais || '.' || c.numero_certificado || '.' || replace(to_char(c.numero_sequencial,'000,000'), ',','.'),' ','') as numero_crt, 
			       c.emissao_data,
				   replace(m.numero_cod_pais || '.' || m.numero_certificado || '.' || replace(to_char(m.numero_sequencial,'000,000'), ',','.'),' ','') as numero_mic,
				   '' as data_embarque,
				   m.veic_orig_placa_controle || ' / ' || m.veic_orig_placa_referencia as placas,
					decode(oper.pkg_veiculo.fnc_veiculo_proprietario(m.veic_orig_placa_controle),1,'Frota',2,'Agregado','Terceiro') as proprietario,
				   (select sum(mci.peso_bruto)
					  from fiscal.v$intc_manifesto_crt_item mci
					 where mci.manifesto_id = mc.manifesto_id
					   and mci.conhecimento_id = mc.conhecimento_id) as peso_bruto,
				   (select sum(mci.valor_fot)
					  from fiscal.v$intc_manifesto_crt_item mci
					 where mci.manifesto_id = mc.manifesto_id
					   and mci.conhecimento_id = mc.conhecimento_id) as valor_mercadoria,
				   (select sum(mci.valor_total)
					  from fiscal.v$intc_manifesto_crt_item mci
					 where mci.manifesto_id = mc.manifesto_id
					   and mci.conhecimento_id = mc.conhecimento_id) as valor_frete,
					mc.rem_nome, mc.dest_nome, c.resp_local as origem_local, m.destino_local,
					decode(c.PAGO_POR,1,c.REM_NOME, c.DEST_NOME) as pagador,
					cep.fnc_cidade_completa(f.municipio_id_1) as fronteira,
					f.descricao as filial,
					m.num_romaneio as num_romaneio
			  from fiscal.v$intc_manifesto m
	    inner join fiscal.v$intc_manifesto_crt mc
		    	on mc.manifesto_id = m.manifesto_id
		inner join fiscal.v$intc_conhecimento c
				on c.conhecimento_id = mc.conhecimento_id
		 /* left join oper.v$filial f
			    on f.cod_pessoa = c.cod_pessoa_filial */
		 inner join fiscal.v$intc_conhecimento_fronteira cf
                 on cf.conhecimento_id = c.conhecimento_id
         inner join fiscal.v$fronteira f
				on f.fronteira_id = cf.FRONTEIRA_ID
			where 1=1
			<cfif Len(Trim(arguments.numero_mic))>
			  and m.numero_cod_pais||'.'||lpad(m.numero_certificado,3,'0')||'.'||lpad(m.numero_sequencial,6,'0') = '#arguments.numero_mic#'
			</cfif>
			<cfif Len(Trim(arguments.num_romaneio))>
			  and m.num_romaneio 	= #arguments.num_romaneio#
         	</cfif>
			<cfif Len(Trim(arguments.numero_crt)) and ( not( Len(Trim(arguments.num_romaneio)) ) )>
			  and m.manifesto_id in (select mc.manifesto_id
                           			   from fiscal.v$intc_manifesto_crt mc
                           		 inner join fiscal.v$intc_conhecimento c
                           				 on c.conhecimento_id 	 = mc.conhecimento_id
                           			  where 1=1
                                        and c.numero_cod_pais = '#ListGetAt(arguments.numero_crt,1,".")#'
                                      <cfif listLen(arguments.numero_crt,'.') gt 1>
                                        and c.numero_certificado = '#ListGetAt(arguments.numero_crt,2,".")#'
                                      </cfif>
                                      <cfif listLen(arguments.numero_crt,'.') gt 2>
                                        and c.numero_sequencial = '#ListGetAt(arguments.numero_crt,3,".")#'
                                      </cfif>
                                      )
			<cfelse>
					<cfif Len(Trim(arguments.numero_crt))>
                        and c.numero_cod_pais = '#ListGetAt(arguments.numero_crt,1,".")#'
                      <cfif listLen(arguments.numero_crt,'.') gt 1>
                        and c.numero_certificado = '#ListGetAt(arguments.numero_crt,2,".")#'
                      </cfif>
                      <cfif listLen(arguments.numero_crt,'.') gt 2>
                        and c.numero_sequencial = '#ListGetAt(arguments.numero_crt,3,".")#'
                      </cfif>
					</cfif>
			</cfif>
		  order by numero_crt, numero_mic, num_romaneio 
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca de CRTs por Filial
	-- NOTAS EXPLICATIVAS
	-- Rafael  21/05/2009
	--->		
	<cffunction name="get_crts_por_filial" access="remote" returntype="query" output="true">
		<cfargument name="cod_filial" required="no" default="">
		<cfargument name="data_inicio" required="no" default="">
		<cfargument name="data_fim" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select replace(c.numero_cod_pais || '.' || c.numero_certificado || '.' || replace(to_char(c.numero_sequencial, '000,000'), ',', '.'), ' ', '')
               as numero_crt,
               c.emissao_data,
               replace(m.numero_cod_pais || '.' || m.numero_certificado || '.' || replace(to_char(m.numero_sequencial, '000,000'), ',', '.'), ' ', '')
               as numero_mic,
               '' as data_embarque,
               m.veic_orig_placa_controle || ' / ' || m.veic_orig_placa_referencia as placas,
               decode(oper.pkg_veiculo.fnc_veiculo_proprietario(m.veic_orig_placa_controle),1,'Frota',2,'Agregado','Terceiro')
               as proprietario,
               (select sum(mci.peso_bruto)
                  from fiscal.v$intc_manifesto_crt_item mci
                   where mci.manifesto_id = mc.manifesto_id
                   and mci.conhecimento_id = mc.conhecimento_id) as peso_bruto,
               (select sum(mci.valor_fot)
                  from fiscal.v$intc_manifesto_crt_item mci
                   where mci.manifesto_id = mc.manifesto_id
                   and mci.conhecimento_id = mc.conhecimento_id) as valor_mercadoria,
               (select sum(mci.valor_total)
                  from fiscal.v$intc_manifesto_crt_item mci
                   where mci.manifesto_id = mc.manifesto_id
                   and mci.conhecimento_id = mc.conhecimento_id) as valor_frete,
               mc.rem_nome,
               mc.dest_nome,
               c.resp_local as origem_local,
               m.destino_local,
               decode(c.PAGO_POR, 1, c.REM_NOME, c.DEST_NOME) as pagador,
               cep.fnc_cidade_completa(f.municipio_id_1) as fronteira,
               fi.nome as filial,
               m.num_romaneio as num_romaneio
             from fiscal.v$intc_manifesto m
            inner join fiscal.v$intc_manifesto_crt mc
                    on mc.manifesto_id = m.manifesto_id
            inner join fiscal.v$intc_conhecimento c
                    on c.conhecimento_id = mc.conhecimento_id
            inner join fiscal.v$intc_conhecimento_fronteira cf
                   on cf.conhecimento_id = c.conhecimento_id
            inner join fiscal.v$fronteira f
                   on f.fronteira_id = cf.FRONTEIRA_ID
            left join oper.v$filial fi
                   on fi.cod_pessoa = c.cod_pessoa_filial
          where 1 = 1


			<cfif len(trim(arguments.cod_filial))>
            	and c.cod_pessoa_filial = '#arguments.cod_filial#'
            </cfif>
            <cfif Len(Trim(arguments.data_inicio))>
                and trunc(c.emissao_data) >= '#arguments.data_inicio#'
            </cfif>
            <cfif Len(Trim(arguments.data_fim))>
                and trunc(c.emissao_data) <= '#arguments.data_fim#'
            </cfif>
            
            order by numero_crt, numero_mic, num_romaneio 
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os pagamentos do periodo
	-- NOTAS EXPLICATIVAS
	-- GUTO 28/03/2006
	--->		
	<cffunction name="get_intc_rem_dest" access="remote" returntype="query" output="true">
        <cfargument name="NUMERO_CRT" required="yes"/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select c.conhecimento_id,c.rem_cidade, c.dest_cidade, to_char(c.data_entrega, 'dd/mm/yyyy hh24:mi') as data_entrega
			  from fiscal.v$intc_conhecimento c
			 where 1=1
			<cfif Len(Trim(arguments.numero_crt))>
			   and c.numero_cod_pais||'.'||lpad(c.numero_certificado,3,'0')||'.'||lpad(c.numero_sequencial,6,'0') 	= '#arguments.numero_crt#'
			</cfif>
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO -  - criado
	--->	
	<cffunction name="get_crt_por_modalidade" displayname="" access="remote" returntype="query" output="true">
		<cfargument name="cod_pais" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
				select to_char(c.emissao_data,'mm/yyyy') as mes_ano, to_char(c.emissao_data,'yyyymm') ordem,
							 decode(oper.pkg_veiculo.fnc_veiculo_proprietario(m.veic_orig_placa_controle),1,'Frota',2,'Agregado','Terceiro') as proprietario,
						   sum((select sum(mci.valor_total)
							  from fiscal.v$intc_manifesto_crt_item mci
							 where mci.manifesto_id = mc.manifesto_id
							   and mci.conhecimento_id = mc.conhecimento_id)) as valor_frete
					  from fiscal.v$intc_manifesto m
					 inner join fiscal.v$intc_manifesto_crt mc
							 on mc.manifesto_id = m.manifesto_id
					 inner join fiscal.v$intc_conhecimento c
							 on c.conhecimento_id = mc.conhecimento_id
					 /* left join oper.v$filial f
							 on f.cod_pessoa = c.cod_pessoa_filial */
                     inner join fiscal.v$intc_conhecimento_fronteira cf
                             on cf.conhecimento_id = c.conhecimento_id
                     inner join fiscal.v$fronteira f
                            on f.fronteira_id = cf.FRONTEIRA_ID
					where 1=1
					  and trunc(c.emissao_data) >= trunc(last_day(sysdate-180)+1)
					  <cfif Len(Trim(arguments.cod_pais))>
					   and c.numero_cod_pais = '#arguments.cod_pais#'
					  </cfif>
					group by to_char(c.emissao_data,'mm/yyyy'), to_char(c.emissao_data,'yyyymm'), decode(oper.pkg_veiculo.fnc_veiculo_proprietario(m.veic_orig_placa_controle),1,'Frota',2,'Agregado','Terceiro')
			  order by to_char(c.emissao_data,'yyyymm')
		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>		
	
	<!--- 
	-- PROPSITO 
	-- Busca os items da moeda
	-- NOTAS EXPLICATIVAS
	-- LOUIS  25/04/2006
	--->		
	<cffunction name="get_moeda_bacen" access="remote" returntype="query" output="true">
		<cfargument name="moeda_bacen_id" required="no">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cod_moeda,
				   descricao_moeda,
				   pais,
				   tipo
			from finan.v$moeda_bacen
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>			
	
	<!--- 
	-- PROPSITO 
	-- Busca as cotaes
	-- NOTAS EXPLICATIVAS
	-- LOUIS  26/04/2006
	--->		
	<cffunction name="get_lista_cotacao" access="remote" returntype="query" output="true">
		<cfargument name="cod_moeda" required="no" default="">
		<cfargument name="cod_moeda_conversao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select m.cod_moeda,
			   m.cod_moeda_conversao,
			   m.tipo,
			   m.moeda,
			   m.taxa_compra,
			   m.taxa_venda,
			   m.paridade_compra,
			   m.paridade_venda,
			   to_char(m.data_cotacao,'dd/mm/yyyy') as data_cotacao
			 from finan.v$moeda_bacen_cotacao m
			 where 1=1
			 <cfif len(trim(arguments.cod_moeda))>
			 	and m.cod_moeda = '#arguments.cod_moeda#'
			</cfif>
			 <cfif len(trim(arguments.cod_moeda_conversao))>
			 	and m.cod_moeda_conversao = '#arguments.cod_moeda_conversao#'
			 </cfif>
			 	and m.data_cotacao > (sysdate - 30)
			 	order by m.data_cotacao desc
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>		
	
	
	<!--- 
	-- PROPSITO 
	-- Busca as cotaes de acordo com a data de emissao de fatura
	-- NOTAS EXPLICATIVAS
	-- LOUIS  10/05/2006
	--->		
	<cffunction name="get_cotacao_faturar" access="remote" returntype="query" output="true">
		<cfargument name="data_emissao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select m.cod_moeda,
			   m.cod_moeda_conversao,
			   m.tipo,
			   m.moeda,
			   m.taxa_compra,
			   m.taxa_venda,
			   m.paridade_compra,
			   m.paridade_venda,
			   to_char(m.data_cotacao,'dd/mm/yyyy') as data_cotacao
			 from finan.v$moeda_bacen_cotacao m
			 where 1=1
			 <cfif len(trim(arguments.data_emissao))>
			 	and m.data_cotacao = to_date('#arguments.data_emissao#','dd/mm/yyyy')-1
			</cfif>
				and  m.cod_moeda_conversao='705' and m.cod_moeda='220'
			 	order by m.data_cotacao desc
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca as cotaes de acordo com a data de emissao de fatura
	-- NOTAS EXPLICATIVAS
	-- LOUIS  10/05/2006
	--->		
	<cffunction name="get_cotacao_dias_faturar" access="remote" returntype="query" output="true">
		<cfargument name="data_emissao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select m.cod_moeda,
			   m.cod_moeda_conversao,
			   m.tipo,
			   m.moeda,
			   m.taxa_compra,
			   m.taxa_venda as cotacao_moeda2,
			   m.paridade_compra,
			   m.paridade_venda,
			   to_char(m.data_cotacao,'dd/mm/yyyy') as data_cotacao
			 from finan.v$moeda_bacen_cotacao m
			 where 1=1
			 <cfif len(trim(arguments.data_emissao))>
				and m.data_cotacao 	between to_date('#arguments.data_emissao#','dd/mm/yyyy')-2  and to_date('#arguments.data_emissao#','dd/mm/yyyy')+2
			 </cfif>
			 and  m.cod_moeda_conversao='705' and m.cod_moeda='220'
			 	order by m.data_cotacao desc
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os Complementos do conhecimento
	-- CRISTOFER  24/05/2007
	--->		
	<cffunction name="get_intc_conhecimento_complemento" access="remote" returntype="query" output="true">
		<cfargument name="conhecimento_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cc.conhecimento_id,
				   cc.conhecimento_id_complemento,
				   c.numero_cod_pais || '.' || c.numero_certificado || '.' || replace(replace(to_char(c.numero_sequencial, '000,000'), ',', ''), ' ', '') as numero_crt_complemento,
				   cc.tipo_id,
				   cc.date_insert,
				   cc.user_insert,
				   cc.date_update,
				   cc.user_update,
				   cc.site
			  from fiscal.v$intc_conhecimento_complemen	cc
			 inner join fiscal.v$intc_conhecimento c
			         on c.conhecimento_id = cc.conhecimento_id_complemento
			 where 1=1
			 <cfif len(trim(arguments.conhecimento_id))>
			   and cc.conhecimento_id = #arguments.conhecimento_id#
			 </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Retorna todos os clientes que possuem faturas internacionais
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 14/06/2007 - criado
	--->	
	<cffunction name="get_clientes_intc" displayname="Retorna todos os clientes que possuem faturas internacionais" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="no" default="">
		<cfargument name="cod_cadastro_contribuinte" required="no" default="">
		<cfargument name="razao_social" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select cod_pessoa, cod_cadastro_contribuinte, identificador, 
				   razao_social, cliente 
			  from fiscal.v$intc_clientes
			 where 1=1
			 <cfif len(trim(arguments.cod_pessoa))>
			   and cod_pessoa = #arguments.cod_pessoa#
			 </cfif>
			 <cfif len(trim(arguments.cod_cadastro_contribuinte))>
			   and cod_cadastro_contribuinte = '#arguments.cod_cadastro_contribuinte#'
			 </cfif>
			 <cfif len(trim(arguments.razao_social))>
			   and upper(razao_social) like upper('%#arguments.razao_social#%')
			 </cfif>
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca recibos
	-- GUTO 20/06/2007
	--->		
	<cffunction name="get_intc_recibo" access="remote" returntype="query" output="true">
		<cfargument name="recibo_id" required="no" default="">
		<cfargument name="num_recibo" required="no" default="">
		<cfargument name="cod_pessoa_cliente" required="no" default="">
		<cfargument name="data_emissao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
          select ir.recibo_id, ir.num_recibo, ir.cod_posto_venda, ir.data_emissao, 
                 ir.cod_pessoa_cliente, p.nome as cliente, p.endereco, p.municipio, p.estado_provincia,
                 p.cod_cadastro_contribuinte as cod_cadastro_contribuinte, ir.cod_moeda, ir.cod_moeda_2, ir.cotacao, ir.total_recibo, ir.total_recibo_moeda_2, 
                 ir.total_pagtos, ir.total_pagtos_moeda_2 
            from fiscal.v$intc_recibo ir
           inner join kss.v$pessoa_estrangeira p
               on p.cod_pessoa = ir.cod_pessoa_cliente    
           where 1=1
			 <cfif len(trim(arguments.recibo_id))>
			   and ir.recibo_id = #arguments.recibo_id#
			 </cfif>
			 <cfif len(trim(arguments.data_emissao))>
			   and trunc(ir.data_emissao) = '#arguments.data_emissao#'
			 </cfif>
			 <cfif len(trim(arguments.num_recibo))>
			   and ir.num_recibo = #arguments.num_recibo#
			 </cfif>
			 <cfif len(trim(arguments.cod_pessoa_cliente))>
			   and ir.cod_pessoa_cliente = #arguments.cod_pessoa_cliente#
			 </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca faturas vinculadas a recibos
	-- GUTO 20/06/2007
	--->		
	<cffunction name="get_intc_recibo_fatura" access="remote" returntype="query" output="true">
		<cfargument name="recibo_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select irf.controle_id,

                   irf.recibo_id,
                   irf.fatura_id,
                   decode(f.tipo_fatura, 1, 'Factura ' || f.cod_tipo, 2, 'Nota Dbito', 'Nota Crdito') as tipo_fatura,
                   irf.tipo_pagto,
                   irf.observacao,
                   irf.valor,
                   irf.cotacao,
                   irf.valor_moeda_2,
                   irf.lancamento_caixa_id,
                   (select kss.fnc_concat_all(kss.to_concat_expr(fd.conhecimento_id, ','))
                      from fiscal.v$intc_fatura_dados fd
                     where fd.fatura_id = irf.fatura_id) as conhecimento_id,
                   f.num_fatura,
                   (select kss.fnc_concat_all(kss.to_concat_expr(fd.numero_crt, ' / '))
                      from fiscal.v$intc_fatura_dados fd
                     where fd.fatura_id = irf.fatura_id) as numero_crt,
                   ir.cod_moeda,
                   ir.cod_moeda_2,
                   fcl.controle_id as caixa_controle_id,
                   fla.cod_historico_arg as cod_historico,
                   fcl.cod_centro_custo,
                   sum(irf.valor) over(order by irf.recibo_id desc) as total_uss,
                   sum(irf.valor_moeda_2) over(order by irf.recibo_id desc) as total_pesos
              from fiscal.v$intc_recibo ir
             inner join fiscal.v$intc_recibo_fatura irf
                     on ir.recibo_id = irf.recibo_id
             inner join fiscal.v$intc_fatura f
                     on f.fatura_id = irf.fatura_id
             inner join finan.v$finan_caixa_lancamento fcl
                     on fcl.lancamento_id = irf.lancamento_caixa_id
             inner join finan.v$finan_caixa_lancamento_arg fla
                     on fla.lancamento_id = fcl.lancamento_id
             where 1 = 1
			 <cfif len(trim(arguments.recibo_id))>
			   and ir.recibo_id = #arguments.recibo_id#
			 </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca pagtos vinculadas a recibos
	-- GUTO 20/06/2007
	--->		
	<cffunction name="get_intc_recibo_pagtos" access="remote" returntype="query" output="true">
		<cfargument name="recibo_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select irp.pagto_id, irp.recibo_id, irp.forma_pagto_id, irp.cod_moeda, irp.valor, 
				   irp.cod_moeda2, irp.cotacao_moeda2, irp.valor_moeda2,
				   (select kss.fnc_concat_all(kss.to_concat_expr(ipa.atributo_id,'||'))
					  from fiscal.v$intc_pagto_atributo ipa
					 where ipa.pagto_id = irp.pagto_id) as pagto_atributo_cod,
				   (select kss.fnc_concat_all(kss.to_concat_expr(ipa.valor,'||'))
					  from fiscal.v$intc_pagto_atributo ipa
					 where ipa.pagto_id = irp.pagto_id) as pagto_atributo_valor,
                   case 
                     when irp.forma_pagto_id = 1 then 'Efectivo'
                     when irp.forma_pagto_id = 3 then 'Deposito'
                     when irp.forma_pagto_id = 2 then (select 'Cheque ' || pc.banco || ' Num.:' || pc.num_cheque
                                                         from fiscal.v$intc_recibo_pagto_cheque pc
                                                        where pc.pagto_id = irp.pagto_id)
                     when irp.forma_pagto_id = 4 then 'Retencion ' || fiscal.pkg_transp_internacional.fnc_get_pagto_atributo(irp.pagto_id,125) || ' num.:' || fiscal.pkg_transp_internacional.fnc_get_pagto_atributo(irp.pagto_id,106) || decode(fiscal.pkg_transp_internacional.fnc_get_pagto_atributo(irp.pagto_id,125),'Ingresos Brutos',fiscal.pkg_transp_internacional.fnc_get_pagto_atributo(irp.pagto_id,108))
                     when irp.forma_pagto_id = 6 then 'Transferencia num.:' || fiscal.pkg_transp_internacional.fnc_get_pagto_atributo(irp.pagto_id,137)
                     when irp.forma_pagto_id = 8 then 'Percepcin de IVA num.:' || fiscal.pkg_transp_internacional.fnc_get_pagto_atributo(irp.pagto_id,138)
                     when irp.forma_pagto_id = 9 then 'Percepcin de SUSS num.:' || fiscal.pkg_transp_internacional.fnc_get_pagto_atributo(irp.pagto_id,140)
                     when irp.forma_pagto_id = 7 then 'Nota de Credito num.:' || (select num_fatura 
                                                                                    from fiscal.v$intc_fatura f
                                                                                   where f.fatura_id = fiscal.pkg_transp_internacional.fnc_get_pagto_atributo(irp.pagto_id,142))
                   else '' end observacao
			  from fiscal.v$intc_recibo_pagto irp			  
			 where 1=1
			 <cfif len(trim(arguments.recibo_id))>
			   and irp.recibo_id = #arguments.recibo_id#
			 </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>		

	<!--- 
	-- PROPSITO 
	-- Busca os pagamento dos DTIs
	-- CRISTOFER  25/06/2007
	--->		
	<cffunction name="get_intc_despacho_caixa" access="remote" returntype="query" output="true">
		<cfargument name="despacho_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select dc.despacho_id
                 , dc.lancamento_id
                 , dc.tipo_id
                 , (select distinct cg.rv_meaning
                      from fiscal.v$cg_ref_codes cg
                     where cg.rv_domain = 'INTC_DESPACHO_CAIXA.TIPO_ID'
                       and cg.rv_low_value = dc.tipo_id) as tipo
                 , dc.valor
                 , fl.valor as valor_pesos
                 , dc.date_insert
                 , dc.user_insert
                 , dc.date_update
                 , dc.user_update
                 , dc.site
                 , dc.controle_id
                 , dc.tipo_pagto
                 , (select distinct cg.rv_meaning
                      from fiscal.v$cg_ref_codes cg
                     where cg.rv_domain = 'INTC_DESPACHO_CAIXA.TIPO_PAGTO'
                       and cg.rv_low_value = dc.tipo_pagto) as tipo_pagto_desc
                 , fl.num_docto
                 , to_char(fl.data_lancamento, 'dd/mm/yyyy hh24:mi') as data_lancamento
              from fiscal.v$intc_despacho_caixa dc
             inner join finan.v$finan_caixa_lancamento fl
                     on fl.lancamento_id = dc.lancamento_id
             where 1 = 1
			<cfif len(trim(arguments.despacho_id))>
			   and dc.despacho_id = #arguments.despacho_id#
			</cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os cheques rechazados
	-- CRISTOFER  29/11/2007
	--->		
	<cffunction name="get_cheques_rechazados" access="remote" returntype="query" output="true">
    	<cfargument name="cod_pessoa_cliente" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select num_cheque, 
                   banco, 
                   valor,
                   pc.pagto_id
              from fiscal.v$intc_recibo_pagto_cheque pc
                  inner join fiscal.v$intc_recibo r
                          on r.recibo_id = pc.recibo_id
            where pc.acreditado = 0
           <cfif len(trim(arguments.cod_pessoa_cliente))>
              and pc.cod_pessoa_cliente = #arguments.cod_pessoa_cliente#
           </cfif>
              and not exists (select 0
                                from fiscal.v$intc_fatura_cheque fc
                               where fc.pagto_id = pc.pagto_id)
            order by num_cheque
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
	<!--- 
	-- PROPSITO 
	-- Filtro do relatrio de fretes internacionais
	-- 18/08/2008 CRIADO
	--->		
	<cffunction name="get_frete_internacional" access="remote" returntype="query" output="true">
		<cfargument name="conhecimento_id" required="no" default="">
		<cfargument name="cod_pessoa_filial" required="no" default="">
		<cfargument name="cod_centro_custo" required="no" default="">
		<cfargument name="data_inicio" required="no" default="">
		<cfargument name="data_fim" required="no" default="">
		<cfargument name="data_inicio_primeiro_embarque" required="no" default="">
		<cfargument name="data_fim_primeiro_embarque" required="no" default="">
		<cfargument name="cancelado" required="no" default="">
		<cfargument name="lib_fatura" required="no" default="">
		<cfargument name="faturado" required="no" default="">
		<cfargument name="nao_embarcado" required="no" default="">
		<cfargument name="quitado" required="no" default="">
		<cfargument name="pre_conhecimento" required="no" default="">
		<cfargument name="numero" required="no" default="">
		<cfargument name="conferido" required="no" default="">
		<cfargument name="data_inicio_lib_fatura" required="no" default="">
		<cfargument name="data_fim_lib_fatura" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		select c.conhecimento_id,
       c.versao,
       upper(numero_cod_pais || '.' || numero_certificado || '.' ||
             replace(to_char(numero_sequencial, '000000'), ' ', '')) as numero,
       kss.to_organograma(c.cod_organograma) .cod_centro_custo as cod_centro_custo,
       cce.centro_custo,
       c.cod_organograma,
       emissao_data,
       
       case
         when c.embarcado = 1 and
              (c.data_ult_embarque <= '#arguments.data_inicio#' or
              '#arguments.data_fim#' is null) then
          to_char(c.data_ult_embarque, 'dd/mm/yyyy')
         else
          null
       end as data_ult_embarque,
       
       decode(cancelado, 1, 'Sim', 'No') as cancelado,
       decode(liberado_fatura, 1, 'Sim', 'No') as liberado_fatura,
       data_lib_fatura,
       decode(faturado, 1, 'Sim', 'No') as faturado,
       
       (select kss.fnc_concat_all(kss.to_concat_expr(f.num_fatura, '/'))
          from fiscal.v$intc_fatura f
         inner join fiscal.v$intc_fatura_item ifa on ifa.fatura_id =
                                                     f.fatura_id
         where ifa.conhecimento_id = c.conhecimento_id) as num_fatura,
       
       (select max(f.data_emissao)
          from fiscal.v$intc_fatura f
         inner join fiscal.v$intc_fatura_item ifa on ifa.fatura_id =
                                                     f.fatura_id
         where ifa.conhecimento_id = c.conhecimento_id) as data_fatura,
       
       decode(quitado, 1, 'Sim', 'No') as quitado,
       
       case
         when c.embarcado = 1 and
              (c.data_ult_embarque <= '#arguments.data_inicio#' or
              '#arguments.data_fim#' is null) then
          'Sim'
         else
          'No'
       end as embarcado,
       
       decode(c.pre_conhecimento, 1, 'Sim', 'No') as pre_conhecimento,
       decode(c.impresso, 1, 'Sim', 'No') as impresso,
       decode(c.conferido, 1, 'Sim', 'No') as conferido,
       
       case
         when pago_por = 1 then
          'CRT de amostra'
         when pago_por = 2 then
          rem_nome
         when pago_por = 3 then
          dest_nome
         when pago_por = 4 then
          rem_nome || '/' || dest_nome
       end pagador,
       
       resp_local,
       entrega_local,
       entrega_data as data_entrega,
       peso_bruto,
       (select moeda
          from oper.v$moeda_bacen
         where cod_moeda = valor_total_cod_moeda) as valor_total_cod_moeda,
       total_custo_origem,
       total_custo_destino,
       c.cotacao,
       c.total_custo_origem + c.total_custo_destino as valor_total,
       round((c.total_custo_origem + c.total_custo_destino) * c.cotacao, 2) as total_reais,
       
       nvl((select sum(t.valor_custo_frota)
             from fiscal.v$intc_conhecimento_custo_cont t
            where exists (select *
                     from oper.v$romaneio_intc_conhecimento rc
                    inner join oper.v$romaneio r on r.num_romaneio =
                                                    rc.num_romaneio
                    where rc.conhecimento_id = t.conhecimento_id
                      and (r.data_termino <=
                          '#arguments.data_inicio_lib_fatura#' or
                          '#arguments.data_fim_lib_fatura#' is null))
              and (t.data_custo <= '#arguments.data_inicio_lib_fatura#' or
                  '#arguments.data_fim_lib_fatura#' is null)
              and t.conhecimento_id = c.conhecimento_id),
           0) as valor_custo_frota,
       
       nvl((select sum(t.valor_custo_agregado)
             from fiscal.v$intc_conhecimento_custo_cont t
            where t.conhecimento_id = c.conhecimento_id
              and (t.data_custo <= '#arguments.data_inicio_lib_fatura#' or
                  '#arguments.data_fim_lib_fatura#' is null)),
           0) as valor_custo_agregado,
       
       nvl((select sum(t.valor_custo_terceiro)
             from fiscal.v$intc_conhecimento_custo_cont t
            where t.conhecimento_id = c.conhecimento_id
              and (t.data_custo <= '#arguments.data_inicio_lib_fatura#' or
                  '#arguments.data_fim_lib_fatura#' is null)),
           0) as valor_custo_terceiro,
       
       '#arguments.data_fim_lib_fatura#' as data_final,
       
       (select sum(nvl(r.km_vazio, 0))
          from oper.v$romaneio_intc_conhecimento rc
          left join oper.v$romaneio r on r.num_romaneio = rc.num_romaneio
         where c.conhecimento_id = rc.conhecimento_id) as km_vazio,
       (select sum(nvl(r.km_carregado, 0))
          from oper.v$romaneio_intc_conhecimento rc
          left join oper.v$romaneio r on r.num_romaneio = rc.num_romaneio
         where c.conhecimento_id = rc.conhecimento_id) as km_carregado,
       
       nvl((select sum(nvl(r.km_carregado, 0) + nvl(r.km_vazio, 0))
             from oper.v$romaneio_intc_conhecimento rc
            inner join oper.v$romaneio r on r.num_romaneio =
                                            rc.num_romaneio
            inner join oper.v$romaneio_hist_veiculo rhv on rhv.num_romaneio =
                                                           r.num_romaneio
                                                       and rhv.data_inicio =
                                                           (select min(rhv2.data_inicio)
                                                              from oper.v$romaneio_hist_veiculo rhv2
                                                             where rhv.num_romaneio =
                                                                   rhv2.num_romaneio)
            where c.conhecimento_id = rc.conhecimento_id
              and c.embarcado = 1
              and (c.data_ult_embarque <= '#arguments.data_inicio#' or
                  '#arguments.data_fim#' is null)
              and oper.pkg_veiculo.fnc_veiculo_proprietario(rhv.placa_controle) = 1
           
           ),
           0) as km_frota_embarcado,
       
       nvl((select sum(nvl(r.km_carregado, 0) + nvl(r.km_vazio, 0))
             from oper.v$romaneio_intc_conhecimento rc
            inner join oper.v$romaneio r on r.num_romaneio =
                                            rc.num_romaneio
            inner join oper.v$romaneio_hist_veiculo rhv on rhv.num_romaneio =
                                                           r.num_romaneio
                                                       and rhv.data_inicio =
                                                           (select min(rhv2.data_inicio)
                                                              from oper.v$romaneio_hist_veiculo rhv2
                                                             where rhv.num_romaneio =
                                                                   rhv2.num_romaneio)
            where c.conhecimento_id = rc.conhecimento_id
              and c.embarcado = 1
              and (c.data_ult_embarque <= '#arguments.data_inicio#' or
                  '#arguments.data_fim#' is null)
              and oper.pkg_veiculo.fnc_veiculo_proprietario(rhv.placa_controle) = 2),
           0) as km_agreg_embarcado,
       
       cod_remetente,
       rem_nome,
       rem_endereco,
       rem_cidade,
       rem_uf,
       rem_pais,
       rem_cnpj_cpf,
       
       cod_destinatario,
       dest_nome,
       dest_endereco,
       dest_cidade,
       dest_uf,
       dest_pais,
       dest_cnpj_cpf,
       
       cod_consignatario,
       cons_nome,
       cons_endereco,
       cons_cidade,
       cons_uf,
       cons_pais,
       cons_cnpj_cpf,
       
       cod_notificar,
       not_endereco,
       not_cidade,
       not_uf,
       not_pais,
       not_cnpj_cpf,
       
       c.user_insert,
       c.date_insert,
       c.user_update,
       c.date_update,
       
       (select kss.fnc_concat_all(kss.to_concat_expr(t.num_romaneio, ', '))
          from oper.v$romaneio_intc_conhecimento t
         where t.conhecimento_id = c.conhecimento_id) as num_romaneio,
       
       (select kss.fnc_concat_all(kss.to_concat_expr(upper(m.numero_cod_pais || '.' ||
                                                           m.numero_certificado || '.' ||
                                                           replace(to_char(m.numero_sequencial,
                                                                           '000000'),
                                                                   ' ',
                                                                   '')),
                                                     ', ')) as num_romaneio
          from fiscal.v$intc_manifesto m
         inner join fiscal.v$intc_manifesto_crt t on m.manifesto_id =
                                                     t.manifesto_id
         where t.conhecimento_id = c.conhecimento_id) as num_manifesto
  from fiscal.v$intc_conhecimento c
  left join kss.v$centro_custo cce on cce.cod_centro_custo = kss.to_organograma(c.cod_organograma).cod_centro_custo
 where 1 = 1

			 <cfif Len(Trim(arguments.NAO_EMBARCADO))>
				and (c.embarcado = 0 or c.data_ult_embarque > to_date('#arguments.data_fim#','dd/mm/yyyy'))
			 </cfif>
			 <cfif Len(Trim(arguments.cod_centro_custo))>
			   and kss.to_organograma(c.cod_organograma).cod_centro_custo = #arguments.cod_centro_custo#
			 </cfif>
			 <cfif Len(Trim(arguments.numero))>
			   and upper(numero_cod_pais||'.'||numero_certificado||'.'||replace(to_char(numero_sequencial, '000000'), ' ', '')) = upper('#arguments.numero#')
			 </cfif>
			 <cfif Len(Trim(arguments.conhecimento_id))>
			   and c.conhecimento_id = #arguments.conhecimento_id#
			 </cfif>
			 <cfif Len(Trim(arguments.cod_pessoa_filial))>
			   and c.cod_pessoa_filial = #arguments.cod_pessoa_filial#
			 </cfif>
			 <cfif Len(Trim(arguments.cancelado))>
			   and c.cancelado = #arguments.cancelado#
    		 <cfelse>
			   and c.cancelado = 0
			 </cfif>
			 <cfif Len(Trim(arguments.lib_fatura))>
			   and c.liberado_fatura = #arguments.lib_fatura#
			 </cfif>
			 <cfif Len(Trim(arguments.faturado)) and arguments.faturado eq 1>
			   and exists (select 'x'
				                  from fiscal.v$intc_conhecimento_receber cr
									  where cr.conhecimento_id = c.conhecimento_id)
			 <cfelseif Len(Trim(arguments.faturado)) and arguments.faturado eq 0>
			   and not exists (select 'x'
				                  from fiscal.v$intc_conhecimento_receber cr
									  where cr.conhecimento_id = c.conhecimento_id)
			 </cfif>
			 <cfif Len(Trim(arguments.quitado))>
			   and c.quitado = #arguments.quitado#
			 </cfif>
			 <cfif Len(Trim(arguments.conferido))>
			   and c.conferido = #arguments.conferido#
			 </cfif>
			 <cfif Len(Trim(arguments.pre_conhecimento))>
			   and c.pre_conhecimento = #arguments.pre_conhecimento#
    		 <cfelse>
			   and c.pre_conhecimento = 0
			 </cfif>
    
			 <cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_fim))>
			   and to_date(to_char(c.emissao_data,'dd/mm/yyyy'),'dd/mm/yyyy') between to_date('#arguments.data_inicio#','dd/mm/yyyy') and to_date('#arguments.data_fim#','dd/mm/yyyy')
			 </cfif>
             <cfif Len(Trim(arguments.data_inicio_primeiro_embarque)) and Len(Trim(arguments.data_fim_primeiro_embarque))>
			   and to_date(to_char(c.data_ult_embarque,'dd/mm/yyyy'),'dd/mm/yyyy') between to_date('#arguments.data_inicio_primeiro_embarque#','dd/mm/yyyy') and to_date('#arguments.data_fim_primeiro_embarque#','dd/mm/yyyy')
			 </cfif>
			 <cfif Len(Trim(arguments.data_inicio_lib_fatura)) and Len(Trim(arguments.data_fim_lib_fatura))>
			   and to_date(to_char(c.data_lib_fatura,'dd/mm/yyyy'),'dd/mm/yyyy') between to_date('#arguments.data_inicio_lib_fatura#','dd/mm/yyyy') and to_date('#arguments.data_fim_lib_fatura#','dd/mm/yyyy')
			 </cfif>

			 order by c.numero_cod_pais, c.numero_certificado, c.numero_sequencial       
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca dados do item do romaneio
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 27/04/2009
	--->
	<cffunction name="get_romaneio_item" displayname="Busca o item do romaneio" access="remote" returntype="query" output="true">
		<cfargument name="num_romaneio" required="yes" />
		<cfargument name="item_id" required="no" default="" />
		<cfargument name="frete_proprio" displayname="FLAG que indica se a consulta  por frete propio" required="no" default="1" />
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select /*+ ordered */
                   ri.num_romaneio, 
                   ri.item_id, 
                   ri.operacao_id, 
                   ri.viagem_carga_id,                    
                   ri.volume, 
                   ri.m3, 
                   ri.valor_frete,
                   ri.cod_remetente, 
                   rem.razao_social as remetente, 
                   rem.cnpj_cpf as rem_cnpj_cpf,
                   rmun.municipio as rem_municipio, 
                   rmun.uf_id as rem_uf,
                   rend.logradouro || ', ' || rend.numero || ' - ' || rend.complemento as rem_endereco, 
                   to_char(rend.cep) as rem_cep, 
                   rend.bairro as rem_bairro, 
                   initcap(rmun.municipio) as coleta, 
                   rem.inscricao_estadual as rem_inscr_estadual, 
                   ri.cod_destinatario, 
                   dest.razao_social as destinatario, 
                   dest.cnpj_cpf as dest_cnpj_cpf, 
                   dend.logradouro || ', ' || dend.numero || ' - ' || dend.complemento as dest_endereco,
                   dmun.uf_id as dest_uf,
                   to_char(dend.cep) as dest_cep, 
                   dend.bairro as dest_bairro, 
                   initcap(dmun.municipio) as dest_municipio,
                   dest.cod_atividade_fiscal as dest_atividade_fiscal,          
                   dest.inscricao_estadual as dest_inscr_estadual,
                   ri.observacao, 
                   0 as icms_incluso,    
                   1 as pedagio_incluso, 
                   slc.valor_em as frete_em, 
                   fiscal.pkg_fiscal.fnc_converte_peso(ri.peso, 'Kg', slc.cod_unidade) as peso,
                   '' as rodape,
                   decode(slc.cod_destinatario, null, 0, 1) as lote_com_destinatario,
                   op.frete_proprio, 
                   op.regra_fiscal_id, 
                   ri.redespacho,
                   InitCap(dmun.municipio) entrega,
                   dmun.uf_id as entrega_uf                       
              from oper.v$romaneio_item ri
             inner join logistica.v$viagem_carga vc
                     on vc.viagem_carga_id = ri.viagem_carga_id
             inner join logistica.v$solicitacao_carga slc
                     on slc.solicitacao_carga_id = vc.solicitacao_carga_id
             inner join logistica.v$operacao op  
                     on op.operacao_id = ri.operacao_id
             inner join kss.v$pessoa rem
                     on ri.cod_remetente = rem.cod_pessoa
             inner join kss.v$pessoa_endereco rend
                     on rend.cod_pessoa = rem.cod_pessoa
                    and rend.endereco_padrao = 1
             inner join cep.municipio rmun
                     on coalesce(slc.origem_municipio_id,rend.municipio_id) = rmun.municipio_id
              left join kss.v$pessoa dest
                     on ri.cod_destinatario = dest.cod_pessoa
              left join kss.v$pessoa_endereco dend
                     on dend.cod_pessoa = dest.cod_pessoa
                    and dend.endereco_padrao = 1
              left join cep.municipio dmun
                     on coalesce(slc.destino_municipio_id,dend.municipio_id) = dmun.municipio_id
			 where ri.num_romaneio = #arguments.num_romaneio#
			 <cfif Len(Trim(arguments.item_id))>
			   and ri.item_id = #arguments.item_id#
			 </cfif>
 			 <cfif arguments.frete_proprio eq 1>
			   and op.frete_proprio = 1
			 <cfelse>
			   and op.frete_proprio <> 1
			 </cfif>
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca os permissos
	-- RAFAEL   29/11/2007
	--->		
	<cffunction name="get_permisso" access="remote" returntype="query" output="true">
    	<cfargument name="tipo_documento" required="no" default="">
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.permisso_id
            	  ,t.cod_pais
                  ,t.num_permisso
                  ,t.num_sequencial_inicial
                  ,t.tipo_documento
                  ,t.serie
                  ,decode(t.tipo_documento, 0 , 'CRT', 1, 'MIC', 'Outros') as tipo_descricao
            from fiscal.v$intc_permisso t
        <cfif Len(Trim(#arguments.tipo_documento#))>
           where t.tipo_documento = #arguments.tipo_documento# 
        </cfif>
            order by t.cod_pais
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

    <!--- 
	-- PROPSITO
	-- Retorna a cotao do dlar do dia anterior ao informado
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 18/05/2009
	--->
	<cffunction name="get_cotacao" displayname="Retorna a cotao do dlar do dia anterior ao informado" output="true" returntype="query" access="remote">
		<cfargument name="data" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select round((select /*+ FIRST_ROWS */ mc.taxa_compra
                            from finan.v$moeda_bacen_cotacao mc
                           where mc.cod_moeda = 220
                             and mc.cod_moeda_conversao = 790
                             and mc.data_cotacao = (select /*+ ALL_ROWS */ max(mc2.data_cotacao)
                                                      from finan.v$moeda_bacen_cotacao mc2
                                                     where trunc(mc2.data_cotacao) < to_date('#arguments.data#','dd/mm/yyyy') - 1)), 3) as cotacao
              from dual
  		</cfquery>
		<cfreturn qr_result>
	</cffunction> 
	
    <!--- 
	-- PROPSITO
	-- Retorna o prximo nmero de CRT de acordo com o pas informado
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 18/05/2009
	--->
	<cffunction name="get_prox_num_seq" displayname="Retorna o prximo nmero de CRT de acordo com o pas informado" output="true" returntype="query" access="remote">
		<cfargument name="cod_pais" required="yes">
        <cfargument name="tipo_documento" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select fiscal.pkg_transp_internacional.fnc_prox_num_seq('#arguments.cod_pais#','#arguments.tipo_documento#') as prox_num_seq from dual
  		</cfquery>
		<cfreturn qr_result>
	</cffunction> 
    
     <!--- 
	-- PROPSITO
	-- Retorna os dados para preenchmento de Espelho de CRT
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 22/06/2009
	--->
	<cffunction name="get_crt_espelho" displayname="Retorna os dados para preenchmento de Espelho de CRT" output="true" returntype="query" access="remote">
		<cfargument name="conhecimento_id" required="yes">

        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
       select  c.cod_pessoa_filial as cod_emitente
               ,fi.nome as emitente
               ,c.num_crt_completo
               ,c.obs_pago_por
               ,nvl(c.rem_cnpj_cpf,c.cod_remetente) as cod_remetente
               ,c.rem_nome
               ,nvl(c.dest_cnpj_cpf,c.cod_destinatario) as cod_destinatario
       		   ,c.dest_nome
               ,nvl(c.cons_cnpj_cpf,c.cod_consignatario) as cod_consignatario
               ,c.cons_nome
               ,me.cep as emissao_cep
               ,c.emissao_local
               ,mr.cep as resp_cep
               ,c.resp_local
               ,ment.cep as entrega_cep
               ,c.entrega_local
               ,a.codigo as rota
               ,a.nome as rota_descricao
               ,c.num_especie
               ,e.abreviatura as especie_descricao
               ,ci.produto_id
               ,n.descricao as produto_descricao
               ,c.organizacional_id_gerencial
               , (select substr(replace(sys_connect_by_path(o.descricao, '@@'),'@@','/'),2) as descricao_completa
                    from kss.v$organizacional o
                   where o.organizacional_id = c.organizacional_id_gerencial      
              start with o.organizacional_id_pai = -1
        connect by prior o.organizacional_id = o.organizacional_id_pai) as organizacional_descricao
               ,nvl(c.quantidade_total,0) as quantidade_total
               ,nvl(c.m3,0) as m3
               ,nvl(c.peso_liquido,0) as peso_liquido
               ,nvl(c.peso_bruto,0) as peso_bruto
               ,(select kss.fnc_concat_all(kss.to_concat_expr(a.descricao, chr(10)))
               from fiscal.v$intc_conhecimento_anexo a
              where a.conhecimento_id = c.conhecimento_id) as documentos
              ,nvl(c.cotacao,0) as cotacao
              ,nvl(c.valor_mercadorias,0) as valor_mercadorias
              ,(select b.moeda from finan.v$moeda_bacen b where b.cod_moeda = c.valor_mercadorias_cod_moeda) as mercadorias_moeda
              ,nvl(c.valor_frt_externo,0) as valor_frt_externo
              ,(select b.moeda from finan.v$moeda_bacen b where b.cod_moeda = c.valor_frt_externo_cod_moeda) as frt_externo_cod_moeda
              ,nvl(c.valor_reembolso,0) as valor_reembolso
              ,(select b.moeda from finan.v$moeda_bacen b where b.cod_moeda = c.valor_reembolso_cod_moeda) as reembolso_cod_moeda
              ,to_char(c.emissao_data, 'dd/mm/yyyy') as emissao_data
              ,to_char(c.data_entrega, 'dd/mm/yyyy') as data_entrega
              ,decode(c.pago_por,1,'Amostra',2,'Na Origem',3,'No Destino',4,'Na Origem e no Destino') as situacao
              ,decode(c.pago_por,2,c.rem_nome,3,c.dest_nome,4,c.rem_nome) as pago_por
         from fiscal.v$intc_conhecimento c
        inner join fiscal.v$intc_conhecimento_item ci
           on ci.conhecimento_id = c.conhecimento_id
        left join cep.municipio me
           on me.municipio_id = c.emissao_municipio_id
        left join cep.municipio mr
           on mr.municipio_id = c.resp_municipio_id
        left join cep.municipio ment
           on ment.municipio_id = c.entrega_municipio_id
        left join fiscal.v$intc_conhecimento_fronteira cf
           on cf.conhecimento_id = c.conhecimento_id
        left join fiscal.v$alfandega a 
           on a.alfandega_id = cf.fronteira_id
        left join oper.v$especie e
           on e.num_especie = c.num_especie
        left join oper.v$natureza n
           on n.num_natureza = ci.produto_id
        left join oper.v$filial fi
           on fi.cod_pessoa = c.cod_pessoa_filial
        where c.conhecimento_id = '#arguments.conhecimento_id#'
  		</cfquery>
		<cfreturn qr_result>
	</cffunction> 
    
    
	<!--- 
	-- PROPSITO
	-- Retorna os itens para preenchmento de Espelho de CRT
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 22/06/2009
	--->
	<cffunction name="get_crt_espelho_itens" displayname="Retorna os itens para preenchmento de Espelho de CRT" output="true" returntype="query" access="remote">
		<cfargument name="conhecimento_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
           select descricao
           ,valor_origem as valor
      from fiscal.v$intc_conhecimento_custo cco
     where conhecimento_id = '#arguments.conhecimento_id#'
       and cco.VALOR_ORIGEM > 0
     union select descricao
           ,valor_destino as valor
      from fiscal.v$intc_conhecimento_custo cc
     where conhecimento_id = '#arguments.conhecimento_id#'
       and cc.VALOR_DESTINO > 0
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna os Tipos de Ocorrncias de Fatura
	-- NOTAS EXPLICATIVAS
	-- Rafael 22/07/2009 - criado
	--->	
	<cffunction name="get_tipo_ocorrencia_fatura" displayname="Retorna os Tipos de Ocorrncias de Fatura" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
          select tipo_id
                ,descricao
            from fiscal.v$intc_fatura_tipo_ocorrencia
        order by descricao
  		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction> 
    
    <!--- 
	-- PROPSITO
	-- Retorna as Ocorrncias de Fatura
	-- NOTAS EXPLICATIVAS
	-- Rafael 22/07/2009 - criado
	--->	
	<cffunction name="get_ocorrencia_fatura" displayname="Retorna as Ocorrncias de Fatura" access="remote" returntype="query" output="true">
    	<cfargument name="fatura_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
          select fo.ocorrencia_id
                ,fo.fatura_id
                ,f.num_fatura
                ,fo.tipo_ocorrencia_id
                ,fto.descricao
                ,to_char(fo.data_ocorrencia,'DD/MM/YYYY') as data_ocorrencia
                ,fo.observacao
                ,fo.user_insert
                ,to_char(fo.date_insert,'DD/MM/YYYY') as date_insert
                ,f.cod_tipo
                ,f.tipo_fatura
            from fiscal.v$intc_fatura_ocorrencia fo
      inner join fiscal.v$intc_fatura f
              on f.fatura_id = fo.fatura_id
      inner join fiscal.v$intc_fatura_tipo_ocorrencia fto
              on fto.tipo_id = fo.tipo_ocorrencia_id
           where 1 = 1
          <cfif Len(Trim(arguments.fatura_id))>
            and fo.fatura_id = '#arguments.fatura_id#'
          </cfif>
          order by fo.date_insert
  		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna um nmero por extenso em espanhol
    -- ANDERSON 07/08/2009
    --->		
    <cffunction name="get_valor_extenso_espanhol" access="remote" returntype="query" output="true">
        <cfargument name="valor" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select kss.pkg_string.fnc_extenso_espanhol(#arguments.valor#) as valor_extenso from dual
        </cfquery>
        <cfreturn qr_result>
    </cffunction> 
    
    <!--- 
    -- PROPSITO 
    -- Busca as programaes de cargas
    -- ANDERSON 11/01/2010 - ALTERADO
    --->		
    <cffunction name="get_intc_programacao" access="remote" returntype="query" output="true">
        <cfargument name="programacao_id" required="no" default="" />
        <cfargument name="tipo_id" required="no" default="" />
        <cfargument name="cod_remetente" required="no" default="" />
        <cfargument name="cod_destinatario" required="no" default="" />
        <cfargument name="coleta_municipio" required="no" default="" />
        <cfargument name="entrega_municipio" required="no" default="" />
        <cfargument name="data_inicio" required="no" default="" />
        <cfargument name="data_fim" required="no" default="" />
        <cfargument name="consolidada" required="no" default="" />
        <cfargument name="cancelada" required="no" default="0" hint="0-No; 1-Sim" />
        <cfargument name="situacao_id" required="no" default="" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select p.programacao_id
                 , p.tipo_id
                 , (select cg.rv_abbreviation
                      from kss.cg_ref_codes cg
                     where cg.owner = 'OPER'
                       and cg.rv_domain = 'INTC_PROGRAMACAO.TIPO_ID'
                       and cg.rv_low_value = p.tipo_id) as tipo
                 , to_char(p.data, 'dd/mm/yyyy') as data
                 , p.cod_remetente
                 , (select decode(pe.tipo_pessoa, 2, nvl(pes.cod_cadastro_contribuinte, pes.cod_pessoa), pe.cnpj_cpf)
                      from kss.v$pessoa pe
                      left join kss.v$pessoa_estrangeira pes
                             on pes.cod_pessoa = pe.cod_pessoa
                     where pe.cod_pessoa = p.cod_remetente) as rem_cnpj_cpf
                 , (select pe.razao_social
                      from kss.v$pessoa pe
                     where pe.cod_pessoa = p.cod_remetente) as rem_razao_social
                 , p.coleta_municipio_id
                 , (select m.municipio
                      from cep.municipio m
                     where m.municipio_id = p.coleta_municipio_id) as coleta_municipio
                 , (select m.uf_id
                      from cep.municipio m
                     where m.municipio_id = p.coleta_municipio_id) as coleta_uf
                 , (pr.razao_social || ' (' ||
                    mc.municipio || ' - ' ||
                    mc.uf_id || ' - ' ||
                    (select pa.descricao
                       from cep.pais pa
                      where pa.pais_id = mc.pais_id) || ')') as origem
                 , p.cod_destinatario
                 , (select decode(pe.tipo_pessoa, 2, nvl(pes.cod_cadastro_contribuinte, pes.cod_pessoa), pe.cnpj_cpf)
                      from kss.v$pessoa pe
                      left join kss.v$pessoa_estrangeira pes
                             on pes.cod_pessoa = pe.cod_pessoa
                     where pe.cod_pessoa = p.cod_destinatario) as dest_cnpj_cpf
                 , (select pe.razao_social
                      from kss.v$pessoa pe
                     where pe.cod_pessoa = p.cod_destinatario) as dest_razao_social
                 , p.entrega_municipio_id
                 , (select m.municipio
                      from cep.municipio m
                     where m.municipio_id = p.entrega_municipio_id) as entrega_municipio
                 , (select m.uf_id
                      from cep.municipio m
                     where m.municipio_id = p.entrega_municipio_id) as entrega_uf
                 , (pd.razao_social || ' (' ||
                    me.municipio || ' - ' ||
                    me.uf_id || ' - ' ||
                    (select pa.descricao
                       from cep.pais pa
                      where pa.pais_id = me.pais_id) || ')') as destino
                 , p.fronteira_id
                 , (select f.descricao
                      from fiscal.v$fronteira f
                     where f.fronteira_id = p.fronteira_id) as fronteira
                 , p.quantidade_veiculos
                 , p.consolidada
                 , decode(p.consolidada, 0, 'No', 1, 'Sim', '') as consolidada_descricao
                 , p.programacao_id_vinculo
                 , p.observacao
                 , to_char(p.data_cancelamento, 'dd/mm/yyyy hh24:mi') as data_cancelamento
                 , p.usuario_cancelamento
                 , p.motivo_cancelamento
                 , kss.fnc_ref_code('OPER', 'INTC_PROGRAMACAO.SITUACAO_ID', p.situacao_id) as situacao
              from oper.v$intc_programacao p
             inner join kss.v$pessoa pr
                     on pr.cod_pessoa = p.cod_remetente
             inner join kss.v$pessoa pd
                     on pd.cod_pessoa = p.cod_destinatario
             inner join cep.municipio mc
                     on mc.municipio_id = p.coleta_municipio_id
             inner join cep.municipio me
                     on me.municipio_id = p.entrega_municipio_id
             where 1 = 1
			<cfif Len(Trim(arguments.programacao_id))>
               and p.programacao_id = #arguments.programacao_id#
            </cfif>
            <cfif Len(Trim(arguments.tipo_id))>
               and p.tipo_id = #arguments.tipo_id#
            </cfif>
            <cfif Len(Trim(arguments.cod_remetente))>
               and p.cod_remetente = #arguments.cod_remetente#
            </cfif>
            <cfif Len(Trim(arguments.cod_destinatario))>
               and p.cod_destinatario = #arguments.cod_destinatario#
            </cfif>
            <cfif Len(Trim(arguments.coleta_municipio))>
               and upper(kss.pkg_string.fnc_string_clean(mc.municipio)) like upper(kss.pkg_string.fnc_string_clean('%#arguments.coleta_municipio#%'))
            </cfif>
            <cfif Len(Trim(arguments.entrega_municipio))>
               and upper(kss.pkg_string.fnc_string_clean(me.municipio)) like upper(kss.pkg_string.fnc_string_clean('%#arguments.entrega_municipio#%'))
            </cfif>
            <cfif Len(Trim(arguments.data_inicio))>
               and trunc(p.data) >= '#arguments.data_inicio#'
            </cfif>
            <cfif Len(Trim(arguments.data_fim))>
               and trunc(p.data) <= '#arguments.data_fim#'
            </cfif>
            <cfif Len(Trim(arguments.consolidada))>
               and p.consolidada = #arguments.consolidada#
            </cfif>
            <cfif arguments.cancelada eq 0>
               and p.data_cancelamento is null
            </cfif>
            <cfif Len(Trim(arguments.situacao_id))>
               and p.situacao_id = #arguments.situacao_id#
            </cfif>
             order by p.data desc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as ocorrncias de uma programao de carga
    -- ANDERSON 15/07/2010 - CRIADO
    --->		
    <cffunction name="get_intc_programacao_ocorrencia" access="remote" returntype="query" output="true">
    	<cfargument name="programacao_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select po.programacao_id
                 , po.ocorrencia_id
                 , o.tipo_id
                 , (select ot.descricao
                      from oper.v$intc_ocorrencia_tipo ot
                     where ot.tipo_id = o.tipo_id
                   ) as tipo
                 , o.usuario
                 , to_char(o.data, 'dd/mm/yyyy hh24:mi:ss') as data
                 , o.comentario
                 , o.ocorrencia_id_origem
              from oper.v$intc_programacao_ocorrencia po
             inner join oper.v$intc_ocorrencia o
                     on o.ocorrencia_id = po.ocorrencia_id
             where po.programacao_id = #arguments.programacao_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Busca as programaes de cargas abertas
    -- ANDERSON 08/01/2010 - ALTERADO
    --->		
    <cffunction name="get_intc_programacao_abertas" access="remote" returntype="query" output="true">
        <cfargument name="tipo_id" required="no" default="" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select pa.programacao_id
                 , pa.tipo
                 , to_char(pa.data_programacao, 'dd/mm/yyyy') as data_programacao
                 , pa.origem
                 , pa.destino
                 , pa.quantidade_veiculos
                 , pa.qtde_veiculos_embarcados
                 , pa.consolidada
                 , pa.consolidada_desc
                 , pa.programacao_id_vinculo
                 , pa.observacao_programacao
                 , pa.viagem_id
                 , pa.num_viagem
                 , to_char(pa.data_saida_viagem, 'dd/mm/yyyy hh24:mi') as data_saida_viagem
                 , pa.qtde_embarques_viagem
                 , pa.embarque_id
                 , pa.conhecimento_id
                 , pa.num_conhecimento
                 , pa.crt_programacao
                 , pa.manifesto_id
                 , pa.num_manifesto
                 , pa.nome_motorista
                 , pa.cod_veiculo_cavalo
                 , pa.cod_veiculo_carreta
                 , to_char(pa.data_saida_embarque, 'dd/mm/yyyy hh24:mi') as data_saida_embarque
                 , to_char(pa.previsao_chegada_fronteira, 'dd/mm/yyyy hh24:mi') as previsao_chegada_fronteira
                 , pa.fronteira
                 , pa.dta_desc
                 , pa.transbordo_desc
                 , pa.observacao_embarque
                 , pa.qte_programacao_anexos
                 , pa.qtde_embarque_anexos
                 , pa.situacao_id
                 , pa.data_termino
              from oper.v$intc_programacao_abertas pa
             where ((pa.data_termino is null and pa.embarque_id is not null) or pa.situacao_id=1)
			<cfif Len(Trim(arguments.tipo_id))>
               and pa.tipo_id = #arguments.tipo_id#
            </cfif>
             order by pa.tipo_id, pa.programacao_id, pa.viagem_id, pa.data_saida_embarque
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Busca as viagens
    -- ANDERSON 07/11/2009 - ALTERADO
    --->		
    <cffunction name="get_intc_viagem" access="remote" returntype="query" output="true">
        <cfargument name="viagem_id" required="no" default="" />
        <cfargument name="programacao_id" required="no" default="" />
        <cfargument name="num_viagem" required="no" default="" />
        <cfargument name="abertas" required="no" default="0" hint="0-No; 1-Sim" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select v.viagem_id
                 , v.programacao_id
                 , v.num_viagem
                 , to_char(v.data_saida, 'dd/mm/yyyy hh24:mi') as data_saida
                 , to_char(v.data_termino, 'dd/mm/yyyy hh24:mi') as data_termino
                 , (select sign(count(*))
                              from oper.v$intc_viagem_embarque ve
                     where ve.viagem_id = v.viagem_id) as possui_embarque
              from oper.v$intc_viagem v
             where 1 = 1
			<cfif Len(Trim(arguments.viagem_id))>
               and v.viagem_id = #arguments.viagem_id#
            </cfif>
            <cfif Len(Trim(arguments.programacao_id))>
               and v.programacao_id = #arguments.programacao_id#
            </cfif>
            <cfif Len(Trim(arguments.num_viagem))>
               and v.num_viagem = #arguments.num_viagem#
            </cfif>
            <cfif arguments.abertas eq 1>
               and v.data_termino is null
            </cfif>
             order by v.num_viagem asc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Busca os embarques
    -- ANDERSON 11/01/2010 - ALTERADO
    --->		
    <cffunction name="get_intc_embarque" access="remote" returntype="query" output="true">
        <cfargument name="embarque_id" required="no" default="" />
        <cfargument name="viagem_id" required="no" default="" />
        <cfargument name="conhecimento_id" required="no" default="" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select v.viagem_id
                 , v.num_viagem
                 , to_char(v.data_saida, 'dd/mm/yyyy hh24:mi') as data_saida_viagem
                 , ve.embarque_id
                 , ve.conhecimento_id
                 , (select c.numero_cod_pais ||
                           '.' || c.numero_certificado ||
                           '.' || replace(to_char(c.numero_sequencial, '000000'), ' ', '')
                      from fiscal.v$intc_conhecimento c
                     where c.conhecimento_id = ve.conhecimento_id) as num_conhecimento
                 , ve.manifesto_id
                 , ve.cod_motorista
                 , oper.pkg_global.fnc_get_cod_funcionario(ve.cod_motorista) as cod_funcionario_motorista
                 , oper.pkg_global.fnc_busca_nome_pessoa(ve.cod_motorista) as nome_motorista
                 , ve.placa_cavalo
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(ve.placa_cavalo) as cod_veiculo_cavalo
                 , ve.placa_carreta
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(ve.placa_carreta) as cod_veiculo_carreta
                 , to_char(ve.data_saida, 'dd/mm/yyyy hh24:mi') as data_saida
                 , to_char(ve.previsao_chegada_fronteira, 'dd/mm/yyyy hh24:mi') as previsao_chegada_fronteira
                 , ve.fronteira_id
                 , ve.cod_despachante_origem
                 , (select p.cnpj_cpf
                      from kss.v$pessoa p
                     where p.cod_pessoa = ve.cod_despachante_origem) as cnpj_cpf_despachante_origem
                 , (select p.razao_social
                      from kss.v$pessoa p
                     where p.cod_pessoa = ve.cod_despachante_origem) as despachante_origem
                 , ve.cod_despachante_destino
                 , (select p.cnpj_cpf
                      from kss.v$pessoa p
                     where p.cod_pessoa = ve.cod_despachante_destino) as cnpj_cpf_despachante_destino
                 , (select p.razao_social
                      from kss.v$pessoa p
                     where p.cod_pessoa = ve.cod_despachante_destino) as despachante_destino
                 , ve.factura
                 , ve.sd
                 , ve.tras
                 , ve.pe
                 , ve.di
                 , ve.dta
                 , ve.transbordo
                 , ve.local_transbordo_id
                 , to_char(ve.data_descarga_transbordo, 'dd/mm/yyyy hh24:mi') as data_descarga_transbordo
                 , to_char(ve.data_carga_transbordo, 'dd/mm/yyyy hh24:mi') as data_carga_transbordo
                 , ve.placa_cavalo_transbordo
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(ve.placa_cavalo_transbordo) as cod_veiculo_cavalo_transbordo
                 , ve.placa_carreta_transbordo
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(ve.placa_carreta_transbordo) as cod_veiculo_carreta_transbordo
                 , ve.observacao
                 , ve.programacao_id_geradora
                 , to_char(ve.data_termino, 'dd/mm/yyyy hh24:mi') as data_termino
                 , ve.condicoes_entrega_mercadoria
                 , to_char(ve.programado_para, 'dd/mm/yyyy hh24:mi') as programado_para
                 , ve.num_pedido
                 , to_char(ve.solicitacao_cruze, 'dd/mm/yyyy hh24:mi') as solicitacao_cruze
              from oper.v$intc_viagem_embarque ve
             inner join oper.v$intc_viagem v
                     on v.viagem_id = ve.viagem_id
             where 1 = 1
			<cfif Len(Trim(arguments.embarque_id))>
               and ve.embarque_id = #arguments.embarque_id#
            </cfif>
            <cfif Len(Trim(arguments.viagem_id))>
               and v.viagem_id = #arguments.viagem_id#
            </cfif>
            <cfif Len(Trim(arguments.conhecimento_id))>
               and ve.conhecimento_id = #arguments.conhecimento_id#
            </cfif>
             order by ve.data_saida asc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Busca os embarques abertos
    -- ANDERSON 11/01/2010 - ALTERADO
    --->		
    <cffunction name="intc_viagem_embarque_dados" access="remote" returntype="query" output="true">
    	<cfargument name="embarque_id" required="no" default="" />
        <cfargument name="num_viagem" required="no" default="" />
        <cfargument name="situacao_id" required="no" default="" />
        <cfargument name="tipo_id" required="no" default="" />
        <cfargument name="data_inicio" required="no" default="" />
        <cfargument name="data_fim" required="no" default="" />
        <cfargument name="cod_remetente" required="no" default="" />
        <cfargument name="cod_destinatario" required="no" default="" />
        <cfargument name="coleta_municipio" required="no" default="" />
        <cfargument name="entrega_municipio" required="no" default="" />
        <cfargument name="num_pedido" required="no" default="" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ved.programacao_id
                 , ved.num_viagem
                 , to_char(ved.data_saida_viagem, 'dd/mm/yyyy hh24:mi') as data_saida_viagem
                 , ved.embarque_id
                 , ved.conhecimento_id
                 , ved.num_conhecimento
                 , ved.alfandega_origem
                 , ved.alfandega_destino
                 , ved.num_manifesto
                 , ved.nome_motorista
                 , ved.placa_cavalo
                 , ved.cod_veiculo_cavalo
                 , ved.placa_carreta
                 , ved.cod_veiculo_carreta
                 , to_char(ved.data_saida_embarque, 'dd/mm/yyyy hh24:mi') as data_saida_embarque
                 , to_char(ved.previsao_chegada_fronteira, 'dd/mm/yyyy hh24:mi') as previsao_chegada_fronteira
                 , ved.fronteira
                 , ved.cnpj_cpf_despachante_origem
                 , ved.despachante_origem
                 , ved.cnpj_cpf_despachante_destino
                 , ved.despachante_destino
                 , ved.factura
                 , ved.sd
                 , ved.tras
                 , ved.pe
                 , ved.di
                 , ved.dta_desc
                 , ved.transbordo
                 , ved.transbordo_desc
                 , ved.local_transbordo
                 , to_char(ved.data_descarga_transbordo, 'dd/mm/yyyy hh24:mi') as data_descarga_transbordo
                 , to_char(ved.data_carga_transbordo, 'dd/mm/yyyy hh24:mi') as data_carga_transbordo
                 , ved.placa_cavalo_transbordo
                 , ved.cod_veiculo_cavalo_transbordo
                 , ved.placa_carreta_transbordo
                 , ved.cod_veiculo_carreta_transbordo
                 , ved.observacao_embarque
                 , to_char(ved.data_termino, 'dd/mm/yyyy hh24:mi') as data_termino
                 , ved.condicoes_entrega_mercadoria
                 , ved.remetente
                 , ved.municipio_origem
                 , ved.destinatario
                 , ved.municipio_destino
                 , ved.posicao_atual
                 , to_char(ved.entrada_alfandega_origem, 'dd/mm/yyyy hh24:mi') as entrada_alfandega_origem
                 , to_char(ved.saida_alfandega_origem, 'dd/mm/yyyy hh24:mi') as saida_alfandega_origem
                 , to_char(ved.chegada_fronteira_origem, 'dd/mm/yyyy hh24:mi') as chegada_fronteira_origem
                 , to_char(ved.saida_fronteira_origem, 'dd/mm/yyyy hh24:mi') as saida_fronteira_origem
                 , to_char(ved.chegada_fronteira_destino, 'dd/mm/yyyy hh24:mi') as chegada_fronteira_destino
                 , to_char(ved.saida_fronteira_destino, 'dd/mm/yyyy hh24:mi') as saida_fronteira_destino
                 , to_char(ved.entrada_alfandega_destino, 'dd/mm/yyyy hh24:mi') as entrada_alfandega_destino
                 , to_char(ved.saida_alfandega_destino, 'dd/mm/yyyy hh24:mi') as saida_alfandega_destino
                 , ved.qtde_embarque_anexos
                 , ved.vinculos_ok
                 , ved.em_transbordo
                 , to_char(ved.chegada_cliente, 'dd/mm/yyyy hh24:mi') as chegada_cliente
                 , ved.status_atual
                 , ved.ordem_saida
                 , ved.num_pedido
              from oper.v$intc_viagem_embarque_dados ved
             inner join cep.municipio mc
                     on mc.municipio_id = ved.coleta_municipio_id
             inner join cep.municipio me
                     on me.municipio_id = ved.entrega_municipio_id
             where 1 = 1
			<cfif Len(Trim(arguments.embarque_id))>
               and ved.embarque_id = #arguments.embarque_id#
            </cfif>
            <cfif Len(Trim(arguments.situacao_id))>
            	<cfif arguments.situacao_id eq 1>
                	and ved.data_termino is null
                <cfelseif arguments.situacao_id eq 2>
                	and ved.data_termino is not null
                </cfif>
            </cfif>
            <cfif Len(Trim(arguments.tipo_id))>
               and ved.tipo_id = #arguments.tipo_id#
            </cfif>
			<cfif Len(Trim(arguments.num_viagem))>
               and ved.num_viagem = #arguments.num_viagem#
            </cfif>
            <cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_fim))>
               and ved.data_saida_embarque between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_fim#', 'dd/mm/yyyy')
            </cfif>
            <cfif Len(Trim(arguments.data_inicio)) and not Len(Trim(arguments.data_fim))>
               and ved.data_saida_embarque between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and sysdate
            </cfif>
            <cfif Len(Trim(arguments.cod_remetente))>
               and ved.cod_remetente = #arguments.cod_remetente#
            </cfif>
            <cfif Len(Trim(arguments.cod_destinatario))>
               and ved.cod_destinatario = #arguments.cod_destinatario#
            </cfif>
            <cfif Len(Trim(arguments.coleta_municipio))>
               and upper(kss.pkg_string.fnc_string_clean(mc.municipio)) like upper(kss.pkg_string.fnc_string_clean('%#arguments.coleta_municipio#%'))
            </cfif>
            <cfif Len(Trim(arguments.entrega_municipio))>
               and upper(kss.pkg_string.fnc_string_clean(me.municipio)) like upper(kss.pkg_string.fnc_string_clean('%#arguments.entrega_municipio#%'))
            </cfif>
            <cfif Len(Trim(arguments.num_pedido))>
               and ved.num_pedido in (#arguments.num_pedido#)
            </cfif>
             order by ved.viagem_id, ved.data_saida_embarque 
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os MICs vinculados aos CRTs
    -- ANDERSON 11/01/2010 - ALTERADO
    --->		
    <cffunction name="get_mic_crt" access="remote" returntype="query" output="true">
        <cfargument name="conhecimento_id" required="yes" />
        <cfargument name="manifesto_id" required="no" default="" />
        <cfargument name="somente_nao_embarcados" required="no" default="0" hint="0-No; 1-Sim" />
        <cfargument name="multipla_consulta" required="no" default="0" hint="0-Busca pelo CRT e pelos no embarcados; 1-Busca pelo CRT e pelo ID do MIC juntamente pelos no embarcados;" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select c.conhecimento_id
                 , m.manifesto_id
                 , c.num_crt_completo as numero_crt
                 , m.numero_cod_pais ||
                   '.' || m.numero_certificado ||
                   '.' || replace(replace(to_char(m.numero_sequencial, '000,000'), ',', '.'), ' ', '') as numero_mic
                 , m.veic_orig_mot_cod_pessoa as cod_pessoa_motorista
                 , oper.pkg_global.fnc_get_cod_funcionario(m.veic_orig_mot_cod_pessoa) as cod_funcionario_motorista
                 , oper.pkg_global.fnc_busca_nome_pessoa(m.veic_orig_mot_cod_pessoa) as nome_motorista
                 , m.veic_orig_placa_controle as placa_controle
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(m.veic_orig_placa_controle) as cod_veiculo_controle
                 , m.veic_orig_placa_referencia as placa_referencia
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(m.veic_orig_placa_referencia) as cod_veiculo_referencia
                 , vd.proprietario
              from fiscal.v$intc_conhecimento c
             inner join fiscal.v$intc_manifesto_crt mc
                     on mc.conhecimento_id = c.conhecimento_id
             inner join fiscal.v$intc_manifesto m
                     on m.manifesto_id = mc.manifesto_id
              left join oper.v$veiculo_dados vd
                     on vd.placa = m.veic_orig_placa_controle
             where 1 = 1
            <cfif arguments.multipla_consulta eq 1>
               and c.conhecimento_id = #arguments.conhecimento_id#
			   and (m.manifesto_id = #arguments.manifesto_id#
				<cfif Len(Trim(arguments.somente_nao_embarcados)) and arguments.somente_nao_embarcados eq 1>
                    or not exists (select 'x'
                                     from oper.v$intc_viagem_embarque ve
                                    where ve.conhecimento_id = c.conhecimento_id
                                      and ve.manifesto_id = m.manifesto_id)
                </cfif>
               	   )
            <cfelse>
			   and c.conhecimento_id = #arguments.conhecimento_id#
				<cfif Len(Trim(arguments.somente_nao_embarcados)) and arguments.somente_nao_embarcados eq 1>
                   and not exists (select 'x'
                                     from oper.v$intc_viagem_embarque ve
                                    where ve.conhecimento_id = c.conhecimento_id
                                      and ve.manifesto_id = m.manifesto_id)
				</cfif>
            </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Busca os anexos Internacionais
    -- RAFAEL 26/11/2009 - CRIADO
    --->		
    <cffunction name="get_intc_anexos" access="remote" returntype="query" output="true">
        <cfargument name="embarque_id" required="no" default="" />
        <cfargument name="programacao_id" required="no" default="" />
        <cfargument name="anexo_id" required="no" default="" />
        <cfargument name="conteudo" required="no" default="0" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select a.nome
                 , a.anexo_id
                 , a.extensao 
                 <cfif arguments.conteudo gt 0>
                 , a.conteudo
                 </cfif>
              from oper.v$intc_anexo a
        	<cfif Len(Trim(arguments.embarque_id))>
             inner join oper.v$intc_viagem_embarque_anexo vea
                     on vea.anexo_id = a.anexo_id 
                    and vea.embarque_id = #arguments.embarque_id#
        	</cfif>
       		<cfif Len(Trim(arguments.programacao_id))>
             inner join oper.v$intc_programacao_anexo pa
                     on pa.anexo_id = a.anexo_id
                    and pa.programacao_id = #arguments.programacao_id#
        	</cfif>
             where 1 = 1
        	<cfif Len(Trim(arguments.anexo_id))>
               and a.anexo_id = #arguments.anexo_id#
        	</cfif>
		     order by a.date_insert desc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>


    <!--- 
    -- PROPSITO 
    -- Busca os recibos
    -- Leandro 18/03/2009 - CRIADO
    --->		
    <cffunction name="get_intc_lista_recibos" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="no" default="" />
        <cfargument name="data_fim" required="no" default="" />
        <cfargument name="num_recibo" required="no" default="" />
        <cfargument name="cod_pessoa_cliente" required="no" default="" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">                       
            select (select p.razao_social
                      from kss.v$pessoa p
                     where p.cod_pessoa = r.cod_pessoa_cliente) as cliente,
                   r.num_recibo, r.cod_posto_venda,
                   to_char(r.data_emissao, 'dd/mm/yyyy') as data_emissao,
                   f.fatura_id,
                   f.num_fatura,
                   c.num_crt_completo as num_conhecimento,
                   r.total_recibo,
                   r.total_recibo_moeda_2,
                   (select count(*)
                      from fiscal.v$intc_fatura_ocorrencia fo
                     where fo.fatura_id = f.fatura_id) as qtde_ocorrencias
              from fiscal.v$intc_recibo r
              left join fiscal.v$intc_recibo_fatura rf
                     on rf.recibo_id = r.recibo_id
              left join fiscal.v$intc_fatura f
                     on f.fatura_id = rf.fatura_id
              left join fiscal.v$intc_conhecimento_receber cr
                     on cr.fatura_id = f.fatura_id
              left join fiscal.v$intc_conhecimento c
                     on c.conhecimento_id = cr.conhecimento_id
             where 1 = 1
			<cfif Len(Trim(arguments.data_inicio))>
               and r.data_emissao >= to_date('#arguments.data_inicio#', 'dd/mm/yyyy')
            </cfif>
            <cfif Len(Trim(arguments.data_fim))>
               and r.data_emissao <= to_date('#arguments.data_fim#', 'dd/mm/yyyy')
            </cfif>
			<cfif Len(Trim(arguments.num_recibo))>
               and r.num_recibo = #arguments.num_recibo#
            </cfif>
            <cfif Len(Trim(arguments.cod_pessoa_cliente))>
               and r.cod_pessoa_cliente = #arguments.cod_pessoa_cliente#
            </cfif>
             order by r.data_emissao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
	<!--- 
    -- PROPSITO 
    -- Retorna todas as verses ou a ltima verso
    -- ERICG 01/10/2010 - CRIADO
    --->		
    <cffunction name="get_crt_comercial_versao" access="remote" returntype="query" output="true">
    	<cfargument name="versao_id" required="no" default="" />
        <cfargument name="conhecimento_id" required="no" default="" />
        <cfargument name="ultima_versao" required="no" default="0" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ccv.versao_id
                 , row_number() over (order by ccv.versao_id) as num_versao
                 , ccv.conhecimento_id
                 , ccv.classificacao_natureza_id
                 , ccv.classificacao_comercial_id
                 , ccv.tabela_frete_rota_id
                 , ccv.user_insert
                 , to_char(ccv.date_insert, 'dd/mm/yyyy hh24:mi:ss') as date_insert
              from fiscal.v$intc_crt_comercial_versao ccv
             where 1 = 1
            <cfif Len(Trim(arguments.versao_id))>
               and ccv.versao_id = #arguments.versao_id#
            </cfif>
            <cfif Len(Trim(arguments.conhecimento_id))>
               and ccv.conhecimento_id = #arguments.conhecimento_id#
            </cfif>
            <cfif arguments.ultima_versao eq 1>
               and ccv.versao_id = (select max(ccv2.versao_id)
                                      from fiscal.v$intc_crt_comercial_versao ccv2
                                     where ccv2.conhecimento_id = ccv.conhecimento_id
                                   )
            </cfif>
             order by ccv.versao_id desc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>     
    
	<!--- 
    -- PROPSITO 
    -- Retorna as tarifas da verso
    -- ERICG 01/10/2010 - CRIADO
    --->		
    <cffunction name="get_conhecimento_tarifa" access="remote" returntype="query" output="true">
    	<cfargument name="versao_id" required="yes" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ct.tarifa_id
                 , ct.versao_id
                 , ct.cod_variavel
                 , v.descricao                 
                 , ct.valor
              from fiscal.v$intc_conhecimento_tarifa ct
             inner join comercial.v$variavel v
                     on v.cod_variavel = ct.cod_variavel
             where ct.versao_id = #arguments.versao_id#
             order by v.ordem_exibicao, v.tipo, v.descricao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>  

    <!---
	-- PROPSITO 
    -- Retorna a lista de e-mails
    -- FABIOG 03/02/2011 - CRIADO
    --->
	<cffunction name="get_lista_email" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select le.email_inclusao
            	 , le.email_edicao
                 , le.email_registro_embarque
              from oper.v$intc_lista_email le
        	 where le.lista_email_id = 1
        </cfquery>
        <cfreturn qr_result>
    </cffunction>  
    
   <!--- 
    -- PROPSITO 
    -- Retorna as ocorrncias de um embarque
    -- FABIOG 11/02/2011 - CRIADO
    --->		
    <cffunction name="get_intc_viagem_emb_ocorrencia" access="remote" returntype="query" output="true">
    	<cfargument name="embarque_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select veo.embarque_id
                 , veo.ocorrencia_id
                 , o.tipo_id
                 , (select ot.descricao
                      from oper.v$intc_ocorrencia_tipo ot
                     where ot.tipo_id = o.tipo_id
                   ) as tipo
                 , o.usuario
                 , to_char(o.data, 'dd/mm/yyyy hh24:mi:ss') as data
                 , o.comentario
                 , o.ocorrencia_id_origem
              from oper.v$intc_viagem_emb_ocorrencia veo
             inner join oper.v$intc_ocorrencia o
                     on o.ocorrencia_id = veo.ocorrencia_id
             where veo.embarque_id = #arguments.embarque_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as Assinaturas Digitais
    -- RAFAEL 20/11/2012 - CRIADO
    --->		
    <cffunction name="get_assinatura" access="remote" returntype="query" output="true">
    	<cfargument name="usuario" required="no" default="">
        <cfargument name="assinatura_id" required="no" default="">
        <cfargument name="com_imagem" required="no" default="0">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select pa.assinatura_id
                 , pa.usuario
                 , (select kss.pkg_pessoa.fnc_get_cliente(u.cod_pessoa)
                      from kss.v$usuarios u
                     where u.usuario = pa.usuario ) as pessoa
                 <cfif arguments.com_imagem eq 1>
                 , pa.imagem
                 , pa.extensao
                 </cfif>
              from fiscal.v$pessoa_assinatura pa
             where 1 = 1
          <cfif Len(Trim(arguments.usuario))>
               and upper(pa.usuario) = upper('#arguments.usuario#')
          </cfif>
          <cfif Len(Trim(arguments.assinatura_id))>
               and pa.assinatura_id = #arguments.assinatura_id#
          </cfif>
             
        </cfquery>
        <cfreturn qr_result>
    </cffunction>       
</cfcomponent>