<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO 
	-- Busca ordens de compra cadastradas
	-- NOTAS EXPLICATIVAS
	-- GUTO 19/12/2006
	--->
	<cffunction name="get_ordem_compra" returntype="query" access="remote">
		<cfargument name="NUM_CONTROLE" required="no" default="" >
		<cfargument name="NUM_DOCUMENTO" required="no" default="" >
		<cfargument name="DATA_EMISSAO" required="no" default="" >
		<cfargument name="COD_PESSOA_EMISSAO" required="no" default="" >
		<cfargument name="COD_PESSOA_FORNECEDOR" required="no" default="" >
		<cfargument name="VINCULADA_NOTA" required="no" default="" >
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select oc.titulo, oc.empresa, oc.num_controle, oc.cod_pessoa_emissao, em.cliente as emissao,
					 oc.cod_pessoa_autorizacao, aut.cliente as autorizacao,
					 to_char(oc.data_emissao,'dd/mm/yyyy') as data_emissao, 
					 oc.num_documento, oc.cod_pessoa_fornecedor, f.cliente as fornecedor,
					 oc.nome_responsavel, oc.condicao_pagto, oc.equipamento_id,
					 manutencao.to_equipamento_dados(oc.equipamento_id,sysdate).placa as placa,
					 oc.km_veiculo, oc.total_orcado, oc.total_desconto, oc.total_combinado,
					 oc.observacao, oc.situacao
			  from manutencao.v$ordem_compra oc
			 inner join kss.v$pessoa em
						on em.cod_pessoa = oc.cod_pessoa_emissao
			 inner join kss.v$pessoa aut
						on aut.cod_pessoa = oc.cod_pessoa_autorizacao
			 inner join kss.v$pessoa f
						on f.cod_pessoa = oc.cod_pessoa_fornecedor         		
			 where 1=1
			<cfif len(Trim(arguments.NUM_CONTROLE))>
			  and oc.num_controle = #arguments.NUM_CONTROLE#
			</cfif>
			<cfif len(Trim(arguments.NUM_DOCUMENTO))>
			  and oc.num_documento = #arguments.NUM_DOCUMENTO#
			</cfif>
			<cfif len(Trim(arguments.DATA_EMISSAO))>
			  and trunc(oc.data_emissao) = '#arguments.DATA_EMISSAO#'
			</cfif>
			<cfif len(Trim(arguments.VINCULADA_NOTA))>
			  and oc.vinculada_nota = #arguments.VINCULADA_NOTA#
			</cfif>
			<cfif len(Trim(arguments.COD_PESSOA_EMISSAO))>
			  and oc.cod_pessoa_emissao = #arguments.COD_PESSOA_EMISSAO#
			</cfif>
			<cfif len(Trim(arguments.COD_PESSOA_FORNECEDOR))>
			  and oc.cod_pessoa_fornecedor = #arguments.COD_PESSOA_FORNECEDOR#
			</cfif>
			order by oc.num_documento, oc.num_controle
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>

</cfcomponent>