<cfcomponent extends="componentes.suporte.cfc_init">	
	<!--- 
	-- PROPSITO
	-- Seleciona as tarefas
	-- CRISTOFER 20/07/2005 - criado
	--->			
	<cffunction name="get_tarefas" displayname="Tarefas" access="remote" returntype="Query" output="true">	  
		<cfargument name="operacao" required="no" default=""/>
		<cfargument name="tarefa_id" required="no" default="">
		
		<cfargument name="inicio_emissao" required="no" default="">
		<cfargument name="termino_emissao" required="no" default="">
		<cfargument name="inicio_limite" required="no" default="">
		<cfargument name="termino_limite" required="no" default="">
	
		<cfargument name="aplicacao" required="no" default="">
		<cfargument name="tipo_aplicacao" required="no" default="">
		<cfargument name="cliente" required="no" default="">
		<cfargument name="filial" required="no" default="">
		
		<cfargument name="tarefa_tipo_id" required="no" default="">
		<cfargument name="contato" required="no" default="">
		<cfargument name="urgencia_id" required="no" default="">
	
		<cfargument name="sd" required="no" default="">
		<cfargument name="atribuido_para" required="no" default="">
		<cfargument name="data_inicio" required="no" default="">
		<cfargument name="data_fim" required="no" default="">
		<cfargument name="tarefa" required="no" default="">
		<cfargument name="criador" required="no" default="">
		<cfargument name="status" required="no" default="">
		
			<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
				select t.rowid,
					   t.tarefa_id, 
					   t.aplicacao, 
					   t.cliente, 
					   t.filial, 
					   t.contato, 
					   t.tipo_id, 
					   t.urgencia_id, 
					   t.programa_id, 
					   t.sd_id, 
					   t.data_emissao,
					   t.data_limite, 
					   t.data_conclusao, 
					   t.status_id, 
					   t.descricao_tarefa, 
					   t.comentario, 
					   t.user_insert, 
					   t.date_insert, 
					   t.user_update, 
					   t.date_update,
					   t.tipo_aplicacao_id,
					   tp.tipo_descricao, 
					   u.urgencia_descricao, 
					   s.status_descricao, 
					   ta.tipo_aplicacao_descricao,
					   ta.tarefa_atribuicao_id,
					   ta.data_atribuicao, 
					   ta.data_baixa, 
					   ta.atribuido_para, 
					   ta.data_inicio,
					   ta.data_fim,
					   to_char(t.tempo_estimado) as tempo_estimado,
					   case t.status_id
							 when 1 then 'tarefa_aberta'
							 when 2 then 'tarefa_atribuida'
							 when 3 then 'tarefa_executando'
							 when 4 then 'tarefa_aguardando'
							 when 5 then 'tarefa_liberada_teste'
							 when 6 then 'tarefa_finalizada'
							 when 7 then 'tarefa_recusada'
							 when 8 then 'tarefa_liberada_atualizacao'
							 when 9 then 'tarefa_rejeitada' end as class_tarefa
				  from 
					   internet.tarefa t
					   inner join internet.tarefa_tipo tp
						  on tp.tipo_id = t.tipo_id
					   inner join internet.tarefa_urgencia u
						  on u.urgencia_id = t.urgencia_id
					   inner join internet.tarefa_status s
						  on s.status_id = t.status_id
					   inner join internet.tarefa_tipo_aplicacao ta
						  on ta.tipo_aplicacao_id = t.tipo_aplicacao_id
						left join internet.tarefa_atribuicao ta
						  on ta.tarefa_id = t.tarefa_id
					where 1=1
				<cfif len(trim(arguments.operacao)) and arguments.operacao eq "administrar" and (not len(trim(arguments.Status)))>
						  and t.status_id not in (6,9)
				</cfif>
				<cfif len(trim(arguments.operacao)) and arguments.operacao eq "minhas">
						  and ta.atribuido_para = user and t.status_id in (2,3,4,7) --and trunc(ta.data_inicio) <= trunc(sysdate)
				</cfif>
				<cfif len(trim(arguments.operacao)) and arguments.operacao eq "calendario">
						  and t.status_id in (2,3,4,7)
				</cfif>
				<cfif len(trim(arguments.operacao)) and arguments.operacao eq "teste">
						  and t.status_id = 5
				</cfif>
				<cfif len(trim(arguments.operacao)) and arguments.operacao eq "atualizacao">
						  and t.status_id = 8
				</cfif>
				<cfif len(trim(arguments.tarefa_id)) and len(trim(arguments.tarefa_id))>
						  and t.tarefa_id in (#arguments.tarefa_id#)
				</cfif>
				<cfif len(trim(arguments.data_inicio))>
						and ta.data_inicio = '#arguments.data_inicio#'
				</cfif>
				<cfif len(trim(arguments.data_fim))>
						and ta.data_fim = '#arguments.data_fim#'
				</cfif>
				<cfif len(trim(arguments.criador))>
						and t.user_insert = '#arguments.criador#'
				</cfif>
	
				<cfif len(trim(arguments.inicio_emissao)) and len(trim(termino_emissao))>
					and data_emissao between '#arguments.inicio_emissao#' and '#arguments.termino_emissao#'
				<cfelseif len(trim(arguments.inicio_emissao))>
					and data_emissao >= '#arguments.inicio_emissao#'
				<cfelseif len(trim(arguments.termino_emissao))>
					and 1=0
				</cfif>
	
				<cfif len(trim(arguments.inicio_limite)) and len(trim(termino_limite))>
					and data_limite between '#arguments.inicio_limite#' and '#arguments.termino_limite#'
				<cfelseif len(trim(arguments.inicio_limite))>
					and data_limite >= '#arguments.inicio_limite#'
				<cfelseif len(trim(arguments.termino_limite))>
					and 1=0
				</cfif>
				
				<cfif len(trim(arguments.aplicacao))>
					and t.aplicacao = '#URLDecode(arguments.aplicacao)#'
				</cfif>
				
				<cfif len(trim(arguments.tipo_aplicacao))>
					and t.tipo_aplicacao_id = '#arguments.tipo_aplicacao#'
				</cfif>
				
				<cfif len(trim(arguments.cliente))>
					and t.cliente = '#arguments.cliente#'
				</cfif>
				
				<cfif len(trim(arguments.filial))>
					and t.filial like '%#arguments.filial#%'
				</cfif>
				
				<cfif len(trim(arguments.tarefa_tipo_id))>
					<cfloop list="#arguments.tarefa_tipo_id#" delimiters=" " index="v_item">
						and t.tipo_id = #v_item#
					</cfloop>
				</cfif>
				
				<cfif len(trim(arguments.contato))>
					and upper(t.contato) like upper('%#arguments.contato#%')
				</cfif>
		
				<cfif len(trim(arguments.urgencia_id))>
					and t.urgencia_id in (#arguments.urgencia_id#)
				</cfif>
				
				<cfif len(trim(arguments.sd))>
					and t.sd_id = #arguments.sd#
				</cfif>			
				
				<cfloop list="#arguments.tarefa#" delimiters=" " index="v_item">
					and upper(t.descricao_tarefa) like upper('%#v_item#%')
				</cfloop>
				
				<cfif len(trim(arguments.atribuido_para))>
					and upper(ta.atribuido_para) in (' '<cfloop list="#arguments.Atribuido_para#" delimiters="," index="v_item">,'#v_item#'</cfloop>)
				</cfif>			
				
				<cfif len(trim(arguments.Status))>
					and t.status_id in (#arguments.status#)
				</cfif>			
				
				order by t.data_limite,  t.data_emissao desc, t.tarefa_id desc 
			</cfquery>  
		<cfreturn qr />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Seleciona as tarefas
	-- CRISTOFER 20/07/2005 - criado
	--->			
	<cffunction name="get_tipo_ocorrencia" displayname="Tarefas" access="remote" returntype="Query" output="true">	  
		<cfargument name="predefinida" required="no" default="0">
		<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
			select tipo_ocorrencia_id, tipo_ocorrencia_descricao, predefinida
			  from internet.v$tarefa_tipo_ocorrencia
			where predefinida = #arguments.predefinida#
			 order by tipo_ocorrencia_descricao
		</cfquery>  
		<cfreturn qr />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Seleciona as tarefas
	-- CRISTOFER 20/07/2005 - criado
	--->			
	<cffunction name="get_ocorrencia" displayname="Tarefas" access="remote" returntype="Query" output="true">	  
		<cfargument name="tarefa_id" required="yes">
		<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
			select ocorrencia_id,
				   tipo_ocorrencia_id,
				   tarefa_id,
				   descricao_ocorrencia,
				   data_hora,
				   tipo_ocorrencia_descricao,
				   tecnico as usuario
			  from internet.v$tarefa_ocorrencia
			 where tarefa_id = #arguments.tarefa_id#
			 order by ocorrencia_id desc
		</cfquery>  
		<cfreturn qr />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Seleciona as tarefas
	-- CRISTOFER 20/07/2005 - criado
	--->			
	<cffunction name="get_status" displayname="Tarefas" access="remote" returntype="Query" output="true">	  
		<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
			select status_id, status_descricao from internet.v$tarefa_status order by status_id
		</cfquery>  
		<cfreturn qr />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Seleciona as aplicaes
	-- CRISTOFER 27/07/2005 - criado
	--->			
	<cffunction name="get_aplicacao" displayname="Tarefas" access="remote" returntype="Query" output="true">	  
		<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
			select aplicacao
			  from internet.v$tarefa_aplicacao
		</cfquery>  
		<cfreturn qr />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Seleciona os tipos de aplicaes
	-- CRISTOFER 27/07/2005 - criado
	--->			
	<cffunction name="get_tipo_aplicacao" displayname="Tarefas" access="remote" returntype="Query" output="true">	  
		<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
			select tipo_aplicacao_id,
				   tipo_aplicacao_descricao
			  from internet.v$tarefa_tipo_aplicacao
		</cfquery>  
		<cfreturn qr />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Seleciona os clientes
	-- CRISTOFER 27/07/2005 - criado
	--->			
	<cffunction name="get_cliente" displayname="Tarefas" access="remote" returntype="Query" output="true">	  
		<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
			select cliente
			  from internet.v$tarefa_cliente
		</cfquery>  
		<cfreturn qr />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Seleciona os tipos de tarefas
	-- CRISTOFER 27/07/2005 - criado
	--->			
	<cffunction name="get_tipo_tarefa" displayname="Tarefas" access="remote" returntype="Query" output="true">	  
			<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
				select tipo_id, tipo_descricao from internet.v$tarefa_tipo
			</cfquery>  
		<cfreturn qr />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Seleciona os tipos de urgencias
	-- CRISTOFER 27/07/2005 - criado
	--->			
	<cffunction name="get_urgencia" displayname="Tarefas" access="remote" returntype="Query" output="true">	  
		<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
			select urgencia_id, urgencia_descricao from internet.v$tarefa_urgencia
		</cfquery>  
		<cfreturn qr />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Seleciona os Tecnicos
	-- CRISTOFER 27/07/2005 - criado
	--->			
	<cffunction name="get_tecnico" displayname="Tarefas" access="remote" returntype="Query" output="true">	  
		<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
			select tecnico, email from internet.v$tarefa_tecnico
			order by tecnico
		</cfquery>  
		<cfreturn qr />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Seleciona as Perguntas
	-- CRISTOFER 08/08/2005 - criado
	--->			
	<cffunction name="get_perguntas" displayname="Tarefas" access="remote" returntype="Query" output="true">	  
		<cfargument name="pergunta_id" required="no" default="">
		<cfargument name="pergunta_descricao" required="no" default="">
		<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
			select pergunta_id,
				   pergunta_descricao
			  from internet.v$tarefa_checklist_pergunta
			 where pergunta_descricao like '%#arguments.pergunta_descricao#%'
			 <cfif len(trim(arguments.pergunta_id))>
			 and pergunta_id = #arguments.pergunta_id#
			 </cfif>
			 order by pergunta_descricao
		</cfquery>  
		<cfreturn qr />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Seleciona os Modelos de checklist
	-- CRISTOFER 09/08/2005 - criado
	--->			
	<cffunction name="get_modelos" displayname="Tarefas" access="remote" returntype="Query" output="true">	  
		<cfargument name="modelo_id" required="no" default="">
		<cfargument name="modelo_descricao" required="no" default="">
		<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
			select modelo_id,
				   modelo_descricao
			  from internet.v$tarefa_checklist_modelo
			 where modelo_descricao like '%#arguments.modelo_descricao#%'
			 <cfif len(trim(arguments.modelo_id))>
			   and modelo_id = #arguments.modelo_id#
			 </cfif>
		</cfquery>  
		<cfreturn qr />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Seleciona as perguntas dos Modelos de checklist
	-- CRISTOFER 09/08/2005 - criado
	--->			
	<cffunction name="get_modelo_itens" displayname="Tarefas" access="remote" returntype="Query" output="true">	  
		<cfargument name="modelo_id" required="yes">
		<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
			select m.modelo_id,
				   m.modelo_descricao as modelo,
				   p.pergunta_id,
				   p.pergunta_descricao as pergunta
			  from internet.v$tarefa_checklist_modelo m
			 inner join internet.v$tarefa_checklist_modelo_it mi
					 on mi.modelo_id = m.modelo_id
			 inner join internet.v$tarefa_checklist_pergunta p
					 on p.pergunta_id = mi.pergunta_id
			 where 1=1
			   and m.modelo_id = #arguments.modelo_id#
		</cfquery>  
		<cfreturn qr />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Seleciona as perguntas da tarefa
	-- CRISTOFER 09/08/2005 - criado
	--->			
	<cffunction name="get_perguntas_tarefa" displayname="Tarefas" access="remote" returntype="Query" output="true">	  
		<cfargument name="tarefa_id" required="yes">
		<cfargument name="lista_pergunta_id" required="no" default="">
		<cfargument name="invalidas" required="no" default="">
		<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
			select tc.tarefa_id,
				   tc.pergunta_id,
				   tc.comentario,
				   tc.verificado,
				   tc.verificado_testador,
				   tp.pergunta_descricao
			  from internet.v$tarefa_checklist tc
			 inner join internet.v$tarefa_checklist_pergunta tp
					 on tc.pergunta_id = tp.pergunta_id
			 where tc.tarefa_id = '#arguments.tarefa_id#'
			 <cfif len(trim(arguments.lista_pergunta_id)) and len(trim(arguments.invalidas))>			 
			   and kss.instr_pkg.verifica_lista(tp.pergunta_id, '#arguments.lista_pergunta_id#') <> #arguments.invalidas#
			 </cfif>
		</cfquery>  
		<cfreturn qr />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Seleciona os indices de aproveitamento
	-- CRISTOFER 12/08/2005 - criado
	--->			
	<cffunction name="get_indices" displayname="Tarefas" access="remote" returntype="Query" output="true">	  
		<cfargument name="tecnico" required="no" default="">
		<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
				select recusadas, liberadas, 
					   to_char((100-recusadas/liberadas*100), '999990.00') as aproveitamento,
					   t.tecnico, 
					   dense_rank() over (order by (100-recusadas/liberadas*100) desc) posicao 
				  from 
					   internet.tarefa_tecnico t,
					 ( select tecnico,
							( select count(*)
								from internet.v$tarefa_ocorrencia
							   where tecnico = t.tecnico
								 and tipo_ocorrencia_id = 9 ) as recusadas,
							( select count(*)
								from internet.v$tarefa_ocorrencia
							   where tecnico = t.tecnico
								 and tipo_ocorrencia_id = 6 ) as liberadas
						 from internet.v$tarefa_tecnico t ) x
						 
				 where liberadas > 0 
				<cfif len(trim(arguments.tecnico))>
					and upper(t.tecnico) = upper('#arguments.tecnico#')
				</cfif>
				   and t.tecnico = x.tecnico
				   and t.exibir_ranking = 1
				 order by 3 desc, 2 desc, 1 desc
		</cfquery>  
		<cfreturn qr />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Seleciona os indices de aproveitamento
	-- CRISTOFER 12/08/2005 - criado
	--->	
	<cffunction name="get_indices_gerais" displayname="Tarefas" access="remote" returntype="Query" output="true">	  
		<cfargument name="tecnico" required="no" default="">
		<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
			select sum(recusadas) as recusadas, sum(liberadas) as liberadas, to_char(avg(aproveitamento), '999990.00') as aproveitamento from 
			(select (select count(*)
					  from internet.v$tarefa_ocorrencia
					 where tecnico = t.tecnico
					   and tipo_ocorrencia_id = 9) as recusadas,
				   (select count(*)
					  from internet.v$tarefa_ocorrencia
					 where tecnico = t.tecnico
					   and tipo_ocorrencia_id = 6) as liberadas,
				   (100-((select count(*)
					  from internet.v$tarefa_ocorrencia
					 where tecnico = t.tecnico
					   and tipo_ocorrencia_id = 9)/
				   (select count(*)
					  from internet.v$tarefa_ocorrencia
					 where tecnico = t.tecnico
					   and tipo_ocorrencia_id = 6))*100)
				   as aproveitamento,
				   tecnico
			  from internet.v$tarefa_tecnico t where (select count(*)
					  from internet.v$tarefa_ocorrencia
					 where tecnico = t.tecnico
					   and tipo_ocorrencia_id = 6) > 0
			 order by 3 desc, 2 desc, 1 desc)
		</cfquery>  
		<cfreturn qr />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Seleciona os indices de aproveitamento
	-- CRISTOFER 12/08/2005 - criado
	--->			
	<cffunction name="get_ranking" displayname="Tarefas" access="remote" returntype="Query" output="true">	  
		<cfargument name="recuo" required="no" default="30">
		<cfargument name="tecnico" required="no" default="">
		<cfargument name="geral" required="no" default="1">
		<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
			select sum(case when tipo_ocorrencia_id = 6 then 1 else 0 end) as liberadas, 
				   sum(case when tipo_ocorrencia_id = 9 then 1 else 0 end) as recusadas,
				   100-((sum(case when tipo_ocorrencia_id = 9 then 1 else 0 end)/sum(case when tipo_ocorrencia_id = 6 then 1 else 0 end))*100) as aproveitamento, 
				  <cfif arguments.geral eq "0" or len(trim(arguments.tecnico))>
				   tec.tecnico,
				  </cfif>
				   d.data_hora
			  from internet.v$tarefa_ocorrencia toc
			 inner join internet.v$tarefa_tecnico tec
					 on toc.tecnico = tec.tecnico 
					and tec.exibir_ranking = 1
			 inner join (select distinct trunc(data_hora) as data_hora
					  from internet.v$tarefa_ocorrencia 
					 order by trunc(data_hora)) d
					 on toc.data_hora <= d.data_hora
				where 1=1
			 <cfif len(trim(arguments.tecnico))>
				and tec.tecnico = '#arguments.tecnico#'
			</cfif>
				and d.data_hora >= sysdate-#arguments.recuo#	 
			 group by 
			 <cfif arguments.geral eq 0 or len(trim(arguments.tecnico))>
					tec.tecnico, 
			 </cfif>
			 d.data_hora
			 having sum(case when tipo_ocorrencia_id = 6 then 1 else 0 end) > 0
			 order by d.data_hora, 3
		</cfquery>  
		<cfreturn qr />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Seleciona as tarefas em um determinado periodo
	-- CRISTOFER 15/08/2005 - criado
	--->			
	<cffunction name="get_calendario_tarefas_periodo" displayname="Tarefas" access="remote" returntype="Query" output="true">	  
		<cfargument name="tecnico" required="no" default="">
		<cfargument name="data_inicio" required="no" default="">
		<cfargument name="data_fim" required="no" default="">
		<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
			select ta.data_inicio,
				   ta.data_fim,
				   ta.atribuido_para as agrupamento,
				   ta.atribuido_para,				   
				   ta.atribuido_para || ' (' || ltrim(to_char(count(*), '00')) || ')' as descricao,
				   ta.data_inicio || ta.data_fim || ta.atribuido_para as keyfield
			  from internet.tarefa t
			  left join internet.tarefa_atribuicao ta on ta.tarefa_id = t.tarefa_id
			 where t.status_id in (1, 2, 3, 4, 7)
			   and (data_inicio <= '#arguments.data_fim#' and data_fim >= '#arguments.data_inicio#')
			   and ta.atribuido_para like '%#arguments.tecnico#%'
			 group by ta.data_inicio, ta.data_fim, ta.atribuido_para
			 order by ta.data_inicio, ta.atribuido_para   		
		</cfquery>  
		<cfreturn qr />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Seleciona os indices de aproveitamento
	-- CRISTOFER 12/08/2005 - criado
	--->			
	<cffunction name="get_ocorrencias_dia" displayname="Tarefas" access="remote" returntype="Query" output="true">	  
		<cfargument name="tecnico" required="no" default="">
		<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
			select count(*) as liberadas, 
				   trunc(date_insert) as data
			  from tarefa_ocorrencia
			 where tipo_ocorrencia_id = 6
			 <cfif len(trim(arguments.tecnico))>
			   and tecnico = '#arguments.tecnico#'
			 </cfif>
			 group by trunc(date_insert)
			 order by trunc(date_insert),count(*) desc
		</cfquery>  
		<cfreturn qr />
	</cffunction>
	
	
	<!--- 
	-- PROPSITO
	-- Seleciona os indices de aproveitamento
	-- CRISTOFER 12/08/2005 - criado
	--->			
	<cffunction name="get_graficos_cliente" displayname="Tarefas" access="remote" returntype="Query" output="true">	  
		<cfargument name="data_inicial" required="no" default="#dateFormat(DateAdd('d', -30, Now()), 'DD/MM/YYYY')#">
		<cfargument name="data_final" 	required="no" default="#dateFormat(Now(), 'DD/MM/YYYY')#">
		<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
			select tar.cliente,
				   ttp.tipo_descricao as tipo,
				   count(*) as nro,
				   round(((count(*)/sum(count(*)) over (partition by tar.cliente order by tar.cliente))*100), 2) as percentual,
				   sum(count(*)) over (partition by tar.cliente order by tar.cliente) as total,
				   round(((sum(count(*)) over (partition by tar.cliente order by tar.cliente)/sum(count(*)) over ())*100),2) as percentual_geral,
				   sum(count(*)) over () as total_geral
			  from internet.v$tarefa tar
			 inner join internet.v$tarefa_ocorrencia toc
					 on tar.tarefa_id = toc.tarefa_id
					and toc.tipo_ocorrencia_id = 7
			 inner join internet.v$tarefa_tipo ttp
					 on ttp.tipo_id = tar.tipo_id
			 where trunc(toc.data_hora) between '#arguments.data_inicial#' and '#arguments.data_final#'
			   and tar.cliente is not null
			 group by tar.cliente, ttp.tipo_descricao
			 order by 6 desc, tar.cliente, 4 desc
		</cfquery>  
		<cfreturn qr />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Seleciona os indices de aproveitamento
	-- CRISTOFER 12/08/2005 - criado
	--->			
	<cffunction name="get_graficos_finalizadas" displayname="Tarefas" access="remote" returntype="Query" output="true">	  
		<cfargument name="data_inicial" required="no" default="#dateFormat(DateAdd('d', -30, Now()), 'DD/MM/YYYY')#">
		<cfargument name="data_final" 	required="no" default="#dateFormat(Now(), 'DD/MM/YYYY')#">
		<cfargument name="agrupado"		required="no" default="cliente">
		<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
			select tar.#arguments.agrupado# as CLIENTE,
				   ttp.tipo_descricao as tipo,
				   count(*) as nro,
				   round(((count(*)/sum(count(*)) over (partition by tar.#arguments.agrupado# order by tar.#arguments.agrupado#))*100), 2) as percentual,
				   sum(count(*)) over (partition by tar.#arguments.agrupado# order by tar.#arguments.agrupado#) as total,
				   round(((sum(count(*)) over (partition by tar.#arguments.agrupado# order by tar.#arguments.agrupado#)/sum(count(*)) over ())*100),2) as percentual_geral,
				   sum(count(*)) over () as total_geral
			  from internet.v$tarefa tar
			 inner join internet.v$tarefa_ocorrencia toc
					 on tar.tarefa_id = toc.tarefa_id
					and toc.tipo_ocorrencia_id = 7
			 inner join internet.v$tarefa_tipo ttp
					 on ttp.tipo_id = tar.tipo_id
			 where trunc(toc.data_hora) between '#arguments.data_inicial#' and '#arguments.data_final#'
			   and tar.#arguments.agrupado# is not null
			 group by tar.#arguments.agrupado#, ttp.tipo_descricao
			 order by 6 desc, tar.#arguments.agrupado#, 4 desc
		</cfquery>  
		<cfreturn qr />
	</cffunction>
</cfcomponent>