<cfcomponent extends="_transportes.funcoes.cfc_init" output="yes">
	<!--- 
	-- PROPSITO 
	-- Busca os DSNs cadastrados
	-- CRISTOFER  16/05/2006
	--->		
	<cffunction name="get_dsn" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select dsn_id,
				   nome,
				   nome_exibicao,
				   ativo,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update
			  from site.v$dsn
			 order by nome_exibicao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os clientes
	-- CRISTOFER  16/05/2006
	--->		
	<cffunction name="get_cliente" access="remote" returntype="query" output="true">
		<cfargument name="nome" required="no" default="">
		<cfargument name="cliente_id" required="no" default="">
		<cfargument name="nro_layouts" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cliente_id,
				   nome,
				   pasta,
				   dsn,
				   user_insert,
				   date_insert,
				   user_update,
				   date_update,
				   logo,
				   url,
				   <cfif arguments.nro_layouts eq 1>
				   (select count(*)
				      from site.v$layout l
					 where l.cliente_id = c.cliente_id) as nro_layouts,
				   </cfif>
				   sincronizador
			  from site.v$cliente_config c	
			 where 1=1
			<cfif len(trim(arguments.cliente_id))>
			   and cliente_id in (#arguments.cliente_id#)
			</cfif>
			<cfif len(trim(arguments.nome))>
			   and upper(nome) like upper('%#arguments.nome#%')
			</cfif>
			 order by nome
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os layouts do cliente
	-- CRISTOFER  16/05/2006
	--->		
	<cffunction name="get_layout" access="remote" returntype="query" output="true">
		<cfargument name="layout_id" required="no" default="">
		<cfargument name="cliente_id" required="no" default="">
		<cfargument name="titulo" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select l.layout_id,
				   l.anexo_id,
				   l.situacao_id,
				   l.comentario,
				   l.cliente_id,
				   l.dimensao_id,
				   l.tipo,
				   a.titulo,
				   a.anexo_id,
				   a.url,
				   ls.descricao situacao,
				   d.descricao dimensao,
				   c.nome as cliente
			  from site.v$layout l
			 inner join desenvolvimento.v$anexos a
					 on a.anexo_id = l.anexo_id
			 inner join site.v$layout_dimensao d 
					 on d.dimensao_id = l.dimensao_id
			 inner join site.v$layout_situacao ls
					 on ls.situacao_id = l.situacao_id
			 inner join site.v$cliente_config c
			         on c.cliente_id = l.cliente_id	
			 where 1=1
			 <cfif len(trim(arguments.cliente_id))>
			   and l.cliente_id = #arguments.cliente_id#
			 </cfif>
			 <cfif len(trim(arguments.layout_id))>
			   and l.layout_id = #arguments.layout_id#
			 </cfif>
			 <cfif len(trim(arguments.titulo))>
			   and upper(a.titulo) like upper('%#arguments.titulo#%')
			 </cfif>
			 order by l.layout_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca as situacoes dos layouts
	-- CRISTOFER  16/05/2006
	--->		
	<cffunction name="get_layout_situacao" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select situacao_id,
				   descricao,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from site.v$layout_situacao	
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as dimensoes dos layouts
	-- CRISTOFER  16/05/2006
	--->		
	<cffunction name="get_layout_dimensao" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select dimensao_id,
				   descricao,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from site.v$layout_dimensao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>  


	<!--- 
	-- PROPSITO 
	-- Busca a estrutura de diretorios para o servidor local
	-- CRISTOFER  28/12/2007
	--->		
    <cffunction name="get_diretorio_local" access="remote" output="true" returntype="query">
        <cfargument name="diretorio" required="yes">
        <cfargument name="assinatura" required="yes">
        <cfargument name="arquivo" required="yes">
        <cfargument name="recurse" required="yes">
        <cfargument name="force_pai" required="yes">
      	<cfset arguments.diretorio = REReplace(ExpandPath(arguments.diretorio),'index.cfm','')>
        <cfset qrTree = QueryNew('sortfield,arquivo_id, url,arquivo_pai,tipo,diretorio,tamanho,assinatura,ultima_modificacao','CF_SQL_VARCHAR,CF_SQL_INTEGER,CF_SQL_VARCHAR,CF_SQL_VARCHAR,CF_SQL_VARCHAR,CF_SQL_VARCHAR,CF_SQL_VARCHAR,CF_SQL_VARCHAR,CF_SQL_TIMESTAMP')>
        <cfif not len(trim(arguments.arquivo))>
            <cfdirectory
                directory="#arguments.diretorio#"
                name="lista_arquivos" recurse="#arguments.recurse#" sort="type, directory, name">
            <cfset v_pai = 0>
            <cfset v_arquivo_id = 0>	
            <cfset v_dir = ''>
            <cfset v_array_dir = StructNew()>
            <cfset v_dir = Left(arguments.diretorio, Len(arguments.diretorio)-1)>
            <cfset v_array_dir[arguments.diretorio] = 0>
            <cfset v_array_dir[v_dir] = 0>
            
            <cfoutput query="lista_arquivos">
                <cfif not Find('LCK',lista_arquivos.name) and not Find('.mno',lista_arquivos.name) >
                    <cfset v_arquivo_id = v_arquivo_id + 1>	
                    <cfset v_path = lista_arquivos.directory & '/' & lista_arquivos.name>
                    <cfif lista_arquivos.type neq 'dir'>
                        <cfset v_pai = v_array_dir[lista_arquivos.directory]>				
                        <cfset queryAddRow(qrTree)>
	                    <cfset querySetCell(qrTree,"sortfield", lcase(lista_arquivos.type&"_"&lista_arquivos.directory&"_"&lista_arquivos.name  ))>
                        <cfset querySetCell(qrTree,"arquivo_id",  v_arquivo_id )>
                        <cfset querySetCell(qrTree,"url",  lista_arquivos.name )>
                        <cfif len(trim(arguments.force_pai))>
                            <cfset querySetCell(qrTree,"arquivo_pai",  arguments.force_pai )>
                        <cfelse>
                            <cfset querySetCell(qrTree,"arquivo_pai",  v_pai )>
                        </cfif>
                        <cfset querySetCell(qrTree,"tipo",  lista_arquivos.type )>
                        <cfset querySetCell(qrTree,"diretorio",  replace(lista_arquivos.directory&'/',ExpandPath("/"),"/") )>
                        <cfset querySetCell(qrTree,"tamanho",  lista_arquivos.size )>
                        <cfset querySetCell(qrTree,"ultima_modificacao",  lista_arquivos.dateLastModified )>
                        <cfif arguments.assinatura eq 1>
                            <cfscript>
                                querySetCell(qrTree,"assinatura",  this.md5_file(expand = 0,file = lista_arquivos.directory&"/"&lista_arquivos.name ) );
                            </cfscript>
                        </cfif>
                    <cfelse>
                        <cfset v_array_dir[v_path] = v_arquivo_id>
                        <cfset v_pai = StructFind(v_array_dir, lista_arquivos.directory)>
                        <cfset queryAddRow(qrTree)>
	                    <cfset querySetCell(qrTree,"sortfield",lcase( lista_arquivos.type&"_"&lista_arquivos.directory&"_"&lista_arquivos.name  ))>
                        <cfset querySetCell(qrTree,"arquivo_id",  v_arquivo_id )>
                        <cfset querySetCell(qrTree,"url",  lista_arquivos.name )>
                        <cfif len(trim(arguments.force_pai))>
                            <cfset querySetCell(qrTree,"arquivo_pai",  arguments.force_pai )>
                        <cfelse>
                            <cfset querySetCell(qrTree,"arquivo_pai",  v_pai )>
                        </cfif>
                        <cfset querySetCell(qrTree,"tipo",  lista_arquivos.type )>			
                        <cfset querySetCell(qrTree,"diretorio",  replace(lista_arquivos.directory&'/',ExpandPath("/"),"/") )>
                    </cfif>
                </cfif>
            </cfoutput>	
        <cfelse>
            <cfdirectory
                directory="#arguments.diretorio#"
                name="lista_arquivos" recurse="no" sort="type,directory,name">
            <cfset arguments.arquivo = expandPath(arguments.arquivo)>
	        <cfoutput query="lista_arquivos">
                <cfset v_path = lista_arquivos.directory & '/' & lista_arquivos.name>
                <cfif v_path eq arguments.arquivo>
                    <cfset queryAddRow(qrTree)>
                    <cfset querySetCell(qrTree,"sortfield", lcase(lista_arquivos.type&"_"&lista_arquivos.directory&"_"&lista_arquivos.name  ))>
                    <cfset querySetCell(qrTree,"arquivo_id",  0 )>
                    <cfset querySetCell(qrTree,"url",  lista_arquivos.name )>
                    <cfset querySetCell(qrTree,"tipo",  lista_arquivos.type )>
                    <cfset querySetCell(qrTree,"diretorio",  replace(lista_arquivos.directory&'/',ExpandPath("/"),"/") )>
                    <cfset querySetCell(qrTree,"tamanho",  lista_arquivos.size )>
                    <cfset querySetCell(qrTree,"ultima_modificacao",  lista_arquivos.dateLastModified )>
                    <cfif arguments.assinatura eq 1>
                        <cfscript>
                            querySetCell(qrTree,"assinatura",  this.md5_file(expand = 0,file = lista_arquivos.directory&"/"&lista_arquivos.name ) );
                        </cfscript>
                    </cfif>
                </cfif>
            </cfoutput>			
        </cfif>
        <cfset columnId = qrTree.findColumn("sortfield")>
		<cfset qrTree.sort(columnId, true)>
        <cfreturn qrTree>
    </cffunction>
  	
	<!--- 
	-- PROPSITO 
	-- Busca a estrutura de diretorios de um servidor remoto
	-- CRISTOFER  28/12/2007
	--->		
    <cffunction name="get_diretorio_remoto" access="remote" output="true" returntype="query">
    	<cfargument name="servidor" required="yes">
        <cfargument name="diretorio" required="yes">
        <cfargument name="assinatura" required="no" default="0">
        <cfargument name="arquivo" required="no" default="">
        <cfargument name="recurse" required="no" default="no">
        <cfargument name="force_pai" required="no" default="">
		<cfscript>
			conn = CreateObject("webservice", "http://#arguments.servidor#/_transportes/consulta/cfc_sincronizador.cfc?wsdl");
			qrArquivos = conn.get_diretorio_local(diretorio = arguments.diretorio
												 ,assinatura = arguments.assinatura
												 ,arquivo = arguments.arquivo
												 ,recurse = arguments.recurse
												 ,force_pai = arguments.force_pai
												 );
			
		</cfscript>
        <cfreturn qrArquivos>
	</cffunction>
    
<!--- 
-- PROPSITO
-- Captura o Hash MD5 do Arquivo
-- CRISTOFER 04/11/2005 - criado
--->
<cffunction name="md5_file" displayname="Captura o Hash MD5 do Arquivo" returntype="string" output="true" access="remote">
	<cfargument name="file" required="yes">
	<cfargument name="expand" required="no" default="0">
	<cfif arguments.expand eq 1>
		<cfset arguments.file = expandPath(arguments.file)>
	</cfif>
	<cffile action="read" file="#file#" variable="xFile" />
	<cfscript>
		return ucase(hash(xFile,'MD5'));
	</cfscript>
</cffunction>
    
	<!--- 
	-- PROPSITO 
	-- Busca o conteudo de um arquivo remoto
	-- CRISTOFER  02/01/2008
	--->		
	<cffunction name="get_conteudo_arquivo_remoto" access="remote" returntype="binary" output="false">
    	<cfargument name="path" required="yes">
		<cffile action="readbinary"
                    file="#ExpandPath(arguments.path)#"
                    variable="vArquivoBIN">
		<cfreturn vArquivoBin>
	</cffunction>
    
	<!--- 
	-- PROPSITO 
	-- Busca as versoes do arquivo cadastradas
	-- CRISTOFER  03/01/2008
	--->		
    <cffunction name="get_arquivos_banco" displayname="" access="remote" returntype="Query" output="true">	  
        <cfargument name="diretorio" required="no" default="">
        <cfargument name="arquivo" required="no" default="">
        <cfargument name="tipo" required="no" default="">
        <cfargument name="arquivo_raiz" required="no" default="">
        <cfargument name="conteudo" required="no" default="0">
        <cfargument name="recurse" required="no" default="1">  
        <cfargument name="usuario" required="no" default="">
        <cfquery name="qr" datasource="KMM.KMM.COM.BR" username="site" password="!ks_|_04">
            select arquivo_id, site_id, url, nvl(arquivo_pai,0) as arquivo_pai ,
                       substr(sys_connect_by_path(url, ' - '),2) as caminho_completo, t.versao, t.tipo, t.diretorio diretorio, t.assinatura,
                       t.data_ult_modificacao as ultima_modificacao
                       <cfif arguments.conteudo eq 1>
                       ,t.conteudo
                       </cfif>
              from site.v$site_arquivos t
             where 1=1
             <cfif len(trim(arguments.diretorio))>
               and diretorio||'/' like '#replace(arguments.diretorio&'/', '//', '/', 'ALL')#%'
             </cfif>
             <cfif len(trim(arguments.arquivo))>
               and diretorio||'/'||url = '#arguments.arquivo#'
             </cfif>
             <cfif len(trim(arguments.tipo))>
               and tipo = '#arguments.tipo#'
             </cfif>
             <cfif (not len(trim(arguments.diretorio))) and arguments.recurse eq 0>
                and level = <cfif len(trim(arguments.arquivo_raiz))>2<cfelse>1</cfif>
             </cfif>
             <cfif arquivo_raiz eq -1>
                and data_atualizacao > sysdate -1 
             </cfif>
             <cfif arquivo_raiz eq -2>
                and data_atualizacao > sysdate -1 
                and user_update = upper('#arguments.usuario#')
             </cfif>
             <cfif len(trim(arquivo_raiz)) and arquivo_raiz gte 0>
             START WITH arquivo_id = #arguments.arquivo_raiz#
             <cfelse>
             START WITH arquivo_pai is null
             </cfif>
             CONNECT BY PRIOR arquivo_id = arquivo_pai 
             order siblings by tipo, replace(url, '_', ' _') 
        </cfquery>  
        <cfreturn qr />
    </cffunction>      
</cfcomponent>