<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO 
	-- Busca setor
	-- NOTAS EXPLICATIVAS
	-- GUTO 08/12/2008
	--->
	<cffunction name="get_setor" returntype="query" access="remote">
		<cfargument name="setor_id" required="no" default="">
		<cfargument name="descricao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select setor_id, descricao			       
			  from sgq.v$setor
             where 1=1
             <cfif Len(Trim(arguments.descricao))>
             	and upper(descricao) like upper('%#arguments.descricao#%')
             </cfif> 
             <cfif Len(Trim(arguments.setor_id))>
             	and setor_id = #arguments.setor_id#
             </cfif> 
   		</cfquery>		
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca nao conformidade
	-- NOTAS EXPLICATIVAS
	-- GUTO 08/12/2008
	--->
	<cffunction name="get_nao_conformidade" returntype="query" access="remote">
		<cfargument name="setor_id" required="no" default="">
		<cfargument name="num_nao_conformidade" required="no" default="">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_fim" required="no" default="">        
		<cfargument name="elaborado_por" required="no" default="">
		<cfargument name="abertas" required="no" default="">
		<cfargument name="responsavel" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select nc.num_nao_conformidade, 
            	   to_char(nc.data_abertura,'dd/mm/yyyy hh24:mi') as data_abertura, 
                   nc.setor_id, s.descricao as setor,
                   nc.tipo, nc.registro, nc.elaborado_por, nc.elaborado_por_setor_id, 
                   nc.causa, nc.causa_observacao, nc.disposicao, 
                   nc.disp_retrabalho, nc.disp_aceito_sob_condicao, nc.disp_descartado, 
                   nc.disp_outras, nc.disposicao_outras, 
            	   to_char(nc.analise_data,'dd/mm/yyyy hh24:mi') as analise_data, 
                   nc.analisado_por, 
                   nc.data_implementacao, nc.responsavel_geral, nc.eficaz, 
                   nc.verificacao_eficacia, nc.data_fechamento, nc.responsavel_final,
                   case 
                     when nc.data_fechamento is not null then 'Finalizada'
                     when nc.data_implementacao is not null then 'Implementando Aoes'
                     when nc.analise_data is not null then 'Em analise'
                     when nc.analise_data is null then 'Aberta'
                   else '' end status
              from sgq.v$nao_conformidade nc
              inner join sgq.v$setor s
                      on s.setor_id = nc.setor_id
             where 1=1
             <cfif Len(Trim(arguments.elaborado_por))>
               and elaborado_por = '#arguments.elaborado_por#'
             </cfif> 
             <cfif Len(Trim(arguments.num_nao_conformidade))>
               and num_nao_conformidade = #arguments.num_nao_conformidade#
             </cfif> 
             <cfif Len(Trim(arguments.setor_id))>
             	and setor_id = #arguments.setor_id#
             </cfif> 
             <cfif Len(Trim(arguments.data_inicial))>
             	and trunc(data_abertura) >= #arguments.data_inicial#
             </cfif> 
             <cfif Len(Trim(arguments.data_fim))>
             	and trunc(data_abertura) <= #arguments.data_fim#
             </cfif> 
             <cfif Len(Trim(arguments.abertas))>
             	and nc.data_fechamento is null
             </cfif>
             <cfif Len(Trim(arguments.responsavel))>
             	and exists (select 1
                              from sgq.v$nao_conformidade_acao nca
                             where nca.responsavel = upper('#arguments.responsavel#')
                               and nca.num_nao_conformidade = nc.num_nao_conformidade)
             </cfif>
             order by num_nao_conformidade
   		</cfquery>		
		<cfreturn qr_result>
	</cffunction>    

	<!--- 
	-- PROPSITO 
	-- Busca aao de nao conformidade
	-- NOTAS EXPLICATIVAS
	-- GUTO 08/12/2008
	--->
	<cffunction name="get_nao_conformidade_acao" returntype="query" access="remote">
		<cfargument name="num_nao_conformidade" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select num_nao_conformidade, acao_id, descricao, responsavel, 
                   to_char(data_implementacao,'dd/mm/yyyy hh24:mi') as data_implementacao,
                   (select to_char(max(data_implementacao), 'dd/mm/yyyy hh24:mi')
                      from sgq.v$nao_conformidade_acao a2
                     where a2.num_nao_conformidade = a.num_nao_conformidade) as data_ult_implementacao
              from sgq.v$nao_conformidade_acao a
             where 1=1
             <cfif Len(Trim(arguments.num_nao_conformidade))>
             	and num_nao_conformidade = #arguments.num_nao_conformidade#
             </cfif> 
   		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
    
</cfcomponent>