<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO 
	-- Busca ocorrncias de sinistro
	-- 
	-- WAGNERLV 24/12/2007
	--->
	<cffunction name="get_ocorrencia_sinistro" returntype="query" access="remote">
		<cfargument name="NUM_SINISTRO" required="no" default="" >
        <cfargument name="NUM_PROCESSO" required="no" default="" >
        <cfargument name="PERIODO_I" required="no" default="" >
        <cfargument name="PERIODO_F" required="no" default="" >
        <cfargument name="CNPJCPF" required="no" default="" >
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">        
            select t.sinistro_id,
                   t.num_processo,
                   t.data_hora ,
                   un.cod_unidade_negocio,
                   un.unidade_negocio,
               t.cod_modalidade,
               sinistro_id_chave,
                sinistro_chave,
                   (select x.sigla from oper.v$seg_modalidade x where x.modalidade_id = t.cod_modalidade) as modalidade,
                   t.evento_id,
                   e.descricao as evento,
                   t.arquivamento_id,
                   a.descricao as arquivamento,
                   decode(t.houve_vitima,1,'Sim','No') as houve_vitima,
                   decode(t.houve_vazamento,1,'Sim','No') as houve_vazamento,
                   decode(t.houve_impacto_amb,1,'Sim','No') as houve_impacto_amb,
                   t.num_romaneio,
                   mo.municipio as municipio_origem,
                   mo.uf_id as uf_origem,
                   md.municipio as municipio_destino,
                   md.uf_id as uf_destino,
                   ml.municipio as municipio_local,
                   ml.uf_id as uf_local,
                   t.descricao_local,
                   t.num_natureza,
                   n.descricao as natureza,
                   t.valor_carga,
                   t.informante,
                   pc.identificador as cnpj_cpf_cliente,
                   pc.razao_social as razao_social_cliente,
                   pcc.identificador as cnpj_cpf_corretora,
                   pcc.razao_social as razao_social_corretora,
                   ps.identificador as cnpj_cpf_seguradora,
                   ps.razao_social as razao_social_seguradora,
                   pm.identificador as cnpj_cpf_motorista,
                   pm.razao_social as razao_social_motorista,
                   t.num_liberacao_motorista,
                   t.modalidade_motorista,
                   t.valor_avaria,
                   t.valor_franquia,
                   t.valor_custo_atendimento,
                   t.valor_prejuizo,
                   t.ind_data_recebimento,
                   t.ind_data_pagamento,
                   t.ind_data_previsao,
                   t.ind_valor_recebimento,
                   t.ind_valor_pagamento,
                   decode(t.terc_tipo,1,'Terceiro',2,'Passageiro','') as terc_tipo,
                   t.terc_nome,
                   t.terc_identificacao,
                   t.terc_orgao_emissor,
                   t.terc_logradouro,
                   t.terc_bairro,
                   t.terc_cidade,
                   t.terc_cep,
                   t.terc_telefone,
                   t.terc_ramal,
                   t.terc_veiculo,
                   t.terc_placa,
                   t.terc_uf,
                   t.terc_cor,
                   decode(t.terc_possui_seguro,1,'Sim','No') as terc_possui_seguro,
                   t.terc_seguro,
                   t.terc_observacao,
                   case t.situacao
                      when 0 then 'Em Aberto'
                      when 1 then 'Encerrado'
                      when 2 then 'Pendente de Avaliao'
                      when 3 then 'Pendente de Terceiros'
                   end as situacao,
                   t.user_insert, t.date_insert, t.user_update, t.date_update
              from oper.v$seg_sinistro t
             inner join kss.v$unidade_negocio un
                     on un.cod_pessoa = t.cod_pessoa_filial
             inner join oper.v$seg_sinistro_evento e
                     on t.evento_id = e.evento_id
              left join oper.v$seg_sinistro_arq_processo a
                     on a.arquivamento_id = t.arquivamento_id
              left join cep.municipio mo
                     on mo.municipio_id = t.municipio_id_origem
              left join cep.municipio md
                     on md.municipio_id = t.municipio_id_destino
              left join cep.municipio ml
                     on ml.municipio_id = t.municipio_id_local
              left join oper.v$natureza n
                     on n.num_natureza = t.num_natureza
             inner join kss.v$pessoa pc
                     on pc.cod_pessoa = t.cod_pessoa_cliente
             inner join kss.v$pessoa pcc
                     on pcc.cod_pessoa = t.cod_pessoa_corretora
             inner join kss.v$pessoa ps
                     on ps.cod_pessoa = t.cod_pessoa_seguradora
             inner join kss.v$pessoa pm
                     on pm.cod_pessoa = t.cod_pessoa_motorista         
             where 	
             1=1
             <cfif len(trim(arguments.NUM_PROCESSO)) >
              and (t.num_processo = '#arguments.NUM_PROCESSO#')
             </cfif>
             <cfif len(trim(arguments.NUM_SINISTRO)) >
              and (t.sinistro_id = '#arguments.NUM_SINISTRO#')
             </cfif>
             <cfif len(trim(arguments.PERIODO_I)) or len(trim(arguments.PERIODO_F)) >
             and (trunc(t.data_hora) >= to_date('#arguments.PERIODO_I#', 'dd/mm/yyyy') or '#arguments.PERIODO_I#' is null)
             and (trunc(t.data_hora) <= to_date('#arguments.PERIODO_F#', 'dd/mm/yyyy') or '#arguments.PERIODO_F#' is null)
             
             </cfif>
             <cfif len(trim(arguments.CNPJCPF)) >
              and ps.cnpj_cpf like '%#arguments.CNPJCPF#%' 
             </cfif>
             order by t.sinistro_id
        </cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca arquivos relacionados ao sinistro
	-- 
	-- WAGNERLV 24/12/2007
	--->
    <cffunction name="get_arquivos_sinistro" returntype="query" access="remote">
		<cfargument name="num_sinistro" required="yes" default="" >
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">                
            select sinistro_id,
                   arquivo_id,
                   nome_arquivo,
                   descricao,
                   arquivo,
                   user_insert,
                   date_insert,
                   user_update,
                   date_update
            from oper.v$seg_sinistro_arquivo 
            where sinistro_id = #arguments.num_sinistro#               
          </cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca arquivo relacionado ao sinistro
	-- 
	-- WAGNERLV 24/12/2007
	--->
    <cffunction name="get_arquivo_sinistro" returntype="query" access="remote">
		<cfargument name="ARQUIVO_ID" required="yes" default="" >
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">       
            select nome_arquivo,
                   arquivo
                   from oper.v$seg_sinistro_arquivo 
            where arquivo_id = '#arguments.ARQUIVO_ID#'           
          </cfquery>
		<cfreturn qr_result>
	</cffunction>
    
     <!--- 
	-- PROPSITO 
	-- Busca arquivo relacionado ao sinistro
	-- 
	-- KATHLYNTS 24/12/2007
	--->
    <cffunction name="get_historico_sinistro" returntype="query" access="remote">
		<cfargument name="num_processo" required="yes" default="" >
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">       
           select 
               historico_id,
               historico,
               date_update,
               user_update,
               date_insert,
               user_insert       
          from oper.v$seg_sinistro_hist
         where historico_id = historico_id
           and sinistro_id in( select sinistro_id
                  from  oper.v$seg_sinistro
                 where oper.v$seg_sinistro_hist.sinistro_id = oper.v$seg_sinistro.sinistro_id
                      and oper.v$seg_sinistro.num_processo = '#arguments.num_processo#')
       </cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca arquivo relacionado ao sinistro
	-- 
	-- KATHLYNTS 24/12/2007
	--->
    <cffunction name="get_veiculo" returntype="query" access="remote">
		<cfargument name="num_processo" required="yes" default="" >
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">       
            select placa, modalidade
          from oper.v$seg_sinistro_veiculo
         where sinistro_id in
               (select sinistro_id
                  from oper.v$seg_sinistro
                 where oper.v$seg_sinistro_veiculo.sinistro_id =
                       oper.v$seg_sinistro.sinistro_id
                   and oper.v$seg_sinistro.num_processo = '#arguments.num_processo#')
       </cfquery>
		<cfreturn qr_result>
	</cffunction>   
    
    <!--- 
	-- PROPSITO 
	-- Busca arquivo relacionado ao sinistro
	-- 
	-- Kathlynts 26/12/2007
	--->
    <cffunction name="get_sinistros_vinculados" returntype="query" access="remote">
		<cfargument name="sinistro_id_chave" required="yes" default="" >
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">       
            select 
                    t.sinistro_id_chave as sinistro_id_chave_t,
                    t2.num_processo as num_processo_t2,
                    t2.data_hora data_t2,
                    (select kss.fnc_concat_all(kss.to_concat_expr(v.placa,', '))
            from oper.v$seg_sinistro_veiculo v
            where v.sinistro_id = t.sinistro_id_chave) as placa_chave,
                    t.sinistro_id as sinistro_id_t,
                    t.num_processo as num_processo_t,
                    t.data_hora as data_hora_t,
                    (select kss.fnc_concat_all(kss.to_concat_expr(v.placa,', '))
                    from oper.v$seg_sinistro_veiculo v
                    where v.sinistro_id = t.sinistro_id) as placa
           from  oper.v$seg_sinistro t
                 inner join oper.v$seg_sinistro t2
                 on t2.sinistro_id = t.sinistro_id_chave
           where t2.sinistro_chave = 1      
             and t.sinistro_id_chave= '#arguments.sinistro_id_chave#' 	
       </cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!--- 
	-- PROPSITO 
	-- Busca arquivo relacionado ao sinistro
	-- 
	-- wagnerlv 26/12/2007
	--->
    <cffunction name="get_sinistro_documentos" returntype="query" access="remote">
		<cfargument name="num_romaneio" required="yes" default="" >
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">  
           select c.num_romaneio, to_char(c.NUM_CONHECIMENTO) as num_documento, un.unidade_negocio, c.SERIE, c.DATA_EMISSAO, c.TOTAL_CONHECIMENTO as total_documento, c.conhecimento_id as id,
           'CTRC' as tipo
      from fiscal.v$conhecimento c
     inner join kss.v$unidade_negocio un
             on un.cod_pessoa = c.cod_pessoa_filial
     where NUM_ROMANEIO = #arguments.num_romaneio#
    
    union all
    
    select im.NUM_ROMANEIO, ic.NUMERO_COD_PAIS||'.'||ic.NUMERO_CERTIFICADO||'.'||ic.NUMERO_SEQUENCIAL, un.unidade_negocio, '', ic.EMISSAO_DATA, (ic.TOTAL_CUSTO_ORIGEM+ic.TOTAL_CUSTO_DESTINO)*ic.COTACAO, null as id,
           'CRT' as tipo
      from  fiscal.v$intc_manifesto im
     inner join fiscal.v$intc_manifesto_crt icm
             on icm.manifesto_id = im.manifesto_id
     inner join fiscal.v$intc_conhecimento ic
             on ic.conhecimento_id = icm.conhecimento_id
     inner join kss.v$unidade_negocio un
             on un.cod_pessoa = ic.cod_pessoa_filial
     where im.NUM_ROMANEIO = #arguments.num_romaneio#      
       </cfquery>
		<cfreturn qr_result>
	</cffunction>     
	
    <!--- 
	-- PROPSITO
	-- Retorna as situaes para um veculo
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 25/05/2009
	--->
	<cffunction name="get_situacoes_veiculo" displayname="Retorna as situaes para um veculo" output="true" returntype="query" access="remote">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select num_evento, descricao_resumida 
              from oper.v$evento_operacao_setup
             where num_grupo = 1
               and prioridade = 1
               and situacao = 1
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna os dados de um romaneio
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 25/05/2009
	--->
	<cffunction name="get_dados_romaneio" displayname="Retorna os dados de um romaneio" output="true" returntype="query" access="remote">
		<cfargument name="num_romaneio" required="yes">
        <cfargument name="data_sinistro" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select kss.pkg_string.fnc_string_clean(upper(m1.municipio)) as municipio_origem,  r.org_municipio_id as municipio_id_origem,
                   kss.pkg_string.fnc_string_clean(upper(m2.municipio)) as municipio_destino, r.dest_municipio_id as municipio_id_destino,
                   e.num_natureza, rc.valor_total_nf as total_carga,
                   (select p.cpf||p.cpf_dv
                      from oper.v$romaneio_hist_veiculo v
                     inner join kss.v$pessoa_fisica p
                             on p.cod_pessoa = v.cod_pessoa
                     where v.num_romaneio = r.num_romaneio 
                       and :data_sinistro between v.data_inicio and nvl(v.data_termino, sysdate)
                       and rownum = 1) as cpf_motorista,
                   (select case pm.num_modalidade
                               when 2 then 'AGREGADO'
                               when 6 then 'FROTA'
                               when 8 then 'TERCEIRO'
                            end as modalidade
                      from oper.v$romaneio_hist_veiculo v
                     inner join kss.v$pessoa_fisica p
                             on p.cod_pessoa = v.cod_pessoa
                     inner join kss.v$pessoa_modalidade pm
                             on pm.cod_pessoa = v.cod_pessoa
                     where v.num_romaneio = r.num_romaneio
                       and pm.situacao = 1
                       and pm.num_modalidade in (2,6,8)
                       and rownum = 1) as modalidade_motorista,
                    vr.cod_grupo,
                    ps.cnpj_cpf as cnpj_cpf_seguradora, ps.cod_pessoa as cod_pessoa_seguradora,
                    pc.cnpj_cpf as cnpj_cpf_corretora, pc.cod_pessoa as cod_pessoa_corretora,
                    pe.cnpj_cpf as cnpj_cpf_cliente, pe.cod_pessoa as cod_pessoa_cliente,
                    decode(l.frete_proprio, 1, 1, 0) as tipo_frete
				   (select max(eos.num_evento) keep (dense_rank last order by eo.data)
                      from oper.v$romaneio_evento re
                     inner join oper.v$evento_operacao eo
                        on eo.controle_evo_id = re.controle_evo_id
                     inner join oper.v$evento_operacao_setup eos
                        on eos.num_evento = eo.num_evento
                     where re.num_romaneio = r.num_romaneio
                       and eos.num_grupo = 1
                       and eos.prioridade = 1
                       and eos.situacao = 1
                       and eo.data < '#arguments.data_sinistro#'
                       ) as num_evento 
              from oper.v$romaneio r
              left join cep.municipio m1
                     on m1.municipio_id = r.org_municipio_id
              left join cep.municipio m2
                     on m2.municipio_id = r.dest_municipio_id
              left join oper.v$natureza e
                     on e.num_natureza = r.num_natureza
              left join oper.v$romaneio_cnto rc
                     on rc.num_romaneio = r.num_romaneio
              left join oper.v$romaneio_item i
                     on i.num_romaneio = r.num_romaneio
                    and rownum = 1
              left join logistica.v$operacao l
                     on l.operacao_id = i.operacao_id
              left join logistica.v$operacao_seguro ls
                     on ls.operacao_id = i.operacao_id
                    and ls.data_exclusao is null 
              left join oper.v$seg_contratado sc
                     on sc.id_seguradora in (ls.id_seg_rctr_c, ls.id_seg_rcf_dc, ls.id_seg_rctr_vi, ls.id_seg_rr)
                    and (sc.tipo_seguro = :cod_modalidade)
              left join kss.v$pessoa ps
                     on ps.cod_pessoa = sc.cod_seguradora
              left join kss.v$pessoa pc
                     on pc.cod_pessoa = sc.cod_pessoa_corretora
              left join kss.v$pessoa pe
                     on pe.cod_pessoa = i.cod_remetente   
             inner join oper.v$romaneio_hist_veiculo hv
                     on hv.num_romaneio = r.num_romaneio
                    and r.data_inicio between hv.data_inicio and nvl(hv.data_termino, r.data_termino)
              left join oper.v$veiculo_referencia vr
                     on vr.placa = hv.placa_referencia      
             where r.num_romaneio = #arguments.num_romaneio#
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna os dados de um veculo
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 25/05/2009
	--->
	<cffunction name="get_dados_veiculo" displayname="Retorna os dados de um veculo" output="true" returntype="query" access="remote">
		<cfargument name="cod_veiculo" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ve.cod_veiculo,
                   ve.placa,
                   p.cnpj_cpf as cnpj_cpf_proprietario,
                   p.razao_social as razao_social_proprietario,
                   vp.cod_pessoa as cod_pessoa_proprietario,
                   ve.marca_id,
                   vm.marca,
                   ve.modelo_id,
                   vmo.modelo,
                   ve.ano,
                   1 as situacao_veiculo_id
              from oper.v$veiculo ve
             inner join oper.v$veiculo_marca vm
                     on vm.marca_id = ve.marca_id
             inner join oper.v$veiculo_modelo vmo
                     on vmo.modelo_id = ve.modelo_id
                    and vmo.marca_id = ve.marca_id
             inner join oper.v$veiculo_proprietario vp
                     on vp.placa = ve.placa
                    and vp.data_fim is null  
             inner join kss.v$pessoa p
                     on p.cod_pessoa = vp.cod_pessoa
 			 where cod_veiculo = '#arguments.cod_veiculo#'
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna os sinistros cadastrados com situao pendente de avaliao
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 25/05/2009
	--->
	<cffunction name="get_seg_ficha" displayname="Retorna os sinistros cadastrados com situao pendente de avaliao" output="true" returntype="query" access="remote">
		<cfargument name="sinistro_id" required="no" default="">        
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_fim" required="no" default="">
        <cfargument name="nome_atendente" required="no" default="">
        <cfargument name="informante" required="no" default="">
        <cfargument name="num_romaneio" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.sinistro_id,
                   to_char(t.data_hora, 'dd/mm/yyyy hh24:mi') as data_hora,
                   t.tipo_frete,
                   t.cod_grupo,
                   t.tipo_avaria,
                   t.num_romaneio,
                   (select max(eos.num_evento) keep (dense_rank last order by eo.data)
                      from oper.v$romaneio_evento re
                     inner join oper.v$evento_operacao eo
                        on eo.controle_evo_id = re.controle_evo_id
                     inner join oper.v$evento_operacao_setup eos
                        on eos.num_evento = eo.num_evento
                     where re.num_romaneio = t.num_romaneio
                       and eos.num_grupo = 1
                       and eos.prioridade = 1
                       and eos.situacao = 1
                       and eo.data < t.data_hora_atendimento
                   ) as situacao_romaneio_id,
                   t.nome_atendente,
                   to_char(t.data_hora_atendimento, 'dd/mm/yyyy hh24:mi') as data_hora_atendimento,
                   t.municipio_id_local,
                   ml.municipio as municipio_local,
                   ml.uf_id as uf_local,
                   t.descricao_local,
                   t.valor_carga,
                   t.num_natureza,
                   n.descricao as natureza,
                   n.nociva_meio_ambiente,
                   t.informante, 
                   t.informante_telefone,
                   t.cod_pessoa_motorista,
                   pm.cnpj_cpf as cnpj_cpf_motorista,
                   pm.razao_social as razao_social_motorista,
                   t.mot_cod_cargo,
                   t.mot_modalidade,
                   t.mot_situacao,
                   t.mot_hospital,
                   t.mot_hospital_telefone,
                   t.mot_medico,
                   t.mot_solic_bo,
                   t.mot_solic_disco,
                   t.mot_solic_foto,
                   case t.situacao
                      when 0 then 'Em Aberto'
                      when 1 then 'Encerrado'
                      when 2 then 'Pendente de Avaliao'
                      when 3 then 'Pendente de Terceiros'
                   end as situacao,
                   t.ocorrencia_desc,
                   t.veic_rodar,
                   t.veic_guincho,
                   t.veic_carreta_danos,
                   t.veic_carreta_rodar,
                   t.veic_remocao,
                   t.cod_pessoa_cliente,
                   t.cod_pessoa_corretora,
                   t.cod_pessoa_seguradora,
                   t.municipio_id_origem,
                   t.municipio_id_destino
              from oper.v$seg_sinistro t
              left join cep.municipio ml
                     on ml.municipio_id = t.municipio_id_local
              left join oper.v$natureza n
                     on n.num_natureza = t.num_natureza
             inner join kss.v$pessoa pm
                     on pm.cod_pessoa = t.cod_pessoa_motorista
             where 1 = 1
			<cfif Len(Trim(arguments.sinistro_id))>
               and t.sinistro_id = #arguments.sinistro_id#
            </cfif>
            <cfif Len(Trim(arguments.data_inicio))>
               and trunc(t.data_hora) >= '#arguments.data_inicio#'
            </cfif>
            <cfif Len(Trim(arguments.data_fim))>
               and trunc(t.data_hora) <= '#arguments.data_fim#'
            </cfif>
            <cfif Len(Trim(arguments.nome_atendente))>
               and upper(t.nome_atendente) like upper('#arguments.nome_atendente#')
            </cfif>
            <cfif Len(Trim(arguments.informante))>
               and upper(t.informante) like upper('#arguments.informante#')
            </cfif>
            <cfif Len(Trim(arguments.num_romaneio))>
               and t.num_romaneio = #arguments.num_romaneio#
            </cfif>
               and situacao = 2 -- Pendentes de avaliao
             order by t.data_hora, t.num_romaneio
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna os veculos vinculados a um sinistro
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 25/05/2009
	--->
	<cffunction name="get_seg_veiculo" displayname="Retorna os veculos vinculados a um sinistro" output="true" returntype="query" access="remote">
		<cfargument name="sinistro_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select v.sinistro_id
                 , v.placa
                 , ve.cod_veiculo
                 , v.modalidade
                 , nvl(ve.marca_id,v.marca_id) as marca_id
                 , vm.marca
                 , nvl(ve.modelo_id,v.modelo_id) as modelo_id
                 , vmo.modelo
                 , nvl(ve.ano, v.ano) as ano
                 , nvl(v.cod_pessoa_proprietario,vp.cod_pessoa) as cod_pessoa_proprietario
                 , p.cnpj_cpf as cnpj_cpf_proprietario
                 , p.razao_social as razao_social_proprietario
                 , v.tipo
                 , v.situacao_veiculo_id
              from oper.v$seg_sinistro_veiculo v
             inner join oper.v$veiculo ve
                     on v.placa = ve.placa
             inner join oper.v$veiculo_marca vm
                     on vm.marca_id = nvl(ve.marca_id,v.marca_id)
             inner join oper.v$veiculo_modelo vmo
                     on vmo.modelo_id = nvl(ve.modelo_id,v.modelo_id)
                    and vmo.marca_id = nvl(ve.marca_id,v.marca_id)
             inner join oper.v$veiculo_proprietario vp
                     on vp.placa = ve.placa
                    and vp.data_fim is null
             inner join kss.v$pessoa p
                     on p.cod_pessoa = nvl(v.cod_pessoa_proprietario,vp.cod_pessoa)
             where sinistro_id = #arguments.sinistro_id#
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    <!--- 
    -- PROPSITO 
    -- Retorna Aplices de Seguro ativas
    -- LEOPOLDOS 08/06/2010 - CRIADO
    --->		
    <cffunction name="get_apolices_ativas" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select sys.dbms_xmlgen.getxml('
                        select sc.id_seguradora
                             , sc.cod_seguradora
                             , (select p.cliente
                                  from kss.v$pessoa p
                                 where p.cod_pessoa = sc.cod_seguradora ) as nome_seguradora
                             , sc.numero_apolice
                             , sc.tipo_seguro
                             , sc.valor_cobertura
                             , sc.data_contrato
                             , sc.data_inicio_vigencia
                             , sc.data_fim_vigencia
                          from oper.v$seg_contratado sc
                         where sc.data_inicio_vigencia <= sysdate
                           and sc.data_fim_vigencia >= sysdate') as resultado
              from dual
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
</cfcomponent>