<!-- KM&M Componentes -->
<cfcomponent displayname="Consultas das rotas na maplink" extends="_transportes.funcoes.cfc_init">
	<cfset this.authentication_ws = "http://webservices.maplink2.com.br/webservices/v2.1/Authentication/Authentication.asmx?WSDL">
	<cfset this.route_ws = "">
	<cfset this.maprender_ws = "">
	<cfset this._token = "">
	<cfset this.maplink_user = "kmm">
	<cfset this.maplink_pwd = "eng##2w">
	<cfset this.map_width = "600">
	<cfset this.map_height = "400">
	<cfset this.raio_proximidade = 20>
	
	<!--- 
	-- PROPSITO 
	-- Retorna um objeto MapSize para as paradas da rota
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 23/03/2006
	--->
	<cffunction name="get_map_size" returntype="any" access="public">
		<cfargument name="width" required="no" default="800">
		<cfargument name="height" required="no" default="600">
		<cfscript>
			msz = CreateObject("java", "com.maplink.webservices.maprender.MapSize");
			msz.setHeight(arguments.height);
			msz.setWidth(arguments.width);
			return msz;
		</cfscript>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Retorna um objeto MapOptions para as paradas da rota
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 23/03/2006
	--->
	<cffunction name="get_map_options" returntype="any" access="public">
		<cfargument name="datasource" required="no" default="BR">
		<cfargument name="escala" required="no" default="true">
		<cfargument name="width" required="no" default="800">
		<cfargument name="height" required="no" default="600">
		<cfscript>
			mop = CreateObject("java", "com.maplink.webservices.maprender.MapOptions");
			mop.setDataSource(arguments.datasource);
			mop.setScaleBar(arguments.escala);
			mop.setMapSize(get_map_size(	width  = arguments.width,
											height = arguments.height));
			return mop;
		</cfscript>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Retorna um objeto MapOptions para as paradas da rota
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 23/03/2006
	--->
	<cffunction name="get_extent" returntype="any" access="public">
		<cfargument name="minX" required="no" default="BR">
		<cfargument name="maxX" required="no" default="true">
		<cfargument name="minY" required="no" default="800">
		<cfargument name="maxY" required="no" default="600">
		<cfscript>
			ext = CreateObject("java", "com.maplink.webservices.maprender.Extent");
			ext.setXmin(arguments.minX);
			ext.setXmax(arguments.maxX);
			ext.setYmin(arguments.minY);
			ext.setYmax(arguments.maxY);
			return ext;
		</cfscript>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Pega o Token para os proximos 10min na maplink
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 23/03/2006
	--->
	<cffunction name="get_token" returntype="string" access="package">
		<cfargument name="user" required="no" default="#this.maplink_user#">
		<cfargument name="pwd" required="no" default="#this.maplink_pwd#">
		<cfscript>
			ws = CreateObject("webservice", this.authentication_ws);
			token = ws.getToken(arguments.user, arguments.pwd);
			this._token = token;
			return token;
		</cfscript>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Retorna um objeto RouteDetails com os detalhes de roteamento
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 23/03/2006
	--->
	<cffunction name="get_route_details" returntype="any" access="package">
		<cfargument name="optimize_route" required="no" default="false">
		<cfargument name="route_type" required="no" default="0">
		<!---
			TIPO DE ROTEAMENTO
			rotas rodovirias
			0 - rota de carro mais rpida
			1 - rota de carro mais curta
			2 - rota de carro mais rpida sem balsa
			3 - rota de carro mais rpida sem balsa e estrada de terra
			4 - rota de carro mais rpida sem estrada precria
			5 - rota de carro mais rpida sem estrada de terra
			rotas urbanas
			0 - rota de carro mais rpida
			1 - rota de carro mais curta
			2 - rota a p
			3 - rota de carro mais rpida evitando trnsito	
		--->
		<cfscript>
			rd = CreateObject("java", "com.maplink.webservices.route.RouteDetails");
			rd.setOptimizeRoute(arguments.optimize_route);
			rd.setRouteType (arguments.route_type);
			return rd;
		</cfscript>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Retorna um objeto Vehicle com os dados do veiculo
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 23/03/2006
	--->
	<cffunction name="get_vehicle" returntype="any" access="package">
		<cfargument name="capacidade_tanque" required="no" default="650">
		<cfargument name="consumo_medio" required="no" default="10">
		<cfargument name="preco_combustivel" required="no" default="1.70">
		<cfargument name="velocidade_media" required="no" default="90">
		<cfargument name="categoria" required="no" default="2">
		<!---
			CATEGORIA DE PEDAGIO
			0 = No ser calculado o valor do pedgio
			1 = Motocicletas, motonetas e bicicletas a motor 
			2 = Automvel, caminhoneta e furgo (dois eixos simples) 
			3 = Automvel, caminhoneta com semi-reboque (trs eixos simples) 
			4 = Automvel, caminhoneta com reboque (quatro eixos simples) 
			5 = nibus (dois eixos duplos) 
			6 = nibus com reboque (trs eixos duplos) 
			7 = Caminho leve, furgo e cavalo mecnico (dois eixos duplos) 
			8 = Caminho, caminho trator e cavalo mecnico com semi-reboque (trs eixos duplos) 
			9 = Caminho com reboque e cavalo mecnico com semi-reboque (quatro eixos duplos) 
			10 = Caminho com reboque e cavalo mecnico com semi-reboque (cinco eixos duplos) 
			11 = Caminho com reboque e cavalo mecnico com semi-reboque (seis eixos duplos) 
			12 = Caminho com reboque e cavalo mecnico com semi-reboque (sete eixos duplos) 
			13 = Caminho com reboque e cavalo mecnico com semi-reboque (oito eixos duplos) 
			14 = Caminho com reboque e cavalo mecnico com semi-reboque (nove eixos duplos) 
		--->
		<cfscript>
			ve = CreateObject("java", "com.maplink.webservices.route.Vehicle");
			ve.setTankCapacity(arguments.capacidade_tanque);
			ve.setAverageConsumption(arguments.consumo_medio);
			ve.setFuelPrice(arguments.preco_combustivel);
			ve.setAverageSpeed(arguments.velocidade_media);
			ve.setTollFeeCat(arguments.categoria);
			return ve;
		</cfscript>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Retorna um objeto RouteOptions com as opcoes da rota
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 23/03/2006
	--->
	<cffunction name="get_route_options" returntype="any" access="package">
		<cfargument name="route_details" required="yes">
		<cfargument name="vehicle" required="yes">
		<cfargument name="language" required="no" default="portugues">
		<cfargument name="datasource" required="no" default="BR">
		<cfscript>
			ro = CreateObject("java", "com.maplink.webservices.route.RouteOptions");
			ro.setDatasource(arguments.datasource);
			ro.setLanguage(arguments.language);
			ro.setVehicle(arguments.vehicle);
			ro.setRouteDetails(arguments.route_details);
			return ro;
		</cfscript>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Retorna um objeto RouteStop com as paradas da rota
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 23/03/2006
	--->
	<cffunction name="get_route_stop" returntype="any" access="public">
		<cfargument name="descricao" required="yes">
		<cfargument name="x" required="yes">
		<cfargument name="y" required="yes">
		<cfscript>
			rt = CreateObject("java", "com.maplink.webservices.route.RouteStop");
			rt.setDescription(arguments.descricao);
			pt1 = CreateObject("java", "com.maplink.webservices.route.Point");
			pt1.setX (JavaCast("double", arguments.x));
			pt1.setY (JavaCast("double", arguments.y));
			rt.setPoint(pt1);
			return rt;
		</cfscript>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Retorna um objeto ArrayOfRouteStop para as paradas da rota
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 23/03/2006
	--->
	<cffunction name="get_array_route_stop" returntype="any" access="package">
		<cfargument name="route_stop" required="yes">
		<cfscript>
			rst = CreateObject("java", "com.maplink.webservices.route.ArrayOfRouteStop");
			rst.setRouteStop(arguments.route_stop);	
			return rst;
		</cfscript>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Retorna um objeto MapSize para as paradas da rota
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 23/03/2006
	--->
	<cffunction name="get_map_size_route" returntype="any" access="package">
		<cfargument name="width" required="no" default="800">
		<cfargument name="height" required="no" default="600">
		<cfscript>
			msz = CreateObject("java", "com.maplink.webservices.route.MapSize");
			msz.setHeight(arguments.height);
			msz.setWidth(arguments.width);
			return msz;
		</cfscript>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Retorna um objeto MapOptions para as paradas da rota
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 23/03/2006
	--->
	<cffunction name="get_map_options_route" returntype="any" access="package">
		<cfargument name="datasource" required="no" default="BR">
		<cfargument name="escala" required="no" default="true">
		<cfargument name="width" required="no" default="800">
		<cfargument name="height" required="no" default="600">
		<cfscript>
			mop = CreateObject("java", "com.maplink.webservices.route.MapOptions");
			mop.setDataSource(arguments.datasource);
			mop.setScaleBar(arguments.escala);
			mop.setMapSize(this.get_map_size_route(	width  = arguments.width,
													height = arguments.height));
			return mop;
		</cfscript>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Retorna uma Struct com os dados retornados por um RouteInfo
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 23/03/2006
	--->
	<cffunction name="get_route_struct" returntype="struct" access="package">
		<cfargument name="route_info" required="yes">
		<cfargument name="com_mapa" required="no" default="0">
		<cfscript>
			route_info = arguments.route_info;
			ret = StructNew();
			ret.com_mapa = arguments.com_mapa;
			ret.route_id = route_info.getRouteId();
			ret.map_info = StructNew();
			ret.map_info.url = route_info.getMapInfo().getUrl();
			ret.map_info.extent = StructNew();
			ret.map_info.extent.min_x = route_info.getMapInfo().getExtent().getXMin();
			ret.map_info.extent.max_x = route_info.getMapInfo().getExtent().getXMax();
			ret.map_info.extent.min_y = route_info.getMapInfo().getExtent().getYMin();
			ret.map_info.extent.max_y = route_info.getMapInfo().getExtent().getYMax();
		</cfscript>
		<cfscript>
			ret.segment_description = QueryNew("command,description,clientDescription,city,tolldetails,roadtype,distance,cumulativeDistance,x,y");
		</cfscript>
		<cfloop from="1" to="#ArrayLen(route_info.getSegDescription().getSegmentDescription())#" index="i">
			<cfscript>
				seg = route_info.getSegDescription().getSegmentDescription();
				QueryAddRow(ret.segment_description);
				QuerySetCell(ret.segment_description,"command",seg[i].getCommand());
				QuerySetCell(ret.segment_description,"description",seg[i].getDescription());
				QuerySetCell(ret.segment_description,"clientDescription",seg[i].getClientDescription());
				QuerySetCell(ret.segment_description,"city",seg[i].getCity());
				tollDet = StructNew();
				td = seg[i].getTollDetails();
				if(isDefined("td")) {
					tollDet.name = td.getName();
           			tollDet.direction = td.getDirection();
					tollDet.address = td.getAddress();
					tollDet.concession = td.getConcession();
					tollDet.phone = td.getPhone();
					tollDet.state = td.getState();
					tollDet.price = td.getPrice();
					tollDet.pricePerAxle = td.getPricePerAxle();
					QuerySetCell(ret.segment_description,"tollDetails",tollDet);
				}
				QuerySetCell(ret.segment_description,"roadType",seg[i].getRoadType());
				QuerySetCell(ret.segment_description,"distance",seg[i].getDistance());
				QuerySetCell(ret.segment_description,"cumulativeDistance",seg[i].getCumulativeDistance());
				QuerySetCell(ret.segment_description,"x",seg[i].getX());
				QuerySetCell(ret.segment_description,"y",seg[i].getY());
			</cfscript>
		</cfloop>
		<cfscript>
			ret.route_totals = StructNew();
			ret.route_totals.total_distance = route_info.getRouteTotals().getTotalDistance();
			ret.route_totals.total_time = route_info.getRouteTotals().getTotalTime();
			ret.route_totals.total_fuel_used = route_info.getRouteTotals().getTotalFuelUsed();
			ret.route_totals.total_toll_fee_cost = route_info.getRouteTotals().getTotalTollFeeCost();
			ret.route_totals.total_fuel_cost = route_info.getRouteTotals().getTotalFuelCost();
			ret.route_totals.total_cost = route_info.getRouteTotals().getTotalCost();
			ret.route_summary = queryNew("description,distance,pixelX,pixelY,x,y");
		</cfscript>
		<cfloop from="1" to="#ArrayLen(route_info.getRouteSummary().getRouteSummary())#" index="i">
			<cfscript>
				sum = route_info.getRouteSummary().getRouteSummary();
				QueryAddRow(ret.route_summary);
				QuerySetCell(ret.route_summary, "description", sum[i].getDescription());
				QuerySetCell(ret.route_summary, "distance", sum[i].getDistance());
				QuerySetCell(ret.route_summary, "pixelX", sum[i].getPixelX());
				QuerySetCell(ret.route_summary, "pixelY", sum[i].getPixelY());
				QuerySetCell(ret.route_summary, "x", sum[i].getX());
				QuerySetCell(ret.route_summary, "y", sum[i].getY());
			</cfscript>
		</cfloop>
		<cfscript>
			ret.road_type = StructNew();
			ret.road_type.pista_dupla = route_info.getRoadType().getTwoLaneHighWay();
			ret.road_type.pista_em_duplicacao = route_info.getRoadType().getSecondLaneUnderConstruction();
			ret.road_type.pista_simples = route_info.getRoadType().getOneLaneRoadway();
			ret.road_type.pista_em_construcao = route_info.getRoadType().getPavingWorkInProgress();
			ret.road_type.pista_terra = route_info.getRoadType().getDirtRoad();
			ret.road_type.pista_mas_condicoes = route_info.getRoadType().getRoadwayInPoorConditions();
			ret.road_type.balsa =  route_info.getRoadType().getFerry();
			return ret;
		</cfscript>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca as rotas com pontos de origem e destino proximos aos pontos passados
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 30/03/2006
	--->
	<cffunction name="get_rota_proxima" access="remote" returntype="query" output="true">
		<cfargument name="latitude_origem" required="yes">
		<cfargument name="longitude_origem" required="yes">
		<cfargument name="latitude_destino" required="yes">
		<cfargument name="longitude_destino" required="yes">
		<cfquery name="qr_result" datasource="KMM.KMM.COM.BR" username="rota" password="!kr_|_04">
			select rota_id,
				   descricao_origem,
				   descricao_destino
			  from rota.rota r
			 where 1=1
			   and pkg_coord_geografica.fnc_haversine1(latitude_origem,longitude_origem,#arguments.latitude_origem#,#arguments.longitude_origem#) < #this.raio_proximidade#
			   and pkg_coord_geografica.fnc_haversine1(latitude_destino,longitude_destino,#arguments.latitude_destino#,#arguments.longitude_destino#) < #this.raio_proximidade#
			 order by pkg_coord_geografica.fnc_haversine1(latitude_origem,longitude_origem,#arguments.latitude_origem#,#arguments.longitude_origem#), pkg_coord_geografica.fnc_haversine1(latitude_destino,longitude_destino,#arguments.latitude_destino#,#arguments.longitude_destino#)
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os caminhos de rotas com pontos de parada iguais ou proximos aos pontos fornecidos
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 30/03/2006
	--->
	<cffunction name="get_caminho_proximo" access="remote" returntype="query" output="true">
		<cfargument name="rota_id" required="yes">
		<cfargument name="paradas" required="yes">
		<cfargument name="tipo_id" required="yes">
		<cftransaction action="begin">
			<cfloop from="1" to="#arraylen(arguments.paradas)#" index="i">
				<!--- insere os pontos de parada em uma tabela temporaria para comparao --->
				<cfquery datasource="KMM.KMM.COM.BR" username="rota" password="!kr_|_04">
					insert into rota.rota_paradas_temp
					  (descricao, latitude, longitude, municipio_id, num_parada)
					values
					  ('#arguments.paradas[i].descricao#', #arguments.paradas[i].y#, #arguments.paradas[i].x#, #iif(len(trim(arguments.paradas[i].municipio_id)), de(arguments.paradas[i].municipio_id), de('null'))#, #i#)
				</cfquery>
			</cfloop>
			<cfquery name="qr_result" datasource="KMM.KMM.COM.BR" username="rota" password="!kr_|_04">
				select distinct rt.caminho_id
				  from (select count(*) over (partition by caminho_id order by caminho_id) as paradas_corretas,
							   caminho_id,
							   b.paradas,
							   a.latitude,
							   a.longitude
						  from (select count(*) over (partition by caminho_id order by caminho_id) as paradas,
									  row_number() over (partition by caminho_id order by caminho_id) as num_parada,
									  rota_id,
									  caminho_id,
									  node_id,
									  parada_anterior,
									  latitude,
									  longitude
								 from rota.rota_caminho_node n
								where n.parada = 1
								  and n.rota_id = #arguments.rota_id#
								start with parada_anterior is null
							   connect by prior node_id = parada_anterior) a,
							   (select count(*) over (partition by grupo order by grupo) as paradas,
									   row_number() over (order by grupo) as num_parada,
									   latitude,
									   longitude
								  from rota.rota_paradas_temp) b
						 where a.paradas = b.paradas
						   and a.num_parada = b.num_parada
						   and pkg_coord_geografica.fnc_haversine1(a.latitude,a.longitude,b.latitude,b.longitude) < #this.raio_proximidade#) rt
			     inner join rota.rota_caminho rc
				         on rc.caminho_id = rt.caminho_id
				 where paradas_corretas = paradas
				   and rc.tipo_id = #arguments.tipo_id#
			</cfquery>
		</cftransaction>
		<cfreturn qr_result>		
	</cffunction>	
	
	
	<!--- 
	-- PROPSITO 
	-- Busca da rota na base de dados, caso nao exista consulta maplink
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 30/03/2006
	--->
	<cffunction name="get_route" returntype="struct" access="remote" output="true">
		<cfargument name="rota_otimizada" required="no" default="false">
		<cfargument name="tipo_rota" required="yes">
		<cfargument name="paradas" required="yes">
		<cfargument name="com_mapa" required="no" default="0">
		<cfscript>
			//Verifica se existe alguma rota com pontos de origem e destino proximos ao solicitado
			qrRota = this.get_rota_proxima(	LATITUDE_ORIGEM  		= arguments.paradas[1].y,
											LONGITUDE_ORIGEM 		= arguments.paradas[1].x,
											LATITUDE_DESTINO 		= arguments.paradas[ArrayLen(arguments.paradas)].y,
											LONGITUDE_DESTINO 		= arguments.paradas[ArrayLen(arguments.paradas)].x);
			if(qrRota.RecordCount gt 0) {
				//rota existente, verifica se existe alguma com os mesmos pontos de parada
				qrCaminhoProximo = this.get_caminho_proximo(	rota_id = qrRota.rota_id,
																paradas = arguments.paradas,
																tipo_id = arguments.tipo_rota);
				if (qrCaminhoProximo.recordCount gt 0) {
					//foram encontrados caminhos
					retorno = this.get_rota_completa(	rota_id 	= qrRota.rota_id,
														caminho_id 	= qrCaminhoProximo.caminho_id);
					retorno.operacao = 'Apenas consulta';
				} else {
					//no foi encontrado nenhum caminho, busca um novo
					rota = this.get_route_force(argumentCollection 	= arguments, 
												rota_id 			= qrRota.rota_id);
					retorno = this.get_rota_completa(	rota_id 	= rota.rota_id,
														caminho_id 	= rota.caminho_id);
					retorno.operacao = 'Insero apenas do caminho, rota j existente';
				}
			} else {
				//Rota inexistente, insere nova rota e o caminho
				rota = this.get_route_force(argumentCollection 	= arguments);				
				retorno = this.get_rota_completa(rota_id 		= rota.rota_id,
												 caminho_id 	= rota.caminho_id);
				retorno.operacao = 'Insero completa';
			}
			retorno.com_mapa = arguments.com_mapa;
		</cfscript>
		<cfreturn retorno>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca forcada da rota na maplink, independente da existencia na base de dados, e a insere na base de dados
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  31/03/2006
	--->		
	<cffunction name="get_route_force" access="remote" returntype="struct" output="true">
		<cfargument name="rota_id" required="no" default="">
		<cfargument name="rota_otimizada" required="no" default="false">
		<cfargument name="tipo_rota" required="yes">
		<cfargument name="paradas" required="yes">
		<cfargument name="com_mapa" required="no" default="0">	
		<cftry>
			<cfscript>
				//busca o token
				this.get_token();
				//gera os detalhes de roteamento
				rd = this.get_route_details(optimize_route 	= arguments.rota_otimizada,
											route_type 		= arguments.tipo_rota);
				//gera um veiculo
				ve = this.get_vehicle 	   (capacidade_tanque 	= 650,
											consumo_medio		= 10,
											preco_combustivel	= 1.70,
											velocidade_media	= 90,
											categoria			= 12);
				//gera as opcoes da rota							
				ro = this.get_route_options(vehicle = ve,
											route_details = rd);
				arguments.rs = arrayNew(1);
			</cfscript>
			<cfloop from="1" to="#ArrayLen(arguments.paradas)#" index="i">
				<cfscript>
					arguments.rs[i] = this.get_route_stop(descricao = arguments.paradas[i].descricao,
															x = arguments.paradas[i].x,
															y = arguments.paradas[i].y);
				</cfscript>
			</cfloop>
			<cfscript>
				//gera o array de paradas
				ars = this.get_array_route_stop( route_stop = arguments.rs);
				//gera as opcoes do mapa
				mo  = this.get_map_options_route(	width  = this.map_width,
													height = this.map_height);			
				//Cria o objeto java de conexao
				conn = CreateObject("java", "com.maplink.webservices.Consumer");
				//adquire a rota com ou sem mapa conforme solicitado
				if (arguments.com_mapa eq 1) {
					route = conn.getRouteWithMap(ars,ro,mo,token);
				} else {
					route = conn.getRoute(ars, ro, token);
				}
				//converte o resultado para uma struct
				rota  = this.get_route_struct(	com_mapa 	= arguments.com_mapa,
												route_info 	= route);
				retorno.rota_maplink = rota;
			</cfscript>
				<cfscript>
					conn_manip = CreateObject("component", "_transportes.manipulacao.cfc_rota_maplink");
					//caso no seja fornecido o rota_id insere uma nova rota
					if(not len(trim(arguments.rota_id))) {
						//insere a nova rota, caso j exista alguma com pontos proximos apenas retorna o rota_id
						route = conn_manip.ins_rota(	DESCRICAO_ORIGEM 		= arguments.paradas[1].descricao,
														LATITUDE_ORIGEM  		= arguments.paradas[1].y,
														LONGITUDE_ORIGEM 		= arguments.paradas[1].x,
														MUNICIPIO_ID_ORIGEM 	= arguments.paradas[1].municipio_id,
														DESCRICAO_DESTINO 		= arguments.paradas[ArrayLen(arguments.paradas)].descricao,
														LATITUDE_DESTINO 		= arguments.paradas[ArrayLen(arguments.paradas)].y,
														LONGITUDE_DESTINO 		= arguments.paradas[ArrayLen(arguments.paradas)].x,
														MUNICIPIO_ID_DESTINO 	= arguments.paradas[ArrayLen(arguments.paradas)].municipio_id);
						//adquire o rota_id para os processamentos seguintes
						arguments.rota_id = route.rota_id;
					}
					retorno.rota_id = arguments.rota_id;
					//insere o caminho na rota
					caminho = conn_manip.ins_rota_caminho(	rota_id = retorno.rota_id,
															tipo_id = arguments.tipo_rota,
															route_id = rota.route_id);
					
					retorno.caminho_id = caminho.caminho_id;
				</cfscript>
				<cfif arguments.com_mapa eq 1>
					<cfhttp getasbinary="yes" charset="iso-8859-1" resolveurl="yes" url="#rota.map_info.url#" method="get"></cfhttp>
				</cfif>
				<cfscript>
					//Insere o mapa
					v_imagem = '';
					if(arguments.com_mapa eq 1) {
						v_imagem = cfhttp.FileContent;
					}
					mapa = conn_manip.ins_mapa(	rota_id				= retorno.rota_id,
												caminho_id			= retorno.caminho_id,
												latitude_minima  	= rota.map_info.extent.min_y,
												latitude_maxima  	= rota.map_info.extent.max_y,
												longitude_minima 	= rota.map_info.extent.min_x,
												longitude_maxima 	= rota.map_info.extent.max_x,
												mapa				= v_imagem); 
					v_node_pai = '';
				</cfscript>		
				<cfoutput query="rota.segment_description">			
					<cfscript>	
						ped_id = '';
						if(IsStruct(rota.segment_description.tollDetails)) {
							td = rota.segment_description.tollDetails;
							pedagio = conn_manip.ins_pedagio(	nome 			= td.name,
																latitude 		= rota.segment_description.y,
																longitude 		= rota.segment_description.x,
																concessao		= td.concession,
																direcao			= td.direction,
																preco_por_eixo	= td.pricePerAxle,
																telefone		= td.phone,
																endereco		= td.address);
							ped_id = pedagio.pedagio_id;
						}
					</cfscript>
					<cfscript>
						node = conn_manip.ins_rota_caminho_node(	rota_id 				= retorno.rota_id,
																	caminho_id				= retorno.caminho_id,
																	latitude 				= rota.segment_description.y,
																	longitude 				= rota.segment_description.x,
																	distancia 				= rota.segment_description.distance,
																	tempo 					= 0,
																	node_id_pai 			= v_node_pai,
																	descricao 				= rota.segment_description.description,
																	cidade 					= rota.segment_description.city,
																	cod_tipo_estrada		= rota.segment_description.roadtype,
																	distancia_cumulativa 	= rota.segment_description.cumulativedistance,
																	pedagio_id 				= ped_id,
																	parada 					= iif(ListFind('S,D,O', rota.segment_description.roadtype), de(1), de(0)));
						v_node_pai = node.node_id;
					</cfscript>
				</cfoutput>		
				<cfscript>
					ar = arraynew(1);					ar2 = ArrayNew(1);
					ar[1] = "pista_dupla";				ar2[1] = "PD-PD";
					ar[2] = "pista_em_duplicacao";		ar2[2] = "ED-ED";
					ar[3] = "pista_simples";			ar2[3] = "P-P";
					ar[4] = "pista_em_construcao";		ar2[4] = "EP-EP";
					ar[5] = "pista_terra";				ar2[5] = "T-T";
					ar[6] = "pista_mas_condicoes";		ar2[6] = "CP-CP";
					ar[7] = "balsa";					ar2[7] = "BA-BA";
				</cfscript>
				<cfloop from="1" to="#ArrayLen(ar)#" index="i">
					<cfscript>
						if(rota.road_type[ar[i]] gt 0) {
							total = conn_manip.ins_caminho_tipo_estrada(rota_id 			= retorno.rota_id,
																		caminho_id 			= retorno.caminho_id,
																		cod_tipo_estrada 	= ar2[i],
																		total 				= rota.road_type[ar[i]]);
						}
					</cfscript>
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Rota gerada com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
				<cfdump var="#retorno#">
			</cfcatch>
		</cftry>			
		<cfreturn retorno>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca cidades
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  24/03/2006
	--->		
	<cffunction name="get_cidade" access="remote" returntype="query" output="false">
		<cfargument name="municipio_id" required="no" />
		<cfargument name="municipio" required="no" />
		<cfargument name="pais_id" required="no" />
		<cfargument name="uf_id" required="no" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select municipio_id,
				   municipio,
				   round(oper.pkg_coord_geografica.fnc_graus2decimais(latitude),5) latitude,
				   round(oper.pkg_coord_geografica.fnc_graus2decimais(longitude),5) longitude,
				   p.pais_id,
				   uf_id,
				   altitude,
				   cep,
				   p.descricao as pais,
				   cep.fnc_cidade_completa(municipio_id) as descricao
			  from cep.municipio m
			 inner join cep.pais p 
			 		 on p.pais_id = m.pais_id
			 where 1 = 1
		    <cfif IsDefined("arguments.municipio") and Len(Trim(arguments.municipio))>
			   and upper(municipio) like upper('%#arguments.municipio#%')
			</cfif>
		    <cfif IsDefined("arguments.pais_id") and Len(Trim(arguments.pais_id))>
			   and p.pais_id = #arguments.pais_id#
			</cfif>
		    <cfif IsDefined("arguments.uf_id") and Len(Trim(arguments.uf_id))>
			   and uf_id = '#arguments.uf_id#'
			</cfif>
		    <cfif IsDefined("arguments.municipio_id") and Len(Trim(arguments.municipio_id))>
			   and municipio_id = #arguments.municipio_id#
			</cfif>				 
			 order by municipio	
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os dados da rota
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  31/03/2006
	--->		
	<cffunction name="get_rota" access="remote" returntype="query" output="false">
		<cfargument name="rota_id" required="no" default=""> 
		<cfquery name="qr_result" datasource="KMM.KMM.COM.BR" username="rota" password="!kr_|_04">
			select rota_id,
				   municipio_id_origem,
				   latitude_origem,
				   longitude_origem,
				   municipio_id_destino,
				   latitude_destino,
				   longitude_destino,
				   descricao_origem,
				   descricao_destino
			  from rota.rota
			 where 1=1
			   and rota_id in (#arguments.rota_id#)
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os caminhos da rota
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  31/03/2006
	--->		
	<cffunction name="get_rota_caminho" access="remote" returntype="query" output="false">
		<cfargument name="rota_id" required="yes">
		<cfargument name="caminho_id" required="yes">
		<cfquery name="qr_result" datasource="KMM.KMM.COM.BR" username="rota" password="!kr_|_04">
			select rc.rota_id,
				   rc.caminho_id,
				   rc.tipo_id,
				   rt.descricao as tipo_rota,
				   /*rc.mapa,*/
				   rc.descricao,
				   rc.urbana,
				   rc.route_id,
				   rc.date_update as data_atualizacao
			  from rota.rota_caminho rc
			 inner join rota.rota_tipo rt
			         on rt.tipo_id = rc.tipo_id
			 where 1=1
			   and rc.rota_id = #arguments.rota_id#
			   and rc.caminho_id in (#arguments.caminho_id#)
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os pontos de passagem da rota
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  31/03/2006
	--->		
	<cffunction name="get_rota_caminho_node" access="remote" returntype="query" output="false">
		<cfargument name="rota_id" required="yes">
		<cfargument name="caminho_id" required="yes" default="">	
		<cfquery name="qr_result" datasource="KMM.KMM.COM.BR" username="rota" password="!kr_|_04">
			select rcn.rota_id,
				   rcn.caminho_id,
				   rcn.node_id,
				   rcn.cidade,
				   rcn.cod_tipo_estrada,
				   last_estrada,
				   next_estrada,
				   rota.pkg_rota.fnc_get_tipo_estrada(cod_tipo_estrada, 
				                     case
                                       when lag_cod_estrada = 'S' and last_estrada is not null then next_estrada
                                       else last_estrada 
                                     end, 
                                     case
                                       when next_estrada is null then last_estrada
                                       else next_estrada
                                     end) as estrada,
				   rcn.latitude,
				   rcn.longitude,
				   rcn.distancia,
				   rcn.tempo,
				   rcn.node_id_pai,
				   rcn.descricao,
				   rcn.tipo_estrada,
				   rcn.distancia_cumulativa,
				   rcn.pedagio_id,
				   rcn.nome_pedagio,
				   rcn.preco_por_eixo,
				   rcn.parada,
				   rcn.parada_anterior
			  from (select rcn.rota_id,
						   rcn.caminho_id,
						   rcn.node_id,
						   rcn.cidade,
						   rcn.cod_tipo_estrada,
						   last_value(case
										when rcn.cod_tipo_estrada in ('S', 'D', 'O') then null
										else rcn.cod_tipo_estrada
									  end ignore nulls) over(order by distancia_cumulativa rows unbounded preceding) last_estrada,
						   first_value(case
										 when rcn.cod_tipo_estrada in ('S', 'D', 'O') then null
										 else rcn.cod_tipo_estrada
									   end ignore nulls) over(order by distancia_cumulativa rows between current row and unbounded following) as next_estrada,
						   lag(cod_tipo_estrada) over (order by distancia_cumulativa) as lag_cod_estrada,
						   lead(cod_tipo_estrada) over (order by distancia_cumulativa) as lead_cod_estrada,
						   rcn.latitude,
						   rcn.longitude,
						   rcn.distancia,
						   rcn.tempo,
						   rcn.node_id_pai,
						   rcn.descricao,
						   rcn.tipo_estrada,
						   rcn.distancia_cumulativa,
						   rcn.pedagio_id,
						   rcn.nome_pedagio,
						   rcn.preco_por_eixo,
						   rcn.parada,
						   rcn.parada_anterior
					  from (select rcn.rota_id,
								   rcn.caminho_id,
								   rcn.node_id,
								   rcn.cidade,
								   rcn.cod_tipo_estrada,
								   rcn.latitude,
								   rcn.longitude,
								   rcn.distancia,
								   rcn.tempo,
								   rcn.node_id_pai,
								   rcn.descricao,
								   rte.descricao as tipo_estrada,
								   rcn.distancia_cumulativa,
								   rcn.pedagio_id,
								   rpd.nome as nome_pedagio,
								   rpd.preco_por_eixo,
								   rcn.parada,
								   rcn.parada_anterior
							  from rota.rota_caminho_node rcn
							 inner join rota.rota_tipo_estrada rte on rcn.cod_tipo_estrada =
																	  rte.cod_tipo_estrada
							  left join rota.rota_pedagio rpd on rpd.pedagio_id = rcn.pedagio_id
							 where 1 = 1
							   and rota_id = #arguments.rota_id#
							   and caminho_id = #arguments.caminho_id#) rcn
					 start with node_id_pai is null
					connect by prior node_id = node_id_pai) rcn
        

		      
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca todos os dados da rota
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  31/03/2006
	--->		
	<cffunction name="get_rota_completa" access="remote" returntype="struct" output="false">
		<cfargument name="rota_id" required="yes">
		<cfargument name="caminho_id" required="no" default="">
		<cfscript>
			retorno = StructNew();
			retorno.rota = this.get_rota(rota_id = arguments.rota_id);
			retorno.caminhos = this.get_rota_caminho(	rota_id 	= arguments.rota_id,
														caminho_id 	= arguments.caminho_id);
			retorno.caminho_nodes = this.get_rota_caminho_node(	rota_id 	= arguments.rota_id,
																caminho_id 	= arguments.caminho_id);
			retorno.totais = this.get_rota_totais(	rota_id 	= arguments.rota_id,
													caminho_id 	= arguments.caminho_id);
			retorno.mapa = this.get_rota_mapa	(	rota_id 	= arguments.rota_id,
													caminho_id 	= arguments.caminho_id);
		</cfscript>
		<cfreturn retorno>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Aplica um zoom no mapa
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  03/04/2006
	--->		
	<cffunction name="map_zoom" access="remote" returntype="struct" output="false">
		<cfargument name="minX" required="yes">
		<cfargument name="maxX" required="yes">
		<cfargument name="minY" required="yes">
		<cfargument name="maxY" required="yes">
		<cfargument name="route_id" required="yes">
		<cfargument name="percentual_zoom" required="yes">
		<cfargument name="zoom_in" required="yes">
		<cfscript>
			if(arguments.zoom_in) {
				arguments.percentual_zoom = arguments.percentual_zoom*(-1);
			}
			this.get_token();
			mo = get_map_options(	width = this.map_width,
									height = this.map_height);
			extent = get_extent(	minX = arguments.minX,
									maxX = arguments.maxX,
									minY = arguments.minY,
									maxY = arguments.maxY);
			conn = CreateObject("java", "com.maplink.webservices.Consumer");
			mi = conn.getZoom(arguments.route_id, extent, arguments.percentual_zoom, mo, this._token);
			retorno.url = mi.getUrl();
			retorno.minX = mi.getExtent().getXMin();
			retorno.maxX = mi.getExtent().getXMax();
			retorno.minY = mi.getExtent().getYMin();
			retorno.maxY = mi.getExtent().getYMax();
		</cfscript>
		<cfreturn retorno>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Aplica um pan no mapa
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  03/04/2006
	--->		
	<cffunction name="map_pan" access="remote" returntype="struct" output="false">
		<cfargument name="minX" required="yes">
		<cfargument name="maxX" required="yes">
		<cfargument name="minY" required="yes">
		<cfargument name="maxY" required="yes">
		<cfargument name="route_id" required="yes">
		<cfargument name="percentual_pan" required="yes">
		<cfargument name="direction" required="yes">
		<cfscript>
			this.get_token();
			mo = get_map_options(	width = this.map_width,
									height = this.map_height);
			extent = get_extent(	minX = arguments.minX,
									maxX = arguments.maxX,
									minY = arguments.minY,
									maxY = arguments.maxY);
			conn = CreateObject("java", "com.maplink.webservices.Consumer");
			mi = conn.getPan(arguments.route_id, extent, arguments.direction, arguments.percentual_pan, mo, this._token);
			retorno.url = mi.getUrl();
			retorno.minX = mi.getExtent().getXMin();
			retorno.maxX = mi.getExtent().getXMax();
			retorno.minY = mi.getExtent().getYMin();
			retorno.maxY = mi.getExtent().getYMax();
		</cfscript>
		<cfreturn retorno>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Aplica um pan no mapa
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  03/04/2006
	--->		
	<cffunction name="map_window" access="remote" returntype="struct" output="false">
		<cfargument name="minX" required="yes">
		<cfargument name="maxX" required="yes">
		<cfargument name="minY" required="yes">
		<cfargument name="maxY" required="yes">
		<cfargument name="wminX" required="yes">
		<cfargument name="wmaxX" required="yes">
		<cfargument name="wminY" required="yes">
		<cfargument name="wmaxY" required="yes">
		<cfargument name="route_id" required="yes">
		<cfscript>
			this.get_token();
			mo = get_map_options(	width = this.map_width,
									height = this.map_height);
			extent = get_extent(	minX = arguments.minX,
									maxX = arguments.maxX,
									minY = arguments.minY,
									maxY = arguments.maxY);
			newExtent = get_extent(	minX = arguments.wminX,
									maxX = arguments.wmaxX,
									minY = arguments.wminY,
									maxY = arguments.wmaxY);
			conn = CreateObject("java", "com.maplink.webservices.Consumer");
			mi = conn.getZoomWindow(arguments.route_id, extent, newExtent, mo, this._token);
			retorno.url = mi.getUrl();
			retorno.minX = mi.getExtent().getXMin();
			retorno.maxX = mi.getExtent().getXMax();
			retorno.minY = mi.getExtent().getYMin();
			retorno.maxY = mi.getExtent().getYMax();
		</cfscript>
		<cfreturn retorno>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Aplica um pan no mapa
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  03/04/2006
	--->		
	<cffunction name="map_route" access="remote" returntype="struct" output="false">
		<cfargument name="route_id" required="yes">
		<cfscript>
			this.get_token();
			mo = get_map_options(	width = this.map_width,
									height = this.map_height);
			conn = CreateObject("java", "com.maplink.webservices.Consumer");
			mi = conn.getZoomFullExtent(arguments.route_id, mo, this._token);
			retorno.url = mi.getUrl();
			retorno.minX = mi.getExtent().getXMin();
			retorno.maxX = mi.getExtent().getXMax();
			retorno.minY = mi.getExtent().getYMin();
			retorno.maxY = mi.getExtent().getYMax();
		</cfscript>
		<cfreturn retorno>		
	</cffunction>	
		
	<!--- 
	-- PROPSITO 
	-- Busca os tipos de rota
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  31/03/2006
	--->		
	<cffunction name="get_rota_tipo" access="remote" returntype="query" output="true">
		<cfargument name="urbana" required="no" default="">
		<cfquery name="qr_result" datasource="KMM.KMM.COM.BR" username="rota" password="!kr_|_04">
			select tipo_id,
				   descricao,
				   urbana
			  from rota.rota_tipo	
			 where 1=1
			 <cfif len(trim(arguments.urbana))>
			   and urbana = #arguments.urbana#
			  </cfif>
			 order by tipo_id
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os totais da rota
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  31/03/2006
	--->		
	<cffunction name="get_rota_totais" access="remote" returntype="query" output="true">
		<cfargument name="rota_id" required="yes">
		<cfargument name="caminho_id" required="yes">
		<cfquery name="qr_result" datasource="KMM.KMM.COM.BR" username="rota" password="!kr_|_04">
			select cte.rota_id,
				   cte.caminho_id,
				   rte.descricao as tipo_estrada,
				   cte.cod_tipo_estrada,
				   cte.total
			  from rota.rota_caminho_tipo_estrada cte
			 inner join rota.rota_tipo_estrada rte
					 on rte.cod_tipo_estrada = cte.cod_tipo_estrada
			 where 1=1
			   and rota_id = #arguments.rota_id#
			   and caminho_id in (#arguments.caminho_id#)
			 order by total desc	
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca o mapa de uma rota
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  03/04/2006
	--->		
	<cffunction name="get_rota_mapa" access="remote" returntype="query" output="true">
		<cfargument name="rota_id" required="yes">
		<cfargument name="caminho_id" required="yes">
		<cfargument name="com_imagem" required="no" default="0">
		<cfquery name="qr_result" datasource="KMM.KMM.COM.BR" username="rota" password="!kr_|_04">
				select mapa_id,
				   rota_id,
				   caminho_id,
				   <cfif arguments.com_imagem eq 1>
				   mapa,
				   </cfif>
				   latitude_minima,
				   longitude_minima,
				   latitude_maxima,
				   longitude_maxima
			  from rota.rota_mapa
			 where 1=1
			   and rota_id = #arguments.rota_id#
			   and caminho_id = #arguments.caminho_id#
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>
</cfcomponent>