<!-- KM&M Componentes -->
<cfcomponent displayname="Consultas das rotas" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO 
	-- Busca uma rota
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  16/03/2006
	--->		
	<cffunction name="get_rota" access="remote" returntype="query" output="true">
		<cfargument name="rota_id" required="no" default="">
		<cfargument name="municipio_id_origem" required="no" default="">
		<cfargument name="municipio_id_destino" required="no" default="">
		<cfargument name="municipio" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select r.rota_id,
				   r.municipio_id_origem,
                   cep.fnc_cidade_completa(r.municipio_id_origem) as municipio_origem,
				   r.latitude_origem,
				   r.longitude_origem,
				   r.municipio_id_destino,
                   cep.fnc_cidade_completa(r.municipio_id_destino) as municipio_destino,
				   r.latitude_destino,
				   r.longitude_destino
			  from oper.v$rota r
			 where 1=1
			<cfif len(trim(arguments.rota_id))>
			   and rota_id = #arguments.rota_id#
			</cfif>
			<cfif len(trim(arguments.municipio_id_origem))>
			   and municipio_id_origem = #arguments.municipio_id_origem#
			</cfif>
			<cfif len(trim(arguments.municipio_id_destino))>
			   and municipio_id_destino = #arguments.municipio_id_destino#
			</cfif>
			<cfif len(trim(arguments.municipio_id_destino))>
			   and (upper(cep.fnc_cidade_completa(r.municipio_id_destino)) like upper('%#arguments.municipio#%')
			     or upper(cep.fnc_cidade_completa(r.municipio_id_origem)) like upper('%#arguments.municipio#%'))
			</cfif>
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os caminhos da rota
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  16/03/2006
	--->		
	<cffunction name="get_rota_caminho" access="remote" returntype="query" output="true">
		<cfargument name="rota_id" required="no" default="">
		<cfargument name="caminho_id" required="no" default="">
		<cfargument name="caminho_consolidado" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select rota_id,
				   caminho_id,
				   descricao_caminho,
				   media_km_hodometro,
				   caminho_consolidado
			  from oper.v$rota_caminho
			 where 1=1
			<cfif len(trim(arguments.rota_id))>
			   and rota_id = #arguments.rota_id#
			</cfif>
			<cfif len(trim(arguments.caminho_id))>
			   and caminho_id = #arguments.caminho_id#
			</cfif>
			<cfif len(trim(arguments.caminho_consolidado))>
			   and caminho_consolidado = #arguments.caminho_consolidado#
			</cfif>
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as posicoes percorridas apos a data de termino de carga do ultimo romaneio do veiculo
	-- CRISTOFER  06/07/2006
	--->		
	<cffunction name="get_posicoes_veiculo" access="remote" returntype="query" output="true">
		<cfargument name="placa" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			 select ordem,
					referencia,
					data_inicio, 
					date_termino,
					latitude,
					longitude,
					placa,
					last_raio,
					raio,
					next_raio,
					nvl(raio,0)+nvl(last_raio,0) dist_last_next,
					importancia
			   from (select case 
							  when ordem = 1 then 0 
							  when ordem = max_ordem then 1
							  else row_number() over (order by nvl(raio,0)+nvl(last_raio,0) desc) + 1
							end as importancia,
							referencia,
							data_inicio, 
							date_termino,
							latitude,
							longitude,
							placa,
							last_raio,
							raio,
							next_raio as next_raio,
							ordem
					   from (select referencia,
									row_number() over(order by data_inicio) ordem,
									count(*) over (order by data_inicio rows between unbounded preceding and unbounded following) as max_ordem,
									data_inicio data_inicio, 
									data_termino date_termino,
									latitude,
									longitude,
									placa,
									oper.pkg_coord_geografica.fnc_haversine1(latitude, longitude, lag(latitude) over (order by data_inicio), lag(longitude) over (order by data_inicio)) as last_raio,
									oper.pkg_coord_geografica.fnc_haversine1(latitude, longitude, lead(latitude) over (order by data_inicio), lead(longitude) over (order by data_inicio)) as raio,
									next_raio as next_raio
							   from (select /*+ORDERED*/
											referencia,
											data_inicio,
											nvl((lead(data_inicio) over (order by grp))-1/86400,  data_termino) data_termino,
											max(next_raio) next_raio, 
											sum(tempo) tempo,
											latitude,
											longitude,
											placa
									   from (select grp,
													last_value(referencia) over (partition by grp) referencia,
													first_value(data) over (partition by grp) data_inicio,
													last_value(next_data) over (partition by grp) data_termino,
													lag(referencia) over (order by grp) ref_anterior,
													tempo, 
													next_raio,
													latitude,
													longitude,
													placa
											   from (select sum(case
																							  when raio < limiar and limiar > 5 and raio < 4  then 0
																							  when raio < 4 and raio < limiar and ((next_data - data) * 60 * 60 * 24 - round(limiar * 1.2)) > 0 then 0
																							  else 1
																								end) over (order by data rows unbounded preceding) grp,
																						case
															  when raio < limiar and limiar > 5 and raio < 4 and tempo < 0 then (next_data - data) * 60 * 60 * 24 + (tempo )
															  when raio < limiar and limiar > 5 and raio < 4 then (next_data - data) * 60 * 60 * 24
															  when raio < 4 and raio < limiar and ((next_data - data) * 60 * 60 * 24 - round(limiar * 2)) > 0 then (next_data - data) * 60 * 60 * 24 - round(limiar * 1.1)
															  when raio < (next_tempo/5) and next_tempo > 180 and raio > 4 then ((next_data - data) * 60 * 60 * 24) - round(next_raio * 1.1 * 60 )
															  else 0
															end tempo,
															referencia, 
															data, 
															(next_data-1/86400) next_data,
															raio, 
															next_raio,
															latitude,
															longitude,
															placa
																				 from (select raio, 
																	next_raio, 
																	tempo - round(next_raio * 2) tempo, 
																	referencia,
																	last_data, 
																	data, 
																	next_data,
																	(data - last_data) * 60 * 24 / 5 limiar,
																	(next_data - data) * 60 * 24 next_tempo,
																	latitude,
																	longitude,
																	placa
																							 from (select data, 
																			landmark referencia,
																			nvl(lag(data) over(order by data), data) last_data,
																			nvl(lead(data) over(order by data), data) next_data,
																			trunc((nvl(lead(data) over(order by data), data)-data) * 60 * 24) tempo,
																			nvl(round(oper.pkg_coord_geografica.fnc_haversine1(latitude, longitude, lag(latitude) over(order by data), lag(longitude) over(order by data)), 2),999) raio,
																			round(oper.pkg_coord_geografica.fnc_haversine1(latitude, longitude, lead(latitude) over(order by data), lead(longitude) over(order by data)), 2) next_raio,
																			latitude,
																			longitude,
																			placa
																										 from oper.v$posicao p
																	  where p.placa = '#arguments.placa#'
																		and data >= (select r.data_inicio
																					   from oper.v$romaneio_hist_veiculo r
																					  where r.data_termino is null
																						and r.placa_controle = p.placa)))))
							  where (referencia <> ref_anterior or tempo > 0)
							  group by grp, referencia, data_inicio, data_termino, latitude, longitude, placa
							  order by data_inicio )))
							where importancia <= 30
							 order by ordem
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna os municpios do IBGE cadastrados
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 12/03/2009
	--->	
	<cffunction name="get_municipio_ibge" displayname="Retorna os municpios do IBGE cadastrados" output="true" returntype="query" access="remote">
    	<cfargument name="municipio" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select im.sigla_uf, im.nome_municipio, im.cod_uf, im.cod_municipio,
				   im.cod_dv, im.cod_distrito,
                   oper.pkg_coord_geografica.fnc_graus2decimais(m.latitude) as latitude,
                   oper.pkg_coord_geografica.fnc_graus2decimais(m.longitude) as longitude
			  from cep.ibge_municipio im
              left outer join cep.municipio m
                on im.municipio_id_kmm = m.municipio_id
			 where 1=1
			<cfif Len(Trim(arguments.municipio))>
			   and upper(municipio) like upper('%#arguments.municipio#%')
			</cfif>
			 order by im.nome_municipio asc
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
</cfcomponent>