<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO 
	-- Busca os Modelos de Rastreador Cadastrados
	-- CRISTOFER  23/02/2008
	--->		
	<cffunction name="get_rastreador_modelo" access="remote" returntype="query" output="true">
    	<cfargument name="modelo_id" required="no" default="">
        <cfargument name="descricao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select rm.modelo_id,
                   rm.descricao,
                   rm.driver,
                   rd.descricao driver_descricao,
                   rm.parametros_driver,
                   rm.ordem_integracao,
                   (select nvl(max(num_mensagem),0)
                      from integracao.v$rastreador_modelo_inicio rmi
                     where rmi.modelo_id = rm.modelo_id
                       and tipo_id = 1) as modelo_inicio_1,
                   (select nvl(max(num_mensagem),0)
                      from integracao.v$rastreador_modelo_inicio rmi
                     where rmi.modelo_id = rm.modelo_id
                       and tipo_id = 2) as modelo_inicio_2,
                   (select nvl(max(num_mensagem),0)
                      from integracao.v$rastreador_modelo_inicio rmi
                     where rmi.modelo_id = rm.modelo_id
                       and tipo_id = 3) as modelo_inicio_3,
                   rm.date_insert,
                   rm.user_insert,
                   rm.date_update,
                   rm.user_update,
                   rm.site
              from integracao.v$rastreador_modelo rm
             inner join integracao.v$rastreador_driver rd
                     on rd.driver = rm.driver
             where 1=1
             <cfif len(trim(arguments.modelo_id))>
               and rm.modelo_id in (#arguments.modelo_id#)
             </cfif>
             <cfif len(trim(arguments.descricao))>
               and upper(rm.descricao) like upper('%#arguments.descricao#%')
             </cfif>
             order by rm.descricao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os Drivers de Rastreador Cadastrados
	-- CRISTOFER  23/02/2008
	--->		
	<cffunction name="get_rastreador_driver" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select driver,
                   descricao,
                   date_insert,
                   user_insert,
                   date_update,
                   user_update,
                   site
              from integracao.v$rastreador_driver
  		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os dados do job de integracao
	-- CRISTOFER  23/02/2008
	--->		
	<cffunction name="get_integracao_job" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select job,
                   intervalo_minutos,
                   broken,
                   em_execucao,
                   to_char(last_date,'dd/mm/yyyy hh24:mi:ss') as last_date,
                   to_char(next_date,'dd/mm/yyyy hh24:mi:ss') as next_date,
                   to_char(data_atual,'dd/mm/yyyy hh24:mi:ss') as data_atual,
                   to_char(numtodsinterval(sysdate - last_date,'day')) tempo_ultima_execucao,
                   to_char(numtodsinterval(next_date - sysdate,'day')) tempo_proxima_execucao,
                   to_char(date_insert,'dd/mm/yyyy hh24:mi:ss') as date_insert,
                   user_insert,
                   to_char(date_update,'dd/mm/yyyy hh24:mi:ss') as date_update,
                   user_update,
                   site
              from integracao.v$integracao_job
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as mensagens 
	-- CRISTOFER  23/02/2008
	--->		
	<cffunction name="get_mensagem" access="remote" returntype="query" output="true">
    	<cfargument name="tipo_id" required="no" default="">
    	<cfargument name="mensagem_id" required="no" default="">
    	<cfargument name="cod_veiculo" required="no" default="">
    	<cfargument name="situacao_id" required="no" default="">
    	<cfargument name="data_inicial" required="no" default="">
    	<cfargument name="data_final" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select m.mensagem_id,
                   m.modelo_id,
                   rm.descricao as modelo,
                   m.num_mensagem,
                   m.rastreador_id,
                   m.macro_id,
                   mc.descricao macro,
                   to_char(m.data_envio,'dd/mm/yyyy hh24:mi:ss') as data_envio,
                   to_char(m.data_recebimento,'dd/mm/yyyy hh24:mi:ss') as data_recebimento,
                   to_char(m.data_integracao,'dd/mm/yyyy hh24:mi:ss') as data_integracao,
                   m.situacao_id,
                   ms.descricao situacao,
                   m.tipo_id,
                   mt.descricao tipo,
                   m.conteudo_original,
                   m.conteudo_traduzido,
                   m.erro,
                   to_char(m.date_insert,'dd/mm/yyyy hh24:mi:ss') as date_insert,
                   m.user_insert,
                   to_char(m.date_update,'dd/mm/yyyy hh24:mi:ss') as date_update,
                   m.user_update,
                   m.site,
                   m.veiculo_id,
                   v.cod_veiculo
              from integracao.v$mensagem m
             inner join integracao.v$mensagem_situacao ms
                     on ms.situacao_id = m.situacao_id
             inner join integracao.v$mensagem_tipo mt
                     on mt.tipo_id = m.tipo_id
              left join integracao.v$rastreador_modelo rm
                     on rm.modelo_id = m.modelo_id
              left join integracao.v$veiculo v
                     on m.veiculo_id = v.veiculo_id
              left join integracao.v$macro mc
                     on mc.macro_id = m.macro_id
             where 1=1
             <cfif len(trim(arguments.data_inicial))>
               and nvl(m.data_envio,m.data_recebimento) >= '#arguments.data_inicial#'
             </cfif>
             <cfif len(trim(arguments.data_final))>
               and nvl(m.data_envio,m.data_recebimento) <= '#arguments.data_final#'
             </cfif>
             <cfif len(trim(arguments.tipo_id))>
			   and m.tipo_id in (#arguments.tipo_id#)
             </cfif>
             <cfif len(trim(arguments.mensagem_id))>
               and m.mensagem_id in (#arguments.mensagem_id#)
             </cfif>
             <cfif len(trim(arguments.cod_veiculo))>
               and v.cod_veiculo in (#ListQualify(arguments.cod_veiculo,"'",",")#)
             </cfif>
             <cfif len(trim(arguments.situacao_id))>
               and m.situacao_id in (#arguments.situacao_id#)
             </cfif>
             order by nvl(m.data_envio,m.data_recebimento) desc
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
	<!--- 
	-- PROPSITO 
	-- Buscas execues do Job de integracao
	-- CRISTOFER  25/02/2008
	--->		
	<cffunction name="get_integracao_execucao" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select execucao_id,
                   to_char(data_inicio,'dd/mm/yyyy hh24:mi:ss') as data_inicio,
                   to_char(data_termino,'dd/mm/yyyy hh24:mi:ss') as data_termino,
                   round((data_termino - data_inicio)*24*60*60) as tempo_segundos,
                   mensagens,
                   status,
                   to_char(date_insert,'dd/mm/yyyy hh24:mi:ss') as date_insert,
                   user_insert,
                   to_char(date_update,'dd/mm/yyyy hh24:mi:ss') as date_update,
                   user_update,
                   site,
                   mensagens_erro
              from integracao.v$integracao_execucao
             where data_inicio >= sysdate - 3/24/60
             order by data_inicio desc
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as situaoes das mensagens
	-- CRISTOFER  25/02/2008
	--->		
	<cffunction name="get_mensagem_situacao" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select situacao_id,
                   descricao,
                   date_insert,
                   user_insert,
                   date_update,
                   user_update,
                   site
              from integracao.v$mensagem_situacao
             order by situacao_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os tipos de mensagens
	-- CRISTOFER  25/02/2008
	--->		
	<cffunction name="get_mensagem_tipo" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select tipo_id,
                   descricao,
                   date_insert,
                   user_insert,
                   date_update,
                   user_update,
                   site
              from integracao.v$mensagem_tipo
             order by tipo_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
	<!--- 
	-- PROPSITO 
	-- Busca os tipos de dados
	-- CRISTOFER  26/02/2008
	--->		
	<cffunction name="get_tipo_dado" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select tipo_dado,
                   descricao,
                   date_insert,
                   user_insert,
                   date_update,
                   user_update,
                   site
              from integracao.v$tipo_dado
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os eventos
	-- CRISTOFER  26/02/2008
	--->		
	<cffunction name="get_evento" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select num_evento,
                   descricao,
                   date_insert,
                   user_insert,
                   date_update,
                   user_update,
                   site
              from integracao.v$evento
             order by num_evento
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os dados Cadastrados para o evento
	-- CRISTOFER  26/02/2008
	--->		
	<cffunction name="get_evento_dado" access="remote" returntype="query" output="true">
    	<cfargument name="num_evento" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select dado_id,
                   num_evento,
                   obrigatorio,
                   date_insert,
                   user_insert,
                   date_update,
                   user_update,
                   site,
                   descricao
              from integracao.v$evento_dado
             where 1=1
               and num_evento = #arguments.num_evento#
             order by dado_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- 
	-- CRISTOFER  //2008
	--->		
	<cffunction name="get_status_comando_teste" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="DELP02.delpozo.com.br" username="integracao" password=">>as-20">
            select (xmltype.createxml(pkg_supervisor.fnc_query_execute(9,'select * from forwardmessage_iifwd where iifwd_msgnumber = #arguments.num_mensagem#'))).extract('//return/recordset/row/field[6]/text()').getstringval() status
              from dual
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

</cfcomponent>