<cfcomponent displayname="Componentes de consulta para o Mdulo de Qualidade" extends="_transportes.funcoes.cfc_init">
		
	<!--- 
	-- PROPSITO
	-- Retorna todas Ocorrncias
	-- NOTAS EXPLICATIVAS
	-- Rafael - 06/10/2009 Criado
	--->	
	<cffunction name="get_ocorrencias" displayname="Retorna todas Ocorrncias" access="remote" returntype="query" output="true">
		<cfargument name="OCORRENCIA_TIPO_ID" required="no" default="" />
		<cfargument name="cod_pessoa" required="no" default="" />
        <cfargument name="ocorrencia_id" required="no" default="" />
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_fim" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select o.ocorrencia_id
                 , (select p.cliente from kss.v$pessoa p
                     where p.cod_pessoa = o.cod_pessoa) as funcionario
                  , o.cod_pessoa as cod_pessoa
                 , o.ocorrencia_tipo_id
                 , ot.descricao as ocorrencia_tipo
                 , ot.pontuacao as pontuacao
                 , decode(ot.debito_credito,0,'Dbito','Crdito') as debito_credito
                 , to_char(o.data_ocorrencia,'dd/mm/yyyy hh24:mi') as data_ocorrencia
                 , o.observacao
                 , o.num_romaneio
                 , ot.modalidade
                 , decode(modalidade,0,'Fretista',1,'Fornecedor',2,'Funcionrio') as modalidade_descricao
                 , o.user_insert as user_insert
              from oper.v$ocorrencia o
        inner join oper.v$ocorrencia_tipo ot
                on ot.ocorrencia_tipo_id = o.ocorrencia_tipo_id 
             where 1 = 1
         <cfif len(trim(arguments.OCORRENCIA_TIPO_ID))>
               and o.ocorrencia_tipo_id = #arguments.OCORRENCIA_TIPO_ID#
         </cfif>
         <cfif len(trim(arguments.cod_pessoa))>
               and o.cod_pessoa = #arguments.cod_pessoa#
         </cfif>
         <cfif len(trim(arguments.ocorrencia_id))>
               and o.ocorrencia_id = #arguments.ocorrencia_id#
         </cfif>
         <cfif Len(Trim(arguments.data_inicio))>
               and trunc(o.data_ocorrencia) >= '#arguments.data_inicio#'
         </cfif>
         <cfif Len(Trim(arguments.data_fim))>
               and trunc(o.data_ocorrencia) <= '#arguments.data_fim#'
         </cfif>
          order by o.data_ocorrencia
		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna os Tipos de Ocorrncias
	-- NOTAS EXPLICATIVAS
	-- Rafael - 06/10/2009 Criado
	--->	
	<cffunction name="get_ocorrencia_tipo" displayname="Retorna os Tipos de Ocorrncias" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
               select ot.ocorrencia_tipo_id
                    , ot.descricao
                    , ot.pontuacao
                    , ot.debito_credito
                    , modalidade
                    , decode(modalidade,0,'Fretista',1,'Fornecedor',2,'Funcionrio') as modalidade_descricao
                 from oper.v$ocorrencia_tipo ot
             order by ot.descricao
		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>
    
     <!--- 
	-- PROPSITO
	-- Retorna os Tipos de Ocorrncias
	-- NOTAS EXPLICATIVAS
	-- Rafael - 06/10/2009 Criado
	--->	
	<cffunction name="get_romaneio_rota" displayname="Retorna os Tipos de Ocorrncias" access="remote" returntype="query" output="true">
    	<cfargument name="NUM_ROMANEIO" required="no" default=""/>
        <cfargument name="PLACA" required="no" default=""/>
        <cfargument name="DATA_INICIO" required="no" default=""/>
        <cfargument name="DATA_FIM" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
               select r.num_romaneio
                    , r.carregamento ||' \ '|| r.destino as origem_destino
                    , r.carregamento as origem
                    , r.remetente
                    , r.destino
                    , r.destinatario
                    , r.data_inicio
                    , r.placa_controle as placa
                    , case
                         when situacao_id = 0 then
                            'Aberto'
                         when situacao_id = 1 then
                            'Encerrado'
                         when situacao_id = 2 then
                            'OK'
                         end as situacao
                 from oper.v$romaneio r
                 where 1= 1
                   <cfif Len(Trim(arguments.NUM_ROMANEIO))>
                   and r.num_romaneio = '#arguments.NUM_ROMANEIO#'
                   </cfif>
                   <cfif Len(Trim(arguments.PLACA))>
                   and r.placa_controle = '#arguments.PLACA#'
                   </cfif>
                   <cfif Len(Trim(arguments.data_inicio))>
                       and trunc(r.data_inicio) >= '#arguments.data_inicio#'
                 </cfif>
                 <cfif Len(Trim(arguments.DATA_FIM))>
                       and trunc(r.data_termino) <= '#arguments.DATA_FIM#'
                 </cfif>
                   and r.data_inicio >= sysdate - 30
		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>
		
</cfcomponent>