<cfcomponent  displayname="KM&M File Manager"
			  hint="<b>Site de Suporte da KM&M  de Engenharia de Sistemas</b><br>
				   <b>Autor					: Luciana ( luciana@kmm.com.br )</b><br>
				   <b>Data Criao</b> 		: 04/11/2003<br> 
				   <b>Atualizador			: </b><br>
				   <b>Data Atualizao</b> 	: <br> 
				   <b>Descrio				: </b><br> <div align='justify'>Esse Componente  reponsvel por reunir mtodos de Gesto de Arquivos.</div>"				   
			extends="_transportes.funcoes.cfc_init">	
			
<cfparam name="session.dsn" default="">
<cfparam name="session.dsn_menu" default="#session.dsn#">
<cffunction name="getTipoObjeto" displayname="Tarefas" access="remote" returntype="Query" output="true">	  
	<cfargument name="descricao" required="no" default="">
	<cfargument name="tipo_id" required="no" default="">
	<cfquery name="qr" datasource="#session.dsn_menu#" username="programacao" password="!kp_|_11" blockfactor="100">
		select tipo_id,
			   descricao,
			   tag,
			   user_insert,
			   date_insert,
			   user_update,
			   date_update,
			   site
		  from programacao.v$tipo_objeto
		 where 1=1
	  <cfif len(trim(arguments.tipo_id))>
		   and tipo_id = #arguments.tipo_id#
	  </cfif>
	  <cfif len(trim(arguments.descricao))>
		   and descricao like '%#arguments.descricao#%'
	  </cfif>
		 order by descricao
	</cfquery>   
	<cfreturn qr />
</cffunction>

<cffunction name="getCategoriaObjeto" displayname="Tarefas" access="remote" returntype="Query" output="true">	  
	<cfargument name="descricao" required="no" default="">
	<cfargument name="categoria_id" required="no" default="">
	<cfquery name="qr" datasource="#session.dsn_menu#" username="programacao" password="!kp_|_11" blockfactor="100">
		select categoria_id,
			   descricao,
			   categoria_pai,
			   tipo_id,
			   user_insert,
			   date_insert,
			   user_update,
			   date_update,
			   site
		  from programacao.v$categoria_objeto
		 where 1=1
	  <cfif len(trim(arguments.categoria_id))>
		   and categoria_id = #arguments.categoria_id#
	  </cfif>
	  <cfif len(trim(arguments.descricao))>
		   and descricao like '%#arguments.descricao#%'
	  </cfif>
		 order by descricao
	</cfquery>  
	<cfreturn qr />
</cffunction>

<cffunction name="getCategoriaObjetoTree" displayname="Tarefas" access="remote" returntype="Query" output="true">	  
	<cfargument name="tipo_id" required="no" default="">
	<cfquery name="qr" datasource="#session.dsn#" username="programacao" password="!kp_|_11" blockfactor="100">
		select categoria_id,
			   tipo_id,
			   descricao,
			   categoria_pai,
			   nivel,
			   user_insert,
			   date_insert,
			   user_update,
			   date_update,
			   site
		  from programacao.v$categoria_objeto_tree
		 where 1=1
		 <cfif len(trim(arguments.tipo_id))>
		   and tipo_id = #arguments.tipo_id#
		 </cfif>
	</cfquery>  
	<cfreturn qr />
</cffunction>  

<cffunction name="getObjetos" displayname="Tarefas" access="remote" returntype="Query" output="true" >	  
	<cfargument name="nome" required="no" default="">
	<cfargument name="tipo_id" required="no" default="">
	<cfargument name="categoria_id" required="no" default="">
	<cfargument name="objeto_id" required="no" default="">
	<cfargument name="mostra_corpo" required="no" default="1">
	<cfquery name="qr" datasource="KMM.KMM.COM.BR" username="programacao" password="!kp_|_11">
		select objeto_id,
			   tipo_id,
			   categoria_id,
			   nome,
			   nome_implementacao,
			   proposito,
			   <cfif arguments.mostra_corpo eq 1>
			   corpo,
			   </cfif>
			   user_insert,
			   date_insert,
			   user_update,
			   date_update,
			   site
		  from programacao.v$objeto
		 where 1=1
		 <cfif len(trim(arguments.nome))>
		   and upper(nome) like upper('%#arguments.nome#%')
		 </cfif>
		 <cfif len(trim(arguments.tipo_id))>
		   and tipo_id = #arguments.tipo_id#
		 </cfif>
		 <cfif len(trim(arguments.objeto_id))>
		   and objeto_id = #arguments.objeto_id#
		 </cfif>
		 <cfif len(trim(arguments.categoria_id))>
		   and categoria_id = #arguments.categoria_id#
		 </cfif>
		 order by objeto_id
	</cfquery>  
	<cfreturn qr />
</cffunction>  

<cffunction name="getDependenciasObjetoTree" displayname="Tarefas" access="remote" returntype="Query" output="true">	  
	<cfargument name="objeto_id" required="yes">
	<cfquery name="qr" datasource="#session.dsn_menu#" username="programacao" password="!kp_|_11" blockfactor="100">
		select do.objeto_id,
			   do.objeto_dependente,
			   ob.nome,
			   ob.tipo_id,
			   ob.categoria_id,
			   t.descricao as tipo,
			   cob.descricao as categoria
		  from programacao.v$dependencia_objeto do
		 inner join programacao.v$objeto ob
				 on ob.objeto_id = do.objeto_id
		 inner join programacao.v$tipo_objeto t
				 on t.tipo_id = ob.tipo_id
		 inner join programacao.v$categoria_objeto cob
				 on cob.categoria_id = ob.categoria_id
		 start with do.objeto_id = #arguments.objeto_id#
		 connect by prior do.objeto_dependente = do.objeto_id
	</cfquery>  
	<cfreturn qr />
</cffunction>  

<cffunction name="getLinguagens" displayname="Tarefas" access="remote" returntype="Query" output="true">	  
	<cfargument name="linguagem_id" required="no" default="">
	<cfargument name="nome" required="no" default="">
	<cfquery name="qr" datasource="#session.dsn_menu#" username="programacao" password="!kp_|_11" blockfactor="100">
		select linguagem_id,
			   nome,
			   sigla,
			   date_insert,
			   user_insert,
			   date_update,
			   user_update,
			   site
		  from programacao.v$linguagem
		 where 1=1
		 <cfif len(trim(arguments.linguagem_id))>
		 	and linguagem_id = #arguments.linguagem_id#
		 </cfif>
		 <cfif len(trim(arguments.nome))>
		 	and upper(nome) like upper('%#arguments.nome#%')
		 </cfif>
		 order by linguagem_id
	</cfquery>  
	<cfreturn qr />
</cffunction>  

<cffunction name="getLinguagemTermos" displayname="Tarefas" access="remote" returntype="Query" output="true">	  
	<cfargument name="linguagem_id" required="no" default="">
	<cfquery name="qr" datasource="#session.dsn_menu#" username="programacao" password="!kp_|_11">
		select linguagem_id,
			   termo_id,
			   termo_cod,
			   traducao,
			   date_insert,
			   user_insert,
			   date_update,
			   user_update,
			   site
		  from programacao.v$linguagem_termo
		 where 1=1
		 <cfif len(trim(arguments.linguagem_id))>
		 	and linguagem_id = #arguments.linguagem_id#
		 </cfif>
	</cfquery>  
	<cfreturn qr />
</cffunction>  

<cffunction name="getLinguagemTermosStruct" displayname="Tarefas" access="remote" returntype="Struct" output="true">	  
	<cfargument name="linguagem_id" required="no" default="">
	<cfset retor = StructNew()>
	<cfset qrTermos = this.getLinguagemTermos(linguagem_id = arguments.linguagem_id)>
	<cfloop query="qrTermos">
		<cfset retor[ReReplace(qrTermos.termo_cod, "[&,;]", "_", "ALL")] = qrTermos.traducao>
	</cfloop>
	<cfreturn retor />
</cffunction> 

<cffunction name="getClienteConfig" displayname="" access="remote" returntype="Query" output="true">	  
	<cfquery name="qr" datasource="KMM.KMM.COM.BR" username="site" password="!ks_|_04">
		select cliente_id,
			   nome,
			   pasta,
			   dsn,
			   user_insert,
			   date_insert,
			   user_update,
			   date_update,
			   logo,
			   url
		  from site.v$cliente_config
		 where sincronizador = 1
		 order by nome
	</cfquery>  
	<cfreturn qr />
</cffunction>  

<cffunction name="getDSN" displayname="" access="remote" returntype="Query" output="true">	  
	<cfquery name="qr" datasource="KMM.KMM.COM.BR" username="site" password="!ks_|_04">
		select dsn_id,
			   nome,
			   nome_exibicao,
			   ativo,
			   date_insert,
			   user_insert,
			   date_update,
			   user_update,
			   item_acesso_id
		  from site.v$dsn
		 order by nome_exibicao
  	</cfquery>  
	<cfreturn qr />
</cffunction>

<cffunction name="getArquivosBanco" displayname="" access="remote" returntype="Query" output="true">	  
	<cfargument name="diretorio" required="no" default="">
	<cfargument name="arquivo" required="no" default="">
	<cfargument name="tipo" required="no" default="">
	<cfargument name="arquivo_raiz" required="no" default="">
	<cfargument name="conteudo" required="no" default="0">
	<cfargument name="recurse" required="no" default="1">
	<cfargument name="usuario_sincronizacao" required="no" default="">
	<cfquery name="qr" datasource="KMM.KMM.COM.BR" username="site" password="!ks_|_04">
		select arquivo_id, site_id, url, nvl(arquivo_pai,0) as arquivo_pai ,
				   substr(sys_connect_by_path(url, ' - '),2) as caminho_completo, t.versao, t.tipo, '/var/www/html/sincronizador'||t.diretorio diretorio, t.assinatura,
				   t.data_ult_modificacao as ultima_modificacao
				   <cfif arguments.conteudo eq 1>
				   ,t.conteudo
				   </cfif>
		  from site.v$site_arquivos t
		 where 1=1
		 <cfif len(trim(arguments.diretorio))>
		   and diretorio||'/' like '#replace(arguments.diretorio&'/', '//', '/', 'ALL')#%'
		 </cfif>
		 <cfif len(trim(arguments.arquivo))>
		   and '/var/www/html/sincronizador'||diretorio||'/'||url = '#arguments.arquivo#'
		 </cfif>
		 <cfif len(trim(arguments.tipo))>
		   and tipo = '#arguments.tipo#'
		 </cfif>
		 <cfif (not len(trim(arguments.diretorio))) and arguments.recurse eq 0>
		 	and level = <cfif len(trim(arguments.arquivo_raiz))>2<cfelse>1</cfif>
		 </cfif>
		 <cfif arquivo_raiz eq -1>
		    and data_atualizacao > sysdate -1 
		 </cfif>
		 <cfif arquivo_raiz eq -2>
		    and data_atualizacao > sysdate -1 
			and user_update = upper('#arguments.usuario_sincronizacao#')
		 </cfif>
		 <cfif len(trim(arquivo_raiz)) and arquivo_raiz gte 0>
		 START WITH arquivo_id = #arguments.arquivo_raiz#
		 <cfelse>
		 START WITH arquivo_pai is null
		 </cfif>
		 CONNECT BY PRIOR arquivo_id = arquivo_pai 
		 order siblings by tipo, replace(url, '_', ' _') 
	</cfquery>  
	<cfreturn qr />
</cffunction>  
 
<cffunction name="getDiretorioServidor" access="remote" output="true" returntype="query">
	<cfargument name="diretorio" required="yes">
	<cfargument name="assinatura" required="no" default="0">
	<cfargument name="arquivo" required="no" default="">
	<cfargument name="recurse" required="no" default="yes">
	<cfargument name="force_pai" required="no" default="">
	<cfset qrTree = QueryNew('arquivo_id, url,arquivo_pai,tipo,diretorio,tamanho,assinatura,ultima_modificacao','CF_SQL_INTEGER,CF_SQL_VARCHAR,CF_SQL_VARCHAR,CF_SQL_VARCHAR,CF_SQL_VARCHAR,CF_SQL_VARCHAR,CF_SQL_VARCHAR,CF_SQL_TIMESTAMP')>
	<cfif not len(trim(arguments.arquivo))>
		<cfdirectory
			directory="#arguments.diretorio#"
			name="lista_arquivos" recurse="#arguments.recurse#" sort="type, directory, name">
		<cfset v_pai = 0>
		<cfset v_arquivo_id = 0>	
		<cfset v_dir = ''>
		<cfset v_array_dir = StructNew()>
		<cfset v_dir = Left(arguments.diretorio, Len(arguments.diretorio)-1)>
		<cfset v_array_dir[arguments.diretorio] = 0>
		<cfset v_array_dir[v_dir] = 0>
		<cfoutput query="lista_arquivos">
			<cfif not Find('LCK',lista_arquivos.name) and not Find('.mno',lista_arquivos.name) >
				<cfset v_arquivo_id = v_arquivo_id + 1>	
				<cfset v_path = lista_arquivos.directory & '/' & lista_arquivos.name>
				<cfif lista_arquivos.type neq 'dir'>
					<cfset v_pai = v_array_dir[lista_arquivos.directory]>				
					<cfset queryAddRow(qrTree)>
					<cfset querySetCell(qrTree,"arquivo_id",  v_arquivo_id )>
					<cfset querySetCell(qrTree,"url",  lista_arquivos.name )>
                    <cfif len(trim(arguments.force_pai))>
						<cfset querySetCell(qrTree,"arquivo_pai",  arguments.force_pai )>
                    <cfelse>
						<cfset querySetCell(qrTree,"arquivo_pai",  v_pai )>
                    </cfif>
					<cfset querySetCell(qrTree,"tipo",  lista_arquivos.type )>
					<cfset querySetCell(qrTree,"diretorio",  lista_arquivos.directory )>
					<cfset querySetCell(qrTree,"tamanho",  lista_arquivos.size )>
					<cfset querySetCell(qrTree,"ultima_modificacao",  lista_arquivos.dateLastModified )>
					<cfif arguments.assinatura eq 1>
						<cfscript>
							querySetCell(qrTree,"assinatura",  this.md5_file(file = lista_arquivos.directory&"/"&lista_arquivos.name ) );
						</cfscript>
					</cfif>
				<cfelse>
					<cfset v_array_dir[v_path] = v_arquivo_id>
					<cfset v_pai = StructFind(v_array_dir, lista_arquivos.directory)>
					<cfset queryAddRow(qrTree)>
					<cfset querySetCell(qrTree,"arquivo_id",  v_arquivo_id )>
					<cfset querySetCell(qrTree,"url",  lista_arquivos.name )>
                    <cfif len(trim(arguments.force_pai))>
						<cfset querySetCell(qrTree,"arquivo_pai",  arguments.force_pai )>
                    <cfelse>
						<cfset querySetCell(qrTree,"arquivo_pai",  v_pai )>
                    </cfif>
					<cfset querySetCell(qrTree,"tipo",  lista_arquivos.type )>			
					<cfset querySetCell(qrTree,"diretorio",  lista_arquivos.directory )>
				</cfif>
			</cfif>
		</cfoutput>	
	<cfelse>
		<cfdirectory
			directory="#arguments.diretorio#"
			name="lista_arquivos" recurse="no" sort="type, directory, name">
		<cfoutput query="lista_arquivos">
			<cfset v_path = lista_arquivos.directory & '/' & lista_arquivos.name>
			<cfif v_path eq arguments.arquivo>
				<cfset queryAddRow(qrTree)>
				<cfset querySetCell(qrTree,"arquivo_id",  0 )>
				<cfset querySetCell(qrTree,"url",  lista_arquivos.name )>
				<cfset querySetCell(qrTree,"tipo",  lista_arquivos.type )>
				<cfset querySetCell(qrTree,"diretorio",  lista_arquivos.directory )>
				<cfset querySetCell(qrTree,"tamanho",  lista_arquivos.size )>
				<cfset querySetCell(qrTree,"ultima_modificacao",  lista_arquivos.dateLastModified )>
				<cfif arguments.assinatura eq 1>
					<cfscript>
						querySetCell(qrTree,"assinatura",  this.md5_file(file = lista_arquivos.directory&"/"&lista_arquivos.name ) );
					</cfscript>
				</cfif>
			</cfif>
		</cfoutput>			
	</cfif>
	<cfreturn qrTree>
</cffunction>

<cffunction name="getCompareDirQuery" access="public" output="true" returntype="query">
	<cfargument name="Server" required="yes">
	<cfargument name="Banco"  required="yes">
	<cfset QueryAddColumn(Server, "identificador", ArrayNew(1))>
	<cfset QueryAddColumn(Banco, "identificador", ArrayNew(1))>	
	<cfloop from="1" to="#Server.recordcount#" index="index">
			<cfset Server["identificador"][index] = Server["diretorio"][index]&Server["url"][index]>
	</cfloop>
	<cfloop from="1" to="#Banco.recordcount#" index="index">
		<cfset Banco["identificador"][index] = Banco["diretorio"][index]&"/"&Banco["url"][index]>
	</cfloop>
	<cfset arIDServer	= ( VaLueList( Server.identificador ) )>
	<cfset arIDBanco	= ( VaLueList( Banco.identificador ) )>
	<cfset qrTree = QueryNew('url,tipo,diretorio,tamanho,assinatura,ultima_modificacao,acao,path,descricao','CF_SQL_VARCHAR,CF_SQL_VARCHAR,CF_SQL_VARCHAR,CF_SQL_VARCHAR,CF_SQL_VARCHAR,CF_SQL_TIMESTAMP,CF_SQL_VARCHAR,CF_SQL_VARCHAR,CF_SQL_VARCHAR')>
	<cfif Server.recordcount or Banco.recordcount>
		<cfloop from="1" to="#ListLen(arIDServer)#" index="v_index">
			<!---Busca o item do Server no Banco --->
			<cfset v_index2 = ListFind(UCase(arIDBanco), ListGetAt(UCase(arIDServer), v_index))>
            
			<cfif v_index2 eq 0 and ucase(Server["tipo"][v_index]) neq 'DIR'>
				<!---Item nao existe em Banco --->
				<cfset QueryAddRow( qrTree )>
				<cfset QuerySetCell(qrTree	, "url"					, Server["url"][v_index])>
				<cfset QuerySetCell(qrTree	, "diretorio"			, Server["diretorio"][v_index])>
				<cfset QuerySetCell(qrTree	, "tamanho"				, Server["tamanho"][v_index])>
				<cfset QuerySetCell(qrTree	, "ultima_modificacao"	, Server["ultima_modificacao"][v_index])>
				<cfset QuerySetCell(qrTree	, "tipo"				, Server["tipo"][v_index])>
				<cfset QuerySetCell(qrTree	, "path"				, Server["identificador"][v_index])>
				<cfset QuerySetCell(qrTree	, "acao"				, "Inserir")>
				<cfset QuerySetCell(qrTree	, "descricao"			, "O arquivo no est cadastrado no banco de dados")>
			<cfelseif Server["assinatura"][v_index] neq Banco["assinatura"][v_index2] and ucase(Server["tipo"][v_index]) neq 'DIR'>
				<!---Caso as assinaturas no correspondam--->
				<cfset QueryAddRow( qrTree )>
				<cfset QuerySetCell(qrTree	, "url"					, Server["url"][v_index])>
				<cfset QuerySetCell(qrTree	, "diretorio"			, Server["diretorio"][v_index])>
				<cfset QuerySetCell(qrTree	, "tamanho"				, Server["tamanho"][v_index])>
				<cfset QuerySetCell(qrTree	, "ultima_modificacao"	, Server["ultima_modificacao"][v_index])>
				<cfset QuerySetCell(qrTree	, "tipo"				, Server["tipo"][v_index])>
				<cfset QuerySetCell(qrTree	, "path"				, Server["identificador"][v_index])>
				<cfset QuerySetCell(qrTree	, "acao"				, "Atualizar")>
				<cfset QuerySetCell(qrTree	, "descricao"			, "O conteudo do arquivo foi alterado."&Chr(10)&"Assinaturas:"&Chr(10)&Server["assinatura"][v_index]&""&Chr(10)&""&Banco["assinatura"][v_index])>
			</cfif>
		</cfloop>	

		<cfloop from="1" to="#ListLen(arIDbanco)#" index="v_index">
			<!---Busca o item do Banco no Server --->
			<cfset v_index2 = ListFind(UCase(arIDServer), ListGetAt(UCase(arIDBanco), v_index))>
			<cfif v_index2 eq 0 and ucase(Banco["tipo"][v_index]) neq 'DIR'>
				<!---Item nao existe no Servidor --->
				<cfset QueryAddRow( qrTree )>
				<cfset QuerySetCell(qrTree	, "url"					, Banco["url"][v_index])>
				<cfset QuerySetCell(qrTree	, "diretorio"			, Banco["diretorio"][v_index])>
				<cfset QuerySetCell(qrTree	, "tipo"				, Banco["tipo"][v_index])>
				<cfset QuerySetCell(qrTree	, "path"				, Banco["identificador"][v_index])>
				<cfset QuerySetCell(qrTree	, "acao"				, "Excluir")>
				<cfset QuerySetCell(qrTree	, "descricao"			, "O arquivo no existe mais no sincronizador e ainda esta cadastrado no banco de dados")>
			</cfif>
		</cfloop>	
	</cfif>		
	<cfreturn qrTree>
</cffunction>

<cffunction name="getCompareDirQueryRemote" access="public" output="true" returntype="query">
	<cfargument name="Banco" required="yes">
	<cfargument name="Server"  required="yes">
	<cfset QueryAddColumn(Banco, "identificador", ArrayNew(1))>
	<cfset QueryAddColumn(Server, "identificador", ArrayNew(1))>	
	<cfloop from="1" to="#Banco.recordcount#" index="index">
			<cfset Banco["identificador"][index] = Replace(Banco["diretorio"][index], '/var/www/html/sincronizador', Left(ExpandPath('/'), Len(ExpandPath('/'))-1))&"/"&Banco["url"][index]>
	</cfloop>
	<cfloop from="1" to="#Server.recordcount#" index="index">
		<cfset Server["identificador"][index] = Server["diretorio"][index]&"/"&Server["url"][index]>
	</cfloop>
	<cfset arIDBanco	= ( VaLueList( Banco.identificador ) )>
	<cfset arIDServer	= ( VaLueList( Server.identificador ) )>
	<cfset qrTree = QueryNew('url,tipo,diretorio,tamanho,assinatura,ultima_modificacao,acao,path,descricao','CF_SQL_VARCHAR,CF_SQL_VARCHAR,CF_SQL_VARCHAR,CF_SQL_VARCHAR,CF_SQL_VARCHAR,CF_SQL_TIMESTAMP,CF_SQL_VARCHAR,CF_SQL_VARCHAR,CF_SQL_VARCHAR')>
	<cfif Banco.recordcount or Server.recordcount>
		<cfloop from="1" to="#ListLen(arIDBanco)#" index="v_index">
			<!---Busca o item do Banco no Server --->
			<cfset v_index2 = ListFind(UCase(arIDServer), ListGetAt(UCase(arIDBanco), v_index))>
			<cfif v_index2 eq 0>
				<!---Item nao existe em Server --->
				<cfset QueryAddRow( qrTree )>
				<cfset QuerySetCell(qrTree	, "url"					, Banco["url"][v_index])>
				<cfset QuerySetCell(qrTree	, "diretorio"			, Banco["diretorio"][v_index])>
				<cfset QuerySetCell(qrTree	, "tipo"				, Banco["tipo"][v_index])>
				<cfset QuerySetCell(qrTree	, "path"				, Banco["identificador"][v_index])>
				<cfset QuerySetCell(qrTree	, "acao"				, "Inserir")>
				<cfset QuerySetCell(qrTree	, "descricao"			, "O arquivo no est cadastrado no Servidor do Cliente")>
				<cfset QuerySetCell(qrTree	, "ultima_modificacao"	, Banco["ultima_modificacao"][v_index])>
			<cfelseif Banco["assinatura"][v_index] neq Server["assinatura"][v_index2]>
				<!---Caso as assinaturas no correspondam--->
				<cfset QueryAddRow( qrTree )>
				<cfset QuerySetCell(qrTree	, "url"					, Banco["url"][v_index])>
				<cfset QuerySetCell(qrTree	, "diretorio"			, Banco["diretorio"][v_index])>
				<cfset QuerySetCell(qrTree	, "tipo"				, Banco["tipo"][v_index])>
				<cfset QuerySetCell(qrTree	, "path"				, Banco["identificador"][v_index])>
				<cfset QuerySetCell(qrTree	, "acao"				, "Atualizar")>
				<cfset QuerySetCell(qrTree	, "descricao"			, "O conteudo do arquivo foi alterado."&Chr(10)&"Assinaturas:"&Chr(10)&Banco["assinatura"][v_index]&""&Chr(10)&""&Server["assinatura"][v_index])>
				<cfset QuerySetCell(qrTree	, "ultima_modificacao"	, Banco["ultima_modificacao"][v_index])>
			</cfif>
		</cfloop>	

		<cfloop from="1" to="#ListLen(arIDServer)#" index="v_index">
			<!---Busca o item do Server no Banco --->
			<cfset v_index2 = ListFind(UCase(arIDBanco), ListGetAt(UCase(arIDServer), v_index))>
			<cfif v_index2 eq 0>
				<!---Item nao existe no Servidor --->
				<cfset QueryAddRow( qrTree )>
				<cfset QuerySetCell(qrTree	, "url"					, Server["url"][v_index])>
				<cfset QuerySetCell(qrTree	, "diretorio"			, Server["diretorio"][v_index])>
				<cfset QuerySetCell(qrTree	, "tipo"				, Server["tipo"][v_index])>
				<cfset QuerySetCell(qrTree	, "path"				, Server["identificador"][v_index])>
				<cfset QuerySetCell(qrTree	, "ultima_modificacao"	, Server["ultima_modificacao"][v_index])>
				<cfset QuerySetCell(qrTree	, "tamanho"				, Server["tamanho"][v_index])>
				<cfset QuerySetCell(qrTree	, "tipo"				, Server["tipo"][v_index])>
				<cfset QuerySetCell(qrTree	, "acao"				, "Excluir")>
				<cfset QuerySetCell(qrTree	, "descricao"			, "O arquivo no existe mais no Banco de dados e ainda esta cadastrado no Servidor do Cliente")>
			</cfif>
		</cfloop>	
	</cfif>		
	
	<cfreturn qrTree>
</cffunction>

<!--- 
-- PROPSITO
-- Captura o Hash MD5 do Arquivo
-- CRISTOFER 04/11/2005 - criado
--->
<cffunction name="md5_file" displayname="Captura o Hash MD5 do Arquivo" returntype="string" output="true" access="remote">
	<cfargument name="file" required="yes">
	<cfargument name="expand" required="no" default="0">
	<cfif arguments.expand eq 1>
		<cfset arguments.file = expandPath(arguments.file)>
	</cfif>
	<cffile action="read" file="#file#" variable="xFile" />
	<cfscript>
		return ucase(hash(xFile,'MD5'));
	</cfscript>
</cffunction>

<cffunction name="get_mimetype" displayname="Captura o MIMETYPE do Arquivo" returntype="string" output="true">
	<cfargument name="file" required="yes">
	<cfhttp url="http://#cgi.HTTP_HOST#/KMM/mimetype.php?ARQUIVO=#file#" method="get"></cfhttp>
	<cfreturn UCase(cfhttp.FileContent) />
</cffunction>
       
<cffunction name="getArquivoScripts" displayname="" access="remote" returntype="Struct" output="true">	  
	<cfscript>
		conn = CreateObject("component", "_transportes.consulta.cfc_programacao");
		qrObjetos = conn.getObjetos(tipo_id = 1);
		QueryAddColumn(qrObjetos, "implementacao", arraynew(1));
	</cfscript>
	<cfset retorno.query = qrObjetos>
	
  <cfset v_corpo = "">
  <cfoutput query="qrObjetos">
  	
<cfset v_estrutura = "
/* 
Funo: #qrObjetos.nome#
Inserida: #lsDateFormat(qrObjetos.date_insert)# #LSTimeFormat(qrObjetos.date_insert)#
Ultima alterao: #lsDateFormat(qrObjetos.date_update)# #LSTimeFormat(qrObjetos.date_update)#
Propsito: #qrObjetos.proposito#
*/
		
#qrObjetos.corpo#
">
<cfset QuerySetCell(qrObjetos, "implementacao", v_estrutura, qrObjetos.currentRow)>
<cfset v_corpo=v_corpo&v_estrutura>
  </cfoutput>
	<cfset retorno.arquivo = v_corpo>
	<cfreturn retorno />
</cffunction> 

	<!--- 
	-- PROPSITO 
	-- Busca a arvore de menus do dsn selecionado
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  22/02/2006
	--->		
	<cffunction name="get_item_acesso" access="remote" returntype="query" output="true">
		<cfargument name="dsn" required="no" default="#session.dsn#">
		<cfargument name="inicio" required="no" default="">
		<cfquery name="qr_result" datasource="#arguments.dsn#" username="acesso" password="!ka_|_06">
			select item_acesso_id,
				   nvl(item_acesso_pai,0) as item_acesso_pai,
				   item_acesso_cod,
				   descricao,
				   dll_name,
				   exported_function,
				   act_caption,
				   act_enabled,
				   act_visible,
				   act_hint,
				   act_image,
				   act_shortcut,
				   act_tag,
				   web_url,
				   web_url_image,
				   web_target,
				   ordem,
				   separar,
				   publico
			  from acesso.v$item_acesso ita
			<cfif len(trim(arguments.inicio))>
			 start with item_acesso_id = #arguments.inicio#
			<cfelse>
			 start with item_acesso_pai is null
			</cfif>
			connect by prior ita.item_acesso_id = ita.item_acesso_pai
			 order siblings by ordem
     	</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
	

	<!--- 
	-- PROPSITO 
	-- Busca os Registros diferentes entre 2 querys 
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  22/02/2006
	--->		
	<cffunction name="query_compare" access="remote" returntype="query" output="true">
		<cfargument name="query_origem" required="yes">
		<cfargument name="query_destino" required="yes">
		<cfargument name="id" required="yes">
		<cfif arguments.query_origem.columnlist neq arguments.query_destino.columnlist>
			<cfthrow detail="As querys no possuem os mesmos campos portanto no podem ser comparadas"
					  message="As querys no possuem os mesmos campos portanto no podem ser comparadas">
		</cfif>
		<cfset qr_result = QueryNew(arguments.query_origem.columnlist&',compare_action')>
		<cfset id_origem = ArrayToList(query_origem[arguments.id], ',')>
		<cfset id_destino = ArrayToList(query_destino[arguments.id], ',')>
		<cfloop from="1" to="#ArrayLen(query_origem[arguments.id])#" index="v_idx">
			<cfif not ListFind(id_destino, query_origem[arguments.id][v_idx], ',')>
				<cfset QueryAddRow(qr_result)>
				<cfloop list="#query_origem.columnlist#" index="v_col">
					<cfset QuerySetCell(qr_result, v_col, query_origem[v_col][v_idx], qr_result.recordcount)>
				</cfloop>
				<cfset QuerySetCell(qr_result, 'compare_action', 'Inserir', qr_result.recordcount)>
			<cfelse>
				<cfset v_igual = true>
				<cfset v_idx_d = ListFind(id_destino, query_origem[arguments.id][v_idx], ',')>
				<cfloop list="#query_origem.columnlist#" index="v_col">
					<cfif query_origem[v_col][v_idx] neq query_destino[v_col][v_idx_d]>
						<cfset v_igual = false>
					</cfif>
				</cfloop>
				<cfif not v_igual>
					<cfset QueryAddRow(qr_result)>
					<cfloop list="#query_origem.columnlist#" index="v_col">
						<cfset QuerySetCell(qr_result, v_col, query_origem[v_col][v_idx], qr_result.recordcount)>
					</cfloop>
					<cfset QuerySetCell(qr_result, 'compare_action', 'Atualizar', qr_result.recordcount)>
				</cfif>
			</cfif>
		</cfloop>

		<cfloop from="1" to="#ArrayLen(query_destino[arguments.id])#" index="v_idx">
			<cfif not ListFind(id_origem, query_destino[arguments.id][v_idx], ',')>
				<cfset QueryAddRow(qr_result)>
				<cfloop list="#query_destino.columnlist#" index="v_col">
					<cfset QuerySetCell(qr_result, v_col, query_destino[v_col][v_idx], qr_result.recordcount)>
				</cfloop>
				<cfset QuerySetCell(qr_result, 'compare_action', 'Excluir', qr_result.recordcount)>
			</cfif>
		</cfloop>

		<cfreturn qr_result>		
	</cffunction>	


	<!--- 
	-- PROPSITO 
	-- Busca as versoes do arquivo
	-- CRISTOFER  19/07/2007
	--->		
	<cffunction name="get_site_arquivos_log" access="remote" returntype="query" output="true">
    	<cfargument name="url" required="yes">
    	<cfargument name="diretorio" required="yes">
        <cfargument name="versao" required="no" default="">
        <cfargument name="com_conteudo" required="no" default="0">
        <cfargument name="atual" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select site_id,
                   arquivo_id,
                   versao,
                   url,
                   tipo,
                   arquivo_pai,
                   assinatura,
                   diretorio,
                   sincronizar,
                   <cfif arguments.com_conteudo eq 1>
                   conteudo,
                   </cfif>
                   data_atualizacao,
                   data_ult_modificacao,
                   user_insert,
                   date_insert,
                   user_update,
                   date_update,
                   site,
                   1 as atual
              from site.v$site_arquivos
             where url = '#arguments.url#'
               and diretorio = '#arguments.diretorio#'
              <cfif len(trim(arguments.versao))>
               and versao = #arguments.versao#
              </cfif>
              <cfif arguments.atual eq 0>
               and 1=0
              </cfif>
            union all
            select site_id,
                   arquivo_id,
                   versao,
                   url,
                   tipo,
                   arquivo_pai,
                   assinatura,
                   diretorio,
                   sincronizar,
                   <cfif arguments.com_conteudo eq 1>
                   conteudo,
                   </cfif>
                   data_atualizacao,
                   data_ult_modificacao,
                   user_insert,
                   date_insert,
                   user_update,
                   date_update,
                   site,
                   0 as atual
              from site.v$site_arquivos_log
             where url = '#arguments.url#'
               and diretorio = '#arguments.diretorio#'
              <cfif len(trim(arguments.versao))>
               and versao = #arguments.versao#
              </cfif>
              <cfif arguments.atual eq 1>
               and 1=0
              </cfif>
             order by versao desc
   		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
	<!--- 
	-- PROPSITO 
	-- Busca o conteudo do arquivo na verso especificada (-1 => arquivo do servidor)
	-- CRISTOFER  24/07/2007
	--->		
	<cffunction name="get_arquivo_conteudo_versao" access="remote" returntype="Any" output="true">
    	<cfargument name="diretorio" required="yes">
    	<cfargument name="url" required="yes">
    	<cfargument name="versao" required="yes">
        <cfif arguments.versao eq -1>
        	<cffile action="read" file="#arguments.diretorio#/#arguments.url#" variable="v_conteudo">
        <cfelse>
            <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            	select conteudo
                  from site.v$site_arquivos
                 where url = '#arguments.url#'
                   and diretorio = '#arguments.diretorio#'
                  <cfif len(trim(arguments.versao))>
                   and versao = #arguments.versao#
                  </cfif>
                union all
                select conteudo
                  from site.v$site_arquivos_log
                 where url = '#arguments.url#'
                   and diretorio = '#arguments.diretorio#'
                  <cfif len(trim(arguments.versao))>
                   and versao = #arguments.versao#
                  </cfif>
            </cfquery>
            <cfset v_conteudo = toString(qr_result.conteudo)>
        </cfif>
		<cfreturn v_conteudo>
	</cffunction>
    
    
    <!--- 
	-- PROPSITO 
	-- Busca as versoes do arquivo
	-- CRISTOFER  19/07/2007
	--->		
	<cffunction name="merge_text" access="remote" returntype="struct" output="true">
    	<cfargument name="text_1" required="yes">
    	<cfargument name="text_2" required="yes">
		<cfset retorno = structNew()>
        <cfscript>
			v_array_1 = ListToArray(arguments.text_1,chr(13)&chr(10));
			v_array_2 = ListToArray(arguments.text_2,chr(13)&chr(10));
			v_array_1_res = arrayNew(1);
			v_array_2_res = arrayNew(1);
			v_array_diff = arrayNew(1);
			v_max_ar_1 = arrayLen(v_array_1);
			v_max_ar_2 = arrayLen(v_array_2);
			v_count_1 = 1;
			v_count_2 = 1;
			// Loop por todas as linhas
			while(v_count_1 le v_max_ar_1 or v_count_2 le v_max_ar_2) {
			    if(v_count_1 le v_max_ar_1 and v_count_2 le v_max_ar_2) {
					// Se as linhas forem iguais
					if(trim(v_array_1[v_count_1]) eq trim(v_array_2[v_count_2])) {
						v_array_1_res[ArrayLen(v_array_1_res)+1] = v_array_1[v_count_1];
						v_array_2_res[ArrayLen(v_array_2_res)+1] = v_array_2[v_count_2];
						v_array_diff[ArrayLen(v_array_diff)+1] = 'igual';
						v_count_1 = v_count_1 + 1;
						v_count_2 = v_count_2 + 1;
					} else {
					// Se as linhas forem diferentes corre ate o final do 2 para encontrar correspondencia
						v_encontrado_2 = v_count_2;
						for(v_count_aux_2 = v_count_2;v_count_aux_2 le v_max_ar_2;v_count_aux_2 = v_count_aux_2 + 1) {
							if(trim(v_array_1[v_count_1]) eq trim(v_array_2[v_count_aux_2])) {
								v_encontrado_2 = v_count_aux_2;
								break;
							}
						}
						if(v_encontrado_2 gt v_count_2) {
							// Se encontrar correspondencia preenche as linhas com "" ate atingir esta
							for(v_count_2 = v_count_2;v_count_2 lt v_encontrado_2;v_count_2 = v_count_2 + 1) {
								v_array_1_res[ArrayLen(v_array_1_res)+1] = "";
								v_array_2_res[ArrayLen(v_array_2_res)+1] = v_array_2[v_count_2];
								v_array_diff[ArrayLen(v_array_diff)+1] = 'direita';
							}
							v_count_2 = v_count_2 + 1;
						} else {
							// No encontrou nenhuma ocorrencia no 2, insere a linha em 1 e em branco no 2
							v_array_1_res[ArrayLen(v_array_1_res)+1] = v_array_1[v_count_1];
							v_array_2_res[ArrayLen(v_array_2_res)+1] = "";
							v_array_diff[ArrayLen(v_array_diff)+1] = 'esquerda';
							v_count_1 = v_count_1 + 1;
						}
					}
				} else if (v_count_1 le v_max_ar_1) {
					v_array_1_res[ArrayLen(v_array_1_res)+1] = v_array_1[v_count_1];
					v_array_2_res[ArrayLen(v_array_2_res)+1] = "";
					v_array_diff[ArrayLen(v_array_diff)+1] = 'direita';
					v_count_1 = v_count_1 + 1;
				} else {
					v_array_1_res[ArrayLen(v_array_1_res)+1] = "";
					v_array_2_res[ArrayLen(v_array_2_res)+1] = v_array_2[v_count_2];
					v_array_diff[ArrayLen(v_array_diff)+1] = 'esquerda';
					v_count_2 = v_count_2 + 1;
				}
			}
			retorno.array_1 = v_array_1_res;
			retorno.array_2 = v_array_2_res;
			retorno.diferencas = v_array_diff;
			retorno.merge_1 = ArrayToList(v_array_1_res,chr(13)&chr(10));
			retorno.merge_2 = ArrayToList(v_array_2_res,chr(13)&chr(10));
			
		</cfscript>
		<cfreturn retorno>
	</cffunction>
    
	<!--- 
	-- PROPSITO 
	-- Retorna a comparao entre 2 versoes do arquivo
	-- CRISTOFER  24/07/2007
	--->		
	<cffunction name="merge_arquivo" access="remote" returntype="struct" output="true">
    	<cfargument name="diretorio" required="yes">
    	<cfargument name="url" required="yes">
    	<cfargument name="versao_1" required="yes">
    	<cfargument name="versao_2" required="yes">
    	<cfscript>
			v_versao_1 = this.get_arquivo_conteudo_versao(	diretorio   = arguments.diretorio,
															url			= arguments.url,
															versao		= arguments.versao_1);
			v_versao_2 = this.get_arquivo_conteudo_versao(	diretorio   = arguments.diretorio,
															url			= arguments.url,
															versao		= arguments.versao_2);
			v_merge = this.merge_text(	text_1 = v_versao_1,
										text_2 = v_versao_2);
		</cfscript>
		<cfreturn v_merge>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as atualizacoes
	-- CRISTOFER  30/08/2007
	--->		
	<cffunction name="get_atualizacao" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select atualizacao_id,
                   titulo,
                   usuario,
                   descricao,
                   data,
                   data_sincronizacao,
                   date_insert,
                   user_insert,
                   date_update,
                   user_update,
                   site
              from site.v$atualizacao
             order by data
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os arquivos atualizados 
	-- CRISTOFER  30/08/2007
	--->		
	<cffunction name="get_atualizacao_arquivo_versao" access="remote" returntype="query" output="true">
    	<cfargument name="atualizacao_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select a.atualizacao_id,
                   a.titulo,
                   arv.usuario,
                   atv.arquivo_id,
                   atv.versao,
                   replace(arq.diretorio,'/var/www/html/sincronizador','') diretorio,
                   arq.nome,
                   arv.assinatura,
                   to_char(arv.data_atualizacao,'dd/mm/yyyy hh24:mi:ss') data_atualizacao,
                   site.pkg_atualizacao.fnc_converte_tamanho(length(arv.conteudo)) tamanho,
                   case
                      when arq.versao = arv.versao then 1
                      else 0
                   end versao_atual,
                   arv.data_atualizacao data_ultima_versao
              from site.v$atualizacao a
             inner join site.v$atualizacao_arquivo_versao atv
                     on atv.atualizacao_id = a.atualizacao_id
             inner join site.v$arquivo arq
                     on arq.arquivo_id = atv.arquivo_id
             inner join site.v$arquivo_versao arv
                     on arv.arquivo_id = atv.arquivo_id         
                    and arv.versao     = atv.versao
             left join site.v$arquivo_versao arv1
                     on arv1.arquivo_id = arq.arquivo_id         
                    and arv1.versao     = arq.versao
             where 1=1
             <cfif len(trim(arguments.atualizacao_id))>
               and a.atualizacao_id in (#arguments.atualizacao_id#)
             </cfif>
             order by diretorio,nome
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	<!--- 
	-- PROPSITO 
	-- Busca JOBS rodando no servidor
	-- GUTO  30/08/2007
	--->	
    <cffunction name="getJobs" displayname="Tarefas" access="remote" returntype="Query" output="true">	  
        <cfargument name="dsn_menu" required="yes"/>
        <cfargument name="usuario" required="yes"/>
        <cfargument name="senha" required="yes"/>
        <cfquery name="qr" datasource="#arguments.dsn_menu#" username="#Decrypt(arguments.usuario,arguments.dsn_menu)#" password="#Decrypt(arguments.senha,arguments.dsn_menu)#" blockfactor="100">
            select j.job, j.schema_user, 
                   j.last_date, j.this_date,
                   j.next_date, j.total_time,
                   j.broken, j.interval,
                   j.failures, j.what
              from dba_jobs j
             where 1=1
            order by j.schema_user, j.next_date
        </cfquery>  
        <cfreturn qr />
    </cffunction>
            
</cfcomponent>