<!-- KM&M Componentes -->
<cfcomponent displayname="Consultas da previsao do tempo" extends="_transportes.funcoes.cfc_init">
	<!---
	-- PROPSITO
	-- Busca a previsao do tempo no municipio por webservices na kmm
	-- CRISTOFER 08/03/2006
	--->	
	<cffunction name="get_previsao_municipio" access="remote" returntype="query" output="yes">
		<cfargument name="data" required="no" default="">
		<cfargument name="municipio" required="yes">
		<cfargument name="uf" required="yes">
		<cfif len(trim(arguments.data))>
			<cfset arguments.parse_data = CreateDate(ListGetAt(arguments.data, 3, '/'), ListGetAt(arguments.data, 2, '/'), ListGetAt(arguments.data, 1, '/'))>	
			<cfset regs = 1>
		<cfelse>
			<cfset regs = 4>
		</cfif>
		<cfquery name="qr_previsao" datasource="#session.dsn#" username="PUBLICO" password="kmm2006">
			select url_previsao
			  from oper.v$previsao_tempo_municipio t
			 where upper(kss.pkg_string.fnc_string_clean(t.municipio)) = upper(kss.pkg_string.fnc_string_clean('#arguments.municipio#'))
			   and sigla_uf = upper('#arguments.UF#')
			 <cfif len(trim(arguments.data))>
			   and trunc(data) = to_date('#arguments.DATA#', 'dd/mm/yyyy')
			 <cfelse>
			   and trunc(data) between trunc(sysdate) and trunc(sysdate)+3
			 </cfif>
			   and date_update > sysdate - (1/24)*5
		</cfquery>		
		<cfif (not (qr_previsao.recordCount ge regs)) and ((not len(trim(arguments.data))) or (DateDiff('d', arguments.parse_data, now()) le 3 and DateDiff('d', arguments.parse_data, now()) gt -1))>
			<cfscript>
				conn = CreateObject("webservice", "http://portal.kmm.com.br/_webservices/cfc_previsao.cfc?wsdl");
			// Similar ao webservice, porem com acesso direto (para tratamento de erros).
			//	conn = CreateObject("component", "_webservices.cfc_previsao");
				qrPrevisaoMunic = conn.get_previsao_municipio(data = arguments.data,
				                                              uf = arguments.uf,
															  municipio = arguments.municipio);
			</cfscript>
			<cfoutput query="qrPrevisaoMunic">
				<cfscript>
				this.ins_previsao(	municipio = arguments.municipio,
									uf = arguments.uf,
									data = DateFormat(qrPrevisaoMunic.data,'dd/mm/yyyy'),
									url_previsao = qrPrevisaoMunic.url_previsao,
									maxima = qrPrevisaoMunic.maxima,
									minima = qrPrevisaoMunic.minima);
				</cfscript>
			</cfoutput>
		</cfif>
		<cfquery name="qr_result" datasource="#session.dsn#" username="PUBLICO" password="kmm2006">
			select distinct initcap(kss.pkg_string.fnc_string_clean(t.municipio)) as municipio,
				   t.sigla_uf,
				   trunc(t.data) as data,
				   t.url_previsao,
				   t.maxima,
				   t.minima,
				   p.descricao,
				   p.ordem
			  from oper.v$previsao_tempo_municipio t		
             inner join oper.v$previsao_tempo p
               on p.url = t.url_previsao	
			 where upper(kss.pkg_string.fnc_string_clean(t.municipio)) = upper(kss.pkg_string.fnc_string_clean('#arguments.municipio#'))
			   and sigla_uf = upper('#arguments.UF#')
			 <cfif len(trim(arguments.data))>
			   and data = to_date('#arguments.DATA#', 'dd/mm/yyyy')
			 <cfelse>
			   and trunc(data) between trunc(sysdate) and trunc(sysdate)+3
			 </cfif>
			 order by data
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Busca a previsao do tempo no municipio por webservices na kmm
	-- CRISTOFER 08/03/2006
	--->	
	<cffunction name="get_previsao_tempo" access="remote" returntype="query" output="true">	
		<cfargument name="com_imagem" required="no" default="0">
		<cfargument name="tipo" required="no" default=""><!--- 0 - Pequena, 1 - Grande, "" - Ambas--->
		<cfargument name="url" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="PUBLICO" password="kmm2006">
			select url,
				<cfif (not len(trim(arguments.tipo))) or arguments.tipo eq 1>
				   imagem, 
				</cfif>
				<cfif (not len(trim(arguments.tipo))) or arguments.tipo eq 0>
				   mini, 
				</cfif>
				   descricao, 
				   ordem 
			  from oper.v$previsao_tempo
			 where 1=1
			 <cfif arguments.com_imagem eq 1>
			   and imagem is not null
			 </cfif>
			   and upper(url) = upper('#arguments.url#')
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere uma previsao do tempo para o municipio
	-- cristofer 10/03/2006 16:31:33 - CRIADO
	--->
	<cffunction name='ins_previsao' displayname='' access='package' returntype='Struct' output='yes'>;
		<cfargument name='MUNICIPIO' required='yes'>
		<cfargument name='UF' required='yes'>
		<cfargument name='DATA' required='yes'>
		<cfargument name='URL_PREVISAO' required='yes'>
		<cfargument name='MAXIMA' required='yes'>
		<cfargument name='MINIMA' required='yes'>
		<cfstoredproc procedure='oper.pkg_previsao_tempo.prc_ins_previsao_tempo_munic' datasource='#session.dsn#' username='PUBLICO' password='kmm2006'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MUNICIPIO'  value='#UCase(arguments.MUNICIPIO)#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SIGLA_UF'  value='#UCase(arguments.UF)#' >
			<cfprocparam type='IN' cfsqltype='cf_sql_date' dbvarname='P_DATA'  value='#DateFormat(arguments.DATA, "dd/mm/yyyy")#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_URL_PREVISAO'  value='#arguments.URL_PREVISAO#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_MAXIMA'  value='#arguments.MAXIMA#'  null='#iif(len(trim(arguments.MAXIMA)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_MINIMA'  value='#arguments.MINIMA#'  null='#iif(len(trim(arguments.MINIMA)), de('no'), de('yes'))#'>
		</cfstoredproc>
		<cfreturn StructNew()/>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca cidades
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  24/03/2006
	--->		
	<cffunction name="get_cidade" access="remote" returntype="query" output="false">
		<cfargument name="municipio_id" required="no" />
		<cfargument name="municipio" required="no" />
		<cfargument name="pais_id" required="no" />
		<cfargument name="uf_id" required="no" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="PUBLICO" password="kmm2006">
			select municipio_id,
				   municipio,
--				   round(oper.pkg_coord_geografica.fnc_graus2decimais(latitude),5) latitude,
--				   round(oper.pkg_coord_geografica.fnc_graus2decimais(longitude),5) longitude,
				   p.pais_id,
				   uf_id,
				   altitude,
				   cep,
				   kss.pkg_string.fnc_string_clean(municipio) as municipio_clean,
				   p.descricao as pais,
				   cep.fnc_cidade_completa(municipio_id) as descricao
			  from cep.municipio m
			 inner join cep.pais p 
			 		 on p.pais_id = m.pais_id
			 where 1 = 1
		    <cfif IsDefined("arguments.municipio") and Len(Trim(arguments.municipio))>
			   and upper(kss.pkg_string.fnc_string_clean(municipio)) like upper('%#arguments.municipio#%')
			</cfif>
		    <cfif IsDefined("arguments.pais_id") and Len(Trim(arguments.pais_id))>
			   and p.pais_id = #arguments.pais_id#
			</cfif>
		    <cfif IsDefined("arguments.uf_id") and Len(Trim(arguments.uf_id))>
			   and uf_id = '#arguments.uf_id#'
			</cfif>
		    <cfif IsDefined("arguments.municipio_id") and Len(Trim(arguments.municipio_id))>
			   and municipio_id = #arguments.municipio_id#
			</cfif>				 
			 order by municipio	
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>	

</cfcomponent>