<!-- KM&M Componentes -->
<cfcomponent displayname="Consultas da rea de postos" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO 
	-- Autentica o abastecimento conforme regras do banco.
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  12/01/2004
	--->
	<cffunction name="autentica_abastecimento" displayname="Autentica o abastecimento conforme regras do banco." access="remote" returntype="struct">
		<cfargument name="data_hora" required="yes">
		<cfargument name="placa" required="yes">
		<cfargument name="produto" required="yes">
		<cfargument name="quantidade" required="yes">
		<cfargument name="km" required="yes">
		<cfargument name="cod_pessoa" required="yes">
		<cftry>
			<cftransaction action="begin">
			<cfquery datasource="#session.dsn#" name="qrDataLimite" username="#session.usuario#" password="#session.senha#">
				SELECT sysdate - oper.pkg_global.fnc_get_parametro(8,'ABASTECIMENTO') as data_limite,
						to_date('#arguments.DATA_HORA#','dd/mm/yyyy hh24:mi') as data
				  FROM dual
			</cfquery>
			<cfquery datasource="#session.dsn#" name="qrCod_Pessoa_Motorista" username="#session.usuario#" password="#session.senha#">
				SELECT oper.pkg_operacional.fnc_motorista_veiculo('#arguments.PLACA#','#LSDateFormat(arguments.data_hora,'dd/mm/yyyy')#') as cod_pessoa_motorista
				  FROM dual
			</cfquery>
		
			<cfif DateCompare(qrDataLimite.data,qrDataLimite.data_limite) eq -1>
				<cfset retorno.mensagem = "Data deve ser superior a data limite para lanamento que : "& DateFormat(qrDataLimite.data_limite,'dd/mm/yyyy')& " " &TimeFormat(qrDataLimite.data_limite,'HH:mm')& DateFormat(qrDataLimite.data,'dd/mm/yyyy')& " " &TimeFormat(qrDataLimite.data,'HH:mm')>
				<cfthrow errorcode="20000" detail="Data deve ser superior a data limite para lanamento." >
			<cfelse>
				<cfset retorno.mensagem = "OK">
			</cfif> 
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_abastecimento.prc_autentica_abastecimento" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa" cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_motorista" cfsqltype="cf_sql_integer" value="#qrCod_Pessoa_Motorista.cod_pessoa_motorista#">
				<cfprocparam type="in" dbvarname="P_PLACA" cfsqltype="cf_sql_varchar" value="#arguments.PLACA#">
				<cfprocparam type="inout" dbvarname="P_KM" cfsqltype="cf_sql_integer" value="#arguments.KM#" variable="retorno.km">
				<cfprocparam type="in" dbvarname="P_PRODUTO_ID" cfsqltype="cf_sql_integer" value="#arguments.PRODUTO#">
				<cfprocparam type="in" dbvarname="P_QUANTIDADE" cfsqltype="cf_sql_numeric" scale="5" value="#arguments.QUANTIDADE#">
				<cfprocparam type="in" dbvarname="p_data_hora" cfsqltype="cf_sql_varchar" value="#arguments.data_hora#">
				<cfprocparam type="in" dbvarname="P_ENCHEU" cfsqltype="cf_sql_numeric" scale="5" value="0">
				<cfprocparam type="in" dbvarname="P_SUPLEMENTAR" cfsqltype="cf_sql_numeric" scale="5" value="0">
				<cfprocparam type="out" dbvarname="P_CONTROLE_ID" cfsqltype="cf_sql_integer" variable="retorno.CONTROLE_ID">					
			</cfstoredproc>
			<cfset retorno.erro = false>						
			</cftransaction>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cftransaction action="rollback" />
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>
	<!--- 
	-- PROPSITO 
	-- Busca Contas a receber do posto
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  11/01/2004
	--->
	<cffunction name="get_contas_receber" displayname="Busca Contas a receber do posto" access="remote" returntype="query">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" 	required="no" default="">
		<cfargument name="cod_pessoa" 	required="yes">
		<cfquery datasource="#session.dsn#" name="qr_contas_receber" username="#session.usuario#" password="#session.senha#">
			SELECT /* first_rows */ cp.num_docto,
				   cp.data_emissao,
				   cp.data_vencto,
				   cp.data_previsao,
				   cp.valor_docto,
				   fd.descricao as historico
			  from finan.v$finan_contas_pagar cp,
				   oper.v$ccorrente           cc,
				   finan.v$finan_documento    fd
			 where cp.contas_pagar_id not in
				   (select cpm.contas_pagar_id
					  FROM finan.v$finan_contas_pagar_amort cpm
					 WHERE cpm.autenticado = 1
					   and cp.contas_pagar_id = cpm.contas_pagar_id)
			   and cp.cc_favorecido = cc.cod_conta
			   and cp.docto_id = fd.docto_id
			   and cc.cod_pessoa = #arguments.cod_pessoa#
			   <cfif len(trim(arguments.data_inicial))>
			   and trunc(cp.data_vencto) >= '#arguments.data_inicial#'
			   </cfif>
			   <cfif len(trim(arguments.data_final))>
			   and trunc(cp.data_vencto) <= '#arguments.data_final#'
			   </cfif>
			union
			SELECT /*+ first_rows */ cp.num_docto,
				   cp.data_emissao,
				   cp.data_vencto,
				   cp.data_previsao,
				   cp.valor_docto,
				   fd.descricao as historico
			  from finan.v$finan_contas_pagar cp
			 inner join oper.v$contrato_transp_pagar ctp 
					 on cp.contas_pagar_id = ctp.contas_pagar_id
					and cp.situacao = 0
			 inner join finan.v$finan_documento fd 
					 on cp.docto_id = fd.docto_id
			 where ctp.cod_pessoa_recebimento = #arguments.cod_pessoa#
			 order by 3
		</cfquery>
		<cfreturn qr_contas_receber>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca Contas recebidas pelo posto
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  11/01/2004
	--->
	<cffunction name="get_contas_recebidas" displayname="Busca Contas recebidas pelo posto" access="remote" returntype="query">
		<cfargument name="data_inicial" required="yes">
		<cfargument name="data_final" required="yes">
		<cfargument name="cod_pessoa" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_contas_recebidas" username="#session.usuario#" password="#session.senha#">
        SELECT /*+ORDERED*/ 
               cp.num_docto, ca.num_recibo, cp.data_emissao, cp.data_vencto,               
               ca.valor_amortizacao, ca.data_amortizacao, descricao as historico        
          FROM oper.v$ccorrente cc
			inner join finan.v$finan_contas_pagar cp                                         
					  on cp.cc_favorecido = cc.cod_conta         
			inner join finan.v$finan_contas_pagar_amort ca  
					  on cp.contas_pagar_id = ca.contas_pagar_id         
         inner join finan.v$finan_documento fd
                 on cp.docto_id = fd.docto_id 
			   WHERE ca.autenticado = 1         
				 and cc.cod_pessoa = #arguments.cod_pessoa#
			   <cfif len(trim(arguments.data_inicial))>
				 and trunc(ca.data_amortizacao) >= '#arguments.data_inicial#'
			   </cfif>
			   <cfif len(trim(arguments.data_final))>
				 and trunc(ca.data_amortizacao) <= '#arguments.data_final#'
			   </cfif>				 
			  UNION 
			  SELECT /*+ORDERED*/ cp.num_docto, ca.num_recibo, cp.data_emissao, cp.data_vencto,               
					 ca.valor_amortizacao, ca.data_amortizacao, fd.descricao as historico        
				from oper.v$contrato_transp_pagar ctp
			   inner join finan.v$finan_contas_pagar cp
					   on cp.contas_pagar_id = ctp.contas_pagar_id 
			   inner join finan.v$finan_contas_pagar_amort ca
					   on cp.contas_pagar_id = ca.contas_pagar_id         
					  and ca.autenticado = 1         
			   inner join finan.v$finan_documento fd   
					   on cp.docto_id = fd.docto_id    
			   where ctp.cod_pessoa_recebimento = #arguments.cod_pessoa#
			   <cfif len(trim(arguments.data_inicial))>
				 and trunc(ca.data_amortizacao) >= '#arguments.data_inicial#'
			   </cfif>
			   <cfif len(trim(arguments.data_final))>
				 and trunc(ca.data_amortizacao) <= '#arguments.data_final#'
			   </cfif>				   
			   order by 6 desc
		</cfquery>
		<cfreturn qr_contas_recebidas>
	</cffunction>			 
	
	<!--- 
	-- PROPSITO 
	-- Busca cupons
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  13/01/2004
	--->
	<cffunction name="get_cupons" displayname="Busca cupons" output="true" access="remote" returntype="query">
		<cfargument name="data_inicial" required="no">
		<cfargument name="data_final" required="no">
		<cfargument name="situacao" required="no">
		<cfargument name="ultimos_lancados" required="no">
		<cfargument name="cod_pessoa" required="yes">
		<cfif isDefined("arguments.ultimos_lancados")>
			<cfquery datasource="#session.dsn#" name="qr_cupons" username="#session.usuario#" password="#session.senha#">
				SELECT /*+LEADING(PL)*/
				       pp.descricao as produto,                           
					   pl.controle_id, pl.num_cupom_fiscal, 
					   (substr(pl.placa_veiculo,1,3)||'-'||substr(pl.placa_veiculo,4,7)) as placa_veiculo,          
					   pl.km_veiculo, trunc(pl.data_hora) as data, to_char(pl.data_hora,'HH24:mi') as hora,          
					   pl.quantidade, pl.valor_unitario, pl.valor_total,                           
					   u.unidade, pp.cod_unidade, pl.aliquota_icms      
				  FROM (select pl.cod_pessoa_posto, pl.num_nota_id, pl.produto_id, pl.controle_id, 
							   pl.num_cupom_fiscal, pl.placa as placa_veiculo,          
							   pl.km as km_veiculo, pl.data_hora,          
							   pl.quantidade, pl.valor_unitario, pl.valor_total, 
							   pl.aliquota_icms, pl.data_confirmacao 
						  from oper.v$abastecimento pl 
						 where pl.data_confirmacao is not null
						   and pl.cod_pessoa_posto = #arguments.cod_pessoa#
						   and pl.num_nota_id is null
						 order by data_hora desc) pl, 
						oper.v$unidade_medida u, 
						oper.v$posto_produto pp     
				  WHERE pl.produto_id = pp.produto_id      
					and u.cod_unidade = pp.cod_unidade
					and pl.produto_id = pp.produto_id
			</cfquery>
		<cfelse>		
			<cfquery datasource="#session.dsn#" name="qr_cupons" username="#session.usuario#" password="#session.senha#">
					SELECT /*+INDEX(PL IDX_ABST_02)*/
						   (substr(pl.placa,1,3)||'-'||substr(pl.placa,4,7)) as placa_veiculo, 
						   pl.km as km_veiculo, trunc(pl.data_hora) as data, pl.num_cupom_fiscal,         
						   to_char(pl.data_hora,'HH24:mi') as hora,         
						   pl.quantidade, pl.valor_unitario, pl.valor_total, <!---pl.data_envio, --->
						   p.descricao as produto, pp.cod_unidade, pp.produto_id
					   FROM oper.v$abastecimento pl 
                  left join oper.v$produto p
						 on p.produto_id = pl.produto_id
				  left join oper.v$posto_produto pp
						 on pp.produto_id = pl.produto_id
				  	  WHERE 1=1
				 	    and pl.cod_pessoa_posto = #arguments.cod_pessoa#
						and pl.data_confirmacao is not null
			   		    and trunc(pl.data_hora) between '#arguments.DATA_INICIAL#' and '#arguments.DATA_FINAL#'
							<cfif arguments.situacao eq 0>
								and pl.num_nota_id is null  
							</cfif>
					   ORDER BY pl.num_cupom_fiscal
			</cfquery>
		</cfif>
		<cfreturn qr_cupons>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca cupons vinculados notas fiscais
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  17/01/2006
	--->
	<cffunction name="get_cupons_notas" displayname="Busca cupons vinculados notas fiscais" access="remote" returntype="query">
		<cfargument name="num_nota_remessa" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_cupons" username="#session.usuario#" password="#session.senha#">
			 select pl.num_cupom_fiscal, 
					 p.descricao as produto, 
					 pl.placa as placa_veiculo,
					 pl.km as km_veiculo, 
					 pl.data_hora, 
					 pl.quantidade, 
					 pl.valor_unitario,
					 pl.valor_total
				from oper.v$abastecimento pl
			 inner join oper.v$produto p 
					 on pl.produto_id = p.produto_id
			 where pl.num_nota_id =#arguments.num_nota_remessa#
		</cfquery>
	<cfreturn qr_cupons>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca dados do posto
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  12/01/2006
	--->
	<cffunction name="get_dados_posto" displayname="Busca dados do posto" access="remote" returntype="query">
		<cfargument name="cod_pessoa" required="yes">
		<cfquery name="qrDadosPosto" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct p.cupom_fiscal, 
				   pj.cod_pessoa, 
				   nvl(pj.cnpj_basico,0) as posto, 
				   pj.uf
			  from oper.pessoa_juridica pj   
			  left outer join oper.v$posto p 
				on pj.cod_pessoa = p.cod_pessoa
			 where p.cod_pessoa = #arguments.cod_pessoa#
		</cfquery>	
		<cfreturn qrDadosPosto>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca data limite para lanamentos
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  12/01/2004
	--->
	<cffunction name="get_data_limite" displayname="Busca data limite para lanamentos" access="remote" returntype="string">
		<cfquery datasource="#session.dsn#" name="qr_data_limite" username="#session.usuario#" password="#session.senha#">
			SELECT sysdate - oper.pkg_global.fnc_get_parametro(8,'ABASTECIMENTO') as data_limite
			  FROM dual
		</cfquery>
		<cfreturn qr_data_limite.data_limite>
	</cffunction>
		
	<!--- 
	-- PROPSITO 
	-- Busca contratos confirmados nos postos
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  10/01/2004
	--->
	<cffunction name="get_doctos_enviados_posto" displayname="Busca contratos confirmados nos postos" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" 	required="yes">
		<cfargument name="tipo" 		required="no" default="0" hint="1 - Pagas, 0 - No Pagas, 2 - Todas" >
		<cfargument name="endereco" 	required="no">
		<cfargument name="data_inicial" required="no">
		<cfargument name="data_final" 	required="no">
		<cfquery name="qr_doctos" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select c.num_formulario, c.num_romaneio, trunc(ctp.date_insert) as data_lancamento, 
				   c.data_emissao, cp.data_vencto, ctp.adiantamento + ctp.saldo as valor,
				   decode(ctp.saldo,0,'Adiantamento','Saldo') as tipo, 
				   decode(ctp.saldo,0,'A','S') as tipo_id, 
				   cp.num_docto, cp.parc_docto,
				   decode(cp.situacao,0,'Em Aberto','Paga') as situacao,
				   ctp.lancto_id, ctp.num_recibo, ctp.saldo, ctp.adiantamento, ctp.contas_pagar_id,
				   cp.valor_docto
			  from oper.v$contrato_transp c
			 inner join oper.v$contrato_transp_pagar ctp
				on c.lancto_id = ctp.lancto_id
			 inner join finan.v$finan_contas_pagar cp
				on ctp.contas_pagar_id = cp.contas_pagar_id
			 where ctp.cod_pessoa_recebimento = #arguments.cod_pessoa#
			 <cfif arguments.tipo neq 2>
			   and cp.situacao = #arguments.tipo#
			 </cfif>
			 <cfif isDefined("arguments.data_inicial") and Len(Trim(arguments.data_inicial)) and isDefined("arguments.data_final") and Len(Trim(arguments.data_final))>
			   and trunc(ctp.date_insert) between '#arguments.data_inicial#' and '#arguments.data_final#'
			 </cfif>
			<cfif not isDefined("arguments.endereco")>
				order by trunc(ctp.date_insert), cp.num_docto, cp.parc_docto
			<cfelse>
				order by a.cep
			</cfif>
		</cfquery>		
		<cfreturn qr_doctos>							 
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os itens da nota para o faturamento dos cupons
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  16/02/2006
	--->
	<cffunction name="get_itens_nota" displayname="Busca notas fiscais" access="remote" returntype="query">
		<cfargument name="data_inicial" required="yes">
		<cfargument name="data_final" required="yes">
		<cfargument name="situacao" required="yes">
		<cfargument name="cod_pessoa" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_notas" username="#session.usuario#" password="#session.senha#">
			 select /*+INDEX(PL IDX_ABST_02)*/
			 		sum(pl.quantidade) as quantidade,
				    avg(pl.valor_unitario) as valor_unitario,
				    sum(pl.valor_total) as valor_total,
				    pl.produto_id, p.cod_unidade
               from oper.v$abastecimento pl
			  inner join oper.v$produto p
					  on p.produto_id = pl.produto_id
			  where pl.cod_pessoa_posto = #arguments.cod_pessoa#
			    and trunc(pl.data_hora) between '#arguments.DATA_INICIAL#' and '#arguments.DATA_FINAL#'
				and pl.data_confirmacao is not null
			  group by pl.produto_id, p.cod_unidade
		
		</cfquery>
		<cfreturn qr_notas>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os recados do mural
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  13/01/2004
	--->	
	<cffunction name="get_mural_recados" access="remote" returntype="query" output="true">
		<cfargument name="tipo_recado_id" required="no" default="">		
		<cfargument name="cod_grupo" required="no" default="">		
		<cfquery datasource="#session.dsn#" name="qr_mural" username="#session.usuario#" password="#session.senha#">
			SELECT id, titulo, mensagem  
			  FROM oper.mural_internet 
			 WHERE 1=1
			  <cfif Len(Trim(arguments.tipo_recado_id))>
			   and tipo_recado_id = #arguments.tipo_recado_id#
			   and cod_grupo is null
			  </cfif> 
			  <cfif Len(Trim(arguments.cod_grupo))>
			   and cod_grupo = '#arguments.cod_grupo#' 
			  </cfif> 
			   and trunc(sysdate) <= trunc(data_termino)
			  order by id desc 
		</cfquery>	
		<cfreturn qr_mural>
	</cffunction>	
		
	<!--- 
	-- PROPSITO 
	-- Busca dados da nota fiscal
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  13/01/2004
	--->
	<cffunction name="get_notas" displayname="Busca notas fiscais" access="remote" returntype="query">
		<cfargument name="data_inicial" required="yes">
		<cfargument name="data_final" required="yes">
		<cfargument name="situacao" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_notas" username="#session.usuario#" password="#session.senha#">
			SELECT nfr.num_nota_remessa,nfr.num_nota_fiscal, nfr.data_emissao, 
				   nfr.valor_total_nota, nfr.data_vencto,
				   case nfr.situacao 
					 when 0 then 'Em Aberto'
					 when 1 then 'Em Aberto'
					 when 2 then 'Faturadas'
					 when 3 then 'Faturadas'
					 when 4 then 'Pagas'
				   end as status
			  FROM fiscal.v$nf_terceiro nfr inner join
				   oper.v$kss_controle c on
				   c.cnpj_basico = nfr.cnpj_basico_emitente and
				   c.cnpj_ordem = nfr.cnpj_ordem_emitente
			 WHERE trunc(nfr.data_emissao) between '#arguments.DATA_INICIAL#' and '#arguments.DATA_FINAL#'
			   and nfr.situacao in (#arguments.situacao#)  
			   order by case nfr.situacao 
					 when 0 then 'Em Aberto'
					 when 1 then 'Em Aberto'
					 when 2 then 'Faturadas'
					 when 3 then 'Faturadas'
					 when 4 then 'Pagas'
				   end, nfr.data_emissao
		</cfquery>
		<cfreturn qr_notas>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca dados da nota fiscal
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  13/01/2004
	--->	
	<cffunction name="get_nota" displayname="Busca dados da nota fiscal" access="remote" returntype="query">
		<cfargument name="num_nota_remessa" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_nota" username="#session.usuario#" password="#session.senha#">
			select num_nota_id as num_nota_remessa, num_nota_fiscal, data_emissao, 
				   calc_valor_icms as valor_icms, calc_valor_total_nota as valor_total_icms, calc_base_icms as base_calculo_icms
			  from fiscal.v$nf_terceiro
			 where num_nota_id = #arguments.num_nota_remessa#
		</cfquery>
		<cfreturn qr_nota>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca itens da nota fiscal
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  13/01/2004
	--->	
	<cffunction name="get_nota_itens" displayname="Busca itens da nota fiscal" access="remote" returntype="query">
		<cfargument name="num_nota_remessa" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_nota" username="#session.usuario#" password="#session.senha#">
				select ni.descricao, u.unidade, ni.qtde_volume as quantidade, round(valor_unitario,3) as valor_unitario, valor_total
				  from fiscal.v$nf_terceiro_it nf
				 inner join fiscal.v$nf_item ni
						 on ni.NUM_NOTA_IT_ID = nf.NUM_NOTA_IT_ID
				 inner join oper.v$unidade_medida u 
						 on ni.cod_unidade = u.cod_unidade
				 where nf.num_nota_id = #arguments.num_nota_remessa#
		</cfquery>
		<cfreturn qr_nota>
	</cffunction>			 
	
	<!--- 
	-- PROPSITO 
	-- Busca produtos autorizados para compra nos postos
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  12/01/2004
	--->	
	<cffunction name="get_produtos" displayname="Busca produtos autorizados para compra nos postos" access="remote" returntype="query">
		<cfargument name="data_hora"	required="yes">
		<cfargument name="cod_pessoa" 	required="yes">
		<cfquery name="qr_produtos" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			SELECT php.produto_id, substr(p.descricao,1,20) as produto, 
				   p.descricao as prod_status, 
				   u.unidade,
				   u.cod_unidade 
			  from oper.v$posto_historico_produto ph, 
				   oper.v$posto_historico_produto_prec php, 
				   oper.v$unidade_medida u, 
				   oper.v$posto_produto p  
			 where php.cod_pessoa = #arguments.cod_pessoa#
			   and ph.cod_pessoa = php.cod_pessoa
			   and ph.produto_id = php.produto_id               
			   and ph.produto_id = p.produto_id               
			   and php.data_vigencia = ph.data_vigencia               
			   and ph.autorizado = 1               
			   and u.cod_unidade = p.cod_unidade 
			   and p.servico = 0
			   and php.data_vigencia = (select max(ph2.data_vigencia)  
										  FROM oper.v$posto_historico_produto ph2  
										 WHERE ph2.cod_pessoa = php.cod_pessoa
										   and ph2.data_vigencia <= to_date('#arguments.DATA_HORA#','dd/mm/yyyy hh24:mi')
										   and ph2.produto_id = php.produto_id )               
		</cfquery>
		<cfreturn qr_produtos>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os produtos oferecidos pelo posto
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  10/01/2004
	--->		
	<cffunction name="get_produtos_posto" displayname="Busca os produtos oferecidos pelo posto" access="remote" returntype="query">
		<cfargument name="produto_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			SELECT ppa.produto_id, pp.descricao,                  
				   ppa.preco, ppa.icms, sysdate as data_hoje,          
				   ppa.permite_reajuste, decode(ppa.liberado,1,'Sim','No') as liberado,
				   ppa.cod_pessoa
			  FROM oper.v$kss_controle c,   
				   oper.posto_produto_autorizado ppa,         
				   oper.v$posto_produto pp  
			 WHERE c.cod_pessoa = ppa.cod_pessoa
			   and ppa.produto_id = pp.produto_id           
			   and pp.servico = 0
			   <cfif len(trim(arguments.produto_id))>
			   and ppa.produto_id = #arguments.produto_id#
			   </cfif>
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca vales trocados no dia
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  10/01/2004
	--->		
	<cffunction name="get_vales" displayname="Busca vales trocados no dia" access="remote" returntype="query">
		<cfquery name="qr_vales" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			SELECT v.num_vale, v.valor, v.date_update as data_envio
			  FROM oper.v$vale v, oper.v$kss_controle c  
			 WHERE situacao_id = 4               
			   AND trunc(v.date_update) = trunc(sysdate)          
			   AND v.cod_pessoa_troca = c.cod_pessoa    
			   and v.user_update = c.usuario 
			 ORDER BY data_envio desc
		</cfquery>
		<cfreturn qr_vales>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Retorna valor praticado no estado
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  12/01/2004
	--->		
	<cffunction name="get_valor_pmpf" displayname="Retorna valor praticado no estado" access="remote" returntype="numeric" output="true">
		<cfargument name="uf" required="yes">
		<cfargument name="data" required="yes">
		<cfargument name="valor_unitario" required="yes">
		<cfquery name="qr_valor_praticado" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select oper.pkg_posto.fnc_consulta_valor_pmpf('#arguments.uf#', to_date('#arguments.data#','dd/mm/yyyy hh24:mi'), '#arguments.valor_unitario#') as valor_praticado
			  from dual	
		</cfquery>
		<cfreturn NumberFormat(qr_valor_praticado.valor_praticado, '0.000')>		
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Verifica se o vale est liberado para troca e pagamento para o posto
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  10/01/2004
	--->
	<cffunction name="verifica_vales" displayname="Verifica se o vale est liberado para troca e pagamento para o posto" access="remote" returntype="query">
		<cfargument name="num_vale" required="yes">
		<cfargument name="cod_pessoa" required="yes">
		<cfquery name="qr_vale" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			SELECT num_vale, valor, data_entrega as data_envio  
			  FROM oper.v$vale  
			 WHERE situacao_id = 3
			   and cod_pessoa_troca = #arguments.COD_PESSOA#
			   and num_vale = #arguments.NUM_VALE#
		</cfquery>
		<cfreturn qr_vale>		
	</cffunction>
</cfcomponent>