<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO 
	-- Busca o valor das celulas da planilha
	-- CRISTOFER  12/06/2006
	--->		
	<cffunction name="get_valores_planilha" access="remote" returntype="query" output="true">
		<cfargument name='PLANILHA_ID' required='yes'>
		<cfargument name='SHEET_ID' required='no' default="">
		<cfargument name='LINHA' required='no' default=''>
		<cfargument name='COLUNA' required='no' default=''>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select kss.pkg_planilha.fnc_get_valor(pc.planilha_id,pc.sheet_id,pc.linha,pc.coluna) as valor,
				   pc.planilha_id,
				   pc.linha,
				   pc.coluna,
				   pc.formula,
				   ps.titulo as sheet,
				   ps.sheet_id,
				   ps.ordem
			  from kss.v$planilha_sheet ps
			  left join kss.v$planilha_celula pc
			         on ps.sheet_id = pc.sheet_id
					and ps.planilha_id = pc.planilha_id
			 where ps.planilha_id = #arguments.planilha_id#
			  <cfif len(trim(arguments.sheet_id))>
			   and pc.sheet_id = #arguments.sheet_id#
			  </cfif>
			  <cfif len(trim(arguments.linha))>
			   and pc.linha = #arguments.linha#
			  </cfif>
			  <cfif len(trim(arguments.coluna))>
			   and pc.coluna = '#arguments.coluna#'
			  </cfif>
			  order by ps.ordem, pc.linha, pc.coluna
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera o valor de uma celula da planilha
	-- cristofer 13/06/2006 13:30:30 - CRIADO
	--->
	<cffunction name='ins_planilha_celula' displayname='Altera o valor de uma celula da planilha' access='remote' returntype='Struct' output='true'>
		<cfargument name='PLANILHA_ID' required='yes'>
		<cfargument name='SHEET_ID' required='yes'>
		<cfargument name='LINHA' required='yes'>
		<cfargument name='COLUNA' required='yes'>
		<cfargument name='VALOR' required='yes'>
		<cftry>
			<cftransaction action='begin'>
			
				<cfstoredproc procedure='kss.pkg_planilha.prc_ins_planilha_celula' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PLANILHA_ID'  value='#arguments.PLANILHA_ID#'  null='#iif(len(trim(arguments.PLANILHA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SHEET_ID'  value='#arguments.SHEET_ID#'  null='#iif(len(trim(arguments.SHEET_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LINHA'  value='#arguments.LINHA#'  null='#iif(len(trim(arguments.LINHA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLUNA'  value='#arguments.COLUNA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FORMULA'  value='#arguments.VALOR#' >
				</cfstoredproc>
				<cfscript>
					qrFiltros = this.get_planilha_filtros(planilha_id = arguments.planilha_id);
				</cfscript>
				<!--- seta os parametros de filtro --->
				<cfoutput query="qrFiltros">
					<cfif isdefined("arguments.#qrFiltros.filtro#_#qrFiltros.descricao#")>
						<cfstoredproc procedure='kss.pkg_planilha.prc_set_filtro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
							<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FILTRO'  value='#qrFiltros.filtro#' >
							<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#qrFiltros.descricao#' >
							<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_VALOR'  value='#arguments["#qrFiltros.filtro#_#qrFiltros.descricao#"]#' >
						</cfstoredproc>
					</cfif>
				</cfoutput>
				<cfscript>
					qrValor = this.get_valores_planilha(argumentCollection = arguments);
//					qrDependencias = this.get_dependencias_celula(argumentCollection = arguments);
				</cfscript>
				<cfset retorno.result = qrValor.valor>
<!---				<cfset retorno.dependencias = qrDependencias>--->
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Valor alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os diretorios das planilhas
	-- CRISTOFER  21/06/2006
	--->		
	<cffunction name="get_planilha_diretorio" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select diretorio_id,
				   diretorio_pai_id,
				   nvl(diretorio_pai_id,0) as diretorio_pai_id_nvl,
				   descricao,
				   user_insert,
				   date_insert,
				   user_update,
				   date_update,
				   site
			  from kss.v$planilha_diretorio	
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as planilhas
	-- CRISTOFER  21/06/2006
	--->		
	<cffunction name="get_planilha" access="remote" returntype="query" output="true">
		<cfargument name="diretorio_id" required="no" default="">
		<cfargument name="planilha_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select pl.planilha_id,
				   pl.diretorio_id,
				   pl.titulo,
				   pl.descricao,
				   pl.user_insert,
				   pl.date_insert,
				   pl.user_update,
				   pl.date_update,
				   pl.site
			  from kss.v$planilha pl
 		 	 where 1=1
			 <cfif len(trim(arguments.diretorio_id))>
			   and pl.diretorio_id = #arguments.diretorio_id#
				and (exists (select 'x'
								  from kss.v$org_grupo_planilha ogp
								 inner join kss.v$org_grupo_item ogi
										 on ogi.grupo_id = ogp.grupo_id
								 inner join contab.v$orc_organograma_usuario oou
										 on oou.cod_centro_custo = ogi.cod_centro_custo
								 where ogp.planilha_id = pl.planilha_id)
						or (select count(ogi.cod_centro_custo)
							  from kss.v$org_grupo_planilha ogp
							 inner join kss.v$org_grupo_item ogi
									 on ogi.grupo_id = ogp.grupo_id
							 inner join contab.v$orc_organograma_usuario oou
									 on oou.cod_centro_custo = ogi.cod_centro_custo
								  where ogp.planilha_id = pl.planilha_id) = 0)			   
/*			   and exists (select 'x'
							 from kss.v$org_grupo_planilha ogp
							inner join kss.v$org_grupo_item ogi
									on ogi.grupo_id = ogp.grupo_id
							inner join contab.v$orc_organograma_usuario oou
									on oou.cod_centro_custo = ogi.cod_centro_custo
							where ogp.planilha_id = pl.planilha_id)*/
			 </cfif>
			 <cfif len(trim(arguments.planilha_id))>
			   and planilha_id = #arguments.planilha_id#
			 </cfif>
			 order by titulo
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os filtros da planilha
	-- CRISTOFER  22/06/2006
	--->		
	<cffunction name="get_planilha_filtros" access="remote" returntype="query" output="true">
		<cfargument name="planilha_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		select distinct upper(substr(formula,2,instr(formula,'(')-2)) as filtro,
			   upper(substr(formula,instr(formula,'(')+1,instr(formula,')')-instr(formula,'(')-1)) as descricao
		  from kss.v$planilha_celula t
		 where planilha_id = #arguments.planilha_id#
		   and kss.pkg_planilha.fnc_is_filtro(formula) = 1	
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Seta os filtros e recalcula a planilha
	-- cristofer 13/06/2006 13:30:30 - CRIADO
	--->
	<cffunction name='get_planilha_valores' displayname='Altera o valor de uma celula da planilha' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PLANILHA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfscript>
					qrFiltros = this.get_planilha_filtros(planilha_id = arguments.planilha_id);
				</cfscript>
				<!--- seta os parametros de filtro --->
				<cfoutput query="qrFiltros">
					<cfif not isdefined("arguments.#qrFiltros.filtro#_#qrFiltros.descricao#")>
						<cfthrow errorcode="20000" detail="Alguns filtros no foram determinados para o recalculo da formula">
					</cfif>
					<cfstoredproc procedure='kss.pkg_planilha.prc_set_filtro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FILTRO'  value='#qrFiltros.filtro#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#qrFiltros.descricao#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_VALOR'  value='#arguments["#qrFiltros.filtro#_#qrFiltros.descricao#"]#' >
					</cfstoredproc>
				</cfoutput>
				<cfstoredproc procedure='kss.pkg_planilha.prc_recalcula_planilha' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PLANILHA_ID'  value='#arguments.PLANILHA_ID#'  null='#iif(len(trim(arguments.PLANILHA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				
				<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					select pt.valor,
						   pc.planilha_id,
						   pc.linha,
						   pc.coluna,
						   kss.pkg_planilha.fnc_get_coluna_index(pc.coluna) as coluna_index,
						   pc.formula,
						   ps.titulo as sheet,
						   ps.sheet_id,
						   ps.ordem,
						   max(linha) over (partition by ps.ordem order by ps.ordem) as linhas,
						   kss.pkg_planilha.fnc_get_coluna_index(max(lpad(coluna,2,' ')) over (partition by ps.ordem order by ps.ordem)) as colunas,
						   (select kss.fnc_concat_all(to_concat_expr(decode(pad.atributo_id,
												   8 ,pad.valor,
												   pat.nome||':'||pad.valor),';'))
							  from kss.v$planilha_atributo pat
							 inner join kss.v$planilha_atributo_dado pad
									 on pad.atributo_id = pat.atributo_id
							 where pad.atributo_id in (1,2,3,4,5,6,7,13,14,15,8)
							   and pc.sheet_id = pad.sheet_id
							   and pc.planilha_id = pad.planilha_id
							   and pc.linha = pad.linha
							   and pc.coluna = pad.coluna) as style,
						   kss.pkg_planilha.fnc_get_atributo(pc.planilha_id,pc.sheet_id,pc.linha,pc.coluna,11) as number_format,
						   kss.pkg_planilha.fnc_get_atributo(pc.planilha_id,pc.sheet_id,pc.linha,pc.coluna,12) as currency,
						   kss.pkg_planilha.fnc_get_atributo(pc.planilha_id,pc.sheet_id,pc.linha,pc.coluna,16) as colspan,
						   kss.pkg_planilha.fnc_get_atributo(pc.planilha_id,pc.sheet_id,pc.linha,pc.coluna,17) as rowspan
					  from kss.v$planilha_sheet ps
					  left join kss.v$planilha_celula pc
							 on ps.sheet_id = pc.sheet_id
							and ps.planilha_id = pc.planilha_id
					  left join kss.planilha_valor_temp pt
					         on pt.sheet_id = pc.sheet_id
							and pt.planilha_id = pc.planilha_id
							and pt.linha = pc.linha
							and pt.coluna = pc.coluna
					 where ps.planilha_id = #arguments.planilha_id#
					  order by ps.ordem, pc.linha, lpad(pc.coluna,2,' ')
				</cfquery>			
				
				<cfset retorno.valores = qr_result>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = ''>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca os valores totais da planilha
	-- CRISTOFER  23/06/2006
	--->		
	<cffunction name="get_planilha_totais" access="remote" returntype="query" output="true">
		<cfargument name="planilha_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select planilha_id,
				   sheet_id,
				   kss.pkg_planilha.fnc_get_coluna_index(max(lpad(coluna,2,' '))) as colunas,
				   max(linha) as linhas,
			       count(*) over (partition by planilha_id order by planilha_id) as sheets
			  from kss.v$planilha_celula
			 where 1=1
			 <cfif len(trim(arguments.planilha_id))>
			   and planilha_id = #arguments.planilha_id#
			 </cfif>
			 group by planilha_id,sheet_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as dependencias da celula
	-- CRISTOFER  26/06/2006
	--->		
	<cffunction name="get_dependencias_celula" access="remote" returntype="query" output="true">
		<cfargument name="planilha_id" required="yes">
		<cfargument name="sheet_id" required="yes">
		<cfargument name="linha" required="yes">
		<cfargument name="coluna" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select coluna,
				   linha,
				   sheet_id,
				   planilha_id,
				   coluna||linha as celula
			  from kss.v$planilha_celula
			 where planilha_id = #arguments.planilha_id#
			   and sheet_id = #arguments.sheet_id#
			   and nivel > 0
			   and (instr(upper(formula),'#ucase(arguments.COLUNA)##arguments.LINHA#') > 0 or instr(formula, ':') > 0)
			   and instr(';'||kss.pkg_planilha.fnc_get_referencia_celula(planilha_id,sheet_id,linha,coluna)||';',';#ucase(arguments.COLUNA)##arguments.LINHA#;') <> 0
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os anos com lancamentos
	-- CRISTOFER  27/06/2006
	--->		
	<cffunction name="get_anos_lancamento" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct t.ano_plano
			  from contab.v$contab_saldos t
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>  	
	
	<!--- 
	-- PROPSITO 
	-- Busca os centros de custo aos quais o usuario tem acesso
	-- CRISTOFER  27/06/2006
	--->		
	<cffunction name="get_centro_custo" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cc.cod_centro_custo,
				   cc.centro_custo
			  from contab.v$orc_organograma_usuario ou
			 inner join kss.v$centro_custo cc
					 on cc.cod_centro_custo = ou.cod_centro_custo	
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	
	<!--- 
	-- PROPSITO 
	-- Busca as formulas precadastradas
	-- CRISTOFER  28/06/2006
	--->		
	<cffunction name="get_planilha_formula" access="remote" returntype="query" output="true">
		<cfargument name="nome" required="no" default="">
		<cfargument name="filtro" required="no" default="">
		<cfargument name="customizada" required="no" default="">
		<cfargument name="detalhamento" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select nome,
				   customizada,
				   filtro,
				   com_detalhamento
			  from kss.v$planilha_formula	
			 where 1=1
			 <cfif len(trim(arguments.nome))>
			   and upper(nome) like upper('#arguments.nome#')
			 </cfif>
			 <cfif len(trim(arguments.filtro))>
			   and filtro = #arguments.filtro#
			 </cfif>
			 <cfif len(trim(arguments.customizada))>
			   and customizada = #arguments.customizada#
			 </cfif>
			 <cfif len(trim(arguments.detalhamento))>
			   and com_detalhamento = #arguments.detalhamento#
			 </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Calcula o valor passado
	-- CRISTOFER  28/06/2006
	--->		
	<cffunction name="get_valor_calculo" access="remote" returntype="string" output="true">
		<cfargument name="planilha_id" required="yes">
		<cfargument name="sheet_id" required="yes">
		<cfargument name="calculo" required="yes">
		<cftransaction action="begin">
			<cfscript>
				qrFiltros = this.get_planilha_filtros(planilha_id = arguments.planilha_id);
			</cfscript>
			<!--- seta os parametros de filtro --->
			<cfoutput query="qrFiltros">
				<cfif isdefined("arguments.#qrFiltros.filtro#_#qrFiltros.descricao#")>
					<cfstoredproc procedure='kss.pkg_planilha.prc_set_filtro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FILTRO'  value='#qrFiltros.filtro#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#qrFiltros.descricao#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_VALOR'  value='#arguments["#qrFiltros.filtro#_#qrFiltros.descricao#"]#' >
					</cfstoredproc>
				</cfif>
			</cfoutput>
			<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select kss.pkg_planilha.fnc_formula(#arguments.planilha_id#,#arguments.sheet_id#,'=#arguments.calculo#') as valor
				  from dual
				  
			</cfquery>
			
		</cftransaction>
		<cfreturn qr_result.valor>		
	</cffunction>	
</cfcomponent>