<!-- KM&M Componentes -->
<cfcomponent displayname="Consultas da rea de pertences" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO 
	-- Busca os materiais cadastrados
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  16/02/2006
	--->		
	<cffunction name="get_material_acessorio" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ma.material_id, ma.material_almox_id, 
				   ma.descricao, ma.lote, ma.cod_macro, ma.categoria_id,
				   mc.descricao as categoria
			  from oper.v$material_acessorio ma
			 inner join oper.v$material_categoria mc
			         on mc.categoria_id = ma.categoria_id
		    order by ma.categoria_id, ma.descricao
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os materiais atualmente inventariados no veiculo
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  16/02/2006
	--->		
	<cffunction name="get_material_veiculo" returntype="query" access="remote">
	    <cfargument name="placa" required="yes">
		<cfargument name="mostra_obs" required="no" default="0">
		<cfargument name="composicao" required="no" default="0">
		<cfif arguments.composicao eq 1>
			<cfquery name="qr_composicao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select oper.pkg_pneu.fnc_lista_placa_composicao(oper.pkg_veiculo.fnc_get_placa('#arguments.placa#')) as composicao 
				  from dual
			</cfquery>
			<cfset v_composicao = qr_composicao.composicao>
		</cfif>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select /*+ ORDERED */ distinct mv.placa, v.cod_veiculo, decode(m.cod_macro, null, m.descricao, m.cod_macro||'-'||m.descricao) as material, mvs.material_veiculo_id, mc.descricao as categoria, m.categoria_id, mv.material_id, mv.material_veiculo_id,
			<cfif arguments.mostra_obs neq 0>
					mvs.observacao,
			</cfif>
				   (select max(mvs2.data_verificacao)
					  from oper.v$material_veiculo_status mvs2
					 where mvs2.material_veiculo_id = mvs.material_veiculo_id
					   and mvs2.status_id = 1) as otimo,
				   (select max(mvs2.data_verificacao)
					  from oper.v$material_veiculo_status mvs2
					 where mvs2.material_veiculo_id = mvs.material_veiculo_id
					   and mvs2.status_id = 2) as bom,
				   (select max(mvs2.data_verificacao)
					  from oper.v$material_veiculo_status mvs2
					 where mvs2.material_veiculo_id = mvs.material_veiculo_id
					   and mvs2.status_id = 3) as regular,
				   (select max(mvs2.data_verificacao)
					  from oper.v$material_veiculo_status mvs2
					 where mvs2.material_veiculo_id = mvs.material_veiculo_id
					   and mvs2.status_id = 4) as pessimo,
				   (select mvs2.status_id 
					  from oper.v$material_veiculo_status mvs2    
				     where mvs2.material_veiculo_id = mvs.material_veiculo_id 
					   and mvs2.data_verificacao = (select max(data_verificacao)
													  from oper.v$material_veiculo_status
												     where material_veiculo_id = mvs.material_veiculo_id)) as status_id
					

			  from oper.v$material_veiculo mv
             inner join oper.v$veiculo v
                     on v.placa = mv.placa 
			 inner join oper.v$material_acessorio m
					 on m.material_id = mv.material_id
			 inner join oper.v$material_veiculo_status mvs 
					 on mvs.material_veiculo_id = mv.material_veiculo_id
					and mvs.data_verificacao between mv.data_inicio and sysdate
			 inner join oper.v$material_categoria mc
					 on mc.categoria_id = m.categoria_id
			where mv.data_fim is null  
			<cfif arguments.composicao eq 1>
				and '#v_composicao#' like '%'||mv.placa||'%'
				order by instr('#v_composicao#', mv.placa), m.categoria_id, mv.material_id
			<cfelse>
			  and mv.placa = oper.pkg_veiculo.fnc_get_placa('#arguments.placa#')
				order by m.categoria_id, mv.material_id
			</cfif>
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca os materiais atualmente inventariados no veiculo para impresso do relatrio
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  16/02/2006
	--->		
	<cffunction name="get_material_veiculo_print" returntype="query" access="remote">
	    <cfargument name="placa" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
              select x.quantidade
                    ,mav.placa
                    ,v.cod_veiculo
                    ,decode(m.cod_macro,null,m.descricao,m.cod_macro || '-' || m.descricao) as material
                    ,mvs.material_veiculo_id
                    ,mc.descricao as categoria
                    ,m.categoria_id
                    ,mav.material_id
                    ,mav.material_veiculo_id
                    ,mvs.observacao
                   ,(select max(mvs2.data_verificacao)
                       from oper.v$material_veiculo_status mvs2
                      where mvs2.material_veiculo_id = mvs.material_veiculo_id
                        and mvs2.status_id = 1) as otimo,
                    (select max(mvs2.data_verificacao)
                       from oper.v$material_veiculo_status mvs2
                      where mvs2.material_veiculo_id = mvs.material_veiculo_id
                        and mvs2.status_id = 2) as bom,
                    (select max(mvs2.data_verificacao)
                       from oper.v$material_veiculo_status mvs2
                      where mvs2.material_veiculo_id = mvs.material_veiculo_id
                        and mvs2.status_id = 3) as regular,
                    (select max(mvs2.data_verificacao)
                       from oper.v$material_veiculo_status mvs2
                      where mvs2.material_veiculo_id = mvs.material_veiculo_id
                        and mvs2.status_id = 4) as pessimo,
                    (select mvs2.status_id
                       from oper.v$material_veiculo_status mvs2
                      where mvs2.material_veiculo_id = mvs.material_veiculo_id
                        and mvs2.data_verificacao = (select max(data_verificacao)
                                                       from oper.v$material_veiculo_status
                                                      where material_veiculo_id = mvs.material_veiculo_id)) as status_id
              
               from (select t.quantidade, (select max(mav.MATERIAL_VEICULO_ID) from oper.v$material_veiculo mav
                  where mav.MATERIAL_ID = t.material_id
                 and mav.data_fim is null  
                and '#arguments.placa#' like '%'||mav.placa||'%') as material_veiculo_id, t.material_id from          
               (select mv.material_id, count(mv.material_id) as quantidade
                      from oper.v$material_veiculo mv
                
                    where mv.data_fim is null  
                      and '#arguments.placa#' like '%'||mv.placa||'%'
                      group by mv.material_id) t)x
          inner join oper.v$material_veiculo mav
                  on mav.MATERIAL_VEICULO_ID = x.material_veiculo_id
          inner join oper.v$veiculo v
                  on v.placa = '#arguments.placa#' 
          inner join oper.v$material_acessorio m
                  on m.material_id = x.material_id
          inner join oper.v$material_veiculo_status mvs 
                  on mvs.material_veiculo_id = x.material_veiculo_id
                 and mvs.data_verificacao between mav.data_inicio and sysdate
          inner join oper.v$material_categoria mc
                  on mc.categoria_id = m.categoria_id
            order by m.categoria_id, mav.material_id
        </cfquery>
		<cfreturn qr_result>		
	</cffunction>		

	<!--- 
	-- PROPSITO 
	-- Busca as verificaes do material
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  17/02/2006
	--->
	<cffunction name="get_material_verificacao" returntype="query" access="remote">
	    <cfargument name="placa" required="yes">
	    <cfargument name="material_id" required="yes">
	    <cfargument name="material_veiculo_id" required="no" default="">
		<cfquery name="qrMateriaisVerificacao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select mv.placa, mvs.data_verificacao, mvs.material_veiculo_id, m.descricao as material, 
				   oper.pkg_global.fnc_busca_nome_pessoa(mvs.cod_pessoa_verificador) as verificado_por,
				   mvs.observacao, ms.descricao as status
			  from oper.v$material_veiculo mv
			 inner join oper.v$material_veiculo_status mvs
					 on mvs.material_veiculo_id = mv.material_veiculo_id
					and mvs.data_verificacao between mv.data_inicio and sysdate
			 inner join oper.v$material_acessorio m
					 on m.material_id = mv.material_id
			 inner join oper.v$material_status ms
					 on ms.status_id = mvs.status_id               
		     where mv.data_fim is null
			   and mv.placa = oper.pkg_veiculo.fnc_get_placa('#arguments.placa#')
			   and mv.material_id = #arguments.material_id#
			  <cfif len(trim(arguments.material_veiculo_id))>
			   and mv.material_veiculo_id = #arguments.material_veiculo_id#
			  </cfif>
			order by mvs.data_verificacao
   		</cfquery>		
		<cfreturn qrMateriaisVerificacao>
	</cffunction>	
		
	<!--- 
	-- PROPSITO 
	-- Buscar os Status possveis do material
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  16/02/2006
	--->		
	<cffunction name="get_material_status" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select status_id, descricao 
			  from oper.v$material_status
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Buscar os Veiculos ainda nao inventariados
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  17/02/2006
	--->		
	<cffunction name="get_veiculo_nao_inventariado" returntype="query" access="remote">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select t.placa, v.cod_veiculo,  
				   v.marca, 
				   v.modelo
			  from oper.v$veiculo_ctrl_pertence t
			 inner join oper.v$veiculo_dados v
					 on v.placa = t.placa
			 where v.situacao_id in (1,4)
			   and not exists (select 'x'
								 from oper.v$material_veiculo mv
								where mv.placa = t.placa)	
			order by v.marca, t.placa
   		</cfquery>		
		<cfreturn qr_result>
	</cffunction>	
	
		<!--- 
	-- PROPSITO 
	-- Busca relao de pertences por material e status
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  17/02/2006
	--->		
	<cffunction name="get_pertences_relacao" returntype="query" access="remote">
		<cfargument name="PLACA" required="no" default="" />
		<cfargument name="MATERIAL_ID" required="no" default="" />
		<cfargument name="STATUS_ID" required="no" default="" />
		<cfargument name="NO_VEICULO" required="no" default="" />
		<cfargument name="DATA_INICIAL" required="no" default="" />
		<cfargument name="DATA_FINAL" required="no" default="" />
		<cfargument name="COBRADO_MOTORISTA" required="no" default="" />
		<cfargument name="AGRUPAMENTO_ID" required="no" default="" />
		<cfargument name="TIPO_CARROCERIA_ID" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select /*+ FIRST_ROWS */ vt.descricao as classificacao, vag.descricao as agrupamento,
            	   mv.material_veiculo_id, mv.placa, ma.material_id, ma.descricao as material, ms.descricao as status,
				   mvs.data_verificacao, mvs.cod_pessoa_verificador, vd.cod_veiculo,
				   substr(oper.pkg_global.fnc_busca_nome_pessoa(mvs.cod_pessoa_verificador),1,instr(oper.pkg_global.fnc_busca_nome_pessoa(mvs.cod_pessoa_verificador),' ')) as vistoriador,
				   mv.data_inicio, mv.data_fim, mvs.observacao, vd.modelo, mvs.STATUS_ID,mv.user_update,mv.date_update,
				    (select cl.valor_lancamento
    					 from finan.v$ccorrente_lancamento cl 
   						where mvs.num_lancamento = cl.num_lancamento) as valor_desc_motorista,
				   decode(mvs.num_lancamento, null, 0, 1) as cobrado_motorista
			  from oper.v$material_veiculo mv
		     inner join oper.v$veiculo_dados vd
               	     on vd.placa = mv.placa    
       		 inner join oper.v$veiculo_tipo_carroceria vt
               		 on vt.tipo_carroceria_id = vd.tipo_carroceria_id
       		 inner join oper.v$veiculo_agrupamento vag
               		 on vag.agrupamento_id = vt.agrupamento_id
			 inner join oper.v$material_veiculo_status mvs
					 on mv.material_veiculo_id = mvs.material_veiculo_id
			 inner join oper.v$material_acessorio ma
					 on ma.material_id = mv.material_id         
			 inner join oper.v$material_status ms
					 on ms.status_id = mvs.status_id
			 where mvs.data_verificacao = (select max(mvs2.data_verificacao)
											 from oper.v$material_veiculo_status mvs2
											where mvs2.material_veiculo_id = mvs.material_veiculo_id)
				and vd.situacao_id = 1 <!--- Somente Ativos--->			 
			<cfif Len(Trim(arguments.PLACA))>  
			   and mv.placa = oper.pkg_veiculo.fnc_get_placa('#arguments.PLACA#')
			 </cfif> 
			 <cfif Len(Trim(arguments.MATERIAL_ID))>  
			   and mv.MATERIAL_ID = #arguments.MATERIAL_ID#
			 </cfif>  
			 <cfif Len(Trim(arguments.STATUS_ID))>  
			   and ms.status_id in (#arguments.STATUS_ID#)
			 </cfif>
			 <cfif Len(Trim(arguments.DATA_INICIAL))>  
			   and trunc(mvs.data_verificacao) >= '#arguments.DATA_INICIAL#'
			 </cfif>
			 <cfif Len(Trim(arguments.DATA_FINAL))>  
			   and trunc(mvs.data_verificacao) <= '#arguments.DATA_FINAL#'
			 </cfif>
			 <cfif Len(Trim(arguments.COBRADO_MOTORISTA)) and arguments.COBRADO_MOTORISTA eq 1>  
			   and mvs.num_lancamento is not null
			 </cfif>
			 <cfif Len(Trim(arguments.COBRADO_MOTORISTA)) and arguments.COBRADO_MOTORISTA eq 0>  
			   and mvs.num_lancamento is null
			 </cfif> 
			 <cfif Len(Trim(arguments.AGRUPAMENTO_ID))>  
			   and vag.agrupamento_id in (#arguments.AGRUPAMENTO_ID#)
			 </cfif>  
			 <cfif Len(Trim(arguments.TIPO_CARROCERIA_ID))>  
			   and vd.tipo_carroceria_id in (#arguments.TIPO_CARROCERIA_ID#)
			 </cfif>  
			 <cfif Len(Trim(arguments.NO_VEICULO)) and arguments.NO_VEICULO eq 1>  <!--- Materiais que esto no veculo --->
			   and mv.data_fim is null
			 </cfif>  
			 <cfif Len(Trim(arguments.NO_VEICULO)) and arguments.NO_VEICULO eq 0>  <!--- Materiais retirados do veculo --->
			   and mv.data_fim is not null
			 </cfif>  
			 order by mv.material_id, vag.descricao, vt.descricao, vd.modelo, ms.status_id, mv.data_inicio   
   		</cfquery>		
		<cfreturn qr_result>
	</cffunction>		
		

	<!--- 
	-- PROPSITO 
	-- Retorna todos os veculos da frota que no possuem determinado material
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  17/02/2006
	--->		
	<cffunction name="get_veiculos_sem_pertences" returntype="query" access="remote">
		<cfargument name="MATERIAL_ID" required="yes" />
		<cfargument name="TIPO_VEICULO_ID" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select /*+ ordered */ vt.tipo as tipo_veiculo, vd.placa, vd.modelo
			  from oper.v$veiculo_frota_geral vfg
			 inner join oper.v$veiculo_dados vd
					 on vfg.placa = vd.placa
					and vd.situacao_id in (1,4)
			 inner join oper.v$veiculo_tipo vt
						 on vt.tipo_id = vd.tipo_id                
			where not exists (select 'x'
							   from oper.v$material_veiculo mv
							  where mv.placa = vd.placa 
								and mv.material_id = #arguments.MATERIAL_ID#
								and mv.data_fim is null)
			 <cfif Len(Trim(arguments.TIPO_VEICULO_ID))>  
			   and vd.tipo_id in (#arguments.TIPO_VEICULO_ID#)
			 </cfif>  
			 order by tipo_veiculo
   		</cfquery>		
		<cfreturn qr_result>
	</cffunction>		

	<!--- 
	-- PROPSITO 
	-- Busca detalhes de um material em um veculo
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  17/02/2006
	--->		
	<cffunction name="get_material_veiculo_detalhes" returntype="query" access="remote">
		<cfargument name="material_veiculo_id" required="yes" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select mvs.material_veiculo_id, mv.placa, ma.material_id, ma.descricao as material, ms.descricao as status,
				   mvs.data_verificacao, mvs.cod_pessoa_verificador, 
				   substr(oper.pkg_global.fnc_busca_nome_pessoa(mvs.cod_pessoa_verificador),1,instr(oper.pkg_global.fnc_busca_nome_pessoa(mvs.cod_pessoa_verificador),' ')) as verificador,
				   mv.data_inicio, mv.data_fim, mvs.OBSERVACAO
			  from oper.v$material_veiculo mv
			 inner join oper.v$material_veiculo_status mvs
					 on mv.material_veiculo_id = mvs.material_veiculo_id
			 inner join oper.v$material_acessorio ma
					 on ma.material_id = mv.material_id         
			 inner join oper.v$material_status ms
					 on ms.status_id = mvs.status_id
			 <cfif Len(Trim(arguments.material_veiculo_id))>  
				 where mvs.material_veiculo_id = #arguments.material_veiculo_id#
			 </cfif>  
			order by mvs.data_verificacao
   		</cfquery>		
		<cfreturn qr_result>
	</cffunction>		

	<!--- 
	-- PROPSITO 
	-- Retorna todos os eventos de falta de pertences enviados pelos motoristas
	-- NOTAS EXPLICATIVAS
	-- GUTO 09/05/2006
	--->		
	<cffunction name="get_eventos_falta" returntype="query" access="remote">
		<cfargument name="controle_evo_id" required="no" default=""/>
		<cfargument name="cod_pessoa_responsavel" required="no" default=""/>
		<cfargument name="nao_verificadas" required="no" default=""/>		
		<cfargument name="data_inicio" required="no" default=""/>
		<cfargument name="data_fim" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select eo.controle_evo_id, eo.cod_pessoa, eo.placa, eo.data, eo.referencia_id, 
				   initcap(eo.local) as local,
				   eod.valor, initcap(oper.pkg_motorista.fnc_localizacao_motorista(eo.cod_pessoa).referencia) as referencia,
				   oper.pkg_global.fnc_busca_nome_pessoa(eo.cod_pessoa) as nome_motorista,
		           mef.cod_pessoa_responsavel, mef.comentario,
        		   mef.data_limite, mef.observacao, 
				   case
				     when mef.situacao is null then 'Em aberto'
					 when mef.situacao = 1 then 'Agendada'
					 when mef.situacao = 2 then 'Finalizada'
				   end situacao,
   				   oper.pkg_global.fnc_busca_nome_pessoa(mef.cod_pessoa_responsavel) as nome_responsavel
			  from oper.v$evento_operacao eo
			 inner join oper.v$evento_operacao_dado eod
					 on eod.controle_evo_id = eo.controle_evo_id
			   left join oper.v$material_evento_falta mef
		              on mef.controle_evo_id = eo.controle_evo_id
			 where eo.num_evento = 17
			   and eod.dado_id = 16 
			   <cfif Len(Trim(arguments.nao_verificadas))>
				   and not exists (select 'x'
									 from oper.v$material_veiculo mv
									inner join oper.v$material_veiculo_status mvs
											on mvs.material_veiculo_id = mv.material_veiculo_id
									where mv.placa = eo.placa
									  and mvs.data_verificacao > eo.data)  
				  and (mef.situacao <> 2 or mef.situacao is null)     	
			   </cfif>
			   <cfif Len(Trim(arguments.controle_evo_id))>
			   	and eo.controle_evo_id = #arguments.controle_evo_id#
			   </cfif>
			   <cfif Len(Trim(arguments.data_inicio))>
			   	and trunc(eo.data) >= '#arguments.data_inicio#'
			   </cfif>
			   <cfif Len(Trim(arguments.data_fim))>
			   	and trunc(eo.data) <= '#arguments.data_fim#'
			   </cfif>
			   <cfif Len(Trim(arguments.cod_pessoa_responsavel))>
			   	and mef.cod_pessoa_responsavel = #arguments.cod_pessoa_responsavel#
				and mef.cod_pessoa_responsavel is not null
			   </cfif>			   
			  order by eo.data desc 
   		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
	<!--- 
	-- PROPSITO 
	-- Buscaos itens para o check list da viagem
	-- Rafael 24/08/2009
	--->		
	<cffunction name="get_viagem_item" access="remote" returntype="query" output="true">
    	<cfargument name="placa" required="yes"/>
        <cfargument name="operacao" required="yes"/>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select x.quantidade
                  ,decode(m.cod_macro,null,m.descricao,m.cod_macro || '-' || m.descricao) as material
                  ,mc.descricao as categoria
                  ,mvs.observacao
                            
             from (select t.quantidade, (select max(mav.MATERIAL_VEICULO_ID) from oper.v$material_veiculo mav
                where mav.MATERIAL_ID = t.material_id
               and mav.data_fim is null  
              and '#arguments.placa#' like '%'||mav.placa||'%') as material_veiculo_id, t.material_id from          
             (select mv.material_id, count(mv.material_id) as quantidade
                    from oper.v$material_veiculo mv
                        
                  where mv.data_fim is null  
                    and '#arguments.placa#' like '%'||mv.placa||'%'
                    group by mv.material_id) t)x
        inner join oper.v$material_veiculo mav
                on mav.MATERIAL_VEICULO_ID = x.material_veiculo_id
        inner join oper.v$veiculo v
                on v.placa = '#arguments.placa#' 
        inner join oper.v$material_acessorio m
                on m.material_id = x.material_id
        inner join oper.v$material_veiculo_status mvs 
                on mvs.material_veiculo_id = x.material_veiculo_id
               and mvs.data_verificacao between mav.data_inicio and sysdate
        inner join oper.v$material_categoria mc
                on mc.categoria_id = m.categoria_id
                
        union all
        
            select 1 as quantidade
                  ,ma.DESCRICAO as material
                  ,'Acessrios da Operao' as categoria
                  ,'' as observacao
              from oper.v$material_acessorio ma 
        inner join logistica.v$operacao_acessorio oa
                on oa.material_id = ma.MATERIAL_ID
             where oa.operacao_id = #arguments.operacao#
        </cfquery>
		<cfreturn qr_result>		
	</cffunction>    
    <!--- 
    -- PROPSITO 
    -- Retorna Check List de Viagem
    -- LEOPOLDOS 18/082010 - CRIADO
    --->		
    <cffunction name="get_check_list_viagem" access="remote" returntype="query" output="true">
    	<cfargument name="placa" required="no" default="">
    	<cfargument name="num_romaneio" required="no" default="">
    	<cfargument name="data_inicio" required="no" default="">        
       	<cfargument name="data_fim" required="no" default="">        
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select r.num_romaneio
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(rhv.placa_controle) as placa
                 , oper.pkg_veiculo.fnc_get_placa(rhv.placa_controle) as cod_veiculo
                 , r.data_verificacao
                 , (select (select op.descricao
                              from logistica.v$operacao op
                             where op.operacao_id = ri.operacao_id)
                      from oper.v$romaneio_item ri
                     where ri.num_romaneio = r.num_romaneio
                       and rownum = 1) as operacao
                 , (select ri.operacao_id
                      from oper.v$romaneio_item ri
                     where ri.num_romaneio = r.num_romaneio
                       and rownum = 1) as operacao_id
                 , rom.remetente
                 , rom.destinatario
                 , 1 as carregado
              from oper.v$romaneio_check_list r 
             inner join oper.v$romaneio rom
                     on rom.num_romaneio = r.num_romaneio
             inner join oper.v$romaneio_hist_veiculo rhv
                     on rhv.num_romaneio = r.num_romaneio
             where rhv.roo_hist_veiculo_id = (select max(rhv2.roo_hist_veiculo_id)
                                                from oper.v$romaneio_hist_veiculo rhv2
                                               where rhv2.num_romaneio = r.num_romaneio) 
			<cfif Len(Trim(arguments.NUM_ROMANEIO))>
               and r.num_romaneio = #arguments.NUM_ROMANEIO#
            </cfif>
            <cfif Len(Trim(arguments.PLACA))>
               and rhv.placa_controle = oper.pkg_veiculo.fnc_get_placa('#arguments.PLACA#')
            </cfif>
            <cfif (Len(Trim(arguments.data_inicio)) gt 0 ) and (Len(Trim(arguments.data_fim)) gt 0)>
               and r.data_verificacao between '#arguments.data_inicio#' and '#arguments.data_fim#'
            </cfif>
		    <cfif (Len(Trim(arguments.data_inicio)) gt 0 ) and (Len(Trim(arguments.data_fim)) eq 0)>
               and r.data_verificacao between '#arguments.data_inicio#' and sysdate
            </cfif>
             order by r.data_verificacao desc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    <!--- 
    -- PROPSITO 
    -- Retorna Itens do Check-List do Romaneio (Check List de Viagem)
    -- LEOPOLDOS 18/08/2010 - CRIADO
    --->		
    <cffunction name="get_item_check_list" access="remote" returntype="query" output="true">
    	<cfargument name="NUM_ROMANEIO" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
           select rcli.quantidade
                , mc.descricao as categoria
                , ma.descricao as material
                , case when rcli.data_conforme is null then 0
                       else 1
                  end as conforme
                , case when rcli.data_nao_conforme is null then 0
                       else 1
                  end as nao_conforme
                , rcli.observacao
                , rcl.data_verificacao
                , to_char(rcl.data_verificacao, 'HH24:mm:ss') as hora_verificacao
                , rcl.cod_pessoa_verificador
                , rcl.cod_pessoa_autorizador
             from oper.v$romaneio_check_list rcl
            inner join oper.v$romaneio_check_list_item rcli
                    on rcl.check_list_id = rcli.check_list_id
            inner join oper.v$material_acessorio ma
                    on rcli.material_id = ma.material_id  
            inner join oper.v$material_categoria mc
                    on ma.categoria_id = mc.categoria_id                   
            where rcl.num_romaneio = #arguments.NUM_ROMANEIO# 
              and rcl.check_list_id = (select max(rcl2.check_list_id)
                                         from oper.v$romaneio_check_list rcl2
                                        where rcl2.num_romaneio = rcl.num_romaneio)
            order by mc.descricao, ma.descricao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>		
    <!--- 
    -- PROPSITO 
    -- Retorna Uma linha se esse check list necessita de um autorizador
    -- LEOPOLDOS 21/06/2010 - CRIADO
    --->		
    <cffunction name="get_necessita_autorizacao_check_list" access="remote" returntype="query" output="true">
    	<cfargument name="NUM_ROMANEIO" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select distinct 1
              from oper.v$romaneio_check_list_item rci 
             inner join oper.v$romaneio_check_list rc
                     on rci.check_list_id = rc.check_list_id
             where rc.num_romaneio = #arguments.NUM_ROMANEIO#
               and rci.data_nao_conforme is not null
               and rci.check_list_id = (select max(rc2.check_list_id)
                                          from oper.v$romaneio_check_list rc2
                                         where rc2.num_romaneio = #arguments.NUM_ROMANEIO#)
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Verifica se o veiculo existe
    -- LEOPOLDOS 17/06/2010 - CRIADO
    --->		
    <cffunction name="get_veiculo_existe" access="remote" returntype="query" output="true">
    	<cfargument name="placa" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">		
        	select v.placa
              from oper.v$veiculo v
             where v.placa = oper.pkg_veiculo.fnc_get_placa('#arguments.placa#')
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
</cfcomponent>