<cfcomponent>
	<!--- 
	-- PROPSITO
	-- Retorna tipos de soluo
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 14/07/2005 - criado
	--->	
	<cffunction name="get_wbs_solucao" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select solucao_id, descricao, exige_data, user_insert, date_insert, user_update, date_update, site 
			  from desenvolvimento.v$wbs_tipo_solucao
			 where 1=1
		</cfquery>	
		<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Retorna o conteudo dos objetos do WBS
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 12/07/2005 - criado
	--->	
	<cffunction name="get_wbs_tarefa" access="remote" returntype="query" output="true">
		<cfargument name="tarefa_id" required="no" default="">
		<cfargument name="titulo"      required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select t.tarefa_id, t.titulo, to_char(t.duracao) as duracao,
				   to_char(extract( day from t.duracao),'00') as duracao_dias,
				   to_char(extract( hour from t.duracao),'00') || ':' ||
				   to_char(extract( hour from t.duracao),'00') as duracao_horas, 			 
				   t.percentual_completo, 
				   to_char(extract( day from t.horas_trabalhadas),'00') as horas_trabalhadas_dias,
				   to_char(extract( hour from t.horas_trabalhadas),'00') || ':' ||
				   to_char(extract( hour from t.horas_trabalhadas),'00') as horas_trabalhadas_horas,
				   t.custo_hora, t.data_hora_inicio, t.data_hora_fim, 
				   t.solucao_id, ts.descricao as solucao, t.data_prevista
			  from desenvolvimento.v$wbs_tarefa t
			 inner join desenvolvimento.v$wbs_tipo_solucao ts
					 on ts.solucao_id = t.solucao_id
			 where 1=1
		     <cfif Len(Trim(arguments.tarefa_id))>
			   and t.tarefa_id = #arguments.tarefa_id#
		     </cfif>
		     <cfif Len(Trim(arguments.titulo))>
			   and t.titulo like '%#arguments.titulo#%'
		    </cfif>		
		</cfquery>	
		<cfreturn qr_result>
	</cffunction>
	<!--- 
	-- PROPSITO
	-- Retorna os objetos das tarefas do WBS
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 08/07/2005 - criado
	--->	
	<cffunction name="get_wbs_tarefa_objeto" access="remote" returntype="query" output="true">
		<cfargument name="tarefa_id"   required="no" default=""/>
		<cfargument name="objeto_id"   required="no" default=""/>
		<cfargument name="diagrama_id" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select t.tarefa_id, t.titulo, 
				   extract( day from t.duracao) || 'd ' ||
				   extract( hour from t.duracao) || 'Hs ' ||
				   extract( hour from t.duracao) || 'Min ' as duracao, 
				   t.percentual_completo, 
				   extract( day from t.horas_trabalhadas) || 'd ' ||
				   extract( hour from t.horas_trabalhadas) || 'Hs ' ||
				   extract( hour from t.horas_trabalhadas) || 'Min ' as horas_trabalhadas, 
				   t.custo_hora, t.data_hora_inicio, t.data_hora_fim, 
				   t.solucao_id, ts.descricao as solucao, t.data_prevista,
				   tow.objeto_id
			  from desenvolvimento.v$wbs_tarefa_objeto tow
			 inner join desenvolvimento.v$wbs_tarefa t
					 on tow.tarefa_id = t.tarefa_id
			 inner join desenvolvimento.v$wbs_tipo_solucao ts
					 on ts.solucao_id = t.solucao_id
		     inner join desenvolvimento.v$diagrama_objeto d
			         on d.objeto_id = tow.objeto_id
  			 where 1=1
			 <cfif Len(Trim(arguments.diagrama_id))>
			   and d.diagrama_id = #arguments.diagrama_id#
			 </cfif>
			 <cfif Len(Trim(arguments.tarefa_id))>
			   and t.tarefa_id = #arguments.tarefa_id#
			 </cfif>
			 <cfif Len(Trim(arguments.objeto_id))>
			   and tow.objeto_id = #arguments.objeto_id#
			 </cfif>
			 order by t.tarefa_id desc	
		</cfquery>	
		<cfreturn qr_result>
	</cffunction>
</cfcomponent>