<cfcomponent>
	<!--- 
	-- PROPSITO 
	-- Busca os servicos do monitorador
	-- CRISTOFER  28/12/2007
	--->		
	<cffunction name="get_servico" access="remote" returntype="query" output="true">
    	<cfargument name="cod_tipo" required="no" default="">
		<cfquery name="qr_result" datasource="MANAGER.KMM.COM.BR" username="manager" password="kmm2007">
            select s.servico_id,
                   s.servidor_id,
                   s.cod_servico,
                   s.descricao,
                   s.tipo_id,
                   t.cod_tipo,
                   t.descricao tipo,
                   sv.cod_servidor,
                   sv.descricao servidor,
                   s.date_insert,
                   s.user_insert,
                   s.date_update,
                   s.user_update,
                   s.site
              from manager.v$servico s
             inner join manager.v$servico_tipo t
                     on t.tipo_id = s.tipo_id
             inner join manager.v$servidor sv
                     on sv.servidor_id = s.servidor_id
             where 1=1
             <cfif len(trim(arguments.cod_tipo))>
               and t.cod_tipo = '#arguments.cod_tipo#'
             </cfif>
             order by sv.cod_servidor, s.cod_servico
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
	<!--- 
	-- PROPSITO 
	-- Busca os logs do servico
	-- CRISTOFER  28/12/2007
	--->		
	<cffunction name="get_servico_log" access="remote" returntype="query" output="true">
    	<cfargument name="servico_id" required="no" default="">
    	<cfargument name="data_inicial" required="no" default="">
    	<cfargument name="data_final" required="no" default="">
		<cfquery name="qr_result" datasource="MANAGER.KMM.COM.BR" username="manager" password="kmm2007">
            select log_id,
                   servico_id,
                   texto,
                   date_insert,
                   user_insert,
                   date_update,
                   user_update,
                   site,
                   cod_tipo,
                   to_char(data,'dd/mm/yyyy hh24:mi:ss') data,
                   ordem
              from manager.v$servico_log sl
             where 1=1
             <cfif len(trim(arguments.servico_id))>
               and sl.servico_id = #arguments.servico_id#
             </cfif>
             <cfif len(trim(arguments.data_inicial))>
               and sl.data >= to_date('#arguments.data_inicial#','dd/mm/yyyy hh24:mi')
             </cfif>
             <cfif len(trim(arguments.data_final))>
               and sl.data <= to_date('#arguments.data_final#','dd/mm/yyyy hh24:mi')
             </cfif>
             order by sl.data, ordem
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
	<!--- 
	-- PROPSITO 
	-- Busca o tamanho atual dos arquivos da base de dados
	-- CRISTOFER  31/12/2007
	--->		
	<cffunction name="get_servico_arquivo_historico_atual" access="remote" returntype="query" output="true">
    	<cfargument name="servico_id" required="no" default="">
    	<cfargument name="cod_tipo" required="no" default="">
		<cfquery name="qr_result" datasource="MANAGER.KMM.COM.BR" username="manager" password="kmm2007">
            select filename,
                   to_char(max(data),'dd/mm/yyyy hh24:mi:ss') data,
                   cod_tipo,
                   nvl(max(tamanho) keep(dense_rank last order by data),0) tamanho,
                   max(usado) keep(dense_rank last order by data) usado
              from manager.v$servico_arquivo_historico t
             where 1=1
             <cfif len(trim(arguments.servico_id))>
               and t.servico_id = #arguments.servico_id#
             </cfif>
             <cfif len(trim(arguments.cod_tipo))>
               and t.cod_tipo = '#arguments.cod_tipo#'
             </cfif>
             group by filename, cod_tipo
             order by cod_tipo, filename    
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
</cfcomponent>