<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO 
	-- Busca km atual do veculo
	-- NOTAS EXPLICATIVAS
	-- GUTO 04/10/2006
	--->
	<cffunction name="get_km_atual" returntype="query" access="remote">
		<cfargument name="placa" required="no" default="">
        <cfargument name="data" required="no" default="">
        <cfif Len(Trim(arguments.data))>
        	<cfset v_data = "to_date('#arguments.data#', 'dd/mm/yyyy hh24:mi')">
        <cfelse>
        	<cfset v_data = "sysdate">
        </cfif>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select manutencao.to_veiculo_km(oper.pkg_veiculo.fnc_get_placa('#arguments.placa#'), #PreserveSingleQuotes(v_data)#, #PreserveSingleQuotes(v_data)#).km_data_inicial as km_atual,
			       manutencao.to_equipamento_dados(oper.pkg_veiculo.fnc_get_placa('#arguments.placa#'), #PreserveSingleQuotes(v_data)#).equipamento_id as equipamento_id
			  from dual
   		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
	<!--- 
	-- PROPSITO
	-- Busca composicao
	-- NOTAS EXPLICATIVAS
	-- GUTO 04/10/2006
	--->
	<cffunction name="get_composicao" returntype="string" access="remote">
		<cfargument name="placa" required="no" default="">
		<cfargument name="equipamento_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select 
			       <cfif Len(Trim(arguments.PLACA))>
				   manutencao.to_equipamento_dados('#arguments.PLACA#',sysdate).composicao as composicao
				   </cfif>
			       <cfif Len(Trim(arguments.EQUIPAMENTO_ID))>
				   manutencao.to_equipamento_dados(#arguments.EQUIPAMENTO_ID#,sysdate).composicao as composicao
				   </cfif>
			  from dual
		</cfquery>		
		<cfreturn qr_result.composicao>
	</cffunction>
	<!--- 
	-- PROPSITO 
	-- Busca niveis de especialidade dos recursos
	-- NOTAS EXPLICATIVAS
	-- GUTO 02/08/2006
	--->
	<cffunction name="get_recurso_nivel" returntype="query" access="remote">
		<cfargument name="nivel_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select substr(sys_connect_by_path(rn.descricao, ','),2) as niveis,
				   rn.descricao, rn.nivel_id
			  from manutencao.v$recurso_nivel rn
			  where 1=1
			  <cfif Len(Trim(arguments.nivel_id))>
			 	 and rn.nivel_id = #arguments.nivel_id#
			  </cfif>
			 start with rn.nivel_pai is null
			connect by prior rn.nivel_id = rn.nivel_pai
			order siblings by rn.descricao
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
	<!--- 
	-- PROPSITO 
	-- Busca especialidade dos recursos
	-- NOTAS EXPLICATIVAS
	-- GUTO 02/08/2006
	--->
	<cffunction name="get_recurso_especialidade" returntype="query" access="remote">
		<cfargument name="descricao" required="no" default="">
		<cfargument name="especialidade_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select especialidade_id, descricao 
			  from manutencao.v$recurso_especialidade
			 where 1=1
			  <cfif Len(Trim(arguments.descricao))>
				and upper(descricao) like upper('%#arguments.descricao#%')
			  </cfif>
			  <cfif Len(Trim(arguments.especialidade_id))>
				and especialidade_id = #arguments.especialidade_id#
			  </cfif>
			  order by descricao 
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
	<!--- 
	-- PROPSITO 
	-- Busca recursos 
	-- NOTAS EXPLICATIVAS
	-- GUTO 03/08/2006
	--->
	<cffunction name="get_recurso" returntype="query" access="remote">
		<cfargument name="recurso_id" required="no" default="">
		<cfargument name="cod_pessoa" required="no" default="">
		<cfargument name="nivel_id" required="no" default="">
		<cfargument name="especialidade_id" required="no" default="">
		<cfargument name="todos" required="no" default="1">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct r.recurso_id, 
				   r.cod_pessoa, pf.cliente as nome_funcionario,
				   oper.pkg_global.fnc_get_cod_funcionario(r.cod_pessoa) as cod_funcionario,
				   r.especialidade_id, 
				   re.descricao as especialidade, 
				   r.nivel_id, rn.descricao as nivel
			  from manutencao.v$recurso r
			 inner join manutencao.v$recurso_especialidade re
					 on re.especialidade_id = r.especialidade_id
			 inner join manutencao.v$recurso_nivel rn
					 on rn.nivel_id = r.nivel_id 
			 inner join kss.v$pessoa pf
					 on pf.cod_pessoa = r.cod_pessoa
		     where 1=1
			  <cfif arguments.todos eq 0>
			 	 and (exists (select 'x'
				               from manutencao.v$recurso_oficina ro
                      inner join manutencao.v$recurso r2
                              on r2.recurso_id = ro.recurso_id
                      where r2.cod_pessoa = r.cod_pessoa
                        and ro.cod_pessoa_oficina = #session.cod_pessoa#) 
      			 	 or not exists (select 'x'
      				                  from manutencao.v$recurso_oficina ro
                               inner join manutencao.v$recurso r2
                                       on r2.recurso_id = ro.recurso_id
                               inner join oper.v$filial f
                                       on f.cod_pessoa = ro.cod_pessoa_oficina
                               where r2.cod_pessoa = r.cod_pessoa) )
			  </cfif>
 			  <cfif Len(Trim(arguments.cod_pessoa))>
							and r.cod_pessoa = #arguments.cod_pessoa#
			   </cfif>
			   <cfif Len(Trim(arguments.recurso_id))>
				   and r.recurso_id = #arguments.recurso_id#
			   </cfif>
			   <cfif Len(Trim(arguments.especialidade_id))>
				   and re.especialidade_id in (#arguments.especialidade_id#)
			   </cfif>
			   <cfif Len(Trim(arguments.nivel_id))>
				   and rn.nivel_id in (#arguments.nivel_id#)
			   </cfif>
			  order by nome_funcionario
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
	<!--- 
	-- PROPSITO 
	-- Busca recursos de processos abertos 
	-- NOTAS EXPLICATIVAS
	-- ARLEN 01/11/2006
	--->
	<cffunction name="get_recurso_processo_aberto" returntype="query" access="remote">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct r.cod_pessoa,
							pf.cliente as nome_funcionario,
							(select manutencao.sum_dsinterval(p.tempo_execucao) + min(ope.DATA_INICIO)
        								  from manutencao.v$ordem_servico os
                         inner join manutencao.v$os_atividade oa
                                 on oa.ordem_servico_id = os.ordem_servico_id
                         inner join manutencao.v$os_processo_atividade opa
                                 on opa.controle_id_atividade = oa.controle_id
                         inner join manutencao.v$os_processo_execucao ope
                                 on opa.controle_id_processo = ope.controle_id
                         inner join manutencao.v$os_processos op
                                 on opa.controle_id_processo = op.controle_id
                         inner join manutencao.v$processo p
                                 on p.processo_id = op.processo_id
        								 where ope.cod_pessoa_principal = pf.cod_pessoa
        									and ope.data_termino is null) - sysdate as no_horario,              
							manutencao.to_tempo_execucao((select manutencao.sum_dsinterval(p.tempo_execucao)
        								  from manutencao.v$ordem_servico os
                         inner join manutencao.v$os_atividade oa
                                 on oa.ordem_servico_id = os.ordem_servico_id
                         inner join manutencao.v$os_processo_atividade opa
                                 on opa.controle_id_atividade = oa.controle_id
                         inner join manutencao.v$os_processo_execucao ope
                                 on opa.controle_id_processo = ope.controle_id
                         inner join manutencao.v$os_processos op
                                 on opa.controle_id_processo = op.controle_id
                         inner join manutencao.v$processo p
                                 on p.processo_id = op.processo_id
        								 where ope.cod_pessoa_principal = pf.cod_pessoa
        									and ope.data_termino is null)).retorno as tempo_execucao
			  from manutencao.v$recurso r 
		inner join kss.v$pessoa pf
		        on pf.cod_pessoa = r.cod_pessoa
	    	 where 1 = 1
			   and exists (select /*+PUSH_SUBQ*/ 'x'
        								  from manutencao.v$ordem_servico os
                         inner join manutencao.v$os_atividade oa
                                 on oa.ordem_servico_id = os.ordem_servico_id
                         inner join manutencao.v$os_processo_atividade opa
                                 on opa.controle_id_atividade = oa.controle_id
                         inner join manutencao.v$os_processo_execucao op
                                 on opa.controle_id_processo = op.controle_id
        								 where op.cod_pessoa_principal = pf.cod_pessoa
        									and op.data_termino is null)
			   and (exists (select 'x'
              from manutencao.v$recurso_oficina ro
        inner join manutencao.v$recurso r2
                on r2.recurso_id = ro.recurso_id
             where r2.cod_pessoa = r.cod_pessoa
               and ro.cod_pessoa_oficina = #session.cod_pessoa#) 
  	 or not exists (select 'x'
  	                  from manutencao.v$recurso_oficina ro
                inner join manutencao.v$recurso r2
                        on r2.recurso_id = ro.recurso_id
                inner join oper.v$filial f
                        on f.cod_pessoa = ro.cod_pessoa_oficina
                     where r2.cod_pessoa = r.cod_pessoa) ) 
			 order by nome_funcionario
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>    
	
    <!--- 
    -- PROPSITO 
    -- Busca os equipamentos vinculados a um recurso de um processo aberto
    -- ANDERSON 01/12/2009 - ALTERADO
    --->		
    <cffunction name="get_recurso_processo_equipamentos" access="remote" returntype="query" output="true">
        <cfargument name="cod_pessoa_principal" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select t.equipamento_id
                 , t.cod_equipamento
                 , kss.fnc_concat_all(kss.to_concat_expr(to_char(t.num_ordem_servico), ', ')) as num_ordem_servico
              from (
                    select po.equipamento_id
                         , po.cod_equipamento
                         , os.num_ordem_servico
                      from manutencao.v$processos_oficina po
                     inner join manutencao.v$ordem_servico os
                             on os.ordem_servico_id = po.ordem_servico_id
                     where po.cod_pessoa_oficina = #session.cod_pessoa#
                       and po.execucao_id is not null
                       and po.executada = 0
                       and po.cod_pessoa_principal = #arguments.cod_pessoa_principal#
                     group by po.equipamento_id, po.cod_equipamento, os.num_ordem_servico
                   ) t
             group by t.equipamento_id, t.cod_equipamento
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
	<!--- 
	-- PROPSITO 
	-- Busca os recursos de processos que no possuem execuo atribudas 
	-- NOTAS EXPLICATIVAS
	-- ANDERSON - 10/08/2009 - EDITADO
	--->
	<cffunction name="get_recurso_processo_sem_execucao" returntype="query" access="remote">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select distinct r.cod_pessoa
                 , pf.cliente as nome_funcionario
              from manutencao.v$recurso r
             inner join kss.v$pessoa pf
                     on pf.cod_pessoa = r.cod_pessoa
             where 1 = 1
               and not exists (select 'x'
                                 from manutencao.v$ordem_servico os
                                inner join manutencao.v$os_atividade oa
                                        on oa.ordem_servico_id = os.ordem_servico_id
                                inner join manutencao.v$os_processo_atividade opa
                                        on opa.controle_id_atividade = oa.controle_id
                                inner join manutencao.v$os_processo_execucao op
                                        on opa.controle_id_processo = op.controle_id
                                where op.cod_pessoa_principal = pf.cod_pessoa
                                  and op.data_termino is null)
               and exists (select 'x'
                             from manutencao.v$recurso_oficina ro
                            inner join manutencao.v$recurso r2
                                    on r2.recurso_id = ro.recurso_id
                            where r2.cod_pessoa = r.cod_pessoa
                              and ro.cod_pessoa_oficina = #session.cod_pessoa#)
             order by nome_funcionario
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca processo
	-- NOTAS EXPLICATIVAS
	-- GUTO 03/08/2006
	--->
	<cffunction name="get_processo" returntype="query" access="remote">
		<cfargument name="processo_id" required="no" default="">
		<cfargument name="titulo" required="no" default="">
		<cfargument name="titulo_full" required="no" default="">
		<cfargument name="sem_detalhamento" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select p.processo_id, p.titulo, 
				   <cfif arguments.sem_detalhamento eq 0>to_char(p.detalhamento) as detalhamento, </cfif>
				   to_char(p.tempo_execucao)  as tempo_execucao,
 	            trim(to_char(extract( day from p.tempo_execucao) + extract( hour from p.tempo_execucao),'00')) as tempo_execucao_horas,
               trim(to_char(extract( minute from p.tempo_execucao),'00')) as tempo_execucao_minutos
			  from manutencao.v$processo p
		     where 1=1
 			  <cfif Len(Trim(arguments.processo_id))>
				and p.processo_id = #arguments.processo_id#
			  </cfif>
			  <cfif Len(Trim(arguments.titulo))>
				and upper(p.titulo) like upper('%#arguments.TITULO#%')
			  </cfif>
			  <cfif Len(Trim(arguments.titulo_full))>
				and upper(p.titulo) like upper('#arguments.TITULO_full#')
			  </cfif>
			  order by p.titulo
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>	
	<!--- 
	-- PROPSITO 
	-- Busca processo recurso
	-- NOTAS EXPLICATIVAS
	-- GUTO 03/08/2006
	--->
	<cffunction name="get_processo_recurso" returntype="query" access="remote">
		<cfargument name="processo_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select item_id, processo_id, especialidade_id, quantidade, nivel_id, percentual_participacao,
											(select kss.fnc_concat_all(kss.to_concat_expr(nivel_id,',')) 
														from manutencao.v$recurso_nivel rn
													where rn.nivel_id <= p.nivel_id) as niveis_permitidos,
											(select count(*)
														from manutencao.v$processo_recurso pr
													where pr.processo_id = p.processo_id) as num_funcionarios													
						from manutencao.v$processo_recurso p 
			    where 1=1
 			  <cfif Len(Trim(arguments.processo_id))>
	 	  		and p.processo_id = #arguments.processo_id#
			  </cfif>
			  order by p.processo_id
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca recursos que podem executar o processo
	-- NOTAS EXPLICATIVAS
	-- GUTO 17/10/2007
	--->
	<cffunction name="get_recursos_processo" returntype="query" access="remote">
		<cfargument name="processo_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
              select distinct r.recurso_id, 
                   r.cod_pessoa, pf.cliente as nome_funcionario,
                   oper.pkg_global.fnc_get_cod_funcionario(r.cod_pessoa) as cod_funcionario,
                   r.especialidade_id, 
                   re.descricao as especialidade, 
                   r.nivel_id, rn.descricao as nivel
                from manutencao.v$recurso r
               inner join manutencao.v$recurso_especialidade re
                   on re.especialidade_id = r.especialidade_id
               inner join manutencao.v$recurso_nivel rn
                   on rn.nivel_id = r.nivel_id 
               inner join kss.v$pessoa pf
                   on pf.cod_pessoa = r.cod_pessoa
               inner join manutencao.v$processo_recurso pr
                       on pr.especialidade_id = re.especialidade_id
                      and pr.nivel_id >= rn.nivel_id
                      and pr.processo_id in (#arguments.processo_id#)
                 where 1=1
                           and re.especialidade_id in (select especialidade_id
                                                         from manutencao.v$processo_recurso p 
                                                        where 1=1
                                                          and p.processo_id in (#arguments.processo_id#))
                  order by nome_funcionario
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>    
	<!--- 
	-- PROPSITO 
	-- Busca POSIES
	-- NOTAS EXPLICATIVAS
	-- GUTO 21/09/2006
	--->
	<cffunction name="get_equipamento_posicao" returntype="query" access="remote">
		<cfargument name="posicao_id" required="no" default="">
		<cfargument name="posicao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select posicao_id, posicao
			  from manutencao.v$equipamento_posicao p
  		     where 1=1
 			  <cfif Len(Trim(arguments.posicao_id))>
				and p.posicao_id = #arguments.posicao_id#
			  </cfif>
 			  <cfif Len(Trim(arguments.posicao))>
				and upper(p.posicao) like upper('%#arguments.posicao#%')
			  </cfif>
			  order by p.posicao
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>	
	<!--- 
	-- PROPSITO 
	-- Busca modelos de equipamentos
	-- NOTAS EXPLICATIVAS
	-- ARLEN 06/10/2006
	--->
	<cffunction name="get_equipamento_modelo" returntype="query" access="remote">
		<cfargument name="modelo_id" required="no" default="">
		<cfargument name="descricao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select /*+ORDERED*/ em.controle_id, em.modelo_id, em.equipamento_id, 
				       m.descricao, e.cod_equipamento, 
                       to_char(em.data_inicial,'dd/mm/yyyy') as data_inicial, 
                       to_char(em.data_final,'dd/mm/yyyy') as data_final,
						 md.material
				  from manutencao.v$equipamento_modelo em
				 inner join manutencao.v$modelo m
				          on em.modelo_id = m.modelo_id 
				  inner join almoxarifado.v$equipamento e 
				 	       on em.equipamento_id = e.equipamento_id
              inner join almoxarifado.v$material_dados md
				          on md.material_id = e.material_id							 
		    	  where 1=1
 			  <cfif Len(Trim(arguments.modelo_id))>
				and em.modelo_id = #arguments.modelo_id#
			  </cfif>
			  <cfif Len(Trim(arguments.descricao))>
			 	and upper(e.cod_equipamento) like upper('%#arguments.descricao#%')
			  </cfif>
 			  order by em.controle_id
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca tipos de atividades
	-- GUTO 16/09/2006
	--->		
	<cffunction name="get_atividade_tipo" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select a.tipo_id, a.nome, a.descricao 
			  from manutencao.v$atividade_tipo a
			order by a.nome
  		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca tipos de oficina
	-- GUTO 16/09/2006
	--->		
	<cffunction name="get_tipo_oficina" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select oficina_tipo_id, descricao, num_modalidade
              from manutencao.v$oficina_tipo t
  		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
		
	<!--- 
	-- PROPSITO 
	-- Busca as atividades
	-- CRISTOFER  10/08/2006
	--->		
	<cffunction name="get_atividade" access="remote" returntype="query" output="true">
		<cfargument name="cod_atividade"  required="no" default="">
		<cfargument name="titulo" 			 required="no" default="">
		<cfargument name="atividade_id" 	 required="no" default="">
		<cfargument name="importancia" 	 required="no" default="">
		<cfargument name="grupo_id" 		 required="no" default="">
		<cfargument name="tabela_id" 		 required="no" default="">
      <cfargument name="situacao_ativo" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
         select a.atividade_id
              , a.cod_atividade
              , a.titulo
              , to_char(a.tempo_execucao) as tempo_execucao
              , (sysdate + a.tempo_execucao - sysdate) as tempo_execucao_total
              , trim(to_char((extract(day from a.tempo_execucao) * 24) + extract( hour from a.tempo_execucao), '00')) as tempo_execucao_horas
              , trim(to_char(extract(minute from a.tempo_execucao), '00')) as tempo_execucao_minutos
              , a.garantia_km
              , a.garantia_horas_trabalhadas
              , a.garantia_dias
              , a.garantia_lts_combustivel
              , a.alerta_km
              , a.alerta_horas_trabalhadas
              , a.alerta_dias
              , a.alerta_lts_combustivel
              , a.multiplo
              , a.grupo_id
              , a.tipo_id
              , a.compartimento_id
              , ag.descricao as grupo
              , a.importancia
              , a.verificacao
              , a.tempo_indefinido
              , a.nivel_id
              , round((sysdate + a.tempo_execucao - sysdate) * 1440) as tempo_minutos
              , (select ap.produto_id
                   from manutencao.v$atividade_produto ap
                  where ap.atividade_id = a.atividade_id
                ) as produto_id
         <cfif Len(Trim(arguments.tabela_id))>
              , t.valor
         <cfelse>
              , 0 as valor
         </cfif>
              , a.ativo         
           from manutencao.v$atividade a
           left join manutencao.v$atividade_grupo ag
                  on ag.grupo_id = a.grupo_id
         <cfif Len(Trim(arguments.tabela_id))>
          inner join (select tpa.atividade_id
                           , tpa.valor
                        from compras.v$tabela_preco_atividade tpa
                       where tpa.tabela_id = #arguments.tabela_id#
                         and tpa.data_vigencia = (select max(tpa2.data_vigencia)
                                                    from compras.v$tabela_preco_atividade tpa2
                                                   where tpa2.atividade_id = tpa.atividade_id
                                                     and tpa2.tabela_id = tpa.tabela_id
                                                     and tpa2.data_vigencia <= sysdate)
                     ) t
                  on t.atividade_id = a.atividade_id
         </cfif>             
          where 1 = 1
         <cfif len(trim(arguments.titulo))>
            and upper(kss.pkg_string.fnc_string_clean(a.titulo)) like upper(kss.pkg_string.fnc_string_clean('%#arguments.titulo#%'))
         </cfif>
         <cfif len(trim(arguments.COD_ATIVIDADE))>
            and upper(a.cod_atividade) like upper('%#arguments.COD_ATIVIDADE#%')
         </cfif>
         <cfif len(trim(arguments.atividade_id))>
            and a.atividade_id in (#arguments.atividade_id#)
         </cfif>
         <cfif len(trim(arguments.importancia))>
            and a.importancia = #arguments.importancia#
         </cfif>
         <cfif len(trim(arguments.grupo_id))>
            and a.grupo_id = #arguments.grupo_id#
         </cfif>
         <cfif len(trim(arguments.situacao_ativo)) and arguments.situacao_ativo eq 1>
            and a.ativo = 1
         </cfif>
          order by ag.descricao, a.titulo         
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca dependencia entre as atividades
	-- GUTO 30/10/2006 
	--->		
	<cffunction name="get_atividade_dependencia" access="remote" returntype="query" output="true">
		<cfargument name="atividade_id_principal" required="no" default="">
		<cfargument name="atividade_id_dependente" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ad.atividade_id_principal, ad.atividade_id_dependente, ad.obrigatoria,
					 a1.titulo as atividade_principal, a2.titulo as atividade_dependente,
					 a1.cod_atividade as cod_atividade_principal, a2.cod_atividade as cod_atividade_dependente
			  from manutencao.v$atividade_dependencia ad
			 inner join manutencao.v$atividade a1
						on a1.atividade_id = ad.atividade_id_principal
			 inner join manutencao.v$atividade a2
						on a2.atividade_id = ad.atividade_id_dependente
			 where 1=1
			   <cfif Len(Trim(arguments.atividade_id_principal))>
				   and ad.atividade_id_principal = #arguments.atividade_id_principal#
				</cfif>
			   <cfif Len(Trim(arguments.atividade_id_dependente))>
				   and ad.atividade_id_dependente = #arguments.atividade_id_dependente#
				</cfif>
  		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
	<!--- 
	-- PROPSITO 
	-- Busca atividades conjugadas
	-- GUTO 11/07/2008
	--->		
	<cffunction name="get_atividade_conjugada" access="remote" returntype="query" output="true">
		<cfargument name="atividade_id_principal" required="no" default="">
		<cfargument name="atividade_id_conjugada" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ad.atividade_id_principal, ad.atividade_id_conjugada, ad.baixa_obrigatoria,
                   a1.titulo as atividade_principal, a2.titulo as atividade_conjugada,
                   a1.cod_atividade as cod_atividade_principal, a2.cod_atividade as cod_atividade_conjugada,
				   ad.garantia_km, ad.garantia_horas_trabalhadas, ad.garantia_dias, ad.garantia_lts_combustivel,
				   ad.alerta_km, ad.alerta_horas_trabalhadas, ad.alerta_dias, ad.alerta_lts_combustivel
              from manutencao.v$atividade_conjugada ad
             inner join manutencao.v$atividade a1
                     on a1.atividade_id = ad.atividade_id_principal
             inner join manutencao.v$atividade a2
                     on a2.atividade_id = ad.atividade_id_conjugada
             where 1=1
		     <cfif Len(Trim(arguments.atividade_id_principal))>
               and ad.atividade_id_principal = #arguments.atividade_id_principal#
             </cfif>
             <cfif Len(Trim(arguments.atividade_id_conjugada))>
               and ad.atividade_id_conjugada = #arguments.atividade_id_conjugada#
             </cfif>
  		</cfquery>
		<cfreturn qr_result>		
	</cffunction>    
	
	<!--- 
	-- PROPSITO 
	-- Busca atividade tipos de oficina
	-- GUTO 16/09/2006
	--->		
	<cffunction name="get_atividade_oficina_tipo" access="remote" returntype="query" output="true">
		<cfargument name="atividade_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select atividade_id, oficina_tipo_id as tipo_id
			  from manutencao.v$atividade_oficina_tipo
			 where atividade_id = #arguments.atividade_id#
   		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
		
	<!--- 
	-- PROPSITO 
	-- Busca os processos da atividade
	-- CRISTOFER  11/08/2006
	--->		
	<cffunction name="get_atividade_processo" access="remote" returntype="query">
		<cfargument name="atividade_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ap.item_id,
				   ap.item_pai,
				   ap.ordem,
				   ap.atividade_id,
				   ap.processo_id,
				   p.titulo as processo,
				   ap.user_insert,
				   ap.date_insert,
				   ap.user_update,
				   ap.date_update,
				   ap.site
			  from manutencao.v$atividade_processo ap
			 inner join manutencao.v$processo p
			         on p.processo_id = ap.processo_id
			 where ap.atividade_id in (#arguments.atividade_id#)
			 start with ap.item_pai is null
			connect by prior ap.item_id = ap.item_pai
			order siblings by ap.ordem
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca os processos da atividade detalhado
	-- CRISTOFER  11/08/2006
	--->		
	<cffunction name="get_atividade_processos" access="remote" returntype="query">
		<cfargument name="atividade_id" required="no">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select a.atividade_id, a.titulo as atividade, a.cod_atividade,
					 manutencao.to_tempo_execucao(manutencao.sum_dsinterval(nvl(p.tempo_execucao,a.tempo_execucao)) over(partition by a.atividade_id order by a.atividade_id)).retorno as tempo_total,
					 p.processo_id, p.titulo as processo,  
					 manutencao.to_tempo_execucao(nvl(p.tempo_execucao,a.tempo_execucao)).retorno as tempo_execucao,
					 ap.ordem, ap.item_id
			  from manutencao.v$atividade a
			 left join manutencao.v$atividade_processo ap
						on ap.atividade_id = a.atividade_id
			 left join manutencao.v$processo p
						on p.processo_id = ap.processo_id         
			 order by a.atividade_id, ap.ordem
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca as posices da atividade
	-- CRISTOFER  11/08/2006
	--->		
	<cffunction name="get_atividade_posicao" access="remote" returntype="query" output="true">
		<cfargument name="atividade_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ap.posicao_id,
				   ap.atividade_id,
				   ep.posicao
			  from manutencao.v$atividade_posicao ap
			 inner join manutencao.v$equipamento_posicao ep
			         on ep.posicao_id = ap.posicao_id
			 where atividade_id in (#arguments.atividade_id#) 
		</cfquery>
		<cfreturn qr_result>		
	</cffunction> 

	<!--- 
	-- PROPSITO 
	-- Busca tipos de periodicidade para a tabela de manuteno
	-- NOTAS EXPLICATIVAS
	-- GUTO 22/08/2006
	--->
	<cffunction name="get_periodicidade" returntype="query" access="remote">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select periodicidade_id, descricao
			  from manutencao.v$periodicidade
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction> 	
	<!--- 
	-- PROPSITO 
	-- Busca tabelas de manuteno
	-- NOTAS EXPLICATIVAS
	-- GUTO 22/08/2006
	--->
	<cffunction name="get_tabela_manutencao" returntype="query" access="remote">
		<cfargument name="tabela_id" required="no" default="" />
		<cfargument name="titulo" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select replace(substr(sys_connect_by_path(replace(nome,'/','@@'), '/'),2),'@@','/') as path, 
				   nome || ' [' || replace(substr(sys_connect_by_path(replace(nome,'/','@@'), '/'),2),'@@','/')  || ']' as tabelas,
				   nome, substr(sys_connect_by_path(tabela_id, ','),2) as lista_tabelas, 
                   nome, substr(sys_connect_by_path('|' || tabela_id || '|', ','),2) as lista_tabela_separador,
				   descricao, tabela_id, tabela_pai, obrigatoria,
				   intervalo_km, intervalo_dias, 
				   intervalo_horas_trabalhadas, intervalo_lts_combustivel, alerta_km, 
				   alerta_dias, alerta_horas_trabalhadas, alerta_lts_combustivel,
				   verificacao_pneus, atualiza_revisao, exige_lavagem,tipo_execucao
			  from manutencao.v$tabela_manutencao
			 where 1=1
			 <cfif Len(Trim(arguments.tabela_id))>
			   and tabela_id = #arguments.tabela_id#
			 </cfif>
			 <cfif Len(Trim(arguments.titulo))>
			   and upper(nome) like upper('%#arguments.titulo#%')
			 </cfif>
			 start with tabela_pai = 0
		    connect by prior tabela_id = tabela_pai
		    order siblings by tabela_pai
   		</cfquery>		
		<cfreturn qr_result>
	</cffunction> 		

	<!--- 
	-- PROPSITO 
	-- Busca tabelas de manuteno (PERIODICIDADE)
	-- NOTAS EXPLICATIVAS
	-- GUTO 12/09/2006
	--->
	<cffunction name="get_tabela_periodicidade" returntype="query" access="remote">
		<cfargument name="tabela_id" required="yes"/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select tp.item_id, tp.tabela_id, tp.periodicidade_id, 
                   p.descricao, tp.valor, tp.tolerancia
			  from manutencao.v$tabela_periodicidade tp
		     inner join manutencao.v$periodicidade p
				     on p.periodicidade_id = tp.periodicidade_id
			 where 1=1
			 <cfif Len(Trim(arguments.tabela_id))>
			   and tp.tabela_id = #arguments.tabela_id#
			 </cfif>
   		</cfquery>		
		<cfreturn qr_result>
	</cffunction> 			

	<!--- 
	-- PROPSITO 
	-- Busca tabelas de manuteno vinculadas a um modelo
	-- NOTAS EXPLICATIVAS
	-- GUTO 12/09/2006
	--->
	<cffunction name="get_tabela_modelo" returntype="query" access="remote">
		<cfargument name="tabela_id" required="no" default=""/>
		<cfargument name="modelo_id" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select tm.tabela_id, tm.modelo_id, m.descricao as modelo,
					 tma.nome as tabela
			  from manutencao.v$tabela_modelo tm
			 inner join manutencao.v$modelo m
						on m.modelo_id = tm.modelo_id
			 inner join manutencao.v$tabela_manutencao tma
						on tma.tabela_id = tm.tabela_id         
			 where 1=1
			 <cfif Len(Trim(arguments.tabela_id))>
			   and tm.tabela_id = #arguments.tabela_id#
			 </cfif>
			 <cfif Len(Trim(arguments.modelo_id))>
			   and tm.modelo_id = #arguments.modelo_id#
			 </cfif>
   		</cfquery>		
		<cfreturn qr_result>
	</cffunction> 		
	
	<!--- 
	-- PROPSITO 
	-- Busca tabelas de manuteno (ATIVIDADE)
	-- NOTAS EXPLICATIVAS
	-- GUTO 12/09/2006
	--->
	<cffunction name="get_tabela_atividade" returntype="query" access="remote">
		<cfargument name="tabela_id" required="yes"/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ta.tabela_id, ta.atividade_id, a.titulo,
					round((sysdate + a.tempo_execucao - sysdate) * 1440) as tempo_minutos
			  from manutencao.v$tabela_atividade ta
			 inner join manutencao.v$atividade a
		  		     on a.atividade_id = ta.atividade_id
	      	 where 1=1
			 <cfif Len(Trim(arguments.tabela_id))>
			   and ta.tabela_id = #arguments.tabela_id#
			 </cfif>
		     order by ta.tabela_id               
   		</cfquery>		
		<cfreturn qr_result>
	</cffunction> 	
	
	<!--- 
	-- PROPSITO 
	-- Busca posies que um material pode assumir
	-- NOTAS EXPLICATIVAS
	-- GUTO 12/09/2006
	--->
	<cffunction name="get_material_posicao" returntype="query" access="remote">
		<cfargument name="material_id" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct mp.material_id, ep.posicao_id, ep.posicao
			  from manutencao.v$material_posicao mp
			 inner join manutencao.v$equipamento_posicao ep
						 on ep.posicao_id = mp.posicao_id
			 where mp.material_id in (
						select m.material_id
						  from almoxarifado.v$material m
					 start with m.material_id = #arguments.material_id#
					connect by m.material_id = prior m.material_pai)
		     order by ep.posicao
   		</cfquery>		
		<cfreturn qr_result>
	</cffunction> 
    
	<!--- 
	-- PROPSITO 
	-- Busca dados completos do material atraves do codigo
	-- NOTAS EXPLICATIVAS
	-- GUTO 20/09/2006
	--->
 <cffunction name="get_material_dados_por_codigo" returntype="query" access="remote">
      <cfargument name="material_id" required="no" default=""/>
      <cfargument name="cod_material" required="no" default=""/>
      <cfargument name="material" required="no" default=""/>
      <cfargument name="atributo" required="no" default=""/>
      <cfargument name="com_saldo_estoque" required="no" default="0"/>
      <cfargument name="cod_pessoa_filial" required="no" default=""/>
      <cfargument name="estoque" required="no" default="1"/>
      <cfargument name="niv_arvore" required="no" default=""/>
      <cfargument name="ativo" required="no" default="1"/>
      <cfargument name="tabela_id" required="no" default=""/>
      	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
         select material_id
              , material_pai
              , cod_material
              , titulo
              , descricao
              , compoe_descricao
              , estoque
              , unidade_estoque
              , unidade_comercializacao
              , identificado
              , cod_genuino
              , cod_fabricante
              , cod_paralelo
              , material
              , produto_id
              , valor
              , almoxarifado.pkg_almoxarifado.fnc_estoque_material(material_id, <cfif Len(Trim(arguments.cod_pessoa_filial))>#arguments.cod_pessoa_filial#<cfelse>#session.cod_pessoa#</cfif>, sysdate) as saldo_estoque
              , almoxarifado.pkg_almoxarifado.fnc_get_atributo_mat(<cfif Len(Trim(arguments.cod_pessoa_filial))>#arguments.cod_pessoa_filial#<cfelse>#session.cod_pessoa#</cfif>,material_id,12) as localizacao
              , exige_devolucao 
              , qtde_maxima 
              , qtde_minima
           from (
						<cfif Len(Trim(arguments.cod_material))>
							select m.material_id
								 , m.material_pai
								 , m.cod_material
								 , m.titulo
								 , m.descricao
								 , m.compoe_descricao
								 , m.estoque
								 , m.unidade_estoque
								 , m.unidade_comercializacao
								 , m.identificado
								 , nvl(almoxarifado.pkg_almoxarifado.fnc_get_atributo_mat(m.material_id, 29),0) as exige_devolucao
                                 , almoxarifado.pkg_almoxarifado.fnc_get_atributo_mat(m.material_id, 9) cod_genuino
								 , almoxarifado.pkg_almoxarifado.fnc_get_atributo_mat(m.material_id, 10) cod_fabricante
								 , almoxarifado.pkg_almoxarifado.fnc_get_atributo_mat(m.material_id, 11) cod_paralelo
								 , descricao_completa as material
                                 , (select mp.produto_id
                                      from almoxarifado.v$material_produto mp
                                     where mp.material_id = m.material_id) as produto_id
                                 , (select max(level)
                                      from almoxarifado.v$material t
                                     start with t.material_id = m.material_id
                                     connect by prior t.material_id = t.material_pai) as niv_arvore
							     <cfif Len(Trim(arguments.tabela_id))>
                                 , t.valor
                                 <cfelse>
                                 , 0 as valor
                                 </cfif>
                                 , m.qtde_maxima
                                 , m.qtde_minima
							  from almoxarifado.v$material m
							 inner join almoxarifado.v$material_atributo ma
										on ma.material_id = m.material_id
							<cfif Len(Trim(arguments.tabela_id))>
                             inner join (select tpm.material_id
                                              , tpm.valor
                                           from compras.v$tabela_preco_material tpm
                                          where tpm.tabela_id = #arguments.tabela_id#
                                            and tpm.data_vigencia = (select max(tpm2.data_vigencia)
                                                                       from compras.v$tabela_preco_material tpm2
                                                                      where tpm2.material_id = tpm.material_id
                                                                        and tpm2.tabela_id = tpm.tabela_id
                                                                        and tpm2.data_vigencia <= sysdate
                                                                    )
                                        ) t
                                     on t.material_id = m.material_id
                            </cfif>
							 where 1 = 1
						        and ma.ATRIBUTO_ID in (9,10,11)
						        and upper(ma.valor_padrao) like upper('#arguments.cod_material#%')
                           <cfif arguments.estoque eq 1>
                                and m.estoque = 1
                           </cfif>
                           <cfif Len(Trim(arguments.ativo))>
                           and m.ativo = #arguments.ativo#
                           </cfif> 
						   <cfif Len(Trim(arguments.material))>
                                and upper(kss.pkg_string.fnc_string_clean(descricao_completa)) like upper('%#arguments.material#%')
                           </cfif>
							union all
						</cfif>
						select m.material_id
							 , m.material_pai
							 , m.cod_material
							 , m.titulo
							 , m.descricao
							 , m.compoe_descricao
							 , m.estoque
							 , m.unidade_estoque
							 , m.unidade_comercializacao
							 , m.identificado
							 , nvl(almoxarifado.pkg_almoxarifado.fnc_get_atributo_mat(m.material_id, 29),0) as exige_devolucao
							 , almoxarifado.pkg_almoxarifado.fnc_get_atributo_mat(m.material_id, 9) cod_genuino
							 , almoxarifado.pkg_almoxarifado.fnc_get_atributo_mat(m.material_id, 10) cod_fabricante
							 , almoxarifado.pkg_almoxarifado.fnc_get_atributo_mat(m.material_id, 11) cod_paralelo
							 , descricao_completa as material
                             , (select mp.produto_id
                                  from almoxarifado.v$material_produto mp
                                 where mp.material_id = m.material_id) as produto_id
                             , (select max(level)
                                  from almoxarifado.v$material t
                                 start with t.material_id = m.material_id
                               connect by prior t.material_id = t.material_pai) as niv_arvore
                             <cfif Len(Trim(arguments.tabela_id))>
                             , t.valor
                             <cfelse>
                             , 0 as valor
                             </cfif>
                             , m.qtde_maxima
                             , m.qtde_minima
						  from almoxarifado.v$material m
						<cfif Len(Trim(arguments.tabela_id))>
                         inner join (select tpm.material_id
                                          , tpm.valor
                                       from compras.v$tabela_preco_material tpm
                                      where tpm.tabela_id = #arguments.tabela_id#
                                        and tpm.data_vigencia = (select max(tpm2.data_vigencia)
                                                                   from compras.v$tabela_preco_material tpm2
                                                                  where tpm2.material_id = tpm.material_id
                                                                    and tpm2.tabela_id = tpm.tabela_id
                                                                    and tpm2.data_vigencia <= sysdate
                                                                )
                                    ) t
                                 on t.material_id = m.material_id
                        </cfif>
						 where 1 = 1
                           <cfif arguments.estoque eq 1>
                           and m.estoque = 1
                           </cfif>
						   <cfif Len(Trim(arguments.material))>
                           and upper(kss.pkg_string.fnc_string_clean(descricao_completa)) like upper(kss.pkg_string.fnc_string_clean('%#Replace(arguments.material, ' ', '%', 'all')#%'))
                           </cfif>
						   <cfif Len(Trim(arguments.cod_material))>
						   and upper(m.cod_material) like upper('#arguments.cod_material#%')
						   </cfif>
                           <cfif Len(Trim(arguments.ativo))>
                           and m.ativo = #arguments.ativo#
                           </cfif> 
							)
						 where 1=1
						<cfif Len(Trim(arguments.material_id))>
						   and material_id = #arguments.material_id# 
						</cfif>
                        <cfif Len(Trim(arguments.niv_arvore))>
						   and niv_arvore <= #arguments.niv_arvore#
						</cfif>
					    <cfif arguments.com_saldo_estoque neq 0>
                            and almoxarifado.pkg_almoxarifado.fnc_estoque_material(material_id, <cfif Len(Trim(arguments.cod_pessoa_filial))>#arguments.cod_pessoa_filial#<cfelse>#session.cod_pessoa#</cfif>, sysdate) > 0
                        </cfif>
                         order by material
		</cfquery>
		<cfreturn qr_result>
	</cffunction> 	
	
	<!--- 
	-- PROPSITO 
	-- Busca dados completos do material
	-- NOTAS EXPLICATIVAS
	-- GUTO 20/09/2006
	--->
	<cffunction name="get_material_dados" returntype="query" access="remote">
		<cfargument name="material_id" required="no" default=""/>
		<cfargument name="cod_material" required="no" default=""/>
		<cfargument name="estoque" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select material_id, material_pai, cod_material, titulo, descricao, 
				   compoe_descricao, estoque, unidade_estoque, unidade_comercializacao, identificado, 
				   material, cod_genuino, cod_fabricante, cod_paralelo
			  from almoxarifado.v$material_dados m
			 where 1=1
			 <cfif Len(Trim(arguments.material_id))>
			   and m.material_id = #arguments.material_id#
			 </cfif>
			 <cfif Len(Trim(arguments.cod_material))>
			   and ( upper(m.cod_material) like upper('#arguments.cod_material#%')
			      or upper(m.cod_genuino) like upper('#arguments.cod_material#%')
				  or upper(m.cod_fabricante) like upper('#arguments.cod_material#%')
				  or upper(m.cod_paralelo) like upper('#arguments.cod_material#%') )
			 </cfif>
			 <cfif Len(Trim(arguments.estoque))>
			   and m.estoque = #arguments.estoque#
			 </cfif>
			 start with m.material_pai is null
			connect by prior m.material_id = m.material_pai
			order siblings by m.descricao
   		</cfquery>		
		<cfreturn qr_result>
	</cffunction> 		

	<!--- 
	-- PROPSITO 
	-- Busca materiais que controlam estoque minimo (AGRUPADOS)

	-- NOTAS EXPLICATIVAS
	-- GUTO 20/09/2006
	--->
	<cffunction name="get_materiais_controlados" returntype="query" access="remote">
		<cfargument name="material_id" required="no" default=""/>
		<cfargument name="material" required="no" default=""/>
		<cfargument name="cod_material" required="no" default=""/>
		<cfargument name="todos" required="no" default="0"/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select m.material_id, m.material_pai, m.cod_material, m.titulo, m.descricao, 
				   m.compoe_descricao, m.estoque, m.unidade_estoque, m.unidade_comercializacao, 
                   m.identificado, m.material, m.cod_genuino, m.cod_fabricante, m.cod_paralelo,
                   almoxarifado.pkg_almoxarifado.fnc_estoque_material(m.material_id, #session.cod_pessoa#, sysdate) as saldo_estoque
			  from almoxarifado.v$material_dados m
             <cfif arguments.todos eq 0>inner<cfelse>left</cfif> join almoxarifado.v$material_atributo ma
                     on m.material_id = ma.material_id
                    and ma.atributo_id = 5
			 where 1=1
			 <cfif Len(Trim(arguments.material_id))>
			   and m.material_id = #arguments.material_id#
			 </cfif>
			 <cfif Len(Trim(arguments.cod_material))>
			   and ( upper(m.cod_material) like upper('#arguments.cod_material#%')
			      or upper(m.cod_genuino) like upper('#arguments.cod_material#%')
				  or upper(m.cod_fabricante) like upper('#arguments.cod_material#%')
				  or upper(m.cod_paralelo) like upper('#arguments.cod_material#%') )
			 </cfif>
			 <cfif Len(Trim(arguments.material))>
                 and upper(kss.pkg_string.fnc_string_clean(m.material)) like upper('%#arguments.material#%')
             </cfif>
             order by m.material_id
   		</cfquery>		
		<cfreturn qr_result>
	</cffunction> 
        
	<!--- 
	-- PROPSITO 
	-- Busca equipamentos Ativos
	-- NOTAS EXPLICATIVAS
	-- GUTO 21/09/2006
	--->
	<cffunction name="get_equipamento_ativo" returntype="query" access="remote">
		<cfargument name="material_id" required="no" default=""/>
		<cfargument name="equipamento_id" required="no" default=""/>
		<cfargument name="cod_equipamento" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select e.equipamento_id, e.cod_equipamento, e.data_aquisicao, e.material_id, 
				   almoxarifado.pkg_almoxarifado.fnc_get_material_descricao(e.material_id, ' ') as material
			  from almoxarifado.v$equipamento e
			 inner join almoxarifado.v$material m
					 on m.material_id = e.material_id
			 where e.data_inativacao is null
			   and e.situacao = 1
			 <cfif Len(Trim(arguments.material_id))>
			   and e.material_id = #arguments.material_id#
			 </cfif>
			 <cfif Len(Trim(arguments.equipamento_id))>
			   and e.equipamento_id = #arguments.equipamento_id#
			 </cfif>
			 <cfif Len(Trim(arguments.cod_equipamento))>
			   and e.cod_equipamento = '#arguments.cod_equipamento#'
			 </cfif>
		     order by material
   		</cfquery>		
		<cfreturn qr_result>
	</cffunction> 

	<!--- 
	-- PROPSITO 
	-- Busca equipamentos no estoque
	-- NOTAS EXPLICATIVAS
	-- GUTO 21/09/2006
	--->
	<cffunction name="get_equipamentos_estoque" returntype="query" access="remote">
		<cfargument name="material_id" required="no" default=""/>
		<cfargument name="cod_pessoa_filial" required="no" default=""/>
		<cfargument name="transferencia" required="no" default="0"/>
		<cfargument name="cod_equipamento" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select e.cod_equipamento, e.equipamento_id, max(el.data_entrada) data_entrada,
			       almoxarifado.pkg_almoxarifado.fnc_get_material_descricao(e.material_id, ' ') as material
			  from almoxarifado.v$equipamento e
			 inner join almoxarifado.v$equipamento_localizacao el
						on el.equipamento_id = e.equipamento_id
			  where el.data_saida is null
                and e.data_inativacao is null
             <cfif arguments.transferencia eq 0>
                and not exists (select 'x'
                                  from manutencao.v$equipamento_analise ea
                                 where ea.equipamento_id = e.equipamento_id
                                   and ea.data_analise is null)
             </cfif>         
			 <cfif Len(Trim(arguments.cod_equipamento))>
			   and e.cod_equipamento = '#arguments.cod_equipamento#'
			 </cfif>
			 <cfif Len(Trim(arguments.material_id))>
			   and e.material_id = #arguments.material_id#
			 </cfif>             
			 <cfif  Len(Trim(arguments.cod_pessoa_filial))>
             	and el.cod_pessoa_filial = #arguments.cod_pessoa_filial#
			 </cfif>
			 group by e.cod_equipamento, e.equipamento_id,  almoxarifado.pkg_almoxarifado.fnc_get_material_descricao(e.material_id, ' ')
		     order by e.cod_equipamento
   		</cfquery>		
		<cfreturn qr_result>
	</cffunction> 
		
	<!--- 
	-- PROPSITO 
	-- Busca compartimentos do veculo
	-- NOTAS EXPLICATIVAS
	-- ARLEN 04/10/2006
	--->
	<cffunction name="get_atividade_compartimento" returntype="query" access="remote">
		<cfargument name="compartimento_id" required="no" default="">
		<cfargument name="descricao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
 			 select compartimento_id, descricao, ordem 
			   from manutencao.v$atividade_compartimento
			  where 1=1
  			  <cfif Len(Trim(arguments.compartimento_id))>
			 	and compartimento_id = #arguments.compartimento_id#
			  </cfif>
  			  <cfif Len(Trim(arguments.descricao))>
			 	and upper(kss.pkg_string.fnc_string_clean(descricao)) like upper('%#arguments.descricao#%')
			  </cfif>
			  order by ordem 
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca grupo de atividades
	-- NOTAS EXPLICATIVAS
	-- ARLEN 05/10/2006
	--->
	<cffunction name="get_atividade_grupo" returntype="query" access="remote">
		<cfargument name="grupo_id" required="no" default="">
		<cfargument name="descricao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
 			 select grupo_id, descricao 
			   from manutencao.v$atividade_grupo
			  where 1=1
  			  <cfif Len(Trim(arguments.grupo_id))>
			 	and grupo_id = #arguments.compartimento_id#
			  </cfif>
  			  <cfif Len(Trim(arguments.descricao))>
			 	and upper(descricao) like upper('%#arguments.descricao#%')
			  </cfif>
			  order by descricao
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca servicos vencidos ou a vencer para a OS
	-- NOTAS EXPLICATIVAS
	-- GUTO 04/10/2006
	--->
	<cffunction name="get_veiculo_atividade" returntype="query" access="remote">
		<cfargument name="placa" required="no" default="">
		<cfargument name="equipamento_id" required="no" default="">
		<cfargument name="atividade_id" required="no" default="">
		<cfargument name="nao_executada" required="no" default="">
		<cfargument name="km" required="no" default="">
		<cfset v_composicao = this.get_composicao(placa = arguments.PLACA, equipamento_id = arguments.EQUIPAMENTO_ID)>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select r.equipamento_id, r.controle_id, r.cod_equipamento, r.atividade_id, r.posicao_id, r.posicao, r.cod_atividade, 
				   r.titulo, r.data_previsao, r.km_previsao, r.importancia, r.manut_atividade.alerta_km as alerta_km,
				   r.manut_atividade.alerta_dias as alerta_dias, r.dias, 
			       manutencao.to_veiculo_km(r.cod_equipamento,r.data_previsao,r.data_previsao).km_data_inicial km_real,
					   case
						  when r.ordem_servico_id_execucao is null
						   and (
                               (r.veiculo_km.km_data_inicial > r.km_previsao and r.manut_atividade.garantia_km > 0)
							   <cfif Len(Trim(arguments.km))>
							   or (r.km_previsao < #arguments.km# and r.manut_atividade.garantia_km > 0)
							   </cfif>
							   or (sysdate > r.data_previsao and r.manut_atividade.garantia_dias > 0)) then 'Vencido'
						  when r.ordem_servico_id_execucao is null
						   and ((r.veiculo_km.km_data_inicial + r.manut_atividade.alerta_km > r.km_previsao and r.manut_atividade.garantia_km > 0)
							   or (sysdate + r.manut_atividade.alerta_dias > r.data_previsao and r.manut_atividade.garantia_dias > 0)) then 'A Vencer'
						  when r.ordem_servico_id_execucao is null
						   and (r.veiculo_km.km_data_inicial <= r.km_previsao
							   or sysdate <= r.data_previsao) then 'Ok'
					   else 'Executada' end status,
					   case
						  when r.ordem_servico_id_execucao is null
						   and (
                               (r.veiculo_km.km_data_inicial > r.km_previsao and r.manut_atividade.garantia_km > 0)
							   <cfif Len(Trim(arguments.km))>
							   or (r.km_previsao < #arguments.km# and r.manut_atividade.garantia_km > 0)
							   </cfif> 
							   or (sysdate > r.data_previsao and r.manut_atividade.garantia_dias > 0)) then -2
						  when r.ordem_servico_id_execucao is null
						   and (r.veiculo_km.km_data_inicial + r.manut_atividade.alerta_km > r.km_previsao 
							   or (sysdate + r.manut_atividade.alerta_dias > r.data_previsao and r.manut_atividade.garantia_dias > 0)) then -1
						  when r.ordem_servico_id_execucao is null
						   and (r.veiculo_km.km_data_inicial <= r.km_previsao
							   or sysdate <= r.data_previsao) then 1
					   else 0 end status_id,
					   r.km_previsao - r.veiculo_km.km_data_inicial as km_previsto
			  from (
						select /*+ index(a,PKC_ATE) */ e.equipamento_id, ea.controle_id, e.cod_equipamento, a.atividade_id, ap.posicao_id, nvl(ap.posicao, 'nica') as posicao, 
						   a.cod_atividade, a.titulo, ea.data_previsao, ea.km_previsao, 
						   a.importancia, ea.ordem_servico_id_execucao,
                           manutencao.to_manut_atividade(a.atividade_id) as manut_atividade,
                           manutencao.to_veiculo_km(e.cod_equipamento, sysdate, sysdate) as veiculo_km,
                           decode(manutencao.to_manut_atividade(ea.atividade_id).garantia_dias,0,0,round(ea.data_previsao - sysdate)) as dias
							  from manutencao.v$equipamento_atividade ea
							 inner join manutencao.v$atividade a
									 on a.atividade_id = ea.atividade_id
							 inner join almoxarifado.v$equipamento e
									 on e.equipamento_id = ea.equipamento_id
							 left join manutencao.v$equipamento_posicao ap
									 on ea.posicao_id = ap.posicao_id
							 where 1=1
							  <cfif Len(Trim(arguments.nao_executada))>
							   and ea.ordem_servico_id_execucao is null
							   and a.verificacao = 0
							  </cfif> 
							  <cfif Len(Trim(arguments.placa)) or Len(Trim(arguments.equipamento_id))>
							   and e.equipamento_id in (#v_composicao#)
							  </cfif>
							  <cfif Len(Trim(arguments.atividade_id))>
							   and a.atividade_id = #arguments.atividade_id#
							  </cfif>
                               and ea.controle_id = (select max(ea2.controle_id)
                                                       from manutencao.v$equipamento_atividade ea2
                                                      where ea2.equipamento_id = ea.equipamento_id
                                                        and ea2.atividade_id = ea.atividade_id )
						 ) r
			  order by r.cod_equipamento, r.posicao, r.km_previsao 
		</cfquery>	
		<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca servicos executados na OS
	-- NOTAS EXPLICATIVAS
	-- WAGNER 05/12/2006
	--->
	<cffunction name="get_veiculo_atividade_os" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" required="yes" default="">
        <cfargument name="ordenar_controle_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select osa.controle_id, atv.titulo, nvl(mep.posicao, 'nica') as posicao,
                   atv.cod_atividade, 
                   manutencao.to_os_atividade(osa.controle_id).material_ok as material_ok,
                   manutencao.to_material_dados(manutencao.to_os_atividade(osa.controle_id).material_id).descricao_completa as material_utilizado,
                   manutencao.to_tempo_execucao(osa.tempo_execucao_ajustado,3).retorno as tempo_execucao,
                   case
                       when os.empresa = 1 then
                         round(manutencao.to_tempo_convertido(osa.tempo_execucao_ajustado).horas * (select sum(decode(os.empresa,1,ova.valor_empresa,ova.valor_terceiro))
                                                                                                    from manutencao.mv$os_valor_atividade ova
                                                                                                   where ova.ordem_servico_id = os.ordem_servico_id
                                                                                                     and ova.atividade_id = osa.atividade_id
                                                                                                     and ova.posicao_id = osa.posicao_id),2)
                       else 0
                   end valor,
                   case 
                     when osa.gerada_por = 1 then 'Sistema'
                     when osa.gerada_por = 2 then 'Solicitao do Motorista'
                     when osa.gerada_por = 3 then 'Check List'
                   else '' end gerada_por, os.observacao                       
              from manutencao.v$ordem_servico os
          inner join manutencao.v$os_atividade osa
                        on osa.ordem_servico_id = os.ordem_servico_id
          inner join manutencao.v$atividade atv
              on atv.atividade_id = osa.atividade_id
           left join manutencao.v$equipamento_posicao mep
              on mep.posicao_id = osa.posicao_id
           where osa.ordem_servico_id = #arguments.ordem_servico_id#
           <cfif len(trim(arguments.ordenar_controle_id)) >
           	  order by osa.controle_id	
           </cfif>
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca materiais com a garantia vencida para a OS
	-- NOTAS EXPLICATIVAS
	-- GUTO 04/10/2006
	--->
	<cffunction name="get_veiculo_material" returntype="query" access="remote">
		<cfargument name="placa" required="no" default="">
        <cfargument name="equipamento_id" required="no" default="">
		<cfargument name="km_atual" required="no" default="">
		<cfset v_composicao = this.get_composicao(placa = arguments.placa, equipamento_id = arguments.equipamento_id)>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select r.equipamento_id, r.cod_equipamento, r.controle_id, r.material_id, r.posicao,
				   r.cod_material, r.material, r.data_previsao, r.km_previsao,
				   r.alerta_km, r.alerta_dias, r.dias, r.ordem_servico_id_desmontagem,
					   case
						  when r.km_previsao = 0 then 'Ok'
						  when r.ordem_servico_id_desmontagem is null
						   and (manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial > r.km_previsao 
							   or sysdate > r.data_previsao) then 'Vencido'
						  when r.ordem_servico_id_desmontagem is null
						   and (manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial + manutencao.to_manut_material(r.material_id).alerta_km > r.km_previsao 
							   or sysdate + manutencao.to_manut_material(r.material_id).alerta_dias > r.data_previsao) then 'A Vencer'
						  when r.ordem_servico_id_desmontagem is null
						   and (manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial <= r.km_previsao
							   or sysdate <= r.data_previsao) then 'Ok'
					   else 'Executada' end status,
					   case
						  when r.km_previsao = 0 then 1
						  when r.ordem_servico_id_desmontagem is null
						   and (manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial > r.km_previsao 
							   or sysdate > r.data_previsao) then -2
						  when r.ordem_servico_id_desmontagem is null
						   and (manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial + manutencao.to_manut_material(r.material_id).alerta_km > r.km_previsao 
							   or sysdate + manutencao.to_manut_material(r.material_id).alerta_dias > r.data_previsao) then -1
						  when r.ordem_servico_id_desmontagem is null
						   and (manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial <= r.km_previsao
							   or sysdate <= r.data_previsao) then 1
					   else 0 end status_id,
					   r.km_previsao - manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial as km_previsto,
						cod_equipamento_identificado
			  from (select e.equipamento_id, e.cod_equipamento, em.controle_id, nvl(ap.posicao, 'nica') as posicao, 
						   		m.material_id, m.cod_material, m.material, em.data_previsao, em.km_previsao, 
								   manutencao.to_manut_material(em.material_id).alerta_km as alerta_km,
								   manutencao.to_manut_material(em.material_id).alerta_dias as alerta_dias,
								   round(sysdate - em.data_previsao) as dias, em.ordem_servico_id_desmontagem,
									mp.cod_equipamento as cod_equipamento_identificado
						  from manutencao.v$equipamento_material em
						 inner join almoxarifado.v$material_dados m
									 on m.material_id = em.material_id
						 inner join almoxarifado.v$equipamento e
									 on e.equipamento_id = em.equipamento_id
						  left join manutencao.v$equipamento_posicao ap
								   on em.posicao_id = ap.posicao_id
						  left join almoxarifado.v$equipamento mp 
						         on mp.equipamento_id = em.equipamento_id_identificado
						 where em.ordem_servico_id_desmontagem is null
						 <cfif Len(Trim(arguments.placa)) or Len(Trim(arguments.equipamento_id))>
						   and e.equipamento_id in (#v_composicao#)
						 </cfif>
						 ) r
			 where 1=1
			  order by r.cod_equipamento, r.posicao, r.data_previsao
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca materiais com a garantia na OS
	-- NOTAS EXPLICATIVAS
	-- ANDERSON - 15/06/2009 - ALTERADO
	--->
	<cffunction name="get_veiculo_material_os" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" required="yes" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select om.controle_id,
                   om.posicao_id,
                   nvl(ep.posicao, 'nica') as posicao,
                   round(nvl(om.valor_unitario, almoxarifado.to_material(om.material_id).valor_unitario), 2) as valor_unitario,
                   round(nvl(om.valor_total, almoxarifado.to_material(om.material_id).valor_unitario * om.quantidade), 2) as valor_total,
                   md.material,
                   mdr.material as material_retirado,
                   om.quantidade,
                   e.cod_equipamento
              from manutencao.v$os_material om
             inner join almoxarifado.v$material_dados md
                     on md.material_id = om.material_id
             inner join almoxarifado.v$material_dados mdr
                     on mdr.material_id = om.material_id_retirado
              left join manutencao.v$equipamento_posicao ep
                     on ep.posicao_id = om.posicao_id
              left join almoxarifado.v$equipamento e
                     on e.equipamento_id = om.equipamento_id
   		     where om.ordem_servico_id = #arguments.ordem_servico_id#
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca solicitaes enviadas pelos motoristas
	-- NOTAS EXPLICATIVAS
	-- GUTO 05/10/2006
	--->
	<cffunction name="get_equipamento_solicitacao" returntype="query" access="remote">
		<cfargument name="equipamento_id" required="no" default="">
		<cfargument name="placa" required="no" default="">
		<cfargument name="abertas" required="no" default="1">
		<cfif Len(Trim(arguments.placa))>
			<cfset v_composicao = this.get_composicao(placa = arguments.placa)>
		</cfif>
		<cfif Len(Trim(arguments.equipamento_id))>
			<cfset v_composicao = this.get_composicao(equipamento_id = arguments.equipamento_id)>
		</cfif>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
 			 select /*+ first_rows */ e.cod_equipamento, ms.solicitacao_id, ms.equipamento_id,  to_char(ms.data_solicitacao, 'dd/mm/yyyy hh24:mi:ss') as data_solicitacao, 
			 		ms.texto, ms.atendida, 
			 	    ms.ordem_servico_id_execucao, ms.user_insert, ms.date_insert,
				    (select cod_pessoa
          			   from oper.v$veiculo_motorista vm
         			  where vm.placa = e.cod_equipamento
           				and vm.data_inicio = (select max(vm2.data_inicio)
                                   				from oper.v$veiculo_motorista vm2
                                  			   where vm.placa = e.cod_equipamento)) as cod_pessoa_motorista,
					oper.pkg_global.fnc_busca_nome_pessoa((select cod_pessoa
                                                			 from oper.v$veiculo_motorista vm
                                              				where vm.placa = e.cod_equipamento
                                                			  and vm.data_inicio = (select max(vm2.data_inicio)
                                                                        			  from oper.v$veiculo_motorista vm2
                                                                       				 where vm.placa = e.cod_equipamento))) as motorista
				--	oper.pkg_operacional.fnc_motorista_veiculo(e.cod_equipamento,sysdate) as cod_pessoa_motorista,
				--    oper.pkg_global.fnc_busca_nome_pessoa(oper.pkg_operacional.fnc_motorista_veiculo(e.cod_equipamento,sysdate)) as motorista
			   from manutencao.v$equipamento_solicitacao ms
			  inner join almoxarifado.v$equipamento e
			          on e.equipamento_id = ms.equipamento_id
  			  where 1=1
  			  <cfif Len(Trim(arguments.equipamento_id))>
			 	and ms.equipamento_id = #arguments.equipamento_id#
			  </cfif>
  			  <cfif Len(Trim(arguments.placa))>
			 	and ms.equipamento_id in (#v_composicao#)
			  </cfif>
  			  <cfif Len(Trim(arguments.abertas)) eq 1>
			 	and ms.ordem_servico_id_execucao is null
			  </cfif>
			  order by ms.data_solicitacao desc 
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>		

	<!--- 
	-- PROPSITO 
	-- Busca solicitaes (por OS) enviadas pelos motoristas
	-- NOTAS EXPLICATIVAS
	-- WAGNER 05/12/2006
	--->
	<cffunction name="get_equipamento_solicitacao_os" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" required="yes" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select e.cod_equipamento,
                   ms.solicitacao_id,
                   ms.equipamento_id,
                   to_char(ms.data_solicitacao, 'dd/mm/yyyy hh24:mi:ss') as data_solicitacao,
                   ms.texto,
                   ms.atendida,
                   ms.ordem_servico_id_execucao,
                   ms.user_insert,
                   ms.date_insert,
                   (select cod_pessoa
                      from oper.v$veiculo_motorista vm
                     where vm.placa = e.cod_equipamento
                       and sysdate between vm.data_inicio and nvl(vm.data_fim,sysdate)) as cod_pessoa_motorista,
                   (select p.cliente
                      from oper.v$veiculo_motorista vm
                     inner join kss.v$pessoa p 
                             on p.cod_pessoa = vm.cod_pessoa
                     where vm.placa = e.cod_equipamento
                       and sysdate between vm.data_inicio and nvl(vm.data_fim,sysdate)) as motorista
              from manutencao.v$equipamento_solicitacao ms
             inner join almoxarifado.v$equipamento e 
                      on e.equipamento_id = ms.equipamento_id   
  			  where ms.ordem_servico_id_execucao = #arguments.ordem_servico_id#
			  order by ms.data_solicitacao desc 
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca solicitaes (por OS) enviadas pelos motoristas
	-- NOTAS EXPLICATIVAS
	-- RAFAEL COSTA 30/04/2010
	--->
	<cffunction name="get_equipamento_solicitacao_gerada_os" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" required="no" default="">
        <cfargument name="equipamento_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select e.cod_equipamento,
                   ms.solicitacao_id,
                   ms.equipamento_id,
                   to_char(ms.data_solicitacao, 'dd/mm/yyyy hh24:mi:ss') as data_solicitacao,
                   ms.texto,
                   ms.atendida,
                   ms.ordem_servico_id_execucao,
                   ms.user_insert,
                   ms.date_insert,
                   (select cod_pessoa
                      from oper.v$veiculo_motorista vm
                     where vm.placa = e.cod_equipamento
                       and sysdate between vm.data_inicio and nvl(vm.data_fim,sysdate)) as cod_pessoa_motorista,
                   (select p.cliente
                      from oper.v$veiculo_motorista vm
                     inner join kss.v$pessoa p 
                             on p.cod_pessoa = vm.cod_pessoa
                     where vm.placa = e.cod_equipamento
                       and sysdate between vm.data_inicio and nvl(vm.data_fim,sysdate)) as motorista,
                   oses.ordem_servico_id
              from manutencao.v$equipamento_solicitacao ms
        inner join almoxarifado.v$equipamento e 
                on e.equipamento_id = ms.equipamento_id
        inner join manutencao.v$os_equipamento_solicitacao oses
                on oses.solicitacao_id = ms.solicitacao_id
             where 1 = 1
          <cfif Len(Trim(arguments.ordem_servico_id))>
               and oses.ordem_servico_id = #arguments.ordem_servico_id#
          </cfif>
          <cfif Len(Trim(arguments.equipamento_id))>
               and ms.equipamento_id = #arguments.equipamento_id#
          </cfif>
               and ms.atendida = 0
          order by ms.data_solicitacao desc
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca tabelas de manuteno vincculadas a um veculo
	-- NOTAS EXPLICATIVAS
	-- GUTO 05/10/2006
	--->
	<cffunction name="get_equipamento_tabela" returntype="query" access="remote">
		<cfargument name="equipamento_id" required="no" default="">
		<cfargument name="placa" required="no" default="">
		<cfset v_composicao = this.get_composicao(placa = arguments.placa, equipamento_id = arguments.equipamento_id)>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
          select r.equipamento_id, r.cod_equipamento, r.nome as tabela, r.obrigatoria,
               r.data_previsao, r.km_previsao, r.ordem_servico_id_execucao,
               nvl(r.controle_id, to_number(r.tabela_id||r.equipamento_id)) as identificador,
               r.controle_id, r.tabela_id, r.atualiza_revisao,
               r.dias_previsto, r.alerta_km, r.alerta_dias,
               nvl(manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial,0) as km_atual,
                 case
                 when r.ordem_servico_id_execucao is null and r.controle_id is null then 'Sem execuo'
                 when r.ordem_servico_id_execucao is not null and r.controle_id is not null then 'Executada'
                 when r.ordem_servico_id_execucao is null
                  and (manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial > r.km_previsao
                    or sysdate > r.data_previsao) then 'Vencida'
                 when r.ordem_servico_id_execucao is null
                  and (manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial + manutencao.to_manut_tabela(r.tabela_id).alerta_km >= r.km_previsao
                    or sysdate + manutencao.to_manut_tabela(r.tabela_id).alerta_dias > r.data_previsao) then 'A vencer'
                 else 'OK' end status,
                 case
                 when r.ordem_servico_id_execucao is null and r.controle_id is null then -3
                 when r.ordem_servico_id_execucao is not null and r.controle_id is not null then 0
                 when r.ordem_servico_id_execucao is null
                  and (manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial > r.km_previsao
                    or sysdate > r.data_previsao) then -2
                 when r.ordem_servico_id_execucao is null
                  and (manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial + manutencao.to_manut_tabela(r.tabela_id).alerta_km >= r.km_previsao
                    or sysdate + manutencao.to_manut_tabela(r.tabela_id).alerta_dias > r.data_previsao) then -1
                 else 1 end status_id,
                     r.km_previsao - manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial as km_previsto
            from (select e.equipamento_id, e.cod_equipamento, t.nome,  
                   t.obrigatoria, t.tabela_id, et.data_previsao, et.km_previsao,
                   et.ordem_servico_id_execucao, et.controle_id ,
                   round(sysdate - et.data_previsao) as dias_previsto,
                   manutencao.to_manut_tabela(et.tabela_id).alerta_km as alerta_km, 
                   manutencao.to_manut_tabela(et.tabela_id).alerta_dias as alerta_dias,
                               t.atualiza_revisao
                from almoxarifado.v$equipamento e
               inner join manutencao.v$equipamento_tabela_manut et
                   on et.equipamento_id = e.equipamento_id
               inner join manutencao.v$tabela_manutencao t
                   on et.tabela_id = t.tabela_id
               where e.equipamento_id in (#v_composicao#)
                 and (t.intervalo_km <> 0 or t.intervalo_dias <> 0 or t.intervalo_horas_trabalhadas <> 0 or t.intervalo_lts_combustivel <> 0)) r
            where 1=1
                and r.ordem_servico_id_execucao  is null
  			  <cfif Len(Trim(arguments.equipamento_id))>
			 	and r.equipamento_id = #arguments.equipamento_id#
			  </cfif>
        union
          select r.equipamento_id, r.cod_equipamento, r.nome as tabela, r.obrigatoria,
               r.data_previsao, r.km_previsao, r.ordem_servico_id_execucao,
               nvl(r.controle_id, to_number(r.tabela_id||r.equipamento_id)) as identificador,
               r.controle_id, r.tabela_id, r.atualiza_revisao,
               r.dias_previsto, r.alerta_km, r.alerta_dias,
               manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial as km_atual,
                 case
                 when r.ordem_servico_id_execucao is null and r.controle_id is null then 'Sem execuo'
                 when r.ordem_servico_id_execucao is not null and r.controle_id is not null then 'Executada'
                 when r.ordem_servico_id_execucao is null
                  and (manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial > r.km_previsao
                    or sysdate > r.data_previsao) then 'Vencida'
                 when r.ordem_servico_id_execucao is null
                  and (manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial + manutencao.to_manut_tabela(r.tabela_id).alerta_km >= r.km_previsao
                    or sysdate + manutencao.to_manut_tabela(r.tabela_id).alerta_dias > r.data_previsao) then 'A vencer'
                 else 'OK' end status,
                 case
                 when r.ordem_servico_id_execucao is null and r.controle_id is null then -3
                 when r.ordem_servico_id_execucao is not null and r.controle_id is not null then 0
                 when r.ordem_servico_id_execucao is null
                  and (manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial > r.km_previsao
                    or sysdate > r.data_previsao) then -2
                 when r.ordem_servico_id_execucao is null
                  and (manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial + manutencao.to_manut_tabela(r.tabela_id).alerta_km >= r.km_previsao
                    or sysdate + manutencao.to_manut_tabela(r.tabela_id).alerta_dias > r.data_previsao) then -1
                 else 1 end status_id,
                     r.km_previsao - manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial as km_previsto
            from (select e.equipamento_id, e.cod_equipamento, t.nome,  
                   t.obrigatoria, t.tabela_id, null as data_previsao, null as km_previsao,
                   null as ordem_servico_id_execucao, null as controle_id ,
                   null as dias_previsto,
                   manutencao.to_manut_tabela(tm.tabela_id).alerta_km as alerta_km, 
                   manutencao.to_manut_tabela(tm.tabela_id).alerta_dias as alerta_dias,
                               t.atualiza_revisao
                from almoxarifado.v$equipamento e
               inner join manutencao.v$equipamento_modelo em
                   on em.equipamento_id = e.equipamento_id
                   and em.data_final is null
               inner join manutencao.v$tabela_modelo tm
                   on tm.modelo_id = em.modelo_id
               inner join manutencao.v$tabela_manutencao t
                   on t.tabela_id = tm.tabela_id
               where e.equipamento_id in (#v_composicao#)
                   and not exists (select 1 
                                       from manutencao.v$equipamento_tabela_manut et
                          where et.equipamento_id = e.equipamento_id
                            and et.tabela_id = t.tabela_id
                                                            and et.ordem_servico_id_execucao  is null)) r
            where 1=1
  			  <cfif Len(Trim(arguments.equipamento_id))>
			 	and r.equipamento_id = #arguments.equipamento_id#
			  </cfif>
			  order by km_previsto 
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca tabelas de manuteno vincculadas a um veculo
	-- NOTAS EXPLICATIVAS
	-- WAGNER 05/12/2006
	--->

	<cffunction name="get_equipamento_tabela_os" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" required="yes" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select tm.nome as tabela, ost.ordem_servico_id, 
				       case 
                           when tm.tipo_execucao is null then ''
                           when tm.tipo_execucao = 1 then 'Completa'
                           when tm.tipo_execucao = 2 then 'Parcial'
                       else '' end tipo_execucao
				  from manutencao.v$os_tabela_manutencao ost
           inner join manutencao.v$tabela_manutencao tm
          		   on tm.tabela_id = ost.tabela_id
				where ost.ORDEM_SERVICO_ID = #arguments.ordem_servico_id#
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca modelos de equipamentos
	-- NOTAS EXPLICATIVAS
	-- ARLEN 06/10/2006
	--->
	<cffunction name="get_modelos" returntype="query" access="remote">
		<cfargument name="modelo_id" required="no" default="">
		<cfargument name="descricao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select modelo_id, descricao
				  from manutencao.v$modelo m
    		     where 1=1
 			  <cfif Len(Trim(arguments.modelo_id))>
				and m.modelo_id = #arguments.modelo_id#
			  </cfif>
 			  <cfif Len(Trim(arguments.descricao))>
				and upper(m.descricao) like upper('%#arguments.descricao#%')
			  </cfif>
 			  order by m.descricao
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca dados das OSs abertas para a composio
	-- NOTAS EXPLICATIVAS
	-- GUTO 07/10/2006
	--->
	<cffunction name="get_ordens_servico" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" required="no" default="">
		<cfargument name="placa" required="no" default="">
		<cfargument name="cod_equipamento" required="no" default="">
		<cfargument name="equipamento_id" required="no" default="">
		<cfargument name="cod_pessoa_oficina" required="no" default="">
		<cfargument name="abertas" required="no" default="1">
		<cfargument name="check_list" required="no" default="0">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfargument name="empresa" required="no" default="">
		<cfargument name="num_ordem_servico" required="no" default="">
		<cfargument name="status" required="no" default="">
		<cfargument name="socorro" required="no" default="0">
		<cfif Len(Trim(arguments.placa))>
			<cfset v_composicao = this.get_composicao(placa = arguments.placa)>
		</cfif>
		<cfif Len(Trim(arguments.equipamento_id))>
			<cfset v_composicao = this.get_composicao(equipamento_id = arguments.equipamento_id)>
		</cfif>
		<cfquery result="QUERY" name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select /*+ ORDERED*/ os.ordem_servico_id
                 , os.num_ordem_servico
                 , os.empresa
                 , os.equipamento_id
                 , e.material_id
                 , e.cod_equipamento
                 , almoxarifado.pkg_almoxarifado.fnc_get_material_descricao(e.material_id, ' ') as material
                 , to_char(os.data_abertura, 'dd/mm/yyyy hh24:mi') as data_abertura
                 , os.cod_pessoa_responsavel
                 , oper.pkg_global.fnc_busca_nome_pessoa(os.cod_pessoa_responsavel) as responsavel
                 , os.cod_pessoa_oficina
                 , p.identificador as cnpj_oficina
                 , p.cliente as oficina
                 , os.km_rodado
                 , os.observacao
                 , to_char(os.data_previsao_liberacao, 'dd/mm/yyyy hh24:mi') as data_previsao_liberacao
                 , case
                      when to_number((nvl(os.data_fechamento, sysdate) - os.data_abertura)) > 100 then
                         'Mais de 100 dias'
                      else
                         to_char(manutencao.to_tempo_execucao(numtodsinterval(to_number((nvl(os.data_fechamento, sysdate) - os.data_abertura)), 'DAY'), 2).retorno)
                   end as tempo_aberto
                 , case
                      when os.data_fechamento is null then
                         almoxarifado.to_ponto(e.cod_equipamento, sysdate).landmark
                      when os.data_fechamento is not null then
                         'OS Finalizada'
                   end posicao_atual
                 , to_char(os.data_saida, 'dd/mm/yyyy hh24:mi') as data_saida
                 , to_char(os.data_chegada, 'dd/mm/yyyy hh24:mi') as data_chegada
                 , to_char(os.data_atendimento, 'dd/mm/yyyy hh24:mi') as data_atendimento
                 , to_char(os.data_fechamento, 'dd/mm/yyyy hh24:mi') as data_fechamento
                 , os.log_alteracoes
                 , (select oser.valor_servico
                      from manutencao.v$ordem_servico oser
                     where oser.ordem_servico_id = os.ordem_servico_id) as valor_servico
                 , os.socorro
                 , nft.num_nota_fiscal
                 , os.ordem_servico_id_vinculo
                 , (select oser.num_ordem_servico
                      from manutencao.v$ordem_servico oser
                     where oser.ordem_servico_id = os.ordem_servico_id_vinculo) as num_ordem_servico_vinculo
                 , 0 as valor_total_os
                 , 0 as valor_lancto
                 , tos.descricao as tipo
                 , manutencao.to_equipamento_dados(os.equipamento_id).placa as placa
                 , decode(os.empresa, 0, 'Externa', 'Interna')as tipo_os
              from manutencao.v$ordem_servico_dados os
             inner join kss.v$pessoa p
                     on p.cod_pessoa = os.cod_pessoa_oficina
             inner join almoxarifado.v$equipamento e
                     on e.equipamento_id = os.equipamento_id
             left join manutencao.v$tipo_ordem_servico tos
                   on tos.tipo_ordem_servico_id = os.TIPO_ORDEM_SERVICO_ID
              left join fiscal.v$nf_terceiro nft
                     on nft.num_nota_id = os.num_nota_id
             where 1 = 1
			<cfif Len(Trim(arguments.cod_equipamento))>
			   and e.cod_equipamento = '#arguments.cod_equipamento#'
			</cfif>
			<cfif Len(Trim(arguments.ordem_servico_id))>
               and os.ordem_servico_id = #arguments.ordem_servico_id#
            </cfif>
            <cfif arguments.socorro neq -1>
               and os.socorro = #arguments.socorro#              
            </cfif>
            <cfif arguments.abertas eq 1>
               and os.data_fechamento is null     
            </cfif>
			<cfif arguments.check_list eq 1>
               and exists (select 'x' 
                             from manutencao.v$os_atividade oa
                            inner join manutencao.v$atividade a
                                    on a.atividade_id = oa.atividade_id
                            where oa.ordem_servico_id = os.ordem_servico_id
                              and a.verificacao = 1
                              and oa.executada = 0)
            </cfif>
			<cfif Len(Trim(arguments.cod_pessoa_oficina))>
               and os.cod_pessoa_oficina = #arguments.cod_pessoa_oficina#
            </cfif>
            <cfif Len(Trim(arguments.empresa))>
               and os.empresa = #arguments.empresa#
            </cfif>
            <cfif Len(Trim(arguments.num_ordem_servico))>
               and os.num_ordem_servico = #arguments.num_ordem_servico#
            </cfif>
            <cfif Len(Trim(arguments.data_inicial)) and Len(Trim(arguments.data_final)) >
               and os.data_abertura between '#LSDateFormat(arguments.data_inicial)#' and '#LSDateFormat(arguments.data_final)# 23:59:59'
            </cfif>
            <cfif Len(Trim(arguments.status)) and arguments.status eq 0>
               and os.data_fechamento is null
            </cfif>
            <cfif Len(Trim(arguments.status)) and arguments.status eq 1>
               and os.data_fechamento is not null
            </cfif>
            <cfif Len(Trim(arguments.equipamento_id)) or Len(Trim(arguments.placa))>
				<cfif Len(Trim(v_composicao))>
                	and os.equipamento_id in (#v_composicao#)
                  order by instr('#v_composicao#', to_char(os.equipamento_id)), os.data_abertura desc
                <cfelse>
                    and 1 = 0
                </cfif>
            </cfif>
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca dados das OSs abertas para a composio
	-- NOTAS EXPLICATIVAS
	-- GUTO 07/10/2006
	--->
	<cffunction name="get_equipamento_localizacao" returntype="query" access="remote">
		<cfargument name="material_id" required="no" default="">
		<cfargument name="cod_pessoa_filial" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select e.equipamento_id, e.cod_equipamento, e.data_aquisicao, 
				    e.data_inativacao, e.situacao, e.lancamento_id, e.material_id,
				    el.cod_pessoa_filial
			  from almoxarifado.v$equipamento  e
			  left join manutencao.v$equipamento_localizacao el
			 		   on el.equipamento_id = e.equipamento_id
				     and el.data_saida is null		
			  where 1=1
			  <cfif Len(Trim(arguments.material_id))>
			    and e.material_id = #arguments.material_id#
			  </cfif>
			  <cfif Len(Trim(arguments.cod_pessoa_filial))>
			     and el.cod_pessoa_filial = #arguments.cod_pessoa_filial#
			  </cfif>
			  order by e.cod_equipamento
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca equipamento montado
	-- NOTAS EXPLICATIVAS
	-- GUTO 07/10/2006
	--->
	<cffunction name="get_equipamento_montado" returntype="query" access="remote">
		<cfargument name="equipamento_id" required="yes">
		<cfargument name="material_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
    	select e.equipamento_id, e.cod_equipamento, e.material_id, md.material
			  from almoxarifado.v$equipamento  e
			 inner join manutencao.v$equipamento_material em
				       on em.equipamento_id_identificado = e.equipamento_id
				      and em.ordem_servico_id_desmontagem is null
		     inner join almoxarifado.v$material_dados md
			         on md.material_id = e.material_id 
			  where 1=1
				and em.equipamento_id = #arguments.equipamento_id# 
				<cfif Len(Trim(arguments.material_id))>
			    and e.material_id = #arguments.material_id#
				</cfif>
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca equipamento componente
	-- NOTAS EXPLICATIVAS
	-- GUTO 07/10/2006
	--->
	<cffunction name="get_material_componente" returntype="query" access="remote">
		<cfargument name="material_id" required="yes">
		<cfargument name="material_id_os" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select mc.material_id, almoxarifado.pkg_almoxarifado.FNC_GET_MATERIAL_DESCRICAO(mc.material_id,' ') as material
				  from (select t.material_id, material_pai, material
							  from almoxarifado.v$material_dados t
							 start with t.material_id = #arguments.material_id#
							connect by t.material_id = prior t.material_pai) a
				 inner join almoxarifado.v$material_componente mc 
							on mc.material_id_componente = a.material_id
			 <cfif Len(Trim(arguments.material_id_os))>
			 where not exists (select t.material_id, material_pai, material
									   from almoxarifado.v$material_dados t
									  where t.material_id = mc.material_id
									  start with t.material_id = #arguments.material_id_os#
									 connect by t.material_id = prior t.material_pai)
			 and not exists (select t.material_id, material_pai, material
									   from almoxarifado.v$material_dados t
									  where t.material_id = #arguments.material_id_os#
									  start with t.material_id = mc.material_id
									 connect by t.material_id = prior t.material_pai)
			 </cfif> 
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca materiais usados na OS
	-- NOTAS EXPLICATIVAS
	-- GUTO 11/10/2006
	--->
	<cffunction name="get_os_materiais" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select os.ordem_servico_id, om.controle_id, 
				   om.cod_pessoa_retirada, p.cliente as responsavel,
				   m.material, m.material_id, e.cod_equipamento, nvl(ep.posicao,'nica') as posicao, er.cod_equipamento as cod_equipamento_retirado,
				   om.quantidade, manutencao.to_os_material(om.controle_id).atividade_ok as atividade_ok, m.unidade_estoque,
  				   om.valor_unitario,
                   mr.descricao_completa as material_retirado, om.observacao,
                   m.descricao as material_descricao, m.cod_material
			  from manutencao.v$ordem_servico os
			 inner join manutencao.v$os_material om
					 on om.ordem_servico_id = os.ordem_servico_id
			 inner join almoxarifado.v$material_dados m
					 on m.material_id = om.material_id         
			 inner join almoxarifado.v$material_dados mr
					 on mr.material_id = om.material_id_retirado
		    left join kss.v$pessoa p
			         on p.cod_pessoa = om.cod_pessoa_retirada
			 left join almoxarifado.v$equipamento e
					 on e.equipamento_id = om.equipamento_id         
			 left join manutencao.v$equipamento_posicao ep
					 on ep.posicao_id = om.posicao_id
			 left join almoxarifado.v$equipamento er
					 on er.equipamento_id = om.equipamento_id_retirado
			 where 1=1
			   and os.ordem_servico_id = #arguments.ordem_servico_id#
		  order by om.date_insert 
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca OSs externas com tabelas de manutencao
	-- NOTAS EXPLICATIVAS
	-- GUTO 11/10/2006
	--->
	<cffunction name="get_os_externa_tabela" returntype="query" access="remote">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select /*+ ORDERED*/ os.ordem_servico_id
                 , os.num_ordem_servico
                 , os.empresa
                 , os.equipamento_id
                 , e.material_id
                 , e.cod_equipamento
                 , almoxarifado.pkg_almoxarifado.fnc_get_material_descricao(e.material_id, ' ') as material
                 , to_char(os.data_abertura,'dd/mm/yyyy hh24:mi') as data_abertura
                 , os.cod_pessoa_responsavel
                 , oper.pkg_global.fnc_busca_nome_pessoa(os.cod_pessoa_responsavel) as responsavel
                 , os.cod_pessoa_oficina
                 , p.identificador as cnpj_oficina
                 , p.cliente as oficina
                 , os.observacao
                 , to_char(os.data_previsao_liberacao,'dd/mm/yyyy hh24:mi') as data_previsao_liberacao
                 , case 
                      when to_number((nvl(os.data_fechamento,sysdate)-os.DATA_ABERTURA)) > 100 then 
                         'Mais de 100 dias'
                      else to_char(manutencao.to_tempo_execucao(numtodsinterval(to_number((nvl(os.data_fechamento,sysdate)-os.DATA_ABERTURA)),'DAY'),2).retorno) end tempo_aberto
                 , case
                      when os.data_fechamento is null then
                         almoxarifado.to_ponto(e.cod_equipamento,sysdate).landmark
                      when os.data_fechamento is not null then
                         'OS Finalizada'
                   end posicao_atual
                 , to_char(os.data_saida,'dd/mm/yyyy hh24:mi') as data_saida
                 , to_char(os.data_chegada,'dd/mm/yyyy hh24:mi') as data_chegada
                 , to_char(os.data_atendimento,'dd/mm/yyyy hh24:mi') as data_atendimento
                 , to_char(os.data_fechamento,'dd/mm/yyyy hh24:mi') as data_fechamento
                 , os.log_alteracoes
                 , (select oser.valor_servico
                      from manutencao.v$ordem_servico oser
                     where oser.ordem_servico_id = os.ordem_servico_id )as valor_servico
                 , os.socorro
                 , ot.controle_id
                 , ot.confirmada
                 , tm.nome as tabela
                 , tm.tipo_execucao
              from manutencao.v$ordem_servico_dados os
             inner join kss.v$pessoa p
                on p.cod_pessoa = os.cod_pessoa_oficina
             inner join almoxarifado.v$equipamento e
                on e.equipamento_id = os.equipamento_id
             inner join manutencao.v$os_tabela_manutencao ot
                on ot.ordem_servico_id = os.ordem_servico_id
             inner join manutencao.v$tabela_manutencao tm 
                on tm.tabela_id = ot.tabela_id
             where 1=1
               and os.socorro = 0
               and os.data_fechamento is null     
               and os.empresa = 0
             order by os.ordem_servico_id
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>	    

<!--- 
	-- PROPSITO 
	-- Busca horas dos recursos
	-- NOTAS EXPLICATIVAS
	-- GUTO 11/10/2006
	--->
	<cffunction name="get_horas_recursos" returntype="query" access="remote">
		<cfargument name="cod_pessoa_responsavel" required="no" default="">
		<cfargument name="recurso_id" required="no">
		<cfargument name="data_inicio" required="no">
		<cfargument name="data_termino" required="no">
		<cfquery result="query" name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		 select cod_pessoa_principal, principal, cod_pessoa_auxiliar, 
 			 	    auxiliar, tempo_execucao, 
 				    especialidade_id, especialidade, nivel, nivel_id, 
				    valor_hora, valor_total_horas, 
					manutencao.to_tempo_execucao(manutencao.sum_dsinterval(tempo_exec_interval) over(partition by cod_pessoa_principal order by cod_pessoa_principal),3).retorno as tempo_total_func,
					sum(nvl(valor_total_horas,0)) over(partition by cod_pessoa_principal order by cod_pessoa_principal) as valor_total_func
			from (
			select ope.cod_pessoa_principal, pe.cliente as principal,
					 ope.cod_pessoa_auxiliar, pea.cliente as auxiliar,
					 manutencao.sum_dsinterval(op.tempo_execucao_ajustado * (pr.percentual_participacao/100)) / decode(ope.cod_pessoa_auxiliar,null,1,2) as tempo_exec_interval,
					 manutencao.to_tempo_execucao(manutencao.sum_dsinterval(op.tempo_execucao_ajustado * (pr.percentual_participacao/100))/ decode(ope.cod_pessoa_auxiliar,null,1,2),3) .retorno as tempo_execucao,
					 e.especialidade_id, e.descricao as especialidade,
					 n.descricao as nivel, n.nivel_id,
					 avg(manutencao.to_recurso_valor(ope.cod_pessoa_principal,e.especialidade_id,n.nivel_id,ope.data_termino).valor_hora) as valor_hora,
					 round((((sysdate + manutencao.sum_dsinterval(op.tempo_execucao_ajustado * (pr.percentual_participacao/100)) - sysdate)*24) * avg(manutencao.to_recurso_valor(ope.cod_pessoa_principal,e.especialidade_id,n.nivel_id,ope.data_termino).valor_hora)) / decode(ope.cod_pessoa_auxiliar,null,1,2) ,2) as valor_total_horas
			  from manutencao.v$ordem_servico os
             inner join manutencao.v$os_processos op
                     on os.ordem_servico_id = op.ordem_servico_id
			 inner join manutencao.v$os_processo_execucao ope 
               on op.controle_id = ope.controle_id
			 inner join manutencao.v$processo p 
               on p.processo_id = op.processo_id
			 inner join manutencao.v$processo_recurso pr on pr.item_id = op.processo_recurso_id
			 inner join manutencao.v$recurso_nivel n on n.nivel_id = pr.nivel_id
			 inner join manutencao.v$recurso_especialidade e on e.especialidade_id =
																				 pr.especialidade_id
			 inner join kss.v$pessoa pe on pe.cod_pessoa = ope.cod_pessoa_principal
			  left join kss.v$pessoa pea on pea.cod_pessoa = ope.cod_pessoa_auxiliar
			 where op.executado = 1
				and ope.fecha_execucao = 1
			<cfif Len(Trim(arguments.COD_PESSOA_RESPONSAVEL))>
				and ope.cod_pessoa_principal = #arguments.COD_PESSOA_RESPONSAVEL#
			</cfif>
			<cfif IsDefined("arguments.RECURSO_ID") and arguments.RECURSO_ID neq "">
				and (ope.cod_pessoa_principal in (#arguments.RECURSO_ID#) or
				     ope.cod_pessoa_auxiliar in (#arguments.RECURSO_ID#) )
			</cfif>
			<cfif Len(Trim(arguments.DATA_INICIO)) and Len(Trim(arguments.DATA_TERMINO))>
				and trunc(os.data_abertura) between to_date('#arguments.data_inicio#','dd/mm/yyyy') and to_date('#arguments.data_termino#','dd/mm/yyyy')
			</cfif>
			 group by ope.cod_pessoa_principal, pe.cliente, ope.cod_pessoa_auxiliar,
						 pea.cliente, e.descricao, e.especialidade_id, n.descricao,
						 n.nivel_id) a
			  order by a.cod_pessoa_principal 
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Busca horas de recursos agrupados, para o RH
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO - 10/04/2007 - criado
	--->	
	<cffunction name="get_horas_recursos_agrupado" displayname="" access="remote" returntype="query" output="true">
		<cfargument name="data_inicio" required="no" default=""/>
		<cfargument name="data_fim" required="no" default=""/>
        <cfargument name="recurso_id" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select t.cod_pessoa, p.cliente as recurso, 
				   manutencao.to_tempo_execucao(numtodsinterval(sum(decode(tempo_pago,0,tempo_gasto,tempo_pago)), 'DAY'), 3) .retorno as tempo_pago,       
       			   manutencao.to_tempo_execucao(numtodsinterval(sum(tempo_gasto), 'DAY'), 3) .retorno as tempo_gasto,
				   nvl(round(sum(valor_servico),2),0) as valor_total, ro.interna,
                   nvl((select sum(os.km_deslocamento) 
                      from manutencao.v$os_atendimento os
                     inner join kss.v$pessoa p
                             on p.cod_pessoa = os.cod_pessoa_mecanico
                     inner join manutencao.v$ordem_servico o
                             on o.ordem_servico_id = os.ordem_servico_id 
                     where o.data_abertura >= '#arguments.DATA_INICIO#'
                       and o.data_abertura <= '#arguments.DATA_FIM#'
                       and os.cod_pessoa_mecanico = t.cod_pessoa),0) as km_deslocamento
			  from (
					select /*+ ordered */ pe.cod_pessoa_principal as cod_pessoa, 
						   sum(sysdate + (op.tempo_execucao_ajustado * (pr.percentual_participacao / 100)) - sysdate) as tempo_pago,             
				           sum(sysdate + (pe.tempo_execucao) - sysdate) as tempo_gasto, 
						   sum(manutencao.to_tempo_convertido((decode(op.tempo_execucao_ajustado,to_dsinterval('+000000000 00:00:00'),pe.tempo_execucao,op.tempo_execucao_ajustado))*(pr.percentual_participacao/100)).horas * manutencao.to_recurso_valor(pr.especialidade_id, pr.nivel_id, pe.data_inicio,os.empresa).valor_hora) as valor_servico
					  from manutencao.v$ordem_servico os
                    inner join manutencao.v$os_processos op
	                  	     on os.ordem_servico_id = op.ordem_servico_id
					inner join manutencao.v$os_processo_execucao pe
							on pe.controle_id = op.controle_id
					inner join manutencao.v$processo_recurso pr
							on pr.item_id = op.processo_recurso_id
					where pe.fecha_execucao = 1        
					  and pe.cod_pessoa_auxiliar is null
					  and trunc(pe.data_termino) between '#arguments.data_inicio#' and '#arguments.data_fim#'
					<cfif Len(Trim(arguments.recurso_id))>
                      and pe.cod_pessoa_principal in (#arguments.recurso_id#)
                    </cfif>
					group by pe.cod_pessoa_principal, op.tempo_execucao_ajustado, pe.tempo_execucao
					
					UNION ALL
					
					select /*+ ordered */ pe.cod_pessoa_principal cod_pessoa, 
						   sum(sysdate + ((op.tempo_execucao_ajustado/2) * (pr.percentual_participacao / 100)) - sysdate) as tempo_pago,             
         				   sum(sysdate + (pe.tempo_execucao/2) - sysdate) as tempo_gasto, 
						   sum(manutencao.to_tempo_convertido(((decode(op.tempo_execucao_ajustado,to_dsinterval('+000000000 00:00:00'),pe.tempo_execucao,op.tempo_execucao_ajustado))/2)*(pr.percentual_participacao/100)).horas * manutencao.to_recurso_valor(pr.especialidade_id, pr.nivel_id, pe.data_inicio,os.empresa).valor_hora) as valor_servico
					  from manutencao.v$ordem_servico os
                    inner join manutencao.v$os_processos op
                    	    on os.ordem_servico_id = op.ordem_servico_id
					inner join manutencao.v$os_processo_execucao pe
							on pe.controle_id = op.controle_id
					inner join manutencao.v$processo_recurso pr
							on pr.item_id = op.processo_recurso_id
					where pe.fecha_execucao = 1        
					  and pe.cod_pessoa_auxiliar is not null
					  and trunc(pe.data_termino) between '#arguments.data_inicio#' and '#arguments.data_fim#'
					<cfif Len(Trim(arguments.recurso_id))>
                      and pe.cod_pessoa_principal in (#arguments.recurso_id#)
                    </cfif>
					group by pe.cod_pessoa_principal, op.tempo_execucao_ajustado, pe.tempo_execucao
					  
					UNION ALL
					
					select /*+ ordered */  pe.cod_pessoa_auxiliar cod_pessoa, 
						   sum(sysdate + ((op.tempo_execucao_ajustado/2) * (pr.percentual_participacao / 100)) - sysdate) as tempo_pago,             
        				   sum(sysdate + (pe.tempo_execucao/2) - sysdate) as tempo_gasto, 
						   sum(manutencao.to_tempo_convertido(((decode(op.tempo_execucao_ajustado,to_dsinterval('+000000000 00:00:00'),pe.tempo_execucao,op.tempo_execucao_ajustado))/2)*(pr.percentual_participacao/100)).horas * manutencao.to_recurso_valor(pr.especialidade_id, pr.nivel_id, pe.data_inicio,os.empresa).valor_hora) as valor_servico
					  from manutencao.v$ordem_servico os
                    inner join manutencao.v$os_processos op
                            on os.ordem_servico_id = op.ordem_servico_id
					inner join manutencao.v$os_processo_execucao pe
							on pe.controle_id = op.controle_id
					inner join manutencao.v$processo_recurso pr
							on pr.item_id = op.processo_recurso_id
					where pe.fecha_execucao = 1  
					  and pe.cod_pessoa_auxiliar is not null      
					  and trunc(pe.data_termino) between '#arguments.data_inicio#' and '#arguments.data_fim#'
					<cfif Len(Trim(arguments.recurso_id))>
                      and pe.cod_pessoa_auxiliar in (#arguments.recurso_id#)
                    </cfif>
					group by pe.cod_pessoa_auxiliar, op.tempo_execucao_ajustado, pe.tempo_execucao
					  ) t
			  inner join kss.v$pessoa p 
					  on p.cod_pessoa = t.cod_pessoa          
			  inner join (select distinct r.cod_pessoa as cod_pessoa_funcionario, o.interna
							from manutencao.v$recurso r
						   inner join manutencao.v$recurso_oficina ro 
								   on ro.recurso_id = r.recurso_id
						   inner join manutencao.v$oficinas o
								   on o.cod_pessoa = ro.cod_pessoa_oficina                  
						  where ro.data_fim is null) ro
					  on ro.cod_pessoa_funcionario = p.cod_pessoa           
			group by t.cod_pessoa, p.cliente, ro.interna
			order by p.cliente, ro.interna
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>		
	
	<!--- 
	-- PROPSITO 
	-- Busca Processos executados pelo recurso no periodo
	-- NOTAS EXPLICATIVAS
	-- GUTO 15/12/2006
	--->
	<cffunction name="get_recurso_processos" returntype="query" access="remote">
		<cfargument name="COD_PESSOA" required="yes" >
		<cfargument name="DATA_INICIO" required="yes" >
		<cfargument name="DATA_TERMINO" required="yes" >
		<cfargument name="ESPECIALIDADE_ID" required="no" default="" >
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select t.tipo, t.num_ordem_servico, t.cod_equipamento, t.cod_pessoa, 
				   t.processo, t.especialidade, t.nivel, 
				   t.nivel_especialidade, 
                   manutencao.to_tempo_execucao(numtodsinterval(decode(t.tempo_execucao,0,t.tempo_gasto,t.tempo_execucao), 'DAY'), 3) .retorno as tempo_execucao,
                   manutencao.to_tempo_execucao(numtodsinterval(t.tempo_gasto, 'DAY'), 3) .retorno as tempo_gasto,
                   manutencao.to_tempo_execucao(numtodsinterval(sum(t.tempo_execucao) over(), 'DAY'), 3) .retorno as tempo_execucao_total,
                   manutencao.to_tempo_execucao(numtodsinterval(sum(t.tempo_gasto) over(), 'DAY'), 3) .retorno as tempo_gasto_total,                   
				   t.valor_servico, 
				   round(sum(t.valor_servico) over(),2) as valor_servico_total,
                   sum(t.valor_servico) over(partition by t.num_ordem_servico order by t.num_ordem_servico) as valor_total_os,
                   executado_mes
			  from (
					select /*+ first_rows_1000 */ 'Individual' as tipo, os.num_ordem_servico, e.cod_equipamento, pe.cod_pessoa_principal as cod_pessoa, p.titulo as processo,
						   re.descricao as especialidade, rn.descricao as nivel,
						   re.descricao || rn.descricao as nivel_especialidade,
						   sysdate + (op.tempo_execucao_ajustado * (pr.percentual_participacao / 100)) - sysdate as tempo_execucao,
					       sysdate + (pe.tempo_execucao) - sysdate as tempo_gasto,
						   round(manutencao.to_tempo_convertido((decode(op.tempo_execucao_ajustado,to_dsinterval('+000000000 00:00:00'),pe.tempo_execucao,op.tempo_execucao_ajustado))*(pr.percentual_participacao/100)).horas * manutencao.to_recurso_valor(pr.especialidade_id, pr.nivel_id, pe.data_inicio,os.empresa).valor_hora,2) as valor_servico,
                           case 
                             when '#arguments.DATA_INICIO#' >= pe.DATA_TERMINO then 0
                           else 1 end executado_mes
					  from manutencao.v$ordem_servico os
					 inner join almoxarifado.v$equipamento e
							 on e.equipamento_id = os.equipamento_id
					 inner join manutencao.v$os_processos op
							 on os.ordem_servico_id = op.ordem_servico_id
					 inner join manutencao.v$processo p 
							 on p.processo_id = op.processo_id
					 inner join manutencao.v$os_processo_execucao pe
							 on pe.controle_id = op.controle_id
					 inner join manutencao.v$processo_recurso pr
							 on pr.item_id = op.processo_recurso_id
					 inner join manutencao.v$recurso_especialidade re
							 on re.especialidade_id = pr.especialidade_id
					 inner join manutencao.v$recurso_nivel rn
							 on rn.nivel_id = pr.nivel_id         
					 inner join kss.v$pessoa p 
							 on p.cod_pessoa = pe.cod_pessoa_principal
					where pe.fecha_execucao = 1        
					  and pe.cod_pessoa_auxiliar is null
					  and trunc(pe.data_termino) between '#arguments.DATA_INICIO#' and '#arguments.DATA_TERMINO#'
					  and p.cod_pessoa = #arguments.COD_PESSOA#
					<cfif Len(Trim(arguments.especialidade_id))>
					  and re.especialidade_id = #arguments.especialidade_id#
					</cfif>
					
					UNION ALL
					
					select /*+ first_rows_1000 */ 'Auxiliado' as tipo, os.num_ordem_servico, e.cod_equipamento, 
						   pe.cod_pessoa_principal as cod_pessoa, p.titulo as processo,
						   re.descricao as especialidade, rn.descricao as nivel,
						   re.descricao || rn.descricao as nivel_especialidade,
						   sysdate + ((op.tempo_execucao_ajustado/2) * (pr.percentual_participacao / 100)) - sysdate as tempo_execucao,
					       sysdate + (pe.tempo_execucao/2) - sysdate as tempo_gasto,
						   round(manutencao.to_tempo_convertido((decode(op.tempo_execucao_ajustado,to_dsinterval('+000000000 00:00:00'),pe.tempo_execucao,op.tempo_execucao_ajustado)/2)*(pr.percentual_participacao/100)).horas * manutencao.to_recurso_valor(pr.especialidade_id, pr.nivel_id, pe.data_inicio,os.empresa).valor_hora,2) as valor_servico,
                           case 
                             when '#arguments.data_inicio#' >= pe.data_termino then 0
                           else 1 end executado_mes
					  from manutencao.v$ordem_servico os
					 inner join almoxarifado.v$equipamento e
							 on e.equipamento_id = os.equipamento_id
					 inner join manutencao.v$os_processos op
							 on os.ordem_servico_id = op.ordem_servico_id
					 inner join manutencao.v$processo p 
							 on p.processo_id = op.processo_id
					 inner join manutencao.v$os_processo_execucao pe
							 on pe.controle_id = op.controle_id
					 inner join manutencao.v$processo_recurso pr
							 on pr.item_id = op.processo_recurso_id
					 inner join manutencao.v$recurso_especialidade re
							 on re.especialidade_id = pr.especialidade_id
					 inner join manutencao.v$recurso_nivel rn
							 on rn.nivel_id = pr.nivel_id         
					 inner join kss.v$pessoa p 
							 on p.cod_pessoa = pe.cod_pessoa_principal
					where pe.fecha_execucao = 1        
					  and pe.cod_pessoa_auxiliar is not null
					  and trunc(pe.data_termino) between '#arguments.DATA_INICIO#' and '#arguments.DATA_TERMINO#'
					  and p.cod_pessoa = #arguments.COD_PESSOA#
					<cfif Len(Trim(arguments.especialidade_id))>
					  and re.especialidade_id = #arguments.especialidade_id#
					</cfif>
					
					UNION ALL
					
					select /*+ first_rows_1000 */ 'Auxiliar' as tipo, os.num_ordem_servico, e.cod_equipamento, pe.cod_pessoa_auxiliar as cod_pessoa, p.titulo as processo,
						   re.descricao as especialidade, rn.descricao as nivel,
						   re.descricao || rn.descricao as nivel_especialidade,
						   sysdate + ((op.tempo_execucao_ajustado/2) * (pr.percentual_participacao / 100)) - sysdate as tempo_execucao,
					       sysdate + (pe.tempo_execucao/2) - sysdate as tempo_gasto,
						   round(manutencao.to_tempo_convertido((decode(op.tempo_execucao_ajustado,to_dsinterval('+000000000 00:00:00'),pe.tempo_execucao,op.tempo_execucao_ajustado)/2)*(pr.percentual_participacao/100)).horas * manutencao.to_recurso_valor(pe.cod_pessoa_principal,pr.especialidade_id, pr.nivel_id, pe.data_termino).valor_hora,2) as valor_servico,
                           case 
                             when '#arguments.DATA_INICIO#' >= pe.DATA_TERMINO then 0
                           else 1 end executado_mes
					  from manutencao.v$ordem_servico os
					 inner join almoxarifado.v$equipamento e
							 on e.equipamento_id = os.equipamento_id
					 inner join manutencao.v$os_processos op
							 on os.ordem_servico_id = op.ordem_servico_id
					 inner join manutencao.v$processo p 
							 on p.processo_id = op.processo_id
					 inner join manutencao.v$os_processo_execucao pe
							 on pe.controle_id = op.controle_id
					 inner join manutencao.v$processo_recurso pr
							 on pr.item_id = op.processo_recurso_id
					 inner join manutencao.v$recurso_especialidade re
							 on re.especialidade_id = pr.especialidade_id
					 inner join manutencao.v$recurso_nivel rn
							 on rn.nivel_id = pr.nivel_id         
					 inner join kss.v$pessoa p 
							 on p.cod_pessoa = pe.cod_pessoa_auxiliar
					where pe.fecha_execucao = 1        
					  and trunc(pe.data_termino) between '#arguments.DATA_INICIO#' and '#arguments.DATA_TERMINO#'
					  and p.cod_pessoa = #arguments.COD_PESSOA#
					<cfif Len(Trim(arguments.especialidade_id))>
					  and re.especialidade_id = #arguments.especialidade_id#
					</cfif>) t
                     order by num_ordem_servico, nivel_especialidade
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca tabelas de manuteno na OS
	-- NOTAS EXPLICATIVAS
	-- GUTO 11/10/2006
	--->
	<cffunction name="get_os_tabelas" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ot.controle_id, os.ordem_servico_id, os.num_ordem_servico, ot.confirmada,
					   ot.tabela_id, tm.nome, nvl((select min(oa.executada)
												   from manutencao.v$os_atividade oa
												  where oa.controle_id_tabela = ot.controle_id),1) as executada,
				   manutencao.to_tempo_execucao(numtodsinterval(nvl((select sum(sysdate+oa.tempo_execucao_oficina-sysdate)
																	   from manutencao.v$os_atividade oa
																	  where oa.controle_id_tabela = ot.controle_id),0),'DAY')).retorno as tempo_execucao
			 from manutencao.v$ordem_servico os
			inner join manutencao.v$os_tabela_manutencao ot
				 on ot.ordem_servico_id = os.ordem_servico_id
			inner join manutencao.v$tabela_manutencao tm
					   on tm.tabela_id = ot.tabela_id
			where 1=1
			  and os.ordem_servico_id = #arguments.ordem_servico_id#
			order by ot.date_insert
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca atividades da OS
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 30/04/2010 - ALTERADO
	--->
	<cffunction name="get_os_atividades" returntype="query" access="remote">
		<cfargument name="controle_id" required="no" default="">
		<cfargument name="ordem_servico_id" required="no" default="">
		<cfargument name="verificacao" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select os.ordem_servico_id
                 , op.controle_id
                 , oa.controle_id as controle_id_atividade
                 , oa.atividade_id
                 , oa.controle_id_tabela
                 , a.titulo
                 , manutencao.to_os_atividade(oa.controle_id).material_ok as material_ok
                 , manutencao.to_material_dados(manutencao.to_os_atividade(oa.controle_id).material_id).descricao_completa as material_utilizado
                 , a.cod_atividade
                 , os.valor_servico
                 , oa.valor_servico as valor_servico_atividade
                 , (select count(*)
                      from manutencao.v$os_atividade oa2
                     where oa2.ordem_servico_id = os.ordem_servico_id
                       and oa2.atividade_id = oa.atividade_id) as quantidade
                 , (select data_previsao
                      from manutencao.v$equipamento_atividade ea
                     where ea.equipamento_id = os.equipamento_id
                       and ea.ordem_servico_id_execucao = os.ordem_servico_id
                       and ea.atividade_id = oa.atividade_id) as data_previsao
                 , (select km_previsao
                      from manutencao.v$equipamento_atividade ea
                     where ea.equipamento_id = os.equipamento_id
                       and ea.ordem_servico_id_execucao = os.ordem_servico_id
                       and ea.atividade_id = oa.atividade_id) as km_previsao
                 , case                 
                 when oa.gerada_por = 1 then 'Sistema'
               when oa.gerada_por = 2 then 'Solicitao Mot.'
                      else 'Check List'
                   end gerada_por
                 , oa.executada
                 , manutencao.to_tempo_execucao(nvl(oa.tempo_execucao_ajustado, numtodsinterval(0, 'DAY'))).retorno as tempo_execucao
                 , oa.date_insert
                 , oa.posicao_id
                 , nvl(ep.posicao, 'nica') as posicao
            from manutencao.v$ordem_servico os
      inner join manutencao.v$os_atividade oa
              on oa.ordem_servico_id = os.ordem_servico_id 
      inner join manutencao.v$atividade a
              on a.atividade_id = oa.atividade_id
       left join manutencao.v$os_processo_atividade pa
              on pa.controle_id_atividade = oa.controle_id
       left join manutencao.v$os_processos op
              on op.controle_id = pa.controle_id_processo
       left join manutencao.v$equipamento_posicao ep
              on ep.posicao_id = oa.posicao_id
                 where 1=1
			 <cfif Len(Trim(arguments.ordem_servico_id))>
                 and os.ordem_servico_id = #arguments.ordem_servico_id#
             </cfif>
             <cfif Len(Trim(arguments.controle_id))>
                 and oa.controle_id = #arguments.controle_id#
             </cfif>
             <cfif arguments.verificacao eq 1>
                 and a.verificacao = 1
             </cfif>
           order by oa.date_insert
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca processos da OS
	-- NOTAS EXPLICATIVAS
	-- GUTO 11/10/2006
	--->
	<cffunction name="get_os_processos" returntype="query" access="remote">
		<cfargument name="controle_id" required="no" default="">
		<cfargument name="execucao_id" required="no" default="">
		<cfargument name="ordem_servico_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select os.ordem_servico_id, oa.controle_id as controle_id_atividade, oa.atividade_id,
   								a.titulo as atividade, nvl(p.titulo,a.titulo) as processo, opa.CONTROLE_ID_PROCESSO, 
			   					case 
						 				when oa.gerada_por = 1 then 'Sistema'
							    when oa.gerada_por = 2 then 'Solicitao Mot.'
    							else 'Check List' end gerada_por, oa.executada, 
				   				manutencao.to_tempo_execucao(nvl(oa.tempo_execucao_oficina,numtodsinterval(0,'DAY'))).retorno as tempo_execucao,
							   	oa.date_insert, p.processo_id, 
							   	nvl(ope.data_inicio,sysdate) as date_inicio, 
								   nvl(ep.posicao,'nica') as posicao, ope.execucao_id, 
											ope.cod_pessoa_principal, oper.pkg_global.fnc_busca_nome_pessoa(ope.cod_pessoa_principal) as principal,
											ope.cod_pessoa_auxiliar, oper.pkg_global.fnc_busca_nome_pessoa(ope.cod_pessoa_auxiliar) as auxiliar
						from manutencao.v$ordem_servico os
						inner join manutencao.v$os_atividade oa
						   					on oa.ordem_servico_id = os.ordem_servico_id 
						inner join manutencao.v$atividade a
						   					on a.atividade_id = oa.atividade_id
						inner join manutencao.v$os_processo_atividade opa
									on opa.controle_id_atividade = oa.controle_id
						inner join manutencao.v$os_processos op
										on op.controle_id = opa.controle_id_processo
						inner join manutencao.v$processo p
									on p.processo_id = op.processo_id
							left join manutencao.v$equipamento_posicao ep
										on ep.posicao_id = oa.posicao_id
						  left join manutencao.v$os_processo_execucao ope
							      on ope.controle_id = op.controle_id
							where 1=1
				<cfif Len(Trim(arguments.ordem_servico_id))>
					and os.ordem_servico_id = #arguments.ordem_servico_id#
				</cfif>
				<cfif Len(Trim(arguments.controle_id))>

					and op.controle_id = #arguments.controle_id#
					and (ope.execucao_id = (select max(ope2.execucao_id)
					                          from manutencao.v$os_processo_execucao ope2
											 where ope2.controle_id = op.controle_id)
										or (select max(ope2.execucao_id)
					                          from manutencao.v$os_processo_execucao ope2
											where ope2.controle_id = op.controle_id) is null)
				</cfif>
				<cfif Len(Trim(arguments.execucao_id))>
					and ope.execucao_id = #arguments.execucao_id#
				</cfif>
			order by oa.date_insert, op.date_insert 
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca posies dos materiais
	-- NOTAS EXPLICATIVAS
	-- arlen 16/10/2006
	--->
	<cffunction name="get_posicao_material" returntype="query" access="remote">
		<cfargument name="material_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select mp.item_id, mp.material_id, mp.posicao_id, ep.posicao, ep.posicao_id   
				from manutencao.v$material_posicao mp, manutencao.v$equipamento_posicao ep
				where ep.posicao_id = mp.posicao_id
			  <cfif Len(Trim(arguments.material_id))>
				and mp.material_id = #arguments.material_id#
			  </cfif>
			  order by ep.posicao 
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca todos os processos da OS
	-- NOTAS EXPLICATIVAS
	-- arlen 16/10/2006
	--->
	<cffunction name="get_os_processos_atividades" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" required="no" default="">
		<cfargument name="equipamento_id" required="no" default="">
		<cfargument name="placa" required="no" default="">
		<cfif Len(Trim(arguments.placa))>
			<cfset v_composicao = this.get_composicao(placa = arguments.placa)>
		</cfif>
		<cfif Len(Trim(arguments.equipamento_id))>
			<cfset v_composicao = this.get_composicao(equipamento_id = arguments.equipamento_id)>
		</cfif>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			    select /*+ ORDERED*/ tipo, ordem_servico_id, equipamento_id, cod_equipamento, num_ordem_servico, grupo_id,
														grupo, compartimento_id, compartimento, posicao_id, nvl(posicao, 'nica') as posicao, 
														atividade, nvl(processo,atividade) as processo, controle_id_processo, controle_id_atividade,
														executada, execucao_id, 
														cod_pessoa_principal, oper.pkg_global.fnc_busca_nome_pessoa(cod_pessoa_principal) as principal,
														cod_pessoa_auxiliar, oper.pkg_global.fnc_busca_nome_pessoa(cod_pessoa_auxiliar) as auxiliar,
														data_inicio, data_termino, tempo_estimado, tempo_execucao
			from (select 2 as tipo, os.ordem_servico_id, e.equipamento_id, e.cod_equipamento, os.num_ordem_servico, 
  				      a.grupo_id, ag.descricao as grupo, a.compartimento_id, ac.descricao as compartimento,
                  ep.posicao_id, ep.posicao, manutencao.to_tempo_execucao(p.tempo_execucao).retorno as tempo_estimado,
  				      a.titulo as atividade,  p.titulo as processo, op.controle_id as controle_id_processo, oa.controle_id as controle_id_atividade,
  				      opa.executado as executada, ope.execucao_id, ope.cod_pessoa_principal, ope.cod_pessoa_auxiliar, ope.data_inicio, ope.data_termino,
												manutencao.to_tempo_execucao(numtodsInterval(nvl(ope.data_termino,sysdate) - ope.data_inicio,'DAY')).retorno as tempo_execucao
  			  from manutencao.v$ordem_servico os
  			 inner join almoxarifado.v$equipamento e
        					 on e.equipamento_id = os.equipamento_id
  			 inner join manutencao.v$os_atividade oa
  				      	 on oa.ordem_servico_id = os.ordem_servico_id
  			 inner join manutencao.v$atividade a
        					 on a.atividade_id = oa.atividade_id
  			 left join manutencao.v$atividade_compartimento ac
        					 on ac.compartimento_id = a.compartimento_id
  			 left join manutencao.v$atividade_grupo ag
        					 on ag.grupo_id = a.grupo_id
             inner join manutencao.v$os_processo_atividade opa
         			 on opa.controle_id_atividade = oa.controle_id
  			 inner join manutencao.v$os_processos op
  				     on op.controle_id = opa.controle_id_processo
  			 inner join manutencao.v$processo p 
        			 on p.processo_id = op.processo_id
  			  left join manutencao.v$os_processo_execucao ope
  				      	 on ope.controle_id = op.controle_id
  			  left join manutencao.v$equipamento_posicao ep
        					 on ep.posicao_id = oa.posicao_id
				where os.data_fechamento is null)
			   where 1=1
			<cfif Len(Trim(arguments.ordem_servico_id))>
				and ordem_servico_id = #arguments.ordem_servico_id#
			</cfif>
			<cfif IsDefined("v_composicao")>
				and equipamento_id in (#v_composicao#)
			</cfif>
		   order by ordem_servico_id, compartimento, grupo, posicao, data_inicio 	
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca equipamentos
	-- NOTAS EXPLICATIVAS
	-- arlen 18/10/2006
	--->
	<cffunction name="get_solicitacao_equipamento" returntype="query" access="remote">
		<cfargument name="solicitacao_id" required="no" default="">
		<cfargument name="equipamento_id" required="no" default="">
		<cfargument name="cod_equipamento" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select es.solicitacao_id, es.equipamento_id, es.data_solicitacao, es.texto, es.atendida, es.ordem_servico_id_execucao, e.cod_equipamento
				  from manutencao.v$equipamento_solicitacao es, almoxarifado.v$equipamento e
    		     where 1=1
				 and e.equipamento_id = es.equipamento_id
 			  <cfif Len(Trim(arguments.solicitacao_id))>
				and es.solicitacao_id = #arguments.solicitacao_id#
			  </cfif>
			  <cfif Len(Trim(arguments.equipamento_id))>
				and es.equipamento_id = #arguments.equipamento_id#
			  </cfif>
			  <cfif Len(Trim(arguments.cod_equipamento))>
				and upper(e.cod_equipamento) like upper('%#arguments.cod_equipamento#%')
			  </cfif>
 			  order by e.cod_equipamento
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca Processos para abertos na oficina
	-- NOTAS EXPLICATIVAS
	-- GUTO 18/10/2006
	--->
	<cffunction name="get_oficina_processos" returntype="query" access="remote">
		<cfargument name="cod_pessoa" required="no" default="">
        <cfargument name="ultima_execucao" required="no" default="">
		<cfquery result="query" name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
 					select x.tipo,
                           x.ordem_servico_id,
                           x.empresa,
                           x.cod_pessoa_oficina,
                           x.equipamento_id,
                           x.cod_equipamento,
                           x.num_ordem_servico,
                           x.grupo_id,
                           x.grupo,
                           x.compartimento_id,
                           x.compartimento,
                           x.posicao_id,
                           x.posicao,
                           x.atividade,
                           x.atividade_id,
                           x.processo_id,
                           x.processo,
                           x.executada,
                           x.execucao_id,
                           x.controle_id_processo,
                           x.controle_id_atividade,
                           x.cod_pessoa_principal,
                           x.principal,
                           x.cod_pessoa_auxiliar,
                           x.auxiliar,
                           x.data_inicio,
                           x.data_termino,
                           x.tempo_estimado,
                           x.tempo_execucao,
                           x.tempo_execucao_min,
                           x.ordem_processo,
                           x.verificacao,
                           x.tempo_total_os,
                           x.tempo_total_oficina,
                           rownum as linha_controle
                      from (select /*+ ORDERED USE_HASH(PO PR) PARALLEL*/
                                distinct po.tipo,
                                         po.ordem_servico_id,
                                         po.empresa,
                                         po.cod_pessoa_oficina,
                                         po.equipamento_id,
                                         po.cod_equipamento,
                                         po.num_ordem_servico,
                                         po.grupo_id,
                                         nvl(po.grupo, 'Veculo') as grupo,
                                         po.compartimento_id,
                                         nvl(po.compartimento, 'Veculo') as compartimento,
                                         po.posicao_id,
                                         po.posicao,
                                         po.atividade,
                                         po.atividade_id,
                                         po.processo_id,
                                         po.processo,
                                         po.executada,
                                         po.execucao_id,
                                         po.controle_id_processo,
                                         po.controle_id_atividade,
                                         po.cod_pessoa_principal,
                                         po.principal,
                                         po.cod_pessoa_auxiliar,
                                         po.auxiliar,
                                         po.data_inicio,
                                         po.data_termino,
                                         po.tempo_estimado,
                                         po.tempo_execucao,
                                         po.tempo_execucao_min,
                                         po.ordem_processo,
                                         po.verificacao,
                                         manutencao.to_tempo_execucao(manutencao.sum_dsinterval(po.tempo_execucao_interval)
                                                                      over(partition by
                                                                           po.ordem_servico_id order by
                                                                           po.ordem_servico_id)) .retorno as tempo_total_os,
                                         manutencao.to_tempo_execucao(manutencao.sum_dsinterval(po.tempo_execucao_interval)
                                                                      over()) .retorno as tempo_total_oficina
                                  from manutencao.v$processos_oficina po
                                 inner join manutencao.v$processo_recurso pr on po.processo_id =
                                                                                pr.processo_id
                                where po.cod_pessoa_oficina = #session.cod_pessoa#
                                    and po.executada = 0 
                                   and not exists (select 'x'
                                                      from manutencao.v$os_processo_execucao ope2
                                       where ope2.controle_id = po.controle_id_processo
                                         and ope2.data_termino is null)							
                                    <cfif Len(Trim(arguments.cod_pessoa))>
                                        and exists (select 'x' 
                                                          from manutencao.v$recurso re
                                                    where (re.especialidade_id = pr.especialidade_id
                                                                or pr.especialidade_id is null)
                                                            and re.nivel_id <= nvl(pr.nivel_id,po.nivel_id)
                                                            and re.cod_pessoa = #arguments.cod_pessoa#)
                                    </cfif>
                                    <cfif arguments.ultima_execucao eq 1>
                                        and nvl(po.execucao_id, -1) = nvl((select max(po2.execucao_id) keep(dense_rank last order by po2.data_inicio)
                                                                             from manutencao.v$processos_oficina po2
                                                                            where po2.controle_id_processo = po.controle_id_processo), -1)
                                    </cfif>
                                order by cod_equipamento, ordem_servico_id, compartimento, grupo, posicao, atividade, atividade_id, ordem_processo, data_inicio) x
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca Processos para abertos na oficina
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 25/09/2009 - EDITADO
	--->
	<cffunction name="print_oficina_processos" returntype="query" access="remote" output="true">
		<cfargument name="cod_pessoa" required="no" default="">
		<cfargument name="aberta" required="no" default="">
		<cfargument name="controle_id_processo" required="no" default="">
        <cfargument name="ordem_servico_id" required="no" default="">
        <cfargument name="equipamento_id" required="no" default="">
        <cfargument name="verificacao" required="no" default="0">
        <cfargument name="externa" required="no" default="0" hint="0-No; 1-Sim">
        <cfargument name="ultima_execucao" required="no" default="0" hint="0-No; 1-Sim">
		<cfquery result="query" name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select tipo, rownum as linha_controle, ordem_servico_id,empresa,cod_pessoa_oficina,equipamento_id,
                   cod_equipamento,agrupamento,num_ordem_servico,grupo_id,grupo,
                   compartimento_id,compartimento,posicao_id,posicao,atividade,
                   processo_id,processo,executada,execucao_id,controle_id_processo,
                   controle_id_atividade,cod_pessoa_principal,principal,cod_pessoa_auxiliar,
                   auxiliar,data_inicio,data_termino,tempo_estimado,tempo_execucao,
                   ordem_processo,nome_mecanico,nivel_id,especialidade_id
              from (select distinct po.tipo, 
                           po.ordem_servico_id,
                           po.empresa,
                           po.cod_pessoa_oficina,
                           po.equipamento_id,
                           po.cod_equipamento,
                           po.cod_equipamento || ' > ' || nvl(po.compartimento, 'Veculo') as agrupamento,
                           po.num_ordem_servico,
                           po.grupo_id,
                           nvl(po.grupo, 'Veculo') as grupo,
                           po.compartimento_id,
                           nvl(po.compartimento, 'Veculo') as compartimento,
                           po.posicao_id,
                           po.posicao,
                           po.atividade || ' > ' || nvl(po.grupo, 'Veculo') as atividade,
                           po.processo_id,
                           po.processo,
                           po.executada,
                           po.execucao_id,
                           po.controle_id_processo,
                           po.controle_id_atividade,
                           po.cod_pessoa_principal,
                           po.principal,
                           po.cod_pessoa_auxiliar,
                           po.auxiliar,
                           po.data_inicio,
                           po.data_termino,
                           po.tempo_estimado,
                           po.tempo_execucao,
                           po.ordem_processo,
                           p.cliente as nome_mecanico,
                           0 as nivel_id,
                           0 as especialidade_id
                      from manutencao.v$processos_oficina po
                     left join manutencao.v$processo_recurso pr
                             on po.processo_id = pr.processo_id
                    <cfif arguments.externa eq 1>
                     left join kss.v$pessoa p
                             on p.cod_pessoa = po.cod_pessoa_oficina
                    <cfelse>
                     left join kss.v$pessoa p
                             on p.cod_pessoa = po.cod_pessoa_principal
                     left join manutencao.v$recurso r
                             on r.cod_pessoa = p.cod_pessoa
                            and r.especialidade_id = pr.especialidade_id
                    </cfif>
                     where 1 = 1
                       and po.executada = 0
                    <cfif arguments.externa eq 0>
                       and po.cod_pessoa_oficina = #session.cod_pessoa#
                    </cfif>
                    <cfif Len(Trim(arguments.cod_pessoa))>
                       and po.cod_pessoa_principal = #arguments.cod_pessoa#
                    </cfif>
                    <cfif Len(Trim(arguments.aberta))>
                       and po.data_termino is null
                    </cfif>
                    <cfif Len(Trim(arguments.controle_id_processo))>
                       and po.controle_id_processo in (#arguments.controle_id_processo#)
                    </cfif>
                    <cfif Len(Trim(arguments.ordem_servico_id))>
                       and po.ordem_servico_id = #arguments.ordem_servico_id#
                    </cfif>
                    <cfif Len(Trim(arguments.equipamento_id))>
                       and po.equipamento_id = #arguments.equipamento_id#
                    </cfif>
                    <cfif arguments.verificacao eq 1>
                       and po.verificacao = 1
                    </cfif>
                    <cfif arguments.ultima_execucao eq 1>
                       and po.execucao_id = (select max(po2.execucao_id) keep(dense_rank last order by po2.data_inicio)
                                               from manutencao.v$processos_oficina po2
                                              where po2.processo_id = po.processo_id
                                                and po2.executada = po.executada
                                                and po2.execucao_id is not null
                                                and po2.cod_pessoa_oficina = po.cod_pessoa_oficina
                                                and po2.cod_pessoa_principal = po.cod_pessoa_principal
                                            )
                    </cfif>
                     order by ordem_servico_id, compartimento, grupo, posicao, atividade, ordem_processo, data_inicio)
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>				
				
	<!--- 
	-- PROPSITO 
	-- Busca Processos para abertos na oficina
	-- NOTAS EXPLICATIVAS
	-- GUTO 18/10/2006
	--->
	<cffunction name="get_material_atividade" returntype="query" access="remote">
		<cfargument name="MATERIAL_ID" required="yes" >
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
 				select mab.material_id,
					   mab.atividade_id,
					   atv.titulo
				  from manutencao.v$material_atividade_baixa mab
	    	inner join manutencao.v$atividade atv
					on atv.atividade_id = mab.atividade_id
				 where 1=1 
				   and mab.material_id = #arguments.MATERIAL_ID#
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca OS de funcionrios para impresso
	-- NOTAS EXPLICATIVAS
	-- ARLEN 30/11/2006
	--->
	<cffunction name="get_impressao_os" returntype="query" access="remote">
		<cfargument name="COD_PESSOA_PRINCIPAL" required="yes" >
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
 			select pe.execucao_id,
			  from v$os_processo_execucao pe
			 where 1 = 1	
			<cfif len(Trim(arguments.COD_PESSOA_PRINCIPAL))>
			   and pe.cod_pessoa_principal in (#arguments.COD_PESSOA_PRINCIPAL#)
		    </cfif>
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca as ocorrncias de Previso de Liberaco 
	-- NOTAS EXPLICATIVAS
	-- WAGNER 05/12/2006
	--->
	<cffunction name="get_liberacao" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" default="" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
 			select t.previsao_id,
				   t.ordem_servico_id,
			       to_char(t.data_previsao,'dd/mm/yyyy hh24:mi') as data_previsao,
    			   t.responsavel as responsavel,
     			   t.motivo_adiamento,
				   t.date_update
  			  from manutencao.v$os_previsao_liberacao t
  			 where t.ordem_servico_id = #arguments.ordem_servico_id#
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Busca oficinas cadastradas
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO - 10/04/2007 - criado
	--->	
	<cffunction name="get_oficinas" displayname="" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="no" default=""/>
		<cfargument name="interna" required="no" default=""/>
		<cfargument name="com_os" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select o.cod_pessoa, o.cnpj_cpf, o.identificador, o.inscricao_estadual, 
				   o.razao_social, o.cliente 
			  from manutencao.v$oficinas o
			 where 1=1
			 <cfif Len(Trim(arguments.COD_PESSOA))>
			   and cod_pessoa = #arguments.COD_PESSOA#
			 </cfif>
			 <cfif Len(Trim(arguments.INTERNA))>
			   and interna= #arguments.INTERNA#
			 </cfif>
			 <cfif Len(Trim(arguments.COM_OS))>
			   and exists (select 'x'
			                 from manutencao.v$ordem_servico os
							where os.cod_pessoa_oficina = o.cod_pessoa)
			 </cfif>
			 order by cliente
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Busca pessoas que so proprietarias de equipamentos na empresa
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO - 10/04/2007 - criado
	--->	
	<cffunction name="get_proprietarios" displayname="" access="remote" returntype="query" output="true">
    	<cfargument name="controla_manutencao" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
            select p.cod_pessoa
                 , p.cnpj_cpf
                 , p.identificador
                 , p.inscricao_estadual
                 , p.razao_social
                 , p.cliente
              from manutencao.v$proprietarios p
             where 1 = 1
			<cfif Len(Trim(arguments.controla_manutencao))>
               and (oper.pkg_agregado.fnc_consulta_valor(40, sysdate, p.cod_pessoa, 1) = #arguments.controla_manutencao#
                    or exists (select 1
                                 from kss.v$pessoa_modalidade pm
                                where pm.cod_pessoa = p.cod_pessoa
                                  and pm.num_modalidade in (9,23)
                              )
                   )
			</cfif>
             order by p.cliente
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>		

	<!--- 
	-- PROPSITO 
	-- Busca as atividades da OS 
	-- NOTAS EXPLICATIVAS
	-- WAGNER 05/12/2006
	--->
	<cffunction name="get_atividade_os" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" default="" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select 	atv.titulo,
				 		decode(otv.executada,0,'No','Sim') as executada,
				 		manutencao.to_tempo_execucao(nvl(atv.tempo_execucao,numtodsinterval(0,'DAY'))).retorno as tempo_execucao
		   		  from manutencao.v$os_atividade otv
	 		inner join manutencao.v$atividade atv 
			 		on atv.atividade_id = otv.atividade_id
		   		 where otv.ordem_servico_id = #arguments.ordem_servico_id#
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca as oficinas a que os funcionrios esto vinculados
	-- NOTAS EXPLICATIVAS
	-- ARLEN 04/12/2006
	--->
	<cffunction name="get_oficina_recurso" returntype="query" access="remote">
		<cfargument name="RECURSO_ID" required="no" default="" >
		<cfargument name="COD_PESSOA" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
 			select ro.recurso_id,
				   ro.cod_pessoa_oficina,
				   ro.data_inicio,
				   ro.data_fim,
				   to_char(ro.data_inicio,'dd/mm/yyyy') data_inicio_char,
				   to_char(ro.data_fim,'dd/mm/yyyy') data_fim_char
			from manutencao.v$recurso_oficina ro
			inner join manutencao.v$recurso re on re.recurso_id in ro.recurso_id
			where 1 = 1
			<cfif len(Trim(arguments.RECURSO_ID))>
			   and ro.recurso_id in (#arguments.RECURSO_ID#)
		    </cfif>
			<cfif len(Trim(arguments.COD_PESSOA))>
			    and re.COD_PESSOA = #arguments.COD_PESSOA#
		    </cfif>
		    order by ro.data_inicio desc
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
    
	<!--- 
	-- PROPSITO 
	-- Busca as oficinas distintas a que os funcionrios esto vinculados
	-- NOTAS EXPLICATIVAS
	-- ERICG 21/10/2010
	--->
	<cffunction name="get_distinct_oficina_recurso" returntype="query" access="remote">
		<cfargument name="RECURSO_ID" required="no" default="" >
		<cfargument name="COD_PESSOA" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
          select distinct ro.cod_pessoa_oficina
               , to_char(ro.data_inicio, 'dd/mm/yyyy') data_inicio
               , to_char(ro.data_fim, 'dd/mm/yyyy') data_fim
            from manutencao.v$recurso_oficina ro
           inner join manutencao.v$recurso re
                   on re.recurso_id in ro.recurso_id
           where 1 = 1            
			<cfif len(Trim(arguments.RECURSO_ID))>
			   and ro.recurso_id in (#arguments.RECURSO_ID#)
		    </cfif>
			<cfif len(Trim(arguments.COD_PESSOA))>
			    and re.COD_PESSOA = #arguments.COD_PESSOA#
		    </cfif>
		    order by data_inicio desc
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>    
	
	<!--- 
	-- PROPSITO 
	-- Busca os valores dos nveis de especialidades
	-- NOTAS EXPLICATIVAS
	-- ARLEN 11/12/2006
	--->
	<cffunction name="get_especialidade_valor" returntype="query" access="remote">
		<cfargument name="CONTROLE_ID" required="no" default="" >
		<cfargument name="ESPECIALIDADE_ID" required="no" default="" >
		<cfargument name="NIVEL_ID" required="no" default="" >
		<cfargument name="ABERTOS" required="no" default="" >
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ev.controle_id,
				   ev.especialidade_id,
				   ev.nivel_id,
				   ev.valor_empresa,
				   ev.valor_terceiro,
				   to_char(ev.data_inicio,'dd/mm/yyyy hh24:mi:ss') data_inicio_char,
				   to_char(ev.data_fim,'dd/mm/yyyy hh24:mi:ss') data_fim_char,
				   re.descricao as especialidade_nome,
				   rn.descricao as nivel_nome       
			from manutencao.v$especialidade_valor ev
			inner join manutencao.v$recurso_especialidade re
					   on re.especialidade_id = ev.especialidade_id
			inner join manutencao.v$recurso_nivel rn
					   on rn.nivel_id = ev.nivel_id
			where 1=1
			<cfif len(Trim(arguments.ABERTOS))>
			  and ev.data_fim is null
			</cfif>
			<cfif len(Trim(arguments.CONTROLE_ID))>
			  and ev.controle_id = #arguments.CONTROLE_ID#
			</cfif>
			<cfif len(Trim(arguments.ESPECIALIDADE_ID))>
			  and ev.especialidade_id = #arguments.ESPECIALIDADE_ID#
			</cfif>
			<cfif len(Trim(arguments.NIVEL_ID))>
			  and ev.nivel_id = #arguments.NIVEL_ID#
			</cfif>
			order by ev.data_inicio desc, re.descricao
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca Processos para abertos na oficina
	-- NOTAS EXPLICATIVAS
	-- ARLEN 13/12/2006
	--->
	<cffunction name="get_atividade_equipamento" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" required="no" default="">
		<cfargument name="num_ordem_servico" required="no" default="">
		<cfargument name="equipamento_id" required="no" default="">
		<cfargument name="atividade_id" required="no" default="">
		<cfargument name="data_inicio" required="no" default="">
		<cfargument name="data_fim" required="no" default="">
		<cfargument name="empresa" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct po.tipo, po.ordem_servico_id, po.num_ordem_servico, po.empresa, po.cod_pessoa_oficina, po.equipamento_id, 
				   po.cod_equipamento,
				   po.cod_equipamento || ' > ' || nvl(po.compartimento,'Veculo')  || ' > ' || nvl(po.grupo,'Veculo') as agrupamento,
				   po.num_ordem_servico, po.grupo_id, nvl(po.grupo,'Veculo') as grupo, po.compartimento_id, nvl(po.compartimento,'Veculo') as compartimento, po.posicao_id,
				   po.posicao, po.atividade, po.processo_id, po.processo, po.executada, po.execucao_id, 
				   po.controle_id_processo, po.controle_id_atividade,
				   po.cod_pessoa_principal, po.principal, po.cod_pessoa_auxiliar, po.auxiliar, 
				   po.data_inicio, po.data_termino, po.tempo_estimado, po.tempo_execucao, 
				   po.ordem_processo,
				   os.data_abertura as data_abertura
			  from manutencao.v$processos_oficina po
			 inner join manutencao.v$processo_recurso pr
					 on po.processo_id = pr.processo_id
			 inner join manutencao.v$ordem_servico os
       				 on os.ordem_servico_id = po.ordem_servico_id
			 <cfif len(Trim(atividade_id))>
			 inner join manutencao.v$atividade_processo ap 
			 		 on ap.processo_id = po.processo_id
			 inner join manutencao.v$atividade a
            		 on a.atividade_id = ap.atividade_id
			 </cfif>
			 where 1=1
			 <cfif len(Trim(ordem_servico_id))>
			   and po.ordem_servico_id = #arguments.ordem_servico_id#
			 </cfif> 
			 <cfif len(Trim(num_ordem_servico))>
			   and po.num_ordem_servico = #arguments.num_ordem_servico#
			 </cfif>
			 <cfif len(Trim(equipamento_id))>
			   and po.equipamento_id = #arguments.equipamento_id#
			 </cfif>
			 <cfif len(Trim(atividade_id))>
			   and a.atividade_id in (#arguments.atividade_id#)
			 </cfif>
			 <cfif Len(Trim(arguments.empresa))>
			   and os.empresa= #arguments.empresa#
			  </cfif>		  
			  <cfif Len(Trim(arguments.data_inicio))	and Len(Trim(arguments.data_fim))>
			   and os.data_abertura between '#LSDateFormat(arguments.data_inicio,'dd/mm/yyyy')#' and '#LSDateFormat(arguments.data_fim,'dd/mm/yyyy')#'
			 </cfif>		 
			 order by ordem_servico_id, compartimento, grupo, posicao,  atividade, ordem_processo, data_inicio
 		 </cfquery>		
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca todos os procesoss executados por OS
	-- NOTAS EXPLICATIVAS
	-- GUTO 04/10/2006
	--->
	<cffunction name="get_processo_execucao" returntype="query" access="remote">
		<cfargument name="num_ordem_servico" required="no" default="">
		<cfargument name="cod_equipamento" required="no" default="">
		<cfargument name="cod_pessoa_principal" required="no" default="">
		<cfargument name="data_inicio" required="no" default="">
		<cfargument name="data_termino" required="no" default="">
		<cfquery result="query" name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select op.controle_id,
					 os.num_ordem_servico, 
					 e.cod_equipamento,
					 p.titulo as processo, re.descricao as especialidade,
					 rn.descricao as nivel,
					 extract(hour from op.tempo_execucao_ajustado) as horas,
					 manutencao.to_tempo_execucao(op.tempo_execucao_sistema,3).retorno as tempo_execucao_sistema, 
					 manutencao.to_tempo_execucao(op.tempo_execucao_oficina,3).retorno as tempo_execucao_oficina,
					 manutencao.to_tempo_execucao(op.tempo_execucao_ajustado,3).retorno as tempo_execucao_ajustado
			  from manutencao.v$ordem_servico os
			 inner join almoxarifado.v$equipamento e
						on e.equipamento_id = os.equipamento_id
			 inner join manutencao.v$os_processos op
						on op.ordem_servico_id = os.ordem_servico_id
			 inner join manutencao.v$processo_recurso pr
						on pr.item_id = op.processo_recurso_id
			 inner join manutencao.v$processo p
						on p.processo_id = op.processo_id
			 inner join manutencao.v$recurso_especialidade re
						on re.especialidade_id = pr.especialidade_id
			 inner join manutencao.v$recurso_nivel rn
						on rn.nivel_id = pr.nivel_id 
			 inner join manutencao.v$os_processo_execucao ope
						on ope.controle_id = op.controle_id
					  and ope.fecha_execucao = 1
			  where 1=1
			  <cfif Len(Trim(arguments.num_ordem_servico))>
			  	 and os.num_ordem_servico = #arguments.num_ordem_servico#
			  </cfif>		  
			  <cfif Len(Trim(arguments.equipamento_id))>
			  	 and e.equipamento_id = #arguments.equipamento_id#
			  </cfif>		  
			  <cfif Len(Trim(arguments.cod_equipamento))>
			  	 and e.cod_equipamento = '#arguments.cod_equipamento#'
			  </cfif>		  
			  <cfif Len(Trim(arguments.cod_pessoa_principal))>
			  	 and ope.cod_pessoa_principal = #arguments.cod_pessoa_principal#
			  </cfif>		  
			  <cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_termino))>
			  	 and trunc(ope.data_termino) between '#arguments.data_inicio#' and '#arguments.data_termino#'
			  </cfif>
     	</cfquery>		
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca todos as atividades executados por OS
	-- NOTAS EXPLICATIVAS
	-- GUTO 27/02/2007
	--->
	<cffunction name="get_atividade_execucao" returntype="query" access="remote">
		<cfargument name="num_ordem_servico" required="no" default="">
		<cfargument name="cod_equipamento" required="no" default="">
		<cfargument name="cod_pessoa_principal" required="no" default="">
		<cfargument name="data_inicio" required="no" default="">
		<cfargument name="data_termino" required="no" default="">
		<cfquery result="query" name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select oa.controle_id,
  					 os.num_ordem_servico, 
  					 e.cod_equipamento,
  					 a.titulo as atividade, a.cod_atividade,
  					 extract(hour from oa.tempo_execucao_ajustado) as horas,
  					 manutencao.to_tempo_execucao(oa.tempo_execucao_sistema,3).retorno as tempo_execucao_sistema, 
  					 manutencao.to_tempo_execucao(oa.tempo_execucao_ajustado,3).retorno as tempo_execucao_ajustado
			  from manutencao.v$ordem_servico os
			 inner join almoxarifado.v$equipamento e
					 on e.equipamento_id = os.equipamento_id
			 inner join manutencao.v$os_atividade oa
			   	     on oa.ordem_servico_id = os.ordem_servico_id
	         inner join manutencao.v$atividade a
                     on a.atividade_id = oa.atividade_id
			  where 1=1
			  <cfif Len(Trim(arguments.num_ordem_servico))>
			  	 and os.num_ordem_servico = #arguments.num_ordem_servico#
			  </cfif>		  
			  <cfif Len(Trim(arguments.equipamento_id))>
			  	 and e.equipamento_id = #arguments.equipamento_id#
			  </cfif>		  
			  <cfif Len(Trim(arguments.cod_equipamento))>
			  	 and e.cod_equipamento = '#arguments.cod_equipamento#'
			  </cfif>		  
			  <cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_termino))>
			  	 and trunc(os.data_abertura) between '#arguments.data_inicio#' and '#arguments.data_termino#'
			  </cfif>
     	</cfquery>		
		<cfreturn qr_result>
	</cffunction>
		
	<!--- 
	-- PROPSITO 
	-- Busca processos relacionados aos recursos
	-- NOTAS EXPLICATIVAS
	-- ARLEN 18/12/2006
	--->
	<cffunction name="get_processos_recursos" returntype="query" access="remote">
		<cfargument name="ATIVIDADE_ID" required="no" default="" >
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select pr.item_id,
				   pr.processo_id,
				   pr.especialidade_id,
				   pr.nivel_id,
				   pr.quantidade,
				   pr.percentual_participacao,
				   p.titulo as titulo_processo,
				   p.detalhamento,
				   manutencao.to_tempo_execucao(p.tempo_execucao, 3) .retorno as tempo_execucao,
				   a.atividade_id,
				   a.cod_atividade,
				   a.titulo,
				   re.descricao as descricao_especialidade,
				   rn.descricao as descricao_nivel,
				   ag.grupo_id,
				   ag.descricao
			  from manutencao.v$processo_recurso pr
			 inner join manutencao.v$processo p 
			 			on pr.processo_id = p.processo_id
			 inner join manutencao.v$atividade_processo ap 
			 			on ap.processo_id = p.processo_id
			 inner join manutencao.v$atividade a 
			 			on a.atividade_id = ap.atividade_id
			 inner join manutencao.v$recurso_especialidade re
			 			on re.especialidade_id = pr.especialidade_id
			 inner join manutencao.v$recurso_nivel rn 
			 			on rn.nivel_id = pr.nivel_id
			 inner join manutencao.v$atividade_grupo ag 
            			on ag.grupo_id = a.grupo_id
			 where 1 = 1
 			<cfif len(Trim(arguments.ATIVIDADE_ID))>
			  and a.atividade_id = #arguments.ATIVIDADE_ID#
			</cfif>
			order by ag.descricao, a.titulo, p.titulo
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca ordens de compra cadastradas
	-- NOTAS EXPLICATIVAS
	-- GUTO 19/12/2006
	--->
	<cffunction name="get_ordem_compra_nota_fiscal" returntype="query" access="remote">
		<cfargument name="NUM_CONTROLE" required="no" default="" >
		<cfargument name="NUM_NOTA_FISCAL" required="no" default="" >
		<cfargument name="NUM_NOTA_ID" required="no" default="" >
		<cfargument name="DATA_EMISSAO" required="no" default="" >
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
              select oc.titulo, oc.empresa, oc.num_controle, oc.cod_pessoa_emissao, em.cliente as emissao,
                   oc.cod_pessoa_autorizacao, aut.cliente as autorizacao,
                   to_char(oc.data_emissao,'dd/mm/yyyy') as data_emissao, 
                   oc.num_documento, oc.cod_pessoa_fornecedor, f.cliente as fornecedor,
                   oc.nome_responsavel, oc.condicao_pagto, oc.equipamento_id,
                   manutencao.to_equipamento_dados(oc.equipamento_id,sysdate).placa as placa,
                   oc.km_veiculo, oc.total_orcado, oc.total_desconto, oc.total_combinado,
                   oc.observacao, oc.situacao, nt.num_nota_fiscal, nf.valor_utilizado
                from manutencao.v$ordem_compra oc
                     inner join manutencao.v$nf_terceiro_ordem_compra nf
                              on nf.ordem_compra_id = oc.num_controle	
                     inner join fiscal.v$nf_terceiro nt
                             on nt.num_nota_id = nf.nf_terceiro_id
               inner join kss.v$pessoa em
                    on em.cod_pessoa = oc.cod_pessoa_emissao
               inner join kss.v$pessoa aut
                    on aut.cod_pessoa = oc.cod_pessoa_autorizacao
               inner join kss.v$pessoa f
                    on f.cod_pessoa = oc.cod_pessoa_fornecedor             
               where 1=1
			<cfif len(Trim(arguments.NUM_CONTROLE))>
			  and oc.num_controle = #arguments.NUM_CONTROLE#
			</cfif>
			<cfif len(Trim(arguments.num_nota_fiscal))>
			   and nt.num_nota_fiscal = #arguments.num_nota_fiscal#
			</cfif>
			<cfif len(Trim(arguments.DATA_EMISSAO))>
			  and trunc(oc.data_emissao) = '#arguments.DATA_EMISSAO#'
			</cfif>
			<cfif len(Trim(arguments.NUM_NOTA_ID))>
			   and nt.num_nota_id = #arguments.NUM_NOTA_ID#
			</cfif>
			order by oc.num_documento, oc.num_controle
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>    

	<!---  
    -- PROPSITO  
    -- Busca itens de ordens de compra cadastradas 
    -- NOTAS EXPLICATIVAS 
    -- GUTO 19/12/2006 
    ---> 
    <cffunction name="get_ordem_compra_item" returntype="query" access="remote"> 
    <cfargument name="NUM_CONTROLE" required="no" default="" > 
    <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#"> 
        select oci.num_controle, oci.item_id, oci.descricao, oci.servico_material,  
               oci.quantidade, oci.cod_unidade, oci.valor_unitario,  
               oci.valor_total 
          from manutencao.v$ordem_compra_item oci 
         where 1=1 
		<cfif len(Trim(arguments.NUM_CONTROLE))> 
           and oci.num_controle = #arguments.NUM_CONTROLE# 
        </cfif> 
    </cfquery>  
    <cfreturn qr_result> 
    </cffunction> 
    
    
   <!---  
    -- PROPSITO  
    -- Busca itens de ordens de compra cadastradas
    -- NOTAS EXPLICATIVAS 
    -- JONAS 29/05/2009
    ---> 
    <cffunction name="get_ordem_compra_item_os" returntype="query" access="remote"> 
    <cfargument name="NUM_CONTROLE" required="no" default="" > 
    <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#"> 
        select 
             oc.num_controle,
             m.material_id,
             m.material,
             e.cod_equipamento,
             oci.quantidade,
             m.unidade_estoque,
             oci.valor_unitario,
             oci.valor_total,
             oci.posicao_id,
             (case when oci.posicao_id is null then 'nica' else ep.posicao end) as posicao
        from manutencao.v$ordem_compra oc
        inner join manutencao.v$ordem_compra_item oci
                   on oci.num_controle = oc.num_controle
       inner join almoxarifado.v$material_dados m 
                  on m.descricao_completa = oci.descricao
        left join manutencao.v$equipamento e 
                  on e.equipamento_id = oc.equipamento_id
        left join manutencao.v$equipamento_posicao ep
            on ep.posicao_id = oci.posicao_id
       where 1 = 1
       and oc.num_controle = #arguments.num_controle#
       order by oc.date_insert
    </cfquery>  
    <cfreturn qr_result> 
    </cffunction> 
    

	<!--- 
	-- PROPSITO 
	-- Busca itens de ordens vinculadas a OS
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 30/04/2010 - ALTERADO
	--->
	<cffunction name="get_ordem_compra_os" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
          select oc.num_controle
                  ,p.razao_social as titulo
                 , (select pf.cliente
                      from kss.v$pessoa pf
                     where pf.cod_pessoa = oc.cod_pessoa_fornecedor) as fornecedor
                  ,to_char(oc.data_emissao, 'dd/mm/yyyy') as data_emissao
                  ,oc.total_orcado
                  ,oc.total_desconto
                  ,oc.total_combinado
                  ,e.cod_equipamento as placa
                  ,nvl(nvl(manutencao.to_ordem_servico(os.ordem_servico_id).valor_total_servicos,0) +
                       nvl(manutencao.to_ordem_servico(os.ordem_servico_id).valor_total_material, 0), 0
                      ) as total_utilizado
              from manutencao.v$ordem_compra oc
             inner join manutencao.v$os_ordem_compra ooc
                     on ooc.num_controle = oc.num_controle
             inner join manutencao.v$ordem_servico_dados os
                     on os.ordem_servico_id = ooc.ordem_servico_id
             inner join kss.v$pessoa p
                     on p.cod_pessoa = os.cod_pessoa_oficina
             inner join almoxarifado.v$equipamento e
                     on e.equipamento_id = os.equipamento_id 
             where 1 = 1
            <cfif len(Trim(arguments.ordem_servico_id))>
               and ooc.ordem_servico_id = #arguments.ordem_servico_id#
            </cfif>
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca atividades da ordem de compra
	-- NOTAS EXPLICATIVAS
	-- GUTO 01/02/2007
	--->
	<cffunction name="get_ordem_compra_atividade" returntype="query" access="remote">
		<cfargument name="NUM_ORDEM_COMPRA" required="no" default="" >
		<cfargument name="NF_TERCEIRO_ID" required="no" default="" >
		<cfargument name="EQUIPAMENTO_ID" required="no" default="" >
		<cfargument name="COD_EQUIPAMENTO" required="no" default="" >
		<cfargument name="ABERTAS" required="no" default="0" >
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
             select ea.controle_id, ea.equipamento_id, ea.atividade_id, ag.descricao as grupo,
                   ea.posicao_id, ea.num_ordem_compra, ea.ordem_servico_id_execucao,
                   e.cod_equipamento, a.titulo, ep.posicao,
                   oc.data_emissao, oc.cod_pessoa_autorizacao, p.cliente as responsavel,
                   fr.identificador as cnpj_fornecedor, 
                   oc.num_controle, fr.cliente as fornecedor, a.cod_atividade,
                   nvl((select sum(nvl(manutencao.to_ordem_servico(ooc.ordem_servico_id).valor_total_servicos,0)) + sum(nvl(manutencao.to_ordem_servico(ooc.ordem_servico_id).valor_total_material,0))
                          from manutencao.v$os_ordem_compra ooc
                         where ooc.num_controle = oc.num_controle),0) as total_utilizado_os                   
                from manutencao.v$equipamento_atividade_oc ea
               inner join manutencao.v$ordem_compra oc
                   on oc.num_controle = ea.num_ordem_compra
               inner join kss.v$pessoa p
                   on p.cod_pessoa = oc.cod_pessoa_autorizacao         
               inner join kss.v$pessoa fr
                   on fr.cod_pessoa = oc.cod_pessoa_fornecedor
               inner join almoxarifado.v$equipamento e
                   on e.equipamento_id = ea.equipamento_id
               inner join manutencao.v$atividade a 
                      on a.atividade_id = ea.atividade_id
               inner join manutencao.v$atividade_grupo ag
                       on ag.grupo_id = a.grupo_id
                left join manutencao.v$equipamento_posicao ep
                   on ep.posicao_id = ea.posicao_id   		 
			  where 1=1
				<cfif len(Trim(arguments.COD_EQUIPAMENTO))>
				  and e.COD_EQUIPAMENTO = '#arguments.COD_EQUIPAMENTO#'
				</cfif>
				<cfif len(Trim(arguments.EQUIPAMENTO_ID))>
				  and ea.equipamento_id = #arguments.EQUIPAMENTO_ID#
				</cfif>
				<cfif len(Trim(arguments.NUM_ORDEM_COMPRA))>
				  and ea.num_ordem_compra = #arguments.NUM_ORDEM_COMPRA#
				</cfif>
				<cfif arguments.ABERTAS eq 1>
				  and ea.ordem_servico_id_execucao is null
				</cfif> 
                order by grupo
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
    

	<!--- 
	-- PROPSITO 
	-- Busca ordem de compra para equipamentos
	-- NOTAS EXPLICATIVAS
	-- GUTO 01/02/2007
	--->
	<cffunction name="get_ordem_compra_equipamento" returntype="query" access="remote">
		<cfargument name="EQUIPAMENTO_ID" required="no" default="" >
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select * from (
            select oc.num_controle, oc.titulo, oc.data_emissao, nfo.valor_utilizado,
                   nfo.nf_terceiro_id, nf.num_nota_fiscal, oc.total_combinado,
                   nvl((select sum(nvl(manutencao.to_ordem_servico(ooc.ordem_servico_id).valor_total_servicos,0)) + sum(nvl(manutencao.to_ordem_servico(ooc.ordem_servico_id).valor_total_material,0))
                          from manutencao.v$os_ordem_compra ooc
                         where ooc.num_controle = oc.num_controle),0) as total_utilizado_os
              from manutencao.v$ordem_compra oc
             inner join manutencao.v$nf_terceiro_ordem_compra nfo
                     on nfo.ordem_compra_id = oc.num_controle 
             inner join fiscal.nf_terceiro nf
                        on nf.num_nota_id = nfo.nf_terceiro_id
 	   	     where 1=1
                and oc.data_emissao > '01/07/2008'
			<cfif len(Trim(arguments.EQUIPAMENTO_ID))>
              and oc.equipamento_id = #arguments.EQUIPAMENTO_ID#
            </cfif>
            union all
            select oc.num_controle, oc.titulo, oc.data_emissao, nfo.valor_utilizado,
                   nfo.nf_terceiro_id, nf.num_nota_fiscal, oc.total_combinado,
                   nvl((select sum(nvl(manutencao.to_ordem_servico(ooc.ordem_servico_id).valor_total_servicos,0)) + sum(nvl(manutencao.to_ordem_servico(ooc.ordem_servico_id).valor_total_material,0))
                          from manutencao.v$os_ordem_compra ooc
                         where ooc.num_controle = oc.num_controle),0) as total_utilizado_os
              from manutencao.v$ordem_compra oc
             inner join manutencao.v$nf_terceiro_ordem_compra nfo
                     on nfo.ordem_compra_id = oc.num_controle 
             inner join fiscal.nf_terceiro nf
                        on nf.num_nota_id = nfo.nf_terceiro_id
              where oc.equipamento_id is null
                and oc.data_emissao > '01/07/2008'
            )
            where 1=1
              and total_utilizado_os < total_combinado
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>	    
		
	<!--- 
	-- PROPSITO 
	-- Busca ordens de compra e seus tens para mostrar no relatrio
	-- NOTAS EXPLICATIVAS
	-- ARLEN 27/12/2006
	--->
	<cffunction name="get_ordem_compra_relatorio" returntype="query" access="remote">
		<cfargument name="NUM_CONTROLE" required="no" default="" >
		<cfargument name="NUM_DOCUMENTO" required="no" default="" >
		<cfargument name="NUM_NOTA_ID" required="no" default="" >
		<cfargument name="DATA_INICIO" required="no" default="" >
		<cfargument name="DATA_FIM" required="no" default="" >
		<cfargument name="COD_PESSOA_FORNECEDOR" required="no" default="" >
		<cfargument name="APROVADA" required="no" default="" >
		<cfargument name="VINCULADA_NOTA" required="no" default="" >
		<cfargument name="CANCELADA" required="no" default="" >
		<cfargument name="COD_EQUIPAMENTO" required="no" default="" >
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select oc.titulo,
			   oc.empresa,
			   oc.num_controle,
			   oc.cod_pessoa_emissao,
			   em.cliente as emissao,
			   oc.cod_pessoa_autorizacao,
			   aut.cliente as autorizacao,
			   to_char(oc.data_emissao, 'dd/mm/yyyy') as data_emissao,
			   oc.num_documento,
			   oc.cod_pessoa_fornecedor,
			   f.cliente as fornecedor,
			   oc.nome_responsavel,
			   oc.condicao_pagto,
			   oc.equipamento_id,
			   manutencao.to_equipamento_dados(oc.equipamento_id, sysdate) .placa as placa,
			   oc.km_veiculo,

			   oc.total_orcado,
			   oc.total_desconto,
			   oc.total_combinado,
			   oc.observacao,
			   oc.situacao,
               oc.aprovada, 
               oc.cancelada,
               oc.vinculada_nota,
			   nftoc.nf_terceiro_id,
			   nftoc.num_controle as nftoc_num_controle,
			   nft.num_nota_id
		  from manutencao.v$ordem_compra oc
		 inner join kss.v$pessoa em 
                 on em.cod_pessoa = oc.cod_pessoa_emissao
		 inner join kss.v$pessoa aut 
                 on aut.cod_pessoa = oc.cod_pessoa_autorizacao
		 inner join kss.v$pessoa f 
                 on f.cod_pessoa = oc.cod_pessoa_fornecedor
         <cfif Len(Trim(arguments.COD_EQUIPAMENTO))>
           inner join almoxarifado.v$equipamento e
                       on e.equipamento_id = oc.equipamento_id
                      and e.cod_equipamento =  '#arguments.COD_EQUIPAMENTO#'
         </cfif>
		  left join manutencao.v$nf_terceiro_ordem_compra nftoc 
                 on nftoc.num_controle = oc.num_controle
		  left join fiscal.v$nf_terceiro nft 
                 on nft.num_nota_id = nftoc.nf_terceiro_id
		 where 1 = 1
		 	<cfif len(Trim(arguments.APROVADA))>
			  and oc.APROVADA = #arguments.APROVADA#
			</cfif>
		 	<cfif len(Trim(arguments.CANCELADA))>
			  and oc.CANCELADA = #arguments.CANCELADA#
			</cfif>
		 	<cfif len(Trim(arguments.VINCULADA_NOTA))>
			  and oc.VINCULADA_NOTA = #arguments.VINCULADA_NOTA#
			</cfif>
		 	<cfif len(Trim(arguments.NUM_CONTROLE))>
			  and oc.num_controle = #arguments.NUM_CONTROLE#
			</cfif>
		 	<cfif len(Trim(arguments.NUM_DOCUMENTO))>
			  and oc.num_documento = #arguments.NUM_DOCUMENTO#
			</cfif>
			<cfif len(Trim(arguments.NUM_NOTA_ID))>
			  and nft.num_nota_id = #arguments.NUM_NOTA_ID#
			</cfif>
			<cfif Len(Trim(arguments.DATA_INICIO)) and Len(Trim(arguments.DATA_FIM))>
			  and trunc(oc.data_emissao) between '#arguments.DATA_INICIO#' and '#arguments.DATA_FIM#'
			</cfif>
			<cfif len(Trim(arguments.COD_PESSOA_FORNECEDOR))>
			  and oc.cod_pessoa_fornecedor = #arguments.COD_PESSOA_FORNECEDOR#
			</cfif>
			order by oc.num_controle, oc.num_documento, nft.num_nota_id
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca todas as atividades vinculadas ao equipamento
	-- NOTAS EXPLICATIVAS
	-- GUTO 27/12/2006
	--->
	<cffunction name="get_equipamento_atividades_vinculadas" returntype="query" access="remote">
		<cfargument name="EQUIPAMENTO_ID" required="no" default="" >
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ea.controle_id, a.atividade_id, a.cod_atividade, a.titulo as atividade, 
				    decode(a.importancia,1,'Baixa',2,'Mdia','Alta') as importancia ,
					 e.cod_equipamento, ea.data_previsao, po.posicao,
					 ea.km_previsao, ea.km_rodado, ea.lts_previsao,
					 ea.data_previsao, ose.data_abertura as data_execucao,
					 manutencao.to_manut_atividade(ea.atividade_id, em.MODELO_ID).garantia_km as garantia_km,
					 manutencao.to_manut_atividade(ea.atividade_id, em.MODELO_ID).garantia_dias as garantia_dias
			  from manutencao.v$equipamento_atividade ea
			 inner join almoxarifado.v$equipamento e 
						on e.equipamento_id = ea.equipamento_id
			 inner join manutencao.v$atividade a
						on a.atividade_id = ea.atividade_id
			 left join manutencao.v$equipamento_modelo em
						on em.equipamento_id = e.equipamento_id
					  and em.data_final is null
		      left join manutencao.v$equipamento_posicao po
			         on nvl(po.posicao_id,0) = nvl(ea.posicao_id,0)
			  left join manutencao.v$ordem_servico ose
						on ose.ordem_servico_id = ea.ordem_servico_id_execucao         
			where 1=1
			<cfif len(Trim(arguments.EQUIPAMENTO_ID))>
			  and e.equipamento_id = #arguments.EQUIPAMENTO_ID#
			</cfif>
			order by ea.atividade_id, ose.data_abertura desc nulls first 			 
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
	

	<!--- 
	-- PROPSITO 
	-- Busca todas as atividades vinculadas ao equipamento
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 13/05/2010 - ALTERADO
	--->
	<cffunction name="get_tabela_atividade_posicao" returntype="query" access="remote">
		<cfargument name="TABELA_ID" required="no" default="" >
        <cfargument name="TABELAS_ARVORE" required="no" default="0" >
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct <cfif arguments.TABELAS_ARVORE eq 0>ta.tabela_id,</cfif> a.atividade_id, a.titulo as atividade, ep.posicao_id, ep.posicao
              from manutencao.v$tabela_atividade ta
             inner join manutencao.v$atividade a
                     on a.atividade_id = ta.atividade_id
              left join manutencao.v$atividade_posicao ap
                     on ap.atividade_id = a.atividade_id
              left join manutencao.v$equipamento_posicao ep
                     on ep.posicao_id = ap.posicao_id
			 where 1 = 1
			  <cfif Len(Trim(arguments.TABELA_ID))>
			     <cfif arguments.TABELAS_ARVORE eq 0>
                    and ta.tabela_id = #arguments.TABELA_ID#
                 <cfelse>
                    and ta.tabela_id in (select tm.tabela_id
                                           from manutencao.v$tabela_manutencao tm
                                          start with tm.tabela_id = #arguments.TABELA_ID#
                                        connect by prior tm.tabela_pai = tm.tabela_id
                                        )
            </cfif>
              </cfif>
              
             order by ep.posicao
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca Veculos que possuem uma determinada atividade.
	-- NOTAS EXPLICATIVAS
	-- WAGNER 29/12/2006
	--->
	<cffunction name="get_atividade_veiculo" returntype="query" access="remote">
		<cfargument name="ATIVIDADE_ID" required="no" default="">
		<cfargument name="MODALIDADE" required="no" default="">
		<cfargument name="STATUS_ID" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select *
                  from (
                select /*+ ORDERED */
					   r.equipamento_id,
					   r.controle_id,
					   r.cod_equipamento,
					   r.atividade_id,
					   r.posicao_id,
					   r.posicao,
					   r.cod_atividade,
					   r.titulo,
					   r.data_previsao,
					   r.km_previsao,
					   r.importancia,
					   r.alerta_km,
					   r.alerta_dias,
					   r.dias,
					   case
						   when r.ordem_servico_id_execucao is null and
							  r.km_atual_veiculo > r.km_previsao or
							  r.km_previsao < r.km_atual_veiculo or
							  (sysdate > r.data_previsao and
							  manutencao.to_manut_atividade(r.atividade_id)
							  .garantia_dias > 0) then -2
						   when r.ordem_servico_id_execucao is null and
							  r.km_atual_veiculo +
							  manutencao.to_manut_atividade(r.atividade_id)
							  .alerta_km > r.km_previsao or
							  (sysdate + manutencao.to_manut_atividade(r.atividade_id)
							  .alerta_dias > r.data_previsao and
							   manutencao.to_manut_atividade(r.atividade_id)
							  .garantia_dias > 0) then -1
						   when r.ordem_servico_id_execucao is null and
							  r.km_atual_veiculo <= r.km_previsao or
							  sysdate <= r.data_previsao then 1
						   else 0 end status_id,
							  r.km_previsao - r.km_atual_veiculo as km_previsto
				  from (select e.equipamento_id,
							   ea.controle_id,
							   e.cod_equipamento,
							   a.atividade_id,
							   ap.posicao_id,
							   nvl(ap.posicao, 'nica') as posicao,
							   a.cod_atividade,
							   a.titulo,
							   ea.data_previsao,
							   ea.km_previsao,
							   a.importancia,
							   ea.ordem_servico_id_execucao,
							   (select nvl(max(km), 0)
								  from oper.v$veiculo_km
								 where placa = e.cod_equipamento
								   and data_hora < sysdate) as km_atual_veiculo,
							   manutencao.to_manut_atividade(ea.atividade_id) .alerta_km as alerta_km,
							   manutencao.to_manut_atividade(ea.atividade_id) .alerta_dias as alerta_dias,
							   decode(manutencao.to_manut_atividade(ea.atividade_id).garantia_dias,0,0,
							   round(ea.data_previsao - sysdate)) as dias
						  from manutencao.v$equipamento_atividade ea
                    inner join manutencao.v$equipamento_manutencao em
                            on ea.equipamento_id = em.equipamento_id
                           and em.controla_manutencao = 1 
					inner join manutencao.v$atividade a
							on a.atividade_id = ea.atividade_id
					inner join almoxarifado.v$equipamento e
							on e.equipamento_id = ea.equipamento_id
					 left join manutencao.v$equipamento_posicao ap

							on ea.posicao_id = ap.posicao_id
						 where 1 = 1
						<cfif Len(Trim(arguments.atividade_id))>
				   		   and a.atividade_id in (#arguments.atividade_id#)
						</cfif>
						<cfif Len(Trim(arguments.importancia))>
						   and a.importancia = #arguments.importancia#
						</cfif>
	  					   and ea.ordem_servico_id_execucao is null
						) r )
                      <cfif Len(Trim(arguments.STATUS_ID))>
                      where status_id = #arguments.STATUS_ID#
                      </cfif>
                      order by cod_atividade, cod_equipamento, posicao, km_previsao 
			</cfquery>		
		<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os proprietarios dos equipamentos
	-- NOTAS EXPLICATIVAS
	-- WAGNER 29/12/2006
	--->
	<cffunction name="get_proprietario_equipamento" returntype="query" access="remote">
		<cfargument name="EQUIPAMENTO_ID" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
             select t.cod_pessoa_proprietario, p.cliente as nome 
               from almoxarifado.equipamento_proprietario t 
              inner join kss.v$pessoa p 
                      on p.cod_pessoa = t.cod_pessoa_proprietario
     	      where t.equipamento_id = #arguments.equipamento_id# 
			    and t.date_fim is null 	
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca atividades executadas
	-- NOTAS EXPLICATIVAS
	-- GUTO 31/01/2007
	--->
	<cffunction name="get_atividades_executadas" returntype="query" access="remote">
		<cfargument name="ATIVIDADE_ID" required="no" default="">
		<cfargument name="DATA_INICIO" required="no" default="">
		<cfargument name="DATA_FIM" required="no" default="">
		<cfargument name="PLACA" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select placa, ordem_servico_id, num_ordem_servico, atividade, km_execucao, 
				   nvl(lag(km_execucao) over(partition by placa order by placa, data_execucao),0) as km_anterior,
				   data_execucao, 
				   nvl(lag(data_execucao) over(partition by placa order by placa, data_execucao),data_execucao) as data_anterior
			from (
				  select os.ordem_servico_id, e.cod_equipamento as placa, os.num_ordem_servico, os.data_abertura as data_execucao, a.cod_atividade || '-' || a.titulo as atividade,
						 (select nvl(max(km), 0)
							from oper.v$veiculo_km
						   where placa = e.cod_equipamento
							 and data_hora <= os.data_abertura) as km_execucao                                                   
					from manutencao.v$equipamento_atividade ea
				   inner join manutencao.v$atividade a
						   on a.atividade_id = ea.atividade_id
				   inner join manutencao.v$ordem_servico os
						   on os.ordem_servico_id = ea.ordem_servico_id_execucao
				   inner join almoxarifado.v$equipamento e
						   on e.equipamento_id = os.equipamento_id
				  where 1=1
                 <cfif len(trim(arguments.ATIVIDADE_ID))>
                    and a.atividade_id = #arguments.ATIVIDADE_ID#
                 </cfif>
                  )
             where 1=1
			 <cfif Len(Trim(arguments.DATA_INICIO))>
			   and data_execucao >= '#arguments.DATA_INICIO#'
			 </cfif>				  
			 <cfif Len(Trim(arguments.DATA_FIM))>
			   and data_execucao <= '#arguments.DATA_FIM#'
			 </cfif>				  
			 <cfif Len(Trim(arguments.PLACA))>
			   and placa = '#arguments.PLACA#'
			 </cfif>				  
			order by placa, data_execucao     
		</cfquery>		
	<cfreturn qr_result>
	</cffunction>	


	<!--- 
	-- PROPSITO 
	-- Busca servicos executados
	-- GUTO  15/02/2007
	--->		
	<cffunction name="get_relatorio_atividade" access="remote" returntype="query" output="true">
		<cfargument name="data_inicio" required="no" default="">
		<cfargument name="data_fim" required="no" default="">
		<cfargument name="cod_pessoa_oficina" required="no" default="">
		<cfargument name="grupo" required="no" default="">
		<cfargument name="atividade_id" required="no" default="">
		<cfargument name="empresa" required="no" default="">
		<cfargument name="cod_pessoa_proprietario" required="no" default="">
		<cfargument name="verificacao" required="no" default="">
		<cfargument name="cod_equipamento" required="no" default="">
		<cfargument name="modelo_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select tipo, ordem_servico_id, num_nota_fiscal,grupo, num_ordem_servico, atividade_id, atividade, posicao, data_abertura,
                          importancia, verificacao, grupo_id, compartimento_id, cod_equipamento, filial, empresa,
                          valor_rateio, horas, proprietario, modelo_equipamento, material, sistema,
                       case
                        when a.empresa = 1 then
                          round(manutencao.to_tempo_convertido(a.tempo_execucao_ajustado).horas * (select avg(decode(a.empresa,1,ova.valor_empresa,ova.valor_terceiro))
                                                                from manutencao.mv$os_valor_atividade ova
                                                               where ova.ordem_servico_id = a.ordem_servico_id
                                                                and ova.atividade_id = a.atividade_id),2)
                       else 0
                       end valor
                     from (
                   select /*+ USE_HASH(E M) USE_HASH(OS P) */
                                      'Servio' as tipo,
                                      os.ordem_servico_id, nft.num_nota_fiscal,
                                      oper.pkg_pneu.FNC_PLACA_GRUPO(e.cod_equipamento, os.data_abertura) as grupo,
                                      os.num_ordem_servico,
                                      a.atividade_id,
                                      a.titulo as atividade,
                                      ep.posicao,
                                      os.data_abertura,
                                      a.importancia,
                                      a.verificacao,
                                      a.grupo_id,
                                      a.compartimento_id,
                                      e.cod_equipamento,
                                      p.cliente as filial, os.empresa,
                                      oa.tempo_execucao_ajustado,
                                      round(os.valor_servico / decode((select count(*)
                                                                          from manutencao.v$os_atividade oa2
                                                                         where oa2.ordem_servico_id = os.ordem_servico_id),0,1,(select count(*)
                                                                          from manutencao.v$os_atividade oa2
                                                                         where oa2.ordem_servico_id = os.ordem_servico_id)),2) as valor_rateio,
                                      manutencao.to_tempo_execucao(oa.tempo_execucao_ajustado,3).retorno as horas,
                                      pp.cliente as proprietario, mo.descricao as modelo_equipamento,
                                      m.descricao_completa as material, mg.descricao as sistema
                                  from almoxarifado.v$equipamento e
                                  inner join almoxarifado.v$material m
                                          on m.material_id = e.material_id
                                  inner join manutencao.v$ordem_servico os
                                          on e.equipamento_id = os.equipamento_id
                                  inner join kss.v$pessoa p
                                         on p.cod_pessoa = os.cod_pessoa_oficina
                                  inner join almoxarifado.v$equipamento_proprietario epa
                                      on epa.equipamento_id = e.equipamento_id
                                     and os.data_abertura between epa.data_inicio and nvl(epa.date_fim,sysdate) 	
                                  inner join kss.v$pessoa pp
                                          on pp.cod_pessoa = epa.cod_pessoa_proprietario
                                  left join manutencao.v$os_atividade oa
                                      on oa.ordem_servico_id = os.ordem_servico_id
                                  left join manutencao.v$atividade a
                                      on a.atividade_id = oa.atividade_id
                                  left join manutencao.v$atividade_grupo mg
                                         on mg.grupo_id = a.grupo_id
                                  left join fiscal.v$nf_terceiro nft
                                         on nft.num_nota_id = os.num_nota_id
                                  left join manutencao.v$equipamento_posicao ep
                                      on nvl(ep.posicao_id,0) = nvl(oa.posicao_id,0)
                                  left join manutencao.v$equipamento_modelo em
                                         on em.equipamento_id = e.equipamento_id
                                        and em.data_final is null
                                  left join manutencao.v$modelo mo
                                         on mo.modelo_id = em.modelo_id
                                   where 1=1                    
					  <cfif Len(Trim(arguments.DATA_INICIO))>
                       and trunc(os.data_abertura) >= '#arguments.DATA_INICIO#'
                      </cfif>
                      <cfif Len(Trim(arguments.DATA_FIM))>
                       and trunc(os.data_abertura) <= '#arguments.DATA_FIM#'
                      </cfif>
                      <cfif Len(Trim(arguments.ATIVIDADE_ID))>
                       and a.atividade_id in (#arguments.ATIVIDADE_ID#)
                      </cfif>
                      <cfif Len(Trim(arguments.VERIFICACAO))>
                       and a.verificacao = #arguments.VERIFICACAO#
                      </cfif>
                      <cfif Len(Trim(arguments.COD_PESSOA_PROPRIETARIO))>
                       and epa.cod_pessoa_proprietario = #arguments.COD_PESSOA_PROPRIETARIO#
                      </cfif>
                      <cfif Len(Trim(arguments.COD_PESSOA_OFICINA))>
                       and os.cod_pessoa_oficina = #arguments.COD_PESSOA_OFICINA#
                      </cfif>
                      <cfif Len(Trim(arguments.EMPRESA))>
                       and os.empresa = #arguments.EMPRESA#
                      </cfif>
                      <cfif Len(Trim(arguments.COD_EQUIPAMENTO))>
                       and e.cod_equipamento = '#arguments.COD_EQUIPAMENTO#'
                      </cfif>
                      <cfif Len(Trim(arguments.MODELO_ID))>
                       and em.modelo_id = #arguments.MODELO_ID#
                      </cfif>
                               <cfif Len(Trim(arguments.GRUPO))>
                       and oper.pkg_pneu.FNC_PLACA_GRUPO(e.cod_equipamento, os.data_abertura) = '#arguments.GRUPO#'
                      </cfif> ) a
			  order by a.num_ordem_servico  
  		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	
	<!--- 
	-- PROPSITO 
	-- Busca relatrios de materiais
	-- WAGNER  19/02/2007
	--->		
	<cffunction name="get_relatorio_materiais" access="remote" returntype="query" output="true">
		<cfargument name="data_inicial" 			required="no" default="">
		<cfargument name="data_final" 				required="no" default="">
		<cfargument name="material_id" 				required="no" default="">
		<cfargument name="modelo_id" 				required="no" default="">
		<cfargument name="operacao_tipo_id" 		required="no" default="">
		<cfargument name="cod_pessoa_filial" 		required="no" default="">
		<cfargument name="COD_PESSOA_PROPRIETARIO" 	required="no" default="">
		<cfargument name="cod_grupo" 				required="no" default="">
		<cfargument name="cod_equipamento" 			required="no" default="">
			<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select almoxarifado.pkg_almoxarifado.fnc_get_material_descricao(m.material_id, ' ') as material,
                                        m.material_id, m.operacao_tipo_id,
                                        m.data_lancamento, m.quantidade, 
                                        a.num_ordem_servico,
                                        case
                                            when m.operacao_tipo_id = 2 then to_number(ma.valor,'99999999D009999999999999999999999999999','nls_numeric_characters=''.,''')
                                        else almoxarifado.to_material_estoque(md.material_id).valor_unitario end unitario,
                                        case
                                            when m.operacao_tipo_id = 2 then m.quantidade * to_number(ma.valor,'99999999D009999999999999999999999999999','nls_numeric_characters=''.,''')
                                        else m.quantidade * almoxarifado.to_material_estoque(md.material_id).valor_unitario end valor_total, 
                                        ot.descricao as operacao, m.observacao, m.cod_pessoa_filial,
                                        p.cliente as filial, a.empresa,
                                        a.cod_equipamento as cod_equipamento, 
                                        a.equipamento_id as equipamento_id, 
                                        a.cod_pessoa_proprietario,
                                        a.proprietario,a.cod_grupo, a.modelo_equipamento,
                                        manutencao.to_equipamento_dados(m.equipamento_id).cod_equipamento as identificador,
                                        a.material_equipamento, (select ag.descricao
                                                                   from table (almoxarifado.pkg_almoxarifado.fnc_material_antecessores(md.material_id)) t
                                                                  inner join almoxarifado.v$material m
                                                                          on m.material_id = t.material_id
                                                                   inner join manutencao.v$atividade_grupo ag
                                                                          on ag.grupo_id = m.grupo_id
                                                                  where rownum = 1) as sistema
                         from almoxarifado.v$material md
                 inner join almoxarifado.v$movimentacao m
                         on m.material_id = md.material_id         
                 inner join kss.v$pessoa p 
                         on p.cod_pessoa = m.cod_pessoa_filial
                 inner join almoxarifado.v$operacao_tipo ot
                         on ot.operacao_tipo_id = m.operacao_tipo_id         
                    left join almoxarifado.v$movimentacao_atributo ma
                                                 on ma.lancamento_id = m.lancamento_id 
                                                and ma.atributo_id = 23
                    left join (select om.lancamento_id_saida as lancamento_id, om.equipamento_id, e.cod_equipamento, 
                                      ep.cod_pessoa_proprietario, os.grupo as cod_grupo,
                                      os.empresa, em.modelo_id, os.num_ordem_servico,
                                                        mo.descricao as modelo_equipamento, pp.cliente as proprietario, ma.descricao_completa as material_equipamento
                                                             from manutencao.v$os_material om
                                                            inner join manutencao.v$ordem_servico_grupo os
                                                             on om.ordem_servico_id = os.ordem_servico_id
                                                            inner join almoxarifado.v$equipamento e
                                                             on e.equipamento_id = os.equipamento_id
                                                            inner join almoxarifado.v$material ma
                                                                    on ma.material_id = e.material_id                                                              
                                                             left join manutencao.v$equipamento_modelo em
                                                                            on em.equipamento_id = os.equipamento_id
                                                                         and em.data_final is null 
                                                            left join manutencao.v$modelo mo
                                                                   on mo.modelo_id = em.modelo_id			 
                                                            left join almoxarifado.v$equipamento_proprietario ep 
                                                                    on ep.equipamento_id = e.equipamento_id
                                                                         and os.data_abertura	between ep.data_inicio and nvl(ep.date_fim,sysdate)
                                                            left join kss.v$pessoa pp 
                                                                   on pp.cod_pessoa = ep.cod_pessoa_proprietario			 
                                                        union                 
                                    
                                                        select me.lancamento_id, me.equipamento_id, e.cod_equipamento, ep.cod_pessoa_proprietario, manutencao.pkg_manutencao.fnc_placa_grupo(e.equipamento_id,m.data_lancamento) as cod_grupo,
                                                                     1 as empresa, em.modelo_id, null as num_ordem_servico,
                                                                     mo.descricao as modelo_equipamento, pp.cliente as proprietario,
                                                                     ma.descricao_completa as material_equipamento
                                                            from almoxarifado.v$movimentacao_equipamento me
                                                            inner join almoxarifado.v$movimentacao m
                                                                            on m.lancamento_id = me.lancamento_id
                                                            inner join almoxarifado.v$equipamento e
                                                                            on e.equipamento_id = me.equipamento_id
                                                            inner join almoxarifado.v$material ma
                                                                    on ma.material_id = e.material_id                                                              
                                                            left join almoxarifado.v$equipamento_proprietario ep
                                                                         on ep.equipamento_id = e.equipamento_id
                                                                        and m.data_lancamento	between ep.data_inicio and nvl(ep.date_fim,sysdate)
                                                            left join kss.v$pessoa pp 
                                                                   on pp.cod_pessoa = ep.cod_pessoa_proprietario			
                                                            left join manutencao.v$equipamento_modelo em
                                                                         on em.equipamento_id = e.equipamento_id
                                                                        and em.data_final is null
                                                            left join manutencao.v$modelo mo
                                                                   on mo.modelo_id = em.modelo_id) a
                                 on a.lancamento_id = m.lancamento_id            
        
                 where 1=1
					<cfif len(trim(arguments.MODELO_ID))>
					    and a.modelo_id = #arguments.MODELO_ID#
					</cfif>
					<cfif len(trim(arguments.COD_EQUIPAMENTO))>
					    and a.cod_equipamento = '#arguments.COD_EQUIPAMENTO#'
					</cfif>
					<cfif (len(trim(arguments.data_inicial)) and len(trim(arguments.data_final)))>				
			 		    and trunc(m.data_lancamento) >= '#arguments.data_inicial#'
					    and trunc(m.data_lancamento) <= '#arguments.data_final#'
					</cfif>
					<cfif len(trim(arguments.cod_pessoa_filial))>
					    and m.cod_pessoa_filial = #arguments.cod_pessoa_filial#
					</cfif>
					<cfif len(trim(arguments.operacao_tipo_id))>
					    and m.operacao_tipo_id = #arguments.operacao_tipo_id#
					</cfif>
					<cfif len(trim(arguments.material_id))>
					    and md.material_id in(#arguments.material_id#)
					</cfif>
					<cfif len(trim(arguments.COD_PESSOA_PROPRIETARIO))>
					    and a.cod_pessoa_proprietario = #arguments.cod_pessoa_proprietario#
					</cfif>
					<cfif len(trim(arguments.cod_grupo))>
					    and a.cod_grupo in(#ListQualify(arguments.COD_GRUPO,"'")#)
					</cfif>
			</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Busca materiais inseridos em OSs externas
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO - 10/04/2007 - criado
	--->	
	<cffunction name="get_material_externo" displayname="" access="remote" returntype="query" output="true">
		<cfargument name="DATA_INICIO" required="no" default=""/>
		<cfargument name="DATA_FIM" required="no" default=""/>
		<cfargument name="COD_PESSOA_PROPRIETARIO" required="no" default=""/>
		<cfargument name="COD_PESSOA_OFICINA" required="no" default=""/>
		<cfargument name="MATERIAL_ID" required="no" default=""/>
		<cfargument name="COD_EQUIPAMENTO" required="no" default=""/>
		<cfargument name="MODELO_ID" required="no" default=""/>
		<cfargument name="GRUPO" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
              select /*+ ORDERED USE_HASH(OS OM M)  */ 
                         'Material Externo' as tipo, 
                             oper.pkg_pneu.FNC_PLACA_GRUPO(e.cod_equipamento, os.data_abertura) as grupo,
                             m.descricao_completa as material, m.material_id, os.num_ordem_servico, 
                   os.data_abertura, om.quantidade, om.valor_unitario,
                   om.valor_total, e.cod_equipamento as placa, p.cod_pessoa as cod_pessoa_oficina, 
                             p.cliente as oficina, pp.cliente as empresa,
                             mo.descricao as modelo_equipamento, me.descricao_completa as material_equipamento,
                             manutencao.to_equipamento_dados(om.equipamento_id).cod_equipamento as identificador,
                             om.equipamento_id as equipamento_id_montado,
                   (select ag.descricao
                      from table (almoxarifado.pkg_almoxarifado.fnc_material_antecessores(om.material_id)) t
                     inner join almoxarifado.v$material m
                             on m.material_id = t.material_id
                     inner join manutencao.v$atividade_grupo ag
                             on ag.grupo_id = m.grupo_id
                     where rownum = 1) as sistema          
                from manutencao.v$ordem_servico_grupo os
               inner join manutencao.v$os_material om
                   on om.ordem_servico_id = os.ordem_servico_id
               inner join almoxarifado.v$material m
                   on m.material_id = om.material_id                  
               inner join almoxarifado.v$equipamento e
                   on e.equipamento_id = os.equipamento_id         
                     inner join almoxarifado.v$material me
                             on me.material_id = e.material_id
               inner join almoxarifado.v$equipamento_proprietario epa               
                   on epa.equipamento_id = e.equipamento_id
                   and os.data_abertura between epa.data_inicio and nvl(epa.date_fim,sysdate)
               inner join kss.v$pessoa pp
                   on pp.cod_pessoa = epa.cod_pessoa_proprietario
               inner join kss.v$pessoa p 
                   on p.cod_pessoa = os.cod_pessoa_oficina
                     left  join manutencao.v$equipamento_modelo em
                                     on em.equipamento_id = e.equipamento_id
                                    and em.data_final is null                    
                     left join manutencao.v$modelo mo
                                     on mo.modelo_id = em.modelo_id
                                     
              where os.empresa = 0   
   			  <cfif Len(Trim(arguments.DATA_INICIO))>
			  	and trunc(os.data_abertura) >= '#arguments.DATA_INICIO#'
			  </cfif>
			  <cfif Len(Trim(arguments.DATA_FIM))>
			  	and trunc(os.data_abertura) <= '#arguments.DATA_FIM#'
			  </cfif>
			  <cfif Len(Trim(arguments.COD_PESSOA_OFICINA))>
				 and os.cod_pessoa_oficina in (#arguments.COD_PESSOA_OFICINA#)
			  </cfif>
			  <cfif Len(Trim(arguments.COD_PESSOA_PROPRIETARIO))>
				 and epa.cod_pessoa_proprietario in (#arguments.COD_PESSOA_PROPRIETARIO#)
			  </cfif>
			  <cfif Len(Trim(arguments.MATERIAL_ID))>
			  	and m.material_id in (#arguments.MATERIAL_ID#)
			  </cfif>
			  <cfif Len(Trim(arguments.COD_EQUIPAMENTO))>
			  	and e.cod_equipamento = '#arguments.COD_EQUIPAMENTO#'
			  </cfif>

			  <cfif Len(Trim(arguments.MODELO_ID))>
			  	and em.modelo_id = #arguments.MODELO_ID#
			  </cfif>
			  <cfif Len(Trim(arguments.GRUPO))>
			     and os.grupo in(#ListQualify(arguments.GRUPO,"'")#)
			  </cfif>
			order by os.data_abertura 
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca equipamentos em anlise
	-- NOTAS EXPLICATIVAS
	-- LOUIS 07/07/2007
	--->
	<cffunction name="get_equipamento_analise" returntype="query" access="remote">
		<cfargument name="analisados" required="no" default="">
		<cfargument name="material_id_temp" required="no" default="">
        <cfargument name="cod_equipamento" required="no" default="">
        <cfargument name="equipamento_id" required="no" default="">
        <cfargument name="analise_id" required="no" default="">
        <cfargument name="cod_pessoa" required="no" default="">
        <cfargument name="desmontado" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
           select t.data_inicio,
                  e.cod_equipamento,
                 kss.pkg_global.fnc_obtem_parametro_num(34,'ALMOXARIFADO.EXE',4) as dias_alerta,
                  e.equipamento_id,
                  mt.cod_material,
                  mt.material,
                  mt.material_id,
                  t.ordem_servico_id, e2.cod_equipamento as cod_equipamento_retirada,
                  t.data_analise,
                  t.laudo_id,
                  t.analise_id,
                  pf.cliente as filial,
                  pf.cod_pessoa as cod_pessoa,
                  p.cliente as responsavel,
                  t.observacao,
                  el.descricao as laudo,
                   case
                      when exists(select 'x' from almoxarifado.v$transferencia tr
                                            where tr.analise_id = t.analise_id 
                                              and tr.data_entrada is null)
                     then '1'
                      else '0'
                  end situacao_transf
            from  manutencao.v$equipamento_analise t
      inner join almoxarifado.v$material_dados mt 
              on mt.material_id = t.material_id
      left join almoxarifado.v$equipamento e
              on e.equipamento_id = t.equipamento_id     
       left join kss.v$pessoa p
              on p.cod_pessoa = t.cod_pessoa_responsavel
       left join kss.v$pessoa pf
              on pf.cod_pessoa = t.cod_pessoa_filial
       left join manutencao.v$equipamento_analise_laudo el
              on el.laudo_id = t.laudo_id
       left join manutencao.v$ordem_servico os
              on os.ordem_servico_id = t.ordem_servico_id    
      left join almoxarifado.v$equipamento e2
              on e2.equipamento_id = os.equipamento_id
            where 1=1
         <cfif len(trim(arguments.analisados)) and arguments.analisados eq 0>  
          	 and t.data_analise is null 
         <cfelse>
         	and t.data_analise is not null 
		 </cfif>   
         <cfif len(trim(arguments.material_id_temp))>
            and mt.material_id = #arguments.material_id_temp#
          </cfif>
          <cfif len(trim(arguments.cod_equipamento))>
           and upper(e.cod_equipamento) = upper('#arguments.cod_equipamento#')
          </cfif> 
          <cfif len(trim(arguments.equipamento_id))>
           and e.equipamento_id = #arguments.equipamento_id#
          </cfif>
          <cfif len(trim(arguments.cod_pessoa))>
           and pf.cod_pessoa = #arguments.cod_pessoa#
          </cfif> 
           <cfif len(trim(arguments.analise_id))>
           and t.analise_id = #arguments.analise_id#
          </cfif> 
          <cfif len(trim(arguments.desmontado))>
           and not exists (select 1
                             from manutencao.v$equipamento_material em
                            where em.equipamento_id_identificado = e.equipamento_id
                              and em.ordem_servico_id_desmontagem is null)
          </cfif>
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>	
    
    <!--- 
	-- PROPSITO 
	-- Busca os laudos dos equipamentos analisados
	-- NOTAS EXPLICATIVAS
	-- LOUIS 09/07/2007
	--->
	<cffunction name="get_equipamento_analise_laudo" returntype="query" access="remote">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        select laudo_id,
               descricao,
               operacao_tipo_id
          from manutencao.v$equipamento_analise_laudo
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>	

    <!--- 
	-- PROPSITO 
	-- Busca os Execuo de Tabelas de Manuteno
	-- NOTAS EXPLICATIVAS
	-- GUTO 13/07/2007
	--->
	<cffunction name="get_tabela_veiculo" returntype="query" access="remote">
    	<cfargument name="tabela_id" required="no" default="">
      <cfargument name="status" required="no" default="">
      <cfargument name="somente_ativos" required="no" default="0">

		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cod_equipamento, tabela, data_previsao, km_previsao, km_atual_veiculo,
                   alerta_km, alerta_dias, intervalo_km, intervalo_dias, status_id, km_previsto, dias
              from (select cod_equipamento, tabela, data_previsao, km_previsao, km_atual_veiculo,
                           alerta_km, alerta_dias, intervalo_km, intervalo_dias,
                           case
                             when km_atual_veiculo > km_previsao
                               or sysdate > data_previsao then -2
                             when km_atual_veiculo + alerta_km > km_previsao
                               or sysdate + alerta_dias > data_previsao then -1 
                             else 1 end status_id,
                           km_previsao - km_atual_veiculo as km_previsto,
                           round(data_previsao - sysdate) as dias
                      from (select e.cod_equipamento, tm.nome as tabela, et.ordem_servico_id_execucao,
                                   et.data_previsao, et.km_previsao,
                                   (select nvl(max(km), 0)
                                              from oper.v$veiculo_km
                                             where placa = e.cod_equipamento
                                               and data_hora < sysdate) as km_atual_veiculo,
                                   tm.alerta_km, tm.alerta_dias, tm.intervalo_km, tm.intervalo_dias
                              from almoxarifado.v$equipamento e
                             inner join manutencao.v$equipamento_tabela_manut et
                                     on e.equipamento_id = et.equipamento_id    
                             inner join manutencao.v$tabela_manutencao tm
                                     on et.tabela_id = tm.tabela_id     
                             where et.ordem_servico_id_execucao is null
                               <cfif Len(Trim(arguments.TABELA_ID))>
                               	and tm.tabela_id in (#arguments.TABELA_ID#)
                               </cfif>
                               <cfif arguments.somente_ativos eq 1>
                               	and e.data_inativacao is null
                               </cfif>
                               ) r)
             where 1=1
             <cfif Len(Trim(arguments.STATUS_ID))>
             	and status_id = #arguments.STATUS_ID#
             </cfif>
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>	

    
    <!--- 
	-- PROPSITO 
	-- Busca atendimentos vinculados a OS
	-- NOTAS EXPLICATIVAS
	-- GUTO 09/07/2007
	--->
	<cffunction name="get_os_atendimento" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" required="no" default=""/>
		<cfargument name="data_inicio" required="no" default=""/>
		<cfargument name="data_fim" required="no" default=""/>
        <cfargument name="recurso_id" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select os.controle_id, os.ordem_servico_id, os.cod_pessoa_mecanico, p.cliente as mecanico,
                   os.placa_veiculo_socorro, 
                   to_char(os.data_saida,'dd/mm/yyyy hh24:mi') as data_saida, 
                   to_char(os.data_retorno,'dd/mm/yyyy hh24:mi') as data_retorno, os.km_deslocamento,
                   o.num_ordem_servico, p2.cliente as oficina
              from manutencao.v$os_atendimento os
             inner join kss.v$pessoa p
                     on p.cod_pessoa = os.cod_pessoa_mecanico
             inner join manutencao.v$ordem_servico o
                     on o.ordem_servico_id = os.ordem_servico_id 
             inner join kss.v$pessoa p2
                     on p2.cod_pessoa = o.cod_pessoa_oficina
             where 1=1
             <cfif Len(Trim(arguments.ORDEM_SERVICO_ID))>
               and os.ordem_servico_id = #arguments.ORDEM_SERVICO_ID#
             </cfif>	
             <cfif Len(Trim(arguments.DATA_INICIO))>
               and o.data_abertura >= '#arguments.DATA_INICIO#'
             </cfif>	
             <cfif Len(Trim(arguments.DATA_FIM))>
               and o.data_abertura <= '#arguments.DATA_FIM#'
             </cfif>
             <cfif Len(Trim(arguments.recurso_id))>
               and os.cod_pessoa_mecanico in (#arguments.recurso_id#)
             </cfif>
             order by os.cod_pessoa_mecanico
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>	    

    <!--- 
	-- PROPSITO 
	-- Busca Dados geogrficos do atendimento de socorro
	-- NOTAS EXPLICATIVAS
	-- GUTO 09/07/2007
	--->
	<cffunction name="get_os_atendimento_posicao" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" required="yes"/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        select round(oper.pkg_coord_geografica.fnc_haversine2(a.ponto1.latitude, a.ponto1.longitude,a.ponto2.latitude,a.ponto2.longitude) ) as distancia,
        	   a.ponto1.landmark as landmark,
               a.ponto1.latitude as latitude1, a.ponto1.longitude as longitude1,
               a.ponto2.latitude as latitude2, a.ponto2.longitude as longitude2,
               oficina
          from (select almoxarifado.to_ponto(e.cod_equipamento,os.data_abertura) as ponto1,
                       almoxarifado.to_ponto(os.cod_pessoa_oficina) as ponto2,
                       p.cliente as oficina
                  from manutencao.v$ordem_servico os
                 inner join almoxarifado.v$equipamento e
                         on e.equipamento_id = os.equipamento_id        
                 inner join kss.v$pessoa p 
                         on p.cod_pessoa = os.cod_pessoa_oficina
                where os.ordem_servico_id = #arguments.ORDEM_SERVICO_ID#) a
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>	  
    
    <!--- 
	-- PROPSITO 
	-- Retorna o KM baseado o parametro de limite de revisao
	-- Se o KM limite for negativo no ser permitida a incluso de tabelas que atualizam reviso
	-- Se o KM estiver positivo a reviso pode ser executada
	-- NOTAS EXPLICATIVAS
	-- GUTO 09/07/2007
	--->
	<cffunction name="get_permite_revisao" returntype="query" access="remote">
		<cfargument name="placa" required="no" default="">
        <cfargument name="equipamento_id" required="no" default="">
		<cfargument name="km_veiculo" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select (#arguments.km_veiculo# - (rf.revisao_km + vc.km_revisao - to_number(kss.pkg_global.fnc_parametro_num(11,'OPERACIONAL',18,4)))) as km_limite
              from oper.v$rank_frota rf
		     inner join oper.v$veiculo_controle vc
         			 on vc.placa = rf.placa_controle
             where 1 = 1
			<cfif Len(Trim(arguments.placa))>
               and rf.placa_controle = '#arguments.placa#'
            </cfif>
            <cfif Len(Trim(arguments.equipamento_id))>
               and rf.placa_controle = (select e.placa
                                          from almoxarifado.v$equipamento e
                                         where e.equipamento_id = #arguments.equipamento_id#)
            </cfif>
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>	      

    <!--- 
	-- PROPSITO 
	-- Relatrio de fechamento de custo de OS
	-- NOTAS EXPLICATIVAS
	-- GUTO 26/11/2007
	--->
	<cffunction name="get_os_fechamento_custo" returntype="query" access="remote">
		<cfargument name="data_inicio" required="no" default=""/>
		<cfargument name="data_fim" required="no" default=""/>
		<cfargument name="empresa" required="no" default=""/>
		<cfargument name="socorro" required="no" default=""/>
		<cfargument name="COD_PESSOA_OFICINA" required="no" default=""/>
		<cfargument name="COD_PESSOA_FORNECEDOR" required="no" default=""/>
		<cfargument name="COD_PESSOA_PROPRIETARIO" required="no" default=""/>
		<cfargument name="COD_EQUIPAMENTO_ATRIBUIDO" required="no" default=""/>        
		<cfargument name="tipo_tabela_revisao_os" required="no" default=""/>                
		<cfargument name="grupo" required="no" default=""/>
		<cfargument name="modelo_id" required="no" default=""/>
		<cfargument name="equipamento_id" required="no" default=""/>
		<cfargument name="cod_equipamento" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select o.ordem_servico_id, o.equipamento_id, o.cod_equipamento, 
            	   /*manutencao.to_veiculo_km(o.cod_equipamento,o.data_abertura,o.data_abertura).km_data_inicial as km_abertura,*/
                   o.km_rodado as km_abertura,
                   o.data_abertura, o.grupo, o.data_abertura, o.tipo_os, o.num_nota_fiscal,
                     o.num_ordem_servico, o.custo_servico, o.custo_material, 
                     o.modelo, o.material, o.oficina, 
                     o.ap.ordem_servico_id as aprop_ordem_servico_id, 
                     o.ap.num_ordem_servico as aprop_num_ordem_servico, 
                     o.ap.cod_equipamento as aprop_cod_equipamento, 
                     o.ap.modelo as aprop_modelo, 
                     o.ap.material as aprop_material, 
                     o.ap.grupo as aprop_grupo, km_revisao_ct,
                     (select decode(nvl(min(tm.tipo_execucao),0),1,'Completa',2,'Parcial','')
                        from manutencao.v$os_tabela_manutencao ot
                       inner join manutencao.v$tabela_manutencao tm
                               on tm.tabela_id = ot.tabela_id
                       where ot.ordem_servico_id = o.ordem_servico_id
                       and tm.tipo_execucao > 0) as tabela_execucao
              from ( select os.ordem_servico_id, e.equipamento_id, e.cod_equipamento, nft.num_nota_fiscal, os.km_revisao_ct,
                                             oper.pkg_pneu.fnc_placa_grupo(e.cod_equipamento, os.data_abertura) as grupo,
                                             os.data_abertura,
                                             os.km_rodado,
                                             case 
                                                 when os.socorro = 1 then 'Socorro'
                                                 when os.empresa = 1 then 'Atendimento'
                                                 when os.empresa = 0 then 'Externo'
                                             else '' end tipo_os, os.num_ordem_servico, 
                                             case 
                                               when socorro = 1 then round((select sum((manutencao.to_tempo_convertido(p.tempo_execucao_ajustado).horas * ev.valor_empresa) * pr.percentual_participacao / 100) as valor
                                                              from manutencao.v$os_processos p
                                                              inner join manutencao.v$processo_recurso pr
                                                                  on pr.item_id = p.processo_recurso_id
                                                              inner join manutencao.v$especialidade_valor ev
                                                                  on ev.especialidade_id = pr.especialidade_id
                                                                  and ev.nivel_id = pr.nivel_id					
                                                             where p.ordem_servico_id = os.ordem_servico_id),2)
                                               when empresa = 1 then 
                                                     nvl((select /*+ ordered */ sum(ova.valor_pago)
                                                            from manutencao.v$os_valor_processo ova
                                                     where ova.ordem_servico_id = os.ordem_servico_id),0)
                                             else os.valor_servico end custo_servico,
                                             case 
                                               when empresa = 1 then 
                                                            nvl((select sum(almoxarifado.to_material_estoque(om.material_id).valor_unitario*om.quantidade)	 
                                                                   from manutencao.v$os_material om
                                                                  where om.ordem_servico_id = os.ordem_servico_id),0)
                                             else nvl((select sum(om.valor_total)	 
                                                         from manutencao.v$os_material om
                                                        where om.ordem_servico_id = os.ordem_servico_id),0) end custo_material,
                                             mo.descricao as modelo, m.descricao_completa as material, p.cliente as oficina,
                                             case 
                                                 when to_number(m.veiculo) = 1 then null
                                                 when to_number(m.veiculo) = 0 then manutencao.to_os_custo(os.EQUIPAMENTO_ID,os.data_abertura) 
                                             end ap
                                    from manutencao.v$ordem_servico os
                                    inner join almoxarifado.v$equipamento e
                                                    on e.equipamento_id = os.equipamento_id
                                    inner join almoxarifado.v$equipamento eat
                                                    on eat.equipamento_id = os.equipamento_id_aprop
                                    inner join almoxarifado.v$material_dados m 
                                                    on m.material_id = e.material_id
                                    inner join kss.v$pessoa p
                                                    on p.cod_pessoa = os.cod_pessoa_oficina					
                                   <cfif Len(Trim(arguments.COD_PESSOA_PROPRIETARIO))>
                                    inner join almoxarifado.v$equipamento_proprietario epa
                                                    on epa.equipamento_id = os.equipamento_id 
                                                   and os.data_abertura between epa.data_inicio and nvl(epa.date_fim,sysdate)
                                    inner join table(oper.fnc_empresa_completo(#arguments.COD_PESSOA_PROPRIETARIO#)) e
                                            on e.column_value = epa.cod_pessoa_proprietario
                                    </cfif>                                                   
                                    left join manutencao.v$equipamento_modelo em
                                                    on em.equipamento_id = e.equipamento_id
                                                 and em.data_final is null

                                    left join manutencao.v$modelo mo
                                                 on mo.modelo_id = em.modelo_id
                                    left join fiscal.v$nf_terceiro nft
                                           on nft.num_nota_id = os.num_nota_id
                                where 1=1
                                <cfif Len(Trim(arguments.COD_EQUIPAMENTO))>
                                  and e.cod_equipamento = '#arguments.COD_EQUIPAMENTO#'
                                </cfif>
                                <cfif Len(Trim(arguments.COD_EQUIPAMENTO_ATRIBUIDO))>
                                  and eat.cod_equipamento = '#arguments.COD_EQUIPAMENTO_ATRIBUIDO#'
                                </cfif>
                                <cfif Len(Trim(arguments.EQUIPAMENTO_ID))>
                                  and os.equipamento_id = #arguments.EQUIPAMENTO_ID#
                                </cfif>
                                <cfif Len(Trim(arguments.DATA_INICIO))>
                                  and trunc(os.data_abertura) >= '#arguments.DATA_INICIO#'
                                </cfif>
                                <cfif Len(Trim(arguments.DATA_FIM))>
                                  and trunc(os.data_abertura) <= '#arguments.DATA_FIM#'
                                </cfif>
                                <cfif Len(Trim(arguments.COD_PESSOA_OFICINA))>
                                  and os.cod_pessoa_oficina in (#arguments.COD_PESSOA_OFICINA#)
                                </cfif>
                                <cfif Len(Trim(arguments.COD_PESSOA_FORNECEDOR))>
                                  and os.cod_pessoa_oficina in (#arguments.COD_PESSOA_FORNECEDOR#)
                                </cfif>
                                <cfif Len(Trim(arguments.SOCORRO))>
                                  and os.socorro = #arguments.SOCORRO#
                                </cfif>
                                <cfif Len(Trim(arguments.EMPRESA))>
                                  and os.empresa = #arguments.EMPRESA#
                                </cfif>
                                <cfif Len(Trim(arguments.MODELO_ID))>
                                  and em.modelo_id in (#arguments.MODELO_ID#)
                                </cfif>
								<cfif Len(Trim(arguments.tipo_tabela_revisao_os))>
                                    <cfswitch expression="#arguments.tipo_tabela_revisao_os#">
                                       <cfcase value="1">
                                          and exists (select 1
                                                        from manutencao.v$os_tabela_manutencao tm
                                                       inner join manutencao.v$tabela_manutencao t
                                                               on t.tabela_id = tm.tabela_id
                                                              and t.atualiza_revisao = 1
                                                       where tm.ordem_servico_id = os.ordem_servico_id)
                                       </cfcase>
                                       <cfcase value="0">
                                          and not exists (select 1
                                                            from manutencao.v$os_tabela_manutencao tm
                                                           inner join manutencao.v$tabela_manutencao t
                                                                   on t.tabela_id = tm.tabela_id
                                                                  and t.atualiza_revisao = 1
                                                           where tm.ordem_servico_id = os.ordem_servico_id)
                                       </cfcase>
                                     </cfswitch>
                                </cfif>                                
                                ) o
                                where 1=1
                                <cfif Len(Trim(arguments.grupo))>
                                  and o.grupo in (#ListQualify(arguments.grupo,"'",",")#)
                                </cfif> 
                                
        </cfquery>		
		<cfreturn qr_result>
	</cffunction>
    
    
    <!--- 
	-- PROPSITO 
	-- Retorna todos os vinculos de Atividades/Modelos
	-- Rafael Rudnik 20/05/2008
	--->    
    <cffunction name="get_atividade_modelo" returntype="query" access="remote">		
        <cfargument name="modelo_id" required="no"/>
        <cfargument name="atividade_id" required="no"/>
        <cfargument name="controle_id" required="no"/>
        <cfargument name="titulo" required="no"/>
        <cfargument name="descricao_atividade" required="no"/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
         select ma.controle_id
              , ma.modelo_id
              , ma.atividade_id
              , ma.garantia_km
              , ma.garantia_horas_trabalhadas
              , ma.garantia_dias
              , ma.garantia_lts_combustivel
              , ma.alerta_km
              , ma.alerta_horas_trabalhadas
              , ma.alerta_dias
              , ma.alerta_lts_combustivel
              , ma.user_insert
              , ma.date_insert
              , ma.user_update
              , ma.date_update
              , ma.site
              , at.titulo
              , at.cod_atividade
              , mo.descricao
           from manutencao.v$atividade_modelo ma
          inner join manutencao.v$atividade at
                  on at.atividade_id = ma.atividade_id
          inner join manutencao.v$modelo mo
                  on mo.modelo_id = ma.modelo_id
          where 1 = 1
			<cfif isDefined("arguments.controle_id") and len(trim(arguments.controle_id))>
            and ma.controle_id = '#arguments.controle_id#'
		   </cfif>                      
         <cfif isDefined("arguments.modelo_id") and len(trim(arguments.modelo_id))>
            and ma.modelo_id = '#arguments.modelo_id#'
		   </cfif>
         <cfif isDefined("arguments.atividade_id") and len(trim(arguments.atividade_id))>
            and ma.atividade_id = '#arguments.atividade_id#'
		   </cfif>
         <cfif isDefined("arguments.titulo") and len(trim(arguments.titulo))>
            and upper(at.titulo) LIKE upper('%#arguments.titulo#%')
		   </cfif>
         <cfif isDefined("arguments.descricao_atividade") and len(trim(arguments.descricao_atividade))>
            and upper(mo.descricao) LIKE upper('%#arguments.descricao_atividade#%')
		   </cfif>
          order by ma.controle_id desc
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>    
    	      

    <!--- 
	-- PROPSITO 
	-- Retorna tabelas em aberto no equipamento
	-- Guto 01/08/2008
	--->    
    <cffunction name="get_equipamento_tabela_manutencao" returntype="query" access="remote">		
        <cfargument name="cod_equipamento" required="no" default=""/>                     
        <cfargument name="equipamento_id" required="no" default=""/>                     
        <cfargument name="abertas" required="no" default="1"/>                     
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.tabela_id, t.nome, et.controle_id,
		           et.km_previsao, nvl(oper.pkg_pneu.fnc_km_atual(e.cod_equipamento),0) as km_atual,
                   et.km_previsao - nvl(oper.pkg_pneu.fnc_km_atual(e.cod_equipamento),0) as diferenca,
                   t.atualiza_revisao, 
                   case 
                       when t.tipo_execucao = 0 then ''
                       when t.tipo_execucao = 1 then 'Completa'
                       when t.tipo_execucao = 2 then 'Parcial'
                   end tipo_execucao,
                   case 
                     when et.ordem_servico_id_execucao = -1 then 'Inicial'
                   else nvl(to_char(os.data_fechamento,'dd/mm/yyyy'),'Previso') end data_execucao, 
                   et.km_rodado, t.tipo_execucao, et.ordem_servico_id_execucao, os.num_ordem_servico as NUM_OS_EXECUCAO,
                   et.ordem_servico_id_previsao, osp.num_ordem_servico as num_os_previsao
                from almoxarifado.v$equipamento e
                inner join manutencao.v$equipamento_tabela_manut et
                                on et.equipamento_id = e.equipamento_id
                inner join manutencao.v$tabela_manutencao t
                                on t.tabela_id = et.tabela_id
                left join manutencao.v$os_tabela_manutencao otm
                       on otm.ordem_servico_id = et.ordem_servico_id_execucao
                left join manutencao.v$ordem_servico os
                       on os.ordem_servico_id = otm.ordem_servico_id
                left join manutencao.v$ordem_servico osp
                       on osp.ordem_servico_id = et.ordem_servico_id_previsao
            where 1=1
          <cfif arguments.ABERTAS eq 1>
            and et.ordem_servico_id_execucao is null
          </cfif>
          <cfif len(trim(arguments.cod_equipamento))>
                and e.cod_equipamento = '#arguments.cod_equipamento#'
		  </cfif>                
          <cfif len(trim(arguments.equipamento_id))>
                and e.equipamento_id = #arguments.equipamento_id#
		  </cfif>                
          <cfif arguments.ABERTAS eq 1>
	          order by e.cod_equipamento, et.km_previsao
          <cfelse>
             order by et.tabela_id, et.km_previsao desc 
          </cfif>
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>           

    <!--- 
	-- PROPSITO 
	-- Retorna todas as movimentaoes processadas
	-- NOTAS EXPLICATIVAS
	-- GUTO 16/12/2008
	--->
	<cffunction name="get_tipo_movimentacao" returntype="query" access="remote">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct movimentacao 
              from manutencao_dw.v$movimentacao_materiais
              order by movimentacao
        </cfquery>		
		<cfreturn qr_result>
	</cffunction>	                  
       
    <!--- 
	-- PROPSITO 
	-- Retorna todas as movimentaoes processadas
	-- NOTAS EXPLICATIVAS
	-- GUTO 16/12/2008
	--->
	<cffunction name="get_materiais_completo" returntype="query" access="remote">
        <cfargument name="cod_pessoa_proprietario" required="no" default=""/>                     
        <cfargument name="modelo_id_montado" required="no" default=""/>                     
        <cfargument name="modelo_id_material" required="no" default=""/>  
        <cfargument name="data_inicial" required="no" default=""/> 
        <cfargument name="data_final" required="no" default=""/> 
        <cfargument name="movimentacao" required="no" default=""/>                     
        <cfargument name="cod_pessoa_filial" required="no" default=""/>                     
        <cfargument name="cod_pessoa_oficina" required="no" default=""/>                             
        <cfargument name="cod_equipamento" required="no" default=""/>  
        <cfargument name="cod_grupo" required="no" default=""/>  
        <cfargument name="material_id" required="no" default=""/> 
        <cfargument name="agrupar_material" required="no" default="1"/>  
        <cfargument name="agrupar_material_equipamento" required="no" default="1"/>          
        <cfargument name="material_id_equipamento" required="no" default=""/> 
        <cfargument name="cod_pessoa_fornecedor" required="no" default=""/> 
        <cfargument name="grupo_id" required="no" default=""/>         
        <cfargument name="tipo_tabela_revisao_os" required="no" default=""/>         
        <cfargument name="tipo_os" required="no" default=""/>         
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select mm.controle_id, mm.lancto_id_almox, mm.movimentacao, to_char(mm.data,'dd/mm/yyyy hh24:mi') as data,
                   mm.km, mm.ordem_servico_id, mm.num_ordem_servico, mm.num_nota_id,
                   mm.num_nota_fiscal, mm.equipamento_id_material, mm.material_id, 
                   m.descricao_completa as material, 
                   mm.equipamento_id_montado, em.cod_equipamento as equipamento_montado, mm.grupo_veiculo, 
                   decode(mm.tabela_executada,1,'Completa',2,'Parcial','') as tabela_executada,
                   mm.km_controle_trafego, mm.cod_pessoa_filial, p.cliente as filial, mm.valor_unitario,
                   mm.quantidade, mm.valor_total, mm.cod_pessoa_proprietario, prop.cliente as proprietario,
                   ema.cod_equipamento, mm.material_id_equipamento, 
                   me.descricao_completa as material_equipamento, 
                   mm.posicao_id, ep.posicao, mm.atividade_grupo_id, ag.descricao as sistema,
                   mo.descricao as modelo_equipamento
              from manutencao_dw.v$movimentacao_materiais mm
             inner join almoxarifado.v$material m
                     on m.material_id = mm.material_id 
            <cfif Len(Trim(arguments.tipo_os))>
                 inner join manutencao.v$ordem_servico os
                         on os.ordem_servico_id = mm.ordem_servico_id
                 <cfswitch expression="#arguments.tipo_os#">
                 	<cfcase value="1">
                    	and os.socorro = 0
                    </cfcase>
                 	<cfcase value="2">
                    	and os.socorro = 1
                    </cfcase>
                 	<cfcase value="0">
                    	and os.empresa = 0
                    </cfcase>
                 </cfswitch>
            </cfif>
                     
            <cfif Len(Trim(arguments.cod_pessoa_proprietario))>
                inner join table(oper.fnc_empresa_completo(#arguments.cod_pessoa_proprietario#)) e
                        on e.column_value = mm.cod_pessoa_proprietario
            </cfif> 

            <cfif Len(Trim(arguments.cod_pessoa_fornecedor))>
                inner join fiscal.v$nf_terceiro nft
                        on nft.num_nota_id = mm.num_nota_id
            </cfif> 
                        
            <cfif Len(Trim(arguments.MODELO_ID_MATERIAL)) >
                 inner join manutencao.v$equipamento_modelo em
                    on em.equipamento_id = mm.equipamento_id_material
                   and mm.data between em.data_inicial and nvl(em.data_final,sysdate)
                   and em.modelo_id = #arguments.MODELO_ID_MATERIAL#
                 inner join manutencao.v$modelo meo
                         on meo.modelo_id = em.modelo_id 
            </cfif>

            <cfif Len(Trim(arguments.material_id)) and arguments.agrupar_material eq 1>
                 inner join table (almoxarifado.pkg_almoxarifado.fnc_material_filhos('#arguments.material_id#')) mf
                    on mf.material_id = mm.material_id
            </cfif>
            
            <cfif Len(Trim(arguments.material_id_equipamento)) and arguments.agrupar_material_equipamento eq 1>
                 inner join table (almoxarifado.pkg_almoxarifado.fnc_material_filhos('#arguments.material_id_equipamento#')) mfe
                    on mfe.material_id = mm.material_id_equipamento
            </cfif>

            <cfif Len(Trim(arguments.cod_pessoa_oficina))>
             inner join manutencao.v$ordem_servico os
                    on os.ordem_servico_id = mm.ordem_servico_id
                and os.cod_pessoa_oficina = #arguments.cod_pessoa_oficina#
            </cfif>

            <cfif Len(Trim(arguments.MODELO_ID_EQUIPAMENTO))>
               inner join manutencao.v$equipamento_modelo emo
                   on emo.equipamento_id = mm.equipamento_id_montado
                   and mm.data between emo.data_inicial and nvl(emo.data_final,sysdate)
                   and emo.modelo_id = #arguments.MODELO_ID_EQUIPAMENTO#
               inner join manutencao.v$modelo mo
                       on mo.modelo_id = emo.modelo_id 
            <cfelse>
               left join manutencao.v$equipamento_modelo emo
                      on emo.equipamento_id = mm.equipamento_id_montado
                     and mm.data between emo.data_inicial and nvl(emo.data_final,sysdate)
               left join manutencao.v$modelo mo
                      on mo.modelo_id = emo.modelo_id 
            </cfif>
             left join kss.v$pessoa prop
                    on mm.cod_pessoa_proprietario = prop.cod_pessoa
             left join kss.v$pessoa p
                    on mm.cod_pessoa_filial = p.cod_pessoa
             left join almoxarifado.v$material me
                     on me.material_id = mm.material_id_equipamento
             left join almoxarifado.v$equipamento ema
                     on ema.equipamento_id = mm.equipamento_id_material                     
             left join almoxarifado.v$equipamento em
                     on em.equipamento_id = mm.equipamento_id_montado
             left join manutencao.v$equipamento_posicao ep
                    on ep.posicao_id = mm.posicao_id
             left join manutencao.v$atividade_grupo ag
                    on ag.grupo_id = mm.atividade_grupo_id
              where 1=1
            <cfif Len(Trim(arguments.cod_pessoa_fornecedor))>
                and nft.cod_emitente IN (#arguments.cod_pessoa_fornecedor#) 
            </cfif>
            <cfif Len(Trim(arguments.material_id)) and arguments.agrupar_material eq 0>
                and mm.material_id in (#arguments.material_id#)
            </cfif>
            <cfif Len(Trim(arguments.material_id_equipamento)) and arguments.agrupar_material_equipamento eq 0>
                and mm.material_id_equipamento in (#arguments.material_id_equipamento#)
            </cfif>
            <cfif Len(Trim(arguments.data_inicial))>
                and trunc(mm.data) >= '#arguments.data_inicial#'
            </cfif>
            <cfif Len(Trim(arguments.data_final))>
                and trunc(mm.data) <= '#arguments.data_final#'
            </cfif>
            <cfif Len(Trim(arguments.movimentacao))>
                and mm.movimentacao in (#ListQualify(arguments.movimentacao,'''')#)
            </cfif>
            <cfif Len(Trim(arguments.cod_pessoa_filial))>
                and mm.cod_pessoa_filial = #arguments.cod_pessoa_filial#
            </cfif>
            <cfif Len(Trim(arguments.cod_equipamento))>
                and em.cod_equipamento = '#arguments.cod_equipamento#'
            </cfif>
            <cfif Len(Trim(arguments.cod_grupo))>
                and mm.grupo_veiculo in (#ListQualify(arguments.cod_grupo,"'",',')#)
            </cfif>    
            <cfif Len(Trim(arguments.grupo_id))>
                and mm.atividade_grupo_id = #arguments.grupo_id#
            </cfif>                 
            <cfif Len(Trim(arguments.tipo_tabela_revisao_os))>
                <cfswitch expression="#arguments.tipo_tabela_revisao_os#">
                   <cfcase value="1">
                      and exists (select 1
                                    from manutencao.v$os_tabela_manutencao tm
                                   inner join manutencao.v$tabela_manutencao t
                                           on t.tabela_id = tm.tabela_id
                                          and t.atualiza_revisao = 1
                                   where tm.ordem_servico_id = mm.ordem_servico_id)
                   </cfcase>
                   <cfcase value="0">
                      and not exists (select 1
                                        from manutencao.v$os_tabela_manutencao tm
                                       inner join manutencao.v$tabela_manutencao t
                                               on t.tabela_id = tm.tabela_id
                                              and t.atualiza_revisao = 1
                                       where tm.ordem_servico_id = mm.ordem_servico_id)
                   </cfcase>
                 </cfswitch>
            </cfif>                 
              order by mm.data   
        </cfquery>		
		<cfreturn qr_result>
	</cffunction>	                  
       
    
    <!---====================================CUSTO DE MANUTENCAO====================================--->

    <!--- 
	-- PROPSITO 
	-- Retorna de custo de manutencao
	-- SERVICOS INTERNOS
	-- Guto 01/08/2008
	--->    
    <cffunction name="get_custo_empresa_servico" returntype="query" access="remote">		
        <cfargument name="equipamento_id" required="no" default=""/>                     
        <cfargument name="cod_pessoa_proprietario" required="no" default=""/>                     
        <cfargument name="data_inicio" required="no" default=""/>                     
        <cfargument name="data_fim" required="no" default=""/>  
        <cfargument name="marca_id" required="no" default=""/>  
        <cfargument name="modelo_id" required="no" default=""/> 
        <cfargument name="ano" required="no" default=""/> 
		<cfquery name="qr_parametros" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        select to_number(kss.pkg_global.fnc_obtem_parametro_str(11,'OPERACIONAL',30,1))/100 as perc_encargos, 
               to_number(kss.pkg_global.fnc_obtem_parametro_str(11,'OPERACIONAL',30,2))/100 as perc_geral
		  from dual
  	    </cfquery>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
           select mes_ano, ano_mes, sum(valor) as valor, sum(valor_agregado) as valor_agregado
             from (
            select /*+ordered*/ op.controle_id,to_char(op.data_termino,'mm/yyyy') as mes_ano,
                   to_char(op.data_termino,'yyyymm') as ano_mes,
                   case
			         when op.empresa = 1 then
				       (valor_pago + (valor_pago * #qr_parametros.perc_encargos#)) + ((valor_pago + (valor_pago * #qr_parametros.perc_encargos#)) * #qr_parametros.perc_geral#)
				   else (valor_pago + (valor_pago * #qr_parametros.perc_geral#)) end valor,
                   case
			         when op.empresa = 1 and not exists (select 1 
                                                     from table(oper.fnc_empresa_completo(1)) e
                                                    where e.column_value = otv.cod_pessoa_proprietario) then
				       (valor_pago + (valor_pago * #qr_parametros.perc_encargos#)) + ((valor_pago + (valor_pago * #qr_parametros.perc_encargos#)) * #qr_parametros.perc_geral#)
			         when op.empresa = 0 and not exists (select 1 
                                                     from table(oper.fnc_empresa_completo(1)) e
                                                    where e.column_value = otv.cod_pessoa_proprietario) then
                       (valor_pago + (valor_pago * #qr_parametros.perc_geral#)) 
				   else 0 end valor_agregado 
              from manutencao.v$ordem_servico os
             inner join manutencao.v$ordem_servico_tipo_veiculo otv
                     on otv.ordem_servico_id = os.ordem_servico_id
             inner join manutencao.v$os_valor_processo op
                     on op.ordem_servico_id = os.ordem_servico_id
             inner join almoxarifado.v$equipamento_proprietario ep
                     on ep.equipamento_id = os.equipamento_id
                    and os.data_abertura between ep.data_inicio and nvl(ep.date_fim,sysdate)
 		    <cfif Len(Trim(arguments.cod_pessoa_proprietario))>
                 inner join table(oper.fnc_empresa_completo(#arguments.cod_pessoa_proprietario#)) e
                         on e.column_value = ep.cod_pessoa_proprietario
             </cfif>
             where os.empresa = 1
			  <cfif Len(Trim(arguments.MARCA_ID)) or Len(Trim(arguments.MODELO_ID)) or Len(Trim(arguments.ANO))>
                 and op.equipamento_id in (select e2.equipamento_id 
                                             from almoxarifado.v$equipamento e2
                                             inner join oper.v$veiculo v
                                                     on v.placa = e2.cod_equipamento
                                             where 1=1
                                               <cfif Len(Trim(arguments.MARCA_ID))>
                                                 and v.marca_id = #arguments.MARCA_ID#
                                               </cfif>
                                               <cfif Len(Trim(arguments.MODELO_ID))>
                                                 and v.modelo_id in (#arguments.MODELO_ID#)
                                               </cfif>
                                               <cfif Len(Trim(arguments.ANO))>
                                                 and v.ano = #arguments.ANO#
                                               </cfif>
                                           )
              </cfif>
          <cfif Len(Trim(arguments.equipamento_id))>
              and os.equipamento_id = #arguments.equipamento_id#
          </cfif>
          <cfif Len(Trim(arguments.data_inicio))>
                and trunc(op.data_termino) >= '#arguments.data_inicio#'
          </cfif>      
          <cfif Len(Trim(arguments.data_fim))>
                and trunc(op.data_termino) <= '#arguments.data_fim#'
          </cfif>      
            group by op.controle_id, to_char(op.data_termino,'mm/yyyy'), to_char(op.data_termino,'yyyymm'), op.valor_pago, op.empresa, otv.proprietario, otv.cod_pessoa_proprietario

          <cfif Len(Trim(arguments.data_inicio & arguments.data_fim))>
                union all
                
                select 0 as controle_id,
                	   to_char(add_months(to_date('#arguments.data_inicio#'),level-1),'mm/yyyy') as mes_ano,
                       to_char(add_months(to_date('#arguments.data_inicio#'),level-1),'yyyymm') as ano_mes,
                       0 as valor,
                       0 as valor_agregado
                  from dual
                 connect by to_char(add_months(to_date('#arguments.data_inicio#'),level-1),'yyyymm') <= to_char(to_date('#arguments.data_fim#'),'yyyymm')
     
              </cfif>
            )         
            group by mes_ano, ano_mes
            order by ano_mes 
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>                  

    <!--- 
	-- PROPSITO 
	-- Retorna de custo de manutencao
	-- SERVICOS EXTERNOS
	-- Guto 01/08/2008
	--->    
    <cffunction name="get_custo_externo_servico" returntype="query" access="remote">		
        <cfargument name="equipamento_id" required="no" default=""/>                     
        <cfargument name="cod_pessoa_proprietario" required="no" default=""/>                     
        <cfargument name="data_inicio" required="no" default=""/>                     
        <cfargument name="data_fim" required="no" default=""/>                     
        <cfargument name="marca_id" required="no" default=""/>  
        <cfargument name="modelo_id" required="no" default=""/> 
        <cfargument name="ano" required="no" default=""/> 
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select mes_ano, ano_mes, sum(valor) as valor
            from (
            select to_char(os.data_abertura,'mm/yyyy') as mes_ano,
                     to_char(os.data_abertura,'yyyymm') as ano_mes,
                             sum(os.valor_servico) as valor
              from manutencao.v$ordem_servico os
             inner join almoxarifado.v$equipamento_proprietario ep
                     on ep.equipamento_id = os.equipamento_id
                    and os.data_abertura between ep.data_inicio and nvl(ep.date_fim,sysdate)
				 <cfif Len(Trim(arguments.cod_pessoa_proprietario))>
                 inner join table(oper.fnc_empresa_completo(#arguments.cod_pessoa_proprietario#)) e
                         on e.column_value = ep.cod_pessoa_proprietario
                 </cfif>
                 where os.empresa = 0
			  <cfif Len(Trim(arguments.MARCA_ID)) or Len(Trim(arguments.MODELO_ID)) or Len(Trim(arguments.ANO))>
                 and os.equipamento_id in (select e2.equipamento_id 
                                             from almoxarifado.v$equipamento e2
                                             inner join oper.v$veiculo v
                                                     on v.placa = e2.cod_equipamento
                                             where 1=1
                                               <cfif Len(Trim(arguments.MARCA_ID))>
                                                 and v.marca_id = #arguments.MARCA_ID#
                                               </cfif>
                                               <cfif Len(Trim(arguments.MODELO_ID))>
                                                 and v.modelo_id in (#arguments.MODELO_ID#)
                                               </cfif>
                                               <cfif Len(Trim(arguments.ANO))>
                                                 and v.ano = #arguments.ANO#
                                               </cfif>
                                           )
              </cfif>
              <cfif Len(Trim(arguments.equipamento_id))>
                  and os.equipamento_id_aprop = #arguments.equipamento_id#
              </cfif>
              <cfif Len(Trim(arguments.data_inicio))>
                    and os.data_abertura >= '#arguments.data_inicio#'
              </cfif>      
              <cfif Len(Trim(arguments.data_fim))>
                    and trunc(os.data_abertura) <= '#arguments.data_fim#'
              </cfif>      
                group by to_char(os.data_abertura,'mm/yyyy'),
                         to_char(os.data_abertura,'yyyymm')
 			  <cfif Len(Trim(arguments.data_inicio & arguments.data_fim))>
                union all
                
                select to_char(add_months(to_date('#arguments.data_inicio#'),level-1),'mm/yyyy') as mes_ano,
                       to_char(add_months(to_date('#arguments.data_inicio#'),level-1),'yyyymm') as ano_mes,
                       0 as valor
                  from dual
                 connect by to_char(add_months(to_date('#arguments.data_inicio#'),level-1),'yyyymm') <= to_char(to_date('#arguments.data_fim#'),'yyyymm')
     
              </cfif>
                )                         
            group by mes_ano, ano_mes
                order by ano_mes
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>                  

    <!--- 
	-- PROPSITO 
	-- Retorna de custo de manutencao
	-- EMPRESA PEAS
	-- Guto 01/08/2008
	--->    
    <cffunction name="get_custo_empresa_pecas" returntype="query" access="remote">		
        <cfargument name="equipamento_id" required="no" default=""/>                     
        <cfargument name="cod_pessoa_proprietario" required="no" default=""/>                     
        <cfargument name="data_inicio" required="no" default=""/>                     
        <cfargument name="data_fim" required="no" default=""/>                     
        <cfargument name="marca_id" required="no" default=""/>  
        <cfargument name="modelo_id" required="no" default=""/> 
        <cfargument name="ano" required="no" default=""/> 
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select mes_ano, ano_mes, sum(valor) as valor
              from (
            select to_char(mv.data_lancamento,'mm/yyyy') as mes_ano,
                     to_char(mv.data_lancamento,'yyyymm') as ano_mes,
                             sum(om.VALOR_TOTAL) as valor
              from manutencao.v$ordem_servico os
             inner join manutencao.v$os_material om
                     on om.ordem_servico_id = os.ordem_servico_id
             inner join almoxarifado.v$movimentacao mv
                     on mv.lancamento_id = om.lancamento_id_saida
             inner join almoxarifado.v$equipamento_proprietario ep
                     on ep.equipamento_id = os.equipamento_id
                    and os.data_abertura between ep.data_inicio and nvl(ep.date_fim,sysdate)
				 <cfif Len(Trim(arguments.cod_pessoa_proprietario))>
                 inner join table(oper.fnc_empresa_completo(#arguments.cod_pessoa_proprietario#)) e
                         on e.column_value = ep.cod_pessoa_proprietario
                 </cfif>
             where os.empresa = 1
			  <cfif Len(Trim(arguments.MARCA_ID)) or Len(Trim(arguments.MODELO_ID)) or Len(Trim(arguments.ANO))>
                 and os.equipamento_id_aprop in (select e2.equipamento_id 
                                             from almoxarifado.v$equipamento e2
                                             inner join oper.v$veiculo v
                                                     on v.placa = e2.cod_equipamento
                                             where 1=1
                                               <cfif Len(Trim(arguments.MARCA_ID))>
                                                 and v.marca_id = #arguments.MARCA_ID#
                                               </cfif>
                                               <cfif Len(Trim(arguments.MODELO_ID))>
                                                 and v.modelo_id in (#arguments.MODELO_ID#)
                                               </cfif>
                                               <cfif Len(Trim(arguments.ANO))>
                                                 and v.ano = #arguments.ANO#
                                               </cfif>
                                           )
              </cfif>
              <cfif Len(Trim(arguments.data_inicio))>
                    and mv.data_lancamento >= '#arguments.data_inicio#'
              </cfif>      
              <cfif Len(Trim(arguments.data_fim))>
                    and trunc(mv.data_lancamento) <= '#arguments.data_fim#'
              </cfif>      
              <cfif Len(Trim(arguments.equipamento_id))>
                  and os.equipamento_id = #arguments.equipamento_id#
              </cfif>
            group by to_char(mv.data_lancamento,'mm/yyyy'),
                     to_char(mv.data_lancamento,'yyyymm')
            
            union all
            
            select /*+ordered */to_char(m.data_lancamento,'mm/yyyy') as mes_ano,
                   to_char(m.data_lancamento,'yyyymm') as ano_mes,
                   sum((select nvl(round(to_number(ma.valor,'99999999d0099999999999','nls_numeric_characters=''.,'''),3),0)
                          from almoxarifado.v$movimentacao_atributo ma
                         where ma.lancamento_id = m.lancamento_id
                                       and ma.atributo_id = 3)*m.quantidade) as valor_venda
              from almoxarifado.v$movimentacao m
             inner join almoxarifado.v$movimentacao_equipamento me
                     on me.lancamento_id = m.lancamento_id
             inner join almoxarifado.v$equipamento_proprietario ep
                     on ep.equipamento_id = me.equipamento_id
                    and m.data_lancamento between ep.data_inicio and nvl(ep.date_fim,sysdate)
				 <cfif Len(Trim(arguments.cod_pessoa_proprietario))>
                 inner join table(oper.fnc_empresa_completo(#arguments.cod_pessoa_proprietario#)) e
                         on e.column_value = ep.cod_pessoa_proprietario
                 </cfif>
             where m.operacao_tipo_id = 3
			  <cfif Len(Trim(arguments.MARCA_ID)) or Len(Trim(arguments.MODELO_ID)) or Len(Trim(arguments.ANO))>
                 and me.equipamento_id in (select e2.equipamento_id 
                                             from almoxarifado.v$equipamento e2
                                             inner join oper.v$veiculo v
                                                     on v.placa = e2.cod_equipamento
                                             where 1=1
                                               <cfif Len(Trim(arguments.MARCA_ID))>
                                                 and v.marca_id = #arguments.MARCA_ID#
                                               </cfif>
                                               <cfif Len(Trim(arguments.MODELO_ID))>
                                                 and v.modelo_id in (#arguments.MODELO_ID#)
                                               </cfif>
                                               <cfif Len(Trim(arguments.ANO))>
                                                 and v.ano = #arguments.ANO#
                                               </cfif>
                                           )
              </cfif>
             
               and not exists (select 1
                                   from manutencao.v$os_material mo
                                                     where mo.lancamento_id_saida = m.lancamento_id)
               and m.data_lancamento > '01/01/2007'
              <cfif Len(Trim(arguments.equipamento_id))>
                  and me.equipamento_id = #arguments.equipamento_id#
              </cfif>
              <cfif Len(Trim(arguments.data_inicio))>
                    and m.data_lancamento >= '#arguments.data_inicio#'
              </cfif>      
              <cfif Len(Trim(arguments.data_fim))>
                    and trunc(m.data_lancamento) <= '#arguments.data_fim#'
              </cfif>      
            group by to_char(m.data_lancamento,'mm/yyyy'),
                     to_char(m.data_lancamento,'yyyymm')

 			  <cfif Len(Trim(arguments.data_inicio & arguments.data_fim))>
                union all
                
                select to_char(add_months(to_date('#arguments.data_inicio#'),level-1),'mm/yyyy') as mes_ano,
                       to_char(add_months(to_date('#arguments.data_inicio#'),level-1),'yyyymm') as ano_mes,
                       0 as valor
                  from dual
                 connect by to_char(add_months(to_date('#arguments.data_inicio#'),level-1),'yyyymm') <= to_char(to_date('#arguments.data_fim#'),'yyyymm')
     
              </cfif>
                     
            )
            group by mes_ano, ano_mes
            order by ano_mes
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>                  

    <!--- 
	-- PROPSITO 
	-- Retorna de custo de manutencao
	-- EXTERNOS PECAS
	-- Guto 01/08/2008
	--->    
    <cffunction name="get_custo_externo_pecas" returntype="query" access="remote">		
        <cfargument name="equipamento_id" required="no" default=""/>                     
        <cfargument name="cod_pessoa_proprietario" required="no" default=""/>                     
        <cfargument name="data_inicio" required="no" default=""/>                     
        <cfargument name="data_fim" required="no" default=""/>                     
        <cfargument name="marca_id" required="no" default=""/>  
        <cfargument name="modelo_id" required="no" default=""/> 
        <cfargument name="ano" required="no" default=""/> 
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select mes_ano, ano_mes, sum(valor) as valor
              from (select to_char(os.data_abertura,'mm/yyyy') as mes_ano,
                       to_char(os.data_abertura,'yyyymm') as ano_mes,
                       sum(om.valor_total) as valor
                  from manutencao.v$ordem_servico os
                 inner join manutencao.v$os_material om
                         on om.ordem_servico_id = os.ordem_servico_id
                 inner join almoxarifado.v$equipamento_proprietario ep
                         on ep.equipamento_id = os.equipamento_id
                                and os.data_abertura between ep.data_inicio and nvl(ep.date_fim,sysdate)
				 <cfif Len(Trim(arguments.cod_pessoa_proprietario))>
                 inner join table(oper.fnc_empresa_completo(#arguments.cod_pessoa_proprietario#)) e

                         on e.column_value = ep.cod_pessoa_proprietario
                 </cfif>
                where os.empresa = 0
			  <cfif Len(Trim(arguments.MARCA_ID)) or Len(Trim(arguments.MODELO_ID)) or Len(Trim(arguments.ANO))>
                 and os.equipamento_id_aprop in (select e2.equipamento_id 
                                             from almoxarifado.v$equipamento e2
                                             inner join oper.v$veiculo v
                                                     on v.placa = e2.cod_equipamento
                                             where 1=1
                                               <cfif Len(Trim(arguments.MARCA_ID))>
                                                 and v.marca_id = #arguments.MARCA_ID#
                                               </cfif>
                                               <cfif Len(Trim(arguments.MODELO_ID))>
                                                 and v.modelo_id in (#arguments.MODELO_ID#)
                                               </cfif>
                                               <cfif Len(Trim(arguments.ANO))>
                                                 and v.ano = #arguments.ANO#
                                               </cfif>
                                           )
              </cfif>
                
              <cfif Len(Trim(arguments.equipamento_id))>
                  and os.equipamento_id = #arguments.equipamento_id#
              </cfif>
              <cfif Len(Trim(arguments.data_inicio))>
                    and os.data_abertura >= '#arguments.data_inicio#'
              </cfif>      
              <cfif Len(Trim(arguments.data_fim))>
                    and trunc(os.data_abertura) <= '#arguments.data_fim#'
              </cfif>      
                group by to_char(os.data_abertura,'mm/yyyy'),
                         to_char(os.data_abertura,'yyyymm')
 			  <cfif Len(Trim(arguments.data_inicio & arguments.data_fim))>
                union all
                
                select to_char(add_months(to_date('#arguments.data_inicio#'),level-1),'mm/yyyy') as mes_ano,
                       to_char(add_months(to_date('#arguments.data_inicio#'),level-1),'yyyymm') as ano_mes,
                       0 as valor
                  from dual
                 connect by to_char(add_months(to_date('#arguments.data_inicio#'),level-1),'yyyymm') <= to_char(to_date('#arguments.data_fim#'),'yyyymm')
     
              </cfif>
                )                         
            group by mes_ano, ano_mes
                order by ano_mes
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>     

    <!--- 
	-- PROPSITO 
	-- Retorna de custo de manutencao
	-- ORDENS DE COMPRA
	-- Guto 01/08/2008
	--->    
    <cffunction name="get_custo_projetado_ordem_compra" returntype="query" access="remote">		
        <cfargument name="equipamento_id" required="no" default=""/>                     
        <cfargument name="cod_pessoa_proprietario" required="no" default=""/>                     
        <cfargument name="data_inicio" required="no" default=""/>                     
        <cfargument name="data_fim" required="no" default=""/>                     
        <cfargument name="marca_id" required="no" default=""/>  
        <cfargument name="modelo_id" required="no" default=""/> 
        <cfargument name="ano" required="no" default=""/> 
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
               select ano_mes, mes_ano, sum(valor) as valor 
                from (
                select to_char(t.data_emissao,'mm/yyyy') as mes_ano,
                       to_char(t.data_emissao,'yyyymm') as ano_mes,
                       sum(t.total_combinado) as valor
                  from manutencao.v$ordem_compra t
    	          <cfif Len(Trim(arguments.cod_pessoa_proprietario))>
                     inner join almoxarifado.v$equipamento_proprietario ep
                            on ep.equipamento_id = t.equipamento_id
                           and t.data_emissao between ep.data_inicio and nvl(ep.date_fim,sysdate)
                     inner join table(oper.fnc_empresa_completo(#arguments.cod_pessoa_proprietario#)) e
                             on e.column_value = ep.cod_pessoa_proprietario
	              </cfif>
                 where t.aprovada = 1
                   and t.cancelada = 0 
                   and not exists (select 1
                                       from manutencao.v$nf_terceiro_ordem_compra nf
                                                         where nf.num_controle = t.num_controle)
              <cfif Len(Trim(arguments.equipamento_id))>
                  and t.equipamento_id = #arguments.equipamento_id#
              <cfelse>    
                  and t.equipamento_id is not null
				  <cfif Len(Trim(arguments.MARCA_ID)) or Len(Trim(arguments.MODELO_ID)) or Len(Trim(arguments.ANO))>
                     and t.equipamento_id in (select e2.equipamento_id 
                                                 from almoxarifado.v$equipamento e2
                                                 inner join oper.v$veiculo v
                                                         on v.placa = e2.cod_equipamento
                                                 where 1=1
                                                   <cfif Len(Trim(arguments.MARCA_ID))>
                                                     and v.marca_id = #arguments.MARCA_ID#
                                                   </cfif>
                                                   <cfif Len(Trim(arguments.MODELO_ID))>
                                                     and v.modelo_id in (#arguments.MODELO_ID#)
                                                   </cfif>
                                                   <cfif Len(Trim(arguments.ANO))>
                                                     and v.ano = #arguments.ANO#
                                                   </cfif>
                                               )
                  </cfif>
              </cfif>
              <cfif Len(Trim(arguments.data_inicio))>
                    and t.data_emissao >= '#arguments.data_inicio#'
              </cfif>      
              <cfif Len(Trim(arguments.data_fim))>
                    and trunc(t.data_emissao) <= '#arguments.data_fim#' 
              </cfif>      
                group by to_char(t.data_emissao,'mm/yyyy'),
                         to_char(t.data_emissao,'yyyymm')
			  union all                
                select to_char(data,'mm/yyyy') as mes_ano,
                       to_char(data,'yyyymm') as ano_mes,
                             0 as valor
                from (select add_months(sysdate,-1*(level-1)) as data			 
                        from dual connect by level <= 30)
                where 1=1
              <cfif Len(Trim(arguments.data_inicio))>
                    and data >= '#arguments.data_inicio#'
              </cfif>      
              <cfif Len(Trim(arguments.data_fim))>
                    and trunc(data) <= '#arguments.data_fim#' 
              </cfif>      
				)
                group by ano_mes, mes_ano
                order by ano_mes
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>         

    <!--- 
	-- PROPSITO 
	-- Retorna de custo de manutencao
	-- KM RODADO FROTA
	-- Guto 01/08/2008
	--->    
    <cffunction name="get_km_rodado_frota" returntype="query" access="remote">		
        <cfargument name="equipamento_id" required="no" default=""/>                     
        <cfargument name="cod_pessoa_proprietario" required="no" default=""/>                     
        <cfargument name="data_inicio" required="no" default=""/>                     
        <cfargument name="data_fim" required="no" default=""/>                     
        <cfargument name="marca_id" required="no" default=""/>  
        <cfargument name="modelo_id" required="no" default=""/> 
        <cfargument name="ano" required="no" default=""/> 
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select mes_ano, ano_mes, sum(km_rodado) as km_rodado, sum(num_veiculos) as num_veiculos
            from (  select to_char(mes,'mm/yyyy') as mes_ano, 
                           to_char(mes,'yyyymm') as ano_mes,
                           sum(km_rodado) as km_rodado,
                           count(*) as num_veiculos
                     from (
                    select x.placa, x.mes, kf.km-ki.km km_rodado
                      from (select a.placa, a.ultima_data, a.mes,
                                   lag(a.ultima_data, 1, (select max(t.data_hora)
                                                            from oper.v$veiculo_km t
                                                           where 1=1
                                                             and t.data_hora <= a.mes
                                                             and t.placa = a.placa)) over (partition by placa order by a.ultima_data) primeira_data
                             from(select t.placa, max(t.data_hora) ultima_data, trunc(data_hora, 'month') mes
                                    from oper.v$veiculo_km t
                                   inner join oper.v$veiculo_proprietario vp
                                           on vp.placa = t.placa
                                          and t.data_hora between vp.data_inicio and nvl(vp.data_fim,sysdate)
                                                 inner join oper.v$veiculo_dados v
                                                                 on v.placa = t.placa
                                                 inner join oper.v$veiculo_tracao vt
                                                                 on vt.tipo_carroceria_id = v.tipo_carroceria_id
                                                 <cfif Len(Trim(arguments.cod_pessoa_proprietario))>
                                                 inner join table(oper.fnc_empresa_completo(#arguments.cod_pessoa_proprietario#)) e
                                                         on e.column_value = vp.cod_pessoa
                                                 </cfif>
                                   where 1=1
									  <cfif Len(Trim(arguments.MARCA_ID))>
                                          and v.marca_id = #arguments.MARCA_ID#
                                      </cfif>
                                      <cfif Len(Trim(arguments.MODELO_ID))>
                                         and v.modelo_id = #arguments.MODELO_ID#
                                      </cfif>
                                      <cfif Len(Trim(arguments.ANO))>
                                         and v.ano = #arguments.ANO#
                                      </cfif>
									  <cfif Len(Trim(arguments.equipamento_id))>
                                          and t.placa = (select e.cod_equipamento 
                                                           from almoxarifado.v$equipamento e
                                                           where e.equipamento_id = #arguments.equipamento_id#)
                                      </cfif>                                   
								      <cfif Len(Trim(arguments.data_inicio))>
                                         and trunc(t.data_hora) >= to_date('#arguments.data_inicio#','dd/mm/yyyy')
                                      </cfif>
									  <cfif Len(Trim(arguments.data_fim))>
                                            and trunc(t.data_hora) <= '#arguments.data_fim#' 
                                      </cfif>      
                                   group by t.placa, trunc(data_hora, 'month'))a )x
                     inner join oper.v$veiculo_km ki
                             on ki.placa = x.placa
                            and ki.data_hora = x.primeira_data
                     inner join oper.v$veiculo_km kf
                             on kf.placa = x.placa
                            and kf.data_hora = x.ultima_data
                     group by x.placa, x.mes, kf.km-ki.km)
                    group by to_char(mes,'yyyymm'), to_char(mes,'mm/yyyy')
			  union all
                select to_char(data,'mm/yyyy') as mes_ano,
                       to_char(data,'yyyymm') as ano_mes,
                             0 as km_rodado,
                             0 as num_veiculos
                from (select add_months(sysdate,-1*(level-1)) as data			 
                        from dual connect by level <= 30)
                where 1=1
              <cfif Len(Trim(arguments.data_inicio))>
                    and data >= '#arguments.data_inicio#'
              </cfif>      
              <cfif Len(Trim(arguments.data_fim))>
                    and trunc(data) <= '#arguments.data_fim#' 
              </cfif>
				)
                group by ano_mes, mes_ano
                order by ano_mes
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>   
    
    <!--- 
	-- PROPSITO 
	-- Retorna os dados do tipo de custo
	-- NOTAS EXPLICATIVAS
	-- IGOR 06/11/2008
	--->
	<cffunction name="get_tipo_custo" returntype="query" access="remote">
		<cfargument name="descricao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ct.descricao
            	  ,ct.tipo_id
                  ,ct.d_c
                  ,case ct.d_c
                     when 0 then 'Dbito'
                     when 1 then 'Crdito'
                   end as desc_d_c
            from manutencao.v$custo_retorno_tipo ct
            where 1=1
            <cfif Len(Trim(arguments.descricao))>
        		and upper(ct.descricao) like upper('%#arguments.descricao#%')
            </cfif>
        </cfquery>		
		<cfreturn qr_result>
	</cffunction>	
    
    <!--- 
	-- PROPSITO 
	-- Retorna os dados do lancamento de custo
	-- NOTAS EXPLICATIVAS
	-- IGOR 06/11/2008
	--->
	<cffunction name="get_lancamento_custo" returntype="query" access="remote">
		<cfargument name="tipo_id" required="no" default="">
		<cfargument name="data_inicio" required="no" default="">
		<cfargument name="data_fim" required="no" default="">        
		<cfargument name="complemento" required="no" default="">                
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cl.lancamento_id
                  ,cl.tipo_id
                  ,ct.descricao as desc_tipo
                  ,to_char(cl.data,'dd/mm/yyyy') as data
                  ,cl.valor
                  ,cl.complemento
             from manutencao.v$custo_retorno_lancamento cl
             inner join manutencao.v$custo_retorno_tipo ct
                   on ct.tipo_id = cl.tipo_id
             where 1=1
            <cfif Len(Trim(arguments.tipo_id))>
        		and cl.tipo_id = '#arguments.tipo_id#'
            </cfif>
            <cfif Len(Trim(arguments.complemento))>
        		and upper(cl.complemento) like upper('%#arguments.complemento#%')
            </cfif>   
			<cfif Len(Trim(arguments.data_inicio))>
                  and cl.data >= '#arguments.data_inicio#'
            </cfif>      
            <cfif Len(Trim(arguments.data_fim))>
                  and trunc(cl.data) <= '#arguments.data_fim#' 
            </cfif>                      
        </cfquery>		
		<cfreturn qr_result>
	</cffunction>

    <!--- 
	-- PROPSITO 
	-- Retorna de custo de manutencao
	-- SERVICOS EXTERNOS
	-- IGOR 10/11/2008
	--->    
    <cffunction name="get_custo_retorno_variavel" returntype="query" access="remote">		
        <cfargument name="data_inicio" required="no" default=""/>                     
        <cfargument name="data_fim" required="no" default=""/>                     
        <cfargument name="tipo_id" required="no" default="-1"/>  
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select mes_ano, ano_mes, sum(valor)/decode(max(num_veiculos),0,1,max(num_veiculos)) as valor
              from (select to_char(os.data,'mm/yyyy') as mes_ano,
                           to_char(os.data,'yyyymm') as ano_mes,
                           sum(os.valor) as valor, min(manutencao.pkg_manutencao.fnc_veiculos_ativos(os.data)) as num_veiculos
                      from manutencao.v$custo_retorno_lancamento os
                     inner join manutencao.custo_retorno_tipo r on r.tipo_id = os.tipo_id
                     where r.d_c = #arguments.tipo_id#   
              <cfif Len(Trim(arguments.data_inicio))>
                    and os.data >= '#arguments.data_inicio#'
              </cfif>      
              <cfif Len(Trim(arguments.data_fim))>
                    and os.data <= '#arguments.data_fim#'
              </cfif>      
                group by to_char(os.data,'mm/yyyy'),
                         to_char(os.data,'yyyymm')
 			  <cfif Len(Trim(arguments.data_inicio))>
                union all
                
                select to_char(data,'mm/yyyy') as mes_ano,
                       to_char(data,'yyyymm') as ano_mes,
                             0 as valor, 0
                from (select add_months(sysdate,-1*(level-1)) as data			 
                        from dual connect by level <= 30)
                where 1=1
                  <cfif Len(Trim(arguments.data_inicio))>
                        and data >= '#arguments.data_inicio#'
                  </cfif>      
                  <cfif Len(Trim(arguments.data_fim))>
    					and to_date(to_char(data, 'mm/yyyy'), 'mm/yyyy') <= to_date(to_char(to_date('#arguments.data_fim#', 'dd/mm/yyyy'), 'mm/yyyy'), 'mm/yyyy')
                  </cfif>      
              </cfif>
                )                         
            group by mes_ano, ano_mes
                order by ano_mes 
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>  

    <!--- 
	-- PROPSITO 
	-- Retorna de custo de manutencao
	-- SERVICOS INTERNOS
	-- Guto 01/08/2008
	--->    
    <cffunction name="get_credito_sinistro" returntype="query" access="remote">		
        <cfargument name="equipamento_id" required="no" default=""/>                     
        <cfargument name="cod_pessoa_proprietario" required="no" default=""/>                     
        <cfargument name="data_inicio" required="no" default=""/>                     
        <cfargument name="data_fim" required="no" default=""/>  
        <cfargument name="marca_id" required="no" default=""/>  
        <cfargument name="modelo_id" required="no" default=""/> 
        <cfargument name="ano" required="no" default=""/> 
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select mes_ano, ano_mes, sum(valor_custo) as valor
              from (select to_char(vc.data_custo,'mm/yyyy') as mes_ano,
                           to_char(vc.data_custo,'yyyymm') as ano_mes,
                           vc.valor_custo
                      from oper.v$veiculo v
                      inner join oper.v$seg_sinistro_custo_item vc
                              on v.placa = vc.placa
                      inner join oper.v$seg_sinistro_custo sc
                              on sc.custo_id = vc.custo_id
                             and sc.credito_manutencao = 1 
                      inner join oper.v$veiculo_proprietario vp
                              on vp.placa = vc.placa
                             and vc.data_custo between vp.data_inicio and nvl(vp.data_fim,sysdate) 
		   		      <cfif Len(Trim(arguments.cod_pessoa_proprietario))>
                          inner join (select pj.cod_pessoa
                                       from kss.v$pessoa_juridica pj
                                      where pj.cnpj_basico in (select pj2.cnpj_basico
                                                                 from kss.v$pessoa_juridica pj2
                                                                where pj2.cod_pessoa in (#arguments.cod_pessoa_proprietario#)
                                                              )
                                     ) e
                                  on e.cod_pessoa = vp.cod_pessoa
                      </cfif>
                      where 1=1
                      <cfif Len(Trim(arguments.MARCA_ID))>
                        and v.marca_id = #arguments.MARCA_ID#
                      </cfif>
                      <cfif Len(Trim(arguments.MODELO_ID))>
                        and v.modelo_id in (#arguments.MODELO_ID#)
                      </cfif>
                      <cfif Len(Trim(arguments.ANO))>
                        and v.ano = #arguments.ANO#
                      </cfif>
					  <cfif Len(Trim(arguments.data_inicio))>
                        and data_custo >= '#arguments.data_inicio#'
                      </cfif>      
                      <cfif Len(Trim(arguments.data_fim))>
                        and trunc(data_custo) <= '#arguments.data_fim#'
                      </cfif>                            
                      <cfif Len(Trim(arguments.equipamento_id))>
                        and v.placa = (select e.cod_equipamento 
                                         from almoxarifado.v$equipamento e
                                        where e.equipamento_id = #arguments.equipamento_id#)
                      </cfif>                                       
            
                    union all
                                
                      select to_char(data,'mm/yyyy') as mes_ano,
                             to_char(data,'yyyymm') as ano_mes,
                             0 as valor
                      from (select add_months(trunc(last_day(<cfif Len(Trim(arguments.data_fim))>to_date('#arguments.data_fim#','dd/mm/yyyy')<cfelse>sysdate</cfif>))-1, -1 * (level - 1)) as data
                              from dual
                            connect by level <= 30)
                      where 1=1
					  <cfif Len(Trim(arguments.data_inicio))>
                            and data >= '#arguments.data_inicio#'
                      </cfif>      
                      <cfif Len(Trim(arguments.data_fim))>
           					and to_date(to_char(data, 'mm/yyyy'), 'mm/yyyy') <= to_date(to_char(to_date('#arguments.data_fim#', 'dd/mm/yyyy'), 'mm/yyyy'), 'mm/yyyy')
                      </cfif>      
            )
            group by mes_ano, ano_mes
            order by ano_mes 
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>    
    
    <!--- 
	-- PROPSITO 
	-- Retorna os dados do tipo de custo
	-- NOTAS EXPLICATIVAS
	-- IGOR 06/11/2008
	--->
	<cffunction name="get_num_veiculos" returntype="query" access="remote">
        <cfargument name="equipamento_id" required="no" default=""/>                     
        <cfargument name="cod_pessoa_proprietario" required="no" default=""/>                     
        <cfargument name="data_fim" required="no" default=""/>  
        <cfargument name="marca_id" required="no" default=""/>  
        <cfargument name="modelo_id" required="no" default=""/> 
        <cfargument name="ano" required="no" default=""/> 
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
          select sum(total_veiculos) as total_veiculos, mes_ano, ano_mes
			from 
				(select count(e.cod_equipamento) as total_veiculos,
                        dt.mes_ano, dt.ano_mes
                        from almoxarifado.v$equipamento e
                        inner join (select /*+USE_HASH(VEI VKM) USE_NL(VEI VMO)*/
                                           vei.placa,
                                           (select max(vhs.situacao_id) keep(dense_rank last order by vhs.data)
                                              from oper.v$veiculo_hist_situacao vhs
                                             where vhs.placa = vei.placa
                                               and vhs.data <= nvl2('#arguments.data_inicio#', sysdate, '#arguments.data_inicio#')
                                           ) as situacao_id
                                      from oper.v$veiculo vei
                                     inner join oper.v$veiculo_modelo vmo
                                             on vmo.marca_id = vei.marca_id
                                            and vmo.modelo_id = vei.modelo_id
                                     inner join oper.v$veiculo_marca vma
                                             on vma.marca_id = vei.marca_id
                                     inner join oper.v$veiculo_tipo_controle vet
                                             on vet.tipo_carroceria_id = vei.tipo_carroceria_id
                                     inner join oper.v$veiculo_ultimo_km vkm
                                             on vkm.placa = vei.placa
                                  <cfif Len(Trim(arguments.cod_pessoa_proprietario))>
                                      inner join oper.v$veiculo_proprietario vp
                                              on vp.placa = vei.placa
                                             and vp.data_fim is null
                                      inner join table(oper.fnc_empresa_completo(#arguments.cod_pessoa_proprietario#)) e
                                              on e.column_value = vp.cod_pessoa
                                  </cfif>
                                  where 1=1
                                  <cfif Len(Trim(arguments.MARCA_ID))>
                                    and vei.marca_id = #arguments.MARCA_ID#
                                  </cfif>
                                  <cfif Len(Trim(arguments.MODELO_ID))>
                                    and vei.modelo_id in (#arguments.MODELO_ID#)
                                  </cfif>
                                  <cfif Len(Trim(arguments.ANO))>
                                    and vei.ano = #arguments.ANO#
                                  </cfif>
                                  <cfif Len(Trim(arguments.equipamento_id))>
                                    and vei.placa = (select e.cod_equipamento 
                                                     from almoxarifado.v$equipamento e
                                                    where e.equipamento_id = #arguments.equipamento_id#)
                                  </cfif>) vc
                                on vc.placa = e.cod_equipamento,
                                  (select to_char(data,'mm/yyyy') as mes_ano,
                                                         to_char(data,'yyyymm') as ano_mes,
                                                         0 as valor
                                                  from (select add_months(trunc(last_day(sysdate))-1, -1 * (level - 1)) as data
                                                          from dual
                                                        connect by level <= 30)
                                                  where 1=1
                                                  <cfif Len(Trim(arguments.data_inicio))>
                                                        and data >= '#arguments.data_inicio#'
                                                  </cfif>      
                                                  <cfif Len(Trim(arguments.data_fim))>
                                                        and to_date('01/'||to_char(data,'mm/yyyy')) <= to_date('01/'||to_char(to_date('#arguments.data_fim#','dd/mm/yyyy'),'mm/yyyy'))
                                                  </cfif>      
                                                    ) dt    
                               where e.data_inativacao is null 
                                  or (e.data_inativacao > to_date(dt.mes_ano,'mm/yyyy') and vc.situacao_id = 0)
                                  group by dt.mes_ano, dt.ano_mes
            
                            union 
                                
                            select 0 as valor, to_char(data,'mm/yyyy') as mes_ano,
                                   to_char(data,'yyyymm') as ano_mes
                                         
                            from (select add_months(sysdate,-1*(level-1)) as data       
                                    from dual connect by level <= 30)
                            where 1=1        
                              <cfif Len(Trim(arguments.data_inicio))>
                                    and data >= '#arguments.data_inicio#'
                              </cfif> )
				group by mes_ano, ano_mes
                      order by ano_mes              
        </cfquery>		
		<cfreturn qr_result>
	</cffunction>
    
	<!--- 
	- PROPSITO 
	-- Busca o contratos cadastrados
	-- GUTO 11/06/2008
	--->		
	<cffunction name="get_contrato" access="remote" returntype="query" output="true">
    	<cfargument name="contrato_id" required="no" default="">
    	<cfargument name="cod_pessoa_concessionaria" required="no" default="">
        <cfargument name="titulo" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cm.contrato_id, cm.titulo, cm.cod_pessoa_concessionaria, 
            	   to_char(cm.data_inicial,'dd/mm/yyyy') as data_inicial, 
                   to_char(cm.data_final,'dd/mm/yyyy') as data_final, 
                   p.cliente as concessionaria,
                   p.cnpj_cpf as cnpj_concessionaria
              from manutencao.v$contrato_manutencao cm
             inner join kss.v$pessoa p 
                     on p.cod_pessoa = cm.cod_pessoa_concessionaria        
              where 1=1
              <cfif Len(Trim(arguments.contrato_id))>
                and cm.contrato_id = #arguments.contrato_id#
              </cfif>
              <cfif Len(Trim(arguments.cod_pessoa_concessionaria))>
                and cm.cod_pessoa_concessionaria = #arguments.cod_pessoa_concessionaria#
              </cfif>
              <cfif Len(Trim(arguments.titulo))>
                and upper(cm.titulo) like upper('#arguments.titulo#%')
              </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca o tabelas de custo
	-- GUTO 11/06/2008
	--->		
	<cffunction name="get_contrato_tabela_custo" access="remote" returntype="query" output="true">
    	<cfargument name="tabela_id" required="no" default="">
    	<cfargument name="contrato_id" required="no" default="">
    	<cfargument name="modelo_id" required="no" default="">
    	<cfargument name="atual" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ctc.contrato_id, ctc.tabela_id, ctc.titulo,
                   to_char(ctc.data_vigencia,'dd/mm/yyyy') as data_vigencia, ctc.modelo_id, m.descricao as modelo,
                   ctf.num_faixa, ctf.km_inicial, ctf.km_final, ctf.ano_fabricacao_inicial,
                   ctf.ano_fabricacao_final, ctf.valor_km
              from manutencao.v$contrato_tabela_custo ctc
             inner join manutencao.v$contrato_tabela_faixa ctf
                     on ctc.tabela_id = ctf.tabela_id
             inner join manutencao.v$modelo m
                     on m.modelo_id = ctc.modelo_id
             where 1=1
            <cfif Len(Trim(arguments.tabela_id))>
              and ctc.tabela_id = #arguments.tabela_id#
            </cfif>
  	  	    <cfif Len(Trim(arguments.contrato_id))>
              and ctc.contrato_id = #arguments.contrato_id#
            </cfif>
            <cfif Len(Trim(arguments.modelo_id))>
              and ctc.modelo_id in (#arguments.modelo_id#)
            </cfif>
            <cfif Len(Trim(arguments.atual))>
              and ctc.data_vigencia = (select max(ctc2.data_vigencia) 
                                         from manutencao.v$contrato_tabela_custo ctc2
                                        where ctc2.contrato_id = ctc.contrato_id
                                          and ctc2.modelo_id = ctc.modelo_id)
            </cfif>
            order by ctc.contrato_id, ctc.tabela_id, ctf.km_inicial       
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca vinculos entre equipamentos e contratos
	-- GUTO 03/09/2008
	--->		
	<cffunction name="get_contrato_equipamento" access="remote" returntype="query" output="true">
    	<cfargument name="contrato_id" required="no" default="">
    	<cfargument name="cod_equipamento" required="no" default="">
    	<cfargument name="situacao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ce.controle_id, c.titulo, ce.equipamento_id, e.cod_equipamento, 
                   m.descricao_completa as material,
                   to_char(ce.data_inicio,'dd/mm/yyyy') as data_inicio , 
                   to_char(ce.data_termino,'dd/mm/yyyy') as data_termino                    
              from manutencao.v$contrato_manutencao c
             inner join manutencao.v$contrato_equipamento ce
                     on ce.contrato_id = c.contrato_id
             inner join almoxarifado.v$equipamento e 
                     on e.equipamento_id = ce.equipamento_id
             inner join almoxarifado.v$material m 
                     on m.material_id = e.material_id
              where 1=1
              <cfif Len(Trim(arguments.contrato_id))>
                and c.contrato_id = #arguments.contrato_id#
              </cfif>
              <cfif Len(Trim(arguments.cod_equipamento))>
                and e.cod_equipamento = '#arguments.cod_equipamento#'
              </cfif>
              <cfif Len(Trim(arguments.situacao))>
                <cfif arguments.situacao eq 1>
                  and ce.data_termino is null
                <cfelse>
                  and ce.data_termino is not null	
                </cfif>
              </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca dados do fechamento
	-- NOTAS EXPLICATIVAS
	-- GUTO 10/10/2008
	--->
	<cffunction name="get_contrato_fechamento" returntype="query" access="remote">
		<cfargument name="fechamento_id" required="no" default="">
		<cfargument name="contrato_id" required="no" default="">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select f.fechamento_id, f.contrato_id, 
            	   to_char(f.data_fechamento,'dd/mm/yyyy') as data_fechamento,
                   to_char(f.data_inicial,'dd/mm/yyyy') as data_inicial, 
                   to_char(f.data_final,'dd/mm/yyyy') as data_final, 
                   nvl(f.valor_acordo,0) valor_acordo, nvl(f.desconto,0) desconto,
                   nvl(f.total_acordo,0) as total_acordo, c.titulo as contrato,
                   to_char(f.data_inicial,'dd/mm/yyyy') || ' at ' || to_char(f.data_final,'dd/mm/yyyy') as periodo
              from manutencao.v$contrato_fechamento f
             inner join manutencao.v$contrato_manutencao c
                      on c.contrato_id = f.contrato_id
             where 1=1
             <cfif Len(Trim(arguments.contrato_id))>
			   and f.contrato_id = #arguments.contrato_id#
             </cfif>  
             <cfif Len(Trim(arguments.fechamento_id))>
			   and f.fechamento_id = #arguments.fechamento_id#
             </cfif>  
             <cfif Len(Trim(arguments.data_inicial))>
			   and f.data_fechamento >= '#arguments.data_inicial#'
             </cfif>  
             <cfif Len(Trim(arguments.data_final))>
			   and f.data_fechamento <= '#arguments.data_final#'
             </cfif>  
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca dados dos itens fechamento
	-- NOTAS EXPLICATIVAS
	-- GUTO 10/10/2008
	--->
	<cffunction name="get_contrato_fechamento_it" returntype="query" access="remote">
		<cfargument name="fechamento_id" required="no" default="">
		<cfargument name="contrato_id" required="no" default="">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfargument name="placa" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select fi.fechamento_id
                 , fi.item_id
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(fi.placa) as cod_equipamento
                 , fi.placa
                 , to_char(cf.data_inicial, 'dd/mm/yyyy') as data_inicial
                 , to_char(cf.data_final, 'dd/mm/yyyy') as data_final
                 , fi.km_inicial
                 , fi.km_final
                 , fi.km_final - fi.km_inicial as km_rodado
                 , fi.tabela_id
                 , fi.num_faixa
                 , fi.valor_km
                 , fi.valor_km * (fi.km_final - fi.km_inicial) as total
                 , cm.titulo as contrato
                 , fi.tipo
                 , fi.periodo_inicial
                 , fi.periodo_final
                 , fi.valor_total_periodo
                 , fi.valor_periodo
                 , nvl(fi.valor_total_periodo,0) / nvl(fi.valor_periodo,1) as dias_contrato
                 , (select cg.rv_abbreviation
                      from kss.cg_ref_codes cg
                     where cg.rv_domain = 'TABELA_CUSTO.TIPO'
                       and cg.rv_low_value = fi.tipo) as tipo_descricao
              from manutencao.v$contrato_fechamento_it fi
             inner join manutencao.v$contrato_fechamento cf
                on cf.fechamento_id = fi.fechamento_id
             inner join manutencao.v$contrato_manutencao cm
                on cm.contrato_id = cf.contrato_id
             where 1 = 1
             <cfif Len(Trim(arguments.placa))>
			   and fi.placa = '#arguments.placa#'
             </cfif>  
             <cfif Len(Trim(arguments.contrato_id))>
			   and cf.contrato_id = #arguments.contrato_id#
             </cfif>  
             <cfif Len(Trim(arguments.fechamento_id))>
			   and cf.fechamento_id = #arguments.fechamento_id#
             </cfif>  
             <cfif Len(Trim(arguments.data_inicial))>
			   and cf.data_fechamento >= '#arguments.data_inicial#'
             </cfif>  
             <cfif Len(Trim(arguments.data_final))>
			   and cf.data_fechamento <= '#arguments.data_final#'
             </cfif>  
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca dados dos descontos fechamentos
	-- NOTAS EXPLICATIVAS
	-- GUTO 10/10/2008
	--->
	<cffunction name="get_contrato_fechamento_desconto" returntype="query" access="remote">
		<cfargument name="fechamento_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select distinct fd.controle_id, fd.fechamento_id, fd.num_nota_id, fd.placa, fd.valor_desconto,
                   nf.num_nota_fiscal, nf.emit_razao_social, nf.emit_cnpj_cpf, to_char(nf.data_emissao,'dd/mm/yyyy') as data_emissao,
                   oper.pkg_veiculo.fnc_get_cod_veiculo(fd.placa) as cod_veiculo
              from manutencao.v$contrato_fechamento_desconto fd
              left join fiscal.v$nf_terceiro nf
                on nf.num_nota_id = fd.num_nota_id
              left join fiscal.v$nf_terceiro_rateio nr
                on nr.num_nota_id = nf.num_nota_id
             where 1=1
             <cfif Len(Trim(arguments.fechamento_id))>
			   and fd.fechamento_id = #arguments.fechamento_id#
             </cfif>  
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>	
    
   	<!--- 
	-- PROPSITO 
	-- Busca fechamento de manutencao
	-- NOTAS EXPLICATIVAS
	-- IGOR 07/10/2008
	--->
	<cffunction name="get_fechamento_manutencao" returntype="query" access="remote">
		<cfargument name="data_inicial" required="no" default="">
   		<cfargument name="data_final" required="no" default="">
   		<cfargument name="contrato_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select placa, contrato, equipamento_id, cod_equipamento, 
                	   case
                          when valor_km > 0 then
                           to_char(data_final,'dd/mm/yyyy hh24:mi:ss')
                          when valor_periodo > 0 then
                           to_char(to_date('#arguments.data_final#','dd/mm/yyyy'), 'dd/mm/yyyy hh24:mi:ss')          
                       end as data_final,
                       case
                          when valor_km > 0 then
                           to_char(data_inicial,'dd/mm/yyyy hh24:mi:ss')
                          when valor_periodo > 0 then
                           to_char(to_date('#arguments.data_inicial#','dd/mm/yyyy'), 'dd/mm/yyyy hh24:mi:ss')          
                       end as data_inicial,
                       tabela_id,
                	   contrato_id, num_faixa, valor_km, sum(km_faixa) as km_rodado, (sum(km_faixa) * valor_km) as total,
                 case 
                        when alfa_i > beta_i and alfa_t > beta_t and alfa_i < beta_t  then  alfa_i
                        when alfa_i < beta_i and alfa_t < beta_t and alfa_t > beta_i then  beta_i
                        when alfa_i < beta_i and alfa_t > beta_t and alfa_t > beta_i then  beta_i
                        when alfa_i > beta_i and alfa_t < beta_t and alfa_t > beta_i then  alfa_i
                        when alfa_i > beta_i and alfa_i > beta_t then 0         
                        when alfa_t < beta_i and alfa_t < beta_t then 0         
                        end km_inicial,
                 case 
                        when alfa_i > beta_i and alfa_t > beta_t and alfa_i < beta_t  then  beta_t
                        when alfa_i < beta_i and alfa_t < beta_t and alfa_t > beta_i then  alfa_t 
                        when alfa_i < beta_i and alfa_t > beta_t and alfa_t > beta_i then  beta_t 
                        when alfa_i > beta_i and alfa_t < beta_t and alfa_t > beta_i then  alfa_t 
                        when alfa_i > beta_i and alfa_i > beta_t then 0         
                        when alfa_t < beta_i and alfa_t < beta_t then 0         
                        end km_final,
                        periodo_inicial,
                        periodo_final,
                        valor_periodo,
                        calc_periodo_placa,
                        dias_contrato,
                        num_faixa_periodo,
                        valor_total_periodo,
                        case
                           when valor_km > 0 then
                            1
                           when valor_periodo > 0 then
                            2
                        end as tipo,
                        case
                           when valor_km > 0 then
                            'KM'
                           when valor_periodo > 0 then
                            'Perodo'
                        end as tipo_descricao
              from (select placa, contrato, equipamento_id, cod_equipamento,  contrato_id, alfa_i, 
                           alfa_t, beta_i, beta_t, num_faixa, valor_km, data_final, data_inicial, tabela_id,
                         case 
                                when alfa_i > beta_i and alfa_t > beta_t and alfa_i < beta_t  then  beta_t - alfa_i
                                when alfa_i < beta_i and alfa_t < beta_t and alfa_t > beta_i then  alfa_t - beta_i
                                when alfa_i < beta_i and alfa_t > beta_t and alfa_t > beta_i then  beta_t - beta_i
                                when alfa_i > beta_i and alfa_t < beta_t and alfa_t > beta_i then  alfa_t - alfa_i
                                when alfa_i > beta_i and alfa_i > beta_t then 0         
                                when alfa_t < beta_i and alfa_t < beta_t then 0         
                                end km_faixa,
                           periodo_inicial,
                           periodo_final,
                           valor_periodo,
                           calc_periodo_placa,
                           dias_contrato,
                           num_faixa_periodo,
                           valor_total_periodo                                    
                            from (
                            select cm.titulo as contrato, e.placa, e.cod_equipamento, ce.equipamento_id,  ct.contrato_id, 
                                   t.km_inicial alfa_i, nvl(t.km_final, power(10, 38)) alfa_t, 
                                   z.primeiro_km beta_i, z.ultimo_km beta_t, t.num_faixa, t.valor_km, data_final, data_inicial,
								   t.tabela_id,calc_periodo.periodo_inicial,calc_periodo.periodo_final,calc_periodo.valor_periodo,
                                   calc_periodo.calc_periodo_placa,calc_periodo.dias_contrato,calc_periodo.num_faixa_periodo,calc_periodo.valor_total_periodo
                             from manutencao.v$contrato_equipamento ce
                            inner join manutencao.v$contrato_manutencao cm
                                            on cm.contrato_id = ce.contrato_id
                            inner join manutencao.v$equipamento_modelo em
                                            on em.equipamento_id = ce.equipamento_id
                            inner join almoxarifado.v$equipamento e
                                            on e.equipamento_id = ce.equipamento_id        
                            inner join manutencao.v$contrato_tabela_custo ct

                                            on ct.contrato_id = ce.contrato_id
                                         and ct.modelo_id = em.modelo_id
                            inner join manutencao.v$contrato_tabela_faixa t                    
                                            on t.tabela_id = ct.tabela_id
                             left join (
                            			  select y.placa, ultimo_km, primeiro_km, max(dt) as data_final, min(dta) as data_inicial
                                            from (select x.placa, x.dt, x.km, x.dta, x.kma, 
                                                         last_value(x.km) over (partition by x.placa) ultimo_km, first_value(x.kma) over (partition by x.placa) primeiro_km
                                                    from (select t.placa, t.data_hora dt,t.km,    
                                                                 lag(t.data_hora, 1,(select nvl(max(i.data_hora), to_date('#arguments.data_inicial#','dd/mm/yyyy'))                              
                                                            from oper.v$veiculo_km i
                                                           where 1=1
                                                             and i.data_hora < to_date('#arguments.data_inicial#','dd/mm/yyyy')
                                                             and i.placa = t.placa)) over (partition by t.placa order by t.data_hora) dta,  
                                                                 lag(t.km, 1, (select z.km
                                                                                 from oper.v$veiculo_km z
                                                                                where z.data_hora = (select nvl(max(i.data_hora), to_date('#arguments.data_inicial#','dd/mm/yyyy'))                              
                                                                                                                             from oper.v$veiculo_km i
                                                                                                                            where 1=1
                                                                                                                                and i.data_hora < to_date('#arguments.data_inicial#','dd/mm/yyyy')
                                                                                                                                and i.placa = t.placa)
                                                                                    and z.placa = t.placa)) over (partition by t.placa order by t.data_hora) kma  
                                                                            from oper.v$veiculo_km t
                                                                         inner join oper.v$veiculo_proprietario vp
                                                                                         on vp.placa = t.placa
                                                                                        and t.data_hora between vp.data_inicio and nvl(vp.data_fim,sysdate)
                                                                            where 1=1
                                                                                     and trunc(t.data_hora) between to_date('#arguments.data_inicial#','dd/mm/yyyy') and to_date('#arguments.data_final#','dd/mm/yyyy'))x 
                                                                                     ) y
                                                        group by y.placa, ultimo_km, primeiro_km) z
                                  on z.placa = e.PLACA                            
                             left join (select t.periodo_inicial
                                             , t.periodo_final
                                             , t.valor_periodo
                                             , e.placa as calc_periodo_placa
                                             , contrato.dias_contrato                                
                                             , t.tabela_id
                                             , t.num_faixa as num_faixa_periodo
                                             , ce.contrato_id
                                             , t.valor_periodo * contrato.dias_contrato as valor_total_periodo
                                          from manutencao.v$contrato_equipamento ce
                                         inner join almoxarifado.v$equipamento e
                                            on e.equipamento_id = ce.equipamento_id
                                         inner join (select round(greatest((select nvl2(max(cfi.data_final),ce.data_termino,to_date('#arguments.data_final#','dd/mm/yyyy'))
                                                                              from manutencao.v$contrato_fechamento_it cfi
                                                                             where cfi.placa = e.placa),nvl(ce.data_termino,to_date('#arguments.data_final#','dd/mm/yyyy')),
                                                                          to_date('#arguments.data_final#','dd/mm/yyyy') /*data_termino*/) -
                                                            greatest((select nvl(max(cfi.data_final),ce.data_inicio)
                                                                        from manutencao.v$contrato_fechamento_it cfi
                                                                       where cfi.placa =e.placa),to_date('#arguments.data_inicial#','dd/mm/yyyy')) /*,2*/) as dias_contrato
                                                          , e.placa as placa
                                                       from manutencao.v$contrato_equipamento ce
                                                      inner join almoxarifado.v$equipamento e
                                                         on e.equipamento_id = ce.equipamento_id) contrato
                                            on contrato.placa = e.placa   
                                         inner join manutencao.v$contrato_tabela_faixa t    
                                            on t.tipo = 2/*perodo*/
                                           and contrato.dias_contrato between t.periodo_inicial and t.periodo_final ) calc_periodo
                               on calc_periodo.calc_periodo_placa = e.placa
                              and calc_periodo.tabela_id = t.tabela_id
                              and calc_periodo.contrato_id = ce.contrato_id
                              and calc_periodo.num_faixa_periodo = t.num_faixa
                            )
                            <cfif Len(Trim(arguments.contrato_id))>
                            	where contrato_id = #arguments.contrato_id#
                            </cfif>
                            order by placa, alfa_i
            )
            where (nvl(km_faixa,0) <> nvl(dias_contrato,0))
            group by placa, contrato, equipamento_id, cod_equipamento, contrato_id, tabela_id, num_faixa, valor_km, alfa_i, alfa_t, beta_i, beta_t,
					data_final, data_inicial,periodo_inicial,periodo_final,valor_periodo,calc_periodo_placa,dias_contrato,num_faixa_periodo,valor_total_periodo
            order by cod_equipamento
   		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
    
	<!--- 
	-- PROPSITO 
	-- Busca dados do fechamento para relatorio
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 08/04/2009
	--->
	<cffunction name="get_contrato_fechamento_relatorio" returntype="query" access="remote">
		<cfargument name="fechamento_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
             select fi.item_id,
                oper.pkg_veiculo.fnc_get_cod_veiculo(fi.placa) as cod_equipamento,
                fi.placa,
                f.fechamento_id, 
                f.contrato_id, 
                fi.km_inicial, fi.km_final, fi.km_final-fi.km_inicial as km_rodado, 
                fi.tabela_id, fi.num_faixa, fi.valor_km,
                fi.valor_km * (fi.km_final-fi.km_inicial) as total,
                to_char(f.data_fechamento,'dd/mm/yyyy') as data_fechamento,
                to_char(f.data_inicial,'dd/mm/yyyy') as data_inicial, 
                to_char(f.data_final,'dd/mm/yyyy') as data_final, 
                nvl(f.valor_acordo,0) valor_acordo, nvl(f.desconto,0) desconto,
                nvl(f.total_acordo,0) as total_acordo, c.titulo as contrato,
                to_char(f.data_inicial,'dd/mm/yyyy') || ' at ' || to_char(f.data_final,'dd/mm/yyyy') as periodo,
                fi.tipo, fi.periodo_inicial, fi.periodo_final, fi.valor_total_periodo, fi.valor_periodo,
                nvl(fi.valor_total_periodo,0) / nvl(fi.valor_periodo,1) as dias_contrato
              , (select cg.rv_abbreviation
                   from kss.cg_ref_codes cg
                  where cg.rv_domain = 'TABELA_CUSTO.TIPO'
                    and cg.rv_low_value = fi.tipo) as tipo_descricao
            from manutencao.v$contrato_fechamento f
            left join manutencao.v$contrato_fechamento_it fi
                  on fi.fechamento_id = f.fechamento_id
            left join manutencao.v$contrato_manutencao c
                  on c.contrato_id = f.contrato_id
            where 1=1
             <cfif Len(Trim(arguments.fechamento_id))>
			   and f.fechamento_id = #arguments.fechamento_id#
             </cfif>
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca equipamentos
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 08/04/2009
	--->
	<cffunction name="get_equipamentos" returntype="query" access="remote">
		<cfargument name="equipamento_id" required="no" default="">
		<cfargument name="cod_equipamento" required="no" default="">
        <cfargument name="placa" required="no" default="">
        <cfargument name="somente_placa" required="no" default="">
		<cfargument name="sem_modelo" required="no" default="0">
        <cfargument name="equipamento" required="no" default="">
        <cfargument name="analisados" required="no" default="">
	    <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select m.equipamento_id
                 , m.cod_equipamento
                 , m.placa
                 , ma.material
                 , (select ce.contrato_id
                      from manutencao.v$contrato_equipamento ce
                     where ce.equipamento_id = m.equipamento_id
                       and ce.data_termino is null) as contrato_id
                 , (select cg.organizacional_id
                      from oper.v$veiculo_ccusto_gerencial cg
                     where cg.placa = m.placa
                       and cg.data_cancelamento is null) as organizacional_id
              from almoxarifado.v$equipamento m
             inner join almoxarifado.v$material_dados ma
                     on ma.material_id = m.material_id
            <cfif Len(trim(arguments.analisados))>
              left join manutencao.v$equipamento_analise ea
                     on ea.equipamento_id = m.equipamento_id
            </cfif>
             where 1 = 1
            <cfif Len(Trim(arguments.equipamento_id))>
               and m.equipamento_id = #arguments.equipamento_id#
            </cfif>
            <cfif Len(Trim(arguments.cod_equipamento))>
               and m.cod_equipamento = '#arguments.cod_equipamento#'
            </cfif>
            <cfif Len(Trim(arguments.somente_placa))>
               and upper(m.placa) = upper('#arguments.somente_placa#')
            </cfif>
            <cfif Len(Trim(arguments.placa))>
               and (m.cod_equipamento = '#arguments.placa#'
                    or m.placa = oper.pkg_veiculo.fnc_get_placa('#arguments.placa#')
                   )
            </cfif>
            <cfif arguments.sem_modelo eq 1>
               and not exists (select 'x'
                                 from manutencao.v$equipamento_modelo em
                                where em.equipamento_id = m.equipamento_id
                                  and em.data_final is null)
            </cfif>
            <cfif Len(trim(arguments.equipamento))>
               and upper(ma.material) like upper('%#arguments.equipamento#%')
            </cfif>
            <cfif Len(trim(arguments.analisados))>
               and ea.data_analise is null
            </cfif>
             order by ma.material, m.cod_equipamento
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca Nota fiscal de terceiro e Ordem de Compra
	-- GUTO  20/12/2006
	--->		
	<cffunction name="get_nf_terceiro" access="remote" returntype="query" output="true">
		<cfargument name="num_nota_fiscal" required="no" default="">
		<cfargument name="equipamento_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select nf.num_nota_id, nf.num_nota_fiscal, nfo.valor_utilizado,
            	   p.identificador as cnpj_oficina, p.razao_social as razao_social_oficina, 
                   p.cliente as nome_fantasia_oficina, p.cod_pessoa as cod_pessoa_oficina, 
			       nf.calc_valor_total_nota, oc.num_controle
			  from fiscal.v$nf_terceiro nf
			 inner join kss.v$pessoa p 
 					 on p.cod_pessoa = nf.cod_emitente
 		     inner join manutencao.v$nf_terceiro_ordem_compra nfo
				     on nfo.nf_terceiro_id = nf.NUM_NOTA_ID
		     inner join manutencao.v$ordem_compra oc
                     on oc.num_controle = nfo.num_controle
			 where 1=1
			 <cfif Len(Trim(arguments.num_nota_fiscal))>
			   and nf.num_nota_fiscal = #arguments.num_nota_fiscal#
			 </cfif>
			 <cfif Len(Trim(arguments.equipamento_id))>
			   and (oc.equipamento_id = #arguments.equipamento_id# or oc.equipamento_id is null)
               and oc.aprovada = 1
			 </cfif>
  		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca Nota fiscal de terceiro e Ordem de Compra
	-- GUTO  20/12/2006
	--->		
	<cffunction name="get_nota_fiscal_os" access="remote" returntype="query" output="true">
		<cfargument name="num_nota_fiscal" required="no" default="">
        <cfargument name="equipamento_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct nf.num_nota_id, nf.num_nota_fiscal,
            	   p.identificador as cnpj_oficina, p.razao_social as razao_social_oficina, 
                   p.cliente as nome_fantasia_oficina, p.cod_pessoa as cod_pessoa_oficina, 
			       nf.calc_valor_total_nota
			  from fiscal.v$nf_terceiro nf
			 inner join kss.v$pessoa p 
 					 on p.cod_pessoa = nf.cod_emitente
 		     inner join manutencao.v$nf_terceiro_ordem_compra nfo
				     on nfo.nf_terceiro_id = nf.NUM_NOTA_ID
		     inner join manutencao.v$ordem_compra oc
                     on oc.num_controle = nfo.num_controle
			 where 1=1
			 <cfif Len(Trim(arguments.num_nota_fiscal))>
			   and nf.num_nota_fiscal = #arguments.num_nota_fiscal#
			 </cfif>
			 <cfif Len(Trim(arguments.equipamento_id))>
			   and (oc.equipamento_id = #arguments.equipamento_id# or oc.equipamento_id is null)
               and oc.aprovada = 1
			 </cfif>
  		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca ordens de compra cadastradas
	-- NOTAS EXPLICATIVAS
	-- GUTO 19/12/2006
	--->
	<cffunction name="get_ordem_compra" returntype="query" access="remote">
		<cfargument name="NUM_CONTROLE" required="no" default="" >
		<cfargument name="NUM_DOCUMENTO" required="no" default="" >
		<cfargument name="DATA_EMISSAO" required="no" default="" >
		<cfargument name="COD_PESSOA_EMISSAO" required="no" default="" >
		<cfargument name="COD_PESSOA_FORNECEDOR" required="no" default="" >
		<cfargument name="VINCULADA_NOTA" required="no" default="" >
		<cfargument name="APROVADA" required="no" default="" >
		<cfargument name="DATA_FIM" required="no" default="" >
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select oc.titulo, oc.empresa, oc.num_controle, oc.cod_pessoa_emissao, em.cliente as emissao,
					 oc.cod_pessoa_autorizacao, aut.cliente as autorizacao,
					 to_char(oc.data_emissao,'dd/mm/yyyy') as data_emissao, 
					 oc.num_documento, oc.cod_pessoa_fornecedor, f.cliente as fornecedor,
					 oc.nome_responsavel, oc.condicao_pagto, oc.equipamento_id,
					 manutencao.to_equipamento_dados(oc.equipamento_id,sysdate).placa as placa,
					 oc.km_veiculo, oc.total_orcado, oc.total_desconto, oc.total_combinado,
					 oc.observacao, oc.situacao, oc.vinculada_nota, oc.aprovada, oc.cancelada,
                     nvl((select sum(nvl(manutencao.to_ordem_servico(ooc.ordem_servico_id).valor_total_servicos,0)) + sum(nvl(manutencao.to_ordem_servico(ooc.ordem_servico_id).valor_total_material,0))
                            from manutencao.v$os_ordem_compra ooc
                           where ooc.num_controle = oc.num_controle),0) as total_utilizado_os  
			  from manutencao.v$ordem_compra oc
			 inner join kss.v$pessoa em
						on em.cod_pessoa = oc.cod_pessoa_emissao
			 inner join kss.v$pessoa aut
						on aut.cod_pessoa = oc.cod_pessoa_autorizacao
			 inner join kss.v$pessoa f
						on f.cod_pessoa = oc.cod_pessoa_fornecedor         		
			 where 1=1
			<cfif len(Trim(arguments.APROVADA))>
			  and oc.aprovada = #arguments.APROVADA#
			</cfif>
			<cfif len(Trim(arguments.DATA_FIM))>
			  and oc.data_emissao <= '#arguments.DATA_FIM#'
			</cfif>
			<cfif len(Trim(arguments.NUM_CONTROLE))>
			  and oc.num_controle in (#arguments.NUM_CONTROLE#)
			</cfif>
			<cfif len(Trim(arguments.NUM_DOCUMENTO))>
			  and (oc.num_documento = #arguments.NUM_DOCUMENTO#
			       or oc.num_controle = #arguments.NUM_DOCUMENTO# )
			</cfif>
			<cfif len(Trim(arguments.DATA_EMISSAO))>
			  and trunc(oc.data_emissao) = '#arguments.DATA_EMISSAO#'
			</cfif>
			<cfif len(Trim(arguments.COD_PESSOA_EMISSAO))>
			  and oc.cod_pessoa_emissao = #arguments.COD_PESSOA_EMISSAO#
			</cfif>
			<cfif len(Trim(arguments.COD_PESSOA_FORNECEDOR))>
			  and oc.cod_pessoa_fornecedor = #arguments.COD_PESSOA_FORNECEDOR#
			</cfif>
			order by oc.num_documento, oc.num_controle
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca itens de ordens vinculadas a OS
	-- NOTAS EXPLICATIVAS
	-- RAFAEL COSTA 09/06/2009
	--->
	<cffunction name="get_ordem_compra_nf_terceiro" returntype="query" access="remote">
		<cfargument name="ORDEM_SERVICO_ID" required="no" default="" >
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
              select osd.num_nota_id
                    ,toc.ordem_compra_id
                    ,p.razao_social as titulo
                    ,to_char(oc.data_emissao, 'dd/mm/yyyy') as data_emissao
                    ,oc.total_orcado
                    ,oc.total_desconto
                    ,oc.total_combinado
                    ,nvl((select sum(nvl(manutencao.to_ordem_servico(ooc.ordem_servico_id).valor_total_servicos,0)) +
                                 sum(nvl(manutencao.to_ordem_servico(ooc.ordem_servico_id).valor_total_material,0)) 
                           from manutencao.v$os_ordem_compra ooc
                          where ooc.num_controle = oc.num_controle),0) as valor_utilizado
                    ,oc.num_controle
                    ,e.cod_equipamento as placa
                from manutencao.v$ordem_servico_dados osd
          inner join manutencao.v$nf_terceiro_ordem_compra toc
                  on toc.nf_terceiro_id = osd.num_nota_id
          inner join manutencao.v$ordem_compra oc
                  on oc.num_controle = toc.ordem_compra_id
          inner join kss.v$pessoa p
                  on p.cod_pessoa = osd.cod_pessoa_oficina
          inner join almoxarifado.v$equipamento e
                  on e.equipamento_id = osd.equipamento_id
               where 1 = 1
            <cfif len(Trim(arguments.ORDEM_SERVICO_ID))>
               and osd.ordem_servico_id = #arguments.ORDEM_SERVICO_ID#
            </cfif>
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
   
    <!--- 
	-- PROPSITO 
	-- Busca ordens de servio vinculadas a nf de terceiro
	-- NOTAS EXPLICATIVAS
	-- JONAS 03/07/2009
	--->
	<cffunction name="get_ordem_servico_nf_terceiro" returntype="query" access="remote">
		<cfargument name="ORDEM_SERVICO_ID" required="yes" >
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
         select osd.num_nota_id,
         		 osd.num_ordem_servico,
                osd.ordem_servico_id,
                p.razao_social as titulo,
                e.cod_equipamento as placa,
                to_char(osd.data_abertura, 'dd/mm/yyyy') as data_abertura,
                nvl(
                    nvl(manutencao.to_ordem_servico(osd.ordem_servico_id).valor_total_servicos,0) +-- + manutencao.to_ordem_servico(osd.ordem_servico_id).valor_total_material) as valor,
                    nvl(manutencao.to_ordem_servico(osd.ordem_servico_id).valor_total_material,0)
                ,0) as valor
           from manutencao.v$ordem_servico_dados osd
          inner join kss.v$pessoa p 
             on p.cod_pessoa = osd.cod_pessoa_oficina
          inner join almoxarifado.v$equipamento e 
             on e.equipamento_id = osd.equipamento_id
          where 1 = 1
            and osd.num_nota_id = (select num_nota_id from manutencao.v$ordem_servico_dados where ordem_servico_id = #arguments.ordem_servico_id#)
          order by osd.data_abertura
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca equipamentos em sucateados por OS Externa
	-- NOTAS EXPLICATIVAS
	-- Rafael 04/08/2009 modificado
	--->
	<cffunction name="get_equipamento_sucateado_externo" returntype="query" access="remote">
		<cfargument name="cod_equipamento" required="no" default="">
        <cfargument name="material_id_temp" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select to_char(t.data_abertura, 'dd/mm/yyyy') as data_remocao,
                   t.num_ordem_servico,
                   t.equipamento_id_retirado as equipamento_id,
                   t.cod_equipamento_retirado,
                   t.material_id,
                   t.cod_pessoa_responsavel,
                   t.analise_id,
                   (select e.cod_equipamento
                      from almoxarifado.v$equipamento e
                     where e.equipamento_id = t.equipamento_id) as placa,
                   (select descricao_completa
                      from almoxarifado.v$material m
                     where m.material_id = t.material_id) as material,
                   (select pf.cliente
                      from kss.v$pessoa pf
                     where pf.cod_pessoa =
                           (select el.cod_pessoa_filial
                              from almoxarifado.v$equipamento_localizacao el
                             where el.localizacao_id = (select max(el1.localizacao_id)
                                                          from almoxarifado.v$equipamento_localizacao el1
                                                         where el1.equipamento_id = t.equipamento_id_retirado))) as filial,
                   (select cliente
                      from kss.v$pessoa p
                     where p.cod_pessoa = t.cod_pessoa_oficina) as oficina
              from (select os.ordem_servico_id,
                           os.num_ordem_servico,
                           os.data_abertura,
                           os.cod_pessoa_responsavel,
                           os.cod_pessoa_oficina,
                           osm.equipamento_id_retirado,
                           os.equipamento_id,
                           ea.analise_id,
                           e.cod_equipamento as cod_equipamento_retirado,
                           e.material_id as material_id
                      from manutencao.v$ordem_servico os
                     inner join manutencao.v$os_material osm 
                             on os.ordem_servico_id = osm.ordem_servico_id
                     inner join almoxarifado.v$equipamento e
                             on e.equipamento_id = osm.equipamento_id_retirado
                      left join manutencao.v$equipamento_analise ea
                             on ea.ordem_servico_id = os.ORDEM_SERVICO_ID
                             and ea.equipamento_id = osm.EQUIPAMENTO_ID_RETIRADO
                             and ea.laudo_id = 2
                     where 1 = 1
                       and os.empresa = 0
                       and e.data_inativacao is not null
                     group by os.ordem_servico_id,
                              os.num_ordem_servico,
                              os.data_abertura,
                              os.cod_pessoa_responsavel,
                              os.cod_pessoa_oficina,
                              os.equipamento_id,
                              e.cod_equipamento,
                              e.material_id,
                              osm.equipamento_id_retirado,
                              ea.analise_id) t
             where 1 = 1
          <cfif Len(Trim(arguments.cod_equipamento))>  
               and t.cod_equipamento_retirado = '#arguments.cod_equipamento#'
          </cfif>
          <cfif Len(Trim(arguments.material_id_temp))>  
               and t.material_id = #arguments.material_id_temp#
          </cfif>
           </cfquery>		
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Busca as ordens de servios de um equipamento
    -- ANDERSON 11/09/2009 - CRIADO
    --->		
    <cffunction name="get_os_equipamento" access="remote" returntype="query" output="true">
    	<cfargument name="equipamento_id" required="yes">
        <cfargument name="ordem_servico_id" required="no" default="" hint="Busca as ordens de servio exceto esta">
        <cfargument name="num_ordem_servico" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select os.ordem_servico_id
                 , os.num_ordem_servico
                 , to_char(os.data_abertura, 'dd/mm/yyyy hh24:mi') as data_abertura
              from manutencao.v$ordem_servico os
             where os.equipamento_id = #arguments.equipamento_id#
			<cfif Len(Trim(arguments.ordem_servico_id))>
               and os.ordem_servico_id <> #arguments.ordem_servico_id#
            </cfif>
            <cfif Len(Trim(arguments.num_ordem_servico))>
               and os.num_ordem_servico like '#arguments.num_ordem_servico#%'
            </cfif>
             order by os.num_ordem_servico asc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Disponibilidade de Frota de um perodo
    -- ANDERSON 29/09/2009 - CRIADO
    --->
    <cffunction name="get_disponibilidade_frota" access="remote" returntype="query" output="true">
        <cfargument name="data_inicio" required="yes">
        <cfargument name="data_fim" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select y.cod_centro_custo
                 , y.centro_custo
                 , y.qtde_veiculos
                 , y.qtde_veiculos_manut
                 , y.horas_disponiveis
                 , y.horas_paradas
                 , round( y.horas_falha_operacional * (pt.percentual/100),2) as horas_falha_operacional
                 , round( y.horas_disponiveis - y.horas_paradas, 2) as horas_executadas
                 , round( ((y.horas_disponiveis - y.horas_paradas) / y.horas_disponiveis) * 100, 2) as horas_disponiveis_perc
                 , round( (y.horas_paradas / y.horas_disponiveis ) * 100, 2 ) as horas_paradas_perc     
                 , round( (y.horas_falha_operacional * 100)  / decode(y.horas_paradas, 0, 1, y.horas_paradas) , 2 ) as horas_falha_perc     
                 , round( ((y.horas_disponiveis - (y.horas_paradas - y.horas_falha_operacional)) / y.horas_disponiveis) * 100, 2) as perc_horas_sem_falha
              from (select t.cod_centro_custo,
                           (select cc.centro_custo
                              from kss.v$centro_custo cc
                             where cc.cod_centro_custo = t.cod_centro_custo) as centro_custo,
                           count(*) as qtde_veiculos,
                           sum(t.os_encerrada) as qtde_veiculos_manut,
                           ( count(*) * 24 * (t.data_fim - t.data_inicio)
                             *
                             nvl((select percentual/100
                                    from manutencao.v$ccusto_perc_trabalho_atual pt
                                    where pt.cod_centro_custo = t.cod_centro_custo),1) ) as horas_disponiveis,
                                   
                           round(nvl(sum(t.horas_paradas), 0)
                                 *
                                 nvl((select percentual/100
                                        from manutencao.v$ccusto_perc_trabalho_atual pt
                                       where pt.cod_centro_custo = t.cod_centro_custo),1)   , 2) as horas_paradas,
            
                           round(nvl(sum(t.horas_falha_operacional), 0), 2) as horas_falha_operacional
                                 
                      from (select (select vcc.cod_centro_custo
                                      from oper.v$veiculo_ccusto vcc
                                     where vcc.placa = v.placa
                                       and vcc.veiculo_ccusto_id =
                                           (select max(vcc2.veiculo_ccusto_id) keep(dense_rank last order by vcc2.data)
                                              from oper.v$veiculo_ccusto vcc2
                                             where vcc2.placa = vcc.placa
                                               and vcc2.data < d.data_fim)) as cod_centro_custo,
                                   sign((select count(*)
                                          from manutencao.v$ordem_servico os
                                         inner join almoxarifado.v$equipamento e on e.equipamento_id =
                                                                                    os.equipamento_id
                                         where e.placa = v.placa
                                           and os.data_fechamento is not null
                                           and ((os.data_abertura between d.data_inicio and
                                               d.data_fim) or
                                               (os.data_fechamento between d.data_inicio and
                                               d.data_fim)))) as os_encerrada,
                                   (select least(sum(least(os.data_fechamento, d.data_fim) -
                                                     greatest(os.data_abertura,
                                                              d.data_inicio)) * 24,
                                                 (d.data_fim - d.data_inicio) * 24)
                                      from manutencao.v$ordem_servico os
                                     inner join almoxarifado.v$equipamento e on e.equipamento_id =
                                                                                os.equipamento_id
                                     where e.placa = v.placa
                                       and os.data_fechamento is not null
                                       and ((os.data_abertura between d.data_inicio and
                                           d.data_fim) or (os.data_fechamento between
                                           d.data_inicio and d.data_fim))) as horas_paradas,
                                   (select sum(least(os.data_fechamento, d.data_fim) -
                                               greatest(os.data_abertura, d.data_inicio)) * 24
                                      from manutencao.v$ordem_servico os
                                     inner join almoxarifado.v$equipamento e on e.equipamento_id =
                                                                                os.equipamento_id
                                     where e.placa = v.placa
                                       and os.tipo_manutencao_id = 3
                                       and os.data_fechamento is not null
                                       and ((os.data_abertura between d.data_inicio and
                                           d.data_fim) or (os.data_fechamento between
                                           d.data_inicio and d.data_fim))) as horas_falha_operacional,
                                   d.data_inicio,
                                   d.data_fim
                              from oper.v$veiculo_controle v,
                                   (select to_date('#arguments.data_inicio#', 'dd/mm/yyyy') as data_inicio,
                                           to_date('#arguments.data_fim#', 'dd/mm/yyyy') + 1 as data_fim
                                      from dual) d
                             where v.situacao_id = 1) t
                     where t.cod_centro_custo is not null
                     group by t.cod_centro_custo, t.data_inicio, t.data_fim) y
            
              left join manutencao.v$ccusto_perc_trabalho_atual pt 
                on pt.cod_centro_custo = y.cod_centro_custo
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Busca os veiculos para os detalhes do Rel. Disponibilidade de Frota de um perodo
    -- RAFAEL 05/11/2009 - CRIADO
    --->
    <cffunction name="get_disponibilidade_frota_veiculos" access="remote" returntype="query" output="true">
        <cfargument name="data_inicio" required="yes">
        <cfargument name="data_fim" required="yes">
        <cfargument name="cod_centro_custo" required="yes">
        <cfargument name="em_manutencao" required="no" default="0">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select x.cod_centro_custo
                 , x.os_encerrada
                 , x.placa
                 , x.classificacao
              from (select (select vcc.cod_centro_custo
                              from oper.v$veiculo_ccusto vcc
                             where vcc.placa = v.placa
                               and vcc.veiculo_ccusto_id = (select max(vcc2.veiculo_ccusto_id) keep(dense_rank last order by vcc2.data)
                                                              from oper.v$veiculo_ccusto vcc2
                                                             where vcc2.placa = vcc.placa
                                                               and vcc2.data < d.data_fim
                                                           )
                           ) as cod_centro_custo
                         , sign((select count(*)
                                   from manutencao.v$ordem_servico os
                                  inner join almoxarifado.v$equipamento e
                                          on e.equipamento_id = os.equipamento_id
                                  where e.placa = v.placa
                                    and os.data_fechamento is not null
                                    and os.data_abertura >= d.data_inicio
                                    and os.data_abertura < d.data_fim
                                )
                               ) as os_encerrada
                         , v.placa
                         , v.classificacao
                      from oper.v$veiculo_controle v
                         , (select to_date('#arguments.data_inicio#', 'dd/mm/yyyy') as data_inicio
                                 , to_date('#arguments.data_fim#', 'dd/mm/yyyy') + 1 as data_fim
                              from dual
                           ) d
                     where 1 = 1 
					<cfif arguments.em_manutencao eq 1>
                       and ((select count(*)
                               from manutencao.v$ordem_servico os
                               inner join almoxarifado.v$equipamento e
                                       on e.equipamento_id = os.equipamento_id
                               where e.placa = v.placa
                                 and os.data_fechamento is not null
                                 and os.data_abertura >= d.data_inicio
                                 and os.data_abertura < d.data_fim
                            )
                           ) >= 1
            		</cfif>
                   ) x
             where x.cod_centro_custo = #arguments.cod_centro_custo#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Busca as OS para os detalhes do Rel. Disponibilidade de Frota de um perodo
    -- RAFAEL 05/11/2009 - CRIADO
    --->
    <cffunction name="get_disponibilidade_frota_os" access="remote" returntype="query" output="true">
        <cfargument name="data_inicio" required="yes">
        <cfargument name="data_fim" required="yes">
        <cfargument name="cod_centro_custo" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select os.num_ordem_servico
                 , e.cod_equipamento as frota
                 , to_char(os.data_abertura , 'dd/mm/yyyy hh24:mi') as data_abertura
                 , to_char(os.data_fechamento , 'dd/mm/yyyy hh24:mi') as data_fechamento
                 , to_char(greatest(t.data_inicio,os.data_abertura), 'dd/mm/yyyy hh24:mi') as data_inicio_calculo
                 , to_char(least(t.data_fim,os.data_fechamento), 'dd/mm/yyyy hh24:mi') as data_termino_calculo
                 , kss.to_tempo(NumToDSInterval(( least(t.data_fim,os.data_fechamento) - greatest(t.data_inicio,os.data_abertura)) * 24 * 60, 'MINUTE'), 3).retorno as horas
                 , kss.to_tempo(NumToDSInterval(( least(t.data_fim,os.data_fechamento) - greatest(t.data_inicio,os.data_abertura)) * 24 * 60  * nvl((select percentual/100
                                                                                                            from manutencao.v$ccusto_perc_trabalho_atual pt
                                                                                                           where pt.cod_centro_custo = 302),1), 'MINUTE'), 3).retorno as horas_processadas
                 , os.valor_servico as valor
                 , os.user_insert as usuario
                 , to_char(os.data_abertura, 'dd/mm/yyyy hh24:mi') as data
              from manutencao.v$ordem_servico os
             inner join almoxarifado.v$equipamento e
                     on e.equipamento_id = os.equipamento_id
             inner join (select to_date('01/08/2012', 'dd/mm/yyyy') as data_inicio,
                    			to_date('31/08/2012', 'dd/mm/yyyy') + 1 as data_fim
                           from dual) t
                on (os.data_abertura   between t.data_inicio and t.data_fim)
                or (os.data_fechamento between t.data_inicio and t.data_fim)
             where e.placa in (select vcc.placa
                                 from oper.v$veiculo_ccusto vcc
                                inner join oper.v$veiculo_controle c
                                        on c.placa = vcc.placa
                                where vcc.cod_centro_custo = #arguments.cod_centro_custo#
                                  and vcc.veiculo_ccusto_id = (select max(vcc2.veiculo_ccusto_id) keep(dense_rank last order by vcc2.data)
                                                                 from oper.v$veiculo_ccusto vcc2
                                                                where vcc2.placa = vcc.placa
                                                                  and vcc2.data < (to_date('#arguments.data_fim#', 'dd/mm/yyyy') + 1)
                                                              )
                              )
               and os.data_fechamento is not null

             order by os.data_abertura
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Custo de Manuteno por KM Rodado
    -- ANDERSON 01/10/2009 - CRIADO
    --->
    <cffunction name="get_custo_manutencao_km_rodado" access="remote" returntype="query" output="true">
        <cfargument name="data_inicio" required="yes">
        <cfargument name="data_fim" required="yes">
        <cfargument name="equipamento_id" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfargument name="tipo_carroceria_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select (select tm.tipo_manutencao
                      from fiscal.v$tipo_manutencao tm
                     where tm.tipo_manutencao_id = a.tipo_manutencao_id) as tipo_manutencao
                 , a.placa
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(a.placa) as cod_veiculo
                 , (select cc.centro_custo
                      from kss.v$centro_custo cc
                     where cc.cod_centro_custo = a.cod_centro_custo) as centro_custo
                 , a.valor_mercadoria
                 , a.valor_servico
                 , a.valor_total
                 , a.custo_adicional
                 , a.custo_normal
                 , a.valor_desconto
                 , a.km_rodado
                 , (nvl(a.km_rodado, 0) * nvl(a.tx_manutencao_km, 0)) as credito
                 , a.veiculo_ok
              from (select t.tipo_manutencao_id
                         , t.placa
                         , (select max(vcc.cod_centro_custo) keep(dense_rank last order by vcc.data)
                              from oper.v$veiculo_ccusto vcc
                             where vcc.placa = t.placa
                               and vcc.data <= to_date('#arguments.data_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')) as cod_centro_custo
                         , sum(t.valor_mercadoria) as valor_mercadoria
                         , sum(t.valor_servico) as valor_servico
                         , (sum(t.valor_mercadoria) + sum(t.valor_servico)) as valor_total
                         , sum(t.custo_adicional) as custo_adicional
                         , sum(t.custo_normal) as custo_normal
                         , sum(t.valor_desconto) as valor_desconto
                         , nvl(
                               (select max(vk.km) keep (dense_rank last order by vk.data_hora)
                              from oper.v$veiculo_km vk
                             where vk.placa = t.placa
                                   and vk.data_hora <= to_date('#arguments.data_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                               )
                               - (select max(vk.km) keep (dense_rank last order by vk.data_hora)
                              from oper.v$veiculo_km vk
                             where vk.placa = t.placa
                                     and vk.data_hora <= to_date('#arguments.data_inicio# 00:00:00', 'dd/mm/yyyy hh24:mi:ss')
                                 )
                              ,(select sum(
                                           (select max(vk.km) keep (dense_rank last order by vk.data_hora)
                                              from oper.v$veiculo_km vk
                                             where vk.placa = vc.placa_1
                                               and vk.data_hora <= nvl(vc.data_hora_desengate, to_date('#arguments.data_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss'))
                                           )
                                           - (select max(vk.km) keep (dense_rank last order by vk.data_hora)
                                                from oper.v$veiculo_km vk
                                               where vk.placa = vc.placa_1
                                                 and vk.data_hora <= greatest(to_date('#arguments.data_inicio# 00:00:00', 'dd/mm/yyyy hh24:mi:ss'), vc.data_hora_engate)
                                             )
                                          )
                                  from oper.v$veiculo_composicao vc
                                 where vc.placa_2 = t.placa
                                   and vc.data_hora_engate <= to_date('#arguments.data_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                                   and nvl(vc.data_hora_desengate, to_date('#arguments.data_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')) >= to_date('#arguments.data_inicio# 00:00:00','dd/mm/yyyy hh24:mi:ss')
                               )
                              ) as km_rodado
                         , nvl(
                                 (select va.valor
                                    from oper.veiculo_atributo va
                                   where va.placa = t.placa
                                   and va.cod_atributo = 'TX_MANUT_AGREGADO'
                               )
                              , kss.pkg_global.fnc_obtem_parametro_str(11, 'OPERACIONAL', 17, 273)
                              ) as tx_manutencao_km
                         , (select sign(count(*))
                                      from oper.v$veiculo v
                             where v.placa = t.placa) as veiculo_ok
                      from (select os.tipo_manutencao_id
                                 , e.placa
                                 , (select nvl(sum(om.valor_total), 0)
                                      from manutencao.v$os_material om
                                     where om.ordem_servico_id = os.ordem_servico_id) as valor_mercadoria
                                 , nvl(os.valor_servico, 0) as valor_servico
                                 , case
                                      when os.tipo_manutencao_id <> 1 then
                                         ((select nvl(sum(om.valor_total), 0)
                                             from manutencao.v$os_material om
                                            where om.ordem_servico_id = os.ordem_servico_id) + nvl(os.valor_servico, 0))
                                      else 0
                                   end as custo_adicional
                                 , case
                                      when os.tipo_manutencao_id = 1 then
                                         ((select nvl(sum(om.valor_total), 0)
                                             from manutencao.v$os_material om
                                            where om.ordem_servico_id = os.ordem_servico_id) + nvl(os.valor_servico, 0))
                                      else 0
                                   end as custo_normal
                                 , (select nvl(sum(oc.total_desconto), 0)
                                      from manutencao.v$ordem_compra oc
                                     inner join manutencao.v$os_ordem_compra ooc
                                             on ooc.num_controle = oc.num_controle
                                     where ooc.ordem_servico_id = os.ordem_servico_id) as valor_desconto
                              from manutencao.v$ordem_servico os
                             inner join almoxarifado.v$equipamento e
                                     on e.equipamento_id = os.equipamento_id
                             where os.data_abertura between to_date('#arguments.data_inicio# 00:00:00', 'dd/mm/yyyy hh24:mi:ss') and to_date('#arguments.data_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                               and (select max(vm.modalidade) keep(dense_rank last order by vm.data) modalidade
                                      from oper.v$veiculo_modalidade vm
                                     where vm.placa = e.placa
                                       and vm.data <= to_date('#arguments.data_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')) not in ('AGREGADO', 'TERCEIRO')
							<cfif Len(Trim(arguments.equipamento_id))>
                               and os.equipamento_id = #arguments.equipamento_id#
                            </cfif>
                            <cfif Len(Trim(arguments.cod_centro_custo))>
                               and (select vcc.cod_centro_custo
                                      from oper.v$veiculo_ccusto vcc
                                     where vcc.placa = e.placa
                                       and vcc.veiculo_ccusto_id = (select max(vcc2.veiculo_ccusto_id) keep(dense_rank last order by vcc2.data)
                                                                          from oper.v$veiculo_ccusto vcc2
                                                                         where vcc2.placa = vcc.placa
                                                                           and vcc2.data <= to_date('#arguments.data_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss'))) = #arguments.cod_centro_custo#
							</cfif>
                            <cfif Len(Trim(arguments.tipo_carroceria_id))>
                               and (select v.tipo_carroceria_id
                                      from oper.v$veiculo v
                                     where v.placa = e.placa) = #arguments.tipo_carroceria_id#
							</cfif>
                             
                             union all
                             
                            select null as tipo_manutencao_id
                                 , v.placa
                                 , 0 as valor_mercadoria
                                 , 0 as valor_servico
                                 , 0 as custo_adicional
                                 , 0 as custo_normal
                                 , 0 as valor_desconto
                              from oper.v$veiculo v
                             inner join oper.v$veiculo_hist_situacao_atual vhsa
                             		 on vhsa.placa = v.placa
                             inner join almoxarifado.v$equipamento e
                                     on e.placa = v.placa
                             where vhsa.situacao_id = 1
                               and (select max(vm.modalidade) keep(dense_rank last order by vm.data) modalidade
                                      from oper.v$veiculo_modalidade vm
                                     where vm.placa = e.placa
                                       and vm.data <= to_date('#arguments.data_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')) not in ('AGREGADO', 'TERCEIRO')
                               and e.equipamento_id not in (select os.equipamento_id
                                                              from manutencao.v$ordem_servico os
                                                             where os.data_abertura between to_date('#arguments.data_inicio# 00:00:00', 'dd/mm/yyyy hh24:mi:ss') and to_date('#arguments.data_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss'))
							<cfif Len(Trim(arguments.equipamento_id))>
                               and e.equipamento_id = #arguments.equipamento_id#
                            </cfif>
                            <cfif Len(Trim(arguments.cod_centro_custo))>
                               and (select vcc.cod_centro_custo
                                      from oper.v$veiculo_ccusto vcc
                                     where vcc.placa = e.placa
                                       and vcc.veiculo_ccusto_id = (select max(vcc2.veiculo_ccusto_id) keep(dense_rank last order by vcc2.data)
                                                                          from oper.v$veiculo_ccusto vcc2
                                                                         where vcc2.placa = vcc.placa
                                                                           and vcc2.data <= to_date('#arguments.data_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss'))) = #arguments.cod_centro_custo#
							</cfif>
                            <cfif Len(Trim(arguments.tipo_carroceria_id))>
                               and v.tipo_carroceria_id = #arguments.tipo_carroceria_id#
							</cfif>
                           ) t
                     group by t.tipo_manutencao_id, t.placa
                   ) a
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Resumo do Custo de Manuteno por KM Rodado
    -- ANDERSON 17/02/2010 - CRIADO
    --->		
    <cffunction name="get_custo_manutencao_km_rodado_total" access="remote" returntype="query" output="true">
        <cfargument name="data_inicio" required="yes">
        <cfargument name="data_fim" required="yes">
        <cfargument name="equipamento_id" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfargument name="tipo_carroceria_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select x.centro_custo
                 , sum(x.valor_total) as valor_total
                 , sum(x.custo_adicional) as custo_adicional
                 , sum(x.custo_normal) as custo_normal
                 , sum(x.valor_desconto) as valor_desconto
                 , nvl(sum(x.km_rodado), 0) as km_rodado
                 , sum(x.credito) as credito
              from (select (select cc.centro_custo
                              from kss.v$centro_custo cc
                             where cc.cod_centro_custo = a.cod_centro_custo) as centro_custo
                         , a.valor_total
                         , a.custo_adicional
                         , a.custo_normal
                         , a.valor_desconto
                         , a.km_rodado
                         , (nvl(a.km_rodado, 0) * nvl(a.tx_manutencao_km, 0)) as credito
                      from (select (select max(vcc.cod_centro_custo) keep(dense_rank last order by vcc.data)
                                      from oper.v$veiculo_ccusto vcc
                                     where vcc.placa = t.placa
                                       and vcc.data <= to_date('#arguments.data_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')) as cod_centro_custo
                                 , (sum(t.valor_mercadoria) + sum(t.valor_servico)) as valor_total
                                 , sum(t.custo_adicional) as custo_adicional
                                 , sum(t.custo_normal) as custo_normal
                                 , sum(t.valor_desconto) as valor_desconto
                                 , nvl(
                                       (select max(vk.km) keep (dense_rank last order by vk.data_hora)
                                      from oper.v$veiculo_km vk
                                     where vk.placa = t.placa
                                           and vk.data_hora <= to_date('#arguments.data_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                                       )
                                       - (select max(vk.km) keep (dense_rank last order by vk.data_hora)
                                      from oper.v$veiculo_km vk
                                     where vk.placa = t.placa
                                             and vk.data_hora <= to_date('#arguments.data_inicio# 00:00:00', 'dd/mm/yyyy hh24:mi:ss')
                                         )
                                      ,(select sum(
                                                   (select max(vk.km) keep (dense_rank last order by vk.data_hora)
                                                      from oper.v$veiculo_km vk
                                                     where vk.placa = vc.placa_1
                                                       and vk.data_hora <= nvl(vc.data_hora_desengate, to_date('#arguments.data_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss'))
                                                   )
                                                   - (select max(vk.km) keep (dense_rank last order by vk.data_hora)
                                                        from oper.v$veiculo_km vk
                                                       where vk.placa = vc.placa_1
                                                         and vk.data_hora <= greatest(to_date('#arguments.data_inicio# 00:00:00', 'dd/mm/yyyy hh24:mi:ss'), vc.data_hora_engate)
                                                     )
                                                  )
                                          from oper.v$veiculo_composicao vc
                                         where vc.placa_2 = t.placa
                                           and vc.data_hora_engate <= to_date('#arguments.data_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                                           and nvl(vc.data_hora_desengate, to_date('#arguments.data_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')) >= to_date('#arguments.data_inicio# 00:00:00','dd/mm/yyyy hh24:mi:ss')
                                       )
                                      ) as km_rodado
                                 , nvl(
                                         (select va.valor
                                            from oper.veiculo_atributo va
                                           where va.placa = t.placa
                                           and va.cod_atributo = 'TX_MANUT_AGREGADO'
                                       )
                                      , kss.pkg_global.fnc_obtem_parametro_str(11, 'OPERACIONAL', 17, 273)
                                      ) as tx_manutencao_km
                              from (select os.tipo_manutencao_id
                                         , e.placa
                                         , (select nvl(sum(om.valor_total), 0)
                                              from manutencao.v$os_material om
                                             where om.ordem_servico_id = os.ordem_servico_id) as valor_mercadoria
                                         , nvl(os.valor_servico, 0) as valor_servico
                                         , case
                                              when os.tipo_manutencao_id <> 1 then
                                                 ((select nvl(sum(om.valor_total), 0)
                                                     from manutencao.v$os_material om
                                                    where om.ordem_servico_id = os.ordem_servico_id) + nvl(os.valor_servico, 0))
                                              else 0
                                           end as custo_adicional
                                         , case
                                              when os.tipo_manutencao_id = 1 then
                                                 ((select nvl(sum(om.valor_total), 0)
                                                     from manutencao.v$os_material om
                                                    where om.ordem_servico_id = os.ordem_servico_id) + nvl(os.valor_servico, 0))
                                              else 0
                                           end as custo_normal
                                         , (select nvl(sum(oc.total_desconto), 0)
                                              from manutencao.v$ordem_compra oc
                                             inner join manutencao.v$os_ordem_compra ooc
                                                     on ooc.num_controle = oc.num_controle
                                             where ooc.ordem_servico_id = os.ordem_servico_id) as valor_desconto
                                      from manutencao.v$ordem_servico os
                                     inner join almoxarifado.v$equipamento e
                                             on e.equipamento_id = os.equipamento_id
                                     where os.data_abertura between to_date('#arguments.data_inicio# 00:00:00', 'dd/mm/yyyy hh24:mi:ss') and to_date('#arguments.data_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                                       and (select max(vm.modalidade) keep(dense_rank last order by vm.data) modalidade
                                              from oper.v$veiculo_modalidade vm
                                             where vm.placa = e.placa
                                               and vm.data <= to_date('#arguments.data_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')) not in ('AGREGADO', 'TERCEIRO')
									<cfif Len(Trim(arguments.equipamento_id))>
                                       and os.equipamento_id = #arguments.equipamento_id#
                                    </cfif>
                                    <cfif Len(Trim(arguments.cod_centro_custo))>
                                       and (select vcc.cod_centro_custo
                                              from oper.v$veiculo_ccusto vcc
                                             where vcc.placa = e.placa
                                               and vcc.veiculo_ccusto_id = (select max(vcc2.veiculo_ccusto_id) keep(dense_rank last order by vcc2.data)
                                                                                  from oper.v$veiculo_ccusto vcc2
                                                                                 where vcc2.placa = vcc.placa
                                                                                   and vcc2.data <= to_date('#arguments.data_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss'))) = #arguments.cod_centro_custo#
                                    </cfif>
                                    <cfif Len(Trim(arguments.tipo_carroceria_id))>
                                       and (select v.tipo_carroceria_id
                                              from oper.v$veiculo v
                                             where v.placa = e.placa) = #arguments.tipo_carroceria_id#
                                    </cfif>
                                     
                                     union all
                                     
                                    select null as tipo_manutencao_id
                                         , v.placa
                                         , 0 as valor_mercadoria
                                         , 0 as valor_servico
                                         , 0 as custo_adicional
                                         , 0 as custo_normal
                                         , 0 as valor_desconto
                                      from oper.v$veiculo v
                                     inner join oper.v$veiculo_hist_situacao_atual vhsa
                                     		 on vhsa.placa = v.placa
                                     inner join almoxarifado.v$equipamento e
                                             on e.placa = v.placa
                                     where vhsa.situacao_id = 1
                                       and (select max(vm.modalidade) keep(dense_rank last order by vm.data) modalidade
                                              from oper.v$veiculo_modalidade vm
                                             where vm.placa = e.placa
                                               and vm.data <= to_date('#arguments.data_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')) not in ('AGREGADO', 'TERCEIRO')
                                       and e.equipamento_id not in (select os.equipamento_id
                                                                      from manutencao.v$ordem_servico os
                                                                     where os.data_abertura between to_date('#arguments.data_inicio# 00:00:00', 'dd/mm/yyyy hh24:mi:ss') and to_date('#arguments.data_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss'))
									<cfif Len(Trim(arguments.equipamento_id))>
                                       and e.equipamento_id = #arguments.equipamento_id#
                                    </cfif>
                                    <cfif Len(Trim(arguments.cod_centro_custo))>
                                       and (select vcc.cod_centro_custo
                                              from oper.v$veiculo_ccusto vcc
                                             where vcc.placa = e.placa
                                               and vcc.veiculo_ccusto_id = (select max(vcc2.veiculo_ccusto_id) keep(dense_rank last order by vcc2.data)
                                                                                  from oper.v$veiculo_ccusto vcc2
                                                                                 where vcc2.placa = vcc.placa
                                                                                   and vcc2.data <= to_date('#arguments.data_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss'))) = #arguments.cod_centro_custo#
                                    </cfif>
                                    <cfif Len(Trim(arguments.tipo_carroceria_id))>
                                       and v.tipo_carroceria_id = #arguments.tipo_carroceria_id#
                                    </cfif>
                                   ) t
                             group by t.tipo_manutencao_id, t.placa
                        ) a
                   ) x
             group by x.centro_custo
             order by x.centro_custo
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Busca as transaes das Amostras de Lubrificantes
    -- RAFAEL 11/09/2009 - CRIADO
    --->		
    <cffunction name="get_lubrificante_transacao" access="remote" returntype="query" output="true">
    	<cfargument name="placa" required="no" default="">
        <cfargument name="amostra_original" required="no" default="">
        <cfargument name="transacao" required="no" default="">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_fim" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			    select a.transacao_id
                     , a.amostra_id_original as amostra_original
                     , a.tipo_amostra as tipo
                     , a.amostra_id
                     , a.laboratorio
                     , a.placa
                     , a.nome_compartimento as compartimento
                     , a.km_coleta
                     , a.km_ultima_troca
                     , a.vida_util
                     , a.equipamento_empresa as equipamento
                     , to_char(a.date_insert, 'dd/mm/yyyy hh24:mi') as date_insert
                     , a.user_insert
                     , atr.xml_envio
                     , atr.xml_retorno
                     , 1 as detalhes
                     , 1 as atualizar
                  from manutencao.v$amostra_lista a
            inner join manutencao.v$amostra_transacao atr
                    on atr.transacao_id = a.transacao_id
                 where 1 = 1
            <cfif Len(Trim(arguments.placa))>
                   and a.placa = '#arguments.placa#'
            </cfif>
            <cfif Len(Trim(arguments.amostra_original))>
                   and a.amostra_id_original = #arguments.amostra_original#
            </cfif>
            <cfif Len(Trim(arguments.transacao))>
                   and a.transacao_id = #arguments.transacao#
            </cfif>	
            <cfif Len(Trim(arguments.data_inicio))>
			   	   and a.data_coleta >= '#arguments.data_inicio#'
            </cfif>  
            <cfif Len(Trim(arguments.data_fim))>
			       and a.data_coleta <= '#arguments.data_fim#'
            </cfif>  
              order by a.data_coleta desc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Busca o resultado das Amostras de Lubrificantes
    -- RAFAEL 11/09/2009 - CRIADO
    --->		
    <cffunction name="get_lubrificante_transacao_resultado" access="remote" returntype="query" output="true">
    	<cfargument name="amostra_id_original" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			    select ar.amostra_id
                     , ar.cod_elemento as elemento
                     , ar.valor
                     , ar.situacao
                     , ar.resultado_id
                  from manutencao.v$amostra_resultado ar
            inner join manutencao.v$amostra a
                    on a.amostra_id = ar.amostra_id
                 where 1 = 1
                   and a.amostra_id_original = '#arguments.amostra_id_original#'           
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os pedidos de compra vinculados a uma ordem de servio
    -- ANDERSON 30/11/2009 - CRIADO
    --->		
    <cffunction name="get_os_pedido" access="remote" returntype="query" output="true">
        <cfargument name="ordem_servico_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select p.pedido_id
                 , p.num_pedido
                 , to_char(p.data_pedido, 'dd/mm/yyyy') as data_pedido
                 , (select cg.rv_abbreviation
                      from compras.v$cg_ref_codes cg
                     where cg.rv_domain = 'PEDIDO SITUACAO'
                       and cg.rv_low_value = p.situacao_id
                   ) as situacao
                 , compras.pkg_compras.fnc_get_solitacao_pedido(p.pedido_id) as num_solicitacao_compra
                 , compras.pkg_compras.fnc_get_solicitante_pedido(p.pedido_id) as solicitante
                 , p.valor_material
                 , p.valor_atividade
                 , p.valor_total_pedido
                 , ospi.pedido_item_id
                 , (select osp.valor_utilizado
                      from manutencao.v$os_pedido osp
                     where osp.ordem_servico_id = ospi.ordem_servico_id
                       and osp.pedido_id = pi.pedido_id) as valor_utilizado
                 , nvl(a.titulo, m.descricao_completa) as descricao_item
                 , ct.valor_negociado
              from manutencao.v$os_pedido_item ospi
             inner join compras.v$pedido_item pi
                     on pi.pedido_item_id = ospi.pedido_item_id
             inner join compras.v$pedido p
                     on p.pedido_id = pi.pedido_id
             inner join compras.v$cotacao ct
                     on ct.cotacao_id = pi.cotacao_id
              left join manutencao.v$atividade a
                     on a.atividade_id = ct.atividade_id
              left join almoxarifado.v$material m
                     on m.material_id = ct.material_id
             where ospi.ordem_servico_id = #arguments.ordem_servico_id#
             order by p.num_pedido
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os tipos de ordem de servio
    -- ANDERSON 08/12/2009 - CRIADO
    --->		
    <cffunction name="get_tipo_ordem_servico" access="remote" returntype="query" output="true">
        <cfargument name="tipo_ordem_servico_id" required="no" default="">
        <cfargument name="descricao" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select tos.tipo_ordem_servico_id
                 , tos.descricao
              from manutencao.v$tipo_ordem_servico tos
             where 1 = 1
			<cfif Len(Trim(arguments.tipo_ordem_servico_id))>
               and tos.tipo_ordem_servico_id = #arguments.tipo_ordem_servico_id#
            </cfif>
            <cfif Len(Trim(arguments.descricao))>
               and upper(tos.descricao) like upper('#arguments.descricao#%')
            </cfif>
             order by tos.descricao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

	<!--- 
	-- PROPSITO 
	- Busca veculos em manuteno
	-- NOTAS EXPLICATIVAS
	-- GUTO 15/12/2009
	--->
	<cffunction name="get_veiculos_manutencao" returntype="query" access="remote">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select os.ordem_servico_id, os.num_ordem_servico, 
                   e.placa, e.cod_equipamento, o.cliente as oficina,
                   nvl(tos.descricao, 'No identificado') as tipo_os, 
                   to_char(os.data_abertura,'dd/mm/yyyy hh24:mi') as data_abertura, 
                   kss.to_tempo(numtodsinterval((nvl(os.data_fechamento,sysdate) - os.data_abertura),'day'),1).retorno as tempo_total,
                   numtodsinterval((nvl(os.data_fechamento,sysdate) - os.data_abertura),'day') as tempo_internval, os.observacao,
                   r.cliente as responsavel, os.user_insert, 
                   to_char(os.date_insert,'dd/mm/yyyy hh24:mi') as date_insert,
                   to_char(manutencao.to_os_liberacao(e.placa).data_previsao,'dd/mm/yyyy hh24:mi') as data_prev_liberacao
                   ,manutencao.to_os_liberacao(e.placa).motivo as motivo
              from manutencao.v$ordem_servico os
             inner join almoxarifado.v$equipamento e
                     on e.equipamento_id = os.equipamento_id
             inner join kss.v$pessoa o
                     on o.cod_pessoa = os.cod_pessoa_oficina
              left join manutencao.v$tipo_ordem_servico tos
                     on tos.tipo_ordem_servico_id = os.tipo_ordem_servico_id
             inner join kss.v$pessoa r
                     on r.cod_pessoa = os.cod_pessoa_responsavel
             where os.data_fechamento is null
            order by tempo_internval desc         
   		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca tipos de Solicitao
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 15/12/2009
	--->
	<cffunction name="get_solicitacao_equip_tipo" returntype="query" access="remote">
        <cfargument name="descricao" required="no" default="">
        <cfargument name="controle_trafego" required="no" default="">
        <cfargument name="bloqueia_veiculo" required="no" default="">
        <cfargument name="tipo_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select est.tipo_id
                 , est.descricao
                 , est.dados_adicionais
                 , est.nivel_importancia
                 , est.controle_trafego
                 , decode(est.controle_trafego, 0,'No','Sim') as controle_trafego_descricao
                 , est.bloqueia_veiculo
                 , decode(est.bloqueia_veiculo, 0,'No','Sim') as bloqueia_veiculo_descricao
                 , est.lista_email
              from manutencao.v$equipamento_solicitacao_tipo est
             where 1 = 1
        	<cfif Len(Trim(arguments.descricao))>
              and upper(est.descricao) like upper('%#arguments.descricao#%')
        	</cfif>
            <cfif Len(Trim(arguments.controle_trafego))>
              and est.controle_trafego = #arguments.controle_trafego#
        	</cfif>
            <cfif Len(Trim(arguments.bloqueia_veiculo))>
              and est.bloqueia_veiculo = #arguments.bloqueia_veiculo#
        	</cfif>
            <cfif Len(Trim(arguments.tipo_id))>
              and est.tipo_id = #arguments.tipo_id#
        	</cfif>
   		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Busca as anlises das Amostras de Lubrificantes
    -- RAFAEL 11/09/2009 - CRIADO
    --->		
    <cffunction name="get_analises" access="remote" returntype="query" output="true">
    	<cfargument name="placa" required="no" default="">
        <cfargument name="amostra_id" required="no" default="">
        <cfargument name="resultado" required="no" default="1">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_fim" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			    select a.amostra_id
                     , a.placa
                     , to_char(a.data_coleta, 'dd/mm/yyyy') as data_coleta
                     , a.km_ultima_troca
                     , a.km_coleta as km_troca_atual
                     , a.tipo_amostra
                     , a.cod_equipamento
                     , a.nome_equipamento
                     , a.nome_compartimento
                     , a.nome_oleo
                     , a.laboratorio
                     , a.km_coleta
                     , a.vida_util
                     , a.equipamento_empresa as equipamento
                     , to_char(a.data_recebimento, 'dd/mm/yyyy') as data_recebimento
                     , a.status_laboratorio
                     , a.status_empresa
                     , a.resultado
                  from manutencao.v$amostra_lista a
                 where a.data_cancelamento is null
                   and a.resultado = 0
            <cfif Len(Trim(arguments.placa))>
                   and a.placa = '#arguments.placa#'
            </cfif>
            <cfif Len(Trim(arguments.amostra_id))>
                   and a.amostra_id = #arguments.amostra_id#
            </cfif>
            <cfif Len(Trim(arguments.resultado))>
                   and a.resultado = #arguments.resultado#
            </cfif>	
            <cfif Len(Trim(arguments.data_inicio))>
			   	   and a.data_coleta >= '#arguments.data_inicio#'
            </cfif>  
            <cfif Len(Trim(arguments.data_fim))>
			       and a.data_coleta <= '#arguments.data_fim#'
            </cfif>  
              order by a.data_coleta desc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna o veiculo_id de um equipamento
    -- RAFAEL 08/12/2009 - CRIADO
    --->		
    <cffunction name="get_veiculo_equipamento" access="remote" returntype="query" output="true">
        <cfargument name="equipamento_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select v.veiculo_id
              from oper.v$veiculo v
             where v.placa = (select e.placa
                                from almoxarifado.v$equipamento e
                               where e.equipamento_id = #arguments.equipamento_id#)
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    <!--- 
    -- PROPSITO 
    -- Retorna o veiculo_id de um equipamento
    -- RAFAEL 08/12/2009 - CRIADO
    --->		
    <cffunction name="get_pendencias_registradas" access="remote" returntype="query" output="true">
        <cfargument name="atendida" required="no" default="0"> 
        <cfargument name="tracao" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select est.descricao, est.nivel_importancia, oso.solicitacao_id,
            	   round((sysdate - oso.data_solicitacao)*24) as tempo_solicitacao,
                   to_char(oso.data_solicitacao,'dd/mm/yyyy hh24:mi') as data_solicitacao, oso.texto, oso.cod_pessoa_responsavel, p.cliente as solicitante,
                   oso.equipamento_id, e.cod_equipamento, e.placa, 
                   kss.to_tempo((sysdate-oso.data_solicitacao)*1440,3).retorno as tempo_aberto,
                   oso.ordem_servico_id_execucao, os.num_ordem_servico, 
                   to_char(os.data_abertura,'dd/mm/yyyy hh24:mi') as data_abertura, po.cliente as oficina,
                   va.tracao,
                   (select case
                             when ct.engatada = 1 then ct.landmark
                             when ct.engatada = 0 and va.tracao = 1 then ct.landmark
                             when ct.engatada = 0 and va.tracao = 0 then 'Desengatada em: '||ct.landmark
                           end
                      from oper.v$rank_frota ct
                     where ((ct.placa_controle = e.placa and (ct.engatada = 1 or ct.placa_referencia is null))
                       or ct.placa_referencia = oper.pkg_veiculo.fnc_primeira_carreta(e.placa))
                      and rownum = 1 ) as posicao_atual, oso.tipo_id
              from manutencao.v$equipamento_solicitacao oso
              inner join manutencao.v$equipamento_solicitacao_tipo est
                      on est.tipo_id = oso.tipo_id
              inner join kss.v$pessoa p
                      on p.cod_pessoa = oso.cod_pessoa_responsavel
              inner join almoxarifado.v$equipamento e
                      on e.equipamento_id = oso.equipamento_id
              left join manutencao.v$os_equipamento_solicitacao oes
                      on oso.solicitacao_id = oes.solicitacao_id
              left join manutencao.v$ordem_servico os
                     on os.ordem_servico_id = oso.ordem_servico_id_execucao
              left join kss.v$pessoa po 
                     on po.cod_pessoa = os.cod_pessoa_oficina
              left join oper.v$veiculo v
                     on v.placa = e.placa
              left join oper.v$veiculo_tipo_carroceria vtc
                     on vtc.tipo_carroceria_id = v.tipo_carroceria_id
              left join oper.v$veiculo_agrupamento va
                     on va.agrupamento_id = vtc.agrupamento_id         
              where oso.data_cancelamento is null 
              <cfif Len(Trim(arguments.atendida))>
                and oso.atendida = #arguments.atendida#
              </cfif>
              <cfif Len(Trim(arguments.tracao))>
                and va.tracao = #arguments.tracao#
              </cfif>
              order by est.nivel_importancia desc, est.descricao, oso.equipamento_id, oso.data_solicitacao desc    
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os valores de estadias de manuteno por mes
    -- WAGNERS 11/08/2010 - CRIADO
    --->		
    <cffunction name="get_estadia_manutencao" access="remote" returntype="query" output="true">
        <cfargument name="data_inicio" required="no" default=""> 
        <cfargument name="data_fim" required="no" default="">
        <cfargument name="sinistro" required="no" default="">
        <cfargument name="not_sinistro" required="no" default="">
        <cfargument name="ano" required="no" default="">
        <cfargument name="marca_id" required="no" default="">
        <cfargument name="modelo_id" required="no" default="">
        <cfargument name="cod_pessoa_proprietario" required="no" default="">
        <cfargument name="complementarData" required="no" default="">
        
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        
           select mes_ano,
           		  ano_mes,
                  sum(tempo) as tempo,
                  sum(valor) as valor
            
             from (select to_char( nvl(r.DATA_TERMINO,ctr.DATA_LANCAMENTO), 'mm/yyyy') as mes_ano,
                          to_char( nvl(r.DATA_TERMINO,ctr.DATA_LANCAMENTO), 'yyyymm') as ano_mes,
                          ctr.MANUT_TEMPO as tempo,
                          ctr.MANUT_VALOR_ESTADIA as valor
                    
                     from oper.v$ctrl_tempo_romaneio ctr
	                 left join oper.v$romaneio r          on ctr.NUM_ROMANEIO = r.NUM_ROMANEIO
                     left join oper.v$evento_operacao eo  on eo.controle_evo_id = ctr.evo_id_engate

              <cfif Len(Trim(arguments.COD_PESSOA_PROPRIETARIO)) >
                    inner join oper.v$veiculo_proprietario_atual vpa on vpa.placa = ctr.placa_controle
              </cfif>
              
                   where 1 = 1
             
             <cfif Len(Trim(arguments.COD_PESSOA_PROPRIETARIO)) >
                    and vpa.cod_pessoa in (#arguments.cod_pessoa_proprietario#)
             </cfif>
             <cfif Len(Trim(arguments.sinistro))>
             		and exists ( select 'x'
                                  from oper.v$tempo_viagem_atributo tva
                                 where tva.motivo_id = ctr.manut_motivo_id
                                     and (tva.cod_atributo = 'SINISTRO' and tva.valor = 1)
                                )
             </cfif>
             <cfif Len(Trim(arguments.not_sinistro))>
                       and not exists ( select 'x'
                                      from oper.v$tempo_viagem_atributo tva
                                     where tva.motivo_id = ctr.manut_motivo_id
                                       and tva.cod_atributo = 'SINISTRO' and tva.valor = '1'
		                            )
             </cfif>
             
             <cfif Len(Trim(arguments.data_inicio & arguments.data_fim)) >
                    and ((ctr.vazio_carregado < 2 and r.data_termino between to_date('<cfoutput>#arguments.DATA_INICIO#</cfoutput>', 'dd/mm/yyyy') and last_day(to_date('<cfoutput>#arguments.DATA_FIM#</cfoutput> 23:59:59', 'dd/mm/yyyy hh24:mi:ss'))) or ctr.vazio_carregado = 2) 
   					and ((ctr.vazio_carregado = 2 and eo.data between to_date('<cfoutput>#arguments.DATA_INICIO#</cfoutput>', 'dd/mm/yyyy') and last_day(to_date('<cfoutput>#arguments.DATA_FIM#</cfoutput> 23:59:59', 'dd/mm/yyyy hh24:mi:ss'))) or ctr.vazio_carregado < 2)
             </cfif>
             <cfif Len(Trim(arguments.placa)) >
             		and upper(ctr.placa_controle) = upper('#arguments.placa#')
             </cfif>
             <cfif Len(Trim(arguments.MARCA_ID)) >
             	   and exists ( select 'x'
                          from oper.v$veiculo v
                         where v.placa = r.placa_controle
                           and v.MARCA_ID = #arguments.MARCA_ID#
                           )
             </cfif>
             <cfif Len(Trim(arguments.MODELO_ID)) >
             		and exists ( select 'x'
                          from oper.v$veiculo v
                         where v.placa = r.placa_controle
                           and v.modelo_id in (#arguments.MODELO_ID#)
                           )
              </cfif>
              <cfif Len(Trim(arguments.ANO)) >
              		and exists ( select 'x'
                          from oper.v$veiculo v
                         where v.placa = r.placa_controle
                           and v.ano in (#arguments.ano#)
                           )
              </cfif>
             
                  ) t
            
             group by t.mes_ano, t.ano_mes
            
             order by t.ano_mes
 
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    

    <!--- 
    -- PROPSITO 
    -- Retorna ficha de atividades do equipamento
    -- GUTO 29/04/2010 - CRIADO
    --->		
    <cffunction name="get_equipamento_ficha_atividade" access="remote" returntype="query" output="true">
        <cfargument name="equipamento_id" required="no" default="">
        <cfargument name="data_inicial" required="no" default="">
        <cfargument name="data_final" required="no" default="">
        <cfargument name="atividade_id" required="no" default="">
        <cfargument name="historico" required="no" default="0">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select a.num_ordem_servico, a.ordem_servico_id, a.titulo, to_char(a.data_os,'dd/mm/yyyy') as data_os, 
                   decode(km_posterior,null,'Montado','Trocada') as situacao,
                   case 
                     when km_posterior is not null then 
                          km_posterior - a.km_abertura
                   else oper.pkg_pneu.fnc_km_atual(a.placa) - a.km_abertura 
                   end rodado,
                   a.km_abertura as km_execucao,
                   nvl(km_posterior,oper.pkg_pneu.fnc_km_atual(a.placa)) as km_atual,
                   (select ati.nome
                      from manutencao.v$atividade_tipo ati
                     where ati.tipo_id = av.tipo_id) as tipo, 
                   decode(av.importancia,1,'Baixa',2,'Mdia',3,'Alta') as importancia,
                   av.garantia_km, a.equipamento_id, a.placa, a.posicao, vd.marca, vd.modelo, vd.agrupamento, vd.classificacao
              from (select os.num_ordem_servico as num_ordem_servico, os.ordem_servico_id, a.titulo, os.data_abertura as data_os, os.km_abertura, 
                           lag(os.km_abertura) over (partition by e.placa,oa.atividade_id,ep.posicao_id order by e.placa, oa.atividade_id,ep.posicao_id, os.data_abertura) as km_anterior,
                           lead(os.km_abertura) over (partition by e.placa,oa.atividade_id,ep.posicao_id order by e.placa, oa.atividade_id,ep.posicao_id, os.data_abertura) as km_posterior,
                           os.equipamento_id, e.placa, oa.posicao_id, ep.posicao, oa.atividade_id 
                      from manutencao.v$ordem_servico os
                     inner join manutencao.v$os_atividade oa
                             on oa.ordem_servico_id = os.ordem_servico_id
                     inner join manutencao.v$atividade a
                             on a.atividade_id = oa.atividade_id
                     inner join almoxarifado.v$equipamento e
                             on e.equipamento_id = os.equipamento_id
                     inner join manutencao.v$equipamento_posicao ep
                             on ep.posicao_id = oa.posicao_id
                          <cfif Len(Trim(arguments.ATIVIDADE_ID))>
            		          where oa.atividade_id = #arguments.ATIVIDADE_ID#
                          </cfif>
                    order by e.placa, oa.atividade_id, ep.posicao_id, os.data_abertura) a
             inner join oper.v$veiculo_dados vd
                     on vd.placa = a.placa
             inner join manutencao.v$atividade av
                     on av.atividade_id = a.atividade_id  
            where 1=1
			  <cfif Len(Trim(arguments.EQUIPAMENTO_ID))>
                and a.equipamento_id = #arguments.EQUIPAMENTO_ID#
                <cfif arguments.historico eq 0>
  	               and km_posterior is null
                </cfif>
              </cfif>
  		    <cfif Len(Trim(arguments.EQUIPAMENTO_ID))>
              <cfif arguments.historico eq 0>
                  order by a.placa, a.data_os, a.atividade_id, a.posicao_id
              <cfelse>
                 order by a.placa, a.atividade_id, a.posicao_id, a.data_os
              </cfif>               
            <cfelse>
              order by a.placa, a.atividade_id, a.posicao_id, a.data_os
            </cfif> 
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca OSs externas com tabelas de manutencao
	-- NOTAS EXPLICATIVAS
	-- GUTO 11/10/2006
	--->
	<cffunction name="get_os_externa_tabela_resumo" returntype="query" access="remote">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select /*+ ORDERED*/ os.ordem_servico_id
                 , os.num_ordem_servico
                 , os.empresa
                 , os.equipamento_id
                 , e.cod_equipamento
                 , to_char(os.data_abertura,'dd/mm/yyyy hh24:mi') as data_abertura
                 , to_char(os.data_previsao_liberacao,'dd/mm/yyyy hh24:mi') as data_previsao_liberacao
                 , ot.controle_id
                 , ot.confirmada
                 , tm.nome as tabela
                 , tm.tipo_execucao
              from manutencao.v$ordem_servico_dados os
             inner join almoxarifado.v$equipamento e
                on e.equipamento_id = os.equipamento_id
             inner join manutencao.v$os_tabela_manutencao ot
                on ot.ordem_servico_id = os.ordem_servico_id
             inner join manutencao.v$tabela_manutencao tm 
                on tm.tabela_id = ot.tabela_id
             where 1=1
               and os.socorro = 0
               and os.data_fechamento is null     
               and os.empresa = 0
             order by os.ordem_servico_id
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>

    <!--- 
	-- PROPSITO 
	-- Busca dados das OSs abertas para a composio
	-- NOTAS EXPLICATIVAS
	-- GUTO 07/10/2006
	--->
	<cffunction name="get_ordens_servico_print" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" required="no" default="">
		<cfquery result="QUERY" name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select os.num_ordem_servico
                 , e.cod_equipamento
                 , almoxarifado.pkg_almoxarifado.fnc_get_material_descricao(e.material_id,' ') as material
                 , to_char(os.data_abertura, 'dd/mm/yyyy hh24:mi') as data_abertura
                 , oper.pkg_global.fnc_busca_nome_pessoa(os.cod_pessoa_responsavel) as responsavel
                 , p.cliente as oficina
                 ,  (select oser.valor_servico_fechamento + oser.valor_materiais_fechamento
                       from manutencao.v$ordem_servico oser
                      where oser.ordem_servico_id = os.ordem_servico_id) as valor_total_os
              from manutencao.v$ordem_servico_dados os
        inner join kss.v$pessoa p
                on p.cod_pessoa = os.cod_pessoa_oficina
        inner join almoxarifado.v$equipamento e
                on e.equipamento_id = os.equipamento_id
             where 1 = 1
            <cfif Len(Trim(arguments.ordem_servico_id))>
               and os.ordem_servico_id = #arguments.ordem_servico_id#
            </cfif>
        </cfquery>		
		<cfreturn qr_result>
	</cffunction>
    
	<!--- 
	-- PROPSITO 
	-- Busca Processos para abertos na oficina
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 25/09/2009 - EDITADO
	--->
	<cffunction name="print_oficina_processos_execucao" returntype="query" access="remote" output="true">
		<cfargument name="cod_pessoa" required="no" default="">
		<cfargument name="aberta" required="no" default="">
		<cfargument name="controle_id_processo" required="no" default="">
        <cfargument name="ordem_servico_id" required="no" default="">
        <cfargument name="equipamento_id" required="no" default="">
        <cfargument name="verificacao" required="no" default="0">
        <cfargument name="externa" required="no" default="0" hint="0-No; 1-Sim">
        <cfargument name="ultima_execucao" required="no" default="0" hint="0-No; 1-Sim">
		<cfquery result="query" name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select tipo,
                   rownum as linha_controle,
                   ordem_servico_id,
                   empresa,
                   cod_pessoa_oficina,
                   equipamento_id,
                   cod_equipamento,
                   agrupamento,
                   num_ordem_servico,
                   grupo_id,
                   grupo,
                   compartimento_id,
                   compartimento,
                   posicao_id,
                   posicao,
                   atividade,
                   processo_id,
                   processo,
                   executada,
                   execucao_id,
                   controle_id_processo,
                   controle_id_atividade,
                   cod_pessoa_principal,
                   principal,
                   cod_pessoa_auxiliar,
                   auxiliar,
                   data_inicio,
                   data_termino,
                   tempo_estimado,
                   tempo_execucao,
                   ordem_processo,
                   nome_mecanico,
                   nome_mecanico_auxiliar,
                   nivel_id,
                   especialidade_id
              from (select distinct po.tipo, 
                           po.ordem_servico_id,
                           po.empresa,
                           po.cod_pessoa_oficina,
                           po.equipamento_id,
                           po.cod_equipamento,
                           po.cod_equipamento || ' > ' || nvl(po.compartimento, 'Veculo') as agrupamento,
                           po.num_ordem_servico,
                           po.grupo_id,
                           nvl(po.grupo, 'Veculo') as grupo,
                           po.compartimento_id,
                           nvl(po.compartimento, 'Veculo') as compartimento,
                           po.posicao_id,
                           po.posicao,
                           po.atividade || ' > ' || nvl(po.grupo, 'Veculo') as atividade,
                           po.processo_id,
                           po.processo || chr(10) || chr(13) || 'Auxiliar: ' || nvl((select p3.cliente
                                                                                      from kss.v$pessoa p3
                                                                                     where p3.cod_pessoa = po.cod_pessoa_auxiliar), 'No informado') as processo,
                           po.executada,
                           po.execucao_id,
                           po.controle_id_processo,
                           po.controle_id_atividade,
                           po.cod_pessoa_principal,
                           po.principal,
                           po.cod_pessoa_auxiliar,
                           po.auxiliar,
                           po.data_inicio,
                           po.data_termino,
                           po.tempo_estimado,
                           po.tempo_execucao,
                           po.ordem_processo,
                           (select p2.cliente
                              from kss.v$pessoa p2
                             where p2.cod_pessoa = po.cod_pessoa_principal) as nome_mecanico,                     
                           nvl((select p3.cliente
                              from kss.v$pessoa p3
                             where p3.cod_pessoa = po.cod_pessoa_auxiliar),'No informado') as nome_mecanico_auxiliar,
                           0 as nivel_id,
                           0 as especialidade_id
                      from manutencao.v$processos_oficina po
                     inner join manutencao.v$processo_recurso pr
                             on po.processo_id = pr.processo_id
                    <cfif arguments.externa eq 1>
                     inner join kss.v$pessoa p
                             on p.cod_pessoa = po.cod_pessoa_oficina
                    <cfelse>
                     inner join kss.v$pessoa p
                             on p.cod_pessoa = po.cod_pessoa_principal
                     inner join manutencao.v$recurso r
                             on r.cod_pessoa = p.cod_pessoa
                            and r.especialidade_id = pr.especialidade_id
                    </cfif>
                     where 1 = 1
                       and po.executada = 0
                    <cfif arguments.externa eq 0>
                       and po.execucao_id is not null
                       and po.cod_pessoa_oficina = #session.cod_pessoa#
                    </cfif>
                    <cfif Len(Trim(arguments.cod_pessoa))>
                       and po.cod_pessoa_principal = #arguments.cod_pessoa#
                    </cfif>
                    <cfif Len(Trim(arguments.aberta))>
                       and po.data_termino is null
                    </cfif>
                    <cfif Len(Trim(arguments.controle_id_processo))>
                       and po.controle_id_processo in (#arguments.controle_id_processo#)
                    </cfif>
                    <cfif Len(Trim(arguments.ordem_servico_id))>
                       and po.ordem_servico_id = #arguments.ordem_servico_id#
                    </cfif>
                    <cfif Len(Trim(arguments.equipamento_id))>
                       and po.equipamento_id = #arguments.equipamento_id#
                    </cfif>
                    <cfif arguments.verificacao eq 1>
                       and po.verificacao = 1
                    </cfif>
                    <cfif arguments.ultima_execucao eq 1>
                        and nvl(po.execucao_id, -1) = nvl((select max(po2.execucao_id) keep(dense_rank last order by po2.data_inicio)
                                                                                                     from manutencao.v$processos_oficina po2
                                                                                                    where po2.controle_id_processo = po.controle_id_processo), -1)                         
                    </cfif>
                     order by ordem_servico_id, compartimento, grupo, posicao, atividade, ordem_processo, data_inicio)
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
    
    
    <!--- 
	-- PROPSITO 
	-- Busca os veiculos do centro de custo e a sua disponibilidade
	-- NOTAS EXPLICATIVAS
	-- WAGNER 27/08/2012
	--->
	<cffunction name="get_disponibilidade_veic_ccusto" returntype="query" access="remote">
		<cfargument name="data_inicio" required="no" default="#lsdateformat(now())#">
        <cfargument name="data_fim" required="no" default="#lsdateformat(now())#">
        <cfargument name="cod_centro_custo" required="no" default="">
		<cfquery result="QUERY" name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select y.cod_equipamento as frota,
                   y.horas_disponiveis,
                   y.horas_paradas,
                   y.horas_falha,       
                   case 
                    when y.horas_paradas > 0 then
                       round( nvl((( y.horas_falha * 100) / y.horas_paradas) , 0), 2)
                    else
                       0
                   end perc_horas_falha,
                   round(nvl(((y.horas_disponiveis - (y.horas_paradas - y.horas_falha )) * 100 /
                                     y.horas_disponiveis),
                                     0),
                                 2) as perc_horas_disp,
                   round( sum( y.horas_paradas ) over() ,2) as total_horas_paradas
              from (select t.cod_equipamento,
                           d.data_inicio,
                           d.data_fim,
                           ( (24 * (d.data_fim - d.data_inicio)) * t.percentual_centro_custo ) as horas_disponiveis,
                           (select least( round(nvl(sum(least(os.data_fechamento, d.data_fim) -
                                                        greatest(os.data_abertura, d.data_inicio)) * 24,
                                                     0),
                                                 2), (d.data_fim - d.data_inicio) * 24)
                                   * t.percentual_centro_custo
                              from manutencao.v$ordem_servico os
                             where os.equipamento_id = t.EQUIPAMENTO_ID
                               and os.data_fechamento is not null
                               and ((os.data_abertura between d.data_inicio and
                                   d.data_fim) or (os.data_fechamento between
                                   d.data_inicio and d.data_fim))) as horas_paradas,
                           (select round( nvl (sum(least(os.data_fechamento, d.data_fim) -
                                                   greatest(os.data_abertura, d.data_inicio)) * 24
                                                   * t.percentual_centro_custo, 0), 2)
                              from manutencao.v$ordem_servico os
                             where os.equipamento_id = t.EQUIPAMENTO_ID
                               and os.tipo_manutencao_id = 3
                               and os.data_fechamento is not null
                               and ((os.data_abertura between d.data_inicio and
                                   d.data_fim) or (os.data_fechamento between
                                   d.data_inicio and d.data_fim))) as horas_falha
                      from( select distinct e.COD_EQUIPAMENTO
                                 , e.equipamento_id
                                 , nvl((select percentual/100
                                          from manutencao.v$ccusto_perc_trabalho_atual pt
                                         where pt.cod_centro_custo = vcc.cod_centro_custo),1) as percentual_centro_custo
                              from oper.v$veiculo_ccusto vcc
                             inner join oper.v$veiculo_controle v
                    			on v.placa = vcc.placa
                             inner join almoxarifado.v$equipamento e
                                on e.COD_EQUIPAMENTO = vcc.placa
                                or e.PLACA = vcc.placa
                             where vcc.cod_centro_custo = #arguments.cod_centro_custo#
                               and v.situacao_id = 1
                               and vcc.veiculo_ccusto_id = (select max(vcc2.veiculo_ccusto_id) keep(dense_rank last order by vcc2.data)
                                                              from oper.v$veiculo_ccusto vcc2
                                                             where vcc2.placa = vcc.placa
                                                               and vcc2.data < to_date('#arguments.data_fim#', 'dd/mm/yyyy') ) ) t,
                      (select to_date('#arguments.data_inicio#', 'dd/mm/yyyy') as data_inicio
                            , to_date('#arguments.data_fim#', 'dd/mm/yyyy') + 1 as data_fim
                         from dual) d
                   ) y
              order by y.cod_equipamento
        </cfquery>		
		<cfreturn qr_result>
	</cffunction>
    
    
    <!--- 
	-- PROPSITO 
	-- Busca as Ordens de Servio de Falha operacional do perodo para o centro de custo
	-- NOTAS EXPLICATIVAS
	-- WAGNER 27/08/2012
	--->
	<cffunction name="get_ordem_servico_falha_ccusto" returntype="query" access="remote">
		<cfargument name="data_inicio" required="no" default="#lsdateformat(now())#">
        <cfargument name="data_fim" required="no" default="#lsdateformat(now())#">
        <cfargument name="cod_centro_custo" required="no" default="">
		<cfquery result="QUERY" name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select os.num_ordem_servico
                 , (select e.placa
                      from almoxarifado.v$equipamento e
                     where e.EQUIPAMENTO_ID = os.equipamento_id) as equipamento
                 , to_char(os.data_abertura, 'dd/mm/yyyy  hh24:mi') as data_abertura
                 , to_char(os.data_fechamento, 'dd/mm/yyyy  hh24:mi') as data_fechamento
                 , kss.to_tempo(NumToDSInterval((os.data_fechamento - os.data_abertura) * 24 * 60, 'MINUTE'), 3).retorno as horasf
                 , kss.to_tempo(NumToDSInterval((os.data_fechamento - os.data_abertura) * 24 * 60 * nvl((select percentual/100
                                                                                                           from manutencao.v$ccusto_perc_trabalho_atual pt
                                                                                                          where pt.cod_centro_custo = #arguments.cod_centro_custo#),1) , 'MINUTE'), 3).retorno as horasf_proc
                 , kss.to_tempo(NumToDSInterval(sum( (os.data_fechamento - os.data_abertura) ) over() * 24 * 60, 'MINUTE'), 3).retorno as total_horasf
                 , kss.to_tempo(NumToDSInterval(sum((os.data_fechamento -
                                        os.data_abertura)) over() * 24 * 60 *
                                        nvl((select percentual / 100
                                              from manutencao.v$ccusto_perc_trabalho_atual pt
                                             where pt.cod_centro_custo = #arguments.cod_centro_custo#),
                                            1),
                                    'MINUTE'),
                    3) .retorno as total_horasf_proc
                 , round((os.data_fechamento - os.data_abertura) * 24,2) as horas
                 , round(sum( (os.data_fechamento - os.data_abertura) * 24 ) over(),2) as total_horas
              from manutencao.v$ordem_servico os,
                   (select to_date('#arguments.data_inicio#', 'dd/mm/yyyy') as data_inicio,
                           to_date('#arguments.data_fim#', 'dd/mm/yyyy') + 1 as data_fim
                      from dual) d
             where os.equipamento_id in ( select e.EQUIPAMENTO_ID
                                            from oper.v$veiculo_ccusto vcc
                                           inner join almoxarifado.v$equipamento e
                                              on e.PLACA = vcc.placa
                                           inner join oper.v$veiculo_controle v 
                                              on v.placa = vcc.placa
                                             and v.situacao_id = 1
                                          where vcc.cod_centro_custo = #arguments.cod_centro_custo# 
                                           and vcc.veiculo_ccusto_id =
                                               (select max(vcc2.veiculo_ccusto_id) keep(dense_rank last order by vcc2.data)
                                                  from oper.v$veiculo_ccusto vcc2
                                                 where vcc2.placa = vcc.placa
                                                   and vcc2.data < d.data_fim) )
               and ((os.data_abertura between d.data_inicio and d.data_fim)
                     or
                    (os.data_fechamento between d.data_inicio and d.data_fim))
               and os.tipo_manutencao_id = 3
               and os.data_fechamento is not null
        </cfquery>		
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca os percentiais de trabalho por centro de custo
	-- NOTAS EXPLICATIVAS
	-- WAGNER 11/12/2012
	--->
	<cffunction name="get_perc_trabalho" returntype="query" access="remote">
		<cfargument name="cod_centro_custo" required="no" default="">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_fim" required="no" default="">
        <cfargument name="cod_pessoa" required="no" default="">
        <cfargument name="controle_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ct.controle_id,
                   ct.cod_centro_custo,
                   ct.percentual,
                   to_char(ct.data_vigencia,'dd/mm/yyyy') as data_vigencia,
                   cc.centro_custo,
                   ct.date_insert,
                   ct.user_insert,
                   ct.date_update,
                   ct.user_update,
                   ct.site
              from manutencao.v$ccusto_perc_trabalho ct
             inner join kss.v$centro_custo cc 
                on cc.cod_centro_custo = ct.cod_centro_custo
             where 1=1
           <cfif len(trim(arguments.cod_centro_custo)) >
           	   and ct.cod_centro_custo = '#arguments.cod_centro_custo#'
           </cfif>
           <cfif len(trim(arguments.cod_pessoa)) >
           	   and ct.cod_centro_custo in (select o.cod_centro_custo
               							  from kss.v$organograma o
                                         inner join kss.v$centro_custo cc
                                            on o.cod_centro_custo = cc.cod_centro_custo
                                         where o.cod_pessoa = '#arguments.cod_pessoa#')
           </cfif>
           <cfif len(trim(arguments.data_inicio)) >
           	   and ct.data_vigencia >= '#arguments.data_inicio#'
           </cfif>
           <cfif len(trim(arguments.data_fim)) >
	           and ct.data_vigencia <= '#arguments.data_fim#'
           </cfif>
           <cfif len(trim(arguments.controle_id)) >
           	   and controle_id = '#arguments.controle_id#'
           </cfif>
            order by cc.centro_custo,ct.data_vigencia desc
   		</cfquery>		
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca recursos que podem executar o processo
	-- NOTAS EXPLICATIVAS
	-- GUTO 17/10/2007
	--->
	<cffunction name="get_recursos_processo_simples" returntype="query" access="remote">
		<cfargument name="processo_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
              select distinct r.cod_pessoa,
                pf.cliente as nome_funcionario,
                oper.pkg_global.fnc_get_cod_funcionario(r.cod_pessoa) as cod_funcionario
                from manutencao.v$recurso r
               inner join manutencao.v$recurso_especialidade re
                   on re.especialidade_id = r.especialidade_id
               inner join manutencao.v$recurso_nivel rn
                   on rn.nivel_id = r.nivel_id 
               inner join kss.v$pessoa pf
                   on pf.cod_pessoa = r.cod_pessoa
               inner join manutencao.v$processo_recurso pr
                       on pr.especialidade_id = re.especialidade_id
                      and pr.nivel_id >= rn.nivel_id
                      and pr.processo_id in (#arguments.processo_id#)
                 where 1=1
                           and re.especialidade_id in (select especialidade_id
                                                         from manutencao.v$processo_recurso p 
                                                        where 1=1
                                                          and p.processo_id in (#arguments.processo_id#))
                  order by nome_funcionario
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
    
</cfcomponent>