<cfcomponent displayname="Componentes de consulta para controle de trfego" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- NOTAS EXPLICATIVAS
	--  Busca Coleta
	-- WAGNER 20/10/2006 - criado
	--->	
	<cffunction name="get_coletas" displayname="Busca Coletas" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="no" default="">
		<cfargument name="num_pedido" required="no" default="">
		<cfargument name="num_coleta" required="no" default="">
		<cfargument name="coleta_id" required="no" default="">
		<cfargument name="sem_agendamento" required="no" default="">		
		<cfargument name="sem_confirmacao" required="no" default="">
		<cfargument name="situacao_id" required="no" default="">
		<cfargument name="rem_cod_pessoa" required="no" default="">
		<cfargument name="dest_cod_pessoa" required="no" default="">
		<cfargument name="coleta_municipio_id" required="no" default="">
		<cfargument name="entrega_municipio_id" required="no" default="">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfargument name="ordem_compra" required="no" default="">
		<cfargument name="nota_fiscal" required="no" default="">
		
		<cfquery datasource="#session.dsn#" name="qr_aplicacoes" username="#session.usuario#" password="#session.senha#">
                 select distinct cl.coleta_id
				      , cl.num_coleta
					  , cl.serie
					  , cl.subserie
					  , cl.cod_filial
					  , cl.cod_responsavel
					  , to_char(cl.data_confirmacao,'dd/mm/yyyy hh24:mi') as data_confirmacao
					  , cl.cod_empresa
					  , cl.cod_solicitante
					  , cl.num_pedido
					  , fl.cliente filial
					  , to_char(cl.data_pedido,'dd/mm/yyyy hh24:mi') as data_pedido
					  , to_char(cl.prazo_retirada,'dd/mm/yyyy hh24:mi') as prazo_retirada
					  , cl.rem_cod_pessoa
					  , cl.rem_logradouro
					  , cl.rem_complemento
					  , cl.rem_bairro
					  , cl.rem_cep
					  , cl.rem_municipio_id
					  , cl.dest_cod_pessoa
					  , cl.dest_logradouro
					  , cl.dest_complemento
					  , cl.dest_bairro
					  , cl.dest_cep
					  , cl.dest_municipio_id
   
					  , cl.coleta_cod_pessoa
                      , kss.pkg_string.fnc_num_clean(kss.pkg_pessoa.fnc_get_identificador(cl.coleta_cod_pessoa)) as coleta_cnpj
                      , kss.pkg_pessoa.fnc_get_cliente(cl.coleta_cod_pessoa) as coleta_razao_social
                      , cl.coleta_logradouro
                      , cl.coleta_complemento
                      , cl.coleta_bairro
                      , cl.coleta_cep
                      , cl.coleta_municipio_id
                   
                      , cl.entrega_cod_pessoa
                      , kss.pkg_string.fnc_num_clean(kss.pkg_pessoa.fnc_get_identificador(cl.entrega_cod_pessoa)) as entrega_cnpj
                      , kss.pkg_pessoa.fnc_get_cliente(cl.entrega_cod_pessoa) as entrega_razao_social
                      , cl.entrega_logradouro
                      , cl.entrega_complemento
                      , cl.entrega_bairro
                      , cl.entrega_cep
                      , cl.entrega_municipio_id
  
					  , cl.observacao
					  , ps.cnpj_cpf as rem_cnpj_cpf
					  , ps.razao_social as rem_razao_social
					  , ps1.cnpj_cpf as dest_cnpj_cpf
				  	  , ps1.razao_social as dest_razao_social
					  , mun1.municipio as rem_municipio
					  , mun1.uf_id as rem_uf
					  , mun2.municipio as dest_municipio
					  , mun2.uf_id as dest_uf
					  , mun3.municipio as coleta_municipio
					  , mun3.uf_id as coleta_uf
					  , mun4.municipio as entrega_municipio
					  , mun4.uf_id as entrega_uf
					  , case 
					       when cl.situacao_id = 2 then 0 else 1 end as cancelamento
					  , cv.placa
					  , cl.situacao_id
					  , st.rv_abbreviation situacao
                      , (select kss.fnc_concat_all(distinct kss.to_concat_expr(cnf.ordem_compra_cliente, ';'))
                           from oper.v$carga_ctrc cc
                          inner join fiscal.v$conhecimento_nota_fiscal cnf
                             on cnf.conhecimento_id = cc.conhecimento_id
                          where cc.carga_id = cl.carga_id) as ordem_compra_cliente
				   from oper.v$coleta cl
				  inner join kss.v$pessoa fl
				          on fl.cod_pessoa = cl.cod_filial
				  inner join kss.v$pessoa ps 
				          on ps.cod_pessoa = cl.rem_cod_pessoa
				  inner join cep.municipio mun1
				          on mun1.municipio_id = cl.rem_municipio_id
				  inner join kss.v$pessoa ps1 
				          on ps1.cod_pessoa = cl.dest_cod_pessoa
				  inner join cep.municipio mun2
				          on mun2.municipio_id = cl.dest_municipio_id
				  inner join cep.municipio mun3
				          on mun3.municipio_id = cl.coleta_municipio_id
				  inner join cep.municipio mun4
				          on mun4.municipio_id = cl.entrega_municipio_id
				  inner join oper.cg_ref_codes st
				          on st.rv_low_value = cl.situacao_id
						 and st.rv_domain = 'SITUACAO COLETA'
				   left join oper.v$coleta_veiculo cv
				          on cv.coleta_id = cl.coleta_id
						 and cv.data_cancelamento is null
				  where 1=1
				<cfif len(trim(arguments.cod_pessoa))>
					     and cl.cod_filial in (#arguments.cod_pessoa#)
			    </cfif>
				<cfif len(trim(arguments.situacao_id))>
						 and cl.situacao_id in (#arguments.situacao_id#)
				</cfif>
						 and cl.situacao_id <> 1
				<cfif Len(Trim(arguments.num_pedido))>
				   and cl.num_pedido = #arguments.num_pedido#
 				</cfif>
				<cfif Len(Trim(arguments.sem_agendamento))>
				   and cl.situacao_id = 0
 				</cfif>
				<cfif Len(Trim(arguments.sem_confirmacao))>
				   and cl.situacao_id in (0,2,3,6)
 				</cfif>
				<cfif Len(Trim(arguments.coleta_id))>
				   and cl.coleta_id = #arguments.coleta_id#
 				</cfif>
				<cfif Len(Trim(arguments.num_coleta))>
				   and cl.num_coleta = #arguments.num_coleta#
 				</cfif> 
				<cfif Len(Trim(arguments.rem_cod_pessoa))>
				   and cl.rem_cod_pessoa = #arguments.rem_cod_pessoa#
 				</cfif> 
				<cfif Len(Trim(arguments.dest_cod_pessoa))>
				   and cl.dest_cod_pessoa = #arguments.dest_cod_pessoa#
 				</cfif> 
				<cfif Len(Trim(arguments.coleta_municipio_id))>
				   and cl.coleta_municipio_id = #arguments.coleta_municipio_id#
 				</cfif> 
				<cfif Len(Trim(arguments.entrega_municipio_id))>
				   and cl.entrega_municipio_id = #arguments.entrega_municipio_id#
 				</cfif> 
				<cfif Len(Trim(arguments.data_inicial))>
				   and trunc(cl.data_pedido) >= '#arguments.data_inicial#'
 				</cfif>
				<cfif Len(Trim(arguments.data_final))>
				   and trunc(cl.data_pedido) <= '#arguments.data_final#'
 				</cfif>
			 <cfif len(trim(arguments.ordem_compra))>
			   and exists (select 0
			                 from oper.v$coleta_item cnf
							where cnf.ordem_compra in (#arguments.ordem_compra#)
							  and cnf.coleta_id = cl.coleta_id)
			 </cfif>
			 <cfif len(trim(arguments.nota_fiscal))>
			   and exists (select 'x'
			                 from oper.v$coleta_item cn
							where cn.coleta_id = cl.coleta_id
							  and cn.nf_numero in (#ListQualify(arguments.nota_fiscal,"'",',')#))
			 </cfif>
			 
		</cfquery>	
		<cfreturn qr_aplicacoes>
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- NOTAS EXPLICATIVAS
	--  Busca itens da Coleta
	-- WAGNER 20/10/2006 - criado
	--->	
	<cffunction name="get_coleta_item" displayname="Busca items da Coleta" access="remote" returntype="query" output="true">
		<cfargument name="coleta_id" required="yes" >		
		<cfquery datasource="#session.dsn#" name="qr_aplicacoes" username="#session.usuario#" password="#session.senha#">
			   select ci.coleta_item_id
                    , ci.coleta_id
                    , ci.num_natureza
                    , ci.complemento
                    , ci.nf_numero
                    , ci.nf_modelo
                    , ci.nf_serie
                    , ci.nf_sub_serie
                    , ci.nf_data_emissao
                    , ci.nf_valor
                    , ci.peso_kg
                    , ci.peso_cubado_kg
                    , ci.peso_cobrado_kg
                    , ci.qtde_volume
                    , ci.altura
                    , ci.comprimento
                    , ci.largura
                    , ci.m3
                    , nvl(ci.cubagem, 0) as cubagem
                    , n.descricao as natureza_descricao
                    , e.descricao as especie_descricao
                    , to_char(ci.nf_data_emissao, 'dd/mm/yyyy') nf_data_emissao_data
                    , ci.num_especie
                    , ci.cod_unidade
                    , ci.ordem_compra
                    , ci.valor_segurado
                    , ci.cfop
                    , ci.chave_acesso_nfe
                    , ci.tipo_documento_id
                    , ci.descricao_docto
                    , kss.pkg_string.fnc_formata_cnpj_cpf(nvl(extractvalue(xmltype.createxml(ci.nfe_xml),'//NFe/infNFe/emit/CNPJ','xmlns="http://www.portalfiscal.inf.br/nfe"')
                                                             ,extractvalue(xmltype.createxml(ci.nfe_xml),'//NFe/infNFe/emit/CPF','xmlns="http://www.portalfiscal.inf.br/nfe"'))) as cnpj_emitente
                    , extractvalue(xmltype.createxml(ci.nfe_xml),'//NFe/infNFe/emit/xNome','xmlns="http://www.portalfiscal.inf.br/nfe"') as emitente
                    , kss.pkg_string.fnc_formata_cnpj_cpf(nvl(extractvalue(xmltype.createxml(ci.nfe_xml),'//NFe/infNFe/dest/CNPJ','xmlns="http://www.portalfiscal.inf.br/nfe"')
                                                             ,extractvalue(xmltype.createxml(ci.nfe_xml),'//NFe/infNFe/dest/CPF','xmlns="http://www.portalfiscal.inf.br/nfe"'))) as cnpj_destinatario
                    , extractvalue(xmltype.createxml(ci.nfe_xml),'//NFe/infNFe/dest/xNome','xmlns="http://www.portalfiscal.inf.br/nfe"') as destinatario   
                 from oper.v$coleta_item ci
                inner join oper.v$natureza n
                   on n.num_natureza = ci.num_natureza
                inner join oper.v$especie e
                   on e.num_especie = ci.num_especie
  				where ci.coleta_id = #arguments.coleta_id#
 		</cfquery>	
		<cfreturn qr_aplicacoes>
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- NOTAS EXPLICATIVAS
	--  Busca itens da Coleta
	-- WAGNER 20/10/2006 - criado
	--->
	
	<cffunction name="get_ordem_coleta_print" displayname="Busca dados da Coleta para Impresso" access="remote" returntype="query" output="true">
		<cfargument name="coleta_id" required="yes">
			<cfquery datasource="#session.dsn#" name="qr_aplicacoes" username="#session.usuario#" password="#session.senha#">
                  select distinct 
                        /*Cabealho*/
                        cl.NUM_COLETA,
                        decode(tel.telefone_numero,'','','('||tel.telefone_ddd||') '||tel.telefone_prefixo||'-'||tel.telefone_numero) as telefone_rem,
                        perem.logradouro||', '||perem.numero as endereco_rem,
                        perem.complemento as complemento_rem,
		                perem.bairro as bairro_rem,
                        perem.complemento as complemento_rem,
		                perem.bairro as bairro_rem,
                        perem.municipio as municipio_rem,
                        perem.uf as uf_rem,
                        perem.cep as cep_rem,
                        kss.pkg_global.FNC_BUSCA_NOME_PESSOA(perem.cod_pessoa) as razao_social_rem,
						 kss.pkg_global.FNC_BUSCA_NOME_PESSOA(cl.COD_FILIAL) as razao_social
					   	,pep.logradouro||', '||pep.numero as endereco
					   	,pep.bairro ||' - '||pep.cep as bairro
					   	,pep.complemento as complemento
					   	,pep.municipio ||' - '|| pep.uf as municipio
						,pe.razao_social as remetente,pe.cnpj_cpf as cnpj
						,pe.inscricao_estadual as inscricao_estadual					   	
                        ,mu.municipio as municipio
					   	,mu.uf_id as uf, cl.coleta_logradouro||' - '||cl.coleta_bairro||
						decode(cl.coleta_complemento,'','',' - '||cl.coleta_complemento)||
						decode(cl.coleta_cep,'','',' - cep:'||cl.coleta_cep) ||
						decode(cl.local_carga,'','',' - '||cl.local_carga) as local_carregamento
						,kss.pkg_global.FNC_BUSCA_NOME_PESSOA(cl.DEST_COD_PESSOA) ||decode(( select t.municipio
      																						  from cep.municipio t
      																						 where t.municipio_id = cl.DEST_MUNICIPIO_ID),'','',' / '|| 
      																					  ( select t.municipio
      																						  from cep.municipio t
      																					     where t.municipio_id = cl.DEST_MUNICIPIO_ID)) as transportar_para
						,kss.pkg_global.FNC_BUSCA_NOME_PESSOA(cv.COD_MOTORISTA) as motorista
					   	,decode(cv.placa,'','',kss.pkg_global.FNC_BUSCA_NOME_PESSOA(oper.pkg_veiculo.FNC_PESSOA_PROPRIETARIO(cv.placa,cv.DATA_AGENDAMENTO))) as proprietario
					   	,vm.MARCA as marca
						,oper.pkg_veiculo.FNC_GET_COMPOSICAO(cv.placa) as placas
					   	,cl.observacao
				  from oper.v$coleta cl
				  inner join oper.v$coleta_item ci 
						  on ci.coleta_id = cl.coleta_id
				  inner join kss.v$pessoa pe
						  on pe.cod_pessoa = cl.rem_cod_pessoa
				  inner join cep.municipio mu
						  on mu.municipio_id = cl.dest_municipio_id
				  inner join kss.v$pessoa_endereco_padrao pep
              			  on pep.cod_pessoa=cl.cod_filial
				   left join oper.v$coleta_veiculo cv
		 			  	  on cv.coleta_id = cl.coleta_id
		 				 and cv.situacao_id = 2
				   left join oper.v$veiculo_dados vd
						  on vd.placa = cv.placa 
				   left join oper.v$veiculo_marca vm
						  on vm.MARCA_ID = vd.marca_id
                    inner join kss.v$pessoa_endereco_padrao perem
                      on perem.cod_pessoa=pe.cod_pessoa
                    
                    
                    left join kss.v$pessoa_telefone trem 
                      on trem.cod_pessoa = cl.rem_cod_pessoa
                      and trem.TELEFONE_PADRAO = 1
                      
          		  left join kss.v$telefone tel
                      on tel.telefone_id = trem.telefone_id     
                      
                      
					   where cl.COLETA_ID = #arguments.coleta_id#
		 	</cfquery>	
		<cfreturn qr_aplicacoes>
	</cffunction>
	
	
	<!--- 
	-- PROPSITO
	-- NOTAS EXPLICATIVAS
	--  Busca Conhecimento
	-- WAGNER 20/10/2006 - criado
	--->
	
	<cffunction name="get_conhecimento" displayname="Busca Conhecimento" access="remote" returntype="query" output="true">
		<cfargument name="num_conhecimento" required="no" default="">
		<cfargument name="conhecimento_id" required="no" default="">
		<cfargument name="cod_pessoa" required="no" default="">
			<cfquery datasource="#session.dsn#" name="qr_aplicacoes" username="#session.usuario#" password="#session.senha#">
				select distinct /*+FIRST_ROWS*/
							c.conhecimento_id, c.num_conhecimento, c.serie,
						   trunc(c.data_emissao) data_emissao, c.aliquota_icms, c.valor_icms,
						   c.base_calculo_icms, c.total_conhecimento,
						   c.rem_razao_social remetente,
						   c.dest_razao_social destinatario,
						   c.situacao_id, un.cod_unidade_negocio,c.cod_pessoa_filial,
						   ct.CARGA_ID,
						   c.observacao,
						   ca.rem_cod_pessoa,
              			   ca.dest_cod_pessoa
			   			from fiscal.v$conhecimento c
						-- CTRC
				  inner join oper.V$carga_ctrc ct
						  on ct.NUM_CONHECIMENTO = c.num_conhecimento
				  inner join oper.v$carga ca
						  on ca.CARGA_ID = cT.CARGA_ID
				  inner join oper.v$carga_nf cn
						  on cn.carga_id = ca.CARGA_ID
			      inner join kss.v$unidade_negocio un
						  on un.cod_pessoa = c.cod_pessoa_filial
				 	 where 1=1
				<cfif Len(Trim(arguments.num_conhecimento))>
					 and c.num_conhecimento = #arguments.num_conhecimento#
				</cfif>
				<cfif Len(Trim(arguments.cod_pessoa))>
					 and c.cod_pessoa_filial = #arguments.cod_pessoa#
				</cfif>
				<cfif Len(Trim(arguments.conhecimento_id))>
					 and c.conhecimento_id = #arguments.conhecimento_id#
				</cfif>
				order by trunc(c.data_emissao)
		 	</cfquery>	
		<cfreturn qr_aplicacoes>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- NOTAS EXPLICATIVAS
	--  Busca itens do Conhecimento
	-- WAGNER 20/10/2006 - criado
	--->	
	<cffunction name="get_conhecimento_item" displayname="Busca items do conhecimento" access="remote" returntype="query" output="true">
		<cfargument name="conhecimento_id" required="yes" >		
		<cfquery datasource="#session.dsn#" name="qr_aplicacoes" username="#session.usuario#" password="#session.senha#">
				 select cn.carga_nf_id,cn.carga_id,cn.num_natureza,cn.nf_numero
                   		,cn.nf_serie,cn.nf_data_emissao,cn.nf_valor,cn.peso_kg
                   		,cn.peso_cubado_kg,cn.peso_cobrado_kg,cn.qtde_volume
                   		,cn.altura,cn.comprimento,cn.largura,cn.m3,cn.cubagem
  					from oper.v$carga_nf cn
  			  inner join oper.v$carga_ctrc cc on cc.CARGA_ID = cn.carga_id
  					 and cc.num_conhecimento = #arguments.conhecimento_id#
		</cfquery>	
		<cfreturn qr_aplicacoes>
	</cffunction>
	
    
	<!--- 
	-- PROPSITO 
	-- Busca as cargas
	-- CRISTOFER  26/10/2006
	--->		
	<cffunction name="get_carga" access="remote" returntype="query" output="true">
		<cfargument name="carga_id" required="no" default="">
		<cfargument name="sem_conhecimento" required="no" default="0">
		<cfargument name="cod_filial_atual" required="no" default="">
		<cfargument name="destino" required="no" default="">
		<cfargument name="situacao_id" required="no" default="">
		<cfargument name="blank" required="no" default="">
		<cfargument name="not_situacao_id" required="no" default="4">

		<cfargument name="rem_cod_pessoa" required="no" default="">
		<cfargument name="rem_municipio_id" required="no" default="">
		<cfargument name="dest_cod_pessoa" required="no" default="">
		<cfargument name="dest_municipio_id" required="no" default="">

		<cfargument name="cod_pedido" required="no" default="">
		<cfargument name="ordem_compra" required="no" default="">
		<cfargument name="num_coleta" required="no" default="">
		<cfargument name="num_conhecimento" required="no" default="">
		<cfargument name="nota_fiscal" required="no" default="">
		<cfargument name="grupo_logistico" required="no" default="0">

		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfargument name="cod_filial_conhecimento" required="no" default="">
        <cfargument name="conhecimento_cancelado" required="no" default="">

		<cfargument name="tempos" required="no" default="0">
        
        <cfargument name="com_referencia_geografica" required="no" default="1">
        <cfargument name="conhecimento_apartir_de" required="no" default="">
        <cfargument name="carga_apartir_de" required="no" default="">

		<!--- Feito para otimizar a busca por numero do conhecimento --->
		<cfif len(trim(arguments.num_conhecimento))>
			<cfquery name="qrConhecimentos" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select cc.carga_id
				  from fiscal.v$conhecimento c
				 inner join oper.v$carga_ctrc cc
						 on cc.conhecimento_id = c.conhecimento_id
				 where c.num_conhecimento in (#arguments.num_conhecimento#)
			</cfquery>
		</cfif>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
             <cfif com_referencia_geografica eq 1>
			select d.*,
                   p.latitude,
                   p.longitude,
                   p.landmark
              from (
            
            select /*+ push_subq */ 
            	   c.*, (select max(data)
                           from rastreador.v$posicao p
                          where p.placa = c.placa_posicao
                            and p.data <= c.data_posicao) as data_ult_posicao
              from (
            </cfif>
            select c.carga_id,
				   c.rem_cod_pessoa,
				   rem.cliente as remetente,
				   rem.razao_social as rem_razao_social,
				   rem.cnpj_cpf rem_cnpj_cpf,
				   rem.inscricao_estadual rem_inscricao_estadual,
				   rmun.municipio as rem_municipio,
				   rmun.uf_id as rem_uf,
				   c.dest_cod_pessoa,
				   dest.cliente as destinatario,
				   dest.razao_social as dest_razao_social,
				   dest.cnpj_cpf dest_cnpj_cpf,
				   dest.inscricao_estadual dest_inscricao_estadual,
				   dmun.municipio as dest_municipio,
				   dmun.uf_id as dest_uf,
				   c.user_insert,
				   c.date_insert,
                   to_char(c.date_insert,'dd/mm/yyyy') as date_insert_format,
				   c.user_update,
				   c.date_update,
				   c.site,
				   c.cod_empresa,
				   c.num_pedido,
				   c.rem_logradouro,
				   c.rem_complemento,
				   c.rem_bairro,
				   c.rem_cep,
				   c.rem_municipio_id,
				   c.dest_logradouro,
				   c.dest_complemento,
				   c.dest_bairro,
				   c.dest_cep,
				   c.dest_municipio_id,
				   c.coleta_cod_pessoa,
                   kss.pkg_string.fnc_num_clean(kss.pkg_pessoa.fnc_get_identificador(c.coleta_cod_pessoa)) as coleta_cnpj,
                   kss.pkg_pessoa.fnc_get_cliente(c.coleta_cod_pessoa) as coleta_razao_social,
                   c.coleta_logradouro,
				   c.coleta_complemento,
				   c.coleta_bairro,
				   c.coleta_cep,
				   c.coleta_municipio_id,
				   c.devolucao,
                   case 
                     when c.devolucao = 1 then 'Sim'
                     else 'No'
                   end devolucao_texto,
				   cmun.municipio coleta_municipio,
				   cmun.uf_id coleta_uf,
                   cmun.municipio || '-' || cmun.uf_id as coleta_municipio_uf,
                   (select kss.fnc_concat_all(kss.to_concat_expr( m.num_manifesto, ' / '))
                      from oper.v$manifesto m
                     inner join oper.v$manifesto_conhecimento mc
                        on mc.MANIFESTO_ID = m.manifesto_id
                     where mc.CONHECIMENTO_ID = con.conhecimento_id ) as num_manifesto,
                   (select to_char(e.data_entrega,'dd/mm/yyyy hh24:mi')
                      from oper.v$entrega e
                     where e.carga_id = c.carga_id) as data_entrega,
				   (select to_char(max(cn.NF_DATA_EMISSAO),'dd/mm/yyyy')
                      from oper.v$carga_nf cn
                     where cn.carga_id = c.carga_id) max_data_nf,
				<cfif arguments.tempos eq 1>
                   (select to_char(min(data),'dd/mm/yyyy hh24:mi:ss') data
                      from oper.v$evento_operacao eo2
                     inner join oper.v$romaneio_evento re2
                             on re2.controle_evo_id = eo2.controle_evo_id
                     where eo2.num_evento = 2
                       and roo.num_romaneio = re2.num_romaneio) inicio_carga,
                   (select to_char(max(data),'dd/mm/yyyy hh24:mi:ss') data
                      from oper.v$evento_operacao eo3
                     inner join oper.v$romaneio_evento re3
                             on re3.controle_evo_id = eo3.controle_evo_id
                     where eo3.num_evento = 3
                       and roo.num_romaneio = re3.num_romaneio) termino_carga,
                   to_char(numtodsinterval((select max(data)
                      from oper.v$evento_operacao eo3
                     inner join oper.v$romaneio_evento re3
                             on re3.controle_evo_id = eo3.controle_evo_id
                     where eo3.num_evento = 3
                       and roo.num_romaneio = re3.num_romaneio) -
                   (select min(data)
                      from oper.v$evento_operacao eo2
                     inner join oper.v$romaneio_evento re2
                             on re2.controle_evo_id = eo2.controle_evo_id
                     where eo2.num_evento = 2
                       and roo.num_romaneio = re2.num_romaneio),'DAY')) tempo_carga,
                       
                   to_char(numtodsinterval(nvl(case 
                      when (select nvl(max(m.entrega_direta),0)
                              from oper.v$manifesto_conhecimento mc
                             inner join oper.v$manifesto m on m.manifesto_id = mc.manifesto_id
                             where mc.conhecimento_id = con.conhecimento_id) = 1 then 0
                      else (select max(m.data_termino)
                              from oper.v$manifesto_conhecimento mc
                             inner join oper.v$manifesto m on m.manifesto_id = mc.manifesto_id
                             where mc.conhecimento_id = con.conhecimento_id) -
                           nvl((select max(data_entrega)
                              from oper.v$entrega e
                             where e.carga_id = c.carga_id),nvl(c.inicio_descarga,c.data_entrega))
                   end,0),'day')) tempo_cd,

                   to_char(nvl(c.inicio_descarga,c.data_entrega),'dd/mm/yyyy hh24:mi:ss') inicio_descarga,
                   to_char(c.data_entrega,'dd/mm/yyyy hh24:mi:ss') termino_descarga, 
                   to_char(numtodsinterval(c.data_entrega-nvl(c.inicio_descarga,c.data_entrega),'day')) tempo_descarga,

                </cfif>
				   c.entrega_cod_pessoa,
                   kss.pkg_string.fnc_num_clean(kss.pkg_pessoa.fnc_get_identificador(c.entrega_cod_pessoa)) as entrega_cnpj,
                   kss.pkg_pessoa.fnc_get_cliente(c.entrega_cod_pessoa) as entrega_razao_social,
                   c.entrega_logradouro,
				   c.entrega_complemento,
				   c.entrega_bairro,
				   c.entrega_cep,
				   c.entrega_municipio_id,
				   emun.municipio entrega_municipio,
				   emun.uf_id entrega_uf,
                   emun.municipio || '-' || emun.uf_id as entrega_municipio_uf,
				   decode(cdd.descricao,'',cep.fnc_municipio_uf(desmun.municipio_id),'CD: '||cdd.descricao) destino,
				   c.observacao,
				   c.situacao_id,
				   st.rv_abbreviation as status,
				   con.num_conhecimento,
				   decode(cd.descricao,'',cep.fnc_municipio_uf(c.municipio_id),'CD: '||cd.descricao) ultima_posicao,
				   cl.num_coleta,
				   cl.serie coleta_serie,
				   cl.subserie coleta_subserie,
				   (select kss.fnc_concat_all(kss.to_concat_expr(cn.nf_numero,' / '))
				      from oper.v$carga_nf cn
					 where cn.carga_id = c.carga_id) notas_fiscais,
                   (select kss.fnc_concat_all(kss.to_concat_expr(cn.ordem_compra, ' / '))
   					  from oper.v$carga_nf cn
 					 where cn.carga_id = c.carga_id) as ordem_compra,
					con.data_emissao,
                   to_char(con.data_emissao,'dd/mm/yyyy') as data_emissao_format,
                   con.peso,
             <cfif com_referencia_geografica eq 1>
                   (select max(placa_controle) keep(dense_rank last order by nvl(rh.data_termino,sysdate))
                      from oper.v$romaneio_hist_veiculo rh
                     where rh.num_romaneio = roo.num_romaneio
                       and rh.data_inicio <= least(sysdate,nvl(roo.data_termino,sysdate))) placa_posicao,
                   least(sysdate,nvl(roo.data_termino,sysdate)) data_posicao,
              </cfif>
                   con.placa_tracao
                  ,(select et.cod_endereco
                      from kss.v$pessoa_endereco_todos et
                     where et.cod_pessoa = c.rem_cod_pessoa
                       and et.endereco_padrao = 1 ) cod_endereco_rem    
                  ,(select et.cod_endereco
                      from kss.v$pessoa_endereco_todos et
                     where et.cod_pessoa = c.dest_cod_pessoa
                       and et.endereco_padrao = 1 ) cod_endereco_dest   
                  ,(select et.cod_endereco
                      from kss.v$pessoa_endereco_todos et
                     where et.cod_pessoa = c.coleta_cod_pessoa
                       and et.endereco_padrao = 1 ) cod_endereco_coleta    
                  ,(select et.cod_endereco
                      from kss.v$pessoa_endereco_todos et
                     where et.cod_pessoa = c.entrega_cod_pessoa
                       and et.endereco_padrao = 1 ) cod_endereco_entrega                                                                                      
			  from oper.v$carga c
			 inner join kss.v$pessoa rem
					 on rem.cod_pessoa = c.rem_cod_pessoa
		     left join cep.municipio rmun
					 on rmun.municipio_id = c.rem_municipio_id
			 inner join kss.v$pessoa dest
					 on dest.cod_pessoa = c.dest_cod_pessoa
		     left join cep.municipio dmun
					 on dmun.municipio_id = c.dest_municipio_id
		     inner join cep.municipio cmun
					 on cmun.municipio_id = c.coleta_municipio_id
		     inner join cep.municipio emun
					 on emun.municipio_id = c.entrega_municipio_id
			 inner join oper.cg_ref_codes st
			         on st.rv_low_value = c.situacao_id
					and st.rv_domain = 'SITUACAO CARGA'
			<cfif arguments.grupo_logistico eq 1>
				 inner join oper.v$grupo_logistico_usuario glu
						 on glu.usuario = '#ucase(session.usuario)#'
				  left join oper.v$grupo_logistico_carga glc
						 on glc.cod_pessoa_carga = c.rem_cod_pessoa
						and glu.grupo_id = glc.grupo_id
				  left join oper.v$grupo_logistico_descarga gld
						 on gld.cod_pessoa_descarga = c.dest_cod_pessoa
						and glu.grupo_id = gld.grupo_id
			</cfif>
			  left join oper.v$coleta cl
			         on cl.carga_id = c.carga_id
			  left join oper.v$carga_transferencia tr
			         on tr.carga_id = c.carga_id
					and tr.transferencia_id_posterior is null	
			  left join oper.v$carga_transferencia trd
			         on trd.carga_id = c.carga_id
					and trd.data_destino is null	
			  left join cep.municipio desmun
			         on desmun.municipio_id = trd.municipio_id_destino
			  left join oper.v$centro_distribuicao cdd
			         on cdd.cod_pessoa_filial = trd.cod_filial_destino
              left join oper.v$carga_ctrc cc
			         on cc.carga_id = c.carga_id
		      left join fiscal.v$conhecimento con
			         on con.conhecimento_id = cc.conhecimento_id
              left join oper.v$romaneio roo
                     on roo.num_romaneio = con.num_romaneio
		      left join oper.v$centro_distribuicao cd
			         on cd.cod_pessoa_filial = c.cod_filial_atual
			 where 1=1
			 
			<cfif arguments.grupo_logistico eq 1>
				    and ( c.rem_cod_pessoa = glc.cod_pessoa_carga or 
						 c.dest_cod_pessoa = gld.cod_pessoa_descarga)
				 <cfif len(trim(arguments.rem_cod_pessoa)) or len(trim(arguments.dest_cod_pessoa))>
					and ( 1=0
					<cfif len(trim(arguments.rem_cod_pessoa))>
					   or c.rem_cod_pessoa in (#arguments.rem_cod_pessoa#)
					</cfif>
					<cfif len(trim(arguments.dest_cod_pessoa))>
					   or c.dest_cod_pessoa in (#arguments.dest_cod_pessoa#)
					</cfif>
						)
				 </cfif>
			</cfif>

			 <cfif len(trim(arguments.data_inicial))>
			   and trunc(c.date_insert) >= '#arguments.data_inicial#'
			 </cfif>
			 <cfif len(trim(arguments.data_final))>
			   and trunc(c.date_insert) <= '#arguments.data_final#'
			 </cfif>
			 
			 <cfif len(trim(arguments.destino))>
			   and c.destino = #arguments.destino#
			 </cfif>

			 <cfif len(trim(arguments.rem_cod_pessoa))>
			   and c.rem_cod_pessoa in (#arguments.rem_cod_pessoa#)
			 </cfif>
			 <cfif len(trim(arguments.rem_municipio_id))>
			   and c.rem_municipio_id = #arguments.rem_municipio_id#
			 </cfif>
			 <cfif len(trim(arguments.dest_cod_pessoa))>
			   and c.dest_cod_pessoa in (#arguments.dest_cod_pessoa#)
			 </cfif>
			 <cfif len(trim(arguments.dest_municipio_id))>
			   and c.dest_municipio_id = #arguments.dest_municipio_id#
			 </cfif>

			 <cfif len(trim(arguments.situacao_id))>
			   and c.situacao_id in (#arguments.situacao_id#)
			 </cfif>
			 <cfif len(trim(arguments.not_situacao_id))>
			   and c.situacao_id not in (#arguments.not_situacao_id#)
			 </cfif>
			 <cfif len(trim(arguments.carga_id))>
			   and c.carga_id = #arguments.carga_id#

			 </cfif>
			 <cfif arguments.blank eq 1>
			   and 1=0
			 </cfif>
			 <cfif len(trim(arguments.sem_conhecimento)) and arguments.sem_conhecimento eq 1>
			   and not exists (select '0' 
								 from oper.v$carga_ctrc cc 
								inner join fiscal.v$conhecimento con
										on cc.conhecimento_id = con.conhecimento_id
								where cc.carga_id = c.carga_id
								  and con.situacao_id <> 1)
			 </cfif>
			 <cfif len(trim(arguments.cod_filial_atual))>
			   and c.cod_filial_atual in (#arguments.cod_filial_atual#)
			 </cfif>
             <cfif len(trim(arguments.cod_filial_conhecimento))>
               and con.cod_pessoa_filial in (#arguments.cod_filial_conhecimento#)
             </cfif>
             <cfif len(trim(arguments.conhecimento_cancelado))>
             	<cfif arguments.conhecimento_cancelado eq 0>
                  and con.situacao_id <> 1
                </cfif>
             </cfif>
			 <cfif len(trim(arguments.data_inicial))>
			   and trunc(c.date_insert) >= '#arguments.data_inicial#'
			 </cfif>
			 <cfif len(trim(arguments.data_final))>
			   and trunc(c.date_insert) <= '#arguments.data_final#'
			 </cfif>
			 <cfif len(trim(arguments.cod_pedido))>
			   and c.num_pedido in (#ListQualify(arguments.cod_pedido,"'")#)
			 </cfif>
			 <cfif len(trim(arguments.ordem_compra))>
			   and exists (select 0
			                 from oper.v$carga_nf cnf
							where cnf.ordem_compra in (#arguments.ordem_compra#)
							  and cnf.carga_id = c.carga_id)
			 </cfif>
			 <cfif len(trim(arguments.num_coleta))>
			   and cl.num_coleta in (#arguments.num_coleta#)
			 </cfif>
			 <cfif len(trim(arguments.num_conhecimento))>
			   <cfif not len(trim(ValueList(qrConhecimentos.carga_id)))>
			   and 1=0
			   <cfelse>
			   and c.carga_id in (#ValueList(qrConhecimentos.carga_id)#)
			   </cfif>
			 </cfif>
			 <cfif len(trim(arguments.nota_fiscal))>
			   and exists (select 'x'
			                 from oper.v$carga_nf cn
							where cn.carga_id = c.carga_id
							  and cn.nf_numero in (#ListQualify(arguments.nota_fiscal,"'",',')#))
			 </cfif>
             <cfif len(trim(arguments.conhecimento_apartir_de))>
               and con.data_emissao >= to_date('#arguments.conhecimento_apartir_de#', 'dd/mm/yyyy')
             </cfif>
             <cfif len(trim(arguments.carga_apartir_de))>
               and c.date_insert >= to_date('#arguments.carga_apartir_de#', 'dd/mm/yyyy')
             </cfif>
			 order by c.carga_id desc
             <cfif com_referencia_geografica eq 1>
                 ) c )d
             left join rastreador.v$posicao p
                     on p.placa = d.placa_posicao
                    and p.data = d.data_ult_posicao
             </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca as cargas
	-- CRISTOFER  26/10/2006
	--->		
	<cffunction name="get_carga_entrega" access="remote" returntype="query" output="true">
		<cfargument name="carga_id" required="no" default="">
		<cfargument name="sem_conhecimento" required="no" default="0">
		<cfargument name="cod_filial_atual" required="no" default="">
		<cfargument name="destino" required="no" default="">
		<cfargument name="situacao_id" required="no" default="">
		<cfargument name="blank" required="no" default="">
		<cfargument name="not_situacao_id" required="no" default="4">

		<cfargument name="rem_cod_pessoa" required="no" default="">
		<cfargument name="rem_municipio_id" required="no" default="">
		<cfargument name="dest_cod_pessoa" required="no" default="">
		<cfargument name="dest_municipio_id" required="no" default="">

		<cfargument name="cod_pedido" required="no" default="">
		<cfargument name="ordem_compra" required="no" default="">
		<cfargument name="num_coleta" required="no" default="">
		<cfargument name="num_conhecimento" required="no" default="">
		<cfargument name="nota_fiscal" required="no" default="">
		<cfargument name="grupo_logistico" required="no" default="0">

		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfargument name="cod_filial_conhecimento" required="no" default="">
        <cfargument name="conhecimento_cancelado" required="no" default="">

		<cfargument name="tempos" required="no" default="0">
        
        <cfargument name="com_referencia_geografica" required="no" default="1">
        <cfargument name="conhecimento_apartir_de" required="no" default="">

		<!--- Feito para otimizar a busca por numero do conhecimento --->
		<cfif len(trim(arguments.num_conhecimento))>
			<cfquery name="qrConhecimentos" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select cc.carga_id
				  from fiscal.v$conhecimento c
				 inner join oper.v$carga_ctrc cc
						 on cc.conhecimento_id = c.conhecimento_id
				 where c.num_conhecimento in (#arguments.num_conhecimento#)
			</cfquery>
		</cfif>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
             <cfif com_referencia_geografica eq 1>
			select d.*,
                   p.latitude,
                   p.longitude,
                   p.landmark
              from (
            
            select /*+ push_subq */ 
            	   c.*, (select max(data)
                           from rastreador.v$posicao p
                          where p.placa = c.placa_posicao
                            and p.data <= c.data_posicao) as data_ult_posicao
              from (
            </cfif>
            select c.carga_id,
				   c.rem_cod_pessoa,
				   rem.cliente as remetente,
				   rem.razao_social as rem_razao_social,
				   rem.cnpj_cpf rem_cnpj_cpf,
				   rem.inscricao_estadual rem_inscricao_estadual,
				   rmun.municipio as rem_municipio,
				   rmun.uf_id as rem_uf,
				   c.dest_cod_pessoa,
				   dest.cliente as destinatario,
				   dest.razao_social as dest_razao_social,
				   dest.cnpj_cpf dest_cnpj_cpf,
				   dest.inscricao_estadual dest_inscricao_estadual,
				   dmun.municipio as dest_municipio,
				   dmun.uf_id as dest_uf,
				   c.user_insert,
				   c.date_insert,
				   c.user_update,
				   c.date_update,
				   c.site,
				   c.cod_empresa,
				   c.num_pedido,
				   c.rem_logradouro,
				   c.rem_complemento,
				   c.rem_bairro,
				   c.rem_cep,
				   c.rem_municipio_id,
				   c.dest_logradouro,
				   c.dest_complemento,
				   c.dest_bairro,
				   c.dest_cep,
				   c.dest_municipio_id,

				   c.coleta_logradouro,
				   c.coleta_complemento,
				   c.coleta_bairro,
				   c.coleta_cep,
				   c.coleta_municipio_id,
				   c.devolucao,
				   cmun.municipio coleta_municipio,
				   cmun.uf_id coleta_uf,

				<cfif arguments.tempos eq 1>
                   (select to_char(min(data),'dd/mm/yyyy hh24:mi:ss') data
                      from oper.v$evento_operacao eo2
                     inner join oper.v$romaneio_evento re2
                             on re2.controle_evo_id = eo2.controle_evo_id
                     where eo2.num_evento = 2
                       and roo.num_romaneio = re2.num_romaneio) inicio_carga,
                   (select to_char(max(data),'dd/mm/yyyy hh24:mi:ss') data
                      from oper.v$evento_operacao eo3
                     inner join oper.v$romaneio_evento re3
                             on re3.controle_evo_id = eo3.controle_evo_id
                     where eo3.num_evento = 3
                       and roo.num_romaneio = re3.num_romaneio) termino_carga,
                   to_char(numtodsinterval((select max(data)
                      from oper.v$evento_operacao eo3
                     inner join oper.v$romaneio_evento re3
                             on re3.controle_evo_id = eo3.controle_evo_id
                     where eo3.num_evento = 3
                       and roo.num_romaneio = re3.num_romaneio) -
                   (select min(data)
                      from oper.v$evento_operacao eo2
                     inner join oper.v$romaneio_evento re2
                             on re2.controle_evo_id = eo2.controle_evo_id
                     where eo2.num_evento = 2
                       and roo.num_romaneio = re2.num_romaneio),'DAY')) tempo_carga,
                       
                   to_char(numtodsinterval(nvl(case 
                      when (select nvl(max(m.entrega_direta),0)
                              from oper.v$manifesto_conhecimento mc
                             inner join oper.v$manifesto m on m.manifesto_id = mc.manifesto_id
                             where mc.conhecimento_id = con.conhecimento_id) = 1 then 0
                      else (select max(m.data_termino)
                              from oper.v$manifesto_conhecimento mc
                             inner join oper.v$manifesto m on m.manifesto_id = mc.manifesto_id
                             where mc.conhecimento_id = con.conhecimento_id) -
                           nvl((select max(data_entrega)
                              from oper.v$entrega e
                             where e.carga_id = c.carga_id),nvl(c.inicio_descarga,c.data_entrega))
                   end,0),'day')) tempo_cd,

                   to_char(nvl(c.inicio_descarga,c.data_entrega),'dd/mm/yyyy hh24:mi:ss') inicio_descarga,
                   to_char(c.data_entrega,'dd/mm/yyyy hh24:mi:ss') termino_descarga, 
                   to_char(numtodsinterval(c.data_entrega-nvl(c.inicio_descarga,c.data_entrega),'day')) tempo_descarga,

                </cfif>
				   c.entrega_logradouro,
				   c.entrega_complemento,
				   c.entrega_bairro,
				   c.entrega_cep,
				   c.entrega_municipio_id,
				   emun.municipio entrega_municipio,
				   emun.uf_id entrega_uf,
				   decode(cdd.descricao,'',cep.fnc_municipio_uf(desmun.municipio_id),'CD: '||cdd.descricao) destino,
				   c.observacao,
				   c.situacao_id,
				   st.rv_abbreviation as status,
				   con.num_conhecimento,
				   decode(cd.descricao,'',cep.fnc_municipio_uf(c.municipio_id),'CD: '||cd.descricao) ultima_posicao,
				   cl.num_coleta,
				   cl.serie coleta_serie,
				   cl.subserie coleta_subserie,
				   (select kss.fnc_concat_all(kss.to_concat_expr(cn.nf_numero,' / '))
				      from oper.v$carga_nf cn
					 where cn.carga_id = c.carga_id) notas_fiscais,
                   (select kss.fnc_concat_all(kss.to_concat_expr(cn.ordem_compra, ' / '))
   					  from oper.v$carga_nf cn
 					 where cn.carga_id = c.carga_id) as ordem_compra,
					con.data_emissao,
                   con.peso,
             <cfif com_referencia_geografica eq 1>
                   (select max(placa_controle) keep(dense_rank last order by nvl(rh.data_termino,sysdate))
                      from oper.v$romaneio_hist_veiculo rh
                     where rh.num_romaneio = roo.num_romaneio
                       and rh.data_inicio <= least(sysdate,nvl(roo.data_termino,sysdate))) placa_posicao,
                   least(sysdate,nvl(roo.data_termino,sysdate)) data_posicao,
              </cfif>
                   con.placa_tracao
			  from oper.v$carga c
			 inner join kss.v$pessoa rem
					 on rem.cod_pessoa = c.rem_cod_pessoa
		     left join cep.municipio rmun
					 on rmun.municipio_id = c.rem_municipio_id
			 inner join kss.v$pessoa dest
					 on dest.cod_pessoa = c.dest_cod_pessoa
		     left join cep.municipio dmun
					 on dmun.municipio_id = c.dest_municipio_id
		     inner join cep.municipio cmun
					 on cmun.municipio_id = c.coleta_municipio_id
		     inner join cep.municipio emun
					 on emun.municipio_id = c.entrega_municipio_id
			 inner join oper.cg_ref_codes st
			         on st.rv_low_value = c.situacao_id
					and st.rv_domain = 'SITUACAO CARGA'
			<cfif arguments.grupo_logistico eq 1>
				 inner join oper.v$grupo_logistico_usuario glu
						 on glu.usuario = '#ucase(session.usuario)#'
				  left join oper.v$grupo_logistico_carga glc
						 on glc.cod_pessoa_carga = c.rem_cod_pessoa
						and glu.grupo_id = glc.grupo_id
				  left join oper.v$grupo_logistico_descarga gld
						 on gld.cod_pessoa_descarga = c.dest_cod_pessoa
						and glu.grupo_id = gld.grupo_id
			</cfif>
			  left join oper.v$coleta cl
			         on cl.carga_id = c.carga_id
			  left join oper.v$carga_transferencia tr
			         on tr.carga_id = c.carga_id
					and tr.transferencia_id_posterior is null	
			  left join oper.v$carga_transferencia trd
			         on trd.carga_id = c.carga_id
					and trd.data_destino is null	
			  left join cep.municipio desmun
			         on desmun.municipio_id = trd.municipio_id_destino
			  left join oper.v$centro_distribuicao cdd
			         on cdd.cod_pessoa_filial = trd.cod_filial_destino
              inner join oper.v$carga_ctrc cc
			         on cc.carga_id = c.carga_id
		      inner join fiscal.v$conhecimento con
			         on con.conhecimento_id = cc.conhecimento_id
              left join oper.v$romaneio roo
                     on roo.num_romaneio = con.num_romaneio
		      left join oper.v$centro_distribuicao cd
			         on cd.cod_pessoa_filial = c.cod_filial_atual
			 where 1=1
			 
			<cfif arguments.grupo_logistico eq 1>
				    and ( c.rem_cod_pessoa = glc.cod_pessoa_carga or 
						 c.dest_cod_pessoa = gld.cod_pessoa_descarga)
				 <cfif len(trim(arguments.rem_cod_pessoa)) or len(trim(arguments.dest_cod_pessoa))>
					and ( 1=0
					<cfif len(trim(arguments.rem_cod_pessoa))>
					   or c.rem_cod_pessoa in (#arguments.rem_cod_pessoa#)
					</cfif>
					<cfif len(trim(arguments.dest_cod_pessoa))>
					   or c.dest_cod_pessoa in (#arguments.dest_cod_pessoa#)
					</cfif>
						)
				 </cfif>
			</cfif>

			 <cfif len(trim(arguments.data_inicial))>
			   and trunc(c.date_insert) >= '#arguments.data_inicial#'
			 </cfif>
			 <cfif len(trim(arguments.data_final))>
			   and trunc(c.date_insert) <= '#arguments.data_final#'
			 </cfif>
			 
			 <cfif len(trim(arguments.destino))>
			   and c.destino = #arguments.destino#
			 </cfif>

			 <cfif len(trim(arguments.rem_cod_pessoa))>
			   and c.rem_cod_pessoa in (#arguments.rem_cod_pessoa#)
			 </cfif>
			 <cfif len(trim(arguments.rem_municipio_id))>
			   and c.rem_municipio_id = #arguments.rem_municipio_id#
			 </cfif>
			 <cfif len(trim(arguments.dest_cod_pessoa))>
			   and c.dest_cod_pessoa in (#arguments.dest_cod_pessoa#)
			 </cfif>
			 <cfif len(trim(arguments.dest_municipio_id))>
			   and c.dest_municipio_id = #arguments.dest_municipio_id#
			 </cfif>

			 <cfif len(trim(arguments.situacao_id))>
			   and c.situacao_id in (#arguments.situacao_id#)
			 </cfif>
			 <cfif len(trim(arguments.not_situacao_id))>
			   and c.situacao_id not in (#arguments.not_situacao_id#)
			 </cfif>
			 <cfif len(trim(arguments.carga_id))>
			   and c.carga_id = #arguments.carga_id#

			 </cfif>
			 <cfif arguments.blank eq 1>
			   and 1=0
			 </cfif>
			 <cfif len(trim(arguments.sem_conhecimento)) and arguments.sem_conhecimento eq 1>
			   and not exists (select '0' 
								 from oper.v$carga_ctrc cc 
								inner join fiscal.v$conhecimento con
										on cc.conhecimento_id = con.conhecimento_id
								where cc.carga_id = c.carga_id
								  and con.situacao_id <> 1)
			 </cfif>
			 <cfif len(trim(arguments.cod_filial_atual))>
			   and c.cod_filial_atual in (#arguments.cod_filial_atual#)
			 </cfif>
             <cfif len(trim(arguments.cod_filial_conhecimento))>
               and con.cod_pessoa_filial in (#arguments.cod_filial_conhecimento#)
             </cfif>
             <cfif len(trim(arguments.conhecimento_cancelado))>
             	<cfif arguments.conhecimento_cancelado eq 0>
                  and con.situacao_id <> 1
                </cfif>
             </cfif>
			 <cfif len(trim(arguments.data_inicial))>
			   and trunc(c.date_insert) >= '#arguments.data_inicial#'
			 </cfif>
			 <cfif len(trim(arguments.data_final))>
			   and trunc(c.date_insert) <= '#arguments.data_final#'
			 </cfif>
			 <cfif len(trim(arguments.cod_pedido))>
			   and c.num_pedido in (#ListQualify(arguments.cod_pedido,"'")#)
			 </cfif>
			 <cfif len(trim(arguments.ordem_compra))>
			   and exists (select 0
			                 from oper.v$carga_nf cnf
							where cnf.ordem_compra in (#arguments.ordem_compra#)
							  and cnf.carga_id = c.carga_id)
			 </cfif>
			 <cfif len(trim(arguments.num_coleta))>
			   and cl.num_coleta in (#arguments.num_coleta#)
			 </cfif>
			 <cfif len(trim(arguments.num_conhecimento))>
			   <cfif not len(trim(ValueList(qrConhecimentos.carga_id)))>
			   and 1=0
			   <cfelse>
			   and c.carga_id in (#ValueList(qrConhecimentos.carga_id)#)
			   </cfif>
			 </cfif>
			 <cfif len(trim(arguments.nota_fiscal))>
			   and exists (select 'x'
			                 from oper.v$carga_nf cn
							where cn.carga_id = c.carga_id
							  and cn.nf_numero in (#ListQualify(arguments.nota_fiscal,"'",',')#))
			 </cfif>
             <cfif len(trim(arguments.conhecimento_apartir_de))>
               and con.data_emissao >= to_date('#arguments.conhecimento_apartir_de#', 'dd/mm/yyyy')
             </cfif>
			 order by c.carga_id desc
             <cfif com_referencia_geografica eq 1>
                 ) c )d
             left join rastreador.v$posicao p
                     on p.placa = d.placa_posicao
                    and p.data = d.data_ult_posicao
             </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
	<!--- 
	-- PROPSITO 
	-- Busca as cargas
	-- CRISTOFER  26/10/2006
	--->		
	<cffunction name="get_carga_old" access="remote" returntype="query" output="true">
		<cfargument name="carga_id" required="no" default="">
		<cfargument name="sem_conhecimento" required="no" default="0">
		<cfargument name="cod_filial_atual" required="no" default="">
		<cfargument name="destino" required="no" default="">
		<cfargument name="situacao_id" required="no" default="">
		<cfargument name="blank" required="no" default="">
		<cfargument name="not_situacao_id" required="no" default="4">

		<cfargument name="rem_cod_pessoa" required="no" default="">
		<cfargument name="rem_municipio_id" required="no" default="">
		<cfargument name="dest_cod_pessoa" required="no" default="">
		<cfargument name="dest_municipio_id" required="no" default="">

		<cfargument name="cod_pedido" required="no" default="">
		<cfargument name="ordem_compra" required="no" default="">
		<cfargument name="num_coleta" required="no" default="">
		<cfargument name="num_conhecimento" required="no" default="">
		<cfargument name="nota_fiscal" required="no" default="">
		<cfargument name="grupo_logistico" required="no" default="0">

		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfargument name="cod_filial_conhecimento" required="no" default="">
        <cfargument name="conhecimento_cancelado" required="no" default="">

		<cfargument name="tempos" required="no" default="0">

		<!--- Feito para otimizar a busca por numero do conhecimento --->
		<cfif len(trim(arguments.num_conhecimento))>
			<cfquery name="qrConhecimentos" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select cc.carga_id
				  from fiscal.v$conhecimento c
				 inner join oper.v$carga_ctrc cc
						 on cc.conhecimento_id = c.conhecimento_id
				 where c.num_conhecimento in (#arguments.num_conhecimento#)
			</cfquery>
		</cfif>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select a.*, 
            	   p.latitude, 
                   p.longitude, 
                   p.landmark,                    
                   oper.pkg_veiculo.FNC_GET_COD_VEICULO(a.PLACA_posicao) cod_veiculo_tracao
			 from (
            select c.carga_id,
				   c.rem_cod_pessoa,
				   rem.cliente as remetente,
				   rem.razao_social as rem_razao_social,
				   rem.cnpj_cpf rem_cnpj_cpf,
				   rem.inscricao_estadual rem_inscricao_estadual,
				   rmun.municipio as rem_municipio,
				   rmun.uf_id as rem_uf,
				   c.dest_cod_pessoa,
				   dest.cliente as destinatario,
				   dest.razao_social as dest_razao_social,
				   dest.cnpj_cpf dest_cnpj_cpf,
				   dest.inscricao_estadual dest_inscricao_estadual,
				   dmun.municipio as dest_municipio,
				   dmun.uf_id as dest_uf,
				   c.user_insert,
				   c.date_insert,
				   c.user_update,
				   c.date_update,
				   c.site,
				   c.cod_empresa,
				   c.num_pedido,
				   c.rem_logradouro,
				   c.rem_complemento,
				   c.rem_bairro,
				   c.rem_cep,
				   c.rem_municipio_id,
				   c.dest_logradouro,
				   c.dest_complemento,
				   c.dest_bairro,
				   c.dest_cep,
				   c.dest_municipio_id,

				   c.coleta_logradouro,
				   c.coleta_complemento,
				   c.coleta_bairro,
				   c.coleta_cep,
				   c.coleta_municipio_id,
				   c.devolucao,
				   cmun.municipio coleta_municipio,
				   cmun.uf_id coleta_uf,

				<cfif arguments.tempos eq 1>
                   (select to_char(min(data),'dd/mm/yyyy hh24:mi:ss') data
                      from oper.v$evento_operacao eo2
                     inner join oper.v$romaneio_evento re2
                             on re2.controle_evo_id = eo2.controle_evo_id
                     where eo2.num_evento = 2
                       and roo.num_romaneio = re2.num_romaneio) inicio_carga,
                   (select to_char(max(data),'dd/mm/yyyy hh24:mi:ss') data
                      from oper.v$evento_operacao eo3
                     inner join oper.v$romaneio_evento re3
                             on re3.controle_evo_id = eo3.controle_evo_id
                     where eo3.num_evento = 3
                       and roo.num_romaneio = re3.num_romaneio) termino_carga,
                   to_char(numtodsinterval((select max(data)
                      from oper.v$evento_operacao eo3
                     inner join oper.v$romaneio_evento re3
                             on re3.controle_evo_id = eo3.controle_evo_id
                     where eo3.num_evento = 3
                       and roo.num_romaneio = re3.num_romaneio) -
                   (select min(data)
                      from oper.v$evento_operacao eo2
                     inner join oper.v$romaneio_evento re2
                             on re2.controle_evo_id = eo2.controle_evo_id
                     where eo2.num_evento = 2
                       and roo.num_romaneio = re2.num_romaneio),'DAY')) tempo_carga,
                       
                   to_char(numtodsinterval(nvl(case 
                      when (select nvl(max(m.entrega_direta),0)
                              from oper.v$manifesto_conhecimento mc
                             inner join oper.v$manifesto m on m.manifesto_id = mc.manifesto_id
                             where mc.conhecimento_id = con.conhecimento_id) = 1 then 0
                      else (select max(m.data_termino)
                              from oper.v$manifesto_conhecimento mc
                             inner join oper.v$manifesto m on m.manifesto_id = mc.manifesto_id
                             where mc.conhecimento_id = con.conhecimento_id) -
                           nvl((select max(data_entrega)
                              from oper.v$entrega e
                             where e.carga_id = c.carga_id),nvl(c.inicio_descarga,c.data_entrega))
                   end,0),'day')) tempo_cd,

                   to_char(nvl(c.inicio_descarga,c.data_entrega),'dd/mm/yyyy hh24:mi:ss') inicio_descarga,
                   to_char(c.data_entrega,'dd/mm/yyyy hh24:mi:ss') termino_descarga, 
                   to_char(numtodsinterval(c.data_entrega-nvl(c.inicio_descarga,c.data_entrega),'day')) tempo_descarga,

                </cfif>
				   c.entrega_logradouro,
				   c.entrega_complemento,
				   c.entrega_bairro,
				   c.entrega_cep,
				   c.entrega_municipio_id,
				   emun.municipio entrega_municipio,
				   emun.uf_id entrega_uf,
				   decode(cdd.descricao,'',cep.fnc_municipio_uf(desmun.municipio_id),'CD: '||cdd.descricao) destino,
				   c.observacao,
				   c.situacao_id,
				   st.rv_abbreviation as status,
				   con.num_conhecimento,
				   decode(cd.descricao,'',cep.fnc_municipio_uf(c.municipio_id),'CD: '||cd.descricao) ultima_posicao,
				   cl.num_coleta,
				   cl.serie coleta_serie,
				   cl.subserie coleta_subserie,
				   (select kss.fnc_concat_all(to_concat_expr(cn.nf_numero,' / '))
				      from oper.v$carga_nf cn
					 where cn.carga_id = c.carga_id) notas_fiscais,
					con.data_emissao,
                   con.PESO,
                   (select max(data)
                      from rastreador.v$posicao
                     where placa = (select max(placa_controle) keep(dense_rank last order by nvl(rh.data_termino,sysdate))
                                      from oper.v$romaneio_hist_veiculo rh
                                     where rh.num_romaneio = roo.num_romaneio
                                       and rh.data_inicio <= least(sysdate,nvl(roo.data_termino,sysdate))/*
                                       and nvl(rh.data_termino,sysdate) >= least(sysdate,nvl(roo.data_termino,sysdate))*/)
                       and data <= least(sysdate,nvl(roo.data_termino,sysdate))) as data_posicao,
                       
                   (select max(placa_controle) keep(dense_rank last order by nvl(rh.data_termino,sysdate))
                      from oper.v$romaneio_hist_veiculo rh
                     where rh.num_romaneio = roo.num_romaneio
                       and rh.data_inicio <= least(sysdate,nvl(roo.data_termino,sysdate))/*
                       and nvl(rh.data_termino,sysdate) >= least(sysdate,nvl(roo.data_termino,sysdate))*/) placa_posicao,
                   
                   con.placa_tracao
			  from oper.v$carga c
			 inner join kss.v$pessoa rem
					 on rem.cod_pessoa = c.rem_cod_pessoa
		     left join cep.municipio rmun
					 on rmun.municipio_id = c.rem_municipio_id
			 inner join kss.v$pessoa dest
					 on dest.cod_pessoa = c.dest_cod_pessoa
		     left join cep.municipio dmun
					 on dmun.municipio_id = c.dest_municipio_id
		     inner join cep.municipio cmun
					 on cmun.municipio_id = c.coleta_municipio_id
		     inner join cep.municipio emun
					 on emun.municipio_id = c.entrega_municipio_id
			 inner join oper.cg_ref_codes st
			         on st.rv_low_value = c.situacao_id
					and st.rv_domain = 'SITUACAO CARGA'
			<cfif arguments.grupo_logistico eq 1>
				 inner join oper.v$grupo_logistico_usuario glu
						 on glu.usuario = '#ucase(session.usuario)#'
				  left join oper.v$grupo_logistico_carga glc
						 on glc.cod_pessoa_carga = c.rem_cod_pessoa
						and glu.grupo_id = glc.grupo_id
				  left join oper.v$grupo_logistico_descarga gld
						 on gld.cod_pessoa_descarga = c.dest_cod_pessoa
						and glu.grupo_id = gld.grupo_id
			</cfif>
			  left join oper.v$coleta cl
			         on cl.carga_id = c.carga_id
			  left join oper.v$carga_transferencia tr
			         on tr.carga_id = c.carga_id
					and tr.transferencia_id_posterior is null	
			  left join oper.v$carga_transferencia trd
			         on trd.carga_id = c.carga_id
					and trd.data_destino is null	
			  left join cep.municipio desmun
			         on desmun.municipio_id = trd.municipio_id_destino
			  left join oper.v$centro_distribuicao cdd
			         on cdd.cod_pessoa_filial = trd.cod_filial_destino
			  left join oper.v$carga_ctrc cc
			         on cc.carga_id = c.carga_id
		      left join fiscal.v$conhecimento con
			         on con.conhecimento_id = cc.conhecimento_id
              left join oper.v$romaneio roo
                     on roo.num_romaneio = con.num_romaneio
		      left join oper.v$centro_distribuicao cd
			         on cd.cod_pessoa_filial = c.cod_filial_atual
			 where 1=1
			 
			<cfif arguments.grupo_logistico eq 1>
				    and ( c.rem_cod_pessoa = glc.cod_pessoa_carga or 
						 c.dest_cod_pessoa = gld.cod_pessoa_descarga)
				 <cfif len(trim(arguments.rem_cod_pessoa)) or len(trim(arguments.dest_cod_pessoa))>
					and ( 1=0
					<cfif len(trim(arguments.rem_cod_pessoa))>
					   or c.rem_cod_pessoa in (#arguments.rem_cod_pessoa#)
					</cfif>
					<cfif len(trim(arguments.dest_cod_pessoa))>
					   or c.dest_cod_pessoa in (#arguments.dest_cod_pessoa#)
					</cfif>
						)
				 </cfif>
			</cfif>

			 <cfif len(trim(arguments.data_inicial))>
			   and trunc(c.date_insert) >= '#arguments.data_inicial#'
			 </cfif>
			 <cfif len(trim(arguments.data_final))>
			   and trunc(c.date_insert) <= '#arguments.data_final#'
			 </cfif>
			 
			 <cfif len(trim(arguments.destino))>
			   and c.destino = #arguments.destino#
			 </cfif>

			 <cfif len(trim(arguments.rem_cod_pessoa))>
			   and c.rem_cod_pessoa in (#arguments.rem_cod_pessoa#)
			 </cfif>
			 <cfif len(trim(arguments.rem_municipio_id))>
			   and c.rem_municipio_id = #arguments.rem_municipio_id#
			 </cfif>
			 <cfif len(trim(arguments.dest_cod_pessoa))>
			   and c.dest_cod_pessoa in (#arguments.dest_cod_pessoa#)
			 </cfif>
			 <cfif len(trim(arguments.dest_municipio_id))>
			   and c.dest_municipio_id = #arguments.dest_municipio_id#
			 </cfif>

			 <cfif len(trim(arguments.situacao_id))>
			   and c.situacao_id in (#arguments.situacao_id#)
			 </cfif>
			 <cfif len(trim(arguments.not_situacao_id))>
			   and c.situacao_id not in (#arguments.not_situacao_id#)
			 </cfif>
			 <cfif len(trim(arguments.carga_id))>
			   and c.carga_id = #arguments.carga_id#
			 </cfif>
			 <cfif arguments.blank eq 1>
			   and 1=0
			 </cfif>
			 <cfif len(trim(arguments.sem_conhecimento)) and arguments.sem_conhecimento eq 1>
			   and not exists (select '0' 
								 from oper.v$carga_ctrc cc 
								inner join fiscal.v$conhecimento con
										on cc.conhecimento_id = con.conhecimento_id
								where cc.carga_id = c.carga_id
								  and con.situacao_id <> 1)
			 </cfif>
			 <cfif len(trim(arguments.cod_filial_atual))>
			   and c.cod_filial_atual = #arguments.cod_filial_atual#
			 </cfif>
             <cfif len(trim(arguments.cod_filial_conhecimento))>
               and con.cod_pessoa_filial = #arguments.cod_filial_conhecimento#
             </cfif>
             <cfif len(trim(arguments.conhecimento_cancelado))>
             	<cfif arguments.conhecimento_cancelado eq 0>
                  and con.situacao_id <> 1
                </cfif>
             </cfif>
			 <cfif len(trim(arguments.data_inicial))>
			   and trunc(c.date_insert) >= '#arguments.data_inicial#'
			 </cfif>
			 <cfif len(trim(arguments.data_final))>
			   and trunc(c.date_insert) <= '#arguments.data_final#'
			 </cfif>
			 <cfif len(trim(arguments.cod_pedido))>
			   and c.num_pedido in (#ListQualify(arguments.cod_pedido,"'")#)
			 </cfif>
			 <cfif len(trim(arguments.ordem_compra))>
			   and exists (select 0
			                 from oper.v$carga_nf cnf
							where cnf.ordem_compra in (#arguments.ordem_compra#)
							  and cnf.carga_id = c.carga_id)
			 </cfif>
			 <cfif len(trim(arguments.num_coleta))>
			   and cl.num_coleta in (#arguments.num_coleta#)
			 </cfif>
			 <cfif len(trim(arguments.num_conhecimento))>
			   <cfif not len(trim(ValueList(qrConhecimentos.carga_id)))>
			   and 1=0
			   <cfelse>
			   and c.carga_id in (#ValueList(qrConhecimentos.carga_id)#)
			   </cfif>
			 </cfif>
			 <cfif len(trim(arguments.nota_fiscal))>
			   and exists (select 'x'
			                 from oper.v$carga_nf cn
							where cn.carga_id = c.carga_id
							  and cn.nf_numero in (#ListQualify(arguments.nota_fiscal,"'",',')#))
			 </cfif>
			 order by c.carga_id desc) a
            left join rastreador.v$posicao p
                    on p.placa = a.placa_posicao
                   and p.data = a.data_posicao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
					  		
	<!--- 
	-- PROPSITO 
	-- Busca as ocorrencias da carga
	-- CRISTOFER  27/10/2006
	--->		
	<cffunction name="get_carga_ocorrencia" access="remote" returntype="query" output="true">
		<cfargument name="carga_id" required="no" default="">
		<cfargument name="conhecimento_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select co.carga_ocorrencia_id,
				   co.ocorrencia_id,
				   to_char(co.data,'dd/mm/yyyy hh24:mi:ss') as data,
				   co.carga_id,
				   co.observacao,
				   oe.descricao_resumida,
				   oe.descricao
			  from oper.v$carga_ocorrencia co
			 inner join oper.v$ocorrencia_empresa oe
					 on oe.ocorrencia_Id = co.ocorrencia_id
             <cfif len(trim(arguments.conhecimento_id))>
             inner join oper.v$carga_ctrc cc
                     on cc.carga_id = co.carga_id
                    and cc.conhecimento_id = #arguments.conhecimento_id#
             </cfif>
			 where 1=1
			 <cfif len(trim(arguments.carga_id))>
			   and co.carga_id = #arguments.carga_id#
			 </cfif>
			 order by co.data, co.carga_ocorrencia_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    
    
    <!--- 
	-- PROPSITO 
	-- Busca as ocorrencias da coleta
	-- CRISTOFER  27/10/2006
	--->		
	<cffunction name="get_coleta_ocorrencia" access="remote" returntype="query" output="true">
		<cfargument name="coleta_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select c.coleta_ocorrencia_id,
                   c.ocorrencia_id,
                   c.coleta_id,
                   to_char(c.data,'dd/mm/yyyy hh24:mi:ss') as data,
                   c.observacao,
                   e.descricao,
                   c.date_insert,
                   c.user_insert,
                   c.date_update,
                   c.user_update,
                   c.site
              from oper.v$coleta_ocorrencia c
             inner join oper.v$ocorrencia_empresa e
                on e.ocorrencia_id = c.ocorrencia_id
			 where 1=1
			 <cfif len(trim(arguments.coleta_id))>
			   and c.coleta_id = #arguments.coleta_id#
			 </cfif>
			 order by c.data desc, c.coleta_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    

	<!--- 
	-- PROPSITO 
	-- Busca as NF da carga
	-- CRISTOFER  30/10/2006
	--->		
	<cffunction name="get_carga_nf" access="remote" returntype="query" output="true">
		<cfargument name="carga_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cn.carga_nf_id,
				   cn.carga_id,
				   cn.num_natureza,
                   cn.complemento as nota_complemento,
				   cn.nf_numero,
				   cn.nf_serie,
				   cn.nf_data_emissao,
				   cn.nf_valor,
				   cn.peso_kg,
				   cn.peso_cubado_kg,
				   cn.peso_cobrado_kg,
				   cn.qtde_volume,
				   cn.altura,
				   cn.comprimento,
				   cn.largura,
				   cn.m3,
				   cn.cubagem,
				   cn.user_insert,
				   cn.date_insert,
				   cn.user_update,
				   cn.date_update,
				   cn.site,
				   cn.nf_modelo,
				   cn.nf_sub_serie,
				   cn.valor_segurado,
				   cn.cod_unidade,
				   cn.num_especie,
				   cn.ordem_compra,
				   cn.complemento,
				   n.descricao as natureza,
				   e.descricao as especie,
				   oper.pkg_operacional.fnc_converte_peso(cn.peso_kg,cn.cod_unidade,'Kg') peso_kg_convertido,
				   sum(cn.peso_kg) over (order by cn.carga_id rows between unbounded preceding and unbounded following) as peso_total,
				   sum(cn.qtde_volume) over (order by cn.carga_id rows between unbounded preceding and unbounded following) as qtde_total,
                   to_char(cn.nf_data_emissao, 'dd/mm/yyyy') nf_data_emissao_data,
                   cn.cfop,
                   cn.chave_acesso_nfe,
                   cn.tipo_documento_id,
                   cn.descricao_docto,
                   kss.pkg_string.fnc_formata_cnpj_cpf(nvl(extractvalue(xmltype.createxml(cn.nfe_xml),'//NFe/infNFe/emit/CNPJ','xmlns="http://www.portalfiscal.inf.br/nfe"')
                                                          ,extractvalue(xmltype.createxml(cn.nfe_xml),'//NFe/infNFe/emit/CPF','xmlns="http://www.portalfiscal.inf.br/nfe"'))) as cnpj_emitente,
                   extractvalue(xmltype.createxml(cn.nfe_xml),'//NFe/infNFe/emit/xNome','xmlns="http://www.portalfiscal.inf.br/nfe"') as emitente,
                   kss.pkg_string.fnc_formata_cnpj_cpf(nvl(extractvalue(xmltype.createxml(cn.nfe_xml),'//NFe/infNFe/dest/CNPJ','xmlns="http://www.portalfiscal.inf.br/nfe"')
                                                          ,extractvalue(xmltype.createxml(cn.nfe_xml),'//NFe/infNFe/dest/CPF','xmlns="http://www.portalfiscal.inf.br/nfe"'))) as cnpj_destinatario,
                   extractvalue(xmltype.createxml(cn.nfe_xml),'//NFe/infNFe/dest/xNome','xmlns="http://www.portalfiscal.inf.br/nfe"') as destinatario
			  from oper.v$carga_nf cn
			 inner join oper.v$especie e
			         on e.num_especie = cn.num_especie
			 inner join oper.v$natureza n
			         on n.num_natureza = cn.num_natureza
			 where 1=1
			   and cn.carga_id = #arguments.carga_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as transferencias da carga
	-- CRISTOFER  31/10/2006
	--->		
	<cffunction name="get_carga_transferencia" access="remote" returntype="query" output="true">
		<cfargument name="carga_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select t.transferencia_id,
				   t.carga_id,
				   t.cod_filial_origem,
				   cd1.descricao as cd_origem,
				   t.municipio_id_origem,
				   cep.fnc_cidade_completa(t.municipio_id_origem) municipio_origem,
				   t.data_origem,
				   t.cod_filial_destino,
				   cd2.descricao as cd_destino,
				   t.municipio_id_destino,
				   cep.fnc_cidade_completa(t.municipio_id_destino) municipio_destino,
				   t.data_destino,
				   t.transferencia_id_anterior,
				   t.transferencia_id_posterior,
				   t.tipo_id,
				   t.date_insert,
				   t.user_insert,
				   t.date_update,
				   t.user_update,
				   t.site
			  from oper.v$carga_transferencia t
 			  left join oper.v$centro_distribuicao cd1
			         on cd1.cod_pessoa_filial = t.cod_filial_origem
 			  left join oper.v$centro_distribuicao cd2
			         on cd2.cod_pessoa_filial = t.cod_filial_destino					 
			 where 1=1
			   and carga_id = #arguments.carga_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os itens da carga
	-- CRISTOFER  31/10/2006
	--->		
	<cffunction name="get_carga_item" access="remote" returntype="query" output="true">
		<cfargument name="carga_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			  select 	cn.carga_nf_id
					   ,cn.num_natureza
					   ,cn.nf_numero
					   ,cn.nf_serie
					   ,cn.nf_data_emissao
					   ,cn.nf_valor
					   ,cn.peso_kg
					   ,cn.peso_cubado_kg
					   ,cn.peso_cobrado_kg
					   ,cn.qtde_volume
					   ,cn.altura
					   ,cn.comprimento
					   ,cn.largura
					   ,cn.m3
					   ,cn.cubagem
					   ,cn.carga_nf_id
			   from oper.v$carga_nf cn
			  where 1 = 1
			    and carga_id = #arguments.carga_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
  
	<!--- 
	-- PROPSITO 
	-- Busca os centros de distribuio
	-- CRISTOFER  23/10/2006
	--->		
	<cffunction name="get_centro_distribuicao" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select c.cd_id, 
				   c.descricao, 
				   c.cod_pessoa_filial, 
				   c.municipio_id, 
				   m.uf_id uf,
				   m.municipio
			  from oper.v$centro_distribuicao c
			 inner join cep.municipio m
			         on c.municipio_id = m.municipio_id
			 where 1=1
			 <cfif len(trim(arguments.cod_pessoa_filial))>
			   and c.cod_pessoa_filial = #arguments.cod_pessoa_filial#
			 </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os municipios de origem para o manifesto
	-- CRISTOFER  23/10/2006
	--->		
	<cffunction name="get_origem_manifesto" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" required="no" default="">
		<cfquery name="qr_result"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select /*+ ORDERED USE_HASH(C LC) */ distinct loc.cod_uf||to_char(loc.cod_municipio, '000000')||loc.cod_distrito||loc.cod_dv keyfield,
				   loc.cod_uf, loc.cod_municipio, loc.cod_distrito, loc.cod_dv,
				   loc.sigla_uf||'-'||InitCap(loc.nome_municipio) municipio,
				   loc.sigla_uf, loc.nome_municipio,
				   1 as selecionado, loc.rowid
			  from oper.v$conhecimento c
			 /*inner join oper.v$lote_coleta lc
					 on lc.conhecimento_id = c.conhecimento_id*/
					
			 inner join cep.ibge_municipio loc
					 on loc.cod_uf = c.coleta_cod_uf
					and loc.cod_municipio = c.coleta_cod_municipio
					and loc.cod_distrito = c.coleta_cod_distrito
					and loc.cod_dv = c.coleta_cod_dv
			 where c.cod_pessoa_filial = #arguments.cod_pessoa_filial#
			   and c.situacao_id <> 1
			   and not exists(select '*'
								from oper.v$manifesto_conhecimento mc
							   where mc.conhecimento_id = c.conhecimento_id)
			 order by loc.sigla_uf, loc.nome_municipio
		</cfquery>

		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os municipios de destino para o manifesto
	-- CRISTOFER  23/10/2006
	--->		
	<cffunction name="get_destino_manifesto" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" required="no" default="">
		<cfargument name="cd_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select /*+LEADING(LC)*/distinct loc.cod_uf||to_char(loc.cod_municipio, '000000')||loc.cod_distrito||loc.cod_dv keyfield,
				   loc.cod_uf, loc.cod_municipio, loc.cod_distrito, loc.cod_dv, 
				   loc.sigla_uf||'-'||InitCap(loc.nome_municipio) municipio,  
				   loc.sigla_uf,
				   loc.nome_municipio,
				   1 as selecionado, loc.rowid                                  
			  from oper.v$conhecimento c                                        
			 /*inner join oper.v$lote_coleta lc
					 on lc.conhecimento_id = c.conhecimento_id*/
			 inner join cep.ibge_municipio loc                                    
					 on loc.cod_uf = c.entrega_cod_uf                             
					and loc.cod_municipio = c.entrega_cod_municipio               
					and loc.cod_distrito = c.entrega_cod_distrito                 
					and loc.cod_dv = c.entrega_cod_dv                             
			<cfif len(trim(arguments.cd_id)) and arguments.cd_id neq -1>
				 inner join oper.v$cd_municipio cdm                      
						 on cdm.ibge_cod_uf = loc.cod_uf                 
						and cdm.ibge_cod_municipio = loc.cod_municipio   
						and cdm.ibge_cod_distrito = loc.cod_distrito     
						and cdm.ibge_cod_dv = loc.cod_dv                 
				 inner join oper.v$centro_distribuicao cd                
						 on cd.cd_id = cdm.cd_id                         
						and cd.cd_id = #arguments.cd_id#
			</cfif>
			 where c.cod_pessoa_filial = #arguments.cod_pessoa_filial#
			   and c.situacao_id = 0
			   and c.impresso = 1
			<cfif len(trim(arguments.cd_id)) and arguments.cd_id eq -1>
			  and not exists (select /*+PUSH_SUBQ*/'*'
								from oper.v$cd_municipio cdm
							   where cdm.ibge_cod_uf = c.entrega_cod_uf
								 and cdm.ibge_cod_municipio = c.entrega_cod_municipio
								 and cdm.ibge_cod_distrito = c.entrega_cod_distrito
								 and cdm.ibge_cod_dv = c.entrega_cod_dv )
			</cfif>
			and not exists(select /*+PUSH_SUBQ*/ 0                   
							 from oper.v$manifesto_conhecimento mc      
							where mc.conhecimento_id = c.conhecimento_id) 
			order by loc.sigla_uf, loc.nome_municipio
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os conhecimentos  manifestar
	-- CRISTOFER  23/10/2006
	--->		
	<cffunction name="get_conhecimento_a_manifestar" access="remote" returntype="query" output="true">
		<cfargument name="placa" required="no" default="">
		<cfargument name="municipio_origem" required="no" default="">
		<cfargument name="municipio_destino" required="no" default="">
		<cftransaction action="begin">
			<cfloop list="#arguments.MUNICIPIO_ORIGEM#" delimiters="," index="v_idx" >
				<cfquery result="res" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					insert into oper.FILTRO_MUNICIPIO_TMP
					   (flag,cod_uf,cod_municipio,cod_distrito,cod_dv)
					values
					   (0,#listGetAt(v_idx,1,'_')#,#listGetAt(v_idx,2,'_')#,#listGetAt(v_idx,3,'_')#,#listGetAt(v_idx,4,'_')#)
				</cfquery>
			</cfloop>
			<cfloop list="#arguments.MUNICIPIO_DESTINO#" delimiters="," index="v_idx" >
				<cfquery result="res" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					insert into oper.FILTRO_MUNICIPIO_TMP
					   (flag,cod_uf,cod_municipio,cod_distrito,cod_dv)
					values
					   (1,#listGetAt(v_idx,1,'_')#,#listGetAt(v_idx,2,'_')#,#listGetAt(v_idx,3,'_')#,#listGetAt(v_idx,4,'_')#)
				</cfquery>
			</cfloop>
			<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				 select /*+LEADING(LC)*/c.num_conhecimento, c.serie, c.conhecimento_id,  
						c.peso, c.volume, c.m3, c.total_conhecimento,                    
						c.valor_icms, trunc(c.data_emissao) data_emissao,                
						c.rowid,                                                         
						'[Rem.: ' ||c.rem_razao_social ||                              
						' - Dest.: '||c.dest_razao_social||' ]' detalhes,            
						decode(c.pagador, 0, 'R', 'D') pagador,                      
						oper.pkg_global.fnc_municipio(c.coleta_cod_uf, c.coleta_cod_municipio, c.coleta_cod_distrito, c.coleta_cod_dv) coleta,     
						oper.pkg_global.fnc_municipio(c.entrega_cod_uf, c.entrega_cod_municipio, c.entrega_cod_distrito, c.entrega_cod_dv) entrega
						/*,
						cdo.descricao cd_origem, cdd.descricao cd_destino*/                                                                          
				   from oper.v$conhecimento c                                                                                                      
/*				  inner join oper.v$lote_coleta lc                                                                                                 
						  on lc.conhecimento_id = c.conhecimento_id                                                                                
*/				  inner join oper.filtro_municipio_tmp org                
						  on org.flag = 0                                 
						 and org.cod_uf = c.coleta_cod_uf                 
						 and org.cod_municipio = c.coleta_cod_municipio   
						 and org.cod_distrito = c.coleta_cod_distrito     
						 and org.cod_dv = c.coleta_cod_dv                 
				  inner join oper.filtro_municipio_tmp dest               
						  on dest.flag = 1                                
						 and dest.cod_uf = c.entrega_cod_uf               
						 and dest.cod_distrito = c.entrega_cod_distrito   
						 and dest.cod_dv = c.entrega_cod_dv               
/*				  inner join oper.v$centro_distribuicao cdo               
						  on cdo.cd_id = lc.cd_origem                     
				  inner join oper.v$centro_distribuicao cdd               
						  on cdd.cd_id = lc.cd_destino     */               
				  where c.cod_pessoa_filial = #arguments.cod_pessoa_filial#
  					and c.situacao_id = 0
					and c.impresso = 1                                                                                                               
				    and not exists(select /*+PUSH_SUBQ*/'*'                       
					 			     from oper.v$manifesto_conhecimento mc          
									where mc.conhecimento_id = c.conhecimento_id)   
					<cfif len(trim(arguments.placa))>
					   and c.placa = '#arguments.placa#'
					</cfif>
				 order by c.data_emissao, c.num_conhecimento 
			</cfquery>
		</cftransaction>
		<cftransaction action="commit" />
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os dominios registrados
	-- CRISTOFER  24/10/2006
	--->		
	<cffunction name="get_cg_ref_codes" access="remote" returntype="query" output="true">
		<cfargument name="dominio" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select rv_domain dominio, 
				   rv_low_value id, 
				   rv_abbreviation abreviacao,
				   rv_meaning descricao
			  from oper.cg_ref_codes
			 where rv_domain = '#arguments.dominio#'
			 order by rv_low_value
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os manifestos
	-- CRISTOFER  24/10/2006
	--->		
	<cffunction name="get_manifesto_localizar" access="remote" returntype="query" output="true">
		<cfargument name="num_conhecimento" required="no" default="">
		<cfargument name="num_manifesto" required="no" default="">
		<cfargument name="manifesto_id" required="no" default="">        
		<cfargument name="cod_pessoa_filial" required="no" default="">
		<cfargument name="cod_pessoa_origem" required="no" default="">
		<cfargument name="cod_pessoa_destino" required="no" default="">
		<cfargument name="cod_pessoa_confirmacao" required="no" default="">        
        <cfargument name="cod_unidade_negocio" required="no" default="">
        <cfargument name="data_inicial" required="no" default="">
        <cfargument name="data_final" required="no" default="">
		<cfargument name="situacao_id" required="no" default="0">
		<cfargument name="veiculo_proprietario" required="no" default="">
       	<cfargument name="num_ctrc" required="no" default="">
       	<cfargument name="num_nf_ctrc" required="no" default="">
       	<cfargument name="num_manifesto_con" required="no" default="">
       	<cfargument name="placa_tracao" required="no" default="">
       	<cfargument name="frota_tracao" required="no" default="">        
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select m.manifesto_id,
            	   un.unidade_negocio,	 
				   m.num_manifesto, 
                   m.serie,
				   m.placa_tracao,
				   m.placa_reboque,
                   <cfif len(trim(arguments.num_nf_ctrc))>
                   	nf.numero as num_nf_ctrc,
                   </cfif>
                   cg.rv_abbreviation as situacao,
				   to_char(m.data_inicio, 'dd/mm/yyyy hh24:mi:ss') as data_inicio,
                   cdo.descricao as cd_origem_descricao,
                   to_char(m.data_termino, 'dd/mm/yyyy hh24:mi:ss') as data_termino,
				   cdd.descricao cd_destino_descricao,
				   nvl(cdo.descricao,rmun.municipio||'-'||rmun.uf_id) origem_descricao,
				   nvl(cdd.descricao,dmun.municipio||'-'||dmun.uf_id) destino_descricao,
				   m.dest_municipio_id,
				   dmun.municipio||'-'||dmun.uf_id destino,
				   dmun.cod_pessoa_un cod_pessoa_destino,
                   v.cod_veiculo,
                   m.placa_tracao,
   				   case oper.pkg_veiculo.fnc_veiculo_proprietario(m.placa_tracao)
				      when 1 then 'Frota'
					  when 2 then 'Agregado'
					  when 3 then 'Terceiro'
					  else ''
				   end as veiculo_proprietario -- 1 - Frota, 2 - Agregado, 3 - Terceiro
		  	  from oper.v$manifesto m                                                             
		     inner join kss.v$unidade_negocio un                                             
				     on un.cod_pessoa = m.cod_pessoa_filial                                       
			<cfif len(trim(arguments.num_conhecimento))>
			 inner join oper.v$manifesto_conhecimento mc
					 on mc.manifesto_id = m.manifesto_id
			 inner join oper.v$conhecimento c
					 on c.conhecimento_id = mc.conhecimento_id
			</cfif>
             <cfif len(trim(arguments.num_nf_ctrc))>
             inner join oper.v$manifesto_conhecimento mc 
              		  on mc.MANIFESTO_ID = m.manifesto_id
             inner join fiscal.v$conhecimento ch 
                      on ch.CONHECIMENTO_ID = mc.CONHECIMENTO_ID
             inner join fiscal.conhecimento_nota_fiscal nf
				     on mc.conhecimento_id = nf.conhecimento_id
             </cfif>
		     left join oper.v$centro_distribuicao cdo                                            
				     on cdo.cd_id = m.cd_origem                                                   
		     left join oper.v$centro_distribuicao cdd
				     on cdd.cd_id = m.cd_destino
			 inner join cep.municipio dmun
			         on dmun.municipio_id = m.dest_municipio_id
			 inner join cep.municipio rmun
			         on rmun.municipio_id = m.org_municipio_id
             inner join oper.cg_ref_codes cg
      				 on cg.rv_domain = 'MANIFESTO.SITUACAO_ID'
                     and cg.rv_low_value = m.situacao_id 
             inner join oper.v$veiculo v
                     on v.placa = m.placa_tracao                     
            where 1=1
			<cfif len(trim(arguments.veiculo_proprietario))>
			  and oper.pkg_veiculo.fnc_veiculo_proprietario(m.placa_tracao) in (#arguments.veiculo_proprietario#)
			</cfif>
			<cfif len(trim(arguments.situacao_id))>
			   and m.situacao_id in (#arguments.situacao_id#)
			</cfif>
			<cfif len(trim(arguments.cod_pessoa_destino))>
		      and dmun.cod_pessoa_un = #arguments.cod_pessoa_destino#
			</cfif>
			<cfif len(trim(arguments.cod_pessoa_confirmacao))>
		      and (dmun.cod_pessoa_un = #arguments.cod_pessoa_confirmacao# 
                 or (m.entrega_direta = 1 and cdo.cod_pessoa_filial = #arguments.cod_pessoa_confirmacao#))
			</cfif>            
			<cfif len(trim(arguments.cod_pessoa_origem))>
		      and cdo.cod_pessoa_filial = #arguments.cod_pessoa_origem#
			</cfif>
			<cfif len(trim(arguments.cod_pessoa_filial))>
		      and m.cod_pessoa_filial = #arguments.cod_pessoa_filial#
			</cfif>
			<cfif len(trim(arguments.num_conhecimento))>
			  and c.num_conhecimento like '#arguments.num_conhecimento#%'
			</cfif>
			<cfif len(trim(arguments.num_manifesto))>
			  and to_char(m.num_manifesto) like '#arguments.num_manifesto#%'
			</cfif>
			<cfif len(trim(arguments.manifesto_id))>
			  and to_char(m.manifesto_id) = #arguments.manifesto_id#
			</cfif>            
            <cfif len(trim(arguments.cod_unidade_negocio))>
			  and un.cod_unidade_negocio = '#arguments.cod_unidade_negocio#'
			</cfif>
            <cfif len(trim(arguments.data_inicial))>
              and m.data_inicio > '#arguments.data_inicial#'	
            </cfif>
            <cfif len(trim(arguments.data_final))>
              and m.data_inicio < '#arguments.data_final#'
            </cfif>
            <cfif len(trim(arguments.placa_tracao))>
              and m.placa_tracao = upper('#arguments.placa_tracao#')
            </cfif>
            <cfif len(trim(arguments.frota_tracao))>
              and v.cod_veiculo = '#arguments.frota_tracao#'
            </cfif>                        
            <cfif len(trim(arguments.num_nf_ctrc)) or len(trim(arguments.num_manifesto_con)) or len(trim(arguments.num_ctrc))>
			 and (1=0
            <cfif len(trim(arguments.num_nf_ctrc))>
    		 or nf.numero in (select nf.numero
                               from fiscal.v$conhecimento_nota_fiscal nf
                         inner join oper.v$manifesto_conhecimento mc
                                 on mc.CONHECIMENTO_ID = nf.conhecimento_id
                              where nf.numero = #arguments.num_nf_ctrc#)
            </cfif>
            <cfif len(trim(arguments.num_manifesto_con))>
  			 or m.num_manifesto = #arguments.num_manifesto_con#
           </cfif>
            <cfif len(trim(arguments.num_ctrc))>
              or  m.num_manifesto in
                   (select m.num_manifesto
                     from oper.v$manifesto m
               inner join oper.v$manifesto_conhecimento mc 
                       on mc.MANIFESTO_ID = m.manifesto_id
               inner join fiscal.v$conhecimento ch 
                       on ch.CONHECIMENTO_ID = mc.CONHECIMENTO_ID
                    where ch.num_conhecimento = #arguments.num_ctrc#)
            </cfif>        
            )    </cfif>          
            <cfif len(trim(arguments.num_conhecimento))>
			order by c.num_conhecimento
			<cfelse>
			order by m.num_manifesto 
			</cfif> 
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os manifestos
	-- CRISTOFER  24/10/2006
	--->		
	<cffunction name="get_manifesto" access="remote" returntype="query" output="true">
		<cfargument name="manifesto_id" required="no" default="">
		<cfargument name="num_manifesto" required="no" default="">
		<cfargument name="situacao_id" required="no" default="0">
		<cfargument name="cod_pessoa_destino" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select m.manifesto_id,
				   m.num_lote,
				   m.num_manifesto,
				   m.cod_pessoa_filial,
				   m.cd_origem,
				   m.org_municipio_id,
				   mun1.uf_id org_uf_id,
				   mun1.municipio as org_municipio,
				   m.cd_destino,
				   m.dest_municipio_id,
				   mun2.uf_id dest_uf_id,
				   mun2.municipio as dest_municipio,
				   mun1.municipio||'-'||mun1.uf_id||'/'||mun2.municipio||'-'||mun2.uf_id as descricao,
				   m.placa_tracao,
				   m.placa_reboque,
				   m.data_inicio,
				   m.data_termino,
				   m.km_inicio,
				   m.km_termino,
				   m.situacao_id,
				   m.liberacao_seguradora,
				   m.observacao,
				   m.user_insert,
				   m.date_insert,
				   m.user_update,
				   m.date_update,
				   m.site,
				   m.entrega_direta,
				   cd1.cod_pessoa_filial cod_pessoa_destino,
				   mun2.cod_pessoa_un cod_filial_destino,
                   0 as permite_editar,
                   (select dm.documento_id
                      from fiscal.v$documento_mdfe dm
                     where dm.mdfe_id = m.manifesto_id ) as documento_id_sefaz
			  from oper.v$manifesto m
			 inner join cep.municipio mun1
			         on mun1.municipio_id = m.org_municipio_id
			 inner join cep.municipio mun2
			         on mun2.municipio_id = m.dest_municipio_id
			 left join oper.v$centro_distribuicao cd1
			         on cd1.cd_id = m.cd_destino
			 where 1=1
			<cfif len(trim(arguments.situacao_id))>
			   and m.situacao_id in (#arguments.situacao_id#)
			</cfif>
			<cfif len(trim(arguments.cod_pessoa_destino))>
			   and cd1.cod_pessoa_filial = #arguments.cod_pessoa_destino#
			</cfif>
			<cfif len(trim(arguments.manifesto_id))>
			   and manifesto_id in (#arguments.manifesto_id#)
			</cfif>
			<cfif len(trim(arguments.num_manifesto))>
			   and num_manifesto in (#arguments.num_manifesto#)
			</cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca todos os conhecimentos do manifesto
	-- CRISTOFER  24/10/2006
	--->		
	<cffunction name="get_manifesto_conhecimento" access="remote" returntype="query" output="true">
		<cfargument name="manifesto_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select c.conhecimento_id
                 , c.num_conhecimento
                 , c.volume
                 , c.peso
                 , c.m3
                 , c.total_conhecimento
                 , (select m.municipio
                      from cep.municipio m
                     where m.municipio_id = c.coleta_municipio_id
                   ) as coleta_municipio
                 , (select m.uf_id
                      from cep.municipio m
                     where m.municipio_id = c.coleta_municipio_id
                   ) as coleta_uf
                 , (select m.municipio
                      from cep.municipio m
                     where m.municipio_id = c.entrega_municipio_id
                   ) as entrega_municipio
                 , (select m.uf_id
                      from cep.municipio m
                     where m.municipio_id = c.entrega_municipio_id
                   ) as entrega_uf
              from oper.v$manifesto_conhecimento mc
             inner join oper.v$conhecimento c
                     on mc.conhecimento_id = c.conhecimento_id
             where mc.manifesto_id = #arguments.manifesto_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os motoristas do manifesto
	-- CRISTOFER  24/10/2006
	--->		
	<cffunction name="get_manifesto_motorista" access="remote" returntype="query" output="true">
		<cfargument name="manifesto_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select mm.cod_pessoa, 
				   mm.data_inicio,
				   mm.data_termino,
				   mm.org_municipio_id,
				   p.cliente as nome,
				   p.cnpj_cpf,
			       mun.municipio,
				   mun.uf_id uf
			  from oper.v$manifesto_motorista mm
			 inner join kss.v$pessoa p
					 on p.cod_pessoa = mm.cod_pessoa
			 inner join cep.municipio mun
			         on mun.municipio_id = mm.org_municipio_id		 
			 where 1=1
			   and mm.manifesto_id = #arguments.manifesto_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os lacres do manifesto
	-- CRISTOFER  24/10/2006
	--->		
	<cffunction name="get_manifesto_lacre" access="remote" returntype="query" output="true">
		<cfargument name="manifesto_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select manifesto_id,
				   num_lacre,
				   user_insert,
				   date_insert,
				   user_update,
				   date_update,
				   site
			  from oper.v$manifesto_lacre
			 where manifesto_id = #arguments.manifesto_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	
	<!--- 
	-- PROPSITO 
	-- Busca os manifestos para impressao 
	-- WAGNER  24/10/2006
	--->		
	<cffunction name="get_manifesto_print" access="remote" returntype="query" output="true">
		<cfargument name="manifesto_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select /*Cabealho*/
					   kss.pkg_global.FNC_BUSCA_NOME_PESSOA(m.cod_pessoa_filial) as razao_social
					  ,pep.logradouro||', '||pep.numero as endereco
					  ,pep.bairro ||' - '||pep.cep as bairro
					  ,pep.complemento as complemento
					  ,pep.municipio ||' - '|| pep.uf as municipio_uf
            		  ,pep.municipio as municipio
            		  ,pep.uf as uf
            		  ,( select t.identificador
                 		   from kss.v$pessoa t
                 		  where t.cod_pessoa = m.cod_pessoa_filial) as cnpj 
					 
					   /*Manifesto*/
					   ,m.manifesto_id 
					  ,m.num_manifesto as num_manifesto
					  ,(    select mun.municipio||' - '||mun.uf_id as remetente 
							  from cep.municipio mun
							 where mun.municipio_id = m.org_municipio_id) as remetente
					  ,(    select mun.municipio||' - '||mun.uf_id as destinatario
							  from cep.municipio mun
							 where mun.municipio_id = m.dest_municipio_id) as destinatario     
					 
					   /*Itens*/
					  ,c.NUM_CONHECIMENTO as num_conhecimento
					  ,decode(c.PAGADOR,0,'R','D') as pagador
					  ,decode(c.pagador,0,c.total_conhecimento,0) as pago_remetente
            		  ,c.m3 as m3
					  ,decode(c.pagador,1,c.total_conhecimento,0) as pago_destinatario
					  ,c.REM_RAZAO_SOCIAL as rem_conhecimento
					  ,c.DEST_RAZAO_SOCIAL as dest_conhecimento
					  ,(    select fnc_concat_all(to_concat_expr(to_char(numero), '/')) nota_fiscal
							  from fiscal.v$conhecimento_nota_fiscal cnf
							 where cnf.CONHECIMENTO_ID = mc.CONHECIMENTO_ID) as notas_fiscais
					  ,nvl((    select sum(cnf.VALOR_TOTAL)
							  from fiscal.v$conhecimento_nota_fiscal cnf
							 where cnf.CONHECIMENTO_ID = mc.CONHECIMENTO_ID),0) as total_nf
					  , nvl((    select sum(cnf.cubagem)
							  from fiscal.v$conhecimento_nota_fiscal cnf
							 where cnf.CONHECIMENTO_ID = mc.CONHECIMENTO_ID),0) as peso_cubado_nf
					  ,nvl((	 select sum(cnf.peso)
    					  	   from fiscal.v$conhecimento_nota_fiscal cnf
   							  where cnf.conhecimento_id = mc.conhecimento_id),0) as peso_nf					   
					  ,c.VOLUME as volume
					  ,c.PESO as peso
					  ,c.TOTAL_CONHECIMENTO as total_conhecimento
					  ,c.VALOR_ICMS as icms
					 
					  /*Veculo*/
					  ,m.placa_tracao as placa_tracao
					  ,(    select vm.MARCA
							  from oper.v$veiculo v
						inner join oper.v$veiculo_marca vm
								on vm.MARCA_ID = v.MARCA_ID
							 where v.PLACA = m.placa_tracao) as marca
					  ,(    select vmd.MODELO 
							  from oper.v$veiculo v
						inner join oper.v$veiculo_modelo vmd
                                on vmd.MODELO_ID = v.MODELO_ID
                               and vmd.marca_id = v.marca_id
							 where v.PLACA = m.placa_tracao ) as modelo
					  
					  /*Motorista*/
					  ,kss.pkg_global.FNC_BUSCA_NOME_PESSOA(   (select mm2.COD_PESSOA
																  from oper.v$manifesto_motorista mm2
																 where mm2.manifesto_id = m.manifesto_id
																   and rownum = 1
																   and mm2.data_inicio = (select max(data_inicio)
                                                                  							from oper.v$manifesto_motorista
                                                                 						   where manifesto_id = m.manifesto_id))) as nome_motorista
					  ,( select p.cnpj_cpf
                 		  from kss.v$pessoa p 
					     where p.cod_pessoa = (	select distinct mm3.COD_PESSOA
                                       			  from oper.v$manifesto_motorista mm3
                                       			 where mm3.manifesto_id = m.manifesto_id
                                         		   and rownum = 1
												   and mm3.data_inicio = (select max(data_inicio)
  																		    from oper.v$manifesto_motorista
																		   where manifesto_id = m.manifesto_id))) as cpf_motorista
					  /*Lacres*/
					  ,(	select kss.fnc_concat_all(to_concat_expr(ml.num_lacre,','))
                		  	  from oper.v$manifesto_lacre ml
               		     	 where ml.manifesto_id = m.manifesto_id)as num_lacre
					  
					  /*Diversos*/
					  ,m.liberacao_seguradora as liberacao
                 ,to_char(m.data_inicio,'DD/MM/YYYY') as data_inicio
					  ,m.km_inicio as km_inicio  
					  
					  /*Seguradoras*/
            
            		  -- RCTR_C
					  ,(select kss.pkg_global.FNC_BUSCA_NOME_PESSOA( t.COD_SEGURADORA)
						  from oper.v$seg_contratado  t
					     where t.id_seguradora = ls.id_seg_rctr_c )as seguradora_rctr_c
					  ,(select t.NUMERO_APOLICE
						  from oper.v$seg_contratado  t
					     where t.id_seguradora = ls.id_seg_rctr_c) as num_apolice_rctr_c
					  -- RCF_DC
					  ,(select kss.pkg_global.FNC_BUSCA_NOME_PESSOA( t.COD_SEGURADORA)
						  from oper.v$seg_contratado  t
					     where t.id_seguradora = ls.ID_SEG_RCF_DC )as seguradora_rcf_dc
					  ,(select t.NUMERO_APOLICE
						  from oper.v$seg_contratado  t
					     where t.id_seguradora = ls.ID_SEG_RCF_DC) as num_apolice_rcf_dc
					  -- RCTR_VI
					  ,(select kss.pkg_global.FNC_BUSCA_NOME_PESSOA( t.COD_SEGURADORA)
						  from oper.v$seg_contratado  t
					     where t.id_seguradora = ls.ID_SEG_RCTR_VI )as seguradora_rctr_vi
					  ,(select t.NUMERO_APOLICE
						  from oper.v$seg_contratado  t
					     where t.id_seguradora = ls.ID_SEG_RCTR_VI) as num_apolice_rctr_vi
				      -- RR
					  ,(select kss.pkg_global.FNC_BUSCA_NOME_PESSOA( t.COD_SEGURADORA)
						  from oper.v$seg_contratado  t
					     where t.id_seguradora = ls.ID_SEG_RR )as seguradora_rr
					  ,(select t.NUMERO_APOLICE
						  from oper.v$seg_contratado  t
					     where t.id_seguradora = ls.ID_SEG_RR) as num_apolice_rr
					  
					  from oper.v$manifesto m 
				inner join oper.v$manifesto_conhecimento mc
						on mc.manifesto_id = m.manifesto_id
				inner join fiscal.v$conhecimento c
						on c.conhecimento_id= mc.CONHECIMENTO_ID 
				inner join kss.v$pessoa_endereco_padrao pep 
						on pep.cod_pessoa = m.cod_pessoa_filial
			     left join oper.v$lote_seguro ls
              			on ls.num_lote = m.num_lote
                       and ls.data_exclusao is null
				where m.manifesto_id = #arguments.manifesto_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os manifestos para impressao 
	-- WAGNER  24/10/2006
	--->		
	<cffunction name="get_manifesto_print_novo" access="remote" returntype="query" output="true">
		<cfargument name="manifesto_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					select /*cabealho*/
						   kss.pkg_global.fnc_busca_nome_pessoa(m.cod_pessoa_filial) as razao_social
						  ,pep.logradouro||', '||pep.numero as endereco
						  ,pep.bairro ||' - '||pep.cep as bairro
						  ,pep.complemento as complemento
						  ,pep.municipio ||' - '|| pep.uf as municipio_uf
            		  	  ,pep.municipio as municipio
            		  	  ,pep.uf as uf
            		  	  ,( select t.identificador
                 			   from kss.v$pessoa t
                 			  where t.cod_pessoa = m.cod_pessoa_filial) as cnpj 
					 
						  /*manifesto*/
						  ,m.data_inicio as data_emissao
						  ,m.manifesto_id 
						  ,m.num_manifesto as num_manifesto
						  ,(    select mun.municipio||' - '||mun.uf_id as remetente 
								  from cep.municipio mun
								 where mun.municipio_id = m.org_municipio_id) as remetente
						  ,(    select mun.municipio||' - '||mun.uf_id as destinatario
								  from cep.municipio mun
								 where mun.municipio_id = m.dest_municipio_id) as destinatario     
						  
						  /*Veiculo*/
						  ,m.placa_reboque as placa_reboque
					  	  ,(    select vm.MARCA
							  	  from oper.v$veiculo v
							inner join oper.v$veiculo_marca vm
									on vm.MARCA_ID = v.MARCA_ID
							 	 where v.PLACA = m.placa_tracao) as marca						  
						  /*itens*/
						  ,c.num_conhecimento as num_conhecimento
						  ,c.serie as conhecimento_serie
						  ,decode(c.pagador,0,'CIF','FOB') as pagador
						  ,c.m3 as m3
						  ,c.rem_razao_social as rem_conhecimento
						  ,c.dest_razao_social as dest_conhecimento
						  ,cnf.numero as nota_fiscal
						  ,cnf.serie as nota_serie
						  ,cnf.valor_total as total_nf
						  ,cnf.cubagem as peso_cubado_nf
						  ,cnf.peso as peso_nf					   
						  ,c.volume as volume
						  ,c.peso as peso
						  ,c.total_conhecimento as total_conhecimento
						  ,c.valor_icms as icms
						  ,m.observacao
					 from oper.v$manifesto m 
			   inner join oper.v$manifesto_conhecimento mc
				       on mc.manifesto_id = m.manifesto_id
			   inner join fiscal.v$conhecimento c
				       on c.conhecimento_id= mc.conhecimento_id
			   inner join fiscal.v$conhecimento_nota_fiscal cnf
				       on cnf.conhecimento_id = c.conhecimento_id
			   inner join kss.v$pessoa_endereco_padrao pep 
				       on pep.cod_pessoa = m.cod_pessoa_filial
			    left join oper.v$lote_seguro ls
				  	   on ls.num_lote = m.num_lote	
					where m.manifesto_id = #arguments.manifesto_id#
				 order by c.num_conhecimento  

		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os Conhecimentos a manifestar na filial
	-- CRISTOFER  01/11/2006
	--->		
	<cffunction name="get_conhecimentos_manifestar" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" required="yes">
		<cfargument name="order_coleta" required="no" default="0">
		<cfargument name="coleta_municipio_id" required="no" default="">
		<cfargument name="entrega_municipio_id" required="no" default="">
		<cfargument name="placa" required="no" default="">
		<cfargument name="exceto_manifesto_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select con.conhecimento_id,
                   con.num_conhecimento,
                   con.placa,
                   con.data_emissao,
                   oper.fnc_get_cod_veiculo(con.placa) cod_veiculo,
                   con.peso,
                   con.volume,
                   con.m3,
                   con.total_conhecimento,
                   con.coleta_municipio_id,
                   cep.fnc_cidade_completa(con.coleta_municipio_id) coleta,
                   cmun.uf_id coleta_uf,
                   cmun.municipio coleta_municipio,
                   con.entrega_municipio_id,
                   cep.fnc_cidade_completa(con.entrega_municipio_id) entrega,
                   emun.uf_id entrega_uf,
                   emun.municipio entrega_municipio
              from cep.municipio amun
             inner join oper.v$carga c
                     on amun.municipio_id = c.municipio_id
             inner join oper.v$carga_ctrc ct
                     on c.carga_id = ct.carga_id
             inner join fiscal.v$conhecimento con
                     on con.conhecimento_id = ct.conhecimento_id
             inner join fiscal.v$conhecimento_outros_dados coo
                     on coo.conhecimento_id = con.conhecimento_id
             inner join cep.municipio cmun
                     on cmun.municipio_id = con.coleta_municipio_id
             inner join cep.municipio emun
                     on emun.municipio_id = con.entrega_municipio_id
             inner join fiscal.v$documento_cte dc
                     on dc.conhecimento_id = con.conhecimento_id                     
             where 1=1 
               and con.situacao_id <> 1
               and con.data_emissao >= to_date('01/07/2011', 'dd/mm/yyyy')
               and con.data_entrega is null
               and c.situacao_id = 2
               and amun.cod_pessoa_un = #arguments.cod_pessoa_filial#
               and con.total_conhecimento <> 0
			 <cfif len(trim(arguments.placa))>
			   and con.placa = '#arguments.placa#'
			 </cfif>
			 <cfif len(trim(arguments.coleta_municipio_id))>
			   and con.coleta_municipio_id in (#arguments.coleta_municipio_id#)
			 </cfif>
			 <cfif len(trim(arguments.entrega_municipio_id))>
			   and con.entrega_municipio_id in (#arguments.entrega_municipio_id#)
			 </cfif>
			   /*and not exists (select 0
								 from oper.v$carga_transferencia ct1
								 inner join oper.v$carga_ctrc ct2
									    on ct2.carga_id = ct1.carga_Id
						         inner join oper.v$manifesto_conhecimento mc 
								        on mc.conhecimento_id = ct2.conhecimento_id
									   and ct1.manifesto_id = mc.manifesto_id
								where ct1.carga_id = c.carga_id
								  and ct1.data_destino is null
								<cfif len(trim(arguments.exceto_manifesto_id))>
								  and mc.manifesto_id <> #arguments.exceto_manifesto_id#
								</cfif>
								  )*/
			<cfif arguments.order_coleta eq 1>
			 order by coleta_uf, coleta_municipio
			<cfelse>
			 order by entrega_uf, entrega_municipio
			</cfif> 
		</cfquery>        
        
        
<!---		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select con.conhecimento_id,
                   con.num_conhecimento,
                   con.placa,
                   con.data_emissao,
                   oper.fnc_get_cod_veiculo(con.placa) cod_veiculo,
                   con.peso,
                   con.volume,
                   con.m3,
                   con.total_conhecimento,
                   con.coleta_municipio_id,
                   cep.fnc_cidade_completa(con.coleta_municipio_id) coleta,
                   cmun.uf_id coleta_uf,
                   cmun.municipio coleta_municipio,
                   con.entrega_municipio_id,
                   cep.fnc_cidade_completa(con.entrega_municipio_id) entrega,
                   emun.uf_id entrega_uf,
                   emun.municipio entrega_municipio
              from cep.municipio amun
             inner join oper.v$carga c
                     on amun.municipio_id = c.municipio_id
             inner join oper.v$carga_ctrc ct
                     on c.carga_id = ct.carga_id
             inner join fiscal.v$conhecimento con
                     on con.conhecimento_id = ct.conhecimento_id
             inner join cep.municipio cmun
                     on cmun.municipio_id = con.coleta_municipio_id
             inner join cep.municipio emun
                     on emun.municipio_id = con.entrega_municipio_id
              left join oper.v$romaneio_item ri
                     on ri.num_romaneio = con.num_romaneio
                    and ri.item_id = con.item_id
              left join oper.v$lote l
                     on l.num_lote = ri.num_lote
             where 1=1 
               and con.situacao_id <> 1
               and con.data_emissao >= '01/01/2007'
               and con.data_entrega is null
               and (con.num_romaneio is null or l.fracionado = 1)
               and amun.cod_pessoa_un = #arguments.cod_pessoa_filial#
			 <cfif len(trim(arguments.placa))>
			   and con.placa = '#arguments.placa#'
			 </cfif>
			 <cfif len(trim(arguments.coleta_municipio_id))>
			   and con.coleta_municipio_id in (#arguments.coleta_municipio_id#)
			 </cfif>
			 <cfif len(trim(arguments.entrega_municipio_id))>
			   and con.entrega_municipio_id in (#arguments.entrega_municipio_id#)
			 </cfif>
			   and not exists (select 0
								 from oper.v$carga_transferencia ct1
								 inner join oper.v$carga_ctrc ct2
									    on ct2.carga_id = ct1.carga_Id
						         inner join oper.v$manifesto_conhecimento mc 
								        on mc.conhecimento_id = ct2.conhecimento_id
									   and ct1.manifesto_id = mc.manifesto_id
								where ct1.carga_id = c.carga_id
								  and ct1.data_destino is null
								<cfif len(trim(arguments.exceto_manifesto_id))>
								  and mc.manifesto_id <> #arguments.exceto_manifesto_id#
								</cfif>
								  )
			<cfif arguments.order_coleta eq 1>
			 order by coleta_uf, coleta_municipio
			<cfelse>
			 order by entrega_uf, entrega_municipio 
			</cfif> 
		</cfquery>--->
		<cfreturn qr_result>		
	</cffunction>
  
	<!--- 
	-- PROPSITO 
	-- Busca as entregas
	-- CRISTOFER  03/11/2006
	--->		
	<cffunction name="get_entrega" access="remote" returntype="query" output="true">
		<cfargument name="situacao_id" required="no" default="">
		<cfargument name="cod_filial_atual" required="no" default="">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfargument name="rem_cod_pessoa" required="no" default="">
		<cfargument name="dest_cod_pessoa" required="no" default="">
		<cfargument name="rem_municipio_id" required="no" default="">
		<cfargument name="dest_municipio_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select e.entrega_id,
				   e.data_entrega,
				   e.rem_cod_pessoa,
				   p.cliente as remetente,
				   e.rem_logradouro,
				   e.rem_complemento,
				   e.rem_bairro,
				   e.rem_cep,
				   e.rem_municipio_id,
				   m1.municipio as rem_municipio,
				   m1.uf_id as rem_uf,
				   e.local_carga,
				   e.dest_cod_pessoa,
				   p2.cliente as destinatario,
				   e.dest_logradouro,
				   e.dest_complemento,
				   e.dest_bairro,
				   e.dest_cep,
				   e.dest_municipio_id,
				   m2.municipio as dest_municipio,
				   m2.uf_id as dest_uf,
				   e.observacao,
				   e.user_insert,
				   e.date_insert,
				   e.user_update,
				   e.date_update,
				   e.site,
				   e.local_descarga,
				   e.carga_id,
				   e.situacao_id,
				   e.data_confirmacao,
				   ev.placa, 
				   ev.entrega_vei_id,
				   con.num_conhecimento,
				   st.rv_abbreviation situacao,
				   (select sum(cn.qtde_volume)
				   	  from oper.v$carga_nf cn
					 where cn.carga_id = c.carga_id) volumes
			  from oper.v$entrega e
			 inner join kss.v$pessoa p
					 on p.cod_pessoa = e.rem_cod_pessoa
			 inner join cep.municipio m1
					 on m1.municipio_id = e.rem_municipio_id
			 inner join kss.v$pessoa p2
					 on p2.cod_pessoa = e.dest_cod_pessoa
			 inner join cep.municipio m2
					 on m2.municipio_id = e.dest_municipio_id
			 inner join oper.v$carga c
			         on c.carga_id = e.carga_id
			 inner join oper.cg_ref_codes st
			         on e.situacao_id = st.rv_low_value
					and st.rv_domain = 'SITUACAO ENTREGA'
			  left join oper.v$carga_ctrc ct
			         on ct.carga_id = c.carga_id
			  left join fiscal.v$conhecimento con
			         on con.conhecimento_id = ct.conhecimento_id
			  left join oper.v$entrega_veiculo ev
			         on ev.entrega_id = e.entrega_id
					and ev.data_cancelamento is null
		     where 1=1
			 <cfif len(trim(arguments.situacao_id))>
			   and e.situacao_id in (#arguments.situacao_id#)
			 </cfif>
			 <cfif len(trim(arguments.data_inicial))>
			   and e.data_entrega >= '#arguments.data_inicial#'
			 </cfif>
			 <cfif len(trim(arguments.data_final))>
			   and e.data_entrega <= '#arguments.data_final#'
			 </cfif>
			 <cfif len(trim(arguments.cod_filial_atual))>
			   and e.cod_filial in (#arguments.cod_filial_atual#)
			 </cfif>
			 <cfif len(trim(arguments.rem_cod_pessoa))>
			   and e.rem_cod_pessoa = #arguments.rem_cod_pessoa#
			 </cfif>
			 <cfif len(trim(arguments.dest_cod_pessoa))>
			   and e.dest_cod_pessoa = #arguments.dest_cod_pessoa#
			 </cfif>
			 <cfif len(trim(arguments.dest_municipio_id))>
			   and e.dest_municipio_id = #arguments.dest_municipio_id#
			 </cfif>
			 <cfif len(trim(arguments.rem_municipio_id))>
			   and e.rem_municipio_id = #arguments.rem_municipio_id#
			 </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as coletas e entregas
	-- CRISTOFER  16/11/2006
	--->		
	<cffunction name="get_coleta_entrega" access="remote" returntype="query" output="true">
		<cfargument name="placa" required="no" default="">
		<cfargument name="entrega" required="no" default="">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfargument name="exibir_finalizadas" required="no" default="0">
		
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfif (not len(trim(arguments.entrega))) or (len(trim(arguments.entrega)) and arguments.entrega eq 0)>
			select 'C'||cl.coleta_id id,
			       null entrega_id,
				   0 entrega,
				   'Coleta' tipo,
				   cl.coleta_id,
				   cl.num_coleta,
				   null data_entrega,
				   cl.data_pedido,
				   ev.data_agendamento,
				   cl.rem_cod_pessoa,
				   p.cliente as remetente,
				   cl.rem_logradouro,
				   cl.rem_complemento,
				   cl.rem_bairro,
				   cl.rem_cep,
				   cl.rem_municipio_id,
				   m1.municipio as rem_municipio,
				   m1.uf_id as rem_uf,
				   cl.local_carga,
				   cl.dest_cod_pessoa,
				   p2.cliente as destinatario,
				   cl.dest_logradouro,
				   cl.dest_complemento,
				   cl.dest_bairro,
				   cl.dest_cep,
				   cl.dest_municipio_id,
				   m2.municipio as dest_municipio,
				   m2.uf_id as dest_uf,
				   cl.observacao,
				   cl.user_insert,
				   cl.date_insert,
				   cl.user_update,
				   cl.date_update,
				   cl.site,
				   cl.local_descarga,
				   cl.carga_id,
				   cl.situacao_id,
				   cl.data_confirmacao,
				   ev.placa,
				   ev.coleta_vei_id,
				   null entrega_vei_id,
				   con.num_conhecimento,
				   st.rv_abbreviation as situacao,
				 
				   ci.nf_data_emissao as nf_data_emissao,
				   ci.nf_numero as nf_numero,
				   ci.qtde_volume as volume,
				   ci.nf_valor as nf_valor,
				   esp.descricao as especie,
				   ci.peso_kg as peso,
				   0 as entrega_total_kg,
				   sum(ci.peso_kg) over(partition by cl.coleta_id order by cl.coleta_id) coleta_total_kg,
				   0 as entrega_total_volume,
				   0 as entrega_total_ctrc,
				   ci.qtde_volume as coleta_total_volume,
				   sum(con.TOTAL_CONHECIMENTO) over(partition by cl.coleta_id order by cl.coleta_id) coleta_total_ctrc,
				   1 total_coletas,
				   0 total_entregas,
				   con.TOTAL_CONHECIMENTO as valor_total_ctrc,
                   cl.num_pedido
			  from oper.v$coleta cl
			 inner join oper.v$coleta_item ci
           			 on ci.coleta_id = cl.coleta_id
		     inner join oper.v$especie esp
       				 on esp.num_especie = ci.num_especie
			 inner join oper.cg_ref_codes st
			         on st.rv_low_value = cl.situacao_id
					and rv_domain = 'SITUACAO COLETA'
			 inner join kss.v$pessoa p 
					 on p.cod_pessoa = cl.rem_cod_pessoa
			 inner join cep.municipio m1 
					 on m1.municipio_id = cl.rem_municipio_id
			 inner join kss.v$pessoa p2 
					 on p2.cod_pessoa = cl.dest_cod_pessoa
			 inner join cep.municipio m2 
					 on m2.municipio_id = cl.dest_municipio_id
			  left join oper.v$carga c 
					 on c.carga_id = cl.carga_id
			  left join oper.v$carga_ctrc ct 
					 on ct.carga_id = c.carga_id
			  left join fiscal.v$conhecimento con 
					 on con.conhecimento_id = ct.conhecimento_id
			  left join oper.v$coleta_veiculo ev 
					 on ev.coleta_id = cl.coleta_id
					and ev.data_cancelamento is null
			 where 1 = 1
			 <cfif len(trim(arguments.placa))>
			   and ev.placa in (#ListQualify(arguments.placa,"'",',')#)
			 </cfif>
			 <cfif arguments.exibir_finalizadas neq 1>
			   and cl.situacao_id not in (1,6)
			 </cfif>
			 <cfif len(trim(arguments.data_inicial))>
			   and ev.data_agendamento >= '#arguments.data_inicial#:00'
			 </cfif>
			 <cfif len(trim(arguments.data_final))>
			   and ev.data_agendamento <= '#arguments.data_final#:00'
			 </cfif>
			 
			</cfif>
			<cfif not len(trim(arguments.entrega))>
			union all
			</cfif>
			<cfif (not len(trim(arguments.entrega))) or (len(trim(arguments.entrega)) and arguments.entrega eq 1)>
			select 'E'||e.entrega_id id,
			       e.entrega_id,
				   1 entrega,
				   'Entrega' tipo,
				   null coleta_id,
				   null num_coleta,
				   e.data_entrega,
				   null data_pedido,
				   ev.data_agendamento,
				   e.rem_cod_pessoa,
				   p.cliente as remetente,
				   e.rem_logradouro,
				   e.rem_complemento,
				   e.rem_bairro,
				   e.rem_cep,
				   e.rem_municipio_id,
				   m1.municipio as rem_municipio,
				   m1.uf_id as rem_uf,
				   e.local_carga,
				   e.dest_cod_pessoa,
				   p2.cliente as destinatario,
				   e.dest_logradouro,
				   e.dest_complemento,
				   e.dest_bairro,
				   e.dest_cep,
				   e.dest_municipio_id,
				   m2.municipio as dest_municipio,
				   m2.uf_id as dest_uf,
				   e.observacao,
				   e.user_insert,
				   e.date_insert,
				   e.user_update,
				   e.date_update,
				   e.site,
				   e.local_descarga,
				   e.carga_id,
				   e.situacao_id,
				   e.data_confirmacao,
				   ev.placa,
				   null,
				   ev.entrega_vei_id,
				   con.num_conhecimento,
				   st.rv_abbreviation as situacao,
				   
				   cnf.nf_data_emissao as nf_data_emissao,
				   to_char(cnf.nf_numero) as nf_numero,
				   cnf.qtde_volume as volume,
				   cnf.nf_valor as nf_valor,
				   esp.descricao as especie,
				   cnf.peso_kg as peso,
				   sum(cnf.peso_kg) over(partition by e.entrega_id order by e.entrega_id) entrega_total_kg,
				   0 as coleta_total_kg,
				   cnf.qtde_volume as entrega_total_volume,
				   sum(con.TOTAL_CONHECIMENTO) over(partition by e.entrega_id order by e.entrega_id) entrega_total_ctrc,
				   0 as coleta_total_,
				   0 as coleta_total_ctrc,
				   0 total_coletas,
				   1 total_entregas	,
				   con.TOTAL_CONHECIMENTO as valor_total_ctrc,
                   null as num_pedido
			  from oper.v$entrega e
			 inner join oper.cg_ref_codes st
			         on st.rv_low_value = e.situacao_id
					and rv_domain = 'SITUACAO ENTREGA'
			 inner join kss.v$pessoa p 
					 on p.cod_pessoa = e.rem_cod_pessoa
			 inner join cep.municipio m1 
					 on m1.municipio_id = e.rem_municipio_id
			 inner join kss.v$pessoa p2 
					 on p2.cod_pessoa = e.dest_cod_pessoa
			 inner join cep.municipio m2 
					 on m2.municipio_id = e.dest_municipio_id
			 inner join oper.v$carga c 
					 on c.carga_id = e.carga_id
		     inner join oper.v$carga_nf cnf
           			 on c.carga_id = cnf.carga_id
			 inner join oper.v$especie esp
               		 on esp.num_especie = cnf.num_especie
			  left join oper.v$carga_ctrc ct 
					 on ct.carga_id = c.carga_id
			  left join fiscal.v$conhecimento con 
					 on con.conhecimento_id = ct.conhecimento_id
			  left join oper.v$entrega_veiculo ev 
					 on ev.entrega_id = e.entrega_id
					and ev.data_cancelamento is null
			 where 1 = 1
			 <cfif len(trim(arguments.placa))>
			   and ev.placa in (#ListQualify(arguments.placa,"'",',')#)
			 </cfif>
			 <cfif arguments.exibir_finalizadas neq 1>
			   and e.situacao_id not in (3,4)
			 </cfif>
			 <cfif len(trim(arguments.data_inicial))>
			   and ev.data_agendamento >= '#arguments.data_inicial#:00'
			 </cfif>
			 <cfif len(trim(arguments.data_final))>
			   and ev.data_agendamento <= '#arguments.data_final#:00'
			 </cfif>
			 </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca o numero de coletas e entregas do veiculo no dia
	-- CRISTOFER  12/03/2007
	--->		
	<cffunction name="get_coleta_entrega_veiculo" access="remote" returntype="query" output="true">
		<cfargument name="placa" required="yes">
		<cfargument name="data_inicial" required="yes">
		<cfargument name="data_final" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select d.data, 
				   d.dia_semana,
				   v.placa,
				   (select count('x')
					  from oper.v$entrega_veiculo ev
					 where trunc(ev.data_confirmacao) = trunc(d.data)
					   and ev.placa = v.placa) nro_entregas,
				   (select count('x')
					  from oper.v$coleta_veiculo cv
					 where trunc(cv.data_confirmacao) = trunc(d.data)
					   and cv.placa = v.placa) nro_coletas
			  from table(kss.pkg_tempo.fnc_get_sequencia_dias(trunc(to_date('#arguments.data_inicial#','dd/mm/yyyy hh24:mi')),trunc(to_date('#arguments.data_final#','dd/mm/yyyy hh24:mi')))) d
			 natural join oper.v$veiculo v
			 where v.placa in (#ListQualify(arguments.placa,"'",",")#)
			 group by d.data, d.dia_semana,v.placa
			 order by v.placa,d.data,d.dia_semana
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca as cargas com base no documento fiscal
	-- CRISTOFER  04/11/2006
	-- TIPO_DOCUMENTO
	-- 1 - CTRC
	-- 2 - Manifesto Internacional
	-- 3 - Nota Fiscal de Servio
	-- 4 - N Carga
	--->		
	<cffunction name="get_carga_documento" access="remote" returntype="query" output="true">	
		<cfargument name="num_documento" required="no" default="">
		<cfargument name="tipo_documento" required="no" default="1">
		<cfargument name="cod_pessoa_filial" required="no" default="">
		<cfargument name="entrega_vei_id" required="no" default="">
		<cfargument name="carga_id" required="no" default="">
        <cfargument name="serie" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select con.conhecimento_id documento_id, con.num_romaneio,
				   1 tipo_documento,
				   con.num_conhecimento num_documento,
				   to_char(con.data_emissao,'DD/MM/YYYY HH24:MI') as data_emissao,
				   c.carga_id,
				   con.serie,
				   c.destino,
				   con.cod_pessoa_filial,
				   c.situacao_id,
				   (select stc.rv_abbreviation
                      from oper.cg_ref_codes stc 
                     where stc.rv_low_value = c.situacao_id
                       and rv_domain = 'SITUACAO CARGA') as situacao_carga,
				   rem.cliente remetente,
				   dest.cliente destinatario,
				   rmun.municipio rem_municipio,
				   rmun.uf_id rem_uf,
				   dmun.municipio dest_municipio,
				   dmun.uf_id dest_uf,
				   con.placa_tracao,
				   con.placa,
				   con.valor_icms,
				   con.base_calculo_icms,
				   con.aliquota_icms,
				   con.valor_icms,
                   con.baixado_observacao as observacao,
				   con.total_conhecimento,
				   con.nome_motorista,
				   case 
					  when c.situacao_id in (6,7) or con.num_romaneio is not null then 1
					  else 0
				   end entrega_old,
				   1 entrega,
				   case 
					  when con.num_romaneio is not null then 1
					  else 0
				   end carga_seca,
                   to_char(con.data_entrega,'DD/MM/YYYY HH24:MI') as data_entrega,
				   to_char(c.data_entrega,'DD/MM/YYYY HH24:MI') as data_entrega_carga,
                   to_char(c.inicio_descarga,'DD/MM/YYYY HH24:MI') as inicio_descarga,
                   to_char(c.data_chegada, 'DD/MM/YYYY HH24:MI') as data_chegada
			  from fiscal.v$conhecimento con
			<cfif len(trim(arguments.carga_id))>
             inner join oper.v$carga_ctrc ct
                     on ct.conhecimento_id = con.conhecimento_id
            <cfelse>
			  left join oper.v$carga_ctrc ct
                     on ct.conhecimento_id = con.conhecimento_id
            </cfif>
			<cfif len(trim(arguments.carga_id))>
             inner join oper.v$carga c
					 on ct.carga_id = c.carga_id
            <cfelse>
			  left join oper.v$carga c
					 on ct.carga_id = c.carga_id
            </cfif>
			 inner join kss.v$pessoa rem
					 on rem.cod_pessoa = con.cod_remetente
			 inner join kss.v$pessoa dest
					 on dest.cod_pessoa = con.cod_destinatario
			 inner join cep.municipio rmun
					 on rmun.municipio_id = con.coleta_municipio_id
			 inner join cep.municipio dmun
					 on dmun.municipio_id = con.entrega_municipio_id
			  left join oper.v$entrega e
			         on e.carga_id = c.carga_id
			  left join oper.v$entrega_veiculo ev
			         on ev.entrega_id = e.entrega_id
			 where 1=1
			 <cfif len(trim(arguments.entrega_vei_id))>
			   and ev.entrega_vei_id = #arguments.entrega_vei_id#
			 </cfif>
			 <cfif len(trim(arguments.carga_id))>
			   and c.carga_id = #arguments.carga_id#
			 </cfif>
			 <cfif len(trim(arguments.cod_pessoa_filial))>
			   and con.cod_pessoa_filial = #arguments.cod_pessoa_filial#
			 </cfif>
             <cfif len(trim(arguments.serie))>
			   and con.serie = '#arguments.serie#'
			 </cfif>
			 <cfif len(trim(arguments.tipo_documento)) and len(trim(arguments.num_documento))>
				 <cfif arguments.tipo_documento eq 1>
				   and con.num_conhecimento = '#arguments.num_documento#'
				 <cfelse>
					-- Ainda no esto implementados outros tipos de documento 
					and 1=0
				 </cfif>
			 </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
         
	<!--- 
	-- PROPSITO 
	-- Retorna a relao de entregas do veiculo
	-- CRISTOFER  06/11/2006
	--->		
	<cffunction name="get_entrega_relacao" access="remote" returntype="query" output="true">
		<cfargument name="placa" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select kss.pkg_global.FNC_BUSCA_NOME_PESSOA(e.cod_filial) as razao_social,
				   pep.logradouro||', '||pep.numero as endereco,
				   pep.bairro ||' - '||pep.cep as bairro,
				   pep.complemento as complemento,
				   pep.municipio ||' - '|| pep.uf as municipio,
				   e.entrega_id,
				   e.data_entrega,
				   e.rem_cod_pessoa,
				   p.cliente as remetente,
				   e.rem_logradouro,
				   e.rem_complemento,
				   e.rem_bairro,
				   e.rem_cep,
				   e.rem_municipio_id,
				   m1.municipio as rem_municipio,
				   m1.uf_id as rem_uf,
				   e.local_carga,
				   e.dest_cod_pessoa,
				   p2.cliente as destinatario,
				   e.dest_logradouro,
				   e.dest_complemento,
				   e.dest_bairro,
				   e.dest_cep,
				   e.dest_municipio_id,
				   m2.municipio as dest_municipio,
				   m2.uf_id as dest_uf,
				   e.observacao,
				   e.user_insert,
				   e.date_insert,
				   e.user_update,
				   e.date_update,
				   e.site,
				   e.local_descarga,
				   e.carga_id,
				   e.situacao_id,
				   e.data_confirmacao,
				   ev.placa,
				   ev.entrega_vei_id,
				   con.num_conhecimento,
				   cn.carga_nf_id,
				   cn.num_natureza,
				   cn.nf_numero,
				   cn.nf_modelo,
				   cn.nf_serie,
				   cn.nf_sub_serie,
				   cn.nf_data_emissao,
				   cn.qtde_volume,
				   nt.DESCRICAO as natureza
			  from oper.v$entrega e
			 inner join kss.v$pessoa_endereco_padrao pep
           			 on pep.cod_pessoa = e.cod_filial			 
			 inner join kss.v$pessoa p 
					 on p.cod_pessoa = e.rem_cod_pessoa
			 inner join cep.municipio m1 
					 on m1.municipio_id = e.rem_municipio_id
			 inner join kss.v$pessoa p2 
					 on p2.cod_pessoa = e.dest_cod_pessoa
			 inner join cep.municipio m2 
					 on m2.municipio_id = e.dest_municipio_id
			 inner join oper.v$carga c 
					 on c.carga_id = e.carga_id
			 inner join oper.v$carga_nf cn 
					 on cn.carga_id = c.carga_id
			 inner join oper.v$natureza nt 
					 on nt.num_natureza = cn.num_natureza
			 inner join oper.v$carga_ctrc ct 
					 on ct.carga_id = c.carga_id
			 inner join fiscal.v$conhecimento con 
					 on con.conhecimento_id = ct.conhecimento_id
			 inner join oper.v$entrega_veiculo ev 
					 on ev.entrega_id = e.entrega_id
					and data_cancelamento is null
			 where e.situacao_id = 1
			   and ev.placa = '#Ucase(arguments.placa)#'
			 order by ev.placa, e.data_entrega, e.entrega_id, nt.descricao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
 
	<!--- 
	-- PROPSITO 
	-- Busca os dados da carga
	-- CRISTOFER  13/11/2006
	--->		
	<cffunction name="get_carga_dados" access="remote" returntype="query" output="true">
		<cfargument name="carga_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select c.carga_id,
				   c.rem_cod_pessoa,
				   pr.cnpj_cpf rem_cnpj_cpf,
				   pr.cliente remetente,
				   c.dest_cod_pessoa,
				   pd.cnpj_cpf dest_cnpj_cpf,
				   pd.cliente destinatario,
				   c.user_insert,
				   c.date_insert,
				   c.user_update,
				   c.date_update,
				   c.site,
				   c.cod_empresa,
				   c.num_pedido,
				   c.rem_logradouro,
				   c.rem_complemento,
				   c.rem_bairro,
				   c.rem_cep,
				   c.rem_municipio_id,
				   mr.municipio rem_municipio,
				   mr.uf_id rem_uf,
				   c.dest_logradouro,
				   c.dest_complemento,
				   c.dest_bairro,
				   c.dest_cep,
				   c.dest_municipio_id,
				   md.municipio dest_municipio,
				   md.uf_id dest_uf,
				   
				   c.coleta_cod_pessoa,
                   kss.pkg_string.fnc_num_clean(kss.pkg_pessoa.fnc_get_identificador(c.coleta_cod_pessoa)) as coleta_cnpj,
                   kss.pkg_pessoa.fnc_get_cliente(c.coleta_cod_pessoa) as coleta_razao_social,
                   c.coleta_logradouro,
				   c.coleta_complemento,
				   c.coleta_bairro,
				   c.coleta_cep,
				   c.coleta_municipio_id,
				   cmun.municipio coleta_municipio,
				   cmun.uf_id coleta_uf,

				   c.entrega_cod_pessoa,
                   kss.pkg_string.fnc_num_clean(kss.pkg_pessoa.fnc_get_identificador(c.entrega_cod_pessoa)) as entrega_cnpj,
                   kss.pkg_pessoa.fnc_get_cliente(c.entrega_cod_pessoa) as entrega_razao_social,
                   c.entrega_logradouro,
				   c.entrega_complemento,
				   c.entrega_bairro,
				   c.entrega_cep,
				   c.entrega_municipio_id,
				   emun.municipio entrega_municipio,
				   emun.uf_id entrega_uf,
				   
				   c.observacao,
				   c.situacao_id,
				   c.municipio_id,
				   c.cod_filial_atual,
				   c.destino
			  from oper.v$carga c
		     inner join cep.municipio cmun
					 on cmun.municipio_id = c.coleta_municipio_id
		     inner join cep.municipio emun
					 on emun.municipio_id = c.entrega_municipio_id
			  
			 inner join cep.municipio mr
					 on mr.municipio_id = c.rem_municipio_id
			 inner join cep.municipio md
					 on md.municipio_id = c.dest_municipio_id
			 inner join kss.v$pessoa pr
					 on pr.cod_pessoa = c.rem_cod_pessoa
			 inner join kss.v$pessoa pd
					 on pd.cod_pessoa = c.dest_cod_pessoa
			 where 1=1
			 <cfif len(trim(arguments.carga_id))>
			   and c.carga_id = #arguments.carga_id#
			 </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as nfs da carga
	-- CRISTOFER  13/11/2006
	--->		
	<cffunction name="get_carga_nf_dados" access="remote" returntype="query" output="true">
		<cfargument name="carga_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cn.carga_nf_id,
				   cn.carga_id,
				   cn.num_natureza,
				   cn.nf_numero,
				   cn.nf_serie,
				   cn.nf_data_emissao,
				   cn.nf_valor,
				   cn.peso_kg,
				   cn.peso_cubado_kg,
				   cn.peso_cobrado_kg,
				   cn.qtde_volume,
				   cn.altura,
				   cn.comprimento,
				   cn.largura,
				   cn.m3,
				   cn.cubagem,
				   cn.user_insert,
				   cn.date_insert,
				   cn.user_update,
				   cn.date_update,
				   cn.site,
				   cn.nf_modelo,
				   cn.nf_sub_serie,
				   cn.valor_segurado
			  from oper.v$carga_nf cn
			 where 1=1
			 <cfif len(trim(arguments.carga_id))>
			   and cn.carga_id = #arguments.carga_id#
			 </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
   
	<!--- 
	-- PROPSITO 
	-- Converte entre unidades de medida
	-- CRISTOFER  14/11/2006
	--->		
	<cffunction name="converte_unidade" access="remote" returntype="numeric" output="true">
		<cfargument name="valor" required="yes">
		<cfargument name="unidade_origem" required="yes">
		<cfargument name="unidade_destino" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select oper.pkg_operacional.fnc_converte_peso(#arguments.valor#, '#arguments.unidade_origem#', '#arguments.unidade_destino#') valor
			  from dual
		</cfquery>
		<cfreturn qr_result.valor>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os veiculos que realizaram alguma coleta ou entrega
	-- CRISTOFER  16/11/2006
	--->		
	<cffunction name="get_veiculo_coleta_entrega" access="remote" returntype="query" output="true">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select v.placa,
				   v.cod_veiculo,
				   vma.marca,
				   vm.modelo
			  from (select placa
					  from oper.v$entrega_veiculo ev
					 where 1=1
					 <cfif len(trim(arguments.data_inicial))>
					   and ev.data_agendamento >= '#arguments.data_inicial#'
					 </cfif>
					 <cfif len(trim(arguments.data_final))>
					   and ev.data_agendamento >= '#arguments.data_final#'
					 </cfif>
					 union
					select placa
					  from oper.v$coleta_veiculo cv
					 where 1=1
					 <cfif len(trim(arguments.data_inicial))>
					   and cv.data_agendamento >= '#arguments.data_inicial#'
					 </cfif>
					 <cfif len(trim(arguments.data_final))>
					   and cv.data_agendamento >= '#arguments.data_final#'
					 </cfif>
					 ) cev
			 inner join oper.v$veiculo v
					 on cev.placa = v.placa
			 inner join oper.v$veiculo_marca vma
					 on vma.marca_id = v.marca_id
			 inner join oper.v$veiculo_modelo vm
					 on vm.modelo_id = v.modelo_id
					and vm.marca_id = v.marca_id
			 order by v.cod_veiculo
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
 
	<!--- 
	-- PROPSITO 
	-- Busca as cargas aguardando carregamento
	-- CRISTOFER  20/11/2006
	--->		
	<cffunction name="get_carga_carregamento" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="yes">
		<cfargument name="tipo" required="no" default="0">
		<cfargument name="coleta_municipio_id" required="no" default="">
		<cfargument name="entrega_municipio_id" required="no" default="">
		<cfargument name="carga_id" required="no" default="">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select c.carga_id,
				   m1.municipio coleta_municipio,
				   m1.uf_id     coleta_uf,
				   m2.municipio entrega_municipio,
				   m2.uf_id     entrega_uf,
				   (select kss.fnc_concat_all(to_concat_expr(cn.nf_numero,'/'))
					  from oper.v$carga_nf cn
					 where cn.carga_id = c.carga_id) notas_fiscais,
				   nvl((select sum(oper.pkg_operacional.fnc_converte_peso(cn.peso_kg,cn.cod_unidade,'Kg'))
					  from oper.v$carga_nf cn
					 where cn.carga_id = c.carga_id),0) as peso_total,
				   (select nvl(sum(cn.cubagem),0)
					  from oper.v$carga_nf cn
					 where cn.carga_id = c.carga_id) cubagem_total,
				   nvl((select sum(cn.qtde_volume)
				      from oper.v$carga_nf cn
					 where cn.carga_id = c.carga_id),0) qtde_volume,
                   (select sum(nvl(cn.nf_valor,0))
				      from oper.v$carga_nf cn
					 where cn.carga_id = c.carga_id) valor_mercadoria,
				   con.num_conhecimento,
				   c.rem_cod_pessoa,
				   c.dest_cod_pessoa,
				   c.user_insert,
				   c.date_insert,
				   c.user_update,
				   c.date_update,
				   c.site,
				   c.cod_empresa,
				   c.num_pedido,
				   c.rem_logradouro,
				   c.rem_complemento,
				   c.rem_bairro,
				   c.rem_cep,
				   c.rem_municipio_id,
				   c.dest_logradouro,
				   c.dest_complemento,
				   c.dest_bairro,
				   c.dest_cep,
				   c.dest_municipio_id,
				   c.observacao,
				   c.situacao_id,
				   c.municipio_id,
				   c.cod_filial_atual,
				   c.destino,
				   c.coleta_logradouro,
				   c.coleta_complemento,
				   c.coleta_bairro,
				   c.coleta_cep,
				   c.coleta_municipio_id,
				   c.entrega_logradouro,
				   c.entrega_complemento,
				   c.entrega_bairro,
				   c.entrega_cep,
				   c.entrega_municipio_id,
				   c.devolucao,
				   c.carga_id_origem,
				   p1.cliente remetente,
				   p2.cliente destinatario,
				   oper.pkg_veiculo.FNC_GET_COMPOSICAO(con.PLACA) as placas
			  from oper.v$carga c
			 inner join cep.municipio m1
					 on m1.municipio_id = c.coleta_municipio_id
		     inner join kss.v$pessoa p1
			         on p1.cod_pessoa = c.rem_cod_pessoa
			 inner join cep.municipio m2
					 on m2.municipio_id = c.entrega_municipio_id
		     inner join kss.v$pessoa p2
			         on p2.cod_pessoa = c.dest_cod_pessoa
		      left join oper.v$carga_ctrc cc
			         on cc.carga_id = c.carga_id
		      left join fiscal.v$conhecimento con
			         on con.conhecimento_id = cc.conhecimento_id
			 where 1=1
			   and c.cod_filial_atual = #arguments.cod_pessoa#
			   and c.situacao_id  in (1,2,6)
			<cfif len(trim(arguments.data_inicial))>
			   and trunc(c.date_insert) >= '#arguments.data_inicial#'
			</cfif>
			<cfif len(trim(arguments.data_final))>
			   and trunc(c.date_insert) <= '#arguments.data_final#'
			</cfif>
			<cfif arguments.tipo eq 1>
			   and con.num_conhecimento is not null
			</cfif>
			<cfif arguments.tipo eq 2>
			   and con.num_conhecimento is null
			</cfif>
			<cfif len(trim(arguments.coleta_municipio_id))>
			   and c.coleta_municipio_id in (#arguments.coleta_municipio_id#)
			</cfif>
			<cfif len(trim(arguments.entrega_municipio_id))>
			   and c.entrega_municipio_id in (#arguments.entrega_municipio_id#)
			</cfif>
			<cfif len(trim(arguments.carga_id))>
			   and c.carga_id in (#arguments.carga_id#)
			</cfif>
			 <cfif len(trim(arguments.order_by))>
			 	<cfif arguments.order_by eq 'coleta'>
			 order by m1.uf_id,m1.municipio 
				</cfif>
			 	<cfif arguments.order_by eq 'entrega'>
			 order by m2.uf_id,m2.municipio
				</cfif>
			 	<cfif arguments.order_by eq 'num_carga'>
			 order by c.carga_id
				</cfif>
			 </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>


	<!--- 
	-- PROPSITO 
	-- Busca as cargas aguardando carregamento
	-- CRISTOFER  20/11/2006
	--->		
	<cffunction name="get_carga_carregamento_municipio" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select c.carga_id,
				   m1.municipio coleta_municipio,
				   m1.uf_id     coleta_uf,
				   m2.municipio entrega_municipio,
				   m2.uf_id     entrega_uf,
				   c.coleta_municipio_id,
				   c.entrega_municipio_id
			  from oper.v$carga c
			 inner join cep.municipio m1
					 on m1.municipio_id = c.coleta_municipio_id
			 inner join cep.municipio m2
					 on m2.municipio_id = c.entrega_municipio_id
			 where 1=1
			   and c.cod_filial_atual = #arguments.cod_pessoa#
			   and c.situacao_id  in (1,2)
			 <cfif len(trim(arguments.order_by))>
			 	<cfif arguments.order_by eq 'coleta'>
			 order by m1.uf_id,m1.municipio 
				</cfif>
			 	<cfif arguments.order_by eq 'entrega'>
			 order by m2.uf_id,m2.municipio
				</cfif>
			 	<cfif arguments.order_by eq 'num_carga'>
			 order by c.carga_id
				</cfif>
			 </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os Lotes para o localizar
	-- CRISTOFER  28/11/2006
	--->		
	<cffunction name="get_lote_localizar" access="remote" returntype="query" output="true">
		<cfargument name="num_lote" required="no" default="">
		<cfargument name="remetente" required="no" default="">
		<cfargument name="num_produto" required="no" default="">
		<cfargument name="org_municipio" required="no" default="">
		<cfargument name="fracionado" required="no" default="">
		<cfargument name="internacional" required="no" default="">
		<cfargument name="frete_proprio" required="no" default="">
		<cfargument name="filial_atual" required="no" default="0">
		<cfargument name="dedicado" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct t.num_lote,
				   t.cod_pessoa_filial,
                   rem.cod_pessoa cod_remetente,
				   rem.cliente remetente,
                   rmun.municipio_id org_municipio_id,
                   dest.cod_pessoa cod_destinatario,
                   dmun.municipio_id dest_municipio_id,
				   rmun.municipio||'-'||rmun.uf_id rem_municipio_uf,
				   nvl(dest.cliente ,'-- Aberto --') destinatario,
				   nvl(decode(t.entrega_municipio_id,'','',dmun.municipio||'-'||dmun.uf_id),'-- Aberto --') dest_municipio_uf,
				   t.fracionado,
				   p.descricao produto,
				   t.frete_proprio				   
			  from oper.v$lote t
			 inner join oper.v$lote_setor_docto ld
			         on ld.num_lote = t.num_lote
			 inner join kss.v$pessoa rem
					 on rem.cod_pessoa = t.cod_pessoa_remetente
			 inner join cep.municipio rmun
					 on rmun.municipio_id = t.coleta_municipio_id
			 inner join fiscal.v$produto p 
			         on p.produto_id = t.num_produto
			  left join kss.v$pessoa dest
					 on dest.cod_pessoa = t.cod_pessoa_destinatario
			  left join cep.municipio dmun
					 on dmun.municipio_id = t.entrega_municipio_id
			 where 1=1
			   and t.situacao_id = 1
			 <cfif len(trim(arguments.num_lote))>
			 	and t.num_lote in (#arguments.num_lote#)
			 </cfif>
			 <cfif len(trim(arguments.fracionado))>
			 	and t.fracionado in (#arguments.fracionado#)
			 </cfif>
			 <cfif len(trim(arguments.internacional))>
			 	and t.internacional = #arguments.internacional#
			 </cfif>
			 <cfif len(trim(arguments.dedicado))>
			 	and t.dedicado = #arguments.dedicado#
			 </cfif>
			 <cfif len(trim(arguments.frete_proprio))>
			 	and t.frete_proprio = #arguments.frete_proprio#
			 </cfif>
			 <cfif len(trim(arguments.num_produto))>
			 	and t.num_produto = #arguments.num_produto#
			 </cfif>             
			 <cfif len(trim(arguments.remetente))>
			    and upper(kss.pkg_string.fnc_string_clean(rem.cliente)) like '%'||upper(kss.pkg_string.fnc_string_clean('#arguments.remetente#'))||'%'
			 </cfif>
			 <cfif len(trim(arguments.org_municipio))>
			 	and upper(kss.pkg_string.fnc_string_clean(dmun.municipio||'-'||dmun.uf_id)) like '%'||upper(kss.pkg_string.fnc_string_clean('#arguments.org_municipio#'))||'%'
			 </cfif>
			 <cfif arguments.filial_atual eq 1>
			 	and ld.cod_pessoa_filial = #session.cod_pessoa#
 			    and ld.cod_departamento  = #session.cod_departamento#
			    and ld.cod_setor	        = #session.cod_setor#
			 </cfif>
			 order by t.num_lote
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca o romaneio ativo para a placa
	-- CRISTOFER  29/11/2006
	--->		
	<cffunction name="get_romaneio_ativo" access="remote" returntype="query" output="true">
		<cfargument name="placa" required="no" default="">
		<cfscript>
			conn = CreateObject("component","_transportes.consulta.cfc_veiculo");
			qrVeiculo = conn.get_composicao(cod_veiculo = arguments.placa);
		</cfscript>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select r.num_romaneio,
				   rhv.placa_controle,
				   oper.pkg_veiculo.fnc_veiculo_proprietario(rhv.placa_controle) veiculo_proprietario,
				   (select count(*)
                     from oper.v$romaneio_item ri
                    inner join fiscal.v$nf_es_frete ne 
                            on ne.item_id = ri.item_id
                    where ri.num_romaneio = r.num_romaneio) as possui_nf,
				   case
					 when not exists
							  (select 0
								 from oper.v$agregado_romaneio ar
								where ar.num_romaneio = r.num_romaneio
								  and ar.data_cancelamento is null)
								  and exists (select 0
													 from fiscal.v$conhecimento c
													where c.num_romaneio = r.num_romaneio) then 1
					 when exists (select ''
							 from oper.v$romaneio_item ri
							inner join oper.v$lote l on l.num_lote = ri.num_lote
							where num_romaneio = r.num_romaneio
							  and l.internacional = 1) then
					  1
                      when exists (select ''
                                     from oper.v$romaneio_item ri
                                    inner join fiscal.v$nf_es_frete ne 
                                            on ne.item_id = ri.item_id
                                    where ri.num_romaneio = r.num_romaneio) then
                      1
					 else
					  0
				   end disponivel
			  from oper.v$romaneio r
			 inner join oper.v$romaneio_hist_veiculo rhv
					 on rhv.num_romaneio = r.num_romaneio
			 where 1 = 1
			   and r.situacao_id <> 2
			 <cfif len(trim(arguments.placa))>
			   and rhv.placa_controle = '#Replace(qrVeiculo.placa,'-','')#'
			 </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca itens do romaneio, com o tipo do frete
	-- GUTO  09/01/2007
	--->		
	<cffunction name="get_romaneio_itens" access="remote" returntype="query" output="true">
		<cfargument name="num_romaneio" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ri.item_id, ri.num_romaneio, l.internacional
			  from oper.v$romaneio_item ri
		     inner join oper.v$lote l
                     on l.num_lote = ri.num_lote
			 where num_romaneio = #arguments.num_romaneio#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os conhecimentos do romaneio
	-- CRISTOFER  29/11/2006
	--->		
	<cffunction name="get_conhecimentos_romaneio" access="remote" returntype="query" output="true">
		<cfargument name="num_romaneio" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select conhecimento_id,
				   num_conhecimento
			  from fiscal.v$conhecimento
			 where num_romaneio = #arguments.num_romaneio#
			order by num_conhecimento
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>


	<!--- 
	-- PROPSITO 
	-- Busca os status de importaes
	-- CRISTOFER  01/12/2006
	--->		
	<cffunction name="get_imp_ctrc_klabin" access="remote" returntype="query" output="true">
		<cfargument name="situacao_id" required="no" default="">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfargument name="data_emissao_inicial" required="no" default="">
		<cfargument name="data_emissao_final" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select kx.id,
				   kx.num_conhecimento,
				   kx.situacao_id situacao_importacao,
				   to_char(kx.date_insert,'dd/mm/yyyy hh24:mi:ss') as  data_importacao,
				   k.num_conhecimento,
				   k.serie_conhecimento,
				   to_char(k.data_emissao,'dd/mm/yyyy hh24:mi:ss') as data_emissao,
				   k.conhecimento_id,
				   k.situacao_id situacao_integracao,
				   case k.situacao_id
				      when 1 then 'Aguardando Integrao'
					  when 2 then 'Integrado com sucesso'
					  when 3 then 'Erro de Integrao'
					  when 4 then 'Integrao cancelada'
					  else '-- No identificada --'
				   end situacao,
				   k.erro,
				   to_char(k.data_integracao,'dd/mm/yyyy hh24:mi:ss') as data_integracao
			  from rodomar.v$imp_ctrc_klabin_xml kx
			  left join rodomar.v$imp_ctrc_klabin k
					 on k.xml_id = kx.id
			 where 1=1
			 <cfif len(trim(arguments.situacao_id))>
			   and k.situacao_id in (#arguments.situacao_id#)
			 </cfif>
			 <cfif len(trim(arguments.data_inicial))>
			   and trunc(kx.date_insert) >= '#arguments.data_inicial#'
			 </cfif>
			 <cfif len(trim(arguments.data_final))>
			   and trunc(kx.date_insert) <= '#arguments.data_final#'
			 </cfif>
			 <cfif len(trim(arguments.data_emissao_inicial))>
			   and trunc(k.data_emissao) >= '#arguments.data_emissao_inicial#'
			 </cfif>
			 <cfif len(trim(arguments.data_emissao_final))>
			   and trunc(k.data_emissao) <= '#arguments.data_emissao_final#'
			 </cfif>
			 order by kx.date_insert
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os conhecimentos nos grupos logisticos para o periodo
	-- CRISTOFER  05/12/2006
	--->		
	<cffunction name="get_conhecimentos_grupo" access="remote" returntype="query" output="true">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfargument name="cod_remetente" required="no" default="">
		<cfargument name="cod_destinatario" required="no" default="">
		<cfargument name="nf_numero" required="no" default="">
		<cfargument name="num_conhecimento" required="no" default="">
		<cfargument name="ordem_compra" required="no" default="">
		<cfargument name="num_pedido" required="no" default="">
        <cfargument name="cliente_cobranca_somente_grupo" required="no" default="0">
		<cfif len(trim(arguments.nf_numero))>
			<cfquery name="qr_nf" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select conhecimento_id
				  from fiscal.v$conhecimento_nota_fiscal
				 where numero in (#ListQualify(arguments.nf_numero,"'",",")#)
			</cfquery>
		</cfif>
		<cfif len(trim(arguments.ordem_compra))>
			<cfquery name="qr_ordem_compra" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select conhecimento_id
				  from fiscal.v$conhecimento_nota_fiscal
				 where ordem_compra_cliente in (#ListQualify(arguments.ordem_compra,"'",",")#)
			</cfquery>
		</cfif>
		<cfif len(trim(arguments.num_pedido))>
			<cfquery name="qr_pedido" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select c.conhecimento_id
                  from logistica.v$solicitacao_carga sc
                 inner join fiscal.v$conhecimento c
                    on c.solicitacao_carga_id = sc.solicitacao_carga_id
                 where sc.pedido_shipment in (#ListQualify(arguments.num_pedido,"'",",")#)
			</cfquery>
		</cfif>

		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select con.conhecimento_id,
				   con.num_conhecimento,
				   con.data_emissao,
				   con.rem_razao_social remetente,
				   con.rem_cnpj_cpf,
				   con.dest_razao_social destinatario,
				   con.dest_cnpj_cpf,
				   mc.municipio||'-'||mc.uf_id coleta_municipio_uf,
				   me.municipio||'-'||me.uf_id entrega_municipio_uf,
				   (select kss.fnc_concat_all(kss.to_concat_expr(to_char(numero),' / '))
				      from fiscal.v$conhecimento_nota_fiscal cn
					 where cn.conhecimento_id = con.conhecimento_id) notas_fiscais,
				   (select sum(cn.valor_total)
				      from fiscal.v$conhecimento_nota_fiscal cn
					 where cn.conhecimento_id = con.conhecimento_id) valor_fiscal,
				   con.frete_peso,
				   con.pagador,
				   case con.pagador
				      when 0 then 'CIF'
					  when 1 then 'FOB'
					  else ''
				   end cif_fob,
				   con.frete_valor,
				   con.total_conhecimento,
				   con.pedagio,
				   con.valor_icms,
				   con.sec_cat as coleta_entrega,
				   con.DESPACHO,
				   con.peso, 
           		   c.num_pedido,
				   (select kss.fnc_concat_all(kss.to_concat_expr(cnf.ordem_compra_cliente,' / '))
				      from fiscal.v$conhecimento_nota_fiscal cnf
          			 where cnf.conhecimento_id = con.conhecimento_id) ordem_compra,
                   (select sc.pedido_shipment
                      from logistica.v$solicitacao_carga sc
                     where sc.solicitacao_carga_id = con.solicitacao_carga_id) as pedido_shipment,
				   case 
					  when exists (select 'x'
									 from oper.v$coleta col
									where col.carga_id = c.carga_id) then 'Coletada'
					  else 'Entregue'
				   end coletada,
				   
				   con.prazo_entrega,
				   con.data_entrega,
				   r.data_termino_carga,
	               r.situacao_id romaneio_situacao_id,
				   rf.latitude,
	               rf.longitude,
				   r.placa_controle,
				   decode(cd.descricao,'',cep.fnc_municipio_uf(c.municipio_id),'CD: '||cd.descricao) ultima_posicao,
				   rf.landmark,
                   c.situacao_id,
                   
                   (select crc.rv_meaning
                      from oper.cg_ref_codes crc
                     where crc.rv_domain = 'SITUACAO CARGA'
                       and crc.rv_low_value = c.situacao_id) situacao_carga,
                   ct.transferencia_id,
                   to_char(coalesce(ct.data_destino,ct.data_origem,c.date_insert),'dd/mm/yyyy hh24:mi:ss') data_situacao,
                   con.gris as seguro,
                   con.ademe + con.coleta_entrega as outros,
                   con.ALIQUOTA_ICMS as aliquota_icms,
                   (con.FRETE_VALOR / (select sum(cn.valor_total)
                                         from fiscal.v$conhecimento_nota_fiscal cn
                                        where cn.conhecimento_id = con.conhecimento_id)) as ad_valorem,
                   con.peso_real as peso_nf,
                   con.observacao			   
			  from fiscal.v$conhecimento con
			 inner join oper.v$grupo_logistico_usuario glu
					 on glu.usuario = user
	          left join oper.v$carga_ctrc cc
    	             on cc.conhecimento_id = con.conhecimento_id
       		  left join oper.v$carga c
                     on c.carga_id = cc.carga_id
			  left join oper.v$grupo_logistico_carga glc
					 on glc.cod_pessoa_carga = con.cod_remetente
					and glu.grupo_id = glc.grupo_id
			  left join oper.v$grupo_logistico_descarga gld
					 on gld.cod_pessoa_descarga = con.cod_destinatario
					and glu.grupo_id = gld.grupo_id
			 inner join cep.municipio mc
					 on mc.municipio_id = con.coleta_municipio_id
			 inner join cep.municipio me
					 on me.municipio_id = con.entrega_municipio_id
			   left join oper.v$romaneio r
					  on r.num_romaneio = con.NUM_ROMANEIO
			   left join oper.v$rank_frota rf
					  on rf.num_romaneio = r.num_romaneio
		      left join oper.v$centro_distribuicao cd
			         on cd.cod_pessoa_filial = c.cod_filial_atual
              left join oper.v$carga_transferencia ct
                     on ct.carga_id = c.carga_id
                    and ct.transferencia_id_posterior is null
			 where ( con.cod_remetente = glc.cod_pessoa_carga or 
					 con.cod_destinatario = gld.cod_pessoa_descarga)
               and c.data_cancelamento is null
               and con.cancelado is null
			 <cfif len(trim(arguments.cod_remetente)) or len(trim(arguments.cod_destinatario))>
			 	and ( 1=0
				<cfif len(trim(arguments.cod_remetente))>
				   or con.cod_remetente in (#arguments.cod_remetente#)
				</cfif>
				<cfif len(trim(arguments.cod_destinatario))>
				   or con.cod_destinatario in (#arguments.cod_destinatario#)
				</cfif>
					)
			 </cfif>
			 <cfif len(trim(arguments.num_conhecimento))>
			   and con.num_conhecimento in (#arguments.num_conhecimento#)
			 </cfif>
			 <cfif len(trim(arguments.data_inicial))>
			   and trunc(con.data_emissao) >= '#arguments.data_inicial#'
			 </cfif>
			 <cfif len(trim(arguments.data_final))>
			   and trunc(con.data_emissao) <= '#arguments.data_final#'
			 </cfif>
			<cfif len(trim(arguments.nf_numero))>
				<cfif not qr_nf.recordcount>
					and 1=0
				<cfelse>
					and con.conhecimento_id in (#Valuelist(qr_nf.conhecimento_id)#)
				</cfif>				
			</cfif>
			<cfif len(trim(arguments.ordem_compra))>
				<cfif not qr_ordem_compra.recordcount>
					and 1=0
				<cfelse>
					and con.conhecimento_id in (#Valuelist(qr_ordem_compra.conhecimento_id)#)
				</cfif>				
			</cfif>
			<cfif len(trim(arguments.num_pedido))>
				<cfif not qr_pedido.recordcount>
					and 1=0
				<cfelse>
					and con.conhecimento_id in (#Valuelist(qr_pedido.conhecimento_id)#)
				</cfif>				
			</cfif>
            <cfif arguments.cliente_cobranca_somente_grupo eq 1>
             and exists (select 1
                           from oper.v$grupo_logistico_usuario lu
                          inner join oper.v$grupo_logistico_carga la
                          		  on la.grupo_id = lu.grupo_id
                          where lu.usuario = user
                            and la.cod_pessoa_carga = con.cod_cliente_cobranca
                          
                          union all
                          
                         select 1
                           from oper.v$grupo_logistico_usuario lu
                          inner join oper.v$grupo_logistico_descarga ld
                          	      on ld.grupo_id = lu.grupo_id
                          where lu.usuario = user
                            and ld.cod_pessoa_descarga = con.cod_cliente_cobranca
                        )
            </cfif>
			 
			 order by con.data_emissao desc, con.num_conhecimento
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os clientes do grupo logistico carga/descarga
	-- CRISTOFER  05/12/2006
	--->		
	<cffunction name="get_grupo_logistico_cliente" access="remote" returntype="query" output="true">
		<cfargument name="carga" required="no" default="1">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfif lcase(len(trim(arguments.carga))) neq 1>
			select glc.cod_pessoa_descarga cod_pessoa,
				   p.identificador,
				   p.cliente,
                   p.cnpj_cpf
			  from oper.v$grupo_logistico_descarga glc
			 inner join oper.v$grupo_logistico_usuario glu
			         on glu.grupo_id = glc.grupo_id
			 inner join kss.v$pessoa p
					 on p.cod_pessoa = glc.cod_pessoa_descarga
			 where glu.usuario = user
			 order by p.cliente	
			<cfelse>
			select glc.cod_pessoa_carga cod_pessoa,
				   p.identificador,
				   p.cliente,
                    p.cnpj_cpf
			  from oper.v$grupo_logistico_carga glc
			 inner join oper.v$grupo_logistico_usuario glu
			         on glu.grupo_id = glc.grupo_id
			 inner join kss.v$pessoa p
					 on p.cod_pessoa = glc.cod_pessoa_carga
			 where glu.usuario = user
			 order by p.cliente	
			</cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os grupos logisticos do usurio corrente
	-- CRISTOFER  05/12/2006
	--->		
	<cffunction name="get_grupo_logistico" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select gl.grupo_id,
				   gl.descricao
			  from oper.v$grupo_logistico gl
			 inner join oper.v$grupo_logistico_usuario glu
					 on glu.grupo_id = gl.grupo_id
			 where glu.usuario = user
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Relao das naturezas usadas
	-- GUTO 06/01/2007
	--->
	<cffunction name="get_relatorio_belgo_naturezas" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" required="no" default="">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfargument name="cod_cliente_cobranca" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct cnf.num_natureza, n.descricao
					 from fiscal.v$conhecimento c
			 inner join fiscal.v$conhecimento_nota_fiscal cnf
						on c.conhecimento_id = cnf.conhecimento_id
			 inner join oper.v$natureza n
						on n.num_natureza = cnf.num_natureza
			 where 1 = 1
 			   and c.situacao_id = 0
			 <cfif len(trim(arguments.cod_pessoa_filial))>
			   and c.cod_pessoa_filial in (#arguments.cod_pessoa_filial#)
			 </cfif>
			 <cfif len(trim(arguments.cod_cliente_cobranca))>
			   and c.cod_cliente_cobranca in (#arguments.cod_cliente_cobranca#)
			 </cfif>
			 <cfif Len(trim(arguments.data_inicial))>
			   and trunc(c.data_emissao) >= '#arguments.data_inicial#' 
			 </cfif>
			 <cfif Len(trim(arguments.data_final))>
			   and trunc(c.data_emissao) <= '#arguments.data_final#' 
			 </cfif>
--			   and cnf.ordem_compra_cliente is not null
			  order by n.descricao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>


	<!--- 
	-- PROPSITO 
	-- Relatorio modelo 1 da Belgo
	-- CRISTOFER  19/12/2006
	-- PAULO      10/01/2007
	--->
	<cffunction name="get_relatorio_belgo_01" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" required="no" default="">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfargument name="cod_cliente_cobranca" required="no" default="">
		<cfargument name="num_natureza" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cnf.ordem_compra_cliente,
				   case 
                      when instr(cnf.ordem_compra_cliente, '/', 1) > 0 then 
                                    replace(substr(cnf.ordem_compra_cliente, 1, instr(cnf.ordem_compra_cliente, '/', 1)), '/') 
                      else cnf.ordem_compra_cliente                      
				   end transporte,
				   upper(cnf.serie) || ' /' || cnf.numero nota_fiscal,   
				   upper(m.municipio || ' / ' || m.uf_id) cidade,
				   trunc(c.data_emissao) data_carregamento,
				   trunc(cnf.peso) peso,
				   c.km_rota km,
                   case 
                      when instr(cnf.ordem_compra_cliente, '/', 1) > 0 then 
                            replace(substr(cnf.ordem_compra_cliente, instr(cnf.ordem_compra_cliente, '/', 1)), '/') 
                      else '01' 
				   end entregas,
				   c.data_entrega,
				   c.cob_razao_social,
				   c.cod_cliente_cobranca
			  from fiscal.v$conhecimento c
			 inner join fiscal.v$conhecimento_nota_fiscal cnf
					 on c.conhecimento_id = cnf.conhecimento_id
			 inner join cep.municipio m
					 on m.municipio_id = c.entrega_municipio_id
			 where 1=1
			   and c.situacao_id = 0 
			 <cfif len(trim(arguments.cod_pessoa_filial))>
			   and c.cod_pessoa_filial in (#arguments.cod_pessoa_filial#)
			 </cfif>
			 <cfif len(trim(arguments.cod_cliente_cobranca))>
			   and c.cod_cliente_cobranca in (#arguments.cod_cliente_cobranca#)
			 </cfif>
			 <cfif Len(trim(arguments.data_inicial))>
			   and trunc(c.data_emissao) >= '#arguments.data_inicial#' 
			 </cfif>
			 <cfif Len(trim(arguments.data_final))>
			   and trunc(c.data_emissao) <= '#arguments.data_final#' 
			 </cfif>
			 <cfif Len(trim(arguments.num_natureza))>
				  and cnf.num_natureza in (#arguments.num_natureza#)
			 </cfif>
			 order by c.data_emissao, cnf.ordem_compra_cliente
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	<!--- 
	-- PROPSITO 
	-- Relatorio modelo 2 da Belgo
	-- CRISTOFER  20/12/2006
	--->		
	<cffunction name="get_relatorio_belgo_01_txt" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" required="no" default="">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfargument name="cod_cliente_cobranca" required="no" default="">
		<cfargument name="empresa" required="no" default="">
		<cfargument name="filial" required="no" default="">
		<cfargument name="fornecedor" required="no" default="">
		<cfargument name="complemento" required="no" default="0">
    	<cfargument name="num_natureza" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select lpad(trim(cnf.numero),9,'0') nota_fiscal,
                   lpad(' ',1,' ') espaco1,
			 	   lpad('#arguments.empresa#',4,' ') empresa,
	 			   lpad('#arguments.filial#',4,' ') filial,
				   lpad('#arguments.fornecedor#',7,' ') fornecedor,
				   case
                      when c.modelo_documento = '08' then lpad(c.num_conhecimento, 9, '0')
                      else lpad(' ', 9, ' ')
                   end as num_conhecimento,
				   lpad(nvl(c.serie, '0'), 3, '0') serie_ctr,
				   lpad(' ',2,' ') espaco2,
				   lpad(trim(to_char(c.total_conhecimento,'999999999990D00','nls_numeric_characters='',.''')),16,'0') valor_bruto,
	               lpad(trim(to_char(c.total_conhecimento-(c.valor_icms+c.valor_icms_substit),'999999999990D00','nls_numeric_characters='',.''')),16,'0') valor_icms,
				   lpad(trim(to_char(c.aliquota_icms,'00D0','nls_numeric_characters='',.''')),4,'0') aliquota_icms,
				   to_char(c.data_emissao, 'dd.mm.yyyy') data_emissao_nf,
                   case 
					  when c.cfop > 5000 then c.cfop-4000 
					  else c.cfop 
				   end cfop,
				   rpad(m.uf_id,3,' ') regiao,
                   rpad(c.rem_uf,3,' ') regiao_emissor,
                   lpad(' ', 4, ' ') as aliq_iss,
                   case
                      when c.modelo_documento = '57' then lpad(c.num_conhecimento, 9, '0')
                      else lpad(' ', 9, ' ')
                   end as cte,
                   case
                      when c.modelo_documento = '57' then
                         (select substr(d.chave, 4, length(d.chave) - 3)
                            from fiscal.v$documento_cte dc
                           inner join fiscal.v$dacte d
                                   on d.documento_id = dc.documento_id
                           where dc.conhecimento_id = c.conhecimento_id
                         )
                      else lpad(' ', 44, ' ')
                   end as chave_cte,
                   case
                      when c.modelo_documento = '57' then
                         (select d.protocolo
                            from fiscal.v$documento_cte dc
                           inner join fiscal.v$dacte d
                                   on d.documento_id = dc.documento_id
                           where dc.conhecimento_id = c.conhecimento_id
                         )
                      else lpad(' ', 15, ' ')
                   end as protocolo_cte
			  from fiscal.v$conhecimento c
			 inner join fiscal.v$conhecimento_nota_fiscal cnf
					 on c.conhecimento_id = cnf.conhecimento_id
			 inner join cep.municipio m
					 on m.municipio_id = c.entrega_municipio_id	
			 inner join oper.v$belgo b
			         on b.cod_pessoa = c.cod_cliente_cobranca		 			 
			 where 1=1
			   and c.situacao_id = 0 
			 <cfif len(trim(arguments.cod_pessoa_filial))>
			   and c.cod_pessoa_filial in (#arguments.cod_pessoa_filial#)
			 </cfif>
			 <cfif len(trim(arguments.cod_cliente_cobranca))>
			   and c.cod_cliente_cobranca in (#arguments.cod_cliente_cobranca#)
			 </cfif>
			 <cfif Len(trim(arguments.data_inicial))>
			   and trunc(c.data_emissao) >= '#arguments.data_inicial#' 
			 </cfif>
			 <cfif Len(trim(arguments.data_final))>
			   and trunc(c.data_emissao) <= '#arguments.data_final#' 
			 </cfif>
			 <cfif Len(trim(arguments.num_natureza))>
				  and cnf.num_natureza in (#arguments.num_natureza#)
			 </cfif>
			 <cfif arguments.complemento eq 0>
			   and not exists(select 0
			                    from fiscal.v$conhecimento_complemento cc
							   where cc.conhecimento_complemento_id = c.conhecimento_id)
			 <cfelse>
			   and exists(select 0
			                    from fiscal.v$conhecimento_complemento cc
							   where cc.conhecimento_complemento_id = c.conhecimento_id)
			 </cfif>
			 
			order by c.data_emissao, cnf.ordem_compra_cliente
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Relatorio modelo 2 da Belgo
	-- CRISTOFER  20/12/2006
	-- PAULO      10/01/2007
	--->		
	<cffunction name="get_relatorio_belgo_02" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" required="no" default="">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfargument name="cod_cliente_cobranca" required="no" default="">
		<cfargument name="empresa" required="no" default="">
		<cfargument name="filial" required="no" default="">
		<cfargument name="fornecedor" required="no" default="">
		<cfargument name="complemento" required="no" default="0">
    	<cfargument name="num_natureza" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select lpad('#iif(arguments.complemento eq 0,de("1"),de("2"))#',1,'0') complemento,
			 	   lpad(trim(cnf.numero),9,'0') nota_fiscal,
                   lpad(' ',7,' ') espaco1,
			 	   lpad('#arguments.empresa#',4,' ') empresa,
	 			   lpad('#arguments.filial#',4,' ') filial,
                   lpad(' ',4,' ') espaco2,
				   rpad('#arguments.fornecedor#',10,' ') fornecedor,
				   lpad(c.num_conhecimento, 6, '0') num_conhecimento,
				   rpad(c.serie, 2, ' ') serie_ctr,
				   lpad(' ', 1, ' ') subserie_ctr,
				   lpad(to_char(c.total_conhecimento,'99999999990D00','nls_numeric_characters='',.'''),15,' ') valor_bruto,
	               lpad(to_char(nvl(c.valor_icms,0)+nvl(c.valor_icms_substit,0),'999999999990D00','nls_numeric_characters='',.'''),16,' ') valor_icms,
				   lpad(trim(to_char(c.aliquota_icms,'00D0','nls_numeric_characters='',.''')),4,' ') aliquota_icms,
				   to_char(c.data_emissao, 'dd.mm.yyyy') data_emissao_nf,
                   case 
                       when c.cfop = 6352 then 1352
					   when c.cfop > 5000 then c.cfop-4000 
					    else c.cfop 
				   end cfop
			  from fiscal.v$conhecimento c
			 inner join fiscal.v$conhecimento_nota_fiscal cnf
					 on c.conhecimento_id = cnf.conhecimento_id
			 inner join cep.municipio m
					 on m.municipio_id = c.entrega_municipio_id				 
			 where 1=1
			   and c.situacao_id = 0 
			 <cfif len(trim(arguments.cod_pessoa_filial))>
			   and c.cod_pessoa_filial in (#arguments.cod_pessoa_filial#)
			 </cfif>
			 <cfif len(trim(arguments.cod_cliente_cobranca))>
			   and c.cod_cliente_cobranca in (#arguments.cod_cliente_cobranca#)
			 </cfif>
			 <cfif Len(trim(arguments.data_inicial))>
			   and trunc(c.data_emissao) >= '#arguments.data_inicial#' 
			 </cfif>
			 <cfif Len(trim(arguments.data_final))>
			   and trunc(c.data_emissao) <= '#arguments.data_final#' 
			 </cfif>
			 <cfif Len(trim(arguments.num_natureza))>
				  and cnf.num_natureza in (#arguments.num_natureza#)
			 </cfif>
			 <cfif arguments.complemento eq 0>
			   and not exists(select 0
			                    from fiscal.v$conhecimento_complemento cc
							   where cc.conhecimento_complemento_id = c.conhecimento_id)
			 <cfelse>
			   and exists(select 0
			                    from fiscal.v$conhecimento_complemento cc
							   where cc.conhecimento_complemento_id = c.conhecimento_id)
			 </cfif>
			 
			order by c.data_emissao, cnf.ordem_compra_cliente
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Relatorio modelo 3 da Belgo (TRA)
	-- CRISTOFER  20/12/2006
	-- PAULO      10/01/2007
	--->		
	<cffunction name="get_relatorio_belgo_03" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" required="no" default="">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfargument name="cod_cliente_cobranca" required="no" default="">
		<cfargument name="empresa" required="no" default="">
		<cfargument name="filial" required="no" default="">
		<cfargument name="fornecedor" required="no" default="">
		<cfargument name="regiao_tra" required="no" default="">
		<cfargument name="complemento" required="no" default="0">
		<cfargument name="municipio_com_problemas" required="no" default="0">
		<cfargument name="sem_codigo" required="no" default="0">
    	<cfargument name="num_natureza" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select case
          			  when pj.cnpj_ordem = '0005' then '55'
          			  else substr(pj.cnpj_ordem,3,2)
       			   end as filial,
				   lpad(c.num_conhecimento,6,'0') num_conhecimento,
				   lpad(c.serie,1,' ') serie,
				   lpad(' ',1,' ') subserie,
				   lpad('#iif(arguments.complemento eq 0,de("1"),de("2"))#',1,'0') complemento,
				   lpad(cnf.numero,6,'0') nf_venda,
				   lpad(nvl('#arguments.regiao_tra#',' '),2,'0') regiao,
				   to_char(cnf.data_emissao,'yyyymmdd') data_emissao_nf,
				   lpad(c.cfop,4,' ') cfop,
				   lpad(round(c.total_conhecimento*100), 15, '0') valor_bruto,
				   lpad(round((c.total_conhecimento)*100), 15, '0') valor_liquido,
				   lpad(round(c.aliquota_icms*100),4,'0') aliquota_icms,
				   lpad(round((nvl(c.valor_icms,0)+nvl(c.valor_icms_substit,0))*100),17,'0') valor_icms,
				   nvl(to_char(c.prazo_entrega,'yyyymmdd'),'        ') data_entrega,
				   upper(m.uf_id)||nvl(lpad(to_char(m.cod_uf_belgo),2,'0')||lpad(to_char(m.cod_municipio_belgo),4,'0'),'      ') cod_ibge,
				   case 
					 when c.pagador = 0 then 'C'
					 else 'F' 
				   end cif_fob,
				   m.municipio||'-'||m.uf_id municipio,
				   m.municipio_id,
				   case when (m.cod_municipio_belgo is null or m.cod_uf_belgo is null) then 1 else 0 end sem_codigo,
				   m.cod_municipio_belgo,
				   m.cod_uf_belgo
			  from fiscal.v$conhecimento c
			 inner join fiscal.v$conhecimento_nota_fiscal cnf 
			          on c.conhecimento_id = cnf.conhecimento_id
			 inner join cep.municipio m on m.municipio_id = c.entrega_municipio_id
			  left join kss.v$pessoa_juridica pj
					 on pj.cod_pessoa = c.cod_pessoa_filial
			 where 1 = 1
			   and c.situacao_id = 0 
			 <cfif len(trim(arguments.cod_pessoa_filial))>
			   and c.cod_pessoa_filial in (#arguments.cod_pessoa_filial#)
			 </cfif>
			 <cfif len(trim(arguments.cod_cliente_cobranca))>
			   and c.cod_cliente_cobranca in (#arguments.cod_cliente_cobranca#)
			 </cfif>
			 <cfif Len(trim(arguments.data_inicial))>
			   and trunc(c.data_emissao) >= '#arguments.data_inicial#' 
			 </cfif>
			 <cfif Len(trim(arguments.data_final))>
			   and trunc(c.data_emissao) <= '#arguments.data_final#' 
			 </cfif>
			 <cfif arguments.complemento eq 0>
			   and not exists(select 0
			                    from fiscal.v$conhecimento_complemento cc
							   where cc.conhecimento_complemento_id = c.conhecimento_id)
			 <cfelse>
			   and exists(select 0
			                    from fiscal.v$conhecimento_complemento cc
							   where cc.conhecimento_complemento_id = c.conhecimento_id)
			 </cfif>
			 <cfif Len(trim(arguments.num_natureza))>
				  and cnf.num_natureza in (#arguments.num_natureza#)
			 </cfif>
			 <cfif arguments.sem_codigo eq 1>
			   and (m.cod_municipio_belgo is null or m.cod_uf_belgo is null)
			 </cfif>
			 <cfif arguments.municipio_com_problemas eq 1>
			 order by m.municipio, m.uf_id
			 <cfelse>
			 order by c.data_emissao, cnf.ordem_compra_cliente
			 </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Relatorio modelo 4 da Belgo (RVAE)
	-- CRISTOFER  29/12/2006
	-- PAULO 10/01/2006
	--->		
	<cffunction name="get_relatorio_belgo_04" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" required="no" default="">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfargument name="cod_cliente_cobranca" required="no" default="">
		<cfargument name="empresa" required="no" default="">
		<cfargument name="filial" required="no" default="">
		<cfargument name="fornecedor" required="no" default="">
    	<cfargument name="num_natureza" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select lpad('#arguments.empresa#',4,' ') empresa,
				   lpad(nvl('#arguments.filial#',' '),4,'0') regiao,
				   lpad(cnf.numero,9,'0') nf_venda,
                   lpad(nvl('#arguments.serie_nota#',' '),1,' ')||'  ' serie_nota,
				   nvl(to_char(c.data_entrega,'dd.mm.yyyy') || '23:59000','               ') data_entrega,
                   lpad(nvl('#arguments.fornecedor#',' '),7,'0') fornecedor
			  from fiscal.v$conhecimento c
			 inner join fiscal.v$conhecimento_nota_fiscal cnf 
			         on c.conhecimento_id = cnf.conhecimento_id
			 where 1 = 1
			   and c.data_entrega is not null
			   and c.situacao_id = 0 
			 <cfif len(trim(arguments.cod_pessoa_filial))>
			   and c.cod_pessoa_filial in (#arguments.cod_pessoa_filial#)
			 </cfif>
			 <cfif len(trim(arguments.cod_cliente_cobranca))>
			   and c.cod_cliente_cobranca in (#arguments.cod_cliente_cobranca#)
			 </cfif>
			 <cfif Len(trim(arguments.data_inicial))>
			   and trunc(c.data_emissao) >= '#arguments.data_inicial#' 
			 </cfif>
			 <cfif Len(trim(arguments.data_final))>
			   and trunc(c.data_emissao) <= '#arguments.data_final#' 
			 </cfif>
			 <cfif Len(trim(arguments.num_natureza))>
				  and cnf.num_natureza in (#arguments.num_natureza#)
			 </cfif>
			 order by c.data_emissao, cnf.numero
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
	

	<!--- 
	-- PROPSITO 
	-- Relatorio modelo 5 da Belgo (SUCATA)
	-- PAULO      11/01/2007
	--->		
	<cffunction name="get_relatorio_belgo_05" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" required="no" default="">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfargument name="cod_cliente_cobranca" required="no" default="">
		<cfargument name="empresa" required="no" default="">
		<cfargument name="filial" required="no" default="">
		<cfargument name="fornecedor" required="no" default="">
		<cfargument name="regiao_tra" required="no" default="">
		<cfargument name="complemento" required="no" default="0">
    	<cfargument name="num_natureza" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select rpad(lpad(c.rem_cnpj_cpf, 14, '0'), 16, ' ')  cnpj_fornecedor,
  				   lpad(cnf.numero, 9, '0') as nf_fornecedor,
  				   lpad(nvl(cnf.serie, '0'), 3, '0') as nf_serie_fornecedor,
				   b.cod_empresa empresa, 
				   b.regiao centro,
				   rpad(br.cod_belgo, 10, ' ')  transportador,
  				   case
                      when c.modelo_documento = '08' then lpad(c.num_conhecimento, 6, 0)
                      else lpad(' ', 6, ' ')
                   end as num_ctrc,
  				   lpad(nvl(c.serie, '0'), 3, '0') as serie_ctrc,
  				   rpad(' ', 2, ' ') as subserie_ctrc,
				   c.total_conhecimento valor_bruto_formatado,
				   c.total_conhecimento-c.valor_icms valor_liquido_formatado,
				   c.aliquota_icms aliquota_icms_formatado,
				   lpad(trim(to_char(c.total_conhecimento,'999999999990D00','nls_numeric_characters='',.''')), 16, '0') as valor_bruto,
				   lpad(trim(to_char((c.total_conhecimento-c.valor_icms),'999999999990D00','nls_numeric_characters='',.''')), 16, '0') as valor_liquido,
				   rpad(trim(to_char(c.aliquota_icms,'90D0','nls_numeric_characters='',.''')),4,' ') aliquota_icms,				   
  				   to_char(c.data_emissao, 'dd.mm.yyyy') nf_data_emissao,
                   case 
  					  when c.cfop > 5000 then c.cfop-4000 
  					  else c.cfop 
				   end cfop,
				   lpad(nvl(b.regiao_tra, ' '), 3, ' ') as regiao,
                   lpad(' ', 4, ' ') as aliq_iss,
                   case
                      when c.modelo_documento = '57' then lpad(c.num_conhecimento, 9, 0)
                      else lpad(' ', 9, ' ')
                   end as ctre,
                   case
                      when c.modelo_documento = '57' then
                         (select substr(d.chave, 4, length(d.chave) - 3)
                            from fiscal.v$documento_cte dc
                           inner join fiscal.v$dacte d
                                   on d.documento_id = dc.documento_id
                           where dc.conhecimento_id = c.conhecimento_id
                         )
                      else lpad(' ', 44, ' ')
                   end as chave_cte,
                   case
                      when c.modelo_documento = '57' then
                         (select d.protocolo
                            from fiscal.v$documento_cte dc
                           inner join fiscal.v$dacte d
                                   on d.documento_id = dc.documento_id
                           where dc.conhecimento_id = c.conhecimento_id
                         )
                      else lpad(' ', 15, ' ')
                   end as protocolo_cte
			  from fiscal.v$conhecimento c
			 inner join fiscal.v$conhecimento_nota_fiscal cnf 
			         on c.conhecimento_id = cnf.conhecimento_id
			 inner join oper.v$belgo b
			         on b.cod_pessoa = c.cod_cliente_cobranca		 
			 left join oper.v$belgo_rodomar br
			        on c.cod_pessoa_filial = br.cod_pessoa 		 			 
			 where 1 = 1
			   and c.situacao_id = 0 
			 <cfif len(trim(arguments.cod_pessoa_filial))>
			   and c.cod_pessoa_filial in (#arguments.cod_pessoa_filial#)
			 </cfif>
			 <cfif len(trim(arguments.cod_cliente_cobranca))>
			   and c.cod_cliente_cobranca in (#arguments.cod_cliente_cobranca#)
			 </cfif>
			 <cfif Len(trim(arguments.data_inicial))>
			   and trunc(c.data_emissao) >= '#arguments.data_inicial#' 
			 </cfif>
			 <cfif Len(trim(arguments.data_final))>
			   and trunc(c.data_emissao) <= '#arguments.data_final#' 
			 </cfif>
			 <cfif Len(trim(arguments.num_natureza))>
				  and cnf.num_natureza in (#arguments.num_natureza#)
			 </cfif>
			 <cfif arguments.complemento eq 0>
			   and not exists(select '0'
			                    from fiscal.v$conhecimento_complemento cc
							   where cc.conhecimento_complemento_id = c.conhecimento_id)
			 <cfelse>
			   and exists(select '0'
			                    from fiscal.v$conhecimento_complemento cc
							   where cc.conhecimento_complemento_id = c.conhecimento_id)
			 </cfif>
--   			    order by c.data_emissao, cnf.ordem_compra_cliente
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>


	<!--- 
	-- PROPSITO 
	-- Busca Motoristas de um manifesto
	-- WAGNER 20/12/2006
	--->		
	<cffunction name="get_motoristas_manifesto" access="remote" returntype="query" output="true">
		<cfargument name="manifesto_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select 	p.cliente as motorista_nome, p.cnpj_cpf as motorista_cpf,
						pf.cnh_num_registro as motorista_cnh, pf.cart_ident_num as motorista_rg,  pf.cart_ident_orgao as motorista_rg_uf,
						mm.data_inicio, mm.data_termino
				  from oper.v$manifesto_motorista mm
			inner join kss.v$pessoa p
					on p.cod_pessoa = mm.cod_pessoa
			 left join kss.v$pessoa_fisica pf
					on pf.cod_pessoa = p.cod_pessoa 
				 where mm.manifesto_id = #arguments.manifesto_id#
			  order by mm.data_inicio desc
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os dados das empresas belgo
	-- CRISTOFER  20/10/2006
	--->		
	<cffunction name="get_belgo" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select t.cod_pessoa,
				   t.cod_empresa,
				   t.regiao,
				   t.fornecedor,
				   t.regiao_tra,
				   p.identificador,
				   p.cnpj_cpf,
				   p.cliente
			  from oper.v$belgo t
			 inner join kss.v$pessoa p
					 on p.cod_pessoa = t.cod_pessoa
			 order by p.identificador
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
 

	<!--- 
	-- PROPSITO 
	-- Busca os ctrc nao entregues
	-- CRISTOFER  29/12/2006
	--->		
	<cffunction name="get_ctrc_sem_entrega" access="remote" returntype="query" output="true">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfargument name="cod_cliente_cobranca" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select p.cliente filial,
				   c.num_conhecimento,
				   c.serie,
				   c.data_emissao,
				   c.rem_razao_social,
				   cep.fnc_municipio_uf(c.coleta_municipio_id) coleta_municipio_uf,
				   c.dest_razao_social,
				   cep.fnc_municipio_uf(c.entrega_municipio_id) entrega_municipio_uf
			  from fiscal.v$conhecimento c
			 inner join kss.v$pessoa p 
					 on p.cod_pessoa = c.cod_pessoa_filial
			 where c.data_entrega is null
			 <cfif len(trim(arguments.cod_cliente_cobranca))>
			   and c.cod_cliente_cobranca in (#arguments.cod_cliente_cobranca#)
			 </cfif>
			 <cfif Len(trim(arguments.data_inicial))>
			   and trunc(c.data_emissao) >= '#arguments.data_inicial#' 
			 </cfif>
			 <cfif Len(trim(arguments.data_final))>
			   and trunc(c.data_emissao) <= '#arguments.data_final#' 
			 </cfif>
			 order by p.cliente, c.data_emissao, c.num_conhecimento, c.serie
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Lista os conhecimentos internacionais
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 02/12/2005 - criado
	--->	
	<cffunction name="get_belgo_rodomar" displayname="Lista os conhecimentos internacionais" access="remote" returntype="query" output="true">
		<cfargument name="nome" required="no" default="">
		<cfargument name="cod_empresa" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select f.cod_pessoa,
				   f.razao_social,
				   f.nome,
				   f.identificador,
				   f.cnpj_cpf,
				   f.inscricao_estadual,
				   f.endereco,
				   f.bairro,
				   f.cep,
				   f.municipio,
				   f.uf,
				   f.municipio_uf,
				   f.municipio_id,
				   f.telefone,
				   f.pais_id,
				   f.pais,
				   f.filial, 
				   f.cod_empresa,
				   br.cod_belgo
			  from oper.v$filial f
			  left join oper.v$belgo_rodomar br
			         on f.cod_pessoa = br.cod_pessoa
			 where 1=1
			 <cfif len(trim(arguments.nome))>
			   and upper(razao_social) like upper('%#arguments.nome#%')
			 </cfif>
			 <cfif len(trim(arguments.cod_empresa))>
			   and cod_empresa = '#arguments.cod_empresa#'
			 </cfif>
		     order by nome, razao_social, municipio_uf			 
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Lista de Itinerrios vinculados a placa de carreta.
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 02/12/2005 - criado
	--->	
	<cffunction name="get_itinerario_placa_referencia" displayname="Lista os conhecimentos internacionais" access="remote" returntype="query" output="true">
		<cfargument name="placa_referencia" required="no" default="">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
		    select rit.itinerario_id,
				   rit.num_romaneio, 
				   roi.item_id,
				   rit.placa_referencia,
				   rit.origem_municipio_id,
		   		   mo.municipio || '/' || mo.uf_id as origem,
				   rit.destino_municipio_id,
		   		   md.municipio || '/' || md.uf_id as destino,
			  	   rit.rota_id,
				   rit.km_rota,
				   rot.abreviatura,
				   rit.data_previsao,
				   rit.data_chegada,
				   rit.itinerario_id_anterior,
				   rit.itinerario_id_posterior,
				   rit.vazio_carregado,
				   decode(rit.vazio_carregado,0,'Vazio',1,'Carregado') as desc_vazio_carregado,
				   nvl(rot.descricao_rota,cep.fnc_cidade_completa(rit.origem_municipio_id)) as descricao_rota,
				   rot.abreviatura,
				   rit.itinerario_id_anterior,
			       rit.itinerario_id_posterior,
				   rit.ordem, ri.num_lote, l.internacional,
		           oper.pkg_itinerario.fnc_verifica_romaneio(r.num_romaneio) as romaneio_ok
			  from oper.v$romaneio r
		 inner join (select iti.rota_id , iti.itinerario_id, iti.num_romaneio, iti.vazio_carregado,
						iti.origem_municipio_id, iti.destino_municipio_id, iti.itinerario_id_posterior,
						iti.itinerario_id_anterior, level ordem_level, iti.ordem,
						iti.data_chegada, iti.data_previsao, iti.km_rota, iti.placa_referencia
				   from oper.v$romaneio_itinerario iti
				  start with iti.itinerario_id = oper.pkg_itinerario.fnc_itinerario_data('#arguments.placa_referencia#','#arguments.data_inicial#')
				connect by iti.itinerario_id = prior iti.itinerario_id_posterior) rit
					 on rit.num_romaneio = r.num_romaneio
		inner join cep.municipio mo
				on mo.municipio_id = rit.origem_municipio_id
		inner join cep.municipio md
				on md.municipio_id = rit.destino_municipio_id
		left join oper.v$romaneio_item ri
			   on ri.itinerario_id = rit.itinerario_id
		left join oper.v$lote l
			   on l.num_lote = ri.num_lote
		 left join oper.v$rota rot
				on rot.rota_id = rit.rota_id 
		 left join oper.v$romaneio_item roi
		         on roi.itinerario_id = rit.itinerario_id
			 where 1=1
		  order by rit.ordem_level
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Relao de faturas e ctrc's
	-- NOTAS EXPLICATIVAS
	--  
	-- LOUIS 05/07/2007 - criado
	--->	
	<cffunction name="get_fatura_ctrc" displayname="Relao de faturas e ctrc's" access="remote" returntype="query" output="true">
        <cfargument name="num_docto" required="no" default="">
        <cfargument name="data_inicial" required="no" default="">
        <cfargument name="data_final" required="no" default="">
        <cfargument name="data_emissao_inicial" required="no" default="">
        <cfargument name="data_emissao_final" required="no" default="">
		<cfargument name="cod_pessoa" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
        select r.num_docto,
               trunc(c.data_emissao) data_emissao,
               trunc(r.data_vencto) data_vencto,
               r.valor_docto,
               c.num_conhecimento,
               c.serie,
               c.data_emissao,
               c.dest_razao_social,
               c.dest_municipio,
               c.dest_uf,
               c.total_conhecimento,
               c.aliquota_icms,
               c.base_calculo_icms,
               c.valor_icms,
               c.pedagio as valor_pedagio,
               pf.cnpj_cpf cnpj_cpf_filial,
               pf.cliente filial,
               c.peso,
               case
                  when c2.num_conhecimento is not null then 1
                  else 0
               end complementar,
               c2.num_conhecimento num_conhecimento_compl,
               c2.serie serie_compl,
               case 
                  when c.cod_remetente in (#arguments.cod_pessoa#) then (select p1.cnpj_cpf
                                                                           from kss.v$pessoa p1
                                                                          where p1.cod_pessoa = c.cod_remetente)
                  when c.cod_destinatario in (#arguments.cod_pessoa#) then (select p1.cnpj_cpf
                                                                              from kss.v$pessoa p1
                                                                             where p1.cod_pessoa = c.cod_destinatario)
                  else null
               end filial_cliente,
               case 
                  when c.cod_remetente in (#arguments.cod_pessoa#) then 'Saida'
                  when c.cod_destinatario in (#arguments.cod_pessoa#) then 'Entrada'
                  else null
               end tipo_nf,

               (select kss.fnc_concat_all(to_concat_expr(numero||'-'||serie,','))
                  from fiscal.v$conhecimento_nota_fiscal cnf
                 where cnf.conhecimento_id = c.conhecimento_id) notas_fiscais,
               (select kss.fnc_concat_all(to_concat_expr(numero,','))
                  from fiscal.v$conhecimento_nota_fiscal cnf
                 where cnf.conhecimento_id = c.conhecimento_id) notas_fiscais_sem_serie
          from finan.v$finan_contas_receber r
         inner join fiscal.v$conhecimento_receber cr 
         	     on r.contas_receber_id = cr.contas_receber_id
         <cfif len(trim(arguments.cod_pessoa))>
         inner join finan.v$ccorrente cc
                 on cc.cod_conta = r.cc_sacado
                and cc.cod_pessoa in (#arguments.cod_pessoa#)
         </cfif>
         inner join fiscal.v$conhecimento c 
         	     on cr.conhecimento_id = c.conhecimento_id
         inner join kss.v$pessoa pf 
         	     on c.cod_pessoa_filial = pf.cod_pessoa
          left join fiscal.v$conhecimento_complemento cc1
                 on cc1.conhecimento_complemento_id = c.conhecimento_id
          left join fiscal.v$conhecimento c2
                 on c2.conhecimento_id = cc1.conhecimento_id
              where 1=1 --r.docto_id = 'DP' -- Alterado por Marcel
          <cfif len(trim(arguments.data_inicial)) and len(trim(arguments.data_final))>
               and trunc(r.data_emissao) between '#arguments.data_inicial#' and '#arguments.data_final#'
          </cfif>
          <cfif len(trim(arguments.data_emissao_inicial)) and len(trim(arguments.data_emissao_final))>
               and trunc(c.data_emissao) between '#arguments.data_emissao_inicial#' and '#arguments.data_emissao_final#'
          </cfif>
          <!---<cfif len(trim(arguments.cod_pessoa))>
               and exists
              (select 0
                      from finan.v$ccorrente cc
                     where cc.cod_conta = r.cc_sacado
                       and cc.cod_pessoa in (#arguments.cod_pessoa#))
          </cfif>--->
          <cfif len(trim(arguments.num_docto))>
              and r.num_docto in ('#arguments.num_docto#')
          </cfif>
			 order by num_docto, num_conhecimento
          </cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>
    
        <!--- 
	-- PROPSITO
	-- Relao de faturas e ctrc's
	-- NOTAS EXPLICATIVAS
	--  
	-- LOUIS 05/07/2007 - criado
	--->	
	<cffunction name="get_ctrc_fatura" displayname="Relao de faturas e ctrc's" access="remote" returntype="query" output="true">
        <cfargument name="num_docto" required="no" default="">
        <cfargument name="data_inicial" required="no" default="">
        <cfargument name="data_final" required="no" default="">
        <cfargument name="data_emissao_inicial" required="no" default="">
        <cfargument name="data_emissao_final" required="no" default="">
		<cfargument name="cod_pessoa" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
            select r.num_docto,
                   trunc(c.data_emissao) data_emissao,
                   trunc(r.data_vencto) data_vencto,
                   r.valor_docto,
                   c.num_conhecimento,
                   c.serie,
                   c.data_emissao,
                   c.dest_razao_social,
                   c.dest_municipio,
                   c.dest_uf,
                   c.total_conhecimento,
                   c.aliquota_icms,
                   c.base_calculo_icms,
                   c.valor_icms,
                   c.pedagio as valor_pedagio,
                   pf.cnpj_cpf cnpj_cpf_filial,
                   pf.cliente filial,
                   c.peso,
                   case
                      when c2.num_conhecimento is not null then 1
                      else 0
                   end complementar,
                   c2.num_conhecimento num_conhecimento_compl,
                   c2.serie serie_compl,
                   case 
                      when c.cod_remetente in (#arguments.cod_pessoa#) then (select p1.cnpj_cpf
                                                                               from kss.v$pessoa p1
                                                                              where p1.cod_pessoa = c.cod_remetente)
                      when c.cod_destinatario in (#arguments.cod_pessoa#) then (select p1.cnpj_cpf
                                                                                  from kss.v$pessoa p1
                                                                                 where p1.cod_pessoa = c.cod_destinatario)
                      else null
                   end filial_cliente,
                   case 
                      when c.cod_remetente in (#arguments.cod_pessoa#) then 'Saida'
                      when c.cod_destinatario in (#arguments.cod_pessoa#) then 'Entrada'
                      else null
                   end tipo_nf,
    
                   (select kss.fnc_concat_all(to_concat_expr(numero||'-'||serie,','))
                      from fiscal.v$conhecimento_nota_fiscal cnf
                     where cnf.conhecimento_id = c.conhecimento_id) notas_fiscais,
                   (select kss.fnc_concat_all(to_concat_expr(numero,','))
                      from fiscal.v$conhecimento_nota_fiscal cnf
                     where cnf.conhecimento_id = c.conhecimento_id) notas_fiscais_sem_serie
              from fiscal.v$conhecimento c 
              left join fiscal.v$conhecimento_receber cr 
                     on cr.conhecimento_id = c.conhecimento_id
              left join finan.v$finan_contas_receber r
                     on r.contas_receber_id = cr.contas_receber_id
                    and r.docto_id = 'DP'
             inner join kss.v$pessoa pf 
                     on c.cod_pessoa_filial = pf.cod_pessoa
              left join fiscal.v$conhecimento_complemento cc1
                     on cc1.conhecimento_complemento_id = c.conhecimento_id
              left join fiscal.v$conhecimento c2
                     on c2.conhecimento_id = cc1.conhecimento_id
             where 1=1
			   and c.situacao_id = 0
             <cfif len(trim(arguments.cod_pessoa))>
			   and (c.cod_remetente in (#arguments.cod_pessoa#) or c.cod_destinatario in (#arguments.cod_pessoa#))
             </cfif> 
              <cfif len(trim(arguments.data_inicial)) and len(trim(arguments.data_final))>
                   and trunc(r.data_emissao) between '#arguments.data_inicial#' and '#arguments.data_final#'
              </cfif>
              <cfif len(trim(arguments.data_emissao_inicial)) and len(trim(arguments.data_emissao_final))>
                   and trunc(c.data_emissao) between '#arguments.data_emissao_inicial#' and '#arguments.data_emissao_final#'
              </cfif>
              <!---<cfif len(trim(arguments.cod_pessoa))>
                   and exists
                  (select 0
                          from finan.v$ccorrente cc
                         where cc.cod_conta = r.cc_sacado
                           and cc.cod_pessoa in (#arguments.cod_pessoa#))
              </cfif>--->
              <cfif len(trim(arguments.num_docto))>
                  and r.num_docto in ('#arguments.num_docto#')
              </cfif>
                 order by num_docto, num_conhecimento
          </cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>


	<!--- 
	-- PROPSITO 
	-- Busca o resumo de cargas
	-- CRISTOFER  20/10/2008
	--->		
	<cffunction name="get_carga_resumo" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select c.cod_filial_atual, 
                   p.CLIENTE as filial,
                   c.situacao_id,
                   cg.rv_abbreviation as situacao,
                   count(*) total_situacao, 
                   sum(count(*)) over (partition by c.cod_filial_atual) total_filial,
                   sum(count(*)) over () total_geral
              from oper.v$carga c
             inner join kss.v$pessoa p
                     on p.cod_pessoa = c.cod_filial_atual
             inner join oper.cg_ref_codes cg
                     on cg.rv_low_value = c.situacao_id
                    and cg.rv_domain = 'SITUACAO CARGA'
             where 1=1
               and c.situacao_id not in (4,5,8)
             group by c.situacao_id, cod_filial_atual, cg.rv_abbreviation, p.cliente
             order by p.cliente, situacao_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as situaes das Cargas
	-- CRISTOFER  20/10/2008
	--->		
	<cffunction name="get_carga_situacao" access="remote" returntype="query" output="true">
    	<cfargument name="situacao_id_not_in" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cg.rv_low_value as id,
            	   cg.rv_abbreviation as situacao
              from oper.cg_ref_codes cg
             where cg.rv_domain = 'SITUACAO CARGA'
             <cfif len(trim(arguments.situacao_id_not_in))>
               and cg.rv_low_value not in (#arguments.situacao_id_not_in#)
             </cfif>
             order by cg.rv_low_value 
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os manifestos vinculados ao mesmo romaneio
	-- CRISTOFER  29/10/2008
	--->		
	<cffunction name="get_manifestos_romaneio_manifesto" access="remote" returntype="query" output="true">
    	<cfargument name="num_manifesto" required="no" default="">
    	<cfargument name="cod_pessoa_filial" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select distinct m2.manifesto_id,
                   m2.num_manifesto,
                   m2.cod_pessoa_filial,
                   p.cliente as filial,
                   cep.fnc_municipio_uf(m2.org_municipio_id) origem,
                   cep.fnc_municipio_uf(m2.dest_municipio_id) destino,
                   to_char(m2.data_inicio,'dd/mm/yyyy hh24:mi:ss') as data_inicio,
                   to_char(m2.data_termino,'dd/mm/yyyy hh24:mi:ss') as data_termino,
                   oper.pkg_veiculo.fnc_get_cod_veiculo(m2.placa_tracao) frota_tracao,
                   oper.pkg_veiculo.fnc_get_cod_veiculo(m2.placa_reboque) frota_reboque,
                   m2.situacao_id,
                   cg.rv_abbreviation as situacao
              from oper.v$manifesto m
             inner join oper.v$manifesto_conhecimento mc 
             		 on mc.manifesto_id = m.manifesto_id
             inner join fiscal.v$conhecimento c 
             		 on c.conhecimento_id = mc.conhecimento_id
             inner join fiscal.v$conhecimento c2 
             		 on c2.num_romaneio = c.num_romaneio
             inner join oper.v$manifesto_conhecimento mc2 
             		 on mc2.conhecimento_id = c2.conhecimento_id
             inner join oper.v$manifesto m2 
             		 on m2.manifesto_id = mc2.manifesto_id
             inner join oper.cg_ref_codes cg
                     on cg.rv_low_value = m2.situacao_id
                    and cg.rv_domain = 'MANIFESTO.SITUACAO_ID'
             inner join kss.v$pessoa p 
                     on p.cod_pessoa = m2.cod_pessoa_filial
             where m.num_manifesto = #arguments.num_manifesto#
               and m.cod_pessoa_filial = #arguments.cod_pessoa_filial#
               and not exists (select 0
                                 from oper.v$contrato_transp ct
                                where ct.manifesto_id = m2.manifesto_id)
               and m2.manifesto_id <> m.manifesto_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
    -- PROPSITO
    -- Busca os municipios do Romaneio
    -- 15/12/2008 - criado
    --->	
    <cffunction name="get_romaneio_municipios" displayname="" output="true" returntype="query" access="remote">
    	<cfargument name="num_romaneio" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            with x as (select #arguments.num_romaneio# from dual)
            select sum(coleta) as coletas,
                   sum(entrega) as entregas,
                   num_romaneio,
                   municipio_id,
                   cep.fnc_municipio_uf(municipio_id) as municipio
              from (
                    /* NF_ES_FRETE */
                    select 1 as coleta,
                           0 as entrega,
                           num_romaneio, 
                           coleta_municipio_id as municipio_id
                      from fiscal.v$nf_es_frete nfes
                     where num_romaneio in (select * from x)
                    union all
                    select 0 as coleta,
                           1 as entrega,
                           num_romaneio, 
                           entrega_municipio_id as municipio_id
                      from fiscal.v$nf_es_frete nfes
                     where num_romaneio in (select * from x)
                    union all
                    
                    /* CONHECIMENTOS CARGA SECA */
                    select 1 as coleta,
                           0 as entrega,
                           num_romaneio, 
                           coleta_municipio_id as municipio_id
                      from fiscal.v$conhecimento con
                     inner join fiscal.v$conhecimento_outros_dados co
                             on co.conhecimento_id = con.conhecimento_id
                            and co.tipo_venda = 1
                     where num_romaneio in (select * from x)
                    union all
                    select 0 as coleta,
                           1 as entrega,
                           num_romaneio, 
                           entrega_municipio_id as municipio_id
                      from fiscal.v$conhecimento con
                     inner join fiscal.v$conhecimento_outros_dados co
                             on co.conhecimento_id = con.conhecimento_id
                            and co.tipo_venda = 1
                     where num_romaneio in (select * from x)
            
                     /* MANIFESTOS */
                    union all
                    select 1 as coleta,
                           0 as entrega,
                           num_romaneio,
                           org_municipio_id
                      from oper.v$manifesto man
                     inner join oper.v$romaneio_item ri
                             on man.roo_item_id = ri.ITEM_ID
                     where ri.NUM_ROMANEIO in (select * from x)
                    union all
                    select 0 as coleta,
                           1 as entrega,
                           num_romaneio,
                           man.dest_municipio_id
                      from oper.v$manifesto man
                     inner join oper.v$romaneio_item ri
                             on man.roo_item_id = ri.ITEM_ID
                     where ri.NUM_ROMANEIO in (select * from x)
                     
                    )
             group by num_romaneio, municipio_id
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Busca os dados do veicuo do Conhecimento
    -- 17/03/2009 - criado
    --->	
    <cffunction name="get_conhecimento_dados_veiculo" displayname="" output="true" returntype="query" access="remote">
    	<cfargument name="conhecimento_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select conhecimento_id,
                   num_conhecimento,
                   placa,
                   placa_tracao,
                   oper.pkg_veiculo.FNC_GET_PLACA(placa) as cod_veiculo,
                   oper.pkg_veiculo.FNC_GET_PLACA(placa_tracao) as cod_veiculo_tracao,
                   nome_motorista as motorista,
                   prop_razao_social as proprietario
              from fiscal.v$conhecimento 
             where 1=1
             <cfif len(trim(arguments.conhecimento_id))>
               and conhecimento_id = #arguments.conhecimento_id#
             </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Busca dados da listagem de troca de motorista
    -- JONAS 08/06/2009 - criado
    --->	
    <cffunction name="get_motorista_troca" displayname="" output="true" returntype="query" access="remote">
      <cfargument name="rb_data" required="no" default="">
    	<cfargument name="recebimento_data_inicial" required="no" default="">
      <cfargument name="recebimento_data_final" required="no" default="">
      <cfargument name="entrega_data_inicial" required="no" default="">
      <cfargument name="entrega_data_final" required="no" default="">
    	<cfargument name="placa" required="no" default="">
      <cfargument name="cod_pessoa" required="no" default="">
      <cfargument name="operacao_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
         select /*+ORDERED*/vm.placa, vm.cod_pessoa as motorista,
                kss.pkg_pessoa.fnc_get_cliente(vm.cod_pessoa) as nome_motorista, 
                vm.km_inicio, to_char(vm.data_inicio,'dd/mm/yyyy') as data_inicio, vm.km_fim, to_char(vm.data_fim,'dd/mm/yyyy') as data_fim,
                vm.km_inicio, to_char(vm.data_inicio,'dd/mm/yyyy HH:mm') as data_hora_inicio, vm.km_fim, to_char(vm.data_fim,'dd/mm/yyyy HH:mm') as data_hora_fim, 
                vm.evo_id_recebimento, 
                vm.evo_id_entrega, 
                oper.pkg_global.fnc_get_cod_funcionario(vm.cod_pessoa) as cod_func_rh,
                decode(oper.pkg_global.fnc_get_parametro(202,'LOGISTICA'),2,substr(v.placa, 1, 3) || '-' ||  substr(v.placa, 4, 4),1,v.cod_veiculo) veiculo,
                vm.placa||vm.cod_pessoa||vm.km_inicio||vm.data_inicio as keyfield,
                oper.pkg_global.fnc_tempo_formatado(((nvl(vm.data_fim, sysdate) - vm.data_inicio)*60*60*24)) dias_trabalhados
              , nvl(vm.km_fim,(select nvl(km,0)
                                from oper.v$veiculo_ultimo_km
                               where placa = vm.placa) ) - vm.km_inicio km_rodado,
                (select va.modalidade
                   from oper.v$veiculo_modalidade_atual va
                  where va.placa = vm.placa) modalidade
              , dedicado.to_operacao_dados(fo.operacao_id).nome_completo as operacao
           from oper.v$veiculo_motorista vm
          inner join oper.v$veiculo v
                  on v.placa = vm.placa
          <cfif Len(Trim(arguments.operacao_id))>
          inner join dedicado.v$operacao_funcionario fo
                  on fo.cod_pessoa = vm.cod_pessoa
                 and vm.data_inicio between fo.data_inicio and nvl(fo.data_termino, vm.data_inicio)
          <cfelse>
          left join dedicado.v$operacao_funcionario fo
                 on fo.cod_pessoa = vm.cod_pessoa
                and vm.data_inicio between fo.data_inicio and nvl(fo.data_termino, vm.data_inicio)
          </cfif>
          where 1 = 1
          	<!--- Filtra Motorista --->
            <cfif Len(Trim(arguments.cod_pessoa))>
            and vm.cod_pessoa = #arguments.cod_pessoa#
            </cfif> 
            <!--- Filtra Veculo --->
            <cfif Len(Trim(arguments.placa))>
            and vm.placa = '#arguments.placa#'
            </cfif>
            <!--- Filtra Intervalo de data recebimento --->
            <cfif (arguments.rb_data eq 'recebimento') and Len(Trim(arguments.recebimento_data_inicial)) and Len(Trim(arguments.recebimento_data_final))>
            and vm.data_inicio between to_date('#arguments.recebimento_data_inicial# 00:00:00') and to_date('#arguments.recebimento_data_final# 23:59:59')
            </cfif>
            <!--- Filtra Intervalo de data entrega --->
            <cfif (arguments.rb_data eq 'entrega') and Len(Trim(arguments.entrega_data_inicial)) and Len(Trim(arguments.entrega_data_final))>
            and vm.data_inicio between to_date('#arguments.entrega_data_inicial# 00:00:00') and to_date('#arguments.entrega_data_final# 23:59:59')
            </cfif>
            <!--- Filtra Operao dedicada --->
            <cfif Len(Trim(arguments.operacao_id))>
            and fo.operacao_id = #arguments.operacao_id#
            </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Busca referencias geograficas
    -- JONAS 10/06/2009 - criado
    --->	
    <cffunction name="get_referencia_geografica" displayname="" output="true" returntype="query" access="remote">
      <cfargument name="referencia_id" required="no" default="">
      <cfargument name="referencia" required="no" default="">      
      <cfargument name="classe" required="no" default="">            
      <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
         select /*+FIRST_ROWS*/ r.referencia_id, r.referencia,
					 oper.pkg_coord_geografica.fnc_formata_graus(oper.pkg_coord_geografica.fnc_decimais2graus(r.latitude,0)) graus_latitude,
                oper.pkg_coord_geografica.fnc_formata_graus(oper.pkg_coord_geografica.fnc_decimais2graus(r.longitude, 1)) graus_longitude,
                r.latitude as latitude,
                r.longitude as longitude,
                rc.classe
           from oper.v$referencia r
          inner join rastreador.v$referencia_classe rc on rc.classe_id = r.classe_id
          where 1=1
         <!--- lower(r.referencia) like lower('Ponta%')--->
          <cfif Len(Trim(arguments.referencia_id))>
          	and r.referencia_id = #arguments.referencia_id#
          </cfif>
          <cfif Len(Trim(arguments.referencia))>          	
          	and lower(r.referencia) like lower('#arguments.referencia#%')
          </cfif>
          <cfif Len(Trim(arguments.classe))>
          	and lower(rc.classe) like lower('#arguments.classe#%')
          </cfif>
			 <!---order by r.referencia     --->    
          
      </cfquery>
      <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Busca referencia geografica de evento
    -- JONAS 10/06/2009 - criado
    --->	
    <cffunction name="get_referencia_geografica_evento" displayname="" output="true" returntype="query" access="remote">
      <cfargument name="controle_evo_id" required="yes">
      <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        select eo.local, eo.latitude, eo.longitude, eo.referencia_id
          from oper.v$evento_operacao eo
         where 1=1
           and eo.controle_evo_id = #arguments.controle_evo_id#
      </cfquery>
      <cfreturn qr_result>
    </cffunction>

	<!--- 
	-- PROPSITO
	-- Retorna dados do veculo, por default somente trao
	-- NOTAS EXPLICATIVAS
	-- jonas 13/06/2009 - criado
	--->	
	<cffunction name="get_veiculo_tracao" displayname="Retorna dados do veculo" output="false" returntype="query" access="remote">
		<cfargument name="placa" required="no" default="">
		<cfargument name="cod_veiculo" required="no" default="">      
      
      <!--- 0=no busca terceiros e 1=busca terceiros --->
		<cfquery name="qr_terceiro" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select kss.pkg_global.fnc_obtem_parametro_str(11, 'OPERACIONAL', 17, 211) valor from dual
		</cfquery>
      <cfdump var="#qr_terceiro#">
      <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
         select v.cod_veiculo,
                v.placa,
                (select va.modalidade
                   from oper.v$veiculo_modalidade_atual va
                  where va.placa = v.placa) modalidade
           from oper.v$veiculo v
          <cfif qr_terceiro.valor eq 0>
          inner join oper.v$veiculo_frota_geral vfg
                  on v.placa = vfg.placa
          </cfif>
          inner join oper.v$veiculo_tipo_carroceria vtc
                  on vtc.tipo_carroceria_id = v.tipo_carroceria_id
          inner join oper.v$veiculo_agrupamento va
                  on va.agrupamento_id = vtc.agrupamento_id
                 and va.tracao = 1
                 and va.controla = 1
          <!-----inner join oper.veiculo_hist_situacao vhs
          --        on vhs.placa = v.placa
          --      and vhs.situacao_id = 1  --->
         where 1=1
			<cfif Len(Trim(arguments.placa))>
			   and v.placa like upper('%#arguments.placa#%')
			</cfif>		
			<cfif Len(Trim(arguments.cod_veiculo))>
			   and upper(v.cod_veiculo) like upper('#arguments.cod_veiculo#%')
			</cfif>        
         order by v.cod_veiculo
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
   
   <!--- 
	-- PROPSITO 
	-- Busca motoristas 
	-- Jonas  13/06/2009
	--->
	<cffunction name="get_motorista" displayname="Busca os motoristas" access="remote" returntype="query" output="true">
   	<cfargument name="nome" displayname="Nome do Motorista" required="no" default="">
      <cfargument name="cod_motorista" displayname="Codigo Pessoa do Motorista" required="no" default="">
      <cfargument name="cod_funcionario" displayname="Codigo de funcionario" required="no" default="">
      <!--- qr_terceiro.valor : 0=no busca terceiros e 1=busca terceiros --->
		<cfquery name="qr_terceiro" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select kss.pkg_global.fnc_obtem_parametro_str(11, 'OPERACIONAL', 17, 211) valor from dual
		</cfquery>
		<cfquery name="qr_pessoa_fisica" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select 
                   oper.pkg_global.fnc_get_cod_funcionario(p.cod_pessoa) cod_funcionario,
                   p.razao_social as nome,
                   p.cod_pessoa, rownum as ordem
              from kss.v$pessoa p
             inner join kss.v$pessoa_modalidade pm
                     on pm.cod_pessoa = p.cod_pessoa
                     and pm.situacao = 1
                     <cfif qr_terceiro.valor eq 0>
                     and pm.num_modalidade in (2,6)
                     <cfelse>
                     and pm.num_modalidade in (2,6,8)
                     </cfif>
             where 
             1=1
             <cfif Len(Trim(arguments.cod_funcionario))>
               and p.cod_pessoa = oper.pkg_global.fnc_get_cod_pessoa_func(#arguments.cod_funcionario#)
             </cfif>
             <cfif Len(Trim(arguments.nome))>
	             and upper(p.razao_social) like upper('#arguments.nome#%')
             </cfif>
             <cfif Len(Trim(arguments.cod_motorista))>
               and p.cod_pessoa = #arguments.cod_motorista#
             </cfif>             
             order by ordem
            <!--- 
             
             
            select t.cod_pessoa,
            	   t.nome,
                   t.cod_registro
               from (select pf.cod_pessoa,
                            pf.nome,
                           (select mrh.cod_registro
                              from oper.v$motorista_reg_historico mrh
                where mrh.cod_pessoa = pf.cod_pessoa
                  and mrh.data_inicio = (select max(mrh2.data_inicio)
                from oper.v$motorista_reg_historico mrh2
                    where mrh2.cod_pessoa = mrh.cod_pessoa)) as cod_registro
                    from oper.v$pessoa_fisica pf
                        where exists (select mrh.cod_registro
                        from oper.v$motorista_reg_historico mrh
                        where mrh.cod_pessoa = pf.cod_pessoa
                          and mrh.data_inicio = (select max(mrh2.data_inicio)
                        from oper.v$motorista_reg_historico mrh2
                        where mrh2.cod_pessoa = mrh.cod_pessoa))) t
                        where 1 = 1
                        <cfif Len(Trim(arguments.nome))>
                        	and upper(t.nome) like upper('#arguments.nome#%')
                        </cfif>
								<cfif Len(Trim(arguments.cod_motorista))>
                        	and t.cod_pessoa = #arguments.cod_motorista#
                        </cfif>
                        <cfif Len(Trim(arguments.codigo_motorista))>
                        	and t.cod_registro = #arguments.codigo_motorista#
                        </cfif>--->
        </cfquery>
        <cfreturn qr_pessoa_fisica>
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Verifica se ja exista cargas para o remetente/nota fiscal
	-- NOTAS EXPLICATIVAS
	-- FABIOG 29/04/2011 - criado
	--->	
	<cffunction name="get_cargas_rem_nota" output="false" returntype="query" access="remote">
		<cfargument name="rem_cod_pessoa" required="yes">
		<cfargument name="nf_numero" required="yes">      
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
       		select c.carga_id 
            	 , kss.pkg_pessoa.fnc_get_cliente(c.rem_cod_pessoa)as remetente
     			 , kss.pkg_pessoa.fnc_get_cliente(c.dest_cod_pessoa)as destinatario
                 , to_char(nf.nf_data_emissao, 'dd/mm/yyyy hh24:MM') as nf_data_emissao
                 , nf.nf_numero
              from oper.v$carga c
             inner join oper.v$carga_nf nf
                     on nf.carga_id = c.carga_id
             where c.rem_cod_pessoa = #arguments.rem_cod_pessoa#
               and nf.nf_numero = #arguments.nf_numero#       
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna o XML de Envio de um CTe
    -- RAFAEL 24/01/2011 - CRIADO
    --->		
    <cffunction name="get_xml_envio" access="remote" returntype="query" output="true">
    	<cfargument name="documento_id" required="yes" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select sefaz.pkg_sefaz.fnc_xml_distribuicao(#arguments.documento_id#) as xml_sefaz
              from dual
        </cfquery>
        <cfreturn qr_result>
    </cffunction>    
    
</cfcomponent>