<!-- KM&M Componentes -->
<cfcomponent displayname="Consultas da rea de lancamentos avulsos" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO 
	-- Buscas os lanamentos feitos pelo usurio
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  22/02/2006
	--->		
	<cffunction name="get_lancamentos" displayname="Buscas os lanamentos feitos pelo usurio" access="remote" returntype="query" output="true">
		<cfargument name="cod_funcionario" required="no">
		<cfargument name="data_inicial"    required="no">
		<cfargument name="data_final" 	   required="no">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select distinct num_lancamento,
                   descricao_documento,
                   cod_funcionario,
                   favorecido,
                   num_documento,
                   data_lancamento,
                   historico,
                   valor_lancamento,
                   deb_cred,
                   data_vencto,
                   codigo_transferencia
              from (select /* leading(cc) index (cc idx_ccl_11) */
                           cc.num_lancamento,
                           ccd.descricao_documento,
                           oper.pkg_global.fnc_get_cod_funcionario(c.cod_pessoa) as cod_funcionario,
                           cc.favorecido,
                           cc.num_documento,
                           cc.data_lancamento,
                           cc.historico,
                           cc.valor_lancamento,
                           decode(cc.deb_cred, 0, 'Dbito', 'Crdito') as deb_cred,
                           cc.data_vencto,
                           ct.cod_transferencia as codigo_transferencia
                      from oper.v$ccorrente c
                     inner join oper.v$ccorrente_lancamento cc
                             on cc.cod_conta = c.cod_conta
                     inner join oper.v$ccorrente_documento ccd
                             on ccd.cod_documento = cc.cod_documento
                      left join oper.v$motorista_reg_historico mrh
                             on mrh.cod_pessoa = c.cod_pessoa
                      left join oper.v$ccorrente_transfer_conta ct
                             on ct.num_lancamento_credito = cc.num_lancamento
                             or ct.num_lancamento_debito = cc.num_lancamento
                     where cc.cod_documento in (93, 94, 332)
                       and cc.user_insert in (user, 'VIVO')
                       and c.modalidade_id = 4
            		<cfif isDefined("arguments.cod_funcionario") and IsNumeric(arguments.cod_funcionario)>
                       and c.cod_pessoa = #arguments.cod_funcionario#
            		</cfif>
            <cfif isDefined("arguments.data_inicial") and isDefined("arguments.data_final")>
                   ) t
             where t.data_vencto between '#arguments.data_inicial#' and '#arguments.data_final#'
             order by t.favorecido, t.data_vencto
            <cfelseif not isDefined("arguments.cod_funcionario")>
                       and cc.data_lancamento > sysdate - 5
                   ) t
             order by t.num_lancamento desc
            </cfif>
   		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os ultimos pagamentos liberados
	-- CRISTOFER  02/03/2006
	--->
	<cffunction name="get_liberados" displayname="" access="remote" returntype="query" output="true">
		<cfargument name="cod_funcionario"  required="no" default="" />
		<cfargument name="cod_pessoa"  required="no" default="" />
			<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select  /*+ FIRST_ROWS */ lp.user_insert as usuario, 
					   lp.num_liberacao, 
					   initcap(lp.user_insert) as responsavel, 
					   f.cod_funcionario, 
					   f.nome_funcionario, 
					   (p.descricao || ' - ' || lp.complemento) as produto, 
					   lp.data_autorizacao, lp.valor  
				  from oper.v$liberacao_pagamento lp
				 inner join oper.v$setor_produto p
						 on lp.produto_id = p.produto_id     
				 inner join oper.v$rh_funcionario f
                         on lp.cod_pessoa = oper.pkg_global.fnc_get_cod_pessoa_func(f.cod_funcionario)
					   <cfif Len(trim(arguments.cod_funcionario))>
						and f.cod_funcionario = #val(arguments.cod_funcionario)#
						</cfif> 
					   <cfif Len(trim(arguments.cod_pessoa))>
						and f.cod_funcionario = oper.pkg_global.fnc_get_cod_funcionario(#arguments.cod_pessoa#)
						</cfif> 
 			     where not exists (select 'x'
									 from oper.v$viagem_recibo vr 
									where vr.num_liberacao = lp.num_liberacao)
				</cfquery>
		<cfreturn qr_result />								
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca a listagem dos pagamentos liberados no periodo
	-- CRISTOFER  03/03/2006
	--->
    <cffunction name="get_liberados_listagem" access="remote" returntype="query" output="true">
		<cfargument name="data_inicial"  required="yes" />
		<cfargument name="data_final"    required="yes" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select l.num_liberacao, 
				   l.user_insert as responsavel, 
				   l.data_autorizacao, 
				   l.valor, 
				   p.descricao, 
				   f.nome_funcionario 
			  from oper.v$liberacao_pagamento l, oper.v$setor_produto p, oper.v$rh_funcionario f  
			 where p.produto_id = l.produto_id    
			   and oper.pkg_global.fnc_get_cod_funcionario(l.cod_pessoa) = f.cod_funcionario 
			   and trunc(l.data_autorizacao) between to_date('#arguments.data_inicial#') and to_date('#arguments.data_final#')
			   and not exists (select 'x'
							     from oper.v$viagem_recibo vr  
							    where vr.num_liberacao = l.num_liberacao)
		</cfquery>
		<cfreturn qr_result />					 			
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os produtos do setor
	-- CRISTOFER  02/03/2006
	--->
	<cffunction name="get_produtos" displayname="" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select produto_id, descricao  
			  from oper.v$setor_produto  
			 where necessita_liberacao = 1
		</cfquery>
	<cfreturn qr_result />								
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca as ultimas liberacoes do produto
	-- CRISTOFER  02/03/2006
	--->	
	<cffunction name="get_ultimo_liberado" displayname="" access="remote" returntype="query" output="true">
		<cfargument name="produto_id"  		required="yes" />
		<cfargument name="cod_funcionario"  required="yes" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select /*+ ORDERED */ lp.num_liberacao, lp.user_insert as responsavel, lp.data_autorizacao, lp.date_update as data_uso, lp.valor, 
				   lp.valor_usado, (p.descricao || ' - ' || lp.complemento) as produto, 
				   f.cod_funcionario || '-' || f.nome_funcionario as funcionario        
  			  from oper.v$setor_produto p,
               oper.v$liberacao_pagamento lp, 
    				   oper.v$rh_funcionario f    			 	   
		     where lp.cod_pessoa = oper.pkg_global.fnc_get_cod_pessoa_func(f.cod_funcionario )
			   and lp.produto_id = p.produto_id
			   and lp.produto_id = p.produto_id
				and lp.produto_id = #arguments.produto_id#
				and f.cod_funcionario = #arguments.cod_funcionario#
			and lp.data_autorizacao < (select max(data_autorizacao) 
										 from oper.v$liberacao_pagamento lp2 
										where lp2.produto_id = lp.produto_id 
										  and lp.cod_pessoa = lp2.cod_pessoa
										  and exists ( select 'x' 
													    from oper.v$viagem_recibo vr  
													   where vr.num_liberacao = lp2.num_liberacao))
			and lp.date_insert > sysdate - 60
		  order by data_uso desc 
		</cfquery>
		<cfreturn qr_result />								
	</cffunction>		

	<!--- 
	-- PROPSITO 
	-- Busca as ultimas utilizacoes de liberacao de produtos
	-- CRISTOFER  03/03/2006
	--->		
	<cffunction name="get_usados" access="remote" returntype="query" output="true">
		<cfargument name="data_inicial"  required="yes" />
		<cfargument name="data_final"  required="yes" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select l.num_liberacao,
				   l.user_insert as responsavel,
				   l.data_autorizacao,
				   l.valor,
				   p.descricao,
				   (select distinct f.nome_funcionario
					  from oper.v$rh_funcionario f
					 where oper.pkg_global.fnc_get_cod_funcionario(l.cod_pessoa) = f.cod_funcionario) as nome_funcionario,
				   l.valor_usado,
				   l.user_update as responsavel_troca,
				   l.date_update as data_uso
			  from oper.v$liberacao_pagamento l
			 inner join oper.v$setor_produto p
					 on p.produto_id = l.produto_id
			 where 1=1
			   and trunc(l.data_autorizacao) between to_date('#arguments.data_inicial#') and to_date('#arguments.data_final#') 
			   and exists (select vr.num_liberacao 
				    		 from oper.v$viagem_recibo vr 
							where vr.num_liberacao = l.num_liberacao)
		</cfquery>
		<cfreturn qr_result />								
	</cffunction>	
</cfcomponent>