<cfcomponent extends="_transportes.funcoes.cfc_init">	

	<!--- 
	-- PROPSITO 
	-- Busca os projetos do KSS
	-- CRISTOFER  28/04/2006
	--->		
	<cffunction name="get_projeto" access="remote" returntype="query" output="true">
		<cfargument name="cod_projeto" required="no" default="" />
		<cfargument	name="nome_projeto" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cod_projeto, nome_projeto
			  from kss.kss_projeto
			 where 1=1
		   <cfif Len(Trim(arguments.cod_projeto))>
 			   and cod_projeto = #arguments.cod_projeto#
		   </cfif>
		   <cfif Len(trim(arguments.nome_projeto))>
			   and upper(nome_projeto) like upper('%#arguments.nome_projeto#%')
		   </cfif>
		     order by nome_projeto
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca a gesto do usurio
	-- WAGNER  01/10/2010
	--->		
	<cffunction name="get_gestao" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select kss.getgestao
			  from dual
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    

	<!--- 
	-- PROPSITO 
	-- Busca as aplicacoes
	-- CRISTOFER  28/04/2006
	--->		
	<cffunction name="get_aplicacao" access="remote" returntype="query" output="true">
		<cfargument name="cod_projeto" required="no" default="" />
		<cfargument	name="cod_aplicacao" required="no" default="" />
		<cfargument	name="nome_aplicacao" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select a.cod_projeto, a.cod_aplicacao, a.nome_aplicacao, 
				   a.tipo_aplicacao_id, a.role, p.nome_projeto
			  from kss.kss_projeto p
			 inner join kss.kss_aplicacao a
			         on a.cod_projeto = p.cod_projeto
  			 where 1 = 1
			   <cfif Len(Trim(arguments.cod_projeto))>
			   	  and a.cod_projeto = #arguments.cod_projeto#
			   </cfif>
			   <cfif Len(Trim(arguments.cod_aplicacao))>
			   	  and a.cod_aplicacao = '#arguments.cod_aplicacao#'
			   </cfif>
			   <cfif len(trim(arguments.nome_aplicacao))>
			   	  and upper(a.nome_aplicacao) like upper('%#arguments.nome_aplicacao#%')
			   </cfif>
			  order by a.cod_projeto, a.nome_aplicacao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Seleciona as empresas
	-- CRISTOFER  15/05/2006
	--->		
	<cffunction name="get_empresas" access="remote" returntype="query" output="true">
		<cfargument name="cod_projeto" required="no" default="" />
		<cfargument name="cnpj_basico" required="no" default="" />
		<cfargument name="nome" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct p.nome_fantasia, 
				   pa.cod_pessoa, 
				   p.identificador, 
				   p.cnpj_basico, 
				   p.razao_social
			  from kss.pessoa_aplicacao pa
			 inner join internet.v$pessoa p 
					 on pa.cod_pessoa = p.cod_pessoa
			 where 1=1
	/*		 	and	exists(select 'x'
							 from kss.kss_usuarios_suporte us
							where us.cod_projeto = pa.cod_projeto
							  and us.cod_aplicacao = pa.cod_aplicacao
							  and tecnico_suporte = user)		*/
							  
			<cfif len(trim(arguments.nome))>
			    and (upper(p.nome_fantasia) like upper('%#arguments.nome#%')
			         or upper(p.razao_social) like upper('%#arguments.nome#%'))
			</cfif>	
			<cfif len(trim(arguments.cnpj_basico))>
			    and p.cnpj_basico   = #arguments.cnpj_basico#
			</cfif>	
			<cfif len(trim(arguments.cod_projeto))>
				and pa.cod_projeto   = #arguments.cod_projeto#
			</cfif>	
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os usurios do sistema
	-- CRISTOFER  28/04/2006
	--->		
	<cffunction name="get_usuario_sistema" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="no" default="" />
		<cfargument name="usuario" required="no" default="" />
		<cfargument name="nome" required="no" default="" />
		<cfargument name="ativo" required="no" default="1"/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select u.cod_pessoa, nvl(pj.nome_fantasia,pf.nome) as proprietario, u.usuario, 
		           u.nome, u.descricao, u.email_id, 
				   e.email_username || '@' || e.email_provedor as email,
				   u.ativo 
			  from kss.kss_usuarios u
			 inner join kss.email e
					 on e.email_id = u.email_id
			 left join kss.pessoa_juridica pj
					on pj.cod_pessoa = u.cod_pessoa
			 left join kss.pessoa_fisica pf
					on pf.cod_pessoa = u.cod_pessoa
 			 where ativo = #arguments.ativo#
			<cfif Len(Trim(arguments.cod_pessoa))>
			   and u.cod_pessoa = #arguments.cod_pessoa#			
			</cfif>
			<cfif Len(Trim(arguments.usuario))>
			   and usuario like upper('%#arguments.usuario#%')
			</cfif>
			<cfif Len(Trim(arguments.nome))>
			   and upper(nome) like upper('%#arguments.nome#%')
			</cfif>
			order by u.nome
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as aplicacoes atualmente liberadas para o usuario
	-- CRISTOFER  28/04/2006
	--->		
	<cffunction name="get_aplicacoes_usuario" access="remote" returntype="query" output="true">
		<cfargument name="usuario" required="yes" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select pua.cod_pessoa, pj.nome_fantasia, pua.cod_projeto, p.nome_projeto,
				   pua.cod_aplicacao, a.nome_aplicacao, pua.usuario, nvl(n.cod_nivel_acesso,0) as cod_nivel_acesso
			  from kss.pessoa_usuario_aplicacao pua
			 inner join internet.v$pessoa pj
					 on pj.cod_pessoa = pua.cod_pessoa
			 inner join kss.kss_projeto p
					 on p.cod_projeto = pua.cod_projeto
			 inner join kss.kss_aplicacao a
					 on a.cod_projeto = pua.cod_projeto
					and a.cod_aplicacao = pua.cod_aplicacao
		      left join kss.kss_nivel_acesso_usr_aplic n
					  on n.cod_projeto = pua.cod_projeto
					 and n.cod_aplicacao = pua.cod_aplicacao
					 and n.usuario = pua.usuario
			where upper(pua.usuario) = upper('#arguments.usuario#')
			order by p.nome_projeto, a.nome_aplicacao, pj.nome_fantasia			
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as aplicacoes atualmente liberadas para o usuario com nivel de acesso
	-- CRISTOFER  28/04/2006
	--->
	<cffunction name="get_aplicacoes_usuario_acesso" access="remote" returntype="query" output="true">
		<cfargument name="usuario" required="yes"/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct  pua.cod_projeto, p.nome_projeto,
				   pua.cod_aplicacao, a.nome_aplicacao, pua.usuario, 
             	   nvl(n.cod_nivel_acesso,0) as cod_nivel_acesso
			  from kss.pessoa_usuario_aplicacao pua
			 inner join kss.kss_projeto p
					 on p.cod_projeto = pua.cod_projeto
			 inner join kss.kss_aplicacao a
					 on a.cod_projeto = pua.cod_projeto
					and a.cod_aplicacao = pua.cod_aplicacao
	         left  join kss.kss_nivel_acesso_usr_aplic n
				     on n.cod_projeto = pua.cod_projeto
					and n.cod_aplicacao = pua.cod_aplicacao
				    and n.usuario = pua.usuario
			where pua.usuario = upper('#arguments.usuario#')
			order by p.nome_projeto, a.nome_aplicacao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>



	<!--- 
	-- PROPSITO 
	-- Busca os niveis de acesso
	-- CRISTOFER  28/04/2006
	--->		
	<cffunction name="get_nivel_acesso" access="remote" returntype="query" output="true">
		<cfargument name="cod_nivel_acesso"  required="no" default="" />
		<cfargument name="nome_nivel_acesso" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cod_nivel_acesso, nome_nivel_acesso, intervalo_mudanca_senha
			  from kss.kss_nivel_acesso
			 where 1 = 1
			 <cfif len(trim(arguments.cod_nivel_acesso))>
			   and cod_nivel_acesso = #arguments.cod_nivel_acesso#
			 </cfif>
			 <cfif Len(Trim(arguments.nome_nivel_acesso))>
			   and nome_nivel_acesso like '%#arguments.nome_nivel_acesso#%'
			 </cfif>
 			 order by nome_nivel_acesso			
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as Aplicacoes para suporte
	-- CRISTOFER  28/04/2006
	--->		
	<cffunction name="get_aplicacoes_suporte" access="remote" returntype="query" output="true">
		<cfargument name="cod_projeto"		required="no" />
		<cfargument	name="cod_aplicacao" 	required="no" />
		<cfargument	name="nome_aplicacao" 	required="no" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct a.cod_projeto, a.cod_aplicacao, a.nome_aplicacao, 
				   a.tipo_aplicacao_id, a.role, p.nome_projeto
			  from kss.kss_projeto p
			 inner join kss.kss_aplicacao a
			         on a.cod_projeto = p.cod_projeto
			 inner join internet.pessoa_aplicacao_suporte pas
			         on pas.cod_projeto = a.cod_projeto
					and pas.cod_aplicacao = a.cod_aplicacao
  			 where 1 = 1
			   <cfif IsDefined("arguments.cod_projeto") and Len(Trim(arguments.cod_projeto))>
			   	  and a.cod_projeto = #arguments.cod_projeto#
			   </cfif>
			   <cfif IsDefined("arguments.cod_aplicacao") and Len(Trim(arguments.cod_aplicacao))>
			   	  and a.cod_aplicacao = '#arguments.cod_aplicacao#'
			   </cfif>
			   <cfif IsDefined("arguments.nome_aplicacao")>
			   	  and upper(a.nome_aplicacao) like upper('%#arguments.nome_aplicacao#%')
			   </cfif>
			  order by a.cod_projeto, a.nome_aplicacao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Consulta aplicaes disponiveis para os clientes da KM&M
	-- CRISTOFER  28/04/2006
	--->		
	<cffunction name="get_aplicacao_suporte" access="remote" returntype="query" output="true">
		<cfargument name="cod_projeto" required="no"/>
		<cfargument name="cod_aplicacao" required="no"/>
		<cfargument name="cod_pessoa" required="no"/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select pas.cod_pessoa, pj.nome_fantasia, pas.cod_projeto, pas.cod_aplicacao, pas.situacao
			  from internet.pessoa_aplicacao_suporte pas
			 inner join internet.v$pessoa pj
					 on pj.cod_pessoa = pas.cod_pessoa
			 where 1 = 1
			 <cfif isDefined("arguments.cod_pessoa")>
			   and pj.cod_pessoa = #arguments.cod_pessoa#
			 </cfif>
			 <cfif isDefined("arguments.cod_projeto")>
			   and pas.cod_projeto = #arguments.cod_projeto#
			 </cfif>
			 <cfif isDefined("arguments.cod_aplicacao") and Len(Trim(arguments.cod_aplicacao))>
			   and pas.cod_aplicacao like '#arguments.cod_aplicacao#'
			 </cfif>
			 order by pj.nome_fantasia, pas.cod_projeto, pas.cod_aplicacao         
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as aplicacoes que o usuario da suporte
	-- CRISTOFER  28/04/2006
	--->		
	<cffunction name="get_aplicacoes_suporte_usuario" access="remote" returntype="query" output="true">
		<cfargument name="usuario" required="yes"/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select pua.cod_pessoa, pj.nome_fantasia, pua.cod_projeto, p.nome_projeto,
				   pua.cod_aplicacao, a.nome_aplicacao, pua.usuario
			  from internet.pessoa_usr_aplic_suporte pua
			 inner join kss.pessoa_juridica pj
					 on pj.cod_pessoa = pua.cod_pessoa
			 inner join kss.kss_projeto p
					 on p.cod_projeto = pua.cod_projeto
			 inner join kss.kss_aplicacao a
					 on a.cod_projeto = pua.cod_projeto
					and a.cod_aplicacao = pua.cod_aplicacao
			where pua.usuario = upper('#arguments.usuario#')
			order by pj.nome_fantasia, p.nome_projeto, a.nome_aplicacao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Lista os Projetos que o usuario Corrente tem acesso ou Desenvolve
	-- CRISTOFER  28/04/2006
	--->		
	<cffunction name="get_projetos_usuario" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="no" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct p.cod_projeto, p.nome_projeto, pua.cod_pessoa
			  from kss.kss_projeto p
			 inner join internet.pessoa_usr_aplic_suporte pua
				     on p.cod_projeto = pua.cod_projeto 	 
			 where pua.usuario = user 
			 <cfif IsDefined("arguments.cod_pessoa") and Len(trim(arguments.cod_pessoa)) >
			   and pua.cod_pessoa = #val( arguments.cod_pessoa )# 
			 </cfif>
			 union 
			 	select distinct p.cod_projeto, p.nome_projeto, 40 
				  from kss.kss_projeto p 
				 order by 2	
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca tcnicos de suporte para cada aplicao na da KM&M
	-- CRISTOFER  28/04/2006
	--->		
	<cffunction name="get_tecnico_suporte" access="remote" returntype="query" output="true">
		<cfargument name="cod_projeto" required="no" default=""/>
		<cfargument name="cod_aplicacao" required="no" default=""/>
		<cfargument name="usuario" required="no" default=""/>
		<cfargument name="ordem_por" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct s.cod_projeto, p.nome_projeto, s.cod_aplicacao, a.nome_aplicacao, s.tecnico_suporte, u.nome
			  from kss.kss_usuarios_suporte	s
			 inner join kss.kss_projeto p
			         on p.cod_projeto = s.cod_projeto
		     inner join kss.kss_aplicacao a
			         on a.cod_projeto = s.cod_projeto
					and a.cod_aplicacao = s.cod_aplicacao
			 inner join kss.kss_usuarios u
			         on s.tecnico_suporte = u.usuario
			 where 1 = 1
			   <cfif Len(Trim(arguments.usuario))>
			       and s.tecnico_suporte = '#arguments.usuario#'
			   </cfif>
			   <cfif Len(Trim(arguments.cod_projeto))>
			       and s.cod_projeto = #arguments.cod_projeto#
			   </cfif>
			   <cfif Len(Trim(arguments.cod_aplicacao))>
			       and s.cod_aplicacao = '#arguments.cod_aplicacao#'
			   </cfif>
			   <cfif Len(Trim(arguments.ordem_por))>
					order by #arguments.ordem_por#
			   <cfelse>
					order by s.tecnico_suporte, s.cod_projeto, s.cod_aplicacao			 
			   </cfif> 
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Consulta aplicaes disponiveis para os clientes da KM&M
	-- CRISTOFER  28/04/2006
	--->	
	<cffunction name="get_pessoa_aplicacao" access="remote" returntype="query" output="true">
		<cfargument name="cod_projeto" required="no"/>
		<cfargument name="cod_aplicacao" required="no"/>
		<cfargument name="cod_pessoa" required="no"/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select pa.cod_pessoa, pj.nome_fantasia, pa.cod_projeto, pa.cod_aplicacao, pa.situacao, p.nome_projeto, a.nome_aplicacao
			  from kss.pessoa_aplicacao pa
			 inner join internet.v$pessoa pj
					 on pj.cod_pessoa = pa.cod_pessoa
			 inner join kss.kss_projeto p
			 	     on	p.cod_projeto = pa.cod_projeto	 
			 inner join kss.kss_aplicacao a
			 	     on	a.cod_projeto = pa.cod_projeto	 
			 	     and a.cod_aplicacao = pa.cod_aplicacao
			 where pa.situacao = 1
			 <cfif isDefined("arguments.cod_pessoa")>
			   and pj.cod_pessoa = #arguments.cod_pessoa#
			 </cfif>
			 <cfif isDefined("arguments.cod_projeto")>
			   and pa.cod_projeto = #arguments.cod_projeto#
			 </cfif>
			 <cfif isDefined("arguments.cod_aplicacao") and Len(Trim(arguments.cod_aplicacao))>
			   and pa.cod_aplicacao like '#arguments.cod_aplicacao#'
			 </cfif>
			 order by pj.nome_fantasia, p.nome_projeto, a.nome_aplicacao 
		</cfquery>
		<cfreturn qr_result />			  
	</cffunction>		

	<!--- 
	-- PROPSITO 
	-- Consulta pessoas da KM&M
	-- CRISTOFER  28/04/2006
	--->
	<cffunction name="get_pessoas" access="remote" returntype="query" output="true">
	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		select cod_pessoa, nome_fantasia, identificador
		  from internet.v$pessoa
		  order by nome_fantasia
		</cfquery>
		<cfreturn qr_result />			  
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Consulta pessoas da KM&M
	-- CRISTOFER  28/04/2006
	--->
	<cffunction name="get_projetos_pessoa" displayname="Consulta Clientes da KM&M" access="remote" returntype="query" output="false">
		<cfargument name="cod_pessoa" required="no" default="" />
		<cfargument name="cod_projeto" required="no" default="" />
		<cfquery name="qrCliente" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select pa.cod_pessoa, pa.cod_projeto, pa.cod_aplicacao,
				   p.nome_projeto, a.nome_aplicacao
			  from kss.pessoa_aplicacao pa
			 inner join kss.kss_projeto p
					 on p.cod_projeto = pa.cod_projeto
			 inner join kss.kss_aplicacao a
					 on a.cod_projeto = pa.cod_projeto
					and a.cod_aplicacao = pa.cod_aplicacao
			 where pa.situacao = 1			 
		 <cfif Len(trim(arguments.cod_pessoa))>				 
			   and cod_pessoa = #arguments.cod_pessoa# 
		 </cfif>		  
		 <cfif Len(trim(arguments.cod_projeto))>				 
			   and cod_projeto = #arguments.cod_projeto# 
		 </cfif>		  
			 order by nome_projeto, nome_aplicacao
		</cfquery>
		<cfreturn qrCliente />			  
	</cffunction>	
<!---
<cffunction name="getPessoas" displayname="Consulta pessoas da KM&M" access="remote" returntype="query" output="true">
<cfquery name="qrPessoas" datasource="#application.dsn#" username="#session.usuario#" password="#session.senha#">
	select cod_pessoa, nome_fantasia, identificador
	  from internet.v$pessoa
	  order by nome_fantasia
	</cfquery>
	<cfreturn qrPessoas />			  
</cffunction>	

	<cffunction name="getAplicacoes" displayname="Consulta aplicaes da KM&M" access="remote" returntype="query" output="true">
		<cfargument name="cod_projeto" displayname="Cdigo do Projeto" required="no"/>
		<cfargument	name="cod_aplicacao" displayname="Cdigo da aplicao" required="no"/>
		<cfargument	name="nome_aplicacao" displayname="Nome da Aplicao" required="no"/>
		<cfquery name="qrProjetos" datasource="#application.dsn#" username="#session.usuario#" password="#session.senha#">
			select a.cod_projeto, a.cod_aplicacao, a.nome_aplicacao, 
				   a.tipo_aplicacao_id, a.role, p.nome_projeto
			  from kss.kss_projeto p
			 inner join kss.kss_aplicacao a
			         on a.cod_projeto = p.cod_projeto
  			 where 1 = 1
			   <cfif IsDefined("arguments.cod_projeto") and Len(Trim(arguments.cod_projeto))>
			   	  and a.cod_projeto = #arguments.cod_projeto#
			   </cfif>
			   <cfif IsDefined("arguments.cod_aplicacao") and Len(Trim(arguments.cod_aplicacao))>
			   	  and a.cod_aplicacao = '#arguments.cod_aplicacao#'
			   </cfif>
			   <cfif IsDefined("arguments.nome_aplicacao")>
			   	  and upper(a.nome_aplicacao) like upper('%#arguments.nome_aplicacao#%')
			   </cfif>
			  order by a.cod_projeto, a.nome_aplicacao
		</cfquery>
		<cfreturn qrProjetos />			  
	</cffunction>	

	<cffunction name="getAplicacoesSuporte" displayname="Consulta aplicaes que a KM&M fornece suporte" access="remote" returntype="query" output="true">
		<cfargument name="cod_projeto" displayname="Cdigo do Projeto" required="no"/>
		<cfargument	name="cod_aplicacao" displayname="Cdigo da aplicao" required="no"/>
		<cfargument	name="nome_aplicacao" displayname="Nome da Aplicao" required="no"/>
		<cfquery name="qrProjetos" datasource="#application.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct a.cod_projeto, a.cod_aplicacao, a.nome_aplicacao, 
				   a.tipo_aplicacao_id, a.role, p.nome_projeto
			  from kss.kss_projeto p
			 inner join kss.kss_aplicacao a
			         on a.cod_projeto = p.cod_projeto
			 inner join internet.pessoa_aplicacao_suporte pas
			         on pas.cod_projeto = a.cod_projeto
					and pas.cod_aplicacao = a.cod_aplicacao
  			 where 1 = 1
			   <cfif IsDefined("arguments.cod_projeto") and Len(Trim(arguments.cod_projeto))>
			   	  and a.cod_projeto = #arguments.cod_projeto#
			   </cfif>
			   <cfif IsDefined("arguments.cod_aplicacao") and Len(Trim(arguments.cod_aplicacao))>
			   	  and a.cod_aplicacao = '#arguments.cod_aplicacao#'
			   </cfif>
			   <cfif IsDefined("arguments.nome_aplicacao")>
			   	  and upper(a.nome_aplicacao) like upper('%#arguments.nome_aplicacao#%')
			   </cfif>
			  order by a.cod_projeto, a.nome_aplicacao
		</cfquery>
		<cfreturn qrProjetos />			  
	</cffunction>	

	<cffunction name="getFormularios" displayname="Consulta formularios da KM&M" access="remote" returntype="query" output="true">
		<cfargument name="cod_projeto" displayname="Cdigo do Projeto" required="no"/>
		<cfargument name="cod_apliacao" displayname="Cdigo da Apliao" required="no"/>
		<cfargument name="form_name" displayname="Nome do Formulario" required="no"/>
		<cfquery name="qrProjetos" datasource="#application.dsn#" username="#session.usuario#" password="#session.senha#">
			select f.cod_projeto, f.cod_aplicacao, f.form_name, f.form_caption,
				   p.nome_projeto, a.nome_aplicacao
			  from kss.kss_formulario f
			 inner join kss.kss_projeto p
					 on p.cod_projeto = f.cod_projeto
			 inner join kss.kss_aplicacao a
					 on a.cod_projeto = f.cod_projeto
					and a.cod_aplicacao = f.cod_aplicacao
			      where 1 = 1
			   <cfif IsDefined("arguments.cod_projeto") and Len(Trim(arguments.cod_projeto))>
			   	  and cod_projeto = #arguments.cod_projeto#
			   </cfif>
			   <cfif IsDefined("arguments.cod_aplicacao") and Len(Trim(arguments.cod_aplicacao))>
			   	  and upper(cod_aplicacao) = upper('#arguments.cod_aplicacao#')
			   </cfif>
			   <cfif IsDefined("arguments.form_name") and Len(Trim(arguments.form_name))>
			   	  and upper(form_name) = upper('#arguments.form_name#')
			   </cfif>
			  order by cod_projeto, cod_aplicacao, form_name
		</cfquery>
		<cfreturn qrProjetos />			  
	</cffunction>	

	<cffunction name="getNivelAcesso" displayname="Consulta formularios da KM&M" access="remote" returntype="query" output="true">
		<cfargument name="cod_nivel_acesso" displayname="Cdigo nvel de acesso" required="no"/>
		<cfargument name="nome_nivel_acesso" displayname="Descrio" required="no"/>
		<cfquery name="qrProjetos" datasource="#application.dsn#" username="#session.usuario#" password="#session.senha#">
			select cod_nivel_acesso, nome_nivel_acesso, intervalo_mudanca_senha
			  from kss.kss_nivel_acesso
			 where 1 = 1
			 <cfif isDefined("arguments.cod_nivel_acesso")>
			   and cod_nivel_acesso = #arguments.cod_nivel_acesso#
			 </cfif>
			 <cfif isDefined("arguments.nome_nivel_acesso") and Len(Trim(arguments.nome_nivel_acesso))>
			   and nome_nivel_acesso like '%#arguments.nome_nivel_acesso#%'
			 </cfif>
 			 order by nome_nivel_acesso			
		</cfquery>
		<cfreturn qrProjetos />			  
	</cffunction>	

	<cffunction name="getAplicacaoSuporte" displayname="Consulta aplicaes disponiveis para os clientes da KM&M" access="remote" returntype="query" output="true">
		<cfargument name="cod_projeto" required="no"/>
		<cfargument name="cod_aplicacao" required="no"/>
		<cfargument name="cod_pessoa" required="no"/>
		<cfquery name="qrProjetos" datasource="#application.dsn#" username="#session.usuario#" password="#session.senha#">
			select pas.cod_pessoa, pj.nome_fantasia, pas.cod_projeto, pas.cod_aplicacao, pas.situacao
			  from internet.pessoa_aplicacao_suporte pas
			 inner join internet.v$pessoa pj
					 on pj.cod_pessoa = pas.cod_pessoa
			 where 1 = 1
			 <cfif isDefined("arguments.cod_pessoa")>
			   and pj.cod_pessoa = #arguments.cod_pessoa#
			 </cfif>
			 <cfif isDefined("arguments.cod_projeto")>
			   and pas.cod_projeto = #arguments.cod_projeto#
			 </cfif>
			 <cfif isDefined("arguments.cod_aplicacao") and Len(Trim(arguments.cod_aplicacao))>
			   and pas.cod_aplicacao like '#arguments.cod_aplicacao#'
			 </cfif>
			 order by pj.nome_fantasia, pas.cod_projeto, pas.cod_aplicacao         
		</cfquery>
		<cfreturn qrProjetos />			  
	</cffunction>	

	<cffunction name="getPessoaAplicacao" displayname="Consulta aplicaes disponiveis para os clientes da KM&M" access="remote" returntype="query" output="true">
		<cfargument name="cod_projeto" required="no"/>
		<cfargument name="cod_aplicacao" required="no"/>
		<cfargument name="cod_pessoa" required="no"/>
		<cfquery name="qrProjetos" datasource="#application.dsn#" username="#session.usuario#" password="#session.senha#">
			select pa.cod_pessoa, pj.nome_fantasia, pa.cod_projeto, pa.cod_aplicacao, pa.situacao, p.nome_projeto, a.nome_aplicacao
			  from kss.pessoa_aplicacao pa
			 inner join internet.v$pessoa pj
					 on pj.cod_pessoa = pa.cod_pessoa
			 inner join kss.kss_projeto p
			 	     on	p.cod_projeto = pa.cod_projeto	 
			 inner join kss.kss_aplicacao a
			 	     on	a.cod_projeto = pa.cod_projeto	 
			 	     and a.cod_aplicacao = pa.cod_aplicacao
			 where pa.situacao = 1
			 <cfif isDefined("arguments.cod_pessoa")>
			   and pj.cod_pessoa = #arguments.cod_pessoa#
			 </cfif>
			 <cfif isDefined("arguments.cod_projeto")>
			   and pa.cod_projeto = #arguments.cod_projeto#
			 </cfif>
			 <cfif isDefined("arguments.cod_aplicacao") and Len(Trim(arguments.cod_aplicacao))>
			   and pa.cod_aplicacao like '#arguments.cod_aplicacao#'
			 </cfif>
			 order by pj.nome_fantasia, p.nome_projeto, a.nome_aplicacao 
		</cfquery>
		<cfreturn qrProjetos />			  
	</cffunction>	

	<cffunction name="getUsuariosSistema" displayname="Busca todos os usurios da KM&M" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="no"/>
		<cfargument name="usuario" required="no"/>
		<cfargument name="nome" required="no"/>
		<cfargument name="ativo" required="no" default="1"/>
		<cfquery name="qrUsuario" datasource="#application.dsn#" username="#session.usuario#" password="#session.senha#">
			select u.cod_pessoa, nvl(pj.nome_fantasia,pf.nome) as proprietario, u.usuario, 
		           u.nome, u.descricao, u.email_id, 
				   e.email_username || '@' || e.email_provedor as email,
				   u.ativo 
			  from kss.kss_usuarios u
			 inner join kss.email e
					 on e.email_id = u.email_id
			 left join kss.pessoa_juridica pj
					on pj.cod_pessoa = u.cod_pessoa
			 left join kss.pessoa_fisica pf
					on pf.cod_pessoa = u.cod_pessoa
 			 where ativo = #arguments.ativo#
			<cfif IsDefined("arguments.cod_pessoa") and Len(Trim(arguments.cod_pessoa))>
			   and u.cod_pessoa = #arguments.cod_pessoa#			
			</cfif>
			<cfif IsDefined("arguments.usuario") and Len(Trim(arguments.usuario))>
			   and usuario like upper('%#arguments.usuario#%')
			</cfif>
			<cfif IsDefined("arguments.nome") and Len(Trim(arguments.nome))>
			   and upper(nome) like upper('%#arguments.nome#%')
			</cfif>
			order by u.nome
		</cfquery>
		<cfreturn qrUsuario />			  
	</cffunction>	

	<cffunction name="getAplicacoesUsuario" displayname="Busca todas as aplicaes do usurio na da KM&M" access="remote" returntype="query" output="true">
		<cfargument name="usuario" required="yes"/>
		<cfquery name="qrUsuario" datasource="#application.dsn#" username="#session.usuario#" password="#session.senha#">
			select pua.cod_pessoa, pj.nome_fantasia, pua.cod_projeto, p.nome_projeto,
				   pua.cod_aplicacao, a.nome_aplicacao, pua.usuario, nvl(n.cod_nivel_acesso,0) as cod_nivel_acesso
			  from kss.pessoa_usuario_aplicacao pua
			 inner join internet.v$pessoa pj
					 on pj.cod_pessoa = pua.cod_pessoa
			 inner join kss.kss_projeto p
					 on p.cod_projeto = pua.cod_projeto
			 inner join kss.kss_aplicacao a
					 on a.cod_projeto = pua.cod_projeto
					and a.cod_aplicacao = pua.cod_aplicacao
		      left join kss.kss_nivel_acesso_usr_aplic n
					  on n.cod_projeto = pua.cod_projeto
					 and n.cod_aplicacao = pua.cod_aplicacao
					 and n.usuario = pua.usuario
			where pua.usuario = upper('#arguments.usuario#')
			order by p.nome_projeto, a.nome_aplicacao, pj.nome_fantasia			
		</cfquery>
		<cfreturn qrUsuario />			  
	</cffunction>	
	
	<cffunction name="getAplicacoesUsuarioAcesso" displayname="Busca todas as aplicaes do usurio na da KM&M" access="remote" returntype="query" output="true">
		<cfargument name="usuario" required="yes"/>
		<cfquery name="qrUsuario" datasource="#application.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct  pua.cod_projeto, p.nome_projeto,
				   pua.cod_aplicacao, a.nome_aplicacao, pua.usuario, 
             	   nvl(n.cod_nivel_acesso,0) as cod_nivel_acesso
			  from kss.pessoa_usuario_aplicacao pua
			 inner join kss.kss_projeto p
					 on p.cod_projeto = pua.cod_projeto
			 inner join kss.kss_aplicacao a
					 on a.cod_projeto = pua.cod_projeto
					and a.cod_aplicacao = pua.cod_aplicacao
	         left  join kss.kss_nivel_acesso_usr_aplic n
				     on n.cod_projeto = pua.cod_projeto
					and n.cod_aplicacao = pua.cod_aplicacao
				    and n.usuario = pua.usuario
			where pua.usuario = upper('#arguments.usuario#')
			order by p.nome_projeto, a.nome_aplicacao
		</cfquery>
		<cfreturn qrUsuario />			  
	</cffunction>	

	<cffunction name="getAplicacoesSuporteUsuario" displayname="Busca todas as aplicaes do usurio na da KM&M" access="remote" returntype="query" output="true">
		<cfargument name="usuario" required="yes"/>
		<cfquery name="qrUsuario" datasource="#application.dsn#" username="#session.usuario#" password="#session.senha#">
			select pua.cod_pessoa, pj.nome_fantasia, pua.cod_projeto, p.nome_projeto,
				   pua.cod_aplicacao, a.nome_aplicacao, pua.usuario
			  from internet.pessoa_usr_aplic_suporte pua
			 inner join kss.pessoa_juridica pj
					 on pj.cod_pessoa = pua.cod_pessoa
			 inner join kss.kss_projeto p
					 on p.cod_projeto = pua.cod_projeto
			 inner join kss.kss_aplicacao a
					 on a.cod_projeto = pua.cod_projeto
					and a.cod_aplicacao = pua.cod_aplicacao
			where pua.usuario = upper('#arguments.usuario#')
			order by pj.nome_fantasia, p.nome_projeto, a.nome_aplicacao
		</cfquery>
		<cfreturn qrUsuario />			  
	</cffunction>	
	
	<cffunction name="getTecnicoSuporte" displayname="Busca tcnicos de suporte para cada aplicao na da KM&M" access="remote" returntype="query" output="true">
		<cfargument name="cod_projeto" required="no"/>
		<cfargument name="cod_aplicacao" required="no"/>
		<cfargument name="usuario" required="no"/>
		<cfargument name="ordem_por" required="no">
		<cfquery name="qrUsuario" datasource="#application.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct s.cod_projeto, p.nome_projeto, s.cod_aplicacao, a.nome_aplicacao, s.tecnico_suporte, u.nome
			  from kss.kss_usuarios_suporte	s
			 inner join kss.kss_projeto p
			         on p.cod_projeto = s.cod_projeto
		     inner join kss.kss_aplicacao a
			         on a.cod_projeto = s.cod_projeto
					and a.cod_aplicacao = s.cod_aplicacao
			 inner join kss.kss_usuarios u
			         on s.tecnico_suporte = u.usuario
			 where 1 = 1
			   <cfif IsDefined("arguments.usuario") and Len(Trim(arguments.usuario))>
			       and s.tecnico_suporte = '#arguments.usuario#'
			   </cfif>
			   <cfif IsDefined("arguments.cod_projeto") and Len(Trim(arguments.cod_projeto))>
			       and s.cod_projeto = #arguments.cod_projeto#
			   </cfif>
			   <cfif IsDefined("arguments.cod_aplicacao") and Len(Trim(arguments.cod_aplicacao))>
			       and s.cod_aplicacao = '#arguments.cod_aplicacao#'
			   </cfif>
			   <cfif IsDefined("arguments.ordem_por") and Len(Trim(arguments.ordem_por))>
					order by #arguments.ordem_por#
			   <cfelse>
					order by s.tecnico_suporte, s.cod_projeto, s.cod_aplicacao			 
			   </cfif> 
<!---			   order by s.tecnico_suporte, s.cod_projeto, s.cod_aplicacao			 --->
		</cfquery>
		<cfreturn qrUsuario />			  
	</cffunction>	

<cffunction name="getPessoasComUsuario" displayname="Busca as pessoas que possuem usuario" access="remote" returntype="query" output="true">
	<cfquery name="qrUsuario" datasource="#application.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct p. identificador, cliente
			  from kss.kss_usuarios t
			 inner join kss.v$pessoa p
					 on p.cod_pessoa = t.cod_pessoa
		</cfquery>
		<cfreturn qrUsuario />			  
	</cffunction>	
---></cfcomponent>
<!---

	consulta/cfc_kss_web.cfc
	conn_kss_web_consult = CreateObject("component","_componentes.consulta.cfc_kss_web");

	manipulacao/cfc_kss_web.cfc
	conn_kss_web_manip = CreateObject("component","_componentes.manipulacao.cfc_kss_web");
	
--->	