<cfcomponent displayname="Controle e manipulao de celules, grupo, mensagens SMS" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- Retorna os grupos criados
	-- guto 22/04/2006 12:01:16 - CRIADO
	--->
	<cffunction name="get_grupo" access="remote" returntype="query">
		<cfargument name="grupo_id"  required="no" default="">
		<cfargument name="descricao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select grupo_id, descricao
			  from kmm_sms.v$grupo
			 where 1=1
			<cfif Len(Trim(arguments.grupo_id))>
			   and grupo_id = #arguments.grupo_id#
			</cfif>
			<cfif Len(Trim(arguments.descricao))>
			   and upper(descricao) like upper('%#arguments.descricao#%')
			</cfif>
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Retorna os celulares cadastrados no sistema
	-- guto 22/04/2006 12:01:16 - CRIADO
	--->
	<cffunction name="get_movel" access="remote" returntype="query">
		<cfargument name="movel_id"  required="no" default="">
		<cfargument name="numero" required="no" default="">
		<cfargument name="proprietario" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select /*+ FIRST_ROWS */m.movel_id, m.ddd, m.numero, m.operadora_id, m.grupo_id, 
				   m.proprietario, g.descricao as grupo, o.descricao as operadora
			  from kmm_sms.v$movel m
			 inner join kmm_sms.v$operadora o
					 on o.operadora_id = m.operadora_id
			 inner join kmm_sms.v$grupo g
					 on g.grupo_id = m.grupo_id
  			 where 1=1
			<cfif Len(Trim(arguments.movel_id))>
			   and movel_id = #arguments.movel_id#
			</cfif>
			<cfif Len(Trim(arguments.numero))>
			   and upper(numero) like upper('%#arguments.numero#%')
			</cfif>
			<cfif Len(Trim(arguments.proprietario))>
			   and upper(proprietario) like upper('%#arguments.proprietario#%')
			</cfif>
			order by m.operadora_id, m.grupo_id, m.proprietario
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Retorna as mensagens enviadas pelo sistema
	-- guto 22/04/2006 12:01:16 - CRIADO
	--->
	<cffunction name="get_msg_envio" access="remote" returntype="query">
		<cfargument name="data_inicial" required="no" default="" />
		<cfargument name="data_final" required="no" default="" />
		<cfargument name="operadora_id" required="no" default="" />
		<cfargument name="ddd" required="no" default="" />
		<cfargument name="numero" required="no" default="" />
		<cfargument name="grupo_id" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select me.controle_id, me.movel_id, me.texto, 
            	   to_char(me.data_envio,'dd/mm/yyyy hh24:mi') as data_envio, 
                   to_char(me.data_entregue,'dd/mm/yyyy hh24:mi') as data_entregue, 
				   case 
				    when me.status = 0 then 'Agendada'
				    when me.status = 1 then 'Enviada'
				    when me.status = 2 then 'Entregue'					
				    when me.status = 3 then 'No confirmada a entrega'					
					else 'Problemas no envio'
					end status,
				   m.ddd, m.numero, o.descricao as operadora, g.descricao as grupo
			  from kmm_sms.v$msg_envio me
			 inner join kmm_sms.v$movel m
					 on m.movel_id = me.movel_id
			 inner join kmm_sms.v$grupo g
			  	     on g.grupo_id = m.grupo_id
			 inner join kmm_sms.v$operadora o
					 on o.operadora_id = m.operadora_id
  			 where 1=1
			 <cfif Len(Trim(arguments.data_inicial))>
			   and me.data_envio >= '#arguments.data_inicial#'
			 </cfif>
			 <cfif Len(Trim(arguments.data_final))>
			   and me.data_envio <= to_date('#arguments.data_final# 23:59','dd/mm/yyyy hh24:mi')
			 </cfif>
			 <cfif Len(Trim(arguments.operadora_id))>
			   and m.operadora_id = #arguments.operadora_id#
			 </cfif>
			 <cfif Len(Trim(arguments.ddd))>
			   and m.ddd = '#arguments.ddd#'
			 </cfif>
			 <cfif Len(Trim(arguments.numero))>
			   and m.numero = '#arguments.numero#'
			 </cfif>
			 <cfif Len(Trim(arguments.grupo_id))>
			   and m.grupo_id = #arguments.grupo_id#
			 </cfif>			 
			 order by operadora, grupo, data_envio desc
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Retorna as mensagens enviadas pelo sistema
	-- guto 22/04/2006 12:01:16 - CRIADO
	--->
	<cffunction name="get_msg_recebimento" access="remote" returntype="query">
		<cfargument name="data_inicial" required="no" default="" />
		<cfargument name="data_final" required="no" default="" />
		<cfargument name="operadora_id" required="no" default="" />
		<cfargument name="ddd" required="no" default="" />
		<cfargument name="numero" required="no" default="" />
		<cfargument name="grupo_id" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select mr.anum, mr.tx, m.operadora_id, m.grupo_id,
				   g.descricao as grupo, o.descricao as operadora,
				   mr.data_recebimento, 
				   nvl(m.ddd,substr(mr.anum,1,2)) as ddd, 
				   nvl(m.numero,substr(mr.anum,3,10)) as numero
			  from kmm_sms.msg_retorno_sms mr
			 left join kmm_sms.v$movel m
					 on m.ddd || m.numero = mr.anum 
			 left join kmm_sms.v$grupo g
					 on g.grupo_id = m.grupo_id
			 left join kmm_sms.v$operadora o
						   on o.operadora_id = m.operadora_id
  			 where 1=1
			 <cfif Len(Trim(arguments.data_inicial))>
			   and mr.data_recebimento >= '#arguments.data_inicial#'
			 </cfif>
			 <cfif Len(Trim(arguments.data_final))>
			   and mr.data_recebimento <= to_date('#arguments.data_final# 23:59','dd/mm/yyyy hh24:mi')
			 </cfif>
			 <cfif Len(Trim(arguments.operadora_id))>
			   and o.operadora_id = #arguments.operadora_id#
			 </cfif>
			 <cfif Len(Trim(arguments.ddd))>
			   and m.ddd = '#arguments.ddd#'
			 </cfif>
			 <cfif Len(Trim(arguments.numero))>
			   and m.numero = '#arguments.numero#'
			 </cfif>
			 <cfif Len(Trim(arguments.grupo_id))>
			   and m.grupo_id = #arguments.grupo_id#
			 </cfif>			 
			 order by operadora, grupo, mr.data_recebimento desc
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>		

	<!--- 
	-- PROPSITO
	-- Retorna atributos/tags
	-- Guto 20/06/2006 12:01:16 - CRIADO
	--->
	<cffunction name="get_atributos" access="remote" returntype="query">
		<cfargument name="atributo_id" required="no" default="" />
		<cfargument name="visivel" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select atributo_id, cod_atributo, 
				   nome, tag, tipo_dado
			  from kmm_sms.v$movel_atributo
  			 where 1=1
			<cfif Len(Trim(arguments.atributo_id))>
			   and atributo_id = #arguments.atributo_id#
			</cfif>
			<cfif Len(Trim(arguments.visivel))>
			   and visivel = #arguments.visivel#
			</cfif>
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Retorna atributos com os valores por movel
	-- guto 21/06/2006 09:44:16 - CRIADO
	--->
	<cffunction name="get_movel_atributos" access="remote" returntype="query">
		<cfargument name="movel_id" required="no" default="" />
		<cfargument name="atributo_id" required="no" default="" />
		<cfargument name="visivel" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ma.atributo_id, ma.cod_atributo, 
				   ma.nome, ma.tag, ma.tipo_dado,
				   mav.movel_id, mav.valor
			  from kmm_sms.v$movel_atributo ma
			 inner join kmm_sms.v$movel_atributo_valor mav
			         on mav.atributo_id = ma.atributo_id
  			 where 1=1
			<cfif Len(Trim(arguments.movel_id))>
			   and mav.movel_id = #arguments.movel_id#
			</cfif>
			<cfif Len(Trim(arguments.atributo_id))>
			   and ma.atributo_id = #arguments.atributo_id#
			</cfif>
			<cfif Len(Trim(arguments.visivel))>
			   and ma.visivel = #arguments.visivel#
			</cfif>
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>		
</cfcomponent>