<cfcomponent extends="_transportes.funcoes.cfc_init">	
	<!--- 
	-- PROPSITO 
	-- Busca os clientes
	-- ANDERSON 27/07/2009 - ALTERADO
	--->  		
	<cffunction name="get_cliente" access="remote" returntype="query" output="true">
		<cfargument name="cliente" required="no" default="">
		<cfargument name="cliente_id" required="no" default="">
		<cfargument name="com_projeto" required="no" default="">
        <cfargument name="url_imagem" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select c.cliente_id,
                   c.cliente,
                   c.nome,
                   p.cliente as nome_pessoa,
                   c.cod_pessoa,
                   c.grupo_id,
                   c.date_insert,
                   c.user_insert,
                   c.date_update,
                   c.user_update,
                   c.site,
                   c.logo,
                   c.exibicao_web,
                   a.url_imagem
              from kmm.v$cliente c
              left join kss.v$pessoa p 
              		on p.cod_pessoa = c.cod_pessoa
              left join site.v$arquivo a 
              		on a.arquivo_id = c.logo
             where 1 = 1
			<cfif len(trim(arguments.cliente))>
			   and upper(c.cliente) like upper('%#arguments.cliente#%')
			</cfif>
			<cfif len(trim(arguments.cliente_id))>
			   and c.cliente_id in (#arguments.cliente_id#)
			</cfif>
			<cfif len(trim(arguments.com_projeto))>
            	and exists (select 1 from kmm.v$projeto p where p.cliente_id = c.cliente_id and nvl(p.data_fechamento,sysdate) >= sysdate)
            </cfif>
			 order by c.cliente
  		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Busca os grupos de clientes
    -- ANDERSON 27/07/2009 - CRIADO
    --->		
    <cffunction name="get_cliente_grupo" access="remote" returntype="query" output="true">
    	<cfargument name="grupo_id" required="no" default="">
        <cfargument name="descricao" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cg.grupo_id
                 , cg.descricao
              from kmm.v$cliente_grupo cg
             where 1 = 1
			<cfif Len(Trim(arguments.grupo_id))>
               and cg.grupo_id = #arguments.grupo_id#
            </cfif>
            <cfif Len(Trim(arguments.descricao))>
               and upper(cg.descricao) like upper('#arguments.descricao#%')
            </cfif>
             order by cg.descricao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna os mdulos cadastrados
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 03/04/2009
	--->	
	<cffunction name="get_modulo" displayname="Retorna os mdulos cadastrados" output="true" returntype="query" access="remote">
		<cfargument name="cod_modulo" required="no" default="">
        <cfargument name="modulo_id" required="no" default="">
        <cfargument name="nome" required="no" default="">
        <cfargument name="disponivel" required="no" default="0">
        <cfargument name="cliente_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select m.modulo_id
                 , m.cod_modulo
                 , m.nome
                 , m.descricao
              from kmm.v$modulo m
             where 1 = 1
            <cfif Len(Trim(arguments.modulo_id))>
               and m.modulo_id = #arguments.modulo_id#
			</cfif>
			<cfif Len(Trim(arguments.cod_modulo))>
               and upper(m.cod_modulo) like upper('#arguments.cod_modulo#%')
			</cfif>
			<cfif Len(Trim(arguments.nome))>
               and upper(m.nome) like upper('#arguments.nome#%')
			</cfif>
            <cfif arguments.disponivel eq 1>
               and m.modulo_id not in
                   (select cm.modulo_id
                      from kmm.v$cliente_modulo cm
                     where cm.cliente_id = #arguments.cliente_id#)
            </cfif>
             order by m.nome
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna os mdulos vinculados a um cliente

	-- NOTAS EXPLICATIVAS
	-- ANDERSON 03/04/2009
	--->	
	<cffunction name="get_modulos_cliente" displayname="Retorna os mdulos vinculados a um cliente" output="true" returntype="query" access="remote">
        <cfargument name="cliente_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cm.controle_id
                 , cm.cliente_id
                 , cm.modulo_id
                 , m.nome
                 , m.descricao
              from kmm.v$cliente_modulo cm
              left outer join kmm.v$modulo m
                on m.modulo_id = cm.modulo_id
             where cm.cliente_id = #arguments.cliente_id#
             order by m.nome asc
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- busca os recursos 
	-- CRISTOFER  18/05/2006
	--->		
	<cffunction name="get_recurso" access="remote" returntype="query" output="true">
		<cfargument name="recurso_id" required="no" default="">
		<cfargument name="nome" required="no" default="">
		<cfargument name="usuario" required="no" default="">
		<cfargument name="tecnico" required="no" default="">
		<cfargument name="ativo" required="no" default="">
		<cfargument name="projeto_id" required="no" default="">
		<cfargument name="cliente_id" required="no" default="">
		<cfargument name="interno_projeto" required="no" default="">
		<cfargument name="funcao_id" required="no" default="">
		<cfargument name="possui_custo_hora" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select r.recurso_id,
				   r.nome,
				   u.nome as nome_completo,
				   u.cod_pessoa,
				   p.cliente as nome_pessoa,
				   r.cliente_id,
				   c.nome as cliente,
				   r.tecnico,
				   r.exibir_ranking,
				   r.email,
				   r.date_insert,
				   r.user_insert,
				   r.date_update,
				   r.user_update,
				   r.site,
				   r.custo_hora,
				   r.ativo,
			 <cfif len(trim(arguments.funcao_id))>
			       (select min(er.funcao_id)
                      from kmm.v$equipe_recurso er
                     where er.funcao_id in (#arguments.funcao_id#)
                       and er.recurso_id = r.recurso_id) as funcao_id,
			 </cfif>
                   r.produtividade
			  from kmm.v$recurso r
			 inner join kmm.v$cliente c
			         on c.cliente_id = r.cliente_id
			 inner join kss.kss_usuarios u
			         on u.usuario = r.nome
			 left join kss.v$pessoa p
				     on p.cod_pessoa = u.cod_pessoa
			<cfif len(trim(arguments.projeto_id))>
			 inner join kmm.v$projeto_equipe pe
			         on pe.recurso_id = r.recurso_id
					and pe.projeto_id = #arguments.projeto_id#
					<cfif len(trim(arguments.interno_projeto))>
					and pe.interno in (#projeto.interno#)
					</cfif>
			</cfif>
			 where 1=1
			 <cfif len(trim(arguments.recurso_id))>
			   and r.recurso_id in (#arguments.recurso_id#)
			 </cfif>
			 <cfif len(trim(arguments.nome))>
			   and upper(r.nome) = upper('#arguments.nome#')
			 </cfif>
			 <cfif len(trim(arguments.usuario))>
			   and upper(r.nome) like upper('#arguments.usuario#')
			 </cfif>
			 <cfif len(trim(arguments.tecnico))>
			   and r.tecnico = #arguments.tecnico#
			 </cfif>
			 <cfif len(trim(arguments.ativo))>
			   and r.ativo = #arguments.ativo#
			 </cfif>
			 <cfif len(trim(arguments.cliente_id))>
			   and r.cliente_id = #arguments.cliente_id#
			 </cfif>
			 <cfif len(trim(arguments.funcao_id))>
			   and r.recurso_id in (select er.recurso_id
                                      from kmm.v$equipe_recurso er
                                     where funcao_id in (#arguments.funcao_id#))
			 </cfif>
			 <cfif arguments.possui_custo_hora eq 1>
			   and r.custo_hora > 0
			 </cfif>             
			 order by c.nome, u.nome
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca os projetos
	-- CRISTOFER  02/08/2006
	--->		
	<cffunction name="get_projeto" access="remote" returntype="query" output="true">
		<cfargument name="projeto_id" required="no" default="">
		<cfargument name="cliente_id" required="no" default="">
		<cfargument name="status_id" required="no" default="">
		<cfargument name="titulo" required="no" default="">
		<cfargument name="codigo" required="no" default="">
		<cfargument name="data_inicio_inicial" required="no" default="">
		<cfargument name="data_inicio_final" required="no" default="">
		<cfargument name="data_fechamento_inicial" required="no" default="">
		<cfargument name="data_fechamento_final" required="no" default="">
		<cfargument name="aberto" required="no" default="">
        <cfargument name="com_clobs" required="no" default="1">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select p.projeto_id,
				   p.codigo,
				   p.titulo,
				   p.cliente_id,
				   c.nome as cliente,
				   p.data_inicio,
				   p.data_fechamento,
				   p.status_id,
                   <cfif com_clobs eq 1>
				   pe.descricao as escopo,
				   pl.limitacao as limitacao,
				   pm.meta_gerencial as meta,
				   pp.descricao as proposito,
                   </cfif>
				   p.user_insert,
				   p.date_insert,
				   p.user_update,
				   p.date_update,
				   p.site
			  from kmm.v$projeto p
			 inner join kmm.v$cliente c
			         on c.cliente_id = p.cliente_id
			  left join kmm.v$projeto_limitacao pl
					 on pl.projeto_id = p.projeto_id
			  left join kmm.v$projeto_escopo pe
					 on pe.projeto_id = p.projeto_id
			  left join kmm.v$projeto_meta pm
					 on pm.projeto_id = p.projeto_id
		      left join kmm.v$projeto_proposito pp
			         on pp.projeto_id = p.projeto_id
			 where 1=1
			 <cfif len(trim(arguments.projeto_id))>
			   and p.projeto_id in (#arguments.projeto_id#)
			 </cfif>
			 <cfif len(trim(arguments.cliente_id))>
			   and p.cliente_id in (#arguments.cliente_id#)
			 </cfif>
			 <cfif len(trim(arguments.status_id))>
			   and p.status_id in (#arguments.status_id#) 
			 </cfif>
			 <cfif len(trim(arguments.titulo))>
			   and upper(p.titulo) like upper('%#arguments.titulo#%')
			 </cfif>
			 <cfif len(trim(arguments.codigo))>
			   and upper(p.codigo) like upper('%#arguments.codigo#%')
			 </cfif>
			 <cfif len(trim(arguments.data_inicio_inicial))>
			   and p.data_inicio >= '#arguments.data_inicio_inicial#'
			 </cfif>
			 <cfif len(trim(arguments.data_inicio_final))>
			   and p.data_inicio <= '#arguments.data_inicio_final#'
			 </cfif>
			 <cfif len(trim(arguments.data_fechamento_inicial))>
			   and p.data_fechamento >= '#arguments.data_fechamento_inicial#'
			 </cfif>
			 <cfif len(trim(arguments.data_fechamento_final))>
			   and p.data_fechamento <= '#arguments.data_fechamento_final#'	
			 </cfif>
             <cfif Len(Trim(arguments.aberto)) and arguments.aberto eq 1>
             	 and (p.data_fechamento is null or p.data_fechamento >= sysdate)
             </cfif>	
             order by c.nome, p.titulo
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca as funcoes dos recursos
	-- CRISTOFER  18/05/2006
	--->		
	<cffunction name="get_recurso_funcao" access="remote" returntype="query" output="true">
		<cfargument name="funcao_id" required="no" default="">
		<cfargument name="descricao" required="no" default="">
		<cfargument name="interno" required="no" default="">
		<cfargument name="externo" required="no" default="">
		<cfargument name="terceiro" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select funcao_id,
				   descricao,
				   responsabilidades,
				   cor_hexadecimal,
				   interno,
				   externo,
				   terceiro,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from kmm.v$recurso_funcao
			 where 1=1
			 <cfif len(trim(arguments.funcao_id))>
			   and funcao_id in (#arguments.funcao_id#)
			 </cfif>
			 <cfif len(trim(arguments.interno))>
			   and interno = #arguments.interno#
			 </cfif>
			 <cfif len(trim(arguments.externo))>
			   and externo = #arguments.externo#
			 </cfif>
			 <cfif len(trim(arguments.terceiro))>
			   and terceiro = #arguments.terceiro#
			 </cfif>
			 <cfif len(trim(arguments.descricao))>
			   and upper(descricao) like upper('%#arguments.descricao#%')
			 </cfif>
			 order by descricao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os acronimos do projeto
	-- CRISTOFER  23/08/2006
	--->		
	<cffunction name="get_projeto_acronimo" access="remote" returntype="query" output="true">
		<cfargument name="projeto_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select acronimo_id,
				   projeto_id,
				   abreviacao,
				   descricao,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from kmm.v$projeto_acronimo
			 where 1=1
			 <cfif len(trim(arguments.projeto_id))>
			   and projeto_id = #arguments.projeto_id#
			 </cfif>
			 order by abreviacao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca a equipe do projeto
	-- CRISTOFER  22/08/2006
	--->		
	<cffunction name="get_projeto_equipe" access="remote" returntype="query" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfargument name="interno" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select pe.projeto_equipe_id,
				   pe.projeto_id,
				   pe.recurso_id,
				   r.nome_completo,
				   rf.descricao as funcao,
				   pe.funcao_id,
				   pe.observacao,
				   pe.toma_decisao,
				   pe.interno,
				   pe.date_insert,
				   pe.user_insert,
				   pe.date_update,
				   pe.user_update,
				   pe.ordem
			  from kmm.v$projeto_equipe pe
			 inner join kmm.v$recurso r
			         on r.recurso_id = pe.recurso_id
			 inner join kmm.v$recurso_funcao rf
			         on rf.funcao_id = pe.funcao_id
			 where 1=1
			   and projeto_id = #arguments.projeto_id#
			 <cfif len(trim(arguments.interno))>
			   and interno = #arguments.interno#
			 </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os cronogramas do projeto
	-- CRISTOFER  24/08/2006
	--->		
	<cffunction name="get_projeto_cronograma" access="remote" returntype="query" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select pc.cronograma_id, pc.projeto_id, pc.titulo, pc.status, to_char(pc.data_previsao_conclusao,'dd/mm/yyyy')  as data_previsao_conclusao, 
                   pc.responsavel_id, pc.item_raiz, r.nome_completo as responsavel, kss.to_tempo(numtodsinterval(sysdate-pc.data_previsao_conclusao,'DAY'),3).retorno as dias_conclusao,
                   cg.descricao as status_descricao
              from kmm.v$projeto_cronograma pc
              inner join kmm.v$recurso r
                      on pc.responsavel_id = r.recurso_id
              inner join kmm.v$cg_ref_codes cg
                      on cg.dominio = 'STATUS CRONOGRAMA' 
                     and cg.id = pc.status 
			 where 1=1
			   and pc.projeto_id = #arguments.projeto_id#	
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os status dos treinamentos
	-- CRISTOFER  24/08/2006
	--->		
	<cffunction name="get_treinamento_status" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select status_id, descricao from kmm.v$treinamento_status
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os status das infra-estruturas
	-- CRISTOFER  24/08/2006
	--->		
	<cffunction name="get_infra_estrutura_status" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select status_id, descricao from kmm.v$infra_estrutura_status	
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca os treinamentos do projeto
	-- CRISTOFER  24/08/2006
	--->		
	<cffunction name="get_projeto_recurso" access="remote" returntype="query" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select treinamento_id,
				   projeto_id,
				   descricao,
				   realizar_ate,
				   criterio_participacao,
				   status,
				   tipo_id,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from kmm.v$projeto_recurso
			 where 1=1
			   and projeto_id = #arguments.projeto_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>   	
	
	<!--- 
	-- PROPSITO 
	-- Busca os recursos de infra estrutura do projeto
	-- CRISTOFER  24/08/2006
	--->		
	<cffunction name="get_projeto_infra_estrutura" access="remote" returntype="query" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select infra_estrutura_id,
				   projeto_id,
				   descricao,
				   disponibilizar_ate,
				   status,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from kmm.v$projeto_infra_estrutura
			 where 1=1
			   and projeto_id = #arguments.projeto_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>   

	<!--- 
	-- PROPSITO 
	-- Busca os outros recursos do projeto
	-- CRISTOFER  25/08/2006
	--->		
	<cffunction name="get_projeto_recursos" access="remote" returntype="query" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select projeto_id,
				   descricao,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from kmm.v$projeto_outros_recursos
			 where 1=1
			   and projeto_id = #arguments.projeto_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>     
	
	<!--- 
	-- PROPSITO  
	-- Busca os valores dos dominios
	-- CRISTOFER  25/08/2006
	--->		
	<cffunction name="get_cg_ref_codes" access="remote" returntype="query" output="true">
		<cfargument name="dominio" required="yes">
		<cfargument name="id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select dominio, 
				   id, 
				   descricao 
			  from kmm.v$cg_ref_codes 
			 where dominio = '#arguments.dominio#'	
			 <cfif len(trim(arguments.id))>
			   and id in (#ListDeleteNulls(arguments.id)#)
			 </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca os casos de uso do projeto
	-- CRISTOFER  25/08/2006
	--->		
	<cffunction name="get_projeto_caso_uso" access="remote" returntype="query" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select caso_uso_id,
				   projeto_id,
				   descricao,
				   complexidade_id,
				   status_id,
				   observacao,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from kmm.v$projeto_caso_uso
			 where 1=1
			   and projeto_id = #arguments.projeto_id#	 	
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os atores do projeto
	-- CRISTOFER  25/08/2006
	--->		
	<cffunction name="get_projeto_ator" access="remote" returntype="query" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ator_id,
				   projeto_id,
				   descricao,
				   interface,
				   tipo_id,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from kmm.v$projeto_ator
			 where 1=1
			   and projeto_id = #arguments.projeto_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
	
	
	
	<!--- 
	-- PROPSITO 
	-- Busca os riscos do projeto
	-- CRISTOFER  28/08/2006
	--->		
	<cffunction name="get_projeto_risco" access="remote" returntype="query" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select risco_id,
				   projeto_id,
				   descricao,
				   categoria_id,
				   probabilidade_id,
				   impacto_id,
				   exposicao_id,
				   status_id,
				   estrategia,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from kmm.v$projeto_risco	
			 where projeto_id = #arguments.projeto_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca os projeto modulos
	-- CRISTOFER  28/08/2006
	--->		
	<cffunction name="get_projeto_modulo" access="remote" returntype="query" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select  pm.controle_id
            		,pm.modulo_id
                    ,pm.projeto_id
				    ,pm.ativo
                    ,pm.versao
                    ,pm.observacao
                    ,m.nome, m.cod_modulo
			  from kmm.v$projeto_modulo pm
              inner join kmm.v$modulo m
	             	on m.modulo_id = pm.modulo_id
			 where projeto_id = #arguments.projeto_id#             
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
	
	
	<!--- 
	-- PROPSITO 
	-- Busca as observacoes do projeto
	-- CRISTOFER  28/08/2006
	--->		
	<cffunction name="get_projeto_observacoes" access="remote" returntype="query" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select projeto_id,
				   produtividade,
				   improdutividade,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from kmm.v$projeto_observacoes
			 where 1=1
			   and projeto_id = #arguments.projeto_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>  

	<!--- 
	-- PROPSITO 
	-- Busca os requisitos do projeto
	-- CRISTOFER  28/08/2006
	--->		
	<cffunction name="get_projeto_requisito" access="remote" returntype="query" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select projeto_requisito_id,
				   projeto_id,
				   requisito_id,
				   tipo_id,
				   tamanho_id,
				   complexidade_id,
				   status_id,
				   descricao,
				   descricao observacao,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from kmm.v$projeto_requisito
			 where projeto_id = #arguments.projeto_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca a arvore de requisitos de um projeto
	-- CRISTOFER  28/08/2006
	--->		
	<cffunction name="get_projeto_requisito_tree" access="remote" returntype="query" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfargument name="requisito_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct r.requisito_id,
				   r.requisito_pai,
				   r.cod_requisito,
				   r.titulo,
				   level as nivel,
				   connect_by_isleaf folha,
				   r.cod_requisito as codigo_completo,
				   lpad(' ',(level-1)*2,' ')||r.titulo as path2,
				   case 
					 when pr.requisito_id is null 
					 then 0 
					 else 1 
				   end cadastrado
			  from (select distinct r.requisito_id, 
						   r.requisito_pai
					  from kmm.v$requisito r
					start with r.requisito_id in (select pr1.requisito_id
												  from kmm.v$projeto_requisito pr1
												 where projeto_id = #arguments.projeto_id#)
					<cfif len(trim(arguments.requisito_id))>
					  and r.requisito_id in (#arguments.requisito_id#)
					</cfif>
					connect by prior r.requisito_pai = r.requisito_id) r1
			 inner join kmm.v$requisito r
					 on r.requisito_id = r1.requisito_id
			  left join kmm.v$projeto_requisito pr
					 on pr.requisito_id = r.requisito_id
			start with r1.requisito_pai is null
			connect by prior r1.requisito_id = r1.requisito_pai
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca vinculos entre os requisitos do projeto
	-- CRISTOFER  29/08/2006
	--->		
	<cffunction name="get_projeto_requisito_vinculo" access="remote" returntype="query" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select projeto_id,
				   requisito_id_1,
				   requisito_id_2,
				   user_insert,
				   date_inser,
				   user_update,
				   date_update,
				   site
			  from kmm.v$projeto_requisito_vinculo
			 where projeto_id = #arguments.projeto_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca os parametros do grupo
	-- CRISTOFER  30/08/2006
	--->		
	<cffunction name="get_parametro" access="remote" returntype="query" output="true">
		<cfargument name="grupo" required="yes">
		<cfargument name="cod_parametro" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cod_parametro,
				   grupo,
				   valor,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from kmm.v$parametro
			 where grupo = '#arguments.grupo#'
			 <cfif len(trim(arguments.cod_parametro))>
			   and cod_parametro = '#arguments.cod_parametro#'
			 </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>  	
	
	<!--- 
	-- PROPSITO 
	-- Busca as etapas do ciclo de vida
	-- CRISTOFER  06/09/2006
	--->		
	<cffunction name="get_ciclo_vida_etapa" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select etapa_id,
				   num_etapa,
				   descricao,
				   perc_tempo,
				   padrao,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from kmm.v$ciclo_vida_etapa
			 order by padrao,num_etapa
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>  	
	
	<!--- 
	-- PROPSITO 
	-- Busca as etapas do ciclo de vida para o projeto
	-- CRISTOFER  08/09/2006
	--->		
	<cffunction name="get_projeto_ciclo_vida" access="remote" returntype="query" output="true">
		<cfargument name="projeto_id" required="no" default="">
		<cfargument name="sd_id" required="no" default="">
		<cfargument name="tarefa_id" required="no" default="">
		<cfargument name="num_etapa_inicial" required="no" default="">
		<cfargument name="num_etapa_final" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select pc.projeto_id,
				   pc.etapa_id,
				   ce.descricao,
				   pc.num_etapa,
				   pc.perc_tempo,
				   pc.date_insert,
				   pc.user_insert,
				   pc.date_update,
				   pc.user_update,
				   pc.site
			  from kmm.v$projeto_ciclo_vida pc
			 inner join kmm.v$ciclo_vida_etapa ce
			         on ce.etapa_id = pc.etapa_id
             <cfif Len(Trim(arguments.TAREFA_ID))>
             	inner join kmm.v$projeto_tarefa pt
                        on pt.projeto_id = pc.projeto_id
                       and pt.tarefa_id = #arguments.TAREFA_ID#
			 </cfif>             
             <cfif Len(Trim(arguments.SD_ID))>
             	inner join kmm.v$sd sd
                        on sd.projeto_id = pc.projeto_id
                       and sd.sd_id = #arguments.SD_ID#
             </cfif>
			 where 1=1
             <cfif Len(Trim(arguments.projeto_id))>
               and projeto_id = #arguments.projeto_id#	
             </cfif>
             <cfif Len(trim(arguments.num_etapa_inicial))>
               and ce.num_etapa >= #arguments.num_etapa_inicial#
             </cfif>
             <cfif Len(trim(arguments.num_etapa_final))>
               and ce.num_etapa <= #arguments.num_etapa_final#
             </cfif>
			 order by num_etapa 
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca arvore de requisitos
	-- GUTO - 03/07/2006
	--->		
	<cffunction name="get_requisito_tree" access="remote" returntype="query" output="true">
		<cfargument name="cod_requisito" required="no" default=""/>
		<cfargument name="titulo" required="no" default=""/>
		<cfargument name="hide_clobs" required="no" default="0">
		<cfargument name="projeto_id" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select r.path, r.codigo_completo, r.requisito_id, r.requisito_pai, r.cod_requisito,
				   r.titulo, r.nivel,
				   lpad(' ',(r.nivel-1)*2,' ')||r.titulo as path2,
				   <cfif arguments.hide_clobs eq 0>
				   r.escopo,
				   </cfif>
				    r.tipo_id, r.estado_id, r.folha,
				   r.nivel, r.requisito_id_raiz, max(r.nivel) over(partition by r.requisito_id_raiz) as maior_nivel,
				   (select count(*) 
					  from kmm.v$requisito rp
					 where rp.requisito_pai = r.requisito_id) as filhos,
				   (select fnc_concat_all(to_concat_expr(to_char(requisito_id), ',')) requisitos
					  from kmm.v$requisito rp
					 where rp.requisito_pai = r.requisito_id) as req_filhos,
				   rs.descricao as estado,  rt.descricao as tipo, r.funcional				                  					 
			  from (    select substr(sys_connect_by_path(case when length(titulo) < 25 then titulo else substr(titulo,1,25) || '...' end , ' -> '),5) as path,
							   cod_requisito as codigo_completo,
							   requisito_id, requisito_pai, cod_requisito, titulo, 
							   escopo, tipo_id, estado_id,  connect_by_isleaf as folha,  level as nivel,
					   connect_by_root  requisito_id  as requisito_id_raiz, funcional
						  from kmm.v$requisito
						start with requisito_pai is null
						connect by prior requisito_id = requisito_pai
						order siblings by requisito_id	) r
				 inner join kmm.v$cg_ref_codes rs
						 on rs.id = r.estado_id
						and rs.dominio = 'STATUS REQUISITO'
				 <cfif Len(Trim(arguments.PROJETO_ID))>
				 inner join kmm.v$projeto_requisito pr
						on pr.requisito_id = r.requisito_id
					   and pr.projeto_id = #arguments.PROJETO_ID#
			     </cfif>
				 left join kmm.v$cg_ref_codes rt
						 on rt.id = r.tipo_id
						and rt.dominio = 'TIPO REQUISITO'
			  where 1=1
			  <cfif Len(Trim(arguments.COD_REQUISITO))>
			   and upper(r.cod_requisito) like upper('%#arguments.COD_REQUISITO#%')
			  </cfif>
			  <cfif Len(Trim(arguments.TITULO))>
			   and upper(r.titulo) like upper('%#arguments.TITULO#%')
			  </cfif>
			  order by  r.codigo_completo
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca requisitos
	-- GUTO - 03/07/2006
	--->		
	<cffunction name="get_requisito" access="remote" returntype="query" output="true">
		<cfargument name="requisito_id" required="no" default=""/>
		<cfargument name="cod_requisito" required="no" default=""/>
		<cfargument name="titulo" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select r.requisito_id, r.requisito_pai, r.cod_requisito, r.titulo, 
				   r.escopo, r.tipo_id, r.estado_id, 
				   rs.descricao as estado, rt.descricao as tipo, r.funcional
			  from kmm.v$requisito r

				 inner join kmm.v$cg_ref_codes rs
						 on rs.id = r.estado_id
						and rs.dominio = 'STATUS REQUISITO'
				 left join kmm.v$cg_ref_codes rt
						 on rt.id = r.tipo_id
						and rt.dominio = 'TIPO REQUISITO'
		     where 1=1
			  <cfif Len(Trim(arguments.COD_REQUISITO))>
			   and upper(r.cod_requisito) like upper('%#arguments.COD_REQUISITO#%')
			  </cfif>
			  <cfif Len(Trim(arguments.REQUISITO_ID))>
			   and r.requisito_id = #arguments.REQUISITO_ID#
			  </cfif>
			  <cfif Len(Trim(arguments.TITULO))>
			   and r.titulo like '%#arguments.TITULO#%'
			  </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>		
	
	<!--- 
	-- PROPSITO 
	-- Busca requisitos vinculados
	-- GUTO - 03/07/2006
	--->		
	<cffunction name="get_requisito_vinculo" access="remote" returntype="query" output="true">
		<cfargument name="requisito_id_1" required="no" default="" />
		<cfargument name="requisito_id_2" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select rv.requisito_id_1, r1.titulo as titulo_1, requisito_id_2, r2.titulo as titulo_2
			  from kmm.v$requisito_vinculo rv
			 inner join kmm.v$requisito r1
			         on r1.requisito_id = rv.requisito_id_1
			 inner join kmm.v$requisito r2
			         on r2.requisito_id = rv.requisito_id_2
			 where 1=1
			 <cfif Len(Trim(arguments.requisito_id_1))>
			   and requisito_id_1 = #arguments.requisito_id_1#
			 </cfif>
			 <cfif Len(Trim(arguments.requisito_id_2))>
			   and requisito_id_2 = #arguments.requisito_id_2#
			 </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
		
	<!--- 
	-- PROPSITO 
	-- Busca os tipos de requisito
	-- GUTO - 01/07/2006
	--->		
	<cffunction name="get_requisito_tipo" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select tipo_id, descricao, funcional
			  from kmm.v$requisito_tipo
			 order by tipo_id
  		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	


	

	<!--- 
	-- PROPSITO 
	-- Busca os estados do requisito
	-- GUTO - 01/07/2006
	--->		
	<cffunction name="get_requisito_estado" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select estado_id, descricao, cor_hexadecimal
			  from kmm.v$requisito_estado	
			 order by estado_id
   		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca uma tarefa
	-- CRISTOFER  13/09/2006
	--->		
	<cffunction name="get_tarefa" access="remote" returntype="query" output="true">
		<cfargument name="tarefa_id" required="no" default="">
		<cfargument name="sd_id" required="no" default="">
		<cfargument name="hide_clobs" required="no" default="0">
		<cfargument name="atribuida" required="no" default="">
		<cfargument name="participa" required="no" default="">
		<cfargument name="minhas_tarefas" required="no" default="">
		<cfargument name="projeto_id" required="no" default="">
		<cfargument name="reuniao_id" required="no" default="">
		<cfargument name="requisito_id" required="no" default="">
		<cfargument name="alteracao_id" required="no" default="">
		<cfargument name="aplicacao_id" required="no" default="">
		<cfargument name="etapa_id" required="no" default="">
		<cfargument name="cliente_id" required="no" default="">
		<cfargument name="tipo_aplicacao_id" required="no" default="">
		<cfargument name="tecnico" required="no" default="">
		<cfargument name="data_limite_inicial" required="no" default="">
		<cfargument name="data_limite_final" required="no" default="">
		<cfargument name="urgencia_id" required="no" default="">
		<cfargument name="solicitacao_id" required="no" default="">
		<cfargument name="finalizadas" required="no" default="0">
		<cfargument name="status" required="no" default="">
		<cfargument name="rejeitadas" required="no" default="0">
		<cfargument name="tipo_id" required="no" default="">
		<cfargument name="descricao" required="no" default="">
		<cfargument name="num_ticket" required="no" default="">
        <cfargument name="disponiveis" required="no" default="0">
        <cfargument name="recurso_id" required="no" default="">
        <cfargument name="liberada_desenvolvimento" required="no" default="">
        <cfargument name="participantes" required="no" default="">
        
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select a.tarefa_id, 
            	   a.data_lancamento, 
                   a.num_ticket, 
                   a.aplicacao_id, 
                   a.aplicacao, 
                   a.contato, 
                   a.contato_nome, 
                   a.tipo_id, 
                   a.tipo, 
                   a.urgencia_id, 
                   a.urgencia, 
                   a.titulo, 
                   a.prioridade_kmm, 
                   a.descricao, 
                   to_char(a.entregar_em, 'dd/mm/yyyy') as entregar_em, 
                   a.finalizada_em, 
                   a.data_limite, 
                   a.prazo_atribuicao, 
                   a.tempo_estimado, 
                   a.tempo_estimado_total, 
                   a.horas_estimado, 
                   a.minutos_estimado, 
                   a.tempo_realizado, 
                   a.horas_realizado, 
                   a.minutos_realizado, 
                   a.atribuicao_id, 
                   a.grupo_etapas, 
                   a.grupo_habilidades, 
                   a.nro_habilidades, 
                   a.date_insert, 
                   a.user_insert, 
                   a.date_update, 
                   a.user_update, 
                   a.analise_id, 
                   a.site, 
                   a.tarefa_pai, 
                   a.tamanho_id, 
                   a.complexidade_id, 
                   a.descricao_pai, 
                   a.status, 
                   a.status_descricao, 
                   a.atribuida, 
                   a.projeto_id, 
                   a.etapa_id, 
                   a.etapa_id_tarefa, 
                   a.etapa_tarefa, 
                   a.etapa, 
                   a.tipo_aplicacao, 
                   a.etapa_id_anterior, 
                   a.etapa_anterior, 
                   a.etapa_id_proxima, 
                   a.etapa_proxima, 
                   a.nome_cliente, 
                   a.tipo_aplicacao_id, 
                   a.tempo_total_gasto, 
                   a.percentual_concluida, 
                   a.tempo_estimado_restante, 
                   a.sd_detalhamento_id, 
                   a.sd_id, 
                   a.sd_codigo, 
                   a.sd_titulo, 
                   a.sd_tipo_tarefa, 
                   a.atraso, 
                   a.premio_situacao, 
                   a.premio_situacao_id, 
                   a.liberada_desenvolvimento,
                   to_char(s.data_entrega_cliente,'dd/mm/yyyy hh24:mi:ss') as data_entrega_cliente,
                   s.data_entrega_nivel,
                   s.data_entrega_situacao_id,
                   a.modulo_id,
                   a.modulo,
                   a.modulo_equipe
              from 
            (select /*+ ordered */ t.tarefa_id,
				   t.data_lancamento, t.num_ticket,
				   t.aplicacao_id,
				   a.descricao as aplicacao,
				   t.contato,
				   r.nome as contato_nome,
				   t.tipo_id,
				   tp.descricao as tipo,
				   t.urgencia_id,
				   ur.descricao as urgencia,
				   t.titulo,
				   <cfif arguments.hide_clobs neq 1>
				   t.descricao,
				   </cfif>
				   t.entregar_em,
                   to_char(t.finalizada_em,'dd/mm/yyyy') as finalizada_em, 
                   nvl(te.data_limite, (select min(te2.data_limite) from kmm.v$tarefa_etapa te2 where te2.tarefa_id = t.tarefa_id)) data_limite, 
                   to_char(case t.status
                              when 1 then
                                 case t.tipo_id
                                    when 1 then least(t.entregar_em,trunc(sysdate))
                                    else kmm.pkg_tarefa.fnc_prazo_atribuicao(t.tempo_estimado,t.entregar_em)
                                 end
                              else null
                           end,'dd/mm/yyyy') as prazo_atribuicao,
				   kss.to_tempo(coalesce(te.tempo_estimado,t.tempo_estimado),3).retorno as tempo_estimado, 
                   t.tempo_estimado as tempo_estimado_int,
				   kss.to_tempo(t.tempo_estimado,3).retorno as tempo_estimado_total, 
				   kmm.pkg_global.fnc_get_horas_intervalo(t.tempo_estimado) horas_estimado,
				   extract(minute from t.tempo_estimado) minutos_estimado,
				   replace(to_char(t.tempo_realizado),'+','') as tempo_realizado,
				   kmm.pkg_global.fnc_get_horas_intervalo(t.tempo_realizado) horas_realizado,
				   extract(minute from t.tempo_realizado) minutos_realizado,
				   t.atribuicao_id,
                   kmm.pkg_tarefa.fnc_etapa_grupo_disponivel(t.tarefa_id,'#arguments.recurso_id#') as grupo_etapas,
                   kmm.pkg_tarefa.fnc_etapa_grupo_habilidade(t.tarefa_id,'#arguments.recurso_id#') as grupo_habilidades,
                   (select count(*)
                      from kmm.v$tarefa_habilidade th
                     where th.tarefa_id = t.tarefa_id) as nro_habilidades,
				   t.date_insert,
				   t.user_insert,
				   t.date_update,
				   t.user_update,
                   t.analise_id,
				   t.site,
				   t.tarefa_pai,
				   t.tamanho_id,
				   t.complexidade_id,
				   t2.titulo as descricao_pai,
               	   t.status,
                   st.descricao as status_descricao,
			       nvl(r2.nome, '&lt;&lt;' || (select max(rat.nome) keep(dense_rank first order by ce2.num_etapa)
                         from kmm.v$tarefa_etapa te2 
                        inner join kmm.v$ciclo_vida_etapa ce2
                                on ce2.etapa_id = te2.etapa_id 
                         left join kmm.v$recurso rat
                                on rat.recurso_id = te2.recurso_id
                        where te2.tarefa_id = t.tarefa_id
                          and (t.etapa_id is null or t.etapa_id = te2.etapa_id) ) || '&gt;&gt;') as atribuida,
				   pt.projeto_id,
				   ta.etapa_id,
                   t.etapa_id as etapa_id_tarefa,
                   (select ce2.descricao
                      from kmm.v$ciclo_vida_etapa ce2
                     where t.etapa_id = ce2.etapa_id) as etapa_tarefa,
				   case 
                      when t.status = 7 then 'Finalizada'
                   else nvl(cv.descricao,'NO ATRIBUIDA') end etapa,
				   tap.descricao as tipo_aplicacao,
				   cea.etapa_id etapa_id_anterior,
				   cea.descricao as etapa_anterior,
				   cep.etapa_id etapa_id_proxima,
				   cep.descricao etapa_proxima, 
				   cli.nome nome_cliente,
				   t.tipo_aplicacao_id,                   
                   (select kss.to_tempo(numtodsinterval(sum(coalesce(a2.tempo_minutos, 0)),'MINUTE'),3).retorno
                      from kmm.v$atendimento_suporte a2
                     where a2.num_tarefa = t.tarefa_id) as tempo_total_gasto,  
                   (select nvl(max(a2.percentual_tarefa)
                               keep(dense_rank last order by a2.atendimento_data),0)
                      from kmm.v$atendimento_suporte a2
                     where a2.num_tarefa = t.tarefa_id
                       and a2.atendimento_data >= trunc(ta.data_atribuicao)
                       and a2.tempo_termino is not null
                       and a2.atendimento_usuario = r2.nome) as percentual_concluida,
                    kss.to_tempo(numtodsinterval((select coalesce(max(a2.estimado_restante) keep(dense_rank last order by a2.atendimento_data),0)
                      from kmm.v$atendimento_suporte a2
                     where a2.num_tarefa = t.tarefa_id
                       and a2.atendimento_data >= trunc(ta.data_atribuicao)
                       and a2.tempo_termino is not null
                       and a2.atendimento_usuario = r2.nome),'MINUTE'),3).retorno as tempo_estimado_restante,
                     (select min(st.sd_detalhamento_id)
                        from kmm.v$sd_tarefa st
                       where st.tarefa_id = t.tarefa_id) as sd_detalhamento_id,
                     (select min(st.sd_id)
                        from kmm.v$sd_tarefa st
                       where st.tarefa_id = t.tarefa_id) as sd_id,
                     (select sd.codigo
                        from kmm.v$sd_tarefa st
                       inner join kmm.v$sd sd
                               on sd.sd_id = st.sd_id   
                       where st.tarefa_id = t.tarefa_id
                         and rownum = 1) as sd_codigo,
                     (select sd.prioridade_kmm
                        from kmm.v$sd_tarefa st
                       inner join kmm.v$sd sd
                               on sd.sd_id = st.sd_id   
                       where st.tarefa_id = t.tarefa_id
                         and rownum = 1) as prioridade_kmm,
                     (select sd.titulo
                        from kmm.v$sd_tarefa st
                       inner join kmm.v$sd sd
                               on sd.sd_id = st.sd_id   
                       where st.tarefa_id = t.tarefa_id
                         and rownum = 1) as sd_titulo,
                     (select st.tipo
                        from kmm.v$sd_tarefa st
                       inner join kmm.v$sd sd
                               on sd.sd_id = st.sd_id   
                       where st.tarefa_id = t.tarefa_id
                         and rownum = 1) as sd_tipo_tarefa,
                     (select sd.liberada_desenvolvimento
                        from kmm.v$sd_tarefa st
                       inner join kmm.v$sd sd
                               on sd.sd_id = st.sd_id   
                       where st.tarefa_id = t.tarefa_id
                         and rownum = 1) as liberada_desenvolvimento,
                     (select count(*) 
                        from kmm.v$tarefa_atraso a
                       where a.tarefa_id = t.tarefa_id
                         and a.recurso_id = te.recurso_id) as atraso 
                     ,(select cg.descricao
                         from kmm.v$cg_ref_codes cg
                        where cg.dominio = 'PREMIO SITUACAO'
                          and cg.id = t.premio_situacao) as premio_situacao
                     ,t.premio_situacao as premio_situacao_id
                     ,t.modulo_id
                     ,md.nome as modulo
                     ,(select eq.descricao
                         from kmm.v$equipe eq
                        where eq.equipe_id = md.equipe_id) as modulo_equipe
			  from kmm.v$tarefa t
			 inner join kmm.v$recurso r
					 on t.contato = r.recurso_id
			 inner join kmm.v$cg_ref_codes tp
					 on tp.id = t.tipo_id
					and tp.dominio = 'TIPO TAREFA'
			 inner join kmm.v$cg_ref_codes ur
					 on ur.id = t.urgencia_id
					and ur.dominio = 'URGENCIA TAREFA'
			 inner join kmm.v$cg_ref_codes st
					 on st.id = t.status
					and st.dominio = 'STATUS TAREFA'       
			 inner join kmm.v$cg_ref_codes tap
					 on tap.id = t.tipo_aplicacao_id
					and tap.dominio = 'TIPO APLICACAO TAREFA'     
			 left join kmm.v$aplicacao a
					 on a.aplicacao_id = t.aplicacao_id
			  left join kmm.v$tarefa t2
			         on t2.tarefa_id = t.tarefa_pai   
			  left join kmm.v$tarefa_atribuicao ta
			         on t.atribuicao_id = ta.atribuicao_id
		      left join kmm.v$ciclo_vida_etapa cv
			         on cv.etapa_id = ta.etapa_id
			  left join kmm.v$tarefa_etapa te 
			         on ta.etapa_id = te.etapa_id
					and te.tarefa_id = t.tarefa_id
			  left join kmm.v$recurso r2
			         on r2.recurso_id = ta.recurso_id
			  left join kmm.v$projeto_tarefa pt
			         on pt.tarefa_id = t.tarefa_id
			  left join kmm.v$projeto prj
			         on pt.projeto_id = prj.projeto_id
			  left join kmm.v$cliente cli
			         on cli.cliente_id = prj.cliente_id
              left join kmm.v$ciclo_vida_etapa cea 
                     on te.etapa_id_anterior = cea.etapa_id
              left join kmm.v$tarefa_etapa te2 
			         on te2.tarefa_id = t.tarefa_id
					and (te2.etapa_id_anterior = ta.etapa_id or (ta.etapa_id is null and te2.etapa_id_anterior is null))
              left join kmm.v$ciclo_vida_etapa cep 
			         on te2.etapa_id = cep.etapa_id
			  left join kmm.v$reuniao_tarefa rnt
			         on rnt.tarefa_id = t.tarefa_id
              left join kmm.v$modulo md
                     on md.modulo_id = t.modulo_id
                     
			 where 1=1
			 <cfif arguments.finalizadas eq 0 and not Len(Trim(arguments.TAREFA_ID)) and not Len(Trim(arguments.SD_ID))>
			   and t.status <> 7
			 </cfif>
			 <cfif len(trim(arguments.status)) and not Len(Trim(arguments.TAREFA_ID)) and not Len(Trim(arguments.SD_ID))>
			 	<cfif arguments.finalizadas eq 1>
					<cfset arguments.status = ListAppend(arguments.status,7,',')>
				</cfif>
			 	<cfif arguments.rejeitadas eq 1>
					<cfset arguments.status = ListAppend(arguments.status,8,',')>
				</cfif>
			   and t.status in (#listDeleteNulls(arguments.status)#)
			 </cfif>
			 <cfif arguments.rejeitadas eq 0 and not Len(Trim(arguments.TAREFA_ID))>
			   and t.status <> 8
			 </cfif>
			 <cfif len(trim(arguments.num_ticket))>
			   and t.num_ticket in (#arguments.num_ticket#)
			 </cfif>
			 <cfif len(trim(arguments.tarefa_id))>
			   and t.tarefa_id in (#arguments.tarefa_id#)
			 </cfif>
			 <cfif len(trim(arguments.alteracao_id)) and not Len(Trim(arguments.TAREFA_ID))>
			   and rt.alteracao_id in (#arguments.alteracao_id#)
			 </cfif>
			 <cfif len(trim(arguments.requisito_id)) and not Len(Trim(arguments.TAREFA_ID))>
			   and rt.requisito_id in (#arguments.requisito_id#)
			 </cfif>
			 <cfif len(trim(arguments.projeto_id)) and not Len(Trim(arguments.TAREFA_ID))>
			   and pt.projeto_id in (#arguments.projeto_id#)
			 </cfif>
			 <cfif len(trim(arguments.atribuida)) and not len(trim(arguments.participa)) and not Len(Trim(arguments.TAREFA_ID))>
			   and upper(r2.nome) in (#ListQualify(arguments.atribuida, "'", ",")#)
			 </cfif>
			 <cfif len(trim(arguments.participa)) and not Len(Trim(arguments.TAREFA_ID))>
			   and exists (select 1 
                             from kmm.v$tarefa_etapa te3 
                            inner join kmm.v$recurso r3 
                                    on r3.recurso_id = te3.recurso_id 
                            where te3.tarefa_id = t.tarefa_id
                              and upper(r3.nome) = upper('#arguments.participa#'))
               <cfif Len(Trim(arguments.minhas_tarefas))>
               	and t.tarefa_id not in (#arguments.minhas_tarefas#)
               </cfif>
               and t.status <> 1
			 </cfif>
             <cfif len(trim(arguments.participantes)) and not Len(Trim(arguments.TAREFA_ID))>
			   and exists (select 1 
                             from kmm.v$tarefa_etapa te3 
                            where te3.tarefa_id = t.tarefa_id
                              and upper(te3.recurso_id) in (#ListQualify(ucase(arguments.participantes),"'",',')#)) 
               and t.status <> 1
			 </cfif>
			 <cfif len(trim(arguments.reuniao_id)) and not Len(Trim(arguments.TAREFA_ID))>
			   and rnt.reuniao_id = #arguments.reuniao_id#
			 </cfif>
			 <cfif len(trim(arguments.solicitacao_id)) and not Len(Trim(arguments.TAREFA_ID))>
			   and rsl.solicitacao_id = #arguments.solicitacao_id#
			 </cfif>

			<cfif len(trim(arguments.tipo_id)) and not Len(Trim(arguments.TAREFA_ID))>
			   and t.tipo_id in (#arguments.tipo_id#)
			</cfif>
			<cfif len(trim(arguments.descricao)) and not Len(Trim(arguments.TAREFA_ID))>
			   and ( upper(to_char(t.descricao)) like upper('%#arguments.DESCRICAO#%') or upper(t.titulo) like upper('%#arguments.DESCRICAO#%') )
			</cfif>
            <cfif Len(Trim(arguments.etapa_id)) and not Len(Trim(arguments.TAREFA_ID))>
               and ta.etapa_id in (#arguments.etapa_id#)
            </cfif>
			<cfif len(trim(arguments.cliente_id)) and not Len(Trim(arguments.TAREFA_ID))>
			   and prj.cliente_id in (#ListDeleteNulls(arguments.cliente_id)#)
			</cfif>
			<cfif len(trim(arguments.tipo_aplicacao_id)) and not Len(Trim(arguments.TAREFA_ID))>
			   and t.tipo_aplicacao_id in (#arguments.tipo_aplicacao_id#)
			</cfif>
			<cfif len(trim(arguments.tecnico)) and not Len(Trim(arguments.TAREFA_ID))>
			   and ta.recurso_id in (#arguments.tecnico#)
			</cfif>
			<cfif len(trim(data_limite_inicial)) and not Len(Trim(arguments.TAREFA_ID))>
			   and trunc(t.entregar_em) >= '#arguments.data_limite_inicial#'
			</cfif>
			<cfif len(trim(data_limite_final)) and not Len(Trim(arguments.TAREFA_ID))>
			   and trunc(t.entregar_em) <= '#arguments.data_limite_final#'
			</cfif>
			<cfif len(trim(urgencia_id)) and not Len(Trim(arguments.TAREFA_ID))>
			   and t.urgencia_id in (#arguments.urgencia_id#)
			</cfif>
			<cfif arguments.disponiveis eq 1>
            ) a 
            left join kmm.v$sd s
                     on s.sd_id = a.sd_id
            where 1=1
               and a.status not in (7,8)
               and (a.status = 1 or exists (select 0
                             from kmm.v$tarefa_etapa te2
                            inner join kmm.v$ciclo_vida_etapa ce2
                                    on ce2.etapa_id = te2.etapa_id
                            where te2.tarefa_id = a.tarefa_id
                              and kmm.pkg_tarefa.fnc_grupo_etapa_disponivel(a.tarefa_id,ce2.grupo_id) = 1
				              and nvl(te2.recurso_id,'#arguments.recurso_id#') = '#arguments.recurso_id#')
               )
             order by case a.tipo_id
                         when 1 then 0
                         else 1
                      end,
                      case a.tipo_id
                         when 1 then least(a.entregar_em,trunc(sysdate))
                         else kmm.pkg_tarefa.fnc_prazo_atribuicao(a.tempo_estimado_int,a.entregar_em)
                      end, 
                      /* No considera o peso do grupo como o procedimento */
                      a.urgencia_id,
                      a.tempo_estimado desc,
                      a.tarefa_id
            <cfelse>
            ) a 
            left join kmm.v$sd s
                     on s.sd_id = a.sd_id
            where 1=1
             <cfif Len(Trim(arguments.SD_ID))>
                and a.sd_id = #arguments.SD_ID#
             </cfif>
 			 <cfif len(trim(arguments.liberada_desenvolvimento))>
			   and a.liberada_desenvolvimento in (#arguments.liberada_desenvolvimento#)
			 </cfif>
			 order by a.entregar_em 
            </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca as dependencias da tarefa
	-- CRISTOFER  14/09/2006
	--->		
	<cffunction name="get_tarefa_dependencia" access="remote" returntype="query" output="true">
		<cfargument name="tarefa_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select dp.tarefa_id,
				   dp.tarefa_id_dependencia,
				   t.titulo,
				   dp.date_insert,
				   dp.user_insert,
				   dp.date_update,
				   dp.user_update,
				   dp.site
			  from kmm.v$tarefa_dependencia dp
			 inner join kmm.v$tarefa t
			         on t.tarefa_id = dp.tarefa_id_dependencia			  
			 where dp.tarefa_id = #arguments.tarefa_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>  			
	
	<!--- 
	-- PROPSITO 
	-- Busca as atribuicoes da tarefa
	-- CRISTOFER  15/09/2006
	--->		
	<cffunction name="get_tarefa_atribuicao" access="remote" returntype="query" output="true">
		<cfargument name="tarefa_id" required="yes">
		<cfargument name="atual" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select a.atribuicao_id,
				   a.tarefa_id,
				   a.recurso_id,
				   a.data_atribuicao,
				   a.data_baixa,
				   a.comentario_atribuicao,
				   a.comentario_baixa,
				   a.date_insert,
				   a.user_insert,
				   a.date_update,
				   a.user_update,
				   a.site,
				   a.tipo_id,
				   a.atribuicao_id_origem
			  from kmm.v$tarefa_atribuicao a
			 inner join kmm.v$tarefa t
			         on a.tarefa_id = t.tarefa_id
		     where a.tarefa_id = #arguments.tarefa_id#
			 <cfif arguments.atual eq 1>
			   and a.atribuicao_id = t.atribuicao_id
			 </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca o tempo decorrido na execucao da tarefa
	-- CRISTOFER  15/09/2006
	--->		
	<cffunction name="get_tempo_execucao_tarefa" access="remote" returntype="query" output="true">
		<cfargument name="tarefa_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select kmm.pkg_global.fnc_get_horas_intervalo(tempo) horas,
				   extract(minute from tempo) minutos				   
			  from (select kmm.pkg_tarefa.fnc_get_tempo_tarefa(#arguments.tarefa_id#) tempo
			          from dual)
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca a ultima atribuicao da tarefa do tipo
	-- CRISTOFER  15/09/2006
	--->		
	<cffunction name="get_ultimas_atribuicoes_tarefa" access="remote" returntype="query" output="true">
		<cfargument name="tarefa_id" required="yes">
		<cfargument name="tipo_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select atribuicao_id, recurso_id
			  from kmm.v$tarefa_atribuicao
			 where tarefa_id = #arguments.tarefa_id#
			   and tipo_id = 1
			 start with atribuicao_id_origem is null
		   connect by prior atribuicao_id = atribuicao_id_origem
 			 order by level desc
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca as ocorrencias da tarefa
	-- CRISTOFER  18/09/2006
	--->		
	<cffunction name="get_tarefa_ocorrencia" access="remote" returntype="query" output="true">
		<cfargument name="tarefa_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select o.ocorrencia_id,
				   o.ocorrencia_tipo_id,
				   t.ocorrencia_tipo as tipo,
				   ot.tarefa_id,
				   o.ocorrencia,
				   o.tecnico,
				   o.complemento,
				   to_char(o.date_insert,'dd/mm/yyyy hh24:mi') as date_insert
			  from kmm.v$ocorrencia o 
			 inner join kmm.v$ocorrencia_tipo t
					 on t.ocorrencia_tipo_id = o.ocorrencia_tipo_id
			 inner join kmm.v$tarefa_ocorrencia ot
					 on ot.ocorrencia_id = o.ocorrencia_id
			 where o.ocorrencia_origem_id = 2
			   and tarefa_id = #arguments.tarefa_id#
			 order by ot.tarefa_id, o.date_insert
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>       

	<!--- 
	-- PROPSITO 
	-- Busca as ocorrencias da SD
	-- CRISTOFER  18/09/2006
	--->		
	<cffunction name="get_sd_ocorrencia" access="remote" returntype="query" output="true">
		<cfargument name="sd_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select o.ocorrencia_id,
				   o.ocorrencia_tipo_id,
				   t.ocorrencia_tipo as tipo,
				   os.sd_id,
				   o.ocorrencia,
				   o.tecnico,
				   o.complemento,
				   to_char(o.date_insert,'dd/mm/yyyy hh24:mi') as date_insert
			  from kmm.v$ocorrencia o 
			 inner join kmm.v$ocorrencia_tipo t
					 on t.ocorrencia_tipo_id = o.ocorrencia_tipo_id
			 inner join kmm.v$sd_ocorrencia os
					 on os.ocorrencia_id = o.ocorrencia_id
			 where o.ocorrencia_origem_id = 2
			   and os.sd_id = #arguments.sd_id#
			 order by os.sd_id, o.date_insert
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>       


	<!--- 
	-- PROPSITO 
	-- Busca os tipos de ocorrencia
	-- CRISTOFER  18/09/2006
	--->		
	<cffunction name="get_ocorrencia_tipo" access="remote" returntype="query" output="true">
		<cfargument name="ocorrencia_tipo_id" required="no" default="">
		<cfargument name="predefinida" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ocorrencia_tipo_id,
				   ocorrencia_tipo,
				   predefinida,
				   ativo,
				   user_insert,
				   date_insert,
				   user_update,
				   date_update,
				   site
			  from kmm.v$ocorrencia_tipo
			 where ativo = 1
			 <cfif len(trim(arguments.predefinida))>
			   and predefinida = #arguments.predefinida#
			 </cfif>
			 <cfif len(trim(arguments.ocorrencia_tipo_id))>
			   and ocorrencia_tipo_id = #arguments.ocorrencia_tipo_id#
			 </cfif>
			 order by ocorrencia_tipo_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>  	
	
	<!--- 
	-- PROPSITO 
	-- Busca as perguntas da tarefa
	-- CRISTOFER  18/09/2006
	--->		
	<cffunction name="get_tarefa_checklist" access="remote" returntype="query" output="true">
		<cfargument name="tarefa_id" required="no" default="">
		<cfargument name="atribuicao_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select tc.checklist_id,
				   tc.pergunta_id,
				   p.descricao as pergunta,
				   tc.tarefa_id,
				   tc.comentario,
			<cfif len(trim(arguments.atribuicao_id))>
				   nvl(tcv.verificado,0) verificado,
				   tcv.comentario as comentario_verificacao,
			</cfif>
				   tc.date_insert,
				   tc.user_insert,
				   tc.date_update,
				   tc.user_update,
				   tc.site
			  from kmm.v$tarefa_checklist tc
			 inner join kmm.v$pergunta p
					 on p.pergunta_id = tc.pergunta_id		
			<cfif len(trim(arguments.atribuicao_id))>
              left join kmm.v$tarefa_checklist_verificacao tcv
                     on tcv.checklist_id = tc.checklist_id
					and tcv.atribuicao_id = #arguments.atribuicao_id#
			</cfif>
		     where tc.tarefa_id = #arguments.tarefa_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	
	
	<!--- 
	-- PROPSITO 
	-- Busca o escopo do projeto
	-- CRISTOFER  19/09/2006
	--->		
	<cffunction name="get_projeto_escopo" access="remote" returntype="query" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select projeto_id,
				   descricao 
			  from kmm.v$projeto_escopo t
			 where projeto_id = #arguments.projeto_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca a limitacao do projeto
	-- CRISTOFER  19/09/2006
	--->		
	<cffunction name="get_projeto_limitacao" access="remote" returntype="query" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select projeto_id,
				   limitacao
			  from kmm.v$projeto_limitacao t
			 where projeto_id = #arguments.projeto_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as metas do projeto
	-- CRISTOFER  19/09/2006
	--->		
	<cffunction name="get_projeto_meta" access="remote" returntype="query" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select projeto_id,
				   meta_gerencial
			  from kmm.v$projeto_meta t
			 where projeto_id = #arguments.projeto_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os fatores
	-- CRISTOFER  19/09/2006
	--->		
	<cffunction name="get_fator" access="remote" returntype="query" output="true">
		<cfargument name="ambiental" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select fator_id,
				   descricao,
				   valor,
				   ambiental,
				   detalhes,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from kmm.v$fator
			 where 1=1
			 <cfif len(trim(arguments.ambiental))>
			   and ambiental = #arguments.ambiental#
			 </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os valores dos fatores no projeto
	-- CRISTOFER  20/09/2006
	--->		
	<cffunction name="get_projeto_fator" access="remote" returntype="query" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfargument name="ambiental" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select f.fator_id,
				   f.descricao,
				   nvl(pf.valor,f.valor) valor,
				   f.ambiental,
				   nvl(pf.avaliacao,0) avaliacao,
				   nvl(pf.valor,f.valor)*nvl(pf.avaliacao,0) as total,
				   pf.justificativa,
				   pf.projeto_fator_id,
				   f.detalhes
			  from kmm.v$fator f
			  left join kmm.v$projeto_fator pf
					 on f.fator_id = pf.fator_id
					and pf.projeto_id = #arguments.projeto_id#
			 where f.ambiental = #arguments.ambiental#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as categorias de risco
	-- CRISTOFER  20/09/2006
	--->		
	<cffunction name="get_risco_categoria" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select categoria_id,
				   descricao,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from kmm.v$risco_categoria
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca a tabela de exposicao dos riscos
	-- CRISTOFER  20/09/2006
	--->		
	<cffunction name="get_risco_exposicao" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select probabilidade_id,
				   impacto_id,
				   exposicao_id,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from kmm.v$risco_exposicao
			 order by probabilidade_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os custos do projeto
	-- CRISTOFER  21/09/2006
	--->		
	<cffunction name="get_projeto_custo" access="remote" returntype="query" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select projeto_id,
				   trf,
				   tft,
				   tfa,
				   pa,
				   total_produtividade,
				   esforco_total,
				   tamanho_equipe,
				   horas_mes,
				   estimativa_meses,
				   custo_hora,
				   custo_desenvolvimento,
				   custo_total,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from kmm.v$projeto_custo
			 where projeto_id = #projeto_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os custos complementares do projeto
	-- CRISTOFER  21/09/2006
	--->		
	<cffunction name="get_projeto_custo_complementar" access="remote" returntype="query" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfargument name="estimado" required="no" default="1">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select item_id,
				   projeto_id,
				   descricao,
				   valor,
				   realizacao,
				   tipo_id,
				   estimado,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from kmm.v$projeto_custo_complementar
			 where projeto_id = #arguments.projeto_id#
			 <cfif len(trim(arguments.estimado))>
			   and estimado = #arguments.estimado#
			 </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca o tempo estimado para as etapas
	-- CRISTOFER  22/09/2006
	--->		
	<cffunction name="get_estimado_etapas" access="remote" returntype="query" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfargument name="complexidade_id" required="yes">
		<cfargument name="tamanho_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select t.etapa_id, 
				   e.descricao as etapa,
				   kmm.pkg_global.fnc_get_horas_intervalo(tempo) horas,
				   extract(minute from tempo) minutos
			  from (select etapa_id, 
						   kmm.pkg_tarefa.fnc_estimado_etapa(projeto_id,
															 #arguments.tamanho_id#,
															 #arguments.complexidade_id#,
															 etapa_id) tempo
					  from kmm.v$projeto_ciclo_vida
					 where projeto_id = #arguments.projeto_id#) t
			 inner join kmm.v$ciclo_vida_etapa e
					 on e.etapa_id = t.etapa_id	
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    	
	<!--- 
	-- PROPSITO 
	-- Busca as etapas da tarefa
	-- CRISTOFER  22/09/2006
	--->		
	<cffunction name="get_tarefa_etapa" access="remote" returntype="query" output="true">
		<cfargument name="tarefa_id" required="no" default="">
		<cfargument name="etapa_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select te.tarefa_id,
				   te.etapa_id_anterior,
				   te.etapa_id,
				   kmm.pkg_global.fnc_get_horas_intervalo(te.tempo_estimado) horas_estimado,
				   lpad(extract(minute from te.tempo_estimado),2,'0') as minutos_estimado,
                   to_char(te.data_limite,'dd/mm/yyyy hh24:mi:ss') as data_limite,
                   te.recurso_id, 
                   r.nome_completo as tecnico, 
				   kmm.pkg_global.fnc_get_horas_intervalo(te.horas_pagas) horas_pagas,
				   lpad(extract(minute from te.horas_pagas),2,'0') as minutos_pagos,
				   to_char(te.date_insert,'dd/mm/yyyy hh24:mi:ss') as date_insert,
                   te.dias,
				   te.user_insert,
				   to_char(te.date_update,'dd/mm/yyyy hh24:mi:ss') as date_update,
				   te.user_update, ce.descricao  as etapa
			  from kmm.v$tarefa_etapa te
             inner join kmm.v$ciclo_vida_etapa ce
                     on ce.etapa_id = te.etapa_id
             left join kmm.v$recurso r
                     on r.recurso_id = te.recurso_id
			 where 1=1
             <cfif len(trim(arguments.tarefa_id))>
               and te.tarefa_id = #arguments.tarefa_id#
             </cfif>
             <cfif len(trim(arguments.etapa_id))>
               and te.etapa_id = #arguments.etapa_id#
             </cfif>
             order by te.etapa_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os planejamentos de reunio do projeto
	-- CRISTOFER  26/09/2006
	--->		
	<cffunction name="get_projeto_reuniao_planejamento" access="remote" returntype="query" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select planejamento_id,
				   projeto_id,
				   tipo_id,
				   descricao,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from kmm.v$projeto_reuniao_planejamento
			 where projeto_id = #arguments.projeto_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as reunioes
	-- CRISTOFER  26/09/2006
	--->		
	<cffunction name="get_reuniao" access="remote" returntype="query" output="true">
		<cfargument name="reuniao_id" required="no" default="">
		<cfargument name="titulo" required="no" default="">
		<cfargument name="tipo_id" required="no" default="">
		<cfargument name="status_id" required="no" default="">
		<cfargument name="projeto_id" required="no" default="">
		<cfargument name="recurso_id" required="no" default="">
        <cfargument name="cliente_id" required="no" default="">
        <cfargument name="filtro_recurso" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct r.reuniao_id,
				   pr.projeto_id,
				   r.titulo,
				   r.tipo_id,
				   r.local,
				   t.descricao as tipo,
                   to_char(r.data, 'dd/mm/yyyy hh24:mi') as data,
                   to_char(r.data, 'yyyy/mm/dd hh24:mi') as data_ordem,
				   r.status_id,
				   s.descricao as status,
				   r.date_insert,
				   r.user_insert,
				   r.date_update,
				   r.user_update,
				   r.site,
				   to_char(r.inicio, 'dd/mm/yyyy hh24:mi') as inicio,
				   to_char(r.termino, 'dd/mm/yyyy hh24:mi') as termino,
                   p.cliente_id,
                   p.titulo as projeto,
                   c.nome as cliente_nome 
			  from kmm.v$reuniao r
			 inner join kmm.v$cg_ref_codes t
					 on t.dominio = 'REUNIAO TIPO'
					and t.id = r.tipo_id
			 inner join kmm.v$cg_ref_codes s
					 on s.dominio = 'REUNIAO STATUS'             
					and s.id = r.status_id
			<cfif len(trim(arguments.recurso_id)) or len(trim(arguments.filtro_recurso))>
			 inner join kmm.v$reuniao_participante rp
			         on r.reuniao_id = rp.reuniao_id
			</cfif>
			  left join kmm.v$projeto_reuniao pr
			         on pr.reuniao_id = r.reuniao_id
			  left join kmm.v$projeto p
			         on p.projeto_id = pr.projeto_id
              left join kmm.v$cliente c
			         on c.cliente_id = p.cliente_id
			 where 1=1
            <cfif len(trim(arguments.filtro_recurso))>
			   and rp.recurso_id in (#arguments.filtro_recurso#)
			</cfif>
			<cfif len(trim(arguments.recurso_id))>
			   and rp.recurso_id in (#arguments.recurso_id#)
			</cfif>
			 <cfif len(trim(arguments.reuniao_id))>
			   and r.reuniao_id in (#arguments.reuniao_id#)
			 </cfif>
			 <cfif len(trim(arguments.titulo))>
			   and upper(r.titulo) like upper('%#arguments.titulo#%')
			 </cfif>
			 <cfif len(trim(arguments.tipo_id))>
			   and r.tipo_id in (#arguments.tipo_id#)
			 </cfif>
			 <cfif len(trim(arguments.status_id))>
			   and r.status_id in (#arguments.status_id#)
			 </cfif>
			 <cfif len(trim(arguments.projeto_id))>
			   and pr.projeto_id in (#arguments.projeto_id#)
			 </cfif>
			 order by data_ordem desc
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os participantes da reuniao
	-- CRISTOFER  27/09/2006
	--->		
	<cffunction name="get_reuniao_participante" access="remote" returntype="query" output="true">
		<cfargument name="reuniao_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select rp.participante_id,
				   rp.reuniao_id,
				   rp.recurso_id,
				   r.cliente,
                   r.cliente_id,
				   r.nome_completo as recurso,
				   r.descricao,
				   r.email,
				   rp.observacao,
				   rp.date_insert,
				   rp.user_insert,
				   rp.date_update,
				   rp.user_update,
				   rp.site,
                   rc.funcao_id,
                   rc.descricao as funcao_descricao,
                   c.nome as cliente_nome
			  from kmm.v$reuniao_participante rp
			 inner join kmm.v$recurso r
			         on r.recurso_id = rp.recurso_id
             inner join kmm.v$recurso_funcao rc 
             		 on rc.funcao_id = rp.funcao_id
             inner join kmm.v$cliente c 
             		 on c.cliente_id = r.cliente_id
			 where reuniao_id = #arguments.reuniao_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
		
	<!--- 
	-- PROPSITO 
	-- Busca os assuntos da reuniao
	-- CRISTOFER  27/09/2006
	--->		
	<cffunction name="get_reuniao_assunto" access="remote" returntype="query" output="true">
		<cfargument name="reuniao_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select assunto_id,
				   reuniao_id,
				   descricao,
				   conclusao,
				   discutido,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from kmm.v$reuniao_assunto    
			 where reuniao_id = #arguments.reuniao_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>


	<!--- 
	-- PROPSITO 
	-- Busca as tarefas dos assuntos da reuniao
	-- CRISTOFER  28/09/2006
	--->		
	<cffunction name="get_reuniao_assunto_tarefa" access="remote" returntype="query" output="true">
		<cfargument name="assunto_id" required="no" default="">
		<cfargument name="reuniao_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select rat.assunto_id,
				   rat.tarefa_id,
				   t.titulo,
				   rat.date_insert,
				   rat.user_insert,
				   rat.date_update,
				   rat.user_update,
				   rat.site
			  from kmm.v$reuniao_assunto_tarefa rat
			 inner join kmm.v$reuniao_assunto ra
					 on ra.assunto_id = rat.assunto_id
			 inner join kmm.v$tarefa t
					 on t.tarefa_id = rat.tarefa_id
			 where 1=1
			 <cfif len(trim(arguments.assunto_id))>
			   and rat.assunto_id = #arguments.assunto_id#
			 </cfif>
			 <cfif len(trim(arguments.reuniao_id))>
			   and ra.reuniao_id = #arguments.reuniao_id#	
			 </cfif>
			 order by rat.assunto_id, rat.tarefa_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca a hierarquia do projeto
	-- CRISTOFER  28/09/2006
	--->		
	<cffunction name="get_projeto_hierarquia" access="remote" returntype="query" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select t.id,
				   t.cod,
				   t.pai,
				   t.tipo,
				   t.titulo,
				   t.finalizado,
				   t.data
			  from kmm.v$projeto_hierarquia t
			 start with tipo = 'PROJETO' and id = #arguments.projeto_id#
		   connect by prior cod = pai
			 order siblings by ordem, t.titulo, t.data	
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os anexos
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="get_anexo" access="remote" returntype="query" output="true">
		<cfargument name="anexo_id" required="no" default="">
		<cfargument name="todos" required="no" default="0">
		<cfargument name="titulo" required="no" default="">
		<cfargument name="com_grupo" required="no" default="1">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select 
				<cfif arguments.com_grupo eq 1>
					distinct replace(replace(sys_connect_by_path(ag.descricao,'-/-'),'-/-','/')||'/','/Raiz/','/') as path,
				   upper(a.titulo) as titulo_upper,
				</cfif>
			       a.titulo,
				   a.anexo_id,
				   ag.descricao as grupo,
				   a.url,
				   a.permite_excluir,
				   a.user_insert,
				   a.grupo_id
			  from kmm.v$anexo_grupo ag 
 			  left join kmm.v$anexo a
					 on ag.grupo_id = a.grupo_id
			 where 1 = 1
			   and a.anexo_id is not null
			 <cfif arguments.todos eq 0>
			   and (a.permite_excluir = 1 or a.user_insert = user)
			 </cfif>
			 <cfif len(trim(arguments.titulo))>
			   and upper(a.titulo) like upper('%#arguments.titulo#%')
			 </cfif>
			 <cfif len(trim(arguments.anexo_id))>
			   and a.anexo_id = #arguments.anexo_id#
			 </cfif>
			<cfif arguments.com_grupo eq 1>
			 start with ag.grupo_id = 0
			connect by prior ag.grupo_id = ag.grupo_pai_id
			 order siblings by upper(a.titulo)
 			</cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca os grupos de anexos
	-- CRISTOFER  11/05/2006
	--->		
	<cffunction name="get_anexo_grupo" access="remote" returntype="query" output="true">

		<cfargument name="raiz" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select grupo_id,
				   grupo_pai_id,
				   nvl(grupo_pai_id,0) as grupo_pai_id_nvl,
				   descricao,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from kmm.v$anexo_grupo	
			 where 1=1
			   and grupo_id <> 0
		     start with grupo_pai_id = #arguments.raiz#
		   connect by prior grupo_id = grupo_pai_id
		     order siblings by descricao			   
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca os anexos do projeto
	-- CRISTOFER  02/10/2006
	--->		
	<cffunction name="get_projeto_anexo" access="remote" returntype="query" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select pa.projeto_anexo_id,
				   pa.projeto_id,
				   pa.anexo_id,
				   a.titulo,
				   a.url,
				   pa.date_insert,
				   pa.user_insert,
				   pa.date_update,
				   pa.user_update,
				   pa.site
			  from kmm.v$projeto_anexo pa
			 inner join kmm.v$anexo a
					 on a.anexo_id = pa.anexo_id	
			 where pa.projeto_id = #arguments.projeto_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os anexos do projeto
	-- CRISTOFER  02/10/2006
	--->		
	<cffunction name="get_projeto_wbs_anexo" access="remote" returntype="query" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select pa.projeto_id,
				   pa.anexo_id,
				   a.titulo,
				   a.url,
				   pa.date_insert,
				   pa.user_insert,
				   pa.date_update,
				   pa.user_update,
				   pa.site
			  from kmm.v$projeto_wbs_anexo pa
			 inner join kmm.v$anexo a
					 on a.anexo_id = pa.anexo_id	
			 where pa.projeto_id = #arguments.projeto_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca os paniel para tarefas
	-- GUTO  02/10/2006
	--->		
	<cffunction name="get_tarefa_painel" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select tipo_id, tipo, descricao, 
			       total, tempo_estimado 
		      from kmm.v$tarefa_painel
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca os anexos da tarefa
	-- CRISTOFER  04/10/2006
	--->		
	<cffunction name="get_tarefa_anexo" access="remote" returntype="query" output="true">
		<cfargument name="tarefa_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ta.tarefa_id,
				   ta.anexo_id,
				   a.titulo,
				   a.url,
				   ta.date_insert,
				   ta.user_insert,
				   ta.date_update,
				   ta.user_update,
				   ta.site
			  from kmm.v$tarefa_anexo ta
			 inner join kmm.v$anexo a
			         on a.anexo_id = ta.anexo_id
			 where 1=1
			   and tarefa_id = #arguments.tarefa_id#
			 order by tarefa_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca aplicaes
	-- NOTAS EXPLICATIVAS
	-- ARLEN 05/10/2006
	--->
	<cffunction name="get_aplicacao" returntype="query" access="remote">
		<cfargument name="aplicacao_id" required="yes" default="">
		<cfargument name="aplicacao" required="yes" default="">
		<cfargument name="descricao" required="yes" default="">
		<cfargument name="ativo" required="no" default="1">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
 			 select aplicacao_id, aplicacao, descricao, ativo 
			   from kmm.v$aplicacao
			  where 1=1
  			  <cfif Len(Trim(arguments.aplicacao_id))>
			 	and aplicacao_id = #arguments.aplicacao_id#
			  </cfif>
  			  <cfif Len(Trim(arguments.aplicacao))>
			 	and upper(aplicacao) like upper('%#arguments.aplicacao#%')
			  </cfif>
			    and ativo = #arguments.ativo#
			  order by aplicacao
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os arquivos da tarefa
	-- CRISTOFER  05/10/2006
	--->		
	<cffunction name="get_tarefa_arquivo" access="remote" returntype="query" output="true">
		<cfargument name="tarefa_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ta.tarefa_id,
				   ta.arquivo_id,
				   a.nome,
				   kmm.pkg_arquivo.FNC_GET_CAMINHO_DIRETORIO(a.diretorio_id) as caminho,
				   a.comentario,
				   ta.date_insert,
				   ta.user_insert,
				   ta.date_update,
				   ta.user_update,
				   ta.site
			  from kmm.v$tarefa_arquivo ta
			 inner join kmm.v$arquivo a
					 on a.arquivo_id = ta.arquivo_id
		     where ta.tarefa_id = #arguments.tarefa_id# 			
		</cfquery>
		<cfreturn qr_result>		
	</cffunction> 

	<!--- 
	-- PROPSITO 
	-- Busca os anexos da reuniao
	-- CRISTOFER  06/10/2006
	--->		
	<cffunction name="get_reuniao_anexo" access="remote" returntype="query" output="true">
		<cfargument name="reuniao_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ra.reuniao_id,
				   ra.anexo_id,
				   a.titulo,
				   a.url,
				   ra.date_insert,
				   ra.user_insert,
				   ra.date_update,
				   ra.user_update,
				   ra.site
			  from kmm.v$reuniao_anexo ra
			 inner join kmm.v$anexo a
			         on a.anexo_id = ra.anexo_id
			 where ra.reuniao_id = #arguments.reuniao_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca o tempo executado das tarefas
	-- CRISTOFER  09/10/2006
	--->		
	<cffunction name="get_projeto_tarefa_executado" access="remote" returntype="query" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cve.etapa_id,
				   cve.descricao as etapa,
				   count(*) as nro,
--				   numtodsinterval(sum(sysdate + tet.tempo_estimado - sysdate),'day') tempo_estimado,
				   to_char(numtodsinterval(sum(sysdate + te.tempo_execucao - sysdate),'day'),'hh24:mi:ss') tempo,
				   sum(sysdate + tet.tempo_estimado - sysdate) * 24 horas_estimado,
				   sum(sysdate + nvl(te.tempo_execucao,kmm.pkg_tarefa.FNC_GET_TEMPO_TAREFA(t.tarefa_id)) - sysdate) * 24 horas,
				   round(((sum(sysdate + te.tempo_execucao - sysdate) * 24)/(sum(sysdate + tet.tempo_estimado - sysdate) * 24)) * 100,2) perc,
				   sum(sum(sysdate + nvl(te.tempo_execucao,kmm.pkg_tarefa.FNC_GET_TEMPO_TAREFA(t.tarefa_id)) - sysdate) * 24) over (order by cve.etapa_id,cve.descricao rows between unbounded preceding and unbounded following),
			       (sum(sysdate + nvl(te.tempo_execucao,kmm.pkg_tarefa.FNC_GET_TEMPO_TAREFA(t.tarefa_id)) - sysdate) * 24) * nvl(pc.custo_hora,0) as custo
			  from kmm.v$projeto_ciclo_vida pcv
			 inner join kmm.v$ciclo_vida_etapa cve
					 on cve.etapa_id = pcv.etapa_id
			 inner join kmm.v$projeto_tarefa pt
					 on pt.projeto_id = pcv.projeto_id
			 inner join kmm.v$tarefa_etapa tet
					 on tet.tarefa_id = pt.tarefa_id
					and pcv.etapa_id = tet.etapa_id
			 inner join kmm.v$tarefa_atribuicao ta
					 on ta.tarefa_id = pt.tarefa_id
					and pcv.etapa_id = ta.etapa_id
			 inner join kmm.v$tarefa_execucao te
					 on te.atribuicao_id = ta.atribuicao_id
			 inner join kmm.v$tarefa t
					 on t.tarefa_id = pt.tarefa_id
			  left join kmm.v$projeto_custo pc 
			   		 on pc.projeto_id = pcv.projeto_id
			 where pcv.projeto_id = #arguments.projeto_id#
			 group by cve.etapa_id,cve.descricao,pc.custo_hora  
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>


	<!--- 
	-- PROPSITO 
	-- Busca as alteraes do requisito
	-- CRISTOFER  10/10/2006
	--->		
	<cffunction name="get_requisito_alteracao_titulo" access="remote" returntype="query" output="true">
		<cfargument name="requisito_id" required="yes">
		<cfargument name="projeto_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select alteracao_id,
				   requisito_id,
				   projeto_id,
				   tipo_id,
				   status_id,
				   planejamento,
				   tamanho_id,
				   complexidade_id,
				   solicitacao_id,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site,
				   titulo
			  from kmm.v$requisito_alteracao
			 where requisito_id = #arguments.requisito_id#
			   and projeto_id = #arguments.projeto_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca o tempo estimado no projeto para a complexidade
	-- CRISTOFER  11/10/2006
	--->		
	<cffunction name="get_projeto_tempo_estimado" access="remote" returntype="query" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfargument name="complexidade_id" required="yes">
		<cfargument name="tamanho_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select kmm.pkg_global.FNC_GET_HORAS_INTERVALO(tempo) as horas,
				   lpad(extract(minute from tempo),2,'0') as minutos
			  from (select kmm.pkg_projeto.FNC_GET_TEMPO_ESTIMADO(#arguments.projeto_id#,#arguments.tamanho_id#,#arguments.complexidade_id#) tempo
					  from dual)	
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca as alteracoes de requisito do projeto
	-- CRISTOFER  11/10/2006
	--->		
	<cffunction name="get_requisito_alteracao_lista" access="remote" returntype="query" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfargument name="solicitacao_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select r.requisito_id,
				   r.cod_requisito,
				   r.titulo requisito,
				   ra.alteracao_id,
				   ra.titulo,
				   ra.descricao,
				   ra.status_id,
				   ra.solicitacao_id,
				   st.descricao status,
				   (select count(*)
				      from kmm.v$requisito_tarefa rt
					 inner join kmm.v$projeto_tarefa pt
					         on pt.tarefa_id = rt.tarefa_id
					 where rt.requisito_id = pr.requisito_id
					   and rt.alteracao_id = ra.alteracao_id
					   and pt.projeto_id = pr.projeto_id) nro_tarefas
			  from kmm.v$projeto_requisito pr
			 inner join kmm.v$requisito r
					 on r.requisito_id = pr.requisito_id
			 inner join kmm.v$requisito_alteracao ra
					 on ra.requisito_id = pr.requisito_id
					and ra.projeto_id = pr.projeto_id
			 inner join kmm.v$cg_ref_codes st
					 on st.id = ra.status_id
					and dominio = 'STATUS REQUISITO'		
			 where pr.projeto_id = #arguments.projeto_id#
			 <cfif len(trim(arguments.solicitacao_id))>
			   and ra.solicitacao_id = #arguments.solicitacao_id#
			 </cfif>
			 order by r.cod_requisito, ra.date_insert
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca a alteracao de requisito
	-- CRISTOFER  11/10/2006
	--->		
	<cffunction name="get_requisito_alteracao" access="remote" returntype="query" output="true">
		<cfargument name="alteracao_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ra.alteracao_id,
				   ra.requisito_id,
				   ra.projeto_id,
				   ra.tipo_id,
				   tp.descricao tipo,
				   ra.status_id,
				   st.descricao status,
				   ra.planejamento,
				   ra.descricao,
				   ra.tamanho_id,
				   tm.descricao tamanho,
				   ra.complexidade_id,
				   cp.descricao complexidade,
				   ra.solicitacao_id,
				   ra.date_insert,
				   ra.user_insert,
				   ra.date_update,
				   ra.user_update,
				   ra.site,
				   ra.titulo,
				   r.cod_requisito,
				   r.titulo as requisito,
				   kmm.pkg_global.FNC_FORMAT_INTERVALO(kmm.pkg_projeto.FNC_GET_TEMPO_ESTIMADO(ra.projeto_id,ra.tamanho_id,ra.complexidade_id)) estimado,
				   kmm.pkg_global.FNC_FORMAT_INTERVALO(ra.tempo_ajustado) ajustado
			  from kmm.v$requisito_alteracao ra
			 inner join kmm.v$requisito r
			         on r.requisito_id = ra.requisito_id
			 inner join kmm.v$cg_ref_codes tp
					 on tp.id = ra.tipo_id
					and tp.dominio = 'REQUISITO TIPO'
			 inner join kmm.v$cg_ref_codes st
					 on st.id = ra.status_id
					and st.dominio = 'STATUS REQUISITO'
			 inner join kmm.v$cg_ref_codes tm
					 on tm.id = ra.tamanho_id
					and tm.dominio = 'REQUISITO TAMANHO'
			 inner join kmm.v$cg_ref_codes cp
					 on cp.id = ra.complexidade_id
					and cp.dominio = 'REQUISITO COMPLEXIDADE'
			 where 1=1
			 <cfif len(trim(arguments.alteracao_id))>
			   and ra.alteracao_id = #arguments.alteracao_id#
			 </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca as solicitaes de alterao de requisito
	-- CRISTOFER  19/10/2006
	--->		
	<cffunction name="get_requisito_solicitacao" access="remote" returntype="query" output="true">
		<cfargument name="projeto_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select rs.solicitacao_id,
				   rs.projeto_id,
				   rs.criador,
				   rs.fornecedor,
				   r.nome nome_fornecedor,
				   r.nome_completo nome_completo_fornecedor,
				   rs.data_lancamento,
				   rs.descricao,
				   rs.status_id,
				   st.descricao status,
				   rs.tarefa_id,
				   rs.titulo,
				   rs.tipo_id,
				   tt.descricao tipo,
				   rs.urgencia_id,
				   ut.descricao urgencia,
				   rs.aplicacao_id,
				   ap.descricao aplicacao,
				   rs.data_avaliacao,
				   rs.date_insert,
				   rs.user_insert,
				   rs.date_update,
				   rs.user_update,
				   rs.site
			  from kmm.v$requisito_solicitacao rs
			 inner join kmm.v$recurso r
					 on r.recurso_id = rs.fornecedor
			 inner join kmm.v$cg_ref_codes st
					 on st.id = rs.status_id
					and st.dominio = 'SMR STATUS'
			 inner join kmm.v$cg_ref_codes tt
					 on tt.id = rs.tipo_id
					and tt.dominio = 'TIPO TAREFA'
			 inner join kmm.v$cg_ref_codes ut
					 on ut.id = rs.urgencia_id
					and ut.dominio = 'URGENCIA TAREFA'
			 inner join kmm.v$aplicacao ap
					 on ap.aplicacao_id = rs.aplicacao_id
			 where 1=1
			<cfif len(trim(arguments.projeto_id))>
			   and rs.projeto_id in (#arguments.projeto_id#)
			</cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca as solicitaes de alterao de requisito
	-- CRISTOFER  19/10/2006
	--->		
	<cffunction name="get_solicitacao" access="remote" returntype="query" output="true">
       		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select s.solicitacao_id,
               s.usuario_solicitacao,
               s.cliente_id,
               c.cliente,
               s.tipo_aplicacao_id,
               s.codigo_erro_email,
               s.severidade,
               s.usuario_teste,
               s.descricao_operacao,
               s.informacoes_adicionais,
               s.status_id,
               s.user_insert,
               
       to_char(s.date_insert, 'dd/mm/yyyy hh24:mi') as date_insert,
               
               s.user_update,
               s.date_update,
               s.site
          from kmm.v$solicitacao_suporte s
          inner join kmm.v$cliente c 
                  on c.cliente_id = s.cliente_id
          where 1=1
          <cfif isDefined("arguments.solicitacao_id") and len(trim(arguments.solicitacao_id))>
		  	and s.solicitacao_id = #arguments.solicitacao_id#
		  </cfif>
			 
		   <cfif isDefined("arguments.data_inicio") and len(trim(arguments.data_inicio))>
               and trunc(s.date_insert) >= '#arguments.data_inicio#'                       	
          </cfif>
          <cfif isDefined("arguments.data_f") and len(trim(arguments.data_f))>
               and trunc(s.date_insert) <= '#arguments.data_f#'
          </cfif>
          
          <cfif isDefined("arguments.tipo_aplicacao_id") and len(trim(arguments.tipo_aplicacao_id))>
		  	and s.tipo_aplicacao_id = #arguments.tipo_aplicacao_id#
		  </cfif>
          
          <cfif isDefined("arguments.cliente_id") and len(trim(arguments.cliente_id))>
		  	and s.cliente_id = #arguments.cliente_id#
		  </cfif>
      
          
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    	<!--- 
	-- PROPSITO 
	-- Busca a descricao da tarefa
	-- IGOR  07/10/2008
	--->		
	<cffunction name="get_descricao" access="remote" returntype="query" output="true" >
    	<cfargument name="tarefa_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
              select t.tarefa_id,
                     to_char(t.titulo) as descricao,
                     r.nome,
                     c.cliente, cv.descricao as etapa,
                     ta.etapa_id
                from kmm.v$tarefa t
                inner join kmm.v$projeto_tarefa pt
                        on pt.tarefa_id = t.tarefa_id
                inner join kmm.v$projeto p 
                        on p.projeto_id = pt.projeto_id
                inner join kmm.v$recurso r
                        on r.recurso_id = t.contato
                inner join kmm.v$cliente c
                        on c.cliente_id = p.cliente_id
              left join kmm.v$tarefa_atribuicao ta 
                     on t.atribuicao_id = ta.atribuicao_id
              left join kmm.v$ciclo_vida_etapa cv
                     on cv.etapa_id = ta.etapa_id                     
             where t.tarefa_id = #arguments.tarefa_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca tarefas pendentes de entrega
	-- CRISTOFER  14/09/2006
	--->		
	<cffunction name="get_tarefas_pendentes" access="remote" returntype="query" output="true">
		<cfargument name="CLIENTE_ID" required="no" default="">
		<cfargument name="RECURSO_ID" required="no" default="">
		<cfargument name="DATA_INICIO" required="no" default="">
		<cfargument name="DATA_FIM" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select * 
             from (
            select t.tarefa_id,
                   t.titulo,
                   r2.nome as atribuida_para,
                   cli.nome nome_cliente,
                   to_char(t.entregar_em,'dd/mm/yyyy') as entregar_em,
                   t.status,
                   (select c.descricao
                      from kmm.v$cg_ref_codes c
                     where c.dominio = 'STATUS TAREFA'
                       and c.id = t.status) as status_tarefa,
                   to_char(nvl(min(te.data_limite), (select min(te2.data_limite) from kmm.v$tarefa_etapa te2 where te2.tarefa_id = t.tarefa_id)),'DD/MM/YYYY') data_limite,
                   case  
                    when trunc(t.entregar_em) >= trunc(sysdate) then 1 
                   else 0 end as no_prazo, 
                   to_char(nvl(min(te.data_limite), (select min(te2.data_limite) from kmm.v$tarefa_etapa te2 where te2.tarefa_id = t.tarefa_id)),'iw') semana,
                   to_char(sysdate,'iw') as semana_atual,
                   kss.to_tempo(numtodsinterval(sum(coalesce(a.tempo_minutos, 0)),'MINUTE'),3).retorno as tempo_total_gasto,                     
                   (select nvl(max(a2.percentual_tarefa)
                               keep(dense_rank last order by a2.atendimento_data),0)
                      from kmm.v$atendimento_suporte a2
                     where a2.num_tarefa = t.tarefa_id
                       and a2.atendimento_data >= trunc(ta.data_atribuicao)
                       and a2.tempo_termino is not null
                       and a2.atendimento_usuario = r2.nome) as percentual_concluida,                   
                   to_char(max(a.atendimento_data),'dd/mm/yyyy') as ultima_execucao, 
                   nvl(cv.descricao,'ABERTA') as etapa, 
				   kss.to_tempo(coalesce(te.tempo_estimado,t.tempo_estimado),3).retorno as tempo_estimado,  
				   kss.to_tempo(t.tempo_estimado,3).retorno as tempo_estimado_total, 
                   kss.to_tempo(numtodsinterval((select coalesce(max(a2.estimado_restante) keep(dense_rank last order by a2.atendimento_data),0)
                      from kmm.v$atendimento_suporte a2
                     where a2.num_tarefa = t.tarefa_id
                       and a2.atendimento_data >= trunc(ta.data_atribuicao)
                       and a2.tempo_termino is not null
                       and a2.atendimento_usuario = r2.nome),'MINUTE'),3).retorno as tempo_estimado_restante,sd.codigo as cod_sd, sd.titulo as titulo_sd
              from kmm.v$tarefa t
             left join kmm.v$atendimento_suporte a 
                     on a.num_tarefa = t.tarefa_id
             left join kmm.v$recurso r 
                     on t.contato = r.recurso_id
              left join kmm.v$tarefa_atribuicao ta 
                     on t.atribuicao_id = ta.atribuicao_id
              left join kmm.v$tarefa_etapa te 
                     on ta.etapa_id = te.etapa_id
                    and te.tarefa_id = t.tarefa_id
              left join kmm.v$recurso r2 
                     on r2.recurso_id = ta.recurso_id
              left join kmm.v$tarefa_etapa te2 
                     on te2.tarefa_id = t.tarefa_id
                    and (te2.etapa_id_anterior = ta.etapa_id 
                         or (ta.etapa_id is null 
                         and te2.etapa_id_anterior is null))
              left join kmm.v$projeto_tarefa pt 
                     on pt.tarefa_id = t.tarefa_id
              left join kmm.v$projeto prj 
                     on pt.projeto_id = prj.projeto_id
              left join kmm.v$cliente cli 
                     on cli.cliente_id = prj.cliente_id
              left join kmm.v$ciclo_vida_etapa cv
                     on cv.etapa_id = ta.etapa_id    
              left join kmm.v$sd_tarefa st
                     on st.tarefa_id = t.tarefa_id
              left join kmm.v$sd_detalhamento sdd
                     on sdd.sd_detalhamento_id = st.sd_detalhamento_id
              left join kmm.v$sd sd
                     on sd.sd_id = sdd.sd_id                  
             where 1 = 1
               and t.status not in (7, 8)
               <cfif Len(Trim(arguments.CLIENTE_ID))>
               	  and cli.cliente_id = #arguments.CLIENTE_ID#
               </cfif>
               <cfif Len(Trim(arguments.RECURSO_ID))>
               	  and r2.recurso_id = #arguments.RECURSO_ID#
               </cfif> 
             group by t.tarefa_id, t.status, cli.nome, t.titulo, r2.nome, cv.descricao, coalesce(te.tempo_estimado,t.tempo_estimado), ta.data_atribuicao, t.tempo_estimado, t.entregar_em, sd.codigo, sd.titulo
              )
              where 1=1 
               <cfif Len(Trim(arguments.DATA_INICIO))>
               	  and data_limite >= '#arguments.DATA_INICIO#'
               </cfif>
               <cfif Len(Trim(arguments.DATA_FIM))>
               	  and data_limite <= '#arguments.DATA_FIM#'
               </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>         	
	<!--- 
	-- PROPSITO 
	-- Busca tarefas pendentes de entrega
	-- CRISTOFER  14/09/2006
	--->		
	<cffunction name="get_tarefas_pendentes_resumo" access="remote" returntype="query" output="true">
		<cfargument name="CLIENTE_ID" required="no" default="">
		<cfargument name="RECURSO_ID" required="no" default="">
		<cfargument name="DATA_INICIO" required="no" default="">
		<cfargument name="DATA_FIM" required="no" default="">
		<cfargument name="AGRUPAR_POR" required="no" default="atribuida_para">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select #arguments.AGRUPAR_POR#,count(*) as tarefas,
                   count(*) - sum(no_prazo) as atrasadas
             from (
            select t.tarefa_id,
                   t.titulo,
                   r2.nome as atribuida_para,
                   cli.nome nome_cliente,
                   to_char(nvl(max(te.data_limite), max(t.entregar_em)),'dd/mm/yyyy') data_limite,
                   case 
                     when nvl(max(te.data_limite), max(t.entregar_em)) >= trunc(sysdate) then 1
                   else 0 end as no_prazo,
                   to_char(nvl(max(te.data_limite), max(t.entregar_em)),'iw') semana,
                   to_char(sysdate,'iw') as semana_atual,
                   kss.to_tempo(numtodsinterval(sum(coalesce(a.tempo_minutos, 0)),'MINUTE'),3).retorno as tempo_total_gasto,  
                   (select nvl(max(a2.percentual_tarefa)
                               keep(dense_rank last order by a2.atendimento_data),0)
                      from kmm.v$atendimento_suporte a2
                     where a2.num_tarefa = t.tarefa_id
                       and a2.atendimento_usuario = r2.nome) as percentual_concluida,
                   to_char(max(a.atendimento_data),'dd/mm/yyyy') as ultima_execucao, cv.descricao as etapa
              from kmm.v$tarefa t
             left join kmm.v$atendimento_suporte a 
                     on a.num_tarefa = t.tarefa_id
             left join kmm.v$recurso r 
                     on t.contato = r.recurso_id
              left join kmm.v$tarefa_atribuicao ta 
                     on t.atribuicao_id = ta.atribuicao_id
              left join kmm.v$tarefa_etapa te 
                     on ta.etapa_id = te.etapa_id
                    and te.tarefa_id = t.tarefa_id
              left join kmm.v$recurso r2 
                     on r2.recurso_id = ta.recurso_id
              left join kmm.v$tarefa_etapa te2 
                     on te2.tarefa_id = t.tarefa_id
                    and (te2.etapa_id_anterior = ta.etapa_id 
                         or (ta.etapa_id is null 
                         and te2.etapa_id_anterior is null))
              left join kmm.v$projeto_tarefa pt 
                     on pt.tarefa_id = t.tarefa_id
              left join kmm.v$projeto prj 
                     on pt.projeto_id = prj.projeto_id
              left join kmm.v$cliente cli 
                     on cli.cliente_id = prj.cliente_id
              left join kmm.v$ciclo_vida_etapa cv
                     on cv.etapa_id = ta.etapa_id                     
             where 1 = 1
               and t.status not in (7, 8)
               <cfif Len(Trim(arguments.CLIENTE_ID))>
               	  and cli.cliente_id = #arguments.CLIENTE_ID#
               </cfif>
               <cfif Len(Trim(arguments.RECURSO_ID))>
               	  and r2.recurso_id = #arguments.RECURSO_ID#
               </cfif> 
             group by t.tarefa_id, cli.nome, t.titulo, r2.nome, cv.descricao
              )
              where 1=1 
               <cfif Len(Trim(arguments.DATA_INICIO))>
               	  and data_limite >= '#arguments.DATA_INICIO#'
               </cfif>
               <cfif Len(Trim(arguments.DATA_FIM))>
               	  and data_limite <= '#arguments.DATA_FIM#'
               </cfif>
               group by #arguments.AGRUPAR_POR# 
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>         	    

	<!--- 
	-- PROPSITO 
	-- Busca as etapas de tarefas em aberto
	-- CRISTOFER  29/03/2009
	--->		
	<cffunction name="get_etapas_ativas" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select distinct ce.etapa_id, ce.descricao
              from kmm.v$ciclo_vida_etapa ce
             inner join kmm.v$tarefa_etapa te
                     on te.etapa_id = ce.etapa_id
             inner join kmm.v$tarefa t
                     on t.tarefa_id = te.tarefa_id
             where t.status not in (7,8)
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>         	    

	<!--- 
	-- PROPSITO 
	-- Busca as etapas das tarefas para a atribuicao
	-- CRISTOFER  29/03/2009
	--->		
	<cffunction name="get_tarefa_atribuicao_distribuicao" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.tarefa_id,
                   te.etapa_id,
                   t.titulo,
                   ce.descricao as etapa,
                   case
                      when te.tempo_estimado is null then 'No estimado'
                      else kss.to_tempo(te.tempo_estimado,3).retorno 
                   end as tempo_estimado,
                   r.nome as recurso
              from kmm.v$tarefa  t
             inner join kmm.v$tarefa_etapa te
                     on te.tarefa_id = t.tarefa_id
             inner join kmm.v$ciclo_vida_etapa ce
                     on ce.etapa_id = te.etapa_id
              left join kmm.v$recurso r
                     on r.recurso_id = te.recurso_id
             where t.status not in (7,8)
             order by t.tarefa_id, ce.num_etapa
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca atribuicao por cliente
	-- CRISTOFER  29/03/2009
	--->		
	<cffunction name="get_tarefa_atribuicao_cliente" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.nome as cliente, 
                   tempo_estimado, 
                   tempo_estimado_rest, 
                   semana, 
                   semana_atual
              from (
                    select cl.nome,
                           coalesce(sum(sysdate + te.tempo_estimado - sysdate),0) as tempo_num,
                           kss.to_tempo(numtodsinterval(coalesce(sum(sysdate + te.tempo_estimado - sysdate),0),'day'),3).retorno tempo_estimado,
                           coalesce(sum(sysdate + te.estimado_restante - sysdate),0) as tempo_num_rest,
                           kss.to_tempo(numtodsinterval(coalesce(sum(sysdate + te.estimado_restante - sysdate),0),'day'),3).retorno tempo_estimado_rest,
                           to_char(te.data_limite,'iw') || ' de ' || to_char(trunc(te.data_limite,'day'),'dd/mm/yyyy')||' at '||to_char(trunc(te.data_limite,'day')+6,'dd/mm/yyyy') semana,
                           to_char(trunc(sysdate,'day'),'dd/mm/yyyy')||'=>'||to_char(trunc(sysdate,'day')+6,'dd/mm/yyyy') semana_atual
                      from (select t.tarefa_id,
                                   te.etapa_id,
                                   te.tempo_estimado,
                                   te.data_limite,
                                   nvl(max(percentual_tarefa) keep(dense_rank last order by ats.atendimento_data),0) perc,
                                   numtodsinterval((sysdate + te.tempo_estimado - sysdate) * ((100-(nvl(max(percentual_tarefa) keep(dense_rank last order by ats.atendimento_data),0)))/100),'day') as estimado_restante
                              from kmm.v$tarefa t
                             inner join kmm.v$tarefa_etapa te
                                     on t.tarefa_id = te.tarefa_id
                              left join kmm.v$atendimento_suporte ats
                                     on ats.etapa_id = te.etapa_id
                                    and ats.num_tarefa = t.tarefa_id
                             where t.status not in (7,8)
                             group by t.tarefa_id,
                                   te.etapa_id,
                                   te.tempo_estimado,
                                   te.data_limite
                                ) te
                                          
                     inner join kmm.v$projeto_tarefa pt
                             on pt.tarefa_id = te.tarefa_id
                     inner join kmm.v$projeto p
                             on p.projeto_id = pt.projeto_id
                     inner join kmm.v$cliente cl
                             on cl.cliente_id = p.cliente_id
                     where 1=1 
                     group by cl.nome, to_char(te.data_limite,'yyyy-iw'), trunc(te.data_limite,'day'), to_char(te.data_limite,'iw') 
                     order by to_char(te.data_limite,'yyyy-iw') ) t
             where t.tempo_num > 0                   
		</cfquery>
		<cfreturn qr_result>
	</cffunction>


	<!--- 
	-- PROPSITO 
	-- Busca atribuicao por recurso
	-- CRISTOFER  29/03/2009
	--->		
	<cffunction name="get_tarefa_atribuicao_recurso" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.nome recurso,
                   kss.to_tempo(numtodsinterval(coalesce(sum(sysdate + te.tempo_estimado - sysdate),0),'day'),3).retorno tempo_estimado,
                   to_char(te.data_limite,'iw') || ' de ' || to_char(trunc(te.data_limite,'day'),'dd/mm/yyyy')||' at '||to_char(trunc(te.data_limite,'day')+6,'dd/mm/yyyy') semana
              from kmm.v$tarefa_etapa te
             inner join kmm.v$recurso r
                     on r.recurso_id = te.recurso_id
             inner join kmm.v$tarefa t
                     on t.tarefa_id = te.tarefa_id
             where 1=1
               and t.status not in (7,8)
             group by r.nome, to_char(te.data_limite,'yyyy-iw'), trunc(te.data_limite,'day'), to_char(te.data_limite,'iw')
             order by to_char(te.data_limite,'yyyy-iw')
		</cfquery>
		<cfreturn qr_result>
	</cffunction>


	<!--- 
	-- PROPSITO 
	-- Busca tempos em aberto para cada etapa
	-- CRISTOFER  29/03/2009
	--->		
	<cffunction name="get_tarefa_etapa_tempo" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select a.etapa, 
                   kss.to_tempo(sum(tempo_min),3).retorno as tempo,
                   kss.to_tempo(sum(tempo_min*perc),3).retorno  as tempo_restante,
                   count(*) as tarefas
              from (select cie.descricao as etapa,
                           ((sysdate + nvl(te.tempo_estimado,numtodsinterval(0,'DAY'))) - sysdate)*24*60 as tempo_min,      
                           1-((select nvl(max(percentual_tarefa) keep(dense_rank last order by ats.atendimento_data),0) perc
                             from kmm.v$atendimento_suporte ats
                            where ats.etapa_id = te.etapa_id
                              and ats.num_tarefa = t.tarefa_id)/100) as perc
                      from kmm.v$tarefa t
                      inner join kmm.v$tarefa_etapa te
                              on te.tarefa_id = t.tarefa_id
                      inner join kmm.v$ciclo_vida_etapa cie
                              on cie.etapa_id = te.etapa_id
                      where t.status not in (7,8)) a
            group by etapa
            order by etapa
  		</cfquery>
		<cfreturn qr_result>		
	</cffunction>         	    
    
    <!--- 
	-- PROPSITO 
	-- Busca os anexos da sd
	-- JONAS  14/04/2009
	--->		
	<cffunction name="get_sd_anexo" access="remote" returntype="query" output="true">
		<cfargument name="sd_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select sda.sd_anexo_id,
				   sda.sd_id,
				   sda.anexo_id,
				   a.titulo as anexo_titulo,
				   a.url as anexo_url
			  from kmm.v$sd_anexo sda
			 inner join kmm.v$anexo a
					 on a.anexo_id = sda.anexo_id	
			 where sda.sd_id = #arguments.sd_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca os projeto horas
	-- JONAS  16/04/2008
	--->		
	<cffunction name="get_projeto_contrato_horas" access="remote" returntype="query" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select  phm.controle_id
                    ,phm.projeto_id
				    ,to_char(phm.data_inicial,'dd/mm/yyyy') as data_inicial
                    ,to_char(phm.data_final,'dd/mm/yyyy') as data_final
                    ,phm.horas
			  from kmm.v$projeto_contrato_horas phm
			 where phm.projeto_id = #arguments.projeto_id#             
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	

    <!--- 
	-- PROPSITO 
	-- Busca os tempo por etapa
	-- GUTO 16/04/2008
	--->		
	<cffunction name="get_painel_tempo_etapa" access="remote" returntype="query" output="true">
    	<cfargument name="mes_anterior" required="no" default=""/>
    	<cfargument name="mes_atual" required="no" default=""/>
    	<cfargument name="proximo_mes" required="no" default=""/>
    	<cfargument name="data_inicio" required="no" default=""/>
    	<cfargument name="data_fim" required="no" default=""/>
    	<cfargument name="status" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select a.etapa_id, a.etapa, 
                   kss.to_tempo(kss.sum_dsinterval(nvl(a.tempo_estimado,numtodsinterval(0,'DAY'))),3).retorno as tempo_estimado,
                   kss.to_tempo(kss.sum_dsinterval(nvl(a.tempo_realizado,numtodsinterval(0,'DAY'))),3).retorno as tempo_real
              from (
                    select t.tarefa_id, te.etapa_id, 
                           te.tempo_estimado, 
                           kmm.pkg_producao.fnc_tempo_tarefa(t.tarefa_id,te.etapa_id) as tempo_realizado, ce.descricao as etapa,
                           nvl(t.finalizada_em,t.entregar_em) as data_entrega
                      from kmm.v$tarefa t  
                     inner join kmm.v$tarefa_etapa te
                             on te.tarefa_id = t.tarefa_id
                     inner join kmm.v$ciclo_vida_etapa ce
                             on ce.etapa_id = te.etapa_id          
                     where t.status in (#arguments.STATUS#)) a
            where 1=1
            <cfif Len(Trim(arguments.mes_anterior))>
			  and a.data_entrega between trunc(add_months(sysdate,-1),'MONTH') and last_day(add_months(sysdate,-1))
            </cfif>
            <cfif Len(Trim(arguments.mes_atual))>
			  and a.data_entrega between trunc(sysdate,'MONTH') and last_day(sysdate)
            </cfif>
            <cfif Len(Trim(arguments.proximo_mes))>
			  and a.data_entrega between trunc(add_months(sysdate,1),'MONTH') and last_day(add_months(sysdate,1))
            </cfif>
            <cfif Len(Trim(arguments.data_inicio))>
			  and a.data_entrega >= '#arguments.data_inicio#'
            </cfif>
            <cfif Len(Trim(arguments.data_fim))>
			  and a.data_entrega <= '#arguments.data_fim#'
            </cfif>
            group by a.etapa_id, a.etapa
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	

    <!--- 
	-- PROPSITO 
	-- Busca os tempo por cliente
	-- GUTO  16/04/2008
	--->		
	<cffunction name="get_painel_tempo_cliente" access="remote" returntype="query" output="true">
    	<cfargument name="mes_anterior" required="no" default=""/>
    	<cfargument name="mes_atual" required="no" default=""/>
    	<cfargument name="proximo_mes" required="no" default=""/>
    	<cfargument name="data_inicio" required="no" default=""/>
    	<cfargument name="data_fim" required="no" default=""/>
    	<cfargument name="status" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cliente, identificador, num_tarefas,
                   kss.to_tempo(tempo_estimado_finalizado,3).retorno as tempo_estimado_finalizado,
                   kss.to_tempo(kss.sum_dsinterval(tempo_estimado_finalizado) over(),3).retorno as total_estimado_finalizado,
                   kss.to_tempo(tempo_real_finalizado,3).retorno as tempo_real_finalizado,
                   kss.to_tempo(kss.sum_dsinterval(tempo_real_finalizado) over(),3).retorno as total_real_finalizado,
                   kss.to_tempo(tempo_estimado_executando,3).retorno as tempo_estimado_executando,
                   kss.to_tempo(kss.sum_dsinterval(tempo_estimado_executando) over(),3).retorno as total_estimado_executando,
                   kss.to_tempo(tempo_real_executando,3).retorno as tempo_real_executando,
                   kss.to_tempo(kss.sum_dsinterval(tempo_real_executando) over(),3).retorno as total_real_executando,
                   kss.to_tempo(tempo_total_estimado,3).retorno as tempo_total_estimado,
                   kss.to_tempo(kss.sum_dsinterval(tempo_total_estimado) over(),3).retorno as kmm_total_estimado,
                   kss.to_tempo(tempo_total_realizado,3).retorno as tempo_total_realizado,
                   kss.to_tempo(kss.sum_dsinterval(tempo_total_realizado) over(),3).retorno as kmm_total_realizado,
                   kss.to_tempo(numtodsinterval(tempo_contratado,'HOUR'),3).retorno as tempo_contratado,
                   kss.to_tempo((numtodsinterval(tempo_contratado, 'HOUR')+tempo_corretiva)-tempo_total_estimado,3).retorno as tempo_restante_contrato,
                   kss.to_tempo(kss.sum_dsinterval((numtodsinterval(tempo_contratado, 'HOUR')+tempo_corretiva)-tempo_total_estimado) over(),3).retorno as tempo_total_restante_contrato,
                   case 
                    when numtodsinterval(tempo_contratado,'HOUR') < tempo_total_estimado-tempo_corretiva then 1
                   else 0 end tempo_excedido,
                   tempo_contratado as tempo_contratado_horas,
                   kss.to_tempo(numtodsinterval(sum(tempo_contratado) over(),'HOUR'),3).retorno as total_tempo_contratado,
                   percentual_finalizado,
                   percentual_executado,
                   kss.to_tempo(tempo_restante,3).retorno as tempo_restante,
                   kss.to_tempo(kss.sum_dsinterval(case when tempo_restante < numtodsinterval(0,'DAY') then numtodsinterval(0,'DAY') else tempo_restante end) over(),3).retorno as total_tempo_restante,
                   kss.to_tempo(tempo_corretiva,3).retorno as tempo_corretiva,
                   kss.to_tempo(tempo_restante,3).retorno as tempo_restante,
                   kss.to_tempo(kss.sum_dsinterval(case when tempo_restante < numtodsinterval(0,'DAY') then numtodsinterval(0,'DAY') else tempo_restante end) over(),3).retorno as total_tempo_restante,
                   case 
                     when ((sysdate+tempo_estimado_finalizado)-sysdate) > 0 then
                          round(100*(((sysdate+tempo_corretiva)-sysdate)/((sysdate+tempo_estimado_finalizado)-sysdate)),2)
                   else 0 end perc_corretiva,
                   kss.to_tempo(kss.sum_dsinterval(tempo_corretiva) over(),3).retorno as total_tempo_corretiva,
                   percentual_corretiva
              from (select a.cliente, 'v_' || a.cliente_id as identificador, 
                               count(distinct a.tarefa_id) as num_tarefas,  
                                       kss.sum_dsinterval(nvl(a.tempo_estimado_finalizado,numtodsinterval(0,'DAY'))) as tempo_estimado_finalizado,
                                       kss.sum_dsinterval(nvl(a.tempo_realizado_finalizado,numtodsinterval(0,'DAY'))) as tempo_real_finalizado,
                                       kss.sum_dsinterval(nvl(a.tempo_estimado_executando,numtodsinterval(0,'DAY'))) as tempo_estimado_executando,
                                       kss.sum_dsinterval(nvl(a.tempo_realizado_executando,numtodsinterval(0,'DAY'))) as tempo_real_executando,
                                       kss.sum_dsinterval(a.tempo_estimado_finalizado +a.tempo_estimado_executando) as tempo_total_estimado,
                                       kss.sum_dsinterval(a.tempo_realizado_finalizado +a.tempo_realizado_executando) as tempo_total_realizado,
                                       nvl(kmm.pkg_producao.fnc_tempo_cliente(a.cliente_id, to_char(max(data_entrega),'mm'),to_char(max(data_entrega),'yyyy')),0) as tempo_contratado,
                                       round((((sysdate + kss.sum_dsinterval(a.tempo_estimado_finalizado)) - sysdate)*24)/nvl(kmm.pkg_producao.fnc_tempo_cliente(a.cliente_id, to_char(sysdate,'mm'),to_char(sysdate,'yyyy')),1) * 100) as percentual_finalizado,
                                       round((((sysdate + kss.sum_dsinterval(a.tempo_estimado_finalizado +a.tempo_estimado_executando)) - sysdate)*24)/nvl(kmm.pkg_producao.fnc_tempo_cliente(a.cliente_id, to_char(sysdate,'mm'),to_char(sysdate,'yyyy')),1) * 100) as percentual_executado,
                                       numtodsinterval(nvl(kmm.pkg_producao.fnc_tempo_cliente(a.cliente_id, to_char(max(data_entrega),'mm'),to_char(max(data_entrega),'yyyy')),0),'HOUR') - kss.sum_dsinterval(a.tempo_estimado_finalizado +a.tempo_estimado_executando) as tempo_restante,
                                       kss.sum_dsinterval(tempo_corretiva) as tempo_corretiva,
                                       round((((sysdate + kss.sum_dsinterval(tempo_corretiva)) - sysdate)*24)/nvl(kmm.pkg_producao.fnc_tempo_cliente(a.cliente_id, to_char(max(data_entrega),'mm'),to_char(max(data_entrega),'yyyy')),1) * 100) as percentual_corretiva
                                  from (
                                          select t.tarefa_id, c.nome as cliente, c.cliente_id, 
                                                 nvl(t.tempo_estimado,numtodsinterval(0,'DAY')) as tempo_estimado_finalizado,                            
                                                 nvl(kmm.pkg_producao.fnc_tempo_tarefa(t.tarefa_id),numtodsinterval(0,'DAY')) as tempo_realizado_finalizado,
                                                 numtodsinterval(0,'DAY') as tempo_estimado_executando,
                                                 numtodsinterval(0,'DAY') as tempo_realizado_executando,
                                                 nvl(t.finalizada_em,t.entregar_em) as data_entrega,
                                                 nvl(decode(t.tipo_id,1,t.tempo_estimado,null),numtodsinterval(0,'DAY')) as tempo_corretiva
                                            from kmm.v$tarefa t  
                                           inner join kmm.v$projeto_tarefa pt
                                                   on pt.tarefa_id = t.tarefa_id
                                           inner join kmm.v$projeto p 
                                                   on p.projeto_id = pt.projeto_id
                                           inner join kmm.v$cliente c
                                                   on c.cliente_id = p.cliente_id          
                                           where t.status = 7
                                                         
                                           union all
                                                         
                                           select t.tarefa_id, c.nome as cliente, c.cliente_id, 
                                                 numtodsinterval(0,'DAY') as tempo_estimado_finalizado,
                                                 numtodsinterval(0,'DAY') as tempo_realizado_finalizado,
                                                 nvl(t.tempo_estimado,numtodsinterval(0,'DAY')) as tempo_estimado_executando,                            
                                                 nvl(kmm.pkg_producao.fnc_tempo_tarefa(t.tarefa_id),numtodsinterval(0,'DAY')) as tempo_realizado_executando,
                                                 nvl(t.finalizada_em,t.entregar_em) as data_entrega,
                                                 nvl(decode(t.tipo_id,1,t.tempo_estimado,null),numtodsinterval(0,'DAY')) as tempo_corretiva
                                            from kmm.v$tarefa t  
                                           inner join kmm.v$projeto_tarefa pt
                                                   on pt.tarefa_id = t.tarefa_id
                                           inner join kmm.v$projeto p 
                                                   on p.projeto_id = pt.projeto_id
                                           inner join kmm.v$cliente c
                                                   on c.cliente_id = p.cliente_id          
                                           where t.status in (1,2,3,4,5,6)) a
                              where 1=1
						<cfif Len(Trim(arguments.mes_anterior))>
                          and a.data_entrega between trunc(add_months(sysdate,-1),'MONTH') and last_day(add_months(sysdate,-1))
                        </cfif>
                        <cfif Len(Trim(arguments.mes_atual))>
                          and a.data_entrega between trunc(sysdate,'MONTH') and last_day(sysdate)
                        </cfif>
                        <cfif Len(Trim(arguments.proximo_mes))>
                          and a.data_entrega between trunc(add_months(sysdate,1),'MONTH') and last_day(add_months(sysdate,1))
                        </cfif>
                        <cfif Len(Trim(arguments.data_inicio))>
                          and a.data_entrega >= '#arguments.data_inicio#'
                        </cfif>
                        <cfif Len(Trim(arguments.data_fim))>
                          and a.data_entrega <= '#arguments.data_fim#'
                        </cfif>
                  group by a.cliente, a.cliente_id)
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	

    <!--- 
	-- PROPSITO 
	-- Busca os tempo por recurso
	-- GUTO  16/04/2008
	--->		
	<cffunction name="get_painel_tempo_recurso" access="remote" returntype="query" output="true">
    	<cfargument name="mes_anterior" required="no" default=""/>
    	<cfargument name="mes_atual" required="no" default=""/>
    	<cfargument name="proximo_mes" required="no" default=""/>
    	<cfargument name="data_inicio" required="no" default=""/>
    	<cfargument name="data_fim" required="no" default=""/>
    	<cfargument name="status" required="no" default=""/>
    	<cfargument name="sd_ok" required="no" default="0"/>        
    	<cfargument name="premio_pendente" required="no" default="0"/>        
        <cfset v_valor_por_hora = 4>
        <cfif arguments.SD_OK eq 0>
            <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select recurso_id, 
                	   recurso, 
                       num_tarefas, 
                       atraso, 
                       tarefas,
                       round(premio,2) as premio, 
                       valor_tarefa, 
                       power(num_tarefas,(num_tarefas-atraso)/num_tarefas) as quociente, 
                       atraso/num_tarefas as perc_atrasos,
                       round(valor_tarefa*(1-(atraso/num_tarefas))*power(num_tarefas,(num_tarefas-atraso)/num_tarefas),2) as valor_premio_final,
                       tempo_estimado_finalizado, 
                       tempo_real_finalizado, 
                       tempo_estimado_executando, 
                       tempo_real_executando, 
                       kss.to_tempo(tempo_total_estimado,3).retorno as tempo_total_estimado, 
                       tempo_total_realizado, 
                       kss.to_tempo(kss.sum_dsinterval(tempo_total_estimado) over(),3).retorno as tempo_total_estimado_kmm,
                       tempo_corretiva, 
                       kss.to_tempo(kss.sum_dsinterval(tempo_total_corretiva) over(),3).retorno as tempo_corretiva_kmm
                  from (select a.recurso_id, a.recurso, '' as tarefas,
                               count(distinct a.tarefa_id) as num_tarefas,  (select count(ta.tarefa_id) 
                                                                               from kmm.v$tarefa_atraso ta
                                                                               inner join kmm.v$tarefa t
                                                                                       on t.tarefa_id = ta.tarefa_id
                                                                               where 1=1
                                                                                  and t.status <> 8
                                                                                  and ta.recurso_id = a.recurso_id 
                                                                                <cfif Len(Trim(arguments.mes_anterior))>
                                                                                  and trunc(coalesce(t.finalizada_em,t.entregar_em)) between trunc(add_months(sysdate,-1),'MONTH') and last_day(add_months(sysdate,-1))
                                                                                </cfif>
                                                                                <cfif Len(Trim(arguments.mes_atual))>
                                                                                  and trunc(coalesce(t.finalizada_em,t.entregar_em)) between trunc(sysdate,'MONTH') and last_day(sysdate)
                                                                                </cfif>
                                                                                <cfif Len(Trim(arguments.proximo_mes))>
                                                                                  and trunc(coalesce(t.finalizada_em,t.entregar_em)) between trunc(add_months(sysdate,1),'MONTH') and last_day(add_months(sysdate,1))
                                                                                </cfif>
                                                                                <cfif Len(Trim(arguments.data_inicio))>
                                                                                  and trunc(coalesce(t.finalizada_em,t.entregar_em)) >= '#arguments.data_inicio#'
                                                                                </cfif>
                                                                                <cfif Len(Trim(arguments.data_fim))>
                                                                                  and trunc(coalesce(t.finalizada_em,t.entregar_em)) <= '#arguments.data_fim#'
                                                                                </cfif>) as atraso,
                               (((sysdate + kss.sum_dsinterval(a.tempo_estimado_finalizado +a.tempo_estimado_executando)) - sysdate)*24) * #v_valor_por_hora# as premio,
                               ((((sysdate + kss.sum_dsinterval(a.tempo_estimado_finalizado +a.tempo_estimado_executando)) - sysdate)*24) * #v_valor_por_hora#) / count(distinct a.tarefa_id) as valor_tarefa,
                               kss.to_tempo(kss.sum_dsinterval(nvl(a.tempo_estimado_finalizado,numtodsinterval(0,'DAY'))),3).retorno as tempo_estimado_finalizado,
                               kss.to_tempo(kss.sum_dsinterval(nvl(a.tempo_realizado_finalizado,numtodsinterval(0,'DAY'))),3).retorno as tempo_real_finalizado,
                               kss.to_tempo(kss.sum_dsinterval(nvl(a.tempo_estimado_executando,numtodsinterval(0,'DAY'))),3).retorno as tempo_estimado_executando,
                               kss.to_tempo(kss.sum_dsinterval(nvl(a.tempo_realizado_executando,numtodsinterval(0,'DAY'))),3).retorno as tempo_real_executando,
                               kss.sum_dsinterval(a.tempo_estimado_finalizado +a.tempo_estimado_executando) as tempo_total_estimado,
                               kss.to_tempo(kss.sum_dsinterval(a.tempo_realizado_finalizado +a.tempo_realizado_executando),3).retorno as tempo_total_realizado,
                               kss.to_tempo(kss.sum_dsinterval(a.tempo_estimado_finalizado +a.tempo_estimado_executando) over(),3).retorno as tempo_total_estimado_kmm,
                               kss.to_tempo(kss.sum_dsinterval(a.tempo_corretiva),3).retorno as tempo_corretiva,
                               kss.sum_dsinterval(a.tempo_corretiva) as tempo_total_corretiva
                          from (
                                select  t.tarefa_id, r.recurso_id, r.nome_completo as recurso, 
                                       case 
                                         when t.tipo_id = 1 then numtodsinterval(0,'DAY')
                                       else nvl(te.horas_pagas,numtodsinterval(0,'DAY')) end tempo_estimado_finalizado,                            
                                       case 
                                         when t.tipo_id = 1 then numtodsinterval(0,'DAY')
                                       else nvl(kmm.pkg_producao.fnc_tempo_tarefa(t.tarefa_id,te.etapa_id,r.recurso_id),numtodsinterval(0,'DAY')) end tempo_realizado_finalizado,
                                       numtodsinterval(0,'DAY') as tempo_estimado_executando,
                                       numtodsinterval(0,'DAY') as tempo_realizado_executando,
                                       trunc(nvl(t.finalizada_em,t.entregar_em)) as data_entrega,
                                       case 
                                         when t.tipo_id <> 1 then numtodsinterval(0,'DAY')
                                       else nvl(te.horas_pagas,numtodsinterval(0,'DAY')) end tempo_corretiva
                                  from kmm.v$tarefa t  
                                 inner join kmm.v$tarefa_etapa te
                                         on te.tarefa_id = t.tarefa_id
                                 inner join kmm.v$recurso r
                                         on r.recurso_id = te.recurso_id      
                                 where t.status = 7
                                   and r.custo_hora > 0
                                                             
                                 union all
                                                             
                                 select t.tarefa_id, r.recurso_id, r.nome_completo as recurso, 
                                       numtodsinterval(0,'DAY') as tempo_estimado_finalizado,
                                       numtodsinterval(0,'DAY') as tempo_realizado_finalizado,
                                       case 
                                         when t.tipo_id = 1 then numtodsinterval(0,'DAY')
                                       else nvl(te.horas_pagas,numtodsinterval(0,'DAY')) end tempo_estimado_executando,                            
                                       case 
                                         when t.tipo_id = 1 then numtodsinterval(0,'DAY')
                                       else nvl(kmm.pkg_producao.fnc_tempo_tarefa(t.tarefa_id,te.etapa_id,r.recurso_id),numtodsinterval(0,'DAY')) end tempo_realizado_executando,
                                       nvl(t.finalizada_em,t.entregar_em) as data_entrega,
                                       case 
                                         when t.tipo_id <> 1 then numtodsinterval(0,'DAY')
                                       else nvl(te.horas_pagas,numtodsinterval(0,'DAY')) end tempo_corretiva
                                  from kmm.v$tarefa t  
                                 inner join kmm.v$tarefa_etapa te
                                         on te.tarefa_id = t.tarefa_id
                                 inner join kmm.v$recurso r
                                         on r.recurso_id = te.recurso_id          
                                 where t.status in (1,2,3,4,5,6)
                                   and r.custo_hora > 0) a
                        where 1=1
                        <cfif Len(Trim(arguments.mes_anterior))>
                          and a.data_entrega between trunc(add_months(sysdate,-1),'MONTH') and last_day(add_months(sysdate,-1))
                        </cfif>
                        <cfif Len(Trim(arguments.mes_atual))>
                          and trunc(a.data_entrega) between trunc(sysdate,'MONTH') and last_day(sysdate)
                        </cfif>
                        <cfif Len(Trim(arguments.proximo_mes))>
                          and trunc(a.data_entrega) between trunc(add_months(sysdate,1),'MONTH') and last_day(add_months(sysdate,1))
                        </cfif>
                        <cfif Len(Trim(arguments.data_inicio))>
                          and trunc(a.data_entrega) >= '#arguments.data_inicio#'
                        </cfif>
                        <cfif Len(Trim(arguments.data_fim))>
                          and trunc(a.data_entrega) <= '#arguments.data_fim#'
                        </cfif>
                        <cfif (not Len(Trim(arguments.data_fim))) and (not Len(Trim(arguments.mes_atual))) and (not Len(Trim(arguments.proximo_mes))) and (not Len(Trim(arguments.mes_anterior)))>
                          and trunc(a.data_entrega) between trunc(sysdate,'MONTH') and last_day(sysdate)
                        </cfif>
                        group by a.recurso_id, a.recurso) 
                    order by valor_premio_final desc 
            </cfquery>
        <cfelse>
            <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select recurso_id, recurso, num_tarefas, atraso, tarefas,
                       round(premio,2) as premio, valor_tarefa, 
                       power(num_tarefas,(num_tarefas-atraso)/num_tarefas) as quociente, atraso/num_tarefas as perc_atrasos,
                       round(valor_tarefa*(1-(atraso/num_tarefas))*power(num_tarefas,(num_tarefas-atraso)/num_tarefas),2) as valor_premio_final,
                       tempo_estimado_finalizado, tempo_real_finalizado, tempo_estimado_executando, 
                       tempo_real_executando, kss.to_tempo(tempo_total_estimado,3).retorno as tempo_total_estimado, tempo_total_realizado, 
                       kss.to_tempo(kss.sum_dsinterval(tempo_total_estimado) over(),3).retorno as tempo_total_estimado_kmm,
                       tempo_corretiva, kss.to_tempo(kss.sum_dsinterval(tempo_total_corretiva) over(),3).retorno as tempo_corretiva_kmm
                  from (select  a.recurso_id, a.recurso, kss.fnc_concat_all(kss.to_concat_expr(a.tarefa_id,',')) as tarefas,
                               count(distinct a.tarefa_id) as num_tarefas,  (select count(ta.tarefa_id) 
                                                                               from kmm.v$tarefa_atraso ta
                                                                               inner join kmm.v$tarefa t
                                                                                       on t.tarefa_id = ta.tarefa_id
                                                                               inner join kmm.v$sd_tarefa st
                                                                                         on st.tarefa_id = t.tarefa_id
                                                                               inner join kmm.v$sd sd
                                                                                       on sd.sd_id = st.sd_id
                                                                                      and sd.status_id = 7
                                                                               where 1=1
                                                                                  and t.status <> 8
                                                                                  and ta.recurso_id = a.recurso_id 
                                                                                <cfif Len(Trim(arguments.premio_pendente))>
                                                                                  and t.premio_pago = 0
                                                                                  and trunc(coalesce(t.finalizada_em,t.entregar_em)) >= '01/05/2009'
                                                                                  <cfif Len(Trim(arguments.data_fim))>
                                                                                  and trunc(coalesce(t.finalizada_em,t.entregar_em)) <= '#arguments.data_fim#'
                                                                                  </cfif>
                                                                                </cfif>) as atraso,
                               (((sysdate + kss.sum_dsinterval(a.tempo_estimado_finalizado +a.tempo_estimado_executando)) - sysdate)*24) * #v_valor_por_hora# as premio,
                               ((((sysdate + kss.sum_dsinterval(a.tempo_estimado_finalizado +a.tempo_estimado_executando)) - sysdate)*24) * #v_valor_por_hora#) / count(distinct a.tarefa_id) as valor_tarefa,
                               kss.to_tempo(kss.sum_dsinterval(nvl(a.tempo_estimado_finalizado,numtodsinterval(0,'DAY'))),3).retorno as tempo_estimado_finalizado,
                               kss.to_tempo(kss.sum_dsinterval(nvl(a.tempo_realizado_finalizado,numtodsinterval(0,'DAY'))),3).retorno as tempo_real_finalizado,
                               kss.to_tempo(kss.sum_dsinterval(nvl(a.tempo_estimado_executando,numtodsinterval(0,'DAY'))),3).retorno as tempo_estimado_executando,
                               kss.to_tempo(kss.sum_dsinterval(nvl(a.tempo_realizado_executando,numtodsinterval(0,'DAY'))),3).retorno as tempo_real_executando,
                               kss.sum_dsinterval(a.tempo_estimado_finalizado +a.tempo_estimado_executando) as tempo_total_estimado,
                               kss.to_tempo(kss.sum_dsinterval(a.tempo_realizado_finalizado + a.tempo_realizado_executando),3).retorno as tempo_total_realizado,
                               kss.to_tempo(kss.sum_dsinterval(a.tempo_estimado_finalizado + a.tempo_estimado_executando) over(),3).retorno as tempo_total_estimado_kmm,
                               kss.to_tempo(kss.sum_dsinterval(a.tempo_corretiva),3).retorno as tempo_corretiva,
                               kss.sum_dsinterval(a.tempo_corretiva) as tempo_total_corretiva
                          from (
                                select distinct t.tarefa_id, r.recurso_id, r.nome_completo as recurso,  t.premio_pago,
                                       case 
                                         when t.tipo_id = 1 then numtodsinterval(0,'DAY')
                                         when t.premio_situacao in (1,6) then numtodsinterval(0,'DAY')
                                       else nvl(te.horas_pagas,numtodsinterval(0,'DAY')) end tempo_estimado_finalizado,                            
                                       case 
                                         when t.tipo_id = 1 then numtodsinterval(0,'DAY')
                                       else nvl(kmm.pkg_producao.fnc_tempo_tarefa(t.tarefa_id,te.etapa_id,r.recurso_id),numtodsinterval(0,'DAY')) end tempo_realizado_finalizado,
                                       numtodsinterval(0,'DAY') as tempo_estimado_executando,
                                       numtodsinterval(0,'DAY') as tempo_realizado_executando,
                                       trunc(nvl(t.finalizada_em,t.entregar_em)) as data_entrega,
                                       case 
                                         when t.tipo_id <> 1 then numtodsinterval(0,'DAY')
                                       else nvl(te.horas_pagas,numtodsinterval(0,'DAY')) end tempo_corretiva
                                  from kmm.v$tarefa t  
                                 inner join kmm.v$tarefa_etapa te
                                         on te.tarefa_id = t.tarefa_id
                                 inner join kmm.v$recurso r
                                         on r.recurso_id = te.recurso_id      
                                 inner join kmm.v$sd_tarefa st
                                         on st.tarefa_id = t.tarefa_id
                                 inner join kmm.v$sd sd
                                         on sd.sd_id = st.sd_id
                                 where t.status = 7
                                   and t.premio_situacao = 4
                                   and r.custo_hora > 0
                                   and sd.status_id = 7) a
                        where 1=1
						<cfif Len(Trim(arguments.premio_pendente))>
                          and premio_pago = 0
                          and trunc(a.data_entrega) >= '01/05/2009'
                          <cfif Len(Trim(arguments.data_fim))>
                            and trunc(a.data_entrega) <= '#arguments.data_fim#'
                          </cfif>
                        </cfif>                                                                                       
                        group by a.recurso_id, a.recurso) 
                    order by valor_premio_final desc 
            </cfquery>
        </cfif>        
		<cfreturn qr_result>		
	</cffunction>	    

	<!--- 
	-- PROPSITO 
	-- Busca cronograma TREE
	-- CRISTOFER  25/08/2006
	--->		
	<cffunction name="get_projeto_cronograma_tree" access="remote" returntype="query" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfargument name="item_raiz" required="no" default="null">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select pci.item_id, pci.titulo, a.nivel, pci.ordem, pci.data_entrega,
                   pci.tipo, tp.descricao as tipo_descricao,
                   pci.status, st.descricao as status_descricao, 
                   pci.prazo, pr.descricao as prazo_descricao, 
                   pci.detalhamento, decode(pci.detalhamento,0,'Em aberto','Concludo') as detalhamento_descricao,
                   to_char(pci.data_inicio,'dd/mm/yyyy') as data_inicio, 
                   to_char(pci.data_fim,'dd/mm/yyyy') as data_fim, 
                   kss.to_tempo(((pci.data_fim - pci.data_inicio)*1440)+1440,5).retorno as duracao,
                   pc.titulo, stp.descricao as status_cronograma,
                   (select count(distinct psd.sd_id)
                      from kmm.v$projeto_cronograma_sd psd
                      inner join kmm.v$sd sd
                              on psd.sd_id = sd.sd_id
                      inner join table(kmm.pkg_projeto.fnc_itens_abaixo(pci.item_id)) ai
                              on psd.cronograma_item_id = ai.item_id) as num_sds,
                   (select nvl(to_char(max(sd.data_previsao_entrega),'dd/mm/yyyy'),'Anlise')
                      from kmm.v$projeto_cronograma_sd psd
                      inner join kmm.v$sd sd
                              on psd.sd_id = sd.sd_id
                      inner join table(kmm.pkg_projeto.fnc_itens_abaixo(pci.item_id)) ai
                              on psd.cronograma_item_id = ai.item_id) as data_previsao_producao,
                    (select kss.fnc_concat_all(kss.to_concat_expr(psd.sd_id,','))
                      from kmm.v$projeto_cronograma_sd psd
                      inner join table(kmm.pkg_projeto.fnc_itens_abaixo(pci.item_id)) ai
                              on psd.cronograma_item_id = ai.item_id) as sd_vinculada,
                    (select max('<strong>[' || pro.user_insert || ' ' || to_char(pro.data_ocorrencia,'dd/mm') || '] </strong>' ||  pro.observacoes) keep(dense_rank last order by pro.date_insert ) 
                       from kmm.v$projeto_cronograma_ocorr pro
                      where pro.item_id = pci.item_id) as ocorrencias
              from (select p1.item_id, level as nivel, rownum as ordem
                      from kmm.v$projeto_cronograma_it p1
                      where p1.projeto_id = #arguments.PROJETO_ID#
                     start with nvl(p1.item_pai,-1) = nvl(#arguments.item_raiz#,-1)
                    connect by prior p1.item_id = p1.item_pai
                    order siblings by p1.ordem, p1.data_inicio) a
             inner join kmm.v$projeto_cronograma_it pci
                     on pci.item_id = a.item_id
             inner join kmm.v$cg_ref_codes st
                     on st.dominio = 'CRONOGRAMA ITEM STATUS'
                    and st.id = pci.status 
             inner join kmm.v$cg_ref_codes pr
                     on pr.dominio = 'CRONOGRAMA ITEM PRAZO'
                    and pr.id = pci.prazo
             inner join kmm.v$cg_ref_codes tp
                     on tp.dominio = 'CRONOGRAMA ITEM TIPO'
                    and tp.id = pci.tipo        
             left join kmm.v$projeto_cronograma pc
                    on pc.item_raiz = pci.item_id
             left join kmm.v$cg_ref_codes stp
                     on stp.dominio = 'STATUS CRONOGRAMA'
                    and stp.id = pc.status
           order by a.ordem
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca cronograma 
	-- GUTO
	--->		
	<cffunction name="get_projeto_cronograma_item" access="remote" returntype="query" output="true">
		<cfargument name="item_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select item_id, item_pai, projeto_id, titulo, ordem, data_entrega,
                   status, prazo, detalhamento, 
                   to_char(data_inicio,'dd/mm/yyyy') as data_inicio, 
                   to_char(data_fim,'dd/mm/yyyy') as data_fim,
                   tipo
              from kmm.v$projeto_cronograma_it
             where 1=1
             <cfif Len(Trim(arguments.ITEM_ID))>
             	and item_id = #arguments.ITEM_ID#
             </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca cronograma 
	-- GUTO
	--->		
	<cffunction name="get_projeto_cronograma_item_sd" access="remote" returntype="query" output="true">
		<cfargument name="item_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct sd.sd_id, psd.item_id, sd.titulo, sd.codigo, nvl(to_char(sd.data_previsao_entrega,'dd/mm/yyyy'),'Anlise') as data_previsao_producao,
            	   psd.observacao	
              from kmm.v$projeto_cronograma_sd psd
              inner join kmm.v$sd sd
                      on psd.sd_id = sd.sd_id
              inner join table(kmm.pkg_projeto.fnc_itens_abaixo(#arguments.ITEM_ID#)) ai
                      on psd.cronograma_item_id = ai.item_id
             where 1=1
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca cronograma 
	-- GUTO
	--->		
	<cffunction name="get_projeto_cronograma_item_ocorr" access="remote" returntype="query" output="true">
		<cfargument name="item_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select distinct pco.ocorrencia_id, to_char(pco.data_ocorrencia,'dd/mm hh24:mi') as data_ocorrencia, 
            	   pco.observacoes, pco.user_insert as usuario, pco.date_insert,
                   cg.descricao as tipo, pci.item_id, pci.titulo
                    from kmm.v$projeto_cronograma_ocorr pco
                    inner join table(kmm.pkg_projeto.fnc_itens_abaixo(#arguments.ITEM_ID#)) ai
                            on pco.item_id = ai.item_id
                    inner join kmm.v$projeto_cronograma_it pci
                            on pci.item_id = ai.item_id                
                    inner join kmm.v$cg_ref_codes cg
                            on cg.dominio = 'CRONOGRAMA OCORRENCIA TIPO'
                           and cg.id = pco.tipo 
                   where 1=1
                   order by pci.item_id, data_ocorrencia
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	    

	<!--- 
	-- PROPSITO 
	-- Busca lista de atrasos
	-- GUTO
	--->		
	<cffunction name="get_tarefa_atraso" access="remote" returntype="query" output="true">
		<cfargument name="recurso_id" required="no" default="">
		<cfargument name="tarefa_id" required="no" default="">
		<cfargument name="premio_pago" required="no" default="">
		<cfargument name="nao_cancelados" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.tarefa_id, t.titulo, r.nome, to_char(t.finalizada_em,'dd/mm/yyyy') as finalizada_em,
                   to_char(ta.entrega_em,'dd/mm/yyyy') as entrega_em, ta.recurso_id,
                   to_char(ta.adiada_para,'dd/mm/yyyy') as adiada_para, ta.atraso_id,
                   ta.motivo, 
                   to_char(ta.data_cancelamento,'dd/mm/yyyy') as data_cancelamento, 
                   ta.motivo_cancelamento, ta.usuario_cancelamento,
                   t.premio_pago, 
                   (select cf.descricao
                      from kmm.v$cg_ref_codes cf
                     where cf.dominio = 'STATUS TAREFA'
                       and cf.id = t.status) as status_tarefa
              from kmm.v$tarefa t
             inner join kmm.v$tarefa_atraso_todos ta
                     on ta.tarefa_id = t.tarefa_id
             inner join kmm.v$recurso r
                     on r.recurso_id = ta.recurso_id
                  where 1=1
                  <cfif Len(Trim(arguments.recurso_id))>
                  	 and ta.recurso_id = #arguments.recurso_id#
                  </cfif>
                  <cfif Len(Trim(arguments.tarefa_id))>
                  	 and ta.tarefa_id in (#arguments.tarefa_id#)
                  </cfif>
                  <cfif Len(Trim(arguments.premio_pago))>
                  	 and t.premio_pago = #arguments.premio_pago#
                  </cfif>
                  <cfif Len(Trim(arguments.nao_cancelados))>
                  	 and t.data_cancelamento is not null
                  </cfif>                  
            order by t.tarefa_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
    
    <!--- 
	-- PROPSITO 
	-- Busca diskgroup 
	-- GUTO
	--->		
	<cffunction name="get_diskgroup" access="remote" returntype="query" output="true">
		<cfargument name="diskgroup_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select diskgroup_id
            	  ,descricao
            	  ,capacidade_liquida
              from infraestrutura.v$diskgroup
             where 1=1
             <cfif Len(Trim(arguments.diskgroup_id))>
               and diskgroup_id = arguments.diskgroup_id
             </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Busca os LUNs
    -- ANDERSON 28/07/2009 - CRIADO
    --->		
    <cffunction name="get_lun" access="remote" returntype="query" output="true">
        <cfargument name="lun_id" required="no" default="">
        <cfargument name="diskgroup_id" required="no" default="">
        <cfargument name="nome" required="no" default="">
        <cfargument name="redundancia" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select dl.lun_id,
                   dl.diskgroup_id,
                   d.descricao as diskgroup_desc,
                   dl.nome,
                   dl.observacoes,
                   dl.redundancia,
                   decode(dl.redundancia, 1, 'vRaid0', 2, 'vRaid1', 3, 'vRaid5') as redundancia,
                   dl.tamanho
              from infraestrutura.v$diskgroup_lun dl
             inner join infraestrutura.v$diskgroup d
                     on d.diskgroup_id = dl.diskgroup_id
             where 1 = 1
			<cfif Len(Trim(arguments.lun_id))>
               and dl.lun_id = #arguments.lun_id#
            </cfif>
            <cfif Len(Trim(arguments.diskgroup_id))>
               and dl.diskgroup_id = #arguments.diskgroup_id#
            </cfif>
            <cfif Len(Trim(arguments.nome))>
               and upper(dl.nome) like ('#arguments.nome#%')
            </cfif>
            <cfif Len(Trim(arguments.redundancia))>
               and dl.redundancia = #arguments.redundancia#
            </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Busca as Base de Dados
    -- ANDERSON 28/07/2009 - CRIADO
    --->		
    <cffunction name="get_base_dados" access="remote" returntype="query" output="true">
        <cfargument name="base_id" required="no" default="">
        <cfargument name="cliente_id" required="no" default="">
        <cfargument name="nome" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select bd.base_id,
                   bd.lun_id,
                   dl.nome as lun,
                   bd.cliente_id,
                   c.cliente,
                   bd.nome,
                   bd.sid,
                   bd.service_name,
                   bd.host,
                   bd.port,
                   to_char(bd.data_criacao, 'dd/mm/yyyy') as data_criacao,
                   decode((select count(bdt.base_id)
                            from infraestrutura.v$base_dados_tecnico bdt
                           where bdt.base_id = bd.base_id
                             and bdt.liberado_em is null),
                          0,
                          'No',
                          'Sim') as bloqueada,
                   (select fnc_concat_all(to_concat_expr(to_char(bdt.recurso_id), ','))
                      from infraestrutura.v$base_dados_tecnico bdt
                     where bdt.base_id = bd.base_id
                       and bdt.liberado_em is null) as id_reservado_por,
                   (select fnc_concat_all(to_concat_expr(to_char(r.nome), ','))
                      from infraestrutura.v$base_dados_tecnico bdt
                     inner join kmm.recurso r on r.recurso_id = bdt.recurso_id
                     where bdt.base_id = bd.base_id
                       and bdt.liberado_em is null) as reservado_por
              from infraestrutura.v$base_dados bd
             inner join infraestrutura.v$diskgroup_lun dl
                     on dl.lun_id = bd.lun_id
             inner join kmm.v$cliente c
                     on c.cliente_id = bd.cliente_id
             where 1 = 1
			<cfif Len(Trim(arguments.base_id))>
               and bd.base_id = #arguments.base_id#
            </cfif>
            <cfif Len(Trim(arguments.cliente_id))>
               and bd.cliente_id = #arguments.cliente_id#
            </cfif>
            <cfif Len(Trim(arguments.nome))>
               and upper(bd.nome) like ('#arguments.nome#%')
            </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca lista de tarefas
	-- GUTO
	--->		
	<cffunction name="get_tarefa_lista" access="remote" returntype="query" output="true">
		<cfargument name="recurso_id" required="no" default="">
		<cfargument name="premio_pago" required="no" default="">
		<cfargument name="mes_pagamento" required="no" default="">
		<cfargument name="sd_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select tarefa_id, titulo, descricao, to_char(data_pagamento,'dd/mm/yyyy') as data_pagamento,
                   kss.to_tempo(kss.sum_dsinterval(tempo_estimado) over(),3).retorno as tempo_estimado_total, 
                   kss.to_tempo(tempo_estimado,3).retorno as tempo_estimado, 
                   kss.to_tempo(tempo_realizado_tecnico,3).retorno as tempo_realizado_tecnico, 
                   kss.to_tempo(kss.sum_dsinterval(tempo_realizado_tecnico) over(),3).retorno as tempo_realizado_total, 
                   tecnico, tipo, tipo_id, atrasos, sd
              from (select t.tarefa_id, t.titulo, to_char(t.descricao) as descricao, t.data_pagamento, 
                           kss.sum_dsinterval(te.tempo_estimado) as tempo_estimado, 
                           kss.sum_dsinterval(te.tempo_realizado) as tempo_realizado_tecnico,
                           r.nome_completo as tecnico,
                           (select cg.descricao 
                              from kmm.v$cg_ref_codes cg
                             where cg.dominio = 'TIPO TAREFA'
                               and cg.id = t.tipo_id) as tipo,
                           t.tipo_id,
                           (select count(*) 
                              from kmm.v$tarefa_atraso ta
                             where ta.tarefa_id = t.tarefa_id
                               and ta.recurso_id = r.recurso_id) as atrasos,
                           sd.codigo || '-' || sd.titulo as sd
                      from kmm.v$tarefa t
                     inner join kmm.v$tarefa_etapa te
                             on te.tarefa_id = t.tarefa_id
                     inner join kmm.v$ciclo_vida_etapa ce
                             on ce.etapa_id = te.etapa_id
                     inner join kmm.v$recurso r
                             on r.recurso_id = te.recurso_id
                     inner join kmm.v$sd_tarefa st
                             on st.tarefa_id = t.tarefa_id
                     inner join kmm.v$sd sd
                             on sd.sd_id = st.sd_id
                      where 1=1
					  <cfif Len(Trim(arguments.premio_pago))>
                         and t.premio_pago = #arguments.premio_pago#
                      </cfif>
					  <cfif Len(Trim(arguments.mes_pagamento))>
                        and to_char(t.data_pagamento,'mm') = #arguments.mes_pagamento#
                      </cfif>
					  <cfif Len(Trim(arguments.ano_pagamento))>
                        and to_char(t.data_pagamento,'yyyy') = #arguments.ano_pagamento#
                      </cfif>
					  <cfif Len(Trim(arguments.sd_id))>
                        and st.sd_id = #arguments.sd_id#
                      </cfif>
					  <cfif Len(Trim(arguments.recurso_id))>
                         and te.recurso_id = #arguments.recurso_id#
                      </cfif>
                    group by t.tarefa_id, t.titulo, to_char(t.descricao), r.nome_completo, t.tipo_id, r.recurso_id, t.data_pagamento, sd.codigo || '-' || sd.titulo) t
            order by sd, tarefa_id 
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	    

    <!--- 
    -- PROPSITO 
    -- Busca as tempo projeto
    -- GUTO 30/07/2009 - CRIADO
    --->		
    <cffunction name="get_tempo_projeto" access="remote" returntype="query" output="true">
        <cfargument name="projeto_id" required="no" default="">
        <cfargument name="data" required="no" default="">
        <cfargument name="mes" required="no" default="0">
        <cfargument name="horas_consumidas" required="no" default="0">
        <cfargument name="horas_restantes_mes" required="no" default="0">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select a.data, a.ph.horas_restantes as horas_restantes <cfif arguments.MES eq 0>, a.ph.minutos_restantes as minutos_restantes,
                   a.ph.horas_restantes_mes as horas_restantes_mes, a.ph.horas_consumidas as horas_consumidas </cfif>
                   <cfif arguments.HORAS_CONSUMIDAS eq 1>,a.ph.horas_consumidas as horas_consumidas</cfif>
                   <cfif arguments.HORAS_RESTANTES_MES eq 1>,a.ph.horas_restantes_mes as horas_restantes_mes</cfif>
              from (select p.titulo,
                          d.data, 
                          kmm.to_projeto_horas(p.projeto_id,d.data) ph
                     from kmm.v$projeto p
                    cross join (select to_date('#arguments.DATA#')+level-1 as data
                                  from dual
                               connect by to_date('#arguments.DATA#')+level-1 <= last_day(to_date('#arguments.DATA#'))) d
                    where p.projeto_id = #arguments.PROJETO_ID#
                      <cfif arguments.MES eq 0>
                        and d.data = '#arguments.DATA#'
                      </cfif>
              ) a
              order by a.data
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca Nveis de Habilidade 
	-- Rafael
	--->		
	<cffunction name="get_habilidade_nivel" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select nivel_id
            	  ,descricao
              from kmm.v$habilidade_nivel
             where 1=1
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>
   
   <!--- 
	-- PROPSITO 
	-- Busca lista de habilidades
	-- JONAS 31/07/2009
	--->		
	<cffunction name="get_habilidade" access="remote" returntype="query" output="true">
		<cfargument name="habilidade_id" required="no" default="">
		<cfargument name="descricao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select h.habilidade_id, h.descricao
              from kmm.v$habilidade h
             where 1=1
				<cfif Len(Trim(arguments.habilidade_id))>
               and h.habilidade_id in (#arguments.habilidade_id#)
            </cfif>
            <cfif Len(Trim(arguments.descricao))>
               and upper(h.descricao) like upper('#arguments.descricao#%')
            </cfif>
             order by h.habilidade_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
   
   <!--- 
	-- PROPSITO 
	-- Busca lista de habilidades
	-- JONAS 31/07/2009
	--->		
	<cffunction name="get_etapa_habilidade" access="remote" returntype="query" output="true">
		<cfargument name="etapa_id" required="no" default="">
      <cfargument name="habilidade_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select h.habilidade_id
                 , h.descricao as habilidade_descricao
                 , e.etapa_id
                 , e.descricao as etapa_descricao
              from kmm.v$ciclo_vida_etapa_habilidade eh
             inner join kmm.v$ciclo_vida_etapa e
                     on e.etapa_id = eh.etapa_id
             inner join kmm.v$habilidade h
                     on h.habilidade_id = eh.habilidade_id
             where 1=1
            <cfif Len(Trim(arguments.etapa_id))>
               and h.habilidade_id in (#arguments.habilidade_id#)
            </cfif>
				<cfif Len(Trim(arguments.habilidade_id))>
               and h.habilidade_id in (#arguments.habilidade_id#)
            </cfif>
             order by eh.etapa_id,eh.habilidade_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
   

	<!--- 
	-- PROPSITO 
	-- Busca as habilidades para edicao da tarefa
	-- CRISTOFER  03/08/2009
	--->		
	<cffunction name="get_tarefa_habilidade_edicao" access="remote" returntype="query" output="true">
    	<cfargument name="tarefa_id" required="no" default="-1">
    	<cfargument name="projeto_id" required="no" default="">
    	<cfargument name="sd_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select h.habilidade_id,
                   h.descricao as habilidade,
                   cve.etapa_id,
                   cve.descricao as etapa,
                   th.nivel_id,
                   hn.descricao as nivel
              from kmm.v$projeto_ciclo_vida t
             inner join kmm.v$ciclo_vida_etapa cve
                     on cve.etapa_id = t.etapa_id
             inner join kmm.v$ciclo_vida_etapa_habilidade cveh
                     on cveh.etapa_id = t.etapa_id
             inner join kmm.v$habilidade h
                     on h.habilidade_id = cveh.habilidade_id
             <cfif Len(Trim(arguments.SD_ID))>
             	inner join kmm.v$sd sd
                        on sd.projeto_id = t.projeto_id
                       and sd.sd_id = #arguments.SD_ID#
             </cfif>                     
              left join kmm.v$tarefa_habilidade th
                     on th.habilidade_id = h.habilidade_id
            <cfif len(trim(arguments.tarefa_id))>
                    and th.tarefa_id = #arguments.tarefa_id#
            <cfelse>
                    and th.tarefa_id = -1
            </cfif>
              left join kmm.v$habilidade_nivel hn
                     on hn.nivel_id = th.nivel_id
             where 1=1
            <cfif len(trim(arguments.projeto_id))>
               and t.projeto_id = #arguments.projeto_id#
            <cfelse>
            </cfif>
             order by t.num_etapa, h.descricao 
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Busca as habilidades de um recurso com seus nveis
    -- ANDERSON 05/08/2009 - CRIADO
    --->		
    <cffunction name="get_recurso_habilidade_nivel" access="remote" returntype="query" output="true">
        <cfargument name="recurso_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.controle_id
                 , t.recurso_id
                 , t.habilidade_id
                 , t.nivel_id
              from kmm.v$recurso_habilidade_nivel t
             where t.recurso_id = #arguments.recurso_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Busca os crditos de horas de um projeto
    -- ANDERSON 05/08/2009 - CRIADO
    --->		
    <cffunction name="get_projeto_horas_data" access="remote" returntype="query" output="true">
        <cfargument name="projeto_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.controle_id
                 , t.projeto_id
                 , to_char(t.data, 'dd/mm/yyyy') as data_credito
                 , t.horas
              from kmm.v$projeto_horas_data t
             where t.projeto_id = #arguments.projeto_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as etapas disponiveis das tarefas
	-- CRISTOFER  06/08/2009
	--->		
	<cffunction name="get_tarefa_etapa_disponivel" access="remote" returntype="query" output="true">
    	<cfargument name="tarefa_id" required="yes">
        <cfargument name="recurso_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select te.tarefa_id,
                   cg.grupo_id,
                   cg.descricao,
                   case 
                      when count(distinct te.recurso_id) <= 1 
                       and nvl(max(te.recurso_id),'#arguments.recurso_id#') = '#arguments.recurso_id#' 
                       and count(te.recurso_id) <> count(te.etapa_id) then 1
                      else 0
                   end as disponivel,
                   kmm.pkg_tarefa.fnc_recurso_etapa_grupo_tarefa('#arguments.recurso_id#',te.tarefa_id,cg.grupo_id) possui_habilidade
              from kmm.v$tarefa_etapa te
             inner join kmm.v$ciclo_vida_etapa ce
                     on ce.etapa_id = te.etapa_id
             inner join kmm.v$ciclo_vida_etapa_grupo cg
                     on cg.grupo_id = ce.grupo_id
             where te.tarefa_id = #arguments.tarefa_id#
             group by te.tarefa_id,cg.grupo_id, cg.descricao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>         	    

	<!--- 
	-- PROPSITO 
	-- Busca as habilidades de uma tarefa
	-- CRISTOFER  06/08/2009
	--->		
	<cffunction name="get_tarefa_habilidade_recurso" access="remote" returntype="query" output="true">
    	<cfargument name="tarefa_id" required="yes">
        <cfargument name="recurso_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cg.grupo_id,
                   cg.descricao as grupo,
                   th.habilidade_id,
                   h.descricao as habilidade,
                   th.nivel_id,
                   hn.descricao as nivel,
                   kmm.pkg_tarefa.FNC_RECURSO_HABILIDADE('#arguments.recurso_id#',th.habilidade_id,th.nivel_id) as possui_habilidade
              from kmm.v$tarefa_etapa te
             inner join kmm.v$ciclo_vida_etapa ce
                     on ce.etapa_id = te.etapa_id
             inner join kmm.v$ciclo_vida_etapa_grupo cg
                     on cg.grupo_id = ce.grupo_id
             inner join kmm.v$tarefa_habilidade th
                     on th.tarefa_id = te.tarefa_id
             inner join kmm.v$ciclo_vida_etapa_habilidade ch
                     on ch.etapa_id = te.etapa_id
                    and ch.habilidade_id = th.habilidade_id
             inner join kmm.v$habilidade h
                     on h.habilidade_id = th.habilidade_id
             inner join kmm.v$habilidade_nivel hn
                     on hn.nivel_id = th.nivel_id
             where te.tarefa_id = #arguments.tarefa_id#
             order by cg.grupo_id, h.descricao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>         	    

	<!--- 
	-- PROPSITO 
	-- Busca tarefas para premio
	-- GUTO 08/08/2009
	--->		 
	<cffunction name="get_tarefa_premio" access="remote" returntype="query" output="true">
        <cfargument name="tarefa_id" required="no" default="">
        <cfargument name="recurso_id" required="no" default="">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_fim" required="no" default="">
        <cfargument name="premio_pago" required="no" default="">
        <cfargument name="premio_situacao" required="no" default="">
        <cfargument name="status_sd_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select tarefa_id, to_char(data_lancamento,'dd/mm/yyyy') as data_lancamento, cliente, titulo, tipo_id
            	   ,tempo_estimado, horas_pagas, tempo_realizado, etapa, tempo_estimado_etapa, horas_pagas_etapa
                   ,tempo_realizado_etapa, valor_pago
                   ,to_char(entregar_em,'dd/mm/yyyy') as entregar_em
                   ,to_char(finalizada_em,'dd/mm/yyyy') as finalizada_em,  nvl(finalizada_em,entregar_em) as data_limite
                   ,to_char(data_pagamento,'dd/mm/yyyy') as data_pagamento
                   ,status_id, tipo_tarefa
                   ,status, premio_situacao, premio_situacao_id, codigo, titulo_sd, status_sd, status_id_sd, total_tarefas
                   ,sum(case 
                     when a.status_id_sd = 7 and a.premio_situacao_id = 4 then valor_pago
                    else 0 end) over() valor_pendente_pagamento
                   ,sum(case 
                     when a.premio_situacao_id in (2,3) then valor_pago
                    else 0 end) over() valor_pendente_aprovacao
                   ,sum(case 
                     when a.premio_situacao_id in (5) then valor_pago
                    else 0 end) over() valor_pago_total, nome
              from (select distinct t.tarefa_id, t.data_lancamento, t.titulo, t.tipo_id, t.data_pagamento, r.nome
                           ,kss.to_tempo(t.tempo_estimado,3).retorno as tempo_estimado
                           ,kss.to_tempo(t.horas_pagas,3).retorno as horas_pagas
                           ,kss.to_tempo(nvl(t.tempo_realizado,numtodsinterval(0,'DAY')),3).retorno as tempo_realizado
                           ,ce.descricao as etapa, ce.num_etapa
                           ,kss.to_tempo(te.tempo_estimado,3).retorno as tempo_estimado_etapa
                           ,kss.to_tempo(te.horas_pagas,3).retorno as horas_pagas_etapa
                           ,kss.to_tempo(nvl(te.tempo_realizado,numtodsinterval(0,'DAY')),3).retorno as tempo_realizado_etapa
                           ,case
                              when t.tipo_id = 1 then 0.00
                              when t.premio_situacao = 1 then 0.00
                              when t.premio_situacao = 6 then 0.00
                            else round((sysdate+te.horas_pagas-sysdate) * 24 * t.valor_hora_premio,2) end valor_pago
                           ,t.entregar_em, t.finalizada_em, t.status as status_id
                           ,(select cg.descricao
                              from kmm.v$cg_ref_codes cg
                             where cg.dominio = 'TIPO TAREFA'
                               and cg.id = t.tipo_id) as tipo_tarefa
                           ,(select cg.descricao
                              from kmm.v$cg_ref_codes cg
                             where cg.dominio = 'STATUS TAREFA'
                               and cg.id = t.status) as status
                           ,(select cg.descricao
                              from kmm.v$cg_ref_codes cg
                             where cg.dominio = 'PREMIO SITUACAO'
                               and cg.id = t.premio_situacao) as premio_situacao
                           ,t.premio_situacao as premio_situacao_id
                           ,sd.codigo, sd.titulo as titulo_sd, c.nome as cliente
                           ,(select cg.descricao
                              from kmm.v$cg_ref_codes cg
                             where cg.dominio = 'SD STATUS'
                               and cg.id = sd.status_id) as status_sd, sd.status_id as status_id_sd
                           ,count(distinct t.tarefa_id) over() as total_tarefas
                      from kmm.v$tarefa t
                     inner join kmm.v$tarefa_etapa te
                             on te.tarefa_id = t.tarefa_id
                     inner join kmm.v$ciclo_vida_etapa ce
                             on ce.etapa_id = te.etapa_id         
                     inner join kmm.v$recurso r
                             on r.recurso_id = te.recurso_id
                     inner join kmm.v$sd_tarefa st
                             on st.tarefa_id = t.tarefa_id
                     inner join kmm.v$sd sd
                             on sd.sd_id = st.sd_id
                     inner join kmm.v$projeto p 
                             on p.projeto_id = sd.projeto_id
                     inner join kmm.v$cliente c
                             on c.cliente_id = p.cliente_id
                     where nvl(t.finalizada_em,t.entregar_em) >= '01/05/2009'
                       <cfif Len(Trim(arguments.RECURSO_ID)) and not Len(Trim(arguments.TAREFA_ID))>
                         and r.recurso_id = #arguments.recurso_id#
                       </cfif>
                       <cfif Len(Trim(arguments.DATA_INICIO)) and not Len(Trim(arguments.TAREFA_ID))>
                       	 and nvl(t.finalizada_em,t.entregar_em) >= '#arguments.DATA_INICIO#'
                       </cfif>
                       <cfif Len(Trim(arguments.DATA_FIM)) and not Len(Trim(arguments.TAREFA_ID))>
                       	 and nvl(t.finalizada_em,t.entregar_em) <= '#arguments.DATA_FIM#'
                       </cfif>
					   <cfif Len(Trim(arguments.PREMIO_PAGO)) and not Len(Trim(arguments.TAREFA_ID))>
                         and t.premio_pago = #arguments.PREMIO_PAGO#
                       </cfif>
					   <cfif Len(Trim(arguments.TAREFA_ID))>
                         and t.tarefa_id = #arguments.TAREFA_ID#
                       </cfif>
					   <cfif Len(Trim(arguments.PREMIO_SITUACAO)) and not Len(Trim(arguments.TAREFA_ID))>
                         and t.premio_situacao = #arguments.PREMIO_SITUACAO#
                       </cfif>
                       <cfif Len(Trim(arguments.STATUS_SD_ID)) and not Len(Trim(arguments.TAREFA_ID))>
                         and sd.status_id = #arguments.STATUS_SD_ID#
                       </cfif>                       
                    order by t.tarefa_id, ce.num_etapa) a
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>         	        

	<!--- 
	-- PROPSITO 
	-- Busca tarefas com atraso para premio 
	-- GUTO 08/08/2009
	--->		 
	<cffunction name="get_tarefa_premio_atraso" access="remote" returntype="query" output="true">
        <cfargument name="recurso_id" required="no" default="">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_fim" required="no" default="">
        <cfargument name="premio_pago" required="no" default="">
        <cfargument name="premio_situacao" required="no" default="">
        <cfargument name="status_sd_id" required="no" default="">
        <cfargument name="tarefa_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.tarefa_id, t.titulo
                   ,to_char(t.entregar_em,'dd/mm/yyyy') as entregar_em
                   ,to_char(t.finalizada_em,'dd/mm/yyyy') as finalizada_em
                   ,to_char(t.data_pagamento,'dd/mm/yyyy') as data_pagamento
                   ,(select cg.descricao
                                          from kmm.v$cg_ref_codes cg
                                         where cg.dominio = 'TIPO TAREFA'
                                           and cg.id = t.tipo_id) as tipo_tarefa
                                       ,(select cg.descricao
                                          from kmm.v$cg_ref_codes cg
                                         where cg.dominio = 'STATUS TAREFA'
                                           and cg.id = t.status) as status 
                   ,to_char(ta.entrega_em,'dd/mm/yyyy') as entrega_em
                   ,to_char(ta.adiada_para,'dd/mm/yyyy') as adiada_para
                   ,to_char(ta.data_cancelamento,'dd/mm/yyyy') as data_cancelamento
                   ,ta.motivo, t.status as status_id
                   ,ta.motivo_cancelamento, ta.usuario_cancelamento
                   ,(select cg.descricao
                                          from kmm.v$cg_ref_codes cg
                                         where cg.dominio = 'PREMIO SITUACAO'
                                           and cg.id = t.premio_situacao) as premio_situacao
                   ,t.premio_situacao as premio_situacao_id
                   ,sd.codigo, sd.titulo as titulo_sd, c.nome as cliente
                   ,(select cg.descricao
                      from kmm.v$cg_ref_codes cg
                     where cg.dominio = 'SD STATUS'
                       and cg.id = sd.status_id) as status_sd, sd.status_id as status_id_sd
              from kmm.v$tarefa t
              inner join kmm.v$tarefa_atraso ta
                      on ta.tarefa_id = t.tarefa_id
              inner join kmm.v$sd_tarefa st
                      on st.tarefa_id = t.tarefa_id
              inner join kmm.v$sd sd
                      on sd.sd_id = st.sd_id
              inner join kmm.v$projeto p 
                      on p.projeto_id = sd.projeto_id
              inner join kmm.v$cliente c
                      on c.cliente_id = p.cliente_id
             where 1=1
               <cfif Len(Trim(arguments.RECURSO_ID)) and not Len(Trim(arguments.TAREFA_ID))>
	             and ta.recurso_id = #arguments.recurso_id#
               </cfif>
                 and nvl(t.finalizada_em,t.entregar_em) >= '01/05/2009'
               <cfif Len(Trim(arguments.DATA_INICIO)) and not Len(Trim(arguments.TAREFA_ID))>
                 and nvl(t.finalizada_em,t.entregar_em) >= '#arguments.DATA_INICIO#'
               </cfif>
               <cfif Len(Trim(arguments.DATA_FIM)) and not Len(Trim(arguments.TAREFA_ID))>
                 and nvl(t.finalizada_em,t.entregar_em) <= '#arguments.DATA_FIM#'
               </cfif>
               <cfif Len(Trim(arguments.PREMIO_PAGO)) and not Len(Trim(arguments.TAREFA_ID))>
                 and t.premio_pago = #arguments.PREMIO_PAGO#
               </cfif>
               <cfif Len(Trim(arguments.PREMIO_SITUACAO)) and not Len(Trim(arguments.TAREFA_ID))>
                 and t.premio_situacao = #arguments.PREMIO_SITUACAO#
               </cfif>
			   <cfif Len(Trim(arguments.TAREFA_ID))>
                 and t.tarefa_id = #arguments.TAREFA_ID#
               </cfif>
               <cfif Len(Trim(arguments.STATUS_SD_ID)) and not Len(Trim(arguments.TAREFA_ID))>
                 and sd.status_id = #arguments.STATUS_SD_ID#
               </cfif>
            order by t.tarefa_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>         

	<!--- 
	-- PROPSITO 
	-- Busca tarefas com atraso para premio 
	-- GUTO 08/08/2009
	--->		 
	<cffunction name="get_painel_premio" access="remote" returntype="query" output="true">
        <cfargument name="recurso_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select recurso_id, recurso, num_tarefas, atraso, tarefas, mes_ano,
                   round(premio,2) as premio, valor_tarefa, 
                   power(num_tarefas,(num_tarefas-atraso)/num_tarefas) as quociente, atraso/num_tarefas as perc_atrasos,
                   round(valor_tarefa*(1-(atraso/num_tarefas))*power(num_tarefas,(num_tarefas-atraso)/num_tarefas),2) as valor_premio_final,
                   tempo_estimado_finalizado, tempo_real_finalizado, tempo_estimado_executando, 
                   tempo_real_executando, kss.to_tempo(tempo_total_estimado,3).retorno as tempo_total_estimado, tempo_total_realizado, 
                   kss.to_tempo(kss.sum_dsinterval(tempo_total_estimado) over(),3).retorno as tempo_total_estimado_kmm,
                   tempo_corretiva, kss.to_tempo(kss.sum_dsinterval(tempo_total_corretiva) over(),3).retorno as tempo_corretiva_kmm
              from (select a.recurso_id, a.recurso, kss.fnc_concat_all(kss.to_concat_expr(a.tarefa_id,',')) as tarefas, to_char(add_months(a.data_entrega,-1),'mm/yyyy') as mes_ano,
                           count(distinct a.tarefa_id) as num_tarefas,  (select count(ta.tarefa_id) 
                                                                           from kmm.v$tarefa_atraso ta
                                                                           inner join kmm.v$tarefa t
                                                                                   on t.tarefa_id = ta.tarefa_id
                                                                           inner join kmm.v$sd_tarefa st
                                                                                     on st.tarefa_id = t.tarefa_id
                                                                           inner join kmm.v$sd sd
                                                                                   on sd.sd_id = st.sd_id
                                                                                  and sd.status_id = 7
                                                                           where 1=1
                                                                              and t.status <> 8
                                                                              and ta.recurso_id = a.recurso_id 
                                                                              and t.premio_pago = 1
                                                                              and to_char(t.data_pagamento,'yyyymm') = to_char(a.data_entrega,'yyyymm')
                                                                            ) as atraso,
                           (((sysdate + kss.sum_dsinterval(a.tempo_estimado_finalizado +a.tempo_estimado_executando)) - sysdate)*24) * max(a.valor_hora_premio) as premio,
                           ((((sysdate + kss.sum_dsinterval(a.tempo_estimado_finalizado +a.tempo_estimado_executando)) - sysdate)*24) * max(a.valor_hora_premio)) / count(distinct a.tarefa_id) as valor_tarefa,
                           kss.to_tempo(kss.sum_dsinterval(nvl(a.tempo_estimado_finalizado,numtodsinterval(0,'DAY'))),3).retorno as tempo_estimado_finalizado,
                           kss.to_tempo(kss.sum_dsinterval(nvl(a.tempo_realizado_finalizado,numtodsinterval(0,'DAY'))),3).retorno as tempo_real_finalizado,
                           kss.to_tempo(kss.sum_dsinterval(nvl(a.tempo_estimado_executando,numtodsinterval(0,'DAY'))),3).retorno as tempo_estimado_executando,
                           kss.to_tempo(kss.sum_dsinterval(nvl(a.tempo_realizado_executando,numtodsinterval(0,'DAY'))),3).retorno as tempo_real_executando,
                           kss.sum_dsinterval(a.tempo_estimado_finalizado +a.tempo_estimado_executando) as tempo_total_estimado,
                           kss.to_tempo(kss.sum_dsinterval(a.tempo_realizado_finalizado + a.tempo_realizado_executando),3).retorno as tempo_total_realizado,
                           kss.to_tempo(kss.sum_dsinterval(a.tempo_estimado_finalizado + a.tempo_estimado_executando) over(),3).retorno as tempo_total_estimado_kmm,
                           kss.to_tempo(kss.sum_dsinterval(a.tempo_corretiva),3).retorno as tempo_corretiva,
                           kss.sum_dsinterval(a.tempo_corretiva) as tempo_total_corretiva
                      from (
                            select t.tarefa_id, r.recurso_id, r.nome_completo as recurso,  t.premio_pago, t.valor_hora_premio,
                                   case
                                     when t.tipo_id = 1 then numtodsinterval(0, 'DAY')
                                     else nvl(te.horas_pagas, numtodsinterval(0, 'DAY'))
                                   end tempo_estimado_finalizado,                            
                                   case
                                         when t.tipo_id = 1 then
                                          numtodsinterval(0, 'DAY')
                                         else
                                          nvl(kmm.pkg_producao.fnc_tempo_tarefa(t.tarefa_id,
                                                                                te.etapa_id,
                                                                                r.recurso_id),
                                              numtodsinterval(0, 'DAY'))
                                       end tempo_realizado_finalizado,
                                   numtodsinterval(0,'DAY') as tempo_estimado_executando,
                                   numtodsinterval(0,'DAY') as tempo_realizado_executando,
                                   t.data_pagamento as data_entrega,
                                   case 
                                     when t.tipo_id <> 1 then numtodsinterval(0,'DAY')
                                   else nvl(te.horas_pagas,numtodsinterval(0,'DAY')) end tempo_corretiva
                              from kmm.v$tarefa t  
                             inner join kmm.v$tarefa_etapa te
                                     on te.tarefa_id = t.tarefa_id
                             inner join kmm.v$recurso r
                                     on r.recurso_id = te.recurso_id      
                             inner join kmm.v$sd sd
                                     on sd.sd_id = t.sd_id
                             where t.status = 7
                               and r.custo_hora > 0
                               and sd.status_id = 7) a
                    where 1=1
                      and premio_pago = 1
                      and trunc(a.data_entrega) >= trunc(to_date('01/05/2009','dd/mm/yyyy'),'MONTH')
                      and trunc(a.data_entrega) >= trunc(add_months(sysdate,-6),'MONTH')
                      and trunc(a.data_entrega) <= last_day(sysdate)
                    group by a.recurso_id, a.recurso, a.data_entrega, to_char(a.data_entrega,'yyyymm')) 
                 where 1=1
               <cfif Len(Trim(arguments.RECURSO_ID))>
                 and recurso_id = #arguments.RECURSO_ID#
               </cfif>
                order by mes_ano
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>         	            

	<!--- 
	-- PROPSITO 
	-- Busca tarefas com atraso para premio 
	-- GUTO 08/08/2009
	--->		 
	<cffunction name="get_painel_producao_tecnico" access="remote" returntype="query" output="true">
        <cfargument name="recurso_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select b.num_tarefas
                  ,b.mes_ano
                  ,b.tecnico
                  ,kss.to_tempo(b.horas_produtivas,3).retorno as horas_produtivas
                  ,(sysdate+b.tempo_producao_total-sysdate)*24 as horas_producao_total
                  ,kss.to_tempo(b.tempo_producao_total,3).retorno as horas_producao_tarefa
                  ,round(((sysdate+b.tempo_producao_total-sysdate)/(sysdate+b.horas_produtivas-sysdate))*100,2) as perc_producao_tarefas
                  ,round((1-((sysdate+b.tempo_producao_total-sysdate)/(sysdate+b.horas_produtivas-sysdate)))*100,2) as perc_ociosidade_tarefa
                  ,kss.to_tempo(b.tempo_producao_planilha,3).retorno as horas_producao_planilha      
                  ,round(((sysdate+b.tempo_producao_planilha-sysdate)/(sysdate+b.horas_produtivas-sysdate))*100,2) as perc_producao_planilha
                  ,round((1-((sysdate+b.tempo_producao_planilha-sysdate)/(sysdate+b.horas_produtivas-sysdate)))*100,2) as perc_ociosidade_planilha
              from (select a.num_tarefas
                          ,a.ano_mes
                          ,a.mes_ano 
                          ,a.usuario as tecnico
                          ,a.tempo_producao_total
                          ,numtodsinterval((select sum((kmm.pkg_tarefa.fnc_dia_util(trunc(to_date('01/'||a.mes_ano,'dd/mm/yyyy'),'month')+level-1)))
                                             from dual
                                            where to_char(trunc(to_date('01/'||a.mes_ano,'dd/mm/yyyy'),'month')+level-1, 'd') not in (1,7) 
			                               connect by trunc(to_date('01/'||a.mes_ano,'dd/mm/yyyy'),'month')+level-1 <= case when last_day(to_date('01/'||a.mes_ano,'dd/mm/yyyy')) > sysdate then sysdate else last_day(to_date('01/'||a.mes_ano,'dd/mm/yyyy')) end )*8,'HOUR') as horas_produtivas
                          ,numtodsinterval((select sum(s.tempo_minutos)
                                              from kmm.v$atendimento_suporte s
                                             where s.atendimento_usuario = a.usuario
                                               and to_char(s.atendimento_data,'yyyymm') = ano_mes),'MINUTE') as tempo_producao_planilha
                      from (select count(distinct t.tarefa_id) as num_tarefas, r.nome as usuario
                                  ,kss.sum_dsinterval(te.tempo_estimado) as tempo_producao_total
                                  ,to_char(nvl(t.finalizada_em,t.entregar_em),'yyyymm') as ano_mes
                                  ,to_char(nvl(t.finalizada_em,t.entregar_em),'mm/yyyy') as mes_ano
                              from kmm.v$tarefa t
                             inner join kmm.v$tarefa_etapa te
                                     on te.tarefa_id = t.tarefa_id
                             inner join kmm.v$recurso r 
                                     on r.recurso_id = te.recurso_id
                            where 1=1
                              and nvl(t.finalizada_em,t.entregar_em) >= '01/05/2009'
                              and nvl(t.finalizada_em,t.entregar_em) >= trunc(add_months(sysdate,-6),'MONTH')
                              and t.status = 7
                              and r.custo_hora > 0
							  <cfif Len(Trim(arguments.RECURSO_ID))>
                                and te.recurso_id = #arguments.RECURSO_ID#
                              </cfif>
                            group by to_char(nvl(t.finalizada_em,t.entregar_em),'yyyymm'), to_char(nvl(t.finalizada_em,t.entregar_em),'mm/yyyy'), r.nome
                            order by r.nome, ano_mes) a) b
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>    

	<!--- 
	-- PROPSITO 
	-- Busca Projeo de Desenvolvimento
	-- CRISTOFER  06/08/2009
	--->		
	<cffunction name="get_projecao_producao" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select to_char(data,'dd/mm/yyyy') as data, 100 as contratado
                  ,kss.to_tempo(sum((((sysdate+tempo_tarefas-sysdate)/(sysdate+horas-sysdate))*(sysdate+horas_mes-sysdate)) * 1440),3).retorno as projecao_horas_mes
                  ,kss.to_tempo(horas_contratadas * 60,3).retorno as horas_contratadas
                  ,round((sum((((sysdate+tempo_tarefas-sysdate)/(sysdate+horas-sysdate))*(sysdate+horas_mes-sysdate)) * 1440) / (horas_contratadas * 60))*100,2) as percentual_estimado
              from (select b.data, b.nome, b.produtividade
                          ,b.horas_produtivas as horas
                          ,b.horas_produtivas_mes as horas_mes
                          ,b.recurso_id
                          ,(select sum(a.horas)
                              from (select sum(phm.horas) as horas
                                      from kmm.v$projeto_horas_mes phm
                                     where to_date('01/' || phm.mes || '/' || phm.ano,'dd/mm/yyyy') = trunc(sysdate,'month')
                                    union   
                                    select sum(phm.horas)
                                      from kmm.v$projeto_horas_data phm
                                     where phm.data between trunc(sysdate,'month') and last_day(sysdate)
                                    ) a) as horas_contratadas
                          ,(select kss.sum_dsinterval(te.tempo_estimado)
                              from kmm.v$tarefa t
                              inner join kmm.v$tarefa_etapa te
                                      on te.tarefa_id = t.tarefa_id
                             where te.recurso_id = b.recurso_id
                               and t.status = 7
                               and trunc(nvl(t.finalizada_em,t.entregar_em)) between trunc(b.data,'month') and case when b.data > sysdate then sysdate else b.data end) as tempo_tarefas
                     from (select a.data, t.nome, t.produtividade, t.recurso_id
                                 ,numtodsinterval((select count(*) 
                                                     from dual
                                                    where to_char(trunc(a.data,'month')+level-1, 'd') not in (1,7) 
                                                  connect by trunc(a.data,'month')+level-1 <= case when trunc(a.data,'month') > sysdate then sysdate else a.data end )*(8*(t.produtividade/100)),'HOUR') as horas_produtivas
                                 ,numtodsinterval((select count(*) 
                                                     from dual
                                                    where to_char(trunc(a.data,'month')+level-1, 'd') not in (1,7) 
                                                  connect by trunc(a.data,'month')+level-1 <= last_day(a.data))*(8*(t.produtividade/100)),'HOUR') as horas_produtivas_mes
                             from kmm.v$recurso t
                            cross join (select trunc(sysdate,'month')+level-1 as data
                                          from dual
                                         where to_char(trunc(sysdate,'month')+level-1, 'd') not in (1,7) 
                                        connect by trunc(sysdate,'month')+level-1 <= last_day(sysdate)) a
                           where t.tecnico = 1
                             and t.ativo = 1
                             and t.exibir_ranking = 1) b
                           where b.data >= '01/05/2009') x
            where data <= trunc(sysdate)               
            group by data               
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>      
    
	<!--- 
	-- PROPSITO 
	-- Calcula o proximo dia util
	-- CRISTOFER  06/08/2009
	--->		
	<cffunction name="get_dia_util" access="remote" returntype="string" output="true">
    	<cfargument name="data" required="yes">
        <cfargument name="dias" required="no" default="1">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select to_char(kmm.pkg_tarefa.fnc_add_dias_uteis('#arguments.data#',#arguments.dias#),'dd/mm/yyyy hh24:mi:ss') as dia
              from dual
		</cfquery>
		<cfreturn qr_result.dia>		
	</cffunction>      

	<!--- 
	-- PROPSITO 
	-- Retorna situao das horas dos projetos
	-- CRISTOFER  06/08/2009
	--->		
	<cffunction name="get_projetos_horas" access="remote" returntype="query" output="true">
    	<cfargument name="data" required="no" default="">
        <cfargument name="grupo_id" required="no" default="">
        <cfargument name="cliente_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select a.projeto_id
                  ,a.titulo
                  ,a.cliente
                  ,a.grupo
                  ,a.prj_tarefa.horas_restantes as horas_restantes_data
                  ,kss.to_tempo(nvl((select least(min(kmm.to_projeto_horas(sd.projeto_id,t.entregar_em).minutos_restantes),a.prj_tarefa.minutos_restantes) 
                                       from kmm.v$tarefa t
                                      inner join kmm.v$sd sd 
                                              on sd.sd_id = t.sd_id
                                      where sd.projeto_id = a.projeto_id
                                        and t.entregar_em >= '#arguments.DATA#'),a.prj_tarefa.minutos_restantes),3).retorno as horas_restantes_real
                  ,a.prj_tarefa.minutos_restantes as minutos_restantes
                  ,a.prj_tarefa.horas_consumidas as horas_consumidas
                  ,a.prj_tarefa.horas_contratadas as horas_contratadas
                  ,a.prj_tarefa.minutos_contratados as minutos_contratados
                  ,a.prj_tarefa.horas_adicionais as horas_adicionais
                  ,a.prj_analise.horas_restantes as horas_restantes_analise_data
                  ,kss.to_tempo(nvl((select least(min(kmm.to_projeto_horas(sd.projeto_id,t.entregar_em).minutos_restantes),a.prj_analise.minutos_restantes) 
                                       from kmm.v$tarefa t
                                      inner join kmm.v$sd sd 
                                              on sd.sd_id = t.sd_id
                                      where sd.projeto_id = a.projeto_id
                                        and t.entregar_em >= '#arguments.DATA#'),a.prj_analise.minutos_restantes),3).retorno as horas_restantes_real_analise
                  ,a.prj_analise.minutos_restantes as minutos_restantes_analise
                  ,a.prj_analise.horas_consumidas as horas_consumidas_analise
                  ,a.prj_analise.horas_contratadas as horas_contratadas_analise
                  ,a.prj_analise.horas_adicionais as  horas_adicionais_analise
                  ,kss.to_tempo(a.prj_analise.minutos_analise,3).retorno as horas_analise
              from (select p.projeto_id, p.titulo, c.nome as cliente, cg.descricao as grupo
                          ,kmm.to_projeto_horas(p.projeto_id,nvl('#arguments.DATA#',sysdate)) as prj_tarefa
                          ,kmm.to_projeto_horas(p.projeto_id,nvl('#arguments.DATA#',sysdate),1) as prj_analise
                     from kmm.v$projeto p
                     inner join kmm.v$cliente c
                             on c.cliente_id = p.cliente_id
                     inner join kmm.v$cliente_grupo cg
                             on cg.grupo_id = c.grupo_id
                     where (p.data_fechamento is null or p.data_fechamento >= sysdate)
                       <cfif Len(Trim(arguments.GRUPO_ID))>
                         and cg.grupo_id = #arguments.GRUPO_ID#
                       </cfif>
                       <cfif Len(Trim(arguments.CLIENTE_ID))>
                         and c.cliente_id = #arguments.CLIENTE_ID#
                       </cfif>
                       ) a
                order by minutos_restantes
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>      


	<!--- 
	-- PROPSITO 
	-- Retorna situao das horas dos projetos
	-- CRISTOFER  06/08/2009
	--->		
	<cffunction name="get_recurso_meses_premio" access="remote" returntype="query" output="true">
        <cfargument name="recurso_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select to_char(add_months(greatest(max(t.data_pagamento),sysdate),1),'yyyy-mm') as ano_mes,
                   '0' as mes_ano,
                   InitCap(trim(to_char(add_months(greatest(max(t.data_pagamento),sysdate),1),'month')))||to_char(add_months(greatest(max(t.data_pagamento),sysdate),1),'/yyyy')||' (Pendente)' as mes_ano_desc,
                   to_char(add_months(greatest(max(t.data_pagamento),sysdate),1),'yyyy') as ano,
                   to_char(add_months(greatest(max(t.data_pagamento),sysdate),1),'mm') as mes
              from kmm.v$tarefa t
             where t.data_pagamento >= sysdate - 50
            union all        
            select distinct 
                   to_char(t.data_pagamento,'yyyy-mm') as ano_mes,
                   to_char(t.data_pagamento,'mm/yyyy') as mes_ano,
                   InitCap(trim(to_char(t.data_pagamento,'month')))||to_char(t.data_pagamento,'/yyyy') as mes_ano_desc,
                   to_char(t.data_pagamento,'yyyy') as ano,
                   to_char(t.data_pagamento,'mm') as mes
              from kmm.v$tarefa t
             where t.data_pagamento >= sysdate-365
             <cfif len(trim(arguments.recurso_id))>
               and exists (select 0
                             from kmm.v$tarefa_etapa te
                            where te.recurso_id = 244
                              and te.tarefa_id = t.tarefa_id)
             </cfif>
             order by ano_mes desc
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Retorna situao das horas dos projetos
	-- CRISTOFER  06/08/2009
	--->		
	<cffunction name="get_tarefas_extrato" access="remote" returntype="query" output="true">
        <cfargument name="recurso_id" required="no" default="">
        <cfargument name="mes_ano" required="no" default="">
        <cfargument name="exibir_corretivas" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.tarefa_id,
                   t.titulo,
                   to_char(t.entregar_em,'dd/mm/yyyy hh24:mi:ss') as entregar_em,
                   to_char(t.finalizada_em,'dd/mm/yyyy hh24:mi:ss') as finalizada_em,
                   kss.to_tempo(t.tempo_estimado,3).retorno as tempo_estimado,
                   (sysdate+t.tempo_estimado-sysdate)*24 as tempo_estimado_horas,
                   kss.to_tempo(t.horas_pagas,3).retorno as horas_pagas,
                   (sysdate+t.horas_pagas-sysdate)*24 as horas_pagas_horas,
                   kss.to_tempo(t.tempo_realizado,3).retorno as tempo_realizado,
                   to_char(t.data_pagamento,'dd/mm/yyyy hh24:mi:ss') as data_pagamento,
                   (select descricao
                      from kmm.v$cg_ref_codes 
                     where id = t.premio_situacao
                       and dominio = 'PREMIO SITUACAO') as premio_situacao,
                   t.valor_hora_premio,
                   sd.sd_id,
                   sd.codigo as cod_sd,
                   sd.titulo as titulo_sd,
                   sd.status_id as status_id_sd,
                   (select descricao
                      from kmm.v$cg_ref_codes 
                     where id = sd.status_id
                       and dominio = 'SD STATUS') as status_sd,

                   (select count(distinct ta.entrega_em)
                      from kmm.v$tarefa_atraso ta
                     where ta.tarefa_id = t.tarefa_id
		            <cfif len(trim(arguments.recurso_id))>
                       and ta.recurso_id = #arguments.recurso_id#
                    </cfif>
                       and ta.data_cancelamento is null
                       ) as nro_atrasos,
                   c.nome as cliente
                   
              from kmm.v$tarefa t
              left join kmm.v$sd sd
                on sd.sd_id = t.sd_id
              left join kmm.v$projeto p
                on p.projeto_id = sd.projeto_id
              left join kmm.v$cliente c
                on c.cliente_id = p.cliente_id
             where 1=1
               and t.premio_situacao <> 1
            <cfif arguments.mes_ano eq '0'>
               /* Liberados */
               and t.finalizada_em < trunc(sysdate,'month')
               and t.data_pagamento is null
               and sd.status_id = 7
            <cfelseif arguments.mes_ano eq '-1'>
               /* Pendentes */
               and nvl(t.finalizada_em,sysdate) >= trunc(sysdate,'month')
               and t.data_pagamento is null
            <cfelseif len(trim(arguments.mes_ano))>
               /* Mes */
               and to_char(t.data_pagamento,'mm/yyyy') = '#arguments.mes_ano#'
            <cfelse>
               and 1=0
            </cfif>
            <cfif len(trim(arguments.recurso_id))>
               and exists (select 0
                             from kmm.v$tarefa_etapa te
                            where te.tarefa_id = t.tarefa_id
                              and te.recurso_id = #arguments.recurso_id#)
            </cfif>
            <cfif arguments.exibir_corretivas eq 0>
               and t.tipo_id <> 1
            </cfif>
             order by t.finalizada_em
		</cfquery>
		<cfreturn qr_result>		
	</cffunction> 
    
    
     <!--- 
	-- PROPSITO 
	-- Retorna a data de termino baseada na data de incio somada aos dias de durao
	-- WAGNER  22/03/2011
	--->		
	<cffunction name="get_data_termino" access="remote" returntype="query" output="true">
        <cfargument name="data_inicio" required="yes">
        <cfargument name="duracao_dias" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select to_char(kmm.pkg_sd.fnc_calcula_data_termino('#data_inicio#',#duracao_dias# ),'dd/mm/yyyy') as data_termino
			  from dual
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>  
    
    <!--- 
	-- PROPSITO 
	-- Retorna a data de termino baseada na data de incio somada aos dias de durao
	-- WAGNER  22/03/2011
	--->		
	<cffunction name="get_sprint" access="remote" returntype="query" output="true">
        <cfargument name="sprint_id" required="no">

		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select sprint_id,
                   duracao_dias,
                   to_char(data_inicio,'dd/mm/yyyy') as data_inicio,
                   to_char(data_fim,'dd/mm/yyyy') as data_fim,
                   descricao,
                   date_insert,
                   user_insert,
                   date_update,
                   user_update,
                   site
              from kmm.v$sprint
		     where 1=1
             <cfif isDefined("arguments.sprint_id") and len(trim(arguments.sprint_id)) >
             	and sprint_id = #arguments.sprint_id#
             </cfif>
             <cfif isDefined("arguments.descricao") and len(trim(arguments.descricao)) >
             	and descricao like '%#arguments.descricao#%'
             </cfif>
             <cfif isDefined("arguments.data_inicio") and len(trim(arguments.data_inicio)) >
             	and data_inicio >= '#arguments.data_inicio#'
             </cfif>
             <cfif isDefined("arguments.data_fim") and len(trim(arguments.data_fim)) >
             	and data_fim <= '#arguments.data_fim#'
             </cfif>
             <cfif isDefined("arguments.nao_finalizado") and len(trim(arguments.nao_finalizado)) >
             	and data_fim >= sysdate
             </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>      
   
    
    
    <!--- 
	-- PROPSITO 
	-- Busca a localizacao
	-- MARIALICE  15/04/2010
	--->		
	<cffunction name="get_localizacao" access="remote" returntype="query" output="true">
    	<cfargument name="localizacao_id" required="no">
		<cfargument name="localizacao_pai_id" required="no">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select l.localizacao_id
                 , l.localizacao_pai_id
                 , l.descricao
                 , sys_connect_by_path(l.descricao, '->') as localizacao              
              from kmm.v$localizacao l
             where 1 = 1            
			  <cfif IsDefined("arguments.localizacao_id")>
			   and l.localizacao_id = #arguments.localizacao_id#
			  </cfif>
			  <cfif IsDefined("arguments.localizacao_pai_id")>
			   and l.localizacao_pai_id = #arguments.localizacao_pai_id#
			  </cfif> 
               <cfif IsDefined("arguments.descricao")>
               and upper(l.descricao) like upper('%#arguments.descricao#%')
			  </cfif> 
               start with l.localizacao_pai_id = 0
            connect by prior l.localizacao_id = l.localizacao_pai_id
            order siblings by l.descricao
		</cfquery>
             
		<cfreturn qr_result>		
	</cffunction>
 
    
    <!--- 
	-- PROPSITO 
	-- Busca as localizacoes para edicao da tarefa
	-- MARIALICE  19/04/2011
	--->		
	<cffunction name="get_tarefa_localizacao" access="remote" returntype="query" output="true">
    	<cfargument name="tarefa_id" required="no" default="-1">
    	<cfargument name="localizacao_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select l.localizacao_id
		         , l.localizacao_pai_id
                 , l.descricao
                 , sys_connect_by_path(l.descricao, '->') as localizacao  
                 , tl.tarefa_id                   
             from kmm.v$localizacao l
             left join kmm.v$tarefa_localizacao tl
                     on tl.localizacao_id = l.localizacao_id            
             where 1=1
             <cfif len(trim(arguments.tarefa_id))>
               and tl.tarefa_id = #arguments.tarefa_id#        
            </cfif>
            <cfif len(trim(arguments.localizacao_id))>
               and l.localizacao_id = #arguments.localizacao_id#        
            </cfif>
             start with l.localizacao_pai_id = 0
            connect by prior l.localizacao_id = l.localizacao_pai_id
            order siblings by l.descricao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    
    <!--- 
	-- PROPSITO 
	-- Busca as agendas da reuniao
	-- MARIALICE  25/05/2011
	--->		
	<cffunction name="get_reuniao_agenda" access="remote" returntype="query" output="true">
		<cfargument name="reuniao_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ra.agenda_id,
				   ra.reuniao_id,
				   ra.descricao,
                   to_char(ra.data_inicio, 'dd/mm/yyyy hh24:mi') as data_inicio,
                   to_char(ra.data_termino, 'dd/mm/yyyy hh24:mi') as data_termino
			  from kmm.v$reuniao_agenda ra
		 where ra.reuniao_id = #arguments.reuniao_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    
    <!--- 
	-- PROPSITO 
	-- Busca as obrigacoes da reuniao
	-- MARIALICE  25/05/2011
	--->		
	<cffunction name="get_reuniao_obrigacao" access="remote" returntype="query" output="true">
		<cfargument name="reuniao_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ro.obrigacao_id,
				   ro.reuniao_id,
				   ro.recurso_id,
				   ro.descricao,
                   r.cliente,                   
                   r.cliente_id,
				   r.nome_completo as recurso,
				   r.descricao,
				   r.email,				   
				   ro.date_insert,
				   ro.user_insert,
				   ro.date_update,
				   ro.user_update,
				   ro.site,                  
                   c.nome as cliente_nome
			  from kmm.v$reuniao_obrigacao ro
			 inner join kmm.v$recurso r
			         on r.recurso_id = ro.recurso_id            
             inner join kmm.v$cliente c 
             		 on c.cliente_id = r.cliente_id
			 where reuniao_id = #arguments.reuniao_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os recursos que participam de ao menos uma reunio
	-- MARIALICE  27/05/2011
	--->		
	<cffunction name="get_reuniao_participante_filtro" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select r.recurso_id
                 , r.nome_completo
                 , r.cliente
                 , r.cliente_id
              from kmm.v$recurso r
             where exists (select 1
                             from kmm.v$reuniao_participante rp
                            where rp.recurso_id = r.recurso_id
                          )
             order by r.cliente, r.nome_completo
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
		
</cfcomponent>